/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-gmp {\n"
	"  yang-version \"1.1\";\n"
	"  namespace \"http://frrouting.org/yang/gmp\";\n"
	"\n"
	"  prefix frr-gmp;\n"
	"\n"
	"  import frr-routing {\n"
	"    prefix \"frr-rt\";\n"
	"  }\n"
	"\n"
	"  import ietf-routing-types {\n"
	"    prefix \"rt-types\";\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix \"inet\";\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  import frr-route-map {\n"
	"    prefix frr-route-map;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"\n"
	"  contact\n"
	"    \"FRR Users List:       <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"\n"
	"  description\n"
	"    \"This module defines a model for managing FRR pimd daemon.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2021-11-22 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference\n"
	"      \"RFC 2236: IGMP v2.\n"
	"       RFC 3376: IGMP v3.\n"
	"       RFC 2710: MLD.\n"
	"       RFC 3810: MLD v2.\";\n"
	"  }\n"
	"\n"
	"  grouping interface-config-attributes {\n"
	"    description\n"
	"      \"Configuration IGMP/MLD attributes applied to the interface level.\";\n"
	"\n"
	"    leaf enable {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable IGMP/MLD flag on the interface.\";\n"
	"    }\n"
	"\n"
	"    leaf igmp-version {\n"
	"      when \"../frr-gmp:address-family = \'frr-rt:ipv4\'\" {\n"
	"        description\n"
	"          \"Only applicable to IPv4 address family.\";\n"
	"      }\n"
	"      type uint8 {\n"
	"        range \"2..3\";\n"
	"      }\n"
	"      description\n"
	"        \"IGMP version.\";\n"
	"    }\n"
	"\n"
	"    leaf mld-version {\n"
	"      when \"../frr-gmp:address-family = \'frr-rt:ipv6\'\" {\n"
	"        description\n"
	"          \"Only applicable to IPv6 address family.\";\n"
	"      }\n"
	"      type uint8 {\n"
	"        range \"1..2\";\n"
	"      }\n"
	"      default \"2\";\n"
	"      description\n"
	"        \"MLD version.\";\n"
	"    }\n"
	"\n"
	"    leaf query-interval {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units seconds;\n"
	"      must \". * 10 > ../query-max-response-time\";\n"
	"      default \"125\";\n"
	"      description\n"
	"        \"The Query Interval is the interval between General Queries\n"
	"         sent by the Querier.\";\n"
	"    }\n"
	"\n"
	"    leaf query-max-response-time {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units deciseconds;\n"
	"      must \". <= ../query-interval * 10\";\n"
	"      default \"100\";\n"
	"      description\n"
	"        \"Query maximum response time specifies the maximum time\n"
	"         allowed before sending a responding report.\";\n"
	"    }\n"
	"\n"
	"    leaf last-member-query-interval {\n"
	"      type uint16 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      units deciseconds;\n"
	"      default \"10\";\n"
	"      description\n"
	"        \"Last Member Query Interval, which may be tuned to modify\n"
	"         the leave latency of the network.\";\n"
	"    }\n"
	"\n"
	"    leaf robustness-variable {\n"
	"      type uint8 {\n"
	"        range \"1..max\";\n"
	"      }\n"
	"      default \"2\";\n"
	"      description\n"
	"        \"Querier\'s Robustness Variable allows tuning for the\n"
	"         expected packet loss on a network.\";\n"
	"    }\n"
	"    \n"
	"    leaf proxy {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Enable IGMP proxy on the interface.\";\n"
	"    }\n"
	"\n"
	"    leaf max-groups {\n"
	"      type uint32;\n"
	"      default \"4294967295\";\n"
	"      description\n"
	"        \"Limit number of tracked IGMP group memberships on this interface.\";\n"
	"    }\n"
	"\n"
	"    leaf max-sources {\n"
	"      type uint32;\n"
	"      default \"4294967295\";\n"
	"      description\n"
	"        \"Limit number of tracked IGMPv3 sources on this interface.\";\n"
	"    }\n"
	"\n"
	"    list join-group {\n"
	"      key \"group-addr source-addr\";\n"
	"      description\n"
	"        \"A static GMP join, (*,G) or (S,G).\n"
	"         The version of IGMP must be 3 to support (S,G).\";\n"
	"\n"
	"      leaf group-addr {\n"
	"        type rt-types:ip-multicast-group-address;\n"
	"        description\n"
	"          \"Multicast group address.\";\n"
	"      }\n"
	"      leaf source-addr {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"Multicast source address.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf immediate-leave {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Immediately drop group memberships on receiving IGMPv2/MLDv1 Leave.\n"
	"         Has no effect when IGMPv3/MLDv2 is in use.\";\n"
	"    }\n"
	"\n"
	"    leaf require-router-alert {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Only process IGMP packets with IP Router Alert option set.\";\n"
	"    }\n"
	"\n"
	"    leaf route-map {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Filter multicast with referenced route-map.\";\n"
	"    }\n"
	"\n"
	"    list static-group {\n"
	"      key \"group-addr source-addr\";\n"
	"      description\n"
	"        \"A static multicast group without GMP, (*,G) or (S,G).\";\n"
	"\n"
	"      leaf group-addr {\n"
	"        type rt-types:ip-multicast-group-address;\n"
	"        description\n"
	"          \"Multicast group address.\";\n"
	"      }\n"
	"      leaf source-addr {\n"
	"        type inet:ip-address;\n"
	"        description\n"
	"          \"Multicast source address.\";\n"
	"      }\n"
	"    }\n"
	"  } // interface-config-attributes\n"
	"\n"
	"  /*\n"
	"   * Per-interface configuration data\n"
	"   */\n"
	"  augment \"/frr-interface:lib/frr-interface:interface\" {\n"
	"    container gmp {\n"
	"      list address-family {\n"
	"        key \"address-family\";\n"
	"        description\n"
	"          \"Each list entry for one address family.\";\n"
	"        uses frr-rt:address-family;\n"
	"        uses interface-config-attributes;\n"
	"      } //address-family\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-gmp",
	.mod_rev = "2021-11-22",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
