/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-bgp {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/bgp\";\n"
	"  prefix frr-bgp;\n"
	"\n"
	"  import frr-routing {\n"
	"    prefix frr-rt;\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  import frr-bgp-types {\n"
	"    prefix frr-bt;\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-route-types;\n"
	"  }\n"
	"\n"
	"  include \"frr-bgp-common\";\n"
	"\n"
	"  include \"frr-bgp-common-structure\";\n"
	"\n"
	"  include \"frr-bgp-common-multiprotocol\";\n"
	"\n"
	"  include \"frr-bgp-neighbor\";\n"
	"\n"
	"  include \"frr-bgp-peer-group\";\n"
	"\n"
	"  include \"frr-bgp-bmp\";\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List: <mailto:frog@lists.frrouting.org> FRR Development\n"
	"     List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines a model for managing FRR bgpd daemon.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2019-12-03 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"  }\n"
	"\n"
	"  identity bgp {\n"
	"    base frr-rt:routing-protocol;\n"
	"    description\n"
	"      \"BGP protocol.\";\n"
	"  }\n"
	"\n"
	"  grouping mp-afi-unicast-common {\n"
	"    uses global-group-use-multiple-paths;\n"
	"\n"
	"    uses global-redistribute;\n"
	"\n"
	"    uses admin-distance;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol\" {\n"
	"    container bgp {\n"
	"      when \"../frr-rt:type = \'frr-bgp:bgp\'\" {\n"
	"        description\n"
	"          \"BGP protocol augmentation of ietf-routing module\n"
	"           control-plane-protocol.\";\n"
	"      }\n"
	"      presence \"Enables configuration of BGP\";\n"
	"      description\n"
	"        \"Top-level configuration for the BGP router.\";\n"
	"      container global {\n"
	"        description\n"
	"          \"Global configuration for the BGP router.\";\n"
	"        leaf local-as {\n"
	"          type inet:as-number;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Local autonomous system number of the router.  Uses\n"
	"             the 32-bit as-number type from the model in RFC 6991.\";\n"
	"        }\n"
	"\n"
	"        uses frr-rt:router-id;\n"
	"\n"
	"        container confederation {\n"
	"          description\n"
	"            \"Configuration options specifying parameters when the\n"
	"             local router is within an autonomous system which is\n"
	"             part of a BGP confederation.\";\n"
	"          leaf identifier {\n"
	"            type inet:as-number;\n"
	"            description\n"
	"              \"Confederation identifier for the autonomous system.\";\n"
	"          }\n"
	"\n"
	"          leaf-list member-as {\n"
	"            type inet:as-number;\n"
	"            description\n"
	"              \"Remote autonomous systems that are to be treated\n"
	"               as part of the local confederation.\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        uses med-config;\n"
	"\n"
	"        uses route-reflector-config;\n"
	"\n"
	"        uses route-selection-options;\n"
	"\n"
	"        uses global-neighbor-config;\n"
	"\n"
	"        container graceful-restart {\n"
	"          description\n"
	"            \"Parameters relating the graceful restart mechanism for\n"
	"             BGP.\";\n"
	"          uses graceful-restart-config;\n"
	"        }\n"
	"\n"
	"        uses global-update-group-config;\n"
	"\n"
	"        uses global-config-timers;\n"
	"\n"
	"        uses global-bgp-config;\n"
	"\n"
	"        uses global-network-config;\n"
	"\n"
	"        uses global-graceful-shutdown;\n"
	"\n"
	"        uses global-bmp-config;\n"
	"\n"
	"        container afi-safis {\n"
	"          description\n"
	"            \"List of address-families associated with the BGP\n"
	"             instance.\";\n"
	"          list afi-safi {\n"
	"            key \"afi-safi-name\";\n"
	"            description\n"
	"              \"AFI, SAFI configuration available for the\n"
	"               neighbour or group.\";\n"
	"            uses mp-afi-safi-config;\n"
	"\n"
	"            uses mp-all-afi-safi-list-contents;\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container neighbors {\n"
	"        description\n"
	"          \"Configuration for BGP neighbors.\";\n"
	"        list neighbor {\n"
	"          key \"remote-address\";\n"
	"          description\n"
	"            \"List of BGP neighbors configured on the local system,\n"
	"             uniquely identified by remote IPv[46] address.\";\n"
	"          leaf remote-address {\n"
	"            type inet:ip-address;\n"
	"            description\n"
	"              \"The remote IP address of this entry\'s BGP peer.\";\n"
	"          }\n"
	"\n"
	"          leaf local-interface {\n"
	"            type frr-interface:interface-ref {\n"
	"              require-instance false;\n"
	"            }\n"
	"            description\n"
	"              \"Neighbor\'s interface name.\";\n"
	"          }\n"
	"\n"
	"          leaf local-port {\n"
	"            type inet:port-number {\n"
	"              range \"0..65535\";\n"
	"            }\n"
	"            description\n"
	"              \"Neighbor\'s BGP TCP port number.\";\n"
	"          }\n"
	"\n"
	"          leaf peer-group {\n"
	"            type leafref {\n"
	"              path \"../../../peer-groups/peer-group/peer-group-name\";\n"
	"            }\n"
	"            description\n"
	"              \"The peer-group with which this neighbor is associated.\";\n"
	"          }\n"
	"\n"
	"          container neighbor-remote-as {\n"
	"            leaf remote-as-type {\n"
	"              type frr-bt:as-type;\n"
	"              mandatory true;\n"
	"              description\n"
	"                \"Remote AS type.\";\n"
	"            }\n"
	"\n"
	"            leaf remote-as {\n"
	"              when \"../remote-as-type = \'as-specified\'\";\n"
	"              type inet:as-number;\n"
	"              description\n"
	"                \"The remote autonomous system number received in\n"
	"                 the BGP OPEN message.\";\n"
	"              reference\n"
	"                \"RFC 4271\";\n"
	"            }\n"
	"          }\n"
	"\n"
	"          uses neighbor-parameters;\n"
	"\n"
	"          uses structure-neighbor-group-capability-options;\n"
	"        }\n"
	"\n"
	"        list unnumbered-neighbor {\n"
	"          key \"interface\";\n"
	"          description\n"
	"            \"List of BGP neighbors configured on the local system,\n"
	"             uniquely identified by interfaces.\";\n"
	"          leaf interface {\n"
	"            type frr-interface:interface-ref {\n"
	"              require-instance false;\n"
	"            }\n"
	"            description\n"
	"              \"The local interface of this entry\'s BGP peer.\";\n"
	"          }\n"
	"\n"
	"          leaf v6only {\n"
	"            type boolean;\n"
	"            default \"false\";\n"
	"            description\n"
	"              \"When set to \'true\' it will create a neighbor with v6\n"
	"               link local only.\";\n"
	"          }\n"
	"\n"
	"          leaf peer-group {\n"
	"            type leafref {\n"
	"              path \"../../../peer-groups/peer-group/peer-group-name\";\n"
	"            }\n"
	"            description\n"
	"              \"The peer-group with which this neighbor is associated.\";\n"
	"          }\n"
	"\n"
	"          uses neighbor-remote-as;\n"
	"\n"
	"          uses neighbor-parameters;\n"
	"\n"
	"          uses structure-neighbor-group-capability-options {\n"
	"            refine \"frr-bgp:capability-options/extended-nexthop-capability\" {\n"
	"              default \"true\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container peer-groups {\n"
	"        description\n"
	"          \"Configuration for BGP peer-groups.\";\n"
	"        uses bgp-peer-group-list;\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv4-unicast\" {\n"
	"    list network-config {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of network routes.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv4-prefix;\n"
	"        description\n"
	"          \"IPv4 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      leaf backdoor {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Specify a BGP backdoor route.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-network-config;\n"
	"    }\n"
	"\n"
	"    list aggregate-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of aggregated routes.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv4-prefix;\n"
	"        description\n"
	"          \"IPv4 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-agg-route-config;\n"
	"    }\n"
	"\n"
	"    list admin-distance-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of routes with a particular admin distance.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv4-prefix;\n"
	"        description\n"
	"          \"IPv4 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses distance-per-route-config;\n"
	"    }\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"\n"
	"    uses mp-afi-unicast-common;\n"
	"\n"
	"    uses global-filter-config;\n"
	"\n"
	"    uses global-afi-safi-vpn-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv6-unicast\" {\n"
	"    list network-config {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of network routes.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv6-prefix;\n"
	"        description\n"
	"          \"IPv6 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      leaf backdoor {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Specify a BGP backdoor route.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-network-config;\n"
	"    }\n"
	"\n"
	"    list aggregate-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of aggregated routes.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv6-prefix;\n"
	"        description\n"
	"          \"IPv6 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-agg-route-config;\n"
	"    }\n"
	"\n"
	"    list admin-distance-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of routes with a particular admin distance.\";\n"
	"      leaf prefix {\n"
	"        type inet:ipv6-prefix;\n"
	"        description\n"
	"          \"IPv6 destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses distance-per-route-config;\n"
	"    }\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"\n"
	"    uses mp-afi-unicast-common;\n"
	"\n"
	"    uses global-filter-config;\n"
	"\n"
	"    uses global-afi-safi-vpn-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv4-labeled-unicast\" {\n"
	"    uses global-group-use-multiple-paths;\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv6-labeled-unicast\" {\n"
	"    uses global-group-use-multiple-paths;\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv4-multicast\" {\n"
	"    list network-config {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of network routes.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv4-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv4 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      leaf backdoor {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Specify a BGP backdoor route.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-network-config;\n"
	"    }\n"
	"\n"
	"    list aggregate-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of aggregated routes.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv4-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv4 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-agg-route-config;\n"
	"    }\n"
	"\n"
	"    list admin-distance-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of routes with a particular admin distance.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv4-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv4 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses distance-per-route-config;\n"
	"    }\n"
	"\n"
	"    uses admin-distance;\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"\n"
	"    uses global-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv6-multicast\" {\n"
	"    list network-config {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of network routes.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv6-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv6 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      leaf backdoor {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Specify a BGP backdoor route.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-network-config;\n"
	"    }\n"
	"\n"
	"    list aggregate-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of aggregated routes.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv6-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv6 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses mp-afi-safi-agg-route-config;\n"
	"    }\n"
	"\n"
	"    list admin-distance-route {\n"
	"      key \"prefix\";\n"
	"      description\n"
	"        \"A list of routes with a particular admin distance.\";\n"
	"      leaf prefix {\n"
	"        type frr-route-types:ipv6-multicast-group-prefix;\n"
	"        description\n"
	"          \"IPv6 multicast destination prefix.\";\n"
	"      }\n"
	"\n"
	"      uses distance-per-route-config;\n"
	"    }\n"
	"\n"
	"    uses route-flap-dampening;\n"
	"\n"
	"    uses admin-distance;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/ipv4-flowspec\" {\n"
	"    uses flow-spec-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-unicast\" {\n"
	"    uses global-afi-safi-vpn-network-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-unicast\" {\n"
	"    uses global-afi-safi-vpn-network-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/bmp-config/target-list/afi-safis/afi-safi/ipv4-unicast\" {\n"
	"    uses bmp-afi-safi-common-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/bmp-config/target-list/afi-safis/afi-safi/ipv4-multicast\" {\n"
	"    uses bmp-afi-safi-common-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/bmp-config/target-list/afi-safis/afi-safi/ipv6-unicast\" {\n"
	"    uses bmp-afi-safi-common-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/global/bmp-config/target-list/afi-safis/afi-safi/ipv6-multicast\" {\n"
	"    uses bmp-afi-safi-common-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast\" {\n"
	"    leaf nexthop-local-unchanged {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Configure treatment of outgoing link-local nexthop attribute.\n"
	"         When set to \'true\' it leaves link-local nexthop unchanged\n"
	"         for this peer.\";\n"
	"    }\n"
	"\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"   }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-evpn\" {\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv6-unicast\" {\n"
	"    leaf nexthop-local-unchanged {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Configure treatment of outgoing link-local nexthop attribute.\n"
	"         When set to \'true\' it leaves link-local nexthop unchanged\n"
	"         for this peer.\";\n"
	"    }\n"
	"\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv4-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv6-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv4-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv6-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/l2vpn-evpn\" {\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv4-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/neighbors/unnumbered-neighbor/afi-safis/afi-safi/ipv6-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast\" {\n"
	"    leaf nexthop-local-unchanged {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Configure treatment of outgoing link-local nexthop attribute.\n"
	"         When set to \'true\' it leaves link-local nexthop unchanged\n"
	"         for this peer.\";\n"
	"    }\n"
	"\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-multicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-labeled-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-default-originate-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-group-orf-capability;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-unicast\" {\n"
	"    uses structure-neighbor-group-add-paths;\n"
	"\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-prefix-limit;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-private-as;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-send-community;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-weight;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-evpn\" {\n"
	"    uses structure-neighbor-group-as-path-options;\n"
	"\n"
	"    uses structure-neighbor-group-attr-unchanged;\n"
	"\n"
	"    uses structure-neighbor-nexthop-self;\n"
	"\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"\n"
	"  augment \"/frr-rt:routing/frr-rt:control-plane-protocols/frr-rt:control-plane-protocol/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-flowspec\" {\n"
	"    uses structure-neighbor-route-reflector;\n"
	"\n"
	"    uses structure-neighbor-route-server;\n"
	"\n"
	"    uses structure-neighbor-group-soft-reconfiguration;\n"
	"\n"
	"    uses structure-neighbor-group-filter-config;\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-bgp",
	.mod_rev = "2019-12-03",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
