/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"module frr-bgp-rpki {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/frr-bgp-rpki\";\n"
	"  prefix frr-bgp-rpki;\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-vrf {\n"
	"    prefix frr-vrf;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List: <mailto:frog@lists.frrouting.org> FRR Development\n"
	"     List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines a model for managing FRR BGP RPKI.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2019-12-03 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"  }\n"
	"\n"
	"  typedef transport-type {\n"
	"    type enumeration {\n"
	"      enum \"TCP\" {\n"
	"        value 1;\n"
	"        description\n"
	"          \"Connection to server is TCP based.\";\n"
	"      }\n"
	"      enum \"SSH\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Connection to server is SSH based.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping bgp-rpki-timers {\n"
	"    container rpki-timers {\n"
	"      description\n"
	"        \"RPKI timers config.\";\n"
	"      leaf polling-time {\n"
	"        type uint32 {\n"
	"          range \"1..86400\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"3600\";\n"
	"        description\n"
	"          \"Set the number of seconds the router waits until the\n"
	"           router asks the cache again for updated data.\";\n"
	"      }\n"
	"\n"
	"      leaf expire-time {\n"
	"        type uint32 {\n"
	"          range \"600..172800\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"7200\";\n"
	"        description\n"
	"          \"Set the expire interval.\";\n"
	"      }\n"
	"\n"
	"      leaf retry-time {\n"
	"        type uint16 {\n"
	"          range \"1..7200\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"600\";\n"
	"        description\n"
	"          \"Set the retry interval.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping bgp-rpki-cache-server {\n"
	"    container rpki-cache-server {\n"
	"      description\n"
	"        \"Add a cache server to the socket.\";\n"
	"      list cache-list {\n"
	"        key \"preference\";\n"
	"        leaf preference {\n"
	"          type uint8 {\n"
	"            range \"1..255\";\n"
	"          }\n"
	"          description\n"
	"            \"Preference of the cache server.\";\n"
	"        }\n"
	"\n"
	"        leaf cache-type {\n"
	"          type transport-type;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Specifies a transport method for the RPKI cache.\";\n"
	"        }\n"
	"\n"
	"        choice server {\n"
	"          case ip-address {\n"
	"            leaf ip-address {\n"
	"              type inet:ip-address;\n"
	"              mandatory true;\n"
	"            }\n"
	"          }\n"
	"\n"
	"          case host-name {\n"
	"            leaf ip-host-address {\n"
	"              type inet:host;\n"
	"              mandatory true;\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"\n"
	"        container transport {\n"
	"          container tcp {\n"
	"            when \"../../cache-type = \'TCP\'\";\n"
	"            description\n"
	"              \"TCP server details.\";\n"
	"            leaf tcp-port {\n"
	"              type uint32;\n"
	"            }\n"
	"          }\n"
	"\n"
	"          container ssh {\n"
	"            when \"../../cache-type = \'SSH\'\";\n"
	"            description\n"
	"              \"SSH login details\";\n"
	"            leaf ssh-port {\n"
	"              type uint32 {\n"
	"                range \"1..65535\";\n"
	"              }\n"
	"              description\n"
	"                \"SSH port on which session gets opened.\";\n"
	"            }\n"
	"\n"
	"            leaf user-name {\n"
	"              type string;\n"
	"              description\n"
	"                \"SSH username to establish an SSH connection to the\n"
	"                 cache server.\";\n"
	"            }\n"
	"\n"
	"            leaf private-key {\n"
	"              type string;\n"
	"              description\n"
	"                \"Local path that includes the private key file of the router.\";\n"
	"            }\n"
	"\n"
	"            leaf public-key {\n"
	"              type string;\n"
	"              description\n"
	"                \"Local path that includes the public key file of the router.\";\n"
	"            }\n"
	"\n"
	"            leaf server-public-ley {\n"
	"              type string;\n"
	"              description\n"
	"                \"Server public key.\";\n"
	"            }\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-vrf:lib/frr-vrf:vrf\" {\n"
	"    container bgp-rpki {\n"
	"      description\n"
	"        \"RPKI configuration parameters.\";\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"When set to \'true\' it enables the RPKI.\";\n"
	"      }\n"
	"\n"
	"      uses bgp-rpki-timers;\n"
	"\n"
	"      uses bgp-rpki-cache-server;\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-bgp-rpki",
	.mod_rev = "2019-12-03",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
