/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"module frr-bgp-route-map {\n"
	"  yang-version 1.1;\n"
	"  namespace \"http://frrouting.org/yang/bgp-route-map\";\n"
	"  prefix frr-bgp-route-map;\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-route-map {\n"
	"    prefix frr-route-map;\n"
	"  }\n"
	"\n"
	"  import frr-filter {\n"
	"    prefix filter;\n"
	"  }\n"
	"\n"
	"  import frr-bgp-filter {\n"
	"    prefix bgp-filter;\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-route-types;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"Free Range Routing\";\n"
	"  contact\n"
	"    \"FRR Users List:       <mailto:frog@lists.frrouting.org>\n"
	"     FRR Development List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This module defines bgp route map settings\";\n"
	"\n"
	"  revision 2020-01-02 {\n"
	"    description\n"
	"      \"Initial revision\";\n"
	"    reference \"FRRouting\";\n"
	"  }\n"
	"\n"
	"  identity match-alias {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP community alias name\";\n"
	"  }\n"
	"\n"
	"  identity match-local-preference {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match local-preference of routes\";\n"
	"  }\n"
	"\n"
	"  identity match-script {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match script of routes\";\n"
	"  }\n"
	"\n"
	"  identity match-origin {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP route origin code\";\n"
	"  }\n"
	"\n"
	"  identity rpki {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Control rpki specific settings\";\n"
	"  }\n"
	"\n"
	"  identity rpki-extcommunity {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Control rpki specific settings derived from extended community\";\n"
	"  }\n"
	"\n"
	"  identity probability {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match portion of routes defined by percentage value\";\n"
	"  }\n"
	"\n"
	"  identity source-vrf {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match source vrf of routes\";\n"
	"  }\n"
	"\n"
	"  identity peer {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match peer address\";\n"
	"  }\n"
	"\n"
	"  identity src-peer {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match source peer address\";\n"
	"  }\n"
	"\n"
	"  identity mac-address-list {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match MAC address access-list\";\n"
	"  }\n"
	"\n"
	"  identity ip-route-source {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match advertising source address of route\";\n"
	"  }\n"
	"\n"
	"  identity ip-route-source-prefix-list {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match advertising source address of route\";\n"
	"  }\n"
	"\n"
	"  identity evpn-route-type {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match EVPN route type\";\n"
	"  }\n"
	"\n"
	"  identity evpn-default-route {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match EVPN default Type-5 route\";\n"
	"  }\n"
	"\n"
	"  identity evpn-vni {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match EVPN VNI\";\n"
	"  }\n"
	"\n"
	"  identity evpn-rd {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match EVPN route distinguisher\";\n"
	"  }\n"
	"\n"
	"  identity match-community {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP community list\";\n"
	"  }\n"
	"\n"
	"  identity match-community-limit {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP community limit count\";\n"
	"  }\n"
	"\n"
	"  identity match-large-community {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP large-community list\";\n"
	"  }\n"
	"\n"
	"  identity match-extcommunity {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP extcommunity list\";\n"
	"  }\n"
	"\n"
	"  identity match-extcommunity-limit {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP extcommunity limit count\";\n"
	"  }\n"
	"\n"
	"  identity as-path-list {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match BGP AS path list\";\n"
	"  }\n"
	"\n"
	"  identity ipv4-nexthop {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match IPv4 next hop address\";\n"
	"  }\n"
	"\n"
	"  identity ipv6-nexthop {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match IPv6 next hop address\";\n"
	"  }\n"
	"\n"
	"  identity source-protocol {\n"
	"    base frr-route-map:rmap-match-type;\n"
	"    description\n"
	"      \"Match protocol via which the route was learnt\";\n"
	"  }\n"
	"\n"
	"  identity distance {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP administrative distance to use\";\n"
	"  }\n"
	"\n"
	"  identity set-extcommunity-none {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-extcommunity-rt {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-extcommunity-nt {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-extcommunity-soo {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-extcommunity-lb {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"identity set-extcommunity-color {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-ipv4-nexthop {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the IPv4 next-hop to peer-address/unchanged\";\n"
	"  }\n"
	"\n"
	"  identity ipv4-vpn-address {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set IPv4 VPN next-hop address\";\n"
	"  }\n"
	"\n"
	"  identity ipv6-nexthop-global {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set IPv6 next-hop global address\";\n"
	"  }\n"
	"\n"
	"  identity ipv6-prefer-global {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set IPv6 next-hop to prefer global address\";\n"
	"  }\n"
	"\n"
	"  identity ipv6-peer-address {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set IPv6 next-hop peer address\";\n"
	"  }\n"
	"\n"
	"  identity ipv6-vpn-address {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set IPv6 VPN next-hop address\";\n"
	"  }\n"
	"\n"
	"  identity label-index {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the label index to associate with the prefixs\";\n"
	"  }\n"
	"\n"
	"  identity set-local-preference {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP local preference path attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-origin {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP route origin code\";\n"
	"  }\n"
	"\n"
	"  identity weight {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP weight attribute\";\n"
	"  }\n"
	"\n"
	"  identity originator-id {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP originator ID attribute\";\n"
	"  }\n"
	"\n"
	"  identity table {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Export route to non-main kernel table\";\n"
	"  }\n"
	"\n"
	"  identity atomic-aggregate {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP atomic-aggregate attribute\";\n"
	"  }\n"
	"\n"
	"  identity aigp-metric {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP AIGP attribute (AIGP TLV Metric)\";\n"
	"  }\n"
	"\n"
	"  identity as-path-prepend {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP AS-path attribute\";\n"
	"  }\n"
	"\n"
	"  identity as-path-exclude {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP AS-path attribute\";\n"
	"  }\n"
	"\n"
	"  identity as-path-replace {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Replace ASNs to local AS number\";\n"
	"  }\n"
	"\n"
	"  identity set-community {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP community attribute\";\n"
	"  }\n"
	"\n"
	"  identity set-large-community {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP large-community attribute\";\n"
	"  }\n"
	"\n"
	"  identity aggregator {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set the BGP aggregator attribute\";\n"
	"  }\n"
	"\n"
	"  identity comm-list-delete {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP community list (for deletion)\";\n"
	"  }\n"
	"\n"
	"  identity large-comm-list-delete {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP large community list (for deletion)\";\n"
	"  }\n"
	"\n"
	"  identity extended-comm-list-delete {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set BGP extended community list (for deletion)\";\n"
	"  }\n"
	"\n"
	"  identity set-evpn-gateway-ip-ipv4 {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set EVPN gateway IP overlay index IPv4\";\n"
	"  }\n"
	"\n"
	"  identity set-evpn-gateway-ip-ipv6 {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Set EVPN gateway IP overlay index IPv6\";\n"
	"  }\n"
	"\n"
	"  identity set-l3vpn-nexthop-encapsulation {\n"
	"    base frr-route-map:rmap-set-type;\n"
	"    description\n"
	"      \"Accept L3VPN traffic over other than LSP encapsulation\";\n"
	"  }\n"
	"\n"
	"  grouping extcommunity-non-transitive-types {\n"
	"    description\n"
	"      \"Defines a grouping for non-transitive extended community types\";\n"
	"\n"
	"    leaf two-octet-as-specific {\n"
	"      type boolean;\n"
	"      default false;\n"
	"      description\n"
	"        \"Non-Transitive Two-Octet AS-Specific Extended Community\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  typedef route-distinguisher {\n"
	"    type string {\n"
	"      pattern\n"
	"        \'(0:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0):(429496729[0-5]|\'\n"
	"      +     \'42949672[0-8][0-9]|\'\n"
	"      +     \'4294967[01][0-9]{2}|429496[0-6][0-9]{3}|\'\n"
	"      +     \'42949[0-5][0-9]{4}|\'\n"
	"      +     \'4294[0-8][0-9]{5}|429[0-3][0-9]{6}|\'\n"
	"      +     \'42[0-8][0-9]{7}|4[01][0-9]{8}|\'\n"
	"      +     \'[1-3][0-9]{9}|[1-9][0-9]{0,8}|0))|\'\n"
	"      + \'(1:((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|\'\n"
	"      +     \'25[0-5])\\.){3}([0-9]|[1-9][0-9]|\'\n"
	"      +     \'1[0-9]{2}|2[0-4][0-9]|25[0-5])):(6553[0-5]|\'\n"
	"      +     \'655[0-2][0-9]|\'\n"
	"      +     \'65[0-4][0-9]{2}|6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0))|\'\n"
	"      + \'(2:(429496729[0-5]|42949672[0-8][0-9]|\'\n"
	"      +     \'4294967[01][0-9]{2}|\'\n"
	"      +     \'429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|\'\n"
	"      +     \'4294[0-8][0-9]{5}|\'\n"
	"      +     \'429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[01][0-9]{8}|\'\n"
	"      +     \'[1-3][0-9]{9}|[1-9][0-9]{0,8}|0):\'\n"
	"      +     \'(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0))|\'\n"
	"      + \'(6(:[a-fA-F0-9]{2}){6})|\'\n"
	"      + \'(([3-57-9a-fA-F]|[1-9a-fA-F][0-9a-fA-F]{1,3}):\'\n"
	"      +     \'[0-9a-fA-F]{1,12})|\'\n"
	"      +  \'((6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0):(429496729[0-5]|\'\n"
	"      +     \'42949672[0-8][0-9]|\'\n"
	"      +     \'4294967[01][0-9]{2}|429496[0-6][0-9]{3}|\'\n"
	"      +     \'42949[0-5][0-9]{4}|\'\n"
	"      +     \'4294[0-8][0-9]{5}|429[0-3][0-9]{6}|\'\n"
	"      +     \'42[0-8][0-9]{7}|4[01][0-9]{8}|\'\n"
	"      +     \'[1-3][0-9]{9}|[1-9][0-9]{0,8}|0)|\'\n"
	"      +  \'((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|\'\n"
	"      +     \'25[0-5])\\.){3}([0-9]|[1-9][0-9]|\'\n"
	"      +     \'1[0-9]{2}|2[0-4][0-9]|25[0-5])):(6553[0-5]|\'\n"
	"      +     \'655[0-2][0-9]|\'\n"
	"      +     \'65[0-4][0-9]{2}|6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0))|\'\n"
	"      + \'((429496729[0-5]|42949672[0-8][0-9]|\'\n"
	"      +     \'4294967[01][0-9]{2}|\'\n"
	"      +     \'429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|\'\n"
	"      +     \'4294[0-8][0-9]{5}|\'\n"
	"      +     \'429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[01][0-9]{8}|\'\n"
	"      +     \'[1-3][0-9]{9}|[1-9][0-9]{0,8}|0):\'\n"
	"      +     \'(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0))|\'\n"
	"      +  \'((6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0).\'\n"
	"      +  \'(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|\'\n"
	"      +     \'6[0-4][0-9]{3}|\'\n"
	"      +     \'[1-5][0-9]{4}|[1-9][0-9]{0,3}|0):\'\n"
	"      +     \'(429496729[0-5]|42949672[0-8][0-9]|\'\n"
	"      +     \'4294967[01][0-9]{2}|\'\n"
	"      +     \'429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|\'\n"
	"      +     \'4294[0-8][0-9]{5}|\'\n"
	"      +     \'429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[01][0-9]{8}|\'\n"
	"      +     \'[1-3][0-9]{9}|[1-9][0-9]{0,8}|0))\';\n"
	"    }\n"
	"\n"
	"    description\n"
	"      \"A Route Distinguisher is an 8-octet value used to\n"
	"       distinguish routes from different BGP VPNs (RFC 4364).\n"
	"       A Route Distinguisher will have the same format as a\n"
	"       Route Target as per RFC 4360 and will consist of\n"
	"       two or three fields: a 2-octet Type field, an administrator\n"
	"       field, and, optionally, an assigned number field.\n"
	"       According to the data formats for types 0, 1, 2, and 6 as\n"
	"       defined in RFC 4360, RFC 5668, and RFC 7432, the encoding\n"
	"       pattern is defined as:\n"
	"       0:2-octet-asn:4-octet-number\n"
	"       1:4-octet-ipv4addr:2-octet-number\n"
	"       2:4-octet-asn:2-octet-number\n"
	"       6:6-octet-mac-address\n"
	"       Additionally, a generic pattern is defined for future\n"
	"       route discriminator types:\n"
	"       2-octet-other-hex-number:6-octet-hex-number\n"
	"       Some valid examples are 0:100:100, 1:1.1.1.1:100,\n"
	"       2:1234567890:203, and 6:26:00:08:92:78:00.\n"
	"       The following route distinguisher with two fields are also\n"
	"       accepted : 10000:44 1.2.3.4:44.\";\n"
	"    reference\n"
	"      \"RFC 4360: BGP Extended Communities Attribute.\n"
	"       RFC 4364: BGP/MPLS IP Virtual Private Networks (VPNs).\n"
	"       RFC 5668: 4-Octet AS Specific BGP Extended Community.\n"
	"       RFC 7432: BGP MPLS-Based Ethernet VPN.\";\n"
	"  }\n"
	"\n"
	"  typedef extcommunity-lb-type {\n"
	"    type enumeration {\n"
	"      enum \"explicit-bandwidth\" {\n"
	"        value 0;\n"
	"        description\n"
	"          \"Bandwidth value in Mbps\";\n"
	"      }\n"
	"      enum \"cumulative-bandwidth\" {\n"
	"        value 1;\n"
	"       description\n"
	"          \"Cumulative bandwidth of all multipaths (outbound-only)\";\n"
	"      }\n"
	"      enum \"computed-bandwidth\" {\n"
	"        value 2;\n"
	"        description\n"
	"          \"Internally computed bandwidth based on number of multipaths (outbound-only)\";\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"ext-community link bandwidth types.\";\n"
	"  }\n"
	"\n"
	"  typedef asn-type {\n"
	"    type union {\n"
	"      type uint32 {\n"
	"        range \"1..4294967295\";\n"
	"      }\n"
	"      type string {\n"
	"        pattern \'(0|[1-9][0-9]{0,3}|[1-5][0-9]{4}|\'\n"
	"        +  \'6[0-4][0-9]{3}|65[0-4][0-9]{2}|\'\n"
	"        +  \'655[0-2][0-9]|6553[0-5])\\.\'\n"
	"        +  \'(0|[1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|\'\n"
	"        +  \'65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\' {\n"
	"          error-message \"AS dot should be in the form [0..65535].[0..65535].\";\n"
	"        }\n"
	"        pattern \'^0\\.0$\' {\n"
	"          modifier \"invert-match\";\n"
	"          error-message \"AS dot can\'t be equal to 0.0.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"    description\n"
	"      \"Defines the ASN type as a union of uint32 and string patterns\";\n"
	"  }\n"
	"\n"
	"  typedef color-list {\n"
	"    type string {\n"
	"      pattern \'((00|01|10|11):(429496729[0-5]|42949672[0-8][0-9]|\'\n"
	"      +\t    \'4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|\'\n"
	"      +\t    \'42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|\'\n"
	"      +\t    \'429[0-3][0-9]{6}|42[0-8][0-9]{7}|\'\n"
	"      +\t    \'4[0-1][0-9]{8}|[1-3][0-9]{9}|\'\n"
	"      +\t    \'[1-9][0-9]{0,8})(\\s*))+\';\n"
	"    }\n"
	"    description\n"
	"      \"The color-list type represent a set of colors of value (examples 00:200 01:200 10:200)\n"
	"       values are separated by white spaces\";\n"
	"    reference\n"
	"      \"RFC 9012 - The BGP Tunnel Encapsulation Attribute.\n"
	"       RFC 9256 - Segment Routing Policy Architecture.\";\n"
	"  }\n"
	"\n"
	"  augment \"/frr-route-map:lib/frr-route-map:route-map/frr-route-map:entry/frr-route-map:match-condition/frr-route-map:rmap-match-condition/frr-route-map:match-condition\" {\n"
	"    description\n"
	"      \"Augments the match condition with local preference\";\n"
	"\n"
	"    case local-preference {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-local-preference\')\";\n"
	"      leaf local-preference {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the local preference value for the route\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case alias {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-alias\')\";\n"
	"      leaf alias {\n"
	"        type string;\n"
	"        description\n"
	"          \"Match BGP community alias name\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case script {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-script\')\";\n"
	"      leaf script {\n"
	"        type string;\n"
	"        description\n"
	"          \"Specifies the script to be executed\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case origin {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-origin\')\";\n"
	"      leaf origin {\n"
	"        type enumeration {\n"
	"          enum \"egp\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Remote EGP\";\n"
	"          }\n"
	"          enum \"igp\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Local IGP\";\n"
	"          }\n"
	"          enum \"incomplete\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Unknown heritage\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the origin of the route\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case rpki {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:rpki\')\";\n"
	"      leaf rpki {\n"
	"        type enumeration {\n"
	"          enum \"invalid\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Invalid prefix\";\n"
	"          }\n"
	"          enum \"notfound\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Prefix not found\";\n"
	"          }\n"
	"          enum \"valid\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Valid prefix\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the rpki status of the prefix\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case rpki-extcommunity {\n"
	"      when \"derived-from-or-self(/frr-route-map:lib/frr-route-map:route-map/frr-route-map:entry/frr-route-map:match-condition/frr-route-map:condition, \'frr-bgp-route-map:rpki-extcommunity\')\";\n"
	"      leaf rpki-extcommunity {\n"
	"        type enumeration {\n"
	"          enum \"valid\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Valid prefix\";\n"
	"          }\n"
	"          enum \"notfound\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Prefix not found\";\n"
	"          }\n"
	"          enum \"invalid\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Invalid prefix\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the rpki extended community\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case probability {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:probability\')\";\n"
	"      leaf probability {\n"
	"        type uint8 {\n"
	"          range \"0..100\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the probability of applying the route-map\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case source-vrf {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:source-vrf\')\";\n"
	"      leaf source-vrf {\n"
	"        type string;\n"
	"        description\n"
	"          \"Specifies the source VRF for the route\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case peer {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:peer\')\";\n"
	"      choice peer {\n"
	"        description\n"
	"          \"Value of the peer\";\n"
	"        case peer-ipv4-address {\n"
	"          description\n"
	"            \"IP address of peer\";\n"
	"          leaf peer-ipv4-address {\n"
	"            type inet:ipv4-address;\n"
	"            description\n"
	"              \"Specifies the IP address of the peer\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case peer-interface {\n"
	"          description\n"
	"            \"Interface name of peer\";\n"
	"          leaf peer-interface {\n"
	"            type string;\n"
	"            description\n"
	"              \"Specifies the name of the interface used by the peer\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case peer-ipv6-address {\n"
	"          description\n"
	"            \"IPv6 address of peer\";\n"
	"          leaf peer-ipv6-address {\n"
	"            type inet:ipv6-address;\n"
	"            description\n"
	"              \"Specifies the IPv6 address of the peer\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case peer-local {\n"
	"          description\n"
	"            \"Static or Redistributed routes\";\n"
	"          leaf peer-local {\n"
	"            type boolean;\n"
	"            description\n"
	"              \"Specifies whether the routes are static or redistributed\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case src-peer {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:src-peer\')\";\n"
	"      choice peer {\n"
	"        description\n"
	"          \"Value of the peer\";\n"
	"        case src-peer-ipv4-address {\n"
	"          description\n"
	"            \"IP address of peer\";\n"
	"          leaf src-peer-ipv4-address {\n"
	"            type inet:ipv4-address;\n"
	"            description\n"
	"              \"Specifies the IP address of the peer\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case src-peer-interface {\n"
	"          description\n"
	"            \"Interface name of peer\";\n"
	"          leaf src-peer-interface {\n"
	"            type string;\n"
	"            description\n"
	"              \"Specifies the name of the interface used by the peer\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case src-peer-ipv6-address {\n"
	"          description\n"
	"            \"IPv6 address of peer\";\n"
	"          leaf src-peer-ipv6-address {\n"
	"            type inet:ipv6-address;\n"
	"            description\n"
	"              \"Specifies the IPv6 address of the peer\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case access-list-name {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:mac-address-list\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:as-path-list\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:ip-route-source\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:ip-route-source-prefix-list\')\";\n"
	"      description\n"
	"        \"Access-list name\";\n"
	"      leaf list-name {\n"
	"        type filter:access-list-name;\n"
	"        description\n"
	"          \"Specifies the name of the access list\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case evpn-default-route {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:evpn-default-route\')\";\n"
	"      description\n"
	"        \"Match default EVPN type-5 route\";\n"
	"      leaf evpn-default-route {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Specifies that the route is a default EVPN type-5 route\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case evpn-vni {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:evpn-vni\')\";\n"
	"      description\n"
	"        \"Match EVPN VNI\";\n"
	"      leaf evpn-vni {\n"
	"        type uint32 {\n"
	"          range \"1..16777215\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the EVPN Virtual Network Identifier\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case evpn-route-type {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:evpn-route-type\')\";\n"
	"      description\n"
	"        \"Match EVPN route-type\";\n"
	"      leaf evpn-route-type {\n"
	"        type enumeration {\n"
	"          enum \"macip\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Mac-IP route\";\n"
	"          }\n"
	"          enum \"multicast\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"IMET route\";\n"
	"          }\n"
	"          enum \"prefix\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Prefix route\";\n"
	"          }\n"
	"          enum \"ead\" {\n"
	"            value 3;\n"
	"            description\n"
	"              \"Ethernet Auto-Discovery route\";\n"
	"          }\n"
	"          enum \"es\" {\n"
	"            value 4;\n"
	"            description\n"
	"              \"Ethernet Segment route\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the EVPN route type\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case evpn-rd {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:evpn-rd\')\";\n"
	"      description\n"
	"        \"Match EVPN route-distinguisher\";\n"
	"      leaf route-distinguisher {\n"
	"        type route-distinguisher;\n"
	"        description\n"
	"          \"Specifies the route-distinguisher for EVPN routes\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case community-limit {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-community-limit\')\";\n"
	"      description\n"
	"        \"Match BGP updates when the list of communities count is less than the configured limit.\";\n"
	"      leaf community-limit {\n"
	"        type uint16 {\n"
	"          range \"0..1024\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the limit for the count of communities\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-limit {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-extcommunity-limit\')\";\n"
	"      description\n"
	"        \"Match BGP updates when the list of extended communities count is less than the configured limit.\";\n"
	"      leaf extcommunity-limit {\n"
	"        type uint16 {\n"
	"          range \"0..1024\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the limit for the count of extended communities\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case comm-list-name {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-community\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-large-community\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:match-extcommunity\')\";\n"
	"      container comm-list {\n"
	"        description\n"
	"          \"Specifies the community list for BGP routes\";\n"
	"\n"
	"        leaf comm-list-name {\n"
	"          type bgp-filter:bgp-list-name;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Specifies the name of the community list\";\n"
	"        }\n"
	"\n"
	"        leaf comm-list-name-exact-match {\n"
	"          type boolean;\n"
	"          description\n"
	"            \"Do exact matching of communities\";\n"
	"        }\n"
	"\n"
	"        leaf comm-list-name-any {\n"
	"          type boolean;\n"
	"          description\n"
	"            \"Do matching of any community\";\n"
	"        }\n"
	"\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case ipv4-address {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:ipv4-nexthop\')\";\n"
	"      leaf ipv4-address {\n"
	"        type inet:ipv4-address;\n"
	"        description\n"
	"          \"IPv4 address\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case ipv6-address {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:ipv6-nexthop\')\";\n"
	"      leaf ipv6-address {\n"
	"        type inet:ipv6-address;\n"
	"        description\n"
	"          \"IPv6 address\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case source-protocol {\n"
	"      when \"derived-from-or-self(../frr-route-map:condition, \'frr-bgp-route-map:source-protocol\')\";\n"
	"      leaf source-protocol {\n"
	"        type frr-route-types:frr-route-types;\n"
	"        description\n"
	"          \"Specifies the source protocol for BGP routes\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  augment \"/frr-route-map:lib/frr-route-map:route-map/frr-route-map:entry/frr-route-map:set-action/frr-route-map:rmap-set-action/frr-route-map:set-action\" {\n"
	"    description\n"
	"      \"Augment set-action for route-map entries\";\n"
	"\n"
	"    case distance {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:distance\')\";\n"
	"      leaf distance {\n"
	"        type uint8 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        description\n"
	"          \"Set the distance\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-none {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-none\')\";\n"
	"      description\n"
	"        \"Value of the BGP extended community attribute\";\n"
	"      leaf extcommunity-none {\n"
	"        type boolean;\n"
	"        description \"No extended community attribute\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-rt {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-rt\')\";\n"
	"      description\n"
	"        \"Value of the ext-community\";\n"
	"      leaf extcommunity-rt {\n"
	"        type string;\n"
	"        description\n"
	"          \"Set BGP ext-community route-target attribute\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-nt {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-nt\')\";\n"
	"      description\n"
	"        \"Value of the ext-community\";\n"
	"      leaf extcommunity-nt {\n"
	"        type string;\n"
	"        description\n"
	"          \"Set BGP ext-community node-target attribute\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-soo {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-soo\')\";\n"
	"      description\n"
	"        \"Value of the ext-community\";\n"
	"      leaf extcommunity-soo {\n"
	"        type string;\n"
	"        description\n"
	"          \"Set BGP ext-community site-of-origin attribute\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case extcommunity-lb {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-lb\')\";\n"
	"      container extcommunity-lb {\n"
	"        description\n"
	"          \"Value of the ext-community.\";\n"
	"        leaf lb-type {\n"
	"          type frr-bgp-route-map:extcommunity-lb-type;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Specifies the type of extended community link-bandwidth\";\n"
	"        }\n"
	"\n"
	"        leaf bandwidth {\n"
	"          when \"../lb-type = \'explicit-bandwidth\'\";\n"
	"          type uint32;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Bandwidth value in Mbps\";\n"
	"        }\n"
	"        uses extcommunity-non-transitive-types;\n"
	"      }\n"
	"    }\n"
	"\n"
	"   case extcommunity-color {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-extcommunity-color\')\";\n"
	"      description\n"
	"        \"Value of the ext-community\";\n"
	"      leaf extcommunity-color {\n"
	"        type color-list;\n"
	"        description\n"
	"          \"Set BGP ext-community color attribute with a list of colors\";\n"
	"\treference\n"
	"\t  \"RFC9012\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case ipv4-address {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:ipv4-vpn-address\')\";\n"
	"      description\n"
	"        \"Set the IPv4 address\";\n"
	"      leaf ipv4-address {\n"
	"        type inet:ipv4-address;\n"
	"        description\n"
	"          \"Specifies the IPv4 address value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case ipv4-nexthop {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-ipv4-nexthop\')\";\n"
	"      description\n"
	"        \"Set the IPv4 nexthop\";\n"
	"      leaf ipv4-nexthop {\n"
	"        type string;\n"
	"        description\n"
	"          \"Specifies the IPv4 next-hop address value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case ipv6-address {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:ipv6-nexthop-global\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:ipv6-vpn-address\')\";\n"
	"      description\n"
	"        \"Set the IPv6 address\";\n"
	"      leaf ipv6-address {\n"
	"        type inet:ipv6-address;\n"
	"        description\n"
	"          \"Specifies the IPv6 address value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case preference {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:ipv6-prefer-global\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:ipv6-peer-address\')\";\n"
	"      description\n"
	"        \"Set preference for IPv6 next-hop address\";\n"
	"      leaf preference {\n"
	"        type boolean;\n"
	"        description\n"
	"          \"Specifies whether to prefer global address or peer address for IPv6 next-hop\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case label-index {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:label-index\')\";\n"
	"      description\n"
	"        \"Set the label index\";\n"
	"      leaf label-index {\n"
	"        type uint32 {\n"
	"          range \"0..1048560\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the label index value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case local-pref {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-local-preference\')\";\n"
	"      description\n"
	"        \"Set the local preference\";\n"
	"      leaf local-pref {\n"
	"        type string;\n"
	"        description\n"
	"          \"Specifies the local preference value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case weight {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:weight\')\";\n"
	"      description\n"
	"        \"Set the weight\";\n"
	"      leaf weight {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the weight value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case origin {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-origin\')\";\n"
	"      description\n"
	"        \"Set the origin\";\n"
	"      leaf origin {\n"
	"        type enumeration {\n"
	"          enum \"egp\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"Remote EGP\";\n"
	"          }\n"
	"          enum \"igp\" {\n"
	"            value 1;\n"
	"            description\n"
	"              \"Local IGP\";\n"
	"          }\n"
	"          enum \"incomplete\" {\n"
	"            value 2;\n"
	"            description\n"
	"              \"Unknown heritage\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the origin value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case originator-id {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:originator-id\')\";\n"
	"      description\n"
	"        \"Set the originator ID\";\n"
	"      leaf originator-id {\n"
	"        type inet:ipv4-address;\n"
	"        description\n"
	"          \"Specifies the originator ID value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case table {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:table\')\";\n"
	"      description\n"
	"        \"Set the table\";\n"
	"      leaf table {\n"
	"        type uint32 {\n"
	"          range \"1..4294967295\";\n"
	"        }\n"
	"        description\n"
	"          \"Specifies the table value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case atomic-aggregate {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:atomic-aggregate\')\";\n"
	"      description\n"
	"        \"Set the atomic aggregate\";\n"
	"      leaf atomic-aggregate {\n"
	"        type empty;\n"
	"        description\n"
	"          \"Set BGP atomic-aggregate attribute\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case aigp-metric {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:aigp-metric\')\";\n"
	"      description\n"
	"        \"Set the aigp metric\";\n"
	"      leaf aigp-metric {\n"
	"        type string;\n"
	"        description\n"
	"          \"Set the aigp metric value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case as-path-prepend {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:as-path-prepend\')\";\n"
	"      choice as-path-prepend {\n"
	"        description\n"
	"          \"Set the prepended AS-path\";\n"
	"        case prepend-as {\n"
	"          description\n"
	"            \"Prepend the mentioned AS-path\";\n"
	"          leaf prepend-as-path {\n"
	"            type string;\n"
	"            description\n"
	"              \"Specifies the prepended AS-path value\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case last-as {\n"
	"          description\n"
	"            \"Prepend the last ASN in the AS-path\";\n"
	"          leaf last-as {\n"
	"            type uint8 {\n"
	"              range \"1..10\";\n"
	"            }\n"
	"            description\n"
	"              \"Number of times to prepend the last ASN in the AS-path\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case as-path-exclude {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:as-path-exclude\')\";\n"
	"      description\n"
	"        \"Exclude the mentioned AS-path\";\n"
	"      leaf exclude-as-path {\n"
	"        type string;\n"
	"        description\n"
	"          \"Values in the as-path ACL are excluded from the as-path.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case as-path-replace {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:as-path-replace\')\";\n"
	"      description\n"
	"        \"Set the replaced AS path\";\n"
	"      leaf replace-as-path {\n"
	"        type string;\n"
	"        description\n"
	"          \"Set the replaced AS path value\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case community {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-community\')\";\n"
	"      choice community {\n"
	"        description\n"
	"          \"Value of the BGP community attribute\";\n"
	"        case none {\n"
	"          description\n"
	"            \"No community attribute\";\n"
	"          leaf community-none {\n"
	"            type boolean;\n"
	"            description\n"
	"              \"Indicates that no community attribute should be set\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case community-string {\n"
	"          description\n"
	"            \"Community string\";\n"
	"          leaf community-string {\n"
	"            type string;\n"
	"            description\n"
	"              \"Specifies the value of the community attribute as a string\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case large-community {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-large-community\')\";\n"
	"      choice large-community {\n"
	"        description\n"
	"          \"Value of the BGP large-community attribute\";\n"
	"        case none {\n"
	"          description\n"
	"            \"No large-community attribute\";\n"
	"          leaf large-community-none {\n"
	"            type boolean;\n"
	"            description\n"
	"              \"Indicates that no large-community attribute should be set\";\n"
	"          }\n"
	"        }\n"
	"\n"
	"        case large-community-string {\n"
	"          description\n"
	"            \"Large-Community string\";\n"
	"          leaf large-community-string {\n"
	"            type string;\n"
	"            description\n"
	"              \"Specifies the value of the large-community attribute as a string\";\n"
	"          }\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case aggregator {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:aggregator\')\";\n"
	"      container aggregator {\n"
	"        description\n"
	"          \"Aggregator configuration for BGP routes\";\n"
	"\n"
	"        leaf aggregator-asn {\n"
	"          type asn-type;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"ASN of the aggregator\";\n"
	"        }\n"
	"\n"
	"        leaf aggregator-address {\n"
	"          type inet:ipv4-address;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"IPv4 address of the aggregator\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    case comm-list-name {\n"
	"      when \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:comm-list-delete\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:large-comm-list-delete\') or \"\n"
	"        + \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:extended-comm-list-delete\')\";\n"
	"      description\n"
	"        \"Set the community list name\";\n"
	"      leaf comm-list-name {\n"
	"        type bgp-filter:bgp-list-name;\n"
	"        description\n"
	"          \"Set the community list name value\";\n"
	"      }\n"
	"    }\n"
	"    case evpn-gateway-ip-ipv4 {\n"
	"      when\n"
	"      \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-evpn-gateway-ip-ipv4\')\";\n"
	"      description\n"
	"        \"Set the EVPN gateway IP overlay index IPv4\";\n"
	"      leaf evpn-gateway-ip-ipv4 {\n"
	"        type inet:ipv4-address;\n"
	"        description\n"
	"          \"Specify the EVPN gateway IP overlay index IPv4 value\";\n"
	"      }\n"
	"    }\n"
	"    case evpn-gateway-ip-ipv6 {\n"
	"      when\n"
	"      \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-evpn-gateway-ip-ipv6\')\";\n"
	"      description\n"
	"        \"Set EVPN gateway IP overlay index IPv6\";\n"
	"      leaf evpn-gateway-ip-ipv6 {\n"
	"        type inet:ipv6-address;\n"
	"        description\n"
	"          \"Specify the EVPN gateway IP overlay index IPv6 value\";\n"
	"      }\n"
	"    }\n"
	"    case l3vpn-nexthop-encapsulation {\n"
	"      when\n"
	"      \"derived-from-or-self(../frr-route-map:action, \'frr-bgp-route-map:set-l3vpn-nexthop-encapsulation\')\";\n"
	"      description\n"
	"        \"Set L3VPN traffic over other than LSP encapsulation\";\n"
	"      leaf l3vpn-nexthop-encapsulation {\n"
	"        type enumeration {\n"
	"          enum \"gre\" {\n"
	"            value 0;\n"
	"            description\n"
	"              \"GRE protocol\";\n"
	"          }\n"
	"        }\n"
	"        description\n"
	"          \"Specify L3VPN traffic over other than LSP encapsulation value\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-bgp-route-map",
	.mod_rev = "2020-01-02",
	.sub_mod_name = "",
	.sub_mod_rev = "",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
