/* autogenerated by embedmodel.py.  DO NOT EDIT */

#include <zebra.h>
#include "yang.h"

static const char model[] =
	"// SPDX-License-Identifier: BSD-2-Clause\n"
	"submodule frr-bgp-common {\n"
	"  yang-version 1.1;\n"
	"\n"
	"  belongs-to frr-bgp {\n"
	"    prefix \"bgp\";\n"
	"  }\n"
	"\n"
	"  import ietf-bgp-types {\n"
	"    prefix bt;\n"
	"  }\n"
	"\n"
	"  import ietf-inet-types {\n"
	"    prefix inet;\n"
	"  }\n"
	"\n"
	"  import frr-bgp-types {\n"
	"    prefix frr-bt;\n"
	"  }\n"
	"\n"
	"  import frr-route-map {\n"
	"    prefix frr-route-map;\n"
	"  }\n"
	"\n"
	"  import frr-route-types {\n"
	"    prefix frr-rt-type;\n"
	"  }\n"
	"\n"
	"  import frr-vrf {\n"
	"    prefix frr-vrf;\n"
	"  }\n"
	"\n"
	"  import ietf-routing-types {\n"
	"    prefix rt-types;\n"
	"  }\n"
	"\n"
	"  import frr-interface {\n"
	"    prefix frr-interface;\n"
	"  }\n"
	"\n"
	"  organization\n"
	"    \"FRRouting\";\n"
	"  contact\n"
	"    \"FRR Users List: <mailto:frog@lists.frrouting.org> FRR Development\n"
	"     List: <mailto:dev@lists.frrouting.org>\";\n"
	"  description\n"
	"    \"This submodule contains general data definitions for use in BGP.\n"
	"\n"
	"     Copyright 2020 FRRouting\n"
	"\n"
	"     Redistribution and use in source and binary forms, with or without\n"
	"     modification, are permitted provided that the following conditions\n"
	"     are met:\n"
	"\n"
	"     1. Redistributions of source code must retain the above copyright notice,\n"
	"     this list of conditions and the following disclaimer.\n"
	"\n"
	"     2. Redistributions in binary form must reproduce the above copyright\n"
	"     notice, this list of conditions and the following disclaimer in the\n"
	"     documentation and/or other materials provided with the distribution.\n"
	"\n"
	"     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
	"     \\\"AS IS\\\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
	"     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
	"     A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
	"     HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
	"     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
	"     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
	"     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
	"     THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
	"     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
	"     OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\";\n"
	"\n"
	"  revision 2019-12-03 {\n"
	"    description\n"
	"      \"Initial revision.\";\n"
	"    reference \"FRRouting\";\n"
	"  }\n"
	"\n"
	"  grouping rmap-policy-import {\n"
	"    description\n"
	"      \"Grouping for route map policy import configuration\";\n"
	"\n"
	"    leaf rmap-import {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Reference to route map for import policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping rmap-policy-export {\n"
	"    description\n"
	"      \"Grouping for route map policy export configuration\";\n"
	"\n"
	"    leaf rmap-export {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Reference to route map for export policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping unsuppress-map-policy-import {\n"
	"    description\n"
	"      \"Grouping for unsuppress map policy import configuration\";\n"
	"\n"
	"    leaf unsuppress-map-import {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Reference to unsuppress map for import policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping unsuppress-map-policy-export {\n"
	"    description\n"
	"      \"Grouping for unsuppress map policy export configuration\";\n"
	"\n"
	"    leaf unsuppress-map-export {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Reference to unsuppress map for export policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping plist-policy-import {\n"
	"    description\n"
	"      \"Grouping for prefix list policy import configuration\";\n"
	"\n"
	"    leaf plist-import {\n"
	"      type frr-bt:plist-ref;\n"
	"      description\n"
	"        \"Reference to prefix list for import policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping plist-policy-export {\n"
	"    description\n"
	"      \"Grouping for prefix list policy export configuration\";\n"
	"\n"
	"    leaf plist-export {\n"
	"      type frr-bt:plist-ref;\n"
	"      description\n"
	"        \"Reference to prefix list for export policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping access-list-policy-import {\n"
	"    description\n"
	"      \"Grouping for access list policy import configuration\";\n"
	"\n"
	"    leaf access-list-import {\n"
	"      type frr-bt:access-list-ref;\n"
	"      description\n"
	"        \"Reference to access list for import policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping access-list-policy-export {\n"
	"    description\n"
	"      \"Grouping for access list policy export configuration\";\n"
	"\n"
	"    leaf access-list-export {\n"
	"      type frr-bt:access-list-ref;\n"
	"      description\n"
	"        \"Reference to access list for export policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping as-path-filter-list-policy-import {\n"
	"    description\n"
	"      \"Grouping for AS path filter list policy import configuration\";\n"
	"\n"
	"    leaf as-path-filter-list-import {\n"
	"      type frr-bt:as-path-filter-ref;\n"
	"      description\n"
	"        \"Reference to AS path filter list for import policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping as-path-filter-list-policy-export {\n"
	"    description\n"
	"      \"Grouping for AS path filter list policy export configuration\";\n"
	"\n"
	"    leaf as-path-filter-list-export {\n"
	"      type frr-bt:as-path-filter-ref;\n"
	"      description\n"
	"        \"Reference to AS path filter list for export policy\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping route-selection-options {\n"
	"    description\n"
	"      \"Configuration relating to route selection options.\";\n"
	"    container route-selection-options {\n"
	"      description\n"
	"        \"Parameters relating to options for route selection.\";\n"
	"      leaf always-compare-med {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Compare multi-exit discriminator (MED) value from\n"
	"           different ASes when selecting the best route.  The\n"
	"           default behaviour is to only compare MEDs for paths\n"
	"           received from the same AS.\";\n"
	"      }\n"
	"\n"
	"      leaf deterministic-med {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Compare multi-exit discriminator (MED) value from\n"
	"           Same ASes when selecting the best route.\";\n"
	"      }\n"
	"\n"
	"      leaf confed-med {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Compare multi-exit discriminator (MED) value from\n"
	"           different Sub ASes when selecting the best route.\";\n"
	"      }\n"
	"\n"
	"      leaf missing-as-worst-med {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Missing multi-exit discriminator (MED) value is\n"
	"           considered as value of infinity, making the path\n"
	"           least desirable when selecting the best route.\";\n"
	"      }\n"
	"\n"
	"      leaf aspath-confed {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Compare path lengths including confederation sets\n"
	"           and sequences in selecting a route.\";\n"
	"      }\n"
	"\n"
	"      leaf ignore-as-path-length {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Ignore the AS path length when selecting the best path.\n"
	"           The default is to use the AS path length and prefer paths\n"
	"           with shorter length.\";\n"
	"      }\n"
	"\n"
	"      leaf external-compare-router-id {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"When comparing similar routes received from external BGP\n"
	"           peers, use the router-id as a criterion to select the\n"
	"           active path.\";\n"
	"      }\n"
	"\n"
	"      leaf allow-multiple-as {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Allow multi-path to use paths from different neighbouring\n"
	"           ASes.  The default is to only consider multiple paths\n"
	"           from the same neighbouring AS.\";\n"
	"      }\n"
	"\n"
	"      leaf multi-path-as-set {\n"
	"        when \"../allow-multiple-as = \'true\'\";\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Multi-path with AS-SET, When set to \'true\' it adds AS set\n"
	"           information for aggregate routes, When set to \'false\' it\n"
	"           prevents AS set generation.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping med-config {\n"
	"    description\n"
	"      \"Configuration relating to MED.\";\n"
	"    container med-config {\n"
	"      description\n"
	"        \"Container for MED configuration\";\n"
	"\n"
	"      leaf enable-med-admin {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Flag to enable receiving of MED metric attribute\n"
	"           in routing updates.\";\n"
	"      }\n"
	"      leaf max-med-admin {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        default \"4294967294\";\n"
	"        description\n"
	"          \"Tells the router to announce routes with this MED value\n"
	"           This MED value is applicable for indefinite time.\";\n"
	"      }\n"
	"\n"
	"      leaf max-med-onstart-up-time {\n"
	"        type uint32 {\n"
	"          range \"5..86400\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        description\n"
	"          \"Tells the router to announce routes with MED value,\n"
	"           This MED value is applicable for this duration during\n"
	"           start-up.\";\n"
	"      }\n"
	"\n"
	"      leaf max-med-onstart-up-value {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        default \"4294967294\";\n"
	"        description\n"
	"          \"Tells the router to announce routes with this MED value\n"
	"           This MED value is applicable for start-up time.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping route-reflector-config {\n"
	"    description\n"
	"      \"Grouping used to include route reflector\n"
	"       configuration for BGP global.\";\n"
	"    container route-reflector {\n"
	"      description\n"
	"        \"Route reflector parameters for the BGP global.\";\n"
	"      leaf route-reflector-cluster-id {\n"
	"        type bt:rr-cluster-id-type;\n"
	"        description\n"
	"          \"Route Reflector cluster ID to use when local router is\n"
	"           configured as a route reflector.  Commonly set at the\n"
	"           group level, but allows a different cluster ID to be set\n"
	"           for each neighbor.\";\n"
	"        reference\n"
	"          \"RFC 4456: BGP Route Reflection: An Alternative to\n"
	"           Full Mesh.\";\n"
	"      }\n"
	"\n"
	"      leaf no-client-reflect {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"When set to \'true\', this disables route redistribution\n"
	"           by the Route Reflector. It is set \'true\' when the client is\n"
	"           fully meshed to prevent sending of redundant route\n"
	"           advertisements.\";\n"
	"        reference\n"
	"          \"TODO: Add reference when IETF writes a draft describing\n"
	"           this.\";\n"
	"      }\n"
	"\n"
	"      leaf allow-outbound-policy {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"When set to \'true\', this allow RR to modify the attributes of the\n"
	"           reflected IBGP routes as per the out route-map. It is set \'false\'\n"
	"           RR will not modify the attributes of the reflected IBGP routes as\n"
	"           per the out route-map rules.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-bgp-config {\n"
	"    description\n"
	"      \"Grouping for global BGP configuration\";\n"
	"\n"
	"    leaf instance-type-view {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' BGP instance type is view.\n"
	"         When set to \'false\' BGP instance type is regular.\";\n"
	"    }\n"
	"\n"
	"    leaf as-notation {\n"
	"      type enumeration {\n"
	"        enum \"plain\"   {\n"
	"            value 0;\n"
	"            description \"Use plain format for all AS values\";\n"
	"        }\n"
	"        enum \"dot\" {\n"
	"            value 1;\n"
	"            description \"Use \'AA.BB\' format for AS 4 byte values\";\n"
	"        }\n"
	"        enum \"dot+\" {\n"
	"            value 2;\n"
	"            description \"Use \'AA.BB\' format for all AS values\";\n"
	"        }\n"
	"      }\n"
	"      description\n"
	"        \"The as-notation type\";\n"
	"    }\n"
	"\n"
	"    leaf ebgp-multihop-connected-route-check {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' it will disable checking if nexthop is connected\n"
	"         on EBGP sessions. When set to \'false\' it will enable checking if\n"
	"         nexthop is connected on EBGP sessions.\";\n"
	"    }\n"
	"\n"
	"    leaf fast-external-failover {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"It\'s an interface tracking mechanism. When set to \'true\' don\'t\n"
	"         immediately reset session if a link to a directly connected\n"
	"         external peer goes down. When set to \'false\' it will immediately\n"
	"         reset session if a link to a directly connected external peer goes down.\";\n"
	"    }\n"
	"\n"
	"    leaf local-pref {\n"
	"      type uint32;\n"
	"      default \"100\";\n"
	"      description\n"
	"        \"BGP local preference attribute sent to internal peers to\n"
	"         indicate the degree of preference for externally learned\n"
	"         routes.  The route with the highest local preference\n"
	"         value is preferred.\";\n"
	"      reference\n"
	"        \"RFC 4271.\";\n"
	"    }\n"
	"\n"
	"    leaf default-shutdown {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Apply administrative shutdown to newly configured peers.\";\n"
	"    }\n"
	"\n"
	"    leaf suppress-duplicates {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"Suppress duplicate updates if the route actually not changed.\";\n"
	"    }\n"
	"\n"
	"    leaf ebgp-requires-policy {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"When set to \'true\' BGP speaker requires in and out policy\n"
	"         for EBGP peers (RFC8212).\";\n"
	"    }\n"
	"\n"
	"    leaf show-hostname {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' BGP show hostname in certain command outputs.\";\n"
	"    }\n"
	"\n"
	"    leaf show-nexthop-hostname {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' BGP show hostname for nexthop in certain\n"
	"         command outputs.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-neighbor-config {\n"
	"    description\n"
	"      \"Grouping for global neighbor configuration\";\n"
	"\n"
	"    container global-neighbor-config {\n"
	"      description\n"
	"        \"Container for global neighbor configuration\";\n"
	"\n"
	"      leaf dynamic-neighbors-limit {\n"
	"        type uint32 {\n"
	"          range \"1..65535\";\n"
	"        }\n"
	"        description\n"
	"          \"Maximum number of BGP Dynamic Neighbors that can be created.\";\n"
	"      }\n"
	"\n"
	"      leaf log-neighbor-changes {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"When set to \'true\' BGP will start logging neighbor up/down and reset reason.\n"
	"           When set to \'false\' BGP will stop logging neighbor up/down and reset reason.\";\n"
	"      }\n"
	"\n"
	"      container packet-quanta-config {\n"
	"        description\n"
	"          \"Container for packet quanta configuration\";\n"
	"\n"
	"        leaf wpkt-quanta {\n"
	"          type uint32 {\n"
	"            range \"1..64\";\n"
	"          }\n"
	"          default \"64\";\n"
	"          description\n"
	"            \"How many packets to write to peer socket per run.\";\n"
	"        }\n"
	"\n"
	"        leaf rpkt-quanta {\n"
	"          type uint32 {\n"
	"            range \"1..10\";\n"
	"          }\n"
	"          default \"10\";\n"
	"          description\n"
	"            \"How many packets to read from peer socket per I/O cycle.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-update-group-config {\n"
	"    description\n"
	"      \"Grouping for global update group configuration\";\n"
	"\n"
	"    container global-update-group-config {\n"
	"      description\n"
	"        \"Container for global update group configuration\";\n"
	"\n"
	"      leaf subgroup-pkt-queue-size {\n"
	"        type uint32 {\n"
	"          range \"20..100\";\n"
	"        }\n"
	"        default \"40\";\n"
	"        description\n"
	"          \"Subgroup packet queue size.\";\n"
	"      }\n"
	"\n"
	"      leaf coalesce-time {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        units \"milliseconds\";\n"
	"        default \"1000\";\n"
	"        description\n"
	"          \"Configures the Subgroup coalesce timer.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-network-config {\n"
	"    description\n"
	"      \"Grouping for global network configuration\";\n"
	"\n"
	"    leaf import-check {\n"
	"      type boolean;\n"
	"      default \"true\";\n"
	"      description\n"
	"        \"When set to \'true\' bgp creates entries for network statements\n"
	"         if a matching prefix exists in the rib. When set to \'false\' bgp\n"
	"         creates entries for networks that the router cannot reach.\n"
	"\n"
	"         In FRR versions < 7.4 this used to default to \'false\' this is an\n"
	"         incompatible backward change\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping neighbor-timers {\n"
	"    description\n"
	"      \"Grouping for neighbor timers configuration\";\n"
	"\n"
	"    leaf hold-time {\n"
	"      type uint16 {\n"
	"        range \"0 | 3..65535\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"180\";\n"
	"      description\n"
	"        \"Time interval (in seconds) for the HoldTimer established\n"
	"         with the peer.  When read as operational data (ro), the\n"
	"         value of this object is calculated by this BGP speaker,\n"
	"         using the smaller of the values in hold-time that was\n"
	"         configured (rw) in the running datastore and the Hold Time\n"
	"         received in the OPEN message.\n"
	"\n"
	"         This value must be at least three seconds\n"
	"         if it is not zero (0).\n"
	"\n"
	"         If the Hold Timer has not been established\n"
	"         with the peer this object MUST have a value\n"
	"         of zero (0).\n"
	"\n"
	"         If the configured value of hold-time object was\n"
	"         a value of (0), then when read this object MUST have a\n"
	"         value of (0) also.\";\n"
	"      reference\n"
	"        \"RFC 4271\";\n"
	"    }\n"
	"\n"
	"    leaf keepalive {\n"
	"      type uint16 {\n"
	"        range \"0..65535\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"60\";\n"
	"      description\n"
	"        \"When used as a configuration (rw) value, this Time interval\n"
	"         (in seconds) for the KeepAlive timer configured for this BGP\n"
	"         speaker with this peer. The value of this object will only\n"
	"         determine the KEEPALIVE messages\' frequency relative to\n"
	"         the value specified in configured value for hold-time.\n"
	"\n"
	"         If the value of this object is zero (0), no periodical\n"
	"         KEEPALIVE messages are sent to the peer after the BGP\n"
	"         connection has been established.  The suggested value for\n"
	"         this timer is 30 seconds.;\n"
	"\n"
	"         The actual time interval for the KEEPALIVE messages is\n"
	"         indicated by operational value of keepalive. That value\n"
	"         of this object is calculated by this BGP speaker such that,\n"
	"         when compared with hold-time, it has the same proportion\n"
	"         that keepalive has, compared with hold-time. A\n"
	"         reasonable maximum value for this timer would be one third\n"
	"         of that of hold-time.\";\n"
	"      reference\n"
	"        \"RFC 4271\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-config-timers {\n"
	"    description\n"
	"      \"Grouping for global configuration timers.\";\n"
	"\n"
	"    container global-config-timers {\n"
	"      description\n"
	"        \"Container for global configuration timers.\";\n"
	"\n"
	"      leaf rmap-delay-time {\n"
	"        type uint16 {\n"
	"          range \"0..600\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"5\";\n"
	"        description\n"
	"          \"Time to wait before processing route-map changes.\";\n"
	"      }\n"
	"\n"
	"      leaf update-delay-time {\n"
	"        type uint16 {\n"
	"          range \"0..3600\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        description\n"
	"          \"Time to force initial delay for best-path and updates.\";\n"
	"      }\n"
	"\n"
	"      leaf establish-wait-time {\n"
	"        type uint16 {\n"
	"          range \"1..3600\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        description\n"
	"          \"Time to force initial delay for updates.\";\n"
	"      }\n"
	"\n"
	"      leaf connect-retry-interval {\n"
	"        type uint16 {\n"
	"          range \"1..max\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"120\";\n"
	"        description\n"
	"          \"Time interval (in seconds) for the ConnectRetryTimer. The\n"
	"           suggested value for this timer is 120 seconds.\";\n"
	"        reference\n"
	"          \"RFC 4271, This is the value used\n"
	"           to initialize the \'ConnectRetryTimer\'.\";\n"
	"      }\n"
	"\n"
	"      uses neighbor-timers;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping graceful-restart-config {\n"
	"    description\n"
	"      \"Configuration parameters relating to BGP graceful restart.\";\n"
	"    choice mode {\n"
	"      description\n"
	"        \"Choice for graceful restart mode.\";\n"
	"\n"
	"      case graceful-restart-mode {\n"
	"        leaf enabled {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Enable or disable the graceful-restart capability. When set to \'true\'\n"
	"             it will enable graceful restart and helper both globally. When set\n"
	"             to \'false\' it will enable the default behaviour global helper mode.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      case graceful-restart-disable-mode {\n"
	"        leaf graceful-restart-disable {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"When set to \'true\' it will disable graceful restart and helper both\n"
	"             globally. when set to \'false\' it will enable the default behaviour\n"
	"             global helper mode.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"\n"
	"    leaf preserve-fw-entry {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Sets F-bit indication that fib is preserved while doing Graceful Restart.\n"
	"         When set to \'true\' Zebra would preserve the FIB entry on the restarting\n"
	"         node.\";\n"
	"    }\n"
	"\n"
	"    leaf restart-time {\n"
	"      type uint16 {\n"
	"        range \"1..3600\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"120\";\n"
	"      description\n"
	"        \"Estimated time (in seconds) for the local BGP speaker to\n"
	"         restart a session. This value is advertise in the graceful\n"
	"         restart BGP capability.  This is a 12-bit value, referred to\n"
	"         as Restart Time in RFC4724.  Per RFC4724, the suggested\n"
	"         default value is <= the hold-time value. This timer is\n"
	"         applicable for helper node.\";\n"
	"      reference\n"
	"        \"RFC 4724: Graceful Restart Mechanism for BGP.\";\n"
	"    }\n"
	"\n"
	"    leaf stale-routes-time {\n"
	"      type uint16 {\n"
	"        range \"1..3600\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"360\";\n"
	"      description\n"
	"        \"An upper-bound on the time that stale routes will be\n"
	"         retained by a router after a session is restarted. If an\n"
	"         End-of-RIB (EOR) marker is received prior to this timer\n"
	"         expiring stale-routes will be flushed upon its receipt - if\n"
	"         no EOR is received, then when this timer expires stale paths\n"
	"         will be purged. This timer is applicable for restarting node.\";\n"
	"      reference\n"
	"        \"RFC 4724: Graceful Restart Mechanism for BGP.\";\n"
	"    }\n"
	"\n"
	"    leaf selection-deferral-time {\n"
	"      type uint16 {\n"
	"        range \"0..3600\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"360\";\n"
	"      description\n"
	"        \"An upper-bound on the time that restarting router defers\n"
	"         the route selection process after restart.\";\n"
	"      reference\n"
	"        \"RFC 4724: Graceful Restart Mechanism for BGP.\";\n"
	"    }\n"
	"\n"
	"    leaf rib-stale-time {\n"
	"      type uint16 {\n"
	"        range \"1..3600\";\n"
	"      }\n"
	"      units \"seconds\";\n"
	"      default \"500\";\n"
	"      description\n"
	"        \"An upper-bound on the time that helper router holds the\n"
	"         stale routes in Zebra, When this timer gets expired Zebra\n"
	"         removes the stale routes.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-group-use-multiple-paths {\n"
	"    description\n"
	"      \"Common grouping used for both global and groups which provides\n"
	"       configuration parameters relating to use of multiple paths.\";\n"
	"    container use-multiple-paths {\n"
	"      description\n"
	"        \"Parameters related to the use of multiple paths for the\n"
	"         same NLRI.\";\n"
	"      container ebgp {\n"
	"        description\n"
	"          \"Multi-Path parameters for EBGP.\";\n"
	"        leaf maximum-paths {\n"
	"          type uint16;\n"
	"          default \"64\";\n"
	"          description\n"
	"            \"Maximum number of parallel paths to consider when using\n"
	"             BGP multi-path. The default is use a single path.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      container ibgp {\n"
	"        description\n"
	"          \"Multi-Path parameters for IBGP.\";\n"
	"        leaf maximum-paths {\n"
	"          type uint16;\n"
	"          default \"64\";\n"
	"          description\n"
	"            \"Maximum number of parallel paths to consider when using\n"
	"             IBGP multi-path. The default is to use a single path.\";\n"
	"        }\n"
	"\n"
	"        leaf cluster-length-list {\n"
	"          when \"../maximum-paths != 0\";\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"When set to \'true\' route with the shortest cluster-list\n"
	"             length is used. The cluster-list reflects the IBGP\n"
	"             reflection path the route has taken. It\'s the part\n"
	"             of route selection algo.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-redistribute {\n"
	"    description\n"
	"      \"List of route redistribution per AFI.\";\n"
	"    list redistribution-list {\n"
	"      key \"route-type route-instance\";\n"
	"      description\n"
	"        \"List of route types to be redistributed.\";\n"
	"\n"
	"      leaf route-type {\n"
	"        type frr-rt-type:frr-route-types;\n"
	"        description\n"
	"          \"Protocol route type.\";\n"
	"      }\n"
	"\n"
	"      leaf route-instance {\n"
	"        type uint16 {\n"
	"          range \"0..65535\";\n"
	"        }\n"
	"        description\n"
	"          \"Protocol Instance.\";\n"
	"      }\n"
	"\n"
	"      leaf metric {\n"
	"        type uint32 {\n"
	"          range \"0..4294967295\";\n"
	"        }\n"
	"        description\n"
	"          \"Metric for redistributed routes.\";\n"
	"      }\n"
	"\n"
	"      leaf rmap-policy-import {\n"
	"        type frr-route-map:route-map-ref;\n"
	"        description\n"
	"          \"Route-map to be applied for redistributed routes into the bgp.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping mp-afi-safi-network-config {\n"
	"    description\n"
	"      \"Grouping for AFI/SAFI network configuration.\";\n"
	"\n"
	"    leaf label-index {\n"
	"      type rt-types:mpls-label;\n"
	"      description\n"
	"        \"Label index to associate with the prefix.\";\n"
	"    }\n"
	"\n"
	"    leaf rmap-policy-export {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Route-map to modify the attributes for Routes going out\n"
	"         via BGP updates.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping mp-afi-safi-agg-route-config {\n"
	"    description\n"
	"      \"Grouping for AFI/SAFI aggregate route configuration.\";\n"
	"\n"
	"    leaf as-set {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' AS set path information is generated\n"
	"         for aggregate address. When set to \'false\' AS set path\n"
	"         information is not generated.\";\n"
	"    }\n"
	"\n"
	"    leaf summary-only {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' it advertise only the aggregate route\n"
	"         and suppress the advertisement of all the component routes.\n"
	"         When set to \'false\' all more-specific routes summarized\n"
	"         by the aggregate route are advertised.\";\n"
	"    }\n"
	"\n"
	"    leaf rmap-policy-export {\n"
	"      type frr-route-map:route-map-ref;\n"
	"      description\n"
	"        \"Apply route map to aggregate network.\";\n"
	"    }\n"
	"\n"
	"    leaf origin {\n"
	"      type enumeration {\n"
	"        enum \"igp\" {\n"
	"          value 0;\n"
	"          description\n"
	"            \"Local IGP.\";\n"
	"        }\n"
	"        enum \"egp\" {\n"
	"          value 1;\n"
	"          description\n"
	"            \"Remote EGP.\";\n"
	"        }\n"
	"        enum \"incomplete\" {\n"
	"          value 2;\n"
	"          description\n"
	"            \"Unknown heritage.\";\n"
	"        }\n"
	"        enum \"unspecified\" {\n"
	"          value 255;\n"
	"          description\n"
	"            \"Unspecified.\";\n"
	"        }\n"
	"      }\n"
	"      default \"unspecified\";\n"
	"      description\n"
	"        \"BGP origin type.\";\n"
	"    }\n"
	"\n"
	"    leaf match-med {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"When set to \'true\' aggregate-route matches only\n"
	"         med.\";\n"
	"    }\n"
	"\n"
	"    leaf suppress-map {\n"
	"      type string;\n"
	"      description\n"
	"        \"Suppress more specific routes specified in route-map.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping admin-distance {\n"
	"    description\n"
	"      \"Grouping for administrative distance configuration.\";\n"
	"\n"
	"    container admin-distance {\n"
	"      description\n"
	"        \"Administrative distance (or preference) assigned to\n"
	"         routes received from different sources\n"
	"         (external, internal, and local).\";\n"
	"      leaf external {\n"
	"        type uint8 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        default \"20\";\n"
	"        description\n"
	"          \"Administrative distance for routes learned from\n"
	"           external BGP (EBGP).\";\n"
	"      }\n"
	"\n"
	"      leaf internal {\n"
	"        type uint8 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        default \"200\";\n"
	"        description\n"
	"          \"Administrative distance for routes learned from\n"
	"           internal BGP (IBGP).\";\n"
	"      }\n"
	"\n"
	"      leaf local {\n"
	"        type uint8 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        default \"200\";\n"
	"        description\n"
	"          \"Administrative distance for routes learned from\n"
	"           local.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping distance-per-route-config {\n"
	"    description\n"
	"      \"Grouping for administrative distance configuration per route.\";\n"
	"\n"
	"    leaf distance {\n"
	"      type uint8 {\n"
	"        range \"1..255\";\n"
	"      }\n"
	"      mandatory true;\n"
	"      description\n"
	"        \"Administrative distance for route.\";\n"
	"    }\n"
	"\n"
	"    leaf access-list-policy-export {\n"
	"      type frr-bt:access-list-ref;\n"
	"      description\n"
	"        \"Access-list policy applied on routes going from BGP to Zebra.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping route-flap-dampening {\n"
	"    description\n"
	"      \"Grouping for route flap dampening configuration.\";\n"
	"\n"
	"    container route-flap-dampening {\n"
	"      description\n"
	"        \"Dampening feature\";\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Enable route flap dampening.\";\n"
	"      }\n"
	"\n"
	"      leaf reach-decay {\n"
	"        when \"../enable = \'true\'\";\n"
	"        type uint8 {\n"
	"          range \"1..45\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"15\";\n"
	"        description\n"
	"          \"This value specifies the time desired for the instability\n"
	"           metric value to reach one-half of its current value when\n"
	"           the route is reachable. This half-life value determines\n"
	"           the rate at which the metric value is decayed. A smaller\n"
	"           half-life value makes a suppressed route reusable sooner\n"
	"           than a larger value. The accumulated penalty will be reduced\n"
	"           to half after this duration.\";\n"
	"      }\n"
	"\n"
	"      leaf reuse-above {\n"
	"        when \"../enable = \'true\'\";\n"
	"        type uint16 {\n"
	"          range \"1..20000\";\n"
	"        }\n"
	"        default \"750\";\n"
	"        description\n"
	"          \"This is the value of the instability metric at which a\n"
	"           suppressed route becomes unsuppressed if it is reachable\n"
	"           but currently suppressed. The value assigned to\n"
	"           reuse-below must be less than suppress-above.\";\n"
	"      }\n"
	"\n"
	"      leaf suppress-above {\n"
	"        when \"../enable = \'true\'\";\n"
	"        type uint16 {\n"
	"          range \"1..20000\";\n"
	"        }\n"
	"        default \"2000\";\n"
	"        description\n"
	"          \"This is the value of the instability metric at which\n"
	"           route suppression takes place. A route is not installed\n"
	"           in the forwarding information base (FIB), or announced\n"
	"           even if it is reachable during the period that it is\n"
	"           suppressed.\";\n"
	"      }\n"
	"\n"
	"      leaf unreach-decay {\n"
	"        when \"../enable = \'true\'\";\n"
	"        type uint8 {\n"
	"          range \"1..255\";\n"
	"        }\n"
	"        units \"seconds\";\n"
	"        default \"60\";\n"
	"        description\n"
	"          \"This value acts the same as reach-decay except that it\n"
	"           specifies the rate at which the instability metric is\n"
	"           decayed when a route is unreachable. It should have a\n"
	"           value greater than or equal to reach-decay.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping flow-spec-config {\n"
	"    description\n"
	"      \"Grouping for flow spec configuration.\";\n"
	"\n"
	"    container flow-spec-config {\n"
	"      description\n"
	"        \"Flow spec feature.\";\n"
	"      leaf interface {\n"
	"        type frr-interface:interface-ref {\n"
	"          require-instance false;\n"
	"        }\n"
	"        description\n"
	"          \"The local interface.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-graceful-shutdown {\n"
	"    description\n"
	"      \"Structural grouping used to include graceful-shutdown\n"
	"       configuration for both BGP neighbors and peer groups.\";\n"
	"    container graceful-shutdown {\n"
	"      description\n"
	"        \"BGP Graceful shutdown feature.\";\n"
	"      leaf enable {\n"
	"        type boolean;\n"
	"        default \"false\";\n"
	"        description\n"
	"          \"Enable graceful-shutdown feature.\";\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-filter-config {\n"
	"    description\n"
	"      \"Structural grouping used to include filter\n"
	"       configuration for BGP RIB table.\";\n"
	"    container filter-config {\n"
	"      description\n"
	"        \"BGP table to RIB route download filter.\";\n"
	"      uses rmap-policy-export;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping route-distinguisher-params {\n"
	"    description\n"
	"      \"Route distinguisher value as per RFC4364.\";\n"
	"    leaf rd {\n"
	"      type rt-types:route-distinguisher;\n"
	"      description\n"
	"        \"Route distinguisher value as per RFC4364.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping vpn-label-params {\n"
	"    description\n"
	"      \"Label value for VRF.\";\n"
	"    choice label-allocation-mode {\n"
	"      description\n"
	"        \"Choice for label allocation mode (manual or auto).\";\n"
	"\n"
	"      case manual {\n"
	"        leaf label {\n"
	"          type rt-types:mpls-label;\n"
	"          description\n"
	"            \"Label index to associate with the prefix.\";\n"
	"        }\n"
	"      }\n"
	"\n"
	"      case auto {\n"
	"        leaf label-auto {\n"
	"          type boolean;\n"
	"          default \"false\";\n"
	"          description\n"
	"            \"Automatically assign a label.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping vpn-nexthop-params {\n"
	"    description\n"
	"      \"Specify next hop to use for VRF advertised prefixes.\";\n"
	"    leaf nexthop {\n"
	"      type inet:ip-address;\n"
	"      description\n"
	"        \"Nexthop IP address.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping rt-list {\n"
	"    description\n"
	"      \"Route Target list\";\n"
	"    leaf-list import-rt-list {\n"
	"      type rt-types:route-target;\n"
	"      description\n"
	"        \"For routes leaked from vpn to current address-family: match any.\";\n"
	"    }\n"
	"\n"
	"    leaf-list export-rt-list {\n"
	"      type rt-types:route-target;\n"
	"      description\n"
	"        \"For routes leaked from current address-family to vpn: set.\";\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping vpn-route-target-params {\n"
	"    description\n"
	"      \"Route Target value.\";\n"
	"    leaf redirect-rt {\n"
	"      type rt-types:route-target;\n"
	"      description\n"
	"        \"Flow-spec redirect type route target.\";\n"
	"    }\n"
	"\n"
	"    choice rt-direction {\n"
	"        description\n"
	"          \"Choice for route target direction (import, export, or both).\";\n"
	"\n"
	"      case import-export {\n"
	"        uses rt-list;\n"
	"      }\n"
	"\n"
	"      case both {\n"
	"        leaf-list rt-list {\n"
	"          type rt-types:route-target;\n"
	"          description\n"
	"            \"Both import: match any and export: set.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping vpn-import-params {\n"
	"    description\n"
	"      \"VPN route leaking parameters.\";\n"
	"    leaf import-vpn {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Import routes from default instance VPN RIB.\";\n"
	"    }\n"
	"\n"
	"    leaf export-vpn {\n"
	"      type boolean;\n"
	"      default \"false\";\n"
	"      description\n"
	"        \"Export routes to default instance VPN RIB.\";\n"
	"    }\n"
	"\n"
	"    list import-vrf-list {\n"
	"      key \"vrf\";\n"
	"      description\n"
	"        \"List of VRFs to import routes from.\";\n"
	"      leaf vrf {\n"
	"        type frr-vrf:vrf-ref {\n"
	"          require-instance false;\n"
	"        }\n"
	"        description\n"
	"          \"Routing instance.\";\n"
	"      }\n"
	"    }\n"
	"\n"
	"    uses rmap-policy-import;\n"
	"\n"
	"    uses rmap-policy-export;\n"
	"  }\n"
	"\n"
	"  grouping global-afi-safi-vpn-config {\n"
	"    description\n"
	"      \"Grouping for global AFI/SAFI VPN configuration.\";\n"
	"\n"
	"    container vpn-config {\n"
	"      description\n"
	"        \"VPN configuration container.\";\n"
	"\n"
	"      leaf rd {\n"
	"        type string;\n"
	"        description\n"
	"          \"Route distinguisher value as per RFC4364.\";\n"
	"      }\n"
	"\n"
	"      uses vpn-label-params;\n"
	"\n"
	"      uses vpn-nexthop-params;\n"
	"\n"
	"      uses vpn-import-params;\n"
	"\n"
	"      uses vpn-route-target-params;\n"
	"    }\n"
	"  }\n"
	"\n"
	"  grouping global-afi-safi-vpn-network-config {\n"
	"    description\n"
	"      \"Grouping for global AFI/SAFI VPN network configuration.\";\n"
	"\n"
	"    list network-config {\n"
	"      key \"rd\";\n"
	"      description\n"
	"        \"A list of rd.\";\n"
	"      uses route-distinguisher-params;\n"
	"\n"
	"      list prefix-list {\n"
	"        key \"prefix\";\n"
	"        description\n"
	"          \"A list of prefix.\";\n"
	"        leaf prefix {\n"
	"          type inet:ip-prefix;\n"
	"          description\n"
	"            \"IP destination prefix.\";\n"
	"        }\n"
	"\n"
	"        leaf label-index {\n"
	"          type uint32;\n"
	"          mandatory true;\n"
	"          description\n"
	"            \"Label index to associate with the prefix.\";\n"
	"        }\n"
	"\n"
	"        leaf rmap-policy-export {\n"
	"          type frr-route-map:route-map-ref;\n"
	"          description\n"
	"            \"Route-map to modify the attributes for Routes going out\n"
	"             via BGP updates.\";\n"
	"        }\n"
	"      }\n"
	"    }\n"
	"  }\n"
	"}\n"
	"";

static struct yang_module_embed embed = {
	.mod_name = "frr-bgp",
	.mod_rev = "",
	.sub_mod_name = "frr-bgp-common",
	.sub_mod_rev = "2019-12-03",
	.data = model,
	.format = LYS_IN_YANG,
};

static void embed_register(void) __attribute__((_CONSTRUCTOR(2000)));
static void embed_register(void)
{
	yang_module_embed(&embed);
}
