/* watchfrr_ignore_daemon => "[no] watchfrr ignore DAEMON$dname" */
DEFUN_CMD_FUNC_DECL(watchfrr_ignore_daemon)
#define funcdecl_watchfrr_ignore_daemon static int watchfrr_ignore_daemon_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * no,\
	const char * dname)
funcdecl_watchfrr_ignore_daemon;
DEFUN_CMD_FUNC_TEXT(watchfrr_ignore_daemon)
{
#if 2 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *no = NULL;
	const char *dname = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "no")) {
			no = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "dname")) {
			dname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!dname) {
		vty_out(vty, "Internal CLI error [%s]\n", "dname");
		return CMD_WARNING;
	}

	return watchfrr_ignore_daemon_magic(self, vty, argc, argv, no, dname);
}

