/* autogenerated file, DO NOT EDIT! */
#include <zebra.h>

#include "command.h"
#include "linklist.h"

#include "vtysh/vtysh.h"

#pragma GCC visibility push(internal)

#define MAKE_VECTOR(name, len, ...)                        \
        static void * name ## _vitems[] = { __VA_ARGS__ }; \
        static struct _vector name = {                     \
                .active = len,                             \
                .count = len,                              \
                .index = name ## _vitems,                  \
        }

DEFSH (VTYSH_KEYS, accept_lifetime_day_month_day_month_cmd_vtysh,
	"accept-lifetime HH:MM:SS (1-31) MONTH (1993-2035) HH:MM:SS (1-31) MONTH (1993-2035)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Day of th month to expire\n"
	"Month of the year to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, accept_lifetime_day_month_month_day_cmd_vtysh,
	"accept-lifetime HH:MM:SS (1-31) MONTH (1993-2035) HH:MM:SS MONTH (1-31) (1993-2035)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Month of the year to expire\n"
	"Day of th month to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, accept_lifetime_duration_day_month_cmd_vtysh,
	"accept-lifetime HH:MM:SS (1-31) MONTH (1993-2035) duration (1-2147483646)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Duration of the key\n"
	"Duration seconds\n")

DEFSH (VTYSH_KEYS, accept_lifetime_duration_month_day_cmd_vtysh,
	"accept-lifetime HH:MM:SS MONTH (1-31) (1993-2035) duration (1-2147483646)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Duration of the key\n"
	"Duration seconds\n")

DEFSH (VTYSH_KEYS, accept_lifetime_infinite_day_month_cmd_vtysh,
	"accept-lifetime HH:MM:SS (1-31) MONTH (1993-2035) infinite",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Never expires\n")

DEFSH (VTYSH_KEYS, accept_lifetime_infinite_month_day_cmd_vtysh,
	"accept-lifetime HH:MM:SS MONTH (1-31) (1993-2035) infinite",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Never expires\n")

DEFSH (VTYSH_KEYS, accept_lifetime_month_day_day_month_cmd_vtysh,
	"accept-lifetime HH:MM:SS MONTH (1-31) (1993-2035) HH:MM:SS (1-31) MONTH (1993-2035)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Day of th month to expire\n"
	"Month of the year to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, accept_lifetime_month_day_month_day_cmd_vtysh,
	"accept-lifetime HH:MM:SS MONTH (1-31) (1993-2035) HH:MM:SS MONTH (1-31) (1993-2035)",
	"Set accept lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Month of the year to expire\n"
	"Day of th month to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_ACL_CONFIG, access_list_cmd_vtysh,
	"access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <A.B.C.D/M$prefix [exact-match$exact]|any>",
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Prefix to match. e.g. 10.0.0.0/8\n"
	"Exact match of the prefixes\n"
	"Match any IPv4\n")

DEFSH (VTYSH_ACL_CONFIG, access_list_ext_cmd_vtysh,
	"access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action ip <A.B.C.D$src A.B.C.D$src_mask|host A.B.C.D$src|any> <A.B.C.D$dst A.B.C.D$dst_mask|host A.B.C.D$dst|any>",
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"IPv4 address\n"
	"Source address to match\n"
	"Source address mask to apply\n"
	"Single source host\n"
	"Source address to match\n"
	"Any source host\n"
	"Destination address to match\n"
	"Destination address mask to apply\n"
	"Single destination host\n"
	"Destination address to match\n"
	"Any destination host\n")

DEFSH (VTYSH_ACL_CONFIG, access_list_remark_cmd_vtysh,
	"access-list ACCESSLIST4_NAME$name remark LINE...",
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_ACL_CONFIG, access_list_std_cmd_vtysh,
	"access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <[host] A.B.C.D$host|A.B.C.D$host A.B.C.D$mask>",
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"A single host address\n"
	"Address to match\n"
	"Address to match\n"
	"Wildcard bits\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X>",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_cost_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_cost_life_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255) lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_life_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_prefix_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M>",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_prefix_cost_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> cost (0-255)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_prefix_cost_life_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> cost (0-255) lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_mac_vni_prefix_life_cmd_vtysh,
	"add vnc mac X:X:X:X:X:X virtual-network-identifier (1-4294967295) vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify mac address information\n"
	"MAC address\n"
	"Virtual Network Identifier follows\n"
	"Virtual Network Identifier\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X>",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_cost_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_cost_life_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255) lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_cost_life_lnh_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255) lifetime (1-4294967295) LNH_OPTIONS...",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n"
	"[local-next-hop (A.B.C.D|X:X::X:X)] [local-cost <0-255>]\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_cost_lnh_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> cost (0-255) LNH_OPTIONS...",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"[local-next-hop (A.B.C.D|X:X::X:X)] [local-cost <0-255>]\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_life_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lifetime (1-4294967295)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_life_cost_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lifetime (1-4294967295) cost (0-255)",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_life_cost_lnh_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lifetime (1-4294967295) cost (0-255) LNH_OPTIONS...",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n"
	"Administrative cost   [default: 255]\n"
	"Administrative cost\n"
	"[local-next-hop (A.B.C.D|X:X::X:X)] [local-cost <0-255>]\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_life_lnh_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lifetime (1-4294967295) LNH_OPTIONS...",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Registration lifetime [default: infinite]\n"
	"Lifetime value in seconds\n"
	"[local-next-hop (A.B.C.D|X:X::X:X)] [local-cost <0-255>]\n")

DEFSH (VTYSH_BGPD, add_vnc_prefix_lnh_cmd_vtysh,
	"add vnc prefix <A.B.C.D/M|X:X::X:X/M> vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> LNH_OPTIONS...",
	"Add registration\n"
	"VNC Information\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"[local-next-hop (A.B.C.D|X:X::X:X)] [local-cost <0-255>]\n")

DEFSH (VTYSH_BGPD, add_vrf_prefix_rd_label_pref_cmd_vtysh,
	"add vrf NAME prefix <A.B.C.D/M|X:X::X:X/M> [{rd ASN:NN_OR_IP-ADDRESS|label (0-1048575)|preference (0-4294967295)}]",
	"Add\n"
	"To a VRF\n"
	"VRF name\n"
	"Add/modify prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Override configured VRF Route Distinguisher\n"
	"<as-number>:<number> or <ip-address>:<number>\n"
	"Override configured VRF label\n"
	"Label Value <0-1048575>\n"
	"Set advertised local preference\n"
	"local preference (higher=more preferred)\n")

DEFSH (VTYSH_ISISD, advertise_definition_cmd_vtysh,
	"[no] advertise-definition",
	"Negate a command or set its defaults\n"
	"Advertise Local Flexible Algorithm\n")

DEFSH (VTYSH_ISISD, advertise_high_metrics_cmd_vtysh,
	"[no] advertise-high-metrics",
	"Negate a command or set its defaults\n"
	"Advertise high metric value on all interfaces\n")

DEFSH (VTYSH_ISISD, advertise_passive_only_cmd_vtysh,
	"[no] advertise-passive-only",
	"Negate a command or set its defaults\n"
	"Advertise prefixes of passive interfaces only\n")

DEFSH (VTYSH_BGPD, af_import_vrf_route_map_cmd_vtysh,
	"import vrf route-map RMAP$rmap_str",
	"Import routes from another VRF\n"
	"Vrf routes being filtered\n"
	"Specify route map\n"
	"name of route-map\n")

DEFSH (VTYSH_BGPD, af_label_vpn_export_allocation_mode_cmd_vtysh,
	"[no$no] label vpn export allocation-mode <per-vrf$label_per_vrf|per-nexthop$label_per_nh>",
	"Negate a command or set its defaults\n"
	"label value for VRF\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n"
	"Label allocation mode\n"
	"Allocate one label for all BGP updates of the VRF\n"
	"Allocate a label per connected next-hop in the VRF\n")

DEFSH (VTYSH_BGPD, af_label_vpn_export_cmd_vtysh,
	"[no] label vpn export <(0-1048575)$label_val|auto$label_auto>",
	"Negate a command or set its defaults\n"
	"label value for VRF\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n"
	"Label Value <0-1048575>\n"
	"Automatically assign a label\n")

DEFSH (VTYSH_BGPD, af_nexthop_vpn_export_cmd_vtysh,
	"[no] nexthop vpn export [<A.B.C.D|X:X::X:X>$nexthop_su]",
	"Negate a command or set its defaults\n"
	"Specify next hop to use for VRF advertised prefixes\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, af_no_import_vrf_route_map_cmd_vtysh,
	"no import vrf route-map [RMAP$rmap_str]",
	"Negate a command or set its defaults\n"
	"Import routes from another VRF\n"
	"Vrf routes being filtered\n"
	"Specify route map\n"
	"name of route-map\n")

DEFSH (VTYSH_BGPD, af_no_label_vpn_export_cmd_vtysh,
	"no label vpn export",
	"Negate a command or set its defaults\n"
	"label value for VRF\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n")

DEFSH (VTYSH_BGPD, af_no_rd_vpn_export_cmd_vtysh,
	"no rd vpn export",
	"Negate a command or set its defaults\n"
	"Specify route distinguisher\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n")

DEFSH (VTYSH_BGPD, af_no_route_map_vpn_imexport_cmd_vtysh,
	"no route-map vpn <import|export>$direction_str",
	"Negate a command or set its defaults\n"
	"Specify route map\n"
	"Between current address-family and vpn\n"
	"For routes leaked from vpn to current address-family\n"
	"For routes leaked from current address-family to vpn\n")

DEFSH (VTYSH_BGPD, af_no_rt_vpn_imexport_cmd_vtysh,
	"no <rt|route-target> vpn <import|export|both>$direction_str",
	"Negate a command or set its defaults\n"
	"Specify route target list\n"
	"Specify route target list\n"
	"Between current address-family and vpn\n"
	"For routes leaked from vpn to current address-family\n"
	"For routes leaked from current address-family to vpn\n"
	"both import and export\n")

DEFSH (VTYSH_BGPD, af_rd_vpn_export_cmd_vtysh,
	"[no] rd vpn export ASN:NN_OR_IP-ADDRESS:NN$rd_str",
	"Negate a command or set its defaults\n"
	"Specify route distinguisher\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n"
	"Route Distinguisher (<as-number>:<number> | <ip-address>:<number>)\n")

DEFSH (VTYSH_BGPD, af_route_map_vpn_imexport_cmd_vtysh,
	"[no] route-map vpn <import|export>$direction_str RMAP$rmap_str",
	"Negate a command or set its defaults\n"
	"Specify route map\n"
	"Between current address-family and vpn\n"
	"For routes leaked from vpn to current address-family\n"
	"For routes leaked from current address-family to vpn\n"
	"name of route-map\n")

DEFSH (VTYSH_BGPD, af_routetarget_import_cmd_vtysh,
	"[no] <rt|route-target|route-target6|rt6> redirect import RTLIST...",
	"Negate a command or set its defaults\n"
	"Specify route target list\n"
	"Specify route target list\n"
	"Specify route target list\n"
	"Specify route target list\n"
	"Flow-spec redirect type route target\n"
	"Import routes to this address-family\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN|IPV6:MN)\n")

DEFSH (VTYSH_BGPD, af_rt_vpn_imexport_cmd_vtysh,
	"[no] <rt|route-target> vpn <import|export|both>$direction_str RTLIST...",
	"Negate a command or set its defaults\n"
	"Specify route target list\n"
	"Specify route target list\n"
	"Between current address-family and vpn\n"
	"For routes leaked from vpn to current address-family: match any\n"
	"For routes leaked from current address-family to vpn: set\n"
	"both import: match any and export: set\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, af_sid_vpn_export_cmd_vtysh,
	"[no] sid vpn export <(1-1048575)$sid_idx|auto$sid_auto|explicit$sid_explicit X:X::X:X$sid_value>",
	"Negate a command or set its defaults\n"
	"sid value for VRF\n"
	"Between current address-family and vpn\n"
	"For routes leaked from current address-family to vpn\n"
	"Sid allocation index\n"
	"Automatically assign a label\n"
	"Explicitly assign a sid value\n"
	"Sid value\n")

DEFSH (VTYSH_ISISD, affinity_exclude_any_cmd_vtysh,
	"[no] affinity exclude-any NAME...",
	"Negate a command or set its defaults\n"
	"Affinity configuration\n"
	"Any Exclude with\n"
	"Exclude NAME list\n")

DEFSH (VTYSH_ISISD, affinity_include_all_cmd_vtysh,
	"[no] affinity include-all NAME...",
	"Negate a command or set its defaults\n"
	"Affinity configuration\n"
	"All Include with\n"
	"Include NAME list\n")

DEFSH (VTYSH_ISISD, affinity_include_any_cmd_vtysh,
	"[no] affinity include-any NAME...",
	"Negate a command or set its defaults\n"
	"Affinity configuration\n"
	"Any Include with\n"
	"Include NAME list\n")

DEFSH (VTYSH_BGPD|VTYSH_ISISD|VTYSH_OSPF6D|VTYSH_OSPFD|VTYSH_RIPD|VTYSH_ZEBRA, agentx_enable_cmd_vtysh,
	"agentx",
	"SNMP AgentX protocol settings\n")

DEFSH (VTYSH_BGPD, aggregate_addressv4_cmd_vtysh,
	"[no] aggregate-address <A.B.C.D/M$prefix|A.B.C.D$addr A.B.C.D$mask> [{as-set$as_set_s|summary-only$summary_only|route-map RMAP_NAME$rmap_name|origin <egp|igp|incomplete>$origin_s|matching-MED-only$match_med|suppress-map RMAP_NAME$suppress_map}]",
	"Negate a command or set its defaults\n"
	"Configure BGP aggregate entries\n"
	"Aggregate prefix\n"
	"Aggregate address\n"
	"Aggregate mask\n"
	"Generate AS set path information\n"
	"Filter more specific routes from updates\n"
	"Apply route map to aggregate network\n"
	"Route map name\n"
	"BGP origin code\n"
	"Remote EGP\n"
	"Local IGP\n"
	"Unknown heritage\n"
	"Only aggregate routes with matching MED\n"
	"Suppress the selected more specific routes\n"
	"Route map with the route selectors\n")

DEFSH (VTYSH_BGPD, aggregate_addressv6_cmd_vtysh,
	"[no] aggregate-address X:X::X:X/M$prefix [{as-set$as_set_s|summary-only$summary_only|route-map RMAP_NAME$rmap_name|origin <egp|igp|incomplete>$origin_s|matching-MED-only$match_med|suppress-map RMAP_NAME$suppress_map}]",
	"Negate a command or set its defaults\n"
	"Configure BGP aggregate entries\n"
	"Aggregate prefix\n"
	"Generate AS set path information\n"
	"Filter more specific routes from updates\n"
	"Apply route map to aggregate network\n"
	"Route map name\n"
	"BGP origin code\n"
	"Remote EGP\n"
	"Local IGP\n"
	"Unknown heritage\n"
	"Only aggregate routes with matching MED\n"
	"Suppress the selected more specific routes\n"
	"Route map with the route selectors\n")

DEFSH (VTYSH_ZEBRA, allow_external_route_update_cmd_vtysh,
	"allow-external-route-update",
	"Allow FRR routes to be overwritten by external processes\n")

DEFSH (VTYSH_NON_MGMTD, allow_reserved_ranges_cmd_vtysh,
	"[no] allow-reserved-ranges",
	"Negate a command or set its defaults\n"
	"Allow using IPv4 (Class E) reserved IP space\n")

DEFSH (VTYSH_OSPF6D, area_export_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> export-list ACCESSLIST6_NAME",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Set the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPF6D, area_filter_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> filter-list prefix PREFIXLIST6_NAME <in|out>",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Filter networks between OSPF6 areas\n"
	"Filter prefixes between OSPF6 areas\n"
	"Name of an IPv6 prefix-list\n"
	"Filter networks sent to this area\n"
	"Filter networks sent from this area\n")

DEFSH (VTYSH_OSPF6D, area_import_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> import-list ACCESSLIST6_NAME",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Set the filter for networks from other areas announced to the specified one\n"
	"Name of the access-list\n")

DEFSH (VTYSH_ISISD, area_lsp_mtu_cmd_vtysh,
	"lsp-mtu (128-4352)$val",
	"Configure the maximum size of generated LSPs\n"
	"Maximum size of generated LSPs\n")

DEFSH (VTYSH_OSPF6D, area_nssa_range_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)>$area nssa range X:X::X:X/M$prefix [<not-advertise$not_adv|cost (0-16777215)$cost>]",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as nssa\n"
	"Configured address range\n"
	"Specify IPv6 prefix\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_ISISD, area_passwd_cmd_vtysh,
	"area-password <clear|md5>$pwd_type WORD$pwd [authenticate snp <send-only|validate>$snp]",
	"Configure the authentication password for an area\n"
	"Clear-text authentication type\n"
	"MD5 authentication type\n"
	"Level-wide password\n"
	"Authentication\n"
	"SNP PDUs\n"
	"Send but do not check PDUs on receiving\n"
	"Send and check PDUs on receiving\n")

DEFSH (VTYSH_ISISD, area_purge_originator_cmd_vtysh,
	"[no] purge-originator",
	"Negate a command or set its defaults\n"
	"Use the RFC 6232 purge-originator\n")

DEFSH (VTYSH_OSPF6D, area_range_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> range X:X::X:X/M [<advertise|not-advertise|cost (0-16777215)>]",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configured address range\n"
	"Specify IPv6 prefix\n"
	"Advertise\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_ISISD, attached_bit_receive_ignore_cmd_vtysh,
	"[no] attached-bit receive ignore",
	"Reset attached bit\n"
	"Set attach bit for inter-area traffic\n"
	"If LSP received with attached bit set, create default route to neighbor\n"
	"Do not process attached bit\n")

DEFSH (VTYSH_ISISD, attached_bit_send_cmd_vtysh,
	"[no] attached-bit send",
	"Reset attached bit\n"
	"Set attached bit for inter-area traffic\n"
	"Set attached bit in LSP sent to L1 router\n")

DEFSH (VTYSH_OSPF6D, auto_cost_reference_bandwidth_cmd_vtysh,
	"auto-cost reference-bandwidth (1-4294967)",
	"Calculate OSPF interface cost according to bandwidth\n"
	"Use reference bandwidth method to assign OSPF cost\n"
	"The reference bandwidth in terms of Mbits per second\n")

DEFSH (VTYSH_BABELD, babel_distribute_list_cmd_vtysh,
	"distribute-list ACCESSLIST4_NAME <in|out> [WORD]",
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_distribute_list_prefix_cmd_vtysh,
	"distribute-list prefix PREFIXLIST4_NAME <in|out> [WORD]",
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_diversity_cmd_vtysh,
	"babel diversity",
	"Babel commands\n"
	"Enable diversity-aware routing.\n")

DEFSH (VTYSH_BABELD, babel_diversity_factor_cmd_vtysh,
	"[no] babel diversity-factor (1-256)$factor",
	"Negate a command or set its defaults\n"
	"Babel commands\n"
	"Set the diversity factor.\n"
	"Factor in units of 1/256.\n")

DEFSH (VTYSH_BABELD, babel_ipv6_distribute_list_cmd_vtysh,
	"ipv6 distribute-list ACCESSLIST6_NAME <in|out> [WORD]",
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_ipv6_distribute_list_prefix_cmd_vtysh,
	"ipv6 distribute-list prefix PREFIXLIST6_NAME <in|out> [WORD]",
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_network_cmd_vtysh,
	"network IF_OR_ADDR",
	"Enable Babel protocol on specified interface or network.\n"
	"Interface or address\n")

DEFSH (VTYSH_BABELD, babel_no_distribute_list_cmd_vtysh,
	"no distribute-list ACCESSLIST4_NAME <in|out> [WORD]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_no_distribute_list_prefix_cmd_vtysh,
	"no distribute-list prefix PREFIXLIST4_NAME <in|out> [WORD]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_no_ipv6_distribute_list_cmd_vtysh,
	"no ipv6 distribute-list ACCESSLIST6_NAME <in|out> [WORD]",
	"Negate a command or set its defaults\n"
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_no_ipv6_distribute_list_prefix_cmd_vtysh,
	"no ipv6 distribute-list prefix PREFIXLIST6_NAME <in|out> [WORD]",
	"Negate a command or set its defaults\n"
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_BABELD, babel_redistribute_type_cmd_vtysh,
	"[no] redistribute <ipv4 <kernel|connected|local|static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|openfabric>|ipv6 <kernel|connected|local|static|ripng|ospf6|isis|bgp|nhrp|vnc|openfabric>>",
	"Negate a command or set its defaults\n"
	"Redistribute\n"
	"Redistribute IPv4 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"OpenFabric Routing Protocol\n"
	"Redistribute IPv6 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_BABELD, babel_set_channel_cmd_vtysh,
	"[no] babel channel <(1-254)$ch|interfering$interfering|noninterfering$noninterfering>",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Channel number for diversity routing\n"
	"Number\n"
	"Mark channel as interfering\n"
	"Mark channel as noninterfering\n")

DEFSH (VTYSH_BABELD, babel_set_enable_timestamps_cmd_vtysh,
	"[no] babel enable-timestamps",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Enable timestamps\n")

DEFSH (VTYSH_BABELD, babel_set_hello_interval_cmd_vtysh,
	"[no] babel hello-interval (20-655340)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Time between scheduled hellos\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_max_rtt_penalty_cmd_vtysh,
	"[no] babel max-rtt-penalty (0-65535)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Maximum additional cost due to RTT\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_resend_delay_cmd_vtysh,
	"[no] babel resend-delay (20-655340)$delay",
	"Negate a command or set its defaults\n"
	"Babel commands\n"
	"Time before resending a message\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_rtt_decay_cmd_vtysh,
	"[no] babel rtt-decay (1-256)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Decay factor for exponential moving average of RTT samples\n"
	"Units of 1/256\n")

DEFSH (VTYSH_BABELD, babel_set_rtt_max_cmd_vtysh,
	"[no] babel rtt-max (1-65535)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Maximum RTT\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_rtt_min_cmd_vtysh,
	"[no] babel rtt-min (1-65535)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Minimum RTT starting for increasing cost\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_rxcost_cmd_vtysh,
	"[no] babel rxcost (1-65534)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Rxcost multiplier\n"
	"Units\n")

DEFSH (VTYSH_BABELD, babel_set_smoothing_half_life_cmd_vtysh,
	"[no] babel smoothing-half-life (0-65534)$seconds",
	"Negate a command or set its defaults\n"
	"Babel commands\n"
	"Smoothing half-life\n"
	"Seconds (0 to disable)\n")

DEFSH (VTYSH_BABELD, babel_set_update_interval_cmd_vtysh,
	"[no] babel update-interval (20-655340)",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Time between scheduled updates\n"
	"Milliseconds\n")

DEFSH (VTYSH_BABELD, babel_set_wired_cmd_vtysh,
	"[no] babel wired",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Enable wired optimizations\n")

DEFSH (VTYSH_BABELD, babel_set_wireless_cmd_vtysh,
	"[no] babel wireless",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Disable wired optimizations (assume wireless)\n")

DEFSH (VTYSH_BABELD, babel_split_horizon_cmd_vtysh,
	"[no] babel split-horizon",
	"Negate a command or set its defaults\n"
	"Babel interface commands\n"
	"Enable split horizon processing\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, backup_nexthop_recursive_use_enable_cmd_vtysh,
	"[no] zebra nexthop resolve-via-backup",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Nexthop configuration \n"
	"Configure use of backup nexthops in recursive resolution\n")

DEFSH (VTYSH_MGMTD, bandwidth_if_cmd_vtysh,
	"[no] bandwidth ![(1-1000000)]$bw",
	"Negate a command or set its defaults\n"
	"Set bandwidth informational parameter\n"
	"Bandwidth in megabits\n")

DEFSH (VTYSH_BFDD, bfd_clear_counters_by_bfdname_cmd_vtysh,
	"clear bfd [vrf NAME$vrfname] bfd-name BFDNAME$bfdname counters",
	"Reset functions\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"clear BFD peer counters information\n")

DEFSH (VTYSH_BFDD, bfd_clear_peer_counters_cmd_vtysh,
	"clear bfd [vrf <NAME$vrfname>] peer <WORD$label|<A.B.C.D|X:X::X:X>$peer [{multihop|local-address <A.B.C.D|X:X::X:X>$local|interface IFNAME$ifname}]> counters",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"Peer label\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Interface information\n"
	"Configure local interface name to use\n"
	"clear BFD peer counters information\n")

DEFSH (VTYSH_BFDD, bfd_config_reset_cmd_vtysh,
	"no bfd",
	"Negate a command or set its defaults\n"
	"Configure BFD peers\n")

DEFSH (VTYSH_BFDD, bfd_debug_distributed_cmd_vtysh,
	"[no] debug bfd distributed",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Bidirection Forwarding Detection\n"
	"BFD data plane (distributed BFD) debugging\n")

DEFSH (VTYSH_BFDD, bfd_debug_network_cmd_vtysh,
	"[no] debug bfd network",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Bidirection Forwarding Detection\n"
	"Network layer debugging\n")

DEFSH (VTYSH_BFDD, bfd_debug_peer_cmd_vtysh,
	"[no] debug bfd peer",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Bidirection Forwarding Detection\n"
	"Peer events debugging\n")

DEFSH (VTYSH_BFDD, bfd_debug_zebra_cmd_vtysh,
	"[no] debug bfd zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Bidirection Forwarding Detection\n"
	"Zebra events debugging\n")

DEFSH (VTYSH_BFDD, bfd_no_peer_cmd_vtysh,
	"no peer <A.B.C.D|X:X::X:X> [{multihop$multihop|local-address <A.B.C.D|X:X::X:X>|interface IFNAME$ifname|vrf NAME}]",
	"Negate a command or set its defaults\n"
	"Configure peer\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Interface information\n"
	"Configure local interface name to use\n"
	"Configure VRF\n"
	"Configure VRF name\n")

DEFSH (VTYSH_BFDD, bfd_peer_echo_cmd_vtysh,
	"[no] echo-mode",
	"Negate a command or set its defaults\n"
	"Configure echo mode\n")

DEFSH (VTYSH_BFDD, bfd_peer_echo_interval_cmd_vtysh,
	"[no] echo-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer echo intervals\n"
	"Configure peer echo rx/tx intervals value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_peer_echo_receive_interval_cmd_vtysh,
	"[no] echo receive-interval ![<disabled$disabled|(10-4294967)$interval>]",
	"Negate a command or set its defaults\n"
	"Configure peer echo intervals\n"
	"Configure required receive interval\n"
	"Disable echo packets receive\n"
	"Configure interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_peer_echo_transmit_interval_cmd_vtysh,
	"[no] echo transmit-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer echo intervals\n"
	"Configure desired transmit interval\n"
	"Configure interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_peer_log_session_changes_cmd_vtysh,
	"[no] log-session-changes",
	"Negate a command or set its defaults\n"
	"Log Up/Down changes for the session\n")

DEFSH (VTYSH_BFDD, bfd_peer_minimum_ttl_cmd_vtysh,
	"[no] minimum-ttl (1-254)$ttl",
	"Negate a command or set its defaults\n"
	"Expect packets with at least this TTL\n"
	"Minimum TTL expected\n")

DEFSH (VTYSH_BFDD, bfd_peer_mult_cmd_vtysh,
	"[no] detect-multiplier ![(1-255)$multiplier]",
	"Negate a command or set its defaults\n"
	"Configure peer detection multiplier\n"
	"Configure peer detection multiplier value\n")

DEFSH (VTYSH_BFDD, bfd_peer_passive_cmd_vtysh,
	"[no] passive-mode",
	"Negate a command or set its defaults\n"
	"Don't attempt to start sessions\n")

DEFSH (VTYSH_BFDD, bfd_peer_profile_cmd_vtysh,
	"[no] profile BFDPROF$pname",
	"Negate a command or set its defaults\n"
	"Use BFD profile settings\n"
	"BFD profile name.\n")

DEFSH (VTYSH_BFDD, bfd_peer_rx_cmd_vtysh,
	"[no] receive-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer receive interval\n"
	"Configure peer receive interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_peer_shutdown_cmd_vtysh,
	"[no] shutdown",
	"Negate a command or set its defaults\n"
	"Disable BFD peer\n")

DEFSH (VTYSH_BFDD, bfd_peer_tx_cmd_vtysh,
	"[no] transmit-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer transmit interval\n"
	"Configure peer transmit interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_profile_echo_cmd_vtysh,
	"[no] echo-mode",
	"Negate a command or set its defaults\n"
	"Configure echo mode\n")

DEFSH (VTYSH_BFDD, bfd_profile_echo_interval_cmd_vtysh,
	"[no] echo-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer echo interval\n"
	"Configure peer echo interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_profile_echo_receive_interval_cmd_vtysh,
	"[no] echo receive-interval ![<disabled$disabled|(10-4294967)$interval>]",
	"Negate a command or set its defaults\n"
	"Configure peer echo intervals\n"
	"Configure required receive interval\n"
	"Disable echo packets receive\n"
	"Configure interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_profile_echo_transmit_interval_cmd_vtysh,
	"[no] echo transmit-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer echo intervals\n"
	"Configure desired transmit interval\n"
	"Configure interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_profile_log_session_changes_cmd_vtysh,
	"[no] log-session-changes",
	"Negate a command or set its defaults\n"
	"Log Up/Down session changes in the profile\n")

DEFSH (VTYSH_BFDD, bfd_profile_minimum_ttl_cmd_vtysh,
	"[no] minimum-ttl (1-254)$ttl",
	"Negate a command or set its defaults\n"
	"Expect packets with at least this TTL\n"
	"Minimum TTL expected\n")

DEFSH (VTYSH_BFDD, bfd_profile_mult_cmd_vtysh,
	"[no] detect-multiplier ![(1-255)$multiplier]",
	"Negate a command or set its defaults\n"
	"Configure peer detection multiplier\n"
	"Configure peer detection multiplier value\n")

DEFSH (VTYSH_BFDD, bfd_profile_passive_cmd_vtysh,
	"[no] passive-mode",
	"Negate a command or set its defaults\n"
	"Don't attempt to start sessions\n")

DEFSH (VTYSH_BFDD, bfd_profile_rx_cmd_vtysh,
	"[no] receive-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer receive interval\n"
	"Configure peer receive interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_profile_shutdown_cmd_vtysh,
	"[no] shutdown",
	"Negate a command or set its defaults\n"
	"Disable BFD peer\n")

DEFSH (VTYSH_BFDD, bfd_profile_tx_cmd_vtysh,
	"[no] transmit-interval ![(10-4294967)$interval]",
	"Negate a command or set its defaults\n"
	"Configure peer transmit interval\n"
	"Configure peer transmit interval value in milliseconds\n")

DEFSH (VTYSH_BFDD, bfd_show_by_bfdname_cmd_vtysh,
	"show bfd [vrf NAME$vrf_name] bfd-name BFDNAME$bfdname [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_counters_by_bfdname_cmd_vtysh,
	"show bfd [vrf NAME$vrf_name] bfd-name BFDNAME$bfdname counters [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"Show BFD peer counters information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_peer_cmd_vtysh,
	"show bfd [vrf NAME$vrf_name] peer <WORD$label|<A.B.C.D|X:X::X:X>$peer [{multihop|local-address <A.B.C.D|X:X::X:X>$local|interface IFNAME$ifname}]> [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"Peer label\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Interface information\n"
	"Configure local interface name to use\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_peer_counters_cmd_vtysh,
	"show bfd [vrf NAME$vrf_name] peer <WORD$label|<A.B.C.D|X:X::X:X>$peer [{multihop|local-address <A.B.C.D|X:X::X:X>$local|interface IFNAME$ifname}]> counters [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"Peer label\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Interface information\n"
	"Configure local interface name to use\n"
	"Show BFD peer counters information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_peers_brief_cmd_vtysh,
	"show bfd [vrf <NAME$vrfname>] peers brief [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"Show BFD peer information in tabular form\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_peers_cmd_vtysh,
	"show bfd [vrf NAME] peers [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BFDD, bfd_show_peers_counters_cmd_vtysh,
	"show bfd [vrf NAME] peers counters [json]",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"BFD peers status\n"
	"Show BFD peer counters information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, bgp_administrative_reset_cmd_vtysh,
	"[no$no] bgp hard-administrative-reset",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Send Hard Reset CEASE Notification for 'Administrative Reset'\n")

DEFSH (VTYSH_BGPD, bgp_allow_martian_cmd_vtysh,
	"[no]$no bgp allow-martian-nexthop",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Allow Martian nexthops to be received in the NLRI from a peer\n")

DEFSH (VTYSH_BGPD, bgp_always_compare_med_cmd_vtysh,
	"bgp always-compare-med",
	"BGP information\n"
	"Allow comparing MED from different neighbors\n")

DEFSH (VTYSH_BGPD, bgp_as_path_cmd_vtysh,
	"bgp as-path access-list AS_PATH_FILTER_NAME [seq (0-4294967295)] <deny|permit> LINE...",
	"BGP information\n"
	"BGP autonomous system path filter\n"
	"Specify an access list name\n"
	"Regular expression access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"A regular-expression (1234567890_^|[,{}() ]$*+.?-\\) to match the BGP AS paths\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_aigp_cmd_vtysh,
	"[no$no] bgp bestpath aigp",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Evaluate the AIGP attribute during the best path selection process\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_aspath_confed_cmd_vtysh,
	"bgp bestpath as-path confed",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Compare path lengths including confederation sets & sequences in selecting a route\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_aspath_ignore_cmd_vtysh,
	"bgp bestpath as-path ignore",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Ignore as-path length in selecting a route\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_aspath_multipath_relax_cmd_vtysh,
	"bgp bestpath as-path multipath-relax [<as-set|no-as-set>]",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Allow load sharing across routes that have different AS paths (but same length)\n"
	"Generate an AS_SET\n"
	"Do not generate an AS_SET\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_bw_cmd_vtysh,
	"bgp bestpath bandwidth <ignore|skip-missing|default-weight-for-missing>$bw_cfg",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Link Bandwidth attribute\n"
	"Ignore link bandwidth (i.e., do regular ECMP, not weighted)\n"
	"Ignore paths without link bandwidth for ECMP (if other paths have it)\n"
	"Assign a low default weight (value 1) to paths not having link bandwidth\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_compare_router_id_cmd_vtysh,
	"bgp bestpath compare-routerid",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Compare router-id for identical EBGP paths\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_med_cmd_vtysh,
	"bgp bestpath med <confed [missing-as-worst]|missing-as-worst [confed]>",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"MED attribute\n"
	"Compare MED among confederation paths\n"
	"Treat missing MED as the least preferred one\n"
	"Treat missing MED as the least preferred one\n"
	"Compare MED among confederation paths\n")

DEFSH (VTYSH_BGPD, bgp_bestpath_peer_type_multipath_relax_cmd_vtysh,
	"bgp bestpath peer-type multipath-relax",
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Peer type\n"
	"Allow load sharing across routes learned from different peer types\n")

DEFSH (VTYSH_BGPD, bgp_client_to_client_reflection_cmd_vtysh,
	"bgp client-to-client reflection",
	"BGP information\n"
	"Configure client to client route reflection\n"
	"reflection of routes allowed\n")

DEFSH (VTYSH_BGPD, bgp_cluster_id_cmd_vtysh,
	"bgp cluster-id <A.B.C.D|(1-4294967295)>",
	"BGP information\n"
	"Configure Route-Reflector Cluster-id\n"
	"Route-Reflector Cluster-id in IP address format\n"
	"Route-Reflector Cluster-id as 32 bit quantity\n")

DEFSH (VTYSH_BGPD, bgp_coalesce_time_cmd_vtysh,
	"coalesce-time (0-4294967295)",
	"Subgroup coalesce timer\n"
	"Subgroup coalesce timer value (in ms)\n")

DEFSH (VTYSH_BGPD, bgp_community_alias_cmd_vtysh,
	"[no$no] bgp community alias WORD$community ALIAS_NAME$alias_name",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add community specific parameters\n"
	"Create an alias for a community\n"
	"Community (AA:BB or AA:BB:CC)\n"
	"Alias name\n")

DEFSH (VTYSH_BGPD, bgp_community_list_expanded_all_cmd_vtysh,
	"bgp community-list <(100-500)|expanded COMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (expanded)\n"
	"Add an expanded community-list entry\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, bgp_community_list_standard_cmd_vtysh,
	"bgp community-list <(1-99)|standard COMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (standard)\n"
	"Add an standard community-list entry\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, bgp_condadv_period_cmd_vtysh,
	"[no$no] bgp conditional-advertisement timer (5-240)$period",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Conditional advertisement settings\n"
	"Set period to rescan BGP table to check if condition is met\n"
	"Period between BGP table scans, in seconds; default 60\n")

DEFSH (VTYSH_BGPD, bgp_confederation_identifier_cmd_vtysh,
	"bgp confederation identifier ASNUM",
	"BGP information\n"
	"AS confederation parameters\n"
	"Set routing domain confederation AS\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, bgp_confederation_peers_cmd_vtysh,
	"bgp confederation peers ASNUM...",
	"BGP information\n"
	"AS confederation parameters\n"
	"Peer ASs in BGP confederation\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, bgp_damp_set_cmd_vtysh,
	"bgp dampening [(1-45) [(1-20000) (1-50000) (1-255)]]",
	"BGP Specific commands\n"
	"Enable route-flap dampening\n"
	"Half-life time for the penalty\n"
	"Value to start reusing a route\n"
	"Value to start suppressing a route\n"
	"Maximum duration to suppress a stable route\n")

DEFSH (VTYSH_BGPD, bgp_damp_unset_cmd_vtysh,
	"no bgp dampening [(1-45) [(1-20000) (1-50000) (1-255)]]",
	"Negate a command or set its defaults\n"
	"BGP Specific commands\n"
	"Enable route-flap dampening\n"
	"Half-life time for the penalty\n"
	"Value to start reusing a route\n"
	"Value to start suppressing a route\n"
	"Maximum duration to suppress a stable route\n")

DEFSH (VTYSH_BGPD, bgp_def_originate_eval_cmd_vtysh,
	"[no$no] bgp default-originate timer (0-65535)$timer",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Control default-originate\n"
	"Set period to rescan BGP table to check if default-originate condition is met\n"
	"Period between BGP table scans, in seconds; default 5\n")

DEFSH (VTYSH_BGPD, bgp_default_afi_safi_cmd_vtysh,
	"[no] bgp default <ipv4-unicast|ipv4-multicast|ipv4-vpn|ipv4-labeled-unicast|ipv4-flowspec|ipv6-unicast|ipv6-multicast|ipv6-vpn|ipv6-labeled-unicast|ipv6-flowspec|l2vpn-evpn>$afi_safi",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Activate ipv4-unicast for a peer by default\n"
	"Activate ipv4-multicast for a peer by default\n"
	"Activate ipv4-vpn for a peer by default\n"
	"Activate ipv4-labeled-unicast for a peer by default\n"
	"Activate ipv4-flowspec for a peer by default\n"
	"Activate ipv6-unicast for a peer by default\n"
	"Activate ipv6-multicast for a peer by default\n"
	"Activate ipv6-vpn for a peer by default\n"
	"Activate ipv6-labeled-unicast for a peer by default\n"
	"Activate ipv6-flowspec for a peer by default\n"
	"Activate l2vpn-evpn for a peer by default\n")

DEFSH (VTYSH_BGPD, bgp_default_dynamic_capability_cmd_vtysh,
	"[no] bgp default dynamic-capability",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Advertise dynamic capability for all neighbors\n")

DEFSH (VTYSH_BGPD, bgp_default_link_local_capability_cmd_vtysh,
	"[no] bgp default link-local-capability",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Advertise Link-Local Next Hop capability for all neighbors\n")

DEFSH (VTYSH_BGPD, bgp_default_local_preference_cmd_vtysh,
	"bgp default local-preference (0-4294967295)",
	"BGP information\n"
	"Configure BGP defaults\n"
	"local preference (higher=more preferred)\n"
	"Configure default local preference value\n")

DEFSH (VTYSH_BGPD, bgp_default_show_hostname_cmd_vtysh,
	"bgp default show-hostname",
	"BGP information\n"
	"Configure BGP defaults\n"
	"Show hostname in certain command outputs\n")

DEFSH (VTYSH_BGPD, bgp_default_show_nexthop_hostname_cmd_vtysh,
	"bgp default show-nexthop-hostname",
	"BGP information\n"
	"Configure BGP defaults\n"
	"Show hostname for nexthop in certain command outputs\n")

DEFSH (VTYSH_BGPD, bgp_default_shutdown_cmd_vtysh,
	"[no] bgp default shutdown",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Apply administrative shutdown to newly configured peers\n")

DEFSH (VTYSH_BGPD, bgp_default_software_version_capability_cmd_vtysh,
	"[no] bgp default software-version-capability",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Advertise software version capability for all neighbors\n")

DEFSH (VTYSH_BGPD, bgp_default_subgroup_pkt_queue_max_cmd_vtysh,
	"bgp default subgroup-pkt-queue-max (20-100)",
	"BGP information\n"
	"Configure BGP defaults\n"
	"subgroup-pkt-queue-max\n"
	"Configure subgroup packet queue max\n")

DEFSH (VTYSH_BGPD, bgp_deterministic_med_cmd_vtysh,
	"bgp deterministic-med",
	"BGP information\n"
	"Pick the best-MED path among paths advertised from the neighboring AS\n")

DEFSH (VTYSH_BGPD, bgp_disable_connected_route_check_cmd_vtysh,
	"bgp disable-ebgp-connected-route-check",
	"BGP information\n"
	"Disable checking if nexthop is connected on ebgp sessions\n")

DEFSH (VTYSH_BGPD, bgp_distance_cmd_vtysh,
	"distance bgp (1-255) (1-255) (1-255)",
	"Define an administrative distance\n"
	"BGP distance\n"
	"Distance for routes external to the AS\n"
	"Distance for routes internal to the AS\n"
	"Distance for local routes\n")

DEFSH (VTYSH_BGPD, bgp_distance_source_access_list_cmd_vtysh,
	"distance (1-255) A.B.C.D/M WORD",
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n"
	"Access list name\n")

DEFSH (VTYSH_BGPD, bgp_distance_source_cmd_vtysh,
	"distance (1-255) A.B.C.D/M",
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n")

DEFSH (VTYSH_BGPD, bgp_ebgp_requires_policy_cmd_vtysh,
	"bgp ebgp-requires-policy",
	"BGP information\n"
	"Require in and out policy for eBGP peers (RFC8212)\n")

DEFSH (VTYSH_BGPD, bgp_enforce_first_as_cmd_vtysh,
	"[no] bgp enforce-first-as",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Enforce the first AS for EBGP routes\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_all_vni_cmd_vtysh,
	"advertise-all-vni",
	"Advertise All local VNIs\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_autort_rfc8365_cmd_vtysh,
	"autort rfc8365-compatible",
	"Auto-derivation of RT\n"
	"Auto-derivation of RT using RFC8365\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_default_gw_cmd_vtysh,
	"advertise-default-gw",
	"Advertise All default g/w mac-ip routes in EVPN\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_default_gw_vni_cmd_vtysh,
	"advertise-default-gw",
	"Advertise default g/w mac-ip routes in EVPN for a VNI\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_pip_ip_mac_cmd_vtysh,
	"[no$no] advertise-pip [ip <A.B.C.D> [mac <X:X:X:X:X:X|X:X:X:X:X:X/M>]]",
	"Negate a command or set its defaults\n"
	"evpn system primary IP\n"
	"IP information\n"
	"ip address\n"
	"MAC address\n"
	"MAC address\n"
	"MAC address\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_svi_ip_cmd_vtysh,
	"[no$no] advertise-svi-ip",
	"Negate a command or set its defaults\n"
	"Advertise svi mac-ip routes in EVPN\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_svi_ip_vni_cmd_vtysh,
	"[no$no] advertise-svi-ip",
	"Negate a command or set its defaults\n"
	"Advertise svi mac-ip routes in EVPN for a VNI\n")

DEFSH (VTYSH_BGPD, bgp_evpn_advertise_type5_cmd_vtysh,
	"advertise <ipv4|ipv6><unicast|multicast|vpn> [gateway-ip] [route-map RMAP_NAME]",
	"Advertise prefix routes\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"advertise gateway IP overlay index\n"
	"route-map for filtering specific routes\n"
	"Name of the route map\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_evpn_advertise_vni_subnet_cmd_vtysh,
	"advertise-subnet",
	"Advertise the subnet corresponding to VNI\n")

DEFSH (VTYSH_BGPD, bgp_evpn_default_originate_cmd_vtysh,
	"default-originate <ipv4 | ipv6>",
	"originate a default route\n"
	"ipv4 address family\n"
	"ipv6 address family\n")

DEFSH (VTYSH_BGPD, bgp_evpn_ead_es_frag_evi_limit_cmd_vtysh,
	"[no$no] ead-es-frag evi-limit (1-1000)$limit",
	"Negate a command or set its defaults\n"
	"EAD ES fragment config\n"
	"EVIs per-fragment\n"
	"limit\n")

DEFSH (VTYSH_BGPD, bgp_evpn_ead_es_rt_cmd_vtysh,
	"ead-es-route-target export RT",
	"EAD ES Route Target\n"
	"export\n"
	"Route target (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, bgp_evpn_ead_evi_rx_disable_cmd_vtysh,
	"[no$no] disable-ead-evi-rx",
	"Negate a command or set its defaults\n"
	"Activate PE on EAD-ES even if EAD-EVI is not received\n")

DEFSH (VTYSH_BGPD, bgp_evpn_ead_evi_tx_disable_cmd_vtysh,
	"[no$no] disable-ead-evi-tx",
	"Negate a command or set its defaults\n"
	"Don't advertise EAD-EVI for local ESs\n")

DEFSH (VTYSH_BGPD, bgp_evpn_enable_resolve_overlay_index_cmd_vtysh,
	"[no$no] enable-resolve-overlay-index",
	"Negate a command or set its defaults\n"
	"Enable Recursive Resolution of type-5 route overlay index\n")

DEFSH (VTYSH_BGPD, bgp_evpn_flood_control_cmd_vtysh,
	"[no$no] flooding <disable$disable|head-end-replication$her>",
	"Negate a command or set its defaults\n"
	"Specify handling for BUM packets\n"
	"Do not flood any BUM packets\n"
	"Flood BUM packets using head-end replication\n")

DEFSH (VTYSH_BGPD, bgp_evpn_flood_control_vni_cmd_vtysh,
	"[no$no] flooding <disable$disable|head-end-replication$her>",
	"Negate a command or set its defaults\n"
	"Specify handling for BUM packets\n"
	"Do not flood any BUM packets\n"
	"Flood BUM packets using head-end replication\n")

DEFSH (VTYSH_BGPD, bgp_evpn_use_es_l3nhg_cmd_vtysh,
	"[no$no] use-es-l3nhg",
	"Negate a command or set its defaults\n"
	"use L3 nexthop group for host routes with ES destination\n")

DEFSH (VTYSH_BGPD, bgp_evpn_vni_rd_cmd_vtysh,
	"rd ASN:NN_OR_IP-ADDRESS:NN",
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, bgp_evpn_vni_rt_cmd_vtysh,
	"route-target <both|import|export> RT",
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"Route target (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, bgp_evpn_vrf_rd_cmd_vtysh,
	"rd ASN:NN_OR_IP-ADDRESS:NN",
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, bgp_evpn_vrf_rt_auto_cmd_vtysh,
	"route-target <both|import|export>$type auto",
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"Automatically derive route target\n")

DEFSH (VTYSH_BGPD, bgp_evpn_vrf_rt_cmd_vtysh,
	"route-target <both|import|export> RTLIST...",
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN|*:OPQR|*:MN)\n")

DEFSH (VTYSH_BGPD, bgp_extcommunity_list_name_expanded_cmd_vtysh,
	"bgp extcommunity-list <(100-500)|expanded EXTCOMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> LINE...",
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (expanded)\n"
	"Specify expanded extcommunity-list\n"
	"Extended Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, bgp_extcommunity_list_standard_cmd_vtysh,
	"bgp extcommunity-list <(1-99)|standard EXTCOMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (standard)\n"
	"Specify standard extcommunity-list\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Extended community attribute in 'rt aa:nn_or_IPaddr:nn' OR 'soo aa:nn_or_IPaddr:nn' format\n")

DEFSH (VTYSH_BGPD, bgp_fast_convergence_cmd_vtysh,
	"bgp fast-convergence",
	"BGP information\n"
	"Fast convergence for bgp sessions\n")

DEFSH (VTYSH_BGPD, bgp_fast_external_failover_cmd_vtysh,
	"bgp fast-external-failover",
	"BGP information\n"
	"Immediately reset session if a link to a directly connected external peer goes down\n")

DEFSH (VTYSH_BGPD, bgp_fs_local_install_ifname_cmd_vtysh,
	"[no] local-install INTERFACE",
	"Negate a command or set its defaults\n"
	"Apply local policy routing\n"
	"Interface name\n")

DEFSH (VTYSH_BGPD, bgp_global_suppress_fib_pending_cmd_vtysh,
	"[no] bgp suppress-fib-pending",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Advertise only routes that are programmed in kernel to peers globally\n")

DEFSH (VTYSH_BGPD, bgp_global_update_delay_cmd_vtysh,
	"bgp update-delay (0-3600)$delay [(1-3600)$wait]",
	"BGP information\n"
	"Force initial delay for best-path and updates for all bgp instances\n"
	"Max delay in seconds\n"
	"Establish wait in seconds\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_cmd_vtysh,
	"bgp graceful-restart",
	"BGP information\n"
	"Global Graceful Restart command\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_disable_cmd_vtysh,
	"bgp graceful-restart-disable",
	"BGP information\n"
	"Global Graceful Restart - Disable Mode\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_graceful_restart_disable_eor_cmd_vtysh,
	"bgp graceful-restart disable-eor",
	"BGP information\n"
	"Graceful restart configuration parameters\n"
	"Disable EOR Check\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_notification_cmd_vtysh,
	"[no$no] bgp graceful-restart notification",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Indicate Graceful Restart support for BGP NOTIFICATION messages\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_preserve_fw_cmd_vtysh,
	"bgp graceful-restart preserve-fw-state",
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Sets F-bit indication that fib is preserved while doing Graceful Restart\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_restart_time_cmd_vtysh,
	"bgp graceful-restart restart-time (0-4095)",
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the time to wait to delete stale routes before a BGP open message is received\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_rib_stale_time_cmd_vtysh,
	"bgp graceful-restart rib-stale-time (1-3600)",
	"BGP information\n"
	"Graceful restart configuration parameters\n"
	"Specify the stale route removal timer in rib\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_select_defer_time_cmd_vtysh,
	"bgp graceful-restart select-defer-time (0-3600)",
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the time to defer the BGP route selection after restart\n"
	"Delay value (seconds, 0 - disable)\n")

DEFSH (VTYSH_BGPD, bgp_graceful_restart_stalepath_time_cmd_vtysh,
	"bgp graceful-restart stalepath-time (1-4095)",
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the max time to hold onto restarting peer's stale paths\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, bgp_graceful_shutdown_cmd_vtysh,
	"bgp graceful-shutdown",
	"BGP information\n"
	"Graceful shutdown parameters\n")

DEFSH (VTYSH_BGPD, bgp_imexport_vpn_cmd_vtysh,
	"[no] <import|export>$direction_str vpn",
	"Negate a command or set its defaults\n"
	"Import routes to this address-family\n"
	"Export routes from this address-family\n"
	"to/from default instance VPN RIB\n")

DEFSH (VTYSH_BGPD, bgp_imexport_vrf_cmd_vtysh,
	"[no] import vrf VIEWVRFNAME$import_name",
	"Negate a command or set its defaults\n"
	"Import routes from another VRF\n"
	"VRF to import from\n"
	"The name of the VRF\n")

DEFSH (VTYSH_BGPD, bgp_inq_limit_cmd_vtysh,
	"bgp input-queue-limit (1-4294967295)$limit",
	"BGP information\n"
	"Set the BGP Input Queue limit for all peers when message parsing\n"
	"Input-Queue limit\n")

DEFSH (VTYSH_BGPD, bgp_ipv6_auto_ra_cmd_vtysh,
	"[no] bgp ipv6-auto-ra",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Allow enabling IPv6 ND RA sending\n")

DEFSH (VTYSH_BGPD, bgp_lcommunity_list_expanded_cmd_vtysh,
	"bgp large-community-list (100-500) [seq (0-4294967295)] <deny|permit> LINE...",
	"BGP information\n"
	"Add a large community list entry\n"
	"Large Community list number (expanded)\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, bgp_lcommunity_list_name_expanded_cmd_vtysh,
	"bgp large-community-list expanded LCOMMUNITY_LIST_NAME [seq (0-4294967295)] <deny|permit> LINE...",
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify expanded large-community-list\n"
	"Large Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, bgp_lcommunity_list_name_standard_cmd_vtysh,
	"bgp large-community-list standard LCOMMUNITY_LIST_NAME [seq (0-4294967295)] <deny|permit> AA:BB:CC...",
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify standard large-community-list\n"
	"Large Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"large community in 'aa:bb:cc' format\n")

DEFSH (VTYSH_BGPD, bgp_lcommunity_list_standard_cmd_vtysh,
	"bgp large-community-list (1-99) [seq (0-4294967295)] <deny|permit> AA:BB:CC...",
	"BGP information\n"
	"Add a large community list entry\n"
	"Large Community list number (standard)\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"large community in 'aa:bb:cc' format\n")

DEFSH (VTYSH_BGPD, bgp_listen_limit_cmd_vtysh,
	"bgp listen limit (1-65535)",
	"BGP information\n"
	"BGP Dynamic Neighbors listen commands\n"
	"Maximum number of BGP Dynamic Neighbors that can be created\n"
	"Configure Dynamic Neighbors listen limit value\n")

DEFSH (VTYSH_BGPD, bgp_listen_range_cmd_vtysh,
	"bgp listen range <A.B.C.D/M|X:X::X:X/M> peer-group PGNAME",
	"BGP information\n"
	"Configure BGP dynamic neighbors listen range\n"
	"Configure BGP dynamic neighbors listen range\n"
	"Neighbor address\n"
	"IPv6 address\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, bgp_llgr_stalepath_time_cmd_vtysh,
	"bgp long-lived-graceful-restart stale-time (1-16777215)",
	"BGP information\n"
	"Enable Long-lived Graceful Restart\n"
	"Specifies maximum time to wait before purging long-lived stale routes\n"
	"Stale time value (seconds)\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_local_mac_cmd_vtysh,
	"bgp local-mac vni (1-16777215) mac WORD seq (0-4294967295)",
	"BGP information\n"
	"Local MAC config\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"local mac\n"
	"mac address\n"
	"mac-mobility sequence\n"
	"seq number\n")

DEFSH (VTYSH_BGPD, bgp_log_neighbor_changes_cmd_vtysh,
	"bgp log-neighbor-changes",
	"BGP information\n"
	"Log neighbor up/down and reset reason\n")

DEFSH (VTYSH_BGPD, bgp_lu_uses_explicit_null_cmd_vtysh,
	"[no] bgp labeled-unicast <explicit-null|ipv4-explicit-null|ipv6-explicit-null>$value",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"BGP Labeled-unicast options\n"
	"Use explicit-null label values for all local prefixes\n"
	"Use the IPv4 explicit-null label value for IPv4 local prefixes\n"
	"Use the IPv6 explicit-null label value for IPv6 local prefixes\n")

DEFSH (VTYSH_BGPD, bgp_maxmed_admin_cmd_vtysh,
	"bgp max-med administrative ",
	"BGP information\n"
	"Advertise routes with max-med\n"
	"Administratively applied, for an indefinite period\n")

DEFSH (VTYSH_BGPD, bgp_maxmed_admin_medv_cmd_vtysh,
	"bgp max-med administrative (0-4294967295)",
	"BGP information\n"
	"Advertise routes with max-med\n"
	"Administratively applied, for an indefinite period\n"
	"Max MED value to be used\n")

DEFSH (VTYSH_BGPD, bgp_maxmed_onstartup_cmd_vtysh,
	"bgp max-med on-startup (5-86400) [(0-4294967295)]",
	"BGP information\n"
	"Advertise routes with max-med\n"
	"Effective on a startup\n"
	"Time (seconds) period for max-med\n"
	"Max MED value to be used\n")

DEFSH (VTYSH_BGPD, bgp_maxpaths_cmd_vtysh,
	"maximum-paths (1-256)",
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_maxpaths_hidden_cmd_vtysh,
	"maximum-paths (1-256)",
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH (VTYSH_BGPD, bgp_maxpaths_ibgp_cluster_cmd_vtysh,
	"maximum-paths ibgp (1-256) equal-cluster-length",
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n"
	"Match the cluster length\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_maxpaths_ibgp_cluster_hidden_cmd_vtysh,
	"maximum-paths ibgp (1-256) equal-cluster-length",
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n"
	"Match the cluster length\n")

DEFSH (VTYSH_BGPD, bgp_maxpaths_ibgp_cmd_vtysh,
	"maximum-paths ibgp (1-256)",
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_maxpaths_ibgp_hidden_cmd_vtysh,
	"maximum-paths ibgp (1-256)",
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n")

DEFSH (VTYSH_BGPD, bgp_minimum_holdtime_cmd_vtysh,
	"bgp minimum-holdtime (1-65535)",
	"BGP specific commands\n"
	"BGP minimum holdtime\n"
	"Seconds\n")

DEFSH (VTYSH_BGPD, bgp_neighbor_graceful_restart_disable_set_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart-disable",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Graceful Restart Disable command for a neighbor\n")

DEFSH (VTYSH_BGPD, bgp_neighbor_graceful_restart_helper_set_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart-helper",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Graceful Restart Helper command for a neighbor\n")

DEFSH (VTYSH_BGPD, bgp_neighbor_graceful_restart_set_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Graceful Restart command for a neighbor\n")

DEFSH (VTYSH_BGPD, bgp_network_cmd_vtysh,
	"[no] network 	<A.B.C.D/M$prefix|A.B.C.D$address [mask A.B.C.D$netmask]> 	[{route-map RMAP_NAME$map_name|label-index (0-1048560)$label_index| 	backdoor$backdoor}]",
	"Negate a command or set its defaults\n"
	"Specify a network to announce via BGP\n"
	"IPv4 prefix\n"
	"Network number\n"
	"Network mask\n"
	"Network mask\n"
	"Route-map to modify the attributes\n"
	"Name of the route map\n"
	"Label index to associate with the prefix\n"
	"Label index value\n"
	"Specify a BGP backdoor route\n")

DEFSH (VTYSH_BGPD, bgp_network_import_check_cmd_vtysh,
	"bgp network import-check",
	"BGP information\n"
	"BGP network command\n"
	"Check BGP network route exists in IGP\n")

DEFSH (VTYSH_BGPD, bgp_norib_cmd_vtysh,
	"bgp no-rib",
	"BGP information\n"
	"Disable BGP route installation to RIB (Zebra)\n")

DEFSH (VTYSH_BGPD, bgp_outq_limit_cmd_vtysh,
	"bgp output-queue-limit (1-4294967295)$limit",
	"BGP information\n"
	"Set the BGP Output Queue limit for all peers when message parsing\n"
	"Output-Queue limit\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric>",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_hidden_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric>",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_metric_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_metric_hidden_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_metric_rmap_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_metric_rmap_hidden_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_hidden_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_metric_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_metric_hidden_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_metric_rmap_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) metric (0-4294967295) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_metric_rmap_hidden_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) metric (0-4294967295) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_rmap_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_rmap_hidden_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_rmap_metric_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) route-map RMAP_NAME metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Route map reference\n"
	"Pointer to route-map entries\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_ospf_rmap_metric_hidden_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) route-map RMAP_NAME metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Route map reference\n"
	"Pointer to route-map entries\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_rmap_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_rmap_hidden_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv4_rmap_metric_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH_HIDDEN (VTYSH_BGPD, bgp_redistribute_ipv4_rmap_metric_hidden_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric>",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_metric_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_metric_rmap_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric> metric (0-4294967295) route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_rmap_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_rmap_metric_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric> route-map RMAP_NAME metric (0-4294967295)",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Route map reference\n"
	"Pointer to route-map entries\n"
	"Metric for redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_BGPD, bgp_redistribute_ipv6_table_cmd_vtysh,
	"redistribute table-direct (1-65535)$table_id [{metric$metric (0-4294967295)$metric_val|route-map WORD$rmap}]",
	"Redistribute information from another routing protocol\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, bgp_reject_as_sets_cmd_vtysh,
	"bgp reject-as-sets",
	"BGP information\n"
	"Reject routes with AS_SET or AS_CONFED_SET flag\n")

DEFSH (VTYSH_BGPD, bgp_retain_route_target_cmd_vtysh,
	"[no$no] bgp retain route-target all",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Retain BGP updates\n"
	"Retain BGP updates based on route-target values\n"
	"Retain all BGP updates\n")

DEFSH (VTYSH_BGPD, bgp_router_id_cmd_vtysh,
	"bgp router-id A.B.C.D",
	"BGP information\n"
	"Override configured router identifier\n"
	"Manually configured router identifier\n")

DEFSH (VTYSH_BGPD, bgp_rpki_start_cmd_vtysh,
	"rpki start [vrf NAME$vrfname]",
	"Control rpki specific settings\n"
	"start rpki support\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_BGPD, bgp_rpki_stop_cmd_vtysh,
	"rpki stop [vrf NAME$vrfname]",
	"Control rpki specific settings\n"
	"start rpki support\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_BGPD, bgp_rpkt_quanta_cmd_vtysh,
	"[no] read-quanta (1-10)$quanta",
	"Negate a command or set its defaults\n"
	"How many packets to read from peer socket per I/O cycle\n"
	"Number of packets\n")

DEFSH (VTYSH_BGPD, bgp_rr_allow_outbound_policy_cmd_vtysh,
	"bgp route-reflector allow-outbound-policy",
	"BGP information\n"
	"Allow modifications made by out route-map\n"
	"on ibgp neighbors\n")

DEFSH (VTYSH_BGPD, bgp_session_dscp_cmd_vtysh,
	"bgp session-dscp (0-63)$dscp",
	"BGP information\n"
	"Override default (CS6) DSCP for BGP connections\n"
	"Manually configured DSCP value\n")

DEFSH (VTYSH_BGPD, bgp_set_route_map_delay_timer_cmd_vtysh,
	"bgp route-map delay-timer (0-600)",
	"Set values in destination routing protocol\n"
	"BGP route-map delay timer\n"
	"Time in secs to wait before processing route-map changes\n"
	"0 disables the timer, no route updates happen when route-maps change\n")

DEFSH (VTYSH_BGPD, bgp_shutdown_cmd_vtysh,
	"bgp shutdown",
	"BGP information\n"
	"Administrative shutdown of the BGP instance\n")

DEFSH (VTYSH_BGPD, bgp_shutdown_msg_cmd_vtysh,
	"bgp shutdown message MSG...",
	"BGP information\n"
	"Administrative shutdown of the BGP instance\n"
	"Add a shutdown message (RFC 8203)\n"
	"Shutdown message\n")

DEFSH (VTYSH_BGPD, bgp_sid_vpn_export_cmd_vtysh,
	"[no] sid vpn per-vrf export <(1-1048575)$sid_idx|auto$sid_auto|explicit$sid_explicit X:X::X:X$sid_value>",
	"Negate a command or set its defaults\n"
	"sid value for VRF\n"
	"Between current vrf and vpn\n"
	"sid per-VRF (both IPv4 and IPv6 address families)\n"
	"For routes leaked from current vrf to vpn\n"
	"Sid allocation index\n"
	"Automatically assign a label\n"
	"Explicitly assign a sid value\n"
	"Sid value\n")

DEFSH (VTYSH_BGPD, bgp_snmp_traps_bgp4_mibv2_cmd_vtysh,
	"[no$no] bgp snmp traps bgp4-mibv2",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP SNMP\n"
	"Configure SNMP traps for BGP\n"
	"Configure use of BGP4-MIBv2 SNMP traps for BGP\n")

DEFSH (VTYSH_BGPD, bgp_snmp_traps_rfc4273_cmd_vtysh,
	"[no$no] bgp snmp traps rfc4273",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP SNMP\n"
	"Configure SNMP traps for BGP\n"
	"Configure use of rfc4273 SNMP traps for BGP\n")

DEFSH (VTYSH_BGPD, bgp_snmp_traps_rfc4382_cmd_vtysh,
	"[no$no] bgp snmp traps rfc4382",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP SNMP\n"
	"Configure SNMP traps for BGP\n"
	"Configure use of rfc4382 SNMP traps for BGP\n")

DEFSH (VTYSH_BGPD, bgp_srv6_encap_behavior_cmd_vtysh,
	"[no$no] encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior",
	"Negate a command or set its defaults\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_BGPD, bgp_srv6_locator_cmd_vtysh,
	"locator NAME$name",
	"Specify SRv6 locator\n"
	"Specify SRv6 locator\n")

DEFSH (VTYSH_BGPD, bgp_srv6_only_cmd_vtysh,
	"[no] srv6-only",
	"Negate a command or set its defaults\n"
	"Only allow SRv6 and disallow MPLS routes\n")

DEFSH (VTYSH_BGPD, bgp_suppress_duplicates_cmd_vtysh,
	"bgp suppress-duplicates",
	"BGP information\n"
	"Suppress duplicate updates if the route actually not changed\n")

DEFSH (VTYSH_BGPD, bgp_suppress_fib_pending_cmd_vtysh,
	"[no] bgp suppress-fib-pending",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Advertise only routes that are programmed in kernel to peers\n")

DEFSH (VTYSH_BGPD, bgp_table_map_cmd_vtysh,
	"table-map WORD",
	"BGP table to RIB route download filter\n"
	"Name of the route map\n")

DEFSH (VTYSH_BGPD, bgp_tcp_keepalive_cmd_vtysh,
	"bgp tcp-keepalive (1-65535)$idle (1-65535)$intvl (1-30)$probes",
	"BGP information\n"
	"TCP keepalive parameters\n"
	"TCP keepalive idle time (seconds)\n"
	"TCP keepalive interval (seconds)\n"
	"TCP keepalive maximum probes\n")

DEFSH (VTYSH_BGPD, bgp_timers_cmd_vtysh,
	"timers bgp (0-65535) (0-65535)",
	"Adjust routing timers\n"
	"BGP timers\n"
	"Keepalive interval\n"
	"Holdtime\n")

DEFSH (VTYSH_BGPD, bgp_update_delay_cmd_vtysh,
	"update-delay (0-3600)$delay [(1-3600)$wait]",
	"Force initial delay for best-path and updates\n"
	"Max delay in seconds\n"
	"Establish wait in seconds\n")

DEFSH (VTYSH_BGPD, bgp_wpkt_quanta_cmd_vtysh,
	"[no] write-quanta (1-64)$quanta",
	"Negate a command or set its defaults\n"
	"How many packets to write to peer socket per run\n"
	"Number of packets\n")

DEFSH (VTYSH_BGPD, bmp_acl_cmd_vtysh,
	"[no] <ip|ipv6>$af access-list ACCESSLIST_NAME$access_list",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Access list to restrict BMP sessions\n"
	"Access list name\n")

DEFSH (VTYSH_BGPD, bmp_connect_cmd_vtysh,
	"[no] bmp connect HOSTNAME port (1-65535) {min-retry (100-86400000)|max-retry (100-86400000)} [source-interface <WORD$srcif>]",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Actively establish connection to monitoring station\n"
	"Monitoring station hostname or address\n"
	"TCP port\n"
	"TCP port\n"
	"Minimum connection retry interval\n"
	"Minimum connection retry interval (milliseconds)\n"
	"Maximum connection retry interval\n"
	"Maximum connection retry interval (milliseconds)\n"
	"Source interface to use\n"
	"Define an interface\n")

DEFSH (VTYSH_BGPD, bmp_import_vrf_cmd_vtysh,
	"[no] bmp import-vrf-view VRFNAME$vrfname",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Import BMP information from another VRF\n"
	"Specify the VRF or view instance name\n")

DEFSH (VTYSH_BGPD, bmp_listener_cmd_vtysh,
	"bmp listener <X:X::X:X|A.B.C.D> port (1-65535)",
	"BGP Monitoring Protocol\n"
	"Listen for inbound BMP connections\n"
	"IPv6 address to listen on\n"
	"IPv4 address to listen on\n"
	"TCP Port number\n"
	"TCP Port number\n")

DEFSH (VTYSH_BGPD, bmp_mirror_cmd_vtysh,
	"[no] bmp mirror",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Send BMP route mirroring messages\n")

DEFSH (VTYSH_BGPD, bmp_mirror_limit_cmd_vtysh,
	"bmp mirror buffer-limit (0-4294967294)",
	"BGP Monitoring Protocol\n"
	"Route Mirroring settings\n"
	"Configure maximum memory used for buffered mirroring messages\n"
	"Limit in bytes\n")

DEFSH (VTYSH_BGPD, bmp_monitor_cmd_vtysh,
	"[no] bmp monitor <ipv4|ipv6|l2vpn> <unicast|multicast|evpn|vpn> <pre-policy|post-policy|loc-rib>$policy",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Send BMP route monitoring messages\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Send state before policy and filter processing\n"
	"Send state with policy and filters applied\n"
	"Send state after decision process is applied\n")

DEFSH (VTYSH_BGPD, bmp_stats_cmd_vtysh,
	"[no] bmp stats [interval (100-86400000)]",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Send BMP statistics messages\n"
	"Specify BMP stats interval\n"
	"Interval (milliseconds) to send BMP Stats in\n")

DEFSH (VTYSH_BGPD, bmp_stats_send_experimental_cmd_vtysh,
	"[no] bmp stats send-experimental",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Send BMP statistics messages\n"
	"Send experimental BMP stats [65531-65534]\n")

DEFSH (VTYSH_OSPFD, capability_opaque_cmd_vtysh,
	"capability opaque",
	"Enable specific OSPF feature\n"
	"Opaque LSA\n")

DEFSH (VTYSH_ISISD, circuit_topology_cmd_vtysh,
	"[no] isis topology<standard|ipv4-unicast|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc>$topology",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Configure interface IS-IS topologies\n"
	"Standard topology\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n")

DEFSH (VTYSH_BGPD, clear_bgp_instance_ipv6_safi_prefix_cmd_vtysh,
	"clear [ip] bgp <view|vrf> VIEWVRFNAME ipv6 <unicast|multicast|vpn> prefix X:X::X:X/M",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Clear bestpath and re-advertise\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, clear_bgp_ipv6_safi_prefix_cmd_vtysh,
	"clear [ip] bgp ipv6 <unicast|multicast|vpn> prefix X:X::X:X/M",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Clear bestpath and re-advertise\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_ALL, clear_event_cpu_cmd_vtysh,
	"clear event cpu [FILTER]",
	"Clear stored data in all pthreads\n"
	"Event information\n"
	"Event CPU usage\n"
	"Display filter (rwtexb)\n")

DEFSH (VTYSH_ZEBRA, clear_evpn_dup_addr_cmd_vtysh,
	"clear evpn dup-addr vni <all$vni_all |(1-16777215)$vni [mac X:X:X:X:X:X | ip <A.B.C.D|X:X::X:X>]>",
	"Reset functions\n"
	"EVPN\n"
	"Duplicate address \n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"All VNIs\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"IP\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_all_cmd_vtysh,
	"clear [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6|l2vpn> [<unicast|multicast|vpn|labeled-unicast|flowspec|evpn>]] <*|A.B.C.D$neighbor|X:X::X:X$neighbor|WORD$neighbor|ASNUM|external|peer-group PGNAME> [<soft [<in|out>]|in [prefix-filter]|out|message-stats|capabilities>]",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Clear all peers\n"
	"BGP IPv4 neighbor to clear\n"
	"BGP IPv6 neighbor to clear\n"
	"BGP neighbor on interface to clear\n"
	"Clear peers with the AS number in plain or dotted format\n"
	"Clear all external peers\n"
	"Clear all members of peer-group\n"
	"BGP peer-group name\n"
	"Soft reconfig inbound and outbound updates\n"
	"Send route-refresh unless using 'soft-reconfiguration inbound'\n"
	"Resend all outbound updates\n"
	"Send route-refresh unless using 'soft-reconfiguration inbound'\n"
	"Push out prefix-list ORF and do inbound soft reconfig\n"
	"Resend all outbound updates\n"
	"Reset message statistics\n"
	"Resend capabilities\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_dampening_address_cmd_vtysh,
	"clear ip bgp dampening A.B.C.D",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"Clear route flap dampening information\n"
	"Network to clear damping information\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_dampening_address_mask_cmd_vtysh,
	"clear ip bgp dampening A.B.C.D A.B.C.D",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"Clear route flap dampening information\n"
	"Network to clear damping information\n"
	"Network mask\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_dampening_cmd_vtysh,
	"clear ip bgp dampening",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"Clear route flap dampening information\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_dampening_prefix_cmd_vtysh,
	"clear ip bgp dampening A.B.C.D/M",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"Clear route flap dampening information\n"
	"IPv4 prefix\n")

DEFSH (VTYSH_BGPD, clear_ip_bgp_prefix_cmd_vtysh,
	"clear [ip] bgp [<view|vrf> VIEWVRFNAME] prefix A.B.C.D/M",
	"Reset functions\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Clear bestpath and re-advertise\n"
	"IPv4 prefix\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_IP_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors A.B.C.D$nbr_addr",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n"
	"IP-EIGRP neighbor address\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_IP_soft_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors A.B.C.D$nbr_addr soft",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n"
	"IP-EIGRP neighbor address\n"
	"Resync with peer without adjacency reset\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_int_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors IFNAME",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n"
	"Interface's name\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_int_soft_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors IFNAME soft",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n"
	"Interface's name\n"
	"Resync with peer without adjacency reset\n")

DEFSH (VTYSH_EIGRPD, clear_ip_eigrp_neighbors_soft_cmd_vtysh,
	"clear ip eigrp [vrf NAME] neighbors soft",
	"Reset functions\n"
	"IP information\n"
	"Clear IP-EIGRP\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Clear IP-EIGRP neighbors\n"
	"Resync with peers without adjacency reset\n")

DEFSH (VTYSH_PIMD, clear_ip_igmp_interfaces_cmd_vtysh,
	"clear ip igmp [vrf NAME] interfaces",
	"Reset functions\n"
	"IP information\n"
	"IGMP clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset IGMP interfaces\n")

DEFSH (VTYSH_PIMD, clear_ip_interfaces_cmd_vtysh,
	"clear ip interfaces [vrf NAME]",
	"Reset functions\n"
	"IP information\n"
	"Reset interfaces\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIMD, clear_ip_mroute_cmd_vtysh,
	"clear ip mroute [vrf NAME]$name",
	"Reset functions\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIMD, clear_ip_mroute_count_cmd_vtysh,
	"clear ip mroute [vrf NAME]$name count",
	"Reset functions\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n")

DEFSH (VTYSH_PIMD, clear_ip_msdp_peer_cmd_vtysh,
	"clear ip msdp peer A.B.C.D$peer [vrf WORD$vrfname]",
	"Reset functions\n"
	"IP information\n"
	"MSDP information\n"
	"Restart MSDP peer\n"
	"MSDP peer address\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIMD, clear_ip_msdp_peer_counters_cmd_vtysh,
	"clear ip msdp [<vrf all$vrf_all|vrf WORD$vrf_name>] peer [A.B.C.D$peer] counters",
	"Reset functions\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP peer information\n"
	"Peer IP address\n"
	"MSDP peer counters\n")

DEFSH (VTYSH_OSPFD, clear_ip_ospf_interface_cmd_vtysh,
	"clear ip ospf [vrf NAME] interface [IFNAME]",
	"Reset functions\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Interface information\n"
	"Interface name\n")

DEFSH (VTYSH_OSPFD, clear_ip_ospf_neighbor_cmd_vtysh,
	"clear ip ospf [(1-65535)]$instance neighbor [A.B.C.D$nbr_id]",
	"Reset functions\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Reset OSPF Neighbor\n"
	"Neighbor ID\n")

DEFSH (VTYSH_OSPFD, clear_ip_ospf_process_cmd_vtysh,
	"clear ip ospf [(1-65535)]$instance process",
	"Reset functions\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Reset OSPF Process\n")

DEFSH (VTYSH_PIMD, clear_ip_pim_bsr_db_cmd_vtysh,
	"clear ip pim [vrf NAME] bsr-data",
	"Reset functions\n"
	"IP information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset pim bsr data\n")

DEFSH (VTYSH_PIMD, clear_ip_pim_interface_traffic_cmd_vtysh,
	"clear ip pim [vrf NAME] interface traffic",
	"Reset functions\n"
	"IP information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM interfaces\n"
	"Reset Protocol Packet counters\n")

DEFSH (VTYSH_PIMD, clear_ip_pim_interfaces_cmd_vtysh,
	"clear ip pim [vrf NAME] interfaces",
	"Reset functions\n"
	"IP information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM interfaces\n")

DEFSH (VTYSH_PIMD, clear_ip_pim_oil_cmd_vtysh,
	"clear ip pim [vrf NAME]$name oil",
	"Reset functions\n"
	"IP information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Rescan PIM OIL (output interface list)\n")

DEFSH (VTYSH_PIMD, clear_ip_pim_statistics_cmd_vtysh,
	"clear ip pim statistics [vrf NAME]$name",
	"Reset functions\n"
	"IP information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM statistics\n")

DEFSH (VTYSH_BABELD|VTYSH_BGPD|VTYSH_EIGRPD|VTYSH_FABRICD|VTYSH_ISISD|VTYSH_OSPFD|VTYSH_PIMD|VTYSH_RIPD|VTYSH_ZEBRA, clear_ip_prefix_list_cmd_vtysh,
	"clear ip prefix-list [PREFIXLIST4_NAME$name [A.B.C.D/M$prefix]]",
	"Reset functions\n"
	"IP information\n"
	"Build a prefix list\n"
	"Name of a prefix list\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n")

DEFSH (VTYSH_MGMTD, clear_ip_rip_cmd_vtysh,
	"clear ip rip [vrf WORD]",
	"Reset functions\n"
	"IP information\n"
	"Clear IP RIP database\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_mld_interfaces_cmd_vtysh,
	"clear ipv6 mld [vrf NAME$vrf_name] interfaces",
	"Reset functions\n"
	"IPv6 information\n"
	"MLD clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset MLD interfaces\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_mroute_cmd_vtysh,
	"clear ipv6 mroute [vrf NAME]$name",
	"Reset functions\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_mroute_count_cmd_vtysh,
	"clear ipv6 mroute [vrf NAME]$name count",
	"Reset functions\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n")

DEFSH (VTYSH_OSPF6D, clear_ipv6_ospf6_interface_cmd_vtysh,
	"clear ipv6 ospf6 [vrf NAME] interface [IFNAME]",
	"Reset functions\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Interface information\n"
	"Interface name(e.g. ep0)\n")

DEFSH (VTYSH_OSPF6D, clear_ipv6_ospf6_intf_auth_cmd_vtysh,
	"clear ipv6 ospf6 [vrf VRF] auth-counters interface [IFNAME]",
	"Reset functions\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"authentication rx/tx drop counters\n"
	"Interface information\n"
	"Interface name(e.g. ep0)\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_pim_bsr_db_cmd_vtysh,
	"clear ipv6 pim [vrf NAME] bsr-data",
	"Reset functions\n"
	"IPv6 information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset pim bsr data\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_pim_interface_traffic_cmd_vtysh,
	"clear ipv6 pim [vrf NAME] interface traffic",
	"Reset functions\n"
	"IPv6 information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM interfaces\n"
	"Reset Protocol Packet counters\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_pim_interfaces_cmd_vtysh,
	"clear ipv6 pim [vrf NAME] interfaces",
	"Reset functions\n"
	"IPv6 information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM interfaces\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_pim_oil_cmd_vtysh,
	"clear ipv6 pim [vrf NAME]$name oil",
	"Reset functions\n"
	"IPv6 information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Rescan PIMv6 OIL (output interface list)\n")

DEFSH (VTYSH_PIM6D, clear_ipv6_pim_statistics_cmd_vtysh,
	"clear ipv6 pim statistics [vrf NAME]$name",
	"Reset functions\n"
	"IPv6 information\n"
	"PIM clear commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset PIM statistics\n")

DEFSH (VTYSH_BABELD|VTYSH_BGPD|VTYSH_FABRICD|VTYSH_ISISD|VTYSH_OSPF6D|VTYSH_PIM6D|VTYSH_RIPNGD|VTYSH_ZEBRA, clear_ipv6_prefix_list_cmd_vtysh,
	"clear ipv6 prefix-list [PREFIXLIST6_NAME$name [X:X::X:X/M$prefix]]",
	"Reset functions\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Name of a prefix list\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n")

DEFSH (VTYSH_MGMTD, clear_ipv6_rip_cmd_vtysh,
	"clear ipv6 ripng [vrf WORD]",
	"Reset functions\n"
	"IPv6 information\n"
	"Clear IPv6 RIP database\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_ISISD, clear_isis_neighbor_arg_cmd_vtysh,
	"clear isis [vrf <NAME|all>] neighbor WORD",
	"Reset functions\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"System id\n")

DEFSH (VTYSH_ISISD, clear_isis_neighbor_cmd_vtysh,
	"clear isis [vrf <NAME|all>] neighbor",
	"Reset functions\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n")

DEFSH (VTYSH_NON_MGMTD, clear_log_cmdline_cmd_vtysh,
	"clear log cmdline-targets",
	"Reset functions\n"
	"Logging control\n"
	"Disable log targets specified at startup by --log option\n")

DEFSH (VTYSH_NHRPD, clear_nhrp_cmd_vtysh,
	"clear <ip|ipv6> nhrp <cache|shortcut>",
	"Reset functions\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Dynamic cache entries\n"
	"Shortcut entries\n")

DEFSH (VTYSH_OSPF6D, clear_router_ospf6_cmd_vtysh,
	"clear ipv6 ospf6 process [vrf NAME$name]",
	"Reset functions\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Reset OSPF Process\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_all_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> *",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"From any NVE\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_all_prefix_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> prefix <*|A.B.C.D/M|X:X::X:X/M>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_un_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_un_prefix_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> un <*|A.B.C.D|X:X::X:X> prefix <*|A.B.C.D/M|X:X::X:X/M>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_un_vn_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> un <*|A.B.C.D|X:X::X:X> vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_un_vn_prefix_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> un <*|A.B.C.D|X:X::X:X> vn <*|A.B.C.D|X:X::X:X> prefix <*|A.B.C.D/M|X:X::X:X/M> prefix <*|A.B.C.D/M|X:X::X:X/M>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_vn_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_vn_prefix_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> vn <*|A.B.C.D|X:X::X:X> prefix <*|A.B.C.D/M|X:X::X:X/M>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"UN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_vn_un_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> vn <*|A.B.C.D|X:X::X:X> un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_mac_vn_un_prefix_cmd_vtysh,
	"clear vnc mac <*|X:X:X:X:X:X> virtual-network-identifier <*|(1-4294967295)> vn <*|A.B.C.D|X:X::X:X> un <*|A.B.C.D|X:X::X:X> prefix <*|A.B.C.D/M|X:X::X:X/M>",
	"clear\n"
	"VNC Information\n"
	"Clear mac registration information\n"
	"All macs\n"
	"MAC address\n"
	"VNI keyword\n"
	"Any virtual network identifier\n"
	"Virtual network identifier\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, clear_vnc_nve_all_cmd_vtysh,
	"clear vnc nve *",
	"clear\n"
	"VNC Information\n"
	"Clear per NVE information\n"
	"For all NVEs\n")

DEFSH (VTYSH_BGPD, clear_vnc_nve_un_cmd_vtysh,
	"clear vnc nve un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"UN address of NVE\n"
	"All un nves\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_nve_un_vn_cmd_vtysh,
	"clear vnc nve un <*|A.B.C.D|X:X::X:X> vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"UN address of NVE\n"
	"For all un NVEs\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"VN address of NVE\n"
	"For all vn NVEs\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_nve_vn_cmd_vtysh,
	"clear vnc nve vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"VN address of NVE\n"
	"All addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_nve_vn_un_cmd_vtysh,
	"clear vnc nve vn <*|A.B.C.D|X:X::X:X> un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"VN address of NVE\n"
	"For all NVEs\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"For all UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_prefix_all_cmd_vtysh,
	"clear vnc prefix <*|A.B.C.D/M|X:X::X:X/M> *",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"From any NVE\n")

DEFSH (VTYSH_BGPD, clear_vnc_prefix_un_cmd_vtysh,
	"clear vnc prefix <*|A.B.C.D/M|X:X::X:X/M> un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_prefix_un_vn_cmd_vtysh,
	"clear vnc prefix <*|A.B.C.D/M|X:X::X:X/M> un <*|A.B.C.D|X:X::X:X> vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_prefix_vn_cmd_vtysh,
	"clear vnc prefix <*|A.B.C.D/M|X:X::X:X/M> vn <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"UN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vnc_prefix_vn_un_cmd_vtysh,
	"clear vnc prefix <*|A.B.C.D/M|X:X::X:X/M> vn <*|A.B.C.D|X:X::X:X> un <*|A.B.C.D|X:X::X:X>",
	"clear\n"
	"VNC Information\n"
	"Clear prefix registration information\n"
	"All prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"VN address of NVE\n"
	"All VN addresses\n"
	"VN IPv4 interface address\n"
	"VN IPv6 interface address\n"
	"UN address of NVE\n"
	"All UN addresses\n"
	"UN IPv4 interface address\n"
	"UN IPv6 interface address\n")

DEFSH (VTYSH_BGPD, clear_vrf_all_cmd_vtysh,
	"clear vrf NAME all",
	"Clear stored data\n"
	"From a VRF\n"
	"VRF name\n"
	"All prefixes\n")

DEFSH (VTYSH_BGPD, clear_vrf_prefix_rd_cmd_vtysh,
	"clear vrf NAME [prefix <A.B.C.D/M|X:X::X:X/M>] [rd ASN:NN_OR_IP-ADDRESS]",
	"Clear stored data\n"
	"From a VRF\n"
	"VRF name\n"
	"Prefix related information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Specific VRF Route Distinguisher\n"
	"<as-number>:<number> or <ip-address>:<number>\n")

DEFSH (VTYSH_ZEBRA, clear_zebra_fpm_stats_cmd_vtysh,
	"clear zebra fpm stats",
	"Reset functions\n"
	"Zebra information\n"
	"Clear Forwarding Path Manager information\n"
	"Statistics\n")

DEFSH (VTYSH_NON_MGMTD, config_log_dmn_file_cmd_vtysh,
	"log daemon <zebra|mgmtd|bgpd|ripd|ripngd|ospfd|ospf6d|isisd|fabricd|nhrpd|ldpd|babeld|eigrpd|pimd|pim6d|pbrd|staticd|bfdd|vrrpd|pathd> file FILENAME [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg]",
	"Logging control\n"
	"Specific daemon\n"
	"For the zebra daemon\n"
	"For the mgmtd daemon\n"
	"For the bgpd daemon\n"
	"For the ripd daemon\n"
	"For the ripngd daemon\n"
	"For the ospfd daemon\n"
	"For the ospf6d daemon\n"
	"For the isisd daemon\n"
	"For the fabricd daemon\n"
	"For the nhrpd daemon\n"
	"For the ldpd daemon\n"
	"For the babeld daemon\n"
	"For the eigrpd daemon\n"
	"For the pimd daemon\n"
	"For the pim6d daemon\n"
	"For the pbrd daemon\n"
	"For the staticd daemon\n"
	"For the bfdd daemon\n"
	"For the vrrpd daemon\n"
	"For the pathd daemon\n"
	"Logging to file\n"
	"Logging filename\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, config_log_ec_cmd_vtysh,
	"[no] log error-category",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Prefix log message text with [EC 9999] code\n")

DEFSH (VTYSH_NON_MGMTD, config_log_facility_cmd_vtysh,
	"log facility <kern|user|mail|daemon|auth|syslog|lpr|news|uucp|cron|local0|local1|local2|local3|local4|local5|local6|local7>$facilityarg",
	"Logging control\n"
	"Facility parameter for syslog messages\n"
	"Kernel\n"
	"User process\n"
	"Mail system\n"
	"System daemons\n"
	"Authorization system\n"
	"Syslog itself\n"
	"Line printer system\n"
	"USENET news\n"
	"Unix-to-Unix copy system\n"
	"Cron/at facility\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n")

DEFSH (VTYSH_NON_MGMTD, config_log_file_cmd_vtysh,
	"[no] log file ![FILENAME [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg]]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Logging to file\n"
	"Logging filename\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, config_log_filterfile_cmd_vtysh,
	"log filtered-file FILENAME [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg]",
	"Logging control\n"
	"Logging to file with string filter\n"
	"Logging filename\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH_HIDDEN (VTYSH_NON_MGMTD, config_log_monitor_cmd_vtysh,
	"[no] log monitor [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Set terminal line (monitor) logging level\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, config_log_record_priority_cmd_vtysh,
	"[no] log record-priority",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Log the priority of the message within the message\n")

DEFSH (VTYSH_NON_MGMTD, config_log_record_severity_cmd_vtysh,
	"[no] log record-severity",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Log the severity of the message within the message\n")

DEFSH (VTYSH_NON_MGMTD, config_log_stdout_cmd_vtysh,
	"[no] log stdout [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Set stdout logging level\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, config_log_syslog_cmd_vtysh,
	"log syslog [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg]",
	"Logging control\n"
	"Set syslog logging level\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, config_log_timestamp_precision_cmd_vtysh,
	"log timestamp precision (0-6)",
	"Logging control\n"
	"Timestamp configuration\n"
	"Set the timestamp precision\n"
	"Number of subsecond digits\n")

DEFSH (VTYSH_NON_MGMTD, config_log_xid_cmd_vtysh,
	"[no] log unique-id",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Prefix log message text with [XXXXX-XXXXX] identifier\n")

DEFSH (VTYSH_WATCHFRR, config_write_integrated_cmd_vtysh,
	"write integrated",
	"Write running configuration to memory, network, or terminal\n"
	"Write integrated all-daemon frr.conf file\n")

DEFSH (VTYSH_KEYS, cryptographic_algorithm_cmd_vtysh,
	"cryptographic-algorithm <md5|hmac-sha-1|hmac-sha-256|hmac-sha-384|hmac-sha-512>$algo",
	"Cryptographic-algorithm\n"
	"Use MD5 algorithm\n"
	"Use HMAC-SHA-1 algorithm\n"
	"Use HMAC-SHA-256 algorithm\n"
	"Use HMAC-SHA-384 algorithm\n"
	"Use HMAC-SHA-512 algorithm\n")

DEFSH (VTYSH_ISISD, csnp_interval_cmd_vtysh,
	"isis csnp-interval (1-600)$intv [level-1|level-2]$level",
	"IS-IS routing protocol\n"
	"Set CSNP interval in seconds\n"
	"CSNP interval value\n"
	"Specify interval for level-1 CSNPs\n"
	"Specify interval for level-2 CSNPs\n")

DEFSH (VTYSH_PIMD, debug_autorp_cmd_vtysh,
	"debug pim autorp",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"AutoRP message processing activity\n")

DEFSH (VTYSH_BABELD, debug_babel_cmd_vtysh,
	"debug babel <common|kernel|filter|timeout|interface|route|all>",
	"Enable debug messages for specific or all part.\n"
	"Babel information\n"
	"Common messages (default)\n"
	"Kernel messages\n"
	"Filter messages\n"
	"Timeout messages\n"
	"Interface messages\n"
	"Route messages\n"
	"All messages\n")

DEFSH (VTYSH_BGPD, debug_bgp_aggregate_cmd_vtysh,
	"debug bgp aggregate",
	"Debugging functions\n"
	"BGP information\n"
	"BGP aggregate\n")

DEFSH (VTYSH_BGPD, debug_bgp_aggregate_prefix_cmd_vtysh,
	"debug bgp aggregate prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Debugging functions\n"
	"BGP information\n"
	"BGP aggregate\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, debug_bgp_as4_cmd_vtysh,
	"debug bgp as4",
	"Debugging functions\n"
	"BGP information\n"
	"BGP AS4 actions\n")

DEFSH (VTYSH_BGPD, debug_bgp_as4_segment_cmd_vtysh,
	"debug bgp as4 segment",
	"Debugging functions\n"
	"BGP information\n"
	"BGP AS4 actions\n"
	"BGP AS4 aspath segment handling\n")

DEFSH (VTYSH_BGPD, debug_bgp_bestpath_prefix_cmd_vtysh,
	"debug bgp bestpath <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Debugging functions\n"
	"BGP information\n"
	"BGP bestpath\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, debug_bgp_bfd_cmd_vtysh,
	"[no] debug bgp bfd",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"Bidirection Forwarding Detection\n")

DEFSH (VTYSH_BGPD, debug_bgp_cond_adv_cmd_vtysh,
	"[no$no] debug bgp conditional-advertisement",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP conditional advertisement\n")

DEFSH (VTYSH_BGPD, debug_bgp_evpn_mh_cmd_vtysh,
	"[no$no] debug bgp evpn mh <es$es|route$rt>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"EVPN\n"
	"Multihoming\n"
	"Ethernet Segment debugging\n"
	"Route debugging\n")

DEFSH (VTYSH_BGPD, debug_bgp_flowspec_cmd_vtysh,
	"debug bgp flowspec",
	"Debugging functions\n"
	"BGP information\n"
	"BGP allow flowspec debugging entries\n")

DEFSH (VTYSH_BGPD, debug_bgp_graceful_restart_cmd_vtysh,
	"debug bgp graceful-restart",
	"Debugging functions\n"
	"BGP information\n"
	"Graceful Restart - Enable Debug Logs\n")

DEFSH (VTYSH_BGPD, debug_bgp_keepalive_cmd_vtysh,
	"debug bgp keepalives",
	"Debugging functions\n"
	"BGP information\n"
	"BGP keepalives\n")

DEFSH (VTYSH_BGPD, debug_bgp_keepalive_peer_cmd_vtysh,
	"debug bgp keepalives <A.B.C.D|X:X::X:X|WORD>",
	"Debugging functions\n"
	"BGP information\n"
	"BGP keepalives\n"
	"BGP IPv4 neighbor to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n")

DEFSH (VTYSH_BGPD, debug_bgp_labelpool_cmd_vtysh,
	"debug bgp labelpool",
	"Debugging functions\n"
	"BGP information\n"
	"label pool\n")

DEFSH (VTYSH_BGPD, debug_bgp_neighbor_events_cmd_vtysh,
	"debug bgp neighbor-events",
	"Debugging functions\n"
	"BGP information\n"
	"BGP Neighbor Events\n")

DEFSH (VTYSH_BGPD, debug_bgp_neighbor_events_peer_cmd_vtysh,
	"debug bgp neighbor-events <A.B.C.D|X:X::X:X|WORD>",
	"Debugging functions\n"
	"BGP information\n"
	"BGP Neighbor Events\n"
	"BGP neighbor IP address to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n")

DEFSH (VTYSH_BGPD, debug_bgp_nht_cmd_vtysh,
	"debug bgp nht",
	"Debugging functions\n"
	"BGP information\n"
	"BGP nexthop tracking events\n")

DEFSH (VTYSH_BGPD, debug_bgp_pbr_cmd_vtysh,
	"debug bgp pbr [error]",
	"Debugging functions\n"
	"BGP information\n"
	"BGP policy based routing\n"
	"BGP PBR error\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_cmd_vtysh,
	"debug bgp updates",
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_detail_cmd_vtysh,
	"[no] debug bgp updates detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Show detailed information about updates\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_direct_cmd_vtysh,
	"debug bgp updates <in|out>",
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Inbound updates\n"
	"Outbound updates\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_direct_peer_cmd_vtysh,
	"debug bgp updates <in|out> <A.B.C.D|X:X::X:X|WORD> [prefix-list PREFIXLIST_NAME$plist]",
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Inbound updates\n"
	"Outbound updates\n"
	"BGP neighbor IP address to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n"
	"Use prefix-list to filter prefixes to debug\n"
	"Name of prefix-list\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_groups_cmd_vtysh,
	"debug bgp update-groups",
	"Debugging functions\n"
	"BGP information\n"
	"BGP update-groups\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_prefix_afi_safi_cmd_vtysh,
	"debug bgp updates prefix l2vpn$afi evpn$safi type <<macip|2> mac <X:X:X:X:X:X|X:X:X:X:X:X/M> [ip <A.B.C.D|X:X::X:X>]|<multicast|3> ip <A.B.C.D|X:X::X:X>|<prefix|5> ip <A.B.C.D/M|X:X::X:X/M>>",
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Specify a prefix to debug\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC address\n"
	"MAC address\n"
	"MAC address\n"
	"IP information\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"IP information\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n"
	"IP information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, debug_bgp_update_prefix_cmd_vtysh,
	"debug bgp updates prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, debug_bgp_vnc_cmd_vtysh,
	"debug bgp vnc <rfapi-query|import-bi-attach|import-del-remote|verbose>",
	"Debugging functions\n"
	"BGP information\n"
	"VNC information\n"
	"rfapi query handling\n"
	"import BI atachment\n"
	"import delete remote routes\n"
	"verbose logging\n")

DEFSH (VTYSH_BGPD, debug_bgp_vpn_cmd_vtysh,
	"debug bgp vpn <leak-from-vrf|leak-to-vrf|rmap-event|label>",
	"Debugging functions\n"
	"BGP information\n"
	"VPN routes\n"
	"leaked from vrf to vpn\n"
	"leaked to vrf from vpn\n"
	"route-map updates\n"
	"labels\n")

DEFSH (VTYSH_BGPD, debug_bgp_zebra_cmd_vtysh,
	"debug bgp zebra",
	"Debugging functions\n"
	"BGP information\n"
	"BGP Zebra messages\n")

DEFSH (VTYSH_BGPD, debug_bgp_zebra_prefix_cmd_vtysh,
	"debug bgp zebra prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Debugging functions\n"
	"BGP information\n"
	"BGP Zebra messages\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_PIMD, debug_bsm_cmd_vtysh,
	"debug pim bsm",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"BSR message processing activity\n")

DEFSH (VTYSH_EIGRPD, debug_eigrp_packets_all_cmd_vtysh,
	"debug eigrp packets <siaquery|siareply|ack|hello|probe|query|reply|request|retry|stub|terse|update|all> [send|receive] [detail]",
	"Debugging functions\n"
	"EIGRP information\n"
	"EIGRP packets\n"
	"EIGRP SIA-Query packets\n"
	"EIGRP SIA-Reply packets\n"
	"EIGRP ack packets\n"
	"EIGRP hello packets\n"
	"EIGRP probe packets\n"
	"EIGRP query packets\n"
	"EIGRP reply packets\n"
	"EIGRP request packets\n"
	"EIGRP retransmissions\n"
	"EIGRP stub packets\n"
	"Display all EIGRP packets except Hellos\n"
	"EIGRP update packets\n"
	"Display all EIGRP packets\n"
	"Send Packets\n"
	"Receive Packets\n"
	"Detail Information\n")

DEFSH (VTYSH_EIGRPD, debug_eigrp_transmit_cmd_vtysh,
	"debug eigrp transmit <send|recv|all> [detail]",
	"Debugging functions\n"
	"EIGRP information\n"
	"EIGRP transmission events\n"
	"packet sent\n"
	"packet received\n"
	"all packets\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIMD, debug_graft_cmd_vtysh,
	"[no] debug pim graft",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM Graft processing activity\n")

DEFSH (VTYSH_PIMD, debug_igmp_cmd_vtysh,
	"debug igmp",
	"Debugging functions\n"
	"IGMP protocol activity\n")

DEFSH (VTYSH_PIMD, debug_igmp_events_cmd_vtysh,
	"debug igmp events",
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP protocol events\n")

DEFSH (VTYSH_PIMD, debug_igmp_packets_cmd_vtysh,
	"debug igmp packets",
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP protocol packets\n")

DEFSH (VTYSH_PIMD, debug_igmp_trace_cmd_vtysh,
	"debug igmp trace",
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP internal daemon activity\n")

DEFSH (VTYSH_PIMD, debug_igmp_trace_detail_cmd_vtysh,
	"debug igmp trace detail",
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP internal daemon activity\n"
	"detailed\n")

DEFSH (VTYSH_ISISD, debug_isis_adj_cmd_vtysh,
	"debug isis adj-packets",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Adjacency related packets\n")

DEFSH (VTYSH_ISISD, debug_isis_bfd_cmd_vtysh,
	"debug isis bfd",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"isis interaction with BFD\n")

DEFSH (VTYSH_ISISD, debug_isis_events_cmd_vtysh,
	"debug isis events",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Events\n")

DEFSH (VTYSH_ISISD, debug_isis_flooding_cmd_vtysh,
	"debug isis flooding",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"Flooding algorithm\n")

DEFSH (VTYSH_ISISD, debug_isis_ldp_sync_cmd_vtysh,
	"debug isis ldp-sync",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"isis interaction with LDP-Sync\n")

DEFSH (VTYSH_ISISD, debug_isis_lfa_cmd_vtysh,
	"debug isis lfa",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS LFA Events\n")

DEFSH (VTYSH_ISISD, debug_isis_lsp_gen_cmd_vtysh,
	"debug isis lsp-gen",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS generation of own LSPs\n")

DEFSH (VTYSH_ISISD, debug_isis_lsp_sched_cmd_vtysh,
	"debug isis lsp-sched",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS scheduling of LSP generation\n")

DEFSH (VTYSH_ISISD, debug_isis_packet_dump_cmd_vtysh,
	"debug isis packet-dump",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS packet dump\n")

DEFSH (VTYSH_ISISD, debug_isis_rtevents_cmd_vtysh,
	"debug isis route-events",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Route related events\n")

DEFSH (VTYSH_ISISD, debug_isis_snp_cmd_vtysh,
	"debug isis snp-packets",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS CSNP/PSNP packets\n")

DEFSH (VTYSH_ISISD, debug_isis_spfevents_cmd_vtysh,
	"debug isis spf-events",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Shortest Path First Events\n")

DEFSH (VTYSH_ISISD, debug_isis_srevents_cmd_vtysh,
	"debug isis sr-events",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Segment Routing Events\n")

DEFSH (VTYSH_ISISD, debug_isis_teevents_cmd_vtysh,
	"debug isis te-events",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Traffic Engineering Events\n")

DEFSH (VTYSH_ISISD, debug_isis_tx_queue_cmd_vtysh,
	"debug isis tx-queue",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS TX queues\n")

DEFSH (VTYSH_ISISD, debug_isis_upd_cmd_vtysh,
	"debug isis update-packets",
	"Debugging functions\n"
	"IS-IS routing protocol\n"
	"IS-IS Update related packets\n")

DEFSH (VTYSH_MGMT_BACKEND, debug_mgmt_client_be_cmd_vtysh,
	"[no] debug mgmt client backend",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Management Daemon (MGMTD) information\n"
	"client\n"
	"backend\n")

DEFSH (VTYSH_MGMT_FRONTEND, debug_mgmt_client_fe_cmd_vtysh,
	"[no] debug mgmt client frontend",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Management Daemon (MGMTD) information\n"
	"client\n"
	"frontend\n")

DEFSH (VTYSH_MGMTD, debug_mgmt_cmd_vtysh,
	"[no$no] debug mgmt {backend$be|datastore$ds|frontend$fe|transaction$txn}",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Management Daemon (MGMTD) information\n"
	"Backend debug\n"
	"Datastore debug\n"
	"Frontend debug\n"
	"Transaction debug\n")

DEFSH (VTYSH_PIM6D, debug_mld_cmd_vtysh,
	"[no] debug mld",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MLD protocol activity\n")

DEFSH (VTYSH_PIM6D, debug_mld_events_cmd_vtysh,
	"[no] debug mld events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MLD protocol activity\n"
	"MLD protocol events\n")

DEFSH (VTYSH_PIM6D, debug_mld_packets_cmd_vtysh,
	"[no] debug mld packets",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MLD protocol activity\n"
	"MLD protocol packets\n")

DEFSH (VTYSH_PIM6D, debug_mld_trace_cmd_vtysh,
	"[no] debug mld trace",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MLD protocol activity\n"
	"MLD internal daemon activity\n")

DEFSH (VTYSH_PIM6D, debug_mld_trace_detail_cmd_vtysh,
	"[no] debug mld trace detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MLD protocol activity\n"
	"MLD internal daemon activity\n"
	"detailed\n")

DEFSH (VTYSH_PIM6D, debug_mroute6_cmd_vtysh,
	"[no] debug mroute6",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 interaction with kernel MFC cache\n")

DEFSH (VTYSH_PIM6D, debug_mroute6_detail_cmd_vtysh,
	"[no] debug mroute6 detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 interaction with kernel MFC cache\n"
	"detailed\n")

DEFSH (VTYSH_PIMD, debug_mroute_cmd_vtysh,
	"debug mroute",
	"Debugging functions\n"
	"PIM interaction with kernel MFC cache\n")

DEFSH (VTYSH_PIMD, debug_mroute_detail_cmd_vtysh,
	"debug mroute detail",
	"Debugging functions\n"
	"PIM interaction with kernel MFC cache\n"
	"detailed\n")

DEFSH (VTYSH_PIMD, debug_msdp_cmd_vtysh,
	"debug msdp",
	"Debugging functions\n"
	"MSDP protocol activity\n")

DEFSH (VTYSH_PIMD, debug_msdp_events_cmd_vtysh,
	"debug msdp events",
	"Debugging functions\n"
	"MSDP protocol activity\n"
	"MSDP protocol events\n")

DEFSH (VTYSH_PIMD, debug_msdp_packets_cmd_vtysh,
	"debug msdp packets",
	"Debugging functions\n"
	"MSDP protocol activity\n"
	"MSDP protocol packets\n")

DEFSH (VTYSH_PIMD, debug_mtrace_cmd_vtysh,
	"debug mtrace",
	"Debugging functions\n"
	"Mtrace protocol activity\n")

DEFSH (VTYSH_NHRPD, debug_nhrp_cmd_vtysh,
	"debug nhrp <all|common|event|interface|kernel|route|vici>",
	"Enable debug messages for specific or all parts.\n"
	"NHRP information\n"
	"All messages\n"
	"Common messages (default)\n"
	"Event manager messages\n"
	"Interface messages\n"
	"Kernel messages\n"
	"Route messages\n"
	"VICI messages\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_abr_cmd_vtysh,
	"debug ospf6 abr",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 ABR function\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_asbr_cmd_vtysh,
	"debug ospf6 asbr",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 ASBR function\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_auth_cmd_vtysh,
	"debug ospf6 authentication [<tx|rx>]",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"debug OSPF6 authentication\n"
	"debug authentication tx\n"
	"debug authentication rx\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_brouter_area_cmd_vtysh,
	"debug ospf6 border-routers area-id A.B.C.D",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n"
	"Debug border routers in specific Area\n"
	"Specify Area-ID\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_brouter_cmd_vtysh,
	"debug ospf6 border-routers",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_brouter_router_cmd_vtysh,
	"debug ospf6 border-routers router-id A.B.C.D",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n"
	"Debug specific border router\n"
	"Specify border-router's router-id\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_event_cmd_vtysh,
	"[no] debug ospf6 event",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 event function\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_flooding_cmd_vtysh,
	"debug ospf6 flooding",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 flooding function\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_gr_cmd_vtysh,
	"[no$no] debug ospf6 graceful-restart",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Graceful restart\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_interface_cmd_vtysh,
	"debug ospf6 interface",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 Interface\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_lsa_aggregation_cmd_vtysh,
	"[no] debug ospf6 lsa aggregation",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug Link State Advertisements (LSAs)\n"
	"External LSA Aggregation\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_lsa_all_cmd_vtysh,
	"[no$no] debug ospf6 lsa all",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug Link State Advertisements (LSAs)\n"
	"Display for all types of LSAs\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_lsa_hex_cmd_vtysh,
	"debug ospf6 lsa <router|network|inter-prefix|inter-router|as-external|nssa|link|intra-prefix|unknown> [<originate|examine|flooding>]",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug Link State Advertisements (LSAs)\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display NSSA LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Display LSAs of unknown origin\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_message_cmd_vtysh,
	"debug ospf6 message <unknown|hello|dbdesc|lsreq|lsupdate|lsack|all> [<send|recv|send-hdr|recv-hdr>]",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 message\n"
	"Debug Unknown message\n"
	"Debug Hello message\n"
	"Debug Database Description message\n"
	"Debug Link State Request message\n"
	"Debug Link State Update message\n"
	"Debug Link State Acknowledgement message\n"
	"Debug All message\n"
	"Debug only sending message, entire packet\n"
	"Debug only receiving message, entire packet\n"
	"Debug only sending message, header only\n"
	"Debug only receiving message, header only\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_neighbor_cmd_vtysh,
	"debug ospf6 neighbor [<state|event>]",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 Neighbor\n"
	"Debug OSPFv3 Neighbor State Change\n"
	"Debug OSPFv3 Neighbor Event\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_nssa_cmd_vtysh,
	"debug ospf6 nssa",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 NSSA function\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_route_cmd_vtysh,
	"[no$no] debug ospf6 route <all|table|intra-area|inter-area|memory>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug routes\n"
	"Debug for all types of route calculation\n"
	"Debug route table calculation\n"
	"Debug intra-area route calculation\n"
	"Debug inter-area route calculation\n"
	"Debug route memory use\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_spf_database_cmd_vtysh,
	"debug ospf6 spf database",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug SPF Calculation\n"
	"Log number of LSAs at SPF Calculation time\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_spf_process_cmd_vtysh,
	"debug ospf6 spf process",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug SPF Calculation\n"
	"Debug Detailed SPF Process\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_spf_time_cmd_vtysh,
	"debug ospf6 spf time",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug SPF Calculation\n"
	"Measure time taken by SPF Calculation\n")

DEFSH (VTYSH_OSPF6D, debug_ospf6_zebra_sendrecv_cmd_vtysh,
	"debug ospf6 zebra [<send|recv>]",
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug connection between zebra\n"
	"Debug Sending zebra\n"
	"Debug Receiving zebra\n")

DEFSH (VTYSH_OSPFD, debug_ospf_bfd_cmd_vtysh,
	"[no] debug ospf [(1-65535)$instance] bfd",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"Bidirection Forwarding Detection\n")

DEFSH (VTYSH_OSPFD, debug_ospf_client_api_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] client-api",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF client API information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_default_info_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] default-information",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF default information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_event_cmd_vtysh,
	"debug ospf event",
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF event information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_gr_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] graceful-restart",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Graceful Restart\n")

DEFSH (VTYSH_OSPFD, debug_ospf_instance_event_cmd_vtysh,
	"debug ospf (1-65535) event",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF event information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_instance_lsa_cmd_vtysh,
	"debug ospf (1-65535) lsa [<generate|flooding|install|refresh|aggregate>]",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Link State Advertisement\n"
	"LSA Generation\n"
	"LSA Flooding\n"
	"LSA Install/Delete\n"
	"LSA Refresh\n"
	"External LSA Aggregation\n")

DEFSH (VTYSH_OSPFD, debug_ospf_instance_nsm_cmd_vtysh,
	"debug ospf (1-65535) nsm [<status|events|timers>]",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Neighbor State Machine\n"
	"NSM Status Information\n"
	"NSM Event Information\n"
	"NSM Timer Information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_instance_nssa_cmd_vtysh,
	"debug ospf (1-65535) nssa",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF nssa information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_instance_zebra_cmd_vtysh,
	"debug ospf (1-65535) zebra [<interface|redistribute>]",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"Zebra information\n"
	"Zebra interface\n"
	"Zebra redistribute\n")

DEFSH (VTYSH_OSPFD, debug_ospf_ism_cmd_vtysh,
	"debug ospf [(1-65535)] ism [<status|events|timers>]",
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Interface State Machine\n"
	"ISM Status Information\n"
	"ISM Event Information\n"
	"ISM TImer Information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_ldp_sync_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] ldp-sync",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF LDP-Sync information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_lsa_cmd_vtysh,
	"debug ospf lsa [<generate|flooding|install|refresh|aggregate>]",
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF Link State Advertisement\n"
	"LSA Generation\n"
	"LSA Flooding\n"
	"LSA Install/Delete\n"
	"LSA Refresh\n"
	"External LSA Aggregation\n")

DEFSH (VTYSH_OSPFD, debug_ospf_nsm_cmd_vtysh,
	"debug ospf nsm [<status|events|timers>]",
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF Neighbor State Machine\n"
	"NSM Status Information\n"
	"NSM Event Information\n"
	"NSM Timer Information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_nssa_cmd_vtysh,
	"debug ospf nssa",
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF nssa information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_opaque_lsa_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] opaque-lsa",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Opaque LSA information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_packet_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$inst] packet <hello|dd|ls-request|ls-update|ls-ack|all>$packet [<send$send [detail$detail]|recv$recv [detail$detail]|detail$detail>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF packets\n"
	"OSPF Hello\n"
	"OSPF Database Description\n"
	"OSPF Link State Request\n"
	"OSPF Link State Update\n"
	"OSPF Link State Acknowledgment\n"
	"OSPF all packets\n"
	"Packet sent\n"
	"Detail Information\n"
	"Packet received\n"
	"Detail Information\n"
	"Detail Information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_sr_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] sr",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF-SR information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_te_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] te",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF-TE information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_ti_lfa_cmd_vtysh,
	"[no$no] debug ospf [(1-65535)$instance] ti-lfa",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF-SR TI-LFA information\n")

DEFSH (VTYSH_OSPFD, debug_ospf_zebra_cmd_vtysh,
	"debug ospf zebra [<interface|redistribute>]",
	"Debugging functions\n"
	"OSPF information\n"
	"Zebra information\n"
	"Zebra interface\n"
	"Zebra redistribute\n")

DEFSH (VTYSH_PATHD, debug_path_policy_cmd_vtysh,
	"[no] debug pathd policy",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"path debugging\n"
	"policy debugging\n")

DEFSH (VTYSH_PATHD, debug_path_ted_cmd_vtysh,
	"[no] debug pathd mpls-te",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"path debugging\n"
	"ted debugging\n")

DEFSH (VTYSH_PBRD, debug_pbr_cmd_vtysh,
	"[no] debug pbr [{map$map|zebra$zebra|nht$nht|events$events}]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Policy Based Routing\n"
	"Policy maps\n"
	"PBRD <-> Zebra communications\n"
	"Nexthop tracking\n"
	"Events\n")

DEFSH (VTYSH_PIMD, debug_pim_cmd_vtysh,
	"[no] debug pim",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n")

DEFSH (VTYSH_PIMD, debug_pim_events_cmd_vtysh,
	"[no] debug pim events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM protocol events\n")

DEFSH (VTYSH_PIMD, debug_pim_mlag_cmd_vtysh,
	"debug pim mlag",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM Mlag activity\n")

DEFSH (VTYSH_PIMD, debug_pim_nht_cmd_vtysh,
	"[no] debug pim nht",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"Nexthop Tracking\n")

DEFSH (VTYSH_PIMD, debug_pim_nht_det_cmd_vtysh,
	"[no] debug pim nht detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"Nexthop Tracking\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIMD, debug_pim_nht_rp_cmd_vtysh,
	"debug pim nht rp",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"Nexthop Tracking\n"
	"RP Nexthop Tracking\n")

DEFSH (VTYSH_PIMD, debug_pim_packetdump_recv_cmd_vtysh,
	"[no] debug pim packet-dump receive",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM packet dump\n"
	"Dump received packets\n")

DEFSH (VTYSH_PIMD, debug_pim_packetdump_send_cmd_vtysh,
	"[no] debug pim packet-dump send",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM packet dump\n"
	"Dump sent packets\n")

DEFSH (VTYSH_PIMD, debug_pim_packets_cmd_vtysh,
	"[no] debug pim packets [<hello$hello|joins$joins|register$registers>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM protocol packets\n"
	"PIM Hello protocol packets\n"
	"PIM Join/Prune protocol packets\n"
	"PIM Register/Reg-Stop protocol packets\n")

DEFSH (VTYSH_PIMD, debug_pim_static_cmd_vtysh,
	"debug pim static",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM Static Multicast Route activity\n")

DEFSH (VTYSH_PIMD, debug_pim_trace_cmd_vtysh,
	"[no] debug pim trace",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM internal daemon activity\n")

DEFSH (VTYSH_PIMD, debug_pim_trace_detail_cmd_vtysh,
	"[no] debug pim trace detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM internal daemon activity\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIMD, debug_pim_vxlan_cmd_vtysh,
	"debug pim vxlan",
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM VxLAN events\n")

DEFSH (VTYSH_PIMD, debug_pim_zebra_cmd_vtysh,
	"[no] debug pim zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"ZEBRA protocol activity\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_bsm_cmd_vtysh,
	"[no] debug pimv6 bsm",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"BSR message processing activity\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_cmd_vtysh,
	"[no] debug pimv6",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_events_cmd_vtysh,
	"[no] debug pimv6 events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 protocol events\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_nht_cmd_vtysh,
	"[no] debug pimv6 nht",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"Nexthop Tracking\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_nht_det_cmd_vtysh,
	"[no] debug pimv6 nht detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"Nexthop Tracking\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_packetdump_recv_cmd_vtysh,
	"[no] debug pimv6 packet-dump receive",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 packet dump\n"
	"Dump received packets\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_packetdump_send_cmd_vtysh,
	"[no] debug pimv6 packet-dump send",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 packet dump\n"
	"Dump sent packets\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_packets_cmd_vtysh,
	"[no] debug pimv6 packets [<hello$hello|joins$joins|register$registers>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 protocol packets\n"
	"PIMv6 Hello protocol packets\n"
	"PIMv6 Join/Prune protocol packets\n"
	"PIMv6 Register/Reg-Stop protocol packets\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_trace_cmd_vtysh,
	"[no] debug pimv6 trace",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 internal daemon activity\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_trace_detail_cmd_vtysh,
	"[no] debug pimv6 trace detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"PIMv6 internal daemon activity\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIM6D, debug_pimv6_zebra_cmd_vtysh,
	"[no] debug pimv6 zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIMv6 protocol activity\n"
	"ZEBRA protocol activity\n")

DEFSH (VTYSH_BABELD|VTYSH_BGPD|VTYSH_EIGRPD|VTYSH_FABRICD|VTYSH_ISISD|VTYSH_OSPFD|VTYSH_PIMD|VTYSH_RIPD|VTYSH_ZEBRA, debug_prefix_list_match_cmd_vtysh,
	"debug prefix-list WORD$prefix-list match <A.B.C.D/M|X:X::X:X/M> [address-mode$addr_mode]",
	"Debugging functions\n"
	"Prefix-list test access\n"
	"Name of a prefix list\n"
	"Test prefix for prefix list result\n"
	"Prefix to test in ip prefix-list\n"
	"Prefix to test in ipv6 prefix-list\n"
	"Use address matching mode (PIM RP)\n")

DEFSH (VTYSH_BGPD|VTYSH_NHRPD, debug_resolver_cmd_vtysh,
	"[no] debug resolver",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Debug DNS resolver actions\n")

DEFSH (VTYSH_BGPD, debug_rfapi_close_rfd_cmd_vtysh,
	"debug rfapi-dev close rfd HANDLE",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_close\n"
	"indicate handle follows\n"
	"rfapi handle in hexadecimal\n")

DEFSH (VTYSH_BGPD, debug_rfapi_close_vn_un_cmd_vtysh,
	"debug rfapi-dev close vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_close\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate xt addr follows\n"
	"underlay network interface IPv4 address\n"
	"underlay network interface IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_open_cmd_vtysh,
	"debug rfapi-dev open vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_open\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate xt addr follows\n"
	"underlay network interface IPv4 address\n"
	"underlay network interface IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_query_vn_un_cmd_vtysh,
	"debug rfapi-dev query vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> target <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_query\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate un addr follows\n"
	"IPv4 un address\n"
	"IPv6 un address\n"
	"indicate target follows\n"
	"target IPv4 address\n"
	"target IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_query_vn_un_done_cmd_vtysh,
	"debug rfapi-dev query done vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> target <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_query_done\n"
	"rfapi_query_done\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate xt addr follows\n"
	"underlay network interface IPv4 address\n"
	"underlay network interface IPv6 address\n"
	"indicate target follows\n"
	"Target IPv4 address\n"
	"Target IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_query_vn_un_l2o_cmd_vtysh,
	"debug rfapi-dev query vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> lni LNI target X:X:X:X:X:X",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_query\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate xt addr follows\n"
	"underlay network interface IPv4 address\n"
	"underlay network interface IPv6 address\n"
	"logical network ID follows\n"
	"logical network ID\n"
	"indicate target MAC addr follows\n"
	"target MAC addr\n")

DEFSH (VTYSH_BGPD, debug_rfapi_register_vn_un_cmd_vtysh,
	"debug rfapi-dev register vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> lifetime SECONDS [cost (0-255)]",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_register\n"
	"indicate vn addr follows\n"
	"virtual network IPv4 interface address\n"
	"virtual network IPv6 interface address\n"
	"indicate un addr follows\n"
	"underlay network IPv4 interface address\n"
	"underlay network IPv6 interface address\n"
	"indicate prefix follows\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"indicate lifetime follows\n"
	"lifetime\n"
	"Cost (localpref = 255-cost)\n"
	"0-255\n")

DEFSH (VTYSH_BGPD, debug_rfapi_register_vn_un_l2o_cmd_vtysh,
	"debug rfapi-dev register vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> lifetime SECONDS macaddr X:X:X:X:X:X lni (0-16777215)",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_register\n"
	"indicate vn addr follows\n"
	"virtual network IPv4 interface address\n"
	"virtual network IPv6 interface address\n"
	"indicate un addr follows\n"
	"underlay network IPv4 interface address\n"
	"underlay network IPv6 interface address\n"
	"indicate prefix follows\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"indicate lifetime follows\n"
	"Seconds of lifetime\n"
	"indicate MAC address follows\n"
	"MAC address\n"
	"indicate lni follows\n"
	"lni value range\n")

DEFSH (VTYSH_BGPD, debug_rfapi_response_omit_self_cmd_vtysh,
	"debug rfapi-dev response-omit-self <on|off>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"Omit self in RFP responses\n"
	"filter out self from responses\n"
	"leave self in responses\n")

DEFSH (VTYSH_BGPD, debug_rfapi_show_import_cmd_vtysh,
	"debug rfapi-dev show import",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"Show running system information\n"
	"import\n")

DEFSH (VTYSH_BGPD, debug_rfapi_show_import_vn_un_cmd_vtysh,
	"debug rfapi-dev show import vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"Show running system information\n"
	"import\n"
	"indicate vn addr follows\n"
	"virtual network interface IPv4 address\n"
	"virtual network interface IPv6 address\n"
	"indicate xt addr follows\n"
	"underlay network interface IPv4 address\n"
	"underlay network interface IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_show_nves_cmd_vtysh,
	"debug rfapi-dev show nves",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"Show running system information\n"
	"NVE Information\n")

DEFSH (VTYSH_BGPD, debug_rfapi_show_nves_vn_un_cmd_vtysh,
	"debug rfapi-dev show nves <vn|un> <A.B.C.D|X:X::X:X>",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"Show running system information\n"
	"NVE Information\n"
	"Specify virtual network\n"
	"Specify underlay network interface\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_BGPD, debug_rfapi_unregister_vn_un_cmd_vtysh,
	"debug rfapi-dev unregister vn <A.B.C.D|X:X::X:X> un <A.B.C.D|X:X::X:X> prefix <A.B.C.D/M|X:X::X:X/M> [kill]",
	"Debugging functions\n"
	"RF API debugging/testing command\n"
	"rfapi_unregister\n"
	"indicate vn addr follows\n"
	"virtual network interface address\n"
	"virtual network interface address\n"
	"indicate xt addr follows\n"
	"underlay network interface address\n"
	"underlay network interface address\n"
	"prefix to remove\n"
	"prefix to remove\n"
	"prefix to remove\n"
	"Remove without holddown\n")

DEFSH (VTYSH_RIPD, debug_rip_events_cmd_vtysh,
	"debug rip events",
	"Debugging functions\n"
	"RIP information\n"
	"RIP events\n")

DEFSH (VTYSH_RIPD, debug_rip_packet_cmd_vtysh,
	"debug rip packet",
	"Debugging functions\n"
	"RIP information\n"
	"RIP packet\n")

DEFSH (VTYSH_RIPD, debug_rip_packet_direct_cmd_vtysh,
	"debug rip packet <recv|send>",
	"Debugging functions\n"
	"RIP information\n"
	"RIP packet\n"
	"RIP receive packet\n"
	"RIP send packet\n")

DEFSH (VTYSH_RIPD, debug_rip_zebra_cmd_vtysh,
	"debug rip zebra",
	"Debugging functions\n"
	"RIP information\n"
	"RIP and ZEBRA communication\n")

DEFSH (VTYSH_RIPNGD, debug_ripng_events_cmd_vtysh,
	"debug ripng events",
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng events\n")

DEFSH (VTYSH_RIPNGD, debug_ripng_packet_cmd_vtysh,
	"debug ripng packet",
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng packet\n")

DEFSH (VTYSH_RIPNGD, debug_ripng_packet_direct_cmd_vtysh,
	"debug ripng packet <recv|send>",
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng packet\n"
	"Debug option set for receive packet\n"
	"Debug option set for send packet\n")

DEFSH (VTYSH_RIPNGD, debug_ripng_zebra_cmd_vtysh,
	"debug ripng zebra",
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng and zebra communication\n")

DEFSH (VTYSH_RMAP_SHOW, debug_rmap_cmd_vtysh,
	"debug route-map [detail]$detail",
	"Debugging functions\n"
	"Debug option set for route-maps\n"
	"Detailed output\n")

DEFSH (VTYSH_BGPD, debug_rpki_cmd_vtysh,
	"debug rpki",
	"Debugging functions\n"
	"Enable debugging for rpki\n")

DEFSH (VTYSH_PIMD, debug_ssmpingd_cmd_vtysh,
	"debug ssmpingd",
	"Debugging functions\n"
	"ssmpingd activity\n")

DEFSH (VTYSH_PIMD, debug_state_refresh_cmd_vtysh,
	"[no] debug pim state-refresh",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM State Refresh processing activity\n")

DEFSH (VTYSH_STATICD, debug_staticd_cmd_vtysh,
	"[no] debug static [{events$events|route$route|bfd$bfd|srv6$srv6}]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Static route daemon\n"
	"Debug events\n"
	"Debug route\n"
	"Debug bfd\n"
	"Debug srv6\n")

DEFSH (VTYSH_VRRPD, debug_vrrp_cmd_vtysh,
	"[no] debug vrrp [{protocol$proto|autoconfigure$ac|packets$pkt|sockets$sock|ndisc$ndisc|arp$arp|zebra$zebra}]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Virtual Router Redundancy Protocol\n"
	"Debug protocol state\n"
	"Debug autoconfiguration\n"
	"Debug sent and received packets\n"
	"Debug socket creation and configuration\n"
	"Debug Neighbor Discovery\n"
	"Debug ARP\n"
	"Debug Zebra events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_dplane_cmd_vtysh,
	"debug zebra dplane [detailed]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra dataplane events\n"
	"Detailed debug information\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_dplane_dpdk_cmd_vtysh,
	"[no$no] debug zebra dplane dpdk [detailed$detail]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra dataplane events\n"
	"Debug zebra DPDK offload events\n"
	"Detailed debug information\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_events_cmd_vtysh,
	"debug zebra events",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_evpn_mh_cmd_vtysh,
	"[no$no] debug zebra evpn mh <es$es|mac$mac|neigh$neigh|nh$nh>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"EVPN\n"
	"Multihoming\n"
	"Ethernet Segment Debugging\n"
	"MAC Debugging\n"
	"Neigh Debugging\n"
	"Nexthop Debugging\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_fpm_cmd_vtysh,
	"debug zebra fpm",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra FPM events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_kernel_cmd_vtysh,
	"debug zebra kernel",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra between kernel interface\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_kernel_msgdump_cmd_vtysh,
	"debug zebra kernel msgdump [<recv|send>]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra between kernel interface\n"
	"Dump raw netlink messages, sent and received\n"
	"Dump raw netlink messages received\n"
	"Dump raw netlink messages sent\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_mlag_cmd_vtysh,
	"[no$no] debug zebra mlag",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for mlag events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_mpls_cmd_vtysh,
	"debug zebra mpls [detailed$detail]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra MPLS LSPs\n"
	"Debug option for detailed info\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_neigh_cmd_vtysh,
	"[no$no] debug zebra neigh",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra neigh events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_nexthop_cmd_vtysh,
	"[no$no] debug zebra nexthop [detail$detail]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra nexthop events\n"
	"Detailed information\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_nht_cmd_vtysh,
	"debug zebra nht [detailed]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra next hop tracking\n"
	"Debug option set for detailed info\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_packet_cmd_vtysh,
	"debug zebra packet [<recv|send>] [detail]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra packet\n"
	"Debug option set for receive packet\n"
	"Debug option set for send packet\n"
	"Debug option set for detailed info\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_pbr_cmd_vtysh,
	"debug zebra pbr",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra pbr events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_pw_cmd_vtysh,
	"[no] debug zebra pseudowires",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra pseudowires\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_rib_cmd_vtysh,
	"debug zebra rib [detailed]",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug RIB events\n"
	"Detailed debugs\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_srv6_cmd_vtysh,
	"[no$no] debug zebra srv6",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra SRv6 events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_tc_cmd_vtysh,
	"debug zebra tc",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra tc events\n")

DEFSH (VTYSH_ZEBRA, debug_zebra_vxlan_cmd_vtysh,
	"debug zebra vxlan",
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra VxLAN (EVPN)\n")

DEFSH (VTYSH_ISISD, domain_passwd_cmd_vtysh,
	"domain-password <clear|md5>$pwd_type WORD$pwd [authenticate snp <send-only|validate>$snp]",
	"Set the authentication password for a routing domain\n"
	"Clear-text authentication type\n"
	"MD5 authentication type\n"
	"Level-wide password\n"
	"Authentication\n"
	"SNP PDUs\n"
	"Send but do not check PDUs on receiving\n"
	"Send and check PDUs on receiving\n")

DEFSH_HIDDEN (VTYSH_ISISD, dplane_ip_cmd_vtysh,
	"[no] dataplane ip",
	"Negate a command or set its defaults\n"
	"Advertise and participate in the specified Data-Planes\n"
	"Advertise and participate in IP data-plane\n")

DEFSH (VTYSH_ISISD, dplane_sr_mpls_cmd_vtysh,
	"[no] dataplane sr-mpls",
	"Negate a command or set its defaults\n"
	"Advertise and participate in the specified Data-Planes\n"
	"Advertise and participate in SR-MPLS data-plane\n")

DEFSH_HIDDEN (VTYSH_ISISD, dplane_srv6_cmd_vtysh,
	"[no] dataplane srv6",
	"Negate a command or set its defaults\n"
	"Advertise and participate in the specified Data-Planes\n"
	"Advertise and participate in SRv6 data-plane\n")

DEFSH (VTYSH_BGPD, dump_bgp_all_cmd_vtysh,
	"dump bgp <all|all-et|updates|updates-et|routes-mrt> PATH [INTERVAL]",
	"Dump packet\n"
	"BGP packet dump\n"
	"Dump all BGP packets\n"
	"Dump all BGP packets (Extended Timestamp Header)\n"
	"Dump BGP updates only\n"
	"Dump BGP updates only (Extended Timestamp Header)\n"
	"Dump whole BGP routing table\n"
	"Output filename\n"
	"Interval of output\n")

DEFSH (VTYSH_BGPD, dup_addr_detection_auto_recovery_cmd_vtysh,
	"dup-addr-detection freeze <permanent |(30-3600)$freeze_time_val>",
	"Duplicate address detection\n"
	"Duplicate address detection freeze\n"
	"Duplicate address detection permanent freeze\n"
	"Duplicate address detection freeze time (30-3600)\n")

DEFSH (VTYSH_BGPD, dup_addr_detection_cmd_vtysh,
	"dup-addr-detection [max-moves (2-1000)$max_moves_val time (2-1800)$time_val]",
	"Duplicate address detection\n"
	"Max allowed moves before address detected as duplicate\n"
	"Num of max allowed moves (2-1000) default 5\n"
	"Duplicate address detection time\n"
	"Time in seconds (2-1800) default 180\n")

DEFSH (VTYSH_ISISD, dynamic_hostname_cmd_vtysh,
	"[no] hostname dynamic",
	"Negate a command or set its defaults\n"
	"Dynamic hostname for IS-IS\n"
	"Dynamic hostname\n")

DEFSH (VTYSH_NH_GROUP, ecmp_nexthops_cmd_vtysh,
	"[no] nexthop        <	  <A.B.C.D|X:X::X:X>$addr [INTERFACE$intf [onlink$onlink]]	  |INTERFACE$intf	>	[{ 	   nexthop-vrf NAME$vrf_name 	   |label WORD 	   |vni (1-16777215)            |weight (1-4294967295)            |backup-idx WORD 	}]",
	"Negate a command or set its defaults\n"
	"Specify one of the nexthops in this ECMP group\n"
	"v4 Address\n"
	"v6 Address\n"
	"Interface to use\n"
	"Treat nexthop as directly attached to the interface\n"
	"Interface to use\n"
	"If the nexthop is in a different vrf tell us\n"
	"The nexthop-vrf Name\n"
	"Specify label(s) for this nexthop\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Specify VNI(s) for this nexthop\n"
	"VNI in the range (1-16777215)\n"
	"Weight to be used by the nexthop for purposes of ECMP\n"
	"Weight value to be used\n"
	"Specify backup nexthop indexes in another group\n"
	"One or more indexes in the range (0-254) separated by ','\n")

DEFSH (VTYSH_EIGRPD, eigrp_authentication_keychain_cmd_vtysh,
	"ip authentication key-chain eigrp (1-65535)$as WORD$name",
	"Interface Internet Protocol config commands\n"
	"Authentication subcommands\n"
	"Key-chain\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Name of key-chain\n")

DEFSH (VTYSH_EIGRPD, eigrp_authentication_mode_cmd_vtysh,
	"ip authentication mode eigrp (1-65535)$as <md5|hmac-sha-256>$crypt",
	"Interface Internet Protocol config commands\n"
	"Authentication subcommands\n"
	"Mode\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Keyed message digest\n"
	"HMAC SHA256 algorithm \n")

DEFSH (VTYSH_EIGRPD, eigrp_distribute_list_cmd_vtysh,
	"distribute-list ACCESSLIST4_NAME$name <in|out>$dir [WORD$ifname]",
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_EIGRPD, eigrp_distribute_list_prefix_cmd_vtysh,
	"distribute-list prefix PREFIXLIST4_NAME$name <in|out>$dir [WORD$ifname]",
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_EIGRPD, eigrp_if_bandwidth_cmd_vtysh,
	"eigrp bandwidth (1-10000000)$bw",
	"EIGRP information\n"
	"Set bandwidth informational parameter\n"
	"Bandwidth in kilobits\n")

DEFSH (VTYSH_EIGRPD, eigrp_if_delay_cmd_vtysh,
	"delay (1-16777215)$delay",
	"Specify interface throughput delay\n"
	"Throughput delay (tens of microseconds)\n")

DEFSH (VTYSH_EIGRPD, eigrp_if_ip_hellointerval_cmd_vtysh,
	"ip hello-interval eigrp (1-65535)$hello",
	"Interface Internet Protocol config commands\n"
	"Configures EIGRP hello interval\n"
	"EIGRP information\n"
	"Seconds between hello transmissions\n")

DEFSH (VTYSH_EIGRPD, eigrp_if_ip_holdinterval_cmd_vtysh,
	"ip hold-time eigrp (1-65535)$hold",
	"Interface Internet Protocol config commands\n"
	"Configures EIGRP IPv4 hold time\n"
	"EIGRP information\n"
	"Seconds before neighbor is considered down\n")

DEFSH (VTYSH_EIGRPD, eigrp_ip_summary_address_cmd_vtysh,
	"ip summary-address eigrp (1-65535)$as A.B.C.D/M$prefix",
	"Interface Internet Protocol config commands\n"
	"Perform address summarization\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Summary <network>/<length>, e.g. 192.168.0.0/16\n")

DEFSH (VTYSH_EIGRPD, eigrp_maximum_paths_cmd_vtysh,
	"maximum-paths (1-32)$maximum_paths",
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH (VTYSH_EIGRPD, eigrp_metric_weights_cmd_vtysh,
	"metric weights (0-255)$k1 (0-255)$k2 (0-255)$k3 (0-255)$k4 (0-255)$k5 [(0-255)$k6]",
	"Modify metrics and parameters for advertisement\n"
	"Modify metric coefficients\n"
	"K1\n"
	"K2\n"
	"K3\n"
	"K4\n"
	"K5\n"
	"K6\n")

DEFSH (VTYSH_EIGRPD, eigrp_neighbor_cmd_vtysh,
	"[no] neighbor A.B.C.D$addr",
	"Negate a command or set its defaults\n"
	"Specify a neighbor router\n"
	"Neighbor address\n")

DEFSH (VTYSH_EIGRPD, eigrp_network_cmd_vtysh,
	"[no] network A.B.C.D/M$prefix",
	"Negate a command or set its defaults\n"
	"Enable routing on an IP network\n"
	"EIGRP network prefix\n")

DEFSH (VTYSH_EIGRPD, eigrp_no_distribute_list_cmd_vtysh,
	"no distribute-list [ACCESSLIST4_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_EIGRPD, eigrp_no_distribute_list_prefix_cmd_vtysh,
	"no distribute-list prefix [PREFIXLIST4_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_EIGRPD, eigrp_passive_interface_cmd_vtysh,
	"[no] passive-interface IFNAME",
	"Negate a command or set its defaults\n"
	"Suppress routing updates on an interface\n"
	"Interface to suppress on\n")

DEFSH (VTYSH_EIGRPD, eigrp_redistribute_source_metric_cmd_vtysh,
	"[no] redistribute <kernel|connected|local|static|rip|ospf|isis|bgp|nhrp|vnc|babel|openfabric>$proto [metric (1-4294967295)$bw (0-4294967295)$delay (0-255)$rlbt (1-255)$load (1-65535)$mtu]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Bandwidth metric in Kbits per second\n"
	"EIGRP delay metric, in 10 microsecond units\n"
	"EIGRP reliability metric where 255 is 100% reliable2 ?\n"
	"EIGRP Effective bandwidth metric (Loading) where 255 is 100% loaded\n"
	"EIGRP MTU of the path\n")

DEFSH (VTYSH_EIGRPD, eigrp_router_id_cmd_vtysh,
	"eigrp router-id A.B.C.D$addr",
	"EIGRP information\n"
	"Router ID for this EIGRP process\n"
	"EIGRP Router-ID in IP address format\n")

DEFSH (VTYSH_EIGRPD, eigrp_timers_active_cmd_vtysh,
	"timers active-time <(1-65535)$timer|disabled$disabled>",
	"Adjust routing timers\n"
	"Time limit for active state\n"
	"Active state time limit in seconds\n"
	"Disable time limit for active state\n")

DEFSH (VTYSH_EIGRPD, eigrp_variance_cmd_vtysh,
	"variance (1-128)$variance",
	"Control load balancing variance\n"
	"Metric variance multiplier\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, evpn_accept_bgp_seq_cmd_vtysh,
	"evpn accept-bgp-seq",
	"EVPN\n"
	"Accept all sequence numbers from BGP\n")

DEFSH (VTYSH_ZEBRA, evpn_mh_mac_holdtime_cmd_vtysh,
	"[no$no] evpn mh mac-holdtime (0-86400)$duration",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"MAC hold time\n"
	"Duration in seconds\n")

DEFSH (VTYSH_ZEBRA, evpn_mh_neigh_holdtime_cmd_vtysh,
	"[no$no] evpn mh neigh-holdtime (0-86400)$duration",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Neighbor entry hold time\n"
	"Duration in seconds\n")

DEFSH (VTYSH_ZEBRA, evpn_mh_redirect_off_cmd_vtysh,
	"[no$no] evpn mh redirect-off",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"ES bond redirect for fast-failover off\n")

DEFSH (VTYSH_ZEBRA, evpn_mh_startup_delay_cmd_vtysh,
	"[no] evpn mh startup-delay(0-3600)$duration",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Startup delay\n"
	"duration in seconds\n")

DEFSH (VTYSH_BGPD, evpnrt5_network_cmd_vtysh,
	"network <A.B.C.D/M|X:X::X:X/M> rd ASN:NN_OR_IP-ADDRESS:NN ethtag WORD label WORD esi WORD gwip <A.B.C.D|X:X::X:X> routermac WORD [route-map RMAP_NAME]",
	"Specify a network to announce via BGP\n"
	"IP prefix\n"
	"IPv6 prefix\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"Ethernet Tag\n"
	"Ethernet Tag Value\n"
	"BGP label\n"
	"label value\n"
	"Ethernet Segment Identifier\n"
	"ESI value ( 00:11:22:33:44:55:66:77:88:99 format) \n"
	"Gateway IP\n"
	"Gateway IP ( A.B.C.D )\n"
	"Gateway IPv6 ( X:X::X:X )\n"
	"Router Mac Ext Comm\n"
	"Router Mac address Value ( aa:bb:cc:dd:ee:ff format)\n"
	"Route-map to modify the attributes\n"
	"Name of the route map\n")

DEFSH (VTYSH_ALL, exec_timeout_min_cmd_vtysh,
	"exec-timeout (0-35791)",
	"Set timeout value\n"
	"Timeout value in minutes\n")

DEFSH (VTYSH_ALL, exec_timeout_sec_cmd_vtysh,
	"exec-timeout (0-35791) (0-2147483)",
	"Set the EXEC timeout\n"
	"Timeout in minutes\n"
	"Timeout in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_area_lsp_mtu_cmd_vtysh,
	"lsp-mtu (128-4352)",
	"Configure the maximum size of generated LSPs\n"
	"Maximum size of generated LSPs\n")

DEFSH (VTYSH_FABRICD, fabricd_area_purge_originator_cmd_vtysh,
	"[no] purge-originator",
	"Negate a command or set its defaults\n"
	"Use the RFC 6232 purge-originator\n")

DEFSH (VTYSH_FABRICD, fabricd_circuit_topology_cmd_vtysh,
	"openfabric topology <standard|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc>",
	"OpenFabric routing protocol\n"
	"Configure interface IS-IS topologies\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n")

DEFSH (VTYSH_FABRICD, fabricd_clear_isis_neighbor_arg_cmd_vtysh,
	"clear openfabric [vrf <NAME|all>] neighbor WORD",
	"Reset functions\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"System id\n")

DEFSH (VTYSH_FABRICD, fabricd_clear_isis_neighbor_cmd_vtysh,
	"clear openfabric [vrf <NAME|all>] neighbor",
	"Reset functions\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n")

DEFSH (VTYSH_FABRICD, fabricd_csnp_interval_cmd_vtysh,
	"openfabric csnp-interval (1-600)",
	"OpenFabric routing protocol\n"
	"Set CSNP interval in seconds\n"
	"CSNP interval value\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_adj_cmd_vtysh,
	"debug openfabric adj-packets",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Adjacency related packets\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_bfd_cmd_vtysh,
	"debug openfabric bfd",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"openfabric interaction with BFD\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_events_cmd_vtysh,
	"debug openfabric events",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_flooding_cmd_vtysh,
	"debug openfabric flooding",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"Flooding algorithm\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_ldp_sync_cmd_vtysh,
	"debug openfabric ldp-sync",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"openfabric interaction with LDP-Sync\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_lfa_cmd_vtysh,
	"debug openfabric lfa",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS LFA Events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_lsp_gen_cmd_vtysh,
	"debug openfabric lsp-gen",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS generation of own LSPs\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_lsp_sched_cmd_vtysh,
	"debug openfabric lsp-sched",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS scheduling of LSP generation\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_packet_dump_cmd_vtysh,
	"debug openfabric packet-dump",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS packet dump\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_rtevents_cmd_vtysh,
	"debug openfabric route-events",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Route related events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_snp_cmd_vtysh,
	"debug openfabric snp-packets",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS CSNP/PSNP packets\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_spfevents_cmd_vtysh,
	"debug openfabric spf-events",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Shortest Path First Events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_srevents_cmd_vtysh,
	"debug openfabric sr-events",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Segment Routing Events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_teevents_cmd_vtysh,
	"debug openfabric te-events",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Traffic Engineering Events\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_tx_queue_cmd_vtysh,
	"debug openfabric tx-queue",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS TX queues\n")

DEFSH (VTYSH_FABRICD, fabricd_debug_isis_upd_cmd_vtysh,
	"debug openfabric update-packets",
	"Debugging functions\n"
	"OpenFabric routing protocol\n"
	"IS-IS Update related packets\n")

DEFSH (VTYSH_FABRICD, fabricd_domain_passwd_cmd_vtysh,
	"domain-password <clear|md5> WORD [authenticate snp <send-only|validate>]",
	"Set the authentication password for a routing domain\n"
	"Authentication type\n"
	"Authentication type\n"
	"Level-wide password\n"
	"Authentication\n"
	"SNP PDUs\n"
	"Send but do not check PDUs on receiving\n"
	"Send and check PDUs on receiving\n")

DEFSH (VTYSH_FABRICD, fabricd_fabric_tier_cmd_vtysh,
	"fabric-tier (0-14)",
	"Statically configure the tier to advertise\n"
	"Tier to advertise\n")

DEFSH (VTYSH_FABRICD, fabricd_ip6_router_isis_cmd_vtysh,
	"ipv6 router openfabric WORD",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"OpenFabric routing protocol\n"
	"Routing process tag\n")

DEFSH (VTYSH_FABRICD, fabricd_ip_router_isis_cmd_vtysh,
	"ip router openfabric WORD",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"OpenFabric routing protocol\n"
	"Routing process tag\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_bfd_cmd_vtysh,
	"openfabric bfd",
	"OpenFabric routing protocol\n"
	"Enable BFD support\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_default_originate_cmd_vtysh,
	"default-information originate <ipv4|ipv6> [always] [{metric (0-16777215)|route-map RMAP_NAME}]",
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Distribute default route for IPv4\n"
	"Distribute default route for IPv6\n"
	"Always advertise default route\n"
	"Metric for default route\n"
	"ISIS default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_hello_interval_cmd_vtysh,
	"openfabric hello-interval (1-600)",
	"OpenFabric routing protocol\n"
	"Set Hello interval\n"
	"Holdtime 1 seconds, interval depends on multiplier\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_hello_multiplier_cmd_vtysh,
	"openfabric hello-multiplier (2-100)",
	"OpenFabric routing protocol\n"
	"Set multiplier for Hello holding time\n"
	"Hello multiplier value\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_metric_cmd_vtysh,
	"openfabric metric (0-16777215)",
	"OpenFabric routing protocol\n"
	"Set default metric for circuit\n"
	"Default metric value\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_passive_cmd_vtysh,
	"openfabric passive",
	"OpenFabric routing protocol\n"
	"Configure the passive mode for interface\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_passwd_cmd_vtysh,
	"openfabric password <md5|clear> WORD",
	"OpenFabric routing protocol\n"
	"Configure the authentication password for a circuit\n"
	"HMAC-MD5 authentication\n"
	"Cleartext password\n"
	"Circuit password\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_redistribute_cmd_vtysh,
	"redistribute <ipv4 <kernel|connected|local|static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|babel>|ipv6 <kernel|connected|local|static|ripng|ospf6|isis|bgp|nhrp|vnc|babel>> [{metric (0-16777215)|route-map RMAP_NAME}]",
	"Redistribute information from another routing protocol\n"
	"Redistribute IPv4 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"Redistribute IPv6 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"Metric for redistributed routes\n"
	"ISIS default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_FABRICD, fabricd_isis_topology_cmd_vtysh,
	"topology <standard|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc> [overload]",
	"Configure IS-IS topologies\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n"
	"Set overload bit for topology\n")

DEFSH (VTYSH_FABRICD, fabricd_log_adj_changes_cmd_vtysh,
	"log-adjacency-changes",
	"Log changes in adjacency state\n")

DEFSH (VTYSH_FABRICD, fabricd_lsp_gen_interval_cmd_vtysh,
	"lsp-gen-interval (1-120)",
	"Minimum interval between regenerating same LSP\n"
	"Minimum interval in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_lsp_refresh_interval_cmd_vtysh,
	"lsp-refresh-interval (1-65235)",
	"LSP refresh interval\n"
	"LSP refresh interval in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_max_lsp_lifetime_cmd_vtysh,
	"max-lsp-lifetime (350-65535)",
	"Maximum LSP lifetime\n"
	"LSP lifetime in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_net_cmd_vtysh,
	"net WORD",
	"A Network Entity Title for this process (OSI only)\n"
	"XX.XXXX. ... .XXX.XX  Network entity title (NET)\n")

DEFSH (VTYSH_FABRICD, fabricd_no_area_lsp_mtu_cmd_vtysh,
	"no lsp-mtu [(128-4352)]",
	"Negate a command or set its defaults\n"
	"Configure the maximum size of generated LSPs\n"
	"Maximum size of generated LSPs\n")

DEFSH (VTYSH_FABRICD, fabricd_no_circuit_topology_cmd_vtysh,
	"no openfabric topology <standard|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc>",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Configure interface IS-IS topologies\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n")

DEFSH (VTYSH_FABRICD, fabricd_no_csnp_interval_cmd_vtysh,
	"no openfabric csnp-interval [(1-600)]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Set CSNP interval in seconds\n"
	"CSNP interval value\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_adj_cmd_vtysh,
	"no debug openfabric adj-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Adjacency related packets\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_bfd_cmd_vtysh,
	"no debug openfabric bfd",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"openfabric interaction with BFD\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_events_cmd_vtysh,
	"no debug openfabric events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_flooding_cmd_vtysh,
	"no debug openfabric flooding",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"Flooding algorithm\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_ldp_sync_cmd_vtysh,
	"no debug openfabric ldp-sync",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"openfabric interaction with LDP-Sync\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_lfa_cmd_vtysh,
	"no debug openfabric lfa",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS LFA Events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_lsp_gen_cmd_vtysh,
	"no debug openfabric lsp-gen",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS generation of own LSPs\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_lsp_sched_cmd_vtysh,
	"no debug openfabric lsp-sched",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS scheduling of LSP generation\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_packet_dump_cmd_vtysh,
	"no debug openfabric packet-dump",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS packet dump\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_rtevents_cmd_vtysh,
	"no debug openfabric route-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Route related events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_snp_cmd_vtysh,
	"no debug openfabric snp-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS CSNP/PSNP packets\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_spfevents_cmd_vtysh,
	"no debug openfabric spf-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Shortest Path First Events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_srevents_cmd_vtysh,
	"no debug openfabric sr-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Segment Routing Events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_teevents_cmd_vtysh,
	"no debug openfabric te-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Traffic Engineering Events\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_tx_queue_cmd_vtysh,
	"no debug openfabric tx-queue",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS TX queues\n")

DEFSH (VTYSH_FABRICD, fabricd_no_debug_isis_upd_cmd_vtysh,
	"no debug openfabric update-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"OpenFabric routing protocol\n"
	"IS-IS Update related packets\n")

DEFSH (VTYSH_FABRICD, fabricd_no_domain_passwd_cmd_vtysh,
	"no domain-password",
	"Negate a command or set its defaults\n"
	"Set the authentication password for a routing domain\n")

DEFSH (VTYSH_FABRICD, fabricd_no_fabric_tier_cmd_vtysh,
	"no fabric-tier [(0-14)]",
	"Negate a command or set its defaults\n"
	"Statically configure the tier to advertise\n"
	"Tier to advertise\n")

DEFSH (VTYSH_FABRICD, fabricd_no_ip_router_isis_cmd_vtysh,
	"no <ip|ipv6> router openfabric WORD",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IP router interface commands\n"
	"OpenFabric routing protocol\n"
	"Routing process tag\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_bfd_cmd_vtysh,
	"no openfabric bfd",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Disables BFD support\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_default_originate_cmd_vtysh,
	"no default-information originate <ipv4|ipv6>",
	"Negate a command or set its defaults\n"
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Distribute default route for IPv4\n"
	"Distribute default route for IPv6\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_hello_interval_cmd_vtysh,
	"no openfabric hello-interval [(1-600)]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Set Hello interval\n"
	"Holdtime 1 second, interval depends on multiplier\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_hello_multiplier_cmd_vtysh,
	"no openfabric hello-multiplier [(2-100)]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Set multiplier for Hello holding time\n"
	"Hello multiplier value\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_metric_cmd_vtysh,
	"no openfabric metric [(0-16777215)]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Set default metric for circuit\n"
	"Default metric value\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_passive_cmd_vtysh,
	"no openfabric passive",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Configure the passive mode for interface\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_passwd_cmd_vtysh,
	"no openfabric password [<md5|clear> WORD]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Configure the authentication password for a circuit\n"
	"HMAC-MD5 authentication\n"
	"Cleartext password\n"
	"Circuit password\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_redistribute_cmd_vtysh,
	"no redistribute <ipv4 <kernel|connected|local|static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|babel>|ipv6 <kernel|connected|local|static|ripng|ospf6|isis|bgp|nhrp|vnc|babel>>",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Redistribute IPv4 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"Redistribute IPv6 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n")

DEFSH (VTYSH_FABRICD, fabricd_no_isis_topology_cmd_vtysh,
	"no topology <standard|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc> [overload]",
	"Negate a command or set its defaults\n"
	"Configure IS-IS topologies\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n"
	"Set overload bit for topology\n")

DEFSH (VTYSH_FABRICD, fabricd_no_log_adj_changes_cmd_vtysh,
	"no log-adjacency-changes",
	"Negate a command or set its defaults\n"
	"Stop logging changes in adjacency state\n")

DEFSH (VTYSH_FABRICD, fabricd_no_lsp_gen_interval_cmd_vtysh,
	"no lsp-gen-interval [(1-120)]",
	"Negate a command or set its defaults\n"
	"Minimum interval between regenerating same LSP\n"
	"Minimum interval in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_no_lsp_refresh_interval_cmd_vtysh,
	"no lsp-refresh-interval [(1-65235)]",
	"Negate a command or set its defaults\n"
	"LSP refresh interval\n"
	"LSP refresh interval in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_no_max_lsp_lifetime_cmd_vtysh,
	"no max-lsp-lifetime [(350-65535)]",
	"Negate a command or set its defaults\n"
	"Maximum LSP lifetime\n"
	"LSP lifetime in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_no_net_cmd_vtysh,
	"no net WORD",
	"Negate a command or set its defaults\n"
	"A Network Entity Title for this process (OSI only)\n"
	"XX.XXXX. ... .XXX.XX  Network entity title (NET)\n")

DEFSH (VTYSH_FABRICD, fabricd_no_psnp_interval_cmd_vtysh,
	"no openfabric psnp-interval [(1-120)]",
	"Negate a command or set its defaults\n"
	"OpenFabric routing protocol\n"
	"Set PSNP interval in seconds\n"
	"PSNP interval value\n")

DEFSH (VTYSH_FABRICD, fabricd_no_router_openfabric_cmd_vtysh,
	"no router openfabric WORD",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"OpenFabric routing protocol\n"
	"ISO Routing area tag\n")

DEFSH (VTYSH_FABRICD, fabricd_no_set_overload_bit_cmd_vtysh,
	"no set-overload-bit",
	"Reset overload bit to accept transit traffic\n"
	"Reset overload bit\n")

DEFSH (VTYSH_FABRICD, fabricd_no_spf_delay_ietf_cmd_vtysh,
	"no spf-delay-ietf",
	"Negate a command or set its defaults\n"
	"IETF SPF delay algorithm\n")

DEFSH (VTYSH_FABRICD, fabricd_no_spf_interval_cmd_vtysh,
	"no spf-interval [(1-120)]",
	"Negate a command or set its defaults\n"
	"Minimum interval between SPF calculations\n"
	"Minimum interval between consecutive SPFs in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_no_triggered_csnp_cmd_vtysh,
	"no triggered-csnp-delay [(100-10000) [always]]",
	"Negate a command or set its defaults\n"
	"Configure the delay for triggered CSNPs\n"
	"Delay in milliseconds\n"
	"Trigger CSNP for all LSPs, not only circuit-scoped\n")

DEFSH (VTYSH_FABRICD, fabricd_psnp_interval_cmd_vtysh,
	"openfabric psnp-interval (1-120)",
	"OpenFabric routing protocol\n"
	"Set PSNP interval in seconds\n"
	"PSNP interval value\n")

DEFSH (VTYSH_FABRICD, fabricd_set_overload_bit_cmd_vtysh,
	"set-overload-bit",
	"Set overload bit to avoid any transit traffic\n")

DEFSH (VTYSH_FABRICD, fabricd_show_database_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] database [detail] [WORD] [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Link state database\n"
	"Detailed information\n"
	"LSP ID\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_hostname_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] hostname",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS Dynamic hostname mapping\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_frr_summary_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] fast-reroute summary",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS FRR information\n"
	"FRR summary\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_interface_arg_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] interface WORD [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS interface\n"
	"IS-IS interface name\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_interface_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] interface [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"json output\n"
	"IS-IS interface\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_interface_detail_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] interface detail [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS interface\n"
	"show detailed information\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_mpls_ldp_interface_cmd_vtysh,
	"show openfabric mpls ldp-sync [interface <INTERFACE|all>]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"MPLS information\n"
	"LDP-IGP Sync information\n"
	"Interface information\n"
	"Interface name\n"
	"All interfaces\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_neighbor_arg_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] neighbor WORD [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"System id\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_neighbor_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] neighbor [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_neighbor_detail_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] neighbor detail [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"all vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"show detailed information\n"
	"json output\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_route_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] route [prefix-sid] [backup] [json$uj]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS routing table\n"
	"Show Prefix-SID information\n"
	"Show backup routes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_spf_ietf_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] spf-delay-ietf",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"SPF delay IETF information\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_summary_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] summary [json]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"json output\n"
	"summary\n")

DEFSH (VTYSH_FABRICD, fabricd_show_isis_topology_cmd_vtysh,
	"show openfabric [vrf <NAME|all>] topology [json$uj]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS paths to Intermediate Systems\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_FABRICD, fabricd_show_lsp_flooding_cmd_vtysh,
	"show openfabric flooding [WORD]",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Flooding information\n"
	"LSP ID\n")

DEFSH (VTYSH_FABRICD, fabricd_show_sr_node_cmd_vtysh,
	"show openfabric segment-routing node",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Segment-Routing\n"
	"Segment-Routing node\n")

DEFSH (VTYSH_FABRICD, fabricd_show_srv6_node_cmd_vtysh,
	"show openfabric segment-routing srv6 node",
	"Show running system information\n"
	"OpenFabric routing protocol\n"
	"Segment-Routing\n"
	"Segment-Routing over IPv6 (SRv6)\n"
	"SRv6 node\n")

DEFSH (VTYSH_FABRICD, fabricd_spf_delay_ietf_cmd_vtysh,
	"spf-delay-ietf init-delay (0-60000) short-delay (0-60000) long-delay (0-60000) holddown (0-60000) time-to-learn (0-60000)",
	"IETF SPF delay algorithm\n"
	"Delay used while in QUIET state\n"
	"Delay used while in QUIET state in milliseconds\n"
	"Delay used while in SHORT_WAIT state\n"
	"Delay used while in SHORT_WAIT state in milliseconds\n"
	"Delay used while in LONG_WAIT\n"
	"Delay used while in LONG_WAIT state in milliseconds\n"
	"Time with no received IGP events before considering IGP stable\n"
	"Time with no received IGP events before considering IGP stable (in milliseconds)\n"
	"Maximum duration needed to learn all the events related to a single failure\n"
	"Maximum duration needed to learn all the events related to a single failure (in milliseconds)\n")

DEFSH (VTYSH_FABRICD, fabricd_spf_interval_cmd_vtysh,
	"spf-interval (1-120)",
	"Minimum interval between SPF calculations\n"
	"Minimum interval between consecutive SPFs in seconds\n")

DEFSH (VTYSH_FABRICD, fabricd_triggered_csnp_cmd_vtysh,
	"triggered-csnp-delay (100-10000) [always]",
	"Configure the delay for triggered CSNPs\n"
	"Delay in milliseconds\n"
	"Trigger CSNP for all LSPs, not only circuit-scoped\n")

DEFSH (VTYSH_OSPFD, flood_reduction_area_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> flood-reduction",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Enable flood reduction for area\n")

DEFSH (VTYSH_OSPFD, flood_reduction_cmd_vtysh,
	"flood-reduction",
	"flood reduction feature\n")

DEFSH (VTYSH_ZEBRA, fpm_remote_ip_cmd_vtysh,
	"fpm connection ip A.B.C.D port (1-65535)",
	"Forwarding Path Manager\n"
	"Configure FPM connection\n"
	"Connect to IPv4 address\n"
	"Connect to IPv4 address\n"
	"TCP port number\n"
	"TCP port number\n")

DEFSH (VTYSH_ZEBRA, fpm_reset_counters_cmd_vtysh,
	"clear fpm counters",
	"Reset functions\n"
	"Forwarding Plane Manager configuration\n"
	"FPM statistic counters\n")

DEFSH (VTYSH_ZEBRA, fpm_set_address_cmd_vtysh,
	"fpm address <A.B.C.D|X:X::X:X> [port (1-65535)]",
	"Forwarding Plane Manager configuration\n"
	"FPM remote listening server address\n"
	"Remote IPv4 FPM server\n"
	"Remote IPv6 FPM server\n"
	"FPM remote listening server port\n"
	"Remote FPM server port\n")

DEFSH (VTYSH_ZEBRA, fpm_show_counters_cmd_vtysh,
	"show fpm counters",
	"Show running system information\n"
	"Forwarding Plane Manager configuration\n"
	"FPM statistic counters\n")

DEFSH (VTYSH_ZEBRA, fpm_show_counters_json_cmd_vtysh,
	"show fpm counters json",
	"Show running system information\n"
	"Forwarding Plane Manager configuration\n"
	"FPM statistic counters\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, fpm_show_status_cmd_vtysh,
	"show fpm status [json]$json",
	"Show running system information\n"
	"Forwarding Plane Manager configuration\n"
	"FPM status\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, fpm_use_nhg_cmd_vtysh,
	"fpm use-next-hop-groups",
	"Forwarding Plane Manager configuration\n"
	"Use netlink next hop groups feature.\n")

DEFSH (VTYSH_ZEBRA, fpm_use_route_replace_cmd_vtysh,
	"fpm use-route-replace",
	"Forwarding Plane Manager configuration\n"
	"Use netlink route replace semantics\n")

DEFSH (VTYSH_ALL, frr_defaults_cmd_vtysh,
	"frr defaults PROFILE...",
	"FRRouting global parameters\n"
	"set of configuration defaults used\n"
	"profile string\n")

DEFSH (VTYSH_ALL, frr_version_cmd_vtysh,
	"frr version VERSION...",
	"FRRouting global parameters\n"
	"version configuration was written by\n"
	"version string\n")

DEFSH (VTYSH_PIM6D, gm_debug_iface_cfg_cmd_vtysh,
	"debug ipv6 mld {robustness (0-7)|query-max-response-time (1-8387584)}",
	"Debugging functions\n"
	"IPv6 information\n"
	"Multicast Listener Discovery\n"
	"QRV\n"
	"QRV\n"
	"maxresp\n"
	"maxresp\n")

DEFSH (VTYSH_PIM6D, gm_debug_show_cmd_vtysh,
	"debug show mld interface IFNAME",
	"Debugging functions\n"
	"Show running system information\n"
	"MLD information\n"
	"Interface information\n"
	"interface name\n")

DEFSH (VTYSH_PIM6D, gm_show_interface_cmd_vtysh,
	"show ipv6 mld [vrf <VRF|all>$vrf_str] interface [IFNAME | detail$detail] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"MLD information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MLD interface information\n"
	"Interface name\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, gm_show_interface_joins_cmd_vtysh,
	"show ipv6 mld [vrf <VRF|all>$vrf_str] joins [{interface IFNAME|groups X:X::X:X/M|sources X:X::X:X/M|detail$detail}] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"MLD information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MLD joined groups & sources\n"
	"Interface information\n"
	"Interface name\n"
	"Limit output to group range\n"
	"Show groups covered by this prefix\n"
	"Limit output to source range\n"
	"Show sources covered by this prefix\n"
	"Show details, including tracked receivers\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, gm_show_interface_stats_cmd_vtysh,
	"show ipv6 mld [vrf <VRF|all>$vrf_str] statistics [interface IFNAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"MLD information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MLD statistics\n"
	"Interface information\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, gm_show_mld_groups_cmd_vtysh,
	"show ipv6 mld [vrf <VRF|all>$vrf_str] groups [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"MLD information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MLD groups information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, graceful_restart_cmd_vtysh,
	"graceful-restart [grace-period (1-1800)$grace_period]",
	"OSPF non-stop forwarding (NSF) also known as OSPF Graceful Restart\n"
	"Maximum length of the 'grace period'\n"
	"Maximum length of the 'grace period' in seconds\n")

DEFSH (VTYSH_OSPFD, graceful_restart_prepare_cmd_vtysh,
	"graceful-restart prepare ip ospf",
	"Graceful Restart commands\n"
	"Prepare upcoming graceful restart\n"
	"IP information\n"
	"Prepare to restart the OSPF process\n")

DEFSH (VTYSH_MGMTD, if_ipv4_route_map_cmd_vtysh,
	"route-map ROUTE-MAP <in$in|out> IFNAME",
	"Route map set\n"
	"Route map name\n"
	"Route map set for input filtering\n"
	"Route map set for output filtering\n"
	"Interface information\n")

DEFSH (VTYSH_MGMTD, if_ipv6_route_map_cmd_vtysh,
	"route-map ROUTE-MAP <in$in|out> IFNAME",
	"Route map set\n"
	"Route map name\n"
	"Route map set for input filtering\n"
	"Route map set for output filtering\n"
	"Interface information\n")

DEFSH (VTYSH_NHRPD, if_nhrp_authentication_cmd_vtysh,
	"<ip|ipv6>nhrp authentication PASSWORD$password",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify plain text password used for authenticantion\n"
	"Password, plain text, limited to 8 characters\n")

DEFSH (VTYSH_NHRPD, if_nhrp_flags_cmd_vtysh,
	"<ip|ipv6> nhrp <shortcut|redirect>",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Allow shortcut establishment\n"
	"Send redirect notifications\n")

DEFSH (VTYSH_NHRPD, if_nhrp_holdtime_cmd_vtysh,
	"<ip|ipv6> nhrp holdtime (1-65000)",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify NBMA address validity time\n"
	"Time in seconds that NBMA addresses are advertised valid\n")

DEFSH (VTYSH_NHRPD, if_nhrp_map_cmd_vtysh,
	"<ip|ipv6> nhrp map <A.B.C.D|X:X::X:X> <A.B.C.D|local>",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Nexthop Server configuration\n"
	"IPv4 protocol address\n"
	"IPv6 protocol address\n"
	"IPv4 NBMA address\n"
	"Handle protocol address locally\n")

DEFSH (VTYSH_NHRPD, if_nhrp_map_multicast_cmd_vtysh,
	"<ip|ipv6> nhrp map multicast <A.B.C.D|X:X::X:X|dynamic>",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Multicast NBMA Configuration\n"
	"Use this NBMA mapping for multicasts\n"
	"IPv4 NBMA address\n"
	"IPv6 NBMA address\n"
	"Dynamically learn destinations from client registrations on hub\n")

DEFSH (VTYSH_NHRPD, if_nhrp_mtu_cmd_vtysh,
	"ip nhrp mtu <(576-1500)|opennhrp>",
	"IP information\n"
	"Next Hop Resolution Protocol functions\n"
	"Configure NHRP advertised MTU\n"
	"MTU value\n"
	"Advertise bound interface MTU similar to OpenNHRP\n")

DEFSH (VTYSH_NHRPD, if_nhrp_network_id_cmd_vtysh,
	"<ip|ipv6> nhrp network-id (1-4294967295)",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Enable NHRP and specify network-id\n"
	"System local ID to specify interface group\n")

DEFSH (VTYSH_NHRPD, if_nhrp_nhs_cmd_vtysh,
	"<ip|ipv6> nhrp nhs <A.B.C.D|X:X::X:X|dynamic> nbma <A.B.C.D|FQDN>",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Nexthop Server configuration\n"
	"IPv4 protocol address\n"
	"IPv6 protocol address\n"
	"Automatic detection of protocol address\n"
	"NBMA address\n"
	"IPv4 NBMA address\n"
	"Fully qualified domain name for NBMA address(es)\n")

DEFSH (VTYSH_NHRPD, if_nhrp_reg_flags_cmd_vtysh,
	"<ip|ipv6> nhrp registration no-unique",
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Registration configuration\n"
	"Don't set unique flag\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_authentication_cmd_vtysh,
	"no <ip|ipv6>nhrp authentication PASSWORD$password",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify plain text password used for authenticantion\n"
	"Password, plain text, limited to 8 characters\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_flags_cmd_vtysh,
	"no <ip|ipv6> nhrp <shortcut|redirect>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Allow shortcut establishment\n"
	"Send redirect notifications\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_holdtime_cmd_vtysh,
	"no <ip|ipv6> nhrp holdtime [(1-65000)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify NBMA address validity time\n"
	"Time in seconds that NBMA addresses are advertised valid\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_map_cmd_vtysh,
	"no <ip|ipv6> nhrp map <A.B.C.D|X:X::X:X> [<A.B.C.D|local>]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Nexthop Server configuration\n"
	"IPv4 protocol address\n"
	"IPv6 protocol address\n"
	"IPv4 NBMA address\n"
	"Handle protocol address locally\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_map_multicast_cmd_vtysh,
	"no <ip|ipv6> nhrp map multicast <A.B.C.D|X:X::X:X|dynamic>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Multicast NBMA Configuration\n"
	"Use this NBMA mapping for multicasts\n"
	"IPv4 NBMA address\n"
	"IPv6 NBMA address\n"
	"Dynamically learn destinations from client registrations on hub\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_mtu_cmd_vtysh,
	"no ip nhrp mtu [(576-1500)|opennhrp]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Next Hop Resolution Protocol functions\n"
	"Configure NHRP advertised MTU\n"
	"MTU value\n"
	"Advertise bound interface MTU similar to OpenNHRP\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_network_id_cmd_vtysh,
	"no <ip|ipv6> nhrp network-id [(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Enable NHRP and specify network-id\n"
	"System local ID to specify interface group\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_nhs_cmd_vtysh,
	"no <ip|ipv6> nhrp nhs <A.B.C.D|X:X::X:X|dynamic> nbma <A.B.C.D|FQDN>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Nexthop Server configuration\n"
	"IPv4 protocol address\n"
	"IPv6 protocol address\n"
	"Automatic detection of protocol address\n"
	"NBMA address\n"
	"IPv4 NBMA address\n"
	"Fully qualified domain name for NBMA address(es)\n")

DEFSH (VTYSH_NHRPD, if_no_nhrp_reg_flags_cmd_vtysh,
	"no <ip|ipv6> nhrp registration no-unique",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IPv6 information\n"
	"Next Hop Resolution Protocol functions\n"
	"Registration configuration\n"
	"Don't set unique flag\n")

DEFSH (VTYSH_INTERFACE, interface_desc_cmd_vtysh,
	"description LINE...",
	"Interface specific description\n"
	"Characters describing this interface\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_cmd_vtysh,
	"ip igmp",
	"IP information\n"
	"Enable IGMP operation\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_immediate_leave_cmd_vtysh,
	"[no] ip igmp immediate-leave",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Immediately drop group memberships on receiving Leave (IGMPv2 only)\n")

DEFSH_HIDDEN (VTYSH_PIMD, interface_ip_igmp_join_cmd_vtysh,
	"[no] ip igmp join A.B.C.D$grp [A.B.C.D]$src",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP join multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_join_group_cmd_vtysh,
	"[no] ip igmp join-group A.B.C.D$grp [A.B.C.D]$src",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP join multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_last_member_query_count_cmd_vtysh,
	"ip igmp last-member-query-count (1-255)$lmqc",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP last member query count\n"
	"Last member query count\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_last_member_query_interval_cmd_vtysh,
	"ip igmp last-member-query-interval (1-65535)$lmqi",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP last member query interval\n"
	"Last member query interval in deciseconds\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_limits_cmd_vtysh,
	"[no] ip igmp <max-sources$do_src (0-4294967295)$val|max-groups$do_grp (0-4294967295)$val>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Limit number of IGMPv3 sources to track\n"
	"Permitted number of sources\n"
	"Limit number of IGMP group memberships to track\n"
	"Permitted number of groups\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_proxy_cmd_vtysh,
	"[no] ip igmp proxy",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IGMP information\n"
	"Proxy IGMP join/prune operations\n")

DEFSH_HIDDEN (VTYSH_PIMD, interface_ip_igmp_query_generate_cmd_vtysh,
	"ip igmp generate-query-once [version (2-3)]",
	"IP information\n"
	"Enable IGMP operation\n"
	"Generate igmp general query once\n"
	"IGMP version\n"
	"IGMP version number\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_query_interval_cmd_vtysh,
	"ip igmp query-interval (1-65535)",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP host query interval\n"
	"Query interval in seconds\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_query_max_response_time_cmd_vtysh,
	"ip igmp query-max-response-time (1-65535)$qmrt",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP max query response value (seconds)\n"
	"Query response value in deci-seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, interface_ip_igmp_query_max_response_time_dsec_cmd_vtysh,
	"ip igmp query-max-response-time-dsec (1-65535)",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP max query response value (deciseconds)\n"
	"Query response value in deciseconds\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_require_ra_cmd_vtysh,
	"[no] ip igmp require-router-alert",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Require IP Router Alert option for IGMP packets\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_rmap_cmd_vtysh,
	"[no] ip igmp route-map ![RMAP_NAME]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Filter joins through route-map\n"
	"Route-map name\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_static_group_cmd_vtysh,
	"[no] ip igmp static-group A.B.C.D$grp [A.B.C.D]$src",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Static multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, interface_ip_igmp_version_cmd_vtysh,
	"ip igmp version (2-3)",
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP version\n"
	"IGMP version number\n")

DEFSH (VTYSH_PIMD, interface_ip_mroute_cmd_vtysh,
	"ip mroute INTERFACE A.B.C.D [A.B.C.D]",
	"IP information\n"
	"Add multicast route\n"
	"Outgoing interface name\n"
	"Group address\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_activeactive_cmd_vtysh,
	"[no$no] ip pim active-active",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Mark interface as Active-Active for MLAG operations, Hidden because not finished yet\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_boundary_acl_cmd_vtysh,
	"[no] ip multicast boundary ACCESSLIST4_NAME$name",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Generic multicast configuration options\n"
	"Define multicast boundary\n"
	"Access-list to filter OIL with by source and group\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_boundary_oil_cmd_vtysh,
	"ip multicast boundary oil WORD",
	"IP information\n"
	"Generic multicast configuration options\n"
	"Define multicast boundary\n"
	"Filter OIL by group using prefix list\n"
	"Prefix list to filter OIL with\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_cmd_vtysh,
	"[no] ip pim [sm|ssm$ssm|dm$dm|sm-dm$smdm]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Enable PIM Sparse Mode\n"
	"Enable PIM SSM operation\n"
	"Enable PIM Dense Mode\n"
	"Enable PIM Sparse-Dense Mode\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_drprio_cmd_vtysh,
	"ip pim drpriority (0-4294967295)",
	"IP information\n"
	"PIM information\n"
	"Set the Designated Router Election Priority\n"
	"Value of the new DR Priority\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_hello_cmd_vtysh,
	"ip pim hello (1-65535) [(1-65535)]",
	"IP information\n"
	"PIM information\n"
	"Hello Interval\n"
	"Time in seconds for Hello Interval\n"
	"Time in seconds for Hold Interval\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_neighbor_prefix_list_cmd_vtysh,
	"[no] ip pim allowed-neighbors prefix-list WORD",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"pim multicast routing\n"
	"Restrict allowed PIM neighbors\n"
	"Use prefix-list to filter neighbors\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, interface_ip_pim_passive_cmd_vtysh,
	"[no] ip pim passive$passive",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Disable exchange of protocol packets\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_cmd_vtysh,
	"ipv6 mld",
	"IPv6 information\n"
	"Enable MLD operation\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_immediate_leave_cmd_vtysh,
	"[no] ipv6 mld immediate-leave",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Immediately drop group memberships on receiving Leave (MLDv1 only)\n")

DEFSH_HIDDEN (VTYSH_PIM6D, interface_ipv6_mld_join_cmd_vtysh,
	"[no] ipv6 mld join X:X::X:X$grp [X:X::X:X]$src",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD join multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_join_group_cmd_vtysh,
	"[no] ipv6 mld join-group X:X::X:X$grp [X:X::X:X]$src",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD join multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_last_member_query_count_cmd_vtysh,
	"ipv6 mld last-member-query-count (1-255)$lmqc",
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD last member query count\n"
	"Last member query count\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_last_member_query_interval_cmd_vtysh,
	"ipv6 mld last-member-query-interval (1-65535)$lmqi",
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD last member query interval\n"
	"Last member query interval in deciseconds\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_limits_cmd_vtysh,
	"[no] ipv6 mld <max-sources$do_src (0-4294967295)$val|max-groups$do_grp (0-4294967295)$val>",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Limit number of MLDv2 sources to track\n"
	"Permitted number of sources\n"
	"Limit number of MLD group memberships to track\n"
	"Permitted number of groups\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_query_interval_cmd_vtysh,
	"ipv6 mld query-interval (1-65535)$q_interval",
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD host query interval\n"
	"Query interval in seconds\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_query_max_response_time_cmd_vtysh,
	"ipv6 mld query-max-response-time (1-65535)$qmrt",
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD max query response value (seconds)\n"
	"Query response value in deci-seconds\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_require_ra_cmd_vtysh,
	"[no] ipv6 mld require-router-alert",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Require IP Router Alert option for MLD packets\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_rmap_cmd_vtysh,
	"[no] ipv6 mld route-map ![RMAP_NAME]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Filter joins through route-map\n"
	"Route-map name\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_static_group_cmd_vtysh,
	"[no] ipv6 mld static-group X:X::X:X$grp [X:X::X:X]$src",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Static multicast group\n"
	"Multicast group address\n"
	"Source address\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mld_version_cmd_vtysh,
	"ipv6 mld version (1-2)$version",
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD version\n"
	"MLD version number\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_mroute_cmd_vtysh,
	"ipv6 mroute INTERFACE X:X::X:X$group [X:X::X:X]$source",
	"IPv6 information\n"
	"Add multicast route\n"
	"Outgoing interface name\n"
	"Group address\n"
	"Source address\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_activeactive_cmd_vtysh,
	"[no] ipv6 pim active-active",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Mark interface as Active-Active for MLAG operations\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_boundary_oil_cmd_vtysh,
	"ipv6 multicast boundary oil WORD",
	"IPv6 information\n"
	"Generic multicast configuration options\n"
	"Define multicast boundary\n"
	"Filter OIL by group using prefix list\n"
	"Prefix list to filter OIL with\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_cmd_vtysh,
	"[no] ipv6 pim [sm|ssm$ssm|dm$dm|sm-dm$smdm]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Enable PIM Sparse Mode\n"
	"Enable PIM SSM operation\n"
	"Enable PIM Dense Mode\n"
	"Enable PIM Sparse-Dense Mode\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_drprio_cmd_vtysh,
	"ipv6 pim drpriority (0-4294967295)",
	"IPv6 information\n"
	"PIM information\n"
	"Set the Designated Router Election Priority\n"
	"Value of the new DR Priority\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_hello_cmd_vtysh,
	"ipv6 pim hello (1-65535) [(1-65535)]$hold",
	"IPv6 information\n"
	"PIM information\n"
	"Hello Interval\n"
	"Time in seconds for Hello Interval\n"
	"Time in seconds for Hold Interval\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_neighbor_prefix_list_cmd_vtysh,
	"[no] ipv6 pim allowed-neighbors prefix-list PREFIXLIST6_NAME$prefix_list",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Restrict allowed PIM neighbors\n"
	"Use prefix-list to filter neighbors\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_passive_cmd_vtysh,
	"[no] ipv6 pim passive$passive",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Disable exchange of protocol packets\n")

DEFSH (VTYSH_PIM6D, interface_ipv6_pim_use_source_cmd_vtysh,
	"[no] ipv6 pim use-source X:X::X:X$source",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Configure primary IPv6 address\n"
	"Source IPv6 address\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_cmd_vtysh,
	"no ip igmp",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_last_member_query_count_cmd_vtysh,
	"no ip igmp last-member-query-count [(1-255)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP last member query count\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_last_member_query_interval_cmd_vtysh,
	"no ip igmp last-member-query-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP last member query interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_query_interval_cmd_vtysh,
	"no ip igmp query-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP host query interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_query_max_response_time_cmd_vtysh,
	"no ip igmp query-max-response-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP max query response value (seconds)\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, interface_no_ip_igmp_query_max_response_time_dsec_cmd_vtysh,
	"no ip igmp query-max-response-time-dsec [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP max query response value (deciseconds)\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, interface_no_ip_igmp_version_cmd_vtysh,
	"no ip igmp version (2-3)",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"IGMP version\n"
	"IGMP version number\n")

DEFSH (VTYSH_PIMD, interface_no_ip_mroute_cmd_vtysh,
	"no ip mroute INTERFACE A.B.C.D [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Add multicast route\n"
	"Outgoing interface name\n"
	"Group Address\n"
	"Source Address\n")

DEFSH (VTYSH_PIMD, interface_no_ip_pim_boundary_oil_cmd_vtysh,
	"no ip multicast boundary oil [WORD]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Generic multicast configuration options\n"
	"Define multicast boundary\n"
	"Filter OIL by group using prefix list\n"
	"Prefix list to filter OIL with\n")

DEFSH (VTYSH_PIMD, interface_no_ip_pim_drprio_cmd_vtysh,
	"no ip pim drpriority [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Revert the Designated Router Priority to default\n"
	"Old Value of the Priority\n")

DEFSH (VTYSH_PIMD, interface_no_ip_pim_hello_cmd_vtysh,
	"no ip pim hello [(1-65535) [(1-65535)]]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Hello Interval\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, interface_no_ip_pim_neighbor_prefix_list_cmd_vtysh,
	"no ip pim allowed-neighbors [prefix-list]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"pim multicast routing\n"
	"Restrict allowed PIM neighbors\n"
	"Use prefix-list to filter neighbors\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_cmd_vtysh,
	"no ipv6 mld",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_last_member_query_count_cmd_vtysh,
	"no ipv6 mld last-member-query-count [(1-255)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD last member query count\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_last_member_query_interval_cmd_vtysh,
	"no ipv6 mld last-member-query-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD last member query interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_query_interval_cmd_vtysh,
	"no ipv6 mld query-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD host query interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_query_max_response_time_cmd_vtysh,
	"no ipv6 mld query-max-response-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD max query response value (seconds)\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mld_version_cmd_vtysh,
	"no ipv6 mld version [(1-2)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"MLD version\n"
	"MLD version number\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_mroute_cmd_vtysh,
	"no ipv6 mroute INTERFACE X:X::X:X$group [X:X::X:X]$source",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Add multicast route\n"
	"Outgoing interface name\n"
	"Group Address\n"
	"Source Address\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_pim_boundary_oil_cmd_vtysh,
	"no ipv6 multicast boundary oil [WORD]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Generic multicast configuration options\n"
	"Define multicast boundary\n"
	"Filter OIL by group using prefix list\n"
	"Prefix list to filter OIL with\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_pim_drprio_cmd_vtysh,
	"no ipv6 pim drpriority [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Revert the Designated Router Priority to default\n"
	"Old Value of the Priority\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_pim_hello_cmd_vtysh,
	"no ipv6 pim hello [(1-65535) [(1-65535)]]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Hello Interval\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, interface_no_ipv6_pim_neighbor_prefix_list_cmd_vtysh,
	"no ipv6 pim allowed-neighbors [prefix-list]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Restrict allowed PIM neighbors\n"
	"Use prefix-list to filter neighbors\n")

DEFSH (VTYSH_PIMD, interface_no_pim_use_source_cmd_vtysh,
	"no ip pim use-source [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Delete source IP address\n"
	"source ip address\n")

DEFSH (VTYSH_PIMD, interface_pim_use_source_cmd_vtysh,
	"ip pim use-source A.B.C.D",
	"IP information\n"
	"PIM information\n"
	"Configure primary IP address\n"
	"source ip address\n")

DEFSH (VTYSH_ISISD, ip6_router_isis_cmd_vtysh,
	"ipv6 router isis WORD$tag",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n")

DEFSH_HIDDEN (VTYSH_ISISD, ip6_router_isis_vrf_cmd_vtysh,
	"ipv6 router isis WORD$tag vrf NAME$vrf_name",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, ip_address_cmd_vtysh,
	"[no] ip address A.B.C.D/M [label LINE$label]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Set the IP address of an interface\n"
	"IP address (e.g. 10.0.0.1/8)\n"
	"Label of this address\n"
	"Label\n")

DEFSH (VTYSH_MGMTD, ip_address_peer_cmd_vtysh,
	"[no] ip address A.B.C.D peer A.B.C.D/M [label LINE$label]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Set the IP address of an interface\n"
	"Local IP (e.g. 10.0.0.1) for P-t-P address\n"
	"Specify P-t-P address\n"
	"Peer IP address (e.g. 10.0.0.1/8)\n"
	"Label of this address\n"
	"Label\n")

DEFSH (VTYSH_MGMTD, ip_forwarding_cmd_vtysh,
	"[no] ip forwarding",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Turn on IP forwarding\n")

DEFSH (VTYSH_PIMD, ip_igmp_group_watermark_cmd_vtysh,
	"ip igmp watermark-warn (1-65535)$limit",
	"IP information\n"
	"IGMP information\n"
	"Configure group limit for watermark warning\n"
	"Group count to generate watermark warning\n")

DEFSH (VTYSH_MGMTD, ip_mroute_dist_cmd_vtysh,
	"[no] ip mroute A.B.C.D/M$prefix <A.B.C.D$gate|INTERFACE$ifname> [{(1-255)$distance|bfd$bfd [{multi-hop$bfd_multi_hop|source A.B.C.D$bfd_source|profile BFDPROF$bfd_profile}]}]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure static unicast route into MRIB for multicast RPF lookup\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"Nexthop address\n"
	"Nexthop interface name\n"
	"Distance\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_msdp_mesh_group_member_cmd_vtysh,
	"ip msdp mesh-group WORD$gname member A.B.C.D$maddr",
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP mesh-group\n"
	"Mesh group name\n"
	"Mesh group member\n"
	"Peer IP address\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_msdp_mesh_group_source_cmd_vtysh,
	"ip msdp mesh-group WORD$gname source A.B.C.D$saddr",
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP mesh-group\n"
	"Mesh group name\n"
	"Mesh group local address\n"
	"Source IP address for the TCP connection\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_msdp_peer_cmd_vtysh,
	"ip msdp peer A.B.C.D$peer source A.B.C.D$source",
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"Peer IP address\n"
	"Source address for TCP connection\n"
	"Local IP address\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_msdp_timers_cmd_vtysh,
	"ip msdp timers (1-65535)$keepalive (1-65535)$holdtime [(1-65535)$connretry]",
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"MSDP timers configuration\n"
	"Keep alive period (in seconds)\n"
	"Hold time period (in seconds)\n"
	"Connection retry period (in seconds)\n")

DEFSH (VTYSH_MGMTD, ip_nht_default_route_cmd_vtysh,
	"[no] ip nht resolve-via-default",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Filter Next Hop tracking route resolution\n"
	"Resolve via default route\n")

DEFSH (VTYSH_OSPFD, ip_ospf_area_cmd_vtysh,
	"ip ospf [(1-65535)] area <A.B.C.D|(0-4294967295)> [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Instance ID\n"
	"Enable OSPF on this interface\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_authentication_addr_cmd_vtysh,
	"ip ospf authentication [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Enable authentication on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_authentication_args_addr_cmd_vtysh,
	"ip ospf authentication <null|message-digest|key-chain KEYCHAIN_NAME> [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Enable authentication on this interface\n"
	"Use null authentication\n"
	"Use message-digest authentication\n"
	"Use a key-chain for cryptographic authentication keys\n"
	"Key-chain name\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_authentication_key_addr_cmd_vtysh,
	"ip ospf authentication-key AUTH_KEY [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_bfd_cmd_vtysh,
	"ip ospf bfd",
	"IP Information\n"
	"OSPF interface commands\n"
	"Enables BFD support\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ip_ospf_bfd_param_cmd_vtysh,
	"ip ospf bfd (2-255) (50-60000) (50-60000)",
	"IP Information\n"
	"OSPF interface commands\n"
	"Enables BFD support\n"
	"Detect Multiplier\n"
	"Required min receive interval\n"
	"Desired min transmit interval\n")

DEFSH (VTYSH_OSPFD, ip_ospf_bfd_prof_cmd_vtysh,
	"ip ospf bfd profile BFDPROF",
	"IP Information\n"
	"OSPF interface commands\n"
	"Enables BFD support\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH (VTYSH_OSPFD, ip_ospf_capability_opaque_addr_cmd_vtysh,
	"[no] ip ospf capability opaque [A.B.C.D]$ip_addr",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Disable OSPF capability on this interface\n"
	"Disable OSPF opaque LSA capability on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_cost_cmd_vtysh,
	"ip ospf cost (1-65535) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Interface cost\n"
	"Cost\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_dead_interval_cmd_vtysh,
	"ip ospf dead-interval (1-65535) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_dead_interval_minimal_addr_cmd_vtysh,
	"ip ospf dead-interval minimal hello-multiplier (2-20) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Interval time after which a neighbor is declared down\n"
	"Minimal 1s dead-interval with fast sub-second hellos\n"
	"Hello multiplier factor\n"
	"Number of Hellos to send each second\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_gr_hdelay_cmd_vtysh,
	"ip ospf graceful-restart hello-delay (1-1800)",
	"IP information\n"
	"OSPF interface commands\n"
	"Graceful Restart parameters\n"
	"Delay the sending of the first hello packets.\n"
	"Delay in seconds\n")

DEFSH (VTYSH_OSPFD, ip_ospf_hello_interval_cmd_vtysh,
	"ip ospf hello-interval (1-65535) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_message_digest_key_cmd_vtysh,
	"ip ospf message-digest-key (1-255) md5 KEY [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_mtu_ignore_addr_cmd_vtysh,
	"ip ospf mtu-ignore [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Disable MTU mismatch detection on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_neighbor_filter_addr_cmd_vtysh,
	"[no] ip ospf neighbor-filter ![PREFIXLIST4_NAME]$prefix_list [A.B.C.D]$ip_addr",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Filter OSPF neighbor packets\n"
	"Prefix-List used for filtering\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_network_cmd_vtysh,
	"ip ospf network <broadcast|non-broadcast|point-to-multipoint [delay-reflood|non-broadcast]|point-to-point [dmvpn]>",
	"IP Information\n"
	"OSPF interface commands\n"
	"Network type\n"
	"Specify OSPF broadcast multi-access network\n"
	"Specify OSPF NBMA network\n"
	"Specify OSPF point-to-multipoint network\n"
	"Specify OSPF delayed reflooding of LSAs received on P2MP interface\n"
	"Specify OSPF point-to-multipoint network doesn't support broadcast\n"
	"Specify OSPF point-to-point network\n"
	"Specify OSPF point-to-point DMVPN network\n")

DEFSH (VTYSH_OSPFD, ip_ospf_passive_cmd_vtysh,
	"ip ospf passive [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Suppress routing updates on an interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_prefix_suppression_addr_cmd_vtysh,
	"[no] ip ospf prefix-suppression [A.B.C.D]$ip_addr",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Suppress OSPF prefix advertisement on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_priority_cmd_vtysh,
	"ip ospf priority (0-255) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Router priority\n"
	"Priority\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_retransmit_interval_addr_cmd_vtysh,
	"ip ospf retransmit-interval (1-65535) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_retransmit_window_addr_cmd_vtysh,
	"[no] ip ospf retransmit-window ![(20-1000)]$retransmit-window [A.B.C.D]$ip_addr",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Window for LSA retransmit - Retransmit LSAs expiring in this window\n"
	"Milliseconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ip_ospf_transmit_delay_addr_cmd_vtysh,
	"ip ospf transmit-delay (1-65535) [A.B.C.D]",
	"IP Information\n"
	"OSPF interface commands\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_PIMD, ip_pim_bfd_cmd_vtysh,
	"ip pim bfd [profile BFDPROF$prof]",
	"IP information\n"
	"PIM information\n"
	"Enables BFD support\n"
	"Use BFD profile\n"
	"Use BFD profile name\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_bfd_param_cmd_vtysh,
	"ip pim bfd (2-255) (1-65535) (1-65535)",
	"IP information\n"
	"PIM information\n"
	"Enables BFD support\n"
	"Detect Multiplier\n"
	"Required min receive interval\n"
	"Desired min transmit interval\n")

DEFSH (VTYSH_PIMD, ip_pim_bsm_cmd_vtysh,
	"ip pim bsm",
	"IP information\n"
	"PIM information\n"
	"Enable BSM support on the interface\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_ecmp_cmd_vtysh,
	"ip pim ecmp",
	"IP information\n"
	"PIM information\n"
	"Enable PIM ECMP \n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_ecmp_rebalance_cmd_vtysh,
	"ip pim ecmp rebalance",
	"IP information\n"
	"PIM information\n"
	"Enable PIM ECMP \n"
	"Enable PIM ECMP Rebalance\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_joinprune_time_cmd_vtysh,
	"ip pim join-prune-interval (1-65535)$jpi",
	"IP information\n"
	"PIM information\n"
	"Join Prune Send Interval\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_keep_alive_cmd_vtysh,
	"ip pim keep-alive-timer (1-65535)$kat",
	"IP information\n"
	"PIM information\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_mlag_cmd_vtysh,
	"ip pim mlag INTERFACE$iface role [primary|secondary]$role state [up|down]$state addr A.B.C.D$addr",
	"IP information\n"
	"PIM information\n"
	"MLAG\n"
	"peerlink sub interface\n"
	"MLAG role\n"
	"MLAG role primary\n"
	"MLAG role secondary\n"
	"peer session state\n"
	"peer session state up\n"
	"peer session state down\n"
	"configure PIP\n"
	"unique ip address\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_packets_cmd_vtysh,
	"ip pim packets (1-255)",
	"IP information\n"
	"PIM information\n"
	"packets to process at one time per fd\n"
	"Number of packets\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_register_accept_list_cmd_vtysh,
	"[no] ip pim register-accept-list PREFIXLIST4_NAME$word",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Only accept registers from a specific source prefix list\n"
	"Prefix-List name\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_register_suppress_cmd_vtysh,
	"ip pim register-suppress-time (1-65535)$rst",
	"IP information\n"
	"PIM information\n"
	"Register Suppress Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_rp_cmd_vtysh,
	"ip pim rp A.B.C.D$rp [A.B.C.D/M]$gp",
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"Group Address range to cover\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_rp_keep_alive_cmd_vtysh,
	"ip pim rp keep-alive-timer (1-65535)$kat",
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_rp_prefix_list_cmd_vtysh,
	"ip pim rp A.B.C.D$rp prefix-list PREFIXLIST4_NAME$plist",
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_spt_switchover_infinity_cmd_vtysh,
	"ip pim spt-switchover infinity-and-beyond",
	"IP information\n"
	"PIM information\n"
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_spt_switchover_infinity_plist_cmd_vtysh,
	"ip pim spt-switchover infinity-and-beyond prefix-list PREFIXLIST4_NAME$plist",
	"IP information\n"
	"PIM information\n"
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_ssm_prefix_list_cmd_vtysh,
	"ip pim ssm prefix-list PREFIXLIST4_NAME$plist",
	"IP information\n"
	"PIM information\n"
	"Source Specific Multicast\n"
	"group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, ip_pim_ucast_bsm_cmd_vtysh,
	"ip pim unicast-bsm",
	"IP information\n"
	"PIM information\n"
	"Accept/Send unicast BSM on the interface\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_pim_v6_secondary_cmd_vtysh,
	"ip pim send-v6-secondary",
	"IP information\n"
	"PIM information\n"
	"Send v6 secondary addresses\n")

DEFSH (VTYSH_ACL_CONFIG, ip_prefix_list_cmd_vtysh,
	"ip prefix-list PREFIXLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <any|A.B.C.D/M$prefix [{ge (0-32)$ge|le (0-32)$le}]>",
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Any prefix match.  Same as \"0.0.0.0/0 le 32\"\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n"
	"Minimum prefix length to be matched\n"
	"Minimum prefix length\n"
	"Maximum prefix length to be matched\n"
	"Maximum prefix length\n")

DEFSH (VTYSH_ACL_CONFIG, ip_prefix_list_remark_cmd_vtysh,
	"ip prefix-list PREFIXLIST4_NAME$name description LINE...",
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_MGMTD, ip_protocol_cmd_vtysh,
	"[no] ip protocol <static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|babel|openfabric|any> $proto ![route-map ROUTE-MAP$rmap]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Filter routing info exchanged between zebra and protocol\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Any of the above protocols\n"
	"Specify route-map\n"
	"Route map name\n")

DEFSH (VTYSH_MGMTD, ip_protocol_nht_rmap_cmd_vtysh,
	"[no] ip nht <static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|babel|openfabric|any> $proto ![route-map ROUTE-MAP$rmap]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Filter Next Hop tracking route resolution\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Any of the above protocols\n"
	"Specify route map\n"
	"Route map name\n")

DEFSH (VTYSH_MGMTD, ip_rip_authentication_key_chain_cmd_vtysh,
	"ip rip authentication key-chain LINE$keychain",
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication key-chain\n"
	"name of key-chain\n")

DEFSH (VTYSH_MGMTD, ip_rip_authentication_mode_cmd_vtysh,
	"ip rip authentication mode <md5$mode [auth-length <rfc|old-ripd>$auth_length]|text$mode>",
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication mode\n"
	"Keyed message digest\n"
	"MD5 authentication data length\n"
	"RFC compatible\n"
	"Old ripd compatible\n"
	"Clear text authentication\n")

DEFSH (VTYSH_MGMTD, ip_rip_authentication_string_cmd_vtysh,
	"ip rip authentication string LINE$password",
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication string\n"
	"Authentication string\n")

DEFSH (VTYSH_MGMTD, ip_rip_bfd_cmd_vtysh,
	"[no] ip rip bfd",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Enable BFD support\n")

DEFSH (VTYSH_MGMTD, ip_rip_bfd_profile_cmd_vtysh,
	"[no] ip rip bfd profile BFDPROF$profile",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Enable BFD support\n"
	"Use a pre-configured profile\n"
	"Profile name\n")

DEFSH (VTYSH_MGMTD, ip_rip_receive_version_cmd_vtysh,
	"ip rip receive version <{1$v1|2$v2}|none>",
	"IP information\n"
	"Routing Information Protocol\n"
	"Advertisement reception\n"
	"Version control\n"
	"RIP version 1\n"
	"RIP version 2\n"
	"None\n")

DEFSH (VTYSH_MGMTD, ip_rip_send_version_cmd_vtysh,
	"ip rip send version <{1$v1|2$v2}|none>",
	"IP information\n"
	"Routing Information Protocol\n"
	"Advertisement transmission\n"
	"Version control\n"
	"RIP version 1\n"
	"RIP version 2\n"
	"None\n")

DEFSH (VTYSH_MGMTD, ip_rip_split_horizon_cmd_vtysh,
	"[no] ip rip split-horizon [poisoned-reverse$poisoned_reverse]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Perform split horizon\n"
	"With poisoned-reverse\n")

DEFSH (VTYSH_MGMTD, ip_rip_v2_broadcast_cmd_vtysh,
	"[no] ip rip v2-broadcast",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Send ip broadcast v2 update\n")

DEFSH (VTYSH_MGMTD, ip_route_address_interface_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask> 	<A.B.C.D|X:X::X:X>$gate                        	<INTERFACE|Null0>$ifname                       	[{                                             	  tag (1-4294967295)                           	  |(1-255)$distance                            	  |vrf NAME                                    	  |label WORD                                  	  |table (1-4294967295)                        	  |nexthop-vrf NAME                            	  |onlink$onlink                               	  |color (1-4294967295)                        	  |bfd$bfd [{multi-hop$bfd_multi_hop|source A.B.C.D$bfd_source|profile BFDPROF$bfd_profile}] 	  |segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"IP gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Treat the nexthop as directly attached to the interface\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Steer this route over an SRv6 SID list\n"
	"SRv6 SID list\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ip_route_address_interface_vrf_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask> 	<A.B.C.D|X:X::X:X>$gate                        	<INTERFACE|Null0>$ifname                       	[{                                             	  tag (1-4294967295)                           	  |(1-255)$distance                            	  |label WORD                                  	  |table (1-4294967295)                        	  |nexthop-vrf NAME                            	  |onlink$onlink                               	  |color (1-4294967295)                        	  |bfd$bfd [{multi-hop$bfd_multi_hop|source A.B.C.D$bfd_source|profile BFDPROF$bfd_profile}] 	  |segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior] 	  }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"IP gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Treat the nexthop as directly attached to the interface\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Steer this route over an SRv6 SID list\n"
	"SRv6 SID list\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ip_route_blackhole_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask>                        	<reject|blackhole>$flag                                               	[{                                                                    	  tag (1-4294967295)                                                  	  |(1-255)$distance                                                   	  |vrf NAME                                                           	  |label WORD                                                                   |table (1-4294967295)                                                         }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"Emit an ICMP unreachable when matched\n"
	"Silently discard pkts when matched\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n")

DEFSH (VTYSH_MGMTD, ip_route_blackhole_vrf_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask>                        	<reject|blackhole>$flag                                               	[{                                                                    	  tag (1-4294967295)                                                  	  |(1-255)$distance                                                   	  |label WORD                                                         	  |table (1-4294967295)                                                         }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"Emit an ICMP unreachable when matched\n"
	"Silently discard pkts when matched\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n")

DEFSH (VTYSH_MGMTD, ip_route_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask>     	<<A.B.C.D|X:X::X:X>$gate|<INTERFACE|Null0>$ifname> 	[{                                             	   	  tag (1-4294967295)                               	  |(1-255)$distance                                	  |vrf NAME                                        	  |label WORD                                      	  |table (1-4294967295)                            	  |nexthop-vrf NAME                                	  |color (1-4294967295)                            	  |bfd$bfd [{multi-hop$bfd_multi_hop|source A.B.C.D$bfd_source|profile BFDPROF$bfd_profile}] 	  |segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"IP gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Steer this route over an SRv6 SID list\n"
	"SRv6 SID list\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ip_route_vrf_cmd_vtysh,
	"[no] ip route	<A.B.C.D/M$prefix|A.B.C.D$prefix A.B.C.D$mask>     	<<A.B.C.D|X:X::X:X>$gate|<INTERFACE|Null0>$ifname> 	[{                                                 	  tag (1-4294967295)                               	  |(1-255)$distance                                	  |label WORD                                      	  |table (1-4294967295)                            	  |nexthop-vrf NAME                                	  |color (1-4294967295)                            	  |bfd$bfd [{multi-hop$bfd_multi_hop|source A.B.C.D$bfd_source|profile BFDPROF$bfd_profile}] 	  |segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Establish static routes\n"
	"IP destination prefix (e.g. 10.0.0.0/8)\n"
	"IP destination prefix\n"
	"IP destination prefix mask\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"IP gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this route\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Steer this route over an SRv6 SID list\n"
	"SRv6 SID list\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ip_router_id_cmd_vtysh,
	"[no] ip router-id A.B.C.D$id vrf NAME",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Manually set the router-id\n"
	"IP address to use for router-id\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, ip_router_id_in_vrf_cmd_vtysh,
	"[no] ip router-id ![A.B.C.D$id]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Manually set the router-id\n"
	"IP address to use for router-id\n")

DEFSH (VTYSH_ISISD, ip_router_isis_cmd_vtysh,
	"ip router isis WORD$tag",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n")

DEFSH_HIDDEN (VTYSH_ISISD, ip_router_isis_vrf_cmd_vtysh,
	"ip router isis WORD$tag vrf NAME$vrf_name",
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH_HIDDEN (VTYSH_PIMD, ip_ssmpingd_cmd_vtysh,
	"ip ssmpingd [A.B.C.D]$src",
	"IP information\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_MGMTD, ip_table_range_cmd_vtysh,
	"[no] ip table range ![(1-4294967295)$start (1-4294967295)$end]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"table configuration\n"
	"Configure table range\n"
	"Start Routing Table\n"
	"End Routing Table\n")

DEFSH (VTYSH_ZEBRA, ip_zebra_import_table_distance_cmd_vtysh,
	"ip import-table (1-252)$table_id [mrib]$mrib [distance (1-255)$distance] [route-map RMAP_NAME$rmap]",
	"IP information\n"
	"import routes from non-main kernel table\n"
	"kernel routing table id\n"
	"Import into the MRIB instead of the URIB\n"
	"Distance for imported routes\n"
	"Default distance value\n"
	"route-map for filtering\n"
	"route-map name\n")

DEFSH (VTYSH_ACL_CONFIG, ipv6_access_list_cmd_vtysh,
	"ipv6 access-list ACCESSLIST6_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <X:X::X:X/M$prefix [exact-match$exact]|any>",
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"IPv6 prefix\n"
	"Exact match of the prefixes\n"
	"Match any IPv6\n")

DEFSH (VTYSH_ACL_CONFIG, ipv6_access_list_remark_cmd_vtysh,
	"ipv6 access-list ACCESSLIST6_NAME$name remark LINE...",
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_MGMTD, ipv6_address_cmd_vtysh,
	"[no] ipv6 address X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Set the IP address of an interface\n"
	"IPv6 address (e.g. 3ffe:506::1/48)\n")

DEFSH (VTYSH_BGPD, ipv6_bgp_distance_source_access_list_cmd_vtysh,
	"distance (1-255) X:X::X:X/M WORD",
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n"
	"Access list name\n")

DEFSH (VTYSH_BGPD, ipv6_bgp_distance_source_cmd_vtysh,
	"distance (1-255) X:X::X:X/M",
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n")

DEFSH (VTYSH_BGPD, ipv6_bgp_network_cmd_vtysh,
	"[no] network X:X::X:X/M$prefix 	[{route-map RMAP_NAME$map_name|label-index (0-1048560)$label_index}]",
	"Negate a command or set its defaults\n"
	"Specify a network to announce via BGP\n"
	"IPv6 prefix\n"
	"Route-map to modify the attributes\n"
	"Name of the route map\n"
	"Label index to associate with the prefix\n"
	"Label index value\n")

DEFSH (VTYSH_MGMTD, ipv6_forwarding_cmd_vtysh,
	"[no] ipv6 forwarding",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Turn on IPv6 forwarding\n")

DEFSH (VTYSH_PIM6D, ipv6_mld_group_watermark_cmd_vtysh,
	"ipv6 mld watermark-warn (1-65535)$limit",
	"IPv6 information\n"
	"MLD information\n"
	"Configure group limit for watermark warning\n"
	"Group count to generate watermark warning\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_adv_interval_config_option_cmd_vtysh,
	"[no] ipv6 nd adv-interval-option",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Advertisement Interval Option\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_dnssl_cmd_vtysh,
	"[no] ipv6 nd dnssl SUFFIX [<(0-4294967295)|infinite>]$lifetime",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"DNS search list information\n"
	"Domain name suffix\n"
	"Valid lifetime in seconds\n"
	"Infinite valid lifetime\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_homeagent_config_flag_cmd_vtysh,
	"[no] ipv6 nd home-agent-config-flag",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Home Agent configuration flag\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_homeagent_lifetime_cmd_vtysh,
	"[no] ipv6 nd home-agent-lifetime ![(1-65520)$lifetime]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Home Agent lifetime\n"
	"Home Agent lifetime in seconds\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_homeagent_preference_cmd_vtysh,
	"[no] ipv6 nd home-agent-preference ![(0-65535)$pref]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Home Agent preference\n"
	"preference value (default is 0, least preferred)\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_managed_config_flag_cmd_vtysh,
	"[no] ipv6 nd managed-config-flag",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Managed address configuration flag\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_mtu_cmd_vtysh,
	"[no] ipv6 nd mtu ![(1-65535)]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Advertised MTU\n"
	"MTU in bytes\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_other_config_flag_cmd_vtysh,
	"[no] ipv6 nd other-config-flag",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Other statefull configuration flag\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_pref64_cmd_vtysh,
	"[no] ipv6 nd nat64 [X:X::X:X/M]$prefix [lifetime <(0-65535)|auto>]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"NAT64 prefix advertisement (RFC8781)\n"
	"NAT64 prefix to advertise (default: 64:ff9b::/96)\n"
	"Specify validity lifetime\n"
	"Valid lifetime in seconds\n"
	"Calculate lifetime automatically\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_prefix_cmd_vtysh,
	"[no] ipv6 nd prefix X:X::X:X/M$prefix [<(0-4294967295)|infinite>$valid <(0-4294967295)|infinite>$preferred] [{router-address$routeraddr|off-link$offlink|no-autoconfig$noautoconf}]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Prefix information\n"
	"IPv6 prefix\n"
	"Valid lifetime in seconds\n"
	"Infinite valid lifetime\n"
	"Preferred lifetime in seconds\n"
	"Infinite preferred lifetime\n"
	"Set Router Address flag\n"
	"Do not use prefix for onlink determination\n"
	"Do not use prefix for autoconfiguration\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_ra_fast_retrans_cmd_vtysh,
	"[no] ipv6 nd ra-fast-retrans",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Fast retransmit of RA packets\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_ra_hop_limit_cmd_vtysh,
	"[no] ipv6 nd ra-hop-limit ![(0-255)$hopcount]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Advertisement Hop Limit\n"
	"Advertisement Hop Limit in hops (default:64)\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_ra_interval_cmd_vtysh,
	"[no] ipv6 nd ra-interval ![<(1-1800)$sec|msec (70-1800000)$msec>]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Router Advertisement interval\n"
	"Router Advertisement interval in seconds\n"
	"Router Advertisement interval in milliseconds\n"
	"Router Advertisement interval in milliseconds\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_ra_lifetime_cmd_vtysh,
	"[no] ipv6 nd ra-lifetime ![(0-9000)$lifetime]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Router lifetime\n"
	"Router lifetime in seconds (0 stands for a non-default gw)\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_ra_retrans_interval_cmd_vtysh,
	"[no] ipv6 nd ra-retrans-interval ![(0-4294967295)$interval]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Advertisement Retransmit Interval\n"
	"Advertisement Retransmit Interval in msec\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_rdnss_cmd_vtysh,
	"[no] ipv6 nd rdnss X:X::X:X$addr [<(0-4294967295)|infinite>]$lifetime",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Recursive DNS server information\n"
	"IPv6 address\n"
	"Valid lifetime in seconds\n"
	"Infinite valid lifetime\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_reachable_time_cmd_vtysh,
	"[no] ipv6 nd reachable-time ![(1-3600000)$msec]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Reachable time\n"
	"Reachable time in milliseconds\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_router_preference_cmd_vtysh,
	"[no] ipv6 nd router-preference ![<high|medium|low>$pref]",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Default router preference\n"
	"High default router preference\n"
	"Medium default router preference (default)\n"
	"Low default router preference\n")

DEFSH (VTYSH_MGMTD, ipv6_nd_suppress_ra_cmd_vtysh,
	"[no] ipv6 nd suppress-ra",
	"Negate a command or set its defaults\n"
	"Interface IPv6 config commands\n"
	"Neighbor discovery\n"
	"Suppress Router Advertisement\n")

DEFSH (VTYSH_MGMTD, ipv6_nht_default_route_cmd_vtysh,
	"[no] ipv6 nht resolve-via-default",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Filter Next Hop tracking route resolution\n"
	"Resolve via default route\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_advertise_prefix_list_cmd_vtysh,
	"ipv6 ospf6 advertise prefix-list PREFIXLIST6_NAME",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Advertising options\n"
	"Filter prefix using prefix-list\n"
	"Prefix list name\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_area_cmd_vtysh,
	"ipv6 ospf6 area <A.B.C.D|(0-4294967295)>",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the OSPF6 area ID\n"
	"OSPF6 area ID in IPv4 address notation\n"
	"OSPF6 area ID in decimal notation\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_bfd_cmd_vtysh,
	"ipv6 ospf6 bfd [profile BFDPROF]",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Enables BFD support\n"
	"BFD Profile selection\n"
	"BFD Profile name\n")

DEFSH_HIDDEN (VTYSH_OSPF6D, ipv6_ospf6_bfd_param_cmd_vtysh,
	"ipv6 ospf6 bfd (2-255) (50-60000) (50-60000)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Enables BFD support\n"
	"Detect Multiplier\n"
	"Required min receive interval\n"
	"Desired min transmit interval\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_cost_cmd_vtysh,
	"ipv6 ospf6 cost (1-65535)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Interface cost\n"
	"Outgoing metric of this interface\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_deadinterval_cmd_vtysh,
	"ipv6 ospf6 dead-interval (1-65535)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_gr_hdelay_cmd_vtysh,
	"ipv6 ospf6 graceful-restart hello-delay (1-1800)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Graceful Restart parameters\n"
	"Delay the sending of the first hello packets.\n"
	"Delay in seconds\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_hellointerval_cmd_vtysh,
	"ipv6 ospf6 hello-interval (1-65535)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Time between HELLO packets\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_ifmtu_cmd_vtysh,
	"ipv6 ospf6 ifmtu (1-65535)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Interface MTU\n"
	"OSPFv3 Interface MTU\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_instance_cmd_vtysh,
	"ipv6 ospf6 instance-id (0-255)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Instance ID for this interface\n"
	"Instance ID value\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_intf_auth_trailer_key_cmd_vtysh,
	"ipv6 ospf6 authentication key-id (1-65535) hash-algo <md5|hmac-sha-1|hmac-sha-256|hmac-sha-384|hmac-sha-512> key WORD",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Authentication\n"
	"Key ID\n"
	"Key ID value\n"
	"Cryptographic-algorithm\n"
	"Use MD5 algorithm\n"
	"Use HMAC-SHA-1 algorithm\n"
	"Use HMAC-SHA-256 algorithm\n"
	"Use HMAC-SHA-384 algorithm\n"
	"Use HMAC-SHA-512 algorithm\n"
	"Password\n"
	"Password string (key)\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_intf_auth_trailer_keychain_cmd_vtysh,
	"ipv6 ospf6 authentication keychain KEYCHAIN_NAME",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Enable authentication on this interface\n"
	"Keychain\n"
	"Keychain name\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_mtu_ignore_cmd_vtysh,
	"ipv6 ospf6 mtu-ignore",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Disable MTU mismatch detection on this interface\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_network_cmd_vtysh,
	"ipv6 ospf6 network <broadcast|point-to-point|point-to-multipoint>",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Network type\n"
	"Specify OSPF6 broadcast network\n"
	"Specify OSPF6 point-to-point network\n"
	"Specify OSPF6 point-to-multipoint network\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_connected_pfx_cmd_vtysh,
	"[no] ipv6 ospf6 p2p-p2mp connected-prefixes <include$incl|exclude$excl>",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Point-to-point and Point-to-Multipoint parameters\n"
	"Adjust handling of directly connected prefixes\n"
	"Advertise prefixes and own /128 (default for PtP)\n"
	"Ignore, only advertise own /128 (default for PtMP)\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_neigh_cmd_vtysh,
	"[no] ipv6 ospf6 neighbor X:X::X:X",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Configure static neighbor\n"
	"Neighbor link-local address\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_neigh_cost_cmd_vtysh,
	"[no] ipv6 ospf6 neighbor X:X::X:X cost (1-65535)",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Configure static neighbor\n"
	"Neighbor link-local address\n"
	"Outgoing metric for this neighbor\n"
	"Outgoing metric for this neighbor\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_neigh_poll_interval_cmd_vtysh,
	"[no] ipv6 ospf6 neighbor X:X::X:X poll-interval (1-65535)",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Configure static neighbor\n"
	"Neighbor link-local address\n"
	"Send unicast hellos to neighbor when down\n"
	"Unicast hello interval when down (seconds)\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_no_multicast_hello_cmd_vtysh,
	"[no] ipv6 ospf6 p2p-p2mp disable-multicast-hello",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Point-to-point and Point-to-Multipoint parameters\n"
	"Do not send multicast hellos\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_p2xp_only_cfg_neigh_cmd_vtysh,
	"[no] ipv6 ospf6 p2p-p2mp config-neighbors-only",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Point-to-point and Point-to-Multipoint parameters\n"
	"Only form adjacencies with explicitly configured neighbors\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_passive_cmd_vtysh,
	"ipv6 ospf6 passive",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Passive interface; no adjacency will be formed on this interface\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_priority_cmd_vtysh,
	"ipv6 ospf6 priority (0-255)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Router priority\n"
	"Priority value\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_retransmitinterval_cmd_vtysh,
	"ipv6 ospf6 retransmit-interval (1-65535)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, ipv6_ospf6_transmitdelay_cmd_vtysh,
	"ipv6 ospf6 transmit-delay (1-3600)",
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Link state transmit delay\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, ipv6_pim_bsm_cmd_vtysh,
	"ipv6 pim bsm",
	"IPv6 information\n"
	"PIM information\n"
	"Enable BSM support on the interface\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_joinprune_time_cmd_vtysh,
	"ipv6 pim join-prune-interval (1-65535)$jpi",
	"IPv6 information\n"
	"PIM information\n"
	"Join Prune Send Interval\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_keep_alive_cmd_vtysh,
	"ipv6 pim keep-alive-timer (1-65535)$kat",
	"IPv6 information\n"
	"PIM information\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_packets_cmd_vtysh,
	"ipv6 pim packets (1-255)",
	"IPv6 information\n"
	"PIM information\n"
	"packets to process at one time per fd\n"
	"Number of packets\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_register_suppress_cmd_vtysh,
	"ipv6 pim register-suppress-time (1-65535)$rst",
	"IPv6 information\n"
	"PIM information\n"
	"Register Suppress Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_rp_cmd_vtysh,
	"ipv6 pim rp X:X::X:X$rp [X:X::X:X/M]$gp",
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"Group Address range to cover\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_rp_keep_alive_cmd_vtysh,
	"ipv6 pim rp keep-alive-timer (1-65535)$kat",
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_rp_prefix_list_cmd_vtysh,
	"ipv6 pim rp X:X::X:X$rp prefix-list PREFIXLIST6_NAME$plist",
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_spt_switchover_infinity_cmd_vtysh,
	"ipv6 pim spt-switchover infinity-and-beyond",
	"IPv6 information\n"
	"PIM information\n"
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_pim_spt_switchover_infinity_plist_cmd_vtysh,
	"ipv6 pim spt-switchover infinity-and-beyond prefix-list PREFIXLIST6_NAME$plist",
	"IPv6 information\n"
	"PIM information\n"
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIM6D, ipv6_pim_ssm_cmd_vtysh,
	"[no] ssm prefix-list PREFIXLIST6_NAME$plist",
	"Negate a command or set its defaults\n"
	"Source Specific Multicast\n"
	"Group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIM6D, ipv6_pim_ucast_bsm_cmd_vtysh,
	"ipv6 pim unicast-bsm",
	"IPv6 information\n"
	"PIM information\n"
	"Accept/Send unicast BSM on the interface\n")

DEFSH (VTYSH_ACL_CONFIG, ipv6_prefix_list_cmd_vtysh,
	"ipv6 prefix-list PREFIXLIST6_NAME$name [seq (1-4294967295)] <deny|permit>$action <any|X:X::X:X/M$prefix [{ge (0-128)$ge|le (0-128)$le}]>",
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Any prefix match.  Same as \"::0/0 le 128\"\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n"
	"Maximum prefix length to be matched\n"
	"Maximum prefix length\n"
	"Minimum prefix length to be matched\n"
	"Minimum prefix length\n")

DEFSH (VTYSH_ACL_CONFIG, ipv6_prefix_list_remark_cmd_vtysh,
	"ipv6 prefix-list PREFIXLIST6_NAME$name description LINE...",
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_MGMTD, ipv6_protocol_cmd_vtysh,
	"[no] ipv6 protocol <static|ripng|ospf6|isis|bgp|nhrp|vnc|babel|openfabric|any> $proto ![route-map ROUTE-MAP$rmap]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Filter IPv6 routing info exchanged between zebra and protocol\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Any of the above protocols\n"
	"Specify route-map\n"
	"Route map name\n")

DEFSH (VTYSH_MGMTD, ipv6_protocol_nht_rmap_cmd_vtysh,
	"[no] ipv6 nht <static|ripng|ospf6|isis|bgp|nhrp|vnc|babel|openfabric|any> $proto ![route-map ROUTE-MAP$rmap]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Filter Next Hop tracking route resolution\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Any of the above protocols\n"
	"Specify route map\n"
	"Route map name\n")

DEFSH (VTYSH_MGMTD, ipv6_ripng_split_horizon_cmd_vtysh,
	"[no] ipv6 ripng split-horizon [poisoned-reverse$poisoned_reverse]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Routing Information Protocol\n"
	"Perform split horizon\n"
	"With poisoned-reverse\n")

DEFSH (VTYSH_MGMTD, ipv6_route_address_interface_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           X:X::X:X$gate                                              <INTERFACE|Null0>$ifname                                   [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |vrf NAME                                                  |label WORD                                    	    |table (1-4294967295)                                      |nexthop-vrf NAME                              	    |onlink$onlink                                 	    |color (1-4294967295)                          	    |bfd$bfd [{multi-hop$bfd_multi_hop|source X:X::X:X$bfd_source|profile BFDPROF$bfd_profile}] 		|segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"IPv6 gateway address\n"
	"IPv6 gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Treat the nexthop as directly attached to the interface\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Value of segs\n"
	"Segs (SIDs)\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ipv6_route_address_interface_vrf_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           X:X::X:X$gate                                              <INTERFACE|Null0>$ifname                                   [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |label WORD                                    	    |table (1-4294967295)                                      |nexthop-vrf NAME                              	    |onlink$onlink                                 	    |color (1-4294967295)                          	    |bfd$bfd [{multi-hop$bfd_multi_hop|source X:X::X:X$bfd_source|profile BFDPROF$bfd_profile}] 		|segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"IPv6 gateway address\n"
	"IPv6 gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Treat the nexthop as directly attached to the interface\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Value of segs\n"
	"Segs (SIDs)\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ipv6_route_blackhole_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           <reject|blackhole>$flag                                    [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |vrf NAME                                                  |label WORD                                                |table (1-4294967295)                                    }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"Emit an ICMP unreachable when matched\n"
	"Silently discard pkts when matched\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n")

DEFSH (VTYSH_MGMTD, ipv6_route_blackhole_vrf_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           <reject|blackhole>$flag                                    [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |label WORD                                                |table (1-4294967295)                                    }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"Emit an ICMP unreachable when matched\n"
	"Silently discard pkts when matched\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n")

DEFSH (VTYSH_MGMTD, ipv6_route_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           <X:X::X:X$gate|<INTERFACE|Null0>$ifname>                   [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |vrf NAME                                                  |label WORD                                    	    |table (1-4294967295)                                      |nexthop-vrf NAME                                          |color (1-4294967295)                          	    |bfd$bfd [{multi-hop$bfd_multi_hop|source X:X::X:X$bfd_source|profile BFDPROF$bfd_profile}] 			|segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"IPv6 gateway address\n"
	"IPv6 gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Value of segs\n"
	"Segs (SIDs)\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ipv6_route_vrf_cmd_vtysh,
	"[no] ipv6 route X:X::X:X/M$prefix [from X:X::X:X/M]           <X:X::X:X$gate|<INTERFACE|Null0>$ifname>                           [{                                                           tag (1-4294967295)                                         |(1-255)$distance                                          |label WORD                                    	    |table (1-4294967295)                                      |nexthop-vrf NAME                              	    |color (1-4294967295)                          	    |bfd$bfd [{multi-hop$bfd_multi_hop|source X:X::X:X$bfd_source|profile BFDPROF$bfd_profile}] 		|segments WORD [encap-behavior <H_Encaps|H_Encaps_Red>$encap_behavior]           }]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Establish static routes\n"
	"IPv6 destination prefix (e.g. 3ffe:506::/32)\n"
	"IPv6 source-dest route\n"
	"IPv6 source prefix\n"
	"IPv6 gateway address\n"
	"IPv6 gateway interface name\n"
	"Null interface\n"
	"Set tag for this route\n"
	"Tag value\n"
	"Distance value for this prefix\n"
	"Specify label(s) for this route\n"
	"One or more labels in the range (16-1048575) separated by '/'\n"
	"Table to configure\n"
	"The table number to configure\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"SR-TE color\n"
	"The SR-TE color to configure\n"
	"BFD monitoring\n"
	"Use BFD multi hop session\n"
	"Use source for BFD session\n"
	"Use IPv4 source for BFD session\n"
	"BFD profile.\n"
	"BFD profile name.\n"
	"Value of segs\n"
	"Segs (SIDs)\n"
	"Configure SRv6 encap mode\n"
	"H.Encaps\n"
	"H.Encaps.Red\n")

DEFSH (VTYSH_MGMTD, ipv6_router_id_cmd_vtysh,
	"[no] ipv6 router-id X:X::X:X$id vrf NAME",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Manually set the router-id\n"
	"IPv6 address to use for router-id\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, ipv6_router_id_in_vrf_cmd_vtysh,
	"[no] ipv6 router-id ![X:X::X:X$id]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Manually set the IPv6 router-id\n"
	"IPV6 address to use for router-id\n")

DEFSH_HIDDEN (VTYSH_PIM6D, ipv6_ssmpingd_cmd_vtysh,
	"ipv6 ssmpingd [X:X::X:X]$source",
	"IPv6 information\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_ISISD, is_type_cmd_vtysh,
	"is-type <level-1|level-1-2|level-2-only>$level",
	"IS Level for this routing process (OSI only)\n"
	"Act as a station router only\n"
	"Act as both a station router and an area router\n"
	"Act as an area router only\n")

DEFSH (VTYSH_ISISD, isis_admin_group_send_zero_cmd_vtysh,
	"[no] admin-group-send-zero",
	"Negate a command or set its defaults\n"
	"Allow sending the default admin-group value of 0x00000000.\n")

DEFSH_HIDDEN (VTYSH_ISISD, isis_asla_legacy_flag_cmd_vtysh,
	"[no] asla-legacy-flag",
	"Negate a command or set its defaults\n"
	"Set the legacy flag (aka. L-FLAG) in the ASLA Sub-TLV.\n")

DEFSH (VTYSH_ISISD, isis_bfd_cmd_vtysh,
	"[no] isis bfd",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Enable BFD support\n")

DEFSH (VTYSH_ISISD, isis_bfd_profile_cmd_vtysh,
	"[no] isis bfd profile BFDPROF$profile",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Enable BFD support\n"
	"Use a pre-configured profile\n"
	"Profile name\n")

DEFSH (VTYSH_ISISD, isis_circuit_type_cmd_vtysh,
	"isis circuit-type <level-1|level-1-2|level-2-only>$type",
	"IS-IS routing protocol\n"
	"Configure circuit type for interface\n"
	"Level-1 only adjacencies are formed\n"
	"Level-1-2 adjacencies are formed\n"
	"Level-2 only adjacencies are formed\n")

DEFSH (VTYSH_ISISD, isis_default_originate_cmd_vtysh,
	"[no] default-information originate <ipv4|ipv6>$ip <level-1|level-2>$level [always]$always [{metric (0-16777215)$metric|route-map RMAP_NAME$rmap}]",
	"Negate a command or set its defaults\n"
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Distribute default route for IPv4\n"
	"Distribute default route for IPv6\n"
	"Distribute default route into level-1\n"
	"Distribute default route into level-2\n"
	"Always advertise default route\n"
	"Metric for default route\n"
	"IS-IS default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_ISISD, isis_frr_lfa_load_sharing_cmd_vtysh,
	"[no] fast-reroute load-sharing disable [<level-1|level-2>$level]",
	"Negate a command or set its defaults\n"
	"Configure Fast ReRoute\n"
	"Load share prefixes across multiple backups\n"
	"Disable load sharing\n"
	"Disable load sharing for level-1 only\n"
	"Disable load sharing for level-2 only\n")

DEFSH (VTYSH_ISISD, isis_frr_lfa_priority_limit_cmd_vtysh,
	"[no] fast-reroute priority-limit <critical|high|medium>$priority [<level-1|level-2>$level]",
	"Negate a command or set its defaults\n"
	"Configure Fast ReRoute\n"
	"Limit backup computation up to the prefix priority\n"
	"Compute for critical priority prefixes only\n"
	"Compute for critical & high priority prefixes\n"
	"Compute for critical, high & medium priority prefixes\n"
	"Set priority-limit for level-1 only\n"
	"Set priority-limit for level-2 only\n")

DEFSH (VTYSH_ISISD, isis_frr_lfa_tiebreaker_cmd_vtysh,
	"[no] fast-reroute lfa          tiebreaker <downstream|lowest-backup-metric|node-protecting>$type	  index (1-255)$index	  [<level-1|level-2>$level]",
	"Negate a command or set its defaults\n"
	"Configure Fast ReRoute\n"
	"LFA configuration\n"
	"Configure tiebreaker for multiple backups\n"
	"Prefer backup path via downstream node\n"
	"Prefer backup path with lowest total metric\n"
	"Prefer node protecting backup path\n"
	"Set preference order among tiebreakers\n"
	"Index\n"
	"Configure tiebreaker for level-1 only\n"
	"Configure tiebreaker for level-2 only\n")

DEFSH (VTYSH_ISISD, isis_frr_remote_lfa_plist_cmd_vtysh,
	"fast-reroute remote-lfa prefix-list WORD$plist [<level-1|level-2>$level]",
	"Configure Fast ReRoute\n"
	"Enable remote LFA related configuration\n"
	"Filter PQ node router ID based on prefix list\n"
	"Prefix-list name\n"
	"Enable router ID filtering for level-1 only\n"
	"Enable router ID filtering for level-2 only\n")

DEFSH (VTYSH_ISISD, isis_hello_interval_cmd_vtysh,
	"isis hello-interval [level-1|level-2]$level (1-600)$intv",
	"IS-IS routing protocol\n"
	"Set Hello interval\n"
	"Specify hello-interval for level-1 IIHs\n"
	"Specify hello-interval for level-2 IIHs\n"
	"Holdtime 1 seconds, interval depends on multiplier\n")

DEFSH (VTYSH_ISISD, isis_hello_multiplier_cmd_vtysh,
	"isis hello-multiplier [level-1|level-2]$level (2-100)$mult",
	"IS-IS routing protocol\n"
	"Set multiplier for Hello holding time\n"
	"Specify hello multiplier for level-1 IIHs\n"
	"Specify hello multiplier for level-2 IIHs\n"
	"Hello multiplier value\n")

DEFSH (VTYSH_ISISD, isis_hello_padding_cmd_vtysh,
	"[no] isis hello padding [during-adjacency-formation]$padding_type",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Type of padding for IS-IS hello packets\n"
	"Pad hello packets\n"
	"Add padding to hello packets during adjacency formation only.\n")

DEFSH (VTYSH_ISISD, isis_lfa_cmd_vtysh,
	"[no] isis fast-reroute lfa [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Interface IP Fast-reroute configuration\n"
	"Enable LFA computation\n"
	"Enable LFA computation for Level 1 only\n"
	"Enable LFA computation for Level 2 only\n")

DEFSH (VTYSH_ISISD, isis_lfa_exclude_interface_cmd_vtysh,
	"[no] isis fast-reroute lfa [level-1|level-2]$level exclude interface IFNAME$ifname",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Interface IP Fast-reroute configuration\n"
	"Enable LFA computation\n"
	"Enable LFA computation for Level 1 only\n"
	"Enable LFA computation for Level 2 only\n"
	"FRR exclusion information\n"
	"Exclude an interface from computation\n"
	"Interface name\n")

DEFSH (VTYSH_ISISD, isis_metric_cmd_vtysh,
	"isis metric [level-1|level-2]$level (0-16777215)$met",
	"IS-IS routing protocol\n"
	"Set default metric for circuit\n"
	"Specify metric for level-1 routing\n"
	"Specify metric for level-2 routing\n"
	"Default metric value\n")

DEFSH (VTYSH_ISISD, isis_mpls_if_ldp_sync_cmd_vtysh,
	"[no] isis mpls ldp-sync",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n")

DEFSH (VTYSH_ISISD, isis_mpls_if_ldp_sync_holddown_cmd_vtysh,
	"isis mpls ldp-sync holddown (0-10000)",
	"IS-IS routing protocol\n"
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n"
	"Time to wait for LDP-SYNC to occur before restoring interface metric\n"
	"Time in seconds\n")

DEFSH (VTYSH_ISISD, isis_mpls_ldp_sync_cmd_vtysh,
	"mpls ldp-sync",
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n")

DEFSH (VTYSH_ISISD, isis_mpls_ldp_sync_holddown_cmd_vtysh,
	"mpls ldp-sync holddown (0-10000)",
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n"
	"Time to wait for LDP-SYNC to occur before restoring interface metric\n"
	"Time in seconds\n")

DEFSH (VTYSH_ISISD, isis_mpls_te_export_cmd_vtysh,
	"mpls-te export",
	"MPLS-TE specific commands\n"
	"Enable export of MPLS-TE Link State information\n")

DEFSH (VTYSH_ISISD, isis_mpls_te_inter_as_cmd_vtysh,
	"[no] mpls-te inter-as [level-1|level-1-2|level-2-only]",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Configure MPLS-TE Inter-AS support\n"
	"AREA native mode self originate INTER-AS LSP with L1 only flooding scope\n"
	"AREA native mode self originate INTER-AS LSP with L1 and L2 flooding scope\n"
	"AS native mode self originate INTER-AS LSP with L2 only flooding scope\n")

DEFSH (VTYSH_ISISD, isis_mpls_te_on_cmd_vtysh,
	"mpls-te on",
	"MPLS-TE specific commands\n"
	"Enable the MPLS-TE functionality\n")

DEFSH (VTYSH_ISISD, isis_mpls_te_router_addr_cmd_vtysh,
	"mpls-te router-address A.B.C.D",
	"MPLS-TE specific commands\n"
	"Stable IP address of the advertising router\n"
	"MPLS-TE router address in IPv4 address format\n")

DEFSH (VTYSH_ISISD, isis_mpls_te_router_addr_v6_cmd_vtysh,
	"mpls-te router-address ipv6 X:X::X:X",
	"MPLS-TE specific commands\n"
	"Stable IP address of the advertising router\n"
	"IPv6 address\n"
	"MPLS-TE router address in IPv6 address format\n")

DEFSH (VTYSH_ISISD, isis_network_cmd_vtysh,
	"[no] isis network point-to-point",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set network type\n"
	"point-to-point network type\n")

DEFSH (VTYSH_ISISD, isis_passive_cmd_vtysh,
	"[no] isis passive",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Configure the passive mode for interface\n")

DEFSH (VTYSH_ISISD, isis_passwd_cmd_vtysh,
	"isis password <md5|clear>$type WORD$pwd",
	"IS-IS routing protocol\n"
	"Configure the authentication password for a circuit\n"
	"HMAC-MD5 authentication\n"
	"Cleartext password\n"
	"Circuit password\n")

DEFSH (VTYSH_ISISD, isis_priority_cmd_vtysh,
	"isis priority (0-127)$prio [level-1|level-2]$level",
	"IS-IS routing protocol\n"
	"Set priority for Designated Router election\n"
	"Priority value\n"
	"Specify priority for level-1 routing\n"
	"Specify priority for level-2 routing\n")

DEFSH (VTYSH_ISISD, isis_redistribute_cmd_vtysh,
	"[no] redistribute <ipv4$ip <kernel|connected|local|static|rip|ospf|bgp|eigrp|nhrp|vnc|babel|openfabric>$proto|ipv6$ip <kernel|connected|local|static|ripng|ospf6|bgp|nhrp|vnc|babel|openfabric>$proto> <level-1|level-2>$level[{metric (0-16777215)|route-map RMAP_NAME$route_map}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Redistribute IPv4 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Redistribute IPv6 routes\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Redistribute into level-1\n"
	"Redistribute into level-2\n"
	"Metric for redistributed routes\n"
	"IS-IS default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_ISISD, isis_redistribute_table_cmd_vtysh,
	"[no] redistribute <ipv4|ipv6>$ip table (1-65535)$table<level-1|level-2>$level [{metric (0-16777215)|route-map WORD}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Redistribute IPv4 routes\n"
	"Redistribute IPv6 routes\n"
	"Non-main Kernel Routing Table\n"
	"Table Id\n"
	"Redistribute into level-1\n"
	"Redistribute into level-2\n"
	"Metric for redistributed routes\n"
	"IS-IS default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_ISISD, isis_remote_lfa_cmd_vtysh,
	"[no] isis fast-reroute remote-lfa tunnel mpls-ldp [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Interface IP Fast-reroute configuration\n"
	"Enable remote LFA computation\n"
	"Enable remote LFA computation using tunnels\n"
	"Use MPLS LDP tunnel to reach the remote LFA node\n"
	"Enable LFA computation for Level 1 only\n"
	"Enable LFA computation for Level 2 only\n")

DEFSH (VTYSH_ISISD, isis_remote_lfa_max_metric_cmd_vtysh,
	"[no] isis fast-reroute remote-lfa maximum-metric (1-16777215)$metric [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Interface IP Fast-reroute configuration\n"
	"Enable remote LFA computation\n"
	"Limit remote LFA node selection within the metric\n"
	"Value of the metric\n"
	"Enable LFA computation for Level 1 only\n"
	"Enable LFA computation for Level 2 only\n")

DEFSH (VTYSH_ISISD, isis_sr_enable_cmd_vtysh,
	"segment-routing on",
	"Segment-Routing specific commands\n"
	"Enable Segment Routing\n")

DEFSH (VTYSH_ISISD, isis_sr_global_block_label_range_cmd_vtysh,
	"segment-routing global-block (16-1048575)$gb_lower_bound (16-1048575)$gb_upper_bound [local-block (16-1048575)$lb_lower_bound (16-1048575)$lb_upper_bound]",
	"Segment-Routing specific commands\n"
	"Segment Routing Global Block label range\n"
	"The lower bound of the global block\n"
	"The upper bound of the global block (block size may not exceed 65535)\n"
	"Segment Routing Local Block label range\n"
	"The lower bound of the local block\n"
	"The upper bound of the local block (block size may not exceed 65535)\n")

DEFSH (VTYSH_ISISD, isis_sr_node_msd_cmd_vtysh,
	"segment-routing node-msd (1-16)$msd",
	"Segment-Routing specific commands\n"
	"Maximum Stack Depth for this router\n"
	"Maximum number of label that can be stack (1-16)\n")

DEFSH (VTYSH_ISISD, isis_sr_prefix_sid_algorithm_cmd_vtysh,
	"segment-routing prefix <A.B.C.D/M|X:X::X:X/M>$prefix              algorithm (128-255)$algorithm              <absolute$sid_type (16-1048575)$sid_value|index$sid_type (0-65535)$sid_value>              [<no-php-flag|explicit-null>$lh_behavior] [n-flag-clear$n_flag_clear]",
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n"
	"Algorithm Specific Prefix SID Configuration\n"
	"Algorithm number\n"
	"Specify the absolute value of Prefix Segment ID\n"
	"The Prefix Segment ID value\n"
	"Specify the index of Prefix Segment ID\n"
	"The Prefix Segment ID index\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n"
	"Not a node SID\n")

DEFSH (VTYSH_ISISD, isis_sr_prefix_sid_cmd_vtysh,
	"segment-routing prefix          <A.B.C.D/M|X:X::X:X/M>$prefix	  <absolute$sid_type (16-1048575)$sid_value|index$sid_type (0-65535)$sid_value>	  [<no-php-flag|explicit-null>$lh_behavior] [n-flag-clear$n_flag_clear]",
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n"
	"Specify the absolute value of Prefix Segment ID\n"
	"The Prefix Segment ID value\n"
	"Specify the index of Prefix Segment ID\n"
	"The Prefix Segment ID index\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n"
	"Not a node SID\n")

DEFSH (VTYSH_ISISD, isis_srv6_interface_cmd_vtysh,
	"[no] interface WORD$interface",
	"Negate a command or set its defaults\n"
	"Interface for Segment Routing over IPv6 (SRv6)\n"
	"Interface for Segment Routing over IPv6 (SRv6)\n")

DEFSH (VTYSH_ISISD, isis_srv6_locator_cmd_vtysh,
	"[no] locator NAME$loc_name",
	"Negate a command or set its defaults\n"
	"Specify SRv6 locator\n"
	"Specify SRv6 locator\n")

DEFSH (VTYSH_ISISD, isis_srv6_node_msd_max_end_d_cmd_vtysh,
	"[no] max-end-d (0-255)$max_end_d",
	"Negate a command or set its defaults\n"
	"Specify Maximum End D MSD\n"
	"Specify Maximum End D MSD\n")

DEFSH (VTYSH_ISISD, isis_srv6_node_msd_max_end_pop_cmd_vtysh,
	"[no] max-end-pop (0-255)$max_end_pop",
	"Negate a command or set its defaults\n"
	"Specify Maximum End Pop MSD\n"
	"Specify Maximum End Pop MSD\n")

DEFSH (VTYSH_ISISD, isis_srv6_node_msd_max_h_encaps_cmd_vtysh,
	"[no] max-h-encaps (0-255)$max_h_encaps",
	"Negate a command or set its defaults\n"
	"Specify Maximum H.Encaps MSD\n"
	"Specify Maximum H.Encaps MSD\n")

DEFSH (VTYSH_ISISD, isis_srv6_node_msd_max_segs_left_cmd_vtysh,
	"[no] max-segs-left (0-255)$max_segs_left",
	"Negate a command or set its defaults\n"
	"Specify Maximum Segments Left MSD\n"
	"Specify Maximum Segments Left MSD\n")

DEFSH (VTYSH_ISISD, isis_threeway_adj_cmd_vtysh,
	"[no] isis three-way-handshake",
	"Negate a command or set its defaults\n"
	"IS-IS commands\n"
	"Enable/Disable three-way handshake\n")

DEFSH (VTYSH_ISISD, isis_ti_lfa_cmd_vtysh,
	"[no] isis fast-reroute ti-lfa [level-1|level-2]$level [node-protection$node_protection [link-fallback$link_fallback]]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Interface IP Fast-reroute configuration\n"
	"Enable TI-LFA computation\n"
	"Enable TI-LFA computation for Level 1 only\n"
	"Enable TI-LFA computation for Level 2 only\n"
	"Protect against node failures\n"
	"Enable link-protection fallback\n")

DEFSH (VTYSH_ISISD, isis_topology_cmd_vtysh,
	"[no] topology <standard|ipv4-unicast|ipv4-mgmt|ipv6-unicast|ipv4-multicast|ipv6-multicast|ipv6-mgmt|ipv6-dstsrc>$topology [overload]$overload",
	"Negate a command or set its defaults\n"
	"Configure IS-IS topologies\n"
	"standard topology\n"
	"IPv4 unicast topology\n"
	"IPv4 management topology\n"
	"IPv6 unicast topology\n"
	"IPv4 multicast topology\n"
	"IPv6 multicast topology\n"
	"IPv6 management topology\n"
	"IPv6 dst-src topology\n"
	"Set overload bit for topology\n")

DEFSH (VTYSH_KEYS, key_string_cmd_vtysh,
	"key-string LINE",
	"Set key string\n"
	"The key\n")

DEFSH (VTYSH_LDPD, ldp_allow_broken_lsps_cmd_vtysh,
	"[no] install allow-broken-lsps",
	"Negate a command or set its defaults\n"
	"install lsps\n"
	"if no remote-label install with imp-null\n")

DEFSH (VTYSH_LDPD, ldp_bridge_cmd_vtysh,
	"[no] bridge IFNAME$ifname",
	"Negate a command or set its defaults\n"
	"Bridge interface\n"
	"Interface's name\n")

DEFSH (VTYSH_LDPD, ldp_clear_mpls_ldp_neighbor_cmd_vtysh,
	"clear mpls ldp neighbor [<A.B.C.D|X:X::X:X>]$address",
	"Reset functions\n"
	"Reset MPLS statistical information\n"
	"Clear LDP state\n"
	"Clear LDP neighbor sessions\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_LDPD, ldp_control_word_cmd_vtysh,
	"[no] control-word <exclude|include>$preference",
	"Negate a command or set its defaults\n"
	"Control-word options\n"
	"Exclude control-word in pseudowire packets\n"
	"Include control-word in pseudowire packets\n")

DEFSH (VTYSH_LDPD, ldp_debug_mpls_ldp_discovery_hello_cmd_vtysh,
	"[no] debug mpls ldp discovery hello <recv|sent>$dir",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Discovery messages\n"
	"Discovery hello message\n"
	"Received messages\n"
	"Sent messages\n")

DEFSH (VTYSH_LDPD, ldp_debug_mpls_ldp_messages_recv_cmd_vtysh,
	"[no] debug mpls ldp messages recv [all]$all",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Messages\n"
	"Received messages, excluding periodic Keep Alives\n"
	"Received messages, including periodic Keep Alives\n")

DEFSH (VTYSH_LDPD, ldp_debug_mpls_ldp_messages_sent_cmd_vtysh,
	"[no] debug mpls ldp messages sent [all]$all",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Messages\n"
	"Sent messages, excluding periodic Keep Alives\n"
	"Sent messages, including periodic Keep Alives\n")

DEFSH (VTYSH_LDPD, ldp_debug_mpls_ldp_type_cmd_vtysh,
	"[no] debug mpls ldp <errors|event|labels|sync|zebra>$type",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Errors\n"
	"LDP event information\n"
	"LDP label allocation information\n"
	"LDP sync information\n"
	"LDP zebra information\n")

DEFSH (VTYSH_LDPD, ldp_disable_establish_hello_cmd_vtysh,
	"[no] disable-establish-hello",
	"Negate a command or set its defaults\n"
	"Disable sending additional LDP hello message on establishing LDP tcp connection\n")

DEFSH (VTYSH_LDPD, ldp_discovery_link_holdtime_cmd_vtysh,
	"[no] discovery hello holdtime (1-65535)$holdtime",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"LDP Link Hellos\n"
	"Hello holdtime\n"
	"Time (seconds) - 65535 implies infinite\n")

DEFSH (VTYSH_LDPD, ldp_discovery_link_interval_cmd_vtysh,
	"[no] discovery hello interval (1-65535)$interval",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"LDP Link Hellos\n"
	"Hello interval\n"
	"Time (seconds)\n")

DEFSH (VTYSH_LDPD, ldp_discovery_targeted_hello_accept_cmd_vtysh,
	"[no] discovery targeted-hello accept [from ACCESSLIST_NAME$from_acl]",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"LDP Targeted Hellos\n"
	"Accept and respond to targeted hellos\n"
	"Access list to specify acceptable targeted hello source\n"
	"IP access-list name\n")

DEFSH (VTYSH_LDPD, ldp_discovery_targeted_holdtime_cmd_vtysh,
	"[no] discovery targeted-hello holdtime (1-65535)$holdtime",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"LDP Targeted Hellos\n"
	"Hello holdtime\n"
	"Time (seconds) - 65535 implies infinite\n")

DEFSH (VTYSH_LDPD, ldp_discovery_targeted_interval_cmd_vtysh,
	"[no] discovery targeted-hello interval (1-65535)$interval",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"LDP Targeted Hellos\n"
	"Hello interval\n"
	"Time (seconds)\n")

DEFSH (VTYSH_LDPD, ldp_discovery_transport_address_ipv4_cmd_vtysh,
	"[no] discovery transport-address A.B.C.D$address",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"Specify transport address for TCP connection\n"
	"IP address to be used as transport address\n")

DEFSH (VTYSH_LDPD, ldp_discovery_transport_address_ipv6_cmd_vtysh,
	"[no] discovery transport-address X:X::X:X$address",
	"Negate a command or set its defaults\n"
	"Configure discovery parameters\n"
	"Specify transport address for TCP connection\n"
	"IPv6 address to be used as transport address\n")

DEFSH (VTYSH_LDPD, ldp_dual_stack_cisco_interop_cmd_vtysh,
	"[no] dual-stack cisco-interop",
	"Negate a command or set its defaults\n"
	"Configure dual stack parameters\n"
	"Use Cisco non-compliant format to send and interpret the Dual-Stack capability TLV\n")

DEFSH (VTYSH_LDPD, ldp_dual_stack_transport_connection_prefer_ipv4_cmd_vtysh,
	"[no] dual-stack transport-connection prefer ipv4",
	"Negate a command or set its defaults\n"
	"Configure dual stack parameters\n"
	"Configure TCP transport parameters\n"
	"Configure preferred address family for TCP transport connection with neighbor\n"
	"IPv4\n")

DEFSH (VTYSH_LDPD, ldp_label_local_advertise_cmd_vtysh,
	"[no] label local advertise [{to ACCESSLIST_NAME$to_acl|for ACCESSLIST_NAME$for_acl}]",
	"Negate a command or set its defaults\n"
	"Configure label control and policies\n"
	"Configure local label control and policies\n"
	"Configure outbound label advertisement control\n"
	"IP Access-list specifying controls on LDP Peers\n"
	"IP access-list name\n"
	"IP access-list for destination prefixes\n"
	"IP access-list name\n")

DEFSH (VTYSH_LDPD, ldp_label_local_advertise_explicit_null_cmd_vtysh,
	"[no] label local advertise explicit-null [for ACCESSLIST_NAME$for_acl]",
	"Negate a command or set its defaults\n"
	"Configure label control and policies\n"
	"Configure local label control and policies\n"
	"Configure outbound label advertisement control\n"
	"Configure explicit-null advertisement\n"
	"IP access-list for destination prefixes\n"
	"IP access-list name\n")

DEFSH (VTYSH_LDPD, ldp_label_local_allocate_cmd_vtysh,
	"[no] label local allocate <host-routes$host_routes|for ACCESSLIST_NAME$for_acl>",
	"Negate a command or set its defaults\n"
	"Configure label control and policies\n"
	"Configure local label control and policies\n"
	"Configure label allocation control\n"
	"allocate local label for host routes only\n"
	"IP access-list\n"
	"IP access-list name\n")

DEFSH (VTYSH_LDPD, ldp_label_remote_accept_cmd_vtysh,
	"[no] label remote accept {from ACCESSLIST_NAME$from_acl|for ACCESSLIST_NAME$for_acl}",
	"Negate a command or set its defaults\n"
	"Configure label control and policies\n"
	"Configure remote/peer label control and policies\n"
	"Configure inbound label acceptance control\n"
	"Neighbor from whom to accept label advertisement\n"
	"IP access-list name\n"
	"IP access-list for destination prefixes\n"
	"IP access-list name\n")

DEFSH (VTYSH_LDPD, ldp_member_interface_cmd_vtysh,
	"[no] member interface IFNAME$ifname",
	"Negate a command or set its defaults\n"
	"L2VPN member configuration\n"
	"Local interface\n"
	"Interface's name\n")

DEFSH (VTYSH_LDPD, ldp_mtu_cmd_vtysh,
	"[no] mtu (1500-9180)$mtu",
	"Negate a command or set its defaults\n"
	"Set Maximum Transmission Unit\n"
	"Maximum Transmission Unit value\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_address_cmd_vtysh,
	"[no] neighbor address <A.B.C.D|X:X::X:X>$pw_address",
	"Negate a command or set its defaults\n"
	"Remote endpoint configuration\n"
	"Specify the IPv4 or IPv6 address of the remote endpoint\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_ipv4_targeted_cmd_vtysh,
	"[no] neighbor A.B.C.D$address targeted",
	"Negate a command or set its defaults\n"
	"Configure neighbor parameters\n"
	"IP address of neighbor\n"
	"Establish targeted session\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_ipv6_targeted_cmd_vtysh,
	"[no] neighbor X:X::X:X$address targeted",
	"Negate a command or set its defaults\n"
	"Configure neighbor parameters\n"
	"IPv6 address of neighbor\n"
	"Establish targeted session\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_lsr_id_cmd_vtysh,
	"[no] neighbor lsr-id A.B.C.D$address",
	"Negate a command or set its defaults\n"
	"Remote endpoint configuration\n"
	"Specify the LSR-ID of the remote endpoint\n"
	"IPv4 address\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_password_cmd_vtysh,
	"[no] neighbor A.B.C.D$neighbor password WORD$password",
	"Negate a command or set its defaults\n"
	"Configure neighbor parameters\n"
	"LDP Id of neighbor\n"
	"Configure password for MD5 authentication\n"
	"The password\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_session_holdtime_cmd_vtysh,
	"[no] neighbor A.B.C.D$neighbor session holdtime (15-65535)$holdtime",
	"Negate a command or set its defaults\n"
	"Configure neighbor parameters\n"
	"LDP Id of neighbor\n"
	"Configure session parameters\n"
	"Configure session holdtime\n"
	"Time (seconds)\n")

DEFSH (VTYSH_LDPD, ldp_neighbor_ttl_security_cmd_vtysh,
	"[no] neighbor A.B.C.D$neighbor ttl-security <disable|hops (1-254)$hops>",
	"Negate a command or set its defaults\n"
	"Configure neighbor parameters\n"
	"LDP Id of neighbor\n"
	"LDP ttl security check\n"
	"Disable ttl security\n"
	"IP hops\n"
	"maximum number of hops\n")

DEFSH (VTYSH_LDPD, ldp_ordered_control_cmd_vtysh,
	"[no] ordered-control",
	"Negate a command or set its defaults\n"
	"Configure LDP ordered label distribution control mode\n")

DEFSH (VTYSH_LDPD, ldp_pw_id_cmd_vtysh,
	"[no] pw-id (1-4294967295)$pwid",
	"Negate a command or set its defaults\n"
	"Set the Virtual Circuit ID\n"
	"Virtual Circuit ID value\n")

DEFSH (VTYSH_LDPD, ldp_pw_status_disable_cmd_vtysh,
	"[no] pw-status disable",
	"Negate a command or set its defaults\n"
	"Configure PW status\n"
	"Disable PW status\n")

DEFSH (VTYSH_LDPD, ldp_router_id_cmd_vtysh,
	"[no] router-id A.B.C.D$address",
	"Negate a command or set its defaults\n"
	"Configure router Id\n"
	"LSR Id (in form of an IPv4 address)\n")

DEFSH (VTYSH_LDPD, ldp_session_holdtime_cmd_vtysh,
	"[no] session holdtime (15-65535)$holdtime",
	"Negate a command or set its defaults\n"
	"Configure session parameters\n"
	"Configure session holdtime\n"
	"Time (seconds)\n")

DEFSH (VTYSH_LDPD, ldp_show_l2vpn_atom_binding_cmd_vtysh,
	"show l2vpn atom binding	  [{	    A.B.C.D$peer	    |local-label (16-1048575)$local_label	    |remote-label (16-1048575)$remote_label	  }]	 [json]$json",
	"Show running system information\n"
	"Show information about Layer2 VPN\n"
	"Show Any Transport over MPLS information\n"
	"Show AToM label binding information\n"
	"Destination address of the VC\n"
	"Match locally assigned label values\n"
	"Locally assigned label value\n"
	"Match remotely assigned label values\n"
	"Remotely assigned label value\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_l2vpn_atom_vc_cmd_vtysh,
	"show l2vpn atom vc	  [{	    A.B.C.D$peer	    |interface IFNAME$ifname	    |vc-id (1-4294967295)$vcid	  }]	 [json]$json",
	"Show running system information\n"
	"Show information about Layer2 VPN\n"
	"Show Any Transport over MPLS information\n"
	"Show AToM virtual circuit information\n"
	"Destination address of the VC\n"
	"Local interface of the pseudowire\n"
	"Interface's name\n"
	"VC ID\n"
	"VC ID\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_binding_cmd_vtysh,
	"show mpls ldp [<ipv4|ipv6>]$af binding	  [<A.B.C.D/M|X:X::X:X/M>$prefix [longer-prefixes$longer_prefixes]]	  [{	    neighbor A.B.C.D$nbr	    |local-label (0-1048575)$local_label	    |remote-label (0-1048575)$remote_label	  }]	 [detail]$detail [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"IPv4 Address Family\n"
	"IPv6 Address Family\n"
	"Label Information Base (LIB) information\n"
	"Destination prefix (IPv4)\n"
	"Destination prefix (IPv6)\n"
	"Include longer matches\n"
	"Display labels from LDP neighbor\n"
	"Neighbor LSR-ID\n"
	"Match locally assigned label values\n"
	"Locally assigned label value\n"
	"Match remotely assigned label values\n"
	"Remotely assigned label value\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_capabilities_cmd_vtysh,
	"show mpls ldp capabilities [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Display LDP Capabilities information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_discovery_cmd_vtysh,
	"show mpls ldp [<ipv4|ipv6>]$af discovery [detail]$detail [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"IPv4 Address Family\n"
	"IPv6 Address Family\n"
	"Discovery Hello Information\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_igp_sync_cmd_vtysh,
	"show mpls ldp igp-sync [json]$json",
	"Show mpls ldp ldp-sync information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"LDP-IGP Sync information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_interface_cmd_vtysh,
	"show mpls ldp [<ipv4|ipv6>]$af interface [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"IPv4 Address Family\n"
	"IPv6 Address Family\n"
	"interface information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_neighbor_capabilities_cmd_vtysh,
	"show mpls ldp neighbor [A.B.C.D]$lsr_id capabilities [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Neighbor information\n"
	"Neighbor LSR-ID\n"
	"Display neighbor capability information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_show_mpls_ldp_neighbor_cmd_vtysh,
	"show mpls ldp neighbor [A.B.C.D]$lsr_id [detail]$detail [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Label Distribution Protocol\n"
	"Neighbor information\n"
	"Neighbor LSR-ID\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_LDPD, ldp_ttl_security_disable_cmd_vtysh,
	"[no] ttl-security disable",
	"Negate a command or set its defaults\n"
	"LDP ttl security check\n"
	"Disable ttl security\n")

DEFSH (VTYSH_LDPD, ldp_vc_type_cmd_vtysh,
	"[no] vc type <ethernet|ethernet-tagged>$vc_type",
	"Negate a command or set its defaults\n"
	"Virtual Circuit options\n"
	"Virtual Circuit type to use\n"
	"Ethernet (type 5)\n"
	"Ethernet-tagged (type 4)\n")

DEFSH (VTYSH_LDPD, ldp_wait_for_sync_cmd_vtysh,
	"[no] wait-for-sync (1-10000)$waitforsync",
	"Negate a command or set its defaults\n"
	"Time to wait for LDP-IGP Sync to complete label exchange\n"
	"Time (seconds)\n")

DEFSH (VTYSH_MGMTD, link_params_admin_grp_cmd_vtysh,
	"[no] admin-grp ![BITPATTERN]",
	"Negate a command or set its defaults\n"
	"Administrative group membership\n"
	"32-bit Hexadecimal value (e.g. 0xa1)\n")

DEFSH (VTYSH_MGMTD, link_params_affinity_cmd_vtysh,
	"[no] affinity NAME...",
	"Negate a command or set its defaults\n"
	"Interface affinities\n"
	"Affinity names\n")

DEFSH (VTYSH_MGMTD, link_params_affinity_mode_cmd_vtysh,
	"[no] affinity-mode ![<standard|extended|both>$mode]",
	"Negate a command or set its defaults\n"
	"Interface affinity mode\n"
	"Standard Admin-Group only RFC3630,5305,5329\n"
	"Extended Admin-Group only RFC7308 (default)\n"
	"Standard and extended Admin-Group format\n")

DEFSH (VTYSH_MGMTD, link_params_ava_bw_cmd_vtysh,
	"[no] ava-bw ![BANDWIDTH]",
	"Negate a command or set its defaults\n"
	"Unidirectional Available Bandwidth\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, link_params_delay_cmd_vtysh,
	"[no] delay ![(0-16777215)$delay [min (0-16777215)$min max (0-16777215)$max]]",
	"Negate a command or set its defaults\n"
	"Unidirectional Average Link Delay\n"
	"Average delay in micro-second as decimal (0...16777215)\n"
	"Minimum delay\n"
	"Minimum delay in micro-second as decimal (0...16777215)\n"
	"Maximum delay\n"
	"Maximum delay in micro-second as decimal (0...16777215)\n")

DEFSH (VTYSH_MGMTD, link_params_delay_var_cmd_vtysh,
	"[no] delay-variation ![(0-16777215)$delay_var]",
	"Negate a command or set its defaults\n"
	"Unidirectional Link Delay Variation\n"
	"delay variation in micro-second as decimal (0...16777215)\n")

DEFSH_HIDDEN (VTYSH_MGMTD, link_params_enable_cmd_vtysh,
	"enable",
	"Activate link parameters on this interface\n")

DEFSH (VTYSH_MGMTD, link_params_inter_as_cmd_vtysh,
	"[no] neighbor ![A.B.C.D$ip as (1-4294967295)$as]",
	"Negate a command or set its defaults\n"
	"Configure remote ASBR information (Neighbor IP address and AS number)\n"
	"Remote IP address in dot decimal A.B.C.D\n"
	"Remote AS number\n"
	"AS number in the range <1-4294967295>\n")

DEFSH (VTYSH_MGMTD, link_params_max_rsv_bw_cmd_vtysh,
	"max-rsv-bw BANDWIDTH",
	"Maximum bandwidth that may be reserved\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, link_params_maxbw_cmd_vtysh,
	"max-bw BANDWIDTH",
	"Maximum bandwidth that can be used\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, link_params_metric_cmd_vtysh,
	"[no] metric ![(0-4294967295)]$metric",
	"Negate a command or set its defaults\n"
	"Link metric for MPLS-TE purpose\n"
	"Metric value in decimal\n")

DEFSH (VTYSH_MGMTD, link_params_pkt_loss_cmd_vtysh,
	"[no] packet-loss ![PERCENTAGE]",
	"Negate a command or set its defaults\n"
	"Unidirectional Link Packet Loss\n"
	"percentage of total traffic by 0.000003% step and less than 50.331642%\n")

DEFSH (VTYSH_MGMTD, link_params_res_bw_cmd_vtysh,
	"[no] res-bw ![BANDWIDTH]",
	"Negate a command or set its defaults\n"
	"Unidirectional Residual Bandwidth\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, link_params_unrsv_bw_cmd_vtysh,
	"unrsv-bw (0-7)$priority BANDWIDTH",
	"Unreserved bandwidth at each priority level\n"
	"Priority\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, link_params_use_bw_cmd_vtysh,
	"[no] use-bw ![BANDWIDTH]",
	"Negate a command or set its defaults\n"
	"Unidirectional Utilised Bandwidth\n"
	"Bytes/second (IEEE floating point format)\n")

DEFSH (VTYSH_MGMTD, linkdetect_cmd_vtysh,
	"[no] link-detect",
	"Negate a command or set its defaults\n"
	"Enable link detection on interface\n")

DEFSH (VTYSH_ZEBRA, locator_behavior_cmd_vtysh,
	"[no] behavior usid",
	"Negate a command or set its defaults\n"
	"Configure SRv6 behavior\n"
	"Specify SRv6 behavior uSID\n")

DEFSH (VTYSH_ZEBRA, locator_flavor_psp_cmd_vtysh,
	"[no] flavor psp",
	"Negate a command or set its defaults\n"
	"Configure SRv6 flavors\n"
	"Specify Penultimate Segment Popping flavor\n")

DEFSH (VTYSH_ZEBRA, locator_prefix_cmd_vtysh,
	"prefix X:X::X:X/M$prefix [block-len (16-64)$block_bit_len]  	        [node-len (0-64)$node_bit_len] [func-bits (0-64)$func_bit_len]",
	"Configure SRv6 locator prefix\n"
	"Specify SRv6 locator prefix\n"
	"Configure SRv6 locator block length in bits\n"
	"Specify SRv6 locator block length in bits\n"
	"Configure SRv6 locator node length in bits\n"
	"Specify SRv6 locator node length in bits\n"
	"Configure SRv6 locator function length in bits\n"
	"Specify SRv6 locator function length in bits\n")

DEFSH (VTYSH_ZEBRA, locator_sid_format_cmd_vtysh,
	"format <usid-f3216|usid-f4816|uncompressed-f4024>$format",
	"Configure SRv6 SID format\n"
	"Specify usid-f3216 format\n"
	"Specify usid-f4816 format\n"
	"Specify uncompressed-f4024 format\n")

DEFSH (VTYSH_ISISD, log_adj_changes_cmd_vtysh,
	"[no] log-adjacency-changes",
	"Negate a command or set its defaults\n"
	"Log changes in adjacency state\n")

DEFSH (VTYSH_ALL, log_commands_cmd_vtysh,
	"[no] log commands",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Log all commands\n")

DEFSH (VTYSH_NON_MGMTD, log_filter_clear_cmd_vtysh,
	"clear log filter-text",
	"Reset functions\n"
	"Logging control\n"
	"Filter Logs\n")

DEFSH (VTYSH_NON_MGMTD, log_filter_cmd_vtysh,
	"[no] log filter-text WORD$filter",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Filter Logs\n"
	"String to filter by\n")

DEFSH (VTYSH_NON_MGMTD, log_immediate_mode_cmd_vtysh,
	"[no] log immediate-mode",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Output immediately, without buffering\n")

DEFSH (VTYSH_ISISD, log_pdu_drops_cmd_vtysh,
	"[no] log-pdu-drops",
	"Negate a command or set its defaults\n"
	"Log any dropped PDUs\n")

DEFSH (VTYSH_ISISD, lsp_gen_interval_cmd_vtysh,
	"lsp-gen-interval [level-1|level-2]$level (1-120)$val",
	"Minimum interval between regenerating same LSP\n"
	"Set interval for level 1 only\n"
	"Set interval for level 2 only\n"
	"Minimum interval in seconds\n")

DEFSH (VTYSH_ISISD, lsp_refresh_interval_cmd_vtysh,
	"lsp-refresh-interval [level-1|level-2]$level (1-65235)$val",
	"LSP refresh interval\n"
	"LSP refresh interval for Level 1 only\n"
	"LSP refresh interval for Level 2 only\n"
	"LSP refresh interval in seconds\n")

DEFSH (VTYSH_ISISD, lsp_timers_cmd_vtysh,
	"lsp-timers [level-1|level-2]$level gen-interval (1-120)$gen refresh-interval (1-65235)$refresh max-lifetime (350-65535)$lifetime",
	"LSP-related timers\n"
	"LSP-related timers for Level 1 only\n"
	"LSP-related timers for Level 2 only\n"
	"Minimum interval between regenerating same LSP\n"
	"Generation interval in seconds\n"
	"LSP refresh interval\n"
	"LSP refresh interval in seconds\n"
	"Maximum LSP lifetime\n"
	"Maximum LSP lifetime in seconds\n")

DEFSH (VTYSH_ACL_CONFIG, mac_access_list_cmd_vtysh,
	"mac access-list ACCESSLIST_MAC_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <X:X:X:X:X:X$mac|any>",
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"MAC address\n"
	"Match any MAC address\n")

DEFSH (VTYSH_ACL_CONFIG, mac_access_list_remark_cmd_vtysh,
	"mac access-list ACCESSLIST_MAC_NAME$name remark LINE...",
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_BGPD, macvrf_soo_global_cmd_vtysh,
	"mac-vrf soo ASN:NN_OR_IP-ADDRESS:NN$soo",
	"EVPN MAC-VRF\n"
	"Site-of-Origin extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, match_alias_cmd_vtysh,
	"match alias ALIAS_NAME",
	"Match values from routing table\n"
	"Match BGP community alias name\n"
	"BGP community alias name\n")

DEFSH (VTYSH_BGPD, match_aspath_cmd_vtysh,
	"match as-path AS_PATH_FILTER_NAME",
	"Match values from routing table\n"
	"Match BGP AS path list\n"
	"AS path access-list name\n")

DEFSH (VTYSH_BGPD, match_community_cmd_vtysh,
	"match community <(1-99)|(100-500)|COMMUNITY_LIST_NAME> [<exact-match$exact|any$any>]",
	"Match values from routing table\n"
	"Match BGP community list\n"
	"Community-list number (standard)\n"
	"Community-list number (expanded)\n"
	"Community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, match_community_limit_cmd_vtysh,
	"[no$no] match community-limit ![(0-65535)$limit]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP community limit\n"
	"Community limit number\n")

DEFSH (VTYSH_BGPD, match_ecommunity_cmd_vtysh,
	"match extcommunity <(1-99)|(100-500)|EXTCOMMUNITY_LIST_NAME> [<exact-match$exact|any$any>]",
	"Match values from routing table\n"
	"Match BGP/VPN extended community list\n"
	"Extended community-list number (standard)\n"
	"Extended community-list number (expanded)\n"
	"Extended community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, match_evpn_default_route_cmd_vtysh,
	"match evpn default-route",
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"default EVPN type-5 route\n")

DEFSH (VTYSH_BGPD, match_evpn_rd_cmd_vtysh,
	"match evpn rd ASN:NN_OR_IP-ADDRESS:NN",
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, match_evpn_route_type_cmd_vtysh,
	"match evpn route-type <ead|1|macip|2|multicast|3|es|4|prefix|5>",
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n")

DEFSH (VTYSH_BGPD, match_evpn_vni_cmd_vtysh,
	"match evpn vni (1-16777215)",
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Match VNI\n"
	"VNI ID\n")

DEFSH (VTYSH_BGPD, match_extcommunity_limit_cmd_vtysh,
	"[no$no] match extcommunity-limit ![(0-65535)$limit]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP extended community limit\n"
	"Extended community limit number\n")

DEFSH (VTYSH_RMAP_CONFIG, match_interface_cmd_vtysh,
	"match interface IFNAME",
	"Match values from routing table\n"
	"Match first hop interface of route\n"
	"Interface information\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ip_address_cmd_vtysh,
	"match ip address ACCESSLIST4_NAME$name",
	"Match values from routing table\n"
	"IP information\n"
	"Match address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_MGMTD, match_ip_address_prefix_len_cmd_vtysh,
	"match ip address prefix-len (0-32)$length",
	"Match values from routing table\n"
	"IP information\n"
	"Match prefix length of IP address\n"
	"Match prefix length of IP address\n"
	"Prefix length\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ip_address_prefix_list_cmd_vtysh,
	"match ip address prefix-list PREFIXLIST4_NAME$name",
	"Match values from routing table\n"
	"IP information\n"
	"Match address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ip_next_hop_cmd_vtysh,
	"match ip next-hop ACCESSLIST4_NAME$name",
	"Match values from routing table\n"
	"IP information\n"
	"Match next-hop address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ip_next_hop_prefix_list_cmd_vtysh,
	"match ip next-hop prefix-list PREFIXLIST4_NAME$name",
	"Match values from routing table\n"
	"IP information\n"
	"Match next-hop address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ip_next_hop_type_cmd_vtysh,
	"match ip next-hop type <blackhole>$type",
	"Match values from routing table\n"
	"IP information\n"
	"Match next-hop address of route\n"
	"Match entries by type\n"
	"Blackhole\n")

DEFSH (VTYSH_MGMTD, match_ip_nexthop_prefix_len_cmd_vtysh,
	"match ip next-hop prefix-len (0-32)$length",
	"Match values from routing table\n"
	"IP information\n"
	"Match prefixlen of nexthop IP address\n"
	"Match prefixlen of given nexthop\n"
	"Prefix length\n")

DEFSH (VTYSH_BGPD, match_ip_route_source_cmd_vtysh,
	"match ip route-source ACCESSLIST4_NAME",
	"Match values from routing table\n"
	"IP information\n"
	"Match advertising source address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_BGPD, match_ip_route_source_prefix_list_cmd_vtysh,
	"match ip route-source prefix-list PREFIXLIST_NAME",
	"Match values from routing table\n"
	"IP information\n"
	"Match advertising source address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_BGPD, match_ipv4_next_hop_cmd_vtysh,
	"match ip next-hop address A.B.C.D",
	"Match values from routing table\n"
	"IP information\n"
	"Match IP next-hop address of route\n"
	"IP address\n"
	"IP address of next-hop\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ipv6_address_cmd_vtysh,
	"match ipv6 address ACCESSLIST6_NAME$name",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 address of route\n"
	"IPv6 access-list name\n")

DEFSH (VTYSH_MGMTD, match_ipv6_address_prefix_len_cmd_vtysh,
	"match ipv6 address prefix-len (0-128)$length",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match prefix length of IPv6 address\n"
	"Match prefix length of IPv6 address\n"
	"Prefix length\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ipv6_address_prefix_list_cmd_vtysh,
	"match ipv6 address prefix-list PREFIXLIST6_NAME$name",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_BGPD, match_ipv6_next_hop_address_cmd_vtysh,
	"match ipv6 next-hop address X:X::X:X",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ipv6_next_hop_cmd_vtysh,
	"match ipv6 next-hop ACCESSLIST6_NAME",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 access-list name\n")

DEFSH_HIDDEN (VTYSH_BGPD, match_ipv6_next_hop_old_cmd_vtysh,
	"match ipv6 next-hop X:X::X:X",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ipv6_next_hop_prefix_list_cmd_vtysh,
	"match ipv6 next-hop prefix-list PREFIXLIST_NAME",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"Match entries by prefix-list\n"
	"IPv6 prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_ipv6_next_hop_type_cmd_vtysh,
	"match ipv6 next-hop type <blackhole>$type",
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match next-hop address of route\n"
	"Match entries by type\n"
	"Blackhole\n")

DEFSH (VTYSH_BGPD, match_lcommunity_cmd_vtysh,
	"match large-community <(1-99)|(100-500)|LCOMMUNITY_LIST_NAME> [<exact-match$exact|any$any>]",
	"Match values from routing table\n"
	"Match BGP large community list\n"
	"Large Community-list number (standard)\n"
	"Large Community-list number (expanded)\n"
	"Large Community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, match_local_pref_cmd_vtysh,
	"match local-preference (0-4294967295)",
	"Match values from routing table\n"
	"Match local-preference of route\n"
	"Metric value\n")

DEFSH (VTYSH_BGPD, match_mac_address_cmd_vtysh,
	"match mac address ACCESSLIST_MAC_NAME",
	"Match values from routing table\n"
	"mac address\n"
	"Match address of route\n"
	"MAC Access-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_metric_cmd_vtysh,
	"match metric (0-4294967295)$metric",
	"Match values from routing table\n"
	"Match metric of route\n"
	"Metric value\n")

DEFSH (VTYSH_BGPD, match_origin_cmd_vtysh,
	"match origin <egp|igp|incomplete>",
	"Match values from routing table\n"
	"BGP origin code\n"
	"remote EGP\n"
	"local IGP\n"
	"unknown heritage\n")

DEFSH (VTYSH_BGPD, match_peer_cmd_vtysh,
	"match peer <A.B.C.D$addrv4|X:X::X:X$addrv6|WORD$intf>",
	"Match values from routing table\n"
	"Match peer address\n"
	"IP address of peer\n"
	"IPv6 address of peer\n"
	"Interface name of peer or peer group name\n")

DEFSH (VTYSH_BGPD, match_peer_local_cmd_vtysh,
	"match peer local",
	"Match values from routing table\n"
	"Match peer address\n"
	"Static or Redistributed routes\n")

DEFSH (VTYSH_BGPD, match_probability_cmd_vtysh,
	"match probability (0-100)",
	"Match values from routing table\n"
	"Match portion of routes defined by percentage value\n"
	"Percentage of routes\n")

DEFSH (VTYSH_BGPD, match_rpki_cmd_vtysh,
	"match rpki <valid|invalid|notfound>",
	"Match values from routing table\n"
	"Control rpki specific settings\n"
	"Valid prefix\n"
	"Invalid prefix\n"
	"Prefix not found\n")

DEFSH (VTYSH_BGPD, match_rpki_extcommunity_cmd_vtysh,
	"[no$no] match rpki-extcommunity <valid|invalid|notfound>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"BGP RPKI (Origin Validation State) extended community attribute\n"
	"Valid prefix\n"
	"Invalid prefix\n"
	"Prefix not found\n")

DEFSH (VTYSH_BGPD, match_script_cmd_vtysh,
	"[no] match script WORD",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Execute script to determine match\n"
	"The script name to run, without .lua; e.g. 'myroutemap' to run myroutemap.lua\n")

DEFSH (VTYSH_MGMTD, match_source_instance_cmd_vtysh,
	"match source-instance (0-255)$instance",
	"Match values from routing table\n"
	"Match the protocol's instance number\n"
	"The instance number\n")

DEFSH (VTYSH_BGPD|VTYSH_MGMTD, match_source_protocol_cmd_vtysh,
	"match source-protocol <kernel|connected|local|static|rip|ripng|ospf|ospf6|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>$proto",
	"Match values from routing table\n"
	"Match protocol via which the route was learnt\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_BGPD, match_src_peer_cmd_vtysh,
	"match src-peer <A.B.C.D$addrv4|X:X::X:X$addrv6|WORD$intf>",
	"Match values from routing table\n"
	"Match source peer address\n"
	"IP address of peer\n"
	"IPv6 address of peer\n"
	"Interface name of peer or peer group name\n")

DEFSH (VTYSH_RMAP_CONFIG, match_tag_cmd_vtysh,
	"match tag <untagged$untagged|(1-4294967295)$tagged>",
	"Match values from routing table\n"
	"Match tag of route\n"
	"Untagged route\n"
	"Tag value\n")

DEFSH (VTYSH_BGPD, match_vrl_source_vrf_cmd_vtysh,
	"match source-vrf NAME$vrf_name",
	"Match values from routing table\n"
	"source vrf\n"
	"The VRF name\n")

DEFSH (VTYSH_ISISD, max_lsp_lifetime_cmd_vtysh,
	"max-lsp-lifetime [level-1|level-2]$level (350-65535)$val",
	"Maximum LSP lifetime\n"
	"Maximum LSP lifetime for Level 1 only\n"
	"Maximum LSP lifetime for Level 2 only\n"
	"LSP lifetime in seconds\n")

DEFSH (VTYSH_ISISD, metric_style_cmd_vtysh,
	"metric-style <narrow|transition|wide>$style",
	"Use old-style (ISO 10589) or new-style packet formats\n"
	"Use old style of TLVs with narrow metric\n"
	"Send and accept both styles of TLVs during transition\n"
	"Use new style of TLVs to carry wider metric\n")

DEFSH (VTYSH_ISISD, metric_type_cmd_vtysh,
	"[no] metric-type [igp$igp|te$te|delay$delay]",
	"Negate a command or set its defaults\n"
	"Metric-type used by flex-algo calculation\n"
	"Use IGP metric (default)\n"
	"Use Delay as metric\n"
	"Use Traffic Engineering metric\n")

DEFSH (VTYSH_MGMTD, mgmt_commit_cmd_vtysh,
	"mgmt commit <check|apply|abort>$type",
	"Management Daemon (MGMTD) information\n"
	"Commit action\n"
	"Validate the set of config commands\n"
	"Validate and apply the set of config commands\n"
	"Abort and drop the set of config commands recently added\n")

DEFSH (VTYSH_MGMTD, mgmt_create_config_data_cmd_vtysh,
	"mgmt create-config WORD$path VALUE",
	"Management Daemon (MGMTD) information\n"
	"Create configuration data\n"
	"XPath expression specifying the YANG data path\n"
	"Value of the data to create\n")

DEFSH (VTYSH_MGMTD, mgmt_delete_config_data_cmd_vtysh,
	"mgmt delete-config WORD$path",
	"Management Daemon (MGMTD) information\n"
	"Delete configuration data\n"
	"XPath expression specifying the YANG data path\n")

DEFSH (VTYSH_MGMTD, mgmt_edit_cmd_vtysh,
	"mgmt edit {create|delete|merge|replace|remove}$op XPATH [json|xml]$fmt [lock$lock] [commit$commit] [DATA]",
	"Management Daemon (MGMTD) information\n"
	"Edit configuration data\n"
	"Create data\n"
	"Delete data\n"
	"Merge data\n"
	"Replace data\n"
	"Remove data\n"
	"XPath expression specifying the YANG data path\n"
	"JSON input format (default)\n"
	"XML input format\n"
	"Lock the datastores automatically\n"
	"Commit the changes automatically\n"
	"Data tree\n")

DEFSH (VTYSH_MGMTD, mgmt_load_config_cmd_vtysh,
	"mgmt load-config WORD$filepath <merge|replace>$type",
	"Management Daemon (MGMTD) information\n"
	"Load configuration onto Candidate Datastore\n"
	"Full path of the file\n"
	"Merge configuration with contents of Candidate Datastore\n"
	"Replace the existing contents of Candidate datastore\n")

DEFSH_HIDDEN (VTYSH_MGMTD, mgmt_performance_measurement_cmd_vtysh,
	"[no] mgmt performance-measurement",
	"Negate a command or set its defaults\n"
	"Management Daemon (MGMTD) information\n"
	"Enable performance measurement\n")

DEFSH (VTYSH_MGMTD, mgmt_remove_config_data_cmd_vtysh,
	"mgmt remove-config WORD$path",
	"Management Daemon (MGMTD) information\n"
	"Remove configuration data\n"
	"XPath expression specifying the YANG data path\n")

DEFSH (VTYSH_MGMTD, mgmt_replace_config_data_cmd_vtysh,
	"mgmt replace-config WORD$path VALUE",
	"Management Daemon (MGMTD) information\n"
	"Replace configuration data\n"
	"XPath expression specifying the YANG data path\n"
	"Value of the data to set\n")

DEFSH (VTYSH_MGMTD, mgmt_reset_performance_stats_cmd_vtysh,
	"mgmt reset-statistics",
	"Management Daemon (MGMTD) information\n"
	"Reset the Performance measurement statistics\n")

DEFSH (VTYSH_MGMTD, mgmt_rollback_cmd_vtysh,
	"mgmt rollback <commit-id WORD$commit | last [(1-10)]$last>",
	"Management Daemon (MGMTD) information\n"
	"Rollback commits\n"
	"Rollback to commit ID\n"
	"Commit-ID\n"
	"Rollbak n commits\n"
	"Number of commits\n")

DEFSH (VTYSH_MGMTD, mgmt_rpc_cmd_vtysh,
	"mgmt rpc XPATH [json|xml]$fmt [DATA]",
	"Management Daemon (MGMTD) information\n"
	"Invoke RPC\n"
	"XPath expression specifying the YANG data path\n"
	"JSON input format (default)\n"
	"XML input format\n"
	"Input data tree\n")

DEFSH (VTYSH_MGMTD, mgmt_save_config_cmd_vtysh,
	"mgmt save-config <candidate|running>$dsname WORD$filepath",
	"Management Daemon (MGMTD) information\n"
	"Save configuration from datastore\n"
	"Candidate datastore\n"
	"Running datastore\n"
	"Full path of the file\n")

DEFSH (VTYSH_MGMTD, mgmt_set_config_data_cmd_vtysh,
	"mgmt set-config WORD$path VALUE",
	"Management Daemon (MGMTD) information\n"
	"Set configuration data\n"
	"XPath expression specifying the YANG data path\n"
	"Value of the data to set\n")

DEFSH (VTYSH_BGPD, mpls_bgp_forwarding_cmd_vtysh,
	"[no$no] mpls bgp forwarding",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"BGP information\n"
	"Enable MPLS forwarding for eBGP directly connected peers\n")

DEFSH (VTYSH_BGPD, mpls_bgp_l3vpn_multi_domain_switching_cmd_vtysh,
	"[no$no] mpls bgp l3vpn-multi-domain-switching",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"BGP information\n"
	"Bind a local MPLS label to incoming L3VPN updates\n")

DEFSH (VTYSH_MGMTD, mpls_cmd_vtysh,
	"[no] mpls <enable$on|disable$off>",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Set mpls to be on for the interface\n"
	"Set mpls to be off for the interface\n")

DEFSH (VTYSH_MGMTD, mpls_fec_nexthop_resolution_cmd_vtysh,
	"[no$no] mpls fec nexthop-resolution",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"MPLS FEC table\n"
	"Authorise nexthop resolution over all labeled routes.\n")

DEFSH (VTYSH_ZEBRA, mpls_label_bind_cmd_vtysh,
	"mpls label bind <A.B.C.D/M|X:X::X:X/M> <(16-1048575)|implicit-null|explicit-null>",
	"MPLS information\n"
	"Label configuration\n"
	"Establish FEC to label binding\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"MPLS Label to bind\n"
	"Use Implicit-Null Label\n"
	"Use Explicit-Null Label\n")

DEFSH (VTYSH_ZEBRA, mpls_label_dynamic_block_cmd_vtysh,
	"[no$no] mpls label dynamic-block [(16-1048575)$start (16-1048575)$end]",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Label configuration\n"
	"Configure dynamic label block\n"
	"Start label\n"
	"End label\n")

DEFSH (VTYSH_ZEBRA, mpls_label_global_block_cmd_vtysh,
	"mpls label global-block (16-1048575) (16-1048575)",
	"MPLS information\n"
	"Label configuration\n"
	"Configure global label block\n"
	"Start label\n"
	"End label\n")

DEFSH (VTYSH_OSPFD, mpls_ldp_sync_cmd_vtysh,
	"ip ospf mpls ldp-sync",
	"IP information\n"
	"OSPF interface commands\n"
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n")

DEFSH (VTYSH_OSPFD, mpls_ldp_sync_holddown_cmd_vtysh,
	"ip ospf mpls ldp-sync holddown (0-10000)",
	"IP information\n"
	"OSPF interface commands\n"
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n"
	"Time to wait for LDP-SYNC to occur before restoring interface cost\n"
	"Time in seconds\n")

DEFSH (VTYSH_ZEBRA, mpls_transit_lsp_cmd_vtysh,
	"mpls lsp (16-1048575) <A.B.C.D|X:X::X:X> <(16-1048575)|explicit-null|implicit-null>",
	"MPLS information\n"
	"Establish label switched path\n"
	"Incoming MPLS label\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"Outgoing MPLS label\n"
	"Use Explicit-Null label\n"
	"Use Implicit-Null label\n")

DEFSH (VTYSH_PIMD, msdp_log_neighbor_changes_cmd_vtysh,
	"[no] msdp log neighbor-events",
	"Negate a command or set its defaults\n"
	"MSDP information\n"
	"MSDP log messages\n"
	"MSDP log neighbor event messages\n")

DEFSH (VTYSH_PIMD, msdp_log_sa_changes_cmd_vtysh,
	"[no] msdp log sa-events",
	"Negate a command or set its defaults\n"
	"MSDP information\n"
	"MSDP log messages\n"
	"MSDP log SA event messages\n")

DEFSH (VTYSH_PIMD, msdp_originator_id_cmd_vtysh,
	"[no] msdp originator-id ![A.B.C.D$originator_id]",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP RP originator\n"
	"MSDP RP originator identifier\n")

DEFSH (VTYSH_PIMD, msdp_peer_md5_cmd_vtysh,
	"msdp peer A.B.C.D$peer password WORD$psk",
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"MSDP Peer address\n"
	"Use MD5 authentication\n"
	"MD5 pre shared key\n")

DEFSH (VTYSH_PIMD, msdp_peer_sa_filter_cmd_vtysh,
	"msdp peer A.B.C.D$peer sa-filter ACL_NAME$acl_name <in|out>$dir",
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"MSDP Peer address\n"
	"SA access-list filter\n"
	"SA access-list name\n"
	"Filter incoming SAs\n"
	"Filter outgoing SAs\n")

DEFSH (VTYSH_PIMD, msdp_peer_sa_limit_cmd_vtysh,
	"[no] msdp peer A.B.C.D$peer sa-limit ![(1-4294967294)$sa_limit]",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"MSDP peer address\n"
	"Limit amount of SA\n"
	"Maximum number of SA\n")

DEFSH (VTYSH_PIMD, msdp_shutdown_cmd_vtysh,
	"[no] msdp shutdown",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Shutdown MSDP operation\n")

DEFSH_HIDDEN (VTYSH_MGMTD, multicast_cmd_vtysh,
	"[no] multicast",
	"Negate a command or set its defaults\n"
	"Set multicast flag to interface\n")

DEFSH (VTYSH_MGMTD, multicast_new_cmd_vtysh,
	"[no] multicast <enable$on|disable$off>",
	"Negate a command or set its defaults\n"
	"Control multicast flag on interface\n"
	"Set multicast flag on interface\n"
	"Unset multicast flag on interface\n")

DEFSH (VTYSH_BGPD, neighbor_accept_own_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor accept-own",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable handling of self-originated VPN routes containing ACCEPT_OWN community\n")

DEFSH (VTYSH_BGPD, neighbor_activate_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> activate",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable the Address Family for this Neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_activate_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> activate",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable the Address Family for this Neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_addpath_paths_limit_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor addpath-rx-paths-limit (1-65535)$paths_limit",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Paths Limit for Addpath to receive from the peer\n"
	"Maximum number of paths\n")

DEFSH (VTYSH_BGPD, neighbor_addpath_tx_all_paths_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-all-paths",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise all paths to a neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_addpath_tx_all_paths_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-all-paths",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise all paths to a neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor addpath-tx-best-selected (1-6)$paths",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise best selected paths to a neighbor\n"
	"The number of best paths\n")

DEFSH (VTYSH_BGPD, neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-bestpath-per-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise the bestpath per each neighboring AS\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_addpath_tx_bestpath_per_as_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-bestpath-per-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise the bestpath per each neighboring AS\n")

DEFSH (VTYSH_BGPD, neighbor_advertise_interval_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> advertisement-interval (0-600)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Minimum interval between sending BGP routing updates\n"
	"time in seconds\n")

DEFSH (VTYSH_BGPD, neighbor_advertise_map_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor advertise-map RMAP_NAME$advertise_str <exist-map|non-exist-map>$exist RMAP_NAME$condition_str",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to conditionally advertise routes\n"
	"Name of advertise map\n"
	"Advertise routes only if prefixes in exist-map are installed in BGP table\n"
	"Advertise routes only if prefixes in non-exist-map are not installed in BGP table\n"
	"Name of the exist or non exist map\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_advertise_map_hidden_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor advertise-map RMAP_NAME$advertise_str <exist-map|non-exist-map>$exist RMAP_NAME$condition_str",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to conditionally advertise routes\n"
	"Name of advertise map\n"
	"Advertise routes only if prefixes in exist-map are installed in BGP table\n"
	"Advertise routes only if prefixes in non-exist-map are not installed in BGP table\n"
	"Name of the exist or non exist map\n")

DEFSH (VTYSH_BGPD, neighbor_aigp_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor aigp",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable send and receive of the AIGP attribute per neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_allowas_in_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> allowas-in [<(1-10)|origin>]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Accept as-path with my AS present in it\n"
	"Number of occurrences of AS number\n"
	"Only accept my AS in the as-path if the route was originated in my AS\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_allowas_in_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> allowas-in [<(1-10)|origin>]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Accept as-path with my AS present in it\n"
	"Number of occurrences of AS number\n"
	"Only accept my AS in the as-path if the route was originated in my AS\n")

DEFSH (VTYSH_BGPD, neighbor_as_override_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> as-override",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override ASNs in outbound updates if aspath equals remote-as\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_as_override_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> as-override",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override ASNs in outbound updates if aspath equals remote-as\n")

DEFSH (VTYSH_BGPD, neighbor_aspath_loop_detection_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor sender-as-path-loop-detection",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Detect AS loops before sending to neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_attr_unchanged_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> attribute-unchanged [{as-path|next-hop|med}]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP attribute is propagated unchanged to this neighbor\n"
	"As-path attribute\n"
	"Nexthop attribute\n"
	"Med attribute\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_attr_unchanged_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> attribute-unchanged [{as-path|next-hop|med}]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP attribute is propagated unchanged to this neighbor\n"
	"As-path attribute\n"
	"Nexthop attribute\n"
	"Med attribute\n")

DEFSH (VTYSH_BGPD, neighbor_bfd_check_controlplane_failure_cmd_vtysh,
	"[no] neighbor <A.B.C.D|X:X::X:X|WORD> bfd check-control-plane-failure",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BFD support\n"
	"Link dataplane status with BGP controlplane\n")

DEFSH (VTYSH_BGPD, neighbor_bfd_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> bfd",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enables BFD support\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_bfd_param_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> bfd (2-255) (50-60000) (50-60000)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enables BFD support\n"
	"Detect Multiplier\n"
	"Required min receive interval\n"
	"Desired min transmit interval\n")

DEFSH (VTYSH_BGPD, neighbor_bfd_profile_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> bfd profile BFDPROF",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BFD integration\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH (VTYSH_BGPD, neighbor_bfd_strict_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor bfd strict",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BFD support\n"
	"Strict mode\n")

DEFSH (VTYSH_BGPD, neighbor_bfd_strict_hold_time_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor bfd strict hold-time ![(1-4294967295)$hold_time]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BFD support\n"
	"Strict mode\n"
	"BFD Hold time in seconds\n"
	"Seconds to wait before declaring BFD session down\n")

DEFSH (VTYSH_BGPD, neighbor_capability_dynamic_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> capability dynamic",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise dynamic capability to this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_capability_enhe_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> capability extended-nexthop",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise extended next-hop capability to the peer\n")

DEFSH (VTYSH_BGPD, neighbor_capability_fqdn_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor capability fqdn",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise fqdn capability to the peer\n")

DEFSH (VTYSH_BGPD, neighbor_capability_link_local_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor capability link-local",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise Link-Local Next Hop capability to the peer\n")

DEFSH (VTYSH_BGPD, neighbor_capability_orf_prefix_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> capability orf prefix-list <both|send|receive>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise ORF capability to the peer\n"
	"Advertise prefixlist ORF capability to this neighbor\n"
	"Capability to SEND and RECEIVE the ORF to/from this neighbor\n"
	"Capability to RECEIVE the ORF from this neighbor\n"
	"Capability to SEND the ORF to this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_capability_orf_prefix_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> capability orf prefix-list <both|send|receive>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise ORF capability to the peer\n"
	"Advertise prefixlist ORF capability to this neighbor\n"
	"Capability to SEND and RECEIVE the ORF to/from this neighbor\n"
	"Capability to RECEIVE the ORF from this neighbor\n"
	"Capability to SEND the ORF to this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_capability_software_version_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor capability software-version",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise Software Version capability to the peer\n")

DEFSH (VTYSH_BGPD, neighbor_damp_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor dampening [(1-45)$half [(1-20000)$reuse (1-20000)$suppress (1-255)$max]]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable neighbor route-flap dampening\n"
	"Half-life time for the penalty\n"
	"Value to start reusing a route\n"
	"Value to start suppressing a route\n"
	"Maximum duration to suppress a stable route\n")

DEFSH (VTYSH_BGPD, neighbor_default_originate_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> default-originate",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_default_originate_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> default-originate",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_default_originate_rmap_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> default-originate route-map RMAP_NAME",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n"
	"Route-map to specify criteria to originate default\n"
	"route-map name\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_default_originate_rmap_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> default-originate route-map RMAP_NAME",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n"
	"Route-map to specify criteria to originate default\n"
	"route-map name\n")

DEFSH (VTYSH_BGPD, neighbor_description_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> description LINE...",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor specific description\n"
	"Up to 80 characters describing this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_disable_addpath_rx_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> disable-addpath-rx",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Do not accept additional paths\n")

DEFSH (VTYSH_BGPD, neighbor_disable_connected_check_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> <disable-connected-check|enforce-multihop>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"one-hop away EBGP peer using loopback address\n"
	"Enforce EBGP neighbors perform multihop\n")

DEFSH (VTYSH_BGPD, neighbor_disable_link_bw_encoding_ieee_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> disable-link-bw-encoding-ieee",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable IEEE floating-point encoding for extended community bandwidth\n")

DEFSH (VTYSH_BGPD, neighbor_distribute_list_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> distribute-list ACCESSLIST_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"IP Access-list name\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_distribute_list_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> distribute-list ACCESSLIST_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"IP Access-list name\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH (VTYSH_BGPD, neighbor_dont_capability_negotiate_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> dont-capability-negotiate",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Do not perform capability negotiation\n")

DEFSH (VTYSH_BGPD, neighbor_ebgp_multihop_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> ebgp-multihop",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Allow EBGP neighbors not on directly connected networks\n")

DEFSH (VTYSH_BGPD, neighbor_ebgp_multihop_ttl_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> ebgp-multihop (1-255)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Allow EBGP neighbors not on directly connected networks\n"
	"maximum hop count\n")

DEFSH (VTYSH_BGPD, neighbor_ecommunity_rpki_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor send-community extended rpki",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n"
	"Send Extended Community attributes\n"
	"Send RPKI Extended Community attributes\n")

DEFSH (VTYSH_BGPD, neighbor_encapsulation_srv6_or_mpls_cmd_vtysh,
	"[no] neighbor <A.B.C.D|X:X::X:X|WORD>$peer_str <encapsulation-srv6$srv6|encapsulation-mpls$mpls>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Distribute L3VPN updates with SRv6 prefix SID\n"
	"Distribute L3VPN updates with MPLS prefix SID\n")

DEFSH (VTYSH_BGPD, neighbor_enforce_first_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> enforce-first-as",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enforce the first AS for EBGP routes\n")

DEFSH (VTYSH_BGPD, neighbor_extended_link_bw_cmd_vtysh,
	"[no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor extended-link-bandwidth",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Extended (64-bit) version of encoding for Link-Bandwidth\n")

DEFSH (VTYSH_BGPD, neighbor_extended_optional_parameters_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> extended-optional-parameters",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Force the extended optional parameters format for OPEN messages\n")

DEFSH (VTYSH_BGPD, neighbor_filter_list_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> filter-list AS_PATH_FILTER_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Establish BGP filters\n"
	"AS path access-list name\n"
	"Filter incoming routes\n"
	"Filter outgoing routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_filter_list_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> filter-list AS_PATH_FILTER_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Establish BGP filters\n"
	"AS path access-list name\n"
	"Filter incoming routes\n"
	"Filter outgoing routes\n")

DEFSH (VTYSH_BGPD, neighbor_graceful_shutdown_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor_str graceful-shutdown",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Graceful shutdown\n")

DEFSH (VTYSH_BGPD, neighbor_interface_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X> interface WORD",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"IPv6 address\n"
	"Interface\n"
	"Interface name\n")

DEFSH (VTYSH_BGPD, neighbor_interface_config_cmd_vtysh,
	"neighbor WORD interface [peer-group PGNAME]",
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Enable BGP on interface\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, neighbor_interface_config_remote_as_cmd_vtysh,
	"neighbor WORD interface remote-as <ASNUM|internal|external|auto>",
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Enable BGP on interface\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, neighbor_interface_config_v6only_cmd_vtysh,
	"neighbor WORD interface v6only [peer-group PGNAME]",
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Enable BGP on interface\n"
	"Enable BGP with v6 link-local only\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, neighbor_interface_v6only_config_remote_as_cmd_vtysh,
	"neighbor WORD interface v6only remote-as <ASNUM|internal|external|auto>",
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Enable BGP with v6 link-local only\n"
	"Enable BGP on interface\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, neighbor_ip_transparent_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor ip-transparent",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable IP_TRANSPARENT on the BGP TCP socket\n")

DEFSH (VTYSH_BGPD, neighbor_local_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> local-as ASNUM",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a local-as number\n"
	"AS number expressed in dotted or plain format used as local AS\n")

DEFSH (VTYSH_BGPD, neighbor_local_as_no_prepend_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> local-as ASNUM no-prepend",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a local-as number\n"
	"AS number expressed in dotted or plain format used as local AS\n"
	"Do not prepend local-as to updates from ebgp peers\n")

DEFSH (VTYSH_BGPD, neighbor_local_as_no_prepend_replace_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> local-as ASNUM no-prepend replace-as [dual-as$dual_as]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a local-as number\n"
	"AS number expressed in dotted or plain format used as local AS\n"
	"Do not prepend local-as to updates from ebgp peers\n"
	"Do not prepend local-as to updates from ibgp peers\n"
	"Allow peering with a global AS number or local-as number\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_out_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix-out (1-4294967295)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to be sent to this peer\n"
	"Maximum no. of prefix limit\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_restart_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) restart (1-65535) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_restart_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) restart (1-65535) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_threshold_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_threshold_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_threshold_restart_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) restart (1-65535) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_threshold_restart_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) restart (1-65535) [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_threshold_warning_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) warning-only [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_threshold_warning_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) (1-100) warning-only [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_maximum_prefix_warning_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) warning-only [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_maximum_prefix_warning_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix (1-4294967295) warning-only [force]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefix accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, neighbor_nexthop_local_unchanged_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> nexthop-local unchanged",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure treatment of outgoing link-local nexthop attribute\n"
	"Leave link-local nexthop unchanged for this peer\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_nexthop_self_all_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self all",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH (VTYSH_BGPD, neighbor_nexthop_self_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_nexthop_self_force_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self force",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_nexthop_self_force_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self force",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_nexthop_self_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_nhc_attribute_cmd_vtysh,
	"[no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor send-nexthop-characteristics",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send BGP Next Hop Dependent Characteristics Attribute\n")

DEFSH (VTYSH_BGPD, neighbor_oad_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor oad",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set peering session type to EBGP-OAD\n")

DEFSH (VTYSH_BGPD, neighbor_override_capability_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> override-capability",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override capability negotiation result\n")

DEFSH (VTYSH_BGPD, neighbor_passive_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> passive",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Don't send open messages to this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_password_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> password LINE",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set a password\n"
	"The password\n")

DEFSH (VTYSH_BGPD, neighbor_path_attribute_discard_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor path-attribute discard (1-255)...",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Manipulate path attributes from incoming UPDATE messages\n"
	"Drop specified attributes from incoming UPDATE messages\n"
	"Attribute number\n")

DEFSH (VTYSH_BGPD, neighbor_path_attribute_treat_as_withdraw_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor path-attribute treat-as-withdraw (1-255)...",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Manipulate path attributes from incoming UPDATE messages\n"
	"Treat-as-withdraw any incoming BGP UPDATE messages that contain the specified attribute\n"
	"Attribute number\n")

DEFSH (VTYSH_BGPD, neighbor_peer_group_cmd_vtysh,
	"neighbor WORD peer-group",
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Configure peer-group\n")

DEFSH (VTYSH_BGPD, neighbor_port_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> port (0-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor's BGP port\n"
	"TCP port number\n")

DEFSH (VTYSH_BGPD, neighbor_prefix_list_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> prefix-list WORD <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"Name of a prefix list\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_prefix_list_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> prefix-list WORD <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"Name of a prefix list\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH (VTYSH_BGPD, neighbor_remote_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remote-as <ASNUM|internal|external|auto>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, neighbor_remove_private_as_all_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_remove_private_as_all_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n")

DEFSH (VTYSH_BGPD, neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all replace-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_remove_private_as_all_replace_as_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all replace-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH (VTYSH_BGPD, neighbor_remove_private_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_remove_private_as_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n")

DEFSH (VTYSH_BGPD, neighbor_remove_private_as_replace_as_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS replace-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_remove_private_as_replace_as_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS replace-AS",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH (VTYSH_BGPD, neighbor_role_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor local-role <provider|rs-server|rs-client|customer|peer>$role",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set session role\n"
	"Providing transit\n"
	"Route server\n"
	"RS client\n"
	"Using transit\n"
	"Public/private peering\n")

DEFSH (VTYSH_BGPD, neighbor_role_strict_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor local-role <provider|rs-server|rs-client|customer|peer>$role strict-mode",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set session role\n"
	"Providing transit\n"
	"Route server\n"
	"RS client\n"
	"Using transit\n"
	"Public/private peering\n"
	"Use additional restriction on peer\n")

DEFSH (VTYSH_BGPD, neighbor_route_map_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-map RMAP_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Apply route map to neighbor\n"
	"Name of route map\n"
	"Apply map to incoming routes\n"
	"Apply map to outbound routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_route_map_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-map RMAP_NAME <in|out>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Apply route map to neighbor\n"
	"Name of route map\n"
	"Apply map to incoming routes\n"
	"Apply map to outbound routes\n")

DEFSH (VTYSH_BGPD, neighbor_route_reflector_client_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-reflector-client",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Reflector client\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_route_reflector_client_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-reflector-client",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Reflector client\n")

DEFSH (VTYSH_BGPD, neighbor_route_server_client_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-server-client",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Server client\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_route_server_client_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> route-server-client",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Server client\n")

DEFSH (VTYSH_BGPD, neighbor_rpki_strict_cmd_vtysh,
	"[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor rpki strict",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"RPKI configuration\n"
	"Strict mode\n")

DEFSH (VTYSH_BGPD, neighbor_send_community_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> send-community",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_send_community_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> send-community",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_send_community_type_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> send-community <both|all|extended|standard|large>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n"
	"Send Standard and Extended Community attributes\n"
	"Send Standard, Large and Extended Community attributes\n"
	"Send Extended Community attributes\n"
	"Send Standard Community attributes\n"
	"Send Large Community attributes\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_send_community_type_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> send-community <both|all|extended|standard|large>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n"
	"Send Standard and Extended Community attributes\n"
	"Send Standard, Large and Extended Community attributes\n"
	"Send Extended Community attributes\n"
	"Send Standard Community attributes\n"
	"Send Large Community attributes\n")

DEFSH (VTYSH_BGPD, neighbor_set_peer_group_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> peer-group PGNAME",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_set_peer_group_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> peer-group PGNAME",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, neighbor_shutdown_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> shutdown",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_shutdown_msg_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> shutdown message MSG...",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n"
	"Add a shutdown message (RFC 8203)\n"
	"Shutdown message\n")

DEFSH (VTYSH_BGPD, neighbor_shutdown_rtt_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> shutdown rtt (1-65535) [count (1-255)]",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n"
	"Shutdown if round-trip-time is higher than expected\n"
	"Round-trip-time in milliseconds\n"
	"Specify the number of keepalives before shutdown\n"
	"The number of keepalives with higher RTT to shutdown\n")

DEFSH (VTYSH_BGPD, neighbor_soft_reconfiguration_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> soft-reconfiguration inbound",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Per neighbor soft reconfiguration\n"
	"Allow inbound soft reconfiguration for this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_soft_reconfiguration_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> soft-reconfiguration inbound",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Per neighbor soft reconfiguration\n"
	"Allow inbound soft reconfiguration for this neighbor\n")

DEFSH (VTYSH_BGPD, neighbor_solo_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> solo",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Solo peer - part of its own update group\n")

DEFSH (VTYSH_BGPD, neighbor_soo_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor soo ASN:NN_OR_IP-ADDRESS:NN$soo",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set the Site-of-Origin (SoO) extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, neighbor_strict_capability_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> strict-capability-match",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Strict capability negotiation match\n")

DEFSH (VTYSH_BGPD, neighbor_tcp_mss_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> tcp-mss (1-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"TCP max segment size\n"
	"TCP MSS value\n")

DEFSH (VTYSH_BGPD, neighbor_timers_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> timers (0-65535) (0-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"Keepalive interval\n"
	"Holdtime\n")

DEFSH (VTYSH_BGPD, neighbor_timers_connect_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> timers connect (1-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"BGP connect timer\n"
	"Connect timer\n")

DEFSH (VTYSH_BGPD, neighbor_timers_delayopen_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor timers delayopen (1-240)$interval",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"RFC 4271 DelayOpenTimer\n"
	"DelayOpenTime timer interval\n")

DEFSH (VTYSH_BGPD, neighbor_ttl_security_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> ttl-security hops (1-254)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP ttl-security parameters\n"
	"Specify the maximum number of hops to the BGP peer\n"
	"Number of hops to BGP peer\n")

DEFSH (VTYSH_BGPD, neighbor_unsuppress_map_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> unsuppress-map WORD",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to selectively unsuppress suppressed routes\n"
	"Name of route map\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_unsuppress_map_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> unsuppress-map WORD",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to selectively unsuppress suppressed routes\n"
	"Name of route map\n")

DEFSH (VTYSH_BGPD, neighbor_update_source_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> update-source <A.B.C.D|X:X::X:X|WORD>",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Source of routing updates\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Interface name (requires zebra to be running)\n")

DEFSH (VTYSH_BGPD, neighbor_weight_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> weight (0-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set default weight for routes from this neighbor\n"
	"default weight\n")

DEFSH_HIDDEN (VTYSH_BGPD, neighbor_weight_hidden_cmd_vtysh,
	"neighbor <A.B.C.D|X:X::X:X|WORD> weight (0-65535)",
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set default weight for routes from this neighbor\n"
	"default weight\n")

DEFSH (VTYSH_ISISD, net_cmd_vtysh,
	"[no] net WORD",
	"Remove an existing Network Entity Title for this process\n"
	"A Network Entity Title for this process (OSI only)\n"
	"XX.XXXX. ... .XXX.XX  Network entity title (NET)\n")

DEFSH (VTYSH_NH_GROUP, nexthop_group_backup_cmd_vtysh,
	"backup-group WORD$name",
	"Specify a group name containing backup nexthops\n"
	"The name of the backup group\n")

DEFSH (VTYSH_NH_GROUP, nexthop_group_resilience_cmd_vtysh,
	"resilient buckets (1-256) idle-timer (1-4294967295) unbalanced-timer (1-4294967295)",
	"A resilient Nexthop Group\n"
	"Buckets in the Hash for this Group\n"
	"Number of buckets\n"
	"The Idle timer for this Resilient Nexthop Group in seconds\n"
	"Number of seconds of Idle time\n"
	"The length of time that the Nexthop Group can be unbalanced\n"
	"Number of seconds of Unbalanced time\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, nexthop_group_use_enable_cmd_vtysh,
	"[no] zebra nexthop kernel enable",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Nexthop configuration \n"
	"Configure use of kernel nexthops\n"
	"Enable kernel nexthops\n")

DEFSH (VTYSH_NHRPD, nhrp_event_socket_cmd_vtysh,
	"nhrp event socket SOCKET",
	"Next Hop Resolution Protocol functions\n"
	"Event Manager commands\n"
	"Event Manager unix socket path\n"
	"Unix path for the socket\n")

DEFSH (VTYSH_NHRPD, nhrp_multicast_nflog_group_cmd_vtysh,
	"nhrp multicast-nflog-group (1-65535)",
	"Next Hop Resolution Protocol functions\n"
	"Specify NFLOG group number for Multicast Packets\n"
	"NFLOG group number\n")

DEFSH (VTYSH_NHRPD, nhrp_nflog_group_cmd_vtysh,
	"nhrp nflog-group (1-65535)",
	"Next Hop Resolution Protocol functions\n"
	"Specify NFLOG group number\n"
	"NFLOG group number\n")

DEFSH (VTYSH_KEYS, no_accept_lifetime_cmd_vtysh,
	"no accept-lifetime",
	"Negate a command or set its defaults\n"
	"Unset accept-lifetime\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_all_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <A.B.C.D/M$prefix [exact-match$exact]|any>",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Prefix to match. e.g. 10.0.0.0/8\n"
	"Exact match of the prefixes\n"
	"Match any IPv4\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_ext_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action ip <A.B.C.D$src A.B.C.D$src_mask|host A.B.C.D$src|any> <A.B.C.D$dst A.B.C.D$dst_mask|host A.B.C.D$dst|any>",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Any Internet Protocol\n"
	"Source address to match\n"
	"Source address mask to apply\n"
	"Single source host\n"
	"Source address to match\n"
	"Any source host\n"
	"Destination address to match\n"
	"Destination address mask to apply\n"
	"Single destination host\n"
	"Destination address to match\n"
	"Any destination host\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_remark_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name remark",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_remark_line_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name remark LINE...",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_ACL_CONFIG, no_access_list_std_cmd_vtysh,
	"no access-list ACCESSLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <[host] A.B.C.D$host|A.B.C.D$host A.B.C.D$mask>",
	"Negate a command or set its defaults\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"A single host address\n"
	"Address to match\n"
	"Address to match\n"
	"Wildcard bits\n")

DEFSH (VTYSH_BGPD|VTYSH_ISISD|VTYSH_OSPF6D|VTYSH_OSPFD|VTYSH_RIPD|VTYSH_ZEBRA, no_agentx_cmd_vtysh,
	"no agentx",
	"Negate a command or set its defaults\n"
	"SNMP AgentX protocol settings\n")

DEFSH (VTYSH_ZEBRA, no_allow_external_route_update_cmd_vtysh,
	"no allow-external-route-update",
	"Negate a command or set its defaults\n"
	"Allow FRR routes to be overwritten by external processes\n")

DEFSH (VTYSH_OSPF6D, no_area_export_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> export-list ACCESSLIST6_NAME",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Unset the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPF6D, no_area_filter_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> filter-list prefix PREFIXLIST6_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Filter networks between OSPF6 areas\n"
	"Filter prefixes between OSPF6 areas\n"
	"Name of an IPv6 prefix-list\n"
	"Filter networks sent to this area\n"
	"Filter networks sent from this area\n")

DEFSH (VTYSH_OSPF6D, no_area_import_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> import-list ACCESSLIST6_NAME",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Unset the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_ISISD, no_area_lsp_mtu_cmd_vtysh,
	"no lsp-mtu [(128-4352)]",
	"Negate a command or set its defaults\n"
	"Configure the maximum size of generated LSPs\n"
	"Maximum size of generated LSPs\n")

DEFSH (VTYSH_OSPF6D, no_area_nssa_range_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)>$area nssa range X:X::X:X/M$prefix [<not-advertise|cost (0-16777215)>]",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as nssa\n"
	"Configured address range\n"
	"Specify IPv6 prefix\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_ISISD, no_area_passwd_cmd_vtysh,
	"no <area-password|domain-password>$cmd [<clear|md5>$pwd_type WORD$pwd [authenticate snp <send-only|validate>$snp]]",
	"Negate a command or set its defaults\n"
	"Configure the authentication password for an area\n"
	"Set the authentication password for a routing domain\n"
	"Clear-text authentication type\n"
	"MD5 authentication type\n"
	"Level-wide password\n"
	"Authentication\n"
	"SNP PDUs\n"
	"Send but do not check PDUs on receiving\n"
	"Send and check PDUs on receiving\n")

DEFSH (VTYSH_OSPF6D, no_area_range_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> range X:X::X:X/M [<advertise|not-advertise|cost (0-16777215)>]",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configured address range\n"
	"Specify IPv6 prefix\n"
	"Advertise\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_OSPF6D, no_auto_cost_reference_bandwidth_cmd_vtysh,
	"no auto-cost reference-bandwidth [(1-4294967)]",
	"Negate a command or set its defaults\n"
	"Calculate OSPF interface cost according to bandwidth\n"
	"Use reference bandwidth method to assign OSPF cost\n"
	"The reference bandwidth in terms of Mbits per second\n")

DEFSH (VTYSH_BABELD, no_babel_diversity_cmd_vtysh,
	"no babel diversity",
	"Negate a command or set its defaults\n"
	"Babel commands\n"
	"Disable diversity-aware routing.\n")

DEFSH (VTYSH_BABELD, no_babel_network_cmd_vtysh,
	"no network IF_OR_ADDR",
	"Negate a command or set its defaults\n"
	"Disable Babel protocol on specified interface or network.\n"
	"Interface or address\n")

DEFSH (VTYSH_BFDD, no_bfd_peer_minimum_ttl_cmd_vtysh,
	"no minimum-ttl",
	"Negate a command or set its defaults\n"
	"Expect packets with at least this TTL\n")

DEFSH (VTYSH_BFDD, no_bfd_profile_cmd_vtysh,
	"no profile BFDPROF$name",
	"Negate a command or set its defaults\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH (VTYSH_BFDD, no_bfd_profile_minimum_ttl_cmd_vtysh,
	"no minimum-ttl",
	"Negate a command or set its defaults\n"
	"Expect packets with at least this TTL\n")

DEFSH (VTYSH_BGPD, no_bgp_always_compare_med_cmd_vtysh,
	"no bgp always-compare-med",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Allow comparing MED from different neighbors\n")

DEFSH (VTYSH_BGPD, no_bgp_as_path_all_cmd_vtysh,
	"no bgp as-path access-list AS_PATH_FILTER_NAME",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"BGP autonomous system path filter\n"
	"Specify an access list name\n"
	"Regular expression access list name\n")

DEFSH (VTYSH_BGPD, no_bgp_as_path_cmd_vtysh,
	"no bgp as-path access-list AS_PATH_FILTER_NAME [seq (0-4294967295)] <deny|permit> LINE...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"BGP autonomous system path filter\n"
	"Specify an access list name\n"
	"Regular expression access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"A regular-expression (1234567890_^|[,{}() ]$*+.?-\\) to match the BGP AS paths\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_aspath_confed_cmd_vtysh,
	"no bgp bestpath as-path confed",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Compare path lengths including confederation sets & sequences in selecting a route\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_aspath_ignore_cmd_vtysh,
	"no bgp bestpath as-path ignore",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Ignore as-path length in selecting a route\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_aspath_multipath_relax_cmd_vtysh,
	"no bgp bestpath as-path multipath-relax [<as-set|no-as-set>]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"AS-path attribute\n"
	"Allow load sharing across routes that have different AS paths (but same length)\n"
	"Generate an AS_SET\n"
	"Do not generate an AS_SET\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_bw_cmd_vtysh,
	"no bgp bestpath bandwidth [<ignore|skip-missing|default-weight-for-missing>$bw_cfg]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Link Bandwidth attribute\n"
	"Ignore link bandwidth (i.e., do regular ECMP, not weighted)\n"
	"Ignore paths without link bandwidth for ECMP (if other paths have it)\n"
	"Assign a low default weight (value 1) to paths not having link bandwidth\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_compare_router_id_cmd_vtysh,
	"no bgp bestpath compare-routerid",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Compare router-id for identical EBGP paths\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_med_cmd_vtysh,
	"no bgp bestpath med <confed [missing-as-worst]|missing-as-worst [confed]>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"MED attribute\n"
	"Compare MED among confederation paths\n"
	"Treat missing MED as the least preferred one\n"
	"Treat missing MED as the least preferred one\n"
	"Compare MED among confederation paths\n")

DEFSH (VTYSH_BGPD, no_bgp_bestpath_peer_type_multipath_relax_cmd_vtysh,
	"no bgp bestpath peer-type multipath-relax",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Change the default bestpath selection\n"
	"Peer type\n"
	"Allow load sharing across routes learned from different peer types\n")

DEFSH (VTYSH_BGPD, no_bgp_client_to_client_reflection_cmd_vtysh,
	"no bgp client-to-client reflection",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure client to client route reflection\n"
	"reflection of routes allowed\n")

DEFSH (VTYSH_BGPD, no_bgp_cluster_id_cmd_vtysh,
	"no bgp cluster-id [<A.B.C.D|(1-4294967295)>]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure Route-Reflector Cluster-id\n"
	"Route-Reflector Cluster-id in IP address format\n"
	"Route-Reflector Cluster-id as 32 bit quantity\n")

DEFSH (VTYSH_BGPD, no_bgp_coalesce_time_cmd_vtysh,
	"no coalesce-time (0-4294967295)",
	"Negate a command or set its defaults\n"
	"Subgroup coalesce timer\n"
	"Subgroup coalesce timer value (in ms)\n")

DEFSH (VTYSH_BGPD, no_bgp_community_list_expanded_all_cmd_vtysh,
	"no bgp community-list <(100-500)|expanded COMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (expanded)\n"
	"Add an expanded community-list entry\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, no_bgp_community_list_expanded_all_list_cmd_vtysh,
	"no bgp community-list <(100-500)|expanded COMMUNITY_LIST_NAME>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (expanded)\n"
	"Add an expanded community-list entry\n"
	"Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_community_list_standard_all_cmd_vtysh,
	"no bgp community-list <(1-99)|standard COMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (standard)\n"
	"Add an standard community-list entry\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, no_bgp_community_list_standard_all_list_cmd_vtysh,
	"no bgp community-list <(1-99)|standard COMMUNITY_LIST_NAME>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a community list entry\n"
	"Community list number (standard)\n"
	"Add an standard community-list entry\n"
	"Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_confederation_identifier_cmd_vtysh,
	"no bgp confederation identifier [ASNUM]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"AS confederation parameters\n"
	"Set routing domain confederation AS\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, no_bgp_confederation_peers_cmd_vtysh,
	"no bgp confederation peers ASNUM...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"AS confederation parameters\n"
	"Peer ASs in BGP confederation\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, no_bgp_default_local_preference_cmd_vtysh,
	"no bgp default local-preference [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"local preference (higher=more preferred)\n"
	"Configure default local preference value\n")

DEFSH (VTYSH_BGPD, no_bgp_default_show_hostname_cmd_vtysh,
	"no bgp default show-hostname",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Show hostname in certain command outputs\n")

DEFSH (VTYSH_BGPD, no_bgp_default_show_nexthop_hostname_cmd_vtysh,
	"no bgp default show-nexthop-hostname",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"Show hostname for nexthop in certain command outputs\n")

DEFSH (VTYSH_BGPD, no_bgp_default_subgroup_pkt_queue_max_cmd_vtysh,
	"no bgp default subgroup-pkt-queue-max [(20-100)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Configure BGP defaults\n"
	"subgroup-pkt-queue-max\n"
	"Configure subgroup packet queue max\n")

DEFSH (VTYSH_BGPD, no_bgp_deterministic_med_cmd_vtysh,
	"no bgp deterministic-med",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Pick the best-MED path among paths advertised from the neighboring AS\n")

DEFSH (VTYSH_BGPD, no_bgp_disable_connected_route_check_cmd_vtysh,
	"no bgp disable-ebgp-connected-route-check",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Disable checking if nexthop is connected on ebgp sessions\n")

DEFSH (VTYSH_BGPD, no_bgp_distance_cmd_vtysh,
	"no distance bgp [(1-255) (1-255) (1-255)]",
	"Negate a command or set its defaults\n"
	"Define an administrative distance\n"
	"BGP distance\n"
	"Distance for routes external to the AS\n"
	"Distance for routes internal to the AS\n"
	"Distance for local routes\n")

DEFSH (VTYSH_BGPD, no_bgp_distance_source_access_list_cmd_vtysh,
	"no distance (1-255) A.B.C.D/M WORD",
	"Negate a command or set its defaults\n"
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n"
	"Access list name\n")

DEFSH (VTYSH_BGPD, no_bgp_distance_source_cmd_vtysh,
	"no distance (1-255) A.B.C.D/M",
	"Negate a command or set its defaults\n"
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n")

DEFSH (VTYSH_BGPD, no_bgp_ebgp_requires_policy_cmd_vtysh,
	"no bgp ebgp-requires-policy",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Require in and out policy for eBGP peers (RFC8212)\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_advertise_all_vni_cmd_vtysh,
	"no advertise-all-vni",
	"Negate a command or set its defaults\n"
	"Advertise All local VNIs\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_advertise_autort_rfc8365_cmd_vtysh,
	"no autort rfc8365-compatible",
	"Negate a command or set its defaults\n"
	"Auto-derivation of RT\n"
	"Auto-derivation of RT using RFC8365\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_advertise_default_gw_cmd_vtysh,
	"no advertise-default-gw",
	"Negate a command or set its defaults\n"
	"Withdraw All default g/w mac-ip routes from EVPN\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_advertise_default_gw_vni_cmd_vtysh,
	"no advertise-default-gw",
	"Negate a command or set its defaults\n"
	"Withdraw default g/w mac-ip routes from EVPN for a VNI\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_advertise_type5_cmd_vtysh,
	"no advertise <ipv4|ipv6><unicast|multicast|vpn> [route-map WORD]",
	"Negate a command or set its defaults\n"
	"Advertise prefix routes\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"route-map for filtering specific routes\n"
	"Name of the route map\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_evpn_advertise_vni_subnet_cmd_vtysh,
	"no advertise-subnet",
	"Negate a command or set its defaults\n"
	"Advertise All local VNIs\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_default_originate_cmd_vtysh,
	"no default-originate <ipv4 | ipv6>",
	"Negate a command or set its defaults\n"
	"withdraw a default route\n"
	"ipv4 address family\n"
	"ipv6 address family\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_ead_es_rt_cmd_vtysh,
	"no ead-es-route-target export RT",
	"Negate a command or set its defaults\n"
	"EAD ES Route Target\n"
	"export\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vni_cmd_vtysh,
	"no vni (1-16777215)",
	"Negate a command or set its defaults\n"
	"VXLAN Network Identifier\n"
	"VNI number\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vni_rd_cmd_vtysh,
	"no rd ASN:NN_OR_IP-ADDRESS:NN",
	"Negate a command or set its defaults\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vni_rd_without_val_cmd_vtysh,
	"no rd",
	"Negate a command or set its defaults\n"
	"Route Distinguisher\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vni_rt_cmd_vtysh,
	"no route-target <both|import|export> RT",
	"Negate a command or set its defaults\n"
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vni_rt_without_val_cmd_vtysh,
	"no route-target <import|export>",
	"Negate a command or set its defaults\n"
	"Route Target\n"
	"import\n"
	"export\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vrf_rd_cmd_vtysh,
	"no rd ASN:NN_OR_IP-ADDRESS:NN",
	"Negate a command or set its defaults\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vrf_rd_without_val_cmd_vtysh,
	"no rd",
	"Negate a command or set its defaults\n"
	"Route Distinguisher\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vrf_rt_auto_cmd_vtysh,
	"no route-target <both|import|export>$type auto",
	"Negate a command or set its defaults\n"
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"Automatically derive route target\n")

DEFSH (VTYSH_BGPD, no_bgp_evpn_vrf_rt_cmd_vtysh,
	"no route-target <both|import|export> RTLIST...",
	"Negate a command or set its defaults\n"
	"Route Target\n"
	"import and export\n"
	"import\n"
	"export\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, no_bgp_extcommunity_list_expanded_all_cmd_vtysh,
	"no bgp extcommunity-list <(100-500)|expanded EXTCOMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> LINE...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (expanded)\n"
	"Specify expanded extcommunity-list\n"
	"Extended Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, no_bgp_extcommunity_list_expanded_all_list_cmd_vtysh,
	"no bgp extcommunity-list <(100-500)|expanded EXTCOMMUNITY_LIST_NAME>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (expanded)\n"
	"Specify expanded extcommunity-list\n"
	"Extended Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_extcommunity_list_standard_all_cmd_vtysh,
	"no bgp extcommunity-list <(1-99)|standard EXTCOMMUNITY_LIST_NAME> [seq (0-4294967295)] <deny|permit> AA:NN...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (standard)\n"
	"Specify standard extcommunity-list\n"
	"Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify community to reject\n"
	"Specify community to accept\n"
	"Extended community attribute in 'rt aa:nn_or_IPaddr:nn' OR 'soo aa:nn_or_IPaddr:nn' format\n")

DEFSH (VTYSH_BGPD, no_bgp_extcommunity_list_standard_all_list_cmd_vtysh,
	"no bgp extcommunity-list <(1-99)|standard EXTCOMMUNITY_LIST_NAME>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a extended community list entry\n"
	"Extended Community list number (standard)\n"
	"Specify standard extcommunity-list\n"
	"Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_fast_convergence_cmd_vtysh,
	"no bgp fast-convergence",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Fast convergence for bgp sessions\n")

DEFSH (VTYSH_BGPD, no_bgp_fast_external_failover_cmd_vtysh,
	"no bgp fast-external-failover",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Immediately reset session if a link to a directly connected external peer goes down\n")

DEFSH (VTYSH_BGPD, no_bgp_global_update_delay_cmd_vtysh,
	"no bgp update-delay [(0-3600) [(1-3600)]]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Force initial delay for best-path and updates\n"
	"Max delay in seconds\n"
	"Establish wait in seconds\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_cmd_vtysh,
	"no bgp graceful-restart",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Undo Global Graceful Restart command\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_disable_cmd_vtysh,
	"no bgp graceful-restart-disable",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Undo Global Graceful Restart - Disable Mode\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_graceful_restart_disable_eor_cmd_vtysh,
	"no bgp graceful-restart disable-eor",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart configuration parameters\n"
	"Disable EOR Check\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_preserve_fw_cmd_vtysh,
	"no bgp graceful-restart preserve-fw-state",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Unsets F-bit indication that fib is preserved while doing Graceful Restart\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_restart_time_cmd_vtysh,
	"no bgp graceful-restart restart-time [(0-4095)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the time to wait to delete stale routes before a BGP open message is received\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_rib_stale_time_cmd_vtysh,
	"no bgp graceful-restart rib-stale-time [(1-3600)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart configuration parameters\n"
	"Specify the stale route removal timer in rib\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_select_defer_time_cmd_vtysh,
	"no bgp graceful-restart select-defer-time [(0-3600)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the time to defer the BGP route selection after restart\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_restart_stalepath_time_cmd_vtysh,
	"no bgp graceful-restart stalepath-time [(1-4095)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful restart capability parameters\n"
	"Set the max time to hold onto restarting peer's stale paths\n"
	"Delay value (seconds)\n")

DEFSH (VTYSH_BGPD, no_bgp_graceful_shutdown_cmd_vtysh,
	"no bgp graceful-shutdown",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Graceful shutdown parameters\n")

DEFSH (VTYSH_BGPD, no_bgp_inq_limit_cmd_vtysh,
	"no bgp input-queue-limit [(1-4294967295)$limit]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Set the BGP Input Queue limit for all peers when message parsing\n"
	"Input-Queue limit\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_all_cmd_vtysh,
	"no bgp large-community-list <(1-99)|(100-500)|LCOMMUNITY_LIST_NAME>",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Large Community list number (standard)\n"
	"Large Community list number (expanded)\n"
	"Large Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_expanded_cmd_vtysh,
	"no bgp large-community-list (100-500) [seq (0-4294967295)] <deny|permit> LINE...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Large Community list number (expanded)\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_name_expanded_all_cmd_vtysh,
	"no bgp large-community-list expanded LCOMMUNITY_LIST_NAME",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify expanded large-community-list\n"
	"Large Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_name_expanded_cmd_vtysh,
	"no bgp large-community-list expanded LCOMMUNITY_LIST_NAME [seq (0-4294967295)] <deny|permit> LINE...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify expanded large-community-list\n"
	"Large community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"An ordered list as a regular-expression\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_name_standard_all_cmd_vtysh,
	"no bgp large-community-list standard LCOMMUNITY_LIST_NAME",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify standard large-community-list\n"
	"Large Community list name\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_name_standard_cmd_vtysh,
	"no bgp large-community-list standard LCOMMUNITY_LIST_NAME [seq (0-4294967295)] <deny|permit> AA:AA:NN...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Specify standard large-community-list\n"
	"Large Community list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"large community in 'aa:bb:cc' format\n")

DEFSH (VTYSH_BGPD, no_bgp_lcommunity_list_standard_cmd_vtysh,
	"no bgp large-community-list (1-99) [seq (0-4294967295)] <deny|permit> AA:AA:NN...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Add a large community list entry\n"
	"Large Community list number (standard)\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify large community to reject\n"
	"Specify large community to accept\n"
	"large community in 'aa:bb:cc' format\n")

DEFSH (VTYSH_BGPD, no_bgp_listen_limit_cmd_vtysh,
	"no bgp listen limit [(1-65535)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"BGP Dynamic Neighbors listen commands\n"
	"Maximum number of BGP Dynamic Neighbors that can be created\n"
	"Configure Dynamic Neighbors listen limit value\n")

DEFSH (VTYSH_BGPD, no_bgp_listen_range_cmd_vtysh,
	"no bgp listen range <A.B.C.D/M|X:X::X:X/M> peer-group PGNAME",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Unconfigure BGP dynamic neighbors listen range\n"
	"Unconfigure BGP dynamic neighbors listen range\n"
	"Neighbor address\n"
	"IPv6 address\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, no_bgp_llgr_stalepath_time_cmd_vtysh,
	"no bgp long-lived-graceful-restart stale-time [(1-16777215)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Enable Long-lived Graceful Restart\n"
	"Specifies maximum time to wait before purging long-lived stale routes\n"
	"Stale time value (seconds)\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_local_mac_cmd_vtysh,
	"no bgp local-mac vni (1-16777215) mac WORD",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Local MAC config\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"local mac\n"
	"mac address\n")

DEFSH (VTYSH_BGPD, no_bgp_log_neighbor_changes_cmd_vtysh,
	"no bgp log-neighbor-changes",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Log neighbor up/down and reset reason\n")

DEFSH (VTYSH_BGPD, no_bgp_maxmed_admin_cmd_vtysh,
	"no bgp max-med administrative [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Advertise routes with max-med\n"
	"Administratively applied, for an indefinite period\n"
	"Max MED value to be used\n")

DEFSH (VTYSH_BGPD, no_bgp_maxmed_onstartup_cmd_vtysh,
	"no bgp max-med on-startup [(5-86400) [(0-4294967295)]]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Advertise routes with max-med\n"
	"Effective on a startup\n"
	"Time (seconds) period for max-med\n"
	"Max MED value to be used\n")

DEFSH (VTYSH_BGPD, no_bgp_maxpaths_cmd_vtysh,
	"no maximum-paths [(1-256)]",
	"Negate a command or set its defaults\n"
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_maxpaths_hidden_cmd_vtysh,
	"no maximum-paths [(1-256)]",
	"Negate a command or set its defaults\n"
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH (VTYSH_BGPD, no_bgp_maxpaths_ibgp_cmd_vtysh,
	"no maximum-paths ibgp [(1-256) [equal-cluster-length]]",
	"Negate a command or set its defaults\n"
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n"
	"Match the cluster length\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_maxpaths_ibgp_hidden_cmd_vtysh,
	"no maximum-paths ibgp [(1-256) [equal-cluster-length]]",
	"Negate a command or set its defaults\n"
	"Forward packets over multiple paths\n"
	"iBGP-multipath\n"
	"Number of paths\n"
	"Match the cluster length\n")

DEFSH (VTYSH_BGPD, no_bgp_minimum_holdtime_cmd_vtysh,
	"no bgp minimum-holdtime [(1-65535)]",
	"Negate a command or set its defaults\n"
	"BGP specific commands\n"
	"BGP minimum holdtime\n"
	"Seconds\n")

DEFSH (VTYSH_BGPD, no_bgp_neighbor_graceful_restart_disable_set_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart-disable",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Undo Graceful Restart Disable command for a neighbor\n")

DEFSH (VTYSH_BGPD, no_bgp_neighbor_graceful_restart_helper_set_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart-helper",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Undo Graceful Restart Helper command for a neighbor\n")

DEFSH (VTYSH_BGPD, no_bgp_neighbor_graceful_restart_set_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> graceful-restart",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Undo Graceful Restart command for a neighbor\n")

DEFSH (VTYSH_BGPD, no_bgp_network_import_check_cmd_vtysh,
	"no bgp network import-check",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"BGP network command\n"
	"Check BGP network route exists in IGP\n")

DEFSH (VTYSH_BGPD, no_bgp_norib_cmd_vtysh,
	"no bgp no-rib",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Disable BGP route installation to RIB (Zebra)\n")

DEFSH (VTYSH_BGPD, no_bgp_outq_limit_cmd_vtysh,
	"no bgp output-queue-limit [(1-4294967295)$limit]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Set the BGP Output Queue limit for all peers when message parsing\n"
	"Output-Queue limit\n")

DEFSH (VTYSH_BGPD, no_bgp_redistribute_ipv4_cmd_vtysh,
	"no redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> [{metric (0-4294967295)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_redistribute_ipv4_hidden_cmd_vtysh,
	"no redistribute <kernel|connected|local|static|rip|ospf|isis|eigrp|nhrp|vnc|vnc-direct|babel|openfabric> [{metric (0-4294967295)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, no_bgp_redistribute_ipv4_ospf_cmd_vtysh,
	"no redistribute <ospf|table|table-direct> (1-65535) [{metric (0-4294967295)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_bgp_redistribute_ipv4_ospf_hidden_cmd_vtysh,
	"no redistribute <ospf|table|table-direct> (1-65535) [{metric (0-4294967295)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, no_bgp_redistribute_ipv6_cmd_vtysh,
	"no redistribute <kernel|connected|local|static|ripng|ospf6|isis|nhrp|vnc|vnc-direct|babel|openfabric> [{metric (0-4294967295)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"VNC direct (not via zebra) routes\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, no_bgp_redistribute_ipv6_table_cmd_vtysh,
	"no redistribute table-direct (1-65535)$table_id [{metric (0-4294967295)|route-map WORD}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Table ID\n"
	"Metric for redistributed routes\n"
	"Default metric\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_BGPD, no_bgp_reject_as_sets_cmd_vtysh,
	"no bgp reject-as-sets",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Reject routes with AS_SET or AS_CONFED_SET flag\n")

DEFSH (VTYSH_BGPD, no_bgp_router_id_cmd_vtysh,
	"no bgp router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Override configured router identifier\n"
	"Manually configured router identifier\n")

DEFSH (VTYSH_BGPD, no_bgp_rr_allow_outbound_policy_cmd_vtysh,
	"no bgp route-reflector allow-outbound-policy",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Allow modifications made by out route-map\n"
	"on ibgp neighbors\n")

DEFSH (VTYSH_BGPD, no_bgp_segment_routing_srv6_cmd_vtysh,
	"no segment-routing srv6",
	"Negate a command or set its defaults\n"
	"Segment-Routing configuration\n"
	"Segment-Routing SRv6 configuration\n")

DEFSH (VTYSH_BGPD, no_bgp_send_extra_data_cmd_vtysh,
	"[no] bgp send-extra-data zebra",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Extra data to Zebra for display/use\n"
	"To zebra\n")

DEFSH (VTYSH_BGPD, no_bgp_session_dscp_cmd_vtysh,
	"no bgp session-dscp [(0-63)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Override default (CS6) DSCP for BGP connections\n"
	"Manually configured DSCP value\n")

DEFSH (VTYSH_BGPD, no_bgp_set_route_map_delay_timer_cmd_vtysh,
	"no bgp route-map delay-timer [(0-600)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Default BGP route-map delay timer\n"
	"Reset to default time to wait for processing route-map changes\n"
	"0 disables the timer, no route updates happen when route-maps change\n")

DEFSH (VTYSH_BGPD, no_bgp_shutdown_cmd_vtysh,
	"no bgp shutdown",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Administrative shutdown of the BGP instance\n")

DEFSH (VTYSH_BGPD, no_bgp_shutdown_msg_cmd_vtysh,
	"no bgp shutdown message MSG...",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Administrative shutdown of the BGP instance\n"
	"Add a shutdown message (RFC 8203)\n"
	"Shutdown message\n")

DEFSH (VTYSH_BGPD, no_bgp_sid_vpn_export_cmd_vtysh,
	"no$no sid vpn per-vrf export",
	"Negate a command or set its defaults\n"
	"sid value for VRF\n"
	"Between current vrf and vpn\n"
	"sid per-VRF (both IPv4 and IPv6 address families)\n"
	"For routes leaked from current vrf to vpn\n")

DEFSH (VTYSH_BGPD, no_bgp_srv6_locator_cmd_vtysh,
	"no locator NAME$name",
	"Negate a command or set its defaults\n"
	"Specify SRv6 locator\n"
	"Specify SRv6 locator\n")

DEFSH (VTYSH_BGPD, no_bgp_suppress_duplicates_cmd_vtysh,
	"no bgp suppress-duplicates",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"Suppress duplicate updates if the route actually not changed\n")

DEFSH (VTYSH_BGPD, no_bgp_table_map_cmd_vtysh,
	"no table-map WORD",
	"Negate a command or set its defaults\n"
	"BGP table to RIB route download filter\n"
	"Name of the route map\n")

DEFSH (VTYSH_BGPD, no_bgp_tcp_keepalive_cmd_vtysh,
	"no bgp tcp-keepalive [(1-65535) (1-65535) (1-30)]",
	"Negate a command or set its defaults\n"
	"BGP information\n"
	"TCP keepalive parameters\n"
	"TCP keepalive idle time (seconds)\n"
	"TCP keepalive interval (seconds)\n"
	"TCP keepalive maximum probes\n")

DEFSH (VTYSH_BGPD, no_bgp_timers_cmd_vtysh,
	"no timers bgp [(0-65535) (0-65535)]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"BGP timers\n"
	"Keepalive interval\n"
	"Holdtime\n")

DEFSH (VTYSH_BGPD, no_bgp_update_delay_cmd_vtysh,
	"no update-delay [(0-3600) [(1-3600)]]",
	"Negate a command or set its defaults\n"
	"Force initial delay for best-path and updates\n"
	"Max delay in seconds\n"
	"Establish wait in seconds\n")

DEFSH (VTYSH_BGPD, no_bmp_listener_cmd_vtysh,
	"no bmp listener <X:X::X:X|A.B.C.D> port (1-65535)",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Create BMP listener\n"
	"IPv6 address to listen on\n"
	"IPv4 address to listen on\n"
	"TCP Port number\n"
	"TCP Port number\n")

DEFSH (VTYSH_BGPD, no_bmp_mirror_limit_cmd_vtysh,
	"no bmp mirror buffer-limit [(0-4294967294)]",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Route Mirroring settings\n"
	"Configure maximum memory used for buffered mirroring messages\n"
	"Limit in bytes\n")

DEFSH (VTYSH_BGPD, no_bmp_targets_cmd_vtysh,
	"no bmp targets BMPTARGETS",
	"Negate a command or set its defaults\n"
	"BGP Monitoring Protocol\n"
	"Delete BMP target group\n"
	"Name of the BMP target group\n")

DEFSH (VTYSH_OSPFD, no_capability_opaque_cmd_vtysh,
	"no capability opaque",
	"Negate a command or set its defaults\n"
	"Enable specific OSPF feature\n"
	"Opaque LSA\n")

DEFSH (VTYSH_NON_MGMTD, no_config_log_dmn_file_cmd_vtysh,
	"no log daemon <zebra|mgmtd|bgpd|ripd|ripngd|ospfd|ospf6d|isisd|fabricd|nhrpd|ldpd|babeld|eigrpd|pimd|pim6d|pbrd|staticd|bfdd|vrrpd|pathd> file [FILENAME [LEVEL]]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Specific daemon\n"
	"For the zebra daemon\n"
	"For the mgmtd daemon\n"
	"For the bgpd daemon\n"
	"For the ripd daemon\n"
	"For the ripngd daemon\n"
	"For the ospfd daemon\n"
	"For the ospf6d daemon\n"
	"For the isisd daemon\n"
	"For the fabricd daemon\n"
	"For the nhrpd daemon\n"
	"For the ldpd daemon\n"
	"For the babeld daemon\n"
	"For the eigrpd daemon\n"
	"For the pimd daemon\n"
	"For the pim6d daemon\n"
	"For the pbrd daemon\n"
	"For the staticd daemon\n"
	"For the bfdd daemon\n"
	"For the vrrpd daemon\n"
	"For the pathd daemon\n"
	"Cancel logging to file\n"
	"Logging file name\n"
	"Logging level\n")

DEFSH (VTYSH_NON_MGMTD, no_config_log_facility_cmd_vtysh,
	"no log facility [<kern|user|mail|daemon|auth|syslog|lpr|news|uucp|cron|local0|local1|local2|local3|local4|local5|local6|local7>] [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Reset syslog facility to default (daemon)\n"
	"Kernel\n"
	"User process\n"
	"Mail system\n"
	"System daemons\n"
	"Authorization system\n"
	"Syslog itself\n"
	"Line printer system\n"
	"USENET news\n"
	"Unix-to-Unix copy system\n"
	"Cron/at facility\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"Local use\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, no_config_log_filterfile_cmd_vtysh,
	"no log filtered-file [FILENAME [LEVEL]]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Cancel logging to file with string filter\n"
	"Logging file name\n"
	"Logging level\n")

DEFSH (VTYSH_NON_MGMTD, no_config_log_syslog_cmd_vtysh,
	"no log syslog [<emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Cancel logging to syslog\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n")

DEFSH (VTYSH_NON_MGMTD, no_config_log_timestamp_precision_cmd_vtysh,
	"no log timestamp precision [(0-6)]",
	"Negate a command or set its defaults\n"
	"Logging control\n"
	"Timestamp configuration\n"
	"Reset the timestamp precision to the default value of 0\n"
	"Number of subsecond digits\n")

DEFSH (VTYSH_KEYS, no_cryptographic_algorithm_cmd_vtysh,
	"no cryptographic-algorithm [<md5|hmac-sha-1|hmac-sha-256|hmac-sha-384|hmac-sha-512>$algo]",
	"Negate a command or set its defaults\n"
	"Cryptographic-algorithm\n"
	"Use MD5 algorithm\n"
	"Use HMAC-SHA-1 algorithm\n"
	"Use HMAC-SHA-256 algorithm\n"
	"Use HMAC-SHA-384 algorithm\n"
	"Use HMAC-SHA-512 algorithm\n")

DEFSH (VTYSH_ISISD, no_csnp_interval_cmd_vtysh,
	"no isis csnp-interval [(1-600)] [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set CSNP interval in seconds\n"
	"CSNP interval value\n"
	"Specify interval for level-1 CSNPs\n"
	"Specify interval for level-2 CSNPs\n")

DEFSH (VTYSH_PIMD, no_debug_autorp_cmd_vtysh,
	"no debug pim autorp",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"AutoRP message processing activity\n")

DEFSH (VTYSH_BABELD, no_debug_babel_cmd_vtysh,
	"no debug babel <common|kernel|filter|timeout|interface|route|all>",
	"Negate a command or set its defaults\n"
	"Disable debug messages for specific or all part.\n"
	"Babel information\n"
	"Common messages (default)\n"
	"Kernel messages\n"
	"Filter messages\n"
	"Timeout messages\n"
	"Interface messages\n"
	"Route messages\n"
	"All messages\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_aggregate_cmd_vtysh,
	"no debug bgp aggregate",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP aggregate\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_aggregate_prefix_cmd_vtysh,
	"no debug bgp aggregate prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP aggregate\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_as4_cmd_vtysh,
	"no debug bgp as4",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP AS4 actions\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_as4_segment_cmd_vtysh,
	"no debug bgp as4 segment",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP AS4 actions\n"
	"BGP AS4 aspath segment handling\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_bestpath_cmd_vtysh,
	"no debug bgp bestpath",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP bestpath\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_bestpath_prefix_cmd_vtysh,
	"no debug bgp bestpath <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP bestpath\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_cmd_vtysh,
	"no debug bgp",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_flowspec_cmd_vtysh,
	"no debug bgp flowspec",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP allow flowspec debugging entries\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_graceful_restart_cmd_vtysh,
	"no debug bgp graceful-restart",
	"Debugging functions\n"
	"BGP information\n"
	"Graceful Restart - Enable Debug Logs\n"
	"Negate a command or set its defaults\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_keepalive_cmd_vtysh,
	"no debug bgp keepalives",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP keepalives\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_keepalive_peer_cmd_vtysh,
	"no debug bgp keepalives <A.B.C.D|X:X::X:X|WORD>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP keepalives\n"
	"BGP neighbor IP address to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_labelpool_cmd_vtysh,
	"no debug bgp labelpool",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"label pool\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_neighbor_events_cmd_vtysh,
	"no debug bgp neighbor-events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"Neighbor Events\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_neighbor_events_peer_cmd_vtysh,
	"no debug bgp neighbor-events <A.B.C.D|X:X::X:X|WORD>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"Neighbor Events\n"
	"BGP neighbor IP address to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_nht_cmd_vtysh,
	"no debug bgp nht",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP nexthop tracking events\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_pbr_cmd_vtysh,
	"no debug bgp pbr [error]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP policy based routing\n"
	"BGP PBR Error\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_cmd_vtysh,
	"no debug bgp updates",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_direct_cmd_vtysh,
	"no debug bgp updates <in|out>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Inbound updates\n"
	"Outbound updates\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_direct_peer_cmd_vtysh,
	"no debug bgp updates <in|out> <A.B.C.D|X:X::X:X|WORD> [prefix-list PREFIXLIST_NAME]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Inbound updates\n"
	"Outbound updates\n"
	"BGP neighbor IP address to debug\n"
	"BGP IPv6 neighbor to debug\n"
	"BGP neighbor on interface to debug\n"
	"Use prefix-list to filter prefixes to debug\n"
	"Name of prefix-list\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_groups_cmd_vtysh,
	"no debug bgp update-groups",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP update-groups\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_prefix_afi_safi_cmd_vtysh,
	"no debug bgp updates prefix l2vpn$afi evpn$safi type <<macip|2> mac <X:X:X:X:X:X|X:X:X:X:X:X/M> [ip <A.B.C.D|X:X::X:X>]|<multicast|3> ip <A.B.C.D|X:X::X:X>|<prefix|5> ip <A.B.C.D/M|X:X::X:X/M>>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Specify a prefix to debug\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC address\n"
	"MAC address\n"
	"MAC address\n"
	"IP information\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"IP information\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n"
	"IP information\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_update_prefix_cmd_vtysh,
	"no debug bgp updates prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP updates\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_vnc_all_cmd_vtysh,
	"no debug all bgp vnc",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Disable all VNC debugging\n"
	"BGP information\n"
	"VNC information\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_vnc_cmd_vtysh,
	"no debug bgp vnc <rfapi-query|import-bi-attach|import-del-remote|verbose>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"VNC information\n"
	"rfapi query handling\n"
	"import BI atachment\n"
	"import delete remote routes\n"
	"verbose logging\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_vpn_cmd_vtysh,
	"no debug bgp vpn <leak-from-vrf|leak-to-vrf|rmap-event|label>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"VPN routes\n"
	"leaked from vrf to vpn\n"
	"leaked to vrf from vpn\n"
	"route-map updates\n"
	"labels\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_zebra_cmd_vtysh,
	"no debug bgp zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP Zebra messages\n")

DEFSH (VTYSH_BGPD, no_debug_bgp_zebra_prefix_cmd_vtysh,
	"no debug bgp zebra prefix <A.B.C.D/M|X:X::X:X/M>$prefix",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"BGP information\n"
	"BGP Zebra messages\n"
	"Specify a prefix to debug\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_PIMD, no_debug_bsm_cmd_vtysh,
	"no debug pim bsm",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"BSR message processing activity\n")

DEFSH (VTYSH_EIGRPD, no_debug_eigrp_packets_all_cmd_vtysh,
	"no debug eigrp packets <siaquery|siareply|ack|hello|probe|query|reply|request|retry|stub|terse|update|all> [send|receive] [detail]",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"EIGRP information\n"
	"EIGRP packets\n"
	"EIGRP SIA-Query packets\n"
	"EIGRP SIA-Reply packets\n"
	"EIGRP ack packets\n"
	"EIGRP hello packets\n"
	"EIGRP probe packets\n"
	"EIGRP query packets\n"
	"EIGRP reply packets\n"
	"EIGRP request packets\n"
	"EIGRP retransmissions\n"
	"EIGRP stub packets\n"
	"Display all EIGRP packets except Hellos\n"
	"EIGRP update packets\n"
	"Display all EIGRP packets\n"
	"Send Packets\n"
	"Receive Packets\n"
	"Detailed Information\n")

DEFSH (VTYSH_EIGRPD, no_debug_eigrp_transmit_cmd_vtysh,
	"no debug eigrp transmit <send|recv|all> [detail]",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"EIGRP information\n"
	"EIGRP transmission events\n"
	"packet sent\n"
	"packet received\n"
	"all packets\n"
	"Detailed Information\n")

DEFSH (VTYSH_PIMD, no_debug_igmp_cmd_vtysh,
	"no debug igmp",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"IGMP protocol activity\n")

DEFSH (VTYSH_PIMD, no_debug_igmp_events_cmd_vtysh,
	"no debug igmp events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP protocol events\n")

DEFSH (VTYSH_PIMD, no_debug_igmp_packets_cmd_vtysh,
	"no debug igmp packets",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP protocol packets\n")

DEFSH (VTYSH_PIMD, no_debug_igmp_trace_cmd_vtysh,
	"no debug igmp trace",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP internal daemon activity\n")

DEFSH (VTYSH_PIMD, no_debug_igmp_trace_detail_cmd_vtysh,
	"no debug igmp trace detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"IGMP protocol activity\n"
	"IGMP internal daemon activity\n"
	"detailed\n")

DEFSH (VTYSH_ISISD, no_debug_isis_adj_cmd_vtysh,
	"no debug isis adj-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Adjacency related packets\n")

DEFSH (VTYSH_ISISD, no_debug_isis_bfd_cmd_vtysh,
	"no debug isis bfd",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"isis interaction with BFD\n")

DEFSH (VTYSH_ISISD, no_debug_isis_events_cmd_vtysh,
	"no debug isis events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_flooding_cmd_vtysh,
	"no debug isis flooding",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"Flooding algorithm\n")

DEFSH (VTYSH_ISISD, no_debug_isis_ldp_sync_cmd_vtysh,
	"no debug isis ldp-sync",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"isis interaction with LDP-Sync\n")

DEFSH (VTYSH_ISISD, no_debug_isis_lfa_cmd_vtysh,
	"no debug isis lfa",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS LFA Events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_lsp_gen_cmd_vtysh,
	"no debug isis lsp-gen",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS generation of own LSPs\n")

DEFSH (VTYSH_ISISD, no_debug_isis_lsp_sched_cmd_vtysh,
	"no debug isis lsp-sched",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS scheduling of LSP generation\n")

DEFSH (VTYSH_ISISD, no_debug_isis_packet_dump_cmd_vtysh,
	"no debug isis packet-dump",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS packet dump\n")

DEFSH (VTYSH_ISISD, no_debug_isis_rtevents_cmd_vtysh,
	"no debug isis route-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Route related events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_snp_cmd_vtysh,
	"no debug isis snp-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS CSNP/PSNP packets\n")

DEFSH (VTYSH_ISISD, no_debug_isis_spfevents_cmd_vtysh,
	"no debug isis spf-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Shortest Path First Events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_srevents_cmd_vtysh,
	"no debug isis sr-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Segment Routing Events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_teevents_cmd_vtysh,
	"no debug isis te-events",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Traffic Engineering Events\n")

DEFSH (VTYSH_ISISD, no_debug_isis_tx_queue_cmd_vtysh,
	"no debug isis tx-queue",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS TX queues\n")

DEFSH (VTYSH_ISISD, no_debug_isis_upd_cmd_vtysh,
	"no debug isis update-packets",
	"Negate a command or set its defaults\n"
	"Disable debugging functions (see also 'debug')\n"
	"IS-IS routing protocol\n"
	"IS-IS Update related packets\n")

DEFSH (VTYSH_PIMD, no_debug_mroute_cmd_vtysh,
	"no debug mroute",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM interaction with kernel MFC cache\n")

DEFSH (VTYSH_PIMD, no_debug_mroute_detail_cmd_vtysh,
	"no debug mroute detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM interaction with kernel MFC cache\n"
	"detailed\n")

DEFSH (VTYSH_PIMD, no_debug_msdp_cmd_vtysh,
	"no debug msdp",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MSDP protocol activity\n")

DEFSH (VTYSH_PIMD, no_debug_msdp_events_cmd_vtysh,
	"no debug msdp events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MSDP protocol activity\n"
	"MSDP protocol events\n")

DEFSH (VTYSH_PIMD, no_debug_msdp_packets_cmd_vtysh,
	"no debug msdp packets",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"MSDP protocol activity\n"
	"MSDP protocol packets\n")

DEFSH (VTYSH_PIMD, no_debug_mtrace_cmd_vtysh,
	"no debug mtrace",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Mtrace protocol activity\n")

DEFSH (VTYSH_NHRPD, no_debug_nhrp_cmd_vtysh,
	"no debug nhrp <all|common|event|interface|kernel|route|vici>",
	"Negate a command or set its defaults\n"
	"Disable debug messages for specific or all parts.\n"
	"NHRP information\n"
	"All messages\n"
	"Common messages (default)\n"
	"Event manager messages\n"
	"Interface messages\n"
	"Kernel messages\n"
	"Route messages\n"
	"VICI messages\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_abr_cmd_vtysh,
	"no debug ospf6 abr",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 ABR function\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_asbr_cmd_vtysh,
	"no debug ospf6 asbr",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 ASBR function\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_auth_cmd_vtysh,
	"no debug ospf6 authentication [<tx|rx>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"debug OSPF6 authentication\n"
	"debug authentication tx\n"
	"debug authentication rx\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_brouter_area_cmd_vtysh,
	"no debug ospf6 border-routers area-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n"
	"Debug border routers in specific Area\n"
	"Specify Area-ID\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_brouter_cmd_vtysh,
	"no debug ospf6 border-routers",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_brouter_router_cmd_vtysh,
	"no debug ospf6 border-routers router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug border router\n"
	"Debug specific border router\n"
	"Specify border-router's router-id\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_cmd_vtysh,
	"no debug ospf6",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_flooding_cmd_vtysh,
	"no debug ospf6 flooding",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 flooding function\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_interface_cmd_vtysh,
	"no debug ospf6 interface",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 Interface\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_lsa_hex_cmd_vtysh,
	"no debug ospf6 lsa <router|network|inter-prefix|inter-router|as-external|nssa|link|intra-prefix|unknown> [<originate|examine|flooding>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug Link State Advertisements (LSAs)\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display NSSA LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Display LSAs of unknown origin\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_message_cmd_vtysh,
	"no debug ospf6 message <unknown|hello|dbdesc|lsreq|lsupdate|lsack|all> [<send|recv|send-hdr|recv-hdr>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 message\n"
	"Debug Unknown message\n"
	"Debug Hello message\n"
	"Debug Database Description message\n"
	"Debug Link State Request message\n"
	"Debug Link State Update message\n"
	"Debug Link State Acknowledgement message\n"
	"Debug All message\n"
	"Debug only sending message, entire pkt\n"
	"Debug only receiving message, entire pkt\n"
	"Debug only sending message, header only\n"
	"Debug only receiving message, header only\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_neighbor_cmd_vtysh,
	"no debug ospf6 neighbor [<state|event>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 Neighbor\n"
	"Debug OSPFv3 Neighbor State Change\n"
	"Debug OSPFv3 Neighbor Event\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_nssa_cmd_vtysh,
	"no debug ospf6 nssa",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug OSPFv3 NSSA function\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_spf_database_cmd_vtysh,
	"no debug ospf6 spf database",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug SPF Calculation\n"
	"Quit Logging number of LSAs at SPF Calculation time\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_spf_process_cmd_vtysh,
	"no debug ospf6 spf process",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Quit Debugging SPF Calculation\n"
	"Quit Debugging Detailed SPF Process\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_spf_time_cmd_vtysh,
	"no debug ospf6 spf time",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Quit Debugging SPF Calculation\n"
	"Quit Measuring time taken by SPF Calculation\n")

DEFSH (VTYSH_OSPF6D, no_debug_ospf6_zebra_sendrecv_cmd_vtysh,
	"no debug ospf6 zebra [<send|recv>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Debug connection between zebra\n"
	"Debug Sending zebra\n"
	"Debug Receiving zebra\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_cmd_vtysh,
	"no debug ospf",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_event_cmd_vtysh,
	"no debug ospf event",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF event information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_instance_event_cmd_vtysh,
	"no debug ospf (1-65535) event",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF event information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_instance_lsa_cmd_vtysh,
	"no debug ospf (1-65535) lsa [<generate|flooding|install|refresh|aggregate>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Link State Advertisement\n"
	"LSA Generation\n"
	"LSA Flooding\n"
	"LSA Install/Delete\n"
	"LSA Refres\n"
	"External LSA Aggregation\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_instance_nsm_cmd_vtysh,
	"no debug ospf (1-65535) nsm [<status|events|timers>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Neighbor State Machine\n"
	"NSM Status Information\n"
	"NSM Event Information\n"
	"NSM Timer Information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_instance_nssa_cmd_vtysh,
	"no debug ospf (1-65535) nssa",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF nssa information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_instance_zebra_cmd_vtysh,
	"no debug ospf (1-65535) zebra [<interface|redistribute>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"Zebra information\n"
	"Zebra interface\n"
	"Zebra redistribute\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_ism_cmd_vtysh,
	"no debug ospf [(1-65535)] ism [<status|events|timers>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF Interface State Machine\n"
	"ISM Status Information\n"
	"ISM Event Information\n"
	"ISM TImer Information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_lsa_cmd_vtysh,
	"no debug ospf lsa [<generate|flooding|install|refresh|aggregate>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF Link State Advertisement\n"
	"LSA Generation\n"
	"LSA Flooding\n"
	"LSA Install/Delete\n"
	"LSA Refres\n"
	"External LSA Aggregation\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_nsm_cmd_vtysh,
	"no debug ospf nsm [<status|events|timers>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF Neighbor State Machine\n"
	"NSM Status Information\n"
	"NSM Event Information\n"
	"NSM Timer Information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_nssa_cmd_vtysh,
	"no debug ospf nssa",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"OSPF nssa information\n")

DEFSH (VTYSH_OSPFD, no_debug_ospf_zebra_cmd_vtysh,
	"no debug ospf zebra [<interface|redistribute>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"OSPF information\n"
	"Zebra information\n"
	"Zebra interface\n"
	"Zebra redistribute\n")

DEFSH (VTYSH_PIMD, no_debug_pim_mlag_cmd_vtysh,
	"no debug pim mlag",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM Mlag activity\n")

DEFSH (VTYSH_PIMD, no_debug_pim_nht_rp_cmd_vtysh,
	"no debug pim nht rp",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"Nexthop Tracking\n"
	"RP Nexthop Tracking\n")

DEFSH (VTYSH_PIMD, no_debug_pim_static_cmd_vtysh,
	"no debug pim static",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM Static Multicast Route activity\n")

DEFSH (VTYSH_PIMD, no_debug_pim_vxlan_cmd_vtysh,
	"no debug pim vxlan",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"PIM protocol activity\n"
	"PIM VxLAN events\n")

DEFSH (VTYSH_RIPD, no_debug_rip_events_cmd_vtysh,
	"no debug rip events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIP information\n"
	"RIP events\n")

DEFSH (VTYSH_RIPD, no_debug_rip_packet_cmd_vtysh,
	"no debug rip packet",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIP information\n"
	"RIP packet\n")

DEFSH (VTYSH_RIPD, no_debug_rip_packet_direct_cmd_vtysh,
	"no debug rip packet <recv|send>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIP information\n"
	"RIP packet\n"
	"RIP option set for receive packet\n"
	"RIP option set for send packet\n")

DEFSH (VTYSH_RIPD, no_debug_rip_zebra_cmd_vtysh,
	"no debug rip zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIP information\n"
	"RIP and ZEBRA communication\n")

DEFSH (VTYSH_RIPNGD, no_debug_ripng_events_cmd_vtysh,
	"no debug ripng events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng events\n")

DEFSH (VTYSH_RIPNGD, no_debug_ripng_packet_cmd_vtysh,
	"no debug ripng packet",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng packet\n")

DEFSH (VTYSH_RIPNGD, no_debug_ripng_packet_direct_cmd_vtysh,
	"no debug ripng packet <recv|send>",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng packet\n"
	"Debug option set for receive packet\n"
	"Debug option set for send packet\n")

DEFSH (VTYSH_RIPNGD, no_debug_ripng_zebra_cmd_vtysh,
	"no debug ripng zebra",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"RIPng configuration\n"
	"Debug option set for ripng and zebra communication\n")

DEFSH (VTYSH_RMAP_SHOW, no_debug_rmap_cmd_vtysh,
	"no debug route-map [detail]$detail",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Debug option set for route-maps\n"
	"Detailed output\n")

DEFSH (VTYSH_BGPD, no_debug_rpki_cmd_vtysh,
	"no debug rpki",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Disable debugging for rpki\n")

DEFSH (VTYSH_PIMD, no_debug_ssmpingd_cmd_vtysh,
	"no debug ssmpingd",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"ssmpingd activity\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_dplane_cmd_vtysh,
	"no debug zebra dplane",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra dataplane events\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_events_cmd_vtysh,
	"no debug zebra events",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra events\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_fpm_cmd_vtysh,
	"no debug zebra fpm",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra FPM events\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_kernel_cmd_vtysh,
	"no debug zebra kernel",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra between kernel interface\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_kernel_msgdump_cmd_vtysh,
	"no debug zebra kernel msgdump [<recv|send>]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra between kernel interface\n"
	"Dump raw netlink messages, sent and received\n"
	"Dump raw netlink messages received\n"
	"Dump raw netlink messages sent\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_mpls_cmd_vtysh,
	"no debug zebra mpls [detailed]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra MPLS LSPs\n"
	"Debug option for zebra detailed info\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_nht_cmd_vtysh,
	"no debug zebra nht [detailed]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra next hop tracking\n"
	"Debug option set for detailed info\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_packet_cmd_vtysh,
	"no debug zebra packet [<recv|send>] [detail]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra packet\n"
	"Debug option set for receive packet\n"
	"Debug option set for send packet\n"
	"Debug option set for detailed info\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_pbr_cmd_vtysh,
	"no debug zebra pbr",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra pbr events\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_rib_cmd_vtysh,
	"no debug zebra rib [detailed]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug zebra RIB\n"
	"Detailed debugs\n")

DEFSH (VTYSH_ZEBRA, no_debug_zebra_vxlan_cmd_vtysh,
	"no debug zebra vxlan",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"Zebra configuration\n"
	"Debug option set for zebra VxLAN (EVPN)\n")

DEFSH (VTYSH_BGPD, no_dump_bgp_all_cmd_vtysh,
	"no dump bgp <all|all-et|updates|updates-et|routes-mrt> [PATH [INTERVAL]]",
	"Negate a command or set its defaults\n"
	"Stop dump packet\n"
	"Stop BGP packet dump\n"
	"Stop dump process all\n"
	"Stop dump process all-et\n"
	"Stop dump process updates\n"
	"Stop dump process updates-et\n"
	"Stop dump process route-mrt\n"
	"Output filename\n"
	"Interval of output\n")

DEFSH (VTYSH_BGPD, no_dup_addr_detection_cmd_vtysh,
	"no dup-addr-detection [max-moves (2-1000)$max_moves_val time (2-1800)$time_val | freeze <permanent$permanent_val | (30-3600)$freeze_time_val>]",
	"Negate a command or set its defaults\n"
	"Duplicate address detection\n"
	"Max allowed moves before address detected as duplicate\n"
	"Num of max allowed moves (2-1000) default 5\n"
	"Duplicate address detection time\n"
	"Time in seconds (2-1800) default 180\n"
	"Duplicate address detection freeze\n"
	"Duplicate address detection permanent freeze\n"
	"Duplicate address detection freeze time (30-3600)\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_authentication_keychain_cmd_vtysh,
	"no ip authentication key-chain eigrp (1-65535)$as [WORD]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Authentication subcommands\n"
	"Key-chain\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Name of key-chain\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_authentication_mode_cmd_vtysh,
	"no ip authentication mode eigrp (1-65535)$as [<md5|hmac-sha-256>]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Authentication subcommands\n"
	"Mode\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Keyed message digest\n"
	"HMAC SHA256 algorithm \n")

DEFSH (VTYSH_EIGRPD, no_eigrp_if_bandwidth_cmd_vtysh,
	"no eigrp bandwidth [(1-10000000)]",
	"Negate a command or set its defaults\n"
	"EIGRP information\n"
	"Set bandwidth informational parameter\n"
	"Bandwidth in kilobits\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_if_delay_cmd_vtysh,
	"no delay [(1-16777215)]",
	"Negate a command or set its defaults\n"
	"Specify interface throughput delay\n"
	"Throughput delay (tens of microseconds)\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_if_ip_hellointerval_cmd_vtysh,
	"no ip hello-interval eigrp [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Configures EIGRP hello interval\n"
	"EIGRP information\n"
	"Seconds between hello transmissions\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_if_ip_holdinterval_cmd_vtysh,
	"no ip hold-time eigrp [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Configures EIGRP IPv4 hold time\n"
	"EIGRP information\n"
	"Seconds before neighbor is considered down\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_ip_summary_address_cmd_vtysh,
	"no ip summary-address eigrp (1-65535)$as A.B.C.D/M$prefix",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"Perform address summarization\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Summary <network>/<length>, e.g. 192.168.0.0/16\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_maximum_paths_cmd_vtysh,
	"no maximum-paths [(1-32)]",
	"Negate a command or set its defaults\n"
	"Forward packets over multiple paths\n"
	"Number of paths\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_metric_weights_cmd_vtysh,
	"no metric weights [(0-255) (0-255) (0-255) (0-255) (0-255) (0-255)]",
	"Negate a command or set its defaults\n"
	"Modify metrics and parameters for advertisement\n"
	"Modify metric coefficients\n"
	"K1\n"
	"K2\n"
	"K3\n"
	"K4\n"
	"K5\n"
	"K6\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_router_id_cmd_vtysh,
	"no eigrp router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"EIGRP information\n"
	"Router ID for this EIGRP process\n"
	"EIGRP Router-ID in IP address format\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_timers_active_cmd_vtysh,
	"no timers active-time [<(1-65535)|disabled>]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"Time limit for active state\n"
	"Active state time limit in seconds\n"
	"Disable time limit for active state\n")

DEFSH (VTYSH_EIGRPD, no_eigrp_variance_cmd_vtysh,
	"no variance [(1-128)]",
	"Negate a command or set its defaults\n"
	"Control load balancing variance\n"
	"Metric variance multiplier\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, no_evpn_accept_bgp_seq_cmd_vtysh,
	"no evpn accept-bgp-seq",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Accept all sequence numbers from BGP\n")

DEFSH (VTYSH_BGPD, no_evpnrt5_network_cmd_vtysh,
	"no network <A.B.C.D/M|X:X::X:X/M> rd ASN:NN_OR_IP-ADDRESS:NN ethtag WORD label WORD esi WORD gwip <A.B.C.D|X:X::X:X>",
	"Negate a command or set its defaults\n"
	"Specify a network to announce via BGP\n"
	"IP prefix\n"
	"IPv6 prefix\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"Ethernet Tag\n"
	"Ethernet Tag Value\n"
	"BGP label\n"
	"label value\n"
	"Ethernet Segment Identifier\n"
	"ESI value ( 00:11:22:33:44:55:66:77:88:99 format) \n"
	"Gateway IP\n"
	"Gateway IP ( A.B.C.D )\n"
	"Gateway IPv6 ( X:X::X:X )\n")

DEFSH (VTYSH_ALL, no_exec_timeout_cmd_vtysh,
	"no exec-timeout",
	"Negate a command or set its defaults\n"
	"Set the EXEC timeout\n")

DEFSH (VTYSH_ISISD, no_flex_algo_cmd_vtysh,
	"no flex-algo (128-255)$algorithm",
	"Negate a command or set its defaults\n"
	"Flexible Algorithm\n"
	"Flexible Algorithm Number\n")

DEFSH (VTYSH_OSPFD, no_flood_reduction_area_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> flood-reduction",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Disable flood reduction for area\n")

DEFSH (VTYSH_OSPFD, no_flood_reduction_cmd_vtysh,
	"no flood-reduction",
	"Negate a command or set its defaults\n"
	"flood reduction feature\n")

DEFSH (VTYSH_ZEBRA, no_fpm_remote_ip_cmd_vtysh,
	"no fpm connection ip A.B.C.D port (1-65535)",
	"Negate a command or set its defaults\n"
	"Forwarding Path Manager\n"
	"Remove configured FPM connection\n"
	"Connect to IPv4 address\n"
	"Connect to IPv4 address\n"
	"TCP port number\n"
	"TCP port number\n")

DEFSH (VTYSH_ZEBRA, no_fpm_set_address_cmd_vtysh,
	"no fpm address [<A.B.C.D|X:X::X:X> [port <1-65535>]]",
	"Negate a command or set its defaults\n"
	"Forwarding Plane Manager configuration\n"
	"FPM remote listening server address\n"
	"Remote IPv4 FPM server\n"
	"Remote IPv6 FPM server\n"
	"FPM remote listening server port\n"
	"Remote FPM server port\n")

DEFSH (VTYSH_ZEBRA, no_fpm_use_nhg_cmd_vtysh,
	"no fpm use-next-hop-groups",
	"Negate a command or set its defaults\n"
	"Forwarding Plane Manager configuration\n"
	"Use netlink next hop groups feature.\n")

DEFSH (VTYSH_ZEBRA, no_fpm_use_route_replace_cmd_vtysh,
	"no fpm use-route-replace",
	"Negate a command or set its defaults\n"
	"Forwarding Plane Manager configuration\n"
	"Use netlink route replace semantics\n")

DEFSH (VTYSH_OSPFD, no_graceful_restart_cmd_vtysh,
	"no graceful-restart [grace-period (1-1800)]",
	"Negate a command or set its defaults\n"
	"OSPF non-stop forwarding (NSF) also known as OSPF Graceful Restart\n"
	"Maximum length of the 'grace period'\n"
	"Maximum length of the 'grace period' in seconds\n")

DEFSH (VTYSH_MGMTD, no_if_ipv4_route_map_cmd_vtysh,
	"no route-map [ROUTE-MAP] <in$in|out> IFNAME",
	"Negate a command or set its defaults\n"
	"Route map set\n"
	"Route map name\n"
	"Route map set for input filtering\n"
	"Route map set for output filtering\n"
	"Interface information\n")

DEFSH (VTYSH_MGMTD, no_if_ipv6_route_map_cmd_vtysh,
	"no route-map [ROUTE-MAP] <in$in|out> IFNAME",
	"Negate a command or set its defaults\n"
	"Route map set\n"
	"Route map name\n"
	"Route map set for input filtering\n"
	"Route map set for output filtering\n"
	"Interface information\n")

DEFSH (VTYSH_INTERFACE, no_interface_cmd_vtysh,
	"no interface IFNAME [vrf NAME$vrf_name]",
	"Negate a command or set its defaults\n"
	"Delete a pseudo interface's configuration\n"
	"Interface's name\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_INTERFACE, no_interface_desc_cmd_vtysh,
	"no description",
	"Negate a command or set its defaults\n"
	"Interface specific description\n")

DEFSH (VTYSH_PIMD, no_interface_ip_igmp_limits_cmd_vtysh,
	"no ip igmp <max-sources$do_src|max-groups$do_grp>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable IGMP operation\n"
	"Limit number of IGMPv3 sources to track\n"
	"Limit number of IGMP group memberships to track\n")

DEFSH (VTYSH_PIM6D, no_interface_ipv6_mld_limits_cmd_vtysh,
	"no ipv6 mld <max-sources$do_src|max-groups$do_grp>",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable MLD operation\n"
	"Limit number of MLDv2 sources to track\n"
	"Limit number of MLD group memberships to track\n")

DEFSH (VTYSH_PIMD, no_ip_igmp_group_watermark_cmd_vtysh,
	"no ip igmp watermark-warn [(1-65535)$limit]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"IGMP information\n"
	"Unconfigure group limit for watermark warning\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_msdp_mesh_group_cmd_vtysh,
	"no ip msdp mesh-group WORD$gname",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group\n"
	"Mesh group name\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_msdp_mesh_group_member_cmd_vtysh,
	"no ip msdp mesh-group WORD$gname member A.B.C.D$maddr",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group member\n"
	"Mesh group name\n"
	"Mesh group member\n"
	"Peer IP address\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_msdp_mesh_group_source_cmd_vtysh,
	"no ip msdp mesh-group WORD$gname source [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group source\n"
	"Mesh group name\n"
	"Mesh group source\n"
	"Mesh group local address\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_msdp_peer_cmd_vtysh,
	"no ip msdp peer A.B.C.D",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP peer\n"
	"peer ip address\n")

DEFSH (VTYSH_PIMD, no_ip_msdp_peer_sa_filter_cmd_vtysh,
	"no msdp peer A.B.C.D$peer sa-filter ACL_NAME <in|out>$dir",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"MSDP Peer address\n"
	"SA access-list filter\n"
	"SA access-list name\n"
	"Filter incoming SAs\n"
	"Filter outgoing SAs\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_msdp_timers_cmd_vtysh,
	"no ip msdp timers [(1-65535) (1-65535) [(1-65535)]]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Configure multicast source discovery protocol\n"
	"MSDP timers configuration\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_area_cmd_vtysh,
	"no ip ospf [(1-65535)] area [<A.B.C.D|(0-4294967295)> [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Instance ID\n"
	"Disable OSPF on this interface\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_authentication_addr_cmd_vtysh,
	"no ip ospf authentication [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Enable authentication on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_authentication_args_addr_cmd_vtysh,
	"no ip ospf authentication <null|message-digest|key-chain [KEYCHAIN_NAME]> [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Enable authentication on this interface\n"
	"Use null authentication\n"
	"Use message-digest authentication\n"
	"Use a key-chain for cryptographic authentication keys\n"
	"Key-chain name\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_authentication_key_authkey_addr_cmd_vtysh,
	"no ip ospf authentication-key [AUTH_KEY [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_bfd_cmd_vtysh,
	"no ip ospf bfd",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Disables BFD support\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_bfd_prof_cmd_vtysh,
	"no ip ospf bfd profile [BFDPROF]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Enables BFD support\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_cost_cmd_vtysh,
	"no ip ospf cost [(1-65535)] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Interface cost\n"
	"Cost\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_dead_interval_cmd_vtysh,
	"no ip ospf dead-interval [<(1-65535)|minimal hello-multiplier [(2-20)]> [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n"
	"Minimal 1s dead-interval with fast sub-second hellos\n"
	"Hello multiplier factor\n"
	"Number of Hellos to send each second\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_gr_hdelay_cmd_vtysh,
	"no ip ospf graceful-restart hello-delay [(1-1800)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"OSPF interface commands\n"
	"Graceful Restart parameters\n"
	"Delay the sending of the first hello packets.\n"
	"Delay in seconds\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_hello_interval_cmd_vtysh,
	"no ip ospf hello-interval [(1-65535) [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_message_digest_key_cmd_vtysh,
	"no ip ospf message-digest-key (1-255) [md5 KEY] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_mtu_ignore_addr_cmd_vtysh,
	"no ip ospf mtu-ignore [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Disable MTU mismatch detection on this interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_network_cmd_vtysh,
	"no ip ospf network [<broadcast|non-broadcast|point-to-multipoint|point-to-point>]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Network type\n"
	"Specify OSPF broadcast multi-access network\n"
	"Specify OSPF NBMA network\n"
	"Specify OSPF point-to-multipoint network\n"
	"Specify OSPF point-to-point network\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_passive_cmd_vtysh,
	"no ip ospf passive [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Enable routing updates on an interface\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_priority_cmd_vtysh,
	"no ip ospf priority [(0-255) [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Router priority\n"
	"Priority\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_retransmit_interval_addr_cmd_vtysh,
	"no ip ospf retransmit-interval [(1-65535)] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ip_ospf_transmit_delay_addr_cmd_vtysh,
	"no ip ospf transmit-delay [(1-65535)] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"IP Information\n"
	"OSPF interface commands\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_PIMD, no_ip_pim_bfd_cmd_vtysh,
	"no ip pim bfd",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Disables BFD support\n")

DEFSH (VTYSH_PIMD, no_ip_pim_bfd_profile_cmd_vtysh,
	"no ip pim bfd profile [BFDPROF]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Enables BFD support\n"
	"Disable BFD profile\n"
	"BFD Profile name\n")

DEFSH (VTYSH_PIMD, no_ip_pim_bsm_cmd_vtysh,
	"no ip pim bsm",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Enable BSM support on the interface\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_ecmp_cmd_vtysh,
	"no ip pim ecmp",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Disable PIM ECMP \n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_ecmp_rebalance_cmd_vtysh,
	"no ip pim ecmp rebalance",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Disable PIM ECMP \n"
	"Disable PIM ECMP Rebalance\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_joinprune_time_cmd_vtysh,
	"no ip pim join-prune-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Join Prune Send Interval\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_keep_alive_cmd_vtysh,
	"no ip pim keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_mlag_cmd_vtysh,
	"no ip pim mlag",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"MLAG\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_packets_cmd_vtysh,
	"no ip pim packets [(1-255)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"packets to process at one time per fd\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_register_suppress_cmd_vtysh,
	"no ip pim register-suppress-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Register Suppress Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_rp_cmd_vtysh,
	"no ip pim rp A.B.C.D$rp [A.B.C.D/M]$gp",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"Group Address range to cover\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_rp_keep_alive_cmd_vtysh,
	"no ip pim rp keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_rp_prefix_list_cmd_vtysh,
	"no ip pim rp A.B.C.D$rp prefix-list PREFIXLIST4_NAME$plist",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_spt_switchover_infinity_cmd_vtysh,
	"no ip pim spt-switchover infinity-and-beyond",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_spt_switchover_infinity_plist_cmd_vtysh,
	"no ip pim spt-switchover infinity-and-beyond prefix-list PREFIXLIST4_NAME",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_ssm_prefix_list_cmd_vtysh,
	"no ip pim ssm prefix-list",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Source Specific Multicast\n"
	"group range prefix-list filter\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_ssm_prefix_list_name_cmd_vtysh,
	"no ip pim ssm prefix-list PREFIXLIST4_NAME$plist",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Source Specific Multicast\n"
	"group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, no_ip_pim_ucast_bsm_cmd_vtysh,
	"no ip pim unicast-bsm",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Accept/Send unicast BSM on the interface\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_pim_v6_secondary_cmd_vtysh,
	"no ip pim send-v6-secondary",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"PIM information\n"
	"Send v6 secondary addresses\n")

DEFSH (VTYSH_ACL_CONFIG, no_ip_prefix_list_all_cmd_vtysh,
	"no ip prefix-list PREFIXLIST4_NAME$name",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n")

DEFSH (VTYSH_ACL_CONFIG, no_ip_prefix_list_cmd_vtysh,
	"no ip prefix-list PREFIXLIST4_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <any|A.B.C.D/M$prefix [{ge (0-32)|le (0-32)}]>",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Any prefix match.  Same as \"0.0.0.0/0 le 32\"\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n"
	"Minimum prefix length to be matched\n"
	"Minimum prefix length\n"
	"Maximum prefix length to be matched\n"
	"Maximum prefix length\n")

DEFSH (VTYSH_ACL_CONFIG, no_ip_prefix_list_remark_cmd_vtysh,
	"no ip prefix-list PREFIXLIST4_NAME$name description",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n")

DEFSH (VTYSH_ACL_CONFIG, no_ip_prefix_list_remark_line_cmd_vtysh,
	"no ip prefix-list PREFIXLIST4_NAME$name description LINE...",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_ACL_CONFIG, no_ip_prefix_list_seq_cmd_vtysh,
	"no ip prefix-list PREFIXLIST4_NAME$name seq (1-4294967295)$seq",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_authentication_key_chain_cmd_vtysh,
	"no ip rip authentication key-chain [LINE]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication key-chain\n"
	"name of key-chain\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_authentication_mode_cmd_vtysh,
	"no ip rip authentication mode [<md5 [auth-length <rfc|old-ripd>]|text>]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication mode\n"
	"Keyed message digest\n"
	"MD5 authentication data length\n"
	"RFC compatible\n"
	"Old ripd compatible\n"
	"Clear text authentication\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_authentication_string_cmd_vtysh,
	"no ip rip authentication string [LINE]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Authentication control\n"
	"Authentication string\n"
	"Authentication string\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_bfd_profile_cmd_vtysh,
	"no ip rip bfd profile",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Enable BFD support\n"
	"Use a pre-configured profile\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_receive_version_cmd_vtysh,
	"no ip rip receive version [<{1|2}|none>]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Advertisement reception\n"
	"Version control\n"
	"RIP version 1\n"
	"RIP version 2\n"
	"None\n")

DEFSH (VTYSH_MGMTD, no_ip_rip_send_version_cmd_vtysh,
	"no ip rip send version [<{1|2}|none>]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Routing Information Protocol\n"
	"Advertisement transmission\n"
	"Version control\n"
	"RIP version 1\n"
	"RIP version 2\n"
	"None\n")

DEFSH (VTYSH_ISISD, no_ip_router_isis_cmd_vtysh,
	"no <ip|ipv6>$ip router isis [WORD]$tag",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n")

DEFSH_HIDDEN (VTYSH_ISISD, no_ip_router_isis_vrf_cmd_vtysh,
	"no <ip|ipv6>$ip router isis WORD$tag vrf NAME$vrf_name",
	"Negate a command or set its defaults\n"
	"Interface Internet Protocol config commands\n"
	"IP router interface commands\n"
	"IP router interface commands\n"
	"IS-IS routing protocol\n"
	"Routing process tag\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_ip_ssmpingd_cmd_vtysh,
	"no ip ssmpingd [A.B.C.D]$src",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_ZEBRA, no_ip_zebra_import_table_cmd_vtysh,
	"no ip import-table (1-252)$table_id [mrib]$mrib [distance (1-255)] [route-map NAME]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"import routes from non-main kernel table\n"
	"kernel routing table id\n"
	"Import into the MRIB instead of the URIB\n"
	"Distance for imported routes\n"
	"Default distance value\n"
	"route-map for filtering\n"
	"route-map name\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_access_list_all_cmd_vtysh,
	"no ipv6 access-list ACCESSLIST6_NAME$name",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_access_list_cmd_vtysh,
	"no ipv6 access-list ACCESSLIST6_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <X:X::X:X/M$prefix [exact-match$exact]|any>",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"IPv6 prefix\n"
	"Exact match of the prefixes\n"
	"Match any IPv6\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_access_list_remark_cmd_vtysh,
	"no ipv6 access-list ACCESSLIST6_NAME$name remark",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_access_list_remark_line_cmd_vtysh,
	"no ipv6 access-list ACCESSLIST6_NAME$name remark LINE...",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_BGPD, no_ipv6_bgp_distance_source_access_list_cmd_vtysh,
	"no distance (1-255) X:X::X:X/M WORD",
	"Negate a command or set its defaults\n"
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n"
	"Access list name\n")

DEFSH (VTYSH_BGPD, no_ipv6_bgp_distance_source_cmd_vtysh,
	"no distance (1-255) X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"Define an administrative distance\n"
	"Administrative distance\n"
	"IP source prefix\n")

DEFSH (VTYSH_PIM6D, no_ipv6_mld_group_watermark_cmd_vtysh,
	"no ipv6 mld watermark-warn [(1-65535)$limit]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"MLD information\n"
	"Unconfigure group limit for watermark warning\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_advertise_prefix_list_cmd_vtysh,
	"no ipv6 ospf6 advertise prefix-list [PREFIXLIST6_NAME]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Advertising options\n"
	"Filter prefix using prefix-list\n"
	"Prefix list name\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_area_cmd_vtysh,
	"no ipv6 ospf6 area [<A.B.C.D|(0-4294967295)>]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the OSPF6 area ID\n"
	"OSPF6 area ID in IPv4 address notation\n"
	"OSPF6 area ID in decimal notation\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_bfd_cmd_vtysh,
	"no ipv6 ospf6 bfd",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Disables BFD support\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_bfd_profile_cmd_vtysh,
	"no ipv6 ospf6 bfd profile [BFDPROF]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"BFD support\n"
	"BFD Profile selection\n"
	"BFD Profile name\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_cost_cmd_vtysh,
	"no ipv6 ospf6 cost [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Calculate interface cost from bandwidth\n"
	"Outgoing metric of this interface\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_deadinterval_cmd_vtysh,
	"no ipv6 ospf6 dead-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_gr_hdelay_cmd_vtysh,
	"no ipv6 ospf6 graceful-restart hello-delay [(1-1800)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Graceful Restart parameters\n"
	"Delay the sending of the first hello packets.\n"
	"Delay in seconds\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_hellointerval_cmd_vtysh,
	"no ipv6 ospf6 hello-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Time between HELLO packets\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_ifmtu_cmd_vtysh,
	"no ipv6 ospf6 ifmtu [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Interface MTU\n"
	"OSPFv3 Interface MTU\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_instance_cmd_vtysh,
	"no ipv6 ospf6 instance-id [(0-255)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Instance ID for this interface\n"
	"Instance ID value\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_intf_auth_trailer_key_cmd_vtysh,
	"no ipv6 ospf6 authentication key-id [(1-65535) hash-algo <md5|hmac-sha-1|hmac-sha-256|hmac-sha-384|hmac-sha-512> key WORD]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Authentication\n"
	"Key ID\n"
	"Key ID value\n"
	"Cryptographic-algorithm\n"
	"Use MD5 algorithm\n"
	"Use HMAC-SHA-1 algorithm\n"
	"Use HMAC-SHA-256 algorithm\n"
	"Use HMAC-SHA-384 algorithm\n"
	"Use HMAC-SHA-512 algorithm\n"
	"Password\n"
	"Password string (key)\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_intf_auth_trailer_keychain_cmd_vtysh,
	"no ipv6 ospf6 authentication keychain [KEYCHAIN_NAME]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Enable authentication on this interface\n"
	"Keychain\n"
	"Keychain name\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_mtu_ignore_cmd_vtysh,
	"no ipv6 ospf6 mtu-ignore",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Disable MTU mismatch detection on this interface\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_network_cmd_vtysh,
	"no ipv6 ospf6 network [<broadcast|point-to-point|point-to-multipoint>]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Set default network type\n"
	"Specify OSPF6 broadcast network\n"
	"Specify OSPF6 point-to-point network\n"
	"Specify OSPF6 point-to-multipoint network\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_p2xp_connected_pfx_cmd_vtysh,
	"no ipv6 ospf6 p2p-p2mp connected-prefixes",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Point-to-point and Point-to-Multipoint parameters\n"
	"Adjust handling of directly connected prefixes\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_passive_cmd_vtysh,
	"no ipv6 ospf6 passive",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"passive interface: No Adjacency will be formed on this I/F\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_priority_cmd_vtysh,
	"no ipv6 ospf6 priority [(0-255)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Router priority\n"
	"Priority value\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_retransmitinterval_cmd_vtysh,
	"no ipv6 ospf6 retransmit-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n")

DEFSH (VTYSH_OSPF6D, no_ipv6_ospf6_transmitdelay_cmd_vtysh,
	"no ipv6 ospf6 transmit-delay [(1-3600)]",
	"Negate a command or set its defaults\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Link state transmit delay\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, no_ipv6_pim_bsm_cmd_vtysh,
	"no ipv6 pim bsm",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Enable BSM support on the interface\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_joinprune_time_cmd_vtysh,
	"no ipv6 pim join-prune-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Join Prune Send Interval\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_keep_alive_cmd_vtysh,
	"no ipv6 pim keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_packets_cmd_vtysh,
	"no ipv6 pim packets [(1-255)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"packets to process at one time per fd\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_register_suppress_cmd_vtysh,
	"no ipv6 pim register-suppress-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Register Suppress Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_rp_cmd_vtysh,
	"no ipv6 pim rp X:X::X:X$rp [X:X::X:X/M]$gp",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"Group Address range to cover\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_rp_keep_alive_cmd_vtysh,
	"no ipv6 pim rp keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_rp_prefix_list_cmd_vtysh,
	"no ipv6 pim rp X:X::X:X$rp prefix-list PREFIXLIST6_NAME$plist",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_spt_switchover_infinity_cmd_vtysh,
	"no ipv6 pim spt-switchover infinity-and-beyond",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_pim_spt_switchover_infinity_plist_cmd_vtysh,
	"no ipv6 pim spt-switchover infinity-and-beyond prefix-list PREFIXLIST6_NAME",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIM6D, no_ipv6_pim_ucast_bsm_cmd_vtysh,
	"no ipv6 pim unicast-bsm",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"PIM information\n"
	"Accept/Send unicast BSM on the interface\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_prefix_list_all_cmd_vtysh,
	"no ipv6 prefix-list PREFIXLIST6_NAME$name",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_prefix_list_cmd_vtysh,
	"no ipv6 prefix-list PREFIXLIST6_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <any|X:X::X:X/M$prefix [{ge (0-128)$ge|le (0-128)$le}]>",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"Any prefix match.  Same as \"::0/0 le 128\"\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n"
	"Maximum prefix length to be matched\n"
	"Maximum prefix length\n"
	"Minimum prefix length to be matched\n"
	"Minimum prefix length\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_prefix_list_remark_cmd_vtysh,
	"no ipv6 prefix-list PREFIXLIST6_NAME$name description",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_prefix_list_remark_line_cmd_vtysh,
	"no ipv6 prefix-list PREFIXLIST6_NAME$name description LINE...",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_ACL_CONFIG, no_ipv6_prefix_list_seq_cmd_vtysh,
	"no ipv6 prefix-list PREFIXLIST6_NAME$name seq (1-4294967295)$seq",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Prefix list entry name\n"
	"Sequence number of an entry\n"
	"Sequence number\n")

DEFSH_HIDDEN (VTYSH_PIM6D, no_ipv6_ssmpingd_cmd_vtysh,
	"no ipv6 ssmpingd [X:X::X:X]$source",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_ISISD, no_is_type_cmd_vtysh,
	"no is-type [<level-1|level-1-2|level-2-only>]",
	"Negate a command or set its defaults\n"
	"IS Level for this routing process (OSI only)\n"
	"Act as a station router only\n"
	"Act as both a station router and an area router\n"
	"Act as an area router only\n")

DEFSH (VTYSH_ISISD, no_isis_circuit_type_cmd_vtysh,
	"no isis circuit-type [level-1|level-1-2|level-2-only]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Configure circuit type for interface\n"
	"Level-1 only adjacencies are formed\n"
	"Level-1-2 adjacencies are formed\n"
	"Level-2 only adjacencies are formed\n")

DEFSH (VTYSH_ISISD, no_isis_frr_remote_lfa_plist_cmd_vtysh,
	"no fast-reroute remote-lfa prefix-list [WORD] [<level-1|level-2>$level]",
	"Negate a command or set its defaults\n"
	"Configure Fast ReRoute\n"
	"Enable remote LFA related configuration\n"
	"Filter PQ node router ID based on prefix list\n"
	"Prefix-list name\n"
	"Enable router ID filtering for level-1 only\n"
	"Enable router ID filtering for level-2 only\n")

DEFSH (VTYSH_ISISD, no_isis_hello_interval_cmd_vtysh,
	"no isis hello-interval [level-1|level-2]$level [(1-600)]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set Hello interval\n"
	"Specify hello-interval for level-1 IIHs\n"
	"Specify hello-interval for level-2 IIHs\n"
	"Holdtime 1 second, interval depends on multiplier\n")

DEFSH (VTYSH_ISISD, no_isis_hello_multiplier_cmd_vtysh,
	"no isis hello-multiplier [level-1|level-2]$level [(2-100)]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set multiplier for Hello holding time\n"
	"Specify hello multiplier for level-1 IIHs\n"
	"Specify hello multiplier for level-2 IIHs\n"
	"Hello multiplier value\n")

DEFSH (VTYSH_ISISD, no_isis_metric_cmd_vtysh,
	"no isis metric [level-1|level-2]$level [(0-16777215)]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set default metric for circuit\n"
	"Specify metric for level-1 routing\n"
	"Specify metric for level-2 routing\n"
	"Default metric value\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_if_ldp_sync_holddown_cmd_vtysh,
	"no isis mpls ldp-sync holddown [<(1-10000)>]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"MPLS information\n"
	"Disable MPLS LDP-SYNC\n"
	"holddown timer disable\n"
	"Time in seconds\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_ldp_sync_cmd_vtysh,
	"no mpls ldp-sync",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Disable MPLS LDP-SYNC\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_ldp_sync_holddown_cmd_vtysh,
	"no mpls ldp-sync holddown [<(1-10000)>]",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Enable MPLS LDP-SYNC\n"
	"holddown timer disable\n"
	"Time in seconds\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_te_export_cmd_vtysh,
	"no mpls-te export",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Disable export of MPLS-TE  Link State information\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_te_on_cmd_vtysh,
	"no mpls-te [on]",
	"Negate a command or set its defaults\n"
	"Disable the MPLS-TE functionality\n"
	"Disable the MPLS-TE functionality\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_te_router_addr_cmd_vtysh,
	"no mpls-te router-address [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Delete IP address of the advertising router\n"
	"MPLS-TE router address in IPv4 address format\n")

DEFSH (VTYSH_ISISD, no_isis_mpls_te_router_addr_v6_cmd_vtysh,
	"no mpls-te router-address ipv6 [X:X::X:X]",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Delete IP address of the advertising router\n"
	"IPv6 address\n"
	"MPLS-TE router address in IPv6 address format\n")

DEFSH (VTYSH_ISISD, no_isis_passwd_cmd_vtysh,
	"no isis password [<md5|clear> WORD]",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Configure the authentication password for a circuit\n"
	"HMAC-MD5 authentication\n"
	"Cleartext password\n"
	"Circuit password\n")

DEFSH (VTYSH_ISISD, no_isis_priority_cmd_vtysh,
	"no isis priority [(0-127)] [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set priority for Designated Router election\n"
	"Priority value\n"
	"Specify priority for level-1 routing\n"
	"Specify priority for level-2 routing\n")

DEFSH (VTYSH_ISISD, no_isis_sr_enable_cmd_vtysh,
	"no segment-routing [on]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Disable Segment Routing\n")

DEFSH (VTYSH_ISISD, no_isis_sr_global_block_label_range_cmd_vtysh,
	"no segment-routing global-block [(16-1048575) (16-1048575) local-block (16-1048575) (16-1048575)]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Segment Routing Global Block label range\n"
	"The lower bound of the global block\n"
	"The upper bound of the global block (block size may not exceed 65535)\n"
	"Segment Routing Local Block label range\n"
	"The lower bound of the local block\n"
	"The upper bound of the local block (block size may not exceed 65535)\n")

DEFSH (VTYSH_ISISD, no_isis_sr_node_msd_cmd_vtysh,
	"no segment-routing node-msd [(1-16)]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Maximum Stack Depth for this router\n"
	"Maximum number of label that can be stack (1-16)\n")

DEFSH (VTYSH_ISISD, no_isis_sr_prefix_sid_algorithm_cmd_vtysh,
	"no segment-routing prefix <A.B.C.D/M|X:X::X:X/M>$prefix              algorithm (128-255)$algorithm              [<absolute$sid_type (16-1048575)|index (0-65535)> [<no-php-flag|explicit-null>]]              [n-flag-clear]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n"
	"Algorithm Specific Prefix SID Configuration\n"
	"Algorithm number\n"
	"Specify the absolute value of Prefix Segment ID\n"
	"The Prefix Segment ID value\n"
	"Specify the index of Prefix Segment ID\n"
	"The Prefix Segment ID index\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n"
	"Not a node SID\n")

DEFSH (VTYSH_ISISD, no_isis_sr_prefix_sid_cmd_vtysh,
	"no segment-routing prefix <A.B.C.D/M|X:X::X:X/M>$prefix         [<absolute$sid_type (16-1048575)|index (0-65535)> [<no-php-flag|explicit-null>]]	 [n-flag-clear]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix\n"
	"IPv6 Prefix\n"
	"Specify the absolute value of Prefix Segment ID\n"
	"The Prefix Segment ID value\n"
	"Specify the index of Prefix Segment ID\n"
	"The Prefix Segment ID index\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n"
	"Not a node SID\n")

DEFSH (VTYSH_ISISD, no_isis_srv6_enable_cmd_vtysh,
	"no segment-routing srv6",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Disable Segment Routing over IPv6 (SRv6)\n")

DEFSH (VTYSH_KEYS, no_key_chain_cmd_vtysh,
	"no key chain WORD",
	"Negate a command or set its defaults\n"
	"Authentication key management\n"
	"Key-chain management\n"
	"Key-chain name\n")

DEFSH (VTYSH_KEYS, no_key_cmd_vtysh,
	"no key (0-2147483647)",
	"Negate a command or set its defaults\n"
	"Delete a key\n"
	"Key identifier number\n")

DEFSH (VTYSH_KEYS, no_key_string_cmd_vtysh,
	"no key-string [LINE]",
	"Negate a command or set its defaults\n"
	"Unset key string\n"
	"The key\n")

DEFSH (VTYSH_LDPD, no_ldp_address_family_cmd_vtysh,
	"no address-family <ipv4|ipv6>$af",
	"Negate a command or set its defaults\n"
	"Configure Address Family and its parameters\n"
	"IPv4\n"
	"IPv6\n")

DEFSH (VTYSH_LDPD, no_ldp_interface_cmd_vtysh,
	"no interface IFNAME$ifname",
	"Negate a command or set its defaults\n"
	"Enable LDP on an interface and enter interface submode\n"
	"Interface's name\n")

DEFSH (VTYSH_LDPD, no_ldp_l2vpn_cmd_vtysh,
	"no l2vpn WORD$l2vpn_name type vpls",
	"Negate a command or set its defaults\n"
	"Configure l2vpn commands\n"
	"L2VPN name\n"
	"L2VPN type\n"
	"Virtual Private LAN Service\n")

DEFSH (VTYSH_LDPD, no_ldp_member_pseudowire_cmd_vtysh,
	"no member pseudowire IFNAME$ifname",
	"Negate a command or set its defaults\n"
	"L2VPN member configuration\n"
	"Pseudowire interface\n"
	"Interface's name\n")

DEFSH (VTYSH_LDPD, no_ldp_mpls_ldp_cmd_vtysh,
	"no mpls ldp",
	"Negate a command or set its defaults\n"
	"Global MPLS configuration subcommands\n"
	"Label Distribution Protocol\n")

DEFSH (VTYSH_MGMTD, no_link_params_cmd_vtysh,
	"no link-params",
	"Negate a command or set its defaults\n"
	"Configure interface link parameters\n")

DEFSH (VTYSH_ZEBRA, no_locator_sid_format_cmd_vtysh,
	"no format [WORD]",
	"Negate a command or set its defaults\n"
	"Configure SRv6 SID format\n"
	"Specify SRv6 SID format\n")

DEFSH (VTYSH_ISISD, no_lsp_gen_interval_cmd_vtysh,
	"no lsp-gen-interval [level-1|level-2]$level [(1-120)]",
	"Negate a command or set its defaults\n"
	"Minimum interval between regenerating same LSP\n"
	"Set interval for level 1 only\n"
	"Set interval for level 2 only\n"
	"Minimum interval in seconds\n")

DEFSH (VTYSH_ISISD, no_lsp_refresh_interval_cmd_vtysh,
	"no lsp-refresh-interval [level-1|level-2]$level [(1-65235)]",
	"Negate a command or set its defaults\n"
	"LSP refresh interval\n"
	"LSP refresh interval for Level 1 only\n"
	"LSP refresh interval for Level 2 only\n"
	"LSP refresh interval in seconds\n")

DEFSH (VTYSH_ISISD, no_lsp_timers_cmd_vtysh,
	"no lsp-timers [level-1|level-2]$level [gen-interval (1-120) refresh-interval (1-65235) max-lifetime (350-65535)]",
	"Negate a command or set its defaults\n"
	"LSP-related timers\n"
	"LSP-related timers for Level 1 only\n"
	"LSP-related timers for Level 2 only\n"
	"Minimum interval between regenerating same LSP\n"
	"Generation interval in seconds\n"
	"LSP refresh interval\n"
	"LSP refresh interval in seconds\n"
	"Maximum LSP lifetime\n"
	"Maximum LSP lifetime in seconds\n")

DEFSH (VTYSH_ACL_CONFIG, no_mac_access_list_all_cmd_vtysh,
	"no mac access-list ACCESSLIST_MAC_NAME$name",
	"Negate a command or set its defaults\n"
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n")

DEFSH (VTYSH_ACL_CONFIG, no_mac_access_list_cmd_vtysh,
	"no mac access-list ACCESSLIST_MAC_NAME$name [seq (1-4294967295)$seq] <deny|permit>$action <X:X:X:X:X:X$mac|any>",
	"Negate a command or set its defaults\n"
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n"
	"Sequence number of an entry\n"
	"Sequence number\n"
	"Specify packets to reject\n"
	"Specify packets to forward\n"
	"MAC address\n"
	"Match any MAC address\n")

DEFSH (VTYSH_ACL_CONFIG, no_mac_access_list_remark_cmd_vtysh,
	"no mac access-list ACCESSLIST_MAC_NAME$name remark",
	"Negate a command or set its defaults\n"
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n")

DEFSH (VTYSH_ACL_CONFIG, no_mac_access_list_remark_line_cmd_vtysh,
	"no mac access-list ACCESSLIST_MAC_NAME$name remark LINE...",
	"Negate a command or set its defaults\n"
	"MAC address\n"
	"Access list entry\n"
	"Access list name\n"
	"Access list entry comment\n"
	"Comment up to 100 characters\n")

DEFSH (VTYSH_BGPD, no_macvrf_soo_global_cmd_vtysh,
	"no mac-vrf soo [ASN:NN_OR_IP-ADDRESS:NN$soo]",
	"Negate a command or set its defaults\n"
	"EVPN MAC-VRF\n"
	"Site-of-Origin extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, no_match_alias_cmd_vtysh,
	"no match alias [ALIAS_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP community alias name\n"
	"BGP community alias name\n")

DEFSH (VTYSH_BGPD, no_match_aspath_cmd_vtysh,
	"no match as-path [AS_PATH_FILTER_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP AS path list\n"
	"AS path access-list name\n")

DEFSH (VTYSH_BGPD, no_match_community_cmd_vtysh,
	"no match community [<(1-99)|(100-500)|COMMUNITY_LIST_NAME> [<exact-match$exact|any$any>]]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP community list\n"
	"Community-list number (standard)\n"
	"Community-list number (expanded)\n"
	"Community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, no_match_ecommunity_cmd_vtysh,
	"no match extcommunity [<(1-99)|(100-500)|EXTCOMMUNITY_LIST_NAME> [<exact-match$exact|any$any>]]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP/VPN extended community list\n"
	"Extended community-list number (standard)\n"
	"Extended community-list number (expanded)\n"
	"Extended community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, no_match_evpn_default_route_cmd_vtysh,
	"no match evpn default-route",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"default EVPN type-5 route\n")

DEFSH (VTYSH_BGPD, no_match_evpn_rd_cmd_vtysh,
	"no match evpn rd ASN:NN_OR_IP-ADDRESS:NN",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n")

DEFSH (VTYSH_BGPD, no_match_evpn_route_type_cmd_vtysh,
	"no match evpn route-type <ead|1|macip|2|multicast|3|es|4|prefix|5>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n")

DEFSH (VTYSH_BGPD, no_match_evpn_vni_cmd_vtysh,
	"no match evpn vni (1-16777215)",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Ethernet Virtual Private Network\n"
	"Match VNI\n"
	"VNI ID\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_interface_cmd_vtysh,
	"no match interface [IFNAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match first hop interface of route\n"
	"Interface information\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ip_address_cmd_vtysh,
	"no match ip address [ACCESSLIST4_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_MGMTD, no_match_ip_address_prefix_len_cmd_vtysh,
	"no match ip address prefix-len [(0-32)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match prefix length of IP address\n"
	"Match prefix length of IP address\n"
	"Prefix length\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ip_address_prefix_list_cmd_vtysh,
	"no match ip address prefix-list [PREFIXLIST4_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ip_next_hop_cmd_vtysh,
	"no match ip next-hop [ACCESSLIST4_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ip_next_hop_prefix_list_cmd_vtysh,
	"no match ip next-hop prefix-list [PREFIXLIST4_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match next-hop address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ip_next_hop_type_cmd_vtysh,
	"no match ip next-hop type [<blackhole>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match next-hop address of route\n"
	"Match entries by type\n"
	"Blackhole\n")

DEFSH (VTYSH_MGMTD, no_match_ip_nexthop_prefix_len_cmd_vtysh,
	"no match ip next-hop prefix-len [(0-32)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match prefixlen of nexthop IP address\n"
	"Match prefix length of nexthop\n"
	"Prefix length\n")

DEFSH (VTYSH_BGPD, no_match_ip_route_source_cmd_vtysh,
	"no match ip route-source [ACCESSLIST4_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match advertising source address of route\n"
	"IP Access-list name\n")

DEFSH (VTYSH_BGPD, no_match_ip_route_source_prefix_list_cmd_vtysh,
	"no match ip route-source prefix-list [PREFIXLIST_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match advertising source address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_BGPD, no_match_ipv4_next_hop_cmd_vtysh,
	"no match ip next-hop address [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Match IP next-hop address of route\n"
	"IP address\n"
	"IP address of next-hop\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ipv6_address_cmd_vtysh,
	"no match ipv6 address [ACCESSLIST6_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 address of route\n"
	"IPv6 access-list name\n")

DEFSH (VTYSH_MGMTD, no_match_ipv6_address_prefix_len_cmd_vtysh,
	"no match ipv6 address prefix-len [(0-128)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match prefix length of IPv6 address\n"
	"Match prefix length of IPv6 address\n"
	"Prefix length\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ipv6_address_prefix_list_cmd_vtysh,
	"no match ipv6 address prefix-list [PREFIXLIST6_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match address of route\n"
	"Match entries of prefix-lists\n"
	"IP prefix-list name\n")

DEFSH (VTYSH_BGPD, no_match_ipv6_next_hop_address_cmd_vtysh,
	"no match ipv6 next-hop address X:X::X:X",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ipv6_next_hop_cmd_vtysh,
	"no match ipv6 next-hop [ACCESSLIST6_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 access-list name\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_match_ipv6_next_hop_old_cmd_vtysh,
	"no match ipv6 next-hop X:X::X:X",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ipv6_next_hop_prefix_list_cmd_vtysh,
	"no match ipv6 next-hop prefix-list [PREFIXLIST_NAME]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match IPv6 next-hop address of route\n"
	"Match entries by prefix-list\n"
	"IPv6 prefix-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_ipv6_next_hop_type_cmd_vtysh,
	"no match ipv6 next-hop type [<blackhole>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Match address of route\n"
	"Match entries by type\n"
	"Blackhole\n")

DEFSH (VTYSH_BGPD, no_match_lcommunity_cmd_vtysh,
	"no match large-community [<(1-99)|(100-500)|LCOMMUNITY_LIST_NAME> [<exact-match|any>]]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match BGP large community list\n"
	"Large Community-list number (standard)\n"
	"Large Community-list number (expanded)\n"
	"Large Community-list name\n"
	"Do exact matching of communities\n"
	"Do matching of any community\n")

DEFSH (VTYSH_BGPD, no_match_local_pref_cmd_vtysh,
	"no match local-preference [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match local preference of route\n"
	"Local preference value\n")

DEFSH (VTYSH_BGPD, no_match_mac_address_cmd_vtysh,
	"no match mac address ACCESSLIST_MAC_NAME",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"mac\n"
	"Match address of route\n"
	"MAC acess-list name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_metric_cmd_vtysh,
	"no match metric [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match metric of route\n"
	"Metric value\n")

DEFSH (VTYSH_BGPD, no_match_origin_cmd_vtysh,
	"no match origin [<egp|igp|incomplete>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"BGP origin code\n"
	"remote EGP\n"
	"local IGP\n"
	"unknown heritage\n")

DEFSH (VTYSH_BGPD, no_match_peer_cmd_vtysh,
	"no match peer [<local|A.B.C.D|X:X::X:X|WORD>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match peer address\n"
	"Static or Redistributed routes\n"
	"IP address of peer\n"
	"IPv6 address of peer\n"
	"Interface name of peer\n")

DEFSH (VTYSH_BGPD, no_match_probability_cmd_vtysh,
	"no match probability [(0-100)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match portion of routes defined by percentage value\n"
	"Percentage of routes\n")

DEFSH (VTYSH_BGPD, no_match_rpki_cmd_vtysh,
	"no match rpki <valid|invalid|notfound>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Control rpki specific settings\n"
	"Valid prefix\n"
	"Invalid prefix\n"
	"Prefix not found\n")

DEFSH (VTYSH_MGMTD, no_match_source_instance_cmd_vtysh,
	"no match source-instance [(0-255)]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match the protocol's instance number\n"
	"The instance number\n")

DEFSH (VTYSH_BGPD|VTYSH_MGMTD, no_match_source_protocol_cmd_vtysh,
	"no match source-protocol [<kernel|connected|local|static|rip|ripng|ospf|ospf6|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match protocol via which the route was learnt\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_BGPD, no_match_src_peer_cmd_vtysh,
	"no match src-peer [<A.B.C.D|X:X::X:X|WORD>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match peer address\n"
	"IP address of peer\n"
	"IPv6 address of peer\n"
	"Interface name of peer\n")

DEFSH (VTYSH_RMAP_CONFIG, no_match_tag_cmd_vtysh,
	"no match tag [<untagged|(1-4294967295)>]",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Match tag of route\n"
	"Untagged route\n"
	"Tag value\n")

DEFSH (VTYSH_BGPD, no_match_vrl_source_vrf_cmd_vtysh,
	"no match source-vrf NAME$vrf_name",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"source vrf\n"
	"The VRF name\n")

DEFSH (VTYSH_ISISD, no_max_lsp_lifetime_cmd_vtysh,
	"no max-lsp-lifetime [level-1|level-2]$level [(350-65535)]",
	"Negate a command or set its defaults\n"
	"Maximum LSP lifetime\n"
	"Maximum LSP lifetime for Level 1 only\n"
	"Maximum LSP lifetime for Level 2 only\n"
	"LSP lifetime in seconds\n")

DEFSH (VTYSH_ISISD, no_metric_style_cmd_vtysh,
	"no metric-style [narrow|transition|wide]",
	"Negate a command or set its defaults\n"
	"Use old-style (ISO 10589) or new-style packet formats\n"
	"Use old style of TLVs with narrow metric\n"
	"Send and accept both styles of TLVs during transition\n"
	"Use new style of TLVs to carry wider metric\n")

DEFSH (VTYSH_ZEBRA, no_mpls_label_bind_cmd_vtysh,
	"no mpls label bind <A.B.C.D/M|X:X::X:X/M> [<(16-1048575)|implicit-null|explicit-null>]",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Label configuration\n"
	"Establish FEC to label binding\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"MPLS Label to bind\n"
	"Use Implicit-Null Label\n"
	"Use Explicit-Null Label\n")

DEFSH (VTYSH_ZEBRA, no_mpls_label_global_block_cmd_vtysh,
	"no mpls label global-block [(16-1048575) (16-1048575)]",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Label configuration\n"
	"Configure global label block\n"
	"Start label\n"
	"End label\n")

DEFSH (VTYSH_OSPFD, no_mpls_ldp_sync_cmd_vtysh,
	"no ip ospf mpls ldp-sync",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"OSPF interface commands\n"
	"MPLS information\n"
	"Disable MPLS LDP-SYNC\n")

DEFSH (VTYSH_OSPFD, no_mpls_ldp_sync_holddown_cmd_vtysh,
	"no ip ospf mpls ldp-sync holddown [<(1-10000)>]",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"OSPF interface commands\n"
	"MPLS information\n"
	"Disable MPLS LDP-SYNC\n"
	"holddown timer disable\n"
	"Time in seconds\n")

DEFSH (VTYSH_ZEBRA, no_mpls_transit_lsp_all_cmd_vtysh,
	"no mpls lsp (16-1048575)",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Establish label switched path\n"
	"Incoming MPLS label\n")

DEFSH (VTYSH_ZEBRA, no_mpls_transit_lsp_cmd_vtysh,
	"no mpls lsp (16-1048575) <A.B.C.D|X:X::X:X>",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Establish label switched path\n"
	"Incoming MPLS label\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n")

DEFSH (VTYSH_ZEBRA, no_mpls_transit_lsp_out_label_cmd_vtysh,
	"no mpls lsp (16-1048575) <A.B.C.D|X:X::X:X> <(16-1048575)|explicit-null|implicit-null>",
	"Negate a command or set its defaults\n"
	"MPLS information\n"
	"Establish label switched path\n"
	"Incoming MPLS label\n"
	"IPv4 gateway address\n"
	"IPv6 gateway address\n"
	"Outgoing MPLS label\n"
	"Use Explicit-Null label\n"
	"Use Implicit-Null label\n")

DEFSH (VTYSH_PIMD, no_msdp_peer_md5_cmd_vtysh,
	"no msdp peer A.B.C.D$peer password [WORD]",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"MSDP Peer address\n"
	"Use MD5 authentication\n"
	"MD5 pre shared key\n")

DEFSH (VTYSH_BGPD, no_neighbor_activate_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> activate",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable the Address Family for this Neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_activate_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> activate",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable the Address Family for this Neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_addpath_paths_limit_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor addpath-rx-paths-limit [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Paths Limit for Addpath to receive from the peer\n"
	"Maximum number of paths\n")

DEFSH (VTYSH_BGPD, no_neighbor_addpath_tx_all_paths_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-all-paths",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise all paths to a neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_addpath_tx_all_paths_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-all-paths",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise all paths to a neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor addpath-tx-best-selected [(1-6)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise best selected paths to a neighbor\n"
	"The number of best paths\n")

DEFSH (VTYSH_BGPD, no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-bestpath-per-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise the bestpath per each neighboring AS\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_addpath_tx_bestpath_per_as_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> addpath-tx-bestpath-per-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Use addpath to advertise the bestpath per each neighboring AS\n")

DEFSH (VTYSH_BGPD, no_neighbor_advertise_interval_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> advertisement-interval [(0-600)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Minimum interval between sending BGP routing updates\n"
	"time in seconds\n")

DEFSH (VTYSH_BGPD, no_neighbor_allowas_in_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> allowas-in [<(1-10)|origin>]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"allow local ASN appears in aspath attribute\n"
	"Number of occurrences of AS number\n"
	"Only accept my AS in the as-path if the route was originated in my AS\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_allowas_in_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> allowas-in [<(1-10)|origin>]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"allow local ASN appears in aspath attribute\n"
	"Number of occurrences of AS number\n"
	"Only accept my AS in the as-path if the route was originated in my AS\n")

DEFSH (VTYSH_BGPD, no_neighbor_as_override_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> as-override",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override ASNs in outbound updates if aspath equals remote-as\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_as_override_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> as-override",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override ASNs in outbound updates if aspath equals remote-as\n")

DEFSH (VTYSH_BGPD, no_neighbor_aspath_loop_detection_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor sender-as-path-loop-detection",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Detect AS loops before sending to neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_attr_unchanged_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> attribute-unchanged [{as-path|next-hop|med}]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP attribute is propagated unchanged to this neighbor\n"
	"As-path attribute\n"
	"Nexthop attribute\n"
	"Med attribute\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_attr_unchanged_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> attribute-unchanged [{as-path|next-hop|med}]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP attribute is propagated unchanged to this neighbor\n"
	"As-path attribute\n"
	"Nexthop attribute\n"
	"Med attribute\n")

DEFSH (VTYSH_BGPD, no_neighbor_bfd_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> bfd",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disables BFD support\n")

DEFSH (VTYSH_BGPD, no_neighbor_bfd_profile_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> bfd profile [BFDPROF]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BFD integration\n"
	"BFD profile.\n"
	"BFD profile name.\n")

DEFSH (VTYSH_BGPD, no_neighbor_capability_dynamic_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> capability dynamic",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise dynamic capability to this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_capability_enhe_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> capability extended-nexthop",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise extended next-hop capability to the peer\n")

DEFSH (VTYSH_BGPD, no_neighbor_capability_orf_prefix_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> capability orf prefix-list <both|send|receive>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise ORF capability to the peer\n"
	"Advertise prefixlist ORF capability to this neighbor\n"
	"Capability to SEND and RECEIVE the ORF to/from this neighbor\n"
	"Capability to RECEIVE the ORF from this neighbor\n"
	"Capability to SEND the ORF to this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_capability_orf_prefix_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> capability orf prefix-list <both|send|receive>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Advertise capability to the peer\n"
	"Advertise ORF capability to the peer\n"
	"Advertise prefixlist ORF capability to this neighbor\n"
	"Capability to SEND and RECEIVE the ORF to/from this neighbor\n"
	"Capability to RECEIVE the ORF from this neighbor\n"
	"Capability to SEND the ORF to this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_cmd_vtysh,
	"no neighbor <WORD|<A.B.C.D|X:X::X:X> [remote-as <ASNUM|internal|external|auto>]>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, no_neighbor_damp_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor dampening [HALF [REUSE SUPPRESS MAX]]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enable neighbor route-flap dampening\n"
	"Half-life time for the penalty\n"
	"Value to start reusing a route\n"
	"Value to start suppressing a route\n"
	"Maximum duration to suppress a stable route\n")

DEFSH (VTYSH_BGPD, no_neighbor_default_originate_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> default-originate [route-map RMAP_NAME]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n"
	"Route-map to specify criteria to originate default\n"
	"route-map name\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_default_originate_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> default-originate [route-map RMAP_NAME]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Originate default route to this neighbor\n"
	"Route-map to specify criteria to originate default\n"
	"route-map name\n")

DEFSH (VTYSH_BGPD, no_neighbor_description_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> description",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor specific description\n")

DEFSH (VTYSH_BGPD, no_neighbor_description_comment_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> description LINE...",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor specific description\n"
	"Up to 80 characters describing this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_disable_addpath_rx_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> disable-addpath-rx",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Do not accept additional paths\n")

DEFSH (VTYSH_BGPD, no_neighbor_disable_connected_check_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> <disable-connected-check|enforce-multihop>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"one-hop away EBGP peer using loopback address\n"
	"Enforce EBGP neighbors perform multihop\n")

DEFSH (VTYSH_BGPD, no_neighbor_disable_link_bw_encoding_ieee_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> disable-link-bw-encoding-ieee",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable IEEE floating-point encoding for extended community bandwidth\n")

DEFSH (VTYSH_BGPD, no_neighbor_distribute_list_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> distribute-list ACCESSLIST_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"IP Access-list name\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_distribute_list_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> distribute-list ACCESSLIST_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"IP Access-list name\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH (VTYSH_BGPD, no_neighbor_dont_capability_negotiate_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> dont-capability-negotiate",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Do not perform capability negotiation\n")

DEFSH (VTYSH_BGPD, no_neighbor_ebgp_multihop_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> ebgp-multihop [(1-255)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Allow EBGP neighbors not on directly connected networks\n"
	"maximum hop count\n")

DEFSH (VTYSH_BGPD, no_neighbor_enforce_first_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> enforce-first-as",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Enforce the first AS for EBGP routes\n")

DEFSH (VTYSH_BGPD, no_neighbor_extended_optional_parameters_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> extended-optional-parameters",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Force the extended optional parameters format for OPEN messages\n")

DEFSH (VTYSH_BGPD, no_neighbor_filter_list_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> filter-list AS_PATH_FILTER_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Establish BGP filters\n"
	"AS path access-list name\n"
	"Filter incoming routes\n"
	"Filter outgoing routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_filter_list_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> filter-list AS_PATH_FILTER_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Establish BGP filters\n"
	"AS path access-list name\n"
	"Filter incoming routes\n"
	"Filter outgoing routes\n")

DEFSH (VTYSH_BGPD, no_neighbor_interface_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X> interface WORD",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"IPv6 address\n"
	"Interface\n"
	"Interface name\n")

DEFSH (VTYSH_BGPD, no_neighbor_interface_config_cmd_vtysh,
	"no neighbor WORD interface [v6only] [peer-group PGNAME] [remote-as <ASNUM|internal|external|auto>]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Interface name\n"
	"Configure BGP on interface\n"
	"Enable BGP with v6 link-local only\n"
	"Member of the peer-group\n"
	"Peer-group name\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, no_neighbor_interface_peer_group_remote_as_cmd_vtysh,
	"no neighbor WORD remote-as <ASNUM|internal|external|auto>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Interface name or neighbor tag\n"
	"Specify a BGP neighbor\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal BGP peer\n"
	"External BGP peer\n"
	"Automatically detect remote ASN\n")

DEFSH (VTYSH_BGPD, no_neighbor_local_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> local-as [ASNUM [no-prepend [replace-as] [dual-as]]]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Specify a local-as number\n"
	"AS number expressed in dotted or plain format used as local AS\n"
	"Do not prepend local-as to updates from ebgp peers\n"
	"Do not prepend local-as to updates from ibgp peers\n"
	"Allow peering with a global AS number or local-as number\n")

DEFSH (VTYSH_BGPD, no_neighbor_maximum_prefix_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix [(1-4294967295) [(1-100)] [restart (1-65535)] [warning-only] [force]]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_maximum_prefix_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix [(1-4294967295) [(1-100)] [restart (1-65535)] [warning-only] [force]]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to accept from this peer\n"
	"maximum no. of prefix limit\n"
	"Threshold value (%) at which to generate a warning msg\n"
	"Restart bgp connection after limit is exceeded\n"
	"Restart interval in minutes\n"
	"Only give warning message when limit is exceeded\n"
	"Force checking all received routes not only accepted\n")

DEFSH (VTYSH_BGPD, no_neighbor_maximum_prefix_out_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> maximum-prefix-out [(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Maximum number of prefixes to be sent to this peer\n"
	"Maximum no. of prefix limit\n")

DEFSH (VTYSH_BGPD, no_neighbor_nexthop_local_unchanged_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> nexthop-local unchanged",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure treatment of outgoing link-local-nexthop attribute\n"
	"Leave link-local nexthop unchanged for this peer\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_nexthop_self_all_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self all",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH (VTYSH_BGPD, no_neighbor_nexthop_self_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_nexthop_self_force_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self force",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_nexthop_self_force_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self force",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n"
	"Set the next hop to self for reflected routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_nexthop_self_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> next-hop-self",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Disable the next hop calculation for this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_override_capability_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> override-capability",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Override capability negotiation result\n")

DEFSH (VTYSH_BGPD, no_neighbor_passive_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> passive",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Don't send open messages to this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_password_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> password [LINE]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set a password\n"
	"The password\n")

DEFSH (VTYSH_BGPD, no_neighbor_path_attribute_discard_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor path-attribute discard [(1-255)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Manipulate path attributes from incoming UPDATE messages\n"
	"Drop specified attributes from incoming UPDATE messages\n"
	"Attribute number\n")

DEFSH (VTYSH_BGPD, no_neighbor_path_attribute_treat_as_withdraw_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor path-attribute treat-as-withdraw (1-255)...",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Manipulate path attributes from incoming UPDATE messages\n"
	"Treat-as-withdraw any incoming BGP UPDATE messages that contain the specified attribute\n"
	"Attribute number\n")

DEFSH (VTYSH_BGPD, no_neighbor_peer_group_cmd_vtysh,
	"no neighbor WORD peer-group",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor tag\n"
	"Configure peer-group\n")

DEFSH (VTYSH_BGPD, no_neighbor_port_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> port [(0-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor's BGP port\n"
	"TCP port number\n")

DEFSH (VTYSH_BGPD, no_neighbor_prefix_list_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> prefix-list WORD <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"Name of a prefix list\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_prefix_list_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> prefix-list WORD <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Filter updates to/from this neighbor\n"
	"Name of a prefix list\n"
	"Filter incoming updates\n"
	"Filter outgoing updates\n")

DEFSH (VTYSH_BGPD, no_neighbor_remove_private_as_all_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_remove_private_as_all_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n")

DEFSH (VTYSH_BGPD, no_neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all replace-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_remove_private_as_all_replace_as_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS all replace-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Apply to all AS numbers\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH (VTYSH_BGPD, no_neighbor_remove_private_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_remove_private_as_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n")

DEFSH (VTYSH_BGPD, no_neighbor_remove_private_as_replace_as_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS replace-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_remove_private_as_replace_as_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> remove-private-AS replace-AS",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Remove private ASNs in outbound updates\n"
	"Replace private ASNs with our ASN in outbound updates\n")

DEFSH (VTYSH_BGPD, no_neighbor_role_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor local-role <provider|rs-server|rs-client|customer|peer> [strict-mode]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set session role\n"
	"Providing transit\n"
	"Route server\n"
	"RS client\n"
	"Using transit\n"
	"Public/private peering\n"
	"Use additional restriction on peer\n")

DEFSH (VTYSH_BGPD, no_neighbor_route_map_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-map RMAP_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Apply route map to neighbor\n"
	"Name of route map\n"
	"Apply map to incoming routes\n"
	"Apply map to outbound routes\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_route_map_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-map RMAP_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Apply route map to neighbor\n"
	"Name of route map\n"
	"Apply map to incoming routes\n"
	"Apply map to outbound routes\n")

DEFSH (VTYSH_BGPD, no_neighbor_route_reflector_client_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-reflector-client",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Reflector client\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_route_reflector_client_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-reflector-client",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Reflector client\n")

DEFSH (VTYSH_BGPD, no_neighbor_route_server_client_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-server-client",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Server client\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_route_server_client_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> route-server-client",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Configure a neighbor as Route Server client\n")

DEFSH (VTYSH_BGPD, no_neighbor_send_community_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> send-community",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_send_community_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> send-community",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_send_community_type_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> send-community <both|all|extended|standard|large>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n"
	"Send Standard and Extended Community attributes\n"
	"Send Standard, Large and Extended Community attributes\n"
	"Send Extended Community attributes\n"
	"Send Standard Community attributes\n"
	"Send Large Community attributes\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_send_community_type_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> send-community <both|all|extended|standard|large>",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Send Community attribute to this neighbor\n"
	"Send Standard and Extended Community attributes\n"
	"Send Standard, Large and Extended Community attributes\n"
	"Send Extended Community attributes\n"
	"Send Standard Community attributes\n"
	"Send Large Community attributes\n")

DEFSH (VTYSH_BGPD, no_neighbor_set_peer_group_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> peer-group PGNAME",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_set_peer_group_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> peer-group PGNAME",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Member of the peer-group\n"
	"Peer-group name\n")

DEFSH (VTYSH_BGPD, no_neighbor_shutdown_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> shutdown",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_shutdown_msg_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> shutdown message MSG...",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n"
	"Remove a shutdown message (RFC 8203)\n"
	"Shutdown message\n")

DEFSH (VTYSH_BGPD, no_neighbor_shutdown_rtt_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> shutdown rtt [(1-65535) [count (1-255)]]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Administratively shut down this neighbor\n"
	"Shutdown if round-trip-time is higher than expected\n"
	"Round-trip-time in milliseconds\n"
	"Specify the number of keepalives before shutdown\n"
	"The number of keepalives with higher RTT to shutdown\n")

DEFSH (VTYSH_BGPD, no_neighbor_soft_reconfiguration_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> soft-reconfiguration inbound",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Per neighbor soft reconfiguration\n"
	"Allow inbound soft reconfiguration for this neighbor\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_soft_reconfiguration_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> soft-reconfiguration inbound",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Per neighbor soft reconfiguration\n"
	"Allow inbound soft reconfiguration for this neighbor\n")

DEFSH (VTYSH_BGPD, no_neighbor_solo_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> solo",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Solo peer - part of its own update group\n")

DEFSH (VTYSH_BGPD, no_neighbor_soo_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor soo [ASN:NN_OR_IP-ADDRESS:NN$soo]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set the Site-of-Origin (SoO) extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, no_neighbor_strict_capability_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> strict-capability-match",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Strict capability negotiation match\n")

DEFSH (VTYSH_BGPD, no_neighbor_tcp_mss_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> tcp-mss [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"TCP max segment size\n"
	"TCP MSS value\n")

DEFSH (VTYSH_BGPD, no_neighbor_timers_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> timers [(0-65535) (0-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"Keepalive interval\n"
	"Holdtime\n")

DEFSH (VTYSH_BGPD, no_neighbor_timers_connect_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> timers connect [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"BGP connect timer\n"
	"Connect timer\n")

DEFSH (VTYSH_BGPD, no_neighbor_timers_delayopen_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor timers delayopen [(0-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP per neighbor timers\n"
	"RFC 4271 DelayOpenTimer\n"
	"DelayOpenTime timer interval\n")

DEFSH (VTYSH_BGPD, no_neighbor_ttl_security_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> ttl-security hops (1-254)",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"BGP ttl-security parameters\n"
	"Specify the maximum number of hops to the BGP peer\n"
	"Number of hops to BGP peer\n")

DEFSH (VTYSH_BGPD, no_neighbor_unsuppress_map_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> unsuppress-map WORD",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to selectively unsuppress suppressed routes\n"
	"Name of route map\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_unsuppress_map_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> unsuppress-map WORD",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Route-map to selectively unsuppress suppressed routes\n"
	"Name of route map\n")

DEFSH (VTYSH_BGPD, no_neighbor_update_source_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> update-source [<A.B.C.D|X:X::X:X|WORD>]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Source of routing updates\n"
	"IPv4 address\n"
	"IPv6 address\n"
	"Interface name (requires zebra to be running)\n")

DEFSH (VTYSH_BGPD, no_neighbor_weight_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> weight [(0-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set default weight for routes from this neighbor\n"
	"default weight\n")

DEFSH_HIDDEN (VTYSH_BGPD, no_neighbor_weight_hidden_cmd_vtysh,
	"no neighbor <A.B.C.D|X:X::X:X|WORD> weight [(0-65535)]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Set default weight for routes from this neighbor\n"
	"default weight\n")

DEFSH (VTYSH_NH_GROUP, no_nexthop_group_backup_cmd_vtysh,
	"no backup-group [WORD$name]",
	"Negate a command or set its defaults\n"
	"Clear group name containing backup nexthops\n"
	"The name of the backup group\n")

DEFSH (VTYSH_NH_GROUP, no_nexthop_group_resilience_cmd_vtysh,
	"no resilient [buckets (1-256) idle-timer (1-4294967295) unbalanced-timer (1-4294967295)]",
	"Negate a command or set its defaults\n"
	"A resilient Nexthop Group\n"
	"Buckets in the Hash for this Group\n"
	"Number of buckets\n"
	"The Idle timer for this Resilient Nexthop Group in seconds\n"
	"Number of seconds of Idle time\n"
	"The length of time that the Nexthop Group can be unbalanced\n"
	"Number of seconds of Unbalanced time\n")

DEFSH (VTYSH_NHRPD, no_nhrp_event_socket_cmd_vtysh,
	"no nhrp event socket [SOCKET]",
	"Negate a command or set its defaults\n"
	"Next Hop Resolution Protocol functions\n"
	"Event Manager commands\n"
	"Event Manager unix socket path\n"
	"Unix path for the socket\n")

DEFSH (VTYSH_NHRPD, no_nhrp_multicast_nflog_group_cmd_vtysh,
	"no nhrp multicast-nflog-group [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify NFLOG group number\n"
	"NFLOG group number\n")

DEFSH (VTYSH_NHRPD, no_nhrp_nflog_group_cmd_vtysh,
	"no nhrp nflog-group [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Next Hop Resolution Protocol functions\n"
	"Specify NFLOG group number\n"
	"NFLOG group number\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_area_nssa_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)>$area_str nssa        [{	  default-information-originate [{metric (0-16777214)|metric-type (1-2)}]	  |no-summary	 }]",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as nssa\n"
	"Originate Type 7 default into NSSA area\n"
	"OSPFv3 default metric\n"
	"OSPFv3 metric\n"
	"OSPFv3 metric type for default routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n"
	"Do not inject inter-area routes into area\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_area_stub_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> stub",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as stub\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_area_stub_no_summary_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> stub no-summary",
	"Negate a command or set its defaults\n"
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as stub\n"
	"Do not inject inter-area routes into area\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_default_information_originate_cmd_vtysh,
	"no default-information originate [{always|metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Always advertise default route\n"
	"OSPFv3 default metric\n"
	"OSPFv3 metric\n"
	"OSPFv3 metric type for default routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_distance_cmd_vtysh,
	"no distance (1-255)",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"OSPF6 Administrative distance\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_distance_ospf6_cmd_vtysh,
	"no distance ospf6 [{intra-area [(1-255)]|inter-area [(1-255)]|external [(1-255)]}]",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"OSPF6 distance\n"
	"Intra-area routes\n"
	"Distance for intra-area routes\n"
	"Inter-area routes\n"
	"Distance for inter-area routes\n"
	"External routes\n"
	"Distance for external routes\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_external_route_aggregation_cmd_vtysh,
	"no summary-address X:X::X:X/M$prefix [tag (1-4294967295)] [{metric (0-16777215) | metric-type (1-2)}]",
	"Negate a command or set its defaults\n"
	"External summary address\n"
	"Specify IPv6 prefix\n"
	"Router tag\n"
	"Router tag value\n"
	"Metric \n"
	"Advertised metric for this route\n"
	"OSPFv3 exterior metric type for summarised routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_external_route_aggregation_no_advertise_cmd_vtysh,
	"no summary-address X:X::X:X/M$prefix no-advertise",
	"Negate a command or set its defaults\n"
	"External summary address\n"
	"Specify IPv6 prefix\n"
	"Adverise summary route to the AS \n")

DEFSH (VTYSH_OSPF6D, no_ospf6_gr_helper_disable_lsacheck_cmd_vtysh,
	"no graceful-restart helper lsa-check-disable",
	"Negate a command or set its defaults\n"
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"diasble strict LSA check\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_gr_helper_planned_only_cmd_vtysh,
	"no graceful-restart helper planned-only",
	"Negate a command or set its defaults\n"
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"supported only for planned restart\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_gr_helper_supported_grace_time_cmd_vtysh,
	"no graceful-restart helper supported-grace-time (10-1800)$interval",
	"Negate a command or set its defaults\n"
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"supported grace timer\n"
	"grace interval(in seconds)\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_log_adjacency_changes_cmd_vtysh,
	"no log-adjacency-changes",
	"Negate a command or set its defaults\n"
	"Log changes in adjacency state\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_log_adjacency_changes_detail_cmd_vtysh,
	"no log-adjacency-changes detail",
	"Negate a command or set its defaults\n"
	"Log changes in adjacency state\n"
	"Log all state changes\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_max_multipath_cmd_vtysh,
	"no maximum-paths [(1-256)]",
	"Negate a command or set its defaults\n"
	"Max no of multiple paths for ECMP support\n"
	"Number of paths\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_redistribute_cmd_vtysh,
	"no redistribute <kernel|connected|local|static|ripng|isis|bgp|nhrp|vnc|babel|openfabric>[{metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Route map name\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_route_aggregation_timer_cmd_vtysh,
	"no aggregation timer [5-1800]",
	"Negate a command or set its defaults\n"
	"External route aggregation\n"
	"Delay timer\n"
	"Timer interval(in seconds)\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_router_id_cmd_vtysh,
	"no ospf6 router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Configure OSPF6 Router-ID\n"
	"specify by IPv4 address notation(e.g. 0.0.0.0)\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_stub_router_admin_cmd_vtysh,
	"no stub-router administrative",
	"Negate a command or set its defaults\n"
	"Make router a stub router\n"
	"Administratively applied, for an indefinite period\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_timers_lsa_cmd_vtysh,
	"no timers lsa min-arrival [(0-600000)]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"OSPF6 LSA timers\n"
	"Minimum delay in receiving new version of a LSA\n"
	"Delay in milliseconds\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_timers_throttle_spf_cmd_vtysh,
	"no timers throttle spf [(0-600000) (0-600000) (0-600000)]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"Throttling adaptive timer\n"
	"OSPF6 SPF timers\n"
	"Delay (msec) from first change received till SPF calculation\n"
	"Initial hold time (msec) between consecutive SPF calculations\n"
	"Maximum hold time (msec)\n")

DEFSH (VTYSH_OSPF6D, no_ospf6_write_multiplier_cmd_vtysh,
	"no write-multiplier (1-100)",
	"Negate a command or set its defaults\n"
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_OSPFD, no_ospf_abr_type_cmd_vtysh,
	"no ospf abr-type [<cisco|ibm|shortcut|standard>]",
	"Negate a command or set its defaults\n"
	"OSPF specific commands\n"
	"Set OSPF ABR type\n"
	"Alternative ABR, cisco implementation\n"
	"Alternative ABR, IBM implementation\n"
	"Shortcut ABR\n"
	"Standard ABR\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_authentication_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> authentication",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Enable authentication\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_default_cost_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> default-cost [(0-16777215)]",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Set the summary-default cost of a NSSA or stub area\n"
	"Stub's advertised default summary cost\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_export_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> export-list ACCESSLIST4_NAME",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Unset the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_filter_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> filter-list prefix PREFIXLIST4_NAME <in|out>",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Filter networks between OSPF areas\n"
	"Filter prefixes between OSPF areas\n"
	"Name of an IP prefix-list\n"
	"Filter networks sent to this area\n"
	"Filter networks sent from this area\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_import_list_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> import-list ACCESSLIST4_NAME",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Unset the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_nssa_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)>$area_str nssa         [{	   <translate-candidate|translate-never|translate-always>	   |default-information-originate [{metric [(0-16777214)]|metric-type [(1-2)]}]	   |no-summary	   |suppress-fa	 }]",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as nssa\n"
	"Configure NSSA-ABR for translate election (default)\n"
	"Configure NSSA-ABR to never translate\n"
	"Configure NSSA-ABR to always translate\n"
	"Originate Type 7 default into NSSA area\n"
	"OSPF default metric\n"
	"OSPF metric\n"
	"OSPF metric type for default routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Do not inject inter-area routes into nssa\n"
	"Suppress forwarding address\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_nssa_range_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)>$area_str nssa range A.B.C.D/M$prefix [<not-advertise|cost [(0-16777215)]>]",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as nssa\n"
	"Configured address range\n"
	"Specify IPv4 prefix\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_range_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> range A.B.C.D/M [<cost [(0-16777215)]|advertise [cost [(0-16777215)]]|not-advertise>]",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Summarize routes matching address/mask (border routers only)\n"
	"Area range prefix\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n"
	"Advertise this range (default)\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n"
	"DoNotAdvertise this range\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_range_substitute_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> range A.B.C.D/M substitute A.B.C.D/M",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Summarize routes matching address/mask (border routers only)\n"
	"Area range prefix\n"
	"Announce area range as another prefix\n"
	"Network prefix to be announced instead of range\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_shortcut_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> shortcut <default|enable|disable>",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Deconfigure the area's shortcutting mode\n"
	"Deconfigure default shortcutting through the area\n"
	"Deconfigure enabled shortcutting through the area\n"
	"Deconfigure disabled shortcutting through the area\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_stub_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> stub",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as stub\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_stub_no_summary_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> stub no-summary",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as stub\n"
	"Do not inject inter-area routes into area\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_vlink_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> virtual-link A.B.C.D [authentication [<key-chain KEYCHAIN_NAME|message-digest|null>]] [<message-digest-key (1-255) md5 KEY|authentication-key AUTH_KEY>]",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure a virtual link\n"
	"Router ID of the remote ABR\n"
	"Enable authentication on this virtual link\n"
	"Use a key-chain for cryptographic authentication keys\n"
	"Key-chain name\n"
	"Use message-digest authentication\n"
	"Use null authentication\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n")

DEFSH (VTYSH_OSPFD, no_ospf_area_vlink_intervals_cmd_vtysh,
	"no area <A.B.C.D|(0-4294967295)> virtual-link A.B.C.D {hello-interval [(1-65535)]|retransmit-interval [(1-65535)]|retransmit-window [(20-1000)]|transmit-delay [(1-65535)]|dead-interval [(1-65535)]}",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure a virtual link\n"
	"Router ID of the remote ABR\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Window for LSA retransmit - Retransmit LSAs expiring in this window\n"
	"Milliseconds\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_authentication_key_authkey_addr_cmd_vtysh,
	"no ospf authentication-key [AUTH_KEY [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_auto_cost_reference_bandwidth_cmd_vtysh,
	"no auto-cost reference-bandwidth [(1-4294967)]",
	"Negate a command or set its defaults\n"
	"Calculate OSPF interface cost according to bandwidth\n"
	"Use reference bandwidth method to assign OSPF cost\n"
	"The reference bandwidth in terms of Mbits per second\n")

DEFSH (VTYSH_OSPFD, no_ospf_compatible_rfc1583_cmd_vtysh,
	"no compatible rfc1583",
	"Negate a command or set its defaults\n"
	"OSPF compatibility list\n"
	"compatible with RFC 1583\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_cost_cmd_vtysh,
	"no ospf cost [(1-65535)] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Interface cost\n"
	"Cost\n"
	"Address of interface\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_dead_interval_cmd_vtysh,
	"no ospf dead-interval [<(1-65535)|minimal hello-multiplier (2-20)> [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n"
	"Minimal 1s dead-interval with fast sub-second hellos\n"
	"Hello multiplier factor\n"
	"Number of Hellos to send each second\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_default_information_originate_cmd_vtysh,
	"no default-information originate [{always|metric [(0-16777214)]|metric-type [(1-2)]|route-map [RMAP_NAME]}]",
	"Negate a command or set its defaults\n"
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Always advertise default route\n"
	"OSPF default metric\n"
	"OSPF metric\n"
	"OSPF metric type for default routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, no_ospf_default_metric_cmd_vtysh,
	"no default-metric [(0-16777214)]",
	"Negate a command or set its defaults\n"
	"Set metric of redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_OSPFD, no_ospf_distance_cmd_vtysh,
	"no distance [(1-255)]",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"OSPF Administrative distance\n")

DEFSH (VTYSH_OSPFD, no_ospf_distance_ospf_cmd_vtysh,
	"no distance ospf [{intra-area [(1-255)]|inter-area [(1-255)]|external [(1-255)]}]",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"OSPF administrative distance\n"
	"Intra-area routes\n"
	"Distance for intra-area routes\n"
	"Inter-area routes\n"
	"Distance for inter-area routes\n"
	"External routes\n"
	"Distance for external routes\n")

DEFSH (VTYSH_OSPFD, no_ospf_distribute_list_out_cmd_vtysh,
	"no distribute-list ACCESSLIST4_NAME out <kernel|connected|local|static|rip|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter outgoing routing updates\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_OSPFD, no_ospf_external_route_aggregation_cmd_vtysh,
	"no summary-address A.B.C.D/M [tag (1-4294967295)]",
	"Negate a command or set its defaults\n"
	"External summary address\n"
	"Summary address prefix\n"
	"Router tag\n"
	"Router tag value\n")

DEFSH (VTYSH_OSPFD, no_ospf_external_route_aggregation_no_adrvertise_cmd_vtysh,
	"no summary-address A.B.C.D/M no-advertise",
	"Negate a command or set its defaults\n"
	"External summary address\n"
	"Summary address prefix\n"
	"Advertise summary route to the AS \n")

DEFSH (VTYSH_OSPFD, no_ospf_gr_helper_enable_cmd_vtysh,
	"no graceful-restart helper enable [A.B.C.D$address]",
	"Negate a command or set its defaults\n"
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Enable Helper support\n"
	"Advertising Router-ID\n")

DEFSH (VTYSH_OSPFD, no_ospf_gr_helper_enable_lsacheck_cmd_vtysh,
	"no graceful-restart helper strict-lsa-checking",
	"Negate a command or set its defaults\n"
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Disable strict LSA check\n")

DEFSH (VTYSH_OSPFD, no_ospf_gr_helper_planned_only_cmd_vtysh,
	"no graceful-restart helper planned-only",
	"Negate a command or set its defaults\n"
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Supported only for planned restart\n")

DEFSH (VTYSH_OSPFD, no_ospf_gr_helper_supported_grace_time_cmd_vtysh,
	"no graceful-restart helper supported-grace-time (10-1800)$interval",
	"Negate a command or set its defaults\n"
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Supported grace timer\n"
	"Grace interval(in seconds)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_hello_interval_cmd_vtysh,
	"no ospf hello-interval [(1-65535) [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_log_adjacency_changes_cmd_vtysh,
	"no log-adjacency-changes",
	"Negate a command or set its defaults\n"
	"Log changes in adjacency state\n")

DEFSH (VTYSH_OSPFD, no_ospf_log_adjacency_changes_detail_cmd_vtysh,
	"no log-adjacency-changes detail",
	"Negate a command or set its defaults\n"
	"Log changes in adjacency state\n"
	"Log all state changes\n")

DEFSH (VTYSH_OSPFD, no_ospf_max_metric_router_lsa_admin_cmd_vtysh,
	"no max-metric router-lsa administrative",
	"Negate a command or set its defaults\n"
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Administratively applied, for an indefinite period\n")

DEFSH (VTYSH_OSPFD, no_ospf_max_metric_router_lsa_shutdown_cmd_vtysh,
	"no max-metric router-lsa on-shutdown [(5-100)]",
	"Negate a command or set its defaults\n"
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Advertise stub-router prior to full shutdown of OSPF\n"
	"Time (seconds) to wait till full shutdown\n")

DEFSH (VTYSH_OSPFD, no_ospf_max_metric_router_lsa_startup_cmd_vtysh,
	"no max-metric router-lsa on-startup [(5-86400)]",
	"Negate a command or set its defaults\n"
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Automatically advertise stub Router-LSA on startup of OSPF\n"
	"Time (seconds) to advertise self as stub-router\n")

DEFSH (VTYSH_OSPFD, no_ospf_max_multipath_cmd_vtysh,
	"no maximum-paths [(1-256)]",
	"Negate a command or set its defaults\n"
	"Max no of multiple paths for ECMP support\n"
	"Number of paths\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_message_digest_key_cmd_vtysh,
	"no ospf message-digest-key (1-255) [md5 KEY] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_mpls_ldp_sync_cmd_vtysh,
	"no mpls ldp-sync",
	"Negate a command or set its defaults\n"
	"MPLS specific commands\n"
	"Disable MPLS LDP-IGP Sync\n")

DEFSH (VTYSH_OSPFD, no_ospf_mpls_ldp_sync_holddown_cmd_vtysh,
	"no mpls ldp-sync holddown [<(1-10000)>]",
	"Negate a command or set its defaults\n"
	"MPLS specific commands\n"
	"Disable MPLS LDP-IGP Sync\n"
	"holddown timer disable\n"
	"Time in seconds\n")

DEFSH (VTYSH_OSPFD, no_ospf_mpls_te_cmd_vtysh,
	"no mpls-te [on]",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Disable the MPLS-TE functionality\n")

DEFSH (VTYSH_OSPFD, no_ospf_mpls_te_export_cmd_vtysh,
	"no mpls-te export",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Stop export of the MPLS-TE information as Link State\n")

DEFSH (VTYSH_OSPFD, no_ospf_mpls_te_inter_as_cmd_vtysh,
	"no mpls-te inter-as",
	"Negate a command or set its defaults\n"
	"MPLS-TE specific commands\n"
	"Disable MPLS-TE Inter-AS support\n")

DEFSH (VTYSH_OSPFD, no_ospf_network_area_cmd_vtysh,
	"no network A.B.C.D/M area <A.B.C.D|(0-4294967295)>",
	"Negate a command or set its defaults\n"
	"Enable routing on an IP network\n"
	"OSPF network prefix\n"
	"Set the OSPF area ID\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_network_cmd_vtysh,
	"no ospf network [<broadcast|non-broadcast|point-to-multipoint|point-to-point>]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Network type\n"
	"Specify OSPF broadcast multi-access network\n"
	"Specify OSPF NBMA network\n"
	"Specify OSPF point-to-multipoint network\n"
	"Specify OSPF point-to-point network\n")

DEFSH (VTYSH_OSPFD, no_ospf_opaque_cmd_vtysh,
	"no ospf opaque-lsa",
	"Negate a command or set its defaults\n"
	"OSPF specific commands\n"
	"Enable the Opaque-LSA capability (rfc2370)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_passive_interface_addr_cmd_vtysh,
	"no passive-interface IFNAME [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Allow routing updates on an interface\n"
	"Interface's name\n"
	"IPv4 address\n")

DEFSH (VTYSH_OSPFD, no_ospf_passive_interface_default_cmd_vtysh,
	"no passive-interface default",
	"Negate a command or set its defaults\n"
	"Allow routing updates on an interface\n"
	"Allow routing updates on interfaces by default\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_priority_cmd_vtysh,
	"no ospf priority [(0-255) [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Router priority\n"
	"Priority\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_proactive_arp_cmd_vtysh,
	"no proactive-arp",
	"Negate a command or set its defaults\n"
	"Disallow sending ARP requests proactively\n")

DEFSH (VTYSH_OSPFD, no_ospf_redistribute_instance_source_cmd_vtysh,
	"no redistribute <ospf|table|table-direct> (1-65535) [{metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table Id\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, no_ospf_redistribute_source_cmd_vtysh,
	"no redistribute <kernel|connected|local|static|rip|isis|bgp|eigrp|nhrp|vnc|babel|openfabric> [{metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, no_ospf_refresh_timer_val_cmd_vtysh,
	"no refresh timer [(10-1800)]",
	"Negate a command or set its defaults\n"
	"Adjust refresh parameters\n"
	"Unset refresh timer\n"
	"Timer value in seconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_retransmit_interval_cmd_vtysh,
	"no ospf retransmit-interval [(1-65535)] [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_rfc1583_flag_cmd_vtysh,
	"no ospf rfc1583compatibility",
	"Negate a command or set its defaults\n"
	"OSPF specific commands\n"
	"Disable the RFC1583Compatibility flag\n")

DEFSH (VTYSH_OSPFD, no_ospf_route_aggregation_timer_cmd_vtysh,
	"no aggregation timer",
	"Negate a command or set its defaults\n"
	"External route aggregation\n"
	"Delay timer\n")

DEFSH (VTYSH_OSPFD, no_ospf_router_id_cmd_vtysh,
	"no ospf router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"OSPF specific commands\n"
	"router-id for the OSPF process\n"
	"OSPF router-id in IP address format\n")

DEFSH (VTYSH_OSPFD, no_ospf_sr_enable_cmd_vtysh,
	"no segment-routing [on]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Disable Segment Routing\n")

DEFSH (VTYSH_OSPFD, no_ospf_ti_lfa_cmd_vtysh,
	"no fast-reroute ti-lfa [node-protection]",
	"Negate a command or set its defaults\n"
	"Fast Reroute for MPLS and IP resilience\n"
	"Topology Independent LFA (Loop-Free Alternate)\n"
	"TI-LFA node protection (default is link protection)\n")

DEFSH (VTYSH_OSPFD, no_ospf_timers_throttle_spf_cmd_vtysh,
	"no timers throttle spf [(0-600000)(0-600000)(0-600000)]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"Throttling adaptive timer\n"
	"OSPF SPF timers\n"
	"Delay (msec) from first change received till SPF calculation\n"
	"Initial hold time (msec) between consecutive SPF calculations\n"
	"Maximum hold time (msec)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_ospf_transmit_delay_cmd_vtysh,
	"no ospf transmit-delay [(1-65535) [A.B.C.D]]",
	"Negate a command or set its defaults\n"
	"OSPF interface commands\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, no_ospf_write_multiplier_cmd_vtysh,
	"no ospf write-multiplier [(1-100)]",
	"Negate a command or set its defaults\n"
	"OSPF specific commands\n"
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_PATHD, no_path_ted_cmd_vtysh,
	"no mpls-te [on]",
	"Negate a command or set its defaults\n"
	"Negate a command or set its defaults\n"
	"Disable the TE Database functionality\n")

DEFSH (VTYSH_PATHD, no_path_ted_import_cmd_vtysh,
	"no mpls-te import",
	"Negate a command or set its defaults\n"
	"Negate a command or set its defaults\n"
	"Disable the TE Database fill with remote igp data\n")

DEFSH (VTYSH_PBRD, no_pbr_map_nexthop_cmd_vtysh,
	"no set nexthop        [<	  <A.B.C.D|X:X::X:X>$addr [INTERFACE$intf]	  |INTERFACE$intf	  |blackhole$bh	>        [nexthop-vrf NAME$vrf_name]]",
	"Negate a command or set its defaults\n"
	"Set for the PBR-MAP\n"
	"Specify one of the nexthops in this map\n"
	"v4 Address\n"
	"v6 Address\n"
	"Interface to use\n"
	"Interface to use\n"
	"Blackhole route\n"
	"If the nexthop is in a different vrf tell us\n"
	"The nexthop-vrf Name\n")

DEFSH (VTYSH_PBRD, no_pbr_map_nexthop_group_cmd_vtysh,
	"no set nexthop-group [NHGNAME$name]",
	"Negate a command or set its defaults\n"
	"Set for the PBR-MAP\n"
	"nexthop-group to use\n"
	"The name of the nexthop-group\n")

DEFSH (VTYSH_PBRD, no_pbr_map_vrf_cmd_vtysh,
	"no set vrf [<NAME$vrf_name|unchanged>]",
	"Negate a command or set its defaults\n"
	"Set for the PBR-MAP\n"
	"Specify the VRF for this map\n"
	"The VRF Name\n"
	"Use the interface's VRF for lookup\n")

DEFSH (VTYSH_PBRD, no_pbr_set_table_range_cmd_vtysh,
	"no pbr table range [(10000-4294966272)$lb (10000-4294966272)$ub]",
	"Negate a command or set its defaults\n"
	"Policy Based Routing\n"
	"Set table ID range\n"
	"Set table ID range\n"
	"Lower bound for table ID range\n"
	"Upper bound for table ID range\n")

DEFSH (VTYSH_OSPFD, no_pce_address_cmd_vtysh,
	"no pce address [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"PCE Router Information specific commands\n"
	"Disable PCE address\n"
	"PCE address in IPv4 address format\n")

DEFSH (VTYSH_OSPFD, no_pce_cap_flag_cmd_vtysh,
	"no pce flag",
	"Negate a command or set its defaults\n"
	"PCE Router Information specific commands\n"
	"Disable PCE capabilities\n")

DEFSH (VTYSH_OSPFD, no_pce_domain_cmd_vtysh,
	"no pce domain as (0-65535)",
	"Negate a command or set its defaults\n"
	"PCE Router Information specific commands\n"
	"Disable PCE domain AS number\n"
	"AS number where the PCE as visibilities for path computation\n"
	"AS number in decimal <0-65535>\n")

DEFSH (VTYSH_OSPFD, no_pce_neighbor_cmd_vtysh,
	"no pce neighbor as (0-65535)",
	"Negate a command or set its defaults\n"
	"PCE Router Information specific commands\n"
	"Disable PCE neighbor AS number\n"
	"AS number of PCE neighbor\n"
	"AS number in decimal <0-65535>\n")

DEFSH (VTYSH_OSPFD, no_pce_path_scope_cmd_vtysh,
	"no pce scope [BITPATTERN]",
	"Negate a command or set its defaults\n"
	"PCE Router Information specific commands\n"
	"Disable PCE path scope\n"
	"32-bit Hexadecimal value\n")

DEFSH (VTYSH_PATHD, no_pcep_cli_pcc_pcc_msd_cmd_vtysh,
	"no msd [(1-32)]",
	"Negate a command or set its defaults\n"
	"PCC maximum SID depth \n"
	"PCC maximum SID depth value\n")

DEFSH (VTYSH_PIM6D, no_pim6_joinprune_time_cmd_vtysh,
	"no join-prune-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Join Prune Send Interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, no_pim6_keep_alive_cmd_vtysh,
	"no keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, no_pim6_packets_cmd_vtysh,
	"no packets [(1-255)]",
	"Negate a command or set its defaults\n"
	"packets to process at one time per fd\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, no_pim6_register_suppress_cmd_vtysh,
	"no register-suppress-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Register Suppress Timer\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, no_pim6_rp_cmd_vtysh,
	"no rp X:X::X:X$rp [X:X::X:X/M]$gp",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"Group Address range to cover\n")

DEFSH (VTYSH_PIM6D, no_pim6_rp_keep_alive_cmd_vtysh,
	"no rp keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIM6D, no_pim6_rp_prefix_list_cmd_vtysh,
	"no rp X:X::X:X$rp prefix-list PREFIXLIST6_NAME$plist",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIM6D, no_pim6_spt_switchover_infinity_cmd_vtysh,
	"no spt-switchover infinity-and-beyond",
	"Negate a command or set its defaults\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH (VTYSH_PIM6D, no_pim6_spt_switchover_infinity_plist_cmd_vtysh,
	"no spt-switchover infinity-and-beyond prefix-list PREFIXLIST6_NAME",
	"Negate a command or set its defaults\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIM6D, no_pim6_ssmpingd_cmd_vtysh,
	"no ssmpingd [X:X::X:X]$source",
	"Negate a command or set its defaults\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, no_pim_ecmp_cmd_vtysh,
	"no ecmp",
	"Negate a command or set its defaults\n"
	"Disable PIM ECMP \n")

DEFSH (VTYSH_PIMD, no_pim_ecmp_rebalance_cmd_vtysh,
	"no ecmp rebalance",
	"Negate a command or set its defaults\n"
	"Disable PIM ECMP \n"
	"Disable PIM ECMP Rebalance\n")

DEFSH (VTYSH_PIMD, no_pim_joinprune_time_cmd_vtysh,
	"no join-prune-interval [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Join Prune Send Interval\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, no_pim_keep_alive_cmd_vtysh,
	"no keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH_HIDDEN (VTYSH_PIMD, no_pim_mlag_cmd_vtysh,
	"no mlag",
	"Negate a command or set its defaults\n"
	"MLAG\n")

DEFSH (VTYSH_PIMD, no_pim_msdp_mesh_group_cmd_vtysh,
	"no msdp mesh-group WORD$gname",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group\n"
	"Mesh group name\n")

DEFSH (VTYSH_PIMD, no_pim_msdp_mesh_group_member_cmd_vtysh,
	"no msdp mesh-group WORD$gname member A.B.C.D$maddr",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group member\n"
	"Mesh group name\n"
	"Mesh group member\n"
	"Peer IP address\n")

DEFSH (VTYSH_PIMD, no_pim_msdp_mesh_group_source_cmd_vtysh,
	"no msdp mesh-group WORD$gname source [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP mesh-group source\n"
	"Mesh group name\n"
	"Mesh group source\n"
	"Mesh group local address\n")

DEFSH (VTYSH_PIMD, no_pim_msdp_peer_cmd_vtysh,
	"no msdp peer A.B.C.D",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"Delete MSDP peer\n"
	"peer ip address\n")

DEFSH (VTYSH_PIMD, no_pim_msdp_timers_cmd_vtysh,
	"no msdp timers [(1-65535) (1-65535) [(1-65535)]]",
	"Negate a command or set its defaults\n"
	"Configure multicast source discovery protocol\n"
	"MSDP timers configuration\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, no_pim_packets_cmd_vtysh,
	"no packets [(1-255)]",
	"Negate a command or set its defaults\n"
	"packets to process at one time per fd\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, no_pim_register_suppress_cmd_vtysh,
	"no register-suppress-time [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Register Suppress Timer\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, no_pim_rp_cmd_vtysh,
	"no rp A.B.C.D$rp [A.B.C.D/M]$gp",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"Group Address range to cover\n")

DEFSH (VTYSH_PIMD, no_pim_rp_keep_alive_cmd_vtysh,
	"no rp keep-alive-timer [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Ignored value in no form\n")

DEFSH (VTYSH_PIMD, no_pim_rp_prefix_list_cmd_vtysh,
	"no rp A.B.C.D$rp prefix-list PREFIXLIST4_NAME$plist",
	"Negate a command or set its defaults\n"
	"Rendezvous Point\n"
	"ip address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, no_pim_spt_switchover_infinity_cmd_vtysh,
	"no spt-switchover infinity-and-beyond",
	"Negate a command or set its defaults\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH (VTYSH_PIMD, no_pim_spt_switchover_infinity_plist_cmd_vtysh,
	"no spt-switchover infinity-and-beyond prefix-list PREFIXLIST4_NAME",
	"Negate a command or set its defaults\n"
	"SPT_Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIMD, no_pim_ssm_prefix_list_cmd_vtysh,
	"no ssm prefix-list",
	"Negate a command or set its defaults\n"
	"Source Specific Multicast\n"
	"group range prefix-list filter\n")

DEFSH (VTYSH_PIMD, no_pim_ssm_prefix_list_name_cmd_vtysh,
	"no ssm prefix-list PREFIXLIST4_NAME$plist",
	"Negate a command or set its defaults\n"
	"Source Specific Multicast\n"
	"group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, no_pim_ssmpingd_cmd_vtysh,
	"no ssmpingd [A.B.C.D]$src",
	"Negate a command or set its defaults\n"
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, no_pim_v6_secondary_cmd_vtysh,
	"no send-v6-secondary",
	"Negate a command or set its defaults\n"
	"Send v6 secondary addresses\n")

DEFSH (VTYSH_ZEBRA, no_pseudowire_if_cmd_vtysh,
	"no pseudowire IFNAME",
	"Negate a command or set its defaults\n"
	"Static pseudowire configuration\n"
	"Pseudowire name\n")

DEFSH (VTYSH_ISISD, no_psnp_interval_cmd_vtysh,
	"no isis psnp-interval [(1-120)] [level-1|level-2]$level",
	"Negate a command or set its defaults\n"
	"IS-IS routing protocol\n"
	"Set PSNP interval in seconds\n"
	"PSNP interval value\n"
	"Specify interval for level-1 PSNPs\n"
	"Specify interval for level-2 PSNPs\n")

DEFSH (VTYSH_MGMTD, no_rip_allow_ecmp_cmd_vtysh,
	"no allow-ecmp [(1-256)]",
	"Negate a command or set its defaults\n"
	"Allow Equal Cost MultiPath\n"
	"Number of paths\n")

DEFSH (VTYSH_MGMTD, no_rip_bfd_default_profile_cmd_vtysh,
	"no bfd default-profile [BFDPROF]",
	"Negate a command or set its defaults\n"
	"Bidirectional Forwarding Detection\n"
	"BFD default profile\n"
	"Profile name\n")

DEFSH (VTYSH_MGMTD, no_rip_default_metric_cmd_vtysh,
	"no default-metric [(1-16)]",
	"Negate a command or set its defaults\n"
	"Set a metric of redistribute routes\n"
	"Default metric\n")

DEFSH (VTYSH_MGMTD, no_rip_distance_cmd_vtysh,
	"no distance [(1-255)]",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"Distance value\n")

DEFSH (VTYSH_MGMTD, no_rip_distribute_list_cmd_vtysh,
	"no distribute-list [ACCESSLIST4_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, no_rip_distribute_list_prefix_cmd_vtysh,
	"no distribute-list prefix [PREFIXLIST4_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, no_rip_timers_cmd_vtysh,
	"no timers basic [(1-32767) (1-32767) (1-32767)]",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"Basic routing protocol update timers\n"
	"Routing table update timer value in second. Default is 30.\n"
	"Routing information timeout timer. Default is 180.\n"
	"Garbage collection timer. Default is 240.\n")

DEFSH (VTYSH_MGMTD, no_rip_version_cmd_vtysh,
	"no version [(1-2)]",
	"Negate a command or set its defaults\n"
	"Set routing protocol version\n"
	"version\n")

DEFSH (VTYSH_MGMTD, no_ripng_allow_ecmp_cmd_vtysh,
	"no allow-ecmp [(1-256)]",
	"Negate a command or set its defaults\n"
	"Allow Equal Cost MultiPath\n"
	"Number of paths\n")

DEFSH (VTYSH_MGMTD, no_ripng_default_metric_cmd_vtysh,
	"no default-metric [(1-16)]",
	"Negate a command or set its defaults\n"
	"Set a metric of redistribute routes\n"
	"Default metric\n")

DEFSH (VTYSH_MGMTD, no_ripng_ipv6_distribute_list_cmd_vtysh,
	"no ipv6 distribute-list [ACCESSLIST6_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, no_ripng_ipv6_distribute_list_prefix_cmd_vtysh,
	"no ipv6 distribute-list prefix [PREFIXLIST6_NAME$name] <in|out>$dir [WORD$ifname]",
	"Negate a command or set its defaults\n"
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, no_ripng_timers_cmd_vtysh,
	"no timers basic [(1-65535) (1-65535) (1-65535)]",
	"Negate a command or set its defaults\n"
	"RIPng timers setup\n"
	"Basic timer\n"
	"Routing table update timer value in second. Default is 30.\n"
	"Routing information timeout timer. Default is 180.\n"
	"Garbage collection timer. Default is 120.\n")

DEFSH (VTYSH_RMAP_CONFIG, no_rmap_call_cmd_vtysh,
	"no call [NAME]",
	"Negate a command or set its defaults\n"
	"Jump to another Route-Map after match+set\n"
	"Target route-map name\n")

DEFSH (VTYSH_RMAP_CONFIG, no_rmap_continue_cmd_vtysh,
	"no continue [(1-65535)]",
	"Negate a command or set its defaults\n"
	"Continue on a different entry within the route-map\n"
	"Route-map entry sequence number\n")

DEFSH (VTYSH_RMAP_CONFIG, no_rmap_description_cmd_vtysh,
	"no description",
	"Negate a command or set its defaults\n"
	"Route-map comment\n")

DEFSH (VTYSH_RMAP_CONFIG, no_rmap_onmatch_goto_cmd_vtysh,
	"no on-match goto [(1-65535)$rm_num]",
	"Negate a command or set its defaults\n"
	"Exit policy on matches\n"
	"Goto Clause number\n"
	"Number\n")

DEFSH (VTYSH_RMAP_CONFIG, no_rmap_onmatch_next_cmd_vtysh,
	"no on-match next",
	"Negate a command or set its defaults\n"
	"Exit policy on matches\n"
	"Next clause\n")

DEFSH (VTYSH_RMAP_CONFIG, no_route_map_all_cmd_vtysh,
	"no route-map RMAP_NAME$name",
	"Negate a command or set its defaults\n"
	"Create route-map or enter route-map command mode\n"
	"Route map tag\n")

DEFSH (VTYSH_RMAP_CONFIG, no_route_map_cmd_vtysh,
	"no route-map RMAP_NAME$name <deny|permit>$action (1-65535)$sequence",
	"Negate a command or set its defaults\n"
	"Create route-map or enter route-map command mode\n"
	"Route map tag\n"
	"Route map denies set operations\n"
	"Route map permits set operations\n"
	"Sequence to insert to/delete from existing route-map entry\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, no_route_map_match_address_cmd_vtysh,
	"no match ip <multicast-source$do_src|multicast-group$do_grp>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Multicast source address\n"
	"Multicast group address\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, no_route_map_match_address_v6_cmd_vtysh,
	"no match ipv6 <multicast-source$do_src|multicast-group$do_grp>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Multicast source address\n"
	"Multicast group address\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, no_route_map_match_interface_cmd_vtysh,
	"no match multicast-interface",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Multicast data interface\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, no_route_map_match_prefix_list_cmd_vtysh,
	"no match ip <multicast-source$do_src|multicast-group$do_grp> prefix-list",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Match against IPv4 prefix list\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, no_route_map_match_prefix_list_v6_cmd_vtysh,
	"no match ipv6 <multicast-source$do_src|multicast-group$do_grp> prefix-list",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Match against IPv6 prefix list\n")

DEFSH (VTYSH_BABELD, no_router_babel_cmd_vtysh,
	"no router babel",
	"Negate a command or set its defaults\n"
	"Disable a routing process\n"
	"Remove Babel instance command\n")

DEFSH (VTYSH_BGPD, no_router_bgp_cmd_vtysh,
	"no router bgp [ASNUM$instasn [<view|vrf> VIEWVRFNAME] [as-notation <dot|dot+|plain>]]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"BGP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Force the AS notation output\n"
	"use 'AA.BB' format for AS 4 byte values\n"
	"use 'AA.BB' format for all AS values\n"
	"use plain format for all AS values\n")

DEFSH (VTYSH_EIGRPD, no_router_eigrp_cmd_vtysh,
	"no router eigrp (1-65535)$as [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"EIGRP information\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH_HIDDEN (VTYSH_OSPFD, no_router_id_cmd_vtysh,
	"no router-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"router-id for the OSPF process\n"
	"OSPF router-id in IP address format\n")

DEFSH (VTYSH_OSPFD, no_router_info_cmd_vtysh,
	"no router-info [<area|as>]",
	"Negate a command or set its defaults\n"
	"Disable the Router Information functionality\n"
	"Disable the Router Information functionality with AS flooding scope\n"
	"Disable the Router Information functionality with Area flooding scope\n")

DEFSH (VTYSH_ISISD, no_router_isis_cmd_vtysh,
	"no router isis WORD$tag [vrf NAME$vrf_name]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"ISO IS-IS\n"
	"ISO Routing area tag\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_OSPF6D, no_router_ospf6_cmd_vtysh,
	"no router ospf6 [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_OSPFD, no_router_ospf_cmd_vtysh,
	"no router ospf [{(1-65535)|vrf NAME}]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Start OSPF configuration\n"
	"Instance ID\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIM6D, no_router_pim6_cmd_vtysh,
	"no router pim6 [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Start PIM6 configuration\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIMD, no_router_pim_cmd_vtysh,
	"no router pim [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Start PIM configuration\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, no_router_rip_cmd_vtysh,
	"no router rip [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Routing Information Protocol (RIP)\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, no_router_ripng_cmd_vtysh,
	"no router ripng [vrf NAME]",
	"Negate a command or set its defaults\n"
	"Enable a routing process\n"
	"Make RIPng instance command\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_BGPD, no_rpki_cache_cmd_vtysh,
	"no rpki cache <tcp|ssh> <A.B.C.D|WORD> <TCPPORT|(1-65535)$sshport SSH_UNAME SSH_PRIVKEY [KNOWN_HOSTS_PATH]> [source <A.B.C.D>$bindaddr] preference (1-255)",
	"Negate a command or set its defaults\n"
	"Control rpki specific settings\n"
	"Install a cache server to current group\n"
	"Use TCP\n"
	"Use SSH\n"
	"IP address of cache server\n"
	"Hostname of cache server\n"
	"TCP port number\n"
	"SSH port number\n"
	"SSH user name\n"
	"Path to own SSH private key\n"
	"Path to the known hosts file\n"
	"Configure source IP address of RPKI connection\n"
	"Define a Source IP Address\n"
	"Preference of the cache server\n"
	"Preference value\n")

DEFSH (VTYSH_BGPD, no_rpki_cmd_vtysh,
	"no rpki",
	"Negate a command or set its defaults\n"
	"Enable rpki and enter rpki configuration mode\n")

DEFSH (VTYSH_BGPD, no_rpki_expire_interval_cmd_vtysh,
	"no rpki expire_interval [(600-172800)]",
	"Negate a command or set its defaults\n"
	"Control rpki specific settings\n"
	"Set expire interval back to default\n"
	"Expire interval value\n")

DEFSH (VTYSH_BGPD, no_rpki_polling_period_cmd_vtysh,
	"no rpki polling_period [(1-86400)]",
	"Negate a command or set its defaults\n"
	"Control rpki specific settings\n"
	"Set polling period back to default\n"
	"Polling period value\n")

DEFSH (VTYSH_BGPD, no_rpki_retry_interval_cmd_vtysh,
	"no rpki retry_interval [(1-7200)]",
	"Negate a command or set its defaults\n"
	"Control rpki specific settings\n"
	"Set retry interval back to default\n"
	"retry interval value\n")

DEFSH (VTYSH_BFDD, no_sbfd_reflector_all_cmd_vtysh,
	"no sbfd reflector [all]",
	"Negate a command or set its defaults\n"
	"seamless BFD\n"
	"sbfd reflector\n"
	"all\n")

DEFSH (VTYSH_BFDD, no_sbfd_reflector_cmd_vtysh,
	"no sbfd reflector (0-4294967295)$start_discr [(0-4294967295)$end_discr]",
	"Negate a command or set its defaults\n"
	"seamless BFD\n"
	"sbfd reflector\n"
	"start discriminator\n"
	"end discriminator\n")

DEFSH (VTYSH_KEYS, no_send_lifetime_cmd_vtysh,
	"no send-lifetime",
	"Negate a command or set its defaults\n"
	"Unset send-lifetime\n")

DEFSH (VTYSH_ALL, no_service_advanced_vty_cmd_vtysh,
	"no service advanced-vty",
	"Negate a command or set its defaults\n"
	"Set up miscellaneous service\n"
	"Enable advanced mode vty interface\n")

DEFSH (VTYSH_BGPD, no_set_aggregator_as_cmd_vtysh,
	"no set aggregator as [ASNUM A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP aggregator attribute\n"
	"AS number of aggregator\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"IP address of aggregator\n")

DEFSH (VTYSH_BGPD, no_set_aigp_metric_cmd_vtysh,
	"no set aigp-metric [<igp-metric|(0-4294967295)>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP AIGP attribute (AIGP Metric TLV)\n"
	"AIGP Metric value from IGP protocol\n"
	"Manual AIGP Metric value\n")

DEFSH (VTYSH_BGPD, no_set_aspath_exclude_access_list_cmd_vtysh,
	"no set as-path exclude as-path-access-list [AS_PATH_FILTER_NAME]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Exclude from the as-path\n"
	"Specify an as path access list name\n"
	"AS path access list name\n")

DEFSH (VTYSH_BGPD, no_set_aspath_exclude_all_cmd_vtysh,
	"no set as-path exclude",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Exclude from the as-path\n")

DEFSH (VTYSH_BGPD, no_set_aspath_exclude_cmd_vtysh,
	"no set as-path exclude ASNUM...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Exclude from the as-path\n"
	"AS number\n")

DEFSH (VTYSH_BGPD, no_set_aspath_prepend_as_cmd_vtysh,
	"no set as-path prepend ASNUM...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Prepend to the as-path\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, no_set_aspath_prepend_last_as_cmd_vtysh,
	"no set as-path prepend [last-as [(1-10)]]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Prepend to the as-path\n"
	"Use the peers AS-number\n"
	"Number of times to insert\n")

DEFSH (VTYSH_BGPD, no_set_aspath_replace_access_list_cmd_vtysh,
	"no set as-path replace as-path-access-list [AS_PATH_FILTER_NAME] [<ASNUM>$configured_asn]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Replace AS number to local or configured AS number\n"
	"Specify an as path access list name\n"
	"AS path access list name\n"
	"Define the configured AS number\n")

DEFSH (VTYSH_BGPD, no_set_aspath_replace_asn_cmd_vtysh,
	"no set as-path replace [<any|ASNUM>] [<ASNUM>$configured_asn]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Replace AS number to local or configured AS number\n"
	"Replace any AS number to local or configured AS number\n"
	"Replace a specific AS number to local or configured AS number\n"
	"Define the configured AS number\n")

DEFSH (VTYSH_BGPD, no_set_atomic_aggregate_cmd_vtysh,
	"no set atomic-aggregate",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP atomic aggregate attribute\n")

DEFSH (VTYSH_BGPD, no_set_community_cmd_vtysh,
	"no set community AA:NN...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP community attribute\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, no_set_community_delete_cmd_vtysh,
	"no set comm-list [<(1-99)|(100-500)|COMMUNITY_LIST_NAME> delete]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"set BGP community list (for deletion)\n"
	"Community-list number (standard)\n"
	"Community-list number (expanded)\n"
	"Community-list name\n"
	"Delete matching communities\n")

DEFSH (VTYSH_BGPD, no_set_community_short_cmd_vtysh,
	"no set community",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP community attribute\n")

DEFSH (VTYSH_BGPD, no_set_distance_cmd_vtysh,
	"no set distance [(1-255)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP Administrative Distance to use\n"
	"Distance value\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_color_all_cmd_vtysh,
	"no set extcommunity color",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Color extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_color_cmd_vtysh,
	"no set extcommunity color RTLIST...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Color extended community\n"
	"Color ID\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_delete_cmd_vtysh,
	"no set extended-comm-list [<(1-99)|(100-500)|EXTCOMMUNITY_LIST_NAME>] delete",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"set BGP extended community list (for deletion)\n"
	"Extended community-list number (standard)\n"
	"Extended community-list number (expanded)\n"
	"Extended community-list name\n"
	"Delete matching extended communities\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_lb_cmd_vtysh,
	"no set extcommunity bandwidth <(0-4294967295)|cumulative|num-multipaths> [non-transitive]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Link bandwidth extended community\n"
	"Bandwidth value in Mbps\n"
	"Cumulative bandwidth of all multipaths (outbound-only)\n"
	"Internally computed bandwidth based on number of multipaths (outbound-only)\n"
	"Attribute is set as non-transitive\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_lb_short_cmd_vtysh,
	"no set extcommunity bandwidth",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Link bandwidth extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_none_cmd_vtysh,
	"no set extcommunity none",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"No extended community attribute\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_nt_cmd_vtysh,
	"no set extcommunity nt RTLIST...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Node Target extended community\n"
	"Node Target ID\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_nt_short_cmd_vtysh,
	"no set extcommunity nt",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Node Target extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_rt_cmd_vtysh,
	"no set extcommunity rt ASN:NN_OR_IP-ADDRESS:NN...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Route Target extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_rt_short_cmd_vtysh,
	"no set extcommunity rt",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Route Target extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_soo_cmd_vtysh,
	"no set extcommunity soo ASN:NN_OR_IP-ADDRESS:NN...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Site-of-Origin extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, no_set_ecommunity_soo_short_cmd_vtysh,
	"no set extcommunity soo",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"GP extended community attribute\n"
	"Site-of-Origin extended community\n")

DEFSH (VTYSH_BGPD, no_set_evpn_gw_ip_ipv4_cmd_vtysh,
	"no set evpn gateway-ip ipv4 A.B.C.D",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Ethernet Virtual Private Network\n"
	"Set gateway IP for prefix advertisement route\n"
	"IPv4 address\n"
	"Gateway IP address in IPv4 format\n")

DEFSH (VTYSH_BGPD, no_set_evpn_gw_ip_ipv6_cmd_vtysh,
	"no set evpn gateway-ip ipv6 X:X::X:X",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Ethernet Virtual Private Network\n"
	"Set gateway IP for prefix advertisement route\n"
	"IPv4 address\n"
	"Gateway IP address in IPv4 format\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_ip_nexthop_cmd_vtysh,
	"no set ip next-hop [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IP information\n"
	"Next hop address\n"
	"IP address of next hop\n")

DEFSH (VTYSH_BGPD, no_set_ipv6_nexthop_global_cmd_vtysh,
	"no set ipv6 next-hop global X:X::X:X",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"IPv6 global address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_ipv6_nexthop_local_cmd_vtysh,
	"no set ipv6 next-hop local [X:X::X:X]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"IPv6 local address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_BGPD, no_set_ipv6_nexthop_peer_cmd_vtysh,
	"no set ipv6 next-hop peer-address",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"Use peer address (for BGP only)\n")

DEFSH (VTYSH_BGPD, no_set_ipv6_nexthop_prefer_global_cmd_vtysh,
	"no set ipv6 next-hop prefer-global",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"Prefer global over link-local if both exist\n")

DEFSH (VTYSH_BGPD, no_set_ipx_vpn_nexthop_cmd_vtysh,
	"no set <ipv4|ipv6> vpn next-hop [<A.B.C.D|X:X::X:X>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IPv4 information\n"
	"IPv6 information\n"
	"VPN information\n"
	"VPN next-hop address\n"
	"IP address of next hop\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_BGPD, no_set_label_index_cmd_vtysh,
	"no set label-index [(0-1048560)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Label index to associate with the prefix\n"
	"Label index value\n")

DEFSH (VTYSH_BGPD, no_set_lcommunity1_cmd_vtysh,
	"no set large-community AA:BB:CC...",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP large community attribute\n"
	"Large community in AA:BB:CC... format or additive\n")

DEFSH (VTYSH_BGPD, no_set_lcommunity1_short_cmd_vtysh,
	"no set large-community",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP large community attribute\n")

DEFSH (VTYSH_BGPD, no_set_lcommunity_cmd_vtysh,
	"no set large-community none",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP large community attribute\n"
	"No community attribute\n")

DEFSH (VTYSH_BGPD, no_set_lcommunity_delete_cmd_vtysh,
	"no set large-comm-list <(1-99)|(100-500)|LCOMMUNITY_LIST_NAME> [delete]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"set BGP large community list (for deletion)\n"
	"Large Community-list number (standard)\n"
	"Large Communitly-list number (expanded)\n"
	"Large Community-list name\n"
	"Delete matching large communities\n")

DEFSH (VTYSH_BGPD, no_set_lcommunity_delete_short_cmd_vtysh,
	"no set large-comm-list",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"set BGP large community list (for deletion)\n")

DEFSH (VTYSH_BGPD, no_set_local_pref_cmd_vtysh,
	"no set local-preference [WORD]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP local preference path attribute\n"
	"Preference value (0-4294967295)\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_max_metric_cmd_vtysh,
	"no set max-metric [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Maximum Metric value for destination routing protocol\n"
	"Maximum metric value\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_metric_cmd_vtysh,
	"no set metric [OPTVAL]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Metric value for destination routing protocol\n"
	"Metric value\n")

DEFSH (VTYSH_OSPF6D|VTYSH_OSPFD, no_set_metric_type_cmd_vtysh,
	"no set metric-type [<type-1|type-2>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Type of metric for destination routing protocol\n"
	"OSPF[6] external type 1 metric\n"
	"OSPF[6] external type 2 metric\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_min_metric_cmd_vtysh,
	"no set min-metric [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Minimum metric value for destination routing protocol\n"
	"Minimum metric value\n")

DEFSH (VTYSH_BGPD, no_set_origin_cmd_vtysh,
	"no set origin [<egp|igp|incomplete>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP origin code\n"
	"remote EGP\n"
	"local IGP\n"
	"unknown heritage\n")

DEFSH (VTYSH_BGPD, no_set_originator_id_cmd_vtysh,
	"no set originator-id [A.B.C.D]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP originator ID attribute\n"
	"IP address of originator\n")

DEFSH (VTYSH_ISISD, no_set_overload_bit_on_startup_cmd_vtysh,
	"no set-overload-bit on-startup [(0-86400)$val]",
	"Negate a command or set its defaults\n"
	"Reset overload bit to accept transit traffic\n"
	"Set overload bit on startup\n"
	"Set overload time in seconds\n")

DEFSH (VTYSH_MGMTD, no_set_src_cmd_vtysh,
	"no set src [<A.B.C.D|X:X::X:X>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Source address for route\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_srte_color_cmd_vtysh,
	"no set sr-te color [(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"SR-TE information\n"
	"SR-TE Color information\n"
	"Color of the SR-TE Policies to match with\n")

DEFSH (VTYSH_BGPD, no_set_table_id_cmd_vtysh,
	"no set table [(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"export route to non-main kernel table\n"
	"Kernel routing table id\n")

DEFSH (VTYSH_RMAP_CONFIG, no_set_tag_cmd_vtysh,
	"no set tag [<untagged|(1-4294967295)>]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Tag value for routing protocol\n"
	"Untagged route\n"
	"Tag value\n")

DEFSH (VTYSH_BGPD, no_set_weight_cmd_vtysh,
	"no set weight [(0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"BGP weight for routing table\n"
	"Weight value\n")

DEFSH (VTYSH_ISISD, no_spf_backoff_debug_cmd_vtysh,
	"no debug spf-delay-ietf",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"SPF Back-off Debugging\n")

DEFSH (VTYSH_ISISD, no_spf_delay_ietf_cmd_vtysh,
	"no spf-delay-ietf [init-delay (0-60000) short-delay (0-60000) long-delay (0-60000) holddown (0-60000) time-to-learn (0-60000)]",
	"Negate a command or set its defaults\n"
	"IETF SPF delay algorithm\n"
	"Delay used while in QUIET state\n"
	"Delay used while in QUIET state in milliseconds\n"
	"Delay used while in SHORT_WAIT state\n"
	"Delay used while in SHORT_WAIT state in milliseconds\n"
	"Delay used while in LONG_WAIT\n"
	"Delay used while in LONG_WAIT state in milliseconds\n"
	"Time with no received IGP events before considering IGP stable\n"
	"Time with no received IGP events before considering IGP stable (in milliseconds)\n"
	"Maximum duration needed to learn all the events related to a single failure\n"
	"Maximum duration needed to learn all the events related to a single failure (in milliseconds)\n")

DEFSH (VTYSH_ISISD, no_spf_interval_cmd_vtysh,
	"no spf-interval [level-1|level-2]$level [(1-120)]",
	"Negate a command or set its defaults\n"
	"Minimum interval between SPF calculations\n"
	"Set interval for level 1 only\n"
	"Set interval for level 2 only\n"
	"Minimum interval between consecutive SPFs in seconds\n")

DEFSH (VTYSH_ISISD, no_spf_prefix_priority_cmd_vtysh,
	"no spf prefix-priority <critical|high|medium>$priority [ACCESSLIST_NAME]",
	"Negate a command or set its defaults\n"
	"SPF configuration\n"
	"Configure a prefix priority list\n"
	"Specify critical priority prefixes\n"
	"Specify high priority prefixes\n"
	"Specify medium priority prefixes\n"
	"Access-list name\n")

DEFSH (VTYSH_OSPFD, no_sr_global_label_range_cmd_vtysh,
	"no segment-routing global-block [(16-1048575) (16-1048575) local-block (16-1048575) (16-1048575)]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Segment Routing Global Block label range\n"
	"Lower-bound range in decimal (16-1048575)\n"
	"Upper-bound range in decimal (16-1048575)\n"
	"Segment Routing Local Block label range\n"
	"Lower-bound range in decimal (16-1048575)\n"
	"Upper-bound range in decimal (16-1048575)\n")

DEFSH (VTYSH_OSPFD, no_sr_node_msd_cmd_vtysh,
	"no segment-routing node-msd [(1-16)]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Maximum Stack Depth for this router\n"
	"Maximum number of label that could be stack (1-16)\n")

DEFSH (VTYSH_OSPFD, no_sr_prefix_sid_cmd_vtysh,
	"no segment-routing prefix A.B.C.D/M [index (0-65535)|no-php-flag|explicit-null]",
	"Negate a command or set its defaults\n"
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix as A.B.C.D/M\n"
	"SID index for this prefix in decimal (0-65535)\n"
	"Index value inside SRGB (lower_bound < index < upper_bound)\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n")

DEFSH (VTYSH_MGMTD|VTYSH_ZEBRA, no_srv6_cmd_vtysh,
	"no srv6",
	"Negate a command or set its defaults\n"
	"Segment Routing SRv6\n")

DEFSH (VTYSH_ZEBRA, no_srv6_locator_cmd_vtysh,
	"no locator WORD",
	"Negate a command or set its defaults\n"
	"Segment Routing SRv6 locator\n"
	"Specify locator-name\n")

DEFSH (VTYSH_MGMTD, no_srv6_sid_cmd_vtysh,
	"no sid X:X::X:X/M [locator NAME$locator_name] [behavior <uN | uA interface INTERFACE$interface [nexthop X:X::X:X$nh6] | uDT6 vrf VIEWVRFNAME | uDT4 vrf VIEWVRFNAME | uDT46 vrf VIEWVRFNAME>]",
	"Negate a command or set its defaults\n"
	"Configure SRv6 SID\n"
	"Specify SRv6 SID\n"
	"Locator name\n"
	"Specify Locator name\n"
	"Specify SRv6 SID behavior\n"
	"Apply the code to a uN SID\n"
	"Behavior uA\n"
	"Configure the interface\n"
	"Interface name\n"
	"Configure the nexthop\n"
	"IPv6 address of the nexthop\n"
	"Apply the code to an uDT6 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n"
	"Apply the code to an uDT4 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n"
	"Apply the code to an uDT46 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_explicit_cmd_vtysh,
	"no explicit [start (0-4294967295)$start]",
	"Negate a command or set its defaults\n"
	"Configure Explicit range\n"
	"Configure the start value for the Explicit range\n"
	"Specify the start value for the Explicit range\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_f3216_usid_cmd_vtysh,
	"no format usid-f3216",
	"Negate a command or set its defaults\n"
	"Configure SRv6 SID format\n"
	"Configure the uSID f3216 format\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_f4024_uncompressed_cmd_vtysh,
	"no format uncompressed-f4024",
	"Negate a command or set its defaults\n"
	"Configure SRv6 SID format\n"
	"Configure the uncompressed f4024 format\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_f4816_usid_cmd_vtysh,
	"no format usid-f4816",
	"Negate a command or set its defaults\n"
	"Configure SRv6 SID format\n"
	"Configure the uSID f4816 format\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_usid_lib_cmd_vtysh,
	"no local-id-block [start (0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Configure LIB\n"
	"Configure the start value for the LIB\n"
	"Specify the start value for the LIB\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_usid_lib_explicit_cmd_vtysh,
	"no local-id-block explicit [start (0-4294967295) end (0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Configure LIB\n"
	"Configure the Explicit LIB\n"
	"Configure the start value for the Explicit LIB\n"
	"Specify the start value for the Explicit LIB\n"
	"Configure the end value for the Explicit LIB\n"
	"Specify the end value for the Explicit LIB\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_usid_wide_lib_explicit_cmd_vtysh,
	"no wide-local-id-block explicit [start (0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Configure Wide LIB\n"
	"Configure Explicit Wide LIB\n"
	"Configure the start value for the Explicit Wide LIB\n"
	"Specify the start value for the Explicit Wide LIB\n")

DEFSH (VTYSH_ZEBRA, no_srv6_sid_format_usid_wlib_cmd_vtysh,
	"no wide-local-id-block [start (0-4294967295) end (0-4294967295)]",
	"Negate a command or set its defaults\n"
	"Configure Wide LIB\n"
	"Configure the start value for the Wide LIB\n"
	"Specify the start value for the Wide LIB\n"
	"Configure the end value for the Wide LIB\n"
	"Specify the end value for the Wide LIB\n")

DEFSH (VTYSH_ZEBRA, no_srv6_src_addr_cmd_vtysh,
	"no source-address [X:X::X:X$encap_src_addr]",
	"Negate a command or set its defaults\n"
	"Segment Routing SRv6 source address\n"
	"Specify source address for SRv6 encapsulation\n")

DEFSH (VTYSH_NHRPD, no_tunnel_protection_cmd_vtysh,
	"no tunnel protection [vici profile PROFILE [fallback-profile FALLBACK]]",
	"Negate a command or set its defaults\n"
	"NHRP/GRE integration\n"
	"IPsec protection\n"
	"VICI (StrongSwan)\n"
	"IPsec profile\n"
	"IPsec profile name\n"
	"Fallback IPsec profile\n"
	"Fallback IPsec profile name\n")

DEFSH (VTYSH_NHRPD, no_tunnel_source_cmd_vtysh,
	"no tunnel source",
	"NHRP/GRE integration\n"
	"Tunnel device binding tracking\n"
	"Interface name\n")

DEFSH (VTYSH_BGPD, no_vpnv4_network_cmd_vtysh,
	"no network A.B.C.D/M rd ASN:NN_OR_IP-ADDRESS:NN <tag|label> (0-1048575)",
	"Negate a command or set its defaults\n"
	"Specify a network to announce via BGP\n"
	"IPv4 prefix\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"VPN NLRI label (tag)\n"
	"VPN NLRI label (tag)\n"
	"Label value\n")

DEFSH (VTYSH_BGPD, no_vpnv6_network_cmd_vtysh,
	"no network X:X::X:X/M rd ASN:NN_OR_IP-ADDRESS:NN <tag|label> (0-1048575)",
	"Negate a command or set its defaults\n"
	"Specify a network to announce via BGP\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"VPN NLRI label (tag)\n"
	"VPN NLRI label (tag)\n"
	"Label value\n")

DEFSH (VTYSH_VRF, no_vrf_cmd_vtysh,
	"no vrf NAME",
	"Negate a command or set its defaults\n"
	"Delete a pseudo VRF's configuration\n"
	"VRF's name\n")

DEFSH (VTYSH_VRF, no_vrf_debug_cmd_vtysh,
	"no debug vrf",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"VRF Debugging\n")

DEFSH (VTYSH_VRRPD, no_vrrp_advertisement_interval_cmd_vtysh,
	"no vrrp (1-255)$vrid advertisement-interval [(10-40950)]",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Virtual Router Advertisement Interval\n"
	"Advertisement interval in milliseconds; must be multiple of 10\n")

DEFSH (VTYSH_VRRPD, no_vrrp_priority_cmd_vtysh,
	"no vrrp (1-255)$vrid priority [(1-254)]",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Virtual Router Priority\n"
	"Priority value\n")

DEFSH (VTYSH_ALL, no_vty_access_class_cmd_vtysh,
	"no access-class [WORD]",
	"Negate a command or set its defaults\n"
	"Filter connections based on an IP access list\n"
	"IP access list\n")

DEFSH (VTYSH_ALL, no_vty_ipv6_access_class_cmd_vtysh,
	"no ipv6 access-class [WORD]",
	"Negate a command or set its defaults\n"
	"IPv6 information\n"
	"Filter connections based on an IP access list\n"
	"IPv6 access list\n")

DEFSH (VTYSH_ALL, no_vty_login_cmd_vtysh,
	"no login",
	"Negate a command or set its defaults\n"
	"Enable password checking\n")

DEFSH (VTYSH_OSPFD, no_write_multiplier_cmd_vtysh,
	"no write-multiplier [(1-100)]",
	"Negate a command or set its defaults\n"
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_ZEBRA, no_zebra_dplane_queue_limit_cmd_vtysh,
	"no zebra dplane limit [(0-10000)]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Zebra dataplane\n"
	"Limit incoming queued updates\n"
	"Number of queued updates\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, no_zebra_kernel_netlink_batch_tx_buf_cmd_vtysh,
	"no zebra kernel netlink batch-tx-buf [(0-1048576)] [(0-1048576)]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Zebra kernel interface\n"
	"Set Netlink parameters\n"
	"Set batch buffer size and send threshold\n"
	"Size of the buffer\n"
	"Send threshold\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, no_zebra_packet_process_cmd_vtysh,
	"no zebra zapi-packets [(1-10000)]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Zapi Protocol\n"
	"Number of packets to process before relinquishing thread\n")

DEFSH (VTYSH_ZEBRA, no_zebra_protodown_bit_cmd_vtysh,
	"no zebra protodown reason-bit [(0-31)$bit]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Protodown Configuration\n"
	"Reason Bit used in the kernel for setting protodown\n"
	"Reason Bit Range\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, no_zebra_workqueue_timer_cmd_vtysh,
	"no zebra work-queue [(0-10000)]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Work Queue\n"
	"Time in milliseconds\n")

DEFSH (VTYSH_OSPF6D, ospf6_area_nssa_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)>$area_str nssa        [{	  default-information-originate$dflt_originate [{metric (0-16777214)$mval|metric-type (1-2)$mtype}]	  |no-summary$no_summary	 }]",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as nssa\n"
	"Originate Type 7 default into NSSA area\n"
	"OSPFv3 default metric\n"
	"OSPFv3 metric\n"
	"OSPFv3 metric type for default routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n"
	"Do not inject inter-area routes into area\n")

DEFSH (VTYSH_OSPF6D, ospf6_area_stub_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> stub",
	"OSPF6 area parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as stub\n")

DEFSH (VTYSH_OSPF6D, ospf6_area_stub_no_summary_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> stub no-summary",
	"OSPF6 stub parameters\n"
	"OSPF6 area ID in IP address format\n"
	"OSPF6 area ID as a decimal value\n"
	"Configure OSPF6 area as stub\n"
	"Do not inject inter-area routes into stub\n")

DEFSH (VTYSH_OSPF6D, ospf6_default_route_originate_cmd_vtysh,
	"default-information originate [{always$always|metric (0-16777214)$mval|metric-type (1-2)$mtype|route-map RMAP_NAME$rtmap}]",
	"Control distribution of default route\n"
	"Distribute a default route\n"
	"Always advertise default route\n"
	"OSPFv3 default metric\n"
	"OSPFv3 metric\n"
	"OSPFv3 metric type for default routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPF6D, ospf6_distance_cmd_vtysh,
	"distance (1-255)",
	"Administrative distance\n"
	"OSPF6 Administrative distance\n")

DEFSH (VTYSH_OSPF6D, ospf6_distance_ospf6_cmd_vtysh,
	"distance ospf6 {intra-area (1-255)|inter-area (1-255)|external (1-255)}",
	"Administrative distance\n"
	"OSPF6 administrative distance\n"
	"Intra-area routes\n"
	"Distance for intra-area routes\n"
	"Inter-area routes\n"
	"Distance for inter-area routes\n"
	"External routes\n"
	"Distance for external routes\n")

DEFSH (VTYSH_OSPF6D, ospf6_external_route_aggregation_cmd_vtysh,
	"summary-address X:X::X:X/M$prefix [tag (1-4294967295)] [{metric (0-16777215) | metric-type (1-2)$mtype}]",
	"External summary address\n"
	"Specify IPv6 prefix\n"
	"Router tag \n"
	"Router tag value\n"
	"Metric \n"
	"Advertised metric for this route\n"
	"OSPFv3 exterior metric type for summarised routes\n"
	"Set OSPFv3 External Type 1/2 metrics\n")

DEFSH (VTYSH_OSPF6D, ospf6_external_route_aggregation_no_advertise_cmd_vtysh,
	"summary-address X:X::X:X/M$prefix no-advertise",
	"External summary address\n"
	"Specify IPv6 prefix\n"
	"Don't advertise summary route \n")

DEFSH (VTYSH_OSPF6D, ospf6_gr_helper_disable_cmd_vtysh,
	"no graceful-restart helper enable [A.B.C.D$rtr_id]",
	"Negate a command or set its defaults\n"
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"Enable Helper support\n"
	"Advertisement Router-ID\n")

DEFSH (VTYSH_OSPF6D, ospf6_gr_helper_disable_lsacheck_cmd_vtysh,
	"graceful-restart helper lsa-check-disable",
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"disable strict LSA check\n")

DEFSH (VTYSH_OSPF6D, ospf6_gr_helper_enable_cmd_vtysh,
	"graceful-restart helper enable [A.B.C.D$rtr_id]",
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"Enable Helper support\n"
	"Advertisement Router-ID\n")

DEFSH (VTYSH_OSPF6D, ospf6_gr_helper_planned_only_cmd_vtysh,
	"graceful-restart helper planned-only",
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"supported only planned restart\n")

DEFSH (VTYSH_OSPF6D, ospf6_gr_helper_supported_grace_time_cmd_vtysh,
	"graceful-restart helper supported-grace-time (10-1800)$interval",
	"ospf6 graceful restart\n"
	"ospf6 GR Helper\n"
	"supported grace timer\n"
	"grace interval(in seconds)\n")

DEFSH (VTYSH_OSPF6D, ospf6_graceful_restart_cmd_vtysh,
	"graceful-restart [grace-period (1-1800)$grace_period]",
	"OSPF non-stop forwarding (NSF) also known as OSPF Graceful Restart\n"
	"Maximum length of the 'grace period'\n"
	"Maximum length of the 'grace period' in seconds\n")

DEFSH (VTYSH_OSPF6D, ospf6_graceful_restart_prepare_cmd_vtysh,
	"graceful-restart prepare ipv6 ospf",
	"Graceful Restart commands\n"
	"Prepare upcoming graceful restart\n"
	"IPv6 information\n"
	"Prepare to restart the OSPFv3 process\n")

DEFSH (VTYSH_OSPF6D, ospf6_log_adjacency_changes_cmd_vtysh,
	"log-adjacency-changes",
	"Log changes in adjacency state\n")

DEFSH (VTYSH_OSPF6D, ospf6_log_adjacency_changes_detail_cmd_vtysh,
	"log-adjacency-changes detail",
	"Log changes in adjacency state\n"
	"Log all state changes\n")

DEFSH (VTYSH_OSPF6D, ospf6_max_multipath_cmd_vtysh,
	"maximum-paths (1-256)",
	"Max no of multiple paths for ECMP support\n"
	"Number of paths\n")

DEFSH (VTYSH_OSPF6D, ospf6_no_graceful_restart_cmd_vtysh,
	"no graceful-restart [period (1-1800)]",
	"Negate a command or set its defaults\n"
	"OSPF non-stop forwarding (NSF) also known as OSPF Graceful Restart\n"
	"Maximum length of the 'grace period'\n"
	"Maximum length of the 'grace period' in seconds\n")

DEFSH (VTYSH_OSPF6D, ospf6_redistribute_cmd_vtysh,
	"redistribute <kernel|connected|local|static|ripng|isis|bgp|nhrp|vnc|babel|openfabric>[{metric (0-16777214)|metric-type (1-2)$metric_type|route-map RMAP_NAME$rmap_str}]",
	"Redistribute\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Route map name\n")

DEFSH (VTYSH_OSPF6D, ospf6_route_aggregation_timer_cmd_vtysh,
	"aggregation timer (5-1800)",
	"External route aggregation\n"
	"Delay timer (in seconds)\n"
	"Timer interval(in seconds)\n")

DEFSH (VTYSH_OSPF6D, ospf6_routemap_no_set_forwarding_cmd_vtysh,
	"no set forwarding-address [X:X::X:X]",
	"Negate a command or set its defaults\n"
	"Set value\n"
	"Forwarding Address\n"
	"IPv6 Address\n")

DEFSH (VTYSH_OSPF6D, ospf6_routemap_set_forwarding_cmd_vtysh,
	"set forwarding-address X:X::X:X",
	"Set value\n"
	"Forwarding Address\n"
	"IPv6 Address\n")

DEFSH (VTYSH_OSPF6D, ospf6_router_id_cmd_vtysh,
	"ospf6 router-id A.B.C.D",
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Configure OSPF6 Router-ID\n"
	"specify by IPv4 address notation(e.g. 0.0.0.0)\n")

DEFSH (VTYSH_OSPF6D, ospf6_send_extra_data_cmd_vtysh,
	"[no] ospf6 send-extra-data zebra",
	"Negate a command or set its defaults\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Extra data to Zebra for display/use\n"
	"To zebra\n")

DEFSH (VTYSH_OSPF6D, ospf6_stub_router_admin_cmd_vtysh,
	"stub-router administrative",
	"Make router a stub router\n"
	"Administratively applied, for an indefinite period\n")

DEFSH (VTYSH_OSPF6D, ospf6_timers_lsa_cmd_vtysh,
	"timers lsa min-arrival (0-600000)",
	"Adjust routing timers\n"
	"OSPF6 LSA timers\n"
	"Minimum delay in receiving new version of a LSA\n"
	"Delay in milliseconds\n")

DEFSH (VTYSH_OSPF6D, ospf6_timers_throttle_spf_cmd_vtysh,
	"timers throttle spf (0-600000) (0-600000) (0-600000)",
	"Adjust routing timers\n"
	"Throttling adaptive timer\n"
	"OSPF6 SPF timers\n"
	"Delay (msec) from first change received till SPF calculation\n"
	"Initial hold time (msec) between consecutive SPF calculations\n"
	"Maximum hold time (msec)\n")

DEFSH (VTYSH_OSPF6D, ospf6_write_multiplier_cmd_vtysh,
	"write-multiplier (1-100)",
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_OSPFD, ospf_abr_type_cmd_vtysh,
	"ospf abr-type <cisco|ibm|shortcut|standard>",
	"OSPF specific commands\n"
	"Set OSPF ABR type\n"
	"Alternative ABR, cisco implementation\n"
	"Alternative ABR, IBM implementation\n"
	"Shortcut ABR\n"
	"Standard behavior (RFC2328)\n")

DEFSH (VTYSH_OSPFD, ospf_area_authentication_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> authentication",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Enable authentication\n")

DEFSH (VTYSH_OSPFD, ospf_area_authentication_message_digest_cmd_vtysh,
	"[no] area <A.B.C.D|(0-4294967295)> authentication message-digest",
	"Negate a command or set its defaults\n"
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Enable authentication\n"
	"Use message-digest authentication\n")

DEFSH (VTYSH_OSPFD, ospf_area_default_cost_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> default-cost (0-16777215)",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Set the summary-default cost of a NSSA or stub area\n"
	"Stub's advertised default summary cost\n")

DEFSH (VTYSH_OSPFD, ospf_area_export_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> export-list ACCESSLIST4_NAME",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Set the filter for networks announced to other areas\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPFD, ospf_area_filter_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> filter-list prefix PREFIXLIST4_NAME <in|out>",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Filter networks between OSPF areas\n"
	"Filter prefixes between OSPF areas\n"
	"Name of an IP prefix-list\n"
	"Filter networks sent to this area\n"
	"Filter networks sent from this area\n")

DEFSH (VTYSH_OSPFD, ospf_area_import_list_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> import-list ACCESSLIST4_NAME",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Set the filter for networks from other areas announced to the specified one\n"
	"Name of the access-list\n")

DEFSH (VTYSH_OSPFD, ospf_area_nssa_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)>$area_str nssa         [{	   <translate-candidate|translate-never|translate-always>$translator_role	   |default-information-originate$dflt_originate [{metric (0-16777214)$mval|metric-type (1-2)$mtype}]	   |no-summary$no_summary	   |suppress-fa$suppress_fa	 }]",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as nssa\n"
	"Configure NSSA-ABR for translate election (default)\n"
	"Configure NSSA-ABR to never translate\n"
	"Configure NSSA-ABR to always translate\n"
	"Originate Type 7 default into NSSA area\n"
	"OSPF default metric\n"
	"OSPF metric\n"
	"OSPF metric type for default routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Do not inject inter-area routes into nssa\n"
	"Suppress forwarding address\n")

DEFSH (VTYSH_OSPFD, ospf_area_nssa_range_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)>$area_str nssa range A.B.C.D/M$prefix [<not-advertise$not_adv|cost (0-16777215)$cost>]",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as nssa\n"
	"Configured address range\n"
	"Specify IPv4 prefix\n"
	"Do not advertise\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_OSPFD, ospf_area_range_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> range A.B.C.D/M [advertise [cost (0-16777215)]]",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Summarize routes matching address/mask (border routers only)\n"
	"Area range prefix\n"
	"Advertise this range (default)\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n")

DEFSH (VTYSH_OSPFD, ospf_area_range_cost_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> range A.B.C.D/M {cost (0-16777215)|substitute A.B.C.D/M}",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Summarize routes matching address/mask (border routers only)\n"
	"Area range prefix\n"
	"User specified metric for this range\n"
	"Advertised metric for this range\n"
	"Announce area range as another prefix\n"
	"Network prefix to be announced instead of range\n")

DEFSH (VTYSH_OSPFD, ospf_area_range_not_advertise_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> range A.B.C.D/M not-advertise",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Summarize routes matching address/mask (border routers only)\n"
	"Area range prefix\n"
	"DoNotAdvertise this range\n")

DEFSH (VTYSH_OSPFD, ospf_area_shortcut_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> shortcut <default|enable|disable>",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure the area's shortcutting mode\n"
	"Set default shortcutting behavior\n"
	"Enable shortcutting through the area\n"
	"Disable shortcutting through the area\n")

DEFSH (VTYSH_OSPFD, ospf_area_stub_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> stub",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as stub\n")

DEFSH (VTYSH_OSPFD, ospf_area_stub_no_summary_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> stub no-summary",
	"OSPF stub parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure OSPF area as stub\n"
	"Do not inject inter-area routes into stub\n")

DEFSH (VTYSH_OSPFD, ospf_area_vlink_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> virtual-link A.B.C.D [authentication [<key-chain KEYCHAIN_NAME|message-digest|null>]] [<message-digest-key (1-255) md5 KEY|authentication-key AUTH_KEY>]",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure a virtual link\n"
	"Router ID of the remote ABR\n"
	"Enable authentication on this virtual link\n"
	"Use a key-chain for cryptographic authentication keys\n"
	"Key-chain name\n"
	"Use message-digest authentication\n"
	"Use null authentication\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n")

DEFSH (VTYSH_OSPFD, ospf_area_vlink_intervals_cmd_vtysh,
	"area <A.B.C.D|(0-4294967295)> virtual-link A.B.C.D {hello-interval (1-65535)|retransmit-interval (1-65535)|retransmit-window (20-10000)|transmit-delay (1-65535)|dead-interval (1-65535)}",
	"OSPF area parameters\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n"
	"Configure a virtual link\n"
	"Router ID of the remote ABR\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Window for LSA retransmit - Retransmit LSAs expiring in this window\n"
	"Milliseconds\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_authentication_key_cmd_vtysh,
	"ospf authentication-key AUTH_KEY [A.B.C.D]",
	"OSPF interface commands\n"
	"Authentication password (key)\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_auto_cost_reference_bandwidth_cmd_vtysh,
	"auto-cost reference-bandwidth (1-4294967)",
	"Calculate OSPF interface cost according to bandwidth\n"
	"Use reference bandwidth method to assign OSPF cost\n"
	"The reference bandwidth in terms of Mbits per second\n")

DEFSH (VTYSH_OSPFD, ospf_compatible_rfc1583_cmd_vtysh,
	"compatible rfc1583",
	"OSPF compatibility list\n"
	"compatible with RFC 1583\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_cost_cmd_vtysh,
	"ospf cost (1-65535) [A.B.C.D]",
	"OSPF interface commands\n"
	"Interface cost\n"
	"Cost\n"
	"Address of interface\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_dead_interval_cmd_vtysh,
	"ospf dead-interval (1-65535) [A.B.C.D]",
	"OSPF interface commands\n"
	"Interval time after which a neighbor is declared down\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_default_information_originate_cmd_vtysh,
	"default-information originate [{always|metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Control distribution of default information\n"
	"Distribute a default route\n"
	"Always advertise default route\n"
	"OSPF default metric\n"
	"OSPF metric\n"
	"OSPF metric type for default routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, ospf_default_metric_cmd_vtysh,
	"default-metric (0-16777214)",
	"Set metric of redistributed routes\n"
	"Default metric\n")

DEFSH (VTYSH_OSPFD, ospf_distance_cmd_vtysh,
	"distance (1-255)",
	"Administrative distance\n"
	"OSPF Administrative distance\n")

DEFSH (VTYSH_OSPFD, ospf_distance_ospf_cmd_vtysh,
	"distance ospf {intra-area (1-255)|inter-area (1-255)|external (1-255)}",
	"Administrative distance\n"
	"OSPF administrative distance\n"
	"Intra-area routes\n"
	"Distance for intra-area routes\n"
	"Inter-area routes\n"
	"Distance for inter-area routes\n"
	"External routes\n"
	"Distance for external routes\n")

DEFSH (VTYSH_OSPFD, ospf_distribute_list_out_cmd_vtysh,
	"distribute-list ACCESSLIST4_NAME out <kernel|connected|local|static|rip|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>",
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter outgoing routing updates\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n")

DEFSH (VTYSH_OSPFD, ospf_external_route_aggregation_cmd_vtysh,
	"summary-address A.B.C.D/M [tag (1-4294967295)]",
	"External summary address\n"
	"Summary address prefix\n"
	"Router tag \n"
	"Router tag value\n")

DEFSH (VTYSH_OSPFD, ospf_external_route_aggregation_no_adrvertise_cmd_vtysh,
	"summary-address A.B.C.D/M no-advertise",
	"External summary address\n"
	"Summary address prefix\n"
	"Don't advertise summary route \n")

DEFSH (VTYSH_OSPFD, ospf_gr_helper_enable_cmd_vtysh,
	"graceful-restart helper enable [A.B.C.D$address]",
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Enable Helper support\n"
	"Advertising Router-ID\n")

DEFSH (VTYSH_OSPFD, ospf_gr_helper_enable_lsacheck_cmd_vtysh,
	"graceful-restart helper strict-lsa-checking",
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Enable strict LSA check\n")

DEFSH (VTYSH_OSPFD, ospf_gr_helper_planned_only_cmd_vtysh,
	"graceful-restart helper planned-only",
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Supported only planned restart\n")

DEFSH (VTYSH_OSPFD, ospf_gr_helper_supported_grace_time_cmd_vtysh,
	"graceful-restart helper supported-grace-time (10-1800)$interval",
	"OSPF Graceful Restart\n"
	"OSPF GR Helper\n"
	"Supported grace timer\n"
	"Grace interval(in seconds)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_hello_interval_cmd_vtysh,
	"ospf hello-interval (1-65535) [A.B.C.D]",
	"OSPF interface commands\n"
	"Time between HELLO packets\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_log_adjacency_changes_cmd_vtysh,
	"log-adjacency-changes",
	"Log changes in adjacency state\n")

DEFSH (VTYSH_OSPFD, ospf_log_adjacency_changes_detail_cmd_vtysh,
	"log-adjacency-changes detail",
	"Log changes in adjacency state\n"
	"Log all state changes\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_lsa_refresh_timer_cmd_vtysh,
	"[no$no] ospf lsa-refresh [(120-1800)]$value",
	"Negate a command or set its defaults\n"
	"OSPF information\n"
	"OSPF lsa refresh timer\n"
	"timer value in seconds\n")

DEFSH (VTYSH_OSPFD, ospf_max_metric_router_lsa_admin_cmd_vtysh,
	"max-metric router-lsa administrative",
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Administratively applied, for an indefinite period\n")

DEFSH (VTYSH_OSPFD, ospf_max_metric_router_lsa_shutdown_cmd_vtysh,
	"max-metric router-lsa on-shutdown (5-100)",
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Advertise stub-router prior to full shutdown of OSPF\n"
	"Time (seconds) to wait till full shutdown\n")

DEFSH (VTYSH_OSPFD, ospf_max_metric_router_lsa_startup_cmd_vtysh,
	"max-metric router-lsa on-startup (5-86400)",
	"OSPF maximum / infinite-distance metric\n"
	"Advertise own Router-LSA with infinite distance (stub router)\n"
	"Automatically advertise stub Router-LSA on startup of OSPF\n"
	"Time (seconds) to advertise self as stub-router\n")

DEFSH (VTYSH_OSPFD, ospf_max_multipath_cmd_vtysh,
	"maximum-paths (1-256)",
	"Max no of multiple paths for ECMP support\n"
	"Number of paths\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_maxage_delay_timer_cmd_vtysh,
	"[no$no] ospf maxage-delay [(0-60)]$value",
	"Negate a command or set its defaults\n"
	"OSPF information\n"
	"OSPF lsa maxage delay timer\n"
	"timer value in seconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_message_digest_key_cmd_vtysh,
	"ospf message-digest-key (1-255) md5 KEY [A.B.C.D]",
	"OSPF interface commands\n"
	"Message digest authentication password (key)\n"
	"Key ID\n"
	"Use MD5 algorithm\n"
	"The OSPF password (key)\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_ldp_sync_cmd_vtysh,
	"mpls ldp-sync",
	"MPLS specific commands\n"
	"Enable MPLS LDP-IGP Sync\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_ldp_sync_holddown_cmd_vtysh,
	"mpls ldp-sync holddown (1-10000)",
	"MPLS specific commands\n"
	"Enable MPLS LDP-IGP Sync\n"
	"Set holddown timer\n"
	"seconds\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_te_export_cmd_vtysh,
	"mpls-te export",
	"MPLS-TE specific commands\n"
	"Export the MPLS-TE information as Link State\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_te_inter_as_area_cmd_vtysh,
	"mpls-te inter-as area <A.B.C.D|(0-4294967295)>",
	"MPLS-TE specific commands\n"
	"Configure MPLS-TE Inter-AS support\n"
	"AREA native mode self originate INTER_AS LSA with Type 10 (area flooding scope)\n"
	"OSPF area ID in IP format\n"
	"OSPF area ID as decimal value\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_te_inter_as_cmd_vtysh,
	"mpls-te inter-as as",
	"MPLS-TE specific commands\n"
	"Configure MPLS-TE Inter-AS support\n"
	"AS native mode self originate INTER_AS LSA with Type 11 (as flooding scope)\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_te_on_cmd_vtysh,
	"mpls-te on",
	"MPLS-TE specific commands\n"
	"Enable the MPLS-TE functionality\n")

DEFSH (VTYSH_OSPFD, ospf_mpls_te_router_addr_cmd_vtysh,
	"mpls-te router-address A.B.C.D",
	"MPLS-TE specific commands\n"
	"Stable IP address of the advertising router\n"
	"MPLS-TE router address in IPv4 address format\n")

DEFSH (VTYSH_OSPFD, ospf_neighbor_cmd_vtysh,
	"[no] neighbor A.B.C.D$nbr_address [{priority (0-255)$priority | poll-interval (1-65535)$interval}]",
	"Negate a command or set its defaults\n"
	"Specify neighbor router\n"
	"Neighbor IP address\n"
	"Neighbor Priority\n"
	"Priority\n"
	"Dead Neighbor Polling interval\n"
	"Seconds\n")

DEFSH (VTYSH_OSPFD, ospf_network_area_cmd_vtysh,
	"network A.B.C.D/M area <A.B.C.D|(0-4294967295)>",
	"Enable routing on an IP network\n"
	"OSPF network prefix\n"
	"Set the OSPF area ID\n"
	"OSPF area ID in IP address format\n"
	"OSPF area ID as a decimal value\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_network_cmd_vtysh,
	"ospf network <broadcast|non-broadcast|point-to-multipoint|point-to-point>",
	"OSPF interface commands\n"
	"Network type\n"
	"Specify OSPF broadcast multi-access network\n"
	"Specify OSPF NBMA network\n"
	"Specify OSPF point-to-multipoint network\n"
	"Specify OSPF point-to-point network\n")

DEFSH (VTYSH_OSPFD, ospf_opaque_cmd_vtysh,
	"ospf opaque-lsa",
	"OSPF specific commands\n"
	"Enable the Opaque-LSA capability (rfc2370)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_passive_interface_addr_cmd_vtysh,
	"passive-interface IFNAME [A.B.C.D]",
	"Suppress routing updates on an interface\n"
	"Interface's name\n"
	"IPv4 address\n")

DEFSH (VTYSH_OSPFD, ospf_passive_interface_default_cmd_vtysh,
	"passive-interface default",
	"Suppress routing updates on an interface\n"
	"Suppress routing updates on interfaces by default\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_priority_cmd_vtysh,
	"ospf priority (0-255) [A.B.C.D]",
	"OSPF interface commands\n"
	"Router priority\n"
	"Priority\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_proactive_arp_cmd_vtysh,
	"proactive-arp",
	"Allow sending ARP requests proactively\n")

DEFSH (VTYSH_OSPFD, ospf_redistribute_instance_source_cmd_vtysh,
	"redistribute <ospf|table|table-direct> (1-65535) [{metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Redistribute information from another routing protocol\n"
	"Open Shortest Path First\n"
	"Non-main Kernel Routing Table\n"
	"Non-main Kernel Routing Table - Direct\n"
	"Instance ID/Table ID\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, ospf_redistribute_source_cmd_vtysh,
	"redistribute <kernel|connected|local|static|rip|isis|bgp|eigrp|nhrp|vnc|babel|openfabric> [{metric (0-16777214)|metric-type (1-2)|route-map RMAP_NAME}]",
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric for redistributed routes\n"
	"OSPF default metric\n"
	"OSPF exterior metric type for redistributed routes\n"
	"Set OSPF External Type 1/2 metrics\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_OSPFD, ospf_refresh_timer_cmd_vtysh,
	"refresh timer (10-1800)",
	"Adjust refresh parameters\n"
	"Set refresh timer\n"
	"Timer value in seconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_retransmit_interval_cmd_vtysh,
	"ospf retransmit-interval (1-65535) [A.B.C.D]",
	"OSPF interface commands\n"
	"Time between retransmitting lost link state advertisements\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_rfc1583_flag_cmd_vtysh,
	"ospf rfc1583compatibility",
	"OSPF specific commands\n"
	"Enable the RFC1583Compatibility flag\n")

DEFSH (VTYSH_OSPFD, ospf_route_aggregation_timer_cmd_vtysh,
	"aggregation timer (5-1800)",
	"External route aggregation\n"
	"Delay timer (in seconds)\n"
	"Timer interval(in seconds)\n")

DEFSH (VTYSH_OSPFD, ospf_router_id_cmd_vtysh,
	"ospf router-id A.B.C.D",
	"OSPF specific commands\n"
	"router-id for the OSPF process\n"
	"OSPF router-id in IP address format\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_router_id_old_cmd_vtysh,
	"router-id A.B.C.D",
	"router-id for the OSPF process\n"
	"OSPF router-id in IP address format\n")

DEFSH (VTYSH_OSPFD, ospf_send_extra_data_cmd_vtysh,
	"[no] ospf send-extra-data zebra",
	"Negate a command or set its defaults\n"
	"OSPF information\n"
	"Extra data to Zebra for display/use\n"
	"To zebra\n")

DEFSH (VTYSH_OSPFD, ospf_socket_bufsizes_cmd_vtysh,
	"[no] socket buffer <send$send_val | recv$recv_val | all$all_val> 	  ![(1-4000000000)$bufsize]",
	"Negate a command or set its defaults\n"
	"Socket parameters\n"
	"Buffer size configuration\n"
	"Send buffer size\n"
	"Receive buffer size\n"
	"Both send and receive buffer sizes\n"
	"Buffer size, in bytes\n")

DEFSH (VTYSH_OSPFD, ospf_sr_enable_cmd_vtysh,
	"segment-routing on",
	"Segment-Routing specific commands\n"
	"Enable Segment Routing\n")

DEFSH (VTYSH_OSPFD, ospf_ti_lfa_cmd_vtysh,
	"fast-reroute ti-lfa [node-protection]",
	"Fast Reroute for MPLS and IP resilience\n"
	"Topology Independent LFA (Loop-Free Alternate)\n"
	"TI-LFA node protection (default is link protection)\n")

DEFSH (VTYSH_OSPFD, ospf_timers_lsa_min_arrival_cmd_vtysh,
	"[no] timers lsa min-arrival ![(0-5000)]$min_arrival",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"OSPF LSA timers\n"
	"Minimum delay in receiving new version of an LSA\n"
	"Delay in milliseconds\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_timers_lsa_min_arrival_deprecated_cmd_vtysh,
	"timers lsa min-arrival [(5001-60000)]$min_arrival",
	"Adjust routing timers\n"
	"OSPF LSA timers\n"
	"Minimum delay in receiving new version of an LSA\n"
	"Deprecated delay in milliseconds - delays in this range default to 5000 msec\n")

DEFSH (VTYSH_OSPFD, ospf_timers_min_ls_interval_cmd_vtysh,
	"[no] timers throttle lsa all ![(0-5000)]$lsa_refresh_interval",
	"Negate a command or set its defaults\n"
	"Adjust routing timers\n"
	"Throttling adaptive timer\n"
	"LSA delay between transmissions\n"
	"All LSA types\n"
	"Delay (msec) between sending LSAs\n")

DEFSH (VTYSH_OSPFD, ospf_timers_throttle_spf_cmd_vtysh,
	"timers throttle spf (0-600000) (0-600000) (0-600000)",
	"Adjust routing timers\n"
	"Throttling adaptive timer\n"
	"OSPF SPF timers\n"
	"Delay (msec) from first change received till SPF calculation\n"
	"Initial hold time (msec) between consecutive SPF calculations\n"
	"Maximum hold time (msec)\n")

DEFSH_HIDDEN (VTYSH_OSPFD, ospf_transmit_delay_cmd_vtysh,
	"ospf transmit-delay (1-65535) [A.B.C.D]",
	"OSPF interface commands\n"
	"Link state transmit delay\n"
	"Seconds\n"
	"Address of interface\n")

DEFSH (VTYSH_OSPFD, ospf_write_multiplier_cmd_vtysh,
	"ospf write-multiplier (1-100)",
	"OSPF specific commands\n"
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_PATHD, path_ted_import_cmd_vtysh,
	"mpls-te import <ospfv2|ospfv3|isis>$import_daemon",
	"Enable the TE database (TED) fill with remote igp data\n"
	"import\n"
	"Origin ospfv2\n"
	"Origin ospfv3\n"
	"Origin isis\n")

DEFSH (VTYSH_PATHD, path_ted_on_cmd_vtysh,
	"mpls-te on",
	"Negate a command or set its defaults\n"
	"Enable the TE database (TED) functionality\n")

DEFSH (VTYSH_PBRD, pbr_map_action_dscp_cmd_vtysh,
	"[no] set dscp ![DSCP$dscp]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set IP DSCP field\n"
	"DSCP numeric value (0-63) or standard codepoint name\n")

DEFSH (VTYSH_PBRD, pbr_map_action_dst_cmd_vtysh,
	"[no] set dst-ip ![<A.B.C.D|X:X::X:X>$su]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set the dst ipv4 or ipv6 prefix\n"
	"v4 Prefix\n"
	"v6 Prefix\n")

DEFSH (VTYSH_PBRD, pbr_map_action_dst_port_cmd_vtysh,
	"[no] set dst-port ![(1-65535)$port]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set Destination Port\n"
	"The Destination Port\n")

DEFSH (VTYSH_PBRD, pbr_map_action_ecn_cmd_vtysh,
	"[no] set ecn ![(0-3)$ecn]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set IP ECN field\n"
	"Explicit Congestion Notification value\n")

DEFSH (VTYSH_PBRD, pbr_map_action_pcp_cmd_vtysh,
	"[no] set pcp ![(0-7)$pcp]",
	"Negate a command or set its defaults\n"
	"Set the rest of the command\n"
	"Set based on 802.1p Priority Code Point (PCP) value\n"
	"A valid value in range 0..7\n")

DEFSH (VTYSH_PBRD, pbr_map_action_queue_id_cmd_vtysh,
	"[no] set queue-id ![(1-65535)$queue_id]",
	"Negate a command or set its defaults\n"
	"Set the rest of the command\n"
	"Set based on egress port queue id\n"
	"A valid value in range 1..65535 \n")

DEFSH (VTYSH_PBRD, pbr_map_action_src_cmd_vtysh,
	"[no] set src-ip ![<A.B.C.D|X:X::X:X>$su]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set the src ipv4 or ipv6 prefix\n"
	"v4 Prefix\n"
	"v6 Prefix\n")

DEFSH (VTYSH_PBRD, pbr_map_action_src_port_cmd_vtysh,
	"[no] set src-port ![(1-65535)$port]",
	"Negate a command or set its defaults\n"
	"Set command\n"
	"Set Source Port\n"
	"The Source Port\n")

DEFSH (VTYSH_PBRD, pbr_map_action_strip_vlan_cmd_vtysh,
	"[no] strip vlan",
	"Negate a command or set its defaults\n"
	"Strip the vlan tags from frame\n"
	"Strip any inner vlan tag\n")

DEFSH (VTYSH_PBRD, pbr_map_action_vlan_id_cmd_vtysh,
	"[no] set vlan ![(1-4094)$vlan_id]",
	"Negate a command or set its defaults\n"
	"Set the rest of the command\n"
	"Set action for VLAN tagging\n"
	"A valid value in range 1..4094\n")

DEFSH (VTYSH_PBRD, pbr_map_match_dscp_cmd_vtysh,
	"[no] match dscp ![DSCP$dscp]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Match based on IP DSCP field\n"
	"DSCP value (below 64) or standard codepoint name\n")

DEFSH (VTYSH_PBRD, pbr_map_match_dst_cmd_vtysh,
	"[no] match dst-ip ![<A.B.C.D/M|X:X::X:X/M>$prefix]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose the dst ipv4 or ipv6 prefix to use\n"
	"v4 Prefix\n"
	"v6 Prefix\n")

DEFSH (VTYSH_PBRD, pbr_map_match_dst_port_cmd_vtysh,
	"[no] match dst-port ![(1-65535)$port]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose the destination port to use\n"
	"The Destination Port\n")

DEFSH (VTYSH_PBRD, pbr_map_match_ecn_cmd_vtysh,
	"[no] match ecn ![(0-3)$ecn]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Match based on IP ECN field\n"
	"Explicit Congestion Notification\n")

DEFSH (VTYSH_PBRD, pbr_map_match_ip_proto_cmd_vtysh,
	"[no] match ip-protocol ![PROTO$ip_proto]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose an ip-protocol\n"
	"Protocol name\n")

DEFSH (VTYSH_PBRD, pbr_map_match_mark_cmd_vtysh,
	"[no] match mark ![(1-4294967295)$mark]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose the mark value to use\n"
	"mark\n")

DEFSH (VTYSH_PBRD, pbr_map_match_pcp_cmd_vtysh,
	"[no] match pcp ![(0-7)$pcp]",
	"Negate a command or set its defaults\n"
	"Match spec follows\n"
	"Match based on 802.1p Priority Code Point (PCP) value\n"
	"PCP value to match\n")

DEFSH (VTYSH_PBRD, pbr_map_match_src_cmd_vtysh,
	"[no] match src-ip ![<A.B.C.D/M|X:X::X:X/M>$prefix]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose the src ipv4 or ipv6 prefix to use\n"
	"v4 Prefix\n"
	"v6 Prefix\n")

DEFSH (VTYSH_PBRD, pbr_map_match_src_port_cmd_vtysh,
	"[no] match src-port ![(1-65535)$port]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Choose the source port to use\n"
	"The Source Port\n")

DEFSH (VTYSH_PBRD, pbr_map_match_vlan_id_cmd_vtysh,
	"[no] match vlan ![(1-4094)$vlan_id]",
	"Negate a command or set its defaults\n"
	"Match spec follows\n"
	"Match based on VLAN ID\n"
	"VLAN ID to match\n")

DEFSH (VTYSH_PBRD, pbr_map_match_vlan_tag_cmd_vtysh,
	"[no] match vlan ![<tagged|untagged|untagged-or-zero>$tag_type]",
	"Negate a command or set its defaults\n"
	"Match the rest of the command\n"
	"Match based on VLAN tagging\n"
	"Match all tagged frames\n"
	"Match all untagged frames\n"
	"Match untagged frames, or tagged frames with id zero\n")

DEFSH (VTYSH_PBRD, pbr_map_nexthop_cmd_vtysh,
	"set nexthop        <	  <A.B.C.D|X:X::X:X>$addr [INTERFACE$intf]	  |INTERFACE$intf	  |blackhole$bh	>        [nexthop-vrf NAME$vrf_name]",
	"Set for the PBR-MAP\n"
	"Specify one of the nexthops in this map\n"
	"v4 Address\n"
	"v6 Address\n"
	"Interface to use\n"
	"Interface to use\n"
	"Blackhole route\n"
	"If the nexthop is in a different vrf tell us\n"
	"The nexthop-vrf Name\n")

DEFSH (VTYSH_PBRD, pbr_map_nexthop_group_cmd_vtysh,
	"set nexthop-group NHGNAME$name",
	"Set for the PBR-MAP\n"
	"nexthop-group to use\n"
	"The name of the nexthop-group\n")

DEFSH (VTYSH_PBRD, pbr_map_vrf_cmd_vtysh,
	"set vrf <NAME$vrf_name|unchanged>",
	"Set for the PBR-MAP\n"
	"Specify the VRF for this map\n"
	"The VRF Name\n"
	"Use the interface's VRF for lookup\n")

DEFSH (VTYSH_ZEBRA, pbr_nexthop_resolve_cmd_vtysh,
	"[no$no] pbr nexthop-resolve",
	"Negate a command or set its defaults\n"
	"Policy Based Routing\n"
	"Resolve nexthop for dataplane programming\n")

DEFSH (VTYSH_PBRD, pbr_policy_cmd_vtysh,
	"[no] pbr-policy PBRMAP$mapname",
	"Negate a command or set its defaults\n"
	"Policy to use\n"
	"Name of the pbr-map to apply\n")

DEFSH (VTYSH_PBRD, pbr_set_table_range_cmd_vtysh,
	"pbr table range (10000-4294966272)$lb (10000-4294966272)$ub",
	"Policy Based Routing\n"
	"Set table ID range\n"
	"Set table ID range\n"
	"Lower bound for table ID range\n"
	"Upper bound for table ID range\n")

DEFSH (VTYSH_OSPFD, pce_address_cmd_vtysh,
	"pce address A.B.C.D",
	"PCE Router Information specific commands\n"
	"Stable IP address of the PCE\n"
	"PCE address in IPv4 address format\n")

DEFSH (VTYSH_OSPFD, pce_cap_flag_cmd_vtysh,
	"pce flag BITPATTERN",
	"PCE Router Information specific commands\n"
	"Capabilities of the PCE for path computation\n"
	"32-bit Hexadecimal value\n")

DEFSH (VTYSH_OSPFD, pce_domain_cmd_vtysh,
	"pce domain as (0-65535)",
	"PCE Router Information specific commands\n"
	"Configure PCE domain AS number\n"
	"AS number where the PCE as visibilities for path computation\n"
	"AS number in decimal <0-65535>\n")

DEFSH (VTYSH_OSPFD, pce_neighbor_cmd_vtysh,
	"pce neighbor as (0-65535)",
	"PCE Router Information specific commands\n"
	"Configure PCE neighbor domain AS number\n"
	"AS number of PCE neighbors\n"
	"AS number in decimal <0-65535>\n")

DEFSH (VTYSH_OSPFD, pce_path_scope_cmd_vtysh,
	"pce scope BITPATTERN",
	"PCE Router Information specific commands\n"
	"Path scope visibilities of the PCE for path computation\n"
	"32-bit Hexadecimal value\n")

DEFSH (VTYSH_PATHD, pcep_cli_clear_srte_pcep_session_cmd_vtysh,
	"clear sr-te pcep session [WORD]$pce",
	"Reset functions\n"
	"SR-TE\n"
	"PCEP\n"
	"Reset PCEP connection\n"
	"PCE name\n")

DEFSH (VTYSH_PATHD, pcep_cli_debug_cmd_vtysh,
	"[no] debug pathd pcep [{basic$basic|path$path|message$msg|pceplib$lib}]",
	"Negate a command or set its defaults\n"
	"Debugging functions\n"
	"pathd debugging\n"
	"pcep module debugging\n"
	"module basic debugging\n"
	"path structures debugging\n"
	"pcep message debugging\n"
	"pceplib debugging\n")

DEFSH (VTYSH_PATHD, pcep_cli_no_pcc_cmd_vtysh,
	"no pcc",
	"Negate a command or set its defaults\n"
	"PCC configuration\n")

DEFSH (VTYSH_PATHD, pcep_cli_no_pce_cmd_vtysh,
	"no pce WORD$name",
	"Negate a command or set its defaults\n"
	"PCE configuration, address sub-config is mandatory\n"
	"PCE name\n")

DEFSH (VTYSH_PATHD, pcep_cli_no_pcep_cmd_vtysh,
	"no pcep",
	"Negate a command or set its defaults\n"
	"PCEP configuration\n")

DEFSH (VTYSH_PATHD, pcep_cli_pcc_pcc_msd_cmd_vtysh,
	"msd (1-32)",
	"PCC maximum SID depth \n"
	"PCC maximum SID depth value\n")

DEFSH (VTYSH_PATHD, pcep_cli_pcc_pcc_peer_cmd_vtysh,
	"[no] peer WORD [precedence (1-255)]",
	"Negate a command or set its defaults\n"
	"PCC PCE peer\n"
	"PCC PCE name\n"
	"PCC Multi-PCE precedence\n"
	"PCE precedence\n")

DEFSH (VTYSH_PATHD, pcep_cli_pcep_no_pce_config_cmd_vtysh,
	"no pce-config WORD$name",
	"Negate a command or set its defaults\n"
	"Shared configuration\n"
	"Shared configuration name\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_address_cmd_vtysh,
	"address <ip A.B.C.D | ipv6 X:X::X:X> [port (1024-65535)]",
	"PCE IP Address configuration, mandatory configuration\n"
	"PCE IPv4 address\n"
	"Remote PCE server IPv4 address\n"
	"PCE IPv6 address\n"
	"Remote PCE server IPv6 address\n"
	"Remote PCE server port\n"
	"Remote PCE server port value\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_pce_initiated_cmd_vtysh,
	"[no] pce-initiated",
	"Negate a command or set its defaults\n"
	"Configure PCC to accept PCE initiated LSPs\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_pcep_pce_config_ref_cmd_vtysh,
	"config WORD$name",
	"PCE shared configuration to use\n"
	"Shared configuration name\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_source_address_cmd_vtysh,
	"[no] source-address [ip A.B.C.D | ipv6 X:X::X:X] [port (1024-65535)]",
	"Negate a command or set its defaults\n"
	"PCE source IP Address configuration\n"
	"PCE source IPv4 address\n"
	"PCE source IPv4 address value\n"
	"PCE source IPv6 address\n"
	"PCE source IPv6 address value\n"
	"Source PCE server port\n"
	"Source PCE server port value\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_sr_draft07_cmd_vtysh,
	"[no] sr-draft07",
	"Negate a command or set its defaults\n"
	"Configure PCC to send PCEP Open with SR draft07\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_tcp_md5_auth_cmd_vtysh,
	"[no] tcp-md5-auth WORD",
	"Negate a command or set its defaults\n"
	"Configure PCC TCP-MD5 RFC2385 Authentication\n"
	"TCP-MD5 Authentication string\n")

DEFSH (VTYSH_PATHD, pcep_cli_peer_timers_cmd_vtysh,
	"timer [keep-alive (1-63)] [min-peer-keep-alive (1-255)] [max-peer-keep-alive (1-255)] [dead-timer (4-255)] [min-peer-dead-timer (4-255)] [max-peer-dead-timer (4-255)] [pcep-request (1-120)] [session-timeout-interval (1-120)] [delegation-timeout (1-60)]",
	"PCE PCEP Session Timers configuration\n"
	"PCC Keep Alive Timer\n"
	"PCC Keep Alive Timer value in seconds\n"
	"Min Acceptable PCE Keep Alive Timer\n"
	"Min Acceptable PCE Keep Alive Timer value in seconds\n"
	"Max Acceptable PCE Keep Alive Timer\n"
	"Max Acceptable PCE Keep Alive Timer value in seconds\n"
	"PCC Dead Timer\n"
	"PCC Dead Timer value in seconds\n"
	"Min Acceptable PCE Dead Timer\n"
	"Min Acceptable PCE Dead Timer value in seconds\n"
	"Max Acceptable PCE Dead Timer\n"
	"Max Acceptable PCE Dead Timer value in seconds\n"
	"PCC PCEP Request Timer\n"
	"PCC PCEP Request Timer value in seconds\n"
	"PCC Session Timeout Interval\n"
	"PCC Session Timeout Interval value in seconds\n"
	"Multi-PCE delegation timeout\n"
	"Multi-PCE delegation timeout value in seconds\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcc_cmd_vtysh,
	"show sr-te pcep pcc",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"Show current PCC configuration\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcep_counters_cmd_vtysh,
	"show sr-te pcep counters",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"PCEP counters\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcep_pce_cmd_vtysh,
	"show sr-te pcep pce [WORD$name]",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"Show detailed pce values\n"
	"pce name\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcep_pce_config_cmd_vtysh,
	"show sr-te pcep pce-config [<default|WORD>$name]",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"Show shared PCE configuration\n"
	"Show default hard-coded values\n"
	"Shared configuration name\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcep_session_cmd_vtysh,
	"show sr-te pcep session WORD$pce [json$uj]",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"Show PCEP Session information\n"
	"PCE name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PATHD, pcep_cli_show_srte_pcep_sessions_cmd_vtysh,
	"show sr-te pcep session [json$uj]",
	"Show running system information\n"
	"SR-TE info\n"
	"PCEP info\n"
	"Show PCEP Session information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, per_intf_socket_cmd_vtysh,
	"[no] socket-per-interface",
	"Negate a command or set its defaults\n"
	"Use write socket per interface\n")

DEFSH (VTYSH_PIM6D, pim6_bsr_candidate_bsr_cmd_vtysh,
	"[no] bsr candidate-bsr [{priority (0-255)|source <address X:X::X:X|interface IFNAME|loopback$loopback|any$any>}]",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate BSR\n"
	"BSR Priority (higher wins)\n"
	"BSR Priority (higher wins)\n"
	"Specify IP address for BSR operation\n"
	"Local address to use\n"
	"Local address to use\n"
	"Interface to pick address from\n"
	"Interface to pick address from\n"
	"Pick highest loopback address (default)\n"
	"Pick highest address from any interface\n")

DEFSH (VTYSH_PIM6D, pim6_bsr_candidate_rp_cmd_vtysh,
	"[no] bsr candidate-rp [{priority (0-255)|interval (1-4294967295)|source <address X:X::X:X|interface IFNAME|loopback$loopback|any$any>}]",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate RP\n"
	"RP Priority (lower wins)\n"
	"RP Priority (lower wins)\n"
	"Advertisement interval (seconds)\n"
	"Advertisement interval (seconds)\n"
	"Specify IP address for RP operation\n"
	"Local address to use\n"
	"Local address to use\n"
	"Interface to pick address from\n"
	"Interface to pick address from\n"
	"Pick highest loopback address (default)\n"
	"Pick highest address from any interface\n")

DEFSH (VTYSH_PIM6D, pim6_bsr_candidate_rp_group_cmd_vtysh,
	"[no] bsr candidate-rp group X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate RP\n"
	"Configure groups to become candidate RP for\n"
	"Multicast group prefix\n")

DEFSH (VTYSH_PIM6D, pim6_embedded_rp_cmd_vtysh,
	"[no] embedded-rp",
	"Negate a command or set its defaults\n"
	"Embedded Rendezvous Point\n")

DEFSH (VTYSH_PIM6D, pim6_embedded_rp_group_list_cmd_vtysh,
	"[no] embedded-rp group-list ![WORD$prefix_list]",
	"Negate a command or set its defaults\n"
	"Embedded Rendezvous Point\n"
	"Configure embedded RP permitted groups\n"
	"Embedded RP permitted groups\n")

DEFSH (VTYSH_PIM6D, pim6_embedded_rp_limit_cmd_vtysh,
	"[no] embedded-rp limit ![(1-4294967295)$limit]",
	"Negate a command or set its defaults\n"
	"Embedded Rendezvous Point\n"
	"Limit the amount of embedded RPs to learn\n"
	"Maximum amount of embedded RPs to learn\n")

DEFSH (VTYSH_PIM6D, pim6_joinprune_time_cmd_vtysh,
	"join-prune-interval (1-65535)$jpi",
	"Join Prune Send Interval\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, pim6_keep_alive_cmd_vtysh,
	"keep-alive-timer (1-65535)$kat",
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, pim6_packets_cmd_vtysh,
	"packets (1-255)",
	"packets to process at one time per fd\n"
	"Number of packets\n")

DEFSH (VTYSH_PIM6D, pim6_register_suppress_cmd_vtysh,
	"register-suppress-time (1-65535)$rst",
	"Register Suppress Timer\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, pim6_rp_cmd_vtysh,
	"rp X:X::X:X$rp [X:X::X:X/M]$gp",
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"Group Address range to cover\n")

DEFSH (VTYSH_PIM6D, pim6_rp_keep_alive_cmd_vtysh,
	"rp keep-alive-timer (1-65535)$kat",
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH (VTYSH_PIM6D, pim6_rp_prefix_list_cmd_vtysh,
	"rp X:X::X:X$rp prefix-list PREFIXLIST6_NAME$plist",
	"Rendezvous Point\n"
	"ipv6 address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIM6D, pim6_spt_switchover_infinity_cmd_vtysh,
	"spt-switchover infinity-and-beyond",
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH (VTYSH_PIM6D, pim6_spt_switchover_infinity_plist_cmd_vtysh,
	"spt-switchover infinity-and-beyond prefix-list PREFIXLIST6_NAME$plist",
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIM6D, pim6_ssmpingd_cmd_vtysh,
	"ssmpingd [X:X::X:X]$source",
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH (VTYSH_PIMD, pim_autorp_announce_rp_cmd_vtysh,
	"[no] autorp announce A.B.C.D$rpaddr ![A.B.C.D/M$grp|group-list PREFIX_LIST$plist]",
	"Negate a command or set its defaults\n"
	"AutoRP\n"
	"AutoRP Candidate RP announcement\n"
	"AutoRP Candidate RP address\n"
	"Group prefix\n"
	"Prefix list\n"
	"List name\n")

DEFSH (VTYSH_PIMD, pim_autorp_announce_scope_int_cmd_vtysh,
	"[no] autorp announce {scope (1-255) | interval (1-65535) | holdtime (0-65535)}",
	"Negate a command or set its defaults\n"
	"AutoRP\n"
	"AutoRP Candidate RP announcement\n"
	"Packet scope (TTL)\n"
	"TTL value\n"
	"Announcement interval\n"
	"Time in seconds\n"
	"Announcement holdtime\n"
	"Time in seconds\n")

DEFSH (VTYSH_PIMD, pim_autorp_discovery_cmd_vtysh,
	"[no] autorp discovery",
	"Negate a command or set its defaults\n"
	"AutoRP\n"
	"Enable AutoRP discovery\n")

DEFSH (VTYSH_PIMD, pim_autorp_send_rp_discovery_cmd_vtysh,
	"[no] autorp send-rp-discovery [source <address A.B.C.D | interface IFNAME | loopback$loopback | any$any>]",
	"Negate a command or set its defaults\n"
	"AutoRP\n"
	"Enable AutoRP mapping agent\n"
	"Specify AutoRP discovery source\n"
	"Local address\n"
	"IPv4 Address\n"
	"Local Interface (uses highest address)\n"
	"Interface name(e.g. ep0)\n"
	"Highest loopback address (default)\n"
	"Highest address of any interface\n")

DEFSH (VTYSH_PIMD, pim_autorp_send_rp_discovery_scope_int_cmd_vtysh,
	"[no] autorp send-rp-discovery {scope (0-255) | interval (1-65535) | holdtime (0-65535)}",
	"Negate a command or set its defaults\n"
	"AutoRP\n"
	"Enable AutoRP mapping agent\n"
	"Packet scope (TTL)\n"
	"TTL value\n"
	"Discovery TX interval\n"
	"Time in seconds\n"
	"Announcement holdtime\n"
	"Time in seconds\n")

DEFSH (VTYSH_PIMD, pim_bsr_candidate_bsr_cmd_vtysh,
	"[no] bsr candidate-bsr [{priority (0-255)|source <address A.B.C.D|interface IFNAME|loopback$loopback|any$any>}]",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate BSR\n"
	"BSR Priority (higher wins)\n"
	"BSR Priority (higher wins)\n"
	"Specify IP address for BSR operation\n"
	"Local address to use\n"
	"Local address to use\n"
	"Interface to pick address from\n"
	"Interface to pick address from\n"
	"Pick highest loopback address (default)\n"
	"Pick highest address from any interface\n")

DEFSH (VTYSH_PIMD, pim_bsr_candidate_rp_cmd_vtysh,
	"[no] bsr candidate-rp [{priority (0-255)|interval (1-4294967295)|source <address A.B.C.D|interface IFNAME|loopback$loopback|any$any>}]",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate RP\n"
	"RP Priority (lower wins)\n"
	"RP Priority (lower wins)\n"
	"Advertisement interval (seconds)\n"
	"Advertisement interval (seconds)\n"
	"Specify IP address for RP operation\n"
	"Local address to use\n"
	"Local address to use\n"
	"Interface to pick address from\n"
	"Interface to pick address from\n"
	"Pick highest loopback address (default)\n"
	"Pick highest address from any interface\n")

DEFSH (VTYSH_PIMD, pim_bsr_candidate_rp_group_cmd_vtysh,
	"[no] bsr candidate-rp group A.B.C.D/M",
	"Negate a command or set its defaults\n"
	"Bootstrap Router configuration\n"
	"Make this router a Candidate RP\n"
	"Configure groups to become candidate RP for (At least one group must be configured)\n"
	"Multicast group prefix\n")

DEFSH (VTYSH_PIMD, pim_dm_prefix_list_cmd_vtysh,
	"[no] dm prefix-list WORD$plist",
	"Negate a command or set its defaults\n"
	"PIM Dense Mode Multicast\n"
	"Group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, pim_ecmp_cmd_vtysh,
	"ecmp",
	"Enable PIM ECMP \n")

DEFSH (VTYSH_PIMD, pim_ecmp_rebalance_cmd_vtysh,
	"ecmp rebalance",
	"Enable PIM ECMP \n"
	"Enable PIM ECMP Rebalance\n")

DEFSH (VTYSH_PIMD, pim_joinprune_time_cmd_vtysh,
	"join-prune-interval (1-65535)$jpi",
	"Join Prune Send Interval\n"
	"Seconds\n")

DEFSH (VTYSH_PIMD, pim_keep_alive_cmd_vtysh,
	"keep-alive-timer (1-65535)$kat",
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH_HIDDEN (VTYSH_PIMD, pim_mlag_cmd_vtysh,
	"mlag INTERFACE$iface role [primary|secondary]$role state [up|down]$state addr A.B.C.D$addr",
	"MLAG\n"
	"peerlink sub interface\n"
	"MLAG role\n"
	"MLAG role primary\n"
	"MLAG role secondary\n"
	"peer session state\n"
	"peer session state up\n"
	"peer session state down\n"
	"configure PIP\n"
	"unique ip address\n")

DEFSH (VTYSH_PIMD, pim_msdp_mesh_group_member_cmd_vtysh,
	"msdp mesh-group WORD$gname member A.B.C.D$maddr",
	"Configure multicast source discovery protocol\n"
	"Configure MSDP mesh-group\n"
	"Mesh group name\n"
	"Mesh group member\n"
	"Peer IP address\n")

DEFSH (VTYSH_PIMD, pim_msdp_mesh_group_source_cmd_vtysh,
	"msdp mesh-group WORD$gname source A.B.C.D$saddr",
	"Configure multicast source discovery protocol\n"
	"Configure MSDP mesh-group\n"
	"Mesh group name\n"
	"Mesh group local address\n"
	"Source IP address for the TCP connection\n")

DEFSH (VTYSH_PIMD, pim_msdp_peer_cmd_vtysh,
	"msdp peer A.B.C.D$peer source A.B.C.D$source [as (1-4294967295)$asn]",
	"Configure multicast source discovery protocol\n"
	"Configure MSDP peer\n"
	"Peer IP address\n"
	"Source address for TCP connection\n"
	"Local IP address\n"
	"BGP Autonomous System peer information\n"
	"BGP Autonomous System peer number\n")

DEFSH (VTYSH_PIMD, pim_msdp_timers_cmd_vtysh,
	"msdp timers (1-65535)$keepalive (1-65535)$holdtime [(1-65535)$connretry]",
	"Configure multicast source discovery protocol\n"
	"MSDP timers configuration\n"
	"Keep alive period (in seconds)\n"
	"Hold time period (in seconds)\n"
	"Connection retry period (in seconds)\n")

DEFSH (VTYSH_PIMD, pim_packets_cmd_vtysh,
	"packets (1-255)",
	"packets to process at one time per fd\n"
	"Number of packets\n")

DEFSH (VTYSH_PIMD, pim_register_accept_list_cmd_vtysh,
	"[no] register-accept-list PREFIXLIST4_NAME$word",
	"Negate a command or set its defaults\n"
	"Only accept registers from a specific source prefix list\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIMD, pim_register_suppress_cmd_vtysh,
	"register-suppress-time (1-65535)$rst",
	"Register Suppress Timer\n"
	"Seconds\n")

DEFSH (VTYSH_PIMD, pim_rp_cmd_vtysh,
	"rp A.B.C.D$rp [A.B.C.D/M]$gp",
	"Rendezvous Point\n"
	"ip address of RP\n"
	"Group Address range to cover\n")

DEFSH (VTYSH_PIMD, pim_rp_keep_alive_cmd_vtysh,
	"rp keep-alive-timer (1-65535)$kat",
	"Rendezvous Point\n"
	"Keep alive Timer\n"
	"Seconds\n")

DEFSH (VTYSH_PIMD, pim_rp_prefix_list_cmd_vtysh,
	"rp A.B.C.D$rp prefix-list PREFIXLIST4_NAME$plist",
	"Rendezvous Point\n"
	"ip address of RP\n"
	"group prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, pim_rpf_lookup_mode_cmd_vtysh,
	"[no] rpf-lookup-mode            ![urib-only|mrib-only|mrib-then-urib|lower-distance|longer-prefix]$mode            [{group-list PREFIX_LIST$grp_list|source-list PREFIX_LIST$src_list}]",
	"Negate a command or set its defaults\n"
	"RPF lookup behavior\n"
	"Lookup in unicast RIB only\n"
	"Lookup in multicast RIB only\n"
	"Try multicast RIB first, fall back to unicast RIB\n"
	"Lookup both, use entry with lower distance\n"
	"Lookup both, use entry with longer prefix\n"
	"Set a specific mode matching group\n"
	"Multicast group prefix list\n"
	"Set a specific mode matching source address\n"
	"Source address prefix list\n")

DEFSH (VTYSH_PIMD, pim_spt_switchover_infinity_cmd_vtysh,
	"spt-switchover infinity-and-beyond",
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n")

DEFSH (VTYSH_PIMD, pim_spt_switchover_infinity_plist_cmd_vtysh,
	"spt-switchover infinity-and-beyond prefix-list PREFIXLIST4_NAME$plist",
	"SPT-Switchover\n"
	"Never switch to SPT Tree\n"
	"Prefix-List to control which groups to switch\n"
	"Prefix-List name\n")

DEFSH (VTYSH_PIMD, pim_ssm_prefix_list_cmd_vtysh,
	"ssm prefix-list PREFIXLIST4_NAME$plist",
	"Source Specific Multicast\n"
	"group range prefix-list filter\n"
	"Name of a prefix-list\n")

DEFSH (VTYSH_PIMD, pim_ssmpingd_cmd_vtysh,
	"ssmpingd [A.B.C.D]$src",
	"Enable ssmpingd operation\n"
	"Source address\n")

DEFSH_HIDDEN (VTYSH_PIMD, pim_test_sg_keepalive_cmd_vtysh,
	"test pim [vrf NAME$name] keepalive-reset A.B.C.D$source A.B.C.D$group",
	"Test code\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Reset the Keepalive Timer\n"
	"The Source we are resetting\n"
	"The Group we are resetting\n")

DEFSH (VTYSH_PIMD, pim_v6_secondary_cmd_vtysh,
	"send-v6-secondary",
	"Send v6 secondary addresses\n")

DEFSH (VTYSH_ISISD, prefix_metric_cmd_vtysh,
	"[no] prefix-metric",
	"Negate a command or set its defaults\n"
	"Use Flex-Algo Prefix Metric\n")

DEFSH (VTYSH_ISISD, priority_cmd_vtysh,
	"[no] priority (0-255)$priority",
	"Negate a command or set its defaults\n"
	"Flex-Algo definition priority\n"
	"Priority value\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, proto_nexthop_group_only_cmd_vtysh,
	"[no] zebra nexthop proto only",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Nexthop configuration\n"
	"Configure exclusive use of proto nexthops\n"
	"Only use proto nexthops\n")

DEFSH (VTYSH_ZEBRA, pseudowire_control_word_cmd_vtysh,
	"[no] control-word <exclude|include>",
	"Negate a command or set its defaults\n"
	"Control-word options\n"
	"Exclude control-word in pseudowire packets\n"
	"Include control-word in pseudowire packets\n")

DEFSH (VTYSH_ZEBRA, pseudowire_labels_cmd_vtysh,
	"[no] mpls label local (16-1048575) remote (16-1048575)",
	"Negate a command or set its defaults\n"
	"MPLS L2VPN PW command\n"
	"MPLS L2VPN static labels\n"
	"Local pseudowire label\n"
	"Local pseudowire label\n"
	"Remote pseudowire label\n"
	"Remote pseudowire label\n")

DEFSH (VTYSH_ZEBRA, pseudowire_neighbor_cmd_vtysh,
	"[no] neighbor <A.B.C.D|X:X::X:X>",
	"Negate a command or set its defaults\n"
	"Specify the IPv4 or IPv6 address of the remote endpoint\n"
	"IPv4 address\n"
	"IPv6 address\n")

DEFSH (VTYSH_ISISD, psnp_interval_cmd_vtysh,
	"isis psnp-interval (1-120)$intv [level-1|level-2]$level",
	"IS-IS routing protocol\n"
	"Set PSNP interval in seconds\n"
	"PSNP interval value\n"
	"Specify interval for level-1 PSNPs\n"
	"Specify interval for level-2 PSNPs\n")

DEFSH (VTYSH_BGPD, rfp_example_config_value_cmd_vtysh,
	"rfp example-config-value VALUE",
	"RFP information\n"
	"Example value to be configured\n"
	"Value to display\n")

DEFSH (VTYSH_BGPD, rfp_full_table_download_cmd_vtysh,
	"rfp full-table-download <on|off>",
	"RFP information\n"
	"RFP full table download support (default=on)\n"
	"Enable RFP full table download\n"
	"Disable RFP full table download\n")

DEFSH (VTYSH_BGPD, rfp_holddown_factor_cmd_vtysh,
	"rfp holddown-factor (0-4294967295)",
	"RFP information\n"
	"Set Hold-Down Factor as a percentage of registration lifetime.\n"
	"Percentage of registration lifetime\n")

DEFSH (VTYSH_MGMTD, rip_allow_ecmp_cmd_vtysh,
	"allow-ecmp [(1-256)]",
	"Allow Equal Cost MultiPath\n"
	"Number of paths\n")

DEFSH (VTYSH_MGMTD, rip_bfd_default_profile_cmd_vtysh,
	"bfd default-profile BFDPROF$profile",
	"Bidirectional Forwarding Detection\n"
	"BFD default profile\n"
	"Profile name\n")

DEFSH (VTYSH_MGMTD, rip_default_information_originate_cmd_vtysh,
	"[no] default-information originate",
	"Negate a command or set its defaults\n"
	"Control distribution of default route\n"
	"Distribute a default route\n")

DEFSH (VTYSH_MGMTD, rip_default_metric_cmd_vtysh,
	"default-metric (1-16)",
	"Set a metric of redistribute routes\n"
	"Default metric\n")

DEFSH (VTYSH_MGMTD, rip_distance_cmd_vtysh,
	"distance (1-255)",
	"Administrative distance\n"
	"Distance value\n")

DEFSH (VTYSH_MGMTD, rip_distance_source_cmd_vtysh,
	"[no] distance (1-255) A.B.C.D/M$prefix [WORD$acl]",
	"Negate a command or set its defaults\n"
	"Administrative distance\n"
	"Distance value\n"
	"IP source prefix\n"
	"Access list name\n")

DEFSH (VTYSH_MGMTD, rip_distribute_list_cmd_vtysh,
	"distribute-list ACCESSLIST4_NAME$name <in|out>$dir [WORD$ifname]",
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, rip_distribute_list_prefix_cmd_vtysh,
	"distribute-list prefix PREFIXLIST4_NAME$name <in|out>$dir [WORD$ifname]",
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, rip_neighbor_cmd_vtysh,
	"[no] neighbor A.B.C.D",
	"Negate a command or set its defaults\n"
	"Specify a neighbor router\n"
	"Neighbor address\n")

DEFSH (VTYSH_MGMTD, rip_network_if_cmd_vtysh,
	"[no] network WORD",
	"Negate a command or set its defaults\n"
	"Enable routing on an IP network\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, rip_network_prefix_cmd_vtysh,
	"[no] network A.B.C.D/M",
	"Negate a command or set its defaults\n"
	"Enable routing on an IP network\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n")

DEFSH (VTYSH_MGMTD, rip_offset_list_cmd_vtysh,
	"[no] offset-list ACCESSLIST4_NAME$acl <in|out>$direction (0-16)$metric [IFNAME]",
	"Negate a command or set its defaults\n"
	"Modify RIP metric\n"
	"Access-list name\n"
	"For incoming updates\n"
	"For outgoing updates\n"
	"Metric value\n"
	"Interface to match\n")

DEFSH (VTYSH_MGMTD, rip_passive_default_cmd_vtysh,
	"[no] passive-interface default",
	"Negate a command or set its defaults\n"
	"Suppress routing updates on an interface\n"
	"default for all interfaces\n")

DEFSH (VTYSH_MGMTD, rip_passive_interface_cmd_vtysh,
	"[no] passive-interface IFNAME",
	"Negate a command or set its defaults\n"
	"Suppress routing updates on an interface\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, rip_redistribute_cmd_vtysh,
	"[no] redistribute <kernel|connected|local|static|ospf|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>$protocol [{metric (0-16)|route-map RMAP_NAME$route_map}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric\n"
	"Metric value\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_MGMTD, rip_route_cmd_vtysh,
	"[no] route A.B.C.D/M",
	"Negate a command or set its defaults\n"
	"RIP static route configuration\n"
	"IP prefix <network>/<length>\n")

DEFSH (VTYSH_MGMTD, rip_timers_cmd_vtysh,
	"timers basic (1-32767)$update (1-32767)$timeout (1-32767)$garbage",
	"Adjust routing timers\n"
	"Basic routing protocol update timers\n"
	"Routing table update timer value in second. Default is 30.\n"
	"Routing information timeout timer. Default is 180.\n"
	"Garbage collection timer. Default is 240.\n")

DEFSH (VTYSH_MGMTD, rip_version_cmd_vtysh,
	"version (1-2)",
	"Set routing protocol version\n"
	"version\n")

DEFSH (VTYSH_MGMTD, ripng_aggregate_address_cmd_vtysh,
	"[no] aggregate-address X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"Set aggregate RIPng route announcement\n"
	"Aggregate network\n")

DEFSH (VTYSH_MGMTD, ripng_allow_ecmp_cmd_vtysh,
	"allow-ecmp [(1-256)]",
	"Allow Equal Cost MultiPath\n"
	"Number of paths\n")

DEFSH (VTYSH_MGMTD, ripng_default_information_originate_cmd_vtysh,
	"[no] default-information originate",
	"Negate a command or set its defaults\n"
	"Default route information\n"
	"Distribute default route\n")

DEFSH (VTYSH_MGMTD, ripng_default_metric_cmd_vtysh,
	"default-metric (1-16)",
	"Set a metric of redistribute routes\n"
	"Default metric\n")

DEFSH (VTYSH_MGMTD, ripng_ipv6_distribute_list_cmd_vtysh,
	"ipv6 distribute-list ACCESSLIST6_NAME$name <in|out>$dir [WORD$ifname]",
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Access-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, ripng_ipv6_distribute_list_prefix_cmd_vtysh,
	"ipv6 distribute-list prefix PREFIXLIST6_NAME$name <in|out>$dir [WORD$ifname]",
	"IPv6\n"
	"Filter networks in routing updates\n"
	"Specify a prefix list\n"
	"Prefix-list name\n"
	"Filter incoming routing updates\n"
	"Filter outgoing routing updates\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, ripng_network_if_cmd_vtysh,
	"[no] network WORD",
	"Negate a command or set its defaults\n"
	"RIPng enable on specified interface or network.\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, ripng_network_prefix_cmd_vtysh,
	"[no] network X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"RIPng enable on specified interface or network.\n"
	"IPv6 network\n")

DEFSH (VTYSH_MGMTD, ripng_offset_list_cmd_vtysh,
	"[no] offset-list ACCESSLIST6_NAME$acl <in|out>$direction (0-16)$metric [IFNAME]",
	"Negate a command or set its defaults\n"
	"Modify RIPng metric\n"
	"Access-list name\n"
	"For incoming updates\n"
	"For outgoing updates\n"
	"Metric value\n"
	"Interface to match\n")

DEFSH (VTYSH_MGMTD, ripng_passive_interface_cmd_vtysh,
	"[no] passive-interface IFNAME",
	"Negate a command or set its defaults\n"
	"Suppress routing updates on an interface\n"
	"Interface name\n")

DEFSH (VTYSH_MGMTD, ripng_redistribute_cmd_vtysh,
	"[no] redistribute <kernel|connected|local|static|ospf6|isis|bgp|nhrp|vnc|babel|openfabric>$protocol [{metric (0-16)|route-map RMAP_NAME$route_map}]",
	"Negate a command or set its defaults\n"
	"Redistribute information from another routing protocol\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Metric\n"
	"Metric value\n"
	"Route map reference\n"
	"Pointer to route-map entries\n")

DEFSH (VTYSH_MGMTD, ripng_route_cmd_vtysh,
	"[no] route X:X::X:X/M",
	"Negate a command or set its defaults\n"
	"Static route setup\n"
	"Set static RIPng route announcement\n")

DEFSH (VTYSH_MGMTD, ripng_timers_cmd_vtysh,
	"timers basic (1-65535)$update (1-65535)$timeout (1-65535)$garbage",
	"RIPng timers setup\n"
	"Basic timer\n"
	"Routing table update timer value in second. Default is 30.\n"
	"Routing information timeout timer. Default is 180.\n"
	"Garbage collection timer. Default is 120.\n")

DEFSH (VTYSH_RMAP_CONFIG, rmap_call_cmd_vtysh,
	"call WORD$name",
	"Jump to another Route-Map after match+set\n"
	"Target route-map name\n")

DEFSH (VTYSH_RMAP_SHOW, rmap_clear_counters_cmd_vtysh,
	"clear route-map counters [RMAP_NAME$rmapname]",
	"Reset functions\n"
	"route-map information\n"
	"counters associated with the specified route-map\n"
	"route-map name\n")

DEFSH (VTYSH_RMAP_CONFIG, rmap_continue_cmd_vtysh,
	"continue (1-65535)$rm_num",
	"Continue on a different entry within the route-map\n"
	"Route-map entry sequence number\n")

DEFSH (VTYSH_RMAP_CONFIG, rmap_description_cmd_vtysh,
	"description LINE...",
	"Route-map comment\n"
	"Comment describing this route-map rule\n")

DEFSH (VTYSH_RMAP_CONFIG, rmap_onmatch_goto_cmd_vtysh,
	"on-match goto (1-65535)$rm_num",
	"Exit policy on matches\n"
	"Goto Clause number\n"
	"Number\n")

DEFSH (VTYSH_RMAP_CONFIG, rmap_onmatch_next_cmd_vtysh,
	"on-match next",
	"Exit policy on matches\n"
	"Next clause\n")

DEFSH (VTYSH_RMAP_SHOW, rmap_show_unused_cmd_vtysh,
	"show route-map-unused",
	"Show running system information\n"
	"unused route-map information\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, rnh_hide_backups_cmd_vtysh,
	"[no] ip nht hide-backup-events",
	"Negate a command or set its defaults\n"
	"IP information\n"
	"Nexthop-tracking configuration\n"
	"Hide notification about backup nexthops\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, route_map_match_address_cmd_vtysh,
	"[no] match ip <multicast-source$do_src A.B.C.D$addr|multicast-group$do_grp A.B.C.D$addr>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Multicast source address\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Multicast group address\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, route_map_match_address_v6_cmd_vtysh,
	"[no] match ipv6 <multicast-source$do_src X:X::X:X$addr|multicast-group$do_grp X:X::X:X$addr>",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Multicast source address\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Multicast group address\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, route_map_match_interface_cmd_vtysh,
	"[no] match multicast-interface IFNAME",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"Multicast data interface\n"
	"Interface name\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, route_map_match_prefix_list_cmd_vtysh,
	"[no] match ip <multicast-source$do_src|multicast-group$do_grp> prefix-list PREFIXLIST4_NAME$prefix_list",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IP information\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Match against IPv4 prefix list\n"
	"Prefix list name\n")

DEFSH (VTYSH_PIM6D|VTYSH_PIMD, route_map_match_prefix_list_v6_cmd_vtysh,
	"[no] match ipv6 <multicast-source$do_src|multicast-group$do_grp> prefix-list PREFIXLIST6_NAME$prefix_list",
	"Negate a command or set its defaults\n"
	"Match values from routing table\n"
	"IPv6 information\n"
	"Multicast source address\n"
	"Multicast group address\n"
	"Match against IPv6 prefix list\n"
	"Prefix list name\n")

DEFSH (VTYSH_RMAP_CONFIG, route_map_optimization_cmd_vtysh,
	"[no] route-map RMAP_NAME$name optimization",
	"Negate a command or set its defaults\n"
	"Create route-map or enter route-map command mode\n"
	"Route map tag\n"
	"Configure route-map optimization\n")

DEFSH (VTYSH_MGMTD, router_id_cmd_vtysh,
	"[no] router-id A.B.C.D$id vrf NAME",
	"Negate a command or set its defaults\n"
	"Manually set the router-id\n"
	"IP address to use for router-id\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_MGMTD, router_id_in_vrf_cmd_vtysh,
	"[no] router-id ![A.B.C.D$id]",
	"Negate a command or set its defaults\n"
	"Manually set the router-id\n"
	"IP address to use for router-id\n")

DEFSH (VTYSH_OSPFD, router_info_area_cmd_vtysh,
	"router-info <as|area>",
	"OSPF Router Information specific commands\n"
	"Enable the Router Information functionality with AS flooding scope\n"
	"Enable the Router Information functionality with Area flooding scope\n")

DEFSH (VTYSH_BGPD, rpki_cache_ssh_cmd_vtysh,
	"rpki cache ssh <A.B.C.D|WORD>$cache (1-65535)$sshport SSH_UNAME SSH_PRIVKEY [KNOWN_HOSTS_PATH] [source <A.B.C.D>$bindaddr] preference (1-255)",
	"Control rpki specific settings\n"
	"Install a cache server to current group\n"
	"Use SSH\n"
	"IP address of cache server\n"
	"Hostname of cache server\n"
	"SSH port number\n"
	"SSH user name\n"
	"Path to own SSH private key\n"
	"Path to the known hosts file\n"
	"Configure source IP address of RPKI connection\n"
	"Define a Source IP Address\n"
	"Preference of the cache server\n"
	"Preference value\n")

DEFSH (VTYSH_BGPD, rpki_cache_tcp_cmd_vtysh,
	"rpki cache tcp <A.B.C.D|WORD>$cache TCPPORT [source <A.B.C.D>$bindaddr] preference (1-255)",
	"Control rpki specific settings\n"
	"Install a cache server to current group\n"
	"Use TCP\n"
	"IP address of cache server\n"
	"Hostname of cache server\n"
	"TCP port number\n"
	"Configure source IP address of RPKI connection\n"
	"Define a Source IP Address\n"
	"Preference of the cache server\n"
	"Preference value\n")

DEFSH (VTYSH_BGPD, rpki_expire_interval_cmd_vtysh,
	"rpki expire_interval (600-172800)$tmp",
	"Control rpki specific settings\n"
	"Set expire interval\n"
	"Expire interval value\n")

DEFSH (VTYSH_BGPD, rpki_polling_period_cmd_vtysh,
	"rpki polling_period (1-86400)$pp",
	"Control rpki specific settings\n"
	"Set polling period\n"
	"Polling period value\n")

DEFSH (VTYSH_BGPD, rpki_reset_cmd_vtysh,
	"rpki reset [vrf NAME$vrfname]",
	"Control rpki specific settings\n"
	"reset rpki\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_BGPD, rpki_reset_config_mode_cmd_vtysh,
	"rpki reset",
	"Control rpki specific settings\n"
	"reset rpki\n")

DEFSH (VTYSH_BGPD, rpki_retry_interval_cmd_vtysh,
	"rpki retry_interval (1-7200)$tmp",
	"Control rpki specific settings\n"
	"Set retry interval\n"
	"retry interval value\n")

DEFSH (VTYSH_BFDD, sbfd_echo_no_peer_cmd_vtysh,
	"no peer <A.B.C.D|X:X::X:X> bfd-mode sbfd-echo bfd-name BFDNAME$bfdname 	[multihop$multihop] local-address <A.B.C.D|X:X::X:X> [vrf NAME] 	srv6-source-ipv6 X:X::X:X srv6-encap-data X:X::X:X...",
	"Negate a command or set its defaults\n"
	"Configure peer\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Specify bfd session mode\n"
	"Enable sbfd-echo mode\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Configure VRF\n"
	"Configure VRF name\n"
	"Configure source ipv6 address for srv6 encap\n"
	"IPv6 local address\n"
	"Configure sidlist data for srv6 encap\n"
	"X:X::X:X IPv6 sid address\n")

DEFSH (VTYSH_BFDD, sbfd_init_no_peer_cmd_vtysh,
	"no peer <A.B.C.D|X:X::X:X> bfd-mode sbfd-init bfd-name BFDNAME$bfdname 	[multihop$multihop] local-address <A.B.C.D|X:X::X:X> [vrf NAME] 	remote-discr (0-4294967295)$discr srv6-source-ipv6 X:X::X:X srv6-encap-data X:X::X:X...",
	"Negate a command or set its defaults\n"
	"Configure peer\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Specify bfd session mode\n"
	"Enable sbfd-init mode\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Configure VRF\n"
	"Configure VRF name\n"
	"Configure bfd session remote discriminator\n"
	"Configure remote discriminator\n"
	"Configure source ipv6 address for srv6 encap\n"
	"IPv6 local address\n"
	"Configure sidlist data for srv6 encap\n"
	"X:X::X:X IPv6 sid address\n")

DEFSH (VTYSH_BFDD, sbfd_init_no_peer_raw_cmd_vtysh,
	"no peer <A.B.C.D|X:X::X:X> bfd-mode sbfd-init bfd-name BFDNAME$bfdname 	[multihop$multihop] local-address <A.B.C.D|X:X::X:X> [vrf NAME] 	remote-discr (0-4294967295)$discr",
	"Negate a command or set its defaults\n"
	"Configure peer\n"
	"IPv4 peer address\n"
	"IPv6 peer address\n"
	"Specify bfd session mode\n"
	"Enable sbfd-init mode\n"
	"Specify bfd session name\n"
	"bfd session name\n"
	"Configure multihop\n"
	"Configure local address\n"
	"IPv4 local address\n"
	"IPv6 local address\n"
	"Configure VRF\n"
	"Configure VRF name\n"
	"Configure bfd session remote discriminator\n"
	"Configure remote discriminator\n")

DEFSH (VTYSH_BFDD, sbfd_reflector_cmd_vtysh,
	"sbfd reflector source-address X:X::X:X$srcip discriminator WORD...",
	"seamless BFD\n"
	"sbfd reflector\n"
	"binding source ip address\n"
	"IPv6 information\n"
	"discriminator\n"
	"discriminator value or range (e.g. 100 or 100 200 300 or 100-300)\n")

DEFSH (VTYSH_BFDD, sbfd_reflector_show_info_cmd_vtysh,
	"show sbfd reflector",
	"show\n"
	"seamless BFD\n"
	"sbfd reflector\n")

DEFSH (VTYSH_KEYS, send_lifetime_day_month_day_month_cmd_vtysh,
	"send-lifetime HH:MM:SS (1-31) MONTH (1993-2035) HH:MM:SS (1-31) MONTH (1993-2035)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Day of th month to expire\n"
	"Month of the year to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, send_lifetime_day_month_month_day_cmd_vtysh,
	"send-lifetime HH:MM:SS (1-31) MONTH (1993-2035) HH:MM:SS MONTH (1-31) (1993-2035)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Month of the year to expire\n"
	"Day of th month to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, send_lifetime_duration_day_month_cmd_vtysh,
	"send-lifetime HH:MM:SS (1-31) MONTH (1993-2035) duration (1-2147483646)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Duration of the key\n"
	"Duration seconds\n")

DEFSH (VTYSH_KEYS, send_lifetime_duration_month_day_cmd_vtysh,
	"send-lifetime HH:MM:SS MONTH (1-31) (1993-2035) duration (1-2147483646)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Duration of the key\n"
	"Duration seconds\n")

DEFSH (VTYSH_KEYS, send_lifetime_infinite_day_month_cmd_vtysh,
	"send-lifetime HH:MM:SS (1-31) MONTH (1993-2035) infinite",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Day of th month to start\n"
	"Month of the year to start\n"
	"Year to start\n"
	"Never expires\n")

DEFSH (VTYSH_KEYS, send_lifetime_infinite_month_day_cmd_vtysh,
	"send-lifetime HH:MM:SS MONTH (1-31) (1993-2035) infinite",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Never expires\n")

DEFSH (VTYSH_KEYS, send_lifetime_month_day_day_month_cmd_vtysh,
	"send-lifetime HH:MM:SS MONTH (1-31) (1993-2035) HH:MM:SS (1-31) MONTH (1993-2035)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Day of th month to expire\n"
	"Month of the year to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_KEYS, send_lifetime_month_day_month_day_cmd_vtysh,
	"send-lifetime HH:MM:SS MONTH (1-31) (1993-2035) HH:MM:SS MONTH (1-31) (1993-2035)",
	"Set send lifetime of the key\n"
	"Time to start\n"
	"Month of the year to start\n"
	"Day of th month to start\n"
	"Year to start\n"
	"Time to expire\n"
	"Month of the year to expire\n"
	"Day of th month to expire\n"
	"Year to expire\n")

DEFSH (VTYSH_ALL, send_log_cmd_vtysh,
	"send log [level <emergencies|alerts|critical|errors|warnings|notifications|informational|debugging>$levelarg] LINE...",
	"Send message\n"
	"Send log message\n"
	"Level of log message\n"
	"System is unusable\n"
	"Immediate action needed\n"
	"Critical conditions\n"
	"Error conditions\n"
	"Warning conditions\n"
	"Normal but significant conditions\n"
	"Informational messages\n"
	"Debugging messages\n"
	"Log message to send\n")

DEFSH (VTYSH_ALL, service_advanced_vty_cmd_vtysh,
	"service advanced-vty",
	"Set up miscellaneous service\n"
	"Enable advanced mode vty interface\n")

DEFSH (VTYSH_ALL, service_cputime_stats_cmd_vtysh,
	"[no] service cputime-stats",
	"Negate a command or set its defaults\n"
	"Set up miscellaneous service\n"
	"Collect CPU usage statistics\n")

DEFSH (VTYSH_ALL, service_cputime_warning_cmd_vtysh,
	"[no] service cputime-warning ![(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set up miscellaneous service\n"
	"Warn for tasks exceeding CPU usage threshold\n"
	"Warning threshold in milliseconds\n")

DEFSH (VTYSH_ALL, service_walltime_warning_cmd_vtysh,
	"[no] service walltime-warning ![(1-4294967295)]",
	"Negate a command or set its defaults\n"
	"Set up miscellaneous service\n"
	"Warn for tasks exceeding total wallclock threshold\n"
	"Warning threshold in milliseconds\n")

DEFSH (VTYSH_BGPD, set_aggregator_as_cmd_vtysh,
	"set aggregator as ASNUM A.B.C.D",
	"Set values in destination routing protocol\n"
	"BGP aggregator attribute\n"
	"AS number of aggregator\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"IP address of aggregator\n")

DEFSH (VTYSH_BGPD, set_aigp_metric_cmd_vtysh,
	"set aigp-metric <igp-metric|(0-4294967295)>$aigp_metric",
	"Set values in destination routing protocol\n"
	"BGP AIGP attribute (AIGP Metric TLV)\n"
	"AIGP Metric value from IGP protocol\n"
	"Manual AIGP Metric value\n")

DEFSH (VTYSH_BGPD, set_aspath_exclude_access_list_cmd_vtysh,
	"set as-path exclude as-path-access-list AS_PATH_FILTER_NAME",
	"Set values in destination routing protocol\n"
	"Transform BGP AS-path attribute\n"
	"Exclude from the as-path\n"
	"Specify an as path access list name\n"
	"AS path access list name\n")

DEFSH (VTYSH_BGPD, set_aspath_exclude_all_cmd_vtysh,
	"[no$no] set as-path exclude all$all",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"Transform BGP AS-path attribute\n"
	"Exclude from the as-path\n"
	"Exclude all AS numbers from the as-path\n")

DEFSH (VTYSH_BGPD, set_aspath_exclude_cmd_vtysh,
	"set as-path exclude ASNUM...",
	"Set values in destination routing protocol\n"
	"Transform BGP AS-path attribute\n"
	"Exclude from the as-path\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, set_aspath_prepend_asn_cmd_vtysh,
	"set as-path prepend ASNUM...",
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Prepend to the as-path\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n")

DEFSH (VTYSH_BGPD, set_aspath_prepend_lastas_cmd_vtysh,
	"set as-path prepend last-as (1-10)",
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Prepend to the as-path\n"
	"Use the last AS-number in the as-path\n"
	"Number of times to insert\n")

DEFSH (VTYSH_BGPD, set_aspath_replace_access_list_cmd_vtysh,
	"set as-path replace as-path-access-list AS_PATH_FILTER_NAME$aspath_filter_name [<ASNUM>$configured_asn]",
	"Set values in destination routing protocol\n"
	"Transform BGP AS-path attribute\n"
	"Replace AS number to local or configured AS number\n"
	"Specify an as path access list name\n"
	"AS path access list name\n"
	"Define the configured AS number\n")

DEFSH (VTYSH_BGPD, set_aspath_replace_asn_cmd_vtysh,
	"set as-path replace <any|ASNUM>$replace [<ASNUM>$configured_asn]",
	"Set values in destination routing protocol\n"
	"Transform BGP AS_PATH attribute\n"
	"Replace AS number to local or configured AS number\n"
	"Replace any AS number to local or configured AS number\n"
	"Replace a specific AS number to local or configured AS number\n"
	"Define the configured AS number\n")

DEFSH (VTYSH_BGPD, set_atomic_aggregate_cmd_vtysh,
	"set atomic-aggregate",
	"Set values in destination routing protocol\n"
	"BGP atomic aggregate attribute\n")

DEFSH (VTYSH_BGPD, set_community_cmd_vtysh,
	"set community AA:NN...",
	"Set values in destination routing protocol\n"
	"BGP community attribute\n"
	"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive\n")

DEFSH (VTYSH_BGPD, set_community_delete_cmd_vtysh,
	"set comm-list <(1-99)|(100-500)|COMMUNITY_LIST_NAME> delete",
	"Set values in destination routing protocol\n"
	"set BGP community list (for deletion)\n"
	"Community-list number (standard)\n"
	"Community-list number (expanded)\n"
	"Community-list name\n"
	"Delete matching communities\n")

DEFSH (VTYSH_BGPD, set_community_none_cmd_vtysh,
	"set community none",
	"Set values in destination routing protocol\n"
	"BGP community attribute\n"
	"No community attribute\n")

DEFSH (VTYSH_BGPD, set_distance_cmd_vtysh,
	"set distance (1-255)",
	"Set values in destination routing protocol\n"
	"BGP Administrative Distance to use\n"
	"Distance value\n")

DEFSH (VTYSH_BGPD, set_ecommunity_color_cmd_vtysh,
	"set extcommunity color RTLIST...",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Color extended community\n"
	"Color ID\n")

DEFSH (VTYSH_BGPD, set_ecommunity_delete_cmd_vtysh,
	"set extended-comm-list <(1-99)|(100-500)|EXTCOMMUNITY_LIST_NAME> delete",
	"Set values in destination routing protocol\n"
	"set BGP extended community list (for deletion)\n"
	"Extended community-list number (standard)\n"
	"Extended community-list number (expanded)\n"
	"Extended community-list name\n"
	"Delete matching extended communities\n")

DEFSH (VTYSH_BGPD, set_ecommunity_lb_cmd_vtysh,
	"set extcommunity bandwidth <(0-4294967295)|cumulative|num-multipaths> [non-transitive]",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Link bandwidth extended community\n"
	"Bandwidth value in Mbps\n"
	"Cumulative bandwidth of all multipaths (outbound-only)\n"
	"Internally computed bandwidth based on number of multipaths (outbound-only)\n"
	"Attribute is set as non-transitive\n")

DEFSH (VTYSH_BGPD, set_ecommunity_none_cmd_vtysh,
	"set extcommunity none",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"No extended community attribute\n")

DEFSH (VTYSH_BGPD, set_ecommunity_nt_cmd_vtysh,
	"set extcommunity nt RTLIST...",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Node Target extended community\n"
	"Node Target ID\n")

DEFSH (VTYSH_BGPD, set_ecommunity_rt_cmd_vtysh,
	"set extcommunity rt ASN:NN_OR_IP-ADDRESS:NN...",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Route Target extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, set_ecommunity_soo_cmd_vtysh,
	"set extcommunity soo ASN:NN_OR_IP-ADDRESS:NN...",
	"Set values in destination routing protocol\n"
	"BGP extended community attribute\n"
	"Site-of-Origin extended community\n"
	"VPN extended community\n")

DEFSH (VTYSH_BGPD, set_evpn_gw_ip_ipv4_cmd_vtysh,
	"set evpn gateway-ip ipv4 A.B.C.D",
	"Set values in destination routing protocol\n"
	"Ethernet Virtual Private Network\n"
	"Set gateway IP for prefix advertisement route\n"
	"IPv4 address\n"
	"Gateway IP address in IPv4 format\n")

DEFSH (VTYSH_BGPD, set_evpn_gw_ip_ipv6_cmd_vtysh,
	"set evpn gateway-ip ipv6 X:X::X:X",
	"Set values in destination routing protocol\n"
	"Ethernet Virtual Private Network\n"
	"Set gateway IP for prefix advertisement route\n"
	"IPv6 address\n"
	"Gateway IP address in IPv6 format\n")

DEFSH (VTYSH_RMAP_CONFIG, set_ip_nexthop_cmd_vtysh,
	"set ip next-hop A.B.C.D$addr",
	"Set values in destination routing protocol\n"
	"IP information\n"
	"Next hop address\n"
	"IP address of next hop\n")

DEFSH (VTYSH_BGPD, set_ip_nexthop_peer_cmd_vtysh,
	"[no] set ip next-hop peer-address",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IP information\n"
	"Next hop address\n"
	"Use peer address (for BGP only)\n")

DEFSH (VTYSH_BGPD, set_ip_nexthop_unchanged_cmd_vtysh,
	"[no] set ip next-hop unchanged",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"IP information\n"
	"Next hop address\n"
	"Don't modify existing Next hop address\n")

DEFSH (VTYSH_BGPD, set_ipv6_nexthop_global_cmd_vtysh,
	"set ipv6 next-hop global X:X::X:X",
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"IPv6 global address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_RMAP_CONFIG, set_ipv6_nexthop_local_cmd_vtysh,
	"set ipv6 next-hop local X:X::X:X$addr",
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"IPv6 local address\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_BGPD, set_ipv6_nexthop_peer_cmd_vtysh,
	"set ipv6 next-hop peer-address",
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"Next hop address\n"
	"Use peer address (for BGP only)\n")

DEFSH (VTYSH_BGPD, set_ipv6_nexthop_prefer_global_cmd_vtysh,
	"set ipv6 next-hop prefer-global",
	"Set values in destination routing protocol\n"
	"IPv6 information\n"
	"IPv6 next-hop address\n"
	"Prefer global over link-local if both exist\n")

DEFSH (VTYSH_BGPD, set_ipx_vpn_nexthop_cmd_vtysh,
	"set <ipv4|ipv6> vpn next-hop <A.B.C.D$addrv4|X:X::X:X$addrv6>",
	"Set values in destination routing protocol\n"
	"IPv4 information\n"
	"IPv6 information\n"
	"VPN information\n"
	"VPN next-hop address\n"
	"IP address of next hop\n"
	"IPv6 address of next hop\n")

DEFSH (VTYSH_BGPD, set_l3vpn_nexthop_encapsulation_cmd_vtysh,
	"[no] set l3vpn next-hop encapsulation gre",
	"Negate a command or set its defaults\n"
	"Set values in destination routing protocol\n"
	"L3VPN operations\n"
	"Next hop Information\n"
	"Encapsulation options (for BGP only)\n"
	"Accept L3VPN traffic over GRE encapsulation\n")

DEFSH (VTYSH_BGPD, set_label_index_cmd_vtysh,
	"set label-index (0-1048560)",
	"Set values in destination routing protocol\n"
	"Label index to associate with the prefix\n"
	"Label index value\n")

DEFSH (VTYSH_BGPD, set_lcommunity_cmd_vtysh,
	"set large-community AA:BB:CC...",
	"Set values in destination routing protocol\n"
	"BGP large community attribute\n"
	"Large Community number in aa:bb:cc format or additive\n")

DEFSH (VTYSH_BGPD, set_lcommunity_delete_cmd_vtysh,
	"set large-comm-list <(1-99)|(100-500)|LCOMMUNITY_LIST_NAME> delete",
	"Set values in destination routing protocol\n"
	"set BGP large community list (for deletion)\n"
	"Large Community-list number (standard)\n"
	"Large Communitly-list number (expanded)\n"
	"Large Community-list name\n"
	"Delete matching large communities\n")

DEFSH (VTYSH_BGPD, set_lcommunity_none_cmd_vtysh,
	"set large-community none",
	"Set values in destination routing protocol\n"
	"BGP large community attribute\n"
	"No large community attribute\n")

DEFSH (VTYSH_BGPD, set_local_pref_cmd_vtysh,
	"set local-preference WORD",
	"Set values in destination routing protocol\n"
	"BGP local preference path attribute\n"
	"Preference value (0-4294967295)\n")

DEFSH (VTYSH_RMAP_CONFIG, set_max_metric_cmd_vtysh,
	"set max-metric <(0-4294967295)$metric>",
	"Set values in destination routing protocol\n"
	"Maximum metric value for destination routing protocol\n"
	"Miximum metric value\n")

DEFSH (VTYSH_RMAP_CONFIG, set_metric_cmd_vtysh,
	"set metric <(-4294967295-4294967295)$metric|rtt$rtt|+rtt$artt|-rtt$srtt|igp$igp|aigp$aigp>",
	"Set values in destination routing protocol\n"
	"Metric value for destination routing protocol\n"
	"Metric value (use +/- for additions or subtractions)\n"
	"Assign round trip time\n"
	"Add round trip time\n"
	"Subtract round trip time\n"
	"Metric value from IGP protocol\n"
	"Metric value from AIGP (Accumulated IGP)\n")

DEFSH (VTYSH_OSPF6D|VTYSH_OSPFD, set_metric_type_cmd_vtysh,
	"set metric-type <type-1|type-2>",
	"Set values in destination routing protocol\n"
	"Type of metric for destination routing protocol\n"
	"OSPF[6] external type 1 metric\n"
	"OSPF[6] external type 2 metric\n")

DEFSH (VTYSH_RMAP_CONFIG, set_min_metric_cmd_vtysh,
	"set min-metric <(0-4294967295)$metric>",
	"Set values in destination routing protocol\n"
	"Minimum metric value for destination routing protocol\n"
	"Minimum metric value\n")

DEFSH (VTYSH_BGPD, set_origin_cmd_vtysh,
	"set origin <egp|igp|incomplete>",
	"Set values in destination routing protocol\n"
	"BGP origin code\n"
	"remote EGP\n"
	"local IGP\n"
	"unknown heritage\n")

DEFSH (VTYSH_BGPD, set_originator_id_cmd_vtysh,
	"set originator-id A.B.C.D",
	"Set values in destination routing protocol\n"
	"BGP originator ID attribute\n"
	"IP address of originator\n")

DEFSH (VTYSH_ISISD, set_overload_bit_cmd_vtysh,
	"[no] set-overload-bit",
	"Reset overload bit to accept transit traffic\n"
	"Set overload bit to avoid any transit traffic\n")

DEFSH (VTYSH_ISISD, set_overload_bit_on_startup_cmd_vtysh,
	"set-overload-bit on-startup (0-86400)$val",
	"Set overload bit to avoid any transit traffic\n"
	"Set overload bit on startup\n"
	"Set overload time in seconds\n")

DEFSH (VTYSH_MGMTD, set_src_cmd_vtysh,
	"set src <A.B.C.D$addrv4|X:X::X:X$addrv6>",
	"Set values in destination routing protocol\n"
	"src address for route\n"
	"IPv4 src address\n"
	"IPv6 src address\n")

DEFSH (VTYSH_RMAP_CONFIG, set_srte_color_cmd_vtysh,
	"set sr-te color (1-4294967295)",
	"Set values in destination routing protocol\n"
	"SR-TE information\n"
	"SR-TE Color information\n"
	"Color of the SR-TE Policies to match with\n")

DEFSH (VTYSH_BGPD, set_table_id_cmd_vtysh,
	"set table (1-4294967295)",
	"Set values in destination routing protocol\n"
	"export route to non-main kernel table\n"
	"Kernel routing table id\n")

DEFSH (VTYSH_RMAP_CONFIG, set_tag_cmd_vtysh,
	"set tag <untagged$untagged|(1-4294967295)$tagged>",
	"Set values in destination routing protocol\n"
	"Tag value for routing protocol\n"
	"Untagged route\n"
	"Tag value\n")

DEFSH (VTYSH_BGPD, set_weight_cmd_vtysh,
	"set weight (0-4294967295)",
	"Set values in destination routing protocol\n"
	"BGP weight for routing table\n"
	"Weight value\n")

DEFSH (VTYSH_BABELD, show_babel_interface_cmd_vtysh,
	"show babel interface [IFNAME]",
	"Show running system information\n"
	"Babel information\n"
	"Interface information\n"
	"Interface\n")

DEFSH (VTYSH_BABELD, show_babel_neighbour_cmd_vtysh,
	"show babel neighbor [IFNAME]",
	"Show running system information\n"
	"Babel information\n"
	"Print neighbors\n"
	"Interface\n")

DEFSH (VTYSH_BABELD, show_babel_parameters_cmd_vtysh,
	"show babel parameters",
	"Show running system information\n"
	"Babel information\n"
	"Configuration information\n")

DEFSH (VTYSH_BABELD, show_babel_route_addr6_cmd_vtysh,
	"show babel route X:X::X:X",
	"Show running system information\n"
	"Babel information\n"
	"Babel internal routing table\n"
	"IPv6 address <network>/<length>\n")

DEFSH (VTYSH_BABELD, show_babel_route_addr_cmd_vtysh,
	"show babel route A.B.C.D",
	"Show running system information\n"
	"Babel information\n"
	"Babel internal routing table\n"
	"IPv4 address <network>/<length>\n")

DEFSH (VTYSH_BABELD, show_babel_route_cmd_vtysh,
	"show babel route",
	"Show running system information\n"
	"Babel information\n"
	"Babel internal routing table\n")

DEFSH (VTYSH_BABELD, show_babel_route_prefix_cmd_vtysh,
	"show babel route <A.B.C.D/M|X:X::X:X/M>",
	"Show running system information\n"
	"Babel information\n"
	"Babel internal routing table\n"
	"IPv4 prefix <network>/<length>\n"
	"IPv6 prefix <network>/<length>\n")

DEFSH (VTYSH_BFDD, show_bfd_distributed_cmd_vtysh,
	"show bfd distributed",
	"Show running system information\n"
	"Bidirection Forwarding Detection\n"
	"Show BFD data plane (distributed BFD) statistics\n")

DEFSH (VTYSH_BGPD, show_bgp_afi_vpn_rd_route_cmd_vtysh,
	"show bgp <ipv4|ipv6> vpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> <A.B.C.D/M|X:X::X:X/M> [json]",
	"Show running system information\n"
	"BGP information\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Display information for a route distinguisher\n"
	"Route Distinguisher\n"
	"All Route Distinguishers\n"
	"Network in the BGP routing table to display\n"
	"Network in the BGP routing table to display\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_as_path_access_list_all_cmd_vtysh,
	"show bgp as-path-access-list [json]",
	"Show running system information\n"
	"BGP information\n"
	"List AS path access lists\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_as_path_access_list_cmd_vtysh,
	"show bgp as-path-access-list AS_PATH_FILTER_NAME [json]",
	"Show running system information\n"
	"BGP information\n"
	"List AS path access lists\n"
	"AS path access list name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_community_list_arg_cmd_vtysh,
	"show bgp community-list <(1-500)|COMMUNITY_LIST_NAME> detail",
	"Show running system information\n"
	"BGP information\n"
	"List community-list\n"
	"Community-list number\n"
	"Community-list name\n"
	"Detailed information on community-list\n")

DEFSH (VTYSH_BGPD, show_bgp_community_list_cmd_vtysh,
	"show bgp community-list",
	"Show running system information\n"
	"BGP information\n"
	"List community-list\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_import_rt_cmd_vtysh,
	"show bgp evpn import-rt",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"Show import route target\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_cmd_vtysh,
	"show bgp evpn route [detail] [type <macip|2|multicast|3>]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Display Detailed Information\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_rd_cmd_vtysh,
	"show bgp evpn route rd ASN:NN_OR_IP-ADDRESS:NN [type <macip|2|multicast|3>]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_rd_macip_cmd_vtysh,
	"show bgp evpn route rd ASN:NN_OR_IP-ADDRESS:NN mac WORD [ip WORD]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"IP\n"
	"IP address (IPv4 or IPv6)\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_vni_all_cmd_vtysh,
	"show bgp evpn route vni all [detail] [vtep A.B.C.D]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Print Detailed Output\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_vni_cmd_vtysh,
	"show bgp evpn route vni (1-16777215) [<type <macip|2|multicast|3> | vtep A.B.C.D>]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_vni_macip_cmd_vtysh,
	"show bgp evpn route vni (1-16777215) mac WORD [ip WORD]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"IP\n"
	"IP address (IPv4 or IPv6)\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_route_vni_multicast_cmd_vtysh,
	"show bgp evpn route vni (1-16777215) multicast A.B.C.D",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Multicast (Type-3) route\n"
	"Originating Router IP address\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_summary_cmd_vtysh,
	"show bgp evpn summary [json]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"Summary of BGP neighbor status\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_evpn_vni_cmd_vtysh,
	"show bgp evpn vni [(1-16777215)]",
	"Show running system information\n"
	"BGP information\n"
	"Ethernet Virtual Private Network\n"
	"Show VNI\n"
	"VNI number\n")

DEFSH (VTYSH_BGPD, show_bgp_extcommunity_list_arg_cmd_vtysh,
	"show bgp extcommunity-list <(1-500)|EXTCOMMUNITY_LIST_NAME> detail",
	"Show running system information\n"
	"BGP information\n"
	"List extended-community list\n"
	"Extcommunity-list number\n"
	"Extcommunity-list name\n"
	"Detailed information on extcommunity-list\n")

DEFSH (VTYSH_BGPD, show_bgp_extcommunity_list_cmd_vtysh,
	"show bgp extcommunity-list",
	"Show running system information\n"
	"BGP information\n"
	"List extended-community list\n")

DEFSH (VTYSH_BGPD, show_bgp_instance_all_ipv6_updgrps_cmd_vtysh,
	"show [ip] bgp <view|vrf> all update-groups [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"All Views/VRFs\n"
	"Detailed info about dynamic update groups\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_instance_updgrps_stats_cmd_vtysh,
	"show [ip] bgp <view|vrf> VIEWVRFNAME update-groups statistics",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Detailed info about dynamic update groups\n"
	"Statistics\n")

DEFSH (VTYSH_BGPD, show_bgp_ip_vpn_all_rd_cmd_vtysh,
	"show bgp <ipv4|ipv6> vpn all [rd <ASN:NN_OR_IP-ADDRESS:NN|all>] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Address Family\n"
	"Address Family\n"
	"Display VPN NLRI specific information\n"
	"Display VPN NLRI specific information\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_ip_vpn_rd_cmd_vtysh,
	"show bgp <ipv4|ipv6> vpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> [json]",
	"Show running system information\n"
	"BGP information\n"
	"Address Family\n"
	"Address Family\n"
	"Display VPN NLRI specific information\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_com_cmd_vtysh,
	"show bgp l2vpn evpn       <community AA:NN|large-community AA:BB:CC>       [exact-match] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display routes matching the community\n"
	"Community number where AA and NN are (0-65535)\n"
	"Display routes matching the large-community\n"
	"List of large-community numbers\n"
	"Exact match of the communities\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_es_cmd_vtysh,
	"show bgp l2vpn evpn es [NAME$esi_str|detail$detail] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Ethernet Segment\n"
	"ES ID\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_es_evi_cmd_vtysh,
	"show bgp l2vpn evpn es-evi [vni (1-16777215)$vni] [json$uj] [detail$detail]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"ES per EVI\n"
	"VxLAN Network Identifier\n"
	"VNI\n"
	"JavaScript Object Notation\n"
	"Detailed information\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_es_vrf_cmd_vtysh,
	"show bgp l2vpn evpn es-vrf [NAME$esi_str] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Ethernet Segment\n"
	"ES ID\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_import_rt_cmd_vtysh,
	"show bgp l2vpn evpn import-rt [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Show import route target\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_nh_cmd_vtysh,
	"show bgp l2vpn evpn next-hops [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Nexthops\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_cmd_vtysh,
	"show bgp l2vpn evpn route [detail] [type <ead|1|macip|2|multicast|3|es|4|prefix|5>] [self-originate] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Display Detailed Information\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n"
	"Display only self-originated routes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_esi_cmd_vtysh,
	"show bgp l2vpn evpn route esi ESI [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Ethernet Segment Identifier\n"
	"ESI ID\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_mac_ip_evi_es_cmd_vtysh,
	"show bgp l2vpn evpn route mac-ip-evi-es [NAME$esi_str|detail$detail] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"MAC IP routes in the EVI tables linked to the ES\n"
	"ES ID\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_mac_ip_global_es_cmd_vtysh,
	"show bgp l2vpn evpn route mac-ip-global-es [NAME$esi_str|detail$detail] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"MAC IP routes in the global table linked to the ES\n"
	"ES ID\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_prefix_cmd_vtysh,
	"show bgp l2vpn evpn <A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M> [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Network in the BGP routing table to display\n"
	"Network in the BGP routing table to display\n"
	"Network in the BGP routing table to display\n"
	"Network in the BGP routing table to display\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_rd_cmd_vtysh,
	"show bgp l2vpn evpn route rd <ASN:NN_OR_IP-ADDRESS:NN|all> [type <ead|1|macip|2|multicast|3|es|4|prefix|5>] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n"
	"All VPN Route Distinguishers\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Ethernet Segment (Type-4) route\n"
	"Prefix (Type-5) route\n"
	"Prefix (Type-5) route\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_rd_macip_cmd_vtysh,
	"show bgp l2vpn evpn route rd <ASN:NN_OR_IP-ADDRESS:NN|all> mac WORD [ip WORD] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"Route Distinguisher\n"
	"ASN:XX or A.B.C.D:XX\n"
	"All VPN Route Distinguishers\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"IP\n"
	"IP address (IPv4 or IPv6)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_vni_all_cmd_vtysh,
	"show bgp l2vpn evpn route vni all [detail] [vtep A.B.C.D] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Print Detailed Output\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_vni_cmd_vtysh,
	"show bgp l2vpn evpn route vni (1-16777215) [<type <ead|1|macip|2|multicast|3> | vtep A.B.C.D>] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_vni_macip_cmd_vtysh,
	"show bgp l2vpn evpn route vni (1-16777215) mac WORD [ip WORD] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"IP\n"
	"IP address (IPv4 or IPv6)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_route_vni_multicast_cmd_vtysh,
	"show bgp l2vpn evpn route vni (1-16777215) multicast A.B.C.D [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"EVPN route information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Multicast (Type-3) route\n"
	"Originating Router IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_summary_cmd_vtysh,
	"show bgp [vrf VRFNAME] l2vpn evpn summary [established|failed] [<neighbor <A.B.C.D|X:X::X:X|WORD>|remote-as <(1-4294967295)|internal|external>>] [terse] [wide] [json]",
	"Show running system information\n"
	"BGP information\n"
	"bgp vrf\n"
	"vrf name\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Summary of BGP neighbor status\n"
	"Show only sessions in Established state\n"
	"Show only sessions not in Established state\n"
	"Show only the specified neighbor session\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Show only the specified remote AS sessions\n"
	"AS number\n"
	"Internal (iBGP) AS sessions\n"
	"External (eBGP) AS sessions\n"
	"Shorten the information on BGP instances\n"
	"Increase table width for longer output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_updgrps_cmd_vtysh,
	"show [ip] bgp l2vpn evpn update-groups [subgroup-id (1-1000)$subgrpid] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"l2vpn address family\n"
	"evpn sub-address family\n"
	"Detailed info about dynamic update groups\n"
	"Specific subgroup to display detailed info\n"
	"Subgroup identifier\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_vni_cmd_vtysh,
	"show bgp l2vpn evpn vni [(1-16777215)] [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Show VNI\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_l2vpn_evpn_vni_remote_ip_hash_cmd_vtysh,
	"show bgp l2vpn evpn vni remote-ip-hash",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Show VNI\n"
	"Remote IP hash\n")

DEFSH_HIDDEN (VTYSH_BGPD, show_bgp_l2vpn_evpn_vni_svi_hash_cmd_vtysh,
	"show bgp l2vpn evpn vni-svi-hash",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Show vni-svi-hash\n")

DEFSH (VTYSH_BGPD, show_bgp_l2vpn_evpn_vrf_import_rt_cmd_vtysh,
	"show bgp l2vpn evpn vrf-import-rt [json]",
	"Show running system information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Show vrf import route target\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_labelpool_chunks_cmd_vtysh,
	"show bgp labelpool chunks [json]",
	"Show running system information\n"
	"BGP information\n"
	"BGP Labelpool information\n"
	"BGP Labelpool chunks\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_labelpool_inuse_cmd_vtysh,
	"show bgp labelpool inuse [json]",
	"Show running system information\n"
	"BGP information\n"
	"BGP Labelpool information\n"
	"BGP Labelpool inuse\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_labelpool_ledger_cmd_vtysh,
	"show bgp labelpool ledger [json]",
	"Show running system information\n"
	"BGP information\n"
	"BGP Labelpool information\n"
	"BGP Labelpool ledger\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_labelpool_requests_cmd_vtysh,
	"show bgp labelpool requests [json]",
	"Show running system information\n"
	"BGP information\n"
	"BGP Labelpool information\n"
	"BGP Labelpool requests\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_labelpool_summary_cmd_vtysh,
	"show bgp labelpool summary [json]",
	"Show running system information\n"
	"BGP information\n"
	"BGP Labelpool information\n"
	"BGP Labelpool summary\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_lcommunity_list_arg_cmd_vtysh,
	"show bgp large-community-list <(1-500)|LCOMMUNITY_LIST_NAME> detail",
	"Show running system information\n"
	"BGP information\n"
	"List large-community list\n"
	"Large-community-list number\n"
	"Large-community-list name\n"
	"Detailed information on large-community-list\n")

DEFSH (VTYSH_BGPD, show_bgp_lcommunity_list_cmd_vtysh,
	"show bgp large-community-list",
	"Show running system information\n"
	"BGP information\n"
	"List large-community list\n")

DEFSH (VTYSH_BGPD, show_bgp_listeners_cmd_vtysh,
	"show bgp listeners",
	"Show running system information\n"
	"BGP information\n"
	"Display Listen Sockets and who created them\n")

DEFSH (VTYSH_BGPD, show_bgp_mac_hash_cmd_vtysh,
	"show bgp mac hash",
	"Show running system information\n"
	"BGP information\n"
	"Mac Address\n"
	"Mac Address database\n")

DEFSH (VTYSH_BGPD, show_bgp_martian_nexthop_db_cmd_vtysh,
	"show bgp [<view|vrf> VIEWVRFNAME] martian next-hop",
	"Show running system information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"martian next-hops\n"
	"martian next-hop database\n")

DEFSH (VTYSH_BGPD, show_bgp_memory_cmd_vtysh,
	"show [ip] bgp memory",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Global BGP memory statistics\n")

DEFSH (VTYSH_BGPD, show_bgp_mplsvpn_nh_label_bind_cmd_vtysh,
	"show bgp [<view|vrf> VIEWVRFNAME] mplsvpn-nh-label-bind [detail]",
	"Show running system information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"BGP mplsvpn nexthop label binding entries\n"
	"Show detailed information\n")

DEFSH (VTYSH_BGPD, show_bgp_nexthop_label_cmd_vtysh,
	"show bgp [<view|vrf> VIEWVRFNAME] label-nexthop [detail]",
	"Show running system information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"BGP label per-nexthop table\n"
	"Show detailed information\n")

DEFSH (VTYSH_BGPD, show_bgp_peerhash_cmd_vtysh,
	"show bgp peerhash",
	"Show running system information\n"
	"BGP information\n"
	"Display information about the BGP peerhash\n")

DEFSH (VTYSH_BGPD, show_bgp_router_cmd_vtysh,
	"show bgp router [json]",
	"Show running system information\n"
	"BGP information\n"
	"Overall BGP information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_srv6_cmd_vtysh,
	"show bgp segment-routing srv6",
	"Show running system information\n"
	"BGP information\n"
	"BGP Segment Routing\n"
	"BGP Segment Routing SRv6\n")

DEFSH (VTYSH_BGPD, show_bgp_updgrps_stats_cmd_vtysh,
	"show [ip] bgp update-groups statistics",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Detailed info about dynamic update groups\n"
	"Statistics\n")

DEFSH (VTYSH_BGPD, show_bgp_views_cmd_vtysh,
	"show [ip] bgp views",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Show the defined BGP views\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_all_cmd_vtysh,
	"show bgp vni all [vtep A.B.C.D$addr] [detail$detail] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"Print Detailed Output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_all_ead_cmd_vtysh,
	"show bgp vni all type <1|ead> [vtep A.B.C.D$addr] [<detail$detail|json$uj>]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"Print Detailed Output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_all_imet_cmd_vtysh,
	"show bgp vni all type <3|multicast> [vtep A.B.C.D$addr] [<detail$detail|json$uj>]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Specify Route type\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"Print Detailed Output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_all_macip_ip_cmd_vtysh,
	"show bgp vni all type <2|macip> ip [vtep A.B.C.D$addr] [<detail$detail|json$uj>]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"IP Table\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"Print Detailed Output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_all_macip_mac_cmd_vtysh,
	"show bgp vni all type <2|macip> mac [vtep A.B.C.D$addr] [<detail$detail|json$uj>]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"All VNIs\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC Table\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"Print Detailed Output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_cmd_vtysh,
	"show bgp vni (1-16777215)$vni [vtep A.B.C.D$addr] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_ead_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <1|ead> [vtep A.B.C.D$addr] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"EAD (Type-1) route\n"
	"EAD (Type-1) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_imet_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <3|multicast> [vtep A.B.C.D$addr] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"Multicast (Type-3) route\n"
	"Multicast (Type-3) route\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_macip_ip_addr_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <2|macip> ip <A.B.C.D|X:X::X:X> [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"IP Table\n"
	"IPv4 Address\n"
	"IPv6 Address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_macip_ip_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <2|macip> ip [vtep A.B.C.D$addr] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"IP Table\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_macip_mac_addr_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <2|macip> mac X:X:X:X:X:X [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC Table\n"
	"MAC address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vni_macip_mac_cmd_vtysh,
	"show bgp vni (1-16777215)$vni type <2|macip> mac [vtep A.B.C.D$addr] [json$uj]",
	"Show running system information\n"
	"BGP information\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Specify Route type\n"
	"MAC-IP (Type-2) route\n"
	"MAC-IP (Type-2) route\n"
	"MAC Table\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vrf_l3vni_info_cmd_vtysh,
	"show bgp vrf VRFNAME vni [json]",
	"Show running system information\n"
	"BGP information\n"
	"show bgp vrf\n"
	"VRF Name\n"
	"L3-VNI\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bgp_vrfs_cmd_vtysh,
	"show [ip] bgp vrfs [<VRFNAME$vrf_name>] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Show BGP VRFs\n"
	"Specific VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_bmp_cmd_vtysh,
	"show bmp",
	"Show running system information\n"
	"BGP Monitoring Protocol\n")

DEFSH (VTYSH_ISISD, show_database_cmd_vtysh,
	"show isis [vrf <NAME|all>] database [detail] [WORD] [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Link state database\n"
	"Detailed information\n"
	"LSP ID\n"
	"json output\n")

DEFSH (VTYSH_ZEBRA, show_dataplane_cmd_vtysh,
	"show zebra dplane [detailed]",
	"Show running system information\n"
	"Zebra information\n"
	"Zebra dataplane information\n"
	"Detailed output\n")

DEFSH (VTYSH_ZEBRA, show_dataplane_providers_cmd_vtysh,
	"show zebra dplane providers [detailed]",
	"Show running system information\n"
	"Zebra information\n"
	"Zebra dataplane information\n"
	"Zebra dataplane provider information\n"
	"Detailed output\n")

DEFSH (VTYSH_NHRPD, show_dmvpn_cmd_vtysh,
	"show dmvpn [json]",
	"Show running system information\n"
	"DMVPN information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_access_vlan_cmd_vtysh,
	"show evpn access-vlan [IFNAME$if_name (1-4094)$vid | detail$detail] [json$json]",
	"Show running system information\n"
	"EVPN\n"
	"Access VLANs\n"
	"Interface Name\n"
	"VLAN ID\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_es_cmd_vtysh,
	"show evpn es [NAME$esi_str|detail$detail] [json$json]",
	"Show running system information\n"
	"EVPN\n"
	"Ethernet Segment\n"
	"ES ID\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_es_evi_cmd_vtysh,
	"show evpn es-evi [vni (1-16777215)$vni] [detail$detail] [json$json]",
	"Show running system information\n"
	"EVPN\n"
	"Ethernet Segment per EVI\n"
	"VxLAN Network Identifier\n"
	"VNI\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_global_cmd_vtysh,
	"show evpn [json]",
	"Show running system information\n"
	"EVPN\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_l2_nh_cmd_vtysh,
	"show evpn l2-nh [json$json]",
	"Show running system information\n"
	"EVPN\n"
	"Layer2 nexthops\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_all_cmd_vtysh,
	"show evpn mac vni all [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_all_dad_cmd_vtysh,
	"show evpn mac vni all duplicate [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"Duplicate address list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_all_detail_cmd_vtysh,
	"show evpn mac vni all detail [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"Detailed Information On Each VNI MAC\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_all_vtep_cmd_vtysh,
	"show evpn mac vni all vtep A.B.C.D [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_cmd_vtysh,
	"show evpn mac vni (1-16777215)[json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_dad_cmd_vtysh,
	"show evpn mac vni (1-16777215) duplicate [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"Duplicate address list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_detail_cmd_vtysh,
	"show evpn mac vni (1-16777215) detail [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VXLAN Network Identifier\n"
	"VNI number\n"
	"Detailed Information On Each VNI MAC\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_mac_cmd_vtysh,
	"show evpn mac vni (1-16777215) mac WORD [json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"MAC\n"
	"MAC address (e.g., 00:e0:ec:20:12:62)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_mac_vni_vtep_cmd_vtysh,
	"show evpn mac vni (1-16777215) vtep A.B.C.D[json]",
	"Show running system information\n"
	"EVPN\n"
	"MAC addresses\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_all_cmd_vtysh,
	"show evpn arp-cache vni all [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_all_dad_cmd_vtysh,
	"show evpn arp-cache vni all duplicate [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"Duplicate address list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_all_detail_cmd_vtysh,
	"show evpn arp-cache vni all detail [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"All VNIs\n"
	"Neighbor details for all vnis in detail\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_cmd_vtysh,
	"show evpn arp-cache vni (1-16777215)[json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_dad_cmd_vtysh,
	"show evpn arp-cache vni (1-16777215)duplicate [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"Duplicate address list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_neigh_cmd_vtysh,
	"show evpn arp-cache vni (1-16777215) ip WORD [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"Neighbor\n"
	"Neighbor address (IPv4 or IPv6 address)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_neigh_vni_vtep_cmd_vtysh,
	"show evpn arp-cache vni (1-16777215) vtep A.B.C.D [json]",
	"Show running system information\n"
	"EVPN\n"
	"ARP and ND cache\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"Remote VTEP\n"
	"Remote VTEP IP address\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_evpn_nh_svd_cmd_vtysh,
	"show evpn next-hops svd [json]",
	"Show running system information\n"
	"EVPN\n"
	"Remote VTEPs\n"
	"Single Vxlan Device\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_evpn_nh_svd_ip_cmd_vtysh,
	"show evpn next-hops svd ip WORD [json]",
	"Show running system information\n"
	"EVPN\n"
	"Remote Vteps\n"
	"Single Vxlan Device\n"
	"Ip address\n"
	"Host address (ipv4 or ipv6)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_nh_vni_all_cmd_vtysh,
	"show evpn next-hops vni all [json]",
	"Show running system information\n"
	"EVPN\n"
	"Remote VTEPs\n"
	"L3 VNI\n"
	"All VNIs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_nh_vni_cmd_vtysh,
	"show evpn next-hops vni (1-16777215)[json]",
	"Show running system information\n"
	"EVPN\n"
	"Remote Vteps\n"
	"L3 VNI\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_nh_vni_ip_cmd_vtysh,
	"show evpn next-hops vni (1-16777215) ip WORD [json]",
	"Show running system information\n"
	"EVPN\n"
	"Remote Vteps\n"
	"L3 VNI\n"
	"VNI number\n"
	"Ip address\n"
	"Host address (ipv4 or ipv6)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_rmac_vni_all_cmd_vtysh,
	"show evpn rmac vni all [json]",
	"Show running system information\n"
	"EVPN\n"
	"RMAC addresses\n"
	"L3 VNI\n"
	"All VNIs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_rmac_vni_cmd_vtysh,
	"show evpn rmac vni (1-16777215)[json]",
	"Show running system information\n"
	"EVPN\n"
	"RMAC\n"
	"L3 VNI\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_rmac_vni_mac_cmd_vtysh,
	"show evpn rmac vni (1-16777215) mac WORD [json]",
	"Show running system information\n"
	"EVPN\n"
	"RMAC\n"
	"L3 VNI\n"
	"VNI number\n"
	"MAC\n"
	"mac-address (e.g. 0a:0a:0a:0a:0a:0a)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_vni_cmd_vtysh,
	"show evpn vni [json]",
	"Show running system information\n"
	"EVPN\n"
	"VxLAN Network Identifier\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_vni_detail_cmd_vtysh,
	"show evpn vni detail [json]",
	"Show running system information\n"
	"EVPN\n"
	"VxLAN Network Identifier\n"
	"Detailed Information On Each VNI\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_evpn_vni_vni_cmd_vtysh,
	"show evpn vni (1-16777215)[json]",
	"Show running system information\n"
	"EVPN\n"
	"VxLAN Network Identifier\n"
	"VNI number\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_frr_cmd_vtysh,
	"show frr",
	"Show running system information\n"
	"FRR\n")

DEFSH (VTYSH_ISISD, show_hostname_cmd_vtysh,
	"show isis [vrf <NAME|all>] hostname",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS Dynamic hostname mapping\n")

DEFSH (VTYSH_ZEBRA, show_interface_cmd_vtysh,
	"show interface vrf NAME$vrf_name [brief$brief] [json$uj]",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Interface status and configuration summary\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_interface_desc_cmd_vtysh,
	"show interface description vrf NAME",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Interface description\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_ZEBRA, show_interface_desc_vrf_all_cmd_vtysh,
	"show interface description [vrf all]",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Interface description\n"
	"Specify the VRF\n"
	"All VRFs\n")

DEFSH (VTYSH_ZEBRA, show_interface_name_vrf_all_cmd_vtysh,
	"show interface IFNAME$ifname [vrf all] [json$uj]",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Interface name\n"
	"Specify the VRF\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_interface_name_vrf_cmd_vtysh,
	"show interface IFNAME$ifname vrf NAME$vrf_name [json$uj]",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Interface name\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_interface_nexthop_group_cmd_vtysh,
	"show interface [IFNAME$if_name] nexthop-group",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Interface name\n"
	"Show Nexthop Groups\n")

DEFSH (VTYSH_ZEBRA, show_interface_vrf_all_cmd_vtysh,
	"show interface [vrf all] [brief$brief] [json$uj]",
	"Show running system information\n"
	"Interface status and configuration\n"
	"Specify the VRF\n"
	"All VRFs\n"
	"Interface status and configuration summary\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_as_path_access_list_all_cmd_vtysh,
	"show ip as-path-access-list [json]",
	"Show running system information\n"
	"IP information\n"
	"List AS path access lists\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_as_path_access_list_cmd_vtysh,
	"show ip as-path-access-list AS_PATH_FILTER_NAME [json]",
	"Show running system information\n"
	"IP information\n"
	"List AS path access lists\n"
	"AS path access list name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_afi_safi_statistics_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]]         statistics [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"BGP RIB advertisement statistics\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_attr_info_cmd_vtysh,
	"show [ip] bgp attribute-info [summary$summary]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"List all bgp attribute information\n"
	"Display summary of BGP attributes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]]          [all$all]          [cidr-only          |dampening <flap-statistics|dampened-paths>          |community [AA:NN|local-AS|no-advertise|no-export                     |graceful-shutdown|no-peer|blackhole|llgr-stale|no-llgr                     |accept-own|accept-own-nexthop|route-filter-v6                     |route-filter-v4|route-filter-translated-v6                     |route-filter-translated-v4] [exact-match]          |community-list <(1-500)|COMMUNITY_LIST_NAME> [exact-match]          |filter-list AS_PATH_FILTER_NAME          |prefix-list WORD          |access-list ACCESSLIST_NAME          |route-map RMAP_NAME          |rpki <invalid|valid|notfound>          |version (1-4294967295)          |alias ALIAS_NAME          |A.B.C.D/M longer-prefixes          |X:X::X:X/M longer-prefixes          |self-originate          |detail-routes$detail_routes [internal$internal]          ] [json$uj [detail$detail_json] | wide$wide]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display the entries for all address families\n"
	"Display only routes with non-natural netmasks\n"
	"Display detailed information about dampening\n"
	"Display flap statistics of routes\n"
	"Display paths suppressed due to dampening\n"
	"Display routes matching the communities\n"
	"Community number where AA and NN are (0-65535)\n"
	"Do not send outside local AS (well-known community)\n"
	"Do not advertise to any peer (well-known community)\n"
	"Do not export to next AS (well-known community)\n"
	"Graceful shutdown (well-known community)\n"
	"Do not export to any peer (well-known community)\n"
	"Inform EBGP peers to blackhole traffic to prefix (well-known community)\n"
	"Staled Long-lived Graceful Restart VPN route (well-known community)\n"
	"Removed because Long-lived Graceful Restart was not enabled for VPN route (well-known community)\n"
	"Should accept local VPN route if exported and imported into different VRF (well-known community)\n"
	"Should accept VPN route with local nexthop (well-known community)\n"
	"RT VPNv6 route filtering (well-known community)\n"
	"RT VPNv4 route filtering (well-known community)\n"
	"RT translated VPNv6 route filtering (well-known community)\n"
	"RT translated VPNv4 route filtering (well-known community)\n"
	"Exact match of the communities\n"
	"Community-list number\n"
	"Community-list name\n"
	"Display routes matching the community-list\n"
	"Exact match of the communities\n"
	"Display routes conforming to the filter-list\n"
	"Regular expression access list name\n"
	"Display routes conforming to the prefix-list\n"
	"Prefix-list name\n"
	"Display routes conforming to the access-list\n"
	"Access-list name\n"
	"Display routes matching the route-map\n"
	"A route-map to match on\n"
	"RPKI route types\n"
	"A valid path as determined by rpki\n"
	"A invalid path as determined by rpki\n"
	"A path that has no rpki data\n"
	"Display prefixes with matching version numbers\n"
	"Version number and above\n"
	"Display prefixes with matching BGP community alias\n"
	"BGP community alias\n"
	"IPv4 prefix\n"
	"Display route and more specific routes\n"
	"IPv6 prefix\n"
	"Display route and more specific routes\n"
	"Display only self-originated routes\n"
	"Display detailed version of all routes\n"
	"Display detailed version of all routes including internal data\n"
	"JavaScript Object Notation\n"
	"Display detailed version of JSON output\n"
	"Increase table width for longer prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_community_info_cmd_vtysh,
	"show [ip] bgp community-info",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"List all bgp community information\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_dampening_params_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] [all$all] dampening parameters [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display the entries for all address families\n"
	"Display detailed information about dampening\n"
	"Display detail of configured dampening parameters\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_evpn_rd_overlay_cmd_vtysh,
	"show [ip] bgp l2vpn evpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> overlay",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"Display BGP Overlay Information for prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_import_check_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME$vrf] import-check-table [detail$detail] [json$uj]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"BGP import check table\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_all_cmd_vtysh,
	"show [ip] bgp <view|vrf> all [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] [json$uj | wide$wide]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"All Views/VRFs\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"JavaScript Object Notation\n"
	"Increase table width for longer prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_all_nexthop_cmd_vtysh,
	"show [ip] bgp <view|vrf> all nexthop [<ipv4|ipv6>$afi] [detail$detail] [json$uj]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"All Views/VRFs\n"
	"BGP nexthop table\n"
	"BGP IPv4 nexthop table\n"
	"BGP IPv6 nexthop table\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_neighbor_advertised_route_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] [all$all] neighbors <A.B.C.D|X:X::X:X|WORD> <advertised-routes|received-routes|filtered-routes> [route-map RMAP_NAME$route_map] [<A.B.C.D/M|X:X::X:X/M>$prefix | detail$detail] [json$uj | wide$wide]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display the entries for all address families\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display the routes advertised to a BGP neighbor\n"
	"Display the received routes from neighbor\n"
	"Display the filtered routes received from neighbor\n"
	"Route-map to modify the attributes\n"
	"Name of the route map\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Display detailed version of routes\n"
	"JavaScript Object Notation\n"
	"Increase table width for longer prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_neighbor_bestpath_route_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] neighbors <A.B.C.D|X:X::X:X|WORD> bestpath-routes [detail$detail] [json$uj | wide$wide]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display the routes selected by best path\n"
	"Display detailed version of routes\n"
	"JavaScript Object Notation\n"
	"Increase table width for longer prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_neighbor_prefix_counts_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn>]] neighbors <A.B.C.D|X:X::X:X|WORD> prefix-counts [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display detailed prefix count information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_instance_updgrps_adj_s_cmd_vtysh,
	"show [ip]$ip bgp [<view|vrf> VIEWVRFNAME$vrf] [<ipv4|ipv6>$afi <unicast|multicast|vpn>$safi] update-groups [SUBGROUP-ID]$sgid <advertise-queue|advertised-routes|packet-queue>$rtq",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed info about dynamic update groups\n"
	"Specific subgroup to display info for\n"
	"Advertisement queue\n"
	"Announced routes\n"
	"Packet queue\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_all_overlay_cmd_vtysh,
	"show [ip] bgp l2vpn evpn all overlay [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information about all EVPN NLRIs\n"
	"Display BGP Overlay Information for prefixes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_all_tags_cmd_vtysh,
	"show [ip] bgp l2vpn evpn all tags",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information about all EVPN NLRIs\n"
	"Display BGP tags for prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_cmd_vtysh,
	"show [ip] bgp l2vpn evpn [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_neighbor_advertised_routes_cmd_vtysh,
	"show [ip] bgp l2vpn evpn neighbors <A.B.C.D|X:X::X:X|WORD> advertised-routes [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"IPv4 Neighbor to display information about\n"
	"IPv6 Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display the routes advertised to a BGP neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_neighbor_routes_cmd_vtysh,
	"show [ip] bgp l2vpn evpn neighbors <A.B.C.D|X:X::X:X|WORD> routes [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"IPv4 Neighbor to display information about\n"
	"IPv6 Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display routes learned from neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_rd_cmd_vtysh,
	"show [ip] bgp l2vpn evpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_rd_neighbor_advertised_routes_cmd_vtysh,
	"show [ip] bgp l2vpn evpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> neighbors <A.B.C.D|X:X::X:X|WORD> advertised-routes [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"IPv4 Neighbor to display information about\n"
	"IPv6 Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display the routes advertised to a BGP neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_rd_neighbor_routes_cmd_vtysh,
	"show [ip] bgp l2vpn evpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> neighbors <A.B.C.D|X:X::X:X|WORD> routes [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"IPv4 Neighbor to display information about\n"
	"IPv6 Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display routes learned from neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_rd_tags_cmd_vtysh,
	"show [ip] bgp l2vpn evpn rd <ASN:NN_OR_IP-ADDRESS:NN|all> tags",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"Display information for a route distinguisher\n"
	"VPN Route Distinguisher\n"
	"All VPN Route Distinguishers\n"
	"Display BGP tags for prefixes\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_l2vpn_evpn_statistics_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] l2vpn evpn statistics [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Layer 2 Virtual Private Network\n"
	"Ethernet Virtual Private Network\n"
	"BGP RIB advertisement statistics\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_large_community_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] large-community [<AA:BB:CC> [exact-match]] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display routes matching the large-communities\n"
	"List of large-community numbers\n"
	"Exact match of the large-communities\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_large_community_list_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] large-community-list <(1-500)|LCOMMUNITY_LIST_NAME> [exact-match] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display routes matching the large-community-list\n"
	"large-community-list number\n"
	"large-community-list name\n"
	"Exact match of the large-communities\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_lcommunity_info_cmd_vtysh,
	"show ip bgp large-community-info",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"List all bgp large-community information\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_neighbor_damp_param_cmd_vtysh,
	"show [ip] bgp [<ipv4|ipv6> [unicast]] neighbors <A.B.C.D|X:X::X:X|WORD>$neighbor dampening parameters [json]$json",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Specify neighbor router\n"
	"Neighbor address\n"
	"Neighbor IPv6 address\n"
	"Interface name or neighbor tag\n"
	"Neighbor route-flap dampening information\n"
	"Display detail of configured dampening parameters\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_neighbor_received_prefix_filter_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [unicast]] neighbors <A.B.C.D|X:X::X:X|WORD> received prefix-filter [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display information received from a BGP neighbor\n"
	"Display the prefixlist filter\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_neighbor_routes_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] neighbors <A.B.C.D|X:X::X:X|WORD> <flap-statistics|dampened-routes|routes> [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Display flap statistics of the routes learned from neighbor\n"
	"Display the dampened routes received from neighbor\n"
	"Display routes learned from neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_neighbors_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6>] neighbors [<A.B.C.D|X:X::X:X|WORD>] [graceful-restart] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Detailed information on TCP and BGP neighbor connections\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Neighbor graceful restart information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_nexthop_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME$vrf] nexthop [<A.B.C.D|X:X::X:X>$nhop] [<ipv4$afi [A.B.C.D$nhop]|ipv6$afi [X:X::X:X$nhop]>] [detail$detail] [json$uj]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"BGP nexthop table\n"
	"IPv4 nexthop address\n"
	"IPv6 nexthop address\n"
	"BGP nexthop IPv4 table\n"
	"IPv4 nexthop address\n"
	"BGP nexthop IPv6 table\n"
	"IPv6 nexthop address\n"
	"Show detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_paths_cmd_vtysh,
	"show [ip] bgp [<unicast|multicast|vpn>] paths",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Path information\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_peer_groups_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] peer-group [PGNAME] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Detailed information on BGP peer groups\n"
	"Peer group name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_regexp_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] regexp REGEX [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display routes matching the AS path regular expression\n"
	"A regular-expression (1234567890_^|[,{}() ]$*+.?-\\) to match the BGP AS paths\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_route_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]]<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M> [internal] [<bestpath|multipath>] [rpki <valid|invalid|notfound>] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Network in the BGP routing table to display\n"
	"IPv4 prefix\n"
	"Network in the BGP routing table to display\n"
	"IPv6 prefix\n"
	"Display internal data additionally\n"
	"Display only the bestpath\n"
	"Display only multipaths\n"
	"Display only paths that match the specified rpki state\n"
	"A valid path as determined by rpki\n"
	"A invalid path as determined by rpki\n"
	"A path that has no rpki data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_route_leak_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn>]] route-leak  [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Route leaking information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_statistics_all_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] statistics-all [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Display number of prefixes for all afi/safi\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_summary_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] [all$all] summary [established|failed] [<neighbor <A.B.C.D|X:X::X:X|WORD>|remote-as <ASNUM|internal|external>>] [terse] [wide] [json$uj]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Display the entries for all address families\n"
	"Summary of BGP neighbor status\n"
	"Show only sessions in Established state\n"
	"Show only sessions not in Established state\n"
	"Show only the specified neighbor session\n"
	"Neighbor to display information about\n"
	"Neighbor to display information about\n"
	"Neighbor on BGP configured interface\n"
	"Show only the specified remote AS sessions\n"
	"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format\n"
	"Internal (iBGP) AS sessions\n"
	"External (eBGP) AS sessions\n"
	"Shorten the information on BGP instances\n"
	"Increase table width for longer output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_updgrps_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] update-groups [SUBGROUP-ID] [json]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed info about dynamic update groups\n"
	"Specific subgroup to display detailed info for\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_ip_bgp_vrf_afi_safi_routes_detailed_cmd_vtysh,
	"show [ip] bgp [<view|vrf> VIEWVRFNAME$vrf_name] [<ipv4|ipv6> [<unicast|multicast|vpn|labeled-unicast|flowspec>]] detail [json$uj]",
	"Show running system information\n"
	"IP information\n"
	"BGP information\n"
	"BGP view\n"
	"BGP VRF\n"
	"View/VRF name\n"
	"Address Family\n"
	"Address Family\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Address Family modifier\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_EIGRPD, show_ip_eigrp_interfaces_cmd_vtysh,
	"show ip eigrp [vrf NAME] interfaces [IFNAME] [detail]$detail",
	"Show running system information\n"
	"IP information\n"
	"IP-EIGRP show commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IP-EIGRP interfaces\n"
	"Interface name to look at\n"
	"Detailed information\n")

DEFSH (VTYSH_EIGRPD, show_ip_eigrp_neighbors_cmd_vtysh,
	"show ip eigrp [vrf NAME] neighbors [IFNAME] [detail]$detail",
	"Show running system information\n"
	"IP information\n"
	"IP-EIGRP show commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IP-EIGRP neighbors\n"
	"Interface to show on\n"
	"Detailed Information\n")

DEFSH (VTYSH_EIGRPD, show_ip_eigrp_topology_all_cmd_vtysh,
	"show ip eigrp [vrf NAME] topology [all-links$all]",
	"Show running system information\n"
	"IP information\n"
	"IP-EIGRP show commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IP-EIGRP topology\n"
	"Show all links in topology table\n")

DEFSH (VTYSH_EIGRPD, show_ip_eigrp_topology_cmd_vtysh,
	"show ip eigrp [vrf NAME] topology <A.B.C.D$address|A.B.C.D/M$prefix>",
	"Show running system information\n"
	"IP information\n"
	"IP-EIGRP show commands\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IP-EIGRP topology\n"
	"For a specific address\n"
	"For a specific prefix\n")

DEFSH (VTYSH_ZEBRA, show_ip_forwarding_cmd_vtysh,
	"show ip forwarding",
	"Show running system information\n"
	"IP information\n"
	"IP forwarding status\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_groups_cmd_vtysh,
	"show ip igmp [vrf NAME$vrf_name] groups [INTERFACE$ifname [GROUP$grp_str]] [detail$detail] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP groups information\n"
	"Interface name\n"
	"Group address\n"
	"Detailed Information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_groups_retransmissions_cmd_vtysh,
	"show ip igmp [vrf NAME] groups retransmissions",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP groups information\n"
	"IGMP group retransmissions\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_groups_vrf_all_cmd_vtysh,
	"show ip igmp vrf all groups [GROUP$grp_str] [detail$detail] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP groups information\n"
	"Group address\n"
	"Detailed Information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_interface_cmd_vtysh,
	"show ip igmp [vrf NAME] interface [detail|WORD] [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_interface_vrf_all_cmd_vtysh,
	"show ip igmp vrf all interface [detail|WORD] [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_join_cmd_vtysh,
	"show ip igmp [vrf NAME] join [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP static join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_join_group_cmd_vtysh,
	"show ip igmp [vrf NAME] join-group [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP static join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_join_group_vrf_all_cmd_vtysh,
	"show ip igmp vrf all join-group [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP static join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_join_vrf_all_cmd_vtysh,
	"show ip igmp vrf all join [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP static join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_proxy_cmd_vtysh,
	"show ip igmp [vrf NAME] proxy [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP proxy join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_proxy_vrf_all_cmd_vtysh,
	"show ip igmp vrf all proxy [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP proxy join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_sources_cmd_vtysh,
	"show ip igmp [vrf NAME$vrf_name] sources [INTERFACE$ifname [GROUP$grp_str]] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP sources information\n"
	"Interface name\n"
	"Group address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_sources_retransmissions_cmd_vtysh,
	"show ip igmp [vrf NAME] sources retransmissions",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP sources information\n"
	"IGMP source retransmissions\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_static_group_cmd_vtysh,
	"show ip igmp [vrf NAME] static-group [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Static group information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_static_group_vrf_all_cmd_vtysh,
	"show ip igmp vrf all static-group [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Static group information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_igmp_statistics_cmd_vtysh,
	"show ip igmp [vrf NAME] statistics [interface WORD] [json]",
	"Show running system information\n"
	"IP information\n"
	"IGMP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IGMP statistics\n"
	"interface\n"
	"IGMP interface\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_cmd_vtysh,
	"show ip mroute [vrf NAME] [A.B.C.D$s_or_g [A.B.C.D$g]] [fill$fill] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"The Source or Group\n"
	"The Group\n"
	"Fill in Assumed data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_count_cmd_vtysh,
	"show ip mroute [vrf NAME] count [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_count_vrf_all_cmd_vtysh,
	"show ip mroute vrf all count [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_summary_cmd_vtysh,
	"show ip mroute [vrf NAME] summary [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Summary of all mroutes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_summary_vrf_all_cmd_vtysh,
	"show ip mroute vrf all summary [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Summary of all mroutes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_mroute_vrf_all_cmd_vtysh,
	"show ip mroute vrf all [fill$fill] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Fill in Assumed data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_mesh_group_cmd_vtysh,
	"show ip msdp [vrf NAME] mesh-group [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP mesh-group information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_mesh_group_vrf_all_cmd_vtysh,
	"show ip msdp vrf all mesh-group [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP mesh-group information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_peer_detail_cmd_vtysh,
	"show ip msdp [vrf NAME] peer [detail|A.B.C.D] [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP peer information\n"
	"Detailed output\n"
	"peer ip address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_peer_detail_vrf_all_cmd_vtysh,
	"show ip msdp vrf all peer [detail|A.B.C.D] [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP peer information\n"
	"Detailed output\n"
	"peer ip address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_sa_detail_cmd_vtysh,
	"show ip msdp [vrf NAME] sa detail [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP active-source information\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_sa_detail_vrf_all_cmd_vtysh,
	"show ip msdp vrf all sa detail [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP active-source information\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_sa_sg_cmd_vtysh,
	"show ip msdp [vrf NAME] sa [A.B.C.D [A.B.C.D]] [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP active-source information\n"
	"source or group ip\n"
	"group ip\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_msdp_sa_sg_vrf_all_cmd_vtysh,
	"show ip msdp vrf all sa [A.B.C.D [A.B.C.D]] [json]",
	"Show running system information\n"
	"IP information\n"
	"MSDP information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MSDP active-source information\n"
	"source or group ip\n"
	"group ip\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_multicast_cmd_vtysh,
	"show ip multicast [vrf NAME]",
	"Show running system information\n"
	"IP information\n"
	"Multicast global information\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIMD, show_ip_multicast_count_cmd_vtysh,
	"show ip multicast count [vrf NAME] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"Multicast global information\n"
	"Data packet count\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_multicast_count_vrf_all_cmd_vtysh,
	"show ip multicast count vrf all [json$json]",
	"Show running system information\n"
	"IP information\n"
	"Multicast global information\n"
	"Data packet count\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_multicast_vrf_all_cmd_vtysh,
	"show ip multicast vrf all",
	"Show running system information\n"
	"IP information\n"
	"Multicast global information\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_NHRPD, show_ip_nhrp_cmd_vtysh,
	"show <ip|ipv6> nhrp [cache|nhs|shortcut|opennhrp] [json]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 information\n"
	"NHRP information\n"
	"Forwarding cache information\n"
	"Next hop server information\n"
	"Shortcut information\n"
	"opennhrpctl style cache dump\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_ip_nht_cmd_vtysh,
	"show <ip$ipv4|ipv6$ipv6> <nht|import-check>$type [<A.B.C.D|X:X::X:X>$addr|vrf NAME$vrf_name [<A.B.C.D|X:X::X:X>$addr]|vrf all$vrf_all] [mrib$mrib] [json]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 Information\n"
	"IP nexthop tracking table\n"
	"IP import check tracking table\n"
	"IPv4 Address\n"
	"IPv6 Address\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IPv4 Address\n"
	"IPv6 Address\n"
	"Specify the VRF\n"
	"All VRFs\n"
	"Show Multicast (MRIB) NHT state\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_border_routers_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] border-routers [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show all the ABR's and ASBR's\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_database_cmd_vtysh,
	"show ip ospf [(1-65535)$instance_id] [vrf <NAME|all>$vrf_name] database         [<	   max-age$maxage	   |self-originate$selforig	   |<	     detail$detail             |<asbr-summary|external|network|router|summary|nssa-external|opaque-link|opaque-area|opaque-as>$type_name	    >	    [{	      A.B.C.D$lsid	      |<adv-router A.B.C.D$adv_router|self-originate$adv_router_self>	    }]	 >]	 [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Database summary\n"
	"LSAs in MaxAge list\n"
	"Self-originated link states\n"
	"Show detailed information\n"
	"ASBR summary link states\n"
	"External link states\n"
	"Network link states\n"
	"Router link states\n"
	"Network summary link states\n"
	"NSSA external link state\n"
	"Link local Opaque-LSA\n"
	"Link area Opaque-LSA\n"
	"Link AS Opaque-LSA\n"
	"Link State ID (as an IP address)\n"
	"Advertising Router link states\n"
	"Advertising Router (as an IP address)\n"
	"Self-originated link states\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_external_aggregator_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] summary-address [detail] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show external summary addresses\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_gr_helper_cmd_vtysh,
	"show ip ospf [{(1-65535)$instance|vrf <NAME|all>}] graceful-restart helper [detail] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"OSPF Graceful Restart\n"
	"Helper details in the router\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_border_routers_cmd_vtysh,
	"show ip ospf (1-65535) border-routers",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Show all the ABR's and ASBR's\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_cmd_vtysh,
	"show ip ospf (1-65535) [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_interface_cmd_vtysh,
	"show ip ospf (1-65535) interface [INTERFACE] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Interface information\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_all_cmd_vtysh,
	"show ip ospf (1-65535) neighbor all [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"include down status neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_cmd_vtysh,
	"show ip ospf (1-65535) neighbor [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_detail_all_cmd_vtysh,
	"show ip ospf (1-65535) neighbor detail all [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"detail of all neighbors\n"
	"include down status neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_detail_cmd_vtysh,
	"show ip ospf (1-65535) neighbor detail [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"detail of all neighbors\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_id_cmd_vtysh,
	"show ip ospf (1-65535)$instance neighbor A.B.C.D$router_id [detail$detail] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"Neighbor ID\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_int_cmd_vtysh,
	"show ip ospf (1-65535)$instance neighbor IFNAME$ifname [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_neighbor_int_detail_cmd_vtysh,
	"show ip ospf (1-65535)$instance neighbor IFNAME$ifname detail [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Neighbor list\n"
	"Interface name\n"
	"detail of all neighbors\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_reachable_routers_cmd_vtysh,
	"show ip ospf (1-65535) reachable-routers",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"Show all the reachable OSPF routers\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_instance_route_cmd_vtysh,
	"show ip ospf (1-65535) route [detail]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Instance ID\n"
	"OSPF routing table\n"
	"Detailed information\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_interface_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] interface [INTERFACE] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_interface_traffic_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] interface traffic [INTERFACE] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Protocol Packet counters\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_mpls_ldp_interface_cmd_vtysh,
	"show ip ospf mpls ldp-sync [interface <INTERFACE|all>] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"MPLS information\n"
	"LDP-IGP Sync information\n"
	"Interface information\n"
	"Interface name\n"
	"All interfaces\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_mpls_te_db_cmd_vtysh,
	"show ip ospf mpls-te database [<vertex [<self-originate|adv-router A.B.C.D>]|edge [A.B.C.D]|subnet [A.B.C.D/M]>] [verbose|json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"MPLS-TE information\n"
	"MPLS-TE database\n"
	"MPLS-TE Vertex\n"
	"Self-originated MPLS-TE router\n"
	"Advertised MPLS-TE router\n"
	"MPLS-TE router ID (as an IP address)\n"
	"MPLS-TE Edge\n"
	"MPLS-TE Edge ID (as an IP address)\n"
	"MPLS-TE Subnet\n"
	"MPLS-TE Subnet ID (as an IP prefix)\n"
	"Verbose output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_mpls_te_link_cmd_vtysh,
	"show ip ospf mpls-te interface [INTERFACE]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"MPLS-TE information\n"
	"Interface information\n"
	"Interface name\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_mpls_te_router_cmd_vtysh,
	"show ip ospf mpls-te router",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"MPLS-TE information\n"
	"MPLS-TE Router parameters\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_all_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] neighbor all [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"include down status neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] neighbor [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_detail_all_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] neighbor detail all [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"detail of all neighbors\n"
	"include down status neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_detail_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>$vrf_name] neighbor detail [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"detail of all neighbors\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_id_cmd_vtysh,
	"show ip ospf [vrf NAME$vrf_name] neighbor A.B.C.D$router_id [detail$detail] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Neighbor list\n"
	"Neighbor ID\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_int_cmd_vtysh,
	"show ip ospf [vrf NAME$vrf_name] neighbor IFNAME$ifname [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Neighbor list\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_neighbor_int_detail_cmd_vtysh,
	"show ip ospf [vrf NAME$vrf_name] neighbor IFNAME$ifname detail [json$json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Neighbor list\n"
	"Interface name\n"
	"detail of all neighbors\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_reachable_routers_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] reachable-routers",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show all the reachable OSPF routers\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_route_cmd_vtysh,
	"show ip ospf [vrf <NAME|all>] route [detail] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"OSPF routing table\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_router_info_cmd_vtysh,
	"show ip ospf router-info",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Router Information\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_router_info_pce_cmd_vtysh,
	"show ip ospf router-info pce",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Router Information\n"
	"PCE information\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_srdb_cmd_vtysh,
	"show ip ospf database segment-routing [adv-router A.B.C.D|self-originate] [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Database summary\n"
	"Show Segment Routing Data Base\n"
	"Advertising SR node\n"
	"Advertising SR node ID (as an IP address)\n"
	"Self-originated SR node\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPFD, show_ip_ospf_vrfs_cmd_vtysh,
	"show ip ospf vrfs [json]",
	"Show running system information\n"
	"IP information\n"
	"OSPF information\n"
	"Show OSPF VRFs \n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_assert_cmd_vtysh,
	"show ip pim [vrf NAME] assert",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface assert\n")

DEFSH (VTYSH_PIMD, show_ip_pim_assert_internal_cmd_vtysh,
	"show ip pim [vrf NAME] assert-internal",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface internal assert state\n")

DEFSH (VTYSH_PIMD, show_ip_pim_assert_metric_cmd_vtysh,
	"show ip pim [vrf NAME] assert-metric",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface assert metric\n")

DEFSH (VTYSH_PIMD, show_ip_pim_assert_winner_metric_cmd_vtysh,
	"show ip pim [vrf NAME] assert-winner-metric",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface assert winner metric\n")

DEFSH (VTYSH_PIMD, show_ip_pim_autorp_cmd_vtysh,
	"show ip pim [vrf <NAME|all>] autorp [discovery|candidate|mapping-agent]$component [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRF's\n"
	"PIM AutoRP information\n"
	"RP Discovery details\n"
	"Candidate RP details\n"
	"Mapping Agent details\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsm_db_cmd_vtysh,
	"show ip pim bsm-database [vrf NAME] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"PIM cached bsm packets information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_cand_bsr_cmd_vtysh,
	"show ip pim bsr candidate-bsr [vrf NAME$vrfname] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Current PIM router candidate BSR state\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_cand_rp_cmd_vtysh,
	"show ip pim bsr candidate-rp [vrf NAME$vrfname] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Current PIM router candidate RP state\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_cmd_vtysh,
	"show ip pim bsr [vrf NAME] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"boot-strap router information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_groups_cmd_vtysh,
	"show ip pim bsr groups [vrf NAME$vrfname] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"boot-strap router information\n"
	"Candidate RP groups\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_rpdb_cmd_vtysh,
	"show ip pim bsr candidate-rp-database [vrf NAME$vrfname] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Candidate RPs database on this router (if it is the BSR)\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_bsr_rpinfo_cmd_vtysh,
	"show ip pim bsr rp-info [vrf NAME] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"PIM cached group-rp mappings information received from BSR\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_PIMD, show_ip_pim_bsrp_cmd_vtysh,
	"show ip pim bsrp-info [vrf NAME] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"PIM cached group-rp mappings information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_channel_cmd_vtysh,
	"show ip pim [vrf NAME] channel [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM downstream channel info\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_group_type_cmd_vtysh,
	"show ip pim [vrf NAME] group-type A.B.C.D [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"multicast group type\n"
	"group address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_interface_cmd_vtysh,
	"show ip pim [mlag$mlag] [vrf NAME] interface [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"MLAG\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_interface_traffic_cmd_vtysh,
	"show ip pim [vrf NAME] interface traffic [WORD$if_name] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Protocol Packet counters\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_interface_vrf_all_cmd_vtysh,
	"show ip pim [mlag$mlag] vrf all interface [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"MLAG\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_join_cmd_vtysh,
	"show ip pim [vrf NAME] join [A.B.C.D$s_or_g [A.B.C.D$g]] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface join information\n"
	"The Source or Group\n"
	"The Group\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_join_vrf_all_cmd_vtysh,
	"show ip pim vrf all join [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_jp_agg_cmd_vtysh,
	"show ip pim [vrf NAME] jp-agg",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"join prune aggregation list\n")

DEFSH (VTYSH_PIMD, show_ip_pim_local_membership_cmd_vtysh,
	"show ip pim [vrf NAME] local-membership [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface local-membership\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_mlag_summary_cmd_vtysh,
	"show ip pim mlag summary [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"MLAG\n"
	"status and stats\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_mlag_up_cmd_vtysh,
	"show ip pim [vrf NAME] mlag upstream [A.B.C.D [A.B.C.D]] [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MLAG\n"
	"upstream\n"
	"Unicast or Multicast address\n"
	"Multicast address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_mlag_up_vrf_all_cmd_vtysh,
	"show ip pim vrf all mlag upstream [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"MLAG\n"
	"upstream\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_neighbor_cmd_vtysh,
	"show ip pim [vrf NAME] neighbor [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor information\n"
	"Detailed output\n"
	"Name of interface or neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_neighbor_vrf_all_cmd_vtysh,
	"show ip pim vrf all neighbor [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor information\n"
	"Detailed output\n"
	"Name of interface or neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_nexthop_cmd_vtysh,
	"show ip pim [vrf NAME] nexthop [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached nexthop rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_nexthop_lookup_cmd_vtysh,
	"show ip pim [vrf NAME] nexthop-lookup A.B.C.D$source [A.B.C.D$group]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached nexthop rpf lookup\n"
	"Source/RP address\n"
	"Multicast Group address\n")

DEFSH (VTYSH_PIMD, show_ip_pim_rp_cmd_vtysh,
	"show ip pim [vrf NAME] rp-info [A.B.C.D/M$group] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM RP information\n"
	"Multicast Group range\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_rp_vrf_all_cmd_vtysh,
	"show ip pim vrf all rp-info [A.B.C.D/M$group] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM RP information\n"
	"Multicast Group range\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_rpf_cmd_vtysh,
	"show ip pim [vrf NAME] rpf [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached source rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_rpf_vrf_all_cmd_vtysh,
	"show ip pim vrf all rpf [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached source rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_secondary_cmd_vtysh,
	"show ip pim [vrf NAME] secondary",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor addresses\n")

DEFSH (VTYSH_PIMD, show_ip_pim_ssm_range_cmd_vtysh,
	"show ip pim [vrf NAME] group-type [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM group type\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_state_cmd_vtysh,
	"show ip pim [vrf NAME] state [A.B.C.D$s_or_g [A.B.C.D$g]] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM state information\n"
	"Unicast or Multicast address\n"
	"Multicast address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_state_vrf_all_cmd_vtysh,
	"show ip pim vrf all state [A.B.C.D$s_or_g [A.B.C.D$g]] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM state information\n"
	"Unicast or Multicast address\n"
	"Multicast address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_statistics_cmd_vtysh,
	"show ip pim [vrf NAME] statistics [interface WORD$word] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM statistics\n"
	"Interface information\n"
	"PIM interface\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_upstream_cmd_vtysh,
	"show ip pim [vrf NAME] upstream [A.B.C.D$s_or_g [A.B.C.D$g]] [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream information\n"
	"The Source or Group\n"
	"The Group\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_upstream_join_desired_cmd_vtysh,
	"show ip pim [vrf NAME] upstream-join-desired [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream join-desired\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_upstream_rpf_cmd_vtysh,
	"show ip pim [vrf NAME] upstream-rpf [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream source rpf\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_upstream_vrf_all_cmd_vtysh,
	"show ip pim vrf all upstream [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_pim_vxlan_sg_cmd_vtysh,
	"show ip pim [vrf NAME] vxlan-groups [A.B.C.D [A.B.C.D]] [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"VxLAN BUM groups\n"
	"source or group ip\n"
	"group ip\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_PIMD, show_ip_pim_vxlan_sg_work_cmd_vtysh,
	"show ip pim [vrf NAME] vxlan-work [json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"VxLAN work list\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BABELD|VTYSH_BGPD|VTYSH_EIGRPD|VTYSH_FABRICD|VTYSH_ISISD|VTYSH_OSPFD|VTYSH_PIMD|VTYSH_RIPD|VTYSH_ZEBRA, show_ip_prefix_list_prefix_cmd_vtysh,
	"show ip prefix-list PREFIXLIST4_NAME$name A.B.C.D/M$prefix [longer$dl|first-match$dfm]",
	"Show running system information\n"
	"IP information\n"
	"Build a prefix list\n"
	"Name of a prefix list\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n"
	"Lookup longer prefix\n"
	"First matched prefix\n")

DEFSH (VTYSH_ZEBRA, show_ip_protocol_cmd_vtysh,
	"show ip protocol [vrf <NAME$vrf_name|all$vrf_all>]",
	"Show running system information\n"
	"IP information\n"
	"IP protocol filtering status\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n")

DEFSH (VTYSH_ZEBRA, show_ip_protocol_nht_cmd_vtysh,
	"show ip nht route-map [vrf <NAME$vrf_name|all$vrf_all>] [json]",
	"Show running system information\n"
	"IP information\n"
	"IPv4 nexthop tracking table\n"
	"IPv4 Next Hop tracking filtering status\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIMD, show_ip_rib_cmd_vtysh,
	"show ip rib [vrf NAME] A.B.C.D",
	"Show running system information\n"
	"IP information\n"
	"IP unicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Unicast address\n")

DEFSH (VTYSH_RIPD, show_ip_rip_cmd_vtysh,
	"show ip rip [vrf NAME]",
	"Show running system information\n"
	"IP information\n"
	"Show RIP routes\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_RIPD, show_ip_rip_status_cmd_vtysh,
	"show ip rip [vrf NAME] status",
	"Show running system information\n"
	"IP information\n"
	"Show RIP routes\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IP routing protocol process parameters and statistics\n")

DEFSH (VTYSH_ZEBRA, show_ip_router_id_cmd_vtysh,
	"show [ip|ipv6] router-id [vrf NAME]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 information\n"
	"Show the configured router-id\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_ip_rpf_cmd_vtysh,
	"show <ip$ipv4|ipv6$ipv6> rpf$mrib [json$json]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 information\n"
	"Display RPF information for multicast source\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_PIMD, show_ip_rpf_source_cmd_vtysh,
	"show ip rpf A.B.C.D$source",
	"Show running system information\n"
	"IP information\n"
	"Display RPF information for multicast source\n"
	"Nexthop lookup for specific source address\n")

DEFSH (VTYSH_PIMD, show_ip_ssmpingd_cmd_vtysh,
	"show ip ssmpingd [vrf NAME]",
	"Show running system information\n"
	"IP information\n"
	"ssmpingd operation\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_ZEBRA, show_ipv6_forwarding_cmd_vtysh,
	"show ipv6 forwarding",
	"Show running system information\n"
	"IPv6 information\n"
	"Forwarding status\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_cmd_vtysh,
	"show ipv6 mroute [vrf NAME] [X:X::X:X$s_or_g [X:X::X:X$g]] [fill$fill] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"The Source or Group\n"
	"The Group\n"
	"Fill in Assumed data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_count_cmd_vtysh,
	"show ipv6 mroute [vrf NAME] count [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_count_vrf_all_cmd_vtysh,
	"show ipv6 mroute vrf all count [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Route and packet count data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_summary_cmd_vtysh,
	"show ipv6 mroute [vrf NAME] summary [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Summary of all mroutes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_summary_vrf_all_cmd_vtysh,
	"show ipv6 mroute vrf all summary [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Summary of all mroutes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_mroute_vrf_all_cmd_vtysh,
	"show ipv6 mroute vrf all [fill$fill] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"IP multicast routing table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"Fill in Assumed data\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_multicast_cmd_vtysh,
	"show ipv6 multicast [vrf NAME]",
	"Show running system information\n"
	"IPv6 information\n"
	"Multicast global information\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_PIM6D, show_ipv6_multicast_count_cmd_vtysh,
	"show ipv6 multicast count [vrf NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Multicast global information\n"
	"Data packet count\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_multicast_count_vrf_all_cmd_vtysh,
	"show ipv6 multicast count vrf all [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Multicast global information\n"
	"Data packet count\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_multicast_vrf_all_cmd_vtysh,
	"show ipv6 multicast vrf all",
	"Show running system information\n"
	"IPv6 information\n"
	"Multicast global information\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_ZEBRA, show_ipv6_nd_ra_if_cmd_vtysh,
	"show ipv6 nd ra-interfaces [vrf<NAME$vrf_name|all$vrf_all>]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Neighbor discovery\n"
	"Route Advertisement Interfaces\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_area_spf_tree_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] area A.B.C.D spf tree",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Area information\n"
	"Area ID (as an IPv4 notation)\n"
	"Shortest Path First calculation\n"
	"Show SPF tree\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_border_routers_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] border-routers [<A.B.C.D|detail>]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display routing table for ABR and ASBR\n"
	"Router ID\n"
	"Show detailed output\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_adv_router_linkstate_id_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database adv-router A.B.C.D linkstate-id A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Search by Advertising Router\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Search by Link state ID\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_OSPF6D, show_ipv6_ospf6_database_aggr_router_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database aggr adv-router A.B.C.D",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Aggregated Router LSA\n"
	"Search by Advertising Router\n"
	"Specify Advertising Router as IPv4 address notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_id_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <*|linkstate-id> A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Any Link state Type\n"
	"Search by Link state ID\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_id_router_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database * A.B.C.D A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Any Link state Type\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_router_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <*|adv-router> * A.B.C.D <detail|dump|internal> [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Any Link state Type\n"
	"Search by Advertising Router\n"
	"Any Link state ID\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_self_originated_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database self-originated [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Self-originated LSAs\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_adv_router_linkstate_id_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> adv-router A.B.C.D linkstate-id A.B.C.D [<dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Search by Advertising Router\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Search by Link state ID\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_id_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> linkstate-id A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Search by Link state ID\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_id_router_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> A.B.C.D A.B.C.D [<dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_id_self_originated_cmd_vtysh,
	"show ipv6 ospf6  [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> A.B.C.D self-originated [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Display Self-originated LSAs\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_router_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> <*|adv-router> A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Any Link state ID\n"
	"Search by Advertising Router\n"
	"Specify Advertising Router as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_self_originated_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> self-originated [<detail|dump|internal>]  [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Display Self-originated LSAs\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_database_type_self_originated_linkstate_id_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] database <router|network|inter-prefix|inter-router|as-external|group-membership|type-7|link|intra-prefix> self-originated linkstate-id A.B.C.D [<detail|dump|internal>] [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display Link state database\n"
	"Display Router LSAs\n"
	"Display Network LSAs\n"
	"Display Inter-Area-Prefix LSAs\n"
	"Display Inter-Area-Router LSAs\n"
	"Display As-External LSAs\n"
	"Display Group-Membership LSAs\n"
	"Display Type-7 LSAs\n"
	"Display Link LSAs\n"
	"Display Intra-Area-Prefix LSAs\n"
	"Display Self-originated LSAs\n"
	"Search by Link state ID\n"
	"Specify Link state ID as IPv4 address notation\n"
	"Display details of LSAs\n"
	"Dump LSAs\n"
	"Display LSA's internal information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_external_aggregator_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] summary-address [detail$detail] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show external summary addresses\n"
	"detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_gr_helper_cmd_vtysh,
	"show ipv6 ospf6 graceful-restart helper [detail] [json]",
	"Show running system information\n"
	"Ipv6 Information\n"
	"OSPF6 information\n"
	"ospf6 graceful restart\n"
	"helper details in the router\n"
	"detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_interface_ifname_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] interface [IFNAME] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Interface name(e.g. ep0)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_interface_ifname_prefix_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] interface IFNAME prefix [<detail|<X:X::X:X|X:X::X:X/M> [<match|detail>]>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Interface name(e.g. ep0)\n"
	"Display connected prefixes to advertise\n"
	"Display details of the prefixes\n"
	"Display the route bestmatches the address\n"
	"Display the route\n"
	"Display the route matches the prefix\n"
	"Display details of the prefixes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_interface_prefix_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] interface prefix [<detail|<X:X::X:X|X:X::X:X/M> [<match|detail>]>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Display connected prefixes to advertise\n"
	"Display details of the prefixes\n"
	"Display the route bestmatches the address\n"
	"Display the route\n"
	"Display the route matches the prefix\n"
	"Display details of the prefixes\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_interface_traffic_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] interface traffic [IFNAME] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Interface information\n"
	"Protocol Packet counters\n"
	"Interface name(e.g. ep0)\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_linkstate_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] linkstate <router A.B.C.D|network A.B.C.D A.B.C.D>",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display linkstate routing table\n"
	"Display Router Entry\n"
	"Specify Router ID as IPv4 address notation\n"
	"Display Network Entry\n"
	"Specify Router ID as IPv4 address notation\n"
	"Specify Link state ID as IPv4 address notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_linkstate_detail_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] linkstate detail",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Display linkstate routing table\n"
	"Display detailed information\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_neighbor_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] neighbor [<detail|drchoice>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"Display details\n"
	"Display DR choices\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_neighbor_one_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] neighbor A.B.C.D [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Neighbor list\n"
	"Specify Router-ID as IPv4 address notation\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_redistribute_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] redistribute [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"redistributing External information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_route_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] route [<intra-area|inter-area|external-1|external-2|X:X::X:X|X:X::X:X/M|detail|summary>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Routing Table\n"
	"Display Intra-Area routes\n"
	"Display Inter-Area routes\n"
	"Display Type-1 External routes\n"
	"Display Type-2 External routes\n"
	"Specify IPv6 address\n"
	"Specify IPv6 prefix\n"
	"Detailed information\n"
	"Summary of route table\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_route_match_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] route X:X::X:X/M <match|longer> [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Routing Table\n"
	"Specify IPv6 prefix\n"
	"Display routes which match the specified route\n"
	"Display routes longer than the specified route\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_route_match_detail_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] route X:X::X:X/M match detail [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Routing Table\n"
	"Specify IPv6 prefix\n"
	"Display routes which match the specified route\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_route_type_detail_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] route <intra-area|inter-area|external-1|external-2> detail [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Routing Table\n"
	"Display Intra-Area routes\n"
	"Display Inter-Area routes\n"
	"Display Type-1 External routes\n"
	"Display Type-2 External routes\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_simulate_spf_tree_root_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] simulate spf-tree A.B.C.D area A.B.C.D",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Shortest Path First calculation\n"
	"Show SPF tree\n"
	"Specify root's router-id to calculate another router's SPF tree\n"
	"OSPF6 area parameters\n"
	"Area ID (as an IPv4 notation)\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_spf_tree_cmd_vtysh,
	"show ipv6 ospf6 [vrf <NAME|all>] spf tree [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Shortest Path First calculation\n"
	"Show SPF tree\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ipv6_ospf6_vrfs_cmd_vtysh,
	"show ipv6 ospf6 vrfs [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Show OSPF6 VRFs \n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsm_db_cmd_vtysh,
	"show ipv6 pim bsm-database [vrf NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"PIM cached bsm packets information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsr_cand_bsr_cmd_vtysh,
	"show ipv6 pim bsr candidate-bsr [vrf NAME$vrfname] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Current PIM router candidate BSR state\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsr_cand_rp_cmd_vtysh,
	"show ipv6 pim bsr candidate-rp [vrf VRF_NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Current PIM router candidate RP state\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsr_cmd_vtysh,
	"show ipv6 pim bsr [vrf NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"boot-strap router information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsr_groups_cmd_vtysh,
	"show ipv6 pim bsr groups [vrf VRF_NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"boot-strap router information\n"
	"Candidate RP groups\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsr_rpdb_cmd_vtysh,
	"show ipv6 pim bsr candidate-rp-database [vrf VRF_NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Bootstrap Router configuration\n"
	"Candidate RPs database on this router (if it is the BSR)\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_bsrp_cmd_vtysh,
	"show ipv6 pim bsrp-info [vrf NAME] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"PIM cached group-rp mappings information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_channel_cmd_vtysh,
	"show ipv6 pim [vrf NAME] channel [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM downstream channel info\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_group_type_cmd_vtysh,
	"show ipv6 pim [vrf NAME$vrf_name] group-type X:X::X:X$group [json$json]",
	"Show running system information\n"
	"IP information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"multicast group type\n"
	"group address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_interface_cmd_vtysh,
	"show ipv6 pim [vrf NAME] interface [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_interface_traffic_cmd_vtysh,
	"show ipv6 pim [vrf NAME] interface traffic [WORD$if_name] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Protocol Packet counters\n"
	"Interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_interface_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all interface [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface information\n"
	"Detailed output\n"
	"interface name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_join_cmd_vtysh,
	"show ipv6 pim [vrf NAME] join [X:X::X:X$s_or_g [X:X::X:X$g]] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface join information\n"
	"The Source or Group\n"
	"The Group\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_join_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all join [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface join information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_jp_agg_cmd_vtysh,
	"show ipv6 pim [vrf NAME] jp-agg",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"join prune aggregation list\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_local_membership_cmd_vtysh,
	"show ipv6 pim [vrf NAME] local-membership [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM interface local-membership\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_neighbor_cmd_vtysh,
	"show ipv6 pim [vrf NAME] neighbor [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor information\n"
	"Detailed output\n"
	"Name of interface or neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_neighbor_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all neighbor [detail|WORD]$interface [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor information\n"
	"Detailed output\n"
	"Name of interface or neighbor\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_nexthop_cmd_vtysh,
	"show ipv6 pim [vrf NAME] nexthop [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached nexthop rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_nexthop_lookup_cmd_vtysh,
	"show ipv6 pim [vrf NAME] nexthop-lookup X:X::X:X$source X:X::X:X$group",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached nexthop rpf lookup\n"
	"Source/RP address\n"
	"Multicast Group address\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_rp_cmd_vtysh,
	"show ipv6 pim [vrf NAME] rp-info [X:X::X:X/M$group] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM RP information\n"
	"Multicast Group range\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_rp_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all rp-info [X:X::X:X/M$group] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM RP information\n"
	"Multicast Group range\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_rpf_cmd_vtysh,
	"show ipv6 pim [vrf NAME] rpf [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached source rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_rpf_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all rpf [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM cached source rpf information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_secondary_cmd_vtysh,
	"show ipv6 pim [vrf NAME] secondary",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM neighbor addresses\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_ssm_range_cmd_vtysh,
	"show ipv6 pim [vrf NAME$vrf_name] group-type [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM group type\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_state_cmd_vtysh,
	"show ipv6 pim [vrf NAME] state [X:X::X:X$s_or_g [X:X::X:X$g]] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM state information\n"
	"Unicast or Multicast address\n"
	"Multicast address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_state_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all state [X:X::X:X$s_or_g [X:X::X:X$g]] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM state information\n"
	"Unicast or Multicast address\n"
	"Multicast address\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_statistics_cmd_vtysh,
	"show ipv6 pim [vrf NAME] statistics [interface WORD$word] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM statistics\n"
	"Interface information\n"
	"PIM interface\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_upstream_cmd_vtysh,
	"show ipv6 pim [vrf NAME] upstream [X:X::X:X$s_or_g [X:X::X:X$g]] [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream information\n"
	"The Source or Group\n"
	"The Group\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_upstream_join_desired_cmd_vtysh,
	"show ipv6 pim [vrf NAME] upstream-join-desired [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream join-desired\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_upstream_rpf_cmd_vtysh,
	"show ipv6 pim [vrf NAME] upstream-rpf [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream source rpf\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PIM6D, show_ipv6_pim_upstream_vrf_all_cmd_vtysh,
	"show ipv6 pim vrf all upstream [json$json]",
	"Show running system information\n"
	"IPv6 information\n"
	"PIM information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"PIM upstream information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BABELD|VTYSH_BGPD|VTYSH_FABRICD|VTYSH_ISISD|VTYSH_OSPF6D|VTYSH_PIM6D|VTYSH_RIPNGD|VTYSH_ZEBRA, show_ipv6_prefix_list_prefix_cmd_vtysh,
	"show ipv6 prefix-list PREFIXLIST6_NAME$name X:X::X:X/M$prefix [longer$dl|first-match$dfm]",
	"Show running system information\n"
	"IPv6 information\n"
	"Build a prefix list\n"
	"Name of a prefix list\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n"
	"Lookup longer prefix\n"
	"First matched prefix\n")

DEFSH (VTYSH_ZEBRA, show_ipv6_protocol_cmd_vtysh,
	"show ipv6 protocol [vrf <NAME$vrf_name|all$vrf_all>]",
	"Show running system information\n"
	"IPv6 Information\n"
	"IPv6 protocol filtering status\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n")

DEFSH (VTYSH_ZEBRA, show_ipv6_protocol_nht_cmd_vtysh,
	"show ipv6 nht route-map [vrf <NAME$vrf_name|all$vrf_all>] [json]",
	"Show running system information\n"
	"IPv6 Information\n"
	"IPv6 nexthop tracking table\n"
	"IPv6 Next Hop tracking filtering status\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_RIPNGD, show_ipv6_ripng_cmd_vtysh,
	"show ipv6 ripng [vrf NAME]",
	"Show running system information\n"
	"IPv6 information\n"
	"Show RIPng routes\n"
	"Specify the VRF\n"
	"The VRF name\n")

DEFSH (VTYSH_RIPNGD, show_ipv6_ripng_status_cmd_vtysh,
	"show ipv6 ripng [vrf NAME] status",
	"Show running system information\n"
	"IPv6 information\n"
	"Show RIPng routes\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"IPv6 routing protocol process parameters and statistics\n")

DEFSH (VTYSH_ISISD, show_isis_flex_algo_cmd_vtysh,
	"show isis [vrf <NAME|all>] flex-algo [(128-255)]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS Flex-algo information\n"
	"Algorithm number\n")

DEFSH (VTYSH_ISISD, show_isis_frr_summary_cmd_vtysh,
	"show isis [vrf <NAME|all>] fast-reroute summary [<level-1|level-2>]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS FRR information\n"
	"FRR summary\n"
	"level-1 routes\n"
	"level-2 routes\n")

DEFSH (VTYSH_ISISD, show_isis_interface_arg_cmd_vtysh,
	"show isis [vrf <NAME|all>] interface WORD [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS interface\n"
	"IS-IS interface name\n"
	"json output\n")

DEFSH (VTYSH_ISISD, show_isis_interface_cmd_vtysh,
	"show isis [vrf <NAME|all>] interface [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"json output\n"
	"IS-IS interface\n")

DEFSH (VTYSH_ISISD, show_isis_interface_detail_cmd_vtysh,
	"show isis [vrf <NAME|all>] interface detail [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS interface\n"
	"show detailed information\n"
	"json output\n")

DEFSH (VTYSH_ISISD, show_isis_mpls_ldp_interface_cmd_vtysh,
	"show isis mpls ldp-sync [interface <INTERFACE|all>]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"MPLS information\n"
	"LDP-IGP Sync information\n"
	"Interface information\n"
	"Interface name\n"
	"All interfaces\n")

DEFSH (VTYSH_ISISD, show_isis_mpls_te_db_cmd_vtysh,
	"show isis [vrf <NAME|all>] mpls-te database [<vertex [WORD]|edge [A.B.C.D|X:X::X:X]|subnet [A.B.C.D/M|X:X::X:X/M]>] [detail|json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MPLS-TE specific commands\n"
	"MPLS-TE database\n"
	"MPLS-TE Vertex\n"
	"MPLS-TE Vertex ID (as an ISO ID, hostname or \"self\")\n"
	"MPLS-TE Edge\n"
	"MPLS-TE Edge ID (as an IPv4 address)\n"
	"MPLS-TE Edge ID (as an IPv6 address)\n"
	"MPLS-TE Subnet\n"
	"MPLS-TE Subnet ID (as an IPv4 prefix)\n"
	"MPLS-TE Subnet ID (as an IPv6 prefix)\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ISISD, show_isis_mpls_te_interface_cmd_vtysh,
	"show isis mpls-te interface [INTERFACE]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"MPLS-TE specific commands\n"
	"Interface information\n"
	"Interface name\n")

DEFSH (VTYSH_ISISD, show_isis_mpls_te_router_cmd_vtysh,
	"show isis [vrf <NAME|all>] mpls-te router",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"MPLS-TE specific commands\n"
	"Router information\n")

DEFSH (VTYSH_ISISD, show_isis_neighbor_arg_cmd_vtysh,
	"show isis [vrf <NAME|all>] neighbor WORD [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"System id\n"
	"json output\n")

DEFSH (VTYSH_ISISD, show_isis_neighbor_cmd_vtysh,
	"show isis [vrf <NAME|all>] neighbor [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"json output\n")

DEFSH (VTYSH_ISISD, show_isis_neighbor_detail_cmd_vtysh,
	"show isis [vrf <NAME|all>] neighbor detail [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"all vrfs\n"
	"IS-IS neighbor adjacencies\n"
	"show detailed information\n"
	"json output\n")

DEFSH (VTYSH_ISISD, show_isis_route_cmd_vtysh,
	"show isis [vrf <NAME|all>] route [<level-1|level-2>] [prefix-sid] [backup] [algorithm [(128-255)]] [json$uj]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS routing table\n"
	"level-1 routes\n"
	"level-2 routes\n"
	"Show Prefix-SID information\n"
	"Show backup routes\n"
	"Show Flex-algo routes\n"
	"Algorithm number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ISISD, show_isis_spf_ietf_cmd_vtysh,
	"show isis [vrf <NAME|all>] spf-delay-ietf",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"SPF delay IETF information\n")

DEFSH (VTYSH_ISISD, show_isis_summary_cmd_vtysh,
	"show isis [vrf <NAME|all>] summary [json]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"json output\n"
	"summary\n")

DEFSH (VTYSH_ISISD, show_isis_topology_cmd_vtysh,
	"show isis [vrf <NAME|all>] topology [<level-1|level-2>] [algorithm [(128-255)]] [json$uj]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"IS-IS paths to Intermediate Systems\n"
	"Paths to all level-1 routers in the area\n"
	"Paths to all level-2 routers in the domain\n"
	"Show Flex-algo routes\n"
	"Algorithm number\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_label_table_cmd_vtysh,
	"show debugging label-table [json$uj]",
	"Show running system information\n"
	"Debugging functions\n"
	"Display allocated label chunks\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ALL, show_log_filter_cmd_vtysh,
	"show logging filter-text",
	"Show running system information\n"
	"Show current logging configuration\n"
	"Filter Logs\n")

DEFSH (VTYSH_ACL_SHOW, show_mac_access_list_cmd_vtysh,
	"show mac access-list",
	"Show running system information\n"
	"mac access lists\n"
	"List mac access lists\n")

DEFSH (VTYSH_ACL_SHOW, show_mac_access_list_name_cmd_vtysh,
	"show mac access-list ACCESSLIST_MAC_NAME",
	"Show running system information\n"
	"mac access lists\n"
	"List mac access lists\n"
	"mac address\n")

DEFSH (VTYSH_MGMTD, show_mgmt_be_adapter_cmd_vtysh,
	"show mgmt backend-adapter all",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"MGMTD Backend Adapter information\n"
	"Display all Backend Adapters\n")

DEFSH (VTYSH_MGMTD, show_mgmt_be_xpath_reg_cmd_vtysh,
	"show mgmt backend-yang-xpath-registry",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"Backend Adapter YANG Xpath Registry\n")

DEFSH (VTYSH_MGMTD, show_mgmt_cmt_hist_cmd_vtysh,
	"show mgmt commit-history",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"Show commit history\n")

DEFSH (VTYSH_MGMTD, show_mgmt_ds_cmd_vtysh,
	"show mgmt datastore [all|candidate|operational|running]$dsname",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"MGMTD Datastore information\n"
	"All datastores (default)\n"
	"Candidate datastore\n"
	"Operational datastore\n"
	"Running datastore\n")

DEFSH (VTYSH_MGMTD, show_mgmt_dump_data_cmd_vtysh,
	"show mgmt datastore-contents [candidate|operational|running]$dsname [xpath WORD$path] [file WORD$filepath] <json|xml>$fmt",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"Get Datastore contents from a specific datastore\n"
	"Candidate datastore (default)\n"
	"Operational datastore\n"
	"Running datastore\n"
	"XPath expression specifying the YANG data path\n"
	"XPath string\n"
	"Dump the contents to a file\n"
	"Full path of the file\n"
	"json output\n"
	"xml output\n")

DEFSH (VTYSH_MGMTD, show_mgmt_fe_adapter_cmd_vtysh,
	"show mgmt frontend-adapter all [detail$detail]",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"MGMTD Frontend Adapter information\n"
	"Display all Frontend Adapters\n"
	"Display more details\n")

DEFSH (VTYSH_MGMTD, show_mgmt_get_data_cmd_vtysh,
	"show mgmt get-data WORD$path [datastore <candidate|running|operational>$ds] [with-config|only-config]$content [exact]$exact [with-defaults <trim|all-tag|all>$wd] [json|xml]$fmt",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"Get a data from the operational datastore\n"
	"XPath expression specifying the YANG data root\n"
	"Specify datastore to get data from (operational by default)\n"
	"Candidate datastore\n"
	"Running datastore\n"
	"Operational datastore\n"
	"Include \"config true\" data\n"
	"Get only \"config true\" data\n"
	"Get exact node instead of the whole data tree\n"
	"Configure 'with-defaults' mode per RFC 6243 (\"explicit\" mode by default)\n"
	"Use \"trim\" mode\n"
	"Use \"report-all-tagged\" mode\n"
	"Use \"report-all\" mode\n"
	"JSON output format\n"
	"XML output format\n")

DEFSH (VTYSH_MGMTD, show_mgmt_map_xpath_cmd_vtysh,
	"show mgmt yang-xpath-subscription WORD$path",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"Get YANG Backend Subscription\n"
	"XPath expression specifying the YANG data path\n")

DEFSH (VTYSH_MGMTD, show_mgmt_txn_cmd_vtysh,
	"show mgmt transaction all",
	"Show running system information\n"
	"Management Daemon (MGMTD) information\n"
	"MGMTD Transaction information\n"
	"Display all Transactions\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_mlag_cmd_vtysh,
	"show zebra mlag",
	"Show running system information\n"
	"Zebra information\n"
	"The mlag role on this machine\n")

DEFSH (VTYSH_ZEBRA, show_mpls_fec_cmd_vtysh,
	"show mpls fec [<A.B.C.D/M|X:X::X:X/M>]",
	"Show running system information\n"
	"MPLS information\n"
	"MPLS FEC table\n"
	"FEC to display information about\n"
	"FEC to display information about\n")

DEFSH (VTYSH_ZEBRA, show_mpls_status_cmd_vtysh,
	"show mpls status",
	"Show running system information\n"
	"MPLS information\n"
	"MPLS status\n")

DEFSH (VTYSH_ZEBRA, show_mpls_table_cmd_vtysh,
	"show mpls table [json]",
	"Show running system information\n"
	"MPLS information\n"
	"MPLS table\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_mpls_table_lsp_cmd_vtysh,
	"show mpls table (16-1048575) [json]",
	"Show running system information\n"
	"MPLS information\n"
	"MPLS table\n"
	"LSP to display information about\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_neigh_cmd_vtysh,
	"show ip neigh",
	"Show running system information\n"
	"IP information\n"
	"neighbors\n")

DEFSH (VTYSH_ZEBRA, show_nexthop_group_cmd_vtysh,
	"show nexthop-group rib <(0-4294967295)$id|[singleton <ip$v4|ipv6$v6>] [<kernel|zebra|bgp|sharp>$type_str] [vrf <NAME$vrf_name|all$vrf_all>]> [json]",
	"Show running system information\n"
	"Show Nexthop Groups\n"
	"RIB information\n"
	"Nexthop Group ID\n"
	"Show Singleton Nexthop-Groups\n"
	"IP information\n"
	"IPv6 Information\n"
	"Kernel (not installed via the zebra RIB)\n"
	"Zebra (implicitly created by zebra)\n"
	"Border Gateway Protocol (BGP)\n"
	"Super Happy Advanced Routing Protocol (SHARP)\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_OSPF6D, show_ospf6_zebra_cmd_vtysh,
	"show ipv6 ospf6 zebra [json]",
	"Show running system information\n"
	"IPv6 information\n"
	"Open Shortest Path First (OSPF) for IPv6\n"
	"Zebra information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PATHD, show_pathd_ted_db_cmd_vtysh,
	"show pathd ted database <verbose|json>$ver_json ",
	"show command\n"
	"pathd daemon\n"
	"traffic eng\n"
	"database\n"
	"verbose output\n"
	"Show complete received TED database\n")

DEFSH (VTYSH_PBRD, show_pbr_cmd_vtysh,
	"show pbr",
	"Show running system information\n"
	"Policy Based Routing\n")

DEFSH (VTYSH_PBRD, show_pbr_interface_cmd_vtysh,
	"show pbr interface [NAME$name] [json$json]",
	"Show running system information\n"
	"Policy Based Routing\n"
	"PBR Interface\n"
	"PBR Interface Name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_pbr_ipset_cmd_vtysh,
	"show pbr ipset [WORD]",
	"Show running system information\n"
	"Policy-Based Routing\n"
	"IPset Context information\n"
	"IPset Name information\n")

DEFSH (VTYSH_ZEBRA, show_pbr_iptable_cmd_vtysh,
	"show pbr iptable [WORD]",
	"Show running system information\n"
	"Policy-Based Routing\n"
	"IPtable Context information\n"
	"IPtable Name information\n")

DEFSH (VTYSH_PBRD, show_pbr_map_cmd_vtysh,
	"show pbr map [NAME$name] [detail$detail] [json$json]",
	"Show running system information\n"
	"Policy Based Routing\n"
	"PBR Map\n"
	"PBR Map Name\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_PBRD, show_pbr_nexthop_group_cmd_vtysh,
	"show pbr nexthop-groups [WORD$word] [json$json]",
	"Show running system information\n"
	"Policy Based Routing\n"
	"Nexthop Groups\n"
	"Optional Name of the nexthop group\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_pbr_rule_cmd_vtysh,
	"show pbr rule",
	"Show running system information\n"
	"Policy-Based Routing\n"
	"Rule\n")

DEFSH (VTYSH_ZEBRA, show_pseudowires_cmd_vtysh,
	"show mpls pseudowires",
	"Show running system information\n"
	"MPLS information\n"
	"Pseudowires\n")

DEFSH (VTYSH_ZEBRA, show_pseudowires_detail_cmd_vtysh,
	"show mpls pseudowires detail [json]$json",
	"Show running system information\n"
	"MPLS information\n"
	"Pseudowires\n"
	"Detailed output\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_ro_cmd_vtysh,
	"show <ip$ipv4|ipv6$ipv6> ro",
	"Show running system information\n"
	"IP information\n"
	"IPv6 information\n"
	"IP routing table\n")

DEFSH (VTYSH_ZEBRA, show_route_cmd_vtysh,
	"show        <         ip$ipv4 <fib$fib|route>          [{           table <(1-4294967295)$table|all$table_all>           |mrib$mrib           |vrf <NAME$vrf_name|all$vrf_all>          }]          [{           tag (1-4294967295)           |A.B.C.D/M$prefix longer-prefixes           |supernets-only$supernets_only          }]          [<           <kernel|connected|local|static|rip|ospf|isis|bgp|eigrp|nhrp|vnc|babel|openfabric>$type_str           |ospf$type_str (1-65535)$ospf_instance_id          >]         |ipv6$ipv6 <fib$fib|route>          [{           table <(1-4294967295)$table|all$table_all>           |mrib$mrib           |vrf <NAME$vrf_name|all$vrf_all>          }]          [{           tag (1-4294967295)           |X:X::X:X/M$prefix longer-prefixes          }]          [<kernel|connected|local|static|ripng|ospf6|isis|bgp|nhrp|vnc|babel|openfabric>$type_str]        >       [<json$json|nexthop-group$ng>]",
	"Show running system information\n"
	"IP information\n"
	"IP forwarding table\n"
	"IP routing table\n"
	"Table to display\n"
	"The table number to display\n"
	"All tables\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show only routes with tag\n"
	"Tag value\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n"
	"Show route matching the specified Network/Mask pair only\n"
	"Show supernet entries only\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol (RIP)\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Enhanced Interior Gateway Routing Protocol (EIGRP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"Open Shortest Path First (OSPFv2)\n"
	"Instance ID\n"
	"IPv6 information\n"
	"IP forwarding table\n"
	"IP routing table\n"
	"Table to display\n"
	"The table number to display\n"
	"All tables\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Show only routes with tag\n"
	"Tag value\n"
	"IPv6 prefix\n"
	"Show route matching the specified Network/Mask pair only\n"
	"Kernel routes (not installed via the zebra RIB)\n"
	"Connected routes (directly attached subnet or host)\n"
	"Local routes (directly attached host route)\n"
	"Statically configured routes\n"
	"Routing Information Protocol next-generation (IPv6) (RIPng)\n"
	"Open Shortest Path First (IPv6) (OSPFv3)\n"
	"Intermediate System to Intermediate System (IS-IS)\n"
	"Border Gateway Protocol (BGP)\n"
	"Next Hop Resolution Protocol (NHRP)\n"
	"Virtual Network Control (VNC)\n"
	"Babel routing protocol (Babel)\n"
	"OpenFabric Routing Protocol\n"
	"JavaScript Object Notation\n"
	"Nexthop Group Information\n")

DEFSH (VTYSH_ZEBRA, show_route_detail_cmd_vtysh,
	"show         <          ip$ipv4 <fib$fib|route>           [{            mrib$mrib            |vrf <NAME$vrf_name|all$vrf_all>			|table <(1-4294967295)$table_id>           }]           <            A.B.C.D$address            |A.B.C.D/M$prefix           >          |ipv6$ipv6 <fib$fib|route>           [{            mrib$mrib            |vrf <NAME$vrf_name|all$vrf_all>			|table <(1-4294967295)$table_id>           }]           <            X:X::X:X$address            |X:X::X:X/M$prefix           >         >         [json$json] [nexthop-group$ng]",
	"Show running system information\n"
	"IP information\n"
	"IP forwarding table\n"
	"IP routing table\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Table to display\n"
	"The table number to display\n"
	"Network in the IP routing table to display\n"
	"IP prefix <network>/<length>, e.g., 35.0.0.0/8\n"
	"IPv6 Information\n"
	"IPv6 forwarding table\n"
	"IPv6 routing table\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Table to display\n"
	"The table number to display\n"
	"IPv6 Address\n"
	"IPv6 prefix\n"
	"JavaScript Object Notation\n"
	"Nexthop Group Information\n")

DEFSH_HIDDEN (VTYSH_RMAP_SHOW, show_route_map_pfx_tbl_cmd_vtysh,
	"show route-map RMAP_NAME prefix-table",
	"Show running system information\n"
	"route-map\n"
	"route-map name\n"
	"internal prefix-table\n")

DEFSH (VTYSH_ZEBRA, show_route_summary_cmd_vtysh,
	"show <ip$ipv4|ipv6$ipv6> route [{mrib$mrib|vrf <NAME$vrf_name|all$vrf_all>}]             summary [table (1-4294967295)$table_id] [prefix$prefix] [json]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 Information\n"
	"IP routing table\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"Summary of all routes\n"
	"Table to display summary for\n"
	"The table number\n"
	"Prefix routes\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, show_route_zebra_dump_cmd_vtysh,
	"show <ip$ipv4|ipv6$ipv6> zebra route dump [{mrib$mrib|vrf <NAME$vrf_name|all$vrf_all>}]",
	"Show running system information\n"
	"IP information\n"
	"IPv6 Information\n"
	"Zebra daemon\n"
	"Routing table\n"
	"All information\n"
	"Multicast SAFI table\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n")

DEFSH (VTYSH_BGPD, show_rpki_as_number_cmd_vtysh,
	"show rpki as-number <0$zero|ASNUM$by_asn> [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Lookup by ASN in prefix table\n"
	"AS Number of 0, see RFC-7607\n"
	"AS Number\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_rpki_cache_connection_cmd_vtysh,
	"show rpki cache-connection [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Show to which RPKI Cache Servers we have a connection\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_rpki_cache_server_cmd_vtysh,
	"show rpki cache-server [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Show configured cache server\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_rpki_configuration_cmd_vtysh,
	"show rpki configuration [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Show RPKI configuration\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_rpki_prefix_cmd_vtysh,
	"show rpki prefix <A.B.C.D/M|X:X::X:X/M> [0$zero|ASNUM$asn] [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Lookup IP prefix and optionally ASN in prefix table\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"AS Number of 0, see RFC-7607\n"
	"AS Number\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_rpki_prefix_table_cmd_vtysh,
	"show rpki <prefix-table|prefix-count>$prefixkind [vrf NAME$vrfname] [json$uj]",
	"Show running system information\n"
	"Control rpki specific settings\n"
	"Show validated prefixes which were received from RPKI Cache\n"
	"Show prefixes count which were received from RPKI Cache\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ISISD, show_sr_node_cmd_vtysh,
	"show isis segment-routing node [algorithm [(128-255)]]",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Segment-Routing\n"
	"Segment-Routing node\n"
	"Show Flex-algo nodes\n"
	"Algorithm number\n")

DEFSH (VTYSH_PATHD, show_srte_policy_cmd_vtysh,
	"show sr-te policy",
	"Show running system information\n"
	"SR-TE info\n"
	"SR-TE Policy\n")

DEFSH (VTYSH_PATHD, show_srte_policy_detail_cmd_vtysh,
	"show sr-te policy detail",
	"Show running system information\n"
	"SR-TE info\n"
	"SR-TE Policy\n"
	"Show a detailed summary\n")

DEFSH (VTYSH_ZEBRA, show_srv6_locator_cmd_vtysh,
	"show segment-routing srv6 locator [json]",
	"Show running system information\n"
	"Segment Routing\n"
	"Segment Routing SRv6\n"
	"Locator Information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_srv6_locator_detail_cmd_vtysh,
	"show segment-routing srv6 locator NAME detail [json]",
	"Show running system information\n"
	"Segment Routing\n"
	"Segment Routing SRv6\n"
	"Locator Information\n"
	"Locator Name\n"
	"Detailed information\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ZEBRA, show_srv6_manager_cmd_vtysh,
	"show segment-routing srv6 manager [json]",
	"Show running system information\n"
	"Segment Routing\n"
	"Segment Routing SRv6\n"
	"Verify SRv6 Manager\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_ISISD, show_srv6_node_cmd_vtysh,
	"show isis segment-routing srv6 node",
	"Show running system information\n"
	"IS-IS routing protocol\n"
	"Segment-Routing\n"
	"Segment-Routing over IPv6 (SRv6)\n"
	"SRv6 node\n")

DEFSH (VTYSH_ZEBRA, show_srv6_sid_cmd_vtysh,
	"show segment-routing srv6 [locator NAME$locator_name] sid [X:X::X:X$sid_value] [json]",
	"Show running system information\n"
	"Segment Routing\n"
	"Segment Routing SRv6\n"
	"Locator Information\n"
	"Locator Name\n"
	"SID\n"
	"SID value\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_BGPD, show_vnc_queries_pfx_cmd_vtysh,
	"show vnc queries [<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M|X:X:X:X:X:X>]",
	"Show running system information\n"
	"VNC information\n"
	"List active queries\n"
	"Limit output to a particualr IPV4 address\n"
	"Limit output to a particular IPv4 prefix\n"
	"Limit output to a particualr IPV6 address\n"
	"Limit output to a particular IPv6 prefix\n"
	"Limit output to a particualr MAC address\n")

DEFSH (VTYSH_ZEBRA, show_vrf_cmd_vtysh,
	"show vrf",
	"Show running system information\n"
	"VRF\n")

DEFSH (VTYSH_ZEBRA, show_vrf_vni_cmd_vtysh,
	"show vrf [<NAME$vrf_name|all$vrf_all>] vni [json]",
	"Show running system information\n"
	"Specify the VRF\n"
	"The VRF name\n"
	"All VRFs\n"
	"VNI\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_WATCHFRR, show_watchfrr_cmd_vtysh,
	"show watchfrr",
	"Show running system information\n"
	"watchfrr information\n")

DEFSH (VTYSH_ZEBRA, show_zebra_client_cmd_vtysh,
	"show zebra client",
	"Show running system information\n"
	"Zebra information\n"
	"Client information\n")

DEFSH (VTYSH_ZEBRA, show_zebra_client_summary_cmd_vtysh,
	"show zebra client summary",
	"Show running system information\n"
	"Zebra information\n"
	"Client information brief\n"
	"Brief Summary\n")

DEFSH (VTYSH_ZEBRA, show_zebra_cmd_vtysh,
	"show zebra",
	"Show running system information\n"
	"Zebra information\n")

DEFSH (VTYSH_ZEBRA, show_zebra_fpm_stats_cmd_vtysh,
	"show zebra fpm stats",
	"Show running system information\n"
	"Zebra information\n"
	"Forwarding Path Manager information\n"
	"Statistics\n")

DEFSH (VTYSH_ZEBRA, show_zebra_metaq_counters_cmd_vtysh,
	"show zebra metaq [json]",
	"Show running system information\n"
	"Zebra information\n"
	"Zebra MetaQ counters\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_MGMTD, shutdown_if_cmd_vtysh,
	"[no] shutdown",
	"Negate a command or set its defaults\n"
	"Shutdown the selected interface\n")

DEFSH (VTYSH_ISISD, spf_backoff_debug_cmd_vtysh,
	"debug spf-delay-ietf",
	"Debugging functions\n"
	"SPF Back-off Debugging\n")

DEFSH (VTYSH_ISISD, spf_delay_ietf_cmd_vtysh,
	"spf-delay-ietf init-delay (0-60000) short-delay (0-60000) long-delay (0-60000) holddown (0-60000) time-to-learn (0-60000)",
	"IETF SPF delay algorithm\n"
	"Delay used while in QUIET state\n"
	"Delay used while in QUIET state in milliseconds\n"
	"Delay used while in SHORT_WAIT state\n"
	"Delay used while in SHORT_WAIT state in milliseconds\n"
	"Delay used while in LONG_WAIT\n"
	"Delay used while in LONG_WAIT state in milliseconds\n"
	"Time with no received IGP events before considering IGP stable\n"
	"Time with no received IGP events before considering IGP stable (in milliseconds)\n"
	"Maximum duration needed to learn all the events related to a single failure\n"
	"Maximum duration needed to learn all the events related to a single failure (in milliseconds)\n")

DEFSH (VTYSH_ISISD, spf_interval_cmd_vtysh,
	"spf-interval [level-1|level-2]$level (1-120)$val",
	"Minimum interval between SPF calculations\n"
	"Set interval for level 1 only\n"
	"Set interval for level 2 only\n"
	"Minimum interval between consecutive SPFs in seconds\n")

DEFSH (VTYSH_ISISD, spf_prefix_priority_cmd_vtysh,
	"spf prefix-priority <critical|high|medium>$priority ACCESSLIST_NAME$acl_name",
	"SPF configuration\n"
	"Configure a prefix priority list\n"
	"Specify critical priority prefixes\n"
	"Specify high priority prefixes\n"
	"Specify medium priority prefixes\n"
	"Access-list name\n")

DEFSH (VTYSH_OSPFD, sr_global_label_range_cmd_vtysh,
	"segment-routing global-block (16-1048575) (16-1048575) [local-block (16-1048575) (16-1048575)]",
	"Segment-Routing specific commands\n"
	"Segment Routing Global Block label range\n"
	"Lower-bound range in decimal (16-1048575)\n"
	"Upper-bound range in decimal (16-1048575)\n"
	"Segment Routing Local Block label range\n"
	"Lower-bound range in decimal (16-1048575)\n"
	"Upper-bound range in decimal (16-1048575)\n")

DEFSH (VTYSH_OSPFD, sr_node_msd_cmd_vtysh,
	"segment-routing node-msd (1-16)",
	"Segment-Routing specific commands\n"
	"Maximum Stack Depth for this router\n"
	"Maximum number of label that could be stack (1-16)\n")

DEFSH (VTYSH_OSPFD, sr_prefix_sid_cmd_vtysh,
	"segment-routing prefix A.B.C.D/M index (0-65535) [no-php-flag|explicit-null]",
	"Segment-Routing specific commands\n"
	"Prefix SID\n"
	"IPv4 Prefix as A.B.C.D/M\n"
	"SID index for this prefix in decimal (0-65535)\n"
	"Index value inside SRGB (lower_bound < index < upper_bound)\n"
	"Don't request Penultimate Hop Popping (PHP)\n"
	"Upstream neighbor must replace prefix-sid with explicit null label\n")

DEFSH (VTYSH_PATHD, srte_candidate_affinity_filter_cmd_vtysh,
	"affinity <exclude-any|include-any|include-all>$type BITPATTERN$value",
	"Affinity constraint\n"
	"Exclude any matching link\n"
	"Include any matching link\n"
	"Include all matching links\n"
	"Attribute filter bit pattern as an hexadecimal value from 0x00000000 to 0xFFFFFFFF\n")

DEFSH (VTYSH_PATHD, srte_candidate_bandwidth_cmd_vtysh,
	"bandwidth BANDWIDTH$value [required$required]",
	"Define a bandwidth constraint\n"
	"Bandwidth value\n"
	"Required constraint\n")

DEFSH (VTYSH_PATHD, srte_candidate_metric_cmd_vtysh,
	"metric [bound$bound] <igp|te|hc|abc|lmll|cigp|cte|pigp|pte|phc|msd|pd|pdv|pl|ppd|ppdv|ppl|nap|nlp|dc|bnc>$type METRIC$value [required$required] [computed$computed]",
	"Define a metric constraint\n"
	"If the metric is bounded\n"
	"IGP metric\n"
	"TE metric\n"
	"Hop Counts\n"
	"Aggregate bandwidth consumption\n"
	"Load of the most loaded link\n"
	"Cumulative IGP cost\n"
	"Cumulative TE cost\n"
	"P2MP IGP metric\n"
	"P2MP TE metric\n"
	"P2MP hop count metric\n"
	"Segment-ID (SID) Depth.\n"
	"Path Delay metric\n"
	"Path Delay Variation metric\n"
	"Path Loss metric\n"
	"P2MP Path Delay metric\n"
	"P2MP Path Delay variation metric\n"
	"P2MP Path Loss metric\n"
	"Number of adaptations on a path\n"
	"Number of layers on a path\n"
	"Domain Count metric\n"
	"Border Node Count metric\n"
	"Metric value\n"
	"Required constraint\n"
	"Force the PCE to provide the computed path metric\n")

DEFSH (VTYSH_PATHD, srte_candidate_no_affinity_filter_cmd_vtysh,
	"no affinity <exclude-any|include-any|include-all>$type [BITPATTERN$value]",
	"Negate a command or set its defaults\n"
	"Affinity constraint\n"
	"Exclude any matching link\n"
	"Include any matching link\n"
	"Include all matching links\n"
	"Attribute filter bit pattern as an hexadecimal value from 0x00000000 to 0xFFFFFFFF\n")

DEFSH (VTYSH_PATHD, srte_candidate_no_bandwidth_cmd_vtysh,
	"no bandwidth [BANDWIDTH$value] [required$required]",
	"Negate a command or set its defaults\n"
	"Remove a bandwidth constraint\n"
	"Bandwidth value\n"
	"Required constraint\n")

DEFSH (VTYSH_PATHD, srte_candidate_no_metric_cmd_vtysh,
	"no metric [bound] <igp|te|hc|abc|lmll|cigp|cte|pigp|pte|phc|msd|pd|pdv|pl|ppd|ppdv|ppl|nap|nlp|dc|bnc>$type [METRIC$value] [required$required] [computed$computed]",
	"Negate a command or set its defaults\n"
	"Remove a metric constraint\n"
	"If the metric is bounded\n"
	"IGP metric\n"
	"TE metric\n"
	"Hop Counts\n"
	"Aggregate bandwidth consumption\n"
	"Load of the most loaded link\n"
	"Cumulative IGP cost\n"
	"Cumulative TE cost\n"
	"P2MP IGP metric\n"
	"P2MP TE metric\n"
	"P2MP hop count metric\n"
	"Segment-ID (SID) Depth.\n"
	"Path Delay metric\n"
	"Path Delay Variation metric\n"
	"Path Loss metric\n"
	"P2MP Path Delay metric\n"
	"P2MP Path Delay variation metric\n"
	"P2MP Path Loss metric\n"
	"Number of adaptations on a path\n"
	"Number of layers on a path\n"
	"Domain Count metric\n"
	"Border Node Count metric\n"
	"Metric value\n"
	"Required constraint\n"
	"Force the PCE to provide the computed path metric\n")

DEFSH (VTYSH_PATHD, srte_candidate_no_objfun_cmd_vtysh,
	"no objective-function [<mcp|mlp|mbp|mbc|mll|mcc|spt|mct|mplp|mup|mrup|mtd|mbn|mctd|msl|mss|msn>] [required$required]",
	"Negate a command or set its defaults\n"
	"Remove an objective function constraint\n"
	"Minimum Cost Path\n"
	"Minimum Load Path\n"
	"Maximum residual Bandwidth Path\n"
	"Minimize aggregate Bandwidth Consumption\n"
	"Minimize the Load of the most loaded Link\n"
	"Minimize the Cumulative Cost of a set of paths\n"
	"Shortest Path Tree\n"
	"Minimum Cost Tree\n"
	"Minimum Packet Loss Path\n"
	"Maximum Under-Utilized Path\n"
	"Maximum Reserved Under-Utilized Path\n"
	"Minimize the number of Transit Domains\n"
	"Minimize the number of Border Nodes\n"
	"Minimize the number of Common Transit Domains\n"
	"Minimize the number of Shared Links\n"
	"Minimize the number of Shared SRLGs\n"
	"Minimize the number of Shared Nodes\n"
	"Required constraint\n")

DEFSH (VTYSH_PATHD, srte_candidate_objfun_cmd_vtysh,
	"objective-function <mcp|mlp|mbp|mbc|mll|mcc|spt|mct|mplp|mup|mrup|mtd|mbn|mctd|msl|mss|msn>$type [required$required]",
	"Define an objective function constraint\n"
	"Minimum Cost Path\n"
	"Minimum Load Path\n"
	"Maximum residual Bandwidth Path\n"
	"Minimize aggregate Bandwidth Consumption\n"
	"Minimize the Load of the most loaded Link\n"
	"Minimize the Cumulative Cost of a set of paths\n"
	"Shortest Path Tree\n"
	"Minimum Cost Tree\n"
	"Minimum Packet Loss Path\n"
	"Maximum Under-Utilized Path\n"
	"Maximum Reserved Under-Utilized Path\n"
	"Minimize the number of Transit Domains\n"
	"Minimize the number of Border Nodes\n"
	"Minimize the number of Common Transit Domains\n"
	"Minimize the number of Shared Links\n"
	"Minimize the number of Shared SRLGs\n"
	"Minimize the number of Shared Nodes\n"
	"Required constraint\n")

DEFSH (VTYSH_PATHD, srte_no_policy_cmd_vtysh,
	"no policy color (0-4294967295)$num endpoint <A.B.C.D|X:X::X:X>$endpoint",
	"Negate a command or set its defaults\n"
	"Segment Routing Policy\n"
	"SR Policy color\n"
	"SR Policy color value\n"
	"SR Policy endpoint\n"
	"SR Policy endpoint IPv4 address\n"
	"SR Policy endpoint IPv6 address\n")

DEFSH (VTYSH_PATHD, srte_no_segment_list_cmd_vtysh,
	"no segment-list WORD$name",
	"Negate a command or set its defaults\n"
	"Segment List\n"
	"Segment List Name\n")

DEFSH (VTYSH_PATHD, srte_policy_binding_sid_cmd_vtysh,
	"binding-sid (16-1048575)$label",
	"Segment Routing Policy Binding-SID\n"
	"SR Policy Binding-SID label\n")

DEFSH (VTYSH_PATHD, srte_policy_candidate_exp_cmd_vtysh,
	"candidate-path preference (0-4294967295)$preference name WORD$name 	 explicit segment-list WORD$list_name",
	"Segment Routing Policy Candidate Path\n"
	"Segment Routing Policy Candidate Path Preference\n"
	"Administrative Preference\n"
	"Segment Routing Policy Candidate Path Name\n"
	"Symbolic Name\n"
	"Explicit Path\n"
	"List of SIDs\n"
	"Name of the Segment List\n")

DEFSH (VTYSH_PATHD, srte_policy_name_cmd_vtysh,
	"name WORD$name",
	"Segment Routing Policy name\n"
	"SR Policy name value\n")

DEFSH (VTYSH_PATHD, srte_policy_no_binding_sid_cmd_vtysh,
	"no binding-sid [(16-1048575)]",
	"Negate a command or set its defaults\n"
	"Segment Routing Policy Binding-SID\n"
	"SR Policy Binding-SID label\n")

DEFSH (VTYSH_PATHD, srte_policy_no_candidate_cmd_vtysh,
	"no candidate-path	preference (0-4294967295)$preference	[name WORD	<	  explicit segment-list WORD	  |dynamic	>]",
	"Negate a command or set its defaults\n"
	"Segment Routing Policy Candidate Path\n"
	"Segment Routing Policy Candidate Path Preference\n"
	"Administrative Preference\n"
	"Segment Routing Policy Candidate Path Name\n"
	"Symbolic Name\n"
	"Explicit Path\n"
	"List of SIDs\n"
	"Name of the Segment List\n"
	"Dynamic Path\n")

DEFSH (VTYSH_PATHD, srte_policy_no_name_cmd_vtysh,
	"no name [WORD]",
	"Negate a command or set its defaults\n"
	"Segment Routing Policy name\n"
	"SR Policy name value\n")

DEFSH (VTYSH_PATHD, srte_segment_list_no_segment_cmd_vtysh,
	"no index (0-4294967295)$index",
	"Negate a command or set its defaults\n"
	"Index\n"
	"Index Value\n")

DEFSH (VTYSH_PATHD, srte_segment_list_segment_cmd_vtysh,
	"index (0-4294967295)$index <[mpls$has_mpls_label label (16-1048575)$label] |[nai$has_nai <prefix <A.B.C.D/M$prefix_ipv4|X:X::X:X/M$prefix_ipv6><algorithm$has_algo (0-1)$algo| iface$has_iface_id (0-4294967295)$iface_id>| adjacency$has_adj <A.B.C.D$adj_src_ipv4 A.B.C.D$adj_dst_ipv4|X:X::X:X$adj_src_ipv6 X:X::X:X$adj_dst_ipv6>>]>",
	"Index\n"
	"Index Value\n"
	"MPLS or IP Label\n"
	"Label\n"
	"Label Value\n"
	"Segment NAI\n"
	"NAI prefix identifier\n"
	"NAI IPv4 prefix identifier\n"
	"NAI IPv6 prefix identifier\n"
	"IGP Algorithm\n"
	"Algorithm Value SPF or Strict-SPF\n"
	"Interface Id\n"
	"Interface Value\n"
	"ADJ identifier\n"
	"ADJ IPv4 src identifier\n"
	"ADJ IPv4 dst identifier\n"
	"ADJ IPv6 src identifier\n"
	"ADJ IPv6 dst identifier\n")

DEFSH (VTYSH_MGMTD, srv6_sid_cmd_vtysh,
	"sid X:X::X:X/M locator NAME$locator_name behavior <uN | uA interface INTERFACE$interface [nexthop X:X::X:X$nh6] | uDT6 vrf VIEWVRFNAME | uDT4 vrf VIEWVRFNAME | uDT46 vrf VIEWVRFNAME>",
	"Configure SRv6 SID\n"
	"Specify SRv6 SID\n"
	"Locator name\n"
	"Specify Locator name\n"
	"Specify SRv6 SID behavior\n"
	"Apply the code to a uN SID\n"
	"Behavior uA\n"
	"Configure the interface\n"
	"Interface name\n"
	"Configure the nexthop\n"
	"IPv6 address of the nexthop\n"
	"Apply the code to an uDT6 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n"
	"Apply the code to an uDT4 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n"
	"Apply the code to an uDT46 SID\n"
	"Configure VRF name\n"
	"Specify VRF name\n")

DEFSH (VTYSH_ZEBRA, srv6_sid_format_explicit_cmd_vtysh,
	"explicit start (0-4294967295)$start",
	"Configure Explicit range\n"
	"Configure the start value for the Explicit range\n"
	"Specify the start value for the Explicit range\n")

DEFSH (VTYSH_ZEBRA, srv6_sid_format_usid_lib_cmd_vtysh,
	"local-id-block start (0-4294967295)$start",
	"Configure LIB\n"
	"Configure the start value for the LIB\n"
	"Specify the start value for the LIB\n")

DEFSH (VTYSH_ZEBRA, srv6_sid_format_usid_lib_explicit_cmd_vtysh,
	"local-id-block explicit start (0-4294967295)$start end (0-4294967295)$end",
	"Configure LIB\n"
	"Configure the Explicit LIB\n"
	"Configure the start value for the Explicit LIB\n"
	"Specify the start value for the Explicit LIB\n"
	"Configure the end value for the Explicit LIB\n"
	"Specify the end value for the Explicit LIB\n")

DEFSH (VTYSH_ZEBRA, srv6_sid_format_usid_wide_lib_explicit_cmd_vtysh,
	"wide-local-id-block explicit start (0-4294967295)$start",
	"Configure Wide LIB\n"
	"Configure Explicit Wide LIB\n"
	"Configure the start value for the Explicit Wide LIB\n"
	"Specify the start value for the Explicit Wide LIB\n")

DEFSH (VTYSH_ZEBRA, srv6_sid_format_usid_wlib_cmd_vtysh,
	"wide-local-id-block start (0-4294967295)$start end (0-4294967295)$end",
	"Configure Wide LIB\n"
	"Configure the start value for the Wide LIB\n"
	"Specify the start value for the Wide LIB\n"
	"Configure the end value for the Wide LIB\n"
	"Specify the end value for the Wide LIB\n")

DEFSH (VTYSH_ZEBRA, srv6_src_addr_cmd_vtysh,
	"source-address X:X::X:X$encap_src_addr",
	"Segment Routing SRv6 source address\n"
	"Specify source address for SRv6 encapsulation\n")

DEFSH (VTYSH_STATICD, staticd_show_bfd_routes_cmd_vtysh,
	"show bfd static route [json]$isjson",
	"Show running system information\n"
	"BFD monitoring\n"
	"Static route daemon\n"
	"Routing Table\n"
	"JavaScript Object Notation\n")

DEFSH_HIDDEN (VTYSH_BGPD, test_es_add_cmd_vtysh,
	"[no$no] test es NAME$esi_str [state NAME$state_str]",
	"Negate a command or set its defaults\n"
	"Test\n"
	"Ethernet-segment\n"
	"Ethernet-Segment Identifier\n"
	"ES link state\n"
	"up|down\n")

DEFSH_HIDDEN (VTYSH_BGPD, test_es_vni_add_cmd_vtysh,
	"[no$no] test es NAME$esi_str vni (1-16777215)$vni",
	"Negate a command or set its defaults\n"
	"Test\n"
	"Ethernet-segment\n"
	"Ethernet-Segment Identifier\n"
	"VNI\n"
	"1-16777215\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, test_mlag_cmd_vtysh,
	"test zebra mlag <none$none|primary$primary|secondary$secondary>",
	"Test code\n"
	"Zebra information\n"
	"Modify the Mlag state\n"
	"Mlag is not setup on the machine\n"
	"Mlag is setup to be primary\n"
	"Mlag is setup to be the secondary\n")

DEFSH (VTYSH_NHRPD, tunnel_protection_cmd_vtysh,
	"tunnel protection vici profile PROFILE [fallback-profile FALLBACK]",
	"NHRP/GRE integration\n"
	"IPsec protection\n"
	"VICI (StrongSwan)\n"
	"IPsec profile\n"
	"IPsec profile name\n"
	"Fallback IPsec profile\n"
	"Fallback IPsec profile name\n")

DEFSH (VTYSH_NHRPD, tunnel_source_cmd_vtysh,
	"tunnel source INTERFACE",
	"NHRP/GRE integration\n"
	"Tunnel device binding tracking\n"
	"Interface name\n")

DEFSH (VTYSH_BGPD, vnc_advertise_un_method_cmd_vtysh,
	"vnc advertise-un-method encap-attr",
	"VNC/RFP related configuration\n"
	"Method of advertising UN addresses\n"
	"Via Tunnel Encap attribute (in VPN SAFI)\n")

DEFSH (VTYSH_BGPD, vnc_clear_counters_cmd_vtysh,
	"clear vnc counters",
	"Reset functions\n"
	"VNC information\n"
	"Reset VNC counters\n")

DEFSH (VTYSH_BGPD, vnc_defaults_l2rd_cmd_vtysh,
	"l2rd <(1-255)|auto-vn>",
	"Specify default Local Nve ID value to use in RD for L2 routes\n"
	"Fixed value 1-255\n"
	"use the low-order octet of the NVE's VN address\n")

DEFSH (VTYSH_BGPD, vnc_defaults_no_l2rd_cmd_vtysh,
	"no l2rd",
	"Negate a command or set its defaults\n"
	"Specify default Local Nve ID value to use in RD for L2 routes\n")

DEFSH (VTYSH_BGPD, vnc_defaults_rd_cmd_vtysh,
	"rd ASN:NN_OR_IP-ADDRESS:NN",
	"Specify default route distinguisher\n"
	"Route Distinguisher (<as-number>:<number> | <ip-address>:<number> | auto:vn:<number> )\n")

DEFSH (VTYSH_BGPD, vnc_defaults_responselifetime_cmd_vtysh,
	"response-lifetime <LIFETIME|infinite>",
	"Specify default response lifetime\n"
	"Response lifetime in seconds\n"
	"Infinite response lifetime\n")

DEFSH (VTYSH_BGPD, vnc_defaults_rt_both_cmd_vtysh,
	"rt both RTLIST...",
	"Configure default route targets\n"
	"Export+import filters\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_defaults_rt_export_cmd_vtysh,
	"rt export RTLIST...",
	"Configure default route targets\n"
	"Export filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_defaults_rt_import_cmd_vtysh,
	"rt import RTLIST...",
	"Specify default route targets\n"
	"Import filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_export_mode_cmd_vtysh,
	"vnc export <bgp|zebra> mode <group-nve|ce|none|registering-nve>",
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"Select export mode\n"
	"Export routes with nve-group next-hops\n"
	"Export routes with NVE connected router next-hops\n"
	"Disable export\n"
	"Export routes with registering NVE as next-hop\n")

DEFSH (VTYSH_BGPD, vnc_export_nvegroup_cmd_vtysh,
	"vnc export <bgp|zebra> group-nve group NAME",
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"NVE group, used in 'group-nve' export mode\n"
	"NVE group\n"
	"Group name\n")

DEFSH (VTYSH_BGPD, vnc_l2_group_labels_cmd_vtysh,
	"labels (0-1048575)...",
	"Specify label values associated with group\n"
	"Space separated list of label values <0-1048575>\n")

DEFSH (VTYSH_BGPD, vnc_l2_group_lni_cmd_vtysh,
	"logical-network-id (0-4294967295)",
	"Specify Logical Network ID associated with group\n"
	"value\n")

DEFSH (VTYSH_BGPD, vnc_l2_group_no_labels_cmd_vtysh,
	"no labels (0-1048575)...",
	"Negate a command or set its defaults\n"
	"Specify label values associated with L2 group\n"
	"Space separated list of label values <0-1048575>\n")

DEFSH (VTYSH_BGPD, vnc_l2_group_rt_cmd_vtysh,
	"rt <both|export|import> ASN:NN_OR_IP-ADDRESS:NN",
	"Specify route targets\n"
	"Export+import filters\n"
	"Export filters\n"
	"Import filters\n"
	"A route target\n")

DEFSH (VTYSH_BGPD, vnc_no_export_nvegroup_cmd_vtysh,
	"vnc export <bgp|zebra> group-nve no group NAME",
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"NVE group, used in 'group-nve' export mode\n"
	"Disable export of VNC routes\n"
	"NVE group\n"
	"Group name\n")

DEFSH (VTYSH_BGPD, vnc_no_l2_group_cmd_vtysh,
	"no vnc l2-group NAME",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Configure a L2 group\n"
	"Group name\n")

DEFSH (VTYSH_BGPD, vnc_no_nve_group_cmd_vtysh,
	"no vnc nve-group NAME",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Configure a NVE group\n"
	"Group name\n")

DEFSH (VTYSH_BGPD, vnc_no_redistribute_protocol_cmd_vtysh,
	"no vnc redistribute <ipv4|ipv6> <bgp|bgp-direct|bgp-direct-to-nve-groups|connected|kernel|ospf|rip|static>",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Redistribute from other protocol\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"From BGP\n"
	"From BGP without Zebra\n"
	"From BGP without Zebra, only to configured NVE groups\n"
	"Connected interfaces\n"
	"From kernel routes\n"
	"From Open Shortest Path First (OSPF)\n"
	"From Routing Information Protocol (RIP)\n"
	"From Static routes\n")

DEFSH (VTYSH_BGPD, vnc_no_vrf_policy_cmd_vtysh,
	"no vrf-policy NAME",
	"Negate a command or set its defaults\n"
	"Remove a VRF policy group\n"
	"VRF name\n")

DEFSH (VTYSH_BGPD, vnc_nve_export_no_prefixlist_cmd_vtysh,
	"no vnc export <bgp|zebra> <ipv4|ipv6> prefix-list [NAME]",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"IPv4 prefixes\n"
	"IPv6 prefixes\n"
	"Prefix-list for filtering exported routes\n"
	"Prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_nve_export_no_routemap_cmd_vtysh,
	"no vnc export <bgp|zebra> route-map [NAME]",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"Route-map for filtering exported routes\n"
	"Route map name\n")

DEFSH (VTYSH_BGPD, vnc_nve_export_prefixlist_cmd_vtysh,
	"vnc export <bgp|zebra> <ipv4|ipv6> prefix-list NAME",
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"IPv4 prefixes\n"
	"IPv6 prefixes\n"
	"Prefix-list for filtering exported routes\n"
	"Prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_nve_export_routemap_cmd_vtysh,
	"vnc export <bgp|zebra> route-map NAME",
	"VNC/RFP related configuration\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"Route-map for filtering exported routes\n"
	"Route map name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_export_no_prefixlist_cmd_vtysh,
	"no export <bgp|zebra> <ipv4|ipv6> prefix-list [NAME]",
	"Negate a command or set its defaults\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering exported routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_export_no_routemap_cmd_vtysh,
	"no export <bgp|zebra> route-map [NAME]",
	"Negate a command or set its defaults\n"
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_export_prefixlist_cmd_vtysh,
	"export <bgp|zebra> <ipv4|ipv6> prefix-list NAME",
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering exported routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_export_routemap_cmd_vtysh,
	"export <bgp|zebra> route-map NAME",
	"Export to other protocols\n"
	"Export to BGP\n"
	"Export to Zebra (experimental)\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_l2rd_cmd_vtysh,
	"l2rd <(1-255)|auto-vn>",
	"Specify default Local Nve ID value to use in RD for L2 routes\n"
	"Fixed value 1-255\n"
	"use the low-order octet of the NVE's VN address\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_no_l2rd_cmd_vtysh,
	"no l2rd",
	"Negate a command or set its defaults\n"
	"Specify default Local Nve ID value to use in RD for L2 routes\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_prefix_cmd_vtysh,
	"prefix <vn|un> <A.B.C.D/M|X:X::X:X/M>",
	"Specify prefixes matching NVE VN or UN interfaces\n"
	"VN prefix\n"
	"UN prefix\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_rd_cmd_vtysh,
	"rd ASN:NN_OR_IP-ADDRESS:NN",
	"Specify route distinguisher\n"
	"Route Distinguisher (<as-number>:<number> | <ip-address>:<number> | auto:vn:<number> )\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_redist_bgpdirect_no_prefixlist_cmd_vtysh,
	"no redistribute bgp-direct <ipv4|ipv6> prefix-list",
	"Negate a command or set its defaults\n"
	"Redistribute from other protocol\n"
	"Redistribute from BGP directly\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering redistributed routes\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_redist_bgpdirect_no_routemap_cmd_vtysh,
	"no redistribute bgp-direct route-map",
	"Negate a command or set its defaults\n"
	"Redistribute from other protocols\n"
	"Redistribute from BGP directly\n"
	"Route-map for filtering redistributed routes\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_redist_bgpdirect_prefixlist_cmd_vtysh,
	"redistribute bgp-direct <ipv4|ipv6> prefix-list NAME",
	"Redistribute from other protocol\n"
	"Redistribute from BGP directly\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering redistributed routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_redist_bgpdirect_routemap_cmd_vtysh,
	"redistribute bgp-direct route-map NAME",
	"Redistribute from other protocols\n"
	"Redistribute from BGP directly\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_responselifetime_cmd_vtysh,
	"response-lifetime <LIFETIME|infinite>",
	"Specify response lifetime\n"
	"Response lifetime in seconds\n"
	"Infinite response lifetime\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_rt_both_cmd_vtysh,
	"rt both RTLIST...",
	"Specify route targets\n"
	"Export+import filters\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_rt_export_cmd_vtysh,
	"rt export RTLIST...",
	"Specify route targets\n"
	"Export filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_nve_group_rt_import_cmd_vtysh,
	"rt import RTLIST...",
	"Specify route targets\n"
	"Import filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_redist_bgpdirect_no_prefixlist_cmd_vtysh,
	"no vnc redistribute <bgp-direct|bgp-direct-to-nve-groups> <ipv4|ipv6> prefix-list",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Redistribute from other protocol\n"
	"Redistribute from BGP directly\n"
	"Redistribute from BGP without Zebra, only to configured NVE groups\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering redistributed routes\n")

DEFSH (VTYSH_BGPD, vnc_redist_bgpdirect_no_routemap_cmd_vtysh,
	"no vnc redistribute <bgp-direct|bgp-direct-to-nve-groups> route-map",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Redistribute from other protocols\n"
	"Redistribute from BGP directly\n"
	"Redistribute from BGP without Zebra, only to configured NVE groups\n"
	"Route-map for filtering redistributed routes\n")

DEFSH (VTYSH_BGPD, vnc_redist_bgpdirect_prefixlist_cmd_vtysh,
	"vnc redistribute <bgp-direct|bgp-direct-to-nve-groups> <ipv4|ipv6> prefix-list NAME",
	"VNC/RFP related configuration\n"
	"Redistribute from other protocol\n"
	"Redistribute from BGP directly\n"
	"Redistribute from BGP without Zebra, only to configured NVE groups\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering redistributed routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_redist_bgpdirect_routemap_cmd_vtysh,
	"vnc redistribute <bgp-direct|bgp-direct-to-nve-groups> route-map NAME",
	"VNC/RFP related configuration\n"
	"Redistribute from other protocols\n"
	"Redistribute from BGP directly\n"
	"Redistribute from BGP without Zebra, only to configured NVE groups\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_bgp_exterior_cmd_vtysh,
	"vnc redistribute <ipv4|ipv6> bgp-direct-to-nve-groups view NAME",
	"VNC/RFP related configuration\n"
	"Redistribute routes into VNC\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"From BGP without Zebra, only to configured NVE groups\n"
	"From BGP view\n"
	"BGP view name\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_lifetime_cmd_vtysh,
	"vnc redistribute lifetime <LIFETIME|infinite>",
	"VNC/RFP related configuration\n"
	"Redistribute\n"
	"Assign a lifetime to routes redistributed from another routing protocol\n"
	"lifetime value (32 bit)\n"
	"Allow lifetime to never expire\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_mode_cmd_vtysh,
	"vnc redistribute mode <nve-group|plain|resolve-nve>",
	"VNC/RFP related configuration\n"
	"Redistribute routes into VNC\n"
	"Redistribution mode\n"
	"Based on redistribute nve-group\n"
	"Unmodified\n"
	"Resolve each nexthop to connected NVEs\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_no_nvegroup_cmd_vtysh,
	"no vnc redistribute nve-group",
	"Negate a command or set its defaults\n"
	"VNC/RFP related configuration\n"
	"Redistribute from other protocol\n"
	"Assign a NVE group to routes redistributed from another routing protocol\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_nvegroup_cmd_vtysh,
	"vnc redistribute nve-group NAME",
	"VNC/RFP related configuration\n"
	"Assign a NVE group to routes redistributed from another routing protocol\n"
	"NVE group\n"
	"Group name\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_protocol_cmd_vtysh,
	"vnc redistribute <ipv4|ipv6> <bgp|bgp-direct|bgp-direct-to-nve-groups|connected|kernel|ospf|rip|static>",
	"VNC/RFP related configuration\n"
	"Redistribute routes into VNC\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"From BGP\n"
	"From BGP without Zebra\n"
	"From BGP without Zebra, only to configured NVE groups\n"
	"Connected interfaces\n"
	"From kernel routes\n"
	"From Open Shortest Path First (OSPF)\n"
	"From Routing Information Protocol (RIP)\n"
	"From Static routes\n")

DEFSH (VTYSH_BGPD, vnc_redistribute_rh_roo_localadmin_cmd_vtysh,
	"vnc redistribute resolve-nve roo-ec-local-admin (0-65535)",
	"VNC/RFP related configuration\n"
	"Redistribute routes into VNC\n"
	"Resolve-NVE mode\n"
	"Route Origin Extended Community Local Admin Field\n"
	"Field value\n")

DEFSH (VTYSH_BGPD, vnc_show_nves_cmd_vtysh,
	"show vnc nves",
	"Show running system information\n"
	"VNC information\n"
	"List known NVEs\n")

DEFSH (VTYSH_BGPD, vnc_show_nves_ptct_cmd_vtysh,
	"show vnc nves <vn|un> <A.B.C.D|X:X::X:X>",
	"Show running system information\n"
	"VNC information\n"
	"List known NVEs\n"
	"VN address of NVE\n"
	"UN address of NVE\n"
	"IPv4 interface address\n"
	"IPv6 interface address\n")

DEFSH (VTYSH_BGPD, vnc_show_registrations_pfx_cmd_vtysh,
	"show vnc registrations [<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M|X:X:X:X:X:X>]",
	"Show running system information\n"
	"VNC information\n"
	"List active prefix registrations\n"
	"Limit output to a particualr IPV4 address\n"
	"Limit output to a particular IPv4 prefix\n"
	"Limit output to a particualr IPV6 address\n"
	"Limit output to a particular IPv6 prefix\n"
	"Limit output to a particular MAC address\n")

DEFSH (VTYSH_BGPD, vnc_show_registrations_some_pfx_cmd_vtysh,
	"show vnc registrations <all|holddown|imported|local|remote> [<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M|X:X:X:X:X:X>]",
	"Show running system information\n"
	"VNC information\n"
	"List active prefix registrations\n"
	"show all registrations\n"
	"show only registrations in holddown\n"
	"show only imported prefixes\n"
	"show only local registrations\n"
	"show only remote registrations\n"
	"Limit output to a particualr IPV4 address\n"
	"Limit output to a particular IPv4 prefix\n"
	"Limit output to a particualr IPV6 address\n"
	"Limit output to a particular IPv6 prefix\n"
	"Limit output to a particular MAC address\n")

DEFSH (VTYSH_BGPD, vnc_show_responses_pfx_cmd_vtysh,
	"show vnc responses [<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M|X:X:X:X:X:X>]",
	"Show running system information\n"
	"VNC information\n"
	"List recent query responses\n"
	"Limit output to a particualr IPV4 address\n"
	"Limit output to a particular IPv4 prefix\n"
	"Limit output to a particualr IPV6 address\n"
	"Limit output to a particular IPv6 prefix\n"
	"Limit output to a particular MAC address\n")

DEFSH (VTYSH_BGPD, vnc_show_responses_some_pfx_cmd_vtysh,
	"show vnc responses <active|removed> [<A.B.C.D|A.B.C.D/M|X:X::X:X|X:X::X:X/M|X:X:X:X:X:X>]",
	"Show running system information\n"
	"VNC information\n"
	"List recent query responses\n"
	"show only active query responses\n"
	"show only removed query responses\n"
	"Limit output to a particualr IPV4 address\n"
	"Limit output to a particular IPv4 prefix\n"
	"Limit output to a particualr IPV6 address\n"
	"Limit output to a particular IPv6 prefix\n"
	"Limit output to a particular MAC address\n")

DEFSH (VTYSH_BGPD, vnc_show_summary_cmd_vtysh,
	"show vnc summary",
	"Show running system information\n"
	"VNC information\n"
	"Display VNC status summary\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_export_no_prefixlist_cmd_vtysh,
	"no export <ipv4|ipv6> prefix-list [NAME]",
	"Negate a command or set its defaults\n"
	"Export to VRF\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering exported routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_export_no_routemap_cmd_vtysh,
	"no export route-map [NAME]",
	"Negate a command or set its defaults\n"
	"Export to VRF\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_export_prefixlist_cmd_vtysh,
	"export <ipv4|ipv6> prefix-list NAME",
	"Export to VRF\n"
	"IPv4 routes\n"
	"IPv6 routes\n"
	"Prefix-list for filtering exported routes\n"
	"prefix list name\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_export_routemap_cmd_vtysh,
	"export route-map NAME",
	"Export to VRF\n"
	"Route-map for filtering exported routes\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_label_cmd_vtysh,
	"label (0-1048575)",
	"Default label value for VRF\n"
	"Label Value <0-1048575>\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_nexthop_cmd_vtysh,
	"nexthop <A.B.C.D|X:X::X:X|self>",
	"Specify next hop to use for VRF advertised prefixes\n"
	"IPv4 prefix\n"
	"IPv6 prefix\n"
	"Use configured router-id (default)\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_no_label_cmd_vtysh,
	"no label",
	"Negate a command or set its defaults\n"
	"Remove VRF default label\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_rd_cmd_vtysh,
	"rd ASN:NN_OR_IP-ADDRESS:NN",
	"Specify default VRF route distinguisher\n"
	"Route Distinguisher (<as-number>:<number> | <ip-address>:<number> | auto:nh:<number> )\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_rt_both_cmd_vtysh,
	"rt both RTLIST...",
	"Specify route targets\n"
	"Export+import filters\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_rt_export_cmd_vtysh,
	"rt export RTLIST...",
	"Specify route targets\n"
	"Export filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_BGPD, vnc_vrf_policy_rt_import_cmd_vtysh,
	"rt import RTLIST...",
	"Specify route targets\n"
	"Import filter\n"
	"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)\n")

DEFSH (VTYSH_MGMTD, vni_mapping_cmd_vtysh,
	"[no] vni ![(1-16777215)[prefix-routes-only$filter]]",
	"Negate a command or set its defaults\n"
	"VNI corresponding to tenant VRF\n"
	"VNI-ID\n"
	"prefix-routes-only\n")

DEFSH (VTYSH_BGPD, vpnv4_network_cmd_vtysh,
	"network A.B.C.D/M rd ASN:NN_OR_IP-ADDRESS:NN <tag|label> (0-1048575)",
	"Specify a network to announce via BGP\n"
	"IPv4 prefix\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"VPN NLRI label (tag)\n"
	"VPN NLRI label (tag)\n"
	"Label value\n")

DEFSH (VTYSH_BGPD, vpnv4_network_route_map_cmd_vtysh,
	"network A.B.C.D/M rd ASN:NN_OR_IP-ADDRESS:NN <tag|label> (0-1048575) route-map RMAP_NAME",
	"Specify a network to announce via BGP\n"
	"IPv4 prefix\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"VPN NLRI label (tag)\n"
	"VPN NLRI label (tag)\n"
	"Label value\n"
	"route map\n"
	"route map name\n")

DEFSH (VTYSH_BGPD, vpnv6_network_cmd_vtysh,
	"network X:X::X:X/M rd ASN:NN_OR_IP-ADDRESS:NN <tag|label> (0-1048575) [route-map RMAP_NAME]",
	"Specify a network to announce via BGP\n"
	"IPv6 prefix <network>/<length>, e.g., 3ffe::/16\n"
	"Specify Route Distinguisher\n"
	"VPN Route Distinguisher\n"
	"VPN NLRI label (tag)\n"
	"VPN NLRI label (tag)\n"
	"Label value\n"
	"route map\n"
	"route map name\n")

DEFSH (VTYSH_VRF, vrf_debug_cmd_vtysh,
	"debug vrf",
	"Debugging functions\n"
	"VRF Debugging\n")

DEFSH (VTYSH_MGMTD, vrf_netns_cmd_vtysh,
	"[no] netns ![NAME$netns_name]",
	"Negate a command or set its defaults\n"
	"Attach VRF to a Namespace\n"
	"The file name in /var/run/netns, or a full pathname\n")

DEFSH (VTYSH_VRRPD, vrrp_advertisement_interval_cmd_vtysh,
	"vrrp (1-255)$vrid advertisement-interval (10-40950)",
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Virtual Router Advertisement Interval\n"
	"Advertisement interval in milliseconds; must be multiple of 10\n")

DEFSH (VTYSH_VRRPD, vrrp_autoconfigure_cmd_vtysh,
	"[no] vrrp autoconfigure [version (2-3)]",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Automatically set up VRRP instances on VRRP-compatible interfaces\n"
	"Version for automatically configured instances\n"
	"VRRP protocol version\n")

DEFSH (VTYSH_VRRPD, vrrp_checksum_with_ipv4_pseudoheader_cmd_vtysh,
	"[no] vrrp (1-255)$vrid checksum-with-ipv4-pseudoheader",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Checksum mode in VRRPv3\n")

DEFSH (VTYSH_VRRPD, vrrp_default_cmd_vtysh,
	"[no] vrrp default <advertisement-interval$adv (10-40950)$advint|preempt$p|priority$prio (1-254)$prioval|checksum-with-ipv4-pseudoheader$ipv4ph|shutdown$s>",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Configure defaults for new VRRP instances\n"
	"Virtual Router Advertisement Interval\n"
	"Advertisement interval in milliseconds\n"
	"Preempt mode\n"
	"Virtual Router Priority\n"
	"Priority value\n"
	"Checksum mode in VRRPv3\n"
	"Force VRRP router into administrative shutdown\n")

DEFSH (VTYSH_VRRPD, vrrp_ip6_cmd_vtysh,
	"[no] vrrp (1-255)$vrid ipv6 X:X::X:X",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Add IPv6 address\n"
	"Virtual Router IP address\n")

DEFSH (VTYSH_VRRPD, vrrp_ip_cmd_vtysh,
	"[no] vrrp (1-255)$vrid ip A.B.C.D",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Add IPv4 address\n"
	"Virtual Router IP address\n")

DEFSH (VTYSH_VRRPD, vrrp_preempt_cmd_vtysh,
	"[no] vrrp (1-255)$vrid preempt",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Preempt mode\n")

DEFSH (VTYSH_VRRPD, vrrp_priority_cmd_vtysh,
	"vrrp (1-255)$vrid priority (1-254)",
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Virtual Router Priority\n"
	"Priority value\n")

DEFSH (VTYSH_VRRPD, vrrp_shutdown_cmd_vtysh,
	"[no] vrrp (1-255)$vrid shutdown",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"Force VRRP router into administrative shutdown\n")

DEFSH (VTYSH_VRRPD, vrrp_vrid_cmd_vtysh,
	"[no] vrrp (1-255)$vrid [version (2-3)]",
	"Negate a command or set its defaults\n"
	"Virtual Router Redundancy Protocol\n"
	"Virtual Router ID\n"
	"VRRP protocol version\n"
	"VRRP protocol version\n")

DEFSH (VTYSH_VRRPD, vrrp_vrid_show_cmd_vtysh,
	"show vrrp [interface INTERFACE$ifn] [(1-255)$vrid] [json$json]",
	"Show running system information\n"
	"Virtual Router Redundancy Protocol\n"
	"Interface information\n"
	"Only show VRRP instances on this interface\n"
	"Virtual Router ID\n"
	"JavaScript Object Notation\n")

DEFSH (VTYSH_VRRPD, vrrp_vrid_show_summary_cmd_vtysh,
	"show vrrp [interface INTERFACE$ifn] [(1-255)$vrid] summary",
	"Show running system information\n"
	"Virtual Router Redundancy Protocol\n"
	"Interface information\n"
	"Only show VRRP instances on this interface\n"
	"Virtual Router ID\n"
	"Summarize all VRRP instances\n")

DEFSH (VTYSH_ALL, vty_access_class_cmd_vtysh,
	"access-class WORD",
	"Filter connections based on an IP access list\n"
	"IP access list\n")

DEFSH (VTYSH_ALL, vty_ipv6_access_class_cmd_vtysh,
	"ipv6 access-class WORD",
	"IPv6 information\n"
	"Filter connections based on an IP access list\n"
	"IPv6 access list\n")

DEFSH (VTYSH_ALL, vty_login_cmd_vtysh,
	"login",
	"Enable password checking\n")

DEFSH (VTYSH_WATCHFRR, watchfrr_ignore_daemon_cmd_vtysh,
	"[no] watchfrr ignore DAEMON$dname",
	"Negate a command or set its defaults\n"
	"Watchfrr Specific sub-command\n"
	"Ignore a specified daemon when it does not respond to echo request\n"
	"The daemon to ignore\n")

DEFSH (VTYSH_OSPFD, write_multiplier_cmd_vtysh,
	"write-multiplier (1-100)",
	"Write multiplier\n"
	"Maximum number of interface serviced per write\n")

DEFSH (VTYSH_ZEBRA, zebra_dplane_queue_limit_cmd_vtysh,
	"zebra dplane limit (0-10000)",
	"Zebra information\n"
	"Zebra dataplane\n"
	"Limit incoming queued updates\n"
	"Number of queued updates\n")

DEFSH_HIDDEN (VTYSH_MGMTD, zebra_evpn_es_bypass_cmd_vtysh,
	"[no] evpn mh bypass",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Set bypass mode\n")

DEFSH (VTYSH_MGMTD, zebra_evpn_es_id_cmd_vtysh,
	"[no$no] evpn mh es-id ![(1-16777215)$es_lid | NAME$esi_str]",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Ethernet segment identifier\n"
	"local discriminator\n"
	"10-byte ID - 00:AA:BB:CC:DD:EE:FF:GG:HH:II\n")

DEFSH (VTYSH_MGMTD, zebra_evpn_es_pref_cmd_vtysh,
	"[no$no] evpn mh es-df-pref ![(1-65535)$df_pref]",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Preference value used for DF election\n"
	"Preference\n")

DEFSH (VTYSH_MGMTD, zebra_evpn_es_sys_mac_cmd_vtysh,
	"[no$no] evpn mh es-sys-mac ![X:X:X:X:X:X$mac]",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Ethernet segment system MAC\n"
	"MAC address\n")

DEFSH (VTYSH_MGMTD, zebra_evpn_mh_uplink_cmd_vtysh,
	"[no] evpn mh uplink",
	"Negate a command or set its defaults\n"
	"EVPN\n"
	"Multihoming\n"
	"Uplink to the VxLAN core\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, zebra_kernel_netlink_batch_tx_buf_cmd_vtysh,
	"zebra kernel netlink batch-tx-buf (1-1048576) (1-1048576)",
	"Zebra information\n"
	"Zebra kernel interface\n"
	"Set Netlink parameters\n"
	"Set batch buffer size and send threshold\n"
	"Size of the buffer\n"
	"Send threshold\n")

DEFSH (VTYSH_ZEBRA, zebra_nexthop_group_keep_cmd_vtysh,
	"[no] zebra nexthop-group keep (1-3600)",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Nexthop-Group\n"
	"How long to keep\n"
	"Time in seconds from 1-3600\n")

DEFSH (VTYSH_ZEBRA, zebra_on_rib_process_script_cmd_vtysh,
	"zebra on-rib-process script SCRIPT",
	"Zebra information\n"
	"on_rib_process_dplane_results hook call\n"
	"Set a script\n"
	"Script name (same as filename in /etc/frr/scripts/, without .lua)\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, zebra_packet_process_cmd_vtysh,
	"zebra zapi-packets (1-10000)",
	"Zebra information\n"
	"Zapi Protocol\n"
	"Number of packets to process before relinquishing thread\n")

DEFSH (VTYSH_ZEBRA, zebra_protodown_bit_cmd_vtysh,
	"zebra protodown reason-bit (0-31)$bit",
	"Zebra information\n"
	"Protodown Configuration\n"
	"Reason Bit used in the kernel for application\n"
	"Reason Bit range\n")

DEFSH (VTYSH_MGMTD, zebra_route_map_timer_cmd_vtysh,
	"[no] zebra route-map delay-timer ![(0-600)$delay]",
	"Negate a command or set its defaults\n"
	"Zebra information\n"
	"Set route-map parameters\n"
	"Time to wait before route-map updates are processed\n"
	"0 means route-map changes are run immediately instead of delaying\n")

DEFSH (VTYSH_ZEBRA, zebra_show_routing_tables_summary_cmd_vtysh,
	"show zebra router table summary",
	"Show running system information\n"
	"Zebra information\n"
	"The Zebra Router Information\n"
	"Table Information about this Zebra Router\n"
	"Summary Information\n")

DEFSH_HIDDEN (VTYSH_ZEBRA, zebra_workqueue_timer_cmd_vtysh,
	"zebra work-queue (0-10000)",
	"Zebra information\n"
	"Work Queue\n"
	"Time in milliseconds\n")

extern void install_BABEL_NODE(void);
extern void install_BFD_NODE(void);
extern void install_BFD_PEER_NODE(void);
extern void install_BFD_PROFILE_NODE(void);
extern void install_BGP_EVPN_NODE(void);
extern void install_BGP_EVPN_VNI_NODE(void);
extern void install_BGP_FLOWSPECV4_NODE(void);
extern void install_BGP_FLOWSPECV6_NODE(void);
extern void install_BGP_IPV4L_NODE(void);
extern void install_BGP_IPV4M_NODE(void);
extern void install_BGP_IPV4_NODE(void);
extern void install_BGP_IPV6L_NODE(void);
extern void install_BGP_IPV6M_NODE(void);
extern void install_BGP_IPV6_NODE(void);
extern void install_BGP_NODE(void);
extern void install_BGP_SRV6_NODE(void);
extern void install_BGP_VNC_DEFAULTS_NODE(void);
extern void install_BGP_VNC_L2_GROUP_NODE(void);
extern void install_BGP_VNC_NVE_GROUP_NODE(void);
extern void install_BGP_VPNV4_NODE(void);
extern void install_BGP_VPNV6_NODE(void);
extern void install_BGP_VRF_POLICY_NODE(void);
extern void install_BMP_NODE(void);
extern void install_CONFIG_NODE(void);
extern void install_EIGRP_NODE(void);
extern void install_ENABLE_NODE(void);
extern void install_INTERFACE_NODE(void);
extern void install_ISIS_FLEX_ALGO_NODE(void);
extern void install_ISIS_NODE(void);
extern void install_ISIS_SRV6_NODE(void);
extern void install_ISIS_SRV6_NODE_MSD_NODE(void);
extern void install_KEYCHAIN_KEY_NODE(void);
extern void install_KEYCHAIN_NODE(void);
extern void install_LDP_IPV4_IFACE_NODE(void);
extern void install_LDP_IPV4_NODE(void);
extern void install_LDP_IPV6_IFACE_NODE(void);
extern void install_LDP_IPV6_NODE(void);
extern void install_LDP_L2VPN_NODE(void);
extern void install_LDP_NODE(void);
extern void install_LDP_PSEUDOWIRE_NODE(void);
extern void install_LINK_PARAMS_NODE(void);
extern void install_NH_GROUP_NODE(void);
extern void install_OPENFABRIC_NODE(void);
extern void install_OSPF6_NODE(void);
extern void install_OSPF_NODE(void);
extern void install_PBRMAP_NODE(void);
extern void install_PCEP_NODE(void);
extern void install_PCEP_PCC_NODE(void);
extern void install_PCEP_PCE_CONFIG_NODE(void);
extern void install_PCEP_PCE_NODE(void);
extern void install_PIM6_NODE(void);
extern void install_PIM_NODE(void);
extern void install_PW_NODE(void);
extern void install_RIPNG_NODE(void);
extern void install_RIP_NODE(void);
extern void install_RMAP_NODE(void);
extern void install_RPKI_NODE(void);
extern void install_RPKI_VRF_NODE(void);
extern void install_SEGMENT_ROUTING_NODE(void);
extern void install_SRV6_ENCAP_NODE(void);
extern void install_SRV6_LOCS_NODE(void);
extern void install_SRV6_LOC_NODE(void);
extern void install_SRV6_SIDS_NODE(void);
extern void install_SRV6_SID_FORMATS_NODE(void);
extern void install_SRV6_SID_FORMAT_UNCOMPRESSED_F4024_NODE(void);
extern void install_SRV6_SID_FORMAT_USID_F3216_NODE(void);
extern void install_SRV6_SID_FORMAT_USID_F4816_NODE(void);
extern void install_SR_CANDIDATE_DYN_NODE(void);
extern void install_SR_POLICY_NODE(void);
extern void install_SR_SEGMENT_LIST_NODE(void);
extern void install_SR_TRAFFIC_ENG_NODE(void);
extern void install_VIEW_NODE(void);
extern void install_VRF_NODE(void);
extern void install_VTY_NODE(void);

void vtysh_init_cmd(void)
{
	install_BABEL_NODE();
	install_BFD_NODE();
	install_BFD_PEER_NODE();
	install_BFD_PROFILE_NODE();
	install_BGP_EVPN_NODE();
	install_BGP_EVPN_VNI_NODE();
	install_BGP_FLOWSPECV4_NODE();
	install_BGP_FLOWSPECV6_NODE();
	install_BGP_IPV4L_NODE();
	install_BGP_IPV4M_NODE();
	install_BGP_IPV4_NODE();
	install_BGP_IPV6L_NODE();
	install_BGP_IPV6M_NODE();
	install_BGP_IPV6_NODE();
	install_BGP_NODE();
	install_BGP_SRV6_NODE();
	install_BGP_VNC_DEFAULTS_NODE();
	install_BGP_VNC_L2_GROUP_NODE();
	install_BGP_VNC_NVE_GROUP_NODE();
	install_BGP_VPNV4_NODE();
	install_BGP_VPNV6_NODE();
	install_BGP_VRF_POLICY_NODE();
	install_BMP_NODE();
	install_CONFIG_NODE();
	install_EIGRP_NODE();
	install_ENABLE_NODE();
	install_INTERFACE_NODE();
	install_ISIS_FLEX_ALGO_NODE();
	install_ISIS_NODE();
	install_ISIS_SRV6_NODE();
	install_ISIS_SRV6_NODE_MSD_NODE();
	install_KEYCHAIN_KEY_NODE();
	install_KEYCHAIN_NODE();
	install_LDP_IPV4_IFACE_NODE();
	install_LDP_IPV4_NODE();
	install_LDP_IPV6_IFACE_NODE();
	install_LDP_IPV6_NODE();
	install_LDP_L2VPN_NODE();
	install_LDP_NODE();
	install_LDP_PSEUDOWIRE_NODE();
	install_LINK_PARAMS_NODE();
	install_NH_GROUP_NODE();
	install_OPENFABRIC_NODE();
	install_OSPF6_NODE();
	install_OSPF_NODE();
	install_PBRMAP_NODE();
	install_PCEP_NODE();
	install_PCEP_PCC_NODE();
	install_PCEP_PCE_CONFIG_NODE();
	install_PCEP_PCE_NODE();
	install_PIM6_NODE();
	install_PIM_NODE();
	install_PW_NODE();
	install_RIPNG_NODE();
	install_RIP_NODE();
	install_RMAP_NODE();
	install_RPKI_NODE();
	install_RPKI_VRF_NODE();
	install_SEGMENT_ROUTING_NODE();
	install_SRV6_ENCAP_NODE();
	install_SRV6_LOCS_NODE();
	install_SRV6_LOC_NODE();
	install_SRV6_SIDS_NODE();
	install_SRV6_SID_FORMATS_NODE();
	install_SRV6_SID_FORMAT_UNCOMPRESSED_F4024_NODE();
	install_SRV6_SID_FORMAT_USID_F3216_NODE();
	install_SRV6_SID_FORMAT_USID_F4816_NODE();
	install_SR_CANDIDATE_DYN_NODE();
	install_SR_POLICY_NODE();
	install_SR_SEGMENT_LIST_NODE();
	install_SR_TRAFFIC_ENG_NODE();
	install_VIEW_NODE();
	install_VRF_NODE();
	install_VTY_NODE();
}
