/* autogenerated file, DO NOT EDIT! */
#include <zebra.h>

#include "command.h"
#include "linklist.h"

#include "vtysh/vtysh.h"

#pragma GCC visibility push(internal)

#define MAKE_VECTOR(name, len, ...)                        \
        static void * name ## _vitems[] = { __VA_ARGS__ }; \
        static struct _vector name = {                     \
                .active = len,                             \
                .count = len,                              \
                .index = name ## _vitems,                  \
        }

static struct cmd_token ctkn_SRV6_ENCAP_NODE[];
static struct graph_node gn_SRV6_ENCAP_NODE[];

static struct cmd_token ctkn_SRV6_ENCAP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [2] */
		.type = WORD_TKN,
		.text = (char *)"source-address",
		.desc = (char *)"Segment Routing SRv6 source address",
	},
	{ /* [3] */
		.type = FORK_TKN,
		.forkjoin = &gn_SRV6_ENCAP_NODE[5],
	},
	{ /* [4] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Specify source address for SRv6 encapsulation",
		.varname = (char *)"encap_src_addr",
	},
	{ /* [5] */
		.type = JOIN_TKN,
		.forkjoin = &gn_SRV6_ENCAP_NODE[3],
	},
	{ /* [6] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [7] = no_srv6_src_addr_cmd */ },
	{ /* [8] */
		.type = WORD_TKN,
		.text = (char *)"source-address",
		.desc = (char *)"Segment Routing SRv6 source address",
	},
	{ /* [9] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Specify source address for SRv6 encapsulation",
		.varname = (char *)"encap_src_addr",
	},
	{ /* [10] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [11] = srv6_src_addr_cmd */ },
};

extern struct cmd_element no_srv6_src_addr_cmd_vtysh;
extern struct cmd_element srv6_src_addr_cmd_vtysh;

MAKE_VECTOR(gn_SRV6_ENCAP_NODE_0_next, 2, &gn_SRV6_ENCAP_NODE[1], &gn_SRV6_ENCAP_NODE[8]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_1_next, 1, &gn_SRV6_ENCAP_NODE[2]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_1_prev, 1, &gn_SRV6_ENCAP_NODE[0]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_2_next, 1, &gn_SRV6_ENCAP_NODE[3]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_2_prev, 1, &gn_SRV6_ENCAP_NODE[1]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_3_next, 2, &gn_SRV6_ENCAP_NODE[4], &gn_SRV6_ENCAP_NODE[5]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_3_prev, 1, &gn_SRV6_ENCAP_NODE[2]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_4_next, 1, &gn_SRV6_ENCAP_NODE[5]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_4_prev, 1, &gn_SRV6_ENCAP_NODE[3]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_5_next, 1, &gn_SRV6_ENCAP_NODE[6]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_5_prev, 2, &gn_SRV6_ENCAP_NODE[4], &gn_SRV6_ENCAP_NODE[3]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_6_next, 1, &gn_SRV6_ENCAP_NODE[7]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_6_prev, 1, &gn_SRV6_ENCAP_NODE[5]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_7_next, 0, );
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_7_prev, 1, &gn_SRV6_ENCAP_NODE[6]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_8_next, 1, &gn_SRV6_ENCAP_NODE[9]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_8_prev, 1, &gn_SRV6_ENCAP_NODE[0]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_9_next, 1, &gn_SRV6_ENCAP_NODE[10]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_9_prev, 1, &gn_SRV6_ENCAP_NODE[8]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_10_next, 1, &gn_SRV6_ENCAP_NODE[11]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_10_prev, 1, &gn_SRV6_ENCAP_NODE[9]);
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_11_next, 0, );
MAKE_VECTOR(gn_SRV6_ENCAP_NODE_11_prev, 1, &gn_SRV6_ENCAP_NODE[10]);

static struct graph_node gn_SRV6_ENCAP_NODE[] = {
	{
		.from = &gn_SRV6_ENCAP_NODE_0_prev,
		.to = &gn_SRV6_ENCAP_NODE_0_next,
		.data = &ctkn_SRV6_ENCAP_NODE[0],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_1_prev,
		.to = &gn_SRV6_ENCAP_NODE_1_next,
		.data = &ctkn_SRV6_ENCAP_NODE[1],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_2_prev,
		.to = &gn_SRV6_ENCAP_NODE_2_next,
		.data = &ctkn_SRV6_ENCAP_NODE[2],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_3_prev,
		.to = &gn_SRV6_ENCAP_NODE_3_next,
		.data = &ctkn_SRV6_ENCAP_NODE[3],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_4_prev,
		.to = &gn_SRV6_ENCAP_NODE_4_next,
		.data = &ctkn_SRV6_ENCAP_NODE[4],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_5_prev,
		.to = &gn_SRV6_ENCAP_NODE_5_next,
		.data = &ctkn_SRV6_ENCAP_NODE[5],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_6_prev,
		.to = &gn_SRV6_ENCAP_NODE_6_next,
		.data = &ctkn_SRV6_ENCAP_NODE[6],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_7_prev,
		.to = &gn_SRV6_ENCAP_NODE_7_next,
		.data = (void *)&no_srv6_src_addr_cmd_vtysh,
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_8_prev,
		.to = &gn_SRV6_ENCAP_NODE_8_next,
		.data = &ctkn_SRV6_ENCAP_NODE[8],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_9_prev,
		.to = &gn_SRV6_ENCAP_NODE_9_next,
		.data = &ctkn_SRV6_ENCAP_NODE[9],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_10_prev,
		.to = &gn_SRV6_ENCAP_NODE_10_next,
		.data = &ctkn_SRV6_ENCAP_NODE[10],
	},
	{
		.from = &gn_SRV6_ENCAP_NODE_11_prev,
		.to = &gn_SRV6_ENCAP_NODE_11_next,
		.data = (void *)&srv6_src_addr_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_SRV6_ENCAP_NODE, 12, &gn_SRV6_ENCAP_NODE[0], &gn_SRV6_ENCAP_NODE[1], &gn_SRV6_ENCAP_NODE[2], &gn_SRV6_ENCAP_NODE[3], &gn_SRV6_ENCAP_NODE[4], &gn_SRV6_ENCAP_NODE[5], &gn_SRV6_ENCAP_NODE[6], &gn_SRV6_ENCAP_NODE[7], &gn_SRV6_ENCAP_NODE[8], &gn_SRV6_ENCAP_NODE[9], &gn_SRV6_ENCAP_NODE[10], &gn_SRV6_ENCAP_NODE[11]);

extern void install_SRV6_ENCAP_NODE(void);

void install_SRV6_ENCAP_NODE(void)

{
	unsigned node_id = SRV6_ENCAP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_SRV6_ENCAP_NODE;
	vector_set(node->cmd_vector, &no_srv6_src_addr_cmd_vtysh);
	vector_set(node->cmd_vector, &srv6_src_addr_cmd_vtysh);
}

static struct cmd_token ctkn_BGP_IPV4_NODE[];
static struct graph_node gn_BGP_IPV4_NODE[];

static struct cmd_token ctkn_BGP_IPV4_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[1],
	},
	{ /* [4] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[6],
	},
	{ /* [5] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"import",
		.desc = (char *)"Import routes to this address-family",
		.varname = (char *)"direction_str",
	},
	{ /* [6] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[4],
	},
	{ /* [7] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"to/from default instance VPN RIB",
	},
	{ /* [8] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [9] = bgp_imexport_vpn_cmd */ },
	{ /* [10] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"export",
		.desc = (char *)"Export routes from this address-family",
		.varname = (char *)"direction_str",
	},
	{ /* [11] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[13],
	},
	{ /* [12] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Specify route target list",
	},
	{ /* [13] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[11],
	},
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [15] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[17],
	},
	{ /* [16] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"import",
		.desc = (char *)"For routes leaked from vpn to current address-family: match any",
		.varname = (char *)"direction_str",
	},
	{ /* [17] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[15],
	},
	{ /* [18] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)",
		.varname = (char *)"rtlist",
	},
	{ /* [19] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [20] = af_rt_vpn_imexport_cmd */ },
	{ /* [21] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn: set",
		.varname = (char *)"direction_str",
	},
	{ /* [22] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"both",
		.desc = (char *)"both import: match any and export: set",
		.varname = (char *)"direction_str",
	},
	{ /* [23] */
		.type = WORD_TKN,
		.text = (char *)"route-target",
		.desc = (char *)"Specify route target list",
	},
	{ /* [24] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[26],
	},
	{ /* [25] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Specify route target list",
	},
	{ /* [26] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[24],
	},
	{ /* [27] */
		.type = WORD_TKN,
		.text = (char *)"redirect",
		.desc = (char *)"Flow-spec redirect type route target",
	},
	{ /* [28] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import routes to this address-family",
	},
	{ /* [29] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN|IPV6:MN)",
		.varname = (char *)"rtlist",
	},
	{ /* [30] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [31] = af_routetarget_import_cmd */ },
	{ /* [32] */
		.type = WORD_TKN,
		.text = (char *)"route-target",
		.desc = (char *)"Specify route target list",
	},
	{ /* [33] */
		.type = WORD_TKN,
		.text = (char *)"route-target6",
		.desc = (char *)"Specify route target list",
	},
	{ /* [34] */
		.type = WORD_TKN,
		.text = (char *)"rt6",
		.desc = (char *)"Specify route target list",
	},
	{ /* [35] */
		.type = WORD_TKN,
		.text = (char *)"aggregate-address",
		.desc = (char *)"Configure BGP aggregate entries",
	},
	{ /* [36] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[38],
	},
	{ /* [37] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"Aggregate prefix",
		.varname = (char *)"prefix",
	},
	{ /* [38] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[36],
	},
	{ /* [39] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[43],
	},
	{ /* [40] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[42],
	},
	{ /* [41] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"as-set",
		.desc = (char *)"Generate AS set path information",
		.varname = (char *)"as_set_s",
	},
	{ /* [42] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[40],
	},
	{ /* [43] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[39],
	},
	{ /* [44] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [45] = aggregate_addressv4_cmd */ },
	{ /* [46] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"summary-only",
		.desc = (char *)"Filter more specific routes from updates",
		.varname = (char *)"summary_only",
	},
	{ /* [47] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to aggregate network",
	},
	{ /* [48] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Route map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [49] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [50] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[52],
	},
	{ /* [51] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"egp",
		.desc = (char *)"Remote EGP",
		.varname = (char *)"origin_s",
	},
	{ /* [52] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[50],
	},
	{ /* [53] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"igp",
		.desc = (char *)"Local IGP",
		.varname = (char *)"origin_s",
	},
	{ /* [54] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"incomplete",
		.desc = (char *)"Unknown heritage",
		.varname = (char *)"origin_s",
	},
	{ /* [55] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"matching-MED-only",
		.desc = (char *)"Only aggregate routes with matching MED",
		.varname = (char *)"match_med",
	},
	{ /* [56] */
		.type = WORD_TKN,
		.text = (char *)"suppress-map",
		.desc = (char *)"Suppress the selected more specific routes",
	},
	{ /* [57] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Route map with the route selectors",
		.varname = (char *)"suppress_map",
	},
	{ /* [58] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Aggregate address",
		.varname = (char *)"addr",
	},
	{ /* [59] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Aggregate mask",
		.varname = (char *)"mask",
	},
	{ /* [60] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import routes from another VRF",
	},
	{ /* [61] */
		.type = WORD_TKN,
		.text = (char *)"vrf",
		.desc = (char *)"VRF to import from",
	},
	{ /* [62] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"VIEWVRFNAME",
		.desc = (char *)"The name of the VRF",
		.varname = (char *)"import_name",
	},
	{ /* [63] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [64] = bgp_imexport_vrf_cmd */ },
	{ /* [65] */
		.type = WORD_TKN,
		.text = (char *)"label",
		.desc = (char *)"label value for VRF",
	},
	{ /* [66] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [67] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [68] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[70],
	},
	{ /* [69] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-1048575)",
		.desc = (char *)"Label Value <0-1048575>",
		.max = 1048575,
		.varname = (char *)"label_val",
	},
	{ /* [70] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[68],
	},
	{ /* [71] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [72] = af_label_vpn_export_cmd */ },
	{ /* [73] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"auto",
		.desc = (char *)"Automatically assign a label",
		.varname = (char *)"label_auto",
	},
	{ /* [74] */
		.type = WORD_TKN,
		.text = (char *)"allocation-mode",
		.desc = (char *)"Label allocation mode",
	},
	{ /* [75] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[77],
	},
	{ /* [76] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"per-vrf",
		.desc = (char *)"Allocate one label for all BGP updates of the VRF",
		.varname = (char *)"label_per_vrf",
	},
	{ /* [77] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[75],
	},
	{ /* [78] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [79] = af_label_vpn_export_allocation_mode_cmd */ },
	{ /* [80] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"per-nexthop",
		.desc = (char *)"Allocate a label per connected next-hop in the VRF",
		.varname = (char *)"label_per_nh",
	},
	{ /* [81] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [82] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[84],
	},
	{ /* [83] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [84] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[82],
	},
	{ /* [85] */
		.type = WORD_TKN,
		.text = (char *)"advertise-map",
		.desc = (char *)"Route-map to conditionally advertise routes",
	},
	{ /* [86] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of advertise map",
		.varname = (char *)"advertise_str",
	},
	{ /* [87] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[89],
	},
	{ /* [88] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exist-map",
		.desc = (char *)"Advertise routes only if prefixes in exist-map are installed in BGP table",
		.varname = (char *)"exist",
	},
	{ /* [89] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[87],
	},
	{ /* [90] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of the exist or non exist map",
		.varname = (char *)"condition_str",
	},
	{ /* [91] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [92] = neighbor_advertise_map_cmd */ },
	{ /* [93] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"non-exist-map",
		.desc = (char *)"Advertise routes only if prefixes in non-exist-map are not installed in BGP table",
		.varname = (char *)"exist",
	},
	{ /* [94] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [95] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [96] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [97] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [98] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Send RPKI Extended Community attributes",
	},
	{ /* [99] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [100] = neighbor_ecommunity_rpki_cmd */ },
	{ /* [101] */
		.type = WORD_TKN,
		.text = (char *)"network",
		.desc = (char *)"Specify a network to announce via BGP",
	},
	{ /* [102] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[104],
	},
	{ /* [103] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IPv4 prefix",
		.varname = (char *)"prefix",
	},
	{ /* [104] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[102],
	},
	{ /* [105] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[110],
	},
	{ /* [106] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[109],
	},
	{ /* [107] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to modify the attributes",
	},
	{ /* [108] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"map_name",
	},
	{ /* [109] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[106],
	},
	{ /* [110] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[105],
	},
	{ /* [111] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [112] = bgp_network_cmd */ },
	{ /* [113] */
		.type = WORD_TKN,
		.text = (char *)"label-index",
		.desc = (char *)"Label index to associate with the prefix",
	},
	{ /* [114] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-1048560)",
		.desc = (char *)"Label index value",
		.max = 1048560,
		.varname = (char *)"label_index",
	},
	{ /* [115] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"backdoor",
		.desc = (char *)"Specify a BGP backdoor route",
		.varname = (char *)"backdoor",
	},
	{ /* [116] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Network number",
		.varname = (char *)"address",
	},
	{ /* [117] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[120],
	},
	{ /* [118] */
		.type = WORD_TKN,
		.text = (char *)"mask",
		.desc = (char *)"Network mask",
	},
	{ /* [119] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Network mask",
		.varname = (char *)"netmask",
	},
	{ /* [120] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[117],
	},
	{ /* [121] */
		.type = WORD_TKN,
		.text = (char *)"nexthop",
		.desc = (char *)"Specify next hop to use for VRF advertised prefixes",
	},
	{ /* [122] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [123] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [124] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[128],
	},
	{ /* [125] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[127],
	},
	{ /* [126] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IPv4 prefix",
		.varname = (char *)"nexthop_su",
	},
	{ /* [127] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[125],
	},
	{ /* [128] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[124],
	},
	{ /* [129] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [130] = af_nexthop_vpn_export_cmd */ },
	{ /* [131] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 prefix",
		.varname = (char *)"nexthop_su",
	},
	{ /* [132] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Specify route distinguisher",
	},
	{ /* [133] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [134] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [135] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"Route Distinguisher (<as-number>:<number> | <ip-address>:<number>)",
		.varname = (char *)"rd_str",
	},
	{ /* [136] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [137] = af_rd_vpn_export_cmd */ },
	{ /* [138] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Specify route map",
	},
	{ /* [139] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [140] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[142],
	},
	{ /* [141] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"import",
		.desc = (char *)"For routes leaked from vpn to current address-family",
		.varname = (char *)"direction_str",
	},
	{ /* [142] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[140],
	},
	{ /* [143] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP",
		.desc = (char *)"name of route-map",
		.varname = (char *)"rmap_str",
	},
	{ /* [144] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [145] = af_route_map_vpn_imexport_cmd */ },
	{ /* [146] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
		.varname = (char *)"direction_str",
	},
	{ /* [147] */
		.type = WORD_TKN,
		.text = (char *)"sid",
		.desc = (char *)"sid value for VRF",
	},
	{ /* [148] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [149] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [150] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[152],
	},
	{ /* [151] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-1048575)",
		.desc = (char *)"Sid allocation index",
		.min = 1,
		.max = 1048575,
		.varname = (char *)"sid_idx",
	},
	{ /* [152] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[150],
	},
	{ /* [153] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [154] = af_sid_vpn_export_cmd */ },
	{ /* [155] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"auto",
		.desc = (char *)"Automatically assign a label",
		.varname = (char *)"sid_auto",
	},
	{ /* [156] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"explicit",
		.desc = (char *)"Explicitly assign a sid value",
		.varname = (char *)"sid_explicit",
	},
	{ /* [157] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Sid value",
		.varname = (char *)"sid_value",
	},
	{ /* [158] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP Specific commands",
	},
	{ /* [159] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable route-flap dampening",
	},
	{ /* [160] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[167],
	},
	{ /* [161] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"dampening",
	},
	{ /* [162] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[166],
	},
	{ /* [163] */
		.type = RANGE_TKN,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
	},
	{ /* [164] */
		.type = RANGE_TKN,
		.text = (char *)"(1-50000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 50000,
	},
	{ /* [165] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
	},
	{ /* [166] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[162],
	},
	{ /* [167] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[160],
	},
	{ /* [168] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [169] = bgp_damp_set_cmd */ },
	{ /* [170] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Define an administrative distance",
	},
	{ /* [171] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Administrative distance",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [172] */
		.type = IPV4_PREFIX_TKN,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP source prefix",
	},
	{ /* [173] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [174] = bgp_distance_source_cmd */ },
	{ /* [175] */
		.type = VARIABLE_TKN,
		.text = (char *)"WORD",
		.desc = (char *)"Access list name",
	},
	{ /* [176] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [177] = bgp_distance_source_access_list_cmd */ },
	{ /* [178] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP distance",
	},
	{ /* [179] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes external to the AS",
		.min = 1,
		.max = 255,
		.varname = (char *)"bgp",
	},
	{ /* [180] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes internal to the AS",
		.min = 1,
		.max = 255,
	},
	{ /* [181] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for local routes",
		.min = 1,
		.max = 255,
	},
	{ /* [182] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [183] = bgp_distance_cmd */ },
	{ /* [184] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import routes from another VRF",
	},
	{ /* [185] */
		.type = WORD_TKN,
		.text = (char *)"vrf",
		.desc = (char *)"Vrf routes being filtered",
	},
	{ /* [186] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Specify route map",
	},
	{ /* [187] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP",
		.desc = (char *)"name of route-map",
		.varname = (char *)"rmap_str",
	},
	{ /* [188] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [189] = af_import_vrf_route_map_cmd */ },
	{ /* [190] */
		.type = WORD_TKN,
		.text = (char *)"maximum-paths",
		.desc = (char *)"Forward packets over multiple paths",
	},
	{ /* [191] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"maximum_paths",
	},
	{ /* [192] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [193] = bgp_maxpaths_cmd */ },
	{ /* [194] */
		.type = WORD_TKN,
		.text = (char *)"ibgp",
		.desc = (char *)"iBGP-multipath",
	},
	{ /* [195] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"ibgp",
	},
	{ /* [196] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [197] = bgp_maxpaths_ibgp_cmd */ },
	{ /* [198] */
		.type = WORD_TKN,
		.text = (char *)"equal-cluster-length",
		.desc = (char *)"Match the cluster length",
	},
	{ /* [199] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [200] = bgp_maxpaths_ibgp_cluster_cmd */ },
	{ /* [201] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [202] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[204],
	},
	{ /* [203] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [204] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[202],
	},
	{ /* [205] */
		.type = WORD_TKN,
		.text = (char *)"activate",
		.desc = (char *)"Enable the Address Family for this Neighbor",
	},
	{ /* [206] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [207] = neighbor_activate_cmd */ },
	{ /* [208] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [209] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [210] */
		.type = WORD_TKN,
		.text = (char *)"addpath-rx-paths-limit",
		.desc = (char *)"Paths Limit for Addpath to receive from the peer",
	},
	{ /* [211] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Maximum number of paths",
		.min = 1,
		.max = 65535,
		.varname = (char *)"paths_limit",
	},
	{ /* [212] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [213] = neighbor_addpath_paths_limit_cmd */ },
	{ /* [214] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-all-paths",
		.desc = (char *)"Use addpath to advertise all paths to a neighbor",
	},
	{ /* [215] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [216] = neighbor_addpath_tx_all_paths_cmd */ },
	{ /* [217] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-best-selected",
		.desc = (char *)"Use addpath to advertise best selected paths to a neighbor",
	},
	{ /* [218] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-6)",
		.desc = (char *)"The number of best paths",
		.min = 1,
		.max = 6,
		.varname = (char *)"paths",
	},
	{ /* [219] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [220] = neighbor_addpath_tx_best_selected_paths_cmd */ },
	{ /* [221] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-bestpath-per-AS",
		.desc = (char *)"Use addpath to advertise the bestpath per each neighboring AS",
	},
	{ /* [222] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [223] = neighbor_addpath_tx_bestpath_per_as_cmd */ },
	{ /* [224] */
		.type = WORD_TKN,
		.text = (char *)"allowas-in",
		.desc = (char *)"Accept as-path with my AS present in it",
	},
	{ /* [225] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[229],
	},
	{ /* [226] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[228],
	},
	{ /* [227] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of occurrences of AS number",
		.min = 1,
		.max = 10,
		.varname = (char *)"allowas_in",
	},
	{ /* [228] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[226],
	},
	{ /* [229] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[225],
	},
	{ /* [230] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [231] = neighbor_allowas_in_cmd */ },
	{ /* [232] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"Only accept my AS in the as-path if the route was originated in my AS",
	},
	{ /* [233] */
		.type = WORD_TKN,
		.text = (char *)"as-override",
		.desc = (char *)"Override ASNs in outbound updates if aspath equals remote-as",
	},
	{ /* [234] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [235] = neighbor_as_override_cmd */ },
	{ /* [236] */
		.type = WORD_TKN,
		.text = (char *)"attribute-unchanged",
		.desc = (char *)"BGP attribute is propagated unchanged to this neighbor",
	},
	{ /* [237] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[241],
	},
	{ /* [238] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[240],
	},
	{ /* [239] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"As-path attribute",
	},
	{ /* [240] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[238],
	},
	{ /* [241] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[237],
	},
	{ /* [242] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [243] = neighbor_attr_unchanged_cmd */ },
	{ /* [244] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Nexthop attribute",
	},
	{ /* [245] */
		.type = WORD_TKN,
		.text = (char *)"med",
		.desc = (char *)"Med attribute",
	},
	{ /* [246] */
		.type = WORD_TKN,
		.text = (char *)"capability",
		.desc = (char *)"Advertise capability to the peer",
	},
	{ /* [247] */
		.type = WORD_TKN,
		.text = (char *)"orf",
		.desc = (char *)"Advertise ORF capability to the peer",
	},
	{ /* [248] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Advertise prefixlist ORF capability to this neighbor",
	},
	{ /* [249] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[251],
	},
	{ /* [250] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Capability to SEND and RECEIVE the ORF to/from this neighbor",
	},
	{ /* [251] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[249],
	},
	{ /* [252] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [253] = neighbor_capability_orf_prefix_cmd */ },
	{ /* [254] */
		.type = WORD_TKN,
		.text = (char *)"send",
		.desc = (char *)"Capability to RECEIVE the ORF from this neighbor",
	},
	{ /* [255] */
		.type = WORD_TKN,
		.text = (char *)"receive",
		.desc = (char *)"Capability to SEND the ORF to this neighbor",
	},
	{ /* [256] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable neighbor route-flap dampening",
	},
	{ /* [257] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[264],
	},
	{ /* [258] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"half",
	},
	{ /* [259] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[263],
	},
	{ /* [260] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
		.varname = (char *)"reuse",
	},
	{ /* [261] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 20000,
		.varname = (char *)"suppress",
	},
	{ /* [262] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
		.varname = (char *)"max",
	},
	{ /* [263] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[259],
	},
	{ /* [264] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[257],
	},
	{ /* [265] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [266] = neighbor_damp_cmd */ },
	{ /* [267] */
		.type = WORD_TKN,
		.text = (char *)"default-originate",
		.desc = (char *)"Originate default route to this neighbor",
	},
	{ /* [268] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [269] = neighbor_default_originate_cmd */ },
	{ /* [270] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to specify criteria to originate default",
	},
	{ /* [271] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"route-map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [272] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [273] = neighbor_default_originate_rmap_cmd */ },
	{ /* [274] */
		.type = WORD_TKN,
		.text = (char *)"disable-addpath-rx",
		.desc = (char *)"Do not accept additional paths",
	},
	{ /* [275] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [276] = neighbor_disable_addpath_rx_cmd */ },
	{ /* [277] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [278] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist_name",
	},
	{ /* [279] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[281],
	},
	{ /* [280] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [281] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[279],
	},
	{ /* [282] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [283] = neighbor_distribute_list_cmd */ },
	{ /* [284] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [285] */
		.type = WORD_TKN,
		.text = (char *)"filter-list",
		.desc = (char *)"Establish BGP filters",
	},
	{ /* [286] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [287] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[289],
	},
	{ /* [288] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routes",
	},
	{ /* [289] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[287],
	},
	{ /* [290] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [291] = neighbor_filter_list_cmd */ },
	{ /* [292] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routes",
	},
	{ /* [293] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix",
		.desc = (char *)"Maximum number of prefix accept from this peer",
	},
	{ /* [294] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix",
	},
	{ /* [295] */
		.type = RANGE_TKN,
		.text = (char *)"(1-100)",
		.desc = (char *)"Threshold value (%) at which to generate a warning msg",
		.min = 1,
		.max = 100,
	},
	{ /* [296] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[298],
	},
	{ /* [297] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [298] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[296],
	},
	{ /* [299] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [300] = neighbor_maximum_prefix_threshold_cmd */ },
	{ /* [301] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [302] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [303] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[305],
	},
	{ /* [304] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [305] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[303],
	},
	{ /* [306] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [307] = neighbor_maximum_prefix_threshold_restart_cmd */ },
	{ /* [308] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [309] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[311],
	},
	{ /* [310] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [311] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[309],
	},
	{ /* [312] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [313] = neighbor_maximum_prefix_threshold_warning_cmd */ },
	{ /* [314] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[316],
	},
	{ /* [315] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [316] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[314],
	},
	{ /* [317] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [318] = neighbor_maximum_prefix_cmd */ },
	{ /* [319] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [320] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [321] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[323],
	},
	{ /* [322] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [323] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[321],
	},
	{ /* [324] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [325] = neighbor_maximum_prefix_restart_cmd */ },
	{ /* [326] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [327] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[329],
	},
	{ /* [328] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [329] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[327],
	},
	{ /* [330] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [331] = neighbor_maximum_prefix_warning_cmd */ },
	{ /* [332] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix-out",
		.desc = (char *)"Maximum number of prefixes to be sent to this peer",
	},
	{ /* [333] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix_out",
	},
	{ /* [334] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [335] = neighbor_maximum_prefix_out_cmd */ },
	{ /* [336] */
		.type = WORD_TKN,
		.text = (char *)"next-hop-self",
		.desc = (char *)"Disable the next hop calculation for this neighbor",
	},
	{ /* [337] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [338] = neighbor_nexthop_self_cmd */ },
	{ /* [339] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [340] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [341] = neighbor_nexthop_self_all_hidden_cmd */ },
	{ /* [342] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [343] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [344] = neighbor_nexthop_self_force_cmd */ },
	{ /* [345] */
		.type = WORD_TKN,
		.text = (char *)"peer-group",
		.desc = (char *)"Member of the peer-group",
	},
	{ /* [346] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PGNAME",
		.desc = (char *)"Peer-group name",
		.varname = (char *)"pgname",
	},
	{ /* [347] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [348] = neighbor_set_peer_group_hidden_cmd */ },
	{ /* [349] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [350] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of a prefix list",
		.varname = (char *)"prefix_list",
	},
	{ /* [351] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[353],
	},
	{ /* [352] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [353] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[351],
	},
	{ /* [354] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [355] = neighbor_prefix_list_cmd */ },
	{ /* [356] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [357] */
		.type = WORD_TKN,
		.text = (char *)"remove-private-AS",
		.desc = (char *)"Remove private ASNs in outbound updates",
	},
	{ /* [358] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [359] = neighbor_remove_private_as_cmd */ },
	{ /* [360] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Apply to all AS numbers",
	},
	{ /* [361] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [362] = neighbor_remove_private_as_all_cmd */ },
	{ /* [363] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [364] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [365] = neighbor_remove_private_as_all_replace_as_cmd */ },
	{ /* [366] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [367] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [368] = neighbor_remove_private_as_replace_as_cmd */ },
	{ /* [369] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to neighbor",
	},
	{ /* [370] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of route map",
		.varname = (char *)"rmap_name",
	},
	{ /* [371] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[373],
	},
	{ /* [372] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Apply map to incoming routes",
	},
	{ /* [373] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[371],
	},
	{ /* [374] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [375] = neighbor_route_map_cmd */ },
	{ /* [376] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Apply map to outbound routes",
	},
	{ /* [377] */
		.type = WORD_TKN,
		.text = (char *)"route-reflector-client",
		.desc = (char *)"Configure a neighbor as Route Reflector client",
	},
	{ /* [378] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [379] = neighbor_route_reflector_client_cmd */ },
	{ /* [380] */
		.type = WORD_TKN,
		.text = (char *)"route-server-client",
		.desc = (char *)"Configure a neighbor as Route Server client",
	},
	{ /* [381] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [382] = neighbor_route_server_client_cmd */ },
	{ /* [383] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [384] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [385] = neighbor_send_community_cmd */ },
	{ /* [386] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[388],
	},
	{ /* [387] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Send Standard and Extended Community attributes",
	},
	{ /* [388] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[386],
	},
	{ /* [389] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [390] = neighbor_send_community_type_cmd */ },
	{ /* [391] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Send Standard, Large and Extended Community attributes",
	},
	{ /* [392] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [393] */
		.type = WORD_TKN,
		.text = (char *)"standard",
		.desc = (char *)"Send Standard Community attributes",
	},
	{ /* [394] */
		.type = WORD_TKN,
		.text = (char *)"large",
		.desc = (char *)"Send Large Community attributes",
	},
	{ /* [395] */
		.type = WORD_TKN,
		.text = (char *)"soft-reconfiguration",
		.desc = (char *)"Per neighbor soft reconfiguration",
	},
	{ /* [396] */
		.type = WORD_TKN,
		.text = (char *)"inbound",
		.desc = (char *)"Allow inbound soft reconfiguration for this neighbor",
	},
	{ /* [397] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [398] = neighbor_soft_reconfiguration_cmd */ },
	{ /* [399] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Set the Site-of-Origin (SoO) extended community",
	},
	{ /* [400] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"soo",
	},
	{ /* [401] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [402] = neighbor_soo_cmd */ },
	{ /* [403] */
		.type = WORD_TKN,
		.text = (char *)"unsuppress-map",
		.desc = (char *)"Route-map to selectively unsuppress suppressed routes",
	},
	{ /* [404] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of route map",
		.varname = (char *)"unsuppress_map",
	},
	{ /* [405] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [406] = neighbor_unsuppress_map_cmd */ },
	{ /* [407] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"Set default weight for routes from this neighbor",
	},
	{ /* [408] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-65535)",
		.desc = (char *)"default weight",
		.max = 65535,
		.varname = (char *)"weight",
	},
	{ /* [409] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [410] = neighbor_weight_cmd */ },
	{ /* [411] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [412] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[414],
	},
	{ /* [413] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Specify route target list",
	},
	{ /* [414] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[412],
	},
	{ /* [415] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [416] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[418],
	},
	{ /* [417] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"import",
		.desc = (char *)"For routes leaked from vpn to current address-family",
		.varname = (char *)"direction_str",
	},
	{ /* [418] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[416],
	},
	{ /* [419] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [420] = af_no_rt_vpn_imexport_cmd */ },
	{ /* [421] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
		.varname = (char *)"direction_str",
	},
	{ /* [422] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"both",
		.desc = (char *)"both import and export",
		.varname = (char *)"direction_str",
	},
	{ /* [423] */
		.type = WORD_TKN,
		.text = (char *)"route-target",
		.desc = (char *)"Specify route target list",
	},
	{ /* [424] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP Specific commands",
	},
	{ /* [425] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable route-flap dampening",
	},
	{ /* [426] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[433],
	},
	{ /* [427] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"dampening",
	},
	{ /* [428] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[432],
	},
	{ /* [429] */
		.type = RANGE_TKN,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
	},
	{ /* [430] */
		.type = RANGE_TKN,
		.text = (char *)"(1-50000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 50000,
	},
	{ /* [431] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
	},
	{ /* [432] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[428],
	},
	{ /* [433] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[426],
	},
	{ /* [434] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [435] = bgp_damp_unset_cmd */ },
	{ /* [436] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Define an administrative distance",
	},
	{ /* [437] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Administrative distance",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [438] */
		.type = IPV4_PREFIX_TKN,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP source prefix",
	},
	{ /* [439] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [440] = no_bgp_distance_source_cmd */ },
	{ /* [441] */
		.type = VARIABLE_TKN,
		.text = (char *)"WORD",
		.desc = (char *)"Access list name",
	},
	{ /* [442] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [443] = no_bgp_distance_source_access_list_cmd */ },
	{ /* [444] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP distance",
	},
	{ /* [445] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[449],
	},
	{ /* [446] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes external to the AS",
		.min = 1,
		.max = 255,
		.varname = (char *)"bgp",
	},
	{ /* [447] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes internal to the AS",
		.min = 1,
		.max = 255,
	},
	{ /* [448] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for local routes",
		.min = 1,
		.max = 255,
	},
	{ /* [449] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[445],
	},
	{ /* [450] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [451] = no_bgp_distance_cmd */ },
	{ /* [452] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import routes from another VRF",
	},
	{ /* [453] */
		.type = WORD_TKN,
		.text = (char *)"vrf",
		.desc = (char *)"Vrf routes being filtered",
	},
	{ /* [454] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Specify route map",
	},
	{ /* [455] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[457],
	},
	{ /* [456] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP",
		.desc = (char *)"name of route-map",
		.varname = (char *)"rmap_str",
	},
	{ /* [457] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[455],
	},
	{ /* [458] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [459] = af_no_import_vrf_route_map_cmd */ },
	{ /* [460] */
		.type = WORD_TKN,
		.text = (char *)"label",
		.desc = (char *)"label value for VRF",
	},
	{ /* [461] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [462] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [463] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [464] = af_no_label_vpn_export_cmd */ },
	{ /* [465] */
		.type = WORD_TKN,
		.text = (char *)"maximum-paths",
		.desc = (char *)"Forward packets over multiple paths",
	},
	{ /* [466] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[468],
	},
	{ /* [467] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"maximum_paths",
	},
	{ /* [468] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[466],
	},
	{ /* [469] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [470] = no_bgp_maxpaths_cmd */ },
	{ /* [471] */
		.type = WORD_TKN,
		.text = (char *)"ibgp",
		.desc = (char *)"iBGP-multipath",
	},
	{ /* [472] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[477],
	},
	{ /* [473] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"ibgp",
	},
	{ /* [474] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[476],
	},
	{ /* [475] */
		.type = WORD_TKN,
		.text = (char *)"equal-cluster-length",
		.desc = (char *)"Match the cluster length",
	},
	{ /* [476] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[474],
	},
	{ /* [477] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[472],
	},
	{ /* [478] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [479] = no_bgp_maxpaths_ibgp_cmd */ },
	{ /* [480] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [481] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[483],
	},
	{ /* [482] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [483] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[481],
	},
	{ /* [484] */
		.type = WORD_TKN,
		.text = (char *)"activate",
		.desc = (char *)"Enable the Address Family for this Neighbor",
	},
	{ /* [485] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [486] = no_neighbor_activate_cmd */ },
	{ /* [487] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [488] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [489] */
		.type = WORD_TKN,
		.text = (char *)"addpath-rx-paths-limit",
		.desc = (char *)"Paths Limit for Addpath to receive from the peer",
	},
	{ /* [490] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[492],
	},
	{ /* [491] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Maximum number of paths",
		.min = 1,
		.max = 65535,
		.varname = (char *)"addpath_rx_paths_limit",
	},
	{ /* [492] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[490],
	},
	{ /* [493] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [494] = no_neighbor_addpath_paths_limit_cmd */ },
	{ /* [495] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-all-paths",
		.desc = (char *)"Use addpath to advertise all paths to a neighbor",
	},
	{ /* [496] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [497] = no_neighbor_addpath_tx_all_paths_cmd */ },
	{ /* [498] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-best-selected",
		.desc = (char *)"Use addpath to advertise best selected paths to a neighbor",
	},
	{ /* [499] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[501],
	},
	{ /* [500] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-6)",
		.desc = (char *)"The number of best paths",
		.min = 1,
		.max = 6,
		.varname = (char *)"addpath_tx_best_selected",
	},
	{ /* [501] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[499],
	},
	{ /* [502] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [503] = no_neighbor_addpath_tx_best_selected_paths_cmd */ },
	{ /* [504] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-bestpath-per-AS",
		.desc = (char *)"Use addpath to advertise the bestpath per each neighboring AS",
	},
	{ /* [505] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [506] = no_neighbor_addpath_tx_bestpath_per_as_cmd */ },
	{ /* [507] */
		.type = WORD_TKN,
		.text = (char *)"allowas-in",
		.desc = (char *)"allow local ASN appears in aspath attribute",
	},
	{ /* [508] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[512],
	},
	{ /* [509] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[511],
	},
	{ /* [510] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of occurrences of AS number",
		.min = 1,
		.max = 10,
		.varname = (char *)"allowas_in",
	},
	{ /* [511] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[509],
	},
	{ /* [512] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[508],
	},
	{ /* [513] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [514] = no_neighbor_allowas_in_cmd */ },
	{ /* [515] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"Only accept my AS in the as-path if the route was originated in my AS",
	},
	{ /* [516] */
		.type = WORD_TKN,
		.text = (char *)"as-override",
		.desc = (char *)"Override ASNs in outbound updates if aspath equals remote-as",
	},
	{ /* [517] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [518] = no_neighbor_as_override_cmd */ },
	{ /* [519] */
		.type = WORD_TKN,
		.text = (char *)"attribute-unchanged",
		.desc = (char *)"BGP attribute is propagated unchanged to this neighbor",
	},
	{ /* [520] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[524],
	},
	{ /* [521] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[523],
	},
	{ /* [522] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"As-path attribute",
	},
	{ /* [523] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[521],
	},
	{ /* [524] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[520],
	},
	{ /* [525] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [526] = no_neighbor_attr_unchanged_cmd */ },
	{ /* [527] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Nexthop attribute",
	},
	{ /* [528] */
		.type = WORD_TKN,
		.text = (char *)"med",
		.desc = (char *)"Med attribute",
	},
	{ /* [529] */
		.type = WORD_TKN,
		.text = (char *)"capability",
		.desc = (char *)"Advertise capability to the peer",
	},
	{ /* [530] */
		.type = WORD_TKN,
		.text = (char *)"orf",
		.desc = (char *)"Advertise ORF capability to the peer",
	},
	{ /* [531] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Advertise prefixlist ORF capability to this neighbor",
	},
	{ /* [532] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[534],
	},
	{ /* [533] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Capability to SEND and RECEIVE the ORF to/from this neighbor",
	},
	{ /* [534] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[532],
	},
	{ /* [535] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [536] = no_neighbor_capability_orf_prefix_cmd */ },
	{ /* [537] */
		.type = WORD_TKN,
		.text = (char *)"send",
		.desc = (char *)"Capability to RECEIVE the ORF from this neighbor",
	},
	{ /* [538] */
		.type = WORD_TKN,
		.text = (char *)"receive",
		.desc = (char *)"Capability to SEND the ORF to this neighbor",
	},
	{ /* [539] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable neighbor route-flap dampening",
	},
	{ /* [540] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[547],
	},
	{ /* [541] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"HALF",
		.desc = (char *)"Half-life time for the penalty",
		.varname = (char *)"half",
	},
	{ /* [542] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[546],
	},
	{ /* [543] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"REUSE",
		.desc = (char *)"Value to start reusing a route",
		.varname = (char *)"reuse",
	},
	{ /* [544] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SUPPRESS",
		.desc = (char *)"Value to start suppressing a route",
		.varname = (char *)"suppress",
	},
	{ /* [545] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"MAX",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.varname = (char *)"max",
	},
	{ /* [546] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[542],
	},
	{ /* [547] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[540],
	},
	{ /* [548] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [549] = no_neighbor_damp_cmd */ },
	{ /* [550] */
		.type = WORD_TKN,
		.text = (char *)"default-originate",
		.desc = (char *)"Originate default route to this neighbor",
	},
	{ /* [551] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[554],
	},
	{ /* [552] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to specify criteria to originate default",
	},
	{ /* [553] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"route-map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [554] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[551],
	},
	{ /* [555] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [556] = no_neighbor_default_originate_cmd */ },
	{ /* [557] */
		.type = WORD_TKN,
		.text = (char *)"disable-addpath-rx",
		.desc = (char *)"Do not accept additional paths",
	},
	{ /* [558] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [559] = no_neighbor_disable_addpath_rx_cmd */ },
	{ /* [560] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [561] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist_name",
	},
	{ /* [562] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[564],
	},
	{ /* [563] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [564] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[562],
	},
	{ /* [565] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [566] = no_neighbor_distribute_list_cmd */ },
	{ /* [567] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [568] */
		.type = WORD_TKN,
		.text = (char *)"filter-list",
		.desc = (char *)"Establish BGP filters",
	},
	{ /* [569] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [570] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[572],
	},
	{ /* [571] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routes",
	},
	{ /* [572] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[570],
	},
	{ /* [573] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [574] = no_neighbor_filter_list_cmd */ },
	{ /* [575] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routes",
	},
	{ /* [576] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix",
		.desc = (char *)"Maximum number of prefixes to accept from this peer",
	},
	{ /* [577] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[592],
	},
	{ /* [578] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix",
	},
	{ /* [579] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[581],
	},
	{ /* [580] */
		.type = RANGE_TKN,
		.text = (char *)"(1-100)",
		.desc = (char *)"Threshold value (%) at which to generate a warning msg",
		.min = 1,
		.max = 100,
	},
	{ /* [581] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[579],
	},
	{ /* [582] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[585],
	},
	{ /* [583] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [584] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [585] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[582],
	},
	{ /* [586] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[588],
	},
	{ /* [587] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [588] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[586],
	},
	{ /* [589] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[591],
	},
	{ /* [590] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [591] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[589],
	},
	{ /* [592] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[577],
	},
	{ /* [593] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [594] = no_neighbor_maximum_prefix_cmd */ },
	{ /* [595] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix-out",
		.desc = (char *)"Maximum number of prefixes to be sent to this peer",
	},
	{ /* [596] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[598],
	},
	{ /* [597] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix_out",
	},
	{ /* [598] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[596],
	},
	{ /* [599] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [600] = no_neighbor_maximum_prefix_out_cmd */ },
	{ /* [601] */
		.type = WORD_TKN,
		.text = (char *)"next-hop-self",
		.desc = (char *)"Disable the next hop calculation for this neighbor",
	},
	{ /* [602] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [603] = no_neighbor_nexthop_self_cmd */ },
	{ /* [604] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [605] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [606] = no_neighbor_nexthop_self_all_hidden_cmd */ },
	{ /* [607] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [608] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [609] = no_neighbor_nexthop_self_force_cmd */ },
	{ /* [610] */
		.type = WORD_TKN,
		.text = (char *)"peer-group",
		.desc = (char *)"Member of the peer-group",
	},
	{ /* [611] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PGNAME",
		.desc = (char *)"Peer-group name",
		.varname = (char *)"pgname",
	},
	{ /* [612] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [613] = no_neighbor_set_peer_group_hidden_cmd */ },
	{ /* [614] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [615] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of a prefix list",
		.varname = (char *)"prefix_list",
	},
	{ /* [616] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[618],
	},
	{ /* [617] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [618] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[616],
	},
	{ /* [619] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [620] = no_neighbor_prefix_list_cmd */ },
	{ /* [621] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [622] */
		.type = WORD_TKN,
		.text = (char *)"remove-private-AS",
		.desc = (char *)"Remove private ASNs in outbound updates",
	},
	{ /* [623] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [624] = no_neighbor_remove_private_as_cmd */ },
	{ /* [625] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Apply to all AS numbers",
	},
	{ /* [626] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [627] = no_neighbor_remove_private_as_all_cmd */ },
	{ /* [628] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [629] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [630] = no_neighbor_remove_private_as_all_replace_as_cmd */ },
	{ /* [631] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [632] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [633] = no_neighbor_remove_private_as_replace_as_cmd */ },
	{ /* [634] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to neighbor",
	},
	{ /* [635] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of route map",
		.varname = (char *)"rmap_name",
	},
	{ /* [636] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[638],
	},
	{ /* [637] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Apply map to incoming routes",
	},
	{ /* [638] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[636],
	},
	{ /* [639] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [640] = no_neighbor_route_map_cmd */ },
	{ /* [641] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Apply map to outbound routes",
	},
	{ /* [642] */
		.type = WORD_TKN,
		.text = (char *)"route-reflector-client",
		.desc = (char *)"Configure a neighbor as Route Reflector client",
	},
	{ /* [643] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [644] = no_neighbor_route_reflector_client_cmd */ },
	{ /* [645] */
		.type = WORD_TKN,
		.text = (char *)"route-server-client",
		.desc = (char *)"Configure a neighbor as Route Server client",
	},
	{ /* [646] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [647] = no_neighbor_route_server_client_cmd */ },
	{ /* [648] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [649] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [650] = no_neighbor_send_community_cmd */ },
	{ /* [651] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[653],
	},
	{ /* [652] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Send Standard and Extended Community attributes",
	},
	{ /* [653] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[651],
	},
	{ /* [654] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [655] = no_neighbor_send_community_type_cmd */ },
	{ /* [656] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Send Standard, Large and Extended Community attributes",
	},
	{ /* [657] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [658] */
		.type = WORD_TKN,
		.text = (char *)"standard",
		.desc = (char *)"Send Standard Community attributes",
	},
	{ /* [659] */
		.type = WORD_TKN,
		.text = (char *)"large",
		.desc = (char *)"Send Large Community attributes",
	},
	{ /* [660] */
		.type = WORD_TKN,
		.text = (char *)"soft-reconfiguration",
		.desc = (char *)"Per neighbor soft reconfiguration",
	},
	{ /* [661] */
		.type = WORD_TKN,
		.text = (char *)"inbound",
		.desc = (char *)"Allow inbound soft reconfiguration for this neighbor",
	},
	{ /* [662] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [663] = no_neighbor_soft_reconfiguration_cmd */ },
	{ /* [664] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Set the Site-of-Origin (SoO) extended community",
	},
	{ /* [665] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[667],
	},
	{ /* [666] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"soo",
	},
	{ /* [667] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[665],
	},
	{ /* [668] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [669] = no_neighbor_soo_cmd */ },
	{ /* [670] */
		.type = WORD_TKN,
		.text = (char *)"unsuppress-map",
		.desc = (char *)"Route-map to selectively unsuppress suppressed routes",
	},
	{ /* [671] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of route map",
		.varname = (char *)"unsuppress_map",
	},
	{ /* [672] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [673] = no_neighbor_unsuppress_map_cmd */ },
	{ /* [674] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"Set default weight for routes from this neighbor",
	},
	{ /* [675] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[677],
	},
	{ /* [676] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-65535)",
		.desc = (char *)"default weight",
		.max = 65535,
		.varname = (char *)"weight",
	},
	{ /* [677] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[675],
	},
	{ /* [678] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [679] = no_neighbor_weight_cmd */ },
	{ /* [680] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Specify route distinguisher",
	},
	{ /* [681] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [682] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
	},
	{ /* [683] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [684] = af_no_rd_vpn_export_cmd */ },
	{ /* [685] */
		.type = WORD_TKN,
		.text = (char *)"redistribute",
		.desc = (char *)"Redistribute information from another routing protocol",
	},
	{ /* [686] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[688],
	},
	{ /* [687] */
		.type = WORD_TKN,
		.text = (char *)"kernel",
		.desc = (char *)"Kernel routes (not installed via the zebra RIB)",
	},
	{ /* [688] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[686],
	},
	{ /* [689] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[694],
	},
	{ /* [690] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[693],
	},
	{ /* [691] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [692] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [693] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[690],
	},
	{ /* [694] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[689],
	},
	{ /* [695] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [696] = no_bgp_redistribute_ipv4_cmd */ },
	{ /* [697] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [698] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [699] */
		.type = WORD_TKN,
		.text = (char *)"connected",
		.desc = (char *)"Connected routes (directly attached subnet or host)",
	},
	{ /* [700] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Local routes (directly attached host route)",
	},
	{ /* [701] */
		.type = WORD_TKN,
		.text = (char *)"static",
		.desc = (char *)"Statically configured routes",
	},
	{ /* [702] */
		.type = WORD_TKN,
		.text = (char *)"rip",
		.desc = (char *)"Routing Information Protocol (RIP)",
	},
	{ /* [703] */
		.type = WORD_TKN,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
	},
	{ /* [704] */
		.type = WORD_TKN,
		.text = (char *)"isis",
		.desc = (char *)"Intermediate System to Intermediate System (IS-IS)",
	},
	{ /* [705] */
		.type = WORD_TKN,
		.text = (char *)"eigrp",
		.desc = (char *)"Enhanced Interior Gateway Routing Protocol (EIGRP)",
	},
	{ /* [706] */
		.type = WORD_TKN,
		.text = (char *)"nhrp",
		.desc = (char *)"Next Hop Resolution Protocol (NHRP)",
	},
	{ /* [707] */
		.type = WORD_TKN,
		.text = (char *)"vnc",
		.desc = (char *)"Virtual Network Control (VNC)",
	},
	{ /* [708] */
		.type = WORD_TKN,
		.text = (char *)"vnc-direct",
		.desc = (char *)"VNC direct (not via zebra) routes",
	},
	{ /* [709] */
		.type = WORD_TKN,
		.text = (char *)"babel",
		.desc = (char *)"Babel routing protocol (Babel)",
	},
	{ /* [710] */
		.type = WORD_TKN,
		.text = (char *)"openfabric",
		.desc = (char *)"OpenFabric Routing Protocol",
	},
	{ /* [711] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[713],
	},
	{ /* [712] */
		.type = WORD_TKN,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
	},
	{ /* [713] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[711],
	},
	{ /* [714] */
		.type = RANGE_TKN,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Instance ID/Table ID",
		.min = 1,
		.max = 65535,
	},
	{ /* [715] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[720],
	},
	{ /* [716] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[719],
	},
	{ /* [717] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [718] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [719] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[716],
	},
	{ /* [720] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[715],
	},
	{ /* [721] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [722] = no_bgp_redistribute_ipv4_ospf_cmd */ },
	{ /* [723] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [724] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [725] */
		.type = WORD_TKN,
		.text = (char *)"table",
		.desc = (char *)"Non-main Kernel Routing Table",
	},
	{ /* [726] */
		.type = WORD_TKN,
		.text = (char *)"table-direct",
		.desc = (char *)"Non-main Kernel Routing Table - Direct",
	},
	{ /* [727] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Specify route map",
	},
	{ /* [728] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Between current address-family and vpn",
	},
	{ /* [729] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[731],
	},
	{ /* [730] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"import",
		.desc = (char *)"For routes leaked from vpn to current address-family",
		.varname = (char *)"direction_str",
	},
	{ /* [731] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[729],
	},
	{ /* [732] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [733] = af_no_route_map_vpn_imexport_cmd */ },
	{ /* [734] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"export",
		.desc = (char *)"For routes leaked from current address-family to vpn",
		.varname = (char *)"direction_str",
	},
	{ /* [735] */
		.type = WORD_TKN,
		.text = (char *)"table-map",
		.desc = (char *)"BGP table to RIB route download filter",
	},
	{ /* [736] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"table_map",
	},
	{ /* [737] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [738] = no_bgp_table_map_cmd */ },
	{ /* [739] */
		.type = WORD_TKN,
		.text = (char *)"redistribute",
		.desc = (char *)"Redistribute information from another routing protocol",
	},
	{ /* [740] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[742],
	},
	{ /* [741] */
		.type = WORD_TKN,
		.text = (char *)"kernel",
		.desc = (char *)"Kernel routes (not installed via the zebra RIB)",
	},
	{ /* [742] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[740],
	},
	{ /* [743] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [744] = bgp_redistribute_ipv4_cmd */ },
	{ /* [745] */
		.type = WORD_TKN,
		.text = (char *)"connected",
		.desc = (char *)"Connected routes (directly attached subnet or host)",
	},
	{ /* [746] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Local routes (directly attached host route)",
	},
	{ /* [747] */
		.type = WORD_TKN,
		.text = (char *)"static",
		.desc = (char *)"Statically configured routes",
	},
	{ /* [748] */
		.type = WORD_TKN,
		.text = (char *)"rip",
		.desc = (char *)"Routing Information Protocol (RIP)",
	},
	{ /* [749] */
		.type = WORD_TKN,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
	},
	{ /* [750] */
		.type = WORD_TKN,
		.text = (char *)"isis",
		.desc = (char *)"Intermediate System to Intermediate System (IS-IS)",
	},
	{ /* [751] */
		.type = WORD_TKN,
		.text = (char *)"eigrp",
		.desc = (char *)"Enhanced Interior Gateway Routing Protocol (EIGRP)",
	},
	{ /* [752] */
		.type = WORD_TKN,
		.text = (char *)"nhrp",
		.desc = (char *)"Next Hop Resolution Protocol (NHRP)",
	},
	{ /* [753] */
		.type = WORD_TKN,
		.text = (char *)"vnc",
		.desc = (char *)"Virtual Network Control (VNC)",
	},
	{ /* [754] */
		.type = WORD_TKN,
		.text = (char *)"vnc-direct",
		.desc = (char *)"VNC direct (not via zebra) routes",
	},
	{ /* [755] */
		.type = WORD_TKN,
		.text = (char *)"babel",
		.desc = (char *)"Babel routing protocol (Babel)",
	},
	{ /* [756] */
		.type = WORD_TKN,
		.text = (char *)"openfabric",
		.desc = (char *)"OpenFabric Routing Protocol",
	},
	{ /* [757] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [758] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [759] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [760] = bgp_redistribute_ipv4_metric_cmd */ },
	{ /* [761] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [762] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [763] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [764] = bgp_redistribute_ipv4_metric_rmap_cmd */ },
	{ /* [765] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [766] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [767] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [768] = bgp_redistribute_ipv4_rmap_cmd */ },
	{ /* [769] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [770] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [771] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [772] = bgp_redistribute_ipv4_rmap_metric_cmd */ },
	{ /* [773] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[775],
	},
	{ /* [774] */
		.type = WORD_TKN,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
	},
	{ /* [775] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4_NODE[773],
	},
	{ /* [776] */
		.type = RANGE_TKN,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Instance ID/Table ID",
		.min = 1,
		.max = 65535,
	},
	{ /* [777] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [778] = bgp_redistribute_ipv4_ospf_cmd */ },
	{ /* [779] */
		.type = WORD_TKN,
		.text = (char *)"table",
		.desc = (char *)"Non-main Kernel Routing Table",
	},
	{ /* [780] */
		.type = WORD_TKN,
		.text = (char *)"table-direct",
		.desc = (char *)"Non-main Kernel Routing Table - Direct",
	},
	{ /* [781] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [782] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [783] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [784] = bgp_redistribute_ipv4_ospf_metric_cmd */ },
	{ /* [785] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [786] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [787] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [788] = bgp_redistribute_ipv4_ospf_metric_rmap_cmd */ },
	{ /* [789] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [790] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"rmap_name",
	},
	{ /* [791] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [792] = bgp_redistribute_ipv4_ospf_rmap_cmd */ },
	{ /* [793] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric for redistributed routes",
	},
	{ /* [794] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Default metric",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [795] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [796] = bgp_redistribute_ipv4_ospf_rmap_metric_cmd */ },
	{ /* [797] */
		.type = WORD_TKN,
		.text = (char *)"table-map",
		.desc = (char *)"BGP table to RIB route download filter",
	},
	{ /* [798] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"table_map",
	},
	{ /* [799] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [800] = bgp_table_map_cmd */ },
};

extern struct cmd_element af_import_vrf_route_map_cmd_vtysh;
extern struct cmd_element af_label_vpn_export_allocation_mode_cmd_vtysh;
extern struct cmd_element af_label_vpn_export_cmd_vtysh;
extern struct cmd_element af_nexthop_vpn_export_cmd_vtysh;
extern struct cmd_element af_no_import_vrf_route_map_cmd_vtysh;
extern struct cmd_element af_no_label_vpn_export_cmd_vtysh;
extern struct cmd_element af_no_rd_vpn_export_cmd_vtysh;
extern struct cmd_element af_no_route_map_vpn_imexport_cmd_vtysh;
extern struct cmd_element af_no_rt_vpn_imexport_cmd_vtysh;
extern struct cmd_element af_rd_vpn_export_cmd_vtysh;
extern struct cmd_element af_route_map_vpn_imexport_cmd_vtysh;
extern struct cmd_element af_routetarget_import_cmd_vtysh;
extern struct cmd_element af_rt_vpn_imexport_cmd_vtysh;
extern struct cmd_element af_sid_vpn_export_cmd_vtysh;
extern struct cmd_element aggregate_addressv4_cmd_vtysh;
extern struct cmd_element bgp_damp_set_cmd_vtysh;
extern struct cmd_element bgp_damp_unset_cmd_vtysh;
extern struct cmd_element bgp_distance_cmd_vtysh;
extern struct cmd_element bgp_distance_source_access_list_cmd_vtysh;
extern struct cmd_element bgp_distance_source_cmd_vtysh;
extern struct cmd_element bgp_imexport_vpn_cmd_vtysh;
extern struct cmd_element bgp_imexport_vrf_cmd_vtysh;
extern struct cmd_element bgp_maxpaths_cmd_vtysh;
extern struct cmd_element bgp_maxpaths_ibgp_cluster_cmd_vtysh;
extern struct cmd_element bgp_maxpaths_ibgp_cmd_vtysh;
extern struct cmd_element bgp_network_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_metric_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_metric_rmap_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_ospf_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_ospf_metric_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_ospf_metric_rmap_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_ospf_rmap_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_ospf_rmap_metric_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_rmap_cmd_vtysh;
extern struct cmd_element bgp_redistribute_ipv4_rmap_metric_cmd_vtysh;
extern struct cmd_element bgp_table_map_cmd_vtysh;
extern struct cmd_element neighbor_activate_cmd_vtysh;
extern struct cmd_element neighbor_addpath_paths_limit_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_all_paths_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_best_selected_paths_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_bestpath_per_as_cmd_vtysh;
extern struct cmd_element neighbor_advertise_map_cmd_vtysh;
extern struct cmd_element neighbor_allowas_in_cmd_vtysh;
extern struct cmd_element neighbor_as_override_cmd_vtysh;
extern struct cmd_element neighbor_attr_unchanged_cmd_vtysh;
extern struct cmd_element neighbor_capability_orf_prefix_cmd_vtysh;
extern struct cmd_element neighbor_damp_cmd_vtysh;
extern struct cmd_element neighbor_default_originate_cmd_vtysh;
extern struct cmd_element neighbor_default_originate_rmap_cmd_vtysh;
extern struct cmd_element neighbor_disable_addpath_rx_cmd_vtysh;
extern struct cmd_element neighbor_distribute_list_cmd_vtysh;
extern struct cmd_element neighbor_ecommunity_rpki_cmd_vtysh;
extern struct cmd_element neighbor_filter_list_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_out_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_restart_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_restart_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_warning_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_warning_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_all_hidden_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_force_cmd_vtysh;
extern struct cmd_element neighbor_prefix_list_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_all_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_all_replace_as_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_replace_as_cmd_vtysh;
extern struct cmd_element neighbor_route_map_cmd_vtysh;
extern struct cmd_element neighbor_route_reflector_client_cmd_vtysh;
extern struct cmd_element neighbor_route_server_client_cmd_vtysh;
extern struct cmd_element neighbor_send_community_cmd_vtysh;
extern struct cmd_element neighbor_send_community_type_cmd_vtysh;
extern struct cmd_element neighbor_set_peer_group_hidden_cmd_vtysh;
extern struct cmd_element neighbor_soft_reconfiguration_cmd_vtysh;
extern struct cmd_element neighbor_soo_cmd_vtysh;
extern struct cmd_element neighbor_unsuppress_map_cmd_vtysh;
extern struct cmd_element neighbor_weight_cmd_vtysh;
extern struct cmd_element no_bgp_distance_cmd_vtysh;
extern struct cmd_element no_bgp_distance_source_access_list_cmd_vtysh;
extern struct cmd_element no_bgp_distance_source_cmd_vtysh;
extern struct cmd_element no_bgp_maxpaths_cmd_vtysh;
extern struct cmd_element no_bgp_maxpaths_ibgp_cmd_vtysh;
extern struct cmd_element no_bgp_redistribute_ipv4_cmd_vtysh;
extern struct cmd_element no_bgp_redistribute_ipv4_ospf_cmd_vtysh;
extern struct cmd_element no_bgp_table_map_cmd_vtysh;
extern struct cmd_element no_neighbor_activate_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_paths_limit_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_all_paths_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh;
extern struct cmd_element no_neighbor_allowas_in_cmd_vtysh;
extern struct cmd_element no_neighbor_as_override_cmd_vtysh;
extern struct cmd_element no_neighbor_attr_unchanged_cmd_vtysh;
extern struct cmd_element no_neighbor_capability_orf_prefix_cmd_vtysh;
extern struct cmd_element no_neighbor_damp_cmd_vtysh;
extern struct cmd_element no_neighbor_default_originate_cmd_vtysh;
extern struct cmd_element no_neighbor_disable_addpath_rx_cmd_vtysh;
extern struct cmd_element no_neighbor_distribute_list_cmd_vtysh;
extern struct cmd_element no_neighbor_filter_list_cmd_vtysh;
extern struct cmd_element no_neighbor_maximum_prefix_cmd_vtysh;
extern struct cmd_element no_neighbor_maximum_prefix_out_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_all_hidden_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_force_cmd_vtysh;
extern struct cmd_element no_neighbor_prefix_list_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_all_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_all_replace_as_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_replace_as_cmd_vtysh;
extern struct cmd_element no_neighbor_route_map_cmd_vtysh;
extern struct cmd_element no_neighbor_route_reflector_client_cmd_vtysh;
extern struct cmd_element no_neighbor_route_server_client_cmd_vtysh;
extern struct cmd_element no_neighbor_send_community_cmd_vtysh;
extern struct cmd_element no_neighbor_send_community_type_cmd_vtysh;
extern struct cmd_element no_neighbor_set_peer_group_hidden_cmd_vtysh;
extern struct cmd_element no_neighbor_soft_reconfiguration_cmd_vtysh;
extern struct cmd_element no_neighbor_soo_cmd_vtysh;
extern struct cmd_element no_neighbor_unsuppress_map_cmd_vtysh;
extern struct cmd_element no_neighbor_weight_cmd_vtysh;

MAKE_VECTOR(gn_BGP_IPV4_NODE_0_next, 9, &gn_BGP_IPV4_NODE[1], &gn_BGP_IPV4_NODE[158], &gn_BGP_IPV4_NODE[170], &gn_BGP_IPV4_NODE[184], &gn_BGP_IPV4_NODE[190], &gn_BGP_IPV4_NODE[201], &gn_BGP_IPV4_NODE[411], &gn_BGP_IPV4_NODE[739], &gn_BGP_IPV4_NODE[797]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_1_next, 2, &gn_BGP_IPV4_NODE[2], &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_1_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_2_next, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_2_prev, 1, &gn_BGP_IPV4_NODE[1]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_3_next, 12, &gn_BGP_IPV4_NODE[4], &gn_BGP_IPV4_NODE[11], &gn_BGP_IPV4_NODE[24], &gn_BGP_IPV4_NODE[35], &gn_BGP_IPV4_NODE[60], &gn_BGP_IPV4_NODE[65], &gn_BGP_IPV4_NODE[81], &gn_BGP_IPV4_NODE[101], &gn_BGP_IPV4_NODE[121], &gn_BGP_IPV4_NODE[132], &gn_BGP_IPV4_NODE[138], &gn_BGP_IPV4_NODE[147]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_3_prev, 2, &gn_BGP_IPV4_NODE[2], &gn_BGP_IPV4_NODE[1]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_4_next, 2, &gn_BGP_IPV4_NODE[5], &gn_BGP_IPV4_NODE[10]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_4_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_5_next, 1, &gn_BGP_IPV4_NODE[6]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_5_prev, 1, &gn_BGP_IPV4_NODE[4]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_6_next, 1, &gn_BGP_IPV4_NODE[7]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_6_prev, 2, &gn_BGP_IPV4_NODE[5], &gn_BGP_IPV4_NODE[10]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_7_next, 1, &gn_BGP_IPV4_NODE[8]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_7_prev, 1, &gn_BGP_IPV4_NODE[6]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_8_next, 1, &gn_BGP_IPV4_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_8_prev, 1, &gn_BGP_IPV4_NODE[7]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_9_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_9_prev, 1, &gn_BGP_IPV4_NODE[8]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_10_next, 1, &gn_BGP_IPV4_NODE[6]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_10_prev, 1, &gn_BGP_IPV4_NODE[4]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_11_next, 2, &gn_BGP_IPV4_NODE[12], &gn_BGP_IPV4_NODE[23]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_11_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_12_next, 1, &gn_BGP_IPV4_NODE[13]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_12_prev, 1, &gn_BGP_IPV4_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_13_next, 1, &gn_BGP_IPV4_NODE[14]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_13_prev, 2, &gn_BGP_IPV4_NODE[12], &gn_BGP_IPV4_NODE[23]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_14_next, 1, &gn_BGP_IPV4_NODE[15]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_14_prev, 1, &gn_BGP_IPV4_NODE[13]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_15_next, 3, &gn_BGP_IPV4_NODE[16], &gn_BGP_IPV4_NODE[21], &gn_BGP_IPV4_NODE[22]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_15_prev, 1, &gn_BGP_IPV4_NODE[14]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_16_next, 1, &gn_BGP_IPV4_NODE[17]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_16_prev, 1, &gn_BGP_IPV4_NODE[15]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_17_next, 1, &gn_BGP_IPV4_NODE[18]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_17_prev, 3, &gn_BGP_IPV4_NODE[16], &gn_BGP_IPV4_NODE[21], &gn_BGP_IPV4_NODE[22]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_18_next, 2, &gn_BGP_IPV4_NODE[18], &gn_BGP_IPV4_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_18_prev, 2, &gn_BGP_IPV4_NODE[17], &gn_BGP_IPV4_NODE[18]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_19_next, 1, &gn_BGP_IPV4_NODE[20]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_19_prev, 1, &gn_BGP_IPV4_NODE[18]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_20_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_20_prev, 1, &gn_BGP_IPV4_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_21_next, 1, &gn_BGP_IPV4_NODE[17]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_21_prev, 1, &gn_BGP_IPV4_NODE[15]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_22_next, 1, &gn_BGP_IPV4_NODE[17]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_22_prev, 1, &gn_BGP_IPV4_NODE[15]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_23_next, 1, &gn_BGP_IPV4_NODE[13]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_23_prev, 1, &gn_BGP_IPV4_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_24_next, 4, &gn_BGP_IPV4_NODE[25], &gn_BGP_IPV4_NODE[32], &gn_BGP_IPV4_NODE[33], &gn_BGP_IPV4_NODE[34]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_24_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_25_next, 1, &gn_BGP_IPV4_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_25_prev, 1, &gn_BGP_IPV4_NODE[24]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_26_next, 1, &gn_BGP_IPV4_NODE[27]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_26_prev, 4, &gn_BGP_IPV4_NODE[25], &gn_BGP_IPV4_NODE[32], &gn_BGP_IPV4_NODE[33], &gn_BGP_IPV4_NODE[34]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_27_next, 1, &gn_BGP_IPV4_NODE[28]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_27_prev, 1, &gn_BGP_IPV4_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_28_next, 1, &gn_BGP_IPV4_NODE[29]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_28_prev, 1, &gn_BGP_IPV4_NODE[27]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_29_next, 2, &gn_BGP_IPV4_NODE[29], &gn_BGP_IPV4_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_29_prev, 2, &gn_BGP_IPV4_NODE[28], &gn_BGP_IPV4_NODE[29]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_30_next, 1, &gn_BGP_IPV4_NODE[31]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_30_prev, 1, &gn_BGP_IPV4_NODE[29]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_31_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_31_prev, 1, &gn_BGP_IPV4_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_32_next, 1, &gn_BGP_IPV4_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_32_prev, 1, &gn_BGP_IPV4_NODE[24]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_33_next, 1, &gn_BGP_IPV4_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_33_prev, 1, &gn_BGP_IPV4_NODE[24]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_34_next, 1, &gn_BGP_IPV4_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_34_prev, 1, &gn_BGP_IPV4_NODE[24]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_35_next, 1, &gn_BGP_IPV4_NODE[36]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_35_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_36_next, 2, &gn_BGP_IPV4_NODE[37], &gn_BGP_IPV4_NODE[58]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_36_prev, 1, &gn_BGP_IPV4_NODE[35]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_37_next, 1, &gn_BGP_IPV4_NODE[38]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_37_prev, 1, &gn_BGP_IPV4_NODE[36]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_38_next, 1, &gn_BGP_IPV4_NODE[39]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_38_prev, 2, &gn_BGP_IPV4_NODE[37], &gn_BGP_IPV4_NODE[59]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_39_next, 2, &gn_BGP_IPV4_NODE[40], &gn_BGP_IPV4_NODE[43]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_39_prev, 1, &gn_BGP_IPV4_NODE[38]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_40_next, 6, &gn_BGP_IPV4_NODE[41], &gn_BGP_IPV4_NODE[46], &gn_BGP_IPV4_NODE[47], &gn_BGP_IPV4_NODE[49], &gn_BGP_IPV4_NODE[55], &gn_BGP_IPV4_NODE[56]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_40_prev, 2, &gn_BGP_IPV4_NODE[42], &gn_BGP_IPV4_NODE[39]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_41_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_41_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_42_next, 2, &gn_BGP_IPV4_NODE[40], &gn_BGP_IPV4_NODE[43]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_42_prev, 6, &gn_BGP_IPV4_NODE[41], &gn_BGP_IPV4_NODE[46], &gn_BGP_IPV4_NODE[48], &gn_BGP_IPV4_NODE[52], &gn_BGP_IPV4_NODE[55], &gn_BGP_IPV4_NODE[57]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_43_next, 1, &gn_BGP_IPV4_NODE[44]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_43_prev, 2, &gn_BGP_IPV4_NODE[42], &gn_BGP_IPV4_NODE[39]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_44_next, 1, &gn_BGP_IPV4_NODE[45]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_44_prev, 1, &gn_BGP_IPV4_NODE[43]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_45_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_45_prev, 1, &gn_BGP_IPV4_NODE[44]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_46_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_46_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_47_next, 1, &gn_BGP_IPV4_NODE[48]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_47_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_48_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_48_prev, 1, &gn_BGP_IPV4_NODE[47]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_49_next, 1, &gn_BGP_IPV4_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_49_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_50_next, 3, &gn_BGP_IPV4_NODE[51], &gn_BGP_IPV4_NODE[53], &gn_BGP_IPV4_NODE[54]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_50_prev, 1, &gn_BGP_IPV4_NODE[49]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_51_next, 1, &gn_BGP_IPV4_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_51_prev, 1, &gn_BGP_IPV4_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_52_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_52_prev, 3, &gn_BGP_IPV4_NODE[51], &gn_BGP_IPV4_NODE[53], &gn_BGP_IPV4_NODE[54]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_53_next, 1, &gn_BGP_IPV4_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_53_prev, 1, &gn_BGP_IPV4_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_54_next, 1, &gn_BGP_IPV4_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_54_prev, 1, &gn_BGP_IPV4_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_55_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_55_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_56_next, 1, &gn_BGP_IPV4_NODE[57]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_56_prev, 1, &gn_BGP_IPV4_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_57_next, 1, &gn_BGP_IPV4_NODE[42]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_57_prev, 1, &gn_BGP_IPV4_NODE[56]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_58_next, 1, &gn_BGP_IPV4_NODE[59]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_58_prev, 1, &gn_BGP_IPV4_NODE[36]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_59_next, 1, &gn_BGP_IPV4_NODE[38]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_59_prev, 1, &gn_BGP_IPV4_NODE[58]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_60_next, 1, &gn_BGP_IPV4_NODE[61]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_60_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_61_next, 1, &gn_BGP_IPV4_NODE[62]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_61_prev, 1, &gn_BGP_IPV4_NODE[60]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_62_next, 1, &gn_BGP_IPV4_NODE[63]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_62_prev, 1, &gn_BGP_IPV4_NODE[61]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_63_next, 1, &gn_BGP_IPV4_NODE[64]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_63_prev, 1, &gn_BGP_IPV4_NODE[62]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_64_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_64_prev, 1, &gn_BGP_IPV4_NODE[63]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_65_next, 1, &gn_BGP_IPV4_NODE[66]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_65_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_66_next, 1, &gn_BGP_IPV4_NODE[67]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_66_prev, 1, &gn_BGP_IPV4_NODE[65]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_67_next, 2, &gn_BGP_IPV4_NODE[68], &gn_BGP_IPV4_NODE[74]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_67_prev, 1, &gn_BGP_IPV4_NODE[66]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_68_next, 2, &gn_BGP_IPV4_NODE[69], &gn_BGP_IPV4_NODE[73]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_68_prev, 1, &gn_BGP_IPV4_NODE[67]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_69_next, 1, &gn_BGP_IPV4_NODE[70]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_69_prev, 1, &gn_BGP_IPV4_NODE[68]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_70_next, 1, &gn_BGP_IPV4_NODE[71]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_70_prev, 2, &gn_BGP_IPV4_NODE[69], &gn_BGP_IPV4_NODE[73]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_71_next, 1, &gn_BGP_IPV4_NODE[72]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_71_prev, 1, &gn_BGP_IPV4_NODE[70]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_72_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_72_prev, 1, &gn_BGP_IPV4_NODE[71]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_73_next, 1, &gn_BGP_IPV4_NODE[70]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_73_prev, 1, &gn_BGP_IPV4_NODE[68]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_74_next, 1, &gn_BGP_IPV4_NODE[75]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_74_prev, 1, &gn_BGP_IPV4_NODE[67]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_75_next, 2, &gn_BGP_IPV4_NODE[76], &gn_BGP_IPV4_NODE[80]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_75_prev, 1, &gn_BGP_IPV4_NODE[74]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_76_next, 1, &gn_BGP_IPV4_NODE[77]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_76_prev, 1, &gn_BGP_IPV4_NODE[75]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_77_next, 1, &gn_BGP_IPV4_NODE[78]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_77_prev, 2, &gn_BGP_IPV4_NODE[76], &gn_BGP_IPV4_NODE[80]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_78_next, 1, &gn_BGP_IPV4_NODE[79]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_78_prev, 1, &gn_BGP_IPV4_NODE[77]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_79_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_79_prev, 1, &gn_BGP_IPV4_NODE[78]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_80_next, 1, &gn_BGP_IPV4_NODE[77]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_80_prev, 1, &gn_BGP_IPV4_NODE[75]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_81_next, 1, &gn_BGP_IPV4_NODE[82]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_81_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_82_next, 3, &gn_BGP_IPV4_NODE[83], &gn_BGP_IPV4_NODE[94], &gn_BGP_IPV4_NODE[95]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_82_prev, 1, &gn_BGP_IPV4_NODE[81]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_83_next, 1, &gn_BGP_IPV4_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_83_prev, 1, &gn_BGP_IPV4_NODE[82]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_84_next, 2, &gn_BGP_IPV4_NODE[85], &gn_BGP_IPV4_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_84_prev, 3, &gn_BGP_IPV4_NODE[83], &gn_BGP_IPV4_NODE[94], &gn_BGP_IPV4_NODE[95]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_85_next, 1, &gn_BGP_IPV4_NODE[86]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_85_prev, 1, &gn_BGP_IPV4_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_86_next, 1, &gn_BGP_IPV4_NODE[87]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_86_prev, 1, &gn_BGP_IPV4_NODE[85]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_87_next, 2, &gn_BGP_IPV4_NODE[88], &gn_BGP_IPV4_NODE[93]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_87_prev, 1, &gn_BGP_IPV4_NODE[86]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_88_next, 1, &gn_BGP_IPV4_NODE[89]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_88_prev, 1, &gn_BGP_IPV4_NODE[87]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_89_next, 1, &gn_BGP_IPV4_NODE[90]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_89_prev, 2, &gn_BGP_IPV4_NODE[88], &gn_BGP_IPV4_NODE[93]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_90_next, 1, &gn_BGP_IPV4_NODE[91]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_90_prev, 1, &gn_BGP_IPV4_NODE[89]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_91_next, 1, &gn_BGP_IPV4_NODE[92]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_91_prev, 1, &gn_BGP_IPV4_NODE[90]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_92_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_92_prev, 1, &gn_BGP_IPV4_NODE[91]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_93_next, 1, &gn_BGP_IPV4_NODE[89]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_93_prev, 1, &gn_BGP_IPV4_NODE[87]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_94_next, 1, &gn_BGP_IPV4_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_94_prev, 1, &gn_BGP_IPV4_NODE[82]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_95_next, 1, &gn_BGP_IPV4_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_95_prev, 1, &gn_BGP_IPV4_NODE[82]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_96_next, 1, &gn_BGP_IPV4_NODE[97]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_96_prev, 1, &gn_BGP_IPV4_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_97_next, 1, &gn_BGP_IPV4_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_97_prev, 1, &gn_BGP_IPV4_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_98_next, 1, &gn_BGP_IPV4_NODE[99]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_98_prev, 1, &gn_BGP_IPV4_NODE[97]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_99_next, 1, &gn_BGP_IPV4_NODE[100]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_99_prev, 1, &gn_BGP_IPV4_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_100_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_100_prev, 1, &gn_BGP_IPV4_NODE[99]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_101_next, 1, &gn_BGP_IPV4_NODE[102]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_101_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_102_next, 2, &gn_BGP_IPV4_NODE[103], &gn_BGP_IPV4_NODE[116]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_102_prev, 1, &gn_BGP_IPV4_NODE[101]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_103_next, 1, &gn_BGP_IPV4_NODE[104]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_103_prev, 1, &gn_BGP_IPV4_NODE[102]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_104_next, 1, &gn_BGP_IPV4_NODE[105]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_104_prev, 2, &gn_BGP_IPV4_NODE[103], &gn_BGP_IPV4_NODE[120]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_105_next, 2, &gn_BGP_IPV4_NODE[106], &gn_BGP_IPV4_NODE[110]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_105_prev, 1, &gn_BGP_IPV4_NODE[104]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_106_next, 3, &gn_BGP_IPV4_NODE[107], &gn_BGP_IPV4_NODE[113], &gn_BGP_IPV4_NODE[115]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_106_prev, 2, &gn_BGP_IPV4_NODE[109], &gn_BGP_IPV4_NODE[105]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_107_next, 1, &gn_BGP_IPV4_NODE[108]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_107_prev, 1, &gn_BGP_IPV4_NODE[106]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_108_next, 1, &gn_BGP_IPV4_NODE[109]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_108_prev, 1, &gn_BGP_IPV4_NODE[107]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_109_next, 2, &gn_BGP_IPV4_NODE[106], &gn_BGP_IPV4_NODE[110]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_109_prev, 3, &gn_BGP_IPV4_NODE[108], &gn_BGP_IPV4_NODE[114], &gn_BGP_IPV4_NODE[115]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_110_next, 1, &gn_BGP_IPV4_NODE[111]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_110_prev, 2, &gn_BGP_IPV4_NODE[109], &gn_BGP_IPV4_NODE[105]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_111_next, 1, &gn_BGP_IPV4_NODE[112]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_111_prev, 1, &gn_BGP_IPV4_NODE[110]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_112_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_112_prev, 1, &gn_BGP_IPV4_NODE[111]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_113_next, 1, &gn_BGP_IPV4_NODE[114]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_113_prev, 1, &gn_BGP_IPV4_NODE[106]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_114_next, 1, &gn_BGP_IPV4_NODE[109]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_114_prev, 1, &gn_BGP_IPV4_NODE[113]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_115_next, 1, &gn_BGP_IPV4_NODE[109]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_115_prev, 1, &gn_BGP_IPV4_NODE[106]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_116_next, 1, &gn_BGP_IPV4_NODE[117]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_116_prev, 1, &gn_BGP_IPV4_NODE[102]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_117_next, 2, &gn_BGP_IPV4_NODE[118], &gn_BGP_IPV4_NODE[120]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_117_prev, 1, &gn_BGP_IPV4_NODE[116]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_118_next, 1, &gn_BGP_IPV4_NODE[119]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_118_prev, 1, &gn_BGP_IPV4_NODE[117]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_119_next, 1, &gn_BGP_IPV4_NODE[120]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_119_prev, 1, &gn_BGP_IPV4_NODE[118]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_120_next, 1, &gn_BGP_IPV4_NODE[104]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_120_prev, 2, &gn_BGP_IPV4_NODE[119], &gn_BGP_IPV4_NODE[117]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_121_next, 1, &gn_BGP_IPV4_NODE[122]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_121_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_122_next, 1, &gn_BGP_IPV4_NODE[123]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_122_prev, 1, &gn_BGP_IPV4_NODE[121]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_123_next, 1, &gn_BGP_IPV4_NODE[124]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_123_prev, 1, &gn_BGP_IPV4_NODE[122]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_124_next, 2, &gn_BGP_IPV4_NODE[125], &gn_BGP_IPV4_NODE[128]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_124_prev, 1, &gn_BGP_IPV4_NODE[123]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_125_next, 2, &gn_BGP_IPV4_NODE[126], &gn_BGP_IPV4_NODE[131]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_125_prev, 1, &gn_BGP_IPV4_NODE[124]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_126_next, 1, &gn_BGP_IPV4_NODE[127]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_126_prev, 1, &gn_BGP_IPV4_NODE[125]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_127_next, 1, &gn_BGP_IPV4_NODE[128]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_127_prev, 2, &gn_BGP_IPV4_NODE[126], &gn_BGP_IPV4_NODE[131]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_128_next, 1, &gn_BGP_IPV4_NODE[129]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_128_prev, 2, &gn_BGP_IPV4_NODE[127], &gn_BGP_IPV4_NODE[124]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_129_next, 1, &gn_BGP_IPV4_NODE[130]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_129_prev, 1, &gn_BGP_IPV4_NODE[128]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_130_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_130_prev, 1, &gn_BGP_IPV4_NODE[129]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_131_next, 1, &gn_BGP_IPV4_NODE[127]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_131_prev, 1, &gn_BGP_IPV4_NODE[125]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_132_next, 1, &gn_BGP_IPV4_NODE[133]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_132_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_133_next, 1, &gn_BGP_IPV4_NODE[134]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_133_prev, 1, &gn_BGP_IPV4_NODE[132]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_134_next, 1, &gn_BGP_IPV4_NODE[135]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_134_prev, 1, &gn_BGP_IPV4_NODE[133]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_135_next, 1, &gn_BGP_IPV4_NODE[136]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_135_prev, 1, &gn_BGP_IPV4_NODE[134]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_136_next, 1, &gn_BGP_IPV4_NODE[137]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_136_prev, 1, &gn_BGP_IPV4_NODE[135]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_137_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_137_prev, 1, &gn_BGP_IPV4_NODE[136]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_138_next, 1, &gn_BGP_IPV4_NODE[139]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_138_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_139_next, 1, &gn_BGP_IPV4_NODE[140]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_139_prev, 1, &gn_BGP_IPV4_NODE[138]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_140_next, 2, &gn_BGP_IPV4_NODE[141], &gn_BGP_IPV4_NODE[146]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_140_prev, 1, &gn_BGP_IPV4_NODE[139]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_141_next, 1, &gn_BGP_IPV4_NODE[142]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_141_prev, 1, &gn_BGP_IPV4_NODE[140]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_142_next, 1, &gn_BGP_IPV4_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_142_prev, 2, &gn_BGP_IPV4_NODE[141], &gn_BGP_IPV4_NODE[146]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_143_next, 1, &gn_BGP_IPV4_NODE[144]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_143_prev, 1, &gn_BGP_IPV4_NODE[142]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_144_next, 1, &gn_BGP_IPV4_NODE[145]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_144_prev, 1, &gn_BGP_IPV4_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_145_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_145_prev, 1, &gn_BGP_IPV4_NODE[144]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_146_next, 1, &gn_BGP_IPV4_NODE[142]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_146_prev, 1, &gn_BGP_IPV4_NODE[140]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_147_next, 1, &gn_BGP_IPV4_NODE[148]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_147_prev, 1, &gn_BGP_IPV4_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_148_next, 1, &gn_BGP_IPV4_NODE[149]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_148_prev, 1, &gn_BGP_IPV4_NODE[147]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_149_next, 1, &gn_BGP_IPV4_NODE[150]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_149_prev, 1, &gn_BGP_IPV4_NODE[148]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_150_next, 3, &gn_BGP_IPV4_NODE[151], &gn_BGP_IPV4_NODE[155], &gn_BGP_IPV4_NODE[156]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_150_prev, 1, &gn_BGP_IPV4_NODE[149]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_151_next, 1, &gn_BGP_IPV4_NODE[152]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_151_prev, 1, &gn_BGP_IPV4_NODE[150]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_152_next, 1, &gn_BGP_IPV4_NODE[153]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_152_prev, 3, &gn_BGP_IPV4_NODE[151], &gn_BGP_IPV4_NODE[155], &gn_BGP_IPV4_NODE[157]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_153_next, 1, &gn_BGP_IPV4_NODE[154]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_153_prev, 1, &gn_BGP_IPV4_NODE[152]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_154_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_154_prev, 1, &gn_BGP_IPV4_NODE[153]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_155_next, 1, &gn_BGP_IPV4_NODE[152]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_155_prev, 1, &gn_BGP_IPV4_NODE[150]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_156_next, 1, &gn_BGP_IPV4_NODE[157]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_156_prev, 1, &gn_BGP_IPV4_NODE[150]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_157_next, 1, &gn_BGP_IPV4_NODE[152]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_157_prev, 1, &gn_BGP_IPV4_NODE[156]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_158_next, 1, &gn_BGP_IPV4_NODE[159]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_158_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_159_next, 1, &gn_BGP_IPV4_NODE[160]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_159_prev, 1, &gn_BGP_IPV4_NODE[158]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_160_next, 2, &gn_BGP_IPV4_NODE[161], &gn_BGP_IPV4_NODE[167]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_160_prev, 1, &gn_BGP_IPV4_NODE[159]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_161_next, 1, &gn_BGP_IPV4_NODE[162]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_161_prev, 1, &gn_BGP_IPV4_NODE[160]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_162_next, 2, &gn_BGP_IPV4_NODE[163], &gn_BGP_IPV4_NODE[166]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_162_prev, 1, &gn_BGP_IPV4_NODE[161]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_163_next, 1, &gn_BGP_IPV4_NODE[164]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_163_prev, 1, &gn_BGP_IPV4_NODE[162]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_164_next, 1, &gn_BGP_IPV4_NODE[165]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_164_prev, 1, &gn_BGP_IPV4_NODE[163]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_165_next, 1, &gn_BGP_IPV4_NODE[166]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_165_prev, 1, &gn_BGP_IPV4_NODE[164]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_166_next, 1, &gn_BGP_IPV4_NODE[167]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_166_prev, 2, &gn_BGP_IPV4_NODE[165], &gn_BGP_IPV4_NODE[162]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_167_next, 1, &gn_BGP_IPV4_NODE[168]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_167_prev, 2, &gn_BGP_IPV4_NODE[166], &gn_BGP_IPV4_NODE[160]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_168_next, 1, &gn_BGP_IPV4_NODE[169]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_168_prev, 1, &gn_BGP_IPV4_NODE[167]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_169_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_169_prev, 1, &gn_BGP_IPV4_NODE[168]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_170_next, 2, &gn_BGP_IPV4_NODE[171], &gn_BGP_IPV4_NODE[178]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_170_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_171_next, 1, &gn_BGP_IPV4_NODE[172]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_171_prev, 1, &gn_BGP_IPV4_NODE[170]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_172_next, 2, &gn_BGP_IPV4_NODE[173], &gn_BGP_IPV4_NODE[175]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_172_prev, 1, &gn_BGP_IPV4_NODE[171]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_173_next, 1, &gn_BGP_IPV4_NODE[174]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_173_prev, 1, &gn_BGP_IPV4_NODE[172]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_174_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_174_prev, 1, &gn_BGP_IPV4_NODE[173]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_175_next, 1, &gn_BGP_IPV4_NODE[176]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_175_prev, 1, &gn_BGP_IPV4_NODE[172]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_176_next, 1, &gn_BGP_IPV4_NODE[177]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_176_prev, 1, &gn_BGP_IPV4_NODE[175]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_177_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_177_prev, 1, &gn_BGP_IPV4_NODE[176]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_178_next, 1, &gn_BGP_IPV4_NODE[179]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_178_prev, 1, &gn_BGP_IPV4_NODE[170]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_179_next, 1, &gn_BGP_IPV4_NODE[180]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_179_prev, 1, &gn_BGP_IPV4_NODE[178]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_180_next, 1, &gn_BGP_IPV4_NODE[181]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_180_prev, 1, &gn_BGP_IPV4_NODE[179]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_181_next, 1, &gn_BGP_IPV4_NODE[182]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_181_prev, 1, &gn_BGP_IPV4_NODE[180]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_182_next, 1, &gn_BGP_IPV4_NODE[183]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_182_prev, 1, &gn_BGP_IPV4_NODE[181]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_183_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_183_prev, 1, &gn_BGP_IPV4_NODE[182]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_184_next, 1, &gn_BGP_IPV4_NODE[185]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_184_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_185_next, 1, &gn_BGP_IPV4_NODE[186]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_185_prev, 1, &gn_BGP_IPV4_NODE[184]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_186_next, 1, &gn_BGP_IPV4_NODE[187]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_186_prev, 1, &gn_BGP_IPV4_NODE[185]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_187_next, 1, &gn_BGP_IPV4_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_187_prev, 1, &gn_BGP_IPV4_NODE[186]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_188_next, 1, &gn_BGP_IPV4_NODE[189]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_188_prev, 1, &gn_BGP_IPV4_NODE[187]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_189_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_189_prev, 1, &gn_BGP_IPV4_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_190_next, 2, &gn_BGP_IPV4_NODE[191], &gn_BGP_IPV4_NODE[194]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_190_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_191_next, 1, &gn_BGP_IPV4_NODE[192]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_191_prev, 1, &gn_BGP_IPV4_NODE[190]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_192_next, 1, &gn_BGP_IPV4_NODE[193]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_192_prev, 1, &gn_BGP_IPV4_NODE[191]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_193_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_193_prev, 1, &gn_BGP_IPV4_NODE[192]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_194_next, 1, &gn_BGP_IPV4_NODE[195]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_194_prev, 1, &gn_BGP_IPV4_NODE[190]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_195_next, 2, &gn_BGP_IPV4_NODE[196], &gn_BGP_IPV4_NODE[198]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_195_prev, 1, &gn_BGP_IPV4_NODE[194]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_196_next, 1, &gn_BGP_IPV4_NODE[197]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_196_prev, 1, &gn_BGP_IPV4_NODE[195]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_197_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_197_prev, 1, &gn_BGP_IPV4_NODE[196]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_198_next, 1, &gn_BGP_IPV4_NODE[199]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_198_prev, 1, &gn_BGP_IPV4_NODE[195]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_199_next, 1, &gn_BGP_IPV4_NODE[200]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_199_prev, 1, &gn_BGP_IPV4_NODE[198]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_200_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_200_prev, 1, &gn_BGP_IPV4_NODE[199]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_201_next, 1, &gn_BGP_IPV4_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_201_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_202_next, 3, &gn_BGP_IPV4_NODE[203], &gn_BGP_IPV4_NODE[208], &gn_BGP_IPV4_NODE[209]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_202_prev, 1, &gn_BGP_IPV4_NODE[201]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_203_next, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_203_prev, 1, &gn_BGP_IPV4_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_204_next, 28, &gn_BGP_IPV4_NODE[205], &gn_BGP_IPV4_NODE[210], &gn_BGP_IPV4_NODE[214], &gn_BGP_IPV4_NODE[217], &gn_BGP_IPV4_NODE[221], &gn_BGP_IPV4_NODE[224], &gn_BGP_IPV4_NODE[233], &gn_BGP_IPV4_NODE[236], &gn_BGP_IPV4_NODE[246], &gn_BGP_IPV4_NODE[256], &gn_BGP_IPV4_NODE[267], &gn_BGP_IPV4_NODE[274], &gn_BGP_IPV4_NODE[277], &gn_BGP_IPV4_NODE[285], &gn_BGP_IPV4_NODE[293], &gn_BGP_IPV4_NODE[332], &gn_BGP_IPV4_NODE[336], &gn_BGP_IPV4_NODE[345], &gn_BGP_IPV4_NODE[349], &gn_BGP_IPV4_NODE[357], &gn_BGP_IPV4_NODE[369], &gn_BGP_IPV4_NODE[377], &gn_BGP_IPV4_NODE[380], &gn_BGP_IPV4_NODE[383], &gn_BGP_IPV4_NODE[395], &gn_BGP_IPV4_NODE[399], &gn_BGP_IPV4_NODE[403], &gn_BGP_IPV4_NODE[407]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_204_prev, 3, &gn_BGP_IPV4_NODE[203], &gn_BGP_IPV4_NODE[208], &gn_BGP_IPV4_NODE[209]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_205_next, 1, &gn_BGP_IPV4_NODE[206]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_205_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_206_next, 1, &gn_BGP_IPV4_NODE[207]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_206_prev, 1, &gn_BGP_IPV4_NODE[205]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_207_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_207_prev, 1, &gn_BGP_IPV4_NODE[206]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_208_next, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_208_prev, 1, &gn_BGP_IPV4_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_209_next, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_209_prev, 1, &gn_BGP_IPV4_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_210_next, 1, &gn_BGP_IPV4_NODE[211]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_210_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_211_next, 1, &gn_BGP_IPV4_NODE[212]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_211_prev, 1, &gn_BGP_IPV4_NODE[210]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_212_next, 1, &gn_BGP_IPV4_NODE[213]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_212_prev, 1, &gn_BGP_IPV4_NODE[211]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_213_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_213_prev, 1, &gn_BGP_IPV4_NODE[212]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_214_next, 1, &gn_BGP_IPV4_NODE[215]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_214_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_215_next, 1, &gn_BGP_IPV4_NODE[216]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_215_prev, 1, &gn_BGP_IPV4_NODE[214]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_216_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_216_prev, 1, &gn_BGP_IPV4_NODE[215]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_217_next, 1, &gn_BGP_IPV4_NODE[218]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_217_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_218_next, 1, &gn_BGP_IPV4_NODE[219]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_218_prev, 1, &gn_BGP_IPV4_NODE[217]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_219_next, 1, &gn_BGP_IPV4_NODE[220]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_219_prev, 1, &gn_BGP_IPV4_NODE[218]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_220_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_220_prev, 1, &gn_BGP_IPV4_NODE[219]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_221_next, 1, &gn_BGP_IPV4_NODE[222]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_221_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_222_next, 1, &gn_BGP_IPV4_NODE[223]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_222_prev, 1, &gn_BGP_IPV4_NODE[221]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_223_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_223_prev, 1, &gn_BGP_IPV4_NODE[222]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_224_next, 1, &gn_BGP_IPV4_NODE[225]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_224_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_225_next, 2, &gn_BGP_IPV4_NODE[226], &gn_BGP_IPV4_NODE[229]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_225_prev, 1, &gn_BGP_IPV4_NODE[224]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_226_next, 2, &gn_BGP_IPV4_NODE[227], &gn_BGP_IPV4_NODE[232]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_226_prev, 1, &gn_BGP_IPV4_NODE[225]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_227_next, 1, &gn_BGP_IPV4_NODE[228]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_227_prev, 1, &gn_BGP_IPV4_NODE[226]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_228_next, 1, &gn_BGP_IPV4_NODE[229]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_228_prev, 2, &gn_BGP_IPV4_NODE[227], &gn_BGP_IPV4_NODE[232]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_229_next, 1, &gn_BGP_IPV4_NODE[230]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_229_prev, 2, &gn_BGP_IPV4_NODE[228], &gn_BGP_IPV4_NODE[225]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_230_next, 1, &gn_BGP_IPV4_NODE[231]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_230_prev, 1, &gn_BGP_IPV4_NODE[229]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_231_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_231_prev, 1, &gn_BGP_IPV4_NODE[230]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_232_next, 1, &gn_BGP_IPV4_NODE[228]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_232_prev, 1, &gn_BGP_IPV4_NODE[226]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_233_next, 1, &gn_BGP_IPV4_NODE[234]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_233_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_234_next, 1, &gn_BGP_IPV4_NODE[235]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_234_prev, 1, &gn_BGP_IPV4_NODE[233]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_235_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_235_prev, 1, &gn_BGP_IPV4_NODE[234]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_236_next, 1, &gn_BGP_IPV4_NODE[237]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_236_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_237_next, 2, &gn_BGP_IPV4_NODE[238], &gn_BGP_IPV4_NODE[241]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_237_prev, 1, &gn_BGP_IPV4_NODE[236]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_238_next, 3, &gn_BGP_IPV4_NODE[239], &gn_BGP_IPV4_NODE[244], &gn_BGP_IPV4_NODE[245]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_238_prev, 2, &gn_BGP_IPV4_NODE[240], &gn_BGP_IPV4_NODE[237]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_239_next, 1, &gn_BGP_IPV4_NODE[240]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_239_prev, 1, &gn_BGP_IPV4_NODE[238]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_240_next, 2, &gn_BGP_IPV4_NODE[238], &gn_BGP_IPV4_NODE[241]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_240_prev, 3, &gn_BGP_IPV4_NODE[239], &gn_BGP_IPV4_NODE[244], &gn_BGP_IPV4_NODE[245]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_241_next, 1, &gn_BGP_IPV4_NODE[242]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_241_prev, 2, &gn_BGP_IPV4_NODE[240], &gn_BGP_IPV4_NODE[237]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_242_next, 1, &gn_BGP_IPV4_NODE[243]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_242_prev, 1, &gn_BGP_IPV4_NODE[241]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_243_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_243_prev, 1, &gn_BGP_IPV4_NODE[242]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_244_next, 1, &gn_BGP_IPV4_NODE[240]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_244_prev, 1, &gn_BGP_IPV4_NODE[238]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_245_next, 1, &gn_BGP_IPV4_NODE[240]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_245_prev, 1, &gn_BGP_IPV4_NODE[238]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_246_next, 1, &gn_BGP_IPV4_NODE[247]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_246_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_247_next, 1, &gn_BGP_IPV4_NODE[248]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_247_prev, 1, &gn_BGP_IPV4_NODE[246]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_248_next, 1, &gn_BGP_IPV4_NODE[249]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_248_prev, 1, &gn_BGP_IPV4_NODE[247]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_249_next, 3, &gn_BGP_IPV4_NODE[250], &gn_BGP_IPV4_NODE[254], &gn_BGP_IPV4_NODE[255]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_249_prev, 1, &gn_BGP_IPV4_NODE[248]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_250_next, 1, &gn_BGP_IPV4_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_250_prev, 1, &gn_BGP_IPV4_NODE[249]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_251_next, 1, &gn_BGP_IPV4_NODE[252]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_251_prev, 3, &gn_BGP_IPV4_NODE[250], &gn_BGP_IPV4_NODE[254], &gn_BGP_IPV4_NODE[255]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_252_next, 1, &gn_BGP_IPV4_NODE[253]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_252_prev, 1, &gn_BGP_IPV4_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_253_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_253_prev, 1, &gn_BGP_IPV4_NODE[252]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_254_next, 1, &gn_BGP_IPV4_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_254_prev, 1, &gn_BGP_IPV4_NODE[249]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_255_next, 1, &gn_BGP_IPV4_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_255_prev, 1, &gn_BGP_IPV4_NODE[249]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_256_next, 1, &gn_BGP_IPV4_NODE[257]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_256_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_257_next, 2, &gn_BGP_IPV4_NODE[258], &gn_BGP_IPV4_NODE[264]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_257_prev, 1, &gn_BGP_IPV4_NODE[256]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_258_next, 1, &gn_BGP_IPV4_NODE[259]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_258_prev, 1, &gn_BGP_IPV4_NODE[257]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_259_next, 2, &gn_BGP_IPV4_NODE[260], &gn_BGP_IPV4_NODE[263]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_259_prev, 1, &gn_BGP_IPV4_NODE[258]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_260_next, 1, &gn_BGP_IPV4_NODE[261]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_260_prev, 1, &gn_BGP_IPV4_NODE[259]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_261_next, 1, &gn_BGP_IPV4_NODE[262]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_261_prev, 1, &gn_BGP_IPV4_NODE[260]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_262_next, 1, &gn_BGP_IPV4_NODE[263]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_262_prev, 1, &gn_BGP_IPV4_NODE[261]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_263_next, 1, &gn_BGP_IPV4_NODE[264]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_263_prev, 2, &gn_BGP_IPV4_NODE[262], &gn_BGP_IPV4_NODE[259]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_264_next, 1, &gn_BGP_IPV4_NODE[265]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_264_prev, 2, &gn_BGP_IPV4_NODE[263], &gn_BGP_IPV4_NODE[257]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_265_next, 1, &gn_BGP_IPV4_NODE[266]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_265_prev, 1, &gn_BGP_IPV4_NODE[264]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_266_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_266_prev, 1, &gn_BGP_IPV4_NODE[265]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_267_next, 2, &gn_BGP_IPV4_NODE[268], &gn_BGP_IPV4_NODE[270]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_267_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_268_next, 1, &gn_BGP_IPV4_NODE[269]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_268_prev, 1, &gn_BGP_IPV4_NODE[267]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_269_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_269_prev, 1, &gn_BGP_IPV4_NODE[268]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_270_next, 1, &gn_BGP_IPV4_NODE[271]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_270_prev, 1, &gn_BGP_IPV4_NODE[267]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_271_next, 1, &gn_BGP_IPV4_NODE[272]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_271_prev, 1, &gn_BGP_IPV4_NODE[270]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_272_next, 1, &gn_BGP_IPV4_NODE[273]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_272_prev, 1, &gn_BGP_IPV4_NODE[271]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_273_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_273_prev, 1, &gn_BGP_IPV4_NODE[272]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_274_next, 1, &gn_BGP_IPV4_NODE[275]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_274_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_275_next, 1, &gn_BGP_IPV4_NODE[276]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_275_prev, 1, &gn_BGP_IPV4_NODE[274]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_276_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_276_prev, 1, &gn_BGP_IPV4_NODE[275]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_277_next, 1, &gn_BGP_IPV4_NODE[278]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_277_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_278_next, 1, &gn_BGP_IPV4_NODE[279]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_278_prev, 1, &gn_BGP_IPV4_NODE[277]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_279_next, 2, &gn_BGP_IPV4_NODE[280], &gn_BGP_IPV4_NODE[284]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_279_prev, 1, &gn_BGP_IPV4_NODE[278]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_280_next, 1, &gn_BGP_IPV4_NODE[281]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_280_prev, 1, &gn_BGP_IPV4_NODE[279]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_281_next, 1, &gn_BGP_IPV4_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_281_prev, 2, &gn_BGP_IPV4_NODE[280], &gn_BGP_IPV4_NODE[284]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_282_next, 1, &gn_BGP_IPV4_NODE[283]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_282_prev, 1, &gn_BGP_IPV4_NODE[281]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_283_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_283_prev, 1, &gn_BGP_IPV4_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_284_next, 1, &gn_BGP_IPV4_NODE[281]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_284_prev, 1, &gn_BGP_IPV4_NODE[279]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_285_next, 1, &gn_BGP_IPV4_NODE[286]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_285_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_286_next, 1, &gn_BGP_IPV4_NODE[287]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_286_prev, 1, &gn_BGP_IPV4_NODE[285]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_287_next, 2, &gn_BGP_IPV4_NODE[288], &gn_BGP_IPV4_NODE[292]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_287_prev, 1, &gn_BGP_IPV4_NODE[286]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_288_next, 1, &gn_BGP_IPV4_NODE[289]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_288_prev, 1, &gn_BGP_IPV4_NODE[287]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_289_next, 1, &gn_BGP_IPV4_NODE[290]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_289_prev, 2, &gn_BGP_IPV4_NODE[288], &gn_BGP_IPV4_NODE[292]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_290_next, 1, &gn_BGP_IPV4_NODE[291]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_290_prev, 1, &gn_BGP_IPV4_NODE[289]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_291_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_291_prev, 1, &gn_BGP_IPV4_NODE[290]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_292_next, 1, &gn_BGP_IPV4_NODE[289]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_292_prev, 1, &gn_BGP_IPV4_NODE[287]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_293_next, 1, &gn_BGP_IPV4_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_293_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_294_next, 4, &gn_BGP_IPV4_NODE[295], &gn_BGP_IPV4_NODE[314], &gn_BGP_IPV4_NODE[319], &gn_BGP_IPV4_NODE[326]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_294_prev, 1, &gn_BGP_IPV4_NODE[293]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_295_next, 3, &gn_BGP_IPV4_NODE[296], &gn_BGP_IPV4_NODE[301], &gn_BGP_IPV4_NODE[308]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_295_prev, 1, &gn_BGP_IPV4_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_296_next, 2, &gn_BGP_IPV4_NODE[297], &gn_BGP_IPV4_NODE[298]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_296_prev, 1, &gn_BGP_IPV4_NODE[295]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_297_next, 1, &gn_BGP_IPV4_NODE[298]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_297_prev, 1, &gn_BGP_IPV4_NODE[296]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_298_next, 1, &gn_BGP_IPV4_NODE[299]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_298_prev, 2, &gn_BGP_IPV4_NODE[297], &gn_BGP_IPV4_NODE[296]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_299_next, 1, &gn_BGP_IPV4_NODE[300]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_299_prev, 1, &gn_BGP_IPV4_NODE[298]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_300_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_300_prev, 1, &gn_BGP_IPV4_NODE[299]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_301_next, 1, &gn_BGP_IPV4_NODE[302]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_301_prev, 1, &gn_BGP_IPV4_NODE[295]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_302_next, 1, &gn_BGP_IPV4_NODE[303]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_302_prev, 1, &gn_BGP_IPV4_NODE[301]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_303_next, 2, &gn_BGP_IPV4_NODE[304], &gn_BGP_IPV4_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_303_prev, 1, &gn_BGP_IPV4_NODE[302]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_304_next, 1, &gn_BGP_IPV4_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_304_prev, 1, &gn_BGP_IPV4_NODE[303]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_305_next, 1, &gn_BGP_IPV4_NODE[306]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_305_prev, 2, &gn_BGP_IPV4_NODE[304], &gn_BGP_IPV4_NODE[303]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_306_next, 1, &gn_BGP_IPV4_NODE[307]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_306_prev, 1, &gn_BGP_IPV4_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_307_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_307_prev, 1, &gn_BGP_IPV4_NODE[306]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_308_next, 1, &gn_BGP_IPV4_NODE[309]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_308_prev, 1, &gn_BGP_IPV4_NODE[295]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_309_next, 2, &gn_BGP_IPV4_NODE[310], &gn_BGP_IPV4_NODE[311]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_309_prev, 1, &gn_BGP_IPV4_NODE[308]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_310_next, 1, &gn_BGP_IPV4_NODE[311]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_310_prev, 1, &gn_BGP_IPV4_NODE[309]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_311_next, 1, &gn_BGP_IPV4_NODE[312]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_311_prev, 2, &gn_BGP_IPV4_NODE[310], &gn_BGP_IPV4_NODE[309]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_312_next, 1, &gn_BGP_IPV4_NODE[313]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_312_prev, 1, &gn_BGP_IPV4_NODE[311]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_313_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_313_prev, 1, &gn_BGP_IPV4_NODE[312]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_314_next, 2, &gn_BGP_IPV4_NODE[315], &gn_BGP_IPV4_NODE[316]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_314_prev, 1, &gn_BGP_IPV4_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_315_next, 1, &gn_BGP_IPV4_NODE[316]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_315_prev, 1, &gn_BGP_IPV4_NODE[314]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_316_next, 1, &gn_BGP_IPV4_NODE[317]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_316_prev, 2, &gn_BGP_IPV4_NODE[315], &gn_BGP_IPV4_NODE[314]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_317_next, 1, &gn_BGP_IPV4_NODE[318]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_317_prev, 1, &gn_BGP_IPV4_NODE[316]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_318_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_318_prev, 1, &gn_BGP_IPV4_NODE[317]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_319_next, 1, &gn_BGP_IPV4_NODE[320]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_319_prev, 1, &gn_BGP_IPV4_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_320_next, 1, &gn_BGP_IPV4_NODE[321]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_320_prev, 1, &gn_BGP_IPV4_NODE[319]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_321_next, 2, &gn_BGP_IPV4_NODE[322], &gn_BGP_IPV4_NODE[323]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_321_prev, 1, &gn_BGP_IPV4_NODE[320]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_322_next, 1, &gn_BGP_IPV4_NODE[323]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_322_prev, 1, &gn_BGP_IPV4_NODE[321]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_323_next, 1, &gn_BGP_IPV4_NODE[324]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_323_prev, 2, &gn_BGP_IPV4_NODE[322], &gn_BGP_IPV4_NODE[321]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_324_next, 1, &gn_BGP_IPV4_NODE[325]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_324_prev, 1, &gn_BGP_IPV4_NODE[323]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_325_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_325_prev, 1, &gn_BGP_IPV4_NODE[324]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_326_next, 1, &gn_BGP_IPV4_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_326_prev, 1, &gn_BGP_IPV4_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_327_next, 2, &gn_BGP_IPV4_NODE[328], &gn_BGP_IPV4_NODE[329]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_327_prev, 1, &gn_BGP_IPV4_NODE[326]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_328_next, 1, &gn_BGP_IPV4_NODE[329]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_328_prev, 1, &gn_BGP_IPV4_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_329_next, 1, &gn_BGP_IPV4_NODE[330]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_329_prev, 2, &gn_BGP_IPV4_NODE[328], &gn_BGP_IPV4_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_330_next, 1, &gn_BGP_IPV4_NODE[331]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_330_prev, 1, &gn_BGP_IPV4_NODE[329]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_331_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_331_prev, 1, &gn_BGP_IPV4_NODE[330]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_332_next, 1, &gn_BGP_IPV4_NODE[333]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_332_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_333_next, 1, &gn_BGP_IPV4_NODE[334]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_333_prev, 1, &gn_BGP_IPV4_NODE[332]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_334_next, 1, &gn_BGP_IPV4_NODE[335]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_334_prev, 1, &gn_BGP_IPV4_NODE[333]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_335_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_335_prev, 1, &gn_BGP_IPV4_NODE[334]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_336_next, 3, &gn_BGP_IPV4_NODE[337], &gn_BGP_IPV4_NODE[339], &gn_BGP_IPV4_NODE[342]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_336_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_337_next, 1, &gn_BGP_IPV4_NODE[338]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_337_prev, 1, &gn_BGP_IPV4_NODE[336]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_338_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_338_prev, 1, &gn_BGP_IPV4_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_339_next, 1, &gn_BGP_IPV4_NODE[340]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_339_prev, 1, &gn_BGP_IPV4_NODE[336]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_340_next, 1, &gn_BGP_IPV4_NODE[341]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_340_prev, 1, &gn_BGP_IPV4_NODE[339]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_341_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_341_prev, 1, &gn_BGP_IPV4_NODE[340]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_342_next, 1, &gn_BGP_IPV4_NODE[343]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_342_prev, 1, &gn_BGP_IPV4_NODE[336]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_343_next, 1, &gn_BGP_IPV4_NODE[344]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_343_prev, 1, &gn_BGP_IPV4_NODE[342]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_344_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_344_prev, 1, &gn_BGP_IPV4_NODE[343]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_345_next, 1, &gn_BGP_IPV4_NODE[346]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_345_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_346_next, 1, &gn_BGP_IPV4_NODE[347]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_346_prev, 1, &gn_BGP_IPV4_NODE[345]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_347_next, 1, &gn_BGP_IPV4_NODE[348]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_347_prev, 1, &gn_BGP_IPV4_NODE[346]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_348_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_348_prev, 1, &gn_BGP_IPV4_NODE[347]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_349_next, 1, &gn_BGP_IPV4_NODE[350]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_349_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_350_next, 1, &gn_BGP_IPV4_NODE[351]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_350_prev, 1, &gn_BGP_IPV4_NODE[349]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_351_next, 2, &gn_BGP_IPV4_NODE[352], &gn_BGP_IPV4_NODE[356]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_351_prev, 1, &gn_BGP_IPV4_NODE[350]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_352_next, 1, &gn_BGP_IPV4_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_352_prev, 1, &gn_BGP_IPV4_NODE[351]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_353_next, 1, &gn_BGP_IPV4_NODE[354]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_353_prev, 2, &gn_BGP_IPV4_NODE[352], &gn_BGP_IPV4_NODE[356]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_354_next, 1, &gn_BGP_IPV4_NODE[355]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_354_prev, 1, &gn_BGP_IPV4_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_355_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_355_prev, 1, &gn_BGP_IPV4_NODE[354]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_356_next, 1, &gn_BGP_IPV4_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_356_prev, 1, &gn_BGP_IPV4_NODE[351]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_357_next, 3, &gn_BGP_IPV4_NODE[358], &gn_BGP_IPV4_NODE[360], &gn_BGP_IPV4_NODE[366]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_357_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_358_next, 1, &gn_BGP_IPV4_NODE[359]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_358_prev, 1, &gn_BGP_IPV4_NODE[357]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_359_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_359_prev, 1, &gn_BGP_IPV4_NODE[358]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_360_next, 2, &gn_BGP_IPV4_NODE[361], &gn_BGP_IPV4_NODE[363]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_360_prev, 1, &gn_BGP_IPV4_NODE[357]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_361_next, 1, &gn_BGP_IPV4_NODE[362]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_361_prev, 1, &gn_BGP_IPV4_NODE[360]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_362_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_362_prev, 1, &gn_BGP_IPV4_NODE[361]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_363_next, 1, &gn_BGP_IPV4_NODE[364]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_363_prev, 1, &gn_BGP_IPV4_NODE[360]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_364_next, 1, &gn_BGP_IPV4_NODE[365]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_364_prev, 1, &gn_BGP_IPV4_NODE[363]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_365_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_365_prev, 1, &gn_BGP_IPV4_NODE[364]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_366_next, 1, &gn_BGP_IPV4_NODE[367]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_366_prev, 1, &gn_BGP_IPV4_NODE[357]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_367_next, 1, &gn_BGP_IPV4_NODE[368]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_367_prev, 1, &gn_BGP_IPV4_NODE[366]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_368_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_368_prev, 1, &gn_BGP_IPV4_NODE[367]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_369_next, 1, &gn_BGP_IPV4_NODE[370]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_369_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_370_next, 1, &gn_BGP_IPV4_NODE[371]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_370_prev, 1, &gn_BGP_IPV4_NODE[369]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_371_next, 2, &gn_BGP_IPV4_NODE[372], &gn_BGP_IPV4_NODE[376]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_371_prev, 1, &gn_BGP_IPV4_NODE[370]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_372_next, 1, &gn_BGP_IPV4_NODE[373]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_372_prev, 1, &gn_BGP_IPV4_NODE[371]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_373_next, 1, &gn_BGP_IPV4_NODE[374]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_373_prev, 2, &gn_BGP_IPV4_NODE[372], &gn_BGP_IPV4_NODE[376]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_374_next, 1, &gn_BGP_IPV4_NODE[375]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_374_prev, 1, &gn_BGP_IPV4_NODE[373]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_375_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_375_prev, 1, &gn_BGP_IPV4_NODE[374]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_376_next, 1, &gn_BGP_IPV4_NODE[373]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_376_prev, 1, &gn_BGP_IPV4_NODE[371]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_377_next, 1, &gn_BGP_IPV4_NODE[378]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_377_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_378_next, 1, &gn_BGP_IPV4_NODE[379]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_378_prev, 1, &gn_BGP_IPV4_NODE[377]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_379_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_379_prev, 1, &gn_BGP_IPV4_NODE[378]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_380_next, 1, &gn_BGP_IPV4_NODE[381]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_380_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_381_next, 1, &gn_BGP_IPV4_NODE[382]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_381_prev, 1, &gn_BGP_IPV4_NODE[380]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_382_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_382_prev, 1, &gn_BGP_IPV4_NODE[381]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_383_next, 2, &gn_BGP_IPV4_NODE[384], &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_383_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_384_next, 1, &gn_BGP_IPV4_NODE[385]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_384_prev, 1, &gn_BGP_IPV4_NODE[383]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_385_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_385_prev, 1, &gn_BGP_IPV4_NODE[384]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_386_next, 5, &gn_BGP_IPV4_NODE[387], &gn_BGP_IPV4_NODE[391], &gn_BGP_IPV4_NODE[392], &gn_BGP_IPV4_NODE[393], &gn_BGP_IPV4_NODE[394]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_386_prev, 1, &gn_BGP_IPV4_NODE[383]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_387_next, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_387_prev, 1, &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_388_next, 1, &gn_BGP_IPV4_NODE[389]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_388_prev, 5, &gn_BGP_IPV4_NODE[387], &gn_BGP_IPV4_NODE[391], &gn_BGP_IPV4_NODE[392], &gn_BGP_IPV4_NODE[393], &gn_BGP_IPV4_NODE[394]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_389_next, 1, &gn_BGP_IPV4_NODE[390]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_389_prev, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_390_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_390_prev, 1, &gn_BGP_IPV4_NODE[389]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_391_next, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_391_prev, 1, &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_392_next, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_392_prev, 1, &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_393_next, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_393_prev, 1, &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_394_next, 1, &gn_BGP_IPV4_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_394_prev, 1, &gn_BGP_IPV4_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_395_next, 1, &gn_BGP_IPV4_NODE[396]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_395_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_396_next, 1, &gn_BGP_IPV4_NODE[397]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_396_prev, 1, &gn_BGP_IPV4_NODE[395]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_397_next, 1, &gn_BGP_IPV4_NODE[398]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_397_prev, 1, &gn_BGP_IPV4_NODE[396]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_398_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_398_prev, 1, &gn_BGP_IPV4_NODE[397]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_399_next, 1, &gn_BGP_IPV4_NODE[400]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_399_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_400_next, 1, &gn_BGP_IPV4_NODE[401]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_400_prev, 1, &gn_BGP_IPV4_NODE[399]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_401_next, 1, &gn_BGP_IPV4_NODE[402]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_401_prev, 1, &gn_BGP_IPV4_NODE[400]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_402_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_402_prev, 1, &gn_BGP_IPV4_NODE[401]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_403_next, 1, &gn_BGP_IPV4_NODE[404]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_403_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_404_next, 1, &gn_BGP_IPV4_NODE[405]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_404_prev, 1, &gn_BGP_IPV4_NODE[403]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_405_next, 1, &gn_BGP_IPV4_NODE[406]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_405_prev, 1, &gn_BGP_IPV4_NODE[404]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_406_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_406_prev, 1, &gn_BGP_IPV4_NODE[405]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_407_next, 1, &gn_BGP_IPV4_NODE[408]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_407_prev, 1, &gn_BGP_IPV4_NODE[204]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_408_next, 1, &gn_BGP_IPV4_NODE[409]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_408_prev, 1, &gn_BGP_IPV4_NODE[407]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_409_next, 1, &gn_BGP_IPV4_NODE[410]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_409_prev, 1, &gn_BGP_IPV4_NODE[408]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_410_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_410_prev, 1, &gn_BGP_IPV4_NODE[409]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_411_next, 11, &gn_BGP_IPV4_NODE[412], &gn_BGP_IPV4_NODE[424], &gn_BGP_IPV4_NODE[436], &gn_BGP_IPV4_NODE[452], &gn_BGP_IPV4_NODE[460], &gn_BGP_IPV4_NODE[465], &gn_BGP_IPV4_NODE[480], &gn_BGP_IPV4_NODE[680], &gn_BGP_IPV4_NODE[685], &gn_BGP_IPV4_NODE[727], &gn_BGP_IPV4_NODE[735]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_411_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_412_next, 2, &gn_BGP_IPV4_NODE[413], &gn_BGP_IPV4_NODE[423]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_412_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_413_next, 1, &gn_BGP_IPV4_NODE[414]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_413_prev, 1, &gn_BGP_IPV4_NODE[412]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_414_next, 1, &gn_BGP_IPV4_NODE[415]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_414_prev, 2, &gn_BGP_IPV4_NODE[413], &gn_BGP_IPV4_NODE[423]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_415_next, 1, &gn_BGP_IPV4_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_415_prev, 1, &gn_BGP_IPV4_NODE[414]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_416_next, 3, &gn_BGP_IPV4_NODE[417], &gn_BGP_IPV4_NODE[421], &gn_BGP_IPV4_NODE[422]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_416_prev, 1, &gn_BGP_IPV4_NODE[415]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_417_next, 1, &gn_BGP_IPV4_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_417_prev, 1, &gn_BGP_IPV4_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_418_next, 1, &gn_BGP_IPV4_NODE[419]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_418_prev, 3, &gn_BGP_IPV4_NODE[417], &gn_BGP_IPV4_NODE[421], &gn_BGP_IPV4_NODE[422]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_419_next, 1, &gn_BGP_IPV4_NODE[420]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_419_prev, 1, &gn_BGP_IPV4_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_420_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_420_prev, 1, &gn_BGP_IPV4_NODE[419]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_421_next, 1, &gn_BGP_IPV4_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_421_prev, 1, &gn_BGP_IPV4_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_422_next, 1, &gn_BGP_IPV4_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_422_prev, 1, &gn_BGP_IPV4_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_423_next, 1, &gn_BGP_IPV4_NODE[414]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_423_prev, 1, &gn_BGP_IPV4_NODE[412]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_424_next, 1, &gn_BGP_IPV4_NODE[425]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_424_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_425_next, 1, &gn_BGP_IPV4_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_425_prev, 1, &gn_BGP_IPV4_NODE[424]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_426_next, 2, &gn_BGP_IPV4_NODE[427], &gn_BGP_IPV4_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_426_prev, 1, &gn_BGP_IPV4_NODE[425]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_427_next, 1, &gn_BGP_IPV4_NODE[428]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_427_prev, 1, &gn_BGP_IPV4_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_428_next, 2, &gn_BGP_IPV4_NODE[429], &gn_BGP_IPV4_NODE[432]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_428_prev, 1, &gn_BGP_IPV4_NODE[427]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_429_next, 1, &gn_BGP_IPV4_NODE[430]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_429_prev, 1, &gn_BGP_IPV4_NODE[428]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_430_next, 1, &gn_BGP_IPV4_NODE[431]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_430_prev, 1, &gn_BGP_IPV4_NODE[429]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_431_next, 1, &gn_BGP_IPV4_NODE[432]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_431_prev, 1, &gn_BGP_IPV4_NODE[430]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_432_next, 1, &gn_BGP_IPV4_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_432_prev, 2, &gn_BGP_IPV4_NODE[431], &gn_BGP_IPV4_NODE[428]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_433_next, 1, &gn_BGP_IPV4_NODE[434]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_433_prev, 2, &gn_BGP_IPV4_NODE[432], &gn_BGP_IPV4_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_434_next, 1, &gn_BGP_IPV4_NODE[435]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_434_prev, 1, &gn_BGP_IPV4_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_435_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_435_prev, 1, &gn_BGP_IPV4_NODE[434]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_436_next, 2, &gn_BGP_IPV4_NODE[437], &gn_BGP_IPV4_NODE[444]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_436_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_437_next, 1, &gn_BGP_IPV4_NODE[438]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_437_prev, 1, &gn_BGP_IPV4_NODE[436]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_438_next, 2, &gn_BGP_IPV4_NODE[439], &gn_BGP_IPV4_NODE[441]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_438_prev, 1, &gn_BGP_IPV4_NODE[437]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_439_next, 1, &gn_BGP_IPV4_NODE[440]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_439_prev, 1, &gn_BGP_IPV4_NODE[438]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_440_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_440_prev, 1, &gn_BGP_IPV4_NODE[439]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_441_next, 1, &gn_BGP_IPV4_NODE[442]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_441_prev, 1, &gn_BGP_IPV4_NODE[438]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_442_next, 1, &gn_BGP_IPV4_NODE[443]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_442_prev, 1, &gn_BGP_IPV4_NODE[441]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_443_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_443_prev, 1, &gn_BGP_IPV4_NODE[442]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_444_next, 1, &gn_BGP_IPV4_NODE[445]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_444_prev, 1, &gn_BGP_IPV4_NODE[436]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_445_next, 2, &gn_BGP_IPV4_NODE[446], &gn_BGP_IPV4_NODE[449]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_445_prev, 1, &gn_BGP_IPV4_NODE[444]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_446_next, 1, &gn_BGP_IPV4_NODE[447]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_446_prev, 1, &gn_BGP_IPV4_NODE[445]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_447_next, 1, &gn_BGP_IPV4_NODE[448]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_447_prev, 1, &gn_BGP_IPV4_NODE[446]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_448_next, 1, &gn_BGP_IPV4_NODE[449]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_448_prev, 1, &gn_BGP_IPV4_NODE[447]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_449_next, 1, &gn_BGP_IPV4_NODE[450]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_449_prev, 2, &gn_BGP_IPV4_NODE[448], &gn_BGP_IPV4_NODE[445]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_450_next, 1, &gn_BGP_IPV4_NODE[451]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_450_prev, 1, &gn_BGP_IPV4_NODE[449]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_451_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_451_prev, 1, &gn_BGP_IPV4_NODE[450]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_452_next, 1, &gn_BGP_IPV4_NODE[453]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_452_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_453_next, 1, &gn_BGP_IPV4_NODE[454]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_453_prev, 1, &gn_BGP_IPV4_NODE[452]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_454_next, 1, &gn_BGP_IPV4_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_454_prev, 1, &gn_BGP_IPV4_NODE[453]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_455_next, 2, &gn_BGP_IPV4_NODE[456], &gn_BGP_IPV4_NODE[457]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_455_prev, 1, &gn_BGP_IPV4_NODE[454]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_456_next, 1, &gn_BGP_IPV4_NODE[457]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_456_prev, 1, &gn_BGP_IPV4_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_457_next, 1, &gn_BGP_IPV4_NODE[458]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_457_prev, 2, &gn_BGP_IPV4_NODE[456], &gn_BGP_IPV4_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_458_next, 1, &gn_BGP_IPV4_NODE[459]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_458_prev, 1, &gn_BGP_IPV4_NODE[457]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_459_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_459_prev, 1, &gn_BGP_IPV4_NODE[458]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_460_next, 1, &gn_BGP_IPV4_NODE[461]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_460_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_461_next, 1, &gn_BGP_IPV4_NODE[462]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_461_prev, 1, &gn_BGP_IPV4_NODE[460]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_462_next, 1, &gn_BGP_IPV4_NODE[463]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_462_prev, 1, &gn_BGP_IPV4_NODE[461]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_463_next, 1, &gn_BGP_IPV4_NODE[464]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_463_prev, 1, &gn_BGP_IPV4_NODE[462]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_464_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_464_prev, 1, &gn_BGP_IPV4_NODE[463]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_465_next, 2, &gn_BGP_IPV4_NODE[466], &gn_BGP_IPV4_NODE[471]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_465_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_466_next, 2, &gn_BGP_IPV4_NODE[467], &gn_BGP_IPV4_NODE[468]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_466_prev, 1, &gn_BGP_IPV4_NODE[465]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_467_next, 1, &gn_BGP_IPV4_NODE[468]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_467_prev, 1, &gn_BGP_IPV4_NODE[466]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_468_next, 1, &gn_BGP_IPV4_NODE[469]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_468_prev, 2, &gn_BGP_IPV4_NODE[467], &gn_BGP_IPV4_NODE[466]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_469_next, 1, &gn_BGP_IPV4_NODE[470]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_469_prev, 1, &gn_BGP_IPV4_NODE[468]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_470_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_470_prev, 1, &gn_BGP_IPV4_NODE[469]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_471_next, 1, &gn_BGP_IPV4_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_471_prev, 1, &gn_BGP_IPV4_NODE[465]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_472_next, 2, &gn_BGP_IPV4_NODE[473], &gn_BGP_IPV4_NODE[477]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_472_prev, 1, &gn_BGP_IPV4_NODE[471]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_473_next, 1, &gn_BGP_IPV4_NODE[474]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_473_prev, 1, &gn_BGP_IPV4_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_474_next, 2, &gn_BGP_IPV4_NODE[475], &gn_BGP_IPV4_NODE[476]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_474_prev, 1, &gn_BGP_IPV4_NODE[473]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_475_next, 1, &gn_BGP_IPV4_NODE[476]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_475_prev, 1, &gn_BGP_IPV4_NODE[474]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_476_next, 1, &gn_BGP_IPV4_NODE[477]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_476_prev, 2, &gn_BGP_IPV4_NODE[475], &gn_BGP_IPV4_NODE[474]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_477_next, 1, &gn_BGP_IPV4_NODE[478]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_477_prev, 2, &gn_BGP_IPV4_NODE[476], &gn_BGP_IPV4_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_478_next, 1, &gn_BGP_IPV4_NODE[479]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_478_prev, 1, &gn_BGP_IPV4_NODE[477]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_479_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_479_prev, 1, &gn_BGP_IPV4_NODE[478]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_480_next, 1, &gn_BGP_IPV4_NODE[481]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_480_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_481_next, 3, &gn_BGP_IPV4_NODE[482], &gn_BGP_IPV4_NODE[487], &gn_BGP_IPV4_NODE[488]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_481_prev, 1, &gn_BGP_IPV4_NODE[480]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_482_next, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_482_prev, 1, &gn_BGP_IPV4_NODE[481]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_483_next, 28, &gn_BGP_IPV4_NODE[484], &gn_BGP_IPV4_NODE[489], &gn_BGP_IPV4_NODE[495], &gn_BGP_IPV4_NODE[498], &gn_BGP_IPV4_NODE[504], &gn_BGP_IPV4_NODE[507], &gn_BGP_IPV4_NODE[516], &gn_BGP_IPV4_NODE[519], &gn_BGP_IPV4_NODE[529], &gn_BGP_IPV4_NODE[539], &gn_BGP_IPV4_NODE[550], &gn_BGP_IPV4_NODE[557], &gn_BGP_IPV4_NODE[560], &gn_BGP_IPV4_NODE[568], &gn_BGP_IPV4_NODE[576], &gn_BGP_IPV4_NODE[595], &gn_BGP_IPV4_NODE[601], &gn_BGP_IPV4_NODE[610], &gn_BGP_IPV4_NODE[614], &gn_BGP_IPV4_NODE[622], &gn_BGP_IPV4_NODE[634], &gn_BGP_IPV4_NODE[642], &gn_BGP_IPV4_NODE[645], &gn_BGP_IPV4_NODE[648], &gn_BGP_IPV4_NODE[660], &gn_BGP_IPV4_NODE[664], &gn_BGP_IPV4_NODE[670], &gn_BGP_IPV4_NODE[674]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_483_prev, 3, &gn_BGP_IPV4_NODE[482], &gn_BGP_IPV4_NODE[487], &gn_BGP_IPV4_NODE[488]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_484_next, 1, &gn_BGP_IPV4_NODE[485]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_484_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_485_next, 1, &gn_BGP_IPV4_NODE[486]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_485_prev, 1, &gn_BGP_IPV4_NODE[484]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_486_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_486_prev, 1, &gn_BGP_IPV4_NODE[485]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_487_next, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_487_prev, 1, &gn_BGP_IPV4_NODE[481]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_488_next, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_488_prev, 1, &gn_BGP_IPV4_NODE[481]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_489_next, 1, &gn_BGP_IPV4_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_489_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_490_next, 2, &gn_BGP_IPV4_NODE[491], &gn_BGP_IPV4_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_490_prev, 1, &gn_BGP_IPV4_NODE[489]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_491_next, 1, &gn_BGP_IPV4_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_491_prev, 1, &gn_BGP_IPV4_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_492_next, 1, &gn_BGP_IPV4_NODE[493]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_492_prev, 2, &gn_BGP_IPV4_NODE[491], &gn_BGP_IPV4_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_493_next, 1, &gn_BGP_IPV4_NODE[494]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_493_prev, 1, &gn_BGP_IPV4_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_494_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_494_prev, 1, &gn_BGP_IPV4_NODE[493]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_495_next, 1, &gn_BGP_IPV4_NODE[496]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_495_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_496_next, 1, &gn_BGP_IPV4_NODE[497]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_496_prev, 1, &gn_BGP_IPV4_NODE[495]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_497_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_497_prev, 1, &gn_BGP_IPV4_NODE[496]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_498_next, 1, &gn_BGP_IPV4_NODE[499]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_498_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_499_next, 2, &gn_BGP_IPV4_NODE[500], &gn_BGP_IPV4_NODE[501]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_499_prev, 1, &gn_BGP_IPV4_NODE[498]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_500_next, 1, &gn_BGP_IPV4_NODE[501]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_500_prev, 1, &gn_BGP_IPV4_NODE[499]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_501_next, 1, &gn_BGP_IPV4_NODE[502]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_501_prev, 2, &gn_BGP_IPV4_NODE[500], &gn_BGP_IPV4_NODE[499]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_502_next, 1, &gn_BGP_IPV4_NODE[503]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_502_prev, 1, &gn_BGP_IPV4_NODE[501]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_503_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_503_prev, 1, &gn_BGP_IPV4_NODE[502]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_504_next, 1, &gn_BGP_IPV4_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_504_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_505_next, 1, &gn_BGP_IPV4_NODE[506]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_505_prev, 1, &gn_BGP_IPV4_NODE[504]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_506_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_506_prev, 1, &gn_BGP_IPV4_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_507_next, 1, &gn_BGP_IPV4_NODE[508]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_507_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_508_next, 2, &gn_BGP_IPV4_NODE[509], &gn_BGP_IPV4_NODE[512]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_508_prev, 1, &gn_BGP_IPV4_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_509_next, 2, &gn_BGP_IPV4_NODE[510], &gn_BGP_IPV4_NODE[515]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_509_prev, 1, &gn_BGP_IPV4_NODE[508]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_510_next, 1, &gn_BGP_IPV4_NODE[511]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_510_prev, 1, &gn_BGP_IPV4_NODE[509]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_511_next, 1, &gn_BGP_IPV4_NODE[512]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_511_prev, 2, &gn_BGP_IPV4_NODE[510], &gn_BGP_IPV4_NODE[515]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_512_next, 1, &gn_BGP_IPV4_NODE[513]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_512_prev, 2, &gn_BGP_IPV4_NODE[511], &gn_BGP_IPV4_NODE[508]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_513_next, 1, &gn_BGP_IPV4_NODE[514]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_513_prev, 1, &gn_BGP_IPV4_NODE[512]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_514_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_514_prev, 1, &gn_BGP_IPV4_NODE[513]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_515_next, 1, &gn_BGP_IPV4_NODE[511]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_515_prev, 1, &gn_BGP_IPV4_NODE[509]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_516_next, 1, &gn_BGP_IPV4_NODE[517]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_516_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_517_next, 1, &gn_BGP_IPV4_NODE[518]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_517_prev, 1, &gn_BGP_IPV4_NODE[516]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_518_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_518_prev, 1, &gn_BGP_IPV4_NODE[517]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_519_next, 1, &gn_BGP_IPV4_NODE[520]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_519_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_520_next, 2, &gn_BGP_IPV4_NODE[521], &gn_BGP_IPV4_NODE[524]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_520_prev, 1, &gn_BGP_IPV4_NODE[519]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_521_next, 3, &gn_BGP_IPV4_NODE[522], &gn_BGP_IPV4_NODE[527], &gn_BGP_IPV4_NODE[528]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_521_prev, 2, &gn_BGP_IPV4_NODE[523], &gn_BGP_IPV4_NODE[520]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_522_next, 1, &gn_BGP_IPV4_NODE[523]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_522_prev, 1, &gn_BGP_IPV4_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_523_next, 2, &gn_BGP_IPV4_NODE[521], &gn_BGP_IPV4_NODE[524]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_523_prev, 3, &gn_BGP_IPV4_NODE[522], &gn_BGP_IPV4_NODE[527], &gn_BGP_IPV4_NODE[528]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_524_next, 1, &gn_BGP_IPV4_NODE[525]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_524_prev, 2, &gn_BGP_IPV4_NODE[523], &gn_BGP_IPV4_NODE[520]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_525_next, 1, &gn_BGP_IPV4_NODE[526]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_525_prev, 1, &gn_BGP_IPV4_NODE[524]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_526_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_526_prev, 1, &gn_BGP_IPV4_NODE[525]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_527_next, 1, &gn_BGP_IPV4_NODE[523]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_527_prev, 1, &gn_BGP_IPV4_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_528_next, 1, &gn_BGP_IPV4_NODE[523]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_528_prev, 1, &gn_BGP_IPV4_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_529_next, 1, &gn_BGP_IPV4_NODE[530]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_529_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_530_next, 1, &gn_BGP_IPV4_NODE[531]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_530_prev, 1, &gn_BGP_IPV4_NODE[529]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_531_next, 1, &gn_BGP_IPV4_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_531_prev, 1, &gn_BGP_IPV4_NODE[530]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_532_next, 3, &gn_BGP_IPV4_NODE[533], &gn_BGP_IPV4_NODE[537], &gn_BGP_IPV4_NODE[538]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_532_prev, 1, &gn_BGP_IPV4_NODE[531]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_533_next, 1, &gn_BGP_IPV4_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_533_prev, 1, &gn_BGP_IPV4_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_534_next, 1, &gn_BGP_IPV4_NODE[535]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_534_prev, 3, &gn_BGP_IPV4_NODE[533], &gn_BGP_IPV4_NODE[537], &gn_BGP_IPV4_NODE[538]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_535_next, 1, &gn_BGP_IPV4_NODE[536]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_535_prev, 1, &gn_BGP_IPV4_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_536_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_536_prev, 1, &gn_BGP_IPV4_NODE[535]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_537_next, 1, &gn_BGP_IPV4_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_537_prev, 1, &gn_BGP_IPV4_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_538_next, 1, &gn_BGP_IPV4_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_538_prev, 1, &gn_BGP_IPV4_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_539_next, 1, &gn_BGP_IPV4_NODE[540]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_539_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_540_next, 2, &gn_BGP_IPV4_NODE[541], &gn_BGP_IPV4_NODE[547]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_540_prev, 1, &gn_BGP_IPV4_NODE[539]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_541_next, 1, &gn_BGP_IPV4_NODE[542]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_541_prev, 1, &gn_BGP_IPV4_NODE[540]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_542_next, 2, &gn_BGP_IPV4_NODE[543], &gn_BGP_IPV4_NODE[546]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_542_prev, 1, &gn_BGP_IPV4_NODE[541]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_543_next, 1, &gn_BGP_IPV4_NODE[544]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_543_prev, 1, &gn_BGP_IPV4_NODE[542]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_544_next, 1, &gn_BGP_IPV4_NODE[545]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_544_prev, 1, &gn_BGP_IPV4_NODE[543]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_545_next, 1, &gn_BGP_IPV4_NODE[546]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_545_prev, 1, &gn_BGP_IPV4_NODE[544]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_546_next, 1, &gn_BGP_IPV4_NODE[547]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_546_prev, 2, &gn_BGP_IPV4_NODE[545], &gn_BGP_IPV4_NODE[542]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_547_next, 1, &gn_BGP_IPV4_NODE[548]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_547_prev, 2, &gn_BGP_IPV4_NODE[546], &gn_BGP_IPV4_NODE[540]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_548_next, 1, &gn_BGP_IPV4_NODE[549]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_548_prev, 1, &gn_BGP_IPV4_NODE[547]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_549_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_549_prev, 1, &gn_BGP_IPV4_NODE[548]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_550_next, 1, &gn_BGP_IPV4_NODE[551]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_550_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_551_next, 2, &gn_BGP_IPV4_NODE[552], &gn_BGP_IPV4_NODE[554]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_551_prev, 1, &gn_BGP_IPV4_NODE[550]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_552_next, 1, &gn_BGP_IPV4_NODE[553]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_552_prev, 1, &gn_BGP_IPV4_NODE[551]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_553_next, 1, &gn_BGP_IPV4_NODE[554]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_553_prev, 1, &gn_BGP_IPV4_NODE[552]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_554_next, 1, &gn_BGP_IPV4_NODE[555]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_554_prev, 2, &gn_BGP_IPV4_NODE[553], &gn_BGP_IPV4_NODE[551]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_555_next, 1, &gn_BGP_IPV4_NODE[556]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_555_prev, 1, &gn_BGP_IPV4_NODE[554]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_556_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_556_prev, 1, &gn_BGP_IPV4_NODE[555]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_557_next, 1, &gn_BGP_IPV4_NODE[558]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_557_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_558_next, 1, &gn_BGP_IPV4_NODE[559]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_558_prev, 1, &gn_BGP_IPV4_NODE[557]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_559_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_559_prev, 1, &gn_BGP_IPV4_NODE[558]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_560_next, 1, &gn_BGP_IPV4_NODE[561]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_560_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_561_next, 1, &gn_BGP_IPV4_NODE[562]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_561_prev, 1, &gn_BGP_IPV4_NODE[560]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_562_next, 2, &gn_BGP_IPV4_NODE[563], &gn_BGP_IPV4_NODE[567]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_562_prev, 1, &gn_BGP_IPV4_NODE[561]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_563_next, 1, &gn_BGP_IPV4_NODE[564]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_563_prev, 1, &gn_BGP_IPV4_NODE[562]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_564_next, 1, &gn_BGP_IPV4_NODE[565]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_564_prev, 2, &gn_BGP_IPV4_NODE[563], &gn_BGP_IPV4_NODE[567]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_565_next, 1, &gn_BGP_IPV4_NODE[566]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_565_prev, 1, &gn_BGP_IPV4_NODE[564]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_566_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_566_prev, 1, &gn_BGP_IPV4_NODE[565]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_567_next, 1, &gn_BGP_IPV4_NODE[564]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_567_prev, 1, &gn_BGP_IPV4_NODE[562]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_568_next, 1, &gn_BGP_IPV4_NODE[569]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_568_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_569_next, 1, &gn_BGP_IPV4_NODE[570]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_569_prev, 1, &gn_BGP_IPV4_NODE[568]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_570_next, 2, &gn_BGP_IPV4_NODE[571], &gn_BGP_IPV4_NODE[575]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_570_prev, 1, &gn_BGP_IPV4_NODE[569]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_571_next, 1, &gn_BGP_IPV4_NODE[572]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_571_prev, 1, &gn_BGP_IPV4_NODE[570]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_572_next, 1, &gn_BGP_IPV4_NODE[573]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_572_prev, 2, &gn_BGP_IPV4_NODE[571], &gn_BGP_IPV4_NODE[575]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_573_next, 1, &gn_BGP_IPV4_NODE[574]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_573_prev, 1, &gn_BGP_IPV4_NODE[572]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_574_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_574_prev, 1, &gn_BGP_IPV4_NODE[573]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_575_next, 1, &gn_BGP_IPV4_NODE[572]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_575_prev, 1, &gn_BGP_IPV4_NODE[570]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_576_next, 1, &gn_BGP_IPV4_NODE[577]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_576_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_577_next, 2, &gn_BGP_IPV4_NODE[578], &gn_BGP_IPV4_NODE[592]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_577_prev, 1, &gn_BGP_IPV4_NODE[576]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_578_next, 1, &gn_BGP_IPV4_NODE[579]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_578_prev, 1, &gn_BGP_IPV4_NODE[577]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_579_next, 2, &gn_BGP_IPV4_NODE[580], &gn_BGP_IPV4_NODE[581]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_579_prev, 1, &gn_BGP_IPV4_NODE[578]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_580_next, 1, &gn_BGP_IPV4_NODE[581]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_580_prev, 1, &gn_BGP_IPV4_NODE[579]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_581_next, 1, &gn_BGP_IPV4_NODE[582]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_581_prev, 2, &gn_BGP_IPV4_NODE[580], &gn_BGP_IPV4_NODE[579]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_582_next, 2, &gn_BGP_IPV4_NODE[583], &gn_BGP_IPV4_NODE[585]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_582_prev, 1, &gn_BGP_IPV4_NODE[581]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_583_next, 1, &gn_BGP_IPV4_NODE[584]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_583_prev, 1, &gn_BGP_IPV4_NODE[582]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_584_next, 1, &gn_BGP_IPV4_NODE[585]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_584_prev, 1, &gn_BGP_IPV4_NODE[583]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_585_next, 1, &gn_BGP_IPV4_NODE[586]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_585_prev, 2, &gn_BGP_IPV4_NODE[584], &gn_BGP_IPV4_NODE[582]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_586_next, 2, &gn_BGP_IPV4_NODE[587], &gn_BGP_IPV4_NODE[588]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_586_prev, 1, &gn_BGP_IPV4_NODE[585]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_587_next, 1, &gn_BGP_IPV4_NODE[588]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_587_prev, 1, &gn_BGP_IPV4_NODE[586]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_588_next, 1, &gn_BGP_IPV4_NODE[589]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_588_prev, 2, &gn_BGP_IPV4_NODE[587], &gn_BGP_IPV4_NODE[586]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_589_next, 2, &gn_BGP_IPV4_NODE[590], &gn_BGP_IPV4_NODE[591]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_589_prev, 1, &gn_BGP_IPV4_NODE[588]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_590_next, 1, &gn_BGP_IPV4_NODE[591]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_590_prev, 1, &gn_BGP_IPV4_NODE[589]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_591_next, 1, &gn_BGP_IPV4_NODE[592]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_591_prev, 2, &gn_BGP_IPV4_NODE[590], &gn_BGP_IPV4_NODE[589]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_592_next, 1, &gn_BGP_IPV4_NODE[593]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_592_prev, 2, &gn_BGP_IPV4_NODE[591], &gn_BGP_IPV4_NODE[577]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_593_next, 1, &gn_BGP_IPV4_NODE[594]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_593_prev, 1, &gn_BGP_IPV4_NODE[592]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_594_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_594_prev, 1, &gn_BGP_IPV4_NODE[593]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_595_next, 1, &gn_BGP_IPV4_NODE[596]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_595_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_596_next, 2, &gn_BGP_IPV4_NODE[597], &gn_BGP_IPV4_NODE[598]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_596_prev, 1, &gn_BGP_IPV4_NODE[595]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_597_next, 1, &gn_BGP_IPV4_NODE[598]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_597_prev, 1, &gn_BGP_IPV4_NODE[596]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_598_next, 1, &gn_BGP_IPV4_NODE[599]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_598_prev, 2, &gn_BGP_IPV4_NODE[597], &gn_BGP_IPV4_NODE[596]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_599_next, 1, &gn_BGP_IPV4_NODE[600]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_599_prev, 1, &gn_BGP_IPV4_NODE[598]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_600_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_600_prev, 1, &gn_BGP_IPV4_NODE[599]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_601_next, 3, &gn_BGP_IPV4_NODE[602], &gn_BGP_IPV4_NODE[604], &gn_BGP_IPV4_NODE[607]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_601_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_602_next, 1, &gn_BGP_IPV4_NODE[603]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_602_prev, 1, &gn_BGP_IPV4_NODE[601]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_603_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_603_prev, 1, &gn_BGP_IPV4_NODE[602]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_604_next, 1, &gn_BGP_IPV4_NODE[605]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_604_prev, 1, &gn_BGP_IPV4_NODE[601]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_605_next, 1, &gn_BGP_IPV4_NODE[606]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_605_prev, 1, &gn_BGP_IPV4_NODE[604]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_606_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_606_prev, 1, &gn_BGP_IPV4_NODE[605]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_607_next, 1, &gn_BGP_IPV4_NODE[608]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_607_prev, 1, &gn_BGP_IPV4_NODE[601]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_608_next, 1, &gn_BGP_IPV4_NODE[609]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_608_prev, 1, &gn_BGP_IPV4_NODE[607]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_609_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_609_prev, 1, &gn_BGP_IPV4_NODE[608]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_610_next, 1, &gn_BGP_IPV4_NODE[611]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_610_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_611_next, 1, &gn_BGP_IPV4_NODE[612]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_611_prev, 1, &gn_BGP_IPV4_NODE[610]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_612_next, 1, &gn_BGP_IPV4_NODE[613]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_612_prev, 1, &gn_BGP_IPV4_NODE[611]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_613_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_613_prev, 1, &gn_BGP_IPV4_NODE[612]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_614_next, 1, &gn_BGP_IPV4_NODE[615]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_614_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_615_next, 1, &gn_BGP_IPV4_NODE[616]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_615_prev, 1, &gn_BGP_IPV4_NODE[614]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_616_next, 2, &gn_BGP_IPV4_NODE[617], &gn_BGP_IPV4_NODE[621]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_616_prev, 1, &gn_BGP_IPV4_NODE[615]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_617_next, 1, &gn_BGP_IPV4_NODE[618]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_617_prev, 1, &gn_BGP_IPV4_NODE[616]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_618_next, 1, &gn_BGP_IPV4_NODE[619]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_618_prev, 2, &gn_BGP_IPV4_NODE[617], &gn_BGP_IPV4_NODE[621]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_619_next, 1, &gn_BGP_IPV4_NODE[620]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_619_prev, 1, &gn_BGP_IPV4_NODE[618]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_620_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_620_prev, 1, &gn_BGP_IPV4_NODE[619]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_621_next, 1, &gn_BGP_IPV4_NODE[618]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_621_prev, 1, &gn_BGP_IPV4_NODE[616]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_622_next, 3, &gn_BGP_IPV4_NODE[623], &gn_BGP_IPV4_NODE[625], &gn_BGP_IPV4_NODE[631]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_622_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_623_next, 1, &gn_BGP_IPV4_NODE[624]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_623_prev, 1, &gn_BGP_IPV4_NODE[622]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_624_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_624_prev, 1, &gn_BGP_IPV4_NODE[623]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_625_next, 2, &gn_BGP_IPV4_NODE[626], &gn_BGP_IPV4_NODE[628]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_625_prev, 1, &gn_BGP_IPV4_NODE[622]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_626_next, 1, &gn_BGP_IPV4_NODE[627]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_626_prev, 1, &gn_BGP_IPV4_NODE[625]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_627_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_627_prev, 1, &gn_BGP_IPV4_NODE[626]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_628_next, 1, &gn_BGP_IPV4_NODE[629]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_628_prev, 1, &gn_BGP_IPV4_NODE[625]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_629_next, 1, &gn_BGP_IPV4_NODE[630]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_629_prev, 1, &gn_BGP_IPV4_NODE[628]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_630_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_630_prev, 1, &gn_BGP_IPV4_NODE[629]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_631_next, 1, &gn_BGP_IPV4_NODE[632]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_631_prev, 1, &gn_BGP_IPV4_NODE[622]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_632_next, 1, &gn_BGP_IPV4_NODE[633]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_632_prev, 1, &gn_BGP_IPV4_NODE[631]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_633_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_633_prev, 1, &gn_BGP_IPV4_NODE[632]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_634_next, 1, &gn_BGP_IPV4_NODE[635]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_634_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_635_next, 1, &gn_BGP_IPV4_NODE[636]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_635_prev, 1, &gn_BGP_IPV4_NODE[634]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_636_next, 2, &gn_BGP_IPV4_NODE[637], &gn_BGP_IPV4_NODE[641]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_636_prev, 1, &gn_BGP_IPV4_NODE[635]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_637_next, 1, &gn_BGP_IPV4_NODE[638]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_637_prev, 1, &gn_BGP_IPV4_NODE[636]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_638_next, 1, &gn_BGP_IPV4_NODE[639]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_638_prev, 2, &gn_BGP_IPV4_NODE[637], &gn_BGP_IPV4_NODE[641]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_639_next, 1, &gn_BGP_IPV4_NODE[640]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_639_prev, 1, &gn_BGP_IPV4_NODE[638]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_640_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_640_prev, 1, &gn_BGP_IPV4_NODE[639]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_641_next, 1, &gn_BGP_IPV4_NODE[638]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_641_prev, 1, &gn_BGP_IPV4_NODE[636]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_642_next, 1, &gn_BGP_IPV4_NODE[643]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_642_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_643_next, 1, &gn_BGP_IPV4_NODE[644]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_643_prev, 1, &gn_BGP_IPV4_NODE[642]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_644_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_644_prev, 1, &gn_BGP_IPV4_NODE[643]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_645_next, 1, &gn_BGP_IPV4_NODE[646]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_645_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_646_next, 1, &gn_BGP_IPV4_NODE[647]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_646_prev, 1, &gn_BGP_IPV4_NODE[645]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_647_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_647_prev, 1, &gn_BGP_IPV4_NODE[646]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_648_next, 2, &gn_BGP_IPV4_NODE[649], &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_648_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_649_next, 1, &gn_BGP_IPV4_NODE[650]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_649_prev, 1, &gn_BGP_IPV4_NODE[648]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_650_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_650_prev, 1, &gn_BGP_IPV4_NODE[649]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_651_next, 5, &gn_BGP_IPV4_NODE[652], &gn_BGP_IPV4_NODE[656], &gn_BGP_IPV4_NODE[657], &gn_BGP_IPV4_NODE[658], &gn_BGP_IPV4_NODE[659]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_651_prev, 1, &gn_BGP_IPV4_NODE[648]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_652_next, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_652_prev, 1, &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_653_next, 1, &gn_BGP_IPV4_NODE[654]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_653_prev, 5, &gn_BGP_IPV4_NODE[652], &gn_BGP_IPV4_NODE[656], &gn_BGP_IPV4_NODE[657], &gn_BGP_IPV4_NODE[658], &gn_BGP_IPV4_NODE[659]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_654_next, 1, &gn_BGP_IPV4_NODE[655]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_654_prev, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_655_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_655_prev, 1, &gn_BGP_IPV4_NODE[654]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_656_next, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_656_prev, 1, &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_657_next, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_657_prev, 1, &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_658_next, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_658_prev, 1, &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_659_next, 1, &gn_BGP_IPV4_NODE[653]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_659_prev, 1, &gn_BGP_IPV4_NODE[651]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_660_next, 1, &gn_BGP_IPV4_NODE[661]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_660_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_661_next, 1, &gn_BGP_IPV4_NODE[662]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_661_prev, 1, &gn_BGP_IPV4_NODE[660]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_662_next, 1, &gn_BGP_IPV4_NODE[663]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_662_prev, 1, &gn_BGP_IPV4_NODE[661]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_663_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_663_prev, 1, &gn_BGP_IPV4_NODE[662]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_664_next, 1, &gn_BGP_IPV4_NODE[665]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_664_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_665_next, 2, &gn_BGP_IPV4_NODE[666], &gn_BGP_IPV4_NODE[667]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_665_prev, 1, &gn_BGP_IPV4_NODE[664]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_666_next, 1, &gn_BGP_IPV4_NODE[667]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_666_prev, 1, &gn_BGP_IPV4_NODE[665]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_667_next, 1, &gn_BGP_IPV4_NODE[668]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_667_prev, 2, &gn_BGP_IPV4_NODE[666], &gn_BGP_IPV4_NODE[665]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_668_next, 1, &gn_BGP_IPV4_NODE[669]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_668_prev, 1, &gn_BGP_IPV4_NODE[667]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_669_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_669_prev, 1, &gn_BGP_IPV4_NODE[668]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_670_next, 1, &gn_BGP_IPV4_NODE[671]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_670_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_671_next, 1, &gn_BGP_IPV4_NODE[672]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_671_prev, 1, &gn_BGP_IPV4_NODE[670]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_672_next, 1, &gn_BGP_IPV4_NODE[673]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_672_prev, 1, &gn_BGP_IPV4_NODE[671]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_673_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_673_prev, 1, &gn_BGP_IPV4_NODE[672]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_674_next, 1, &gn_BGP_IPV4_NODE[675]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_674_prev, 1, &gn_BGP_IPV4_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_675_next, 2, &gn_BGP_IPV4_NODE[676], &gn_BGP_IPV4_NODE[677]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_675_prev, 1, &gn_BGP_IPV4_NODE[674]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_676_next, 1, &gn_BGP_IPV4_NODE[677]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_676_prev, 1, &gn_BGP_IPV4_NODE[675]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_677_next, 1, &gn_BGP_IPV4_NODE[678]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_677_prev, 2, &gn_BGP_IPV4_NODE[676], &gn_BGP_IPV4_NODE[675]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_678_next, 1, &gn_BGP_IPV4_NODE[679]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_678_prev, 1, &gn_BGP_IPV4_NODE[677]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_679_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_679_prev, 1, &gn_BGP_IPV4_NODE[678]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_680_next, 1, &gn_BGP_IPV4_NODE[681]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_680_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_681_next, 1, &gn_BGP_IPV4_NODE[682]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_681_prev, 1, &gn_BGP_IPV4_NODE[680]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_682_next, 1, &gn_BGP_IPV4_NODE[683]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_682_prev, 1, &gn_BGP_IPV4_NODE[681]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_683_next, 1, &gn_BGP_IPV4_NODE[684]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_683_prev, 1, &gn_BGP_IPV4_NODE[682]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_684_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_684_prev, 1, &gn_BGP_IPV4_NODE[683]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_685_next, 2, &gn_BGP_IPV4_NODE[686], &gn_BGP_IPV4_NODE[711]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_685_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_686_next, 13, &gn_BGP_IPV4_NODE[687], &gn_BGP_IPV4_NODE[699], &gn_BGP_IPV4_NODE[700], &gn_BGP_IPV4_NODE[701], &gn_BGP_IPV4_NODE[702], &gn_BGP_IPV4_NODE[703], &gn_BGP_IPV4_NODE[704], &gn_BGP_IPV4_NODE[705], &gn_BGP_IPV4_NODE[706], &gn_BGP_IPV4_NODE[707], &gn_BGP_IPV4_NODE[708], &gn_BGP_IPV4_NODE[709], &gn_BGP_IPV4_NODE[710]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_686_prev, 1, &gn_BGP_IPV4_NODE[685]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_687_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_687_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_688_next, 1, &gn_BGP_IPV4_NODE[689]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_688_prev, 13, &gn_BGP_IPV4_NODE[687], &gn_BGP_IPV4_NODE[699], &gn_BGP_IPV4_NODE[700], &gn_BGP_IPV4_NODE[701], &gn_BGP_IPV4_NODE[702], &gn_BGP_IPV4_NODE[703], &gn_BGP_IPV4_NODE[704], &gn_BGP_IPV4_NODE[705], &gn_BGP_IPV4_NODE[706], &gn_BGP_IPV4_NODE[707], &gn_BGP_IPV4_NODE[708], &gn_BGP_IPV4_NODE[709], &gn_BGP_IPV4_NODE[710]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_689_next, 2, &gn_BGP_IPV4_NODE[690], &gn_BGP_IPV4_NODE[694]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_689_prev, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_690_next, 2, &gn_BGP_IPV4_NODE[691], &gn_BGP_IPV4_NODE[697]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_690_prev, 2, &gn_BGP_IPV4_NODE[693], &gn_BGP_IPV4_NODE[689]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_691_next, 1, &gn_BGP_IPV4_NODE[692]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_691_prev, 1, &gn_BGP_IPV4_NODE[690]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_692_next, 1, &gn_BGP_IPV4_NODE[693]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_692_prev, 1, &gn_BGP_IPV4_NODE[691]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_693_next, 2, &gn_BGP_IPV4_NODE[690], &gn_BGP_IPV4_NODE[694]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_693_prev, 2, &gn_BGP_IPV4_NODE[692], &gn_BGP_IPV4_NODE[698]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_694_next, 1, &gn_BGP_IPV4_NODE[695]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_694_prev, 2, &gn_BGP_IPV4_NODE[693], &gn_BGP_IPV4_NODE[689]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_695_next, 1, &gn_BGP_IPV4_NODE[696]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_695_prev, 1, &gn_BGP_IPV4_NODE[694]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_696_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_696_prev, 1, &gn_BGP_IPV4_NODE[695]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_697_next, 1, &gn_BGP_IPV4_NODE[698]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_697_prev, 1, &gn_BGP_IPV4_NODE[690]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_698_next, 1, &gn_BGP_IPV4_NODE[693]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_698_prev, 1, &gn_BGP_IPV4_NODE[697]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_699_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_699_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_700_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_700_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_701_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_701_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_702_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_702_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_703_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_703_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_704_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_704_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_705_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_705_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_706_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_706_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_707_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_707_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_708_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_708_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_709_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_709_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_710_next, 1, &gn_BGP_IPV4_NODE[688]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_710_prev, 1, &gn_BGP_IPV4_NODE[686]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_711_next, 3, &gn_BGP_IPV4_NODE[712], &gn_BGP_IPV4_NODE[725], &gn_BGP_IPV4_NODE[726]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_711_prev, 1, &gn_BGP_IPV4_NODE[685]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_712_next, 1, &gn_BGP_IPV4_NODE[713]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_712_prev, 1, &gn_BGP_IPV4_NODE[711]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_713_next, 1, &gn_BGP_IPV4_NODE[714]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_713_prev, 3, &gn_BGP_IPV4_NODE[712], &gn_BGP_IPV4_NODE[725], &gn_BGP_IPV4_NODE[726]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_714_next, 1, &gn_BGP_IPV4_NODE[715]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_714_prev, 1, &gn_BGP_IPV4_NODE[713]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_715_next, 2, &gn_BGP_IPV4_NODE[716], &gn_BGP_IPV4_NODE[720]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_715_prev, 1, &gn_BGP_IPV4_NODE[714]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_716_next, 2, &gn_BGP_IPV4_NODE[717], &gn_BGP_IPV4_NODE[723]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_716_prev, 2, &gn_BGP_IPV4_NODE[719], &gn_BGP_IPV4_NODE[715]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_717_next, 1, &gn_BGP_IPV4_NODE[718]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_717_prev, 1, &gn_BGP_IPV4_NODE[716]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_718_next, 1, &gn_BGP_IPV4_NODE[719]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_718_prev, 1, &gn_BGP_IPV4_NODE[717]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_719_next, 2, &gn_BGP_IPV4_NODE[716], &gn_BGP_IPV4_NODE[720]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_719_prev, 2, &gn_BGP_IPV4_NODE[718], &gn_BGP_IPV4_NODE[724]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_720_next, 1, &gn_BGP_IPV4_NODE[721]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_720_prev, 2, &gn_BGP_IPV4_NODE[719], &gn_BGP_IPV4_NODE[715]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_721_next, 1, &gn_BGP_IPV4_NODE[722]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_721_prev, 1, &gn_BGP_IPV4_NODE[720]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_722_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_722_prev, 1, &gn_BGP_IPV4_NODE[721]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_723_next, 1, &gn_BGP_IPV4_NODE[724]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_723_prev, 1, &gn_BGP_IPV4_NODE[716]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_724_next, 1, &gn_BGP_IPV4_NODE[719]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_724_prev, 1, &gn_BGP_IPV4_NODE[723]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_725_next, 1, &gn_BGP_IPV4_NODE[713]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_725_prev, 1, &gn_BGP_IPV4_NODE[711]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_726_next, 1, &gn_BGP_IPV4_NODE[713]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_726_prev, 1, &gn_BGP_IPV4_NODE[711]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_727_next, 1, &gn_BGP_IPV4_NODE[728]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_727_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_728_next, 1, &gn_BGP_IPV4_NODE[729]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_728_prev, 1, &gn_BGP_IPV4_NODE[727]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_729_next, 2, &gn_BGP_IPV4_NODE[730], &gn_BGP_IPV4_NODE[734]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_729_prev, 1, &gn_BGP_IPV4_NODE[728]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_730_next, 1, &gn_BGP_IPV4_NODE[731]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_730_prev, 1, &gn_BGP_IPV4_NODE[729]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_731_next, 1, &gn_BGP_IPV4_NODE[732]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_731_prev, 2, &gn_BGP_IPV4_NODE[730], &gn_BGP_IPV4_NODE[734]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_732_next, 1, &gn_BGP_IPV4_NODE[733]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_732_prev, 1, &gn_BGP_IPV4_NODE[731]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_733_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_733_prev, 1, &gn_BGP_IPV4_NODE[732]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_734_next, 1, &gn_BGP_IPV4_NODE[731]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_734_prev, 1, &gn_BGP_IPV4_NODE[729]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_735_next, 1, &gn_BGP_IPV4_NODE[736]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_735_prev, 1, &gn_BGP_IPV4_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_736_next, 1, &gn_BGP_IPV4_NODE[737]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_736_prev, 1, &gn_BGP_IPV4_NODE[735]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_737_next, 1, &gn_BGP_IPV4_NODE[738]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_737_prev, 1, &gn_BGP_IPV4_NODE[736]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_738_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_738_prev, 1, &gn_BGP_IPV4_NODE[737]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_739_next, 2, &gn_BGP_IPV4_NODE[740], &gn_BGP_IPV4_NODE[773]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_739_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_740_next, 13, &gn_BGP_IPV4_NODE[741], &gn_BGP_IPV4_NODE[745], &gn_BGP_IPV4_NODE[746], &gn_BGP_IPV4_NODE[747], &gn_BGP_IPV4_NODE[748], &gn_BGP_IPV4_NODE[749], &gn_BGP_IPV4_NODE[750], &gn_BGP_IPV4_NODE[751], &gn_BGP_IPV4_NODE[752], &gn_BGP_IPV4_NODE[753], &gn_BGP_IPV4_NODE[754], &gn_BGP_IPV4_NODE[755], &gn_BGP_IPV4_NODE[756]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_740_prev, 1, &gn_BGP_IPV4_NODE[739]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_741_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_741_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_742_next, 3, &gn_BGP_IPV4_NODE[743], &gn_BGP_IPV4_NODE[757], &gn_BGP_IPV4_NODE[765]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_742_prev, 13, &gn_BGP_IPV4_NODE[741], &gn_BGP_IPV4_NODE[745], &gn_BGP_IPV4_NODE[746], &gn_BGP_IPV4_NODE[747], &gn_BGP_IPV4_NODE[748], &gn_BGP_IPV4_NODE[749], &gn_BGP_IPV4_NODE[750], &gn_BGP_IPV4_NODE[751], &gn_BGP_IPV4_NODE[752], &gn_BGP_IPV4_NODE[753], &gn_BGP_IPV4_NODE[754], &gn_BGP_IPV4_NODE[755], &gn_BGP_IPV4_NODE[756]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_743_next, 1, &gn_BGP_IPV4_NODE[744]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_743_prev, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_744_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_744_prev, 1, &gn_BGP_IPV4_NODE[743]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_745_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_745_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_746_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_746_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_747_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_747_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_748_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_748_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_749_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_749_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_750_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_750_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_751_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_751_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_752_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_752_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_753_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_753_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_754_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_754_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_755_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_755_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_756_next, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_756_prev, 1, &gn_BGP_IPV4_NODE[740]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_757_next, 1, &gn_BGP_IPV4_NODE[758]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_757_prev, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_758_next, 2, &gn_BGP_IPV4_NODE[759], &gn_BGP_IPV4_NODE[761]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_758_prev, 1, &gn_BGP_IPV4_NODE[757]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_759_next, 1, &gn_BGP_IPV4_NODE[760]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_759_prev, 1, &gn_BGP_IPV4_NODE[758]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_760_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_760_prev, 1, &gn_BGP_IPV4_NODE[759]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_761_next, 1, &gn_BGP_IPV4_NODE[762]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_761_prev, 1, &gn_BGP_IPV4_NODE[758]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_762_next, 1, &gn_BGP_IPV4_NODE[763]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_762_prev, 1, &gn_BGP_IPV4_NODE[761]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_763_next, 1, &gn_BGP_IPV4_NODE[764]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_763_prev, 1, &gn_BGP_IPV4_NODE[762]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_764_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_764_prev, 1, &gn_BGP_IPV4_NODE[763]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_765_next, 1, &gn_BGP_IPV4_NODE[766]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_765_prev, 1, &gn_BGP_IPV4_NODE[742]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_766_next, 2, &gn_BGP_IPV4_NODE[767], &gn_BGP_IPV4_NODE[769]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_766_prev, 1, &gn_BGP_IPV4_NODE[765]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_767_next, 1, &gn_BGP_IPV4_NODE[768]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_767_prev, 1, &gn_BGP_IPV4_NODE[766]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_768_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_768_prev, 1, &gn_BGP_IPV4_NODE[767]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_769_next, 1, &gn_BGP_IPV4_NODE[770]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_769_prev, 1, &gn_BGP_IPV4_NODE[766]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_770_next, 1, &gn_BGP_IPV4_NODE[771]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_770_prev, 1, &gn_BGP_IPV4_NODE[769]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_771_next, 1, &gn_BGP_IPV4_NODE[772]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_771_prev, 1, &gn_BGP_IPV4_NODE[770]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_772_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_772_prev, 1, &gn_BGP_IPV4_NODE[771]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_773_next, 3, &gn_BGP_IPV4_NODE[774], &gn_BGP_IPV4_NODE[779], &gn_BGP_IPV4_NODE[780]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_773_prev, 1, &gn_BGP_IPV4_NODE[739]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_774_next, 1, &gn_BGP_IPV4_NODE[775]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_774_prev, 1, &gn_BGP_IPV4_NODE[773]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_775_next, 1, &gn_BGP_IPV4_NODE[776]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_775_prev, 3, &gn_BGP_IPV4_NODE[774], &gn_BGP_IPV4_NODE[779], &gn_BGP_IPV4_NODE[780]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_776_next, 3, &gn_BGP_IPV4_NODE[777], &gn_BGP_IPV4_NODE[781], &gn_BGP_IPV4_NODE[789]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_776_prev, 1, &gn_BGP_IPV4_NODE[775]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_777_next, 1, &gn_BGP_IPV4_NODE[778]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_777_prev, 1, &gn_BGP_IPV4_NODE[776]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_778_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_778_prev, 1, &gn_BGP_IPV4_NODE[777]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_779_next, 1, &gn_BGP_IPV4_NODE[775]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_779_prev, 1, &gn_BGP_IPV4_NODE[773]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_780_next, 1, &gn_BGP_IPV4_NODE[775]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_780_prev, 1, &gn_BGP_IPV4_NODE[773]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_781_next, 1, &gn_BGP_IPV4_NODE[782]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_781_prev, 1, &gn_BGP_IPV4_NODE[776]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_782_next, 2, &gn_BGP_IPV4_NODE[783], &gn_BGP_IPV4_NODE[785]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_782_prev, 1, &gn_BGP_IPV4_NODE[781]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_783_next, 1, &gn_BGP_IPV4_NODE[784]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_783_prev, 1, &gn_BGP_IPV4_NODE[782]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_784_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_784_prev, 1, &gn_BGP_IPV4_NODE[783]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_785_next, 1, &gn_BGP_IPV4_NODE[786]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_785_prev, 1, &gn_BGP_IPV4_NODE[782]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_786_next, 1, &gn_BGP_IPV4_NODE[787]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_786_prev, 1, &gn_BGP_IPV4_NODE[785]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_787_next, 1, &gn_BGP_IPV4_NODE[788]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_787_prev, 1, &gn_BGP_IPV4_NODE[786]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_788_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_788_prev, 1, &gn_BGP_IPV4_NODE[787]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_789_next, 1, &gn_BGP_IPV4_NODE[790]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_789_prev, 1, &gn_BGP_IPV4_NODE[776]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_790_next, 2, &gn_BGP_IPV4_NODE[791], &gn_BGP_IPV4_NODE[793]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_790_prev, 1, &gn_BGP_IPV4_NODE[789]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_791_next, 1, &gn_BGP_IPV4_NODE[792]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_791_prev, 1, &gn_BGP_IPV4_NODE[790]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_792_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_792_prev, 1, &gn_BGP_IPV4_NODE[791]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_793_next, 1, &gn_BGP_IPV4_NODE[794]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_793_prev, 1, &gn_BGP_IPV4_NODE[790]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_794_next, 1, &gn_BGP_IPV4_NODE[795]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_794_prev, 1, &gn_BGP_IPV4_NODE[793]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_795_next, 1, &gn_BGP_IPV4_NODE[796]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_795_prev, 1, &gn_BGP_IPV4_NODE[794]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_796_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_796_prev, 1, &gn_BGP_IPV4_NODE[795]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_797_next, 1, &gn_BGP_IPV4_NODE[798]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_797_prev, 1, &gn_BGP_IPV4_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_798_next, 1, &gn_BGP_IPV4_NODE[799]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_798_prev, 1, &gn_BGP_IPV4_NODE[797]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_799_next, 1, &gn_BGP_IPV4_NODE[800]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_799_prev, 1, &gn_BGP_IPV4_NODE[798]);
MAKE_VECTOR(gn_BGP_IPV4_NODE_800_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4_NODE_800_prev, 1, &gn_BGP_IPV4_NODE[799]);

static struct graph_node gn_BGP_IPV4_NODE[] = {
	{
		.from = &gn_BGP_IPV4_NODE_0_prev,
		.to = &gn_BGP_IPV4_NODE_0_next,
		.data = &ctkn_BGP_IPV4_NODE[0],
	},
	{
		.from = &gn_BGP_IPV4_NODE_1_prev,
		.to = &gn_BGP_IPV4_NODE_1_next,
		.data = &ctkn_BGP_IPV4_NODE[1],
	},
	{
		.from = &gn_BGP_IPV4_NODE_2_prev,
		.to = &gn_BGP_IPV4_NODE_2_next,
		.data = &ctkn_BGP_IPV4_NODE[2],
	},
	{
		.from = &gn_BGP_IPV4_NODE_3_prev,
		.to = &gn_BGP_IPV4_NODE_3_next,
		.data = &ctkn_BGP_IPV4_NODE[3],
	},
	{
		.from = &gn_BGP_IPV4_NODE_4_prev,
		.to = &gn_BGP_IPV4_NODE_4_next,
		.data = &ctkn_BGP_IPV4_NODE[4],
	},
	{
		.from = &gn_BGP_IPV4_NODE_5_prev,
		.to = &gn_BGP_IPV4_NODE_5_next,
		.data = &ctkn_BGP_IPV4_NODE[5],
	},
	{
		.from = &gn_BGP_IPV4_NODE_6_prev,
		.to = &gn_BGP_IPV4_NODE_6_next,
		.data = &ctkn_BGP_IPV4_NODE[6],
	},
	{
		.from = &gn_BGP_IPV4_NODE_7_prev,
		.to = &gn_BGP_IPV4_NODE_7_next,
		.data = &ctkn_BGP_IPV4_NODE[7],
	},
	{
		.from = &gn_BGP_IPV4_NODE_8_prev,
		.to = &gn_BGP_IPV4_NODE_8_next,
		.data = &ctkn_BGP_IPV4_NODE[8],
	},
	{
		.from = &gn_BGP_IPV4_NODE_9_prev,
		.to = &gn_BGP_IPV4_NODE_9_next,
		.data = (void *)&bgp_imexport_vpn_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_10_prev,
		.to = &gn_BGP_IPV4_NODE_10_next,
		.data = &ctkn_BGP_IPV4_NODE[10],
	},
	{
		.from = &gn_BGP_IPV4_NODE_11_prev,
		.to = &gn_BGP_IPV4_NODE_11_next,
		.data = &ctkn_BGP_IPV4_NODE[11],
	},
	{
		.from = &gn_BGP_IPV4_NODE_12_prev,
		.to = &gn_BGP_IPV4_NODE_12_next,
		.data = &ctkn_BGP_IPV4_NODE[12],
	},
	{
		.from = &gn_BGP_IPV4_NODE_13_prev,
		.to = &gn_BGP_IPV4_NODE_13_next,
		.data = &ctkn_BGP_IPV4_NODE[13],
	},
	{
		.from = &gn_BGP_IPV4_NODE_14_prev,
		.to = &gn_BGP_IPV4_NODE_14_next,
		.data = &ctkn_BGP_IPV4_NODE[14],
	},
	{
		.from = &gn_BGP_IPV4_NODE_15_prev,
		.to = &gn_BGP_IPV4_NODE_15_next,
		.data = &ctkn_BGP_IPV4_NODE[15],
	},
	{
		.from = &gn_BGP_IPV4_NODE_16_prev,
		.to = &gn_BGP_IPV4_NODE_16_next,
		.data = &ctkn_BGP_IPV4_NODE[16],
	},
	{
		.from = &gn_BGP_IPV4_NODE_17_prev,
		.to = &gn_BGP_IPV4_NODE_17_next,
		.data = &ctkn_BGP_IPV4_NODE[17],
	},
	{
		.from = &gn_BGP_IPV4_NODE_18_prev,
		.to = &gn_BGP_IPV4_NODE_18_next,
		.data = &ctkn_BGP_IPV4_NODE[18],
	},
	{
		.from = &gn_BGP_IPV4_NODE_19_prev,
		.to = &gn_BGP_IPV4_NODE_19_next,
		.data = &ctkn_BGP_IPV4_NODE[19],
	},
	{
		.from = &gn_BGP_IPV4_NODE_20_prev,
		.to = &gn_BGP_IPV4_NODE_20_next,
		.data = (void *)&af_rt_vpn_imexport_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_21_prev,
		.to = &gn_BGP_IPV4_NODE_21_next,
		.data = &ctkn_BGP_IPV4_NODE[21],
	},
	{
		.from = &gn_BGP_IPV4_NODE_22_prev,
		.to = &gn_BGP_IPV4_NODE_22_next,
		.data = &ctkn_BGP_IPV4_NODE[22],
	},
	{
		.from = &gn_BGP_IPV4_NODE_23_prev,
		.to = &gn_BGP_IPV4_NODE_23_next,
		.data = &ctkn_BGP_IPV4_NODE[23],
	},
	{
		.from = &gn_BGP_IPV4_NODE_24_prev,
		.to = &gn_BGP_IPV4_NODE_24_next,
		.data = &ctkn_BGP_IPV4_NODE[24],
	},
	{
		.from = &gn_BGP_IPV4_NODE_25_prev,
		.to = &gn_BGP_IPV4_NODE_25_next,
		.data = &ctkn_BGP_IPV4_NODE[25],
	},
	{
		.from = &gn_BGP_IPV4_NODE_26_prev,
		.to = &gn_BGP_IPV4_NODE_26_next,
		.data = &ctkn_BGP_IPV4_NODE[26],
	},
	{
		.from = &gn_BGP_IPV4_NODE_27_prev,
		.to = &gn_BGP_IPV4_NODE_27_next,
		.data = &ctkn_BGP_IPV4_NODE[27],
	},
	{
		.from = &gn_BGP_IPV4_NODE_28_prev,
		.to = &gn_BGP_IPV4_NODE_28_next,
		.data = &ctkn_BGP_IPV4_NODE[28],
	},
	{
		.from = &gn_BGP_IPV4_NODE_29_prev,
		.to = &gn_BGP_IPV4_NODE_29_next,
		.data = &ctkn_BGP_IPV4_NODE[29],
	},
	{
		.from = &gn_BGP_IPV4_NODE_30_prev,
		.to = &gn_BGP_IPV4_NODE_30_next,
		.data = &ctkn_BGP_IPV4_NODE[30],
	},
	{
		.from = &gn_BGP_IPV4_NODE_31_prev,
		.to = &gn_BGP_IPV4_NODE_31_next,
		.data = (void *)&af_routetarget_import_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_32_prev,
		.to = &gn_BGP_IPV4_NODE_32_next,
		.data = &ctkn_BGP_IPV4_NODE[32],
	},
	{
		.from = &gn_BGP_IPV4_NODE_33_prev,
		.to = &gn_BGP_IPV4_NODE_33_next,
		.data = &ctkn_BGP_IPV4_NODE[33],
	},
	{
		.from = &gn_BGP_IPV4_NODE_34_prev,
		.to = &gn_BGP_IPV4_NODE_34_next,
		.data = &ctkn_BGP_IPV4_NODE[34],
	},
	{
		.from = &gn_BGP_IPV4_NODE_35_prev,
		.to = &gn_BGP_IPV4_NODE_35_next,
		.data = &ctkn_BGP_IPV4_NODE[35],
	},
	{
		.from = &gn_BGP_IPV4_NODE_36_prev,
		.to = &gn_BGP_IPV4_NODE_36_next,
		.data = &ctkn_BGP_IPV4_NODE[36],
	},
	{
		.from = &gn_BGP_IPV4_NODE_37_prev,
		.to = &gn_BGP_IPV4_NODE_37_next,
		.data = &ctkn_BGP_IPV4_NODE[37],
	},
	{
		.from = &gn_BGP_IPV4_NODE_38_prev,
		.to = &gn_BGP_IPV4_NODE_38_next,
		.data = &ctkn_BGP_IPV4_NODE[38],
	},
	{
		.from = &gn_BGP_IPV4_NODE_39_prev,
		.to = &gn_BGP_IPV4_NODE_39_next,
		.data = &ctkn_BGP_IPV4_NODE[39],
	},
	{
		.from = &gn_BGP_IPV4_NODE_40_prev,
		.to = &gn_BGP_IPV4_NODE_40_next,
		.data = &ctkn_BGP_IPV4_NODE[40],
	},
	{
		.from = &gn_BGP_IPV4_NODE_41_prev,
		.to = &gn_BGP_IPV4_NODE_41_next,
		.data = &ctkn_BGP_IPV4_NODE[41],
	},
	{
		.from = &gn_BGP_IPV4_NODE_42_prev,
		.to = &gn_BGP_IPV4_NODE_42_next,
		.data = &ctkn_BGP_IPV4_NODE[42],
	},
	{
		.from = &gn_BGP_IPV4_NODE_43_prev,
		.to = &gn_BGP_IPV4_NODE_43_next,
		.data = &ctkn_BGP_IPV4_NODE[43],
	},
	{
		.from = &gn_BGP_IPV4_NODE_44_prev,
		.to = &gn_BGP_IPV4_NODE_44_next,
		.data = &ctkn_BGP_IPV4_NODE[44],
	},
	{
		.from = &gn_BGP_IPV4_NODE_45_prev,
		.to = &gn_BGP_IPV4_NODE_45_next,
		.data = (void *)&aggregate_addressv4_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_46_prev,
		.to = &gn_BGP_IPV4_NODE_46_next,
		.data = &ctkn_BGP_IPV4_NODE[46],
	},
	{
		.from = &gn_BGP_IPV4_NODE_47_prev,
		.to = &gn_BGP_IPV4_NODE_47_next,
		.data = &ctkn_BGP_IPV4_NODE[47],
	},
	{
		.from = &gn_BGP_IPV4_NODE_48_prev,
		.to = &gn_BGP_IPV4_NODE_48_next,
		.data = &ctkn_BGP_IPV4_NODE[48],
	},
	{
		.from = &gn_BGP_IPV4_NODE_49_prev,
		.to = &gn_BGP_IPV4_NODE_49_next,
		.data = &ctkn_BGP_IPV4_NODE[49],
	},
	{
		.from = &gn_BGP_IPV4_NODE_50_prev,
		.to = &gn_BGP_IPV4_NODE_50_next,
		.data = &ctkn_BGP_IPV4_NODE[50],
	},
	{
		.from = &gn_BGP_IPV4_NODE_51_prev,
		.to = &gn_BGP_IPV4_NODE_51_next,
		.data = &ctkn_BGP_IPV4_NODE[51],
	},
	{
		.from = &gn_BGP_IPV4_NODE_52_prev,
		.to = &gn_BGP_IPV4_NODE_52_next,
		.data = &ctkn_BGP_IPV4_NODE[52],
	},
	{
		.from = &gn_BGP_IPV4_NODE_53_prev,
		.to = &gn_BGP_IPV4_NODE_53_next,
		.data = &ctkn_BGP_IPV4_NODE[53],
	},
	{
		.from = &gn_BGP_IPV4_NODE_54_prev,
		.to = &gn_BGP_IPV4_NODE_54_next,
		.data = &ctkn_BGP_IPV4_NODE[54],
	},
	{
		.from = &gn_BGP_IPV4_NODE_55_prev,
		.to = &gn_BGP_IPV4_NODE_55_next,
		.data = &ctkn_BGP_IPV4_NODE[55],
	},
	{
		.from = &gn_BGP_IPV4_NODE_56_prev,
		.to = &gn_BGP_IPV4_NODE_56_next,
		.data = &ctkn_BGP_IPV4_NODE[56],
	},
	{
		.from = &gn_BGP_IPV4_NODE_57_prev,
		.to = &gn_BGP_IPV4_NODE_57_next,
		.data = &ctkn_BGP_IPV4_NODE[57],
	},
	{
		.from = &gn_BGP_IPV4_NODE_58_prev,
		.to = &gn_BGP_IPV4_NODE_58_next,
		.data = &ctkn_BGP_IPV4_NODE[58],
	},
	{
		.from = &gn_BGP_IPV4_NODE_59_prev,
		.to = &gn_BGP_IPV4_NODE_59_next,
		.data = &ctkn_BGP_IPV4_NODE[59],
	},
	{
		.from = &gn_BGP_IPV4_NODE_60_prev,
		.to = &gn_BGP_IPV4_NODE_60_next,
		.data = &ctkn_BGP_IPV4_NODE[60],
	},
	{
		.from = &gn_BGP_IPV4_NODE_61_prev,
		.to = &gn_BGP_IPV4_NODE_61_next,
		.data = &ctkn_BGP_IPV4_NODE[61],
	},
	{
		.from = &gn_BGP_IPV4_NODE_62_prev,
		.to = &gn_BGP_IPV4_NODE_62_next,
		.data = &ctkn_BGP_IPV4_NODE[62],
	},
	{
		.from = &gn_BGP_IPV4_NODE_63_prev,
		.to = &gn_BGP_IPV4_NODE_63_next,
		.data = &ctkn_BGP_IPV4_NODE[63],
	},
	{
		.from = &gn_BGP_IPV4_NODE_64_prev,
		.to = &gn_BGP_IPV4_NODE_64_next,
		.data = (void *)&bgp_imexport_vrf_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_65_prev,
		.to = &gn_BGP_IPV4_NODE_65_next,
		.data = &ctkn_BGP_IPV4_NODE[65],
	},
	{
		.from = &gn_BGP_IPV4_NODE_66_prev,
		.to = &gn_BGP_IPV4_NODE_66_next,
		.data = &ctkn_BGP_IPV4_NODE[66],
	},
	{
		.from = &gn_BGP_IPV4_NODE_67_prev,
		.to = &gn_BGP_IPV4_NODE_67_next,
		.data = &ctkn_BGP_IPV4_NODE[67],
	},
	{
		.from = &gn_BGP_IPV4_NODE_68_prev,
		.to = &gn_BGP_IPV4_NODE_68_next,
		.data = &ctkn_BGP_IPV4_NODE[68],
	},
	{
		.from = &gn_BGP_IPV4_NODE_69_prev,
		.to = &gn_BGP_IPV4_NODE_69_next,
		.data = &ctkn_BGP_IPV4_NODE[69],
	},
	{
		.from = &gn_BGP_IPV4_NODE_70_prev,
		.to = &gn_BGP_IPV4_NODE_70_next,
		.data = &ctkn_BGP_IPV4_NODE[70],
	},
	{
		.from = &gn_BGP_IPV4_NODE_71_prev,
		.to = &gn_BGP_IPV4_NODE_71_next,
		.data = &ctkn_BGP_IPV4_NODE[71],
	},
	{
		.from = &gn_BGP_IPV4_NODE_72_prev,
		.to = &gn_BGP_IPV4_NODE_72_next,
		.data = (void *)&af_label_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_73_prev,
		.to = &gn_BGP_IPV4_NODE_73_next,
		.data = &ctkn_BGP_IPV4_NODE[73],
	},
	{
		.from = &gn_BGP_IPV4_NODE_74_prev,
		.to = &gn_BGP_IPV4_NODE_74_next,
		.data = &ctkn_BGP_IPV4_NODE[74],
	},
	{
		.from = &gn_BGP_IPV4_NODE_75_prev,
		.to = &gn_BGP_IPV4_NODE_75_next,
		.data = &ctkn_BGP_IPV4_NODE[75],
	},
	{
		.from = &gn_BGP_IPV4_NODE_76_prev,
		.to = &gn_BGP_IPV4_NODE_76_next,
		.data = &ctkn_BGP_IPV4_NODE[76],
	},
	{
		.from = &gn_BGP_IPV4_NODE_77_prev,
		.to = &gn_BGP_IPV4_NODE_77_next,
		.data = &ctkn_BGP_IPV4_NODE[77],
	},
	{
		.from = &gn_BGP_IPV4_NODE_78_prev,
		.to = &gn_BGP_IPV4_NODE_78_next,
		.data = &ctkn_BGP_IPV4_NODE[78],
	},
	{
		.from = &gn_BGP_IPV4_NODE_79_prev,
		.to = &gn_BGP_IPV4_NODE_79_next,
		.data = (void *)&af_label_vpn_export_allocation_mode_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_80_prev,
		.to = &gn_BGP_IPV4_NODE_80_next,
		.data = &ctkn_BGP_IPV4_NODE[80],
	},
	{
		.from = &gn_BGP_IPV4_NODE_81_prev,
		.to = &gn_BGP_IPV4_NODE_81_next,
		.data = &ctkn_BGP_IPV4_NODE[81],
	},
	{
		.from = &gn_BGP_IPV4_NODE_82_prev,
		.to = &gn_BGP_IPV4_NODE_82_next,
		.data = &ctkn_BGP_IPV4_NODE[82],
	},
	{
		.from = &gn_BGP_IPV4_NODE_83_prev,
		.to = &gn_BGP_IPV4_NODE_83_next,
		.data = &ctkn_BGP_IPV4_NODE[83],
	},
	{
		.from = &gn_BGP_IPV4_NODE_84_prev,
		.to = &gn_BGP_IPV4_NODE_84_next,
		.data = &ctkn_BGP_IPV4_NODE[84],
	},
	{
		.from = &gn_BGP_IPV4_NODE_85_prev,
		.to = &gn_BGP_IPV4_NODE_85_next,
		.data = &ctkn_BGP_IPV4_NODE[85],
	},
	{
		.from = &gn_BGP_IPV4_NODE_86_prev,
		.to = &gn_BGP_IPV4_NODE_86_next,
		.data = &ctkn_BGP_IPV4_NODE[86],
	},
	{
		.from = &gn_BGP_IPV4_NODE_87_prev,
		.to = &gn_BGP_IPV4_NODE_87_next,
		.data = &ctkn_BGP_IPV4_NODE[87],
	},
	{
		.from = &gn_BGP_IPV4_NODE_88_prev,
		.to = &gn_BGP_IPV4_NODE_88_next,
		.data = &ctkn_BGP_IPV4_NODE[88],
	},
	{
		.from = &gn_BGP_IPV4_NODE_89_prev,
		.to = &gn_BGP_IPV4_NODE_89_next,
		.data = &ctkn_BGP_IPV4_NODE[89],
	},
	{
		.from = &gn_BGP_IPV4_NODE_90_prev,
		.to = &gn_BGP_IPV4_NODE_90_next,
		.data = &ctkn_BGP_IPV4_NODE[90],
	},
	{
		.from = &gn_BGP_IPV4_NODE_91_prev,
		.to = &gn_BGP_IPV4_NODE_91_next,
		.data = &ctkn_BGP_IPV4_NODE[91],
	},
	{
		.from = &gn_BGP_IPV4_NODE_92_prev,
		.to = &gn_BGP_IPV4_NODE_92_next,
		.data = (void *)&neighbor_advertise_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_93_prev,
		.to = &gn_BGP_IPV4_NODE_93_next,
		.data = &ctkn_BGP_IPV4_NODE[93],
	},
	{
		.from = &gn_BGP_IPV4_NODE_94_prev,
		.to = &gn_BGP_IPV4_NODE_94_next,
		.data = &ctkn_BGP_IPV4_NODE[94],
	},
	{
		.from = &gn_BGP_IPV4_NODE_95_prev,
		.to = &gn_BGP_IPV4_NODE_95_next,
		.data = &ctkn_BGP_IPV4_NODE[95],
	},
	{
		.from = &gn_BGP_IPV4_NODE_96_prev,
		.to = &gn_BGP_IPV4_NODE_96_next,
		.data = &ctkn_BGP_IPV4_NODE[96],
	},
	{
		.from = &gn_BGP_IPV4_NODE_97_prev,
		.to = &gn_BGP_IPV4_NODE_97_next,
		.data = &ctkn_BGP_IPV4_NODE[97],
	},
	{
		.from = &gn_BGP_IPV4_NODE_98_prev,
		.to = &gn_BGP_IPV4_NODE_98_next,
		.data = &ctkn_BGP_IPV4_NODE[98],
	},
	{
		.from = &gn_BGP_IPV4_NODE_99_prev,
		.to = &gn_BGP_IPV4_NODE_99_next,
		.data = &ctkn_BGP_IPV4_NODE[99],
	},
	{
		.from = &gn_BGP_IPV4_NODE_100_prev,
		.to = &gn_BGP_IPV4_NODE_100_next,
		.data = (void *)&neighbor_ecommunity_rpki_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_101_prev,
		.to = &gn_BGP_IPV4_NODE_101_next,
		.data = &ctkn_BGP_IPV4_NODE[101],
	},
	{
		.from = &gn_BGP_IPV4_NODE_102_prev,
		.to = &gn_BGP_IPV4_NODE_102_next,
		.data = &ctkn_BGP_IPV4_NODE[102],
	},
	{
		.from = &gn_BGP_IPV4_NODE_103_prev,
		.to = &gn_BGP_IPV4_NODE_103_next,
		.data = &ctkn_BGP_IPV4_NODE[103],
	},
	{
		.from = &gn_BGP_IPV4_NODE_104_prev,
		.to = &gn_BGP_IPV4_NODE_104_next,
		.data = &ctkn_BGP_IPV4_NODE[104],
	},
	{
		.from = &gn_BGP_IPV4_NODE_105_prev,
		.to = &gn_BGP_IPV4_NODE_105_next,
		.data = &ctkn_BGP_IPV4_NODE[105],
	},
	{
		.from = &gn_BGP_IPV4_NODE_106_prev,
		.to = &gn_BGP_IPV4_NODE_106_next,
		.data = &ctkn_BGP_IPV4_NODE[106],
	},
	{
		.from = &gn_BGP_IPV4_NODE_107_prev,
		.to = &gn_BGP_IPV4_NODE_107_next,
		.data = &ctkn_BGP_IPV4_NODE[107],
	},
	{
		.from = &gn_BGP_IPV4_NODE_108_prev,
		.to = &gn_BGP_IPV4_NODE_108_next,
		.data = &ctkn_BGP_IPV4_NODE[108],
	},
	{
		.from = &gn_BGP_IPV4_NODE_109_prev,
		.to = &gn_BGP_IPV4_NODE_109_next,
		.data = &ctkn_BGP_IPV4_NODE[109],
	},
	{
		.from = &gn_BGP_IPV4_NODE_110_prev,
		.to = &gn_BGP_IPV4_NODE_110_next,
		.data = &ctkn_BGP_IPV4_NODE[110],
	},
	{
		.from = &gn_BGP_IPV4_NODE_111_prev,
		.to = &gn_BGP_IPV4_NODE_111_next,
		.data = &ctkn_BGP_IPV4_NODE[111],
	},
	{
		.from = &gn_BGP_IPV4_NODE_112_prev,
		.to = &gn_BGP_IPV4_NODE_112_next,
		.data = (void *)&bgp_network_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_113_prev,
		.to = &gn_BGP_IPV4_NODE_113_next,
		.data = &ctkn_BGP_IPV4_NODE[113],
	},
	{
		.from = &gn_BGP_IPV4_NODE_114_prev,
		.to = &gn_BGP_IPV4_NODE_114_next,
		.data = &ctkn_BGP_IPV4_NODE[114],
	},
	{
		.from = &gn_BGP_IPV4_NODE_115_prev,
		.to = &gn_BGP_IPV4_NODE_115_next,
		.data = &ctkn_BGP_IPV4_NODE[115],
	},
	{
		.from = &gn_BGP_IPV4_NODE_116_prev,
		.to = &gn_BGP_IPV4_NODE_116_next,
		.data = &ctkn_BGP_IPV4_NODE[116],
	},
	{
		.from = &gn_BGP_IPV4_NODE_117_prev,
		.to = &gn_BGP_IPV4_NODE_117_next,
		.data = &ctkn_BGP_IPV4_NODE[117],
	},
	{
		.from = &gn_BGP_IPV4_NODE_118_prev,
		.to = &gn_BGP_IPV4_NODE_118_next,
		.data = &ctkn_BGP_IPV4_NODE[118],
	},
	{
		.from = &gn_BGP_IPV4_NODE_119_prev,
		.to = &gn_BGP_IPV4_NODE_119_next,
		.data = &ctkn_BGP_IPV4_NODE[119],
	},
	{
		.from = &gn_BGP_IPV4_NODE_120_prev,
		.to = &gn_BGP_IPV4_NODE_120_next,
		.data = &ctkn_BGP_IPV4_NODE[120],
	},
	{
		.from = &gn_BGP_IPV4_NODE_121_prev,
		.to = &gn_BGP_IPV4_NODE_121_next,
		.data = &ctkn_BGP_IPV4_NODE[121],
	},
	{
		.from = &gn_BGP_IPV4_NODE_122_prev,
		.to = &gn_BGP_IPV4_NODE_122_next,
		.data = &ctkn_BGP_IPV4_NODE[122],
	},
	{
		.from = &gn_BGP_IPV4_NODE_123_prev,
		.to = &gn_BGP_IPV4_NODE_123_next,
		.data = &ctkn_BGP_IPV4_NODE[123],
	},
	{
		.from = &gn_BGP_IPV4_NODE_124_prev,
		.to = &gn_BGP_IPV4_NODE_124_next,
		.data = &ctkn_BGP_IPV4_NODE[124],
	},
	{
		.from = &gn_BGP_IPV4_NODE_125_prev,
		.to = &gn_BGP_IPV4_NODE_125_next,
		.data = &ctkn_BGP_IPV4_NODE[125],
	},
	{
		.from = &gn_BGP_IPV4_NODE_126_prev,
		.to = &gn_BGP_IPV4_NODE_126_next,
		.data = &ctkn_BGP_IPV4_NODE[126],
	},
	{
		.from = &gn_BGP_IPV4_NODE_127_prev,
		.to = &gn_BGP_IPV4_NODE_127_next,
		.data = &ctkn_BGP_IPV4_NODE[127],
	},
	{
		.from = &gn_BGP_IPV4_NODE_128_prev,
		.to = &gn_BGP_IPV4_NODE_128_next,
		.data = &ctkn_BGP_IPV4_NODE[128],
	},
	{
		.from = &gn_BGP_IPV4_NODE_129_prev,
		.to = &gn_BGP_IPV4_NODE_129_next,
		.data = &ctkn_BGP_IPV4_NODE[129],
	},
	{
		.from = &gn_BGP_IPV4_NODE_130_prev,
		.to = &gn_BGP_IPV4_NODE_130_next,
		.data = (void *)&af_nexthop_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_131_prev,
		.to = &gn_BGP_IPV4_NODE_131_next,
		.data = &ctkn_BGP_IPV4_NODE[131],
	},
	{
		.from = &gn_BGP_IPV4_NODE_132_prev,
		.to = &gn_BGP_IPV4_NODE_132_next,
		.data = &ctkn_BGP_IPV4_NODE[132],
	},
	{
		.from = &gn_BGP_IPV4_NODE_133_prev,
		.to = &gn_BGP_IPV4_NODE_133_next,
		.data = &ctkn_BGP_IPV4_NODE[133],
	},
	{
		.from = &gn_BGP_IPV4_NODE_134_prev,
		.to = &gn_BGP_IPV4_NODE_134_next,
		.data = &ctkn_BGP_IPV4_NODE[134],
	},
	{
		.from = &gn_BGP_IPV4_NODE_135_prev,
		.to = &gn_BGP_IPV4_NODE_135_next,
		.data = &ctkn_BGP_IPV4_NODE[135],
	},
	{
		.from = &gn_BGP_IPV4_NODE_136_prev,
		.to = &gn_BGP_IPV4_NODE_136_next,
		.data = &ctkn_BGP_IPV4_NODE[136],
	},
	{
		.from = &gn_BGP_IPV4_NODE_137_prev,
		.to = &gn_BGP_IPV4_NODE_137_next,
		.data = (void *)&af_rd_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_138_prev,
		.to = &gn_BGP_IPV4_NODE_138_next,
		.data = &ctkn_BGP_IPV4_NODE[138],
	},
	{
		.from = &gn_BGP_IPV4_NODE_139_prev,
		.to = &gn_BGP_IPV4_NODE_139_next,
		.data = &ctkn_BGP_IPV4_NODE[139],
	},
	{
		.from = &gn_BGP_IPV4_NODE_140_prev,
		.to = &gn_BGP_IPV4_NODE_140_next,
		.data = &ctkn_BGP_IPV4_NODE[140],
	},
	{
		.from = &gn_BGP_IPV4_NODE_141_prev,
		.to = &gn_BGP_IPV4_NODE_141_next,
		.data = &ctkn_BGP_IPV4_NODE[141],
	},
	{
		.from = &gn_BGP_IPV4_NODE_142_prev,
		.to = &gn_BGP_IPV4_NODE_142_next,
		.data = &ctkn_BGP_IPV4_NODE[142],
	},
	{
		.from = &gn_BGP_IPV4_NODE_143_prev,
		.to = &gn_BGP_IPV4_NODE_143_next,
		.data = &ctkn_BGP_IPV4_NODE[143],
	},
	{
		.from = &gn_BGP_IPV4_NODE_144_prev,
		.to = &gn_BGP_IPV4_NODE_144_next,
		.data = &ctkn_BGP_IPV4_NODE[144],
	},
	{
		.from = &gn_BGP_IPV4_NODE_145_prev,
		.to = &gn_BGP_IPV4_NODE_145_next,
		.data = (void *)&af_route_map_vpn_imexport_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_146_prev,
		.to = &gn_BGP_IPV4_NODE_146_next,
		.data = &ctkn_BGP_IPV4_NODE[146],
	},
	{
		.from = &gn_BGP_IPV4_NODE_147_prev,
		.to = &gn_BGP_IPV4_NODE_147_next,
		.data = &ctkn_BGP_IPV4_NODE[147],
	},
	{
		.from = &gn_BGP_IPV4_NODE_148_prev,
		.to = &gn_BGP_IPV4_NODE_148_next,
		.data = &ctkn_BGP_IPV4_NODE[148],
	},
	{
		.from = &gn_BGP_IPV4_NODE_149_prev,
		.to = &gn_BGP_IPV4_NODE_149_next,
		.data = &ctkn_BGP_IPV4_NODE[149],
	},
	{
		.from = &gn_BGP_IPV4_NODE_150_prev,
		.to = &gn_BGP_IPV4_NODE_150_next,
		.data = &ctkn_BGP_IPV4_NODE[150],
	},
	{
		.from = &gn_BGP_IPV4_NODE_151_prev,
		.to = &gn_BGP_IPV4_NODE_151_next,
		.data = &ctkn_BGP_IPV4_NODE[151],
	},
	{
		.from = &gn_BGP_IPV4_NODE_152_prev,
		.to = &gn_BGP_IPV4_NODE_152_next,
		.data = &ctkn_BGP_IPV4_NODE[152],
	},
	{
		.from = &gn_BGP_IPV4_NODE_153_prev,
		.to = &gn_BGP_IPV4_NODE_153_next,
		.data = &ctkn_BGP_IPV4_NODE[153],
	},
	{
		.from = &gn_BGP_IPV4_NODE_154_prev,
		.to = &gn_BGP_IPV4_NODE_154_next,
		.data = (void *)&af_sid_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_155_prev,
		.to = &gn_BGP_IPV4_NODE_155_next,
		.data = &ctkn_BGP_IPV4_NODE[155],
	},
	{
		.from = &gn_BGP_IPV4_NODE_156_prev,
		.to = &gn_BGP_IPV4_NODE_156_next,
		.data = &ctkn_BGP_IPV4_NODE[156],
	},
	{
		.from = &gn_BGP_IPV4_NODE_157_prev,
		.to = &gn_BGP_IPV4_NODE_157_next,
		.data = &ctkn_BGP_IPV4_NODE[157],
	},
	{
		.from = &gn_BGP_IPV4_NODE_158_prev,
		.to = &gn_BGP_IPV4_NODE_158_next,
		.data = &ctkn_BGP_IPV4_NODE[158],
	},
	{
		.from = &gn_BGP_IPV4_NODE_159_prev,
		.to = &gn_BGP_IPV4_NODE_159_next,
		.data = &ctkn_BGP_IPV4_NODE[159],
	},
	{
		.from = &gn_BGP_IPV4_NODE_160_prev,
		.to = &gn_BGP_IPV4_NODE_160_next,
		.data = &ctkn_BGP_IPV4_NODE[160],
	},
	{
		.from = &gn_BGP_IPV4_NODE_161_prev,
		.to = &gn_BGP_IPV4_NODE_161_next,
		.data = &ctkn_BGP_IPV4_NODE[161],
	},
	{
		.from = &gn_BGP_IPV4_NODE_162_prev,
		.to = &gn_BGP_IPV4_NODE_162_next,
		.data = &ctkn_BGP_IPV4_NODE[162],
	},
	{
		.from = &gn_BGP_IPV4_NODE_163_prev,
		.to = &gn_BGP_IPV4_NODE_163_next,
		.data = &ctkn_BGP_IPV4_NODE[163],
	},
	{
		.from = &gn_BGP_IPV4_NODE_164_prev,
		.to = &gn_BGP_IPV4_NODE_164_next,
		.data = &ctkn_BGP_IPV4_NODE[164],
	},
	{
		.from = &gn_BGP_IPV4_NODE_165_prev,
		.to = &gn_BGP_IPV4_NODE_165_next,
		.data = &ctkn_BGP_IPV4_NODE[165],
	},
	{
		.from = &gn_BGP_IPV4_NODE_166_prev,
		.to = &gn_BGP_IPV4_NODE_166_next,
		.data = &ctkn_BGP_IPV4_NODE[166],
	},
	{
		.from = &gn_BGP_IPV4_NODE_167_prev,
		.to = &gn_BGP_IPV4_NODE_167_next,
		.data = &ctkn_BGP_IPV4_NODE[167],
	},
	{
		.from = &gn_BGP_IPV4_NODE_168_prev,
		.to = &gn_BGP_IPV4_NODE_168_next,
		.data = &ctkn_BGP_IPV4_NODE[168],
	},
	{
		.from = &gn_BGP_IPV4_NODE_169_prev,
		.to = &gn_BGP_IPV4_NODE_169_next,
		.data = (void *)&bgp_damp_set_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_170_prev,
		.to = &gn_BGP_IPV4_NODE_170_next,
		.data = &ctkn_BGP_IPV4_NODE[170],
	},
	{
		.from = &gn_BGP_IPV4_NODE_171_prev,
		.to = &gn_BGP_IPV4_NODE_171_next,
		.data = &ctkn_BGP_IPV4_NODE[171],
	},
	{
		.from = &gn_BGP_IPV4_NODE_172_prev,
		.to = &gn_BGP_IPV4_NODE_172_next,
		.data = &ctkn_BGP_IPV4_NODE[172],
	},
	{
		.from = &gn_BGP_IPV4_NODE_173_prev,
		.to = &gn_BGP_IPV4_NODE_173_next,
		.data = &ctkn_BGP_IPV4_NODE[173],
	},
	{
		.from = &gn_BGP_IPV4_NODE_174_prev,
		.to = &gn_BGP_IPV4_NODE_174_next,
		.data = (void *)&bgp_distance_source_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_175_prev,
		.to = &gn_BGP_IPV4_NODE_175_next,
		.data = &ctkn_BGP_IPV4_NODE[175],
	},
	{
		.from = &gn_BGP_IPV4_NODE_176_prev,
		.to = &gn_BGP_IPV4_NODE_176_next,
		.data = &ctkn_BGP_IPV4_NODE[176],
	},
	{
		.from = &gn_BGP_IPV4_NODE_177_prev,
		.to = &gn_BGP_IPV4_NODE_177_next,
		.data = (void *)&bgp_distance_source_access_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_178_prev,
		.to = &gn_BGP_IPV4_NODE_178_next,
		.data = &ctkn_BGP_IPV4_NODE[178],
	},
	{
		.from = &gn_BGP_IPV4_NODE_179_prev,
		.to = &gn_BGP_IPV4_NODE_179_next,
		.data = &ctkn_BGP_IPV4_NODE[179],
	},
	{
		.from = &gn_BGP_IPV4_NODE_180_prev,
		.to = &gn_BGP_IPV4_NODE_180_next,
		.data = &ctkn_BGP_IPV4_NODE[180],
	},
	{
		.from = &gn_BGP_IPV4_NODE_181_prev,
		.to = &gn_BGP_IPV4_NODE_181_next,
		.data = &ctkn_BGP_IPV4_NODE[181],
	},
	{
		.from = &gn_BGP_IPV4_NODE_182_prev,
		.to = &gn_BGP_IPV4_NODE_182_next,
		.data = &ctkn_BGP_IPV4_NODE[182],
	},
	{
		.from = &gn_BGP_IPV4_NODE_183_prev,
		.to = &gn_BGP_IPV4_NODE_183_next,
		.data = (void *)&bgp_distance_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_184_prev,
		.to = &gn_BGP_IPV4_NODE_184_next,
		.data = &ctkn_BGP_IPV4_NODE[184],
	},
	{
		.from = &gn_BGP_IPV4_NODE_185_prev,
		.to = &gn_BGP_IPV4_NODE_185_next,
		.data = &ctkn_BGP_IPV4_NODE[185],
	},
	{
		.from = &gn_BGP_IPV4_NODE_186_prev,
		.to = &gn_BGP_IPV4_NODE_186_next,
		.data = &ctkn_BGP_IPV4_NODE[186],
	},
	{
		.from = &gn_BGP_IPV4_NODE_187_prev,
		.to = &gn_BGP_IPV4_NODE_187_next,
		.data = &ctkn_BGP_IPV4_NODE[187],
	},
	{
		.from = &gn_BGP_IPV4_NODE_188_prev,
		.to = &gn_BGP_IPV4_NODE_188_next,
		.data = &ctkn_BGP_IPV4_NODE[188],
	},
	{
		.from = &gn_BGP_IPV4_NODE_189_prev,
		.to = &gn_BGP_IPV4_NODE_189_next,
		.data = (void *)&af_import_vrf_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_190_prev,
		.to = &gn_BGP_IPV4_NODE_190_next,
		.data = &ctkn_BGP_IPV4_NODE[190],
	},
	{
		.from = &gn_BGP_IPV4_NODE_191_prev,
		.to = &gn_BGP_IPV4_NODE_191_next,
		.data = &ctkn_BGP_IPV4_NODE[191],
	},
	{
		.from = &gn_BGP_IPV4_NODE_192_prev,
		.to = &gn_BGP_IPV4_NODE_192_next,
		.data = &ctkn_BGP_IPV4_NODE[192],
	},
	{
		.from = &gn_BGP_IPV4_NODE_193_prev,
		.to = &gn_BGP_IPV4_NODE_193_next,
		.data = (void *)&bgp_maxpaths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_194_prev,
		.to = &gn_BGP_IPV4_NODE_194_next,
		.data = &ctkn_BGP_IPV4_NODE[194],
	},
	{
		.from = &gn_BGP_IPV4_NODE_195_prev,
		.to = &gn_BGP_IPV4_NODE_195_next,
		.data = &ctkn_BGP_IPV4_NODE[195],
	},
	{
		.from = &gn_BGP_IPV4_NODE_196_prev,
		.to = &gn_BGP_IPV4_NODE_196_next,
		.data = &ctkn_BGP_IPV4_NODE[196],
	},
	{
		.from = &gn_BGP_IPV4_NODE_197_prev,
		.to = &gn_BGP_IPV4_NODE_197_next,
		.data = (void *)&bgp_maxpaths_ibgp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_198_prev,
		.to = &gn_BGP_IPV4_NODE_198_next,
		.data = &ctkn_BGP_IPV4_NODE[198],
	},
	{
		.from = &gn_BGP_IPV4_NODE_199_prev,
		.to = &gn_BGP_IPV4_NODE_199_next,
		.data = &ctkn_BGP_IPV4_NODE[199],
	},
	{
		.from = &gn_BGP_IPV4_NODE_200_prev,
		.to = &gn_BGP_IPV4_NODE_200_next,
		.data = (void *)&bgp_maxpaths_ibgp_cluster_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_201_prev,
		.to = &gn_BGP_IPV4_NODE_201_next,
		.data = &ctkn_BGP_IPV4_NODE[201],
	},
	{
		.from = &gn_BGP_IPV4_NODE_202_prev,
		.to = &gn_BGP_IPV4_NODE_202_next,
		.data = &ctkn_BGP_IPV4_NODE[202],
	},
	{
		.from = &gn_BGP_IPV4_NODE_203_prev,
		.to = &gn_BGP_IPV4_NODE_203_next,
		.data = &ctkn_BGP_IPV4_NODE[203],
	},
	{
		.from = &gn_BGP_IPV4_NODE_204_prev,
		.to = &gn_BGP_IPV4_NODE_204_next,
		.data = &ctkn_BGP_IPV4_NODE[204],
	},
	{
		.from = &gn_BGP_IPV4_NODE_205_prev,
		.to = &gn_BGP_IPV4_NODE_205_next,
		.data = &ctkn_BGP_IPV4_NODE[205],
	},
	{
		.from = &gn_BGP_IPV4_NODE_206_prev,
		.to = &gn_BGP_IPV4_NODE_206_next,
		.data = &ctkn_BGP_IPV4_NODE[206],
	},
	{
		.from = &gn_BGP_IPV4_NODE_207_prev,
		.to = &gn_BGP_IPV4_NODE_207_next,
		.data = (void *)&neighbor_activate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_208_prev,
		.to = &gn_BGP_IPV4_NODE_208_next,
		.data = &ctkn_BGP_IPV4_NODE[208],
	},
	{
		.from = &gn_BGP_IPV4_NODE_209_prev,
		.to = &gn_BGP_IPV4_NODE_209_next,
		.data = &ctkn_BGP_IPV4_NODE[209],
	},
	{
		.from = &gn_BGP_IPV4_NODE_210_prev,
		.to = &gn_BGP_IPV4_NODE_210_next,
		.data = &ctkn_BGP_IPV4_NODE[210],
	},
	{
		.from = &gn_BGP_IPV4_NODE_211_prev,
		.to = &gn_BGP_IPV4_NODE_211_next,
		.data = &ctkn_BGP_IPV4_NODE[211],
	},
	{
		.from = &gn_BGP_IPV4_NODE_212_prev,
		.to = &gn_BGP_IPV4_NODE_212_next,
		.data = &ctkn_BGP_IPV4_NODE[212],
	},
	{
		.from = &gn_BGP_IPV4_NODE_213_prev,
		.to = &gn_BGP_IPV4_NODE_213_next,
		.data = (void *)&neighbor_addpath_paths_limit_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_214_prev,
		.to = &gn_BGP_IPV4_NODE_214_next,
		.data = &ctkn_BGP_IPV4_NODE[214],
	},
	{
		.from = &gn_BGP_IPV4_NODE_215_prev,
		.to = &gn_BGP_IPV4_NODE_215_next,
		.data = &ctkn_BGP_IPV4_NODE[215],
	},
	{
		.from = &gn_BGP_IPV4_NODE_216_prev,
		.to = &gn_BGP_IPV4_NODE_216_next,
		.data = (void *)&neighbor_addpath_tx_all_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_217_prev,
		.to = &gn_BGP_IPV4_NODE_217_next,
		.data = &ctkn_BGP_IPV4_NODE[217],
	},
	{
		.from = &gn_BGP_IPV4_NODE_218_prev,
		.to = &gn_BGP_IPV4_NODE_218_next,
		.data = &ctkn_BGP_IPV4_NODE[218],
	},
	{
		.from = &gn_BGP_IPV4_NODE_219_prev,
		.to = &gn_BGP_IPV4_NODE_219_next,
		.data = &ctkn_BGP_IPV4_NODE[219],
	},
	{
		.from = &gn_BGP_IPV4_NODE_220_prev,
		.to = &gn_BGP_IPV4_NODE_220_next,
		.data = (void *)&neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_221_prev,
		.to = &gn_BGP_IPV4_NODE_221_next,
		.data = &ctkn_BGP_IPV4_NODE[221],
	},
	{
		.from = &gn_BGP_IPV4_NODE_222_prev,
		.to = &gn_BGP_IPV4_NODE_222_next,
		.data = &ctkn_BGP_IPV4_NODE[222],
	},
	{
		.from = &gn_BGP_IPV4_NODE_223_prev,
		.to = &gn_BGP_IPV4_NODE_223_next,
		.data = (void *)&neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_224_prev,
		.to = &gn_BGP_IPV4_NODE_224_next,
		.data = &ctkn_BGP_IPV4_NODE[224],
	},
	{
		.from = &gn_BGP_IPV4_NODE_225_prev,
		.to = &gn_BGP_IPV4_NODE_225_next,
		.data = &ctkn_BGP_IPV4_NODE[225],
	},
	{
		.from = &gn_BGP_IPV4_NODE_226_prev,
		.to = &gn_BGP_IPV4_NODE_226_next,
		.data = &ctkn_BGP_IPV4_NODE[226],
	},
	{
		.from = &gn_BGP_IPV4_NODE_227_prev,
		.to = &gn_BGP_IPV4_NODE_227_next,
		.data = &ctkn_BGP_IPV4_NODE[227],
	},
	{
		.from = &gn_BGP_IPV4_NODE_228_prev,
		.to = &gn_BGP_IPV4_NODE_228_next,
		.data = &ctkn_BGP_IPV4_NODE[228],
	},
	{
		.from = &gn_BGP_IPV4_NODE_229_prev,
		.to = &gn_BGP_IPV4_NODE_229_next,
		.data = &ctkn_BGP_IPV4_NODE[229],
	},
	{
		.from = &gn_BGP_IPV4_NODE_230_prev,
		.to = &gn_BGP_IPV4_NODE_230_next,
		.data = &ctkn_BGP_IPV4_NODE[230],
	},
	{
		.from = &gn_BGP_IPV4_NODE_231_prev,
		.to = &gn_BGP_IPV4_NODE_231_next,
		.data = (void *)&neighbor_allowas_in_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_232_prev,
		.to = &gn_BGP_IPV4_NODE_232_next,
		.data = &ctkn_BGP_IPV4_NODE[232],
	},
	{
		.from = &gn_BGP_IPV4_NODE_233_prev,
		.to = &gn_BGP_IPV4_NODE_233_next,
		.data = &ctkn_BGP_IPV4_NODE[233],
	},
	{
		.from = &gn_BGP_IPV4_NODE_234_prev,
		.to = &gn_BGP_IPV4_NODE_234_next,
		.data = &ctkn_BGP_IPV4_NODE[234],
	},
	{
		.from = &gn_BGP_IPV4_NODE_235_prev,
		.to = &gn_BGP_IPV4_NODE_235_next,
		.data = (void *)&neighbor_as_override_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_236_prev,
		.to = &gn_BGP_IPV4_NODE_236_next,
		.data = &ctkn_BGP_IPV4_NODE[236],
	},
	{
		.from = &gn_BGP_IPV4_NODE_237_prev,
		.to = &gn_BGP_IPV4_NODE_237_next,
		.data = &ctkn_BGP_IPV4_NODE[237],
	},
	{
		.from = &gn_BGP_IPV4_NODE_238_prev,
		.to = &gn_BGP_IPV4_NODE_238_next,
		.data = &ctkn_BGP_IPV4_NODE[238],
	},
	{
		.from = &gn_BGP_IPV4_NODE_239_prev,
		.to = &gn_BGP_IPV4_NODE_239_next,
		.data = &ctkn_BGP_IPV4_NODE[239],
	},
	{
		.from = &gn_BGP_IPV4_NODE_240_prev,
		.to = &gn_BGP_IPV4_NODE_240_next,
		.data = &ctkn_BGP_IPV4_NODE[240],
	},
	{
		.from = &gn_BGP_IPV4_NODE_241_prev,
		.to = &gn_BGP_IPV4_NODE_241_next,
		.data = &ctkn_BGP_IPV4_NODE[241],
	},
	{
		.from = &gn_BGP_IPV4_NODE_242_prev,
		.to = &gn_BGP_IPV4_NODE_242_next,
		.data = &ctkn_BGP_IPV4_NODE[242],
	},
	{
		.from = &gn_BGP_IPV4_NODE_243_prev,
		.to = &gn_BGP_IPV4_NODE_243_next,
		.data = (void *)&neighbor_attr_unchanged_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_244_prev,
		.to = &gn_BGP_IPV4_NODE_244_next,
		.data = &ctkn_BGP_IPV4_NODE[244],
	},
	{
		.from = &gn_BGP_IPV4_NODE_245_prev,
		.to = &gn_BGP_IPV4_NODE_245_next,
		.data = &ctkn_BGP_IPV4_NODE[245],
	},
	{
		.from = &gn_BGP_IPV4_NODE_246_prev,
		.to = &gn_BGP_IPV4_NODE_246_next,
		.data = &ctkn_BGP_IPV4_NODE[246],
	},
	{
		.from = &gn_BGP_IPV4_NODE_247_prev,
		.to = &gn_BGP_IPV4_NODE_247_next,
		.data = &ctkn_BGP_IPV4_NODE[247],
	},
	{
		.from = &gn_BGP_IPV4_NODE_248_prev,
		.to = &gn_BGP_IPV4_NODE_248_next,
		.data = &ctkn_BGP_IPV4_NODE[248],
	},
	{
		.from = &gn_BGP_IPV4_NODE_249_prev,
		.to = &gn_BGP_IPV4_NODE_249_next,
		.data = &ctkn_BGP_IPV4_NODE[249],
	},
	{
		.from = &gn_BGP_IPV4_NODE_250_prev,
		.to = &gn_BGP_IPV4_NODE_250_next,
		.data = &ctkn_BGP_IPV4_NODE[250],
	},
	{
		.from = &gn_BGP_IPV4_NODE_251_prev,
		.to = &gn_BGP_IPV4_NODE_251_next,
		.data = &ctkn_BGP_IPV4_NODE[251],
	},
	{
		.from = &gn_BGP_IPV4_NODE_252_prev,
		.to = &gn_BGP_IPV4_NODE_252_next,
		.data = &ctkn_BGP_IPV4_NODE[252],
	},
	{
		.from = &gn_BGP_IPV4_NODE_253_prev,
		.to = &gn_BGP_IPV4_NODE_253_next,
		.data = (void *)&neighbor_capability_orf_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_254_prev,
		.to = &gn_BGP_IPV4_NODE_254_next,
		.data = &ctkn_BGP_IPV4_NODE[254],
	},
	{
		.from = &gn_BGP_IPV4_NODE_255_prev,
		.to = &gn_BGP_IPV4_NODE_255_next,
		.data = &ctkn_BGP_IPV4_NODE[255],
	},
	{
		.from = &gn_BGP_IPV4_NODE_256_prev,
		.to = &gn_BGP_IPV4_NODE_256_next,
		.data = &ctkn_BGP_IPV4_NODE[256],
	},
	{
		.from = &gn_BGP_IPV4_NODE_257_prev,
		.to = &gn_BGP_IPV4_NODE_257_next,
		.data = &ctkn_BGP_IPV4_NODE[257],
	},
	{
		.from = &gn_BGP_IPV4_NODE_258_prev,
		.to = &gn_BGP_IPV4_NODE_258_next,
		.data = &ctkn_BGP_IPV4_NODE[258],
	},
	{
		.from = &gn_BGP_IPV4_NODE_259_prev,
		.to = &gn_BGP_IPV4_NODE_259_next,
		.data = &ctkn_BGP_IPV4_NODE[259],
	},
	{
		.from = &gn_BGP_IPV4_NODE_260_prev,
		.to = &gn_BGP_IPV4_NODE_260_next,
		.data = &ctkn_BGP_IPV4_NODE[260],
	},
	{
		.from = &gn_BGP_IPV4_NODE_261_prev,
		.to = &gn_BGP_IPV4_NODE_261_next,
		.data = &ctkn_BGP_IPV4_NODE[261],
	},
	{
		.from = &gn_BGP_IPV4_NODE_262_prev,
		.to = &gn_BGP_IPV4_NODE_262_next,
		.data = &ctkn_BGP_IPV4_NODE[262],
	},
	{
		.from = &gn_BGP_IPV4_NODE_263_prev,
		.to = &gn_BGP_IPV4_NODE_263_next,
		.data = &ctkn_BGP_IPV4_NODE[263],
	},
	{
		.from = &gn_BGP_IPV4_NODE_264_prev,
		.to = &gn_BGP_IPV4_NODE_264_next,
		.data = &ctkn_BGP_IPV4_NODE[264],
	},
	{
		.from = &gn_BGP_IPV4_NODE_265_prev,
		.to = &gn_BGP_IPV4_NODE_265_next,
		.data = &ctkn_BGP_IPV4_NODE[265],
	},
	{
		.from = &gn_BGP_IPV4_NODE_266_prev,
		.to = &gn_BGP_IPV4_NODE_266_next,
		.data = (void *)&neighbor_damp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_267_prev,
		.to = &gn_BGP_IPV4_NODE_267_next,
		.data = &ctkn_BGP_IPV4_NODE[267],
	},
	{
		.from = &gn_BGP_IPV4_NODE_268_prev,
		.to = &gn_BGP_IPV4_NODE_268_next,
		.data = &ctkn_BGP_IPV4_NODE[268],
	},
	{
		.from = &gn_BGP_IPV4_NODE_269_prev,
		.to = &gn_BGP_IPV4_NODE_269_next,
		.data = (void *)&neighbor_default_originate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_270_prev,
		.to = &gn_BGP_IPV4_NODE_270_next,
		.data = &ctkn_BGP_IPV4_NODE[270],
	},
	{
		.from = &gn_BGP_IPV4_NODE_271_prev,
		.to = &gn_BGP_IPV4_NODE_271_next,
		.data = &ctkn_BGP_IPV4_NODE[271],
	},
	{
		.from = &gn_BGP_IPV4_NODE_272_prev,
		.to = &gn_BGP_IPV4_NODE_272_next,
		.data = &ctkn_BGP_IPV4_NODE[272],
	},
	{
		.from = &gn_BGP_IPV4_NODE_273_prev,
		.to = &gn_BGP_IPV4_NODE_273_next,
		.data = (void *)&neighbor_default_originate_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_274_prev,
		.to = &gn_BGP_IPV4_NODE_274_next,
		.data = &ctkn_BGP_IPV4_NODE[274],
	},
	{
		.from = &gn_BGP_IPV4_NODE_275_prev,
		.to = &gn_BGP_IPV4_NODE_275_next,
		.data = &ctkn_BGP_IPV4_NODE[275],
	},
	{
		.from = &gn_BGP_IPV4_NODE_276_prev,
		.to = &gn_BGP_IPV4_NODE_276_next,
		.data = (void *)&neighbor_disable_addpath_rx_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_277_prev,
		.to = &gn_BGP_IPV4_NODE_277_next,
		.data = &ctkn_BGP_IPV4_NODE[277],
	},
	{
		.from = &gn_BGP_IPV4_NODE_278_prev,
		.to = &gn_BGP_IPV4_NODE_278_next,
		.data = &ctkn_BGP_IPV4_NODE[278],
	},
	{
		.from = &gn_BGP_IPV4_NODE_279_prev,
		.to = &gn_BGP_IPV4_NODE_279_next,
		.data = &ctkn_BGP_IPV4_NODE[279],
	},
	{
		.from = &gn_BGP_IPV4_NODE_280_prev,
		.to = &gn_BGP_IPV4_NODE_280_next,
		.data = &ctkn_BGP_IPV4_NODE[280],
	},
	{
		.from = &gn_BGP_IPV4_NODE_281_prev,
		.to = &gn_BGP_IPV4_NODE_281_next,
		.data = &ctkn_BGP_IPV4_NODE[281],
	},
	{
		.from = &gn_BGP_IPV4_NODE_282_prev,
		.to = &gn_BGP_IPV4_NODE_282_next,
		.data = &ctkn_BGP_IPV4_NODE[282],
	},
	{
		.from = &gn_BGP_IPV4_NODE_283_prev,
		.to = &gn_BGP_IPV4_NODE_283_next,
		.data = (void *)&neighbor_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_284_prev,
		.to = &gn_BGP_IPV4_NODE_284_next,
		.data = &ctkn_BGP_IPV4_NODE[284],
	},
	{
		.from = &gn_BGP_IPV4_NODE_285_prev,
		.to = &gn_BGP_IPV4_NODE_285_next,
		.data = &ctkn_BGP_IPV4_NODE[285],
	},
	{
		.from = &gn_BGP_IPV4_NODE_286_prev,
		.to = &gn_BGP_IPV4_NODE_286_next,
		.data = &ctkn_BGP_IPV4_NODE[286],
	},
	{
		.from = &gn_BGP_IPV4_NODE_287_prev,
		.to = &gn_BGP_IPV4_NODE_287_next,
		.data = &ctkn_BGP_IPV4_NODE[287],
	},
	{
		.from = &gn_BGP_IPV4_NODE_288_prev,
		.to = &gn_BGP_IPV4_NODE_288_next,
		.data = &ctkn_BGP_IPV4_NODE[288],
	},
	{
		.from = &gn_BGP_IPV4_NODE_289_prev,
		.to = &gn_BGP_IPV4_NODE_289_next,
		.data = &ctkn_BGP_IPV4_NODE[289],
	},
	{
		.from = &gn_BGP_IPV4_NODE_290_prev,
		.to = &gn_BGP_IPV4_NODE_290_next,
		.data = &ctkn_BGP_IPV4_NODE[290],
	},
	{
		.from = &gn_BGP_IPV4_NODE_291_prev,
		.to = &gn_BGP_IPV4_NODE_291_next,
		.data = (void *)&neighbor_filter_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_292_prev,
		.to = &gn_BGP_IPV4_NODE_292_next,
		.data = &ctkn_BGP_IPV4_NODE[292],
	},
	{
		.from = &gn_BGP_IPV4_NODE_293_prev,
		.to = &gn_BGP_IPV4_NODE_293_next,
		.data = &ctkn_BGP_IPV4_NODE[293],
	},
	{
		.from = &gn_BGP_IPV4_NODE_294_prev,
		.to = &gn_BGP_IPV4_NODE_294_next,
		.data = &ctkn_BGP_IPV4_NODE[294],
	},
	{
		.from = &gn_BGP_IPV4_NODE_295_prev,
		.to = &gn_BGP_IPV4_NODE_295_next,
		.data = &ctkn_BGP_IPV4_NODE[295],
	},
	{
		.from = &gn_BGP_IPV4_NODE_296_prev,
		.to = &gn_BGP_IPV4_NODE_296_next,
		.data = &ctkn_BGP_IPV4_NODE[296],
	},
	{
		.from = &gn_BGP_IPV4_NODE_297_prev,
		.to = &gn_BGP_IPV4_NODE_297_next,
		.data = &ctkn_BGP_IPV4_NODE[297],
	},
	{
		.from = &gn_BGP_IPV4_NODE_298_prev,
		.to = &gn_BGP_IPV4_NODE_298_next,
		.data = &ctkn_BGP_IPV4_NODE[298],
	},
	{
		.from = &gn_BGP_IPV4_NODE_299_prev,
		.to = &gn_BGP_IPV4_NODE_299_next,
		.data = &ctkn_BGP_IPV4_NODE[299],
	},
	{
		.from = &gn_BGP_IPV4_NODE_300_prev,
		.to = &gn_BGP_IPV4_NODE_300_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_301_prev,
		.to = &gn_BGP_IPV4_NODE_301_next,
		.data = &ctkn_BGP_IPV4_NODE[301],
	},
	{
		.from = &gn_BGP_IPV4_NODE_302_prev,
		.to = &gn_BGP_IPV4_NODE_302_next,
		.data = &ctkn_BGP_IPV4_NODE[302],
	},
	{
		.from = &gn_BGP_IPV4_NODE_303_prev,
		.to = &gn_BGP_IPV4_NODE_303_next,
		.data = &ctkn_BGP_IPV4_NODE[303],
	},
	{
		.from = &gn_BGP_IPV4_NODE_304_prev,
		.to = &gn_BGP_IPV4_NODE_304_next,
		.data = &ctkn_BGP_IPV4_NODE[304],
	},
	{
		.from = &gn_BGP_IPV4_NODE_305_prev,
		.to = &gn_BGP_IPV4_NODE_305_next,
		.data = &ctkn_BGP_IPV4_NODE[305],
	},
	{
		.from = &gn_BGP_IPV4_NODE_306_prev,
		.to = &gn_BGP_IPV4_NODE_306_next,
		.data = &ctkn_BGP_IPV4_NODE[306],
	},
	{
		.from = &gn_BGP_IPV4_NODE_307_prev,
		.to = &gn_BGP_IPV4_NODE_307_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_restart_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_308_prev,
		.to = &gn_BGP_IPV4_NODE_308_next,
		.data = &ctkn_BGP_IPV4_NODE[308],
	},
	{
		.from = &gn_BGP_IPV4_NODE_309_prev,
		.to = &gn_BGP_IPV4_NODE_309_next,
		.data = &ctkn_BGP_IPV4_NODE[309],
	},
	{
		.from = &gn_BGP_IPV4_NODE_310_prev,
		.to = &gn_BGP_IPV4_NODE_310_next,
		.data = &ctkn_BGP_IPV4_NODE[310],
	},
	{
		.from = &gn_BGP_IPV4_NODE_311_prev,
		.to = &gn_BGP_IPV4_NODE_311_next,
		.data = &ctkn_BGP_IPV4_NODE[311],
	},
	{
		.from = &gn_BGP_IPV4_NODE_312_prev,
		.to = &gn_BGP_IPV4_NODE_312_next,
		.data = &ctkn_BGP_IPV4_NODE[312],
	},
	{
		.from = &gn_BGP_IPV4_NODE_313_prev,
		.to = &gn_BGP_IPV4_NODE_313_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_warning_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_314_prev,
		.to = &gn_BGP_IPV4_NODE_314_next,
		.data = &ctkn_BGP_IPV4_NODE[314],
	},
	{
		.from = &gn_BGP_IPV4_NODE_315_prev,
		.to = &gn_BGP_IPV4_NODE_315_next,
		.data = &ctkn_BGP_IPV4_NODE[315],
	},
	{
		.from = &gn_BGP_IPV4_NODE_316_prev,
		.to = &gn_BGP_IPV4_NODE_316_next,
		.data = &ctkn_BGP_IPV4_NODE[316],
	},
	{
		.from = &gn_BGP_IPV4_NODE_317_prev,
		.to = &gn_BGP_IPV4_NODE_317_next,
		.data = &ctkn_BGP_IPV4_NODE[317],
	},
	{
		.from = &gn_BGP_IPV4_NODE_318_prev,
		.to = &gn_BGP_IPV4_NODE_318_next,
		.data = (void *)&neighbor_maximum_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_319_prev,
		.to = &gn_BGP_IPV4_NODE_319_next,
		.data = &ctkn_BGP_IPV4_NODE[319],
	},
	{
		.from = &gn_BGP_IPV4_NODE_320_prev,
		.to = &gn_BGP_IPV4_NODE_320_next,
		.data = &ctkn_BGP_IPV4_NODE[320],
	},
	{
		.from = &gn_BGP_IPV4_NODE_321_prev,
		.to = &gn_BGP_IPV4_NODE_321_next,
		.data = &ctkn_BGP_IPV4_NODE[321],
	},
	{
		.from = &gn_BGP_IPV4_NODE_322_prev,
		.to = &gn_BGP_IPV4_NODE_322_next,
		.data = &ctkn_BGP_IPV4_NODE[322],
	},
	{
		.from = &gn_BGP_IPV4_NODE_323_prev,
		.to = &gn_BGP_IPV4_NODE_323_next,
		.data = &ctkn_BGP_IPV4_NODE[323],
	},
	{
		.from = &gn_BGP_IPV4_NODE_324_prev,
		.to = &gn_BGP_IPV4_NODE_324_next,
		.data = &ctkn_BGP_IPV4_NODE[324],
	},
	{
		.from = &gn_BGP_IPV4_NODE_325_prev,
		.to = &gn_BGP_IPV4_NODE_325_next,
		.data = (void *)&neighbor_maximum_prefix_restart_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_326_prev,
		.to = &gn_BGP_IPV4_NODE_326_next,
		.data = &ctkn_BGP_IPV4_NODE[326],
	},
	{
		.from = &gn_BGP_IPV4_NODE_327_prev,
		.to = &gn_BGP_IPV4_NODE_327_next,
		.data = &ctkn_BGP_IPV4_NODE[327],
	},
	{
		.from = &gn_BGP_IPV4_NODE_328_prev,
		.to = &gn_BGP_IPV4_NODE_328_next,
		.data = &ctkn_BGP_IPV4_NODE[328],
	},
	{
		.from = &gn_BGP_IPV4_NODE_329_prev,
		.to = &gn_BGP_IPV4_NODE_329_next,
		.data = &ctkn_BGP_IPV4_NODE[329],
	},
	{
		.from = &gn_BGP_IPV4_NODE_330_prev,
		.to = &gn_BGP_IPV4_NODE_330_next,
		.data = &ctkn_BGP_IPV4_NODE[330],
	},
	{
		.from = &gn_BGP_IPV4_NODE_331_prev,
		.to = &gn_BGP_IPV4_NODE_331_next,
		.data = (void *)&neighbor_maximum_prefix_warning_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_332_prev,
		.to = &gn_BGP_IPV4_NODE_332_next,
		.data = &ctkn_BGP_IPV4_NODE[332],
	},
	{
		.from = &gn_BGP_IPV4_NODE_333_prev,
		.to = &gn_BGP_IPV4_NODE_333_next,
		.data = &ctkn_BGP_IPV4_NODE[333],
	},
	{
		.from = &gn_BGP_IPV4_NODE_334_prev,
		.to = &gn_BGP_IPV4_NODE_334_next,
		.data = &ctkn_BGP_IPV4_NODE[334],
	},
	{
		.from = &gn_BGP_IPV4_NODE_335_prev,
		.to = &gn_BGP_IPV4_NODE_335_next,
		.data = (void *)&neighbor_maximum_prefix_out_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_336_prev,
		.to = &gn_BGP_IPV4_NODE_336_next,
		.data = &ctkn_BGP_IPV4_NODE[336],
	},
	{
		.from = &gn_BGP_IPV4_NODE_337_prev,
		.to = &gn_BGP_IPV4_NODE_337_next,
		.data = &ctkn_BGP_IPV4_NODE[337],
	},
	{
		.from = &gn_BGP_IPV4_NODE_338_prev,
		.to = &gn_BGP_IPV4_NODE_338_next,
		.data = (void *)&neighbor_nexthop_self_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_339_prev,
		.to = &gn_BGP_IPV4_NODE_339_next,
		.data = &ctkn_BGP_IPV4_NODE[339],
	},
	{
		.from = &gn_BGP_IPV4_NODE_340_prev,
		.to = &gn_BGP_IPV4_NODE_340_next,
		.data = &ctkn_BGP_IPV4_NODE[340],
	},
	{
		.from = &gn_BGP_IPV4_NODE_341_prev,
		.to = &gn_BGP_IPV4_NODE_341_next,
		.data = (void *)&neighbor_nexthop_self_all_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_342_prev,
		.to = &gn_BGP_IPV4_NODE_342_next,
		.data = &ctkn_BGP_IPV4_NODE[342],
	},
	{
		.from = &gn_BGP_IPV4_NODE_343_prev,
		.to = &gn_BGP_IPV4_NODE_343_next,
		.data = &ctkn_BGP_IPV4_NODE[343],
	},
	{
		.from = &gn_BGP_IPV4_NODE_344_prev,
		.to = &gn_BGP_IPV4_NODE_344_next,
		.data = (void *)&neighbor_nexthop_self_force_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_345_prev,
		.to = &gn_BGP_IPV4_NODE_345_next,
		.data = &ctkn_BGP_IPV4_NODE[345],
	},
	{
		.from = &gn_BGP_IPV4_NODE_346_prev,
		.to = &gn_BGP_IPV4_NODE_346_next,
		.data = &ctkn_BGP_IPV4_NODE[346],
	},
	{
		.from = &gn_BGP_IPV4_NODE_347_prev,
		.to = &gn_BGP_IPV4_NODE_347_next,
		.data = &ctkn_BGP_IPV4_NODE[347],
	},
	{
		.from = &gn_BGP_IPV4_NODE_348_prev,
		.to = &gn_BGP_IPV4_NODE_348_next,
		.data = (void *)&neighbor_set_peer_group_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_349_prev,
		.to = &gn_BGP_IPV4_NODE_349_next,
		.data = &ctkn_BGP_IPV4_NODE[349],
	},
	{
		.from = &gn_BGP_IPV4_NODE_350_prev,
		.to = &gn_BGP_IPV4_NODE_350_next,
		.data = &ctkn_BGP_IPV4_NODE[350],
	},
	{
		.from = &gn_BGP_IPV4_NODE_351_prev,
		.to = &gn_BGP_IPV4_NODE_351_next,
		.data = &ctkn_BGP_IPV4_NODE[351],
	},
	{
		.from = &gn_BGP_IPV4_NODE_352_prev,
		.to = &gn_BGP_IPV4_NODE_352_next,
		.data = &ctkn_BGP_IPV4_NODE[352],
	},
	{
		.from = &gn_BGP_IPV4_NODE_353_prev,
		.to = &gn_BGP_IPV4_NODE_353_next,
		.data = &ctkn_BGP_IPV4_NODE[353],
	},
	{
		.from = &gn_BGP_IPV4_NODE_354_prev,
		.to = &gn_BGP_IPV4_NODE_354_next,
		.data = &ctkn_BGP_IPV4_NODE[354],
	},
	{
		.from = &gn_BGP_IPV4_NODE_355_prev,
		.to = &gn_BGP_IPV4_NODE_355_next,
		.data = (void *)&neighbor_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_356_prev,
		.to = &gn_BGP_IPV4_NODE_356_next,
		.data = &ctkn_BGP_IPV4_NODE[356],
	},
	{
		.from = &gn_BGP_IPV4_NODE_357_prev,
		.to = &gn_BGP_IPV4_NODE_357_next,
		.data = &ctkn_BGP_IPV4_NODE[357],
	},
	{
		.from = &gn_BGP_IPV4_NODE_358_prev,
		.to = &gn_BGP_IPV4_NODE_358_next,
		.data = &ctkn_BGP_IPV4_NODE[358],
	},
	{
		.from = &gn_BGP_IPV4_NODE_359_prev,
		.to = &gn_BGP_IPV4_NODE_359_next,
		.data = (void *)&neighbor_remove_private_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_360_prev,
		.to = &gn_BGP_IPV4_NODE_360_next,
		.data = &ctkn_BGP_IPV4_NODE[360],
	},
	{
		.from = &gn_BGP_IPV4_NODE_361_prev,
		.to = &gn_BGP_IPV4_NODE_361_next,
		.data = &ctkn_BGP_IPV4_NODE[361],
	},
	{
		.from = &gn_BGP_IPV4_NODE_362_prev,
		.to = &gn_BGP_IPV4_NODE_362_next,
		.data = (void *)&neighbor_remove_private_as_all_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_363_prev,
		.to = &gn_BGP_IPV4_NODE_363_next,
		.data = &ctkn_BGP_IPV4_NODE[363],
	},
	{
		.from = &gn_BGP_IPV4_NODE_364_prev,
		.to = &gn_BGP_IPV4_NODE_364_next,
		.data = &ctkn_BGP_IPV4_NODE[364],
	},
	{
		.from = &gn_BGP_IPV4_NODE_365_prev,
		.to = &gn_BGP_IPV4_NODE_365_next,
		.data = (void *)&neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_366_prev,
		.to = &gn_BGP_IPV4_NODE_366_next,
		.data = &ctkn_BGP_IPV4_NODE[366],
	},
	{
		.from = &gn_BGP_IPV4_NODE_367_prev,
		.to = &gn_BGP_IPV4_NODE_367_next,
		.data = &ctkn_BGP_IPV4_NODE[367],
	},
	{
		.from = &gn_BGP_IPV4_NODE_368_prev,
		.to = &gn_BGP_IPV4_NODE_368_next,
		.data = (void *)&neighbor_remove_private_as_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_369_prev,
		.to = &gn_BGP_IPV4_NODE_369_next,
		.data = &ctkn_BGP_IPV4_NODE[369],
	},
	{
		.from = &gn_BGP_IPV4_NODE_370_prev,
		.to = &gn_BGP_IPV4_NODE_370_next,
		.data = &ctkn_BGP_IPV4_NODE[370],
	},
	{
		.from = &gn_BGP_IPV4_NODE_371_prev,
		.to = &gn_BGP_IPV4_NODE_371_next,
		.data = &ctkn_BGP_IPV4_NODE[371],
	},
	{
		.from = &gn_BGP_IPV4_NODE_372_prev,
		.to = &gn_BGP_IPV4_NODE_372_next,
		.data = &ctkn_BGP_IPV4_NODE[372],
	},
	{
		.from = &gn_BGP_IPV4_NODE_373_prev,
		.to = &gn_BGP_IPV4_NODE_373_next,
		.data = &ctkn_BGP_IPV4_NODE[373],
	},
	{
		.from = &gn_BGP_IPV4_NODE_374_prev,
		.to = &gn_BGP_IPV4_NODE_374_next,
		.data = &ctkn_BGP_IPV4_NODE[374],
	},
	{
		.from = &gn_BGP_IPV4_NODE_375_prev,
		.to = &gn_BGP_IPV4_NODE_375_next,
		.data = (void *)&neighbor_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_376_prev,
		.to = &gn_BGP_IPV4_NODE_376_next,
		.data = &ctkn_BGP_IPV4_NODE[376],
	},
	{
		.from = &gn_BGP_IPV4_NODE_377_prev,
		.to = &gn_BGP_IPV4_NODE_377_next,
		.data = &ctkn_BGP_IPV4_NODE[377],
	},
	{
		.from = &gn_BGP_IPV4_NODE_378_prev,
		.to = &gn_BGP_IPV4_NODE_378_next,
		.data = &ctkn_BGP_IPV4_NODE[378],
	},
	{
		.from = &gn_BGP_IPV4_NODE_379_prev,
		.to = &gn_BGP_IPV4_NODE_379_next,
		.data = (void *)&neighbor_route_reflector_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_380_prev,
		.to = &gn_BGP_IPV4_NODE_380_next,
		.data = &ctkn_BGP_IPV4_NODE[380],
	},
	{
		.from = &gn_BGP_IPV4_NODE_381_prev,
		.to = &gn_BGP_IPV4_NODE_381_next,
		.data = &ctkn_BGP_IPV4_NODE[381],
	},
	{
		.from = &gn_BGP_IPV4_NODE_382_prev,
		.to = &gn_BGP_IPV4_NODE_382_next,
		.data = (void *)&neighbor_route_server_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_383_prev,
		.to = &gn_BGP_IPV4_NODE_383_next,
		.data = &ctkn_BGP_IPV4_NODE[383],
	},
	{
		.from = &gn_BGP_IPV4_NODE_384_prev,
		.to = &gn_BGP_IPV4_NODE_384_next,
		.data = &ctkn_BGP_IPV4_NODE[384],
	},
	{
		.from = &gn_BGP_IPV4_NODE_385_prev,
		.to = &gn_BGP_IPV4_NODE_385_next,
		.data = (void *)&neighbor_send_community_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_386_prev,
		.to = &gn_BGP_IPV4_NODE_386_next,
		.data = &ctkn_BGP_IPV4_NODE[386],
	},
	{
		.from = &gn_BGP_IPV4_NODE_387_prev,
		.to = &gn_BGP_IPV4_NODE_387_next,
		.data = &ctkn_BGP_IPV4_NODE[387],
	},
	{
		.from = &gn_BGP_IPV4_NODE_388_prev,
		.to = &gn_BGP_IPV4_NODE_388_next,
		.data = &ctkn_BGP_IPV4_NODE[388],
	},
	{
		.from = &gn_BGP_IPV4_NODE_389_prev,
		.to = &gn_BGP_IPV4_NODE_389_next,
		.data = &ctkn_BGP_IPV4_NODE[389],
	},
	{
		.from = &gn_BGP_IPV4_NODE_390_prev,
		.to = &gn_BGP_IPV4_NODE_390_next,
		.data = (void *)&neighbor_send_community_type_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_391_prev,
		.to = &gn_BGP_IPV4_NODE_391_next,
		.data = &ctkn_BGP_IPV4_NODE[391],
	},
	{
		.from = &gn_BGP_IPV4_NODE_392_prev,
		.to = &gn_BGP_IPV4_NODE_392_next,
		.data = &ctkn_BGP_IPV4_NODE[392],
	},
	{
		.from = &gn_BGP_IPV4_NODE_393_prev,
		.to = &gn_BGP_IPV4_NODE_393_next,
		.data = &ctkn_BGP_IPV4_NODE[393],
	},
	{
		.from = &gn_BGP_IPV4_NODE_394_prev,
		.to = &gn_BGP_IPV4_NODE_394_next,
		.data = &ctkn_BGP_IPV4_NODE[394],
	},
	{
		.from = &gn_BGP_IPV4_NODE_395_prev,
		.to = &gn_BGP_IPV4_NODE_395_next,
		.data = &ctkn_BGP_IPV4_NODE[395],
	},
	{
		.from = &gn_BGP_IPV4_NODE_396_prev,
		.to = &gn_BGP_IPV4_NODE_396_next,
		.data = &ctkn_BGP_IPV4_NODE[396],
	},
	{
		.from = &gn_BGP_IPV4_NODE_397_prev,
		.to = &gn_BGP_IPV4_NODE_397_next,
		.data = &ctkn_BGP_IPV4_NODE[397],
	},
	{
		.from = &gn_BGP_IPV4_NODE_398_prev,
		.to = &gn_BGP_IPV4_NODE_398_next,
		.data = (void *)&neighbor_soft_reconfiguration_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_399_prev,
		.to = &gn_BGP_IPV4_NODE_399_next,
		.data = &ctkn_BGP_IPV4_NODE[399],
	},
	{
		.from = &gn_BGP_IPV4_NODE_400_prev,
		.to = &gn_BGP_IPV4_NODE_400_next,
		.data = &ctkn_BGP_IPV4_NODE[400],
	},
	{
		.from = &gn_BGP_IPV4_NODE_401_prev,
		.to = &gn_BGP_IPV4_NODE_401_next,
		.data = &ctkn_BGP_IPV4_NODE[401],
	},
	{
		.from = &gn_BGP_IPV4_NODE_402_prev,
		.to = &gn_BGP_IPV4_NODE_402_next,
		.data = (void *)&neighbor_soo_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_403_prev,
		.to = &gn_BGP_IPV4_NODE_403_next,
		.data = &ctkn_BGP_IPV4_NODE[403],
	},
	{
		.from = &gn_BGP_IPV4_NODE_404_prev,
		.to = &gn_BGP_IPV4_NODE_404_next,
		.data = &ctkn_BGP_IPV4_NODE[404],
	},
	{
		.from = &gn_BGP_IPV4_NODE_405_prev,
		.to = &gn_BGP_IPV4_NODE_405_next,
		.data = &ctkn_BGP_IPV4_NODE[405],
	},
	{
		.from = &gn_BGP_IPV4_NODE_406_prev,
		.to = &gn_BGP_IPV4_NODE_406_next,
		.data = (void *)&neighbor_unsuppress_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_407_prev,
		.to = &gn_BGP_IPV4_NODE_407_next,
		.data = &ctkn_BGP_IPV4_NODE[407],
	},
	{
		.from = &gn_BGP_IPV4_NODE_408_prev,
		.to = &gn_BGP_IPV4_NODE_408_next,
		.data = &ctkn_BGP_IPV4_NODE[408],
	},
	{
		.from = &gn_BGP_IPV4_NODE_409_prev,
		.to = &gn_BGP_IPV4_NODE_409_next,
		.data = &ctkn_BGP_IPV4_NODE[409],
	},
	{
		.from = &gn_BGP_IPV4_NODE_410_prev,
		.to = &gn_BGP_IPV4_NODE_410_next,
		.data = (void *)&neighbor_weight_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_411_prev,
		.to = &gn_BGP_IPV4_NODE_411_next,
		.data = &ctkn_BGP_IPV4_NODE[411],
	},
	{
		.from = &gn_BGP_IPV4_NODE_412_prev,
		.to = &gn_BGP_IPV4_NODE_412_next,
		.data = &ctkn_BGP_IPV4_NODE[412],
	},
	{
		.from = &gn_BGP_IPV4_NODE_413_prev,
		.to = &gn_BGP_IPV4_NODE_413_next,
		.data = &ctkn_BGP_IPV4_NODE[413],
	},
	{
		.from = &gn_BGP_IPV4_NODE_414_prev,
		.to = &gn_BGP_IPV4_NODE_414_next,
		.data = &ctkn_BGP_IPV4_NODE[414],
	},
	{
		.from = &gn_BGP_IPV4_NODE_415_prev,
		.to = &gn_BGP_IPV4_NODE_415_next,
		.data = &ctkn_BGP_IPV4_NODE[415],
	},
	{
		.from = &gn_BGP_IPV4_NODE_416_prev,
		.to = &gn_BGP_IPV4_NODE_416_next,
		.data = &ctkn_BGP_IPV4_NODE[416],
	},
	{
		.from = &gn_BGP_IPV4_NODE_417_prev,
		.to = &gn_BGP_IPV4_NODE_417_next,
		.data = &ctkn_BGP_IPV4_NODE[417],
	},
	{
		.from = &gn_BGP_IPV4_NODE_418_prev,
		.to = &gn_BGP_IPV4_NODE_418_next,
		.data = &ctkn_BGP_IPV4_NODE[418],
	},
	{
		.from = &gn_BGP_IPV4_NODE_419_prev,
		.to = &gn_BGP_IPV4_NODE_419_next,
		.data = &ctkn_BGP_IPV4_NODE[419],
	},
	{
		.from = &gn_BGP_IPV4_NODE_420_prev,
		.to = &gn_BGP_IPV4_NODE_420_next,
		.data = (void *)&af_no_rt_vpn_imexport_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_421_prev,
		.to = &gn_BGP_IPV4_NODE_421_next,
		.data = &ctkn_BGP_IPV4_NODE[421],
	},
	{
		.from = &gn_BGP_IPV4_NODE_422_prev,
		.to = &gn_BGP_IPV4_NODE_422_next,
		.data = &ctkn_BGP_IPV4_NODE[422],
	},
	{
		.from = &gn_BGP_IPV4_NODE_423_prev,
		.to = &gn_BGP_IPV4_NODE_423_next,
		.data = &ctkn_BGP_IPV4_NODE[423],
	},
	{
		.from = &gn_BGP_IPV4_NODE_424_prev,
		.to = &gn_BGP_IPV4_NODE_424_next,
		.data = &ctkn_BGP_IPV4_NODE[424],
	},
	{
		.from = &gn_BGP_IPV4_NODE_425_prev,
		.to = &gn_BGP_IPV4_NODE_425_next,
		.data = &ctkn_BGP_IPV4_NODE[425],
	},
	{
		.from = &gn_BGP_IPV4_NODE_426_prev,
		.to = &gn_BGP_IPV4_NODE_426_next,
		.data = &ctkn_BGP_IPV4_NODE[426],
	},
	{
		.from = &gn_BGP_IPV4_NODE_427_prev,
		.to = &gn_BGP_IPV4_NODE_427_next,
		.data = &ctkn_BGP_IPV4_NODE[427],
	},
	{
		.from = &gn_BGP_IPV4_NODE_428_prev,
		.to = &gn_BGP_IPV4_NODE_428_next,
		.data = &ctkn_BGP_IPV4_NODE[428],
	},
	{
		.from = &gn_BGP_IPV4_NODE_429_prev,
		.to = &gn_BGP_IPV4_NODE_429_next,
		.data = &ctkn_BGP_IPV4_NODE[429],
	},
	{
		.from = &gn_BGP_IPV4_NODE_430_prev,
		.to = &gn_BGP_IPV4_NODE_430_next,
		.data = &ctkn_BGP_IPV4_NODE[430],
	},
	{
		.from = &gn_BGP_IPV4_NODE_431_prev,
		.to = &gn_BGP_IPV4_NODE_431_next,
		.data = &ctkn_BGP_IPV4_NODE[431],
	},
	{
		.from = &gn_BGP_IPV4_NODE_432_prev,
		.to = &gn_BGP_IPV4_NODE_432_next,
		.data = &ctkn_BGP_IPV4_NODE[432],
	},
	{
		.from = &gn_BGP_IPV4_NODE_433_prev,
		.to = &gn_BGP_IPV4_NODE_433_next,
		.data = &ctkn_BGP_IPV4_NODE[433],
	},
	{
		.from = &gn_BGP_IPV4_NODE_434_prev,
		.to = &gn_BGP_IPV4_NODE_434_next,
		.data = &ctkn_BGP_IPV4_NODE[434],
	},
	{
		.from = &gn_BGP_IPV4_NODE_435_prev,
		.to = &gn_BGP_IPV4_NODE_435_next,
		.data = (void *)&bgp_damp_unset_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_436_prev,
		.to = &gn_BGP_IPV4_NODE_436_next,
		.data = &ctkn_BGP_IPV4_NODE[436],
	},
	{
		.from = &gn_BGP_IPV4_NODE_437_prev,
		.to = &gn_BGP_IPV4_NODE_437_next,
		.data = &ctkn_BGP_IPV4_NODE[437],
	},
	{
		.from = &gn_BGP_IPV4_NODE_438_prev,
		.to = &gn_BGP_IPV4_NODE_438_next,
		.data = &ctkn_BGP_IPV4_NODE[438],
	},
	{
		.from = &gn_BGP_IPV4_NODE_439_prev,
		.to = &gn_BGP_IPV4_NODE_439_next,
		.data = &ctkn_BGP_IPV4_NODE[439],
	},
	{
		.from = &gn_BGP_IPV4_NODE_440_prev,
		.to = &gn_BGP_IPV4_NODE_440_next,
		.data = (void *)&no_bgp_distance_source_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_441_prev,
		.to = &gn_BGP_IPV4_NODE_441_next,
		.data = &ctkn_BGP_IPV4_NODE[441],
	},
	{
		.from = &gn_BGP_IPV4_NODE_442_prev,
		.to = &gn_BGP_IPV4_NODE_442_next,
		.data = &ctkn_BGP_IPV4_NODE[442],
	},
	{
		.from = &gn_BGP_IPV4_NODE_443_prev,
		.to = &gn_BGP_IPV4_NODE_443_next,
		.data = (void *)&no_bgp_distance_source_access_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_444_prev,
		.to = &gn_BGP_IPV4_NODE_444_next,
		.data = &ctkn_BGP_IPV4_NODE[444],
	},
	{
		.from = &gn_BGP_IPV4_NODE_445_prev,
		.to = &gn_BGP_IPV4_NODE_445_next,
		.data = &ctkn_BGP_IPV4_NODE[445],
	},
	{
		.from = &gn_BGP_IPV4_NODE_446_prev,
		.to = &gn_BGP_IPV4_NODE_446_next,
		.data = &ctkn_BGP_IPV4_NODE[446],
	},
	{
		.from = &gn_BGP_IPV4_NODE_447_prev,
		.to = &gn_BGP_IPV4_NODE_447_next,
		.data = &ctkn_BGP_IPV4_NODE[447],
	},
	{
		.from = &gn_BGP_IPV4_NODE_448_prev,
		.to = &gn_BGP_IPV4_NODE_448_next,
		.data = &ctkn_BGP_IPV4_NODE[448],
	},
	{
		.from = &gn_BGP_IPV4_NODE_449_prev,
		.to = &gn_BGP_IPV4_NODE_449_next,
		.data = &ctkn_BGP_IPV4_NODE[449],
	},
	{
		.from = &gn_BGP_IPV4_NODE_450_prev,
		.to = &gn_BGP_IPV4_NODE_450_next,
		.data = &ctkn_BGP_IPV4_NODE[450],
	},
	{
		.from = &gn_BGP_IPV4_NODE_451_prev,
		.to = &gn_BGP_IPV4_NODE_451_next,
		.data = (void *)&no_bgp_distance_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_452_prev,
		.to = &gn_BGP_IPV4_NODE_452_next,
		.data = &ctkn_BGP_IPV4_NODE[452],
	},
	{
		.from = &gn_BGP_IPV4_NODE_453_prev,
		.to = &gn_BGP_IPV4_NODE_453_next,
		.data = &ctkn_BGP_IPV4_NODE[453],
	},
	{
		.from = &gn_BGP_IPV4_NODE_454_prev,
		.to = &gn_BGP_IPV4_NODE_454_next,
		.data = &ctkn_BGP_IPV4_NODE[454],
	},
	{
		.from = &gn_BGP_IPV4_NODE_455_prev,
		.to = &gn_BGP_IPV4_NODE_455_next,
		.data = &ctkn_BGP_IPV4_NODE[455],
	},
	{
		.from = &gn_BGP_IPV4_NODE_456_prev,
		.to = &gn_BGP_IPV4_NODE_456_next,
		.data = &ctkn_BGP_IPV4_NODE[456],
	},
	{
		.from = &gn_BGP_IPV4_NODE_457_prev,
		.to = &gn_BGP_IPV4_NODE_457_next,
		.data = &ctkn_BGP_IPV4_NODE[457],
	},
	{
		.from = &gn_BGP_IPV4_NODE_458_prev,
		.to = &gn_BGP_IPV4_NODE_458_next,
		.data = &ctkn_BGP_IPV4_NODE[458],
	},
	{
		.from = &gn_BGP_IPV4_NODE_459_prev,
		.to = &gn_BGP_IPV4_NODE_459_next,
		.data = (void *)&af_no_import_vrf_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_460_prev,
		.to = &gn_BGP_IPV4_NODE_460_next,
		.data = &ctkn_BGP_IPV4_NODE[460],
	},
	{
		.from = &gn_BGP_IPV4_NODE_461_prev,
		.to = &gn_BGP_IPV4_NODE_461_next,
		.data = &ctkn_BGP_IPV4_NODE[461],
	},
	{
		.from = &gn_BGP_IPV4_NODE_462_prev,
		.to = &gn_BGP_IPV4_NODE_462_next,
		.data = &ctkn_BGP_IPV4_NODE[462],
	},
	{
		.from = &gn_BGP_IPV4_NODE_463_prev,
		.to = &gn_BGP_IPV4_NODE_463_next,
		.data = &ctkn_BGP_IPV4_NODE[463],
	},
	{
		.from = &gn_BGP_IPV4_NODE_464_prev,
		.to = &gn_BGP_IPV4_NODE_464_next,
		.data = (void *)&af_no_label_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_465_prev,
		.to = &gn_BGP_IPV4_NODE_465_next,
		.data = &ctkn_BGP_IPV4_NODE[465],
	},
	{
		.from = &gn_BGP_IPV4_NODE_466_prev,
		.to = &gn_BGP_IPV4_NODE_466_next,
		.data = &ctkn_BGP_IPV4_NODE[466],
	},
	{
		.from = &gn_BGP_IPV4_NODE_467_prev,
		.to = &gn_BGP_IPV4_NODE_467_next,
		.data = &ctkn_BGP_IPV4_NODE[467],
	},
	{
		.from = &gn_BGP_IPV4_NODE_468_prev,
		.to = &gn_BGP_IPV4_NODE_468_next,
		.data = &ctkn_BGP_IPV4_NODE[468],
	},
	{
		.from = &gn_BGP_IPV4_NODE_469_prev,
		.to = &gn_BGP_IPV4_NODE_469_next,
		.data = &ctkn_BGP_IPV4_NODE[469],
	},
	{
		.from = &gn_BGP_IPV4_NODE_470_prev,
		.to = &gn_BGP_IPV4_NODE_470_next,
		.data = (void *)&no_bgp_maxpaths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_471_prev,
		.to = &gn_BGP_IPV4_NODE_471_next,
		.data = &ctkn_BGP_IPV4_NODE[471],
	},
	{
		.from = &gn_BGP_IPV4_NODE_472_prev,
		.to = &gn_BGP_IPV4_NODE_472_next,
		.data = &ctkn_BGP_IPV4_NODE[472],
	},
	{
		.from = &gn_BGP_IPV4_NODE_473_prev,
		.to = &gn_BGP_IPV4_NODE_473_next,
		.data = &ctkn_BGP_IPV4_NODE[473],
	},
	{
		.from = &gn_BGP_IPV4_NODE_474_prev,
		.to = &gn_BGP_IPV4_NODE_474_next,
		.data = &ctkn_BGP_IPV4_NODE[474],
	},
	{
		.from = &gn_BGP_IPV4_NODE_475_prev,
		.to = &gn_BGP_IPV4_NODE_475_next,
		.data = &ctkn_BGP_IPV4_NODE[475],
	},
	{
		.from = &gn_BGP_IPV4_NODE_476_prev,
		.to = &gn_BGP_IPV4_NODE_476_next,
		.data = &ctkn_BGP_IPV4_NODE[476],
	},
	{
		.from = &gn_BGP_IPV4_NODE_477_prev,
		.to = &gn_BGP_IPV4_NODE_477_next,
		.data = &ctkn_BGP_IPV4_NODE[477],
	},
	{
		.from = &gn_BGP_IPV4_NODE_478_prev,
		.to = &gn_BGP_IPV4_NODE_478_next,
		.data = &ctkn_BGP_IPV4_NODE[478],
	},
	{
		.from = &gn_BGP_IPV4_NODE_479_prev,
		.to = &gn_BGP_IPV4_NODE_479_next,
		.data = (void *)&no_bgp_maxpaths_ibgp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_480_prev,
		.to = &gn_BGP_IPV4_NODE_480_next,
		.data = &ctkn_BGP_IPV4_NODE[480],
	},
	{
		.from = &gn_BGP_IPV4_NODE_481_prev,
		.to = &gn_BGP_IPV4_NODE_481_next,
		.data = &ctkn_BGP_IPV4_NODE[481],
	},
	{
		.from = &gn_BGP_IPV4_NODE_482_prev,
		.to = &gn_BGP_IPV4_NODE_482_next,
		.data = &ctkn_BGP_IPV4_NODE[482],
	},
	{
		.from = &gn_BGP_IPV4_NODE_483_prev,
		.to = &gn_BGP_IPV4_NODE_483_next,
		.data = &ctkn_BGP_IPV4_NODE[483],
	},
	{
		.from = &gn_BGP_IPV4_NODE_484_prev,
		.to = &gn_BGP_IPV4_NODE_484_next,
		.data = &ctkn_BGP_IPV4_NODE[484],
	},
	{
		.from = &gn_BGP_IPV4_NODE_485_prev,
		.to = &gn_BGP_IPV4_NODE_485_next,
		.data = &ctkn_BGP_IPV4_NODE[485],
	},
	{
		.from = &gn_BGP_IPV4_NODE_486_prev,
		.to = &gn_BGP_IPV4_NODE_486_next,
		.data = (void *)&no_neighbor_activate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_487_prev,
		.to = &gn_BGP_IPV4_NODE_487_next,
		.data = &ctkn_BGP_IPV4_NODE[487],
	},
	{
		.from = &gn_BGP_IPV4_NODE_488_prev,
		.to = &gn_BGP_IPV4_NODE_488_next,
		.data = &ctkn_BGP_IPV4_NODE[488],
	},
	{
		.from = &gn_BGP_IPV4_NODE_489_prev,
		.to = &gn_BGP_IPV4_NODE_489_next,
		.data = &ctkn_BGP_IPV4_NODE[489],
	},
	{
		.from = &gn_BGP_IPV4_NODE_490_prev,
		.to = &gn_BGP_IPV4_NODE_490_next,
		.data = &ctkn_BGP_IPV4_NODE[490],
	},
	{
		.from = &gn_BGP_IPV4_NODE_491_prev,
		.to = &gn_BGP_IPV4_NODE_491_next,
		.data = &ctkn_BGP_IPV4_NODE[491],
	},
	{
		.from = &gn_BGP_IPV4_NODE_492_prev,
		.to = &gn_BGP_IPV4_NODE_492_next,
		.data = &ctkn_BGP_IPV4_NODE[492],
	},
	{
		.from = &gn_BGP_IPV4_NODE_493_prev,
		.to = &gn_BGP_IPV4_NODE_493_next,
		.data = &ctkn_BGP_IPV4_NODE[493],
	},
	{
		.from = &gn_BGP_IPV4_NODE_494_prev,
		.to = &gn_BGP_IPV4_NODE_494_next,
		.data = (void *)&no_neighbor_addpath_paths_limit_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_495_prev,
		.to = &gn_BGP_IPV4_NODE_495_next,
		.data = &ctkn_BGP_IPV4_NODE[495],
	},
	{
		.from = &gn_BGP_IPV4_NODE_496_prev,
		.to = &gn_BGP_IPV4_NODE_496_next,
		.data = &ctkn_BGP_IPV4_NODE[496],
	},
	{
		.from = &gn_BGP_IPV4_NODE_497_prev,
		.to = &gn_BGP_IPV4_NODE_497_next,
		.data = (void *)&no_neighbor_addpath_tx_all_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_498_prev,
		.to = &gn_BGP_IPV4_NODE_498_next,
		.data = &ctkn_BGP_IPV4_NODE[498],
	},
	{
		.from = &gn_BGP_IPV4_NODE_499_prev,
		.to = &gn_BGP_IPV4_NODE_499_next,
		.data = &ctkn_BGP_IPV4_NODE[499],
	},
	{
		.from = &gn_BGP_IPV4_NODE_500_prev,
		.to = &gn_BGP_IPV4_NODE_500_next,
		.data = &ctkn_BGP_IPV4_NODE[500],
	},
	{
		.from = &gn_BGP_IPV4_NODE_501_prev,
		.to = &gn_BGP_IPV4_NODE_501_next,
		.data = &ctkn_BGP_IPV4_NODE[501],
	},
	{
		.from = &gn_BGP_IPV4_NODE_502_prev,
		.to = &gn_BGP_IPV4_NODE_502_next,
		.data = &ctkn_BGP_IPV4_NODE[502],
	},
	{
		.from = &gn_BGP_IPV4_NODE_503_prev,
		.to = &gn_BGP_IPV4_NODE_503_next,
		.data = (void *)&no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_504_prev,
		.to = &gn_BGP_IPV4_NODE_504_next,
		.data = &ctkn_BGP_IPV4_NODE[504],
	},
	{
		.from = &gn_BGP_IPV4_NODE_505_prev,
		.to = &gn_BGP_IPV4_NODE_505_next,
		.data = &ctkn_BGP_IPV4_NODE[505],
	},
	{
		.from = &gn_BGP_IPV4_NODE_506_prev,
		.to = &gn_BGP_IPV4_NODE_506_next,
		.data = (void *)&no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_507_prev,
		.to = &gn_BGP_IPV4_NODE_507_next,
		.data = &ctkn_BGP_IPV4_NODE[507],
	},
	{
		.from = &gn_BGP_IPV4_NODE_508_prev,
		.to = &gn_BGP_IPV4_NODE_508_next,
		.data = &ctkn_BGP_IPV4_NODE[508],
	},
	{
		.from = &gn_BGP_IPV4_NODE_509_prev,
		.to = &gn_BGP_IPV4_NODE_509_next,
		.data = &ctkn_BGP_IPV4_NODE[509],
	},
	{
		.from = &gn_BGP_IPV4_NODE_510_prev,
		.to = &gn_BGP_IPV4_NODE_510_next,
		.data = &ctkn_BGP_IPV4_NODE[510],
	},
	{
		.from = &gn_BGP_IPV4_NODE_511_prev,
		.to = &gn_BGP_IPV4_NODE_511_next,
		.data = &ctkn_BGP_IPV4_NODE[511],
	},
	{
		.from = &gn_BGP_IPV4_NODE_512_prev,
		.to = &gn_BGP_IPV4_NODE_512_next,
		.data = &ctkn_BGP_IPV4_NODE[512],
	},
	{
		.from = &gn_BGP_IPV4_NODE_513_prev,
		.to = &gn_BGP_IPV4_NODE_513_next,
		.data = &ctkn_BGP_IPV4_NODE[513],
	},
	{
		.from = &gn_BGP_IPV4_NODE_514_prev,
		.to = &gn_BGP_IPV4_NODE_514_next,
		.data = (void *)&no_neighbor_allowas_in_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_515_prev,
		.to = &gn_BGP_IPV4_NODE_515_next,
		.data = &ctkn_BGP_IPV4_NODE[515],
	},
	{
		.from = &gn_BGP_IPV4_NODE_516_prev,
		.to = &gn_BGP_IPV4_NODE_516_next,
		.data = &ctkn_BGP_IPV4_NODE[516],
	},
	{
		.from = &gn_BGP_IPV4_NODE_517_prev,
		.to = &gn_BGP_IPV4_NODE_517_next,
		.data = &ctkn_BGP_IPV4_NODE[517],
	},
	{
		.from = &gn_BGP_IPV4_NODE_518_prev,
		.to = &gn_BGP_IPV4_NODE_518_next,
		.data = (void *)&no_neighbor_as_override_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_519_prev,
		.to = &gn_BGP_IPV4_NODE_519_next,
		.data = &ctkn_BGP_IPV4_NODE[519],
	},
	{
		.from = &gn_BGP_IPV4_NODE_520_prev,
		.to = &gn_BGP_IPV4_NODE_520_next,
		.data = &ctkn_BGP_IPV4_NODE[520],
	},
	{
		.from = &gn_BGP_IPV4_NODE_521_prev,
		.to = &gn_BGP_IPV4_NODE_521_next,
		.data = &ctkn_BGP_IPV4_NODE[521],
	},
	{
		.from = &gn_BGP_IPV4_NODE_522_prev,
		.to = &gn_BGP_IPV4_NODE_522_next,
		.data = &ctkn_BGP_IPV4_NODE[522],
	},
	{
		.from = &gn_BGP_IPV4_NODE_523_prev,
		.to = &gn_BGP_IPV4_NODE_523_next,
		.data = &ctkn_BGP_IPV4_NODE[523],
	},
	{
		.from = &gn_BGP_IPV4_NODE_524_prev,
		.to = &gn_BGP_IPV4_NODE_524_next,
		.data = &ctkn_BGP_IPV4_NODE[524],
	},
	{
		.from = &gn_BGP_IPV4_NODE_525_prev,
		.to = &gn_BGP_IPV4_NODE_525_next,
		.data = &ctkn_BGP_IPV4_NODE[525],
	},
	{
		.from = &gn_BGP_IPV4_NODE_526_prev,
		.to = &gn_BGP_IPV4_NODE_526_next,
		.data = (void *)&no_neighbor_attr_unchanged_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_527_prev,
		.to = &gn_BGP_IPV4_NODE_527_next,
		.data = &ctkn_BGP_IPV4_NODE[527],
	},
	{
		.from = &gn_BGP_IPV4_NODE_528_prev,
		.to = &gn_BGP_IPV4_NODE_528_next,
		.data = &ctkn_BGP_IPV4_NODE[528],
	},
	{
		.from = &gn_BGP_IPV4_NODE_529_prev,
		.to = &gn_BGP_IPV4_NODE_529_next,
		.data = &ctkn_BGP_IPV4_NODE[529],
	},
	{
		.from = &gn_BGP_IPV4_NODE_530_prev,
		.to = &gn_BGP_IPV4_NODE_530_next,
		.data = &ctkn_BGP_IPV4_NODE[530],
	},
	{
		.from = &gn_BGP_IPV4_NODE_531_prev,
		.to = &gn_BGP_IPV4_NODE_531_next,
		.data = &ctkn_BGP_IPV4_NODE[531],
	},
	{
		.from = &gn_BGP_IPV4_NODE_532_prev,
		.to = &gn_BGP_IPV4_NODE_532_next,
		.data = &ctkn_BGP_IPV4_NODE[532],
	},
	{
		.from = &gn_BGP_IPV4_NODE_533_prev,
		.to = &gn_BGP_IPV4_NODE_533_next,
		.data = &ctkn_BGP_IPV4_NODE[533],
	},
	{
		.from = &gn_BGP_IPV4_NODE_534_prev,
		.to = &gn_BGP_IPV4_NODE_534_next,
		.data = &ctkn_BGP_IPV4_NODE[534],
	},
	{
		.from = &gn_BGP_IPV4_NODE_535_prev,
		.to = &gn_BGP_IPV4_NODE_535_next,
		.data = &ctkn_BGP_IPV4_NODE[535],
	},
	{
		.from = &gn_BGP_IPV4_NODE_536_prev,
		.to = &gn_BGP_IPV4_NODE_536_next,
		.data = (void *)&no_neighbor_capability_orf_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_537_prev,
		.to = &gn_BGP_IPV4_NODE_537_next,
		.data = &ctkn_BGP_IPV4_NODE[537],
	},
	{
		.from = &gn_BGP_IPV4_NODE_538_prev,
		.to = &gn_BGP_IPV4_NODE_538_next,
		.data = &ctkn_BGP_IPV4_NODE[538],
	},
	{
		.from = &gn_BGP_IPV4_NODE_539_prev,
		.to = &gn_BGP_IPV4_NODE_539_next,
		.data = &ctkn_BGP_IPV4_NODE[539],
	},
	{
		.from = &gn_BGP_IPV4_NODE_540_prev,
		.to = &gn_BGP_IPV4_NODE_540_next,
		.data = &ctkn_BGP_IPV4_NODE[540],
	},
	{
		.from = &gn_BGP_IPV4_NODE_541_prev,
		.to = &gn_BGP_IPV4_NODE_541_next,
		.data = &ctkn_BGP_IPV4_NODE[541],
	},
	{
		.from = &gn_BGP_IPV4_NODE_542_prev,
		.to = &gn_BGP_IPV4_NODE_542_next,
		.data = &ctkn_BGP_IPV4_NODE[542],
	},
	{
		.from = &gn_BGP_IPV4_NODE_543_prev,
		.to = &gn_BGP_IPV4_NODE_543_next,
		.data = &ctkn_BGP_IPV4_NODE[543],
	},
	{
		.from = &gn_BGP_IPV4_NODE_544_prev,
		.to = &gn_BGP_IPV4_NODE_544_next,
		.data = &ctkn_BGP_IPV4_NODE[544],
	},
	{
		.from = &gn_BGP_IPV4_NODE_545_prev,
		.to = &gn_BGP_IPV4_NODE_545_next,
		.data = &ctkn_BGP_IPV4_NODE[545],
	},
	{
		.from = &gn_BGP_IPV4_NODE_546_prev,
		.to = &gn_BGP_IPV4_NODE_546_next,
		.data = &ctkn_BGP_IPV4_NODE[546],
	},
	{
		.from = &gn_BGP_IPV4_NODE_547_prev,
		.to = &gn_BGP_IPV4_NODE_547_next,
		.data = &ctkn_BGP_IPV4_NODE[547],
	},
	{
		.from = &gn_BGP_IPV4_NODE_548_prev,
		.to = &gn_BGP_IPV4_NODE_548_next,
		.data = &ctkn_BGP_IPV4_NODE[548],
	},
	{
		.from = &gn_BGP_IPV4_NODE_549_prev,
		.to = &gn_BGP_IPV4_NODE_549_next,
		.data = (void *)&no_neighbor_damp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_550_prev,
		.to = &gn_BGP_IPV4_NODE_550_next,
		.data = &ctkn_BGP_IPV4_NODE[550],
	},
	{
		.from = &gn_BGP_IPV4_NODE_551_prev,
		.to = &gn_BGP_IPV4_NODE_551_next,
		.data = &ctkn_BGP_IPV4_NODE[551],
	},
	{
		.from = &gn_BGP_IPV4_NODE_552_prev,
		.to = &gn_BGP_IPV4_NODE_552_next,
		.data = &ctkn_BGP_IPV4_NODE[552],
	},
	{
		.from = &gn_BGP_IPV4_NODE_553_prev,
		.to = &gn_BGP_IPV4_NODE_553_next,
		.data = &ctkn_BGP_IPV4_NODE[553],
	},
	{
		.from = &gn_BGP_IPV4_NODE_554_prev,
		.to = &gn_BGP_IPV4_NODE_554_next,
		.data = &ctkn_BGP_IPV4_NODE[554],
	},
	{
		.from = &gn_BGP_IPV4_NODE_555_prev,
		.to = &gn_BGP_IPV4_NODE_555_next,
		.data = &ctkn_BGP_IPV4_NODE[555],
	},
	{
		.from = &gn_BGP_IPV4_NODE_556_prev,
		.to = &gn_BGP_IPV4_NODE_556_next,
		.data = (void *)&no_neighbor_default_originate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_557_prev,
		.to = &gn_BGP_IPV4_NODE_557_next,
		.data = &ctkn_BGP_IPV4_NODE[557],
	},
	{
		.from = &gn_BGP_IPV4_NODE_558_prev,
		.to = &gn_BGP_IPV4_NODE_558_next,
		.data = &ctkn_BGP_IPV4_NODE[558],
	},
	{
		.from = &gn_BGP_IPV4_NODE_559_prev,
		.to = &gn_BGP_IPV4_NODE_559_next,
		.data = (void *)&no_neighbor_disable_addpath_rx_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_560_prev,
		.to = &gn_BGP_IPV4_NODE_560_next,
		.data = &ctkn_BGP_IPV4_NODE[560],
	},
	{
		.from = &gn_BGP_IPV4_NODE_561_prev,
		.to = &gn_BGP_IPV4_NODE_561_next,
		.data = &ctkn_BGP_IPV4_NODE[561],
	},
	{
		.from = &gn_BGP_IPV4_NODE_562_prev,
		.to = &gn_BGP_IPV4_NODE_562_next,
		.data = &ctkn_BGP_IPV4_NODE[562],
	},
	{
		.from = &gn_BGP_IPV4_NODE_563_prev,
		.to = &gn_BGP_IPV4_NODE_563_next,
		.data = &ctkn_BGP_IPV4_NODE[563],
	},
	{
		.from = &gn_BGP_IPV4_NODE_564_prev,
		.to = &gn_BGP_IPV4_NODE_564_next,
		.data = &ctkn_BGP_IPV4_NODE[564],
	},
	{
		.from = &gn_BGP_IPV4_NODE_565_prev,
		.to = &gn_BGP_IPV4_NODE_565_next,
		.data = &ctkn_BGP_IPV4_NODE[565],
	},
	{
		.from = &gn_BGP_IPV4_NODE_566_prev,
		.to = &gn_BGP_IPV4_NODE_566_next,
		.data = (void *)&no_neighbor_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_567_prev,
		.to = &gn_BGP_IPV4_NODE_567_next,
		.data = &ctkn_BGP_IPV4_NODE[567],
	},
	{
		.from = &gn_BGP_IPV4_NODE_568_prev,
		.to = &gn_BGP_IPV4_NODE_568_next,
		.data = &ctkn_BGP_IPV4_NODE[568],
	},
	{
		.from = &gn_BGP_IPV4_NODE_569_prev,
		.to = &gn_BGP_IPV4_NODE_569_next,
		.data = &ctkn_BGP_IPV4_NODE[569],
	},
	{
		.from = &gn_BGP_IPV4_NODE_570_prev,
		.to = &gn_BGP_IPV4_NODE_570_next,
		.data = &ctkn_BGP_IPV4_NODE[570],
	},
	{
		.from = &gn_BGP_IPV4_NODE_571_prev,
		.to = &gn_BGP_IPV4_NODE_571_next,
		.data = &ctkn_BGP_IPV4_NODE[571],
	},
	{
		.from = &gn_BGP_IPV4_NODE_572_prev,
		.to = &gn_BGP_IPV4_NODE_572_next,
		.data = &ctkn_BGP_IPV4_NODE[572],
	},
	{
		.from = &gn_BGP_IPV4_NODE_573_prev,
		.to = &gn_BGP_IPV4_NODE_573_next,
		.data = &ctkn_BGP_IPV4_NODE[573],
	},
	{
		.from = &gn_BGP_IPV4_NODE_574_prev,
		.to = &gn_BGP_IPV4_NODE_574_next,
		.data = (void *)&no_neighbor_filter_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_575_prev,
		.to = &gn_BGP_IPV4_NODE_575_next,
		.data = &ctkn_BGP_IPV4_NODE[575],
	},
	{
		.from = &gn_BGP_IPV4_NODE_576_prev,
		.to = &gn_BGP_IPV4_NODE_576_next,
		.data = &ctkn_BGP_IPV4_NODE[576],
	},
	{
		.from = &gn_BGP_IPV4_NODE_577_prev,
		.to = &gn_BGP_IPV4_NODE_577_next,
		.data = &ctkn_BGP_IPV4_NODE[577],
	},
	{
		.from = &gn_BGP_IPV4_NODE_578_prev,
		.to = &gn_BGP_IPV4_NODE_578_next,
		.data = &ctkn_BGP_IPV4_NODE[578],
	},
	{
		.from = &gn_BGP_IPV4_NODE_579_prev,
		.to = &gn_BGP_IPV4_NODE_579_next,
		.data = &ctkn_BGP_IPV4_NODE[579],
	},
	{
		.from = &gn_BGP_IPV4_NODE_580_prev,
		.to = &gn_BGP_IPV4_NODE_580_next,
		.data = &ctkn_BGP_IPV4_NODE[580],
	},
	{
		.from = &gn_BGP_IPV4_NODE_581_prev,
		.to = &gn_BGP_IPV4_NODE_581_next,
		.data = &ctkn_BGP_IPV4_NODE[581],
	},
	{
		.from = &gn_BGP_IPV4_NODE_582_prev,
		.to = &gn_BGP_IPV4_NODE_582_next,
		.data = &ctkn_BGP_IPV4_NODE[582],
	},
	{
		.from = &gn_BGP_IPV4_NODE_583_prev,
		.to = &gn_BGP_IPV4_NODE_583_next,
		.data = &ctkn_BGP_IPV4_NODE[583],
	},
	{
		.from = &gn_BGP_IPV4_NODE_584_prev,
		.to = &gn_BGP_IPV4_NODE_584_next,
		.data = &ctkn_BGP_IPV4_NODE[584],
	},
	{
		.from = &gn_BGP_IPV4_NODE_585_prev,
		.to = &gn_BGP_IPV4_NODE_585_next,
		.data = &ctkn_BGP_IPV4_NODE[585],
	},
	{
		.from = &gn_BGP_IPV4_NODE_586_prev,
		.to = &gn_BGP_IPV4_NODE_586_next,
		.data = &ctkn_BGP_IPV4_NODE[586],
	},
	{
		.from = &gn_BGP_IPV4_NODE_587_prev,
		.to = &gn_BGP_IPV4_NODE_587_next,
		.data = &ctkn_BGP_IPV4_NODE[587],
	},
	{
		.from = &gn_BGP_IPV4_NODE_588_prev,
		.to = &gn_BGP_IPV4_NODE_588_next,
		.data = &ctkn_BGP_IPV4_NODE[588],
	},
	{
		.from = &gn_BGP_IPV4_NODE_589_prev,
		.to = &gn_BGP_IPV4_NODE_589_next,
		.data = &ctkn_BGP_IPV4_NODE[589],
	},
	{
		.from = &gn_BGP_IPV4_NODE_590_prev,
		.to = &gn_BGP_IPV4_NODE_590_next,
		.data = &ctkn_BGP_IPV4_NODE[590],
	},
	{
		.from = &gn_BGP_IPV4_NODE_591_prev,
		.to = &gn_BGP_IPV4_NODE_591_next,
		.data = &ctkn_BGP_IPV4_NODE[591],
	},
	{
		.from = &gn_BGP_IPV4_NODE_592_prev,
		.to = &gn_BGP_IPV4_NODE_592_next,
		.data = &ctkn_BGP_IPV4_NODE[592],
	},
	{
		.from = &gn_BGP_IPV4_NODE_593_prev,
		.to = &gn_BGP_IPV4_NODE_593_next,
		.data = &ctkn_BGP_IPV4_NODE[593],
	},
	{
		.from = &gn_BGP_IPV4_NODE_594_prev,
		.to = &gn_BGP_IPV4_NODE_594_next,
		.data = (void *)&no_neighbor_maximum_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_595_prev,
		.to = &gn_BGP_IPV4_NODE_595_next,
		.data = &ctkn_BGP_IPV4_NODE[595],
	},
	{
		.from = &gn_BGP_IPV4_NODE_596_prev,
		.to = &gn_BGP_IPV4_NODE_596_next,
		.data = &ctkn_BGP_IPV4_NODE[596],
	},
	{
		.from = &gn_BGP_IPV4_NODE_597_prev,
		.to = &gn_BGP_IPV4_NODE_597_next,
		.data = &ctkn_BGP_IPV4_NODE[597],
	},
	{
		.from = &gn_BGP_IPV4_NODE_598_prev,
		.to = &gn_BGP_IPV4_NODE_598_next,
		.data = &ctkn_BGP_IPV4_NODE[598],
	},
	{
		.from = &gn_BGP_IPV4_NODE_599_prev,
		.to = &gn_BGP_IPV4_NODE_599_next,
		.data = &ctkn_BGP_IPV4_NODE[599],
	},
	{
		.from = &gn_BGP_IPV4_NODE_600_prev,
		.to = &gn_BGP_IPV4_NODE_600_next,
		.data = (void *)&no_neighbor_maximum_prefix_out_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_601_prev,
		.to = &gn_BGP_IPV4_NODE_601_next,
		.data = &ctkn_BGP_IPV4_NODE[601],
	},
	{
		.from = &gn_BGP_IPV4_NODE_602_prev,
		.to = &gn_BGP_IPV4_NODE_602_next,
		.data = &ctkn_BGP_IPV4_NODE[602],
	},
	{
		.from = &gn_BGP_IPV4_NODE_603_prev,
		.to = &gn_BGP_IPV4_NODE_603_next,
		.data = (void *)&no_neighbor_nexthop_self_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_604_prev,
		.to = &gn_BGP_IPV4_NODE_604_next,
		.data = &ctkn_BGP_IPV4_NODE[604],
	},
	{
		.from = &gn_BGP_IPV4_NODE_605_prev,
		.to = &gn_BGP_IPV4_NODE_605_next,
		.data = &ctkn_BGP_IPV4_NODE[605],
	},
	{
		.from = &gn_BGP_IPV4_NODE_606_prev,
		.to = &gn_BGP_IPV4_NODE_606_next,
		.data = (void *)&no_neighbor_nexthop_self_all_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_607_prev,
		.to = &gn_BGP_IPV4_NODE_607_next,
		.data = &ctkn_BGP_IPV4_NODE[607],
	},
	{
		.from = &gn_BGP_IPV4_NODE_608_prev,
		.to = &gn_BGP_IPV4_NODE_608_next,
		.data = &ctkn_BGP_IPV4_NODE[608],
	},
	{
		.from = &gn_BGP_IPV4_NODE_609_prev,
		.to = &gn_BGP_IPV4_NODE_609_next,
		.data = (void *)&no_neighbor_nexthop_self_force_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_610_prev,
		.to = &gn_BGP_IPV4_NODE_610_next,
		.data = &ctkn_BGP_IPV4_NODE[610],
	},
	{
		.from = &gn_BGP_IPV4_NODE_611_prev,
		.to = &gn_BGP_IPV4_NODE_611_next,
		.data = &ctkn_BGP_IPV4_NODE[611],
	},
	{
		.from = &gn_BGP_IPV4_NODE_612_prev,
		.to = &gn_BGP_IPV4_NODE_612_next,
		.data = &ctkn_BGP_IPV4_NODE[612],
	},
	{
		.from = &gn_BGP_IPV4_NODE_613_prev,
		.to = &gn_BGP_IPV4_NODE_613_next,
		.data = (void *)&no_neighbor_set_peer_group_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_614_prev,
		.to = &gn_BGP_IPV4_NODE_614_next,
		.data = &ctkn_BGP_IPV4_NODE[614],
	},
	{
		.from = &gn_BGP_IPV4_NODE_615_prev,
		.to = &gn_BGP_IPV4_NODE_615_next,
		.data = &ctkn_BGP_IPV4_NODE[615],
	},
	{
		.from = &gn_BGP_IPV4_NODE_616_prev,
		.to = &gn_BGP_IPV4_NODE_616_next,
		.data = &ctkn_BGP_IPV4_NODE[616],
	},
	{
		.from = &gn_BGP_IPV4_NODE_617_prev,
		.to = &gn_BGP_IPV4_NODE_617_next,
		.data = &ctkn_BGP_IPV4_NODE[617],
	},
	{
		.from = &gn_BGP_IPV4_NODE_618_prev,
		.to = &gn_BGP_IPV4_NODE_618_next,
		.data = &ctkn_BGP_IPV4_NODE[618],
	},
	{
		.from = &gn_BGP_IPV4_NODE_619_prev,
		.to = &gn_BGP_IPV4_NODE_619_next,
		.data = &ctkn_BGP_IPV4_NODE[619],
	},
	{
		.from = &gn_BGP_IPV4_NODE_620_prev,
		.to = &gn_BGP_IPV4_NODE_620_next,
		.data = (void *)&no_neighbor_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_621_prev,
		.to = &gn_BGP_IPV4_NODE_621_next,
		.data = &ctkn_BGP_IPV4_NODE[621],
	},
	{
		.from = &gn_BGP_IPV4_NODE_622_prev,
		.to = &gn_BGP_IPV4_NODE_622_next,
		.data = &ctkn_BGP_IPV4_NODE[622],
	},
	{
		.from = &gn_BGP_IPV4_NODE_623_prev,
		.to = &gn_BGP_IPV4_NODE_623_next,
		.data = &ctkn_BGP_IPV4_NODE[623],
	},
	{
		.from = &gn_BGP_IPV4_NODE_624_prev,
		.to = &gn_BGP_IPV4_NODE_624_next,
		.data = (void *)&no_neighbor_remove_private_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_625_prev,
		.to = &gn_BGP_IPV4_NODE_625_next,
		.data = &ctkn_BGP_IPV4_NODE[625],
	},
	{
		.from = &gn_BGP_IPV4_NODE_626_prev,
		.to = &gn_BGP_IPV4_NODE_626_next,
		.data = &ctkn_BGP_IPV4_NODE[626],
	},
	{
		.from = &gn_BGP_IPV4_NODE_627_prev,
		.to = &gn_BGP_IPV4_NODE_627_next,
		.data = (void *)&no_neighbor_remove_private_as_all_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_628_prev,
		.to = &gn_BGP_IPV4_NODE_628_next,
		.data = &ctkn_BGP_IPV4_NODE[628],
	},
	{
		.from = &gn_BGP_IPV4_NODE_629_prev,
		.to = &gn_BGP_IPV4_NODE_629_next,
		.data = &ctkn_BGP_IPV4_NODE[629],
	},
	{
		.from = &gn_BGP_IPV4_NODE_630_prev,
		.to = &gn_BGP_IPV4_NODE_630_next,
		.data = (void *)&no_neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_631_prev,
		.to = &gn_BGP_IPV4_NODE_631_next,
		.data = &ctkn_BGP_IPV4_NODE[631],
	},
	{
		.from = &gn_BGP_IPV4_NODE_632_prev,
		.to = &gn_BGP_IPV4_NODE_632_next,
		.data = &ctkn_BGP_IPV4_NODE[632],
	},
	{
		.from = &gn_BGP_IPV4_NODE_633_prev,
		.to = &gn_BGP_IPV4_NODE_633_next,
		.data = (void *)&no_neighbor_remove_private_as_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_634_prev,
		.to = &gn_BGP_IPV4_NODE_634_next,
		.data = &ctkn_BGP_IPV4_NODE[634],
	},
	{
		.from = &gn_BGP_IPV4_NODE_635_prev,
		.to = &gn_BGP_IPV4_NODE_635_next,
		.data = &ctkn_BGP_IPV4_NODE[635],
	},
	{
		.from = &gn_BGP_IPV4_NODE_636_prev,
		.to = &gn_BGP_IPV4_NODE_636_next,
		.data = &ctkn_BGP_IPV4_NODE[636],
	},
	{
		.from = &gn_BGP_IPV4_NODE_637_prev,
		.to = &gn_BGP_IPV4_NODE_637_next,
		.data = &ctkn_BGP_IPV4_NODE[637],
	},
	{
		.from = &gn_BGP_IPV4_NODE_638_prev,
		.to = &gn_BGP_IPV4_NODE_638_next,
		.data = &ctkn_BGP_IPV4_NODE[638],
	},
	{
		.from = &gn_BGP_IPV4_NODE_639_prev,
		.to = &gn_BGP_IPV4_NODE_639_next,
		.data = &ctkn_BGP_IPV4_NODE[639],
	},
	{
		.from = &gn_BGP_IPV4_NODE_640_prev,
		.to = &gn_BGP_IPV4_NODE_640_next,
		.data = (void *)&no_neighbor_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_641_prev,
		.to = &gn_BGP_IPV4_NODE_641_next,
		.data = &ctkn_BGP_IPV4_NODE[641],
	},
	{
		.from = &gn_BGP_IPV4_NODE_642_prev,
		.to = &gn_BGP_IPV4_NODE_642_next,
		.data = &ctkn_BGP_IPV4_NODE[642],
	},
	{
		.from = &gn_BGP_IPV4_NODE_643_prev,
		.to = &gn_BGP_IPV4_NODE_643_next,
		.data = &ctkn_BGP_IPV4_NODE[643],
	},
	{
		.from = &gn_BGP_IPV4_NODE_644_prev,
		.to = &gn_BGP_IPV4_NODE_644_next,
		.data = (void *)&no_neighbor_route_reflector_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_645_prev,
		.to = &gn_BGP_IPV4_NODE_645_next,
		.data = &ctkn_BGP_IPV4_NODE[645],
	},
	{
		.from = &gn_BGP_IPV4_NODE_646_prev,
		.to = &gn_BGP_IPV4_NODE_646_next,
		.data = &ctkn_BGP_IPV4_NODE[646],
	},
	{
		.from = &gn_BGP_IPV4_NODE_647_prev,
		.to = &gn_BGP_IPV4_NODE_647_next,
		.data = (void *)&no_neighbor_route_server_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_648_prev,
		.to = &gn_BGP_IPV4_NODE_648_next,
		.data = &ctkn_BGP_IPV4_NODE[648],
	},
	{
		.from = &gn_BGP_IPV4_NODE_649_prev,
		.to = &gn_BGP_IPV4_NODE_649_next,
		.data = &ctkn_BGP_IPV4_NODE[649],
	},
	{
		.from = &gn_BGP_IPV4_NODE_650_prev,
		.to = &gn_BGP_IPV4_NODE_650_next,
		.data = (void *)&no_neighbor_send_community_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_651_prev,
		.to = &gn_BGP_IPV4_NODE_651_next,
		.data = &ctkn_BGP_IPV4_NODE[651],
	},
	{
		.from = &gn_BGP_IPV4_NODE_652_prev,
		.to = &gn_BGP_IPV4_NODE_652_next,
		.data = &ctkn_BGP_IPV4_NODE[652],
	},
	{
		.from = &gn_BGP_IPV4_NODE_653_prev,
		.to = &gn_BGP_IPV4_NODE_653_next,
		.data = &ctkn_BGP_IPV4_NODE[653],
	},
	{
		.from = &gn_BGP_IPV4_NODE_654_prev,
		.to = &gn_BGP_IPV4_NODE_654_next,
		.data = &ctkn_BGP_IPV4_NODE[654],
	},
	{
		.from = &gn_BGP_IPV4_NODE_655_prev,
		.to = &gn_BGP_IPV4_NODE_655_next,
		.data = (void *)&no_neighbor_send_community_type_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_656_prev,
		.to = &gn_BGP_IPV4_NODE_656_next,
		.data = &ctkn_BGP_IPV4_NODE[656],
	},
	{
		.from = &gn_BGP_IPV4_NODE_657_prev,
		.to = &gn_BGP_IPV4_NODE_657_next,
		.data = &ctkn_BGP_IPV4_NODE[657],
	},
	{
		.from = &gn_BGP_IPV4_NODE_658_prev,
		.to = &gn_BGP_IPV4_NODE_658_next,
		.data = &ctkn_BGP_IPV4_NODE[658],
	},
	{
		.from = &gn_BGP_IPV4_NODE_659_prev,
		.to = &gn_BGP_IPV4_NODE_659_next,
		.data = &ctkn_BGP_IPV4_NODE[659],
	},
	{
		.from = &gn_BGP_IPV4_NODE_660_prev,
		.to = &gn_BGP_IPV4_NODE_660_next,
		.data = &ctkn_BGP_IPV4_NODE[660],
	},
	{
		.from = &gn_BGP_IPV4_NODE_661_prev,
		.to = &gn_BGP_IPV4_NODE_661_next,
		.data = &ctkn_BGP_IPV4_NODE[661],
	},
	{
		.from = &gn_BGP_IPV4_NODE_662_prev,
		.to = &gn_BGP_IPV4_NODE_662_next,
		.data = &ctkn_BGP_IPV4_NODE[662],
	},
	{
		.from = &gn_BGP_IPV4_NODE_663_prev,
		.to = &gn_BGP_IPV4_NODE_663_next,
		.data = (void *)&no_neighbor_soft_reconfiguration_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_664_prev,
		.to = &gn_BGP_IPV4_NODE_664_next,
		.data = &ctkn_BGP_IPV4_NODE[664],
	},
	{
		.from = &gn_BGP_IPV4_NODE_665_prev,
		.to = &gn_BGP_IPV4_NODE_665_next,
		.data = &ctkn_BGP_IPV4_NODE[665],
	},
	{
		.from = &gn_BGP_IPV4_NODE_666_prev,
		.to = &gn_BGP_IPV4_NODE_666_next,
		.data = &ctkn_BGP_IPV4_NODE[666],
	},
	{
		.from = &gn_BGP_IPV4_NODE_667_prev,
		.to = &gn_BGP_IPV4_NODE_667_next,
		.data = &ctkn_BGP_IPV4_NODE[667],
	},
	{
		.from = &gn_BGP_IPV4_NODE_668_prev,
		.to = &gn_BGP_IPV4_NODE_668_next,
		.data = &ctkn_BGP_IPV4_NODE[668],
	},
	{
		.from = &gn_BGP_IPV4_NODE_669_prev,
		.to = &gn_BGP_IPV4_NODE_669_next,
		.data = (void *)&no_neighbor_soo_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_670_prev,
		.to = &gn_BGP_IPV4_NODE_670_next,
		.data = &ctkn_BGP_IPV4_NODE[670],
	},
	{
		.from = &gn_BGP_IPV4_NODE_671_prev,
		.to = &gn_BGP_IPV4_NODE_671_next,
		.data = &ctkn_BGP_IPV4_NODE[671],
	},
	{
		.from = &gn_BGP_IPV4_NODE_672_prev,
		.to = &gn_BGP_IPV4_NODE_672_next,
		.data = &ctkn_BGP_IPV4_NODE[672],
	},
	{
		.from = &gn_BGP_IPV4_NODE_673_prev,
		.to = &gn_BGP_IPV4_NODE_673_next,
		.data = (void *)&no_neighbor_unsuppress_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_674_prev,
		.to = &gn_BGP_IPV4_NODE_674_next,
		.data = &ctkn_BGP_IPV4_NODE[674],
	},
	{
		.from = &gn_BGP_IPV4_NODE_675_prev,
		.to = &gn_BGP_IPV4_NODE_675_next,
		.data = &ctkn_BGP_IPV4_NODE[675],
	},
	{
		.from = &gn_BGP_IPV4_NODE_676_prev,
		.to = &gn_BGP_IPV4_NODE_676_next,
		.data = &ctkn_BGP_IPV4_NODE[676],
	},
	{
		.from = &gn_BGP_IPV4_NODE_677_prev,
		.to = &gn_BGP_IPV4_NODE_677_next,
		.data = &ctkn_BGP_IPV4_NODE[677],
	},
	{
		.from = &gn_BGP_IPV4_NODE_678_prev,
		.to = &gn_BGP_IPV4_NODE_678_next,
		.data = &ctkn_BGP_IPV4_NODE[678],
	},
	{
		.from = &gn_BGP_IPV4_NODE_679_prev,
		.to = &gn_BGP_IPV4_NODE_679_next,
		.data = (void *)&no_neighbor_weight_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_680_prev,
		.to = &gn_BGP_IPV4_NODE_680_next,
		.data = &ctkn_BGP_IPV4_NODE[680],
	},
	{
		.from = &gn_BGP_IPV4_NODE_681_prev,
		.to = &gn_BGP_IPV4_NODE_681_next,
		.data = &ctkn_BGP_IPV4_NODE[681],
	},
	{
		.from = &gn_BGP_IPV4_NODE_682_prev,
		.to = &gn_BGP_IPV4_NODE_682_next,
		.data = &ctkn_BGP_IPV4_NODE[682],
	},
	{
		.from = &gn_BGP_IPV4_NODE_683_prev,
		.to = &gn_BGP_IPV4_NODE_683_next,
		.data = &ctkn_BGP_IPV4_NODE[683],
	},
	{
		.from = &gn_BGP_IPV4_NODE_684_prev,
		.to = &gn_BGP_IPV4_NODE_684_next,
		.data = (void *)&af_no_rd_vpn_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_685_prev,
		.to = &gn_BGP_IPV4_NODE_685_next,
		.data = &ctkn_BGP_IPV4_NODE[685],
	},
	{
		.from = &gn_BGP_IPV4_NODE_686_prev,
		.to = &gn_BGP_IPV4_NODE_686_next,
		.data = &ctkn_BGP_IPV4_NODE[686],
	},
	{
		.from = &gn_BGP_IPV4_NODE_687_prev,
		.to = &gn_BGP_IPV4_NODE_687_next,
		.data = &ctkn_BGP_IPV4_NODE[687],
	},
	{
		.from = &gn_BGP_IPV4_NODE_688_prev,
		.to = &gn_BGP_IPV4_NODE_688_next,
		.data = &ctkn_BGP_IPV4_NODE[688],
	},
	{
		.from = &gn_BGP_IPV4_NODE_689_prev,
		.to = &gn_BGP_IPV4_NODE_689_next,
		.data = &ctkn_BGP_IPV4_NODE[689],
	},
	{
		.from = &gn_BGP_IPV4_NODE_690_prev,
		.to = &gn_BGP_IPV4_NODE_690_next,
		.data = &ctkn_BGP_IPV4_NODE[690],
	},
	{
		.from = &gn_BGP_IPV4_NODE_691_prev,
		.to = &gn_BGP_IPV4_NODE_691_next,
		.data = &ctkn_BGP_IPV4_NODE[691],
	},
	{
		.from = &gn_BGP_IPV4_NODE_692_prev,
		.to = &gn_BGP_IPV4_NODE_692_next,
		.data = &ctkn_BGP_IPV4_NODE[692],
	},
	{
		.from = &gn_BGP_IPV4_NODE_693_prev,
		.to = &gn_BGP_IPV4_NODE_693_next,
		.data = &ctkn_BGP_IPV4_NODE[693],
	},
	{
		.from = &gn_BGP_IPV4_NODE_694_prev,
		.to = &gn_BGP_IPV4_NODE_694_next,
		.data = &ctkn_BGP_IPV4_NODE[694],
	},
	{
		.from = &gn_BGP_IPV4_NODE_695_prev,
		.to = &gn_BGP_IPV4_NODE_695_next,
		.data = &ctkn_BGP_IPV4_NODE[695],
	},
	{
		.from = &gn_BGP_IPV4_NODE_696_prev,
		.to = &gn_BGP_IPV4_NODE_696_next,
		.data = (void *)&no_bgp_redistribute_ipv4_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_697_prev,
		.to = &gn_BGP_IPV4_NODE_697_next,
		.data = &ctkn_BGP_IPV4_NODE[697],
	},
	{
		.from = &gn_BGP_IPV4_NODE_698_prev,
		.to = &gn_BGP_IPV4_NODE_698_next,
		.data = &ctkn_BGP_IPV4_NODE[698],
	},
	{
		.from = &gn_BGP_IPV4_NODE_699_prev,
		.to = &gn_BGP_IPV4_NODE_699_next,
		.data = &ctkn_BGP_IPV4_NODE[699],
	},
	{
		.from = &gn_BGP_IPV4_NODE_700_prev,
		.to = &gn_BGP_IPV4_NODE_700_next,
		.data = &ctkn_BGP_IPV4_NODE[700],
	},
	{
		.from = &gn_BGP_IPV4_NODE_701_prev,
		.to = &gn_BGP_IPV4_NODE_701_next,
		.data = &ctkn_BGP_IPV4_NODE[701],
	},
	{
		.from = &gn_BGP_IPV4_NODE_702_prev,
		.to = &gn_BGP_IPV4_NODE_702_next,
		.data = &ctkn_BGP_IPV4_NODE[702],
	},
	{
		.from = &gn_BGP_IPV4_NODE_703_prev,
		.to = &gn_BGP_IPV4_NODE_703_next,
		.data = &ctkn_BGP_IPV4_NODE[703],
	},
	{
		.from = &gn_BGP_IPV4_NODE_704_prev,
		.to = &gn_BGP_IPV4_NODE_704_next,
		.data = &ctkn_BGP_IPV4_NODE[704],
	},
	{
		.from = &gn_BGP_IPV4_NODE_705_prev,
		.to = &gn_BGP_IPV4_NODE_705_next,
		.data = &ctkn_BGP_IPV4_NODE[705],
	},
	{
		.from = &gn_BGP_IPV4_NODE_706_prev,
		.to = &gn_BGP_IPV4_NODE_706_next,
		.data = &ctkn_BGP_IPV4_NODE[706],
	},
	{
		.from = &gn_BGP_IPV4_NODE_707_prev,
		.to = &gn_BGP_IPV4_NODE_707_next,
		.data = &ctkn_BGP_IPV4_NODE[707],
	},
	{
		.from = &gn_BGP_IPV4_NODE_708_prev,
		.to = &gn_BGP_IPV4_NODE_708_next,
		.data = &ctkn_BGP_IPV4_NODE[708],
	},
	{
		.from = &gn_BGP_IPV4_NODE_709_prev,
		.to = &gn_BGP_IPV4_NODE_709_next,
		.data = &ctkn_BGP_IPV4_NODE[709],
	},
	{
		.from = &gn_BGP_IPV4_NODE_710_prev,
		.to = &gn_BGP_IPV4_NODE_710_next,
		.data = &ctkn_BGP_IPV4_NODE[710],
	},
	{
		.from = &gn_BGP_IPV4_NODE_711_prev,
		.to = &gn_BGP_IPV4_NODE_711_next,
		.data = &ctkn_BGP_IPV4_NODE[711],
	},
	{
		.from = &gn_BGP_IPV4_NODE_712_prev,
		.to = &gn_BGP_IPV4_NODE_712_next,
		.data = &ctkn_BGP_IPV4_NODE[712],
	},
	{
		.from = &gn_BGP_IPV4_NODE_713_prev,
		.to = &gn_BGP_IPV4_NODE_713_next,
		.data = &ctkn_BGP_IPV4_NODE[713],
	},
	{
		.from = &gn_BGP_IPV4_NODE_714_prev,
		.to = &gn_BGP_IPV4_NODE_714_next,
		.data = &ctkn_BGP_IPV4_NODE[714],
	},
	{
		.from = &gn_BGP_IPV4_NODE_715_prev,
		.to = &gn_BGP_IPV4_NODE_715_next,
		.data = &ctkn_BGP_IPV4_NODE[715],
	},
	{
		.from = &gn_BGP_IPV4_NODE_716_prev,
		.to = &gn_BGP_IPV4_NODE_716_next,
		.data = &ctkn_BGP_IPV4_NODE[716],
	},
	{
		.from = &gn_BGP_IPV4_NODE_717_prev,
		.to = &gn_BGP_IPV4_NODE_717_next,
		.data = &ctkn_BGP_IPV4_NODE[717],
	},
	{
		.from = &gn_BGP_IPV4_NODE_718_prev,
		.to = &gn_BGP_IPV4_NODE_718_next,
		.data = &ctkn_BGP_IPV4_NODE[718],
	},
	{
		.from = &gn_BGP_IPV4_NODE_719_prev,
		.to = &gn_BGP_IPV4_NODE_719_next,
		.data = &ctkn_BGP_IPV4_NODE[719],
	},
	{
		.from = &gn_BGP_IPV4_NODE_720_prev,
		.to = &gn_BGP_IPV4_NODE_720_next,
		.data = &ctkn_BGP_IPV4_NODE[720],
	},
	{
		.from = &gn_BGP_IPV4_NODE_721_prev,
		.to = &gn_BGP_IPV4_NODE_721_next,
		.data = &ctkn_BGP_IPV4_NODE[721],
	},
	{
		.from = &gn_BGP_IPV4_NODE_722_prev,
		.to = &gn_BGP_IPV4_NODE_722_next,
		.data = (void *)&no_bgp_redistribute_ipv4_ospf_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_723_prev,
		.to = &gn_BGP_IPV4_NODE_723_next,
		.data = &ctkn_BGP_IPV4_NODE[723],
	},
	{
		.from = &gn_BGP_IPV4_NODE_724_prev,
		.to = &gn_BGP_IPV4_NODE_724_next,
		.data = &ctkn_BGP_IPV4_NODE[724],
	},
	{
		.from = &gn_BGP_IPV4_NODE_725_prev,
		.to = &gn_BGP_IPV4_NODE_725_next,
		.data = &ctkn_BGP_IPV4_NODE[725],
	},
	{
		.from = &gn_BGP_IPV4_NODE_726_prev,
		.to = &gn_BGP_IPV4_NODE_726_next,
		.data = &ctkn_BGP_IPV4_NODE[726],
	},
	{
		.from = &gn_BGP_IPV4_NODE_727_prev,
		.to = &gn_BGP_IPV4_NODE_727_next,
		.data = &ctkn_BGP_IPV4_NODE[727],
	},
	{
		.from = &gn_BGP_IPV4_NODE_728_prev,
		.to = &gn_BGP_IPV4_NODE_728_next,
		.data = &ctkn_BGP_IPV4_NODE[728],
	},
	{
		.from = &gn_BGP_IPV4_NODE_729_prev,
		.to = &gn_BGP_IPV4_NODE_729_next,
		.data = &ctkn_BGP_IPV4_NODE[729],
	},
	{
		.from = &gn_BGP_IPV4_NODE_730_prev,
		.to = &gn_BGP_IPV4_NODE_730_next,
		.data = &ctkn_BGP_IPV4_NODE[730],
	},
	{
		.from = &gn_BGP_IPV4_NODE_731_prev,
		.to = &gn_BGP_IPV4_NODE_731_next,
		.data = &ctkn_BGP_IPV4_NODE[731],
	},
	{
		.from = &gn_BGP_IPV4_NODE_732_prev,
		.to = &gn_BGP_IPV4_NODE_732_next,
		.data = &ctkn_BGP_IPV4_NODE[732],
	},
	{
		.from = &gn_BGP_IPV4_NODE_733_prev,
		.to = &gn_BGP_IPV4_NODE_733_next,
		.data = (void *)&af_no_route_map_vpn_imexport_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_734_prev,
		.to = &gn_BGP_IPV4_NODE_734_next,
		.data = &ctkn_BGP_IPV4_NODE[734],
	},
	{
		.from = &gn_BGP_IPV4_NODE_735_prev,
		.to = &gn_BGP_IPV4_NODE_735_next,
		.data = &ctkn_BGP_IPV4_NODE[735],
	},
	{
		.from = &gn_BGP_IPV4_NODE_736_prev,
		.to = &gn_BGP_IPV4_NODE_736_next,
		.data = &ctkn_BGP_IPV4_NODE[736],
	},
	{
		.from = &gn_BGP_IPV4_NODE_737_prev,
		.to = &gn_BGP_IPV4_NODE_737_next,
		.data = &ctkn_BGP_IPV4_NODE[737],
	},
	{
		.from = &gn_BGP_IPV4_NODE_738_prev,
		.to = &gn_BGP_IPV4_NODE_738_next,
		.data = (void *)&no_bgp_table_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_739_prev,
		.to = &gn_BGP_IPV4_NODE_739_next,
		.data = &ctkn_BGP_IPV4_NODE[739],
	},
	{
		.from = &gn_BGP_IPV4_NODE_740_prev,
		.to = &gn_BGP_IPV4_NODE_740_next,
		.data = &ctkn_BGP_IPV4_NODE[740],
	},
	{
		.from = &gn_BGP_IPV4_NODE_741_prev,
		.to = &gn_BGP_IPV4_NODE_741_next,
		.data = &ctkn_BGP_IPV4_NODE[741],
	},
	{
		.from = &gn_BGP_IPV4_NODE_742_prev,
		.to = &gn_BGP_IPV4_NODE_742_next,
		.data = &ctkn_BGP_IPV4_NODE[742],
	},
	{
		.from = &gn_BGP_IPV4_NODE_743_prev,
		.to = &gn_BGP_IPV4_NODE_743_next,
		.data = &ctkn_BGP_IPV4_NODE[743],
	},
	{
		.from = &gn_BGP_IPV4_NODE_744_prev,
		.to = &gn_BGP_IPV4_NODE_744_next,
		.data = (void *)&bgp_redistribute_ipv4_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_745_prev,
		.to = &gn_BGP_IPV4_NODE_745_next,
		.data = &ctkn_BGP_IPV4_NODE[745],
	},
	{
		.from = &gn_BGP_IPV4_NODE_746_prev,
		.to = &gn_BGP_IPV4_NODE_746_next,
		.data = &ctkn_BGP_IPV4_NODE[746],
	},
	{
		.from = &gn_BGP_IPV4_NODE_747_prev,
		.to = &gn_BGP_IPV4_NODE_747_next,
		.data = &ctkn_BGP_IPV4_NODE[747],
	},
	{
		.from = &gn_BGP_IPV4_NODE_748_prev,
		.to = &gn_BGP_IPV4_NODE_748_next,
		.data = &ctkn_BGP_IPV4_NODE[748],
	},
	{
		.from = &gn_BGP_IPV4_NODE_749_prev,
		.to = &gn_BGP_IPV4_NODE_749_next,
		.data = &ctkn_BGP_IPV4_NODE[749],
	},
	{
		.from = &gn_BGP_IPV4_NODE_750_prev,
		.to = &gn_BGP_IPV4_NODE_750_next,
		.data = &ctkn_BGP_IPV4_NODE[750],
	},
	{
		.from = &gn_BGP_IPV4_NODE_751_prev,
		.to = &gn_BGP_IPV4_NODE_751_next,
		.data = &ctkn_BGP_IPV4_NODE[751],
	},
	{
		.from = &gn_BGP_IPV4_NODE_752_prev,
		.to = &gn_BGP_IPV4_NODE_752_next,
		.data = &ctkn_BGP_IPV4_NODE[752],
	},
	{
		.from = &gn_BGP_IPV4_NODE_753_prev,
		.to = &gn_BGP_IPV4_NODE_753_next,
		.data = &ctkn_BGP_IPV4_NODE[753],
	},
	{
		.from = &gn_BGP_IPV4_NODE_754_prev,
		.to = &gn_BGP_IPV4_NODE_754_next,
		.data = &ctkn_BGP_IPV4_NODE[754],
	},
	{
		.from = &gn_BGP_IPV4_NODE_755_prev,
		.to = &gn_BGP_IPV4_NODE_755_next,
		.data = &ctkn_BGP_IPV4_NODE[755],
	},
	{
		.from = &gn_BGP_IPV4_NODE_756_prev,
		.to = &gn_BGP_IPV4_NODE_756_next,
		.data = &ctkn_BGP_IPV4_NODE[756],
	},
	{
		.from = &gn_BGP_IPV4_NODE_757_prev,
		.to = &gn_BGP_IPV4_NODE_757_next,
		.data = &ctkn_BGP_IPV4_NODE[757],
	},
	{
		.from = &gn_BGP_IPV4_NODE_758_prev,
		.to = &gn_BGP_IPV4_NODE_758_next,
		.data = &ctkn_BGP_IPV4_NODE[758],
	},
	{
		.from = &gn_BGP_IPV4_NODE_759_prev,
		.to = &gn_BGP_IPV4_NODE_759_next,
		.data = &ctkn_BGP_IPV4_NODE[759],
	},
	{
		.from = &gn_BGP_IPV4_NODE_760_prev,
		.to = &gn_BGP_IPV4_NODE_760_next,
		.data = (void *)&bgp_redistribute_ipv4_metric_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_761_prev,
		.to = &gn_BGP_IPV4_NODE_761_next,
		.data = &ctkn_BGP_IPV4_NODE[761],
	},
	{
		.from = &gn_BGP_IPV4_NODE_762_prev,
		.to = &gn_BGP_IPV4_NODE_762_next,
		.data = &ctkn_BGP_IPV4_NODE[762],
	},
	{
		.from = &gn_BGP_IPV4_NODE_763_prev,
		.to = &gn_BGP_IPV4_NODE_763_next,
		.data = &ctkn_BGP_IPV4_NODE[763],
	},
	{
		.from = &gn_BGP_IPV4_NODE_764_prev,
		.to = &gn_BGP_IPV4_NODE_764_next,
		.data = (void *)&bgp_redistribute_ipv4_metric_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_765_prev,
		.to = &gn_BGP_IPV4_NODE_765_next,
		.data = &ctkn_BGP_IPV4_NODE[765],
	},
	{
		.from = &gn_BGP_IPV4_NODE_766_prev,
		.to = &gn_BGP_IPV4_NODE_766_next,
		.data = &ctkn_BGP_IPV4_NODE[766],
	},
	{
		.from = &gn_BGP_IPV4_NODE_767_prev,
		.to = &gn_BGP_IPV4_NODE_767_next,
		.data = &ctkn_BGP_IPV4_NODE[767],
	},
	{
		.from = &gn_BGP_IPV4_NODE_768_prev,
		.to = &gn_BGP_IPV4_NODE_768_next,
		.data = (void *)&bgp_redistribute_ipv4_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_769_prev,
		.to = &gn_BGP_IPV4_NODE_769_next,
		.data = &ctkn_BGP_IPV4_NODE[769],
	},
	{
		.from = &gn_BGP_IPV4_NODE_770_prev,
		.to = &gn_BGP_IPV4_NODE_770_next,
		.data = &ctkn_BGP_IPV4_NODE[770],
	},
	{
		.from = &gn_BGP_IPV4_NODE_771_prev,
		.to = &gn_BGP_IPV4_NODE_771_next,
		.data = &ctkn_BGP_IPV4_NODE[771],
	},
	{
		.from = &gn_BGP_IPV4_NODE_772_prev,
		.to = &gn_BGP_IPV4_NODE_772_next,
		.data = (void *)&bgp_redistribute_ipv4_rmap_metric_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_773_prev,
		.to = &gn_BGP_IPV4_NODE_773_next,
		.data = &ctkn_BGP_IPV4_NODE[773],
	},
	{
		.from = &gn_BGP_IPV4_NODE_774_prev,
		.to = &gn_BGP_IPV4_NODE_774_next,
		.data = &ctkn_BGP_IPV4_NODE[774],
	},
	{
		.from = &gn_BGP_IPV4_NODE_775_prev,
		.to = &gn_BGP_IPV4_NODE_775_next,
		.data = &ctkn_BGP_IPV4_NODE[775],
	},
	{
		.from = &gn_BGP_IPV4_NODE_776_prev,
		.to = &gn_BGP_IPV4_NODE_776_next,
		.data = &ctkn_BGP_IPV4_NODE[776],
	},
	{
		.from = &gn_BGP_IPV4_NODE_777_prev,
		.to = &gn_BGP_IPV4_NODE_777_next,
		.data = &ctkn_BGP_IPV4_NODE[777],
	},
	{
		.from = &gn_BGP_IPV4_NODE_778_prev,
		.to = &gn_BGP_IPV4_NODE_778_next,
		.data = (void *)&bgp_redistribute_ipv4_ospf_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_779_prev,
		.to = &gn_BGP_IPV4_NODE_779_next,
		.data = &ctkn_BGP_IPV4_NODE[779],
	},
	{
		.from = &gn_BGP_IPV4_NODE_780_prev,
		.to = &gn_BGP_IPV4_NODE_780_next,
		.data = &ctkn_BGP_IPV4_NODE[780],
	},
	{
		.from = &gn_BGP_IPV4_NODE_781_prev,
		.to = &gn_BGP_IPV4_NODE_781_next,
		.data = &ctkn_BGP_IPV4_NODE[781],
	},
	{
		.from = &gn_BGP_IPV4_NODE_782_prev,
		.to = &gn_BGP_IPV4_NODE_782_next,
		.data = &ctkn_BGP_IPV4_NODE[782],
	},
	{
		.from = &gn_BGP_IPV4_NODE_783_prev,
		.to = &gn_BGP_IPV4_NODE_783_next,
		.data = &ctkn_BGP_IPV4_NODE[783],
	},
	{
		.from = &gn_BGP_IPV4_NODE_784_prev,
		.to = &gn_BGP_IPV4_NODE_784_next,
		.data = (void *)&bgp_redistribute_ipv4_ospf_metric_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_785_prev,
		.to = &gn_BGP_IPV4_NODE_785_next,
		.data = &ctkn_BGP_IPV4_NODE[785],
	},
	{
		.from = &gn_BGP_IPV4_NODE_786_prev,
		.to = &gn_BGP_IPV4_NODE_786_next,
		.data = &ctkn_BGP_IPV4_NODE[786],
	},
	{
		.from = &gn_BGP_IPV4_NODE_787_prev,
		.to = &gn_BGP_IPV4_NODE_787_next,
		.data = &ctkn_BGP_IPV4_NODE[787],
	},
	{
		.from = &gn_BGP_IPV4_NODE_788_prev,
		.to = &gn_BGP_IPV4_NODE_788_next,
		.data = (void *)&bgp_redistribute_ipv4_ospf_metric_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_789_prev,
		.to = &gn_BGP_IPV4_NODE_789_next,
		.data = &ctkn_BGP_IPV4_NODE[789],
	},
	{
		.from = &gn_BGP_IPV4_NODE_790_prev,
		.to = &gn_BGP_IPV4_NODE_790_next,
		.data = &ctkn_BGP_IPV4_NODE[790],
	},
	{
		.from = &gn_BGP_IPV4_NODE_791_prev,
		.to = &gn_BGP_IPV4_NODE_791_next,
		.data = &ctkn_BGP_IPV4_NODE[791],
	},
	{
		.from = &gn_BGP_IPV4_NODE_792_prev,
		.to = &gn_BGP_IPV4_NODE_792_next,
		.data = (void *)&bgp_redistribute_ipv4_ospf_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_793_prev,
		.to = &gn_BGP_IPV4_NODE_793_next,
		.data = &ctkn_BGP_IPV4_NODE[793],
	},
	{
		.from = &gn_BGP_IPV4_NODE_794_prev,
		.to = &gn_BGP_IPV4_NODE_794_next,
		.data = &ctkn_BGP_IPV4_NODE[794],
	},
	{
		.from = &gn_BGP_IPV4_NODE_795_prev,
		.to = &gn_BGP_IPV4_NODE_795_next,
		.data = &ctkn_BGP_IPV4_NODE[795],
	},
	{
		.from = &gn_BGP_IPV4_NODE_796_prev,
		.to = &gn_BGP_IPV4_NODE_796_next,
		.data = (void *)&bgp_redistribute_ipv4_ospf_rmap_metric_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4_NODE_797_prev,
		.to = &gn_BGP_IPV4_NODE_797_next,
		.data = &ctkn_BGP_IPV4_NODE[797],
	},
	{
		.from = &gn_BGP_IPV4_NODE_798_prev,
		.to = &gn_BGP_IPV4_NODE_798_next,
		.data = &ctkn_BGP_IPV4_NODE[798],
	},
	{
		.from = &gn_BGP_IPV4_NODE_799_prev,
		.to = &gn_BGP_IPV4_NODE_799_next,
		.data = &ctkn_BGP_IPV4_NODE[799],
	},
	{
		.from = &gn_BGP_IPV4_NODE_800_prev,
		.to = &gn_BGP_IPV4_NODE_800_next,
		.data = (void *)&bgp_table_map_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_BGP_IPV4_NODE, 801, &gn_BGP_IPV4_NODE[0], &gn_BGP_IPV4_NODE[1], &gn_BGP_IPV4_NODE[2], &gn_BGP_IPV4_NODE[3], &gn_BGP_IPV4_NODE[4], &gn_BGP_IPV4_NODE[5], &gn_BGP_IPV4_NODE[6], &gn_BGP_IPV4_NODE[7], &gn_BGP_IPV4_NODE[8], &gn_BGP_IPV4_NODE[9], &gn_BGP_IPV4_NODE[10], &gn_BGP_IPV4_NODE[11], &gn_BGP_IPV4_NODE[12], &gn_BGP_IPV4_NODE[13], &gn_BGP_IPV4_NODE[14], &gn_BGP_IPV4_NODE[15], &gn_BGP_IPV4_NODE[16], &gn_BGP_IPV4_NODE[17], &gn_BGP_IPV4_NODE[18], &gn_BGP_IPV4_NODE[19], &gn_BGP_IPV4_NODE[20], &gn_BGP_IPV4_NODE[21], &gn_BGP_IPV4_NODE[22], &gn_BGP_IPV4_NODE[23], &gn_BGP_IPV4_NODE[24], &gn_BGP_IPV4_NODE[25], &gn_BGP_IPV4_NODE[26], &gn_BGP_IPV4_NODE[27], &gn_BGP_IPV4_NODE[28], &gn_BGP_IPV4_NODE[29], &gn_BGP_IPV4_NODE[30], &gn_BGP_IPV4_NODE[31], &gn_BGP_IPV4_NODE[32], &gn_BGP_IPV4_NODE[33], &gn_BGP_IPV4_NODE[34], &gn_BGP_IPV4_NODE[35], &gn_BGP_IPV4_NODE[36], &gn_BGP_IPV4_NODE[37], &gn_BGP_IPV4_NODE[38], &gn_BGP_IPV4_NODE[39], &gn_BGP_IPV4_NODE[40], &gn_BGP_IPV4_NODE[41], &gn_BGP_IPV4_NODE[42], &gn_BGP_IPV4_NODE[43], &gn_BGP_IPV4_NODE[44], &gn_BGP_IPV4_NODE[45], &gn_BGP_IPV4_NODE[46], &gn_BGP_IPV4_NODE[47], &gn_BGP_IPV4_NODE[48], &gn_BGP_IPV4_NODE[49], &gn_BGP_IPV4_NODE[50], &gn_BGP_IPV4_NODE[51], &gn_BGP_IPV4_NODE[52], &gn_BGP_IPV4_NODE[53], &gn_BGP_IPV4_NODE[54], &gn_BGP_IPV4_NODE[55], &gn_BGP_IPV4_NODE[56], &gn_BGP_IPV4_NODE[57], &gn_BGP_IPV4_NODE[58], &gn_BGP_IPV4_NODE[59], &gn_BGP_IPV4_NODE[60], &gn_BGP_IPV4_NODE[61], &gn_BGP_IPV4_NODE[62], &gn_BGP_IPV4_NODE[63], &gn_BGP_IPV4_NODE[64], &gn_BGP_IPV4_NODE[65], &gn_BGP_IPV4_NODE[66], &gn_BGP_IPV4_NODE[67], &gn_BGP_IPV4_NODE[68], &gn_BGP_IPV4_NODE[69], &gn_BGP_IPV4_NODE[70], &gn_BGP_IPV4_NODE[71], &gn_BGP_IPV4_NODE[72], &gn_BGP_IPV4_NODE[73], &gn_BGP_IPV4_NODE[74], &gn_BGP_IPV4_NODE[75], &gn_BGP_IPV4_NODE[76], &gn_BGP_IPV4_NODE[77], &gn_BGP_IPV4_NODE[78], &gn_BGP_IPV4_NODE[79], &gn_BGP_IPV4_NODE[80], &gn_BGP_IPV4_NODE[81], &gn_BGP_IPV4_NODE[82], &gn_BGP_IPV4_NODE[83], &gn_BGP_IPV4_NODE[84], &gn_BGP_IPV4_NODE[85], &gn_BGP_IPV4_NODE[86], &gn_BGP_IPV4_NODE[87], &gn_BGP_IPV4_NODE[88], &gn_BGP_IPV4_NODE[89], &gn_BGP_IPV4_NODE[90], &gn_BGP_IPV4_NODE[91], &gn_BGP_IPV4_NODE[92], &gn_BGP_IPV4_NODE[93], &gn_BGP_IPV4_NODE[94], &gn_BGP_IPV4_NODE[95], &gn_BGP_IPV4_NODE[96], &gn_BGP_IPV4_NODE[97], &gn_BGP_IPV4_NODE[98], &gn_BGP_IPV4_NODE[99], &gn_BGP_IPV4_NODE[100], &gn_BGP_IPV4_NODE[101], &gn_BGP_IPV4_NODE[102], &gn_BGP_IPV4_NODE[103], &gn_BGP_IPV4_NODE[104], &gn_BGP_IPV4_NODE[105], &gn_BGP_IPV4_NODE[106], &gn_BGP_IPV4_NODE[107], &gn_BGP_IPV4_NODE[108], &gn_BGP_IPV4_NODE[109], &gn_BGP_IPV4_NODE[110], &gn_BGP_IPV4_NODE[111], &gn_BGP_IPV4_NODE[112], &gn_BGP_IPV4_NODE[113], &gn_BGP_IPV4_NODE[114], &gn_BGP_IPV4_NODE[115], &gn_BGP_IPV4_NODE[116], &gn_BGP_IPV4_NODE[117], &gn_BGP_IPV4_NODE[118], &gn_BGP_IPV4_NODE[119], &gn_BGP_IPV4_NODE[120], &gn_BGP_IPV4_NODE[121], &gn_BGP_IPV4_NODE[122], &gn_BGP_IPV4_NODE[123], &gn_BGP_IPV4_NODE[124], &gn_BGP_IPV4_NODE[125], &gn_BGP_IPV4_NODE[126], &gn_BGP_IPV4_NODE[127], &gn_BGP_IPV4_NODE[128], &gn_BGP_IPV4_NODE[129], &gn_BGP_IPV4_NODE[130], &gn_BGP_IPV4_NODE[131], &gn_BGP_IPV4_NODE[132], &gn_BGP_IPV4_NODE[133], &gn_BGP_IPV4_NODE[134], &gn_BGP_IPV4_NODE[135], &gn_BGP_IPV4_NODE[136], &gn_BGP_IPV4_NODE[137], &gn_BGP_IPV4_NODE[138], &gn_BGP_IPV4_NODE[139], &gn_BGP_IPV4_NODE[140], &gn_BGP_IPV4_NODE[141], &gn_BGP_IPV4_NODE[142], &gn_BGP_IPV4_NODE[143], &gn_BGP_IPV4_NODE[144], &gn_BGP_IPV4_NODE[145], &gn_BGP_IPV4_NODE[146], &gn_BGP_IPV4_NODE[147], &gn_BGP_IPV4_NODE[148], &gn_BGP_IPV4_NODE[149], &gn_BGP_IPV4_NODE[150], &gn_BGP_IPV4_NODE[151], &gn_BGP_IPV4_NODE[152], &gn_BGP_IPV4_NODE[153], &gn_BGP_IPV4_NODE[154], &gn_BGP_IPV4_NODE[155], &gn_BGP_IPV4_NODE[156], &gn_BGP_IPV4_NODE[157], &gn_BGP_IPV4_NODE[158], &gn_BGP_IPV4_NODE[159], &gn_BGP_IPV4_NODE[160], &gn_BGP_IPV4_NODE[161], &gn_BGP_IPV4_NODE[162], &gn_BGP_IPV4_NODE[163], &gn_BGP_IPV4_NODE[164], &gn_BGP_IPV4_NODE[165], &gn_BGP_IPV4_NODE[166], &gn_BGP_IPV4_NODE[167], &gn_BGP_IPV4_NODE[168], &gn_BGP_IPV4_NODE[169], &gn_BGP_IPV4_NODE[170], &gn_BGP_IPV4_NODE[171], &gn_BGP_IPV4_NODE[172], &gn_BGP_IPV4_NODE[173], &gn_BGP_IPV4_NODE[174], &gn_BGP_IPV4_NODE[175], &gn_BGP_IPV4_NODE[176], &gn_BGP_IPV4_NODE[177], &gn_BGP_IPV4_NODE[178], &gn_BGP_IPV4_NODE[179], &gn_BGP_IPV4_NODE[180], &gn_BGP_IPV4_NODE[181], &gn_BGP_IPV4_NODE[182], &gn_BGP_IPV4_NODE[183], &gn_BGP_IPV4_NODE[184], &gn_BGP_IPV4_NODE[185], &gn_BGP_IPV4_NODE[186], &gn_BGP_IPV4_NODE[187], &gn_BGP_IPV4_NODE[188], &gn_BGP_IPV4_NODE[189], &gn_BGP_IPV4_NODE[190], &gn_BGP_IPV4_NODE[191], &gn_BGP_IPV4_NODE[192], &gn_BGP_IPV4_NODE[193], &gn_BGP_IPV4_NODE[194], &gn_BGP_IPV4_NODE[195], &gn_BGP_IPV4_NODE[196], &gn_BGP_IPV4_NODE[197], &gn_BGP_IPV4_NODE[198], &gn_BGP_IPV4_NODE[199], &gn_BGP_IPV4_NODE[200], &gn_BGP_IPV4_NODE[201], &gn_BGP_IPV4_NODE[202], &gn_BGP_IPV4_NODE[203], &gn_BGP_IPV4_NODE[204], &gn_BGP_IPV4_NODE[205], &gn_BGP_IPV4_NODE[206], &gn_BGP_IPV4_NODE[207], &gn_BGP_IPV4_NODE[208], &gn_BGP_IPV4_NODE[209], &gn_BGP_IPV4_NODE[210], &gn_BGP_IPV4_NODE[211], &gn_BGP_IPV4_NODE[212], &gn_BGP_IPV4_NODE[213], &gn_BGP_IPV4_NODE[214], &gn_BGP_IPV4_NODE[215], &gn_BGP_IPV4_NODE[216], &gn_BGP_IPV4_NODE[217], &gn_BGP_IPV4_NODE[218], &gn_BGP_IPV4_NODE[219], &gn_BGP_IPV4_NODE[220], &gn_BGP_IPV4_NODE[221], &gn_BGP_IPV4_NODE[222], &gn_BGP_IPV4_NODE[223], &gn_BGP_IPV4_NODE[224], &gn_BGP_IPV4_NODE[225], &gn_BGP_IPV4_NODE[226], &gn_BGP_IPV4_NODE[227], &gn_BGP_IPV4_NODE[228], &gn_BGP_IPV4_NODE[229], &gn_BGP_IPV4_NODE[230], &gn_BGP_IPV4_NODE[231], &gn_BGP_IPV4_NODE[232], &gn_BGP_IPV4_NODE[233], &gn_BGP_IPV4_NODE[234], &gn_BGP_IPV4_NODE[235], &gn_BGP_IPV4_NODE[236], &gn_BGP_IPV4_NODE[237], &gn_BGP_IPV4_NODE[238], &gn_BGP_IPV4_NODE[239], &gn_BGP_IPV4_NODE[240], &gn_BGP_IPV4_NODE[241], &gn_BGP_IPV4_NODE[242], &gn_BGP_IPV4_NODE[243], &gn_BGP_IPV4_NODE[244], &gn_BGP_IPV4_NODE[245], &gn_BGP_IPV4_NODE[246], &gn_BGP_IPV4_NODE[247], &gn_BGP_IPV4_NODE[248], &gn_BGP_IPV4_NODE[249], &gn_BGP_IPV4_NODE[250], &gn_BGP_IPV4_NODE[251], &gn_BGP_IPV4_NODE[252], &gn_BGP_IPV4_NODE[253], &gn_BGP_IPV4_NODE[254], &gn_BGP_IPV4_NODE[255], &gn_BGP_IPV4_NODE[256], &gn_BGP_IPV4_NODE[257], &gn_BGP_IPV4_NODE[258], &gn_BGP_IPV4_NODE[259], &gn_BGP_IPV4_NODE[260], &gn_BGP_IPV4_NODE[261], &gn_BGP_IPV4_NODE[262], &gn_BGP_IPV4_NODE[263], &gn_BGP_IPV4_NODE[264], &gn_BGP_IPV4_NODE[265], &gn_BGP_IPV4_NODE[266], &gn_BGP_IPV4_NODE[267], &gn_BGP_IPV4_NODE[268], &gn_BGP_IPV4_NODE[269], &gn_BGP_IPV4_NODE[270], &gn_BGP_IPV4_NODE[271], &gn_BGP_IPV4_NODE[272], &gn_BGP_IPV4_NODE[273], &gn_BGP_IPV4_NODE[274], &gn_BGP_IPV4_NODE[275], &gn_BGP_IPV4_NODE[276], &gn_BGP_IPV4_NODE[277], &gn_BGP_IPV4_NODE[278], &gn_BGP_IPV4_NODE[279], &gn_BGP_IPV4_NODE[280], &gn_BGP_IPV4_NODE[281], &gn_BGP_IPV4_NODE[282], &gn_BGP_IPV4_NODE[283], &gn_BGP_IPV4_NODE[284], &gn_BGP_IPV4_NODE[285], &gn_BGP_IPV4_NODE[286], &gn_BGP_IPV4_NODE[287], &gn_BGP_IPV4_NODE[288], &gn_BGP_IPV4_NODE[289], &gn_BGP_IPV4_NODE[290], &gn_BGP_IPV4_NODE[291], &gn_BGP_IPV4_NODE[292], &gn_BGP_IPV4_NODE[293], &gn_BGP_IPV4_NODE[294], &gn_BGP_IPV4_NODE[295], &gn_BGP_IPV4_NODE[296], &gn_BGP_IPV4_NODE[297], &gn_BGP_IPV4_NODE[298], &gn_BGP_IPV4_NODE[299], &gn_BGP_IPV4_NODE[300], &gn_BGP_IPV4_NODE[301], &gn_BGP_IPV4_NODE[302], &gn_BGP_IPV4_NODE[303], &gn_BGP_IPV4_NODE[304], &gn_BGP_IPV4_NODE[305], &gn_BGP_IPV4_NODE[306], &gn_BGP_IPV4_NODE[307], &gn_BGP_IPV4_NODE[308], &gn_BGP_IPV4_NODE[309], &gn_BGP_IPV4_NODE[310], &gn_BGP_IPV4_NODE[311], &gn_BGP_IPV4_NODE[312], &gn_BGP_IPV4_NODE[313], &gn_BGP_IPV4_NODE[314], &gn_BGP_IPV4_NODE[315], &gn_BGP_IPV4_NODE[316], &gn_BGP_IPV4_NODE[317], &gn_BGP_IPV4_NODE[318], &gn_BGP_IPV4_NODE[319], &gn_BGP_IPV4_NODE[320], &gn_BGP_IPV4_NODE[321], &gn_BGP_IPV4_NODE[322], &gn_BGP_IPV4_NODE[323], &gn_BGP_IPV4_NODE[324], &gn_BGP_IPV4_NODE[325], &gn_BGP_IPV4_NODE[326], &gn_BGP_IPV4_NODE[327], &gn_BGP_IPV4_NODE[328], &gn_BGP_IPV4_NODE[329], &gn_BGP_IPV4_NODE[330], &gn_BGP_IPV4_NODE[331], &gn_BGP_IPV4_NODE[332], &gn_BGP_IPV4_NODE[333], &gn_BGP_IPV4_NODE[334], &gn_BGP_IPV4_NODE[335], &gn_BGP_IPV4_NODE[336], &gn_BGP_IPV4_NODE[337], &gn_BGP_IPV4_NODE[338], &gn_BGP_IPV4_NODE[339], &gn_BGP_IPV4_NODE[340], &gn_BGP_IPV4_NODE[341], &gn_BGP_IPV4_NODE[342], &gn_BGP_IPV4_NODE[343], &gn_BGP_IPV4_NODE[344], &gn_BGP_IPV4_NODE[345], &gn_BGP_IPV4_NODE[346], &gn_BGP_IPV4_NODE[347], &gn_BGP_IPV4_NODE[348], &gn_BGP_IPV4_NODE[349], &gn_BGP_IPV4_NODE[350], &gn_BGP_IPV4_NODE[351], &gn_BGP_IPV4_NODE[352], &gn_BGP_IPV4_NODE[353], &gn_BGP_IPV4_NODE[354], &gn_BGP_IPV4_NODE[355], &gn_BGP_IPV4_NODE[356], &gn_BGP_IPV4_NODE[357], &gn_BGP_IPV4_NODE[358], &gn_BGP_IPV4_NODE[359], &gn_BGP_IPV4_NODE[360], &gn_BGP_IPV4_NODE[361], &gn_BGP_IPV4_NODE[362], &gn_BGP_IPV4_NODE[363], &gn_BGP_IPV4_NODE[364], &gn_BGP_IPV4_NODE[365], &gn_BGP_IPV4_NODE[366], &gn_BGP_IPV4_NODE[367], &gn_BGP_IPV4_NODE[368], &gn_BGP_IPV4_NODE[369], &gn_BGP_IPV4_NODE[370], &gn_BGP_IPV4_NODE[371], &gn_BGP_IPV4_NODE[372], &gn_BGP_IPV4_NODE[373], &gn_BGP_IPV4_NODE[374], &gn_BGP_IPV4_NODE[375], &gn_BGP_IPV4_NODE[376], &gn_BGP_IPV4_NODE[377], &gn_BGP_IPV4_NODE[378], &gn_BGP_IPV4_NODE[379], &gn_BGP_IPV4_NODE[380], &gn_BGP_IPV4_NODE[381], &gn_BGP_IPV4_NODE[382], &gn_BGP_IPV4_NODE[383], &gn_BGP_IPV4_NODE[384], &gn_BGP_IPV4_NODE[385], &gn_BGP_IPV4_NODE[386], &gn_BGP_IPV4_NODE[387], &gn_BGP_IPV4_NODE[388], &gn_BGP_IPV4_NODE[389], &gn_BGP_IPV4_NODE[390], &gn_BGP_IPV4_NODE[391], &gn_BGP_IPV4_NODE[392], &gn_BGP_IPV4_NODE[393], &gn_BGP_IPV4_NODE[394], &gn_BGP_IPV4_NODE[395], &gn_BGP_IPV4_NODE[396], &gn_BGP_IPV4_NODE[397], &gn_BGP_IPV4_NODE[398], &gn_BGP_IPV4_NODE[399], &gn_BGP_IPV4_NODE[400], &gn_BGP_IPV4_NODE[401], &gn_BGP_IPV4_NODE[402], &gn_BGP_IPV4_NODE[403], &gn_BGP_IPV4_NODE[404], &gn_BGP_IPV4_NODE[405], &gn_BGP_IPV4_NODE[406], &gn_BGP_IPV4_NODE[407], &gn_BGP_IPV4_NODE[408], &gn_BGP_IPV4_NODE[409], &gn_BGP_IPV4_NODE[410], &gn_BGP_IPV4_NODE[411], &gn_BGP_IPV4_NODE[412], &gn_BGP_IPV4_NODE[413], &gn_BGP_IPV4_NODE[414], &gn_BGP_IPV4_NODE[415], &gn_BGP_IPV4_NODE[416], &gn_BGP_IPV4_NODE[417], &gn_BGP_IPV4_NODE[418], &gn_BGP_IPV4_NODE[419], &gn_BGP_IPV4_NODE[420], &gn_BGP_IPV4_NODE[421], &gn_BGP_IPV4_NODE[422], &gn_BGP_IPV4_NODE[423], &gn_BGP_IPV4_NODE[424], &gn_BGP_IPV4_NODE[425], &gn_BGP_IPV4_NODE[426], &gn_BGP_IPV4_NODE[427], &gn_BGP_IPV4_NODE[428], &gn_BGP_IPV4_NODE[429], &gn_BGP_IPV4_NODE[430], &gn_BGP_IPV4_NODE[431], &gn_BGP_IPV4_NODE[432], &gn_BGP_IPV4_NODE[433], &gn_BGP_IPV4_NODE[434], &gn_BGP_IPV4_NODE[435], &gn_BGP_IPV4_NODE[436], &gn_BGP_IPV4_NODE[437], &gn_BGP_IPV4_NODE[438], &gn_BGP_IPV4_NODE[439], &gn_BGP_IPV4_NODE[440], &gn_BGP_IPV4_NODE[441], &gn_BGP_IPV4_NODE[442], &gn_BGP_IPV4_NODE[443], &gn_BGP_IPV4_NODE[444], &gn_BGP_IPV4_NODE[445], &gn_BGP_IPV4_NODE[446], &gn_BGP_IPV4_NODE[447], &gn_BGP_IPV4_NODE[448], &gn_BGP_IPV4_NODE[449], &gn_BGP_IPV4_NODE[450], &gn_BGP_IPV4_NODE[451], &gn_BGP_IPV4_NODE[452], &gn_BGP_IPV4_NODE[453], &gn_BGP_IPV4_NODE[454], &gn_BGP_IPV4_NODE[455], &gn_BGP_IPV4_NODE[456], &gn_BGP_IPV4_NODE[457], &gn_BGP_IPV4_NODE[458], &gn_BGP_IPV4_NODE[459], &gn_BGP_IPV4_NODE[460], &gn_BGP_IPV4_NODE[461], &gn_BGP_IPV4_NODE[462], &gn_BGP_IPV4_NODE[463], &gn_BGP_IPV4_NODE[464], &gn_BGP_IPV4_NODE[465], &gn_BGP_IPV4_NODE[466], &gn_BGP_IPV4_NODE[467], &gn_BGP_IPV4_NODE[468], &gn_BGP_IPV4_NODE[469], &gn_BGP_IPV4_NODE[470], &gn_BGP_IPV4_NODE[471], &gn_BGP_IPV4_NODE[472], &gn_BGP_IPV4_NODE[473], &gn_BGP_IPV4_NODE[474], &gn_BGP_IPV4_NODE[475], &gn_BGP_IPV4_NODE[476], &gn_BGP_IPV4_NODE[477], &gn_BGP_IPV4_NODE[478], &gn_BGP_IPV4_NODE[479], &gn_BGP_IPV4_NODE[480], &gn_BGP_IPV4_NODE[481], &gn_BGP_IPV4_NODE[482], &gn_BGP_IPV4_NODE[483], &gn_BGP_IPV4_NODE[484], &gn_BGP_IPV4_NODE[485], &gn_BGP_IPV4_NODE[486], &gn_BGP_IPV4_NODE[487], &gn_BGP_IPV4_NODE[488], &gn_BGP_IPV4_NODE[489], &gn_BGP_IPV4_NODE[490], &gn_BGP_IPV4_NODE[491], &gn_BGP_IPV4_NODE[492], &gn_BGP_IPV4_NODE[493], &gn_BGP_IPV4_NODE[494], &gn_BGP_IPV4_NODE[495], &gn_BGP_IPV4_NODE[496], &gn_BGP_IPV4_NODE[497], &gn_BGP_IPV4_NODE[498], &gn_BGP_IPV4_NODE[499], &gn_BGP_IPV4_NODE[500], &gn_BGP_IPV4_NODE[501], &gn_BGP_IPV4_NODE[502], &gn_BGP_IPV4_NODE[503], &gn_BGP_IPV4_NODE[504], &gn_BGP_IPV4_NODE[505], &gn_BGP_IPV4_NODE[506], &gn_BGP_IPV4_NODE[507], &gn_BGP_IPV4_NODE[508], &gn_BGP_IPV4_NODE[509], &gn_BGP_IPV4_NODE[510], &gn_BGP_IPV4_NODE[511], &gn_BGP_IPV4_NODE[512], &gn_BGP_IPV4_NODE[513], &gn_BGP_IPV4_NODE[514], &gn_BGP_IPV4_NODE[515], &gn_BGP_IPV4_NODE[516], &gn_BGP_IPV4_NODE[517], &gn_BGP_IPV4_NODE[518], &gn_BGP_IPV4_NODE[519], &gn_BGP_IPV4_NODE[520], &gn_BGP_IPV4_NODE[521], &gn_BGP_IPV4_NODE[522], &gn_BGP_IPV4_NODE[523], &gn_BGP_IPV4_NODE[524], &gn_BGP_IPV4_NODE[525], &gn_BGP_IPV4_NODE[526], &gn_BGP_IPV4_NODE[527], &gn_BGP_IPV4_NODE[528], &gn_BGP_IPV4_NODE[529], &gn_BGP_IPV4_NODE[530], &gn_BGP_IPV4_NODE[531], &gn_BGP_IPV4_NODE[532], &gn_BGP_IPV4_NODE[533], &gn_BGP_IPV4_NODE[534], &gn_BGP_IPV4_NODE[535], &gn_BGP_IPV4_NODE[536], &gn_BGP_IPV4_NODE[537], &gn_BGP_IPV4_NODE[538], &gn_BGP_IPV4_NODE[539], &gn_BGP_IPV4_NODE[540], &gn_BGP_IPV4_NODE[541], &gn_BGP_IPV4_NODE[542], &gn_BGP_IPV4_NODE[543], &gn_BGP_IPV4_NODE[544], &gn_BGP_IPV4_NODE[545], &gn_BGP_IPV4_NODE[546], &gn_BGP_IPV4_NODE[547], &gn_BGP_IPV4_NODE[548], &gn_BGP_IPV4_NODE[549], &gn_BGP_IPV4_NODE[550], &gn_BGP_IPV4_NODE[551], &gn_BGP_IPV4_NODE[552], &gn_BGP_IPV4_NODE[553], &gn_BGP_IPV4_NODE[554], &gn_BGP_IPV4_NODE[555], &gn_BGP_IPV4_NODE[556], &gn_BGP_IPV4_NODE[557], &gn_BGP_IPV4_NODE[558], &gn_BGP_IPV4_NODE[559], &gn_BGP_IPV4_NODE[560], &gn_BGP_IPV4_NODE[561], &gn_BGP_IPV4_NODE[562], &gn_BGP_IPV4_NODE[563], &gn_BGP_IPV4_NODE[564], &gn_BGP_IPV4_NODE[565], &gn_BGP_IPV4_NODE[566], &gn_BGP_IPV4_NODE[567], &gn_BGP_IPV4_NODE[568], &gn_BGP_IPV4_NODE[569], &gn_BGP_IPV4_NODE[570], &gn_BGP_IPV4_NODE[571], &gn_BGP_IPV4_NODE[572], &gn_BGP_IPV4_NODE[573], &gn_BGP_IPV4_NODE[574], &gn_BGP_IPV4_NODE[575], &gn_BGP_IPV4_NODE[576], &gn_BGP_IPV4_NODE[577], &gn_BGP_IPV4_NODE[578], &gn_BGP_IPV4_NODE[579], &gn_BGP_IPV4_NODE[580], &gn_BGP_IPV4_NODE[581], &gn_BGP_IPV4_NODE[582], &gn_BGP_IPV4_NODE[583], &gn_BGP_IPV4_NODE[584], &gn_BGP_IPV4_NODE[585], &gn_BGP_IPV4_NODE[586], &gn_BGP_IPV4_NODE[587], &gn_BGP_IPV4_NODE[588], &gn_BGP_IPV4_NODE[589], &gn_BGP_IPV4_NODE[590], &gn_BGP_IPV4_NODE[591], &gn_BGP_IPV4_NODE[592], &gn_BGP_IPV4_NODE[593], &gn_BGP_IPV4_NODE[594], &gn_BGP_IPV4_NODE[595], &gn_BGP_IPV4_NODE[596], &gn_BGP_IPV4_NODE[597], &gn_BGP_IPV4_NODE[598], &gn_BGP_IPV4_NODE[599], &gn_BGP_IPV4_NODE[600], &gn_BGP_IPV4_NODE[601], &gn_BGP_IPV4_NODE[602], &gn_BGP_IPV4_NODE[603], &gn_BGP_IPV4_NODE[604], &gn_BGP_IPV4_NODE[605], &gn_BGP_IPV4_NODE[606], &gn_BGP_IPV4_NODE[607], &gn_BGP_IPV4_NODE[608], &gn_BGP_IPV4_NODE[609], &gn_BGP_IPV4_NODE[610], &gn_BGP_IPV4_NODE[611], &gn_BGP_IPV4_NODE[612], &gn_BGP_IPV4_NODE[613], &gn_BGP_IPV4_NODE[614], &gn_BGP_IPV4_NODE[615], &gn_BGP_IPV4_NODE[616], &gn_BGP_IPV4_NODE[617], &gn_BGP_IPV4_NODE[618], &gn_BGP_IPV4_NODE[619], &gn_BGP_IPV4_NODE[620], &gn_BGP_IPV4_NODE[621], &gn_BGP_IPV4_NODE[622], &gn_BGP_IPV4_NODE[623], &gn_BGP_IPV4_NODE[624], &gn_BGP_IPV4_NODE[625], &gn_BGP_IPV4_NODE[626], &gn_BGP_IPV4_NODE[627], &gn_BGP_IPV4_NODE[628], &gn_BGP_IPV4_NODE[629], &gn_BGP_IPV4_NODE[630], &gn_BGP_IPV4_NODE[631], &gn_BGP_IPV4_NODE[632], &gn_BGP_IPV4_NODE[633], &gn_BGP_IPV4_NODE[634], &gn_BGP_IPV4_NODE[635], &gn_BGP_IPV4_NODE[636], &gn_BGP_IPV4_NODE[637], &gn_BGP_IPV4_NODE[638], &gn_BGP_IPV4_NODE[639], &gn_BGP_IPV4_NODE[640], &gn_BGP_IPV4_NODE[641], &gn_BGP_IPV4_NODE[642], &gn_BGP_IPV4_NODE[643], &gn_BGP_IPV4_NODE[644], &gn_BGP_IPV4_NODE[645], &gn_BGP_IPV4_NODE[646], &gn_BGP_IPV4_NODE[647], &gn_BGP_IPV4_NODE[648], &gn_BGP_IPV4_NODE[649], &gn_BGP_IPV4_NODE[650], &gn_BGP_IPV4_NODE[651], &gn_BGP_IPV4_NODE[652], &gn_BGP_IPV4_NODE[653], &gn_BGP_IPV4_NODE[654], &gn_BGP_IPV4_NODE[655], &gn_BGP_IPV4_NODE[656], &gn_BGP_IPV4_NODE[657], &gn_BGP_IPV4_NODE[658], &gn_BGP_IPV4_NODE[659], &gn_BGP_IPV4_NODE[660], &gn_BGP_IPV4_NODE[661], &gn_BGP_IPV4_NODE[662], &gn_BGP_IPV4_NODE[663], &gn_BGP_IPV4_NODE[664], &gn_BGP_IPV4_NODE[665], &gn_BGP_IPV4_NODE[666], &gn_BGP_IPV4_NODE[667], &gn_BGP_IPV4_NODE[668], &gn_BGP_IPV4_NODE[669], &gn_BGP_IPV4_NODE[670], &gn_BGP_IPV4_NODE[671], &gn_BGP_IPV4_NODE[672], &gn_BGP_IPV4_NODE[673], &gn_BGP_IPV4_NODE[674], &gn_BGP_IPV4_NODE[675], &gn_BGP_IPV4_NODE[676], &gn_BGP_IPV4_NODE[677], &gn_BGP_IPV4_NODE[678], &gn_BGP_IPV4_NODE[679], &gn_BGP_IPV4_NODE[680], &gn_BGP_IPV4_NODE[681], &gn_BGP_IPV4_NODE[682], &gn_BGP_IPV4_NODE[683], &gn_BGP_IPV4_NODE[684], &gn_BGP_IPV4_NODE[685], &gn_BGP_IPV4_NODE[686], &gn_BGP_IPV4_NODE[687], &gn_BGP_IPV4_NODE[688], &gn_BGP_IPV4_NODE[689], &gn_BGP_IPV4_NODE[690], &gn_BGP_IPV4_NODE[691], &gn_BGP_IPV4_NODE[692], &gn_BGP_IPV4_NODE[693], &gn_BGP_IPV4_NODE[694], &gn_BGP_IPV4_NODE[695], &gn_BGP_IPV4_NODE[696], &gn_BGP_IPV4_NODE[697], &gn_BGP_IPV4_NODE[698], &gn_BGP_IPV4_NODE[699], &gn_BGP_IPV4_NODE[700], &gn_BGP_IPV4_NODE[701], &gn_BGP_IPV4_NODE[702], &gn_BGP_IPV4_NODE[703], &gn_BGP_IPV4_NODE[704], &gn_BGP_IPV4_NODE[705], &gn_BGP_IPV4_NODE[706], &gn_BGP_IPV4_NODE[707], &gn_BGP_IPV4_NODE[708], &gn_BGP_IPV4_NODE[709], &gn_BGP_IPV4_NODE[710], &gn_BGP_IPV4_NODE[711], &gn_BGP_IPV4_NODE[712], &gn_BGP_IPV4_NODE[713], &gn_BGP_IPV4_NODE[714], &gn_BGP_IPV4_NODE[715], &gn_BGP_IPV4_NODE[716], &gn_BGP_IPV4_NODE[717], &gn_BGP_IPV4_NODE[718], &gn_BGP_IPV4_NODE[719], &gn_BGP_IPV4_NODE[720], &gn_BGP_IPV4_NODE[721], &gn_BGP_IPV4_NODE[722], &gn_BGP_IPV4_NODE[723], &gn_BGP_IPV4_NODE[724], &gn_BGP_IPV4_NODE[725], &gn_BGP_IPV4_NODE[726], &gn_BGP_IPV4_NODE[727], &gn_BGP_IPV4_NODE[728], &gn_BGP_IPV4_NODE[729], &gn_BGP_IPV4_NODE[730], &gn_BGP_IPV4_NODE[731], &gn_BGP_IPV4_NODE[732], &gn_BGP_IPV4_NODE[733], &gn_BGP_IPV4_NODE[734], &gn_BGP_IPV4_NODE[735], &gn_BGP_IPV4_NODE[736], &gn_BGP_IPV4_NODE[737], &gn_BGP_IPV4_NODE[738], &gn_BGP_IPV4_NODE[739], &gn_BGP_IPV4_NODE[740], &gn_BGP_IPV4_NODE[741], &gn_BGP_IPV4_NODE[742], &gn_BGP_IPV4_NODE[743], &gn_BGP_IPV4_NODE[744], &gn_BGP_IPV4_NODE[745], &gn_BGP_IPV4_NODE[746], &gn_BGP_IPV4_NODE[747], &gn_BGP_IPV4_NODE[748], &gn_BGP_IPV4_NODE[749], &gn_BGP_IPV4_NODE[750], &gn_BGP_IPV4_NODE[751], &gn_BGP_IPV4_NODE[752], &gn_BGP_IPV4_NODE[753], &gn_BGP_IPV4_NODE[754], &gn_BGP_IPV4_NODE[755], &gn_BGP_IPV4_NODE[756], &gn_BGP_IPV4_NODE[757], &gn_BGP_IPV4_NODE[758], &gn_BGP_IPV4_NODE[759], &gn_BGP_IPV4_NODE[760], &gn_BGP_IPV4_NODE[761], &gn_BGP_IPV4_NODE[762], &gn_BGP_IPV4_NODE[763], &gn_BGP_IPV4_NODE[764], &gn_BGP_IPV4_NODE[765], &gn_BGP_IPV4_NODE[766], &gn_BGP_IPV4_NODE[767], &gn_BGP_IPV4_NODE[768], &gn_BGP_IPV4_NODE[769], &gn_BGP_IPV4_NODE[770], &gn_BGP_IPV4_NODE[771], &gn_BGP_IPV4_NODE[772], &gn_BGP_IPV4_NODE[773], &gn_BGP_IPV4_NODE[774], &gn_BGP_IPV4_NODE[775], &gn_BGP_IPV4_NODE[776], &gn_BGP_IPV4_NODE[777], &gn_BGP_IPV4_NODE[778], &gn_BGP_IPV4_NODE[779], &gn_BGP_IPV4_NODE[780], &gn_BGP_IPV4_NODE[781], &gn_BGP_IPV4_NODE[782], &gn_BGP_IPV4_NODE[783], &gn_BGP_IPV4_NODE[784], &gn_BGP_IPV4_NODE[785], &gn_BGP_IPV4_NODE[786], &gn_BGP_IPV4_NODE[787], &gn_BGP_IPV4_NODE[788], &gn_BGP_IPV4_NODE[789], &gn_BGP_IPV4_NODE[790], &gn_BGP_IPV4_NODE[791], &gn_BGP_IPV4_NODE[792], &gn_BGP_IPV4_NODE[793], &gn_BGP_IPV4_NODE[794], &gn_BGP_IPV4_NODE[795], &gn_BGP_IPV4_NODE[796], &gn_BGP_IPV4_NODE[797], &gn_BGP_IPV4_NODE[798], &gn_BGP_IPV4_NODE[799], &gn_BGP_IPV4_NODE[800]);

extern void install_BGP_IPV4_NODE(void);

void install_BGP_IPV4_NODE(void)

{
	unsigned node_id = BGP_IPV4_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BGP_IPV4_NODE;
	vector_set(node->cmd_vector, &af_import_vrf_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &af_label_vpn_export_allocation_mode_cmd_vtysh);
	vector_set(node->cmd_vector, &af_label_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &af_nexthop_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &af_no_import_vrf_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &af_no_label_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &af_no_rd_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &af_no_route_map_vpn_imexport_cmd_vtysh);
	vector_set(node->cmd_vector, &af_no_rt_vpn_imexport_cmd_vtysh);
	vector_set(node->cmd_vector, &af_rd_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &af_route_map_vpn_imexport_cmd_vtysh);
	vector_set(node->cmd_vector, &af_routetarget_import_cmd_vtysh);
	vector_set(node->cmd_vector, &af_rt_vpn_imexport_cmd_vtysh);
	vector_set(node->cmd_vector, &af_sid_vpn_export_cmd_vtysh);
	vector_set(node->cmd_vector, &aggregate_addressv4_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_damp_set_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_damp_unset_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_source_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_source_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_imexport_vpn_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_imexport_vrf_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_maxpaths_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_maxpaths_ibgp_cluster_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_maxpaths_ibgp_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_network_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_metric_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_ospf_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_ospf_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_ospf_metric_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_ospf_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_ospf_rmap_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_redistribute_ipv4_rmap_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_table_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_activate_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_paths_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_all_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_best_selected_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_bestpath_per_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_advertise_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_allowas_in_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_as_override_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_attr_unchanged_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_capability_orf_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_damp_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_default_originate_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_default_originate_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_disable_addpath_rx_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_ecommunity_rpki_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_filter_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_out_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_restart_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_restart_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_warning_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_warning_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_all_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_force_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_all_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_all_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_reflector_client_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_server_client_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_send_community_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_send_community_type_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_set_peer_group_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_soft_reconfiguration_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_unsuppress_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_weight_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_source_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_source_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_maxpaths_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_maxpaths_ibgp_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_redistribute_ipv4_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_redistribute_ipv4_ospf_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_table_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_activate_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_paths_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_all_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_allowas_in_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_as_override_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_attr_unchanged_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_capability_orf_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_damp_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_default_originate_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_disable_addpath_rx_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_filter_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_maximum_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_maximum_prefix_out_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_all_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_force_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_all_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_all_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_reflector_client_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_server_client_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_send_community_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_send_community_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_set_peer_group_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_soft_reconfiguration_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_unsuppress_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_weight_cmd_vtysh);
}

static struct cmd_token ctkn_BGP_EVPN_VNI_NODE[];
static struct graph_node gn_BGP_EVPN_VNI_NODE[];

static struct cmd_token ctkn_BGP_EVPN_VNI_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"advertise-svi-ip",
		.desc = (char *)"Advertise svi mac-ip routes in EVPN for a VNI",
	},
	{ /* [5] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [6] = bgp_evpn_advertise_svi_ip_vni_cmd */ },
	{ /* [7] */
		.type = WORD_TKN,
		.text = (char *)"flooding",
		.desc = (char *)"Specify handling for BUM packets",
	},
	{ /* [8] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[10],
	},
	{ /* [9] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"disable",
		.desc = (char *)"Do not flood any BUM packets",
		.varname = (char *)"disable",
	},
	{ /* [10] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[8],
	},
	{ /* [11] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [12] = bgp_evpn_flood_control_vni_cmd */ },
	{ /* [13] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"head-end-replication",
		.desc = (char *)"Flood BUM packets using head-end replication",
		.varname = (char *)"her",
	},
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"advertise-default-gw",
		.desc = (char *)"Advertise default g/w mac-ip routes in EVPN for a VNI",
	},
	{ /* [15] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [16] = bgp_evpn_advertise_default_gw_vni_cmd */ },
	{ /* [17] */
		.type = WORD_TKN,
		.text = (char *)"advertise-subnet",
		.desc = (char *)"Advertise the subnet corresponding to VNI",
	},
	{ /* [18] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [19] = bgp_evpn_advertise_vni_subnet_cmd */ },
	{ /* [20] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [21] */
		.type = WORD_TKN,
		.text = (char *)"advertise-default-gw",
		.desc = (char *)"Withdraw default g/w mac-ip routes from EVPN for a VNI",
	},
	{ /* [22] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [23] = no_bgp_evpn_advertise_default_gw_vni_cmd */ },
	{ /* [24] */
		.type = WORD_TKN,
		.text = (char *)"advertise-subnet",
		.desc = (char *)"Advertise All local VNIs",
	},
	{ /* [25] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [26] = no_bgp_evpn_advertise_vni_subnet_cmd */ },
	{ /* [27] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Route Distinguisher",
	},
	{ /* [28] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [29] = no_bgp_evpn_vni_rd_without_val_cmd */ },
	{ /* [30] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"ASN:XX or A.B.C.D:XX",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [31] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [32] = no_bgp_evpn_vni_rd_cmd */ },
	{ /* [33] */
		.type = WORD_TKN,
		.text = (char *)"route-target",
		.desc = (char *)"Route Target",
	},
	{ /* [34] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[36],
	},
	{ /* [35] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"import and export",
	},
	{ /* [36] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[34],
	},
	{ /* [37] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RT",
		.desc = (char *)"ASN:XX or A.B.C.D:XX",
		.varname = (char *)"rt",
	},
	{ /* [38] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [39] = no_bgp_evpn_vni_rt_cmd */ },
	{ /* [40] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"import",
	},
	{ /* [41] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"export",
	},
	{ /* [42] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[44],
	},
	{ /* [43] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"import",
	},
	{ /* [44] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[42],
	},
	{ /* [45] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [46] = no_bgp_evpn_vni_rt_without_val_cmd */ },
	{ /* [47] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"export",
	},
	{ /* [48] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Route Distinguisher",
	},
	{ /* [49] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"ASN:XX or A.B.C.D:XX",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [50] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [51] = bgp_evpn_vni_rd_cmd */ },
	{ /* [52] */
		.type = WORD_TKN,
		.text = (char *)"route-target",
		.desc = (char *)"Route Target",
	},
	{ /* [53] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[55],
	},
	{ /* [54] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"import and export",
	},
	{ /* [55] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_EVPN_VNI_NODE[53],
	},
	{ /* [56] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RT",
		.desc = (char *)"Route target (A.B.C.D:MN|EF:OPQR|GHJK:MN)",
		.varname = (char *)"rt",
	},
	{ /* [57] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [58] = bgp_evpn_vni_rt_cmd */ },
	{ /* [59] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"import",
	},
	{ /* [60] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"export",
	},
};

extern struct cmd_element bgp_evpn_advertise_default_gw_vni_cmd_vtysh;
extern struct cmd_element bgp_evpn_advertise_svi_ip_vni_cmd_vtysh;
extern struct cmd_element bgp_evpn_advertise_vni_subnet_cmd_vtysh;
extern struct cmd_element bgp_evpn_flood_control_vni_cmd_vtysh;
extern struct cmd_element bgp_evpn_vni_rd_cmd_vtysh;
extern struct cmd_element bgp_evpn_vni_rt_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_advertise_default_gw_vni_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_advertise_vni_subnet_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_vni_rd_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_vni_rd_without_val_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_vni_rt_cmd_vtysh;
extern struct cmd_element no_bgp_evpn_vni_rt_without_val_cmd_vtysh;

MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_0_next, 6, &gn_BGP_EVPN_VNI_NODE[1], &gn_BGP_EVPN_VNI_NODE[14], &gn_BGP_EVPN_VNI_NODE[17], &gn_BGP_EVPN_VNI_NODE[20], &gn_BGP_EVPN_VNI_NODE[48], &gn_BGP_EVPN_VNI_NODE[52]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_1_next, 2, &gn_BGP_EVPN_VNI_NODE[2], &gn_BGP_EVPN_VNI_NODE[3]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_1_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_2_next, 1, &gn_BGP_EVPN_VNI_NODE[3]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_2_prev, 1, &gn_BGP_EVPN_VNI_NODE[1]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_3_next, 2, &gn_BGP_EVPN_VNI_NODE[4], &gn_BGP_EVPN_VNI_NODE[7]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_3_prev, 2, &gn_BGP_EVPN_VNI_NODE[2], &gn_BGP_EVPN_VNI_NODE[1]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_4_next, 1, &gn_BGP_EVPN_VNI_NODE[5]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_4_prev, 1, &gn_BGP_EVPN_VNI_NODE[3]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_5_next, 1, &gn_BGP_EVPN_VNI_NODE[6]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_5_prev, 1, &gn_BGP_EVPN_VNI_NODE[4]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_6_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_6_prev, 1, &gn_BGP_EVPN_VNI_NODE[5]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_7_next, 1, &gn_BGP_EVPN_VNI_NODE[8]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_7_prev, 1, &gn_BGP_EVPN_VNI_NODE[3]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_8_next, 2, &gn_BGP_EVPN_VNI_NODE[9], &gn_BGP_EVPN_VNI_NODE[13]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_8_prev, 1, &gn_BGP_EVPN_VNI_NODE[7]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_9_next, 1, &gn_BGP_EVPN_VNI_NODE[10]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_9_prev, 1, &gn_BGP_EVPN_VNI_NODE[8]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_10_next, 1, &gn_BGP_EVPN_VNI_NODE[11]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_10_prev, 2, &gn_BGP_EVPN_VNI_NODE[9], &gn_BGP_EVPN_VNI_NODE[13]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_11_next, 1, &gn_BGP_EVPN_VNI_NODE[12]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_11_prev, 1, &gn_BGP_EVPN_VNI_NODE[10]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_12_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_12_prev, 1, &gn_BGP_EVPN_VNI_NODE[11]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_13_next, 1, &gn_BGP_EVPN_VNI_NODE[10]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_13_prev, 1, &gn_BGP_EVPN_VNI_NODE[8]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_14_next, 1, &gn_BGP_EVPN_VNI_NODE[15]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_14_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_15_next, 1, &gn_BGP_EVPN_VNI_NODE[16]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_15_prev, 1, &gn_BGP_EVPN_VNI_NODE[14]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_16_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_16_prev, 1, &gn_BGP_EVPN_VNI_NODE[15]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_17_next, 1, &gn_BGP_EVPN_VNI_NODE[18]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_17_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_18_next, 1, &gn_BGP_EVPN_VNI_NODE[19]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_18_prev, 1, &gn_BGP_EVPN_VNI_NODE[17]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_19_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_19_prev, 1, &gn_BGP_EVPN_VNI_NODE[18]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_20_next, 4, &gn_BGP_EVPN_VNI_NODE[21], &gn_BGP_EVPN_VNI_NODE[24], &gn_BGP_EVPN_VNI_NODE[27], &gn_BGP_EVPN_VNI_NODE[33]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_20_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_21_next, 1, &gn_BGP_EVPN_VNI_NODE[22]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_21_prev, 1, &gn_BGP_EVPN_VNI_NODE[20]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_22_next, 1, &gn_BGP_EVPN_VNI_NODE[23]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_22_prev, 1, &gn_BGP_EVPN_VNI_NODE[21]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_23_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_23_prev, 1, &gn_BGP_EVPN_VNI_NODE[22]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_24_next, 1, &gn_BGP_EVPN_VNI_NODE[25]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_24_prev, 1, &gn_BGP_EVPN_VNI_NODE[20]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_25_next, 1, &gn_BGP_EVPN_VNI_NODE[26]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_25_prev, 1, &gn_BGP_EVPN_VNI_NODE[24]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_26_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_26_prev, 1, &gn_BGP_EVPN_VNI_NODE[25]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_27_next, 2, &gn_BGP_EVPN_VNI_NODE[28], &gn_BGP_EVPN_VNI_NODE[30]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_27_prev, 1, &gn_BGP_EVPN_VNI_NODE[20]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_28_next, 1, &gn_BGP_EVPN_VNI_NODE[29]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_28_prev, 1, &gn_BGP_EVPN_VNI_NODE[27]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_29_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_29_prev, 1, &gn_BGP_EVPN_VNI_NODE[28]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_30_next, 1, &gn_BGP_EVPN_VNI_NODE[31]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_30_prev, 1, &gn_BGP_EVPN_VNI_NODE[27]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_31_next, 1, &gn_BGP_EVPN_VNI_NODE[32]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_31_prev, 1, &gn_BGP_EVPN_VNI_NODE[30]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_32_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_32_prev, 1, &gn_BGP_EVPN_VNI_NODE[31]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_33_next, 2, &gn_BGP_EVPN_VNI_NODE[34], &gn_BGP_EVPN_VNI_NODE[42]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_33_prev, 1, &gn_BGP_EVPN_VNI_NODE[20]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_34_next, 3, &gn_BGP_EVPN_VNI_NODE[35], &gn_BGP_EVPN_VNI_NODE[40], &gn_BGP_EVPN_VNI_NODE[41]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_34_prev, 1, &gn_BGP_EVPN_VNI_NODE[33]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_35_next, 1, &gn_BGP_EVPN_VNI_NODE[36]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_35_prev, 1, &gn_BGP_EVPN_VNI_NODE[34]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_36_next, 1, &gn_BGP_EVPN_VNI_NODE[37]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_36_prev, 3, &gn_BGP_EVPN_VNI_NODE[35], &gn_BGP_EVPN_VNI_NODE[40], &gn_BGP_EVPN_VNI_NODE[41]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_37_next, 1, &gn_BGP_EVPN_VNI_NODE[38]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_37_prev, 1, &gn_BGP_EVPN_VNI_NODE[36]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_38_next, 1, &gn_BGP_EVPN_VNI_NODE[39]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_38_prev, 1, &gn_BGP_EVPN_VNI_NODE[37]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_39_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_39_prev, 1, &gn_BGP_EVPN_VNI_NODE[38]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_40_next, 1, &gn_BGP_EVPN_VNI_NODE[36]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_40_prev, 1, &gn_BGP_EVPN_VNI_NODE[34]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_41_next, 1, &gn_BGP_EVPN_VNI_NODE[36]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_41_prev, 1, &gn_BGP_EVPN_VNI_NODE[34]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_42_next, 2, &gn_BGP_EVPN_VNI_NODE[43], &gn_BGP_EVPN_VNI_NODE[47]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_42_prev, 1, &gn_BGP_EVPN_VNI_NODE[33]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_43_next, 1, &gn_BGP_EVPN_VNI_NODE[44]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_43_prev, 1, &gn_BGP_EVPN_VNI_NODE[42]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_44_next, 1, &gn_BGP_EVPN_VNI_NODE[45]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_44_prev, 2, &gn_BGP_EVPN_VNI_NODE[43], &gn_BGP_EVPN_VNI_NODE[47]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_45_next, 1, &gn_BGP_EVPN_VNI_NODE[46]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_45_prev, 1, &gn_BGP_EVPN_VNI_NODE[44]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_46_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_46_prev, 1, &gn_BGP_EVPN_VNI_NODE[45]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_47_next, 1, &gn_BGP_EVPN_VNI_NODE[44]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_47_prev, 1, &gn_BGP_EVPN_VNI_NODE[42]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_48_next, 1, &gn_BGP_EVPN_VNI_NODE[49]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_48_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_49_next, 1, &gn_BGP_EVPN_VNI_NODE[50]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_49_prev, 1, &gn_BGP_EVPN_VNI_NODE[48]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_50_next, 1, &gn_BGP_EVPN_VNI_NODE[51]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_50_prev, 1, &gn_BGP_EVPN_VNI_NODE[49]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_51_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_51_prev, 1, &gn_BGP_EVPN_VNI_NODE[50]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_52_next, 1, &gn_BGP_EVPN_VNI_NODE[53]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_52_prev, 1, &gn_BGP_EVPN_VNI_NODE[0]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_53_next, 3, &gn_BGP_EVPN_VNI_NODE[54], &gn_BGP_EVPN_VNI_NODE[59], &gn_BGP_EVPN_VNI_NODE[60]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_53_prev, 1, &gn_BGP_EVPN_VNI_NODE[52]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_54_next, 1, &gn_BGP_EVPN_VNI_NODE[55]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_54_prev, 1, &gn_BGP_EVPN_VNI_NODE[53]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_55_next, 1, &gn_BGP_EVPN_VNI_NODE[56]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_55_prev, 3, &gn_BGP_EVPN_VNI_NODE[54], &gn_BGP_EVPN_VNI_NODE[59], &gn_BGP_EVPN_VNI_NODE[60]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_56_next, 1, &gn_BGP_EVPN_VNI_NODE[57]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_56_prev, 1, &gn_BGP_EVPN_VNI_NODE[55]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_57_next, 1, &gn_BGP_EVPN_VNI_NODE[58]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_57_prev, 1, &gn_BGP_EVPN_VNI_NODE[56]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_58_next, 0, );
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_58_prev, 1, &gn_BGP_EVPN_VNI_NODE[57]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_59_next, 1, &gn_BGP_EVPN_VNI_NODE[55]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_59_prev, 1, &gn_BGP_EVPN_VNI_NODE[53]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_60_next, 1, &gn_BGP_EVPN_VNI_NODE[55]);
MAKE_VECTOR(gn_BGP_EVPN_VNI_NODE_60_prev, 1, &gn_BGP_EVPN_VNI_NODE[53]);

static struct graph_node gn_BGP_EVPN_VNI_NODE[] = {
	{
		.from = &gn_BGP_EVPN_VNI_NODE_0_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_0_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[0],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_1_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_1_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[1],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_2_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_2_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[2],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_3_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_3_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[3],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_4_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_4_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[4],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_5_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_5_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[5],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_6_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_6_next,
		.data = (void *)&bgp_evpn_advertise_svi_ip_vni_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_7_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_7_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[7],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_8_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_8_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[8],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_9_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_9_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[9],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_10_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_10_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[10],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_11_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_11_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[11],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_12_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_12_next,
		.data = (void *)&bgp_evpn_flood_control_vni_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_13_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_13_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[13],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_14_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_14_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[14],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_15_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_15_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[15],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_16_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_16_next,
		.data = (void *)&bgp_evpn_advertise_default_gw_vni_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_17_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_17_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[17],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_18_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_18_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[18],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_19_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_19_next,
		.data = (void *)&bgp_evpn_advertise_vni_subnet_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_20_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_20_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[20],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_21_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_21_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[21],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_22_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_22_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[22],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_23_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_23_next,
		.data = (void *)&no_bgp_evpn_advertise_default_gw_vni_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_24_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_24_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[24],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_25_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_25_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[25],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_26_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_26_next,
		.data = (void *)&no_bgp_evpn_advertise_vni_subnet_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_27_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_27_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[27],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_28_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_28_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[28],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_29_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_29_next,
		.data = (void *)&no_bgp_evpn_vni_rd_without_val_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_30_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_30_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[30],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_31_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_31_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[31],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_32_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_32_next,
		.data = (void *)&no_bgp_evpn_vni_rd_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_33_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_33_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[33],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_34_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_34_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[34],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_35_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_35_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[35],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_36_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_36_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[36],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_37_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_37_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[37],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_38_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_38_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[38],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_39_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_39_next,
		.data = (void *)&no_bgp_evpn_vni_rt_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_40_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_40_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[40],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_41_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_41_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[41],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_42_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_42_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[42],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_43_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_43_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[43],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_44_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_44_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[44],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_45_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_45_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[45],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_46_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_46_next,
		.data = (void *)&no_bgp_evpn_vni_rt_without_val_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_47_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_47_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[47],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_48_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_48_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[48],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_49_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_49_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[49],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_50_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_50_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[50],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_51_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_51_next,
		.data = (void *)&bgp_evpn_vni_rd_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_52_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_52_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[52],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_53_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_53_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[53],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_54_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_54_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[54],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_55_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_55_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[55],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_56_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_56_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[56],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_57_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_57_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[57],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_58_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_58_next,
		.data = (void *)&bgp_evpn_vni_rt_cmd_vtysh,
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_59_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_59_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[59],
	},
	{
		.from = &gn_BGP_EVPN_VNI_NODE_60_prev,
		.to = &gn_BGP_EVPN_VNI_NODE_60_next,
		.data = &ctkn_BGP_EVPN_VNI_NODE[60],
	},
};
MAKE_VECTOR(gvec_BGP_EVPN_VNI_NODE, 61, &gn_BGP_EVPN_VNI_NODE[0], &gn_BGP_EVPN_VNI_NODE[1], &gn_BGP_EVPN_VNI_NODE[2], &gn_BGP_EVPN_VNI_NODE[3], &gn_BGP_EVPN_VNI_NODE[4], &gn_BGP_EVPN_VNI_NODE[5], &gn_BGP_EVPN_VNI_NODE[6], &gn_BGP_EVPN_VNI_NODE[7], &gn_BGP_EVPN_VNI_NODE[8], &gn_BGP_EVPN_VNI_NODE[9], &gn_BGP_EVPN_VNI_NODE[10], &gn_BGP_EVPN_VNI_NODE[11], &gn_BGP_EVPN_VNI_NODE[12], &gn_BGP_EVPN_VNI_NODE[13], &gn_BGP_EVPN_VNI_NODE[14], &gn_BGP_EVPN_VNI_NODE[15], &gn_BGP_EVPN_VNI_NODE[16], &gn_BGP_EVPN_VNI_NODE[17], &gn_BGP_EVPN_VNI_NODE[18], &gn_BGP_EVPN_VNI_NODE[19], &gn_BGP_EVPN_VNI_NODE[20], &gn_BGP_EVPN_VNI_NODE[21], &gn_BGP_EVPN_VNI_NODE[22], &gn_BGP_EVPN_VNI_NODE[23], &gn_BGP_EVPN_VNI_NODE[24], &gn_BGP_EVPN_VNI_NODE[25], &gn_BGP_EVPN_VNI_NODE[26], &gn_BGP_EVPN_VNI_NODE[27], &gn_BGP_EVPN_VNI_NODE[28], &gn_BGP_EVPN_VNI_NODE[29], &gn_BGP_EVPN_VNI_NODE[30], &gn_BGP_EVPN_VNI_NODE[31], &gn_BGP_EVPN_VNI_NODE[32], &gn_BGP_EVPN_VNI_NODE[33], &gn_BGP_EVPN_VNI_NODE[34], &gn_BGP_EVPN_VNI_NODE[35], &gn_BGP_EVPN_VNI_NODE[36], &gn_BGP_EVPN_VNI_NODE[37], &gn_BGP_EVPN_VNI_NODE[38], &gn_BGP_EVPN_VNI_NODE[39], &gn_BGP_EVPN_VNI_NODE[40], &gn_BGP_EVPN_VNI_NODE[41], &gn_BGP_EVPN_VNI_NODE[42], &gn_BGP_EVPN_VNI_NODE[43], &gn_BGP_EVPN_VNI_NODE[44], &gn_BGP_EVPN_VNI_NODE[45], &gn_BGP_EVPN_VNI_NODE[46], &gn_BGP_EVPN_VNI_NODE[47], &gn_BGP_EVPN_VNI_NODE[48], &gn_BGP_EVPN_VNI_NODE[49], &gn_BGP_EVPN_VNI_NODE[50], &gn_BGP_EVPN_VNI_NODE[51], &gn_BGP_EVPN_VNI_NODE[52], &gn_BGP_EVPN_VNI_NODE[53], &gn_BGP_EVPN_VNI_NODE[54], &gn_BGP_EVPN_VNI_NODE[55], &gn_BGP_EVPN_VNI_NODE[56], &gn_BGP_EVPN_VNI_NODE[57], &gn_BGP_EVPN_VNI_NODE[58], &gn_BGP_EVPN_VNI_NODE[59], &gn_BGP_EVPN_VNI_NODE[60]);

extern void install_BGP_EVPN_VNI_NODE(void);

void install_BGP_EVPN_VNI_NODE(void)

{
	unsigned node_id = BGP_EVPN_VNI_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BGP_EVPN_VNI_NODE;
	vector_set(node->cmd_vector, &bgp_evpn_advertise_default_gw_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_evpn_advertise_svi_ip_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_evpn_advertise_vni_subnet_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_evpn_flood_control_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_evpn_vni_rd_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_evpn_vni_rt_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_advertise_default_gw_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_advertise_vni_subnet_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_vni_rd_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_vni_rd_without_val_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_vni_rt_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_evpn_vni_rt_without_val_cmd_vtysh);
}

static struct cmd_token ctkn_RMAP_NODE[];
static struct graph_node gn_RMAP_NODE[];

static struct cmd_token ctkn_RMAP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"match",
		.desc = (char *)"Match values from routing table",
	},
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"community-limit",
		.desc = (char *)"Match BGP community limit",
	},
	{ /* [6] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[8],
	},
	{ /* [7] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-65535)",
		.desc = (char *)"Community limit number",
		.max = 65535,
		.varname = (char *)"limit",
	},
	{ /* [8] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[6],
	},
	{ /* [9] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [10] = match_community_limit_cmd */ },
	{ /* [11] */
		.type = NEG_ONLY_TKN,
	},
	{ /* [12] */
		.type = WORD_TKN,
		.text = (char *)"extcommunity-limit",
		.desc = (char *)"Match BGP extended community limit",
	},
	{ /* [13] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[15],
	},
	{ /* [14] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-65535)",
		.desc = (char *)"Extended community limit number",
		.max = 65535,
		.varname = (char *)"limit",
	},
	{ /* [15] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[13],
	},
	{ /* [16] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [17] = match_extcommunity_limit_cmd */ },
	{ /* [18] */
		.type = NEG_ONLY_TKN,
	},
	{ /* [19] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [20] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[23],
	},
	{ /* [21] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [22] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"addr",
	},
	{ /* [23] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[20],
	},
	{ /* [24] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [25] = route_map_match_address_cmd */ },
	{ /* [26] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [27] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"addr",
	},
	{ /* [28] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[30],
	},
	{ /* [29] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [30] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[28],
	},
	{ /* [31] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match against IPv4 prefix list",
	},
	{ /* [32] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"Prefix list name",
		.varname = (char *)"prefix_list",
	},
	{ /* [33] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [34] = route_map_match_prefix_list_cmd */ },
	{ /* [35] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [36] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [37] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[40],
	},
	{ /* [38] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [39] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"addr",
	},
	{ /* [40] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[37],
	},
	{ /* [41] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [42] = route_map_match_address_v6_cmd */ },
	{ /* [43] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [44] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"addr",
	},
	{ /* [45] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[47],
	},
	{ /* [46] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [47] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[45],
	},
	{ /* [48] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match against IPv6 prefix list",
	},
	{ /* [49] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST6_NAME",
		.desc = (char *)"Prefix list name",
		.varname = (char *)"prefix_list",
	},
	{ /* [50] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [51] = route_map_match_prefix_list_v6_cmd */ },
	{ /* [52] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [53] */
		.type = WORD_TKN,
		.text = (char *)"multicast-interface",
		.desc = (char *)"Multicast data interface",
	},
	{ /* [54] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [55] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [56] = route_map_match_interface_cmd */ },
	{ /* [57] */
		.type = WORD_TKN,
		.text = (char *)"rpki-extcommunity",
		.desc = (char *)"BGP RPKI (Origin Validation State) extended community attribute",
	},
	{ /* [58] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[60],
	},
	{ /* [59] */
		.type = WORD_TKN,
		.text = (char *)"valid",
		.desc = (char *)"Valid prefix",
	},
	{ /* [60] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[58],
	},
	{ /* [61] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [62] = match_rpki_extcommunity_cmd */ },
	{ /* [63] */
		.type = WORD_TKN,
		.text = (char *)"invalid",
		.desc = (char *)"Invalid prefix",
	},
	{ /* [64] */
		.type = WORD_TKN,
		.text = (char *)"notfound",
		.desc = (char *)"Prefix not found",
	},
	{ /* [65] */
		.type = WORD_TKN,
		.text = (char *)"script",
		.desc = (char *)"Execute script to determine match",
	},
	{ /* [66] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"The script name to run, without .lua; e.g. 'myroutemap' to run myroutemap.lua",
		.varname = (char *)"script",
	},
	{ /* [67] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [68] = match_script_cmd */ },
	{ /* [69] */
		.type = WORD_TKN,
		.text = (char *)"set",
		.desc = (char *)"Set values in destination routing protocol",
	},
	{ /* [70] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"Transform BGP AS-path attribute",
	},
	{ /* [71] */
		.type = WORD_TKN,
		.text = (char *)"exclude",
		.desc = (char *)"Exclude from the as-path",
	},
	{ /* [72] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"all",
		.desc = (char *)"Exclude all AS numbers from the as-path",
		.varname = (char *)"all",
	},
	{ /* [73] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [74] = set_aspath_exclude_all_cmd */ },
	{ /* [75] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [76] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Next hop address",
	},
	{ /* [77] */
		.type = WORD_TKN,
		.text = (char *)"peer-address",
		.desc = (char *)"Use peer address (for BGP only)",
	},
	{ /* [78] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [79] = set_ip_nexthop_peer_cmd */ },
	{ /* [80] */
		.type = WORD_TKN,
		.text = (char *)"unchanged",
		.desc = (char *)"Don't modify existing Next hop address",
	},
	{ /* [81] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [82] = set_ip_nexthop_unchanged_cmd */ },
	{ /* [83] */
		.type = WORD_TKN,
		.text = (char *)"l3vpn",
		.desc = (char *)"L3VPN operations",
	},
	{ /* [84] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Next hop Information",
	},
	{ /* [85] */
		.type = WORD_TKN,
		.text = (char *)"encapsulation",
		.desc = (char *)"Encapsulation options (for BGP only)",
	},
	{ /* [86] */
		.type = WORD_TKN,
		.text = (char *)"gre",
		.desc = (char *)"Accept L3VPN traffic over GRE encapsulation",
	},
	{ /* [87] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [88] = set_l3vpn_nexthop_encapsulation_cmd */ },
	{ /* [89] */
		.type = WORD_TKN,
		.text = (char *)"call",
		.desc = (char *)"Jump to another Route-Map after match+set",
	},
	{ /* [90] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Target route-map name",
		.varname = (char *)"name",
	},
	{ /* [91] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [92] = rmap_call_cmd */ },
	{ /* [93] */
		.type = WORD_TKN,
		.text = (char *)"continue",
		.desc = (char *)"Continue on a different entry within the route-map",
	},
	{ /* [94] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Route-map entry sequence number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"rm_num",
	},
	{ /* [95] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [96] = rmap_continue_cmd */ },
	{ /* [97] */
		.type = WORD_TKN,
		.text = (char *)"description",
		.desc = (char *)"Route-map comment",
	},
	{ /* [98] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"LINE",
		.desc = (char *)"Comment describing this route-map rule",
		.varname = (char *)"line",
	},
	{ /* [99] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [100] = rmap_description_cmd */ },
	{ /* [101] */
		.type = WORD_TKN,
		.text = (char *)"match",
		.desc = (char *)"Match values from routing table",
	},
	{ /* [102] */
		.type = WORD_TKN,
		.text = (char *)"alias",
		.desc = (char *)"Match BGP community alias name",
	},
	{ /* [103] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ALIAS_NAME",
		.desc = (char *)"BGP community alias name",
		.varname = (char *)"alias_name",
	},
	{ /* [104] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [105] = match_alias_cmd */ },
	{ /* [106] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"Match BGP AS path list",
	},
	{ /* [107] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [108] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [109] = match_aspath_cmd */ },
	{ /* [110] */
		.type = WORD_TKN,
		.text = (char *)"community",
		.desc = (char *)"Match BGP community list",
	},
	{ /* [111] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[113],
	},
	{ /* [112] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"community",
	},
	{ /* [113] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[111],
	},
	{ /* [114] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[118],
	},
	{ /* [115] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[117],
	},
	{ /* [116] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
		.varname = (char *)"exact",
	},
	{ /* [117] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[115],
	},
	{ /* [118] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[114],
	},
	{ /* [119] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [120] = match_community_cmd */ },
	{ /* [121] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
		.varname = (char *)"any",
	},
	{ /* [122] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"community",
	},
	{ /* [123] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"COMMUNITY_LIST_NAME",
		.desc = (char *)"Community-list name",
		.varname = (char *)"community_list_name",
	},
	{ /* [124] */
		.type = WORD_TKN,
		.text = (char *)"evpn",
		.desc = (char *)"Ethernet Virtual Private Network",
	},
	{ /* [125] */
		.type = WORD_TKN,
		.text = (char *)"default-route",
		.desc = (char *)"default EVPN type-5 route",
	},
	{ /* [126] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [127] = match_evpn_default_route_cmd */ },
	{ /* [128] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Route Distinguisher",
	},
	{ /* [129] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"ASN:XX or A.B.C.D:XX",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [130] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [131] = match_evpn_rd_cmd */ },
	{ /* [132] */
		.type = WORD_TKN,
		.text = (char *)"route-type",
		.desc = (char *)"Specify Route type",
	},
	{ /* [133] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[135],
	},
	{ /* [134] */
		.type = WORD_TKN,
		.text = (char *)"ead",
		.desc = (char *)"EAD (Type-1) route",
	},
	{ /* [135] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[133],
	},
	{ /* [136] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [137] = match_evpn_route_type_cmd */ },
	{ /* [138] */
		.type = WORD_TKN,
		.text = (char *)"1",
		.desc = (char *)"EAD (Type-1) route",
	},
	{ /* [139] */
		.type = WORD_TKN,
		.text = (char *)"macip",
		.desc = (char *)"MAC-IP (Type-2) route",
	},
	{ /* [140] */
		.type = WORD_TKN,
		.text = (char *)"2",
		.desc = (char *)"MAC-IP (Type-2) route",
	},
	{ /* [141] */
		.type = WORD_TKN,
		.text = (char *)"multicast",
		.desc = (char *)"Multicast (Type-3) route",
	},
	{ /* [142] */
		.type = WORD_TKN,
		.text = (char *)"3",
		.desc = (char *)"Multicast (Type-3) route",
	},
	{ /* [143] */
		.type = WORD_TKN,
		.text = (char *)"es",
		.desc = (char *)"Ethernet Segment (Type-4) route",
	},
	{ /* [144] */
		.type = WORD_TKN,
		.text = (char *)"4",
		.desc = (char *)"Ethernet Segment (Type-4) route",
	},
	{ /* [145] */
		.type = WORD_TKN,
		.text = (char *)"prefix",
		.desc = (char *)"Prefix (Type-5) route",
	},
	{ /* [146] */
		.type = WORD_TKN,
		.text = (char *)"5",
		.desc = (char *)"Prefix (Type-5) route",
	},
	{ /* [147] */
		.type = WORD_TKN,
		.text = (char *)"vni",
		.desc = (char *)"Match VNI",
	},
	{ /* [148] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-16777215)",
		.desc = (char *)"VNI ID",
		.min = 1,
		.max = 16777215,
		.varname = (char *)"vni",
	},
	{ /* [149] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [150] = match_evpn_vni_cmd */ },
	{ /* [151] */
		.type = WORD_TKN,
		.text = (char *)"extcommunity",
		.desc = (char *)"Match BGP/VPN extended community list",
	},
	{ /* [152] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[154],
	},
	{ /* [153] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Extended community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"extcommunity",
	},
	{ /* [154] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[152],
	},
	{ /* [155] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[159],
	},
	{ /* [156] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[158],
	},
	{ /* [157] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
		.varname = (char *)"exact",
	},
	{ /* [158] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[156],
	},
	{ /* [159] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[155],
	},
	{ /* [160] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [161] = match_ecommunity_cmd */ },
	{ /* [162] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
		.varname = (char *)"any",
	},
	{ /* [163] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Extended community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"extcommunity",
	},
	{ /* [164] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"EXTCOMMUNITY_LIST_NAME",
		.desc = (char *)"Extended community-list name",
		.varname = (char *)"extcommunity_list_name",
	},
	{ /* [165] */
		.type = WORD_TKN,
		.text = (char *)"interface",
		.desc = (char *)"Match first hop interface of route",
	},
	{ /* [166] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface information",
		.varname = (char *)"ifname",
	},
	{ /* [167] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [168] = match_interface_cmd */ },
	{ /* [169] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [170] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match address of route",
	},
	{ /* [171] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"name",
	},
	{ /* [172] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [173] = match_ip_address_cmd */ },
	{ /* [174] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefix length of IP address",
	},
	{ /* [175] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-32)",
		.desc = (char *)"Prefix length",
		.max = 32,
		.varname = (char *)"length",
	},
	{ /* [176] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [177] = match_ip_address_prefix_len_cmd */ },
	{ /* [178] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [179] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"name",
	},
	{ /* [180] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [181] = match_ip_address_prefix_list_cmd */ },
	{ /* [182] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Match next-hop address of route",
	},
	{ /* [183] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"name",
	},
	{ /* [184] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [185] = match_ip_next_hop_cmd */ },
	{ /* [186] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"IP address",
	},
	{ /* [187] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next-hop",
		.varname = (char *)"address",
	},
	{ /* [188] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [189] = match_ipv4_next_hop_cmd */ },
	{ /* [190] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefixlen of given nexthop",
	},
	{ /* [191] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-32)",
		.desc = (char *)"Prefix length",
		.max = 32,
		.varname = (char *)"length",
	},
	{ /* [192] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [193] = match_ip_nexthop_prefix_len_cmd */ },
	{ /* [194] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [195] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"name",
	},
	{ /* [196] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [197] = match_ip_next_hop_prefix_list_cmd */ },
	{ /* [198] */
		.type = WORD_TKN,
		.text = (char *)"type",
		.desc = (char *)"Match entries by type",
	},
	{ /* [199] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[201],
	},
	{ /* [200] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"blackhole",
		.desc = (char *)"Blackhole",
		.varname = (char *)"type",
	},
	{ /* [201] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[199],
	},
	{ /* [202] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [203] = match_ip_next_hop_type_cmd */ },
	{ /* [204] */
		.type = WORD_TKN,
		.text = (char *)"route-source",
		.desc = (char *)"Match advertising source address of route",
	},
	{ /* [205] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist4_name",
	},
	{ /* [206] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [207] = match_ip_route_source_cmd */ },
	{ /* [208] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [209] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"prefixlist_name",
	},
	{ /* [210] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [211] = match_ip_route_source_prefix_list_cmd */ },
	{ /* [212] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [213] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match IPv6 address of route",
	},
	{ /* [214] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST6_NAME",
		.desc = (char *)"IPv6 access-list name",
		.varname = (char *)"name",
	},
	{ /* [215] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [216] = match_ipv6_address_cmd */ },
	{ /* [217] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefix length of IPv6 address",
	},
	{ /* [218] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-128)",
		.desc = (char *)"Prefix length",
		.max = 128,
		.varname = (char *)"length",
	},
	{ /* [219] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [220] = match_ipv6_address_prefix_len_cmd */ },
	{ /* [221] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [222] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST6_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"name",
	},
	{ /* [223] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [224] = match_ipv6_address_prefix_list_cmd */ },
	{ /* [225] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Match IPv6 next-hop address of route",
	},
	{ /* [226] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST6_NAME",
		.desc = (char *)"IPv6 access-list name",
		.varname = (char *)"accesslist6_name",
	},
	{ /* [227] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [228] = match_ipv6_next_hop_cmd */ },
	{ /* [229] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"next_hop",
	},
	{ /* [230] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [231] = match_ipv6_next_hop_old_cmd */ },
	{ /* [232] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"IPv6 address",
	},
	{ /* [233] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"address",
	},
	{ /* [234] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [235] = match_ipv6_next_hop_address_cmd */ },
	{ /* [236] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries by prefix-list",
	},
	{ /* [237] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST_NAME",
		.desc = (char *)"IPv6 prefix-list name",
		.varname = (char *)"prefixlist_name",
	},
	{ /* [238] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [239] = match_ipv6_next_hop_prefix_list_cmd */ },
	{ /* [240] */
		.type = WORD_TKN,
		.text = (char *)"type",
		.desc = (char *)"Match entries by type",
	},
	{ /* [241] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[243],
	},
	{ /* [242] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"blackhole",
		.desc = (char *)"Blackhole",
		.varname = (char *)"type",
	},
	{ /* [243] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[241],
	},
	{ /* [244] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [245] = match_ipv6_next_hop_type_cmd */ },
	{ /* [246] */
		.type = WORD_TKN,
		.text = (char *)"large-community",
		.desc = (char *)"Match BGP large community list",
	},
	{ /* [247] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[249],
	},
	{ /* [248] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Large Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"large_community",
	},
	{ /* [249] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[247],
	},
	{ /* [250] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[254],
	},
	{ /* [251] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[253],
	},
	{ /* [252] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
		.varname = (char *)"exact",
	},
	{ /* [253] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[251],
	},
	{ /* [254] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[250],
	},
	{ /* [255] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [256] = match_lcommunity_cmd */ },
	{ /* [257] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
		.varname = (char *)"any",
	},
	{ /* [258] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Large Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"large_community",
	},
	{ /* [259] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"LCOMMUNITY_LIST_NAME",
		.desc = (char *)"Large Community-list name",
		.varname = (char *)"lcommunity_list_name",
	},
	{ /* [260] */
		.type = WORD_TKN,
		.text = (char *)"local-preference",
		.desc = (char *)"Match local-preference of route",
	},
	{ /* [261] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Metric value",
		.max = 4294967295,
		.varname = (char *)"local_preference",
	},
	{ /* [262] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [263] = match_local_pref_cmd */ },
	{ /* [264] */
		.type = WORD_TKN,
		.text = (char *)"mac",
		.desc = (char *)"mac address",
	},
	{ /* [265] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match address of route",
	},
	{ /* [266] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_MAC_NAME",
		.desc = (char *)"MAC Access-list name",
		.varname = (char *)"accesslist_mac_name",
	},
	{ /* [267] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [268] = match_mac_address_cmd */ },
	{ /* [269] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Match metric of route",
	},
	{ /* [270] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Metric value",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [271] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [272] = match_metric_cmd */ },
	{ /* [273] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [274] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[276],
	},
	{ /* [275] */
		.type = WORD_TKN,
		.text = (char *)"egp",
		.desc = (char *)"remote EGP",
	},
	{ /* [276] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[274],
	},
	{ /* [277] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [278] = match_origin_cmd */ },
	{ /* [279] */
		.type = WORD_TKN,
		.text = (char *)"igp",
		.desc = (char *)"local IGP",
	},
	{ /* [280] */
		.type = WORD_TKN,
		.text = (char *)"incomplete",
		.desc = (char *)"unknown heritage",
	},
	{ /* [281] */
		.type = WORD_TKN,
		.text = (char *)"peer",
		.desc = (char *)"Match peer address",
	},
	{ /* [282] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[284],
	},
	{ /* [283] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of peer",
		.varname = (char *)"addrv4",
	},
	{ /* [284] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[282],
	},
	{ /* [285] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [286] = match_peer_cmd */ },
	{ /* [287] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of peer",
		.varname = (char *)"addrv6",
	},
	{ /* [288] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name of peer or peer group name",
		.varname = (char *)"intf",
	},
	{ /* [289] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Static or Redistributed routes",
	},
	{ /* [290] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [291] = match_peer_local_cmd */ },
	{ /* [292] */
		.type = WORD_TKN,
		.text = (char *)"probability",
		.desc = (char *)"Match portion of routes defined by percentage value",
	},
	{ /* [293] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-100)",
		.desc = (char *)"Percentage of routes",
		.max = 100,
		.varname = (char *)"probability",
	},
	{ /* [294] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [295] = match_probability_cmd */ },
	{ /* [296] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Control rpki specific settings",
	},
	{ /* [297] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[299],
	},
	{ /* [298] */
		.type = WORD_TKN,
		.text = (char *)"valid",
		.desc = (char *)"Valid prefix",
	},
	{ /* [299] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[297],
	},
	{ /* [300] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [301] = match_rpki_cmd */ },
	{ /* [302] */
		.type = WORD_TKN,
		.text = (char *)"invalid",
		.desc = (char *)"Invalid prefix",
	},
	{ /* [303] */
		.type = WORD_TKN,
		.text = (char *)"notfound",
		.desc = (char *)"Prefix not found",
	},
	{ /* [304] */
		.type = WORD_TKN,
		.text = (char *)"source-instance",
		.desc = (char *)"Match the protocol's instance number",
	},
	{ /* [305] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-255)",
		.desc = (char *)"The instance number",
		.max = 255,
		.varname = (char *)"instance",
	},
	{ /* [306] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [307] = match_source_instance_cmd */ },
	{ /* [308] */
		.type = WORD_TKN,
		.text = (char *)"source-protocol",
		.desc = (char *)"Match protocol via which the route was learnt",
	},
	{ /* [309] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[311],
	},
	{ /* [310] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"kernel",
		.desc = (char *)"Kernel routes (not installed via the zebra RIB)",
		.varname = (char *)"proto",
	},
	{ /* [311] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[309],
	},
	{ /* [312] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [313] = match_source_protocol_cmd */ },
	{ /* [314] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"connected",
		.desc = (char *)"Connected routes (directly attached subnet or host)",
		.varname = (char *)"proto",
	},
	{ /* [315] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"local",
		.desc = (char *)"Local routes (directly attached host route)",
		.varname = (char *)"proto",
	},
	{ /* [316] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"static",
		.desc = (char *)"Statically configured routes",
		.varname = (char *)"proto",
	},
	{ /* [317] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"rip",
		.desc = (char *)"Routing Information Protocol (RIP)",
		.varname = (char *)"proto",
	},
	{ /* [318] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ripng",
		.desc = (char *)"Routing Information Protocol next-generation (IPv6) (RIPng)",
		.varname = (char *)"proto",
	},
	{ /* [319] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
		.varname = (char *)"proto",
	},
	{ /* [320] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ospf6",
		.desc = (char *)"Open Shortest Path First (IPv6) (OSPFv3)",
		.varname = (char *)"proto",
	},
	{ /* [321] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"isis",
		.desc = (char *)"Intermediate System to Intermediate System (IS-IS)",
		.varname = (char *)"proto",
	},
	{ /* [322] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"bgp",
		.desc = (char *)"Border Gateway Protocol (BGP)",
		.varname = (char *)"proto",
	},
	{ /* [323] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"eigrp",
		.desc = (char *)"Enhanced Interior Gateway Routing Protocol (EIGRP)",
		.varname = (char *)"proto",
	},
	{ /* [324] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"nhrp",
		.desc = (char *)"Next Hop Resolution Protocol (NHRP)",
		.varname = (char *)"proto",
	},
	{ /* [325] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"vnc",
		.desc = (char *)"Virtual Network Control (VNC)",
		.varname = (char *)"proto",
	},
	{ /* [326] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"babel",
		.desc = (char *)"Babel routing protocol (Babel)",
		.varname = (char *)"proto",
	},
	{ /* [327] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"openfabric",
		.desc = (char *)"OpenFabric Routing Protocol",
		.varname = (char *)"proto",
	},
	{ /* [328] */
		.type = WORD_TKN,
		.text = (char *)"source-vrf",
		.desc = (char *)"source vrf",
	},
	{ /* [329] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"NAME",
		.desc = (char *)"The VRF name",
		.varname = (char *)"vrf_name",
	},
	{ /* [330] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [331] = match_vrl_source_vrf_cmd */ },
	{ /* [332] */
		.type = WORD_TKN,
		.text = (char *)"src-peer",
		.desc = (char *)"Match source peer address",
	},
	{ /* [333] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[335],
	},
	{ /* [334] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of peer",
		.varname = (char *)"addrv4",
	},
	{ /* [335] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[333],
	},
	{ /* [336] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [337] = match_src_peer_cmd */ },
	{ /* [338] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of peer",
		.varname = (char *)"addrv6",
	},
	{ /* [339] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name of peer or peer group name",
		.varname = (char *)"intf",
	},
	{ /* [340] */
		.type = WORD_TKN,
		.text = (char *)"tag",
		.desc = (char *)"Match tag of route",
	},
	{ /* [341] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[343],
	},
	{ /* [342] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"untagged",
		.desc = (char *)"Untagged route",
		.varname = (char *)"untagged",
	},
	{ /* [343] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[341],
	},
	{ /* [344] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [345] = match_tag_cmd */ },
	{ /* [346] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Tag value",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"tagged",
	},
	{ /* [347] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [348] */
		.type = WORD_TKN,
		.text = (char *)"call",
		.desc = (char *)"Jump to another Route-Map after match+set",
	},
	{ /* [349] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[351],
	},
	{ /* [350] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"Target route-map name",
		.varname = (char *)"call",
	},
	{ /* [351] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[349],
	},
	{ /* [352] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [353] = no_rmap_call_cmd */ },
	{ /* [354] */
		.type = WORD_TKN,
		.text = (char *)"continue",
		.desc = (char *)"Continue on a different entry within the route-map",
	},
	{ /* [355] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[357],
	},
	{ /* [356] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Route-map entry sequence number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"continue",
	},
	{ /* [357] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[355],
	},
	{ /* [358] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [359] = no_rmap_continue_cmd */ },
	{ /* [360] */
		.type = WORD_TKN,
		.text = (char *)"description",
		.desc = (char *)"Route-map comment",
	},
	{ /* [361] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [362] = no_rmap_description_cmd */ },
	{ /* [363] */
		.type = WORD_TKN,
		.text = (char *)"match",
		.desc = (char *)"Match values from routing table",
	},
	{ /* [364] */
		.type = WORD_TKN,
		.text = (char *)"alias",
		.desc = (char *)"Match BGP community alias name",
	},
	{ /* [365] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[367],
	},
	{ /* [366] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ALIAS_NAME",
		.desc = (char *)"BGP community alias name",
		.varname = (char *)"alias_name",
	},
	{ /* [367] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[365],
	},
	{ /* [368] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [369] = no_match_alias_cmd */ },
	{ /* [370] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"Match BGP AS path list",
	},
	{ /* [371] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[373],
	},
	{ /* [372] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [373] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[371],
	},
	{ /* [374] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [375] = no_match_aspath_cmd */ },
	{ /* [376] */
		.type = WORD_TKN,
		.text = (char *)"community",
		.desc = (char *)"Match BGP community list",
	},
	{ /* [377] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[386],
	},
	{ /* [378] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[380],
	},
	{ /* [379] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"community",
	},
	{ /* [380] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[378],
	},
	{ /* [381] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[385],
	},
	{ /* [382] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[384],
	},
	{ /* [383] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
		.varname = (char *)"exact",
	},
	{ /* [384] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[382],
	},
	{ /* [385] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[381],
	},
	{ /* [386] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[377],
	},
	{ /* [387] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [388] = no_match_community_cmd */ },
	{ /* [389] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
		.varname = (char *)"any",
	},
	{ /* [390] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"community",
	},
	{ /* [391] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"COMMUNITY_LIST_NAME",
		.desc = (char *)"Community-list name",
		.varname = (char *)"community_list_name",
	},
	{ /* [392] */
		.type = WORD_TKN,
		.text = (char *)"evpn",
		.desc = (char *)"Ethernet Virtual Private Network",
	},
	{ /* [393] */
		.type = WORD_TKN,
		.text = (char *)"default-route",
		.desc = (char *)"default EVPN type-5 route",
	},
	{ /* [394] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [395] = no_match_evpn_default_route_cmd */ },
	{ /* [396] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Route Distinguisher",
	},
	{ /* [397] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"ASN:XX or A.B.C.D:XX",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [398] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [399] = no_match_evpn_rd_cmd */ },
	{ /* [400] */
		.type = WORD_TKN,
		.text = (char *)"route-type",
		.desc = (char *)"Specify Route type",
	},
	{ /* [401] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[403],
	},
	{ /* [402] */
		.type = WORD_TKN,
		.text = (char *)"ead",
		.desc = (char *)"EAD (Type-1) route",
	},
	{ /* [403] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[401],
	},
	{ /* [404] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [405] = no_match_evpn_route_type_cmd */ },
	{ /* [406] */
		.type = WORD_TKN,
		.text = (char *)"1",
		.desc = (char *)"EAD (Type-1) route",
	},
	{ /* [407] */
		.type = WORD_TKN,
		.text = (char *)"macip",
		.desc = (char *)"MAC-IP (Type-2) route",
	},
	{ /* [408] */
		.type = WORD_TKN,
		.text = (char *)"2",
		.desc = (char *)"MAC-IP (Type-2) route",
	},
	{ /* [409] */
		.type = WORD_TKN,
		.text = (char *)"multicast",
		.desc = (char *)"Multicast (Type-3) route",
	},
	{ /* [410] */
		.type = WORD_TKN,
		.text = (char *)"3",
		.desc = (char *)"Multicast (Type-3) route",
	},
	{ /* [411] */
		.type = WORD_TKN,
		.text = (char *)"es",
		.desc = (char *)"Ethernet Segment (Type-4) route",
	},
	{ /* [412] */
		.type = WORD_TKN,
		.text = (char *)"4",
		.desc = (char *)"Ethernet Segment (Type-4) route",
	},
	{ /* [413] */
		.type = WORD_TKN,
		.text = (char *)"prefix",
		.desc = (char *)"Prefix (Type-5) route",
	},
	{ /* [414] */
		.type = WORD_TKN,
		.text = (char *)"5",
		.desc = (char *)"Prefix (Type-5) route",
	},
	{ /* [415] */
		.type = WORD_TKN,
		.text = (char *)"vni",
		.desc = (char *)"Match VNI",
	},
	{ /* [416] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-16777215)",
		.desc = (char *)"VNI ID",
		.min = 1,
		.max = 16777215,
		.varname = (char *)"vni",
	},
	{ /* [417] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [418] = no_match_evpn_vni_cmd */ },
	{ /* [419] */
		.type = WORD_TKN,
		.text = (char *)"extcommunity",
		.desc = (char *)"Match BGP/VPN extended community list",
	},
	{ /* [420] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[429],
	},
	{ /* [421] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[423],
	},
	{ /* [422] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Extended community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"extcommunity",
	},
	{ /* [423] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[421],
	},
	{ /* [424] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[428],
	},
	{ /* [425] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[427],
	},
	{ /* [426] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
		.varname = (char *)"exact",
	},
	{ /* [427] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[425],
	},
	{ /* [428] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[424],
	},
	{ /* [429] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[420],
	},
	{ /* [430] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [431] = no_match_ecommunity_cmd */ },
	{ /* [432] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
		.varname = (char *)"any",
	},
	{ /* [433] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Extended community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"extcommunity",
	},
	{ /* [434] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"EXTCOMMUNITY_LIST_NAME",
		.desc = (char *)"Extended community-list name",
		.varname = (char *)"extcommunity_list_name",
	},
	{ /* [435] */
		.type = WORD_TKN,
		.text = (char *)"interface",
		.desc = (char *)"Match first hop interface of route",
	},
	{ /* [436] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[438],
	},
	{ /* [437] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface information",
		.varname = (char *)"ifname",
	},
	{ /* [438] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[436],
	},
	{ /* [439] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [440] = no_match_interface_cmd */ },
	{ /* [441] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [442] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[444],
	},
	{ /* [443] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [444] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[442],
	},
	{ /* [445] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [446] = no_route_map_match_address_cmd */ },
	{ /* [447] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [448] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match against IPv4 prefix list",
	},
	{ /* [449] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [450] = no_route_map_match_prefix_list_cmd */ },
	{ /* [451] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match address of route",
	},
	{ /* [452] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[454],
	},
	{ /* [453] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist4_name",
	},
	{ /* [454] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[452],
	},
	{ /* [455] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [456] = no_match_ip_address_cmd */ },
	{ /* [457] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefix length of IP address",
	},
	{ /* [458] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[460],
	},
	{ /* [459] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-32)",
		.desc = (char *)"Prefix length",
		.max = 32,
		.varname = (char *)"prefix_len",
	},
	{ /* [460] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[458],
	},
	{ /* [461] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [462] = no_match_ip_address_prefix_len_cmd */ },
	{ /* [463] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [464] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[466],
	},
	{ /* [465] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"prefixlist4_name",
	},
	{ /* [466] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[464],
	},
	{ /* [467] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [468] = no_match_ip_address_prefix_list_cmd */ },
	{ /* [469] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Match address of route",
	},
	{ /* [470] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[472],
	},
	{ /* [471] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist4_name",
	},
	{ /* [472] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[470],
	},
	{ /* [473] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [474] = no_match_ip_next_hop_cmd */ },
	{ /* [475] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"IP address",
	},
	{ /* [476] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[478],
	},
	{ /* [477] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next-hop",
		.varname = (char *)"address",
	},
	{ /* [478] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[476],
	},
	{ /* [479] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [480] = no_match_ipv4_next_hop_cmd */ },
	{ /* [481] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefix length of nexthop",
	},
	{ /* [482] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[484],
	},
	{ /* [483] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-32)",
		.desc = (char *)"Prefix length",
		.max = 32,
		.varname = (char *)"prefix_len",
	},
	{ /* [484] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[482],
	},
	{ /* [485] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [486] = no_match_ip_nexthop_prefix_len_cmd */ },
	{ /* [487] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [488] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[490],
	},
	{ /* [489] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"prefixlist4_name",
	},
	{ /* [490] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[488],
	},
	{ /* [491] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [492] = no_match_ip_next_hop_prefix_list_cmd */ },
	{ /* [493] */
		.type = WORD_TKN,
		.text = (char *)"type",
		.desc = (char *)"Match entries by type",
	},
	{ /* [494] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[498],
	},
	{ /* [495] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[497],
	},
	{ /* [496] */
		.type = WORD_TKN,
		.text = (char *)"blackhole",
		.desc = (char *)"Blackhole",
	},
	{ /* [497] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[495],
	},
	{ /* [498] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[494],
	},
	{ /* [499] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [500] = no_match_ip_next_hop_type_cmd */ },
	{ /* [501] */
		.type = WORD_TKN,
		.text = (char *)"route-source",
		.desc = (char *)"Match advertising source address of route",
	},
	{ /* [502] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[504],
	},
	{ /* [503] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist4_name",
	},
	{ /* [504] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[502],
	},
	{ /* [505] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [506] = no_match_ip_route_source_cmd */ },
	{ /* [507] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [508] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[510],
	},
	{ /* [509] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"prefixlist_name",
	},
	{ /* [510] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[508],
	},
	{ /* [511] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [512] = no_match_ip_route_source_prefix_list_cmd */ },
	{ /* [513] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [514] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[516],
	},
	{ /* [515] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-source",
		.desc = (char *)"Multicast source address",
		.varname = (char *)"do_src",
	},
	{ /* [516] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[514],
	},
	{ /* [517] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [518] = no_route_map_match_address_v6_cmd */ },
	{ /* [519] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"multicast-group",
		.desc = (char *)"Multicast group address",
		.varname = (char *)"do_grp",
	},
	{ /* [520] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match against IPv6 prefix list",
	},
	{ /* [521] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [522] = no_route_map_match_prefix_list_v6_cmd */ },
	{ /* [523] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match IPv6 address of route",
	},
	{ /* [524] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[526],
	},
	{ /* [525] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST6_NAME",
		.desc = (char *)"IPv6 access-list name",
		.varname = (char *)"accesslist6_name",
	},
	{ /* [526] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[524],
	},
	{ /* [527] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [528] = no_match_ipv6_address_cmd */ },
	{ /* [529] */
		.type = WORD_TKN,
		.text = (char *)"prefix-len",
		.desc = (char *)"Match prefix length of IPv6 address",
	},
	{ /* [530] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[532],
	},
	{ /* [531] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-128)",
		.desc = (char *)"Prefix length",
		.max = 128,
		.varname = (char *)"prefix_len",
	},
	{ /* [532] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[530],
	},
	{ /* [533] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [534] = no_match_ipv6_address_prefix_len_cmd */ },
	{ /* [535] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries of prefix-lists",
	},
	{ /* [536] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[538],
	},
	{ /* [537] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST6_NAME",
		.desc = (char *)"IP prefix-list name",
		.varname = (char *)"prefixlist6_name",
	},
	{ /* [538] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[536],
	},
	{ /* [539] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [540] = no_match_ipv6_address_prefix_list_cmd */ },
	{ /* [541] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Match IPv6 next-hop address of route",
	},
	{ /* [542] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"next_hop",
	},
	{ /* [543] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [544] = no_match_ipv6_next_hop_old_cmd */ },
	{ /* [545] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[547],
	},
	{ /* [546] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST6_NAME",
		.desc = (char *)"IPv6 access-list name",
		.varname = (char *)"accesslist6_name",
	},
	{ /* [547] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[545],
	},
	{ /* [548] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [549] = no_match_ipv6_next_hop_cmd */ },
	{ /* [550] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"IPv6 address",
	},
	{ /* [551] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"address",
	},
	{ /* [552] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [553] = no_match_ipv6_next_hop_address_cmd */ },
	{ /* [554] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Match entries by prefix-list",
	},
	{ /* [555] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[557],
	},
	{ /* [556] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PREFIXLIST_NAME",
		.desc = (char *)"IPv6 prefix-list name",
		.varname = (char *)"prefixlist_name",
	},
	{ /* [557] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[555],
	},
	{ /* [558] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [559] = no_match_ipv6_next_hop_prefix_list_cmd */ },
	{ /* [560] */
		.type = WORD_TKN,
		.text = (char *)"type",
		.desc = (char *)"Match entries by type",
	},
	{ /* [561] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[565],
	},
	{ /* [562] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[564],
	},
	{ /* [563] */
		.type = WORD_TKN,
		.text = (char *)"blackhole",
		.desc = (char *)"Blackhole",
	},
	{ /* [564] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[562],
	},
	{ /* [565] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[561],
	},
	{ /* [566] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [567] = no_match_ipv6_next_hop_type_cmd */ },
	{ /* [568] */
		.type = WORD_TKN,
		.text = (char *)"large-community",
		.desc = (char *)"Match BGP large community list",
	},
	{ /* [569] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[578],
	},
	{ /* [570] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[572],
	},
	{ /* [571] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Large Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"large_community",
	},
	{ /* [572] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[570],
	},
	{ /* [573] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[577],
	},
	{ /* [574] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[576],
	},
	{ /* [575] */
		.type = WORD_TKN,
		.text = (char *)"exact-match",
		.desc = (char *)"Do exact matching of communities",
	},
	{ /* [576] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[574],
	},
	{ /* [577] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[573],
	},
	{ /* [578] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[569],
	},
	{ /* [579] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [580] = no_match_lcommunity_cmd */ },
	{ /* [581] */
		.type = WORD_TKN,
		.text = (char *)"any",
		.desc = (char *)"Do matching of any community",
	},
	{ /* [582] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Large Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"large_community",
	},
	{ /* [583] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"LCOMMUNITY_LIST_NAME",
		.desc = (char *)"Large Community-list name",
		.varname = (char *)"lcommunity_list_name",
	},
	{ /* [584] */
		.type = WORD_TKN,
		.text = (char *)"local-preference",
		.desc = (char *)"Match local preference of route",
	},
	{ /* [585] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[587],
	},
	{ /* [586] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Local preference value",
		.max = 4294967295,
		.varname = (char *)"local_preference",
	},
	{ /* [587] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[585],
	},
	{ /* [588] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [589] = no_match_local_pref_cmd */ },
	{ /* [590] */
		.type = WORD_TKN,
		.text = (char *)"mac",
		.desc = (char *)"mac",
	},
	{ /* [591] */
		.type = WORD_TKN,
		.text = (char *)"address",
		.desc = (char *)"Match address of route",
	},
	{ /* [592] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_MAC_NAME",
		.desc = (char *)"MAC acess-list name",
		.varname = (char *)"accesslist_mac_name",
	},
	{ /* [593] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [594] = no_match_mac_address_cmd */ },
	{ /* [595] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Match metric of route",
	},
	{ /* [596] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[598],
	},
	{ /* [597] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Metric value",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [598] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[596],
	},
	{ /* [599] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [600] = no_match_metric_cmd */ },
	{ /* [601] */
		.type = WORD_TKN,
		.text = (char *)"multicast-interface",
		.desc = (char *)"Multicast data interface",
	},
	{ /* [602] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [603] = no_route_map_match_interface_cmd */ },
	{ /* [604] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [605] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[609],
	},
	{ /* [606] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[608],
	},
	{ /* [607] */
		.type = WORD_TKN,
		.text = (char *)"egp",
		.desc = (char *)"remote EGP",
	},
	{ /* [608] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[606],
	},
	{ /* [609] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[605],
	},
	{ /* [610] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [611] = no_match_origin_cmd */ },
	{ /* [612] */
		.type = WORD_TKN,
		.text = (char *)"igp",
		.desc = (char *)"local IGP",
	},
	{ /* [613] */
		.type = WORD_TKN,
		.text = (char *)"incomplete",
		.desc = (char *)"unknown heritage",
	},
	{ /* [614] */
		.type = WORD_TKN,
		.text = (char *)"peer",
		.desc = (char *)"Match peer address",
	},
	{ /* [615] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[619],
	},
	{ /* [616] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[618],
	},
	{ /* [617] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Static or Redistributed routes",
	},
	{ /* [618] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[616],
	},
	{ /* [619] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[615],
	},
	{ /* [620] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [621] = no_match_peer_cmd */ },
	{ /* [622] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of peer",
		.varname = (char *)"peer",
	},
	{ /* [623] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of peer",
		.varname = (char *)"peer",
	},
	{ /* [624] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name of peer",
		.varname = (char *)"peer",
	},
	{ /* [625] */
		.type = WORD_TKN,
		.text = (char *)"probability",
		.desc = (char *)"Match portion of routes defined by percentage value",
	},
	{ /* [626] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[628],
	},
	{ /* [627] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-100)",
		.desc = (char *)"Percentage of routes",
		.max = 100,
		.varname = (char *)"probability",
	},
	{ /* [628] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[626],
	},
	{ /* [629] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [630] = no_match_probability_cmd */ },
	{ /* [631] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Control rpki specific settings",
	},
	{ /* [632] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[634],
	},
	{ /* [633] */
		.type = WORD_TKN,
		.text = (char *)"valid",
		.desc = (char *)"Valid prefix",
	},
	{ /* [634] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[632],
	},
	{ /* [635] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [636] = no_match_rpki_cmd */ },
	{ /* [637] */
		.type = WORD_TKN,
		.text = (char *)"invalid",
		.desc = (char *)"Invalid prefix",
	},
	{ /* [638] */
		.type = WORD_TKN,
		.text = (char *)"notfound",
		.desc = (char *)"Prefix not found",
	},
	{ /* [639] */
		.type = WORD_TKN,
		.text = (char *)"source-instance",
		.desc = (char *)"Match the protocol's instance number",
	},
	{ /* [640] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[642],
	},
	{ /* [641] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-255)",
		.desc = (char *)"The instance number",
		.max = 255,
		.varname = (char *)"source_instance",
	},
	{ /* [642] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[640],
	},
	{ /* [643] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [644] = no_match_source_instance_cmd */ },
	{ /* [645] */
		.type = WORD_TKN,
		.text = (char *)"source-protocol",
		.desc = (char *)"Match protocol via which the route was learnt",
	},
	{ /* [646] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[650],
	},
	{ /* [647] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[649],
	},
	{ /* [648] */
		.type = WORD_TKN,
		.text = (char *)"kernel",
		.desc = (char *)"Kernel routes (not installed via the zebra RIB)",
	},
	{ /* [649] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[647],
	},
	{ /* [650] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[646],
	},
	{ /* [651] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [652] = no_match_source_protocol_cmd */ },
	{ /* [653] */
		.type = WORD_TKN,
		.text = (char *)"connected",
		.desc = (char *)"Connected routes (directly attached subnet or host)",
	},
	{ /* [654] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Local routes (directly attached host route)",
	},
	{ /* [655] */
		.type = WORD_TKN,
		.text = (char *)"static",
		.desc = (char *)"Statically configured routes",
	},
	{ /* [656] */
		.type = WORD_TKN,
		.text = (char *)"rip",
		.desc = (char *)"Routing Information Protocol (RIP)",
	},
	{ /* [657] */
		.type = WORD_TKN,
		.text = (char *)"ripng",
		.desc = (char *)"Routing Information Protocol next-generation (IPv6) (RIPng)",
	},
	{ /* [658] */
		.type = WORD_TKN,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
	},
	{ /* [659] */
		.type = WORD_TKN,
		.text = (char *)"ospf6",
		.desc = (char *)"Open Shortest Path First (IPv6) (OSPFv3)",
	},
	{ /* [660] */
		.type = WORD_TKN,
		.text = (char *)"isis",
		.desc = (char *)"Intermediate System to Intermediate System (IS-IS)",
	},
	{ /* [661] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"Border Gateway Protocol (BGP)",
	},
	{ /* [662] */
		.type = WORD_TKN,
		.text = (char *)"eigrp",
		.desc = (char *)"Enhanced Interior Gateway Routing Protocol (EIGRP)",
	},
	{ /* [663] */
		.type = WORD_TKN,
		.text = (char *)"nhrp",
		.desc = (char *)"Next Hop Resolution Protocol (NHRP)",
	},
	{ /* [664] */
		.type = WORD_TKN,
		.text = (char *)"vnc",
		.desc = (char *)"Virtual Network Control (VNC)",
	},
	{ /* [665] */
		.type = WORD_TKN,
		.text = (char *)"babel",
		.desc = (char *)"Babel routing protocol (Babel)",
	},
	{ /* [666] */
		.type = WORD_TKN,
		.text = (char *)"openfabric",
		.desc = (char *)"OpenFabric Routing Protocol",
	},
	{ /* [667] */
		.type = WORD_TKN,
		.text = (char *)"source-vrf",
		.desc = (char *)"source vrf",
	},
	{ /* [668] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"NAME",
		.desc = (char *)"The VRF name",
		.varname = (char *)"vrf_name",
	},
	{ /* [669] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [670] = no_match_vrl_source_vrf_cmd */ },
	{ /* [671] */
		.type = WORD_TKN,
		.text = (char *)"src-peer",
		.desc = (char *)"Match peer address",
	},
	{ /* [672] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[676],
	},
	{ /* [673] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[675],
	},
	{ /* [674] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of peer",
		.varname = (char *)"src_peer",
	},
	{ /* [675] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[673],
	},
	{ /* [676] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[672],
	},
	{ /* [677] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [678] = no_match_src_peer_cmd */ },
	{ /* [679] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of peer",
		.varname = (char *)"src_peer",
	},
	{ /* [680] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name of peer",
		.varname = (char *)"src_peer",
	},
	{ /* [681] */
		.type = WORD_TKN,
		.text = (char *)"tag",
		.desc = (char *)"Match tag of route",
	},
	{ /* [682] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[686],
	},
	{ /* [683] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[685],
	},
	{ /* [684] */
		.type = WORD_TKN,
		.text = (char *)"untagged",
		.desc = (char *)"Untagged route",
	},
	{ /* [685] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[683],
	},
	{ /* [686] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[682],
	},
	{ /* [687] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [688] = no_match_tag_cmd */ },
	{ /* [689] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Tag value",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"tag",
	},
	{ /* [690] */
		.type = WORD_TKN,
		.text = (char *)"on-match",
		.desc = (char *)"Exit policy on matches",
	},
	{ /* [691] */
		.type = WORD_TKN,
		.text = (char *)"goto",
		.desc = (char *)"Goto Clause number",
	},
	{ /* [692] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[694],
	},
	{ /* [693] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"rm_num",
	},
	{ /* [694] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[692],
	},
	{ /* [695] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [696] = no_rmap_onmatch_goto_cmd */ },
	{ /* [697] */
		.type = WORD_TKN,
		.text = (char *)"next",
		.desc = (char *)"Next clause",
	},
	{ /* [698] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [699] = no_rmap_onmatch_next_cmd */ },
	{ /* [700] */
		.type = WORD_TKN,
		.text = (char *)"set",
		.desc = (char *)"Set values in destination routing protocol",
	},
	{ /* [701] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[703],
	},
	{ /* [702] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 information",
	},
	{ /* [703] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[701],
	},
	{ /* [704] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"VPN information",
	},
	{ /* [705] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"VPN next-hop address",
	},
	{ /* [706] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[710],
	},
	{ /* [707] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[709],
	},
	{ /* [708] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next hop",
		.varname = (char *)"next_hop",
	},
	{ /* [709] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[707],
	},
	{ /* [710] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[706],
	},
	{ /* [711] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [712] = no_set_ipx_vpn_nexthop_cmd */ },
	{ /* [713] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"next_hop",
	},
	{ /* [714] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [715] */
		.type = WORD_TKN,
		.text = (char *)"aggregator",
		.desc = (char *)"BGP aggregator attribute",
	},
	{ /* [716] */
		.type = WORD_TKN,
		.text = (char *)"as",
		.desc = (char *)"AS number of aggregator",
	},
	{ /* [717] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[720],
	},
	{ /* [718] */
		.type = ASNUM_TKN,
		.varname_src = 3,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format",
		.varname = (char *)"as",
	},
	{ /* [719] */
		.type = IPV4_TKN,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of aggregator",
	},
	{ /* [720] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[717],
	},
	{ /* [721] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [722] = no_set_aggregator_as_cmd */ },
	{ /* [723] */
		.type = WORD_TKN,
		.text = (char *)"aigp-metric",
		.desc = (char *)"BGP AIGP attribute (AIGP Metric TLV)",
	},
	{ /* [724] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[728],
	},
	{ /* [725] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[727],
	},
	{ /* [726] */
		.type = WORD_TKN,
		.text = (char *)"igp-metric",
		.desc = (char *)"AIGP Metric value from IGP protocol",
	},
	{ /* [727] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[725],
	},
	{ /* [728] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[724],
	},
	{ /* [729] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [730] = no_set_aigp_metric_cmd */ },
	{ /* [731] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Manual AIGP Metric value",
		.max = 4294967295,
		.varname = (char *)"aigp_metric",
	},
	{ /* [732] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"Transform BGP AS_PATH attribute",
	},
	{ /* [733] */
		.type = WORD_TKN,
		.text = (char *)"exclude",
		.desc = (char *)"Exclude from the as-path",
	},
	{ /* [734] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [735] = no_set_aspath_exclude_all_cmd */ },
	{ /* [736] */
		.type = ASNUM_TKN,
		.allowrepeat = true,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number",
	},
	{ /* [737] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [738] = no_set_aspath_exclude_cmd */ },
	{ /* [739] */
		.type = WORD_TKN,
		.text = (char *)"as-path-access-list",
		.desc = (char *)"Specify an as path access list name",
	},
	{ /* [740] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[742],
	},
	{ /* [741] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [742] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[740],
	},
	{ /* [743] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [744] = no_set_aspath_exclude_access_list_cmd */ },
	{ /* [745] */
		.type = WORD_TKN,
		.text = (char *)"prepend",
		.desc = (char *)"Prepend to the as-path",
	},
	{ /* [746] */
		.type = ASNUM_TKN,
		.allowrepeat = true,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format",
	},
	{ /* [747] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [748] = no_set_aspath_prepend_as_cmd */ },
	{ /* [749] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[754],
	},
	{ /* [750] */
		.type = WORD_TKN,
		.text = (char *)"last-as",
		.desc = (char *)"Use the peers AS-number",
	},
	{ /* [751] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[753],
	},
	{ /* [752] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of times to insert",
		.min = 1,
		.max = 10,
		.varname = (char *)"last_as",
	},
	{ /* [753] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[751],
	},
	{ /* [754] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[749],
	},
	{ /* [755] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [756] = no_set_aspath_prepend_last_as_cmd */ },
	{ /* [757] */
		.type = WORD_TKN,
		.text = (char *)"replace",
		.desc = (char *)"Replace AS number to local or configured AS number",
	},
	{ /* [758] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[762],
	},
	{ /* [759] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[761],
	},
	{ /* [760] */
		.type = WORD_TKN,
		.text = (char *)"any",
		.desc = (char *)"Replace any AS number to local or configured AS number",
	},
	{ /* [761] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[759],
	},
	{ /* [762] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[758],
	},
	{ /* [763] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[767],
	},
	{ /* [764] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[766],
	},
	{ /* [765] */
		.type = ASNUM_TKN,
		.varname_src = 4,
		.text = (char *)"ASNUM",
		.desc = (char *)"Define the configured AS number",
		.varname = (char *)"configured_asn",
	},
	{ /* [766] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[764],
	},
	{ /* [767] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[763],
	},
	{ /* [768] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [769] = no_set_aspath_replace_asn_cmd */ },
	{ /* [770] */
		.type = ASNUM_TKN,
		.varname_src = 3,
		.text = (char *)"ASNUM",
		.desc = (char *)"Replace a specific AS number to local or configured AS number",
		.varname = (char *)"replace",
	},
	{ /* [771] */
		.type = WORD_TKN,
		.text = (char *)"as-path-access-list",
		.desc = (char *)"Specify an as path access list name",
	},
	{ /* [772] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[774],
	},
	{ /* [773] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [774] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[772],
	},
	{ /* [775] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[779],
	},
	{ /* [776] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[778],
	},
	{ /* [777] */
		.type = ASNUM_TKN,
		.varname_src = 4,
		.text = (char *)"ASNUM",
		.desc = (char *)"Define the configured AS number",
		.varname = (char *)"configured_asn",
	},
	{ /* [778] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[776],
	},
	{ /* [779] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[775],
	},
	{ /* [780] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [781] = no_set_aspath_replace_access_list_cmd */ },
	{ /* [782] */
		.type = WORD_TKN,
		.text = (char *)"atomic-aggregate",
		.desc = (char *)"BGP atomic aggregate attribute",
	},
	{ /* [783] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [784] = no_set_atomic_aggregate_cmd */ },
	{ /* [785] */
		.type = WORD_TKN,
		.text = (char *)"comm-list",
		.desc = (char *)"set BGP community list (for deletion)",
	},
	{ /* [786] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[791],
	},
	{ /* [787] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[789],
	},
	{ /* [788] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"comm_list",
	},
	{ /* [789] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[787],
	},
	{ /* [790] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching communities",
	},
	{ /* [791] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[786],
	},
	{ /* [792] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [793] = no_set_community_delete_cmd */ },
	{ /* [794] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"comm_list",
	},
	{ /* [795] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"COMMUNITY_LIST_NAME",
		.desc = (char *)"Community-list name",
		.varname = (char *)"community_list_name",
	},
	{ /* [796] */
		.type = WORD_TKN,
		.text = (char *)"community",
		.desc = (char *)"BGP community attribute",
	},
	{ /* [797] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [798] = no_set_community_short_cmd */ },
	{ /* [799] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"AA:NN",
		.desc = (char *)"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive",
		.varname = (char *)"aa_nn",
	},
	{ /* [800] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [801] = no_set_community_cmd */ },
	{ /* [802] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"BGP Administrative Distance to use",
	},
	{ /* [803] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[805],
	},
	{ /* [804] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance value",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [805] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[803],
	},
	{ /* [806] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [807] = no_set_distance_cmd */ },
	{ /* [808] */
		.type = WORD_TKN,
		.text = (char *)"evpn",
		.desc = (char *)"Ethernet Virtual Private Network",
	},
	{ /* [809] */
		.type = WORD_TKN,
		.text = (char *)"gateway-ip",
		.desc = (char *)"Set gateway IP for prefix advertisement route",
	},
	{ /* [810] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 address",
	},
	{ /* [811] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Gateway IP address in IPv4 format",
		.varname = (char *)"ipv4",
	},
	{ /* [812] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [813] = no_set_evpn_gw_ip_ipv4_cmd */ },
	{ /* [814] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv4 address",
	},
	{ /* [815] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Gateway IP address in IPv4 format",
		.varname = (char *)"ipv6",
	},
	{ /* [816] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [817] = no_set_evpn_gw_ip_ipv6_cmd */ },
	{ /* [818] */
		.type = WORD_TKN,
		.text = (char *)"extcommunity",
		.desc = (char *)"BGP extended community attribute",
	},
	{ /* [819] */
		.type = WORD_TKN,
		.text = (char *)"bandwidth",
		.desc = (char *)"Link bandwidth extended community",
	},
	{ /* [820] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [821] = no_set_ecommunity_lb_short_cmd */ },
	{ /* [822] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[824],
	},
	{ /* [823] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Bandwidth value in Mbps",
		.max = 4294967295,
		.varname = (char *)"bandwidth",
	},
	{ /* [824] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[822],
	},
	{ /* [825] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[827],
	},
	{ /* [826] */
		.type = WORD_TKN,
		.text = (char *)"non-transitive",
		.desc = (char *)"Attribute is set as non-transitive",
	},
	{ /* [827] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[825],
	},
	{ /* [828] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [829] = no_set_ecommunity_lb_cmd */ },
	{ /* [830] */
		.type = WORD_TKN,
		.text = (char *)"cumulative",
		.desc = (char *)"Cumulative bandwidth of all multipaths (outbound-only)",
	},
	{ /* [831] */
		.type = WORD_TKN,
		.text = (char *)"num-multipaths",
		.desc = (char *)"Internally computed bandwidth based on number of multipaths (outbound-only)",
	},
	{ /* [832] */
		.type = WORD_TKN,
		.text = (char *)"color",
		.desc = (char *)"Color extended community",
	},
	{ /* [833] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [834] = no_set_ecommunity_color_all_cmd */ },
	{ /* [835] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Color ID",
		.varname = (char *)"rtlist",
	},
	{ /* [836] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [837] = no_set_ecommunity_color_cmd */ },
	{ /* [838] */
		.type = WORD_TKN,
		.text = (char *)"none",
		.desc = (char *)"No extended community attribute",
	},
	{ /* [839] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [840] = no_set_ecommunity_none_cmd */ },
	{ /* [841] */
		.type = WORD_TKN,
		.text = (char *)"nt",
		.desc = (char *)"Node Target extended community",
	},
	{ /* [842] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [843] = no_set_ecommunity_nt_short_cmd */ },
	{ /* [844] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Node Target ID",
		.varname = (char *)"rtlist",
	},
	{ /* [845] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [846] = no_set_ecommunity_nt_cmd */ },
	{ /* [847] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Route Target extended community",
	},
	{ /* [848] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [849] = no_set_ecommunity_rt_short_cmd */ },
	{ /* [850] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [851] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [852] = no_set_ecommunity_rt_cmd */ },
	{ /* [853] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Site-of-Origin extended community",
	},
	{ /* [854] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [855] = no_set_ecommunity_soo_short_cmd */ },
	{ /* [856] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [857] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [858] = no_set_ecommunity_soo_cmd */ },
	{ /* [859] */
		.type = WORD_TKN,
		.text = (char *)"extended-comm-list",
		.desc = (char *)"set BGP extended community list (for deletion)",
	},
	{ /* [860] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[864],
	},
	{ /* [861] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[863],
	},
	{ /* [862] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Extended community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"extended_comm_list",
	},
	{ /* [863] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[861],
	},
	{ /* [864] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[860],
	},
	{ /* [865] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching extended communities",
	},
	{ /* [866] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [867] = no_set_ecommunity_delete_cmd */ },
	{ /* [868] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Extended community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"extended_comm_list",
	},
	{ /* [869] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"EXTCOMMUNITY_LIST_NAME",
		.desc = (char *)"Extended community-list name",
		.varname = (char *)"extcommunity_list_name",
	},
	{ /* [870] */
		.type = WORD_TKN,
		.text = (char *)"forwarding-address",
		.desc = (char *)"Forwarding Address",
	},
	{ /* [871] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[873],
	},
	{ /* [872] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 Address",
		.varname = (char *)"forwarding_address",
	},
	{ /* [873] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[871],
	},
	{ /* [874] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [875] = ospf6_routemap_no_set_forwarding_cmd */ },
	{ /* [876] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [877] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Next hop address",
	},
	{ /* [878] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[880],
	},
	{ /* [879] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next hop",
		.varname = (char *)"next_hop",
	},
	{ /* [880] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[878],
	},
	{ /* [881] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [882] = no_set_ip_nexthop_cmd */ },
	{ /* [883] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [884] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"IPv6 next-hop address",
	},
	{ /* [885] */
		.type = WORD_TKN,
		.text = (char *)"global",
		.desc = (char *)"IPv6 global address",
	},
	{ /* [886] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"global",
	},
	{ /* [887] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [888] = no_set_ipv6_nexthop_global_cmd */ },
	{ /* [889] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"IPv6 local address",
	},
	{ /* [890] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[892],
	},
	{ /* [891] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"local",
	},
	{ /* [892] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[890],
	},
	{ /* [893] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [894] = no_set_ipv6_nexthop_local_cmd */ },
	{ /* [895] */
		.type = WORD_TKN,
		.text = (char *)"peer-address",
		.desc = (char *)"Use peer address (for BGP only)",
	},
	{ /* [896] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [897] = no_set_ipv6_nexthop_peer_cmd */ },
	{ /* [898] */
		.type = WORD_TKN,
		.text = (char *)"prefer-global",
		.desc = (char *)"Prefer global over link-local if both exist",
	},
	{ /* [899] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [900] = no_set_ipv6_nexthop_prefer_global_cmd */ },
	{ /* [901] */
		.type = WORD_TKN,
		.text = (char *)"label-index",
		.desc = (char *)"Label index to associate with the prefix",
	},
	{ /* [902] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[904],
	},
	{ /* [903] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-1048560)",
		.desc = (char *)"Label index value",
		.max = 1048560,
		.varname = (char *)"label_index",
	},
	{ /* [904] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[902],
	},
	{ /* [905] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [906] = no_set_label_index_cmd */ },
	{ /* [907] */
		.type = WORD_TKN,
		.text = (char *)"large-comm-list",
		.desc = (char *)"set BGP large community list (for deletion)",
	},
	{ /* [908] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [909] = no_set_lcommunity_delete_short_cmd */ },
	{ /* [910] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[912],
	},
	{ /* [911] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Large Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"large_comm_list",
	},
	{ /* [912] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[910],
	},
	{ /* [913] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[915],
	},
	{ /* [914] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching large communities",
	},
	{ /* [915] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[913],
	},
	{ /* [916] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [917] = no_set_lcommunity_delete_cmd */ },
	{ /* [918] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Large Communitly-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"large_comm_list",
	},
	{ /* [919] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"LCOMMUNITY_LIST_NAME",
		.desc = (char *)"Large Community-list name",
		.varname = (char *)"lcommunity_list_name",
	},
	{ /* [920] */
		.type = WORD_TKN,
		.text = (char *)"large-community",
		.desc = (char *)"BGP large community attribute",
	},
	{ /* [921] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [922] = no_set_lcommunity1_short_cmd */ },
	{ /* [923] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"AA:BB:CC",
		.desc = (char *)"Large community in AA:BB:CC... format or additive",
		.varname = (char *)"aa_bb_cc",
	},
	{ /* [924] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [925] = no_set_lcommunity1_cmd */ },
	{ /* [926] */
		.type = WORD_TKN,
		.text = (char *)"none",
		.desc = (char *)"No community attribute",
	},
	{ /* [927] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [928] = no_set_lcommunity_cmd */ },
	{ /* [929] */
		.type = WORD_TKN,
		.text = (char *)"local-preference",
		.desc = (char *)"BGP local preference path attribute",
	},
	{ /* [930] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[932],
	},
	{ /* [931] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Preference value (0-4294967295)",
		.varname = (char *)"local_preference",
	},
	{ /* [932] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[930],
	},
	{ /* [933] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [934] = no_set_local_pref_cmd */ },
	{ /* [935] */
		.type = WORD_TKN,
		.text = (char *)"max-metric",
		.desc = (char *)"Maximum Metric value for destination routing protocol",
	},
	{ /* [936] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[938],
	},
	{ /* [937] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Maximum metric value",
		.max = 4294967295,
		.varname = (char *)"max_metric",
	},
	{ /* [938] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[936],
	},
	{ /* [939] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [940] = no_set_max_metric_cmd */ },
	{ /* [941] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric value for destination routing protocol",
	},
	{ /* [942] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[944],
	},
	{ /* [943] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"OPTVAL",
		.desc = (char *)"Metric value",
		.varname = (char *)"optval",
	},
	{ /* [944] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[942],
	},
	{ /* [945] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [946] = no_set_metric_cmd */ },
	{ /* [947] */
		.type = WORD_TKN,
		.text = (char *)"metric-type",
		.desc = (char *)"Type of metric for destination routing protocol",
	},
	{ /* [948] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[952],
	},
	{ /* [949] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[951],
	},
	{ /* [950] */
		.type = WORD_TKN,
		.text = (char *)"type-1",
		.desc = (char *)"OSPF[6] external type 1 metric",
	},
	{ /* [951] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[949],
	},
	{ /* [952] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[948],
	},
	{ /* [953] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [954] = no_set_metric_type_cmd */ },
	{ /* [955] */
		.type = WORD_TKN,
		.text = (char *)"type-2",
		.desc = (char *)"OSPF[6] external type 2 metric",
	},
	{ /* [956] */
		.type = WORD_TKN,
		.text = (char *)"min-metric",
		.desc = (char *)"Minimum metric value for destination routing protocol",
	},
	{ /* [957] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[959],
	},
	{ /* [958] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Minimum metric value",
		.max = 4294967295,
		.varname = (char *)"min_metric",
	},
	{ /* [959] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[957],
	},
	{ /* [960] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [961] = no_set_min_metric_cmd */ },
	{ /* [962] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [963] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[967],
	},
	{ /* [964] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[966],
	},
	{ /* [965] */
		.type = WORD_TKN,
		.text = (char *)"egp",
		.desc = (char *)"remote EGP",
	},
	{ /* [966] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[964],
	},
	{ /* [967] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[963],
	},
	{ /* [968] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [969] = no_set_origin_cmd */ },
	{ /* [970] */
		.type = WORD_TKN,
		.text = (char *)"igp",
		.desc = (char *)"local IGP",
	},
	{ /* [971] */
		.type = WORD_TKN,
		.text = (char *)"incomplete",
		.desc = (char *)"unknown heritage",
	},
	{ /* [972] */
		.type = WORD_TKN,
		.text = (char *)"originator-id",
		.desc = (char *)"BGP originator ID attribute",
	},
	{ /* [973] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[975],
	},
	{ /* [974] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of originator",
		.varname = (char *)"originator_id",
	},
	{ /* [975] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[973],
	},
	{ /* [976] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [977] = no_set_originator_id_cmd */ },
	{ /* [978] */
		.type = WORD_TKN,
		.text = (char *)"sr-te",
		.desc = (char *)"SR-TE information",
	},
	{ /* [979] */
		.type = WORD_TKN,
		.text = (char *)"color",
		.desc = (char *)"SR-TE Color information",
	},
	{ /* [980] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[982],
	},
	{ /* [981] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Color of the SR-TE Policies to match with",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"color",
	},
	{ /* [982] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[980],
	},
	{ /* [983] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [984] = no_set_srte_color_cmd */ },
	{ /* [985] */
		.type = WORD_TKN,
		.text = (char *)"src",
		.desc = (char *)"Source address for route",
	},
	{ /* [986] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[990],
	},
	{ /* [987] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[989],
	},
	{ /* [988] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IPv4 address",
		.varname = (char *)"src",
	},
	{ /* [989] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[987],
	},
	{ /* [990] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[986],
	},
	{ /* [991] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [992] = no_set_src_cmd */ },
	{ /* [993] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address",
		.varname = (char *)"src",
	},
	{ /* [994] */
		.type = WORD_TKN,
		.text = (char *)"table",
		.desc = (char *)"export route to non-main kernel table",
	},
	{ /* [995] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[997],
	},
	{ /* [996] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Kernel routing table id",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"table",
	},
	{ /* [997] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[995],
	},
	{ /* [998] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [999] = no_set_table_id_cmd */ },
	{ /* [1000] */
		.type = WORD_TKN,
		.text = (char *)"tag",
		.desc = (char *)"Tag value for routing protocol",
	},
	{ /* [1001] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1005],
	},
	{ /* [1002] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1004],
	},
	{ /* [1003] */
		.type = WORD_TKN,
		.text = (char *)"untagged",
		.desc = (char *)"Untagged route",
	},
	{ /* [1004] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1002],
	},
	{ /* [1005] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1001],
	},
	{ /* [1006] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1007] = no_set_tag_cmd */ },
	{ /* [1008] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Tag value",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"tag",
	},
	{ /* [1009] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"BGP weight for routing table",
	},
	{ /* [1010] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1012],
	},
	{ /* [1011] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Weight value",
		.max = 4294967295,
		.varname = (char *)"weight",
	},
	{ /* [1012] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1010],
	},
	{ /* [1013] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1014] = no_set_weight_cmd */ },
	{ /* [1015] */
		.type = WORD_TKN,
		.text = (char *)"on-match",
		.desc = (char *)"Exit policy on matches",
	},
	{ /* [1016] */
		.type = WORD_TKN,
		.text = (char *)"goto",
		.desc = (char *)"Goto Clause number",
	},
	{ /* [1017] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"rm_num",
	},
	{ /* [1018] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1019] = rmap_onmatch_goto_cmd */ },
	{ /* [1020] */
		.type = WORD_TKN,
		.text = (char *)"next",
		.desc = (char *)"Next clause",
	},
	{ /* [1021] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1022] = rmap_onmatch_next_cmd */ },
	{ /* [1023] */
		.type = WORD_TKN,
		.text = (char *)"set",
		.desc = (char *)"Set values in destination routing protocol",
	},
	{ /* [1024] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1026],
	},
	{ /* [1025] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 information",
	},
	{ /* [1026] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1024],
	},
	{ /* [1027] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"VPN information",
	},
	{ /* [1028] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"VPN next-hop address",
	},
	{ /* [1029] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1031],
	},
	{ /* [1030] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next hop",
		.varname = (char *)"addrv4",
	},
	{ /* [1031] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1029],
	},
	{ /* [1032] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1033] = set_ipx_vpn_nexthop_cmd */ },
	{ /* [1034] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"addrv6",
	},
	{ /* [1035] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [1036] */
		.type = WORD_TKN,
		.text = (char *)"aggregator",
		.desc = (char *)"BGP aggregator attribute",
	},
	{ /* [1037] */
		.type = WORD_TKN,
		.text = (char *)"as",
		.desc = (char *)"AS number of aggregator",
	},
	{ /* [1038] */
		.type = ASNUM_TKN,
		.varname_src = 3,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format",
		.varname = (char *)"as",
	},
	{ /* [1039] */
		.type = IPV4_TKN,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of aggregator",
	},
	{ /* [1040] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1041] = set_aggregator_as_cmd */ },
	{ /* [1042] */
		.type = WORD_TKN,
		.text = (char *)"aigp-metric",
		.desc = (char *)"BGP AIGP attribute (AIGP Metric TLV)",
	},
	{ /* [1043] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1045],
	},
	{ /* [1044] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"igp-metric",
		.desc = (char *)"AIGP Metric value from IGP protocol",
		.varname = (char *)"aigp_metric",
	},
	{ /* [1045] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1043],
	},
	{ /* [1046] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1047] = set_aigp_metric_cmd */ },
	{ /* [1048] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Manual AIGP Metric value",
		.max = 4294967295,
		.varname = (char *)"aigp_metric",
	},
	{ /* [1049] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"Transform BGP AS-path attribute",
	},
	{ /* [1050] */
		.type = WORD_TKN,
		.text = (char *)"exclude",
		.desc = (char *)"Exclude from the as-path",
	},
	{ /* [1051] */
		.type = ASNUM_TKN,
		.allowrepeat = true,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format",
	},
	{ /* [1052] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1053] = set_aspath_exclude_cmd */ },
	{ /* [1054] */
		.type = WORD_TKN,
		.text = (char *)"as-path-access-list",
		.desc = (char *)"Specify an as path access list name",
	},
	{ /* [1055] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [1056] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1057] = set_aspath_exclude_access_list_cmd */ },
	{ /* [1058] */
		.type = WORD_TKN,
		.text = (char *)"prepend",
		.desc = (char *)"Prepend to the as-path",
	},
	{ /* [1059] */
		.type = ASNUM_TKN,
		.allowrepeat = true,
		.text = (char *)"ASNUM",
		.desc = (char *)"AS number in plain  <1-4294967295> or dotted <0-65535>.<0-65535> format",
	},
	{ /* [1060] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1061] = set_aspath_prepend_asn_cmd */ },
	{ /* [1062] */
		.type = WORD_TKN,
		.text = (char *)"last-as",
		.desc = (char *)"Use the last AS-number in the as-path",
	},
	{ /* [1063] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of times to insert",
		.min = 1,
		.max = 10,
		.varname = (char *)"last_as",
	},
	{ /* [1064] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1065] = set_aspath_prepend_lastas_cmd */ },
	{ /* [1066] */
		.type = WORD_TKN,
		.text = (char *)"replace",
		.desc = (char *)"Replace AS number to local or configured AS number",
	},
	{ /* [1067] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1069],
	},
	{ /* [1068] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"any",
		.desc = (char *)"Replace any AS number to local or configured AS number",
		.varname = (char *)"replace",
	},
	{ /* [1069] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1067],
	},
	{ /* [1070] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1074],
	},
	{ /* [1071] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1073],
	},
	{ /* [1072] */
		.type = ASNUM_TKN,
		.varname_src = 4,
		.text = (char *)"ASNUM",
		.desc = (char *)"Define the configured AS number",
		.varname = (char *)"configured_asn",
	},
	{ /* [1073] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1071],
	},
	{ /* [1074] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1070],
	},
	{ /* [1075] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1076] = set_aspath_replace_asn_cmd */ },
	{ /* [1077] */
		.type = ASNUM_TKN,
		.varname_src = 4,
		.text = (char *)"ASNUM",
		.desc = (char *)"Replace a specific AS number to local or configured AS number",
		.varname = (char *)"replace",
	},
	{ /* [1078] */
		.type = WORD_TKN,
		.text = (char *)"as-path-access-list",
		.desc = (char *)"Specify an as path access list name",
	},
	{ /* [1079] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access list name",
		.varname = (char *)"aspath_filter_name",
	},
	{ /* [1080] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1084],
	},
	{ /* [1081] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1083],
	},
	{ /* [1082] */
		.type = ASNUM_TKN,
		.varname_src = 4,
		.text = (char *)"ASNUM",
		.desc = (char *)"Define the configured AS number",
		.varname = (char *)"configured_asn",
	},
	{ /* [1083] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1081],
	},
	{ /* [1084] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1080],
	},
	{ /* [1085] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1086] = set_aspath_replace_access_list_cmd */ },
	{ /* [1087] */
		.type = WORD_TKN,
		.text = (char *)"atomic-aggregate",
		.desc = (char *)"BGP atomic aggregate attribute",
	},
	{ /* [1088] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1089] = set_atomic_aggregate_cmd */ },
	{ /* [1090] */
		.type = WORD_TKN,
		.text = (char *)"comm-list",
		.desc = (char *)"set BGP community list (for deletion)",
	},
	{ /* [1091] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1093],
	},
	{ /* [1092] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"comm_list",
	},
	{ /* [1093] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1091],
	},
	{ /* [1094] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching communities",
	},
	{ /* [1095] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1096] = set_community_delete_cmd */ },
	{ /* [1097] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"comm_list",
	},
	{ /* [1098] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"COMMUNITY_LIST_NAME",
		.desc = (char *)"Community-list name",
		.varname = (char *)"community_list_name",
	},
	{ /* [1099] */
		.type = WORD_TKN,
		.text = (char *)"community",
		.desc = (char *)"BGP community attribute",
	},
	{ /* [1100] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"AA:NN",
		.desc = (char *)"Community number in AA:NN format (where AA and NN are (0-65535)) or local-AS|no-advertise|no-export|graceful-shutdown|accept-own-nexthop|accept-own|route-filter-translated-v4|route-filter-v4|route-filter-translated-v6|route-filter-v6|llgr-stale|no-llgr|blackhole|no-peer or additive",
		.varname = (char *)"aa_nn",
	},
	{ /* [1101] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1102] = set_community_cmd */ },
	{ /* [1103] */
		.type = WORD_TKN,
		.text = (char *)"none",
		.desc = (char *)"No community attribute",
	},
	{ /* [1104] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1105] = set_community_none_cmd */ },
	{ /* [1106] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"BGP Administrative Distance to use",
	},
	{ /* [1107] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance value",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [1108] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1109] = set_distance_cmd */ },
	{ /* [1110] */
		.type = WORD_TKN,
		.text = (char *)"evpn",
		.desc = (char *)"Ethernet Virtual Private Network",
	},
	{ /* [1111] */
		.type = WORD_TKN,
		.text = (char *)"gateway-ip",
		.desc = (char *)"Set gateway IP for prefix advertisement route",
	},
	{ /* [1112] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 address",
	},
	{ /* [1113] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Gateway IP address in IPv4 format",
		.varname = (char *)"ipv4",
	},
	{ /* [1114] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1115] = set_evpn_gw_ip_ipv4_cmd */ },
	{ /* [1116] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 address",
	},
	{ /* [1117] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Gateway IP address in IPv6 format",
		.varname = (char *)"ipv6",
	},
	{ /* [1118] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1119] = set_evpn_gw_ip_ipv6_cmd */ },
	{ /* [1120] */
		.type = WORD_TKN,
		.text = (char *)"extcommunity",
		.desc = (char *)"BGP extended community attribute",
	},
	{ /* [1121] */
		.type = WORD_TKN,
		.text = (char *)"bandwidth",
		.desc = (char *)"Link bandwidth extended community",
	},
	{ /* [1122] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1124],
	},
	{ /* [1123] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Bandwidth value in Mbps",
		.max = 4294967295,
		.varname = (char *)"bandwidth",
	},
	{ /* [1124] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1122],
	},
	{ /* [1125] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1127],
	},
	{ /* [1126] */
		.type = WORD_TKN,
		.text = (char *)"non-transitive",
		.desc = (char *)"Attribute is set as non-transitive",
	},
	{ /* [1127] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1125],
	},
	{ /* [1128] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1129] = set_ecommunity_lb_cmd */ },
	{ /* [1130] */
		.type = WORD_TKN,
		.text = (char *)"cumulative",
		.desc = (char *)"Cumulative bandwidth of all multipaths (outbound-only)",
	},
	{ /* [1131] */
		.type = WORD_TKN,
		.text = (char *)"num-multipaths",
		.desc = (char *)"Internally computed bandwidth based on number of multipaths (outbound-only)",
	},
	{ /* [1132] */
		.type = WORD_TKN,
		.text = (char *)"color",
		.desc = (char *)"Color extended community",
	},
	{ /* [1133] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Color ID",
		.varname = (char *)"rtlist",
	},
	{ /* [1134] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1135] = set_ecommunity_color_cmd */ },
	{ /* [1136] */
		.type = WORD_TKN,
		.text = (char *)"none",
		.desc = (char *)"No extended community attribute",
	},
	{ /* [1137] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1138] = set_ecommunity_none_cmd */ },
	{ /* [1139] */
		.type = WORD_TKN,
		.text = (char *)"nt",
		.desc = (char *)"Node Target extended community",
	},
	{ /* [1140] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Node Target ID",
		.varname = (char *)"rtlist",
	},
	{ /* [1141] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1142] = set_ecommunity_nt_cmd */ },
	{ /* [1143] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Route Target extended community",
	},
	{ /* [1144] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [1145] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1146] = set_ecommunity_rt_cmd */ },
	{ /* [1147] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Site-of-Origin extended community",
	},
	{ /* [1148] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [1149] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1150] = set_ecommunity_soo_cmd */ },
	{ /* [1151] */
		.type = WORD_TKN,
		.text = (char *)"extended-comm-list",
		.desc = (char *)"set BGP extended community list (for deletion)",
	},
	{ /* [1152] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1154],
	},
	{ /* [1153] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Extended community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"extended_comm_list",
	},
	{ /* [1154] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1152],
	},
	{ /* [1155] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching extended communities",
	},
	{ /* [1156] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1157] = set_ecommunity_delete_cmd */ },
	{ /* [1158] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Extended community-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"extended_comm_list",
	},
	{ /* [1159] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"EXTCOMMUNITY_LIST_NAME",
		.desc = (char *)"Extended community-list name",
		.varname = (char *)"extcommunity_list_name",
	},
	{ /* [1160] */
		.type = WORD_TKN,
		.text = (char *)"forwarding-address",
		.desc = (char *)"Forwarding Address",
	},
	{ /* [1161] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 Address",
		.varname = (char *)"forwarding_address",
	},
	{ /* [1162] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1163] = ospf6_routemap_set_forwarding_cmd */ },
	{ /* [1164] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
	},
	{ /* [1165] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Next hop address",
	},
	{ /* [1166] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of next hop",
		.varname = (char *)"addr",
	},
	{ /* [1167] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1168] = set_ip_nexthop_cmd */ },
	{ /* [1169] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
	},
	{ /* [1170] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"IPv6 next-hop address",
	},
	{ /* [1171] */
		.type = WORD_TKN,
		.text = (char *)"global",
		.desc = (char *)"IPv6 global address",
	},
	{ /* [1172] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"global",
	},
	{ /* [1173] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1174] = set_ipv6_nexthop_global_cmd */ },
	{ /* [1175] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"IPv6 local address",
	},
	{ /* [1176] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of next hop",
		.varname = (char *)"addr",
	},
	{ /* [1177] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1178] = set_ipv6_nexthop_local_cmd */ },
	{ /* [1179] */
		.type = WORD_TKN,
		.text = (char *)"peer-address",
		.desc = (char *)"Use peer address (for BGP only)",
	},
	{ /* [1180] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1181] = set_ipv6_nexthop_peer_cmd */ },
	{ /* [1182] */
		.type = WORD_TKN,
		.text = (char *)"prefer-global",
		.desc = (char *)"Prefer global over link-local if both exist",
	},
	{ /* [1183] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1184] = set_ipv6_nexthop_prefer_global_cmd */ },
	{ /* [1185] */
		.type = WORD_TKN,
		.text = (char *)"label-index",
		.desc = (char *)"Label index to associate with the prefix",
	},
	{ /* [1186] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-1048560)",
		.desc = (char *)"Label index value",
		.max = 1048560,
		.varname = (char *)"label_index",
	},
	{ /* [1187] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1188] = set_label_index_cmd */ },
	{ /* [1189] */
		.type = WORD_TKN,
		.text = (char *)"large-comm-list",
		.desc = (char *)"set BGP large community list (for deletion)",
	},
	{ /* [1190] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1192],
	},
	{ /* [1191] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-99)",
		.desc = (char *)"Large Community-list number (standard)",
		.min = 1,
		.max = 99,
		.varname = (char *)"large_comm_list",
	},
	{ /* [1192] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1190],
	},
	{ /* [1193] */
		.type = WORD_TKN,
		.text = (char *)"delete",
		.desc = (char *)"Delete matching large communities",
	},
	{ /* [1194] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1195] = set_lcommunity_delete_cmd */ },
	{ /* [1196] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-500)",
		.desc = (char *)"Large Communitly-list number (expanded)",
		.min = 100,
		.max = 500,
		.varname = (char *)"large_comm_list",
	},
	{ /* [1197] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"LCOMMUNITY_LIST_NAME",
		.desc = (char *)"Large Community-list name",
		.varname = (char *)"lcommunity_list_name",
	},
	{ /* [1198] */
		.type = WORD_TKN,
		.text = (char *)"large-community",
		.desc = (char *)"BGP large community attribute",
	},
	{ /* [1199] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"AA:BB:CC",
		.desc = (char *)"Large Community number in aa:bb:cc format or additive",
		.varname = (char *)"aa_bb_cc",
	},
	{ /* [1200] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1201] = set_lcommunity_cmd */ },
	{ /* [1202] */
		.type = WORD_TKN,
		.text = (char *)"none",
		.desc = (char *)"No large community attribute",
	},
	{ /* [1203] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1204] = set_lcommunity_none_cmd */ },
	{ /* [1205] */
		.type = WORD_TKN,
		.text = (char *)"local-preference",
		.desc = (char *)"BGP local preference path attribute",
	},
	{ /* [1206] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Preference value (0-4294967295)",
		.varname = (char *)"local_preference",
	},
	{ /* [1207] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1208] = set_local_pref_cmd */ },
	{ /* [1209] */
		.type = WORD_TKN,
		.text = (char *)"max-metric",
		.desc = (char *)"Maximum metric value for destination routing protocol",
	},
	{ /* [1210] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1212],
	},
	{ /* [1211] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Miximum metric value",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [1212] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1210],
	},
	{ /* [1213] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1214] = set_max_metric_cmd */ },
	{ /* [1215] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric value for destination routing protocol",
	},
	{ /* [1216] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1218],
	},
	{ /* [1217] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(-4294967295-4294967295)",
		.desc = (char *)"Metric value (use +/- for additions or subtractions)",
		.min = -4294967295,
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [1218] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1216],
	},
	{ /* [1219] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1220] = set_metric_cmd */ },
	{ /* [1221] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"rtt",
		.desc = (char *)"Assign round trip time",
		.varname = (char *)"rtt",
	},
	{ /* [1222] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"+rtt",
		.desc = (char *)"Add round trip time",
		.varname = (char *)"artt",
	},
	{ /* [1223] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"-rtt",
		.desc = (char *)"Subtract round trip time",
		.varname = (char *)"srtt",
	},
	{ /* [1224] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"igp",
		.desc = (char *)"Metric value from IGP protocol",
		.varname = (char *)"igp",
	},
	{ /* [1225] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"aigp",
		.desc = (char *)"Metric value from AIGP (Accumulated IGP)",
		.varname = (char *)"aigp",
	},
	{ /* [1226] */
		.type = WORD_TKN,
		.text = (char *)"metric-type",
		.desc = (char *)"Type of metric for destination routing protocol",
	},
	{ /* [1227] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1229],
	},
	{ /* [1228] */
		.type = WORD_TKN,
		.text = (char *)"type-1",
		.desc = (char *)"OSPF[6] external type 1 metric",
	},
	{ /* [1229] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1227],
	},
	{ /* [1230] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1231] = set_metric_type_cmd */ },
	{ /* [1232] */
		.type = WORD_TKN,
		.text = (char *)"type-2",
		.desc = (char *)"OSPF[6] external type 2 metric",
	},
	{ /* [1233] */
		.type = WORD_TKN,
		.text = (char *)"min-metric",
		.desc = (char *)"Minimum metric value for destination routing protocol",
	},
	{ /* [1234] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1236],
	},
	{ /* [1235] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Minimum metric value",
		.max = 4294967295,
		.varname = (char *)"metric",
	},
	{ /* [1236] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1234],
	},
	{ /* [1237] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1238] = set_min_metric_cmd */ },
	{ /* [1239] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [1240] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1242],
	},
	{ /* [1241] */
		.type = WORD_TKN,
		.text = (char *)"egp",
		.desc = (char *)"remote EGP",
	},
	{ /* [1242] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1240],
	},
	{ /* [1243] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1244] = set_origin_cmd */ },
	{ /* [1245] */
		.type = WORD_TKN,
		.text = (char *)"igp",
		.desc = (char *)"local IGP",
	},
	{ /* [1246] */
		.type = WORD_TKN,
		.text = (char *)"incomplete",
		.desc = (char *)"unknown heritage",
	},
	{ /* [1247] */
		.type = WORD_TKN,
		.text = (char *)"originator-id",
		.desc = (char *)"BGP originator ID attribute",
	},
	{ /* [1248] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of originator",
		.varname = (char *)"originator_id",
	},
	{ /* [1249] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1250] = set_originator_id_cmd */ },
	{ /* [1251] */
		.type = WORD_TKN,
		.text = (char *)"sr-te",
		.desc = (char *)"SR-TE information",
	},
	{ /* [1252] */
		.type = WORD_TKN,
		.text = (char *)"color",
		.desc = (char *)"SR-TE Color information",
	},
	{ /* [1253] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Color of the SR-TE Policies to match with",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"color",
	},
	{ /* [1254] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1255] = set_srte_color_cmd */ },
	{ /* [1256] */
		.type = WORD_TKN,
		.text = (char *)"src",
		.desc = (char *)"src address for route",
	},
	{ /* [1257] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1259],
	},
	{ /* [1258] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IPv4 src address",
		.varname = (char *)"addrv4",
	},
	{ /* [1259] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1257],
	},
	{ /* [1260] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1261] = set_src_cmd */ },
	{ /* [1262] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 src address",
		.varname = (char *)"addrv6",
	},
	{ /* [1263] */
		.type = WORD_TKN,
		.text = (char *)"table",
		.desc = (char *)"export route to non-main kernel table",
	},
	{ /* [1264] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Kernel routing table id",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"table",
	},
	{ /* [1265] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1266] = set_table_id_cmd */ },
	{ /* [1267] */
		.type = WORD_TKN,
		.text = (char *)"tag",
		.desc = (char *)"Tag value for routing protocol",
	},
	{ /* [1268] */
		.type = FORK_TKN,
		.forkjoin = &gn_RMAP_NODE[1270],
	},
	{ /* [1269] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"untagged",
		.desc = (char *)"Untagged route",
		.varname = (char *)"untagged",
	},
	{ /* [1270] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RMAP_NODE[1268],
	},
	{ /* [1271] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1272] = set_tag_cmd */ },
	{ /* [1273] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Tag value",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"tagged",
	},
	{ /* [1274] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"BGP weight for routing table",
	},
	{ /* [1275] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"Weight value",
		.max = 4294967295,
		.varname = (char *)"weight",
	},
	{ /* [1276] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [1277] = set_weight_cmd */ },
};

extern struct cmd_element match_alias_cmd_vtysh;
extern struct cmd_element match_aspath_cmd_vtysh;
extern struct cmd_element match_community_cmd_vtysh;
extern struct cmd_element match_community_limit_cmd_vtysh;
extern struct cmd_element match_ecommunity_cmd_vtysh;
extern struct cmd_element match_evpn_default_route_cmd_vtysh;
extern struct cmd_element match_evpn_rd_cmd_vtysh;
extern struct cmd_element match_evpn_route_type_cmd_vtysh;
extern struct cmd_element match_evpn_vni_cmd_vtysh;
extern struct cmd_element match_extcommunity_limit_cmd_vtysh;
extern struct cmd_element match_interface_cmd_vtysh;
extern struct cmd_element match_ip_address_cmd_vtysh;
extern struct cmd_element match_ip_address_prefix_len_cmd_vtysh;
extern struct cmd_element match_ip_address_prefix_list_cmd_vtysh;
extern struct cmd_element match_ip_next_hop_cmd_vtysh;
extern struct cmd_element match_ip_next_hop_prefix_list_cmd_vtysh;
extern struct cmd_element match_ip_next_hop_type_cmd_vtysh;
extern struct cmd_element match_ip_nexthop_prefix_len_cmd_vtysh;
extern struct cmd_element match_ip_route_source_cmd_vtysh;
extern struct cmd_element match_ip_route_source_prefix_list_cmd_vtysh;
extern struct cmd_element match_ipv4_next_hop_cmd_vtysh;
extern struct cmd_element match_ipv6_address_cmd_vtysh;
extern struct cmd_element match_ipv6_address_prefix_len_cmd_vtysh;
extern struct cmd_element match_ipv6_address_prefix_list_cmd_vtysh;
extern struct cmd_element match_ipv6_next_hop_address_cmd_vtysh;
extern struct cmd_element match_ipv6_next_hop_cmd_vtysh;
extern struct cmd_element match_ipv6_next_hop_old_cmd_vtysh;
extern struct cmd_element match_ipv6_next_hop_prefix_list_cmd_vtysh;
extern struct cmd_element match_ipv6_next_hop_type_cmd_vtysh;
extern struct cmd_element match_lcommunity_cmd_vtysh;
extern struct cmd_element match_local_pref_cmd_vtysh;
extern struct cmd_element match_mac_address_cmd_vtysh;
extern struct cmd_element match_metric_cmd_vtysh;
extern struct cmd_element match_origin_cmd_vtysh;
extern struct cmd_element match_peer_cmd_vtysh;
extern struct cmd_element match_peer_local_cmd_vtysh;
extern struct cmd_element match_probability_cmd_vtysh;
extern struct cmd_element match_rpki_cmd_vtysh;
extern struct cmd_element match_rpki_extcommunity_cmd_vtysh;
extern struct cmd_element match_script_cmd_vtysh;
extern struct cmd_element match_source_instance_cmd_vtysh;
extern struct cmd_element match_source_protocol_cmd_vtysh;
extern struct cmd_element match_src_peer_cmd_vtysh;
extern struct cmd_element match_tag_cmd_vtysh;
extern struct cmd_element match_vrl_source_vrf_cmd_vtysh;
extern struct cmd_element no_match_alias_cmd_vtysh;
extern struct cmd_element no_match_aspath_cmd_vtysh;
extern struct cmd_element no_match_community_cmd_vtysh;
extern struct cmd_element no_match_ecommunity_cmd_vtysh;
extern struct cmd_element no_match_evpn_default_route_cmd_vtysh;
extern struct cmd_element no_match_evpn_rd_cmd_vtysh;
extern struct cmd_element no_match_evpn_route_type_cmd_vtysh;
extern struct cmd_element no_match_evpn_vni_cmd_vtysh;
extern struct cmd_element no_match_interface_cmd_vtysh;
extern struct cmd_element no_match_ip_address_cmd_vtysh;
extern struct cmd_element no_match_ip_address_prefix_len_cmd_vtysh;
extern struct cmd_element no_match_ip_address_prefix_list_cmd_vtysh;
extern struct cmd_element no_match_ip_next_hop_cmd_vtysh;
extern struct cmd_element no_match_ip_next_hop_prefix_list_cmd_vtysh;
extern struct cmd_element no_match_ip_next_hop_type_cmd_vtysh;
extern struct cmd_element no_match_ip_nexthop_prefix_len_cmd_vtysh;
extern struct cmd_element no_match_ip_route_source_cmd_vtysh;
extern struct cmd_element no_match_ip_route_source_prefix_list_cmd_vtysh;
extern struct cmd_element no_match_ipv4_next_hop_cmd_vtysh;
extern struct cmd_element no_match_ipv6_address_cmd_vtysh;
extern struct cmd_element no_match_ipv6_address_prefix_len_cmd_vtysh;
extern struct cmd_element no_match_ipv6_address_prefix_list_cmd_vtysh;
extern struct cmd_element no_match_ipv6_next_hop_address_cmd_vtysh;
extern struct cmd_element no_match_ipv6_next_hop_cmd_vtysh;
extern struct cmd_element no_match_ipv6_next_hop_old_cmd_vtysh;
extern struct cmd_element no_match_ipv6_next_hop_prefix_list_cmd_vtysh;
extern struct cmd_element no_match_ipv6_next_hop_type_cmd_vtysh;
extern struct cmd_element no_match_lcommunity_cmd_vtysh;
extern struct cmd_element no_match_local_pref_cmd_vtysh;
extern struct cmd_element no_match_mac_address_cmd_vtysh;
extern struct cmd_element no_match_metric_cmd_vtysh;
extern struct cmd_element no_match_origin_cmd_vtysh;
extern struct cmd_element no_match_peer_cmd_vtysh;
extern struct cmd_element no_match_probability_cmd_vtysh;
extern struct cmd_element no_match_rpki_cmd_vtysh;
extern struct cmd_element no_match_source_instance_cmd_vtysh;
extern struct cmd_element no_match_source_protocol_cmd_vtysh;
extern struct cmd_element no_match_src_peer_cmd_vtysh;
extern struct cmd_element no_match_tag_cmd_vtysh;
extern struct cmd_element no_match_vrl_source_vrf_cmd_vtysh;
extern struct cmd_element no_rmap_call_cmd_vtysh;
extern struct cmd_element no_rmap_continue_cmd_vtysh;
extern struct cmd_element no_rmap_description_cmd_vtysh;
extern struct cmd_element no_rmap_onmatch_goto_cmd_vtysh;
extern struct cmd_element no_rmap_onmatch_next_cmd_vtysh;
extern struct cmd_element no_route_map_match_address_cmd_vtysh;
extern struct cmd_element no_route_map_match_address_v6_cmd_vtysh;
extern struct cmd_element no_route_map_match_interface_cmd_vtysh;
extern struct cmd_element no_route_map_match_prefix_list_cmd_vtysh;
extern struct cmd_element no_route_map_match_prefix_list_v6_cmd_vtysh;
extern struct cmd_element no_set_aggregator_as_cmd_vtysh;
extern struct cmd_element no_set_aigp_metric_cmd_vtysh;
extern struct cmd_element no_set_aspath_exclude_access_list_cmd_vtysh;
extern struct cmd_element no_set_aspath_exclude_all_cmd_vtysh;
extern struct cmd_element no_set_aspath_exclude_cmd_vtysh;
extern struct cmd_element no_set_aspath_prepend_as_cmd_vtysh;
extern struct cmd_element no_set_aspath_prepend_last_as_cmd_vtysh;
extern struct cmd_element no_set_aspath_replace_access_list_cmd_vtysh;
extern struct cmd_element no_set_aspath_replace_asn_cmd_vtysh;
extern struct cmd_element no_set_atomic_aggregate_cmd_vtysh;
extern struct cmd_element no_set_community_cmd_vtysh;
extern struct cmd_element no_set_community_delete_cmd_vtysh;
extern struct cmd_element no_set_community_short_cmd_vtysh;
extern struct cmd_element no_set_distance_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_color_all_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_color_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_delete_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_lb_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_lb_short_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_none_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_nt_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_nt_short_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_rt_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_rt_short_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_soo_cmd_vtysh;
extern struct cmd_element no_set_ecommunity_soo_short_cmd_vtysh;
extern struct cmd_element no_set_evpn_gw_ip_ipv4_cmd_vtysh;
extern struct cmd_element no_set_evpn_gw_ip_ipv6_cmd_vtysh;
extern struct cmd_element no_set_ip_nexthop_cmd_vtysh;
extern struct cmd_element no_set_ipv6_nexthop_global_cmd_vtysh;
extern struct cmd_element no_set_ipv6_nexthop_local_cmd_vtysh;
extern struct cmd_element no_set_ipv6_nexthop_peer_cmd_vtysh;
extern struct cmd_element no_set_ipv6_nexthop_prefer_global_cmd_vtysh;
extern struct cmd_element no_set_ipx_vpn_nexthop_cmd_vtysh;
extern struct cmd_element no_set_label_index_cmd_vtysh;
extern struct cmd_element no_set_lcommunity1_cmd_vtysh;
extern struct cmd_element no_set_lcommunity1_short_cmd_vtysh;
extern struct cmd_element no_set_lcommunity_cmd_vtysh;
extern struct cmd_element no_set_lcommunity_delete_cmd_vtysh;
extern struct cmd_element no_set_lcommunity_delete_short_cmd_vtysh;
extern struct cmd_element no_set_local_pref_cmd_vtysh;
extern struct cmd_element no_set_max_metric_cmd_vtysh;
extern struct cmd_element no_set_metric_cmd_vtysh;
extern struct cmd_element no_set_metric_type_cmd_vtysh;
extern struct cmd_element no_set_min_metric_cmd_vtysh;
extern struct cmd_element no_set_origin_cmd_vtysh;
extern struct cmd_element no_set_originator_id_cmd_vtysh;
extern struct cmd_element no_set_src_cmd_vtysh;
extern struct cmd_element no_set_srte_color_cmd_vtysh;
extern struct cmd_element no_set_table_id_cmd_vtysh;
extern struct cmd_element no_set_tag_cmd_vtysh;
extern struct cmd_element no_set_weight_cmd_vtysh;
extern struct cmd_element ospf6_routemap_no_set_forwarding_cmd_vtysh;
extern struct cmd_element ospf6_routemap_set_forwarding_cmd_vtysh;
extern struct cmd_element rmap_call_cmd_vtysh;
extern struct cmd_element rmap_continue_cmd_vtysh;
extern struct cmd_element rmap_description_cmd_vtysh;
extern struct cmd_element rmap_onmatch_goto_cmd_vtysh;
extern struct cmd_element rmap_onmatch_next_cmd_vtysh;
extern struct cmd_element route_map_match_address_cmd_vtysh;
extern struct cmd_element route_map_match_address_v6_cmd_vtysh;
extern struct cmd_element route_map_match_interface_cmd_vtysh;
extern struct cmd_element route_map_match_prefix_list_cmd_vtysh;
extern struct cmd_element route_map_match_prefix_list_v6_cmd_vtysh;
extern struct cmd_element set_aggregator_as_cmd_vtysh;
extern struct cmd_element set_aigp_metric_cmd_vtysh;
extern struct cmd_element set_aspath_exclude_access_list_cmd_vtysh;
extern struct cmd_element set_aspath_exclude_all_cmd_vtysh;
extern struct cmd_element set_aspath_exclude_cmd_vtysh;
extern struct cmd_element set_aspath_prepend_asn_cmd_vtysh;
extern struct cmd_element set_aspath_prepend_lastas_cmd_vtysh;
extern struct cmd_element set_aspath_replace_access_list_cmd_vtysh;
extern struct cmd_element set_aspath_replace_asn_cmd_vtysh;
extern struct cmd_element set_atomic_aggregate_cmd_vtysh;
extern struct cmd_element set_community_cmd_vtysh;
extern struct cmd_element set_community_delete_cmd_vtysh;
extern struct cmd_element set_community_none_cmd_vtysh;
extern struct cmd_element set_distance_cmd_vtysh;
extern struct cmd_element set_ecommunity_color_cmd_vtysh;
extern struct cmd_element set_ecommunity_delete_cmd_vtysh;
extern struct cmd_element set_ecommunity_lb_cmd_vtysh;
extern struct cmd_element set_ecommunity_none_cmd_vtysh;
extern struct cmd_element set_ecommunity_nt_cmd_vtysh;
extern struct cmd_element set_ecommunity_rt_cmd_vtysh;
extern struct cmd_element set_ecommunity_soo_cmd_vtysh;
extern struct cmd_element set_evpn_gw_ip_ipv4_cmd_vtysh;
extern struct cmd_element set_evpn_gw_ip_ipv6_cmd_vtysh;
extern struct cmd_element set_ip_nexthop_cmd_vtysh;
extern struct cmd_element set_ip_nexthop_peer_cmd_vtysh;
extern struct cmd_element set_ip_nexthop_unchanged_cmd_vtysh;
extern struct cmd_element set_ipv6_nexthop_global_cmd_vtysh;
extern struct cmd_element set_ipv6_nexthop_local_cmd_vtysh;
extern struct cmd_element set_ipv6_nexthop_peer_cmd_vtysh;
extern struct cmd_element set_ipv6_nexthop_prefer_global_cmd_vtysh;
extern struct cmd_element set_ipx_vpn_nexthop_cmd_vtysh;
extern struct cmd_element set_l3vpn_nexthop_encapsulation_cmd_vtysh;
extern struct cmd_element set_label_index_cmd_vtysh;
extern struct cmd_element set_lcommunity_cmd_vtysh;
extern struct cmd_element set_lcommunity_delete_cmd_vtysh;
extern struct cmd_element set_lcommunity_none_cmd_vtysh;
extern struct cmd_element set_local_pref_cmd_vtysh;
extern struct cmd_element set_max_metric_cmd_vtysh;
extern struct cmd_element set_metric_cmd_vtysh;
extern struct cmd_element set_metric_type_cmd_vtysh;
extern struct cmd_element set_min_metric_cmd_vtysh;
extern struct cmd_element set_origin_cmd_vtysh;
extern struct cmd_element set_originator_id_cmd_vtysh;
extern struct cmd_element set_src_cmd_vtysh;
extern struct cmd_element set_srte_color_cmd_vtysh;
extern struct cmd_element set_table_id_cmd_vtysh;
extern struct cmd_element set_tag_cmd_vtysh;
extern struct cmd_element set_weight_cmd_vtysh;

MAKE_VECTOR(gn_RMAP_NODE_0_next, 8, &gn_RMAP_NODE[1], &gn_RMAP_NODE[89], &gn_RMAP_NODE[93], &gn_RMAP_NODE[97], &gn_RMAP_NODE[101], &gn_RMAP_NODE[347], &gn_RMAP_NODE[1015], &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1_next, 2, &gn_RMAP_NODE[2], &gn_RMAP_NODE[3]);
MAKE_VECTOR(gn_RMAP_NODE_1_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_2_next, 1, &gn_RMAP_NODE[3]);
MAKE_VECTOR(gn_RMAP_NODE_2_prev, 1, &gn_RMAP_NODE[1]);
MAKE_VECTOR(gn_RMAP_NODE_3_next, 2, &gn_RMAP_NODE[4], &gn_RMAP_NODE[69]);
MAKE_VECTOR(gn_RMAP_NODE_3_prev, 2, &gn_RMAP_NODE[2], &gn_RMAP_NODE[1]);
MAKE_VECTOR(gn_RMAP_NODE_4_next, 7, &gn_RMAP_NODE[5], &gn_RMAP_NODE[12], &gn_RMAP_NODE[19], &gn_RMAP_NODE[36], &gn_RMAP_NODE[53], &gn_RMAP_NODE[57], &gn_RMAP_NODE[65]);
MAKE_VECTOR(gn_RMAP_NODE_4_prev, 1, &gn_RMAP_NODE[3]);
MAKE_VECTOR(gn_RMAP_NODE_5_next, 1, &gn_RMAP_NODE[6]);
MAKE_VECTOR(gn_RMAP_NODE_5_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_6_next, 2, &gn_RMAP_NODE[7], &gn_RMAP_NODE[11]);
MAKE_VECTOR(gn_RMAP_NODE_6_prev, 1, &gn_RMAP_NODE[5]);
MAKE_VECTOR(gn_RMAP_NODE_7_next, 1, &gn_RMAP_NODE[8]);
MAKE_VECTOR(gn_RMAP_NODE_7_prev, 1, &gn_RMAP_NODE[6]);
MAKE_VECTOR(gn_RMAP_NODE_8_next, 1, &gn_RMAP_NODE[9]);
MAKE_VECTOR(gn_RMAP_NODE_8_prev, 2, &gn_RMAP_NODE[7], &gn_RMAP_NODE[11]);
MAKE_VECTOR(gn_RMAP_NODE_9_next, 1, &gn_RMAP_NODE[10]);
MAKE_VECTOR(gn_RMAP_NODE_9_prev, 1, &gn_RMAP_NODE[8]);
MAKE_VECTOR(gn_RMAP_NODE_10_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_10_prev, 1, &gn_RMAP_NODE[9]);
MAKE_VECTOR(gn_RMAP_NODE_11_next, 1, &gn_RMAP_NODE[8]);
MAKE_VECTOR(gn_RMAP_NODE_11_prev, 1, &gn_RMAP_NODE[6]);
MAKE_VECTOR(gn_RMAP_NODE_12_next, 1, &gn_RMAP_NODE[13]);
MAKE_VECTOR(gn_RMAP_NODE_12_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_13_next, 2, &gn_RMAP_NODE[14], &gn_RMAP_NODE[18]);
MAKE_VECTOR(gn_RMAP_NODE_13_prev, 1, &gn_RMAP_NODE[12]);
MAKE_VECTOR(gn_RMAP_NODE_14_next, 1, &gn_RMAP_NODE[15]);
MAKE_VECTOR(gn_RMAP_NODE_14_prev, 1, &gn_RMAP_NODE[13]);
MAKE_VECTOR(gn_RMAP_NODE_15_next, 1, &gn_RMAP_NODE[16]);
MAKE_VECTOR(gn_RMAP_NODE_15_prev, 2, &gn_RMAP_NODE[14], &gn_RMAP_NODE[18]);
MAKE_VECTOR(gn_RMAP_NODE_16_next, 1, &gn_RMAP_NODE[17]);
MAKE_VECTOR(gn_RMAP_NODE_16_prev, 1, &gn_RMAP_NODE[15]);
MAKE_VECTOR(gn_RMAP_NODE_17_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_17_prev, 1, &gn_RMAP_NODE[16]);
MAKE_VECTOR(gn_RMAP_NODE_18_next, 1, &gn_RMAP_NODE[15]);
MAKE_VECTOR(gn_RMAP_NODE_18_prev, 1, &gn_RMAP_NODE[13]);
MAKE_VECTOR(gn_RMAP_NODE_19_next, 2, &gn_RMAP_NODE[20], &gn_RMAP_NODE[28]);
MAKE_VECTOR(gn_RMAP_NODE_19_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_20_next, 2, &gn_RMAP_NODE[21], &gn_RMAP_NODE[26]);
MAKE_VECTOR(gn_RMAP_NODE_20_prev, 1, &gn_RMAP_NODE[19]);
MAKE_VECTOR(gn_RMAP_NODE_21_next, 1, &gn_RMAP_NODE[22]);
MAKE_VECTOR(gn_RMAP_NODE_21_prev, 1, &gn_RMAP_NODE[20]);
MAKE_VECTOR(gn_RMAP_NODE_22_next, 1, &gn_RMAP_NODE[23]);
MAKE_VECTOR(gn_RMAP_NODE_22_prev, 1, &gn_RMAP_NODE[21]);
MAKE_VECTOR(gn_RMAP_NODE_23_next, 1, &gn_RMAP_NODE[24]);
MAKE_VECTOR(gn_RMAP_NODE_23_prev, 2, &gn_RMAP_NODE[22], &gn_RMAP_NODE[27]);
MAKE_VECTOR(gn_RMAP_NODE_24_next, 1, &gn_RMAP_NODE[25]);
MAKE_VECTOR(gn_RMAP_NODE_24_prev, 1, &gn_RMAP_NODE[23]);
MAKE_VECTOR(gn_RMAP_NODE_25_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_25_prev, 1, &gn_RMAP_NODE[24]);
MAKE_VECTOR(gn_RMAP_NODE_26_next, 1, &gn_RMAP_NODE[27]);
MAKE_VECTOR(gn_RMAP_NODE_26_prev, 1, &gn_RMAP_NODE[20]);
MAKE_VECTOR(gn_RMAP_NODE_27_next, 1, &gn_RMAP_NODE[23]);
MAKE_VECTOR(gn_RMAP_NODE_27_prev, 1, &gn_RMAP_NODE[26]);
MAKE_VECTOR(gn_RMAP_NODE_28_next, 2, &gn_RMAP_NODE[29], &gn_RMAP_NODE[35]);
MAKE_VECTOR(gn_RMAP_NODE_28_prev, 1, &gn_RMAP_NODE[19]);
MAKE_VECTOR(gn_RMAP_NODE_29_next, 1, &gn_RMAP_NODE[30]);
MAKE_VECTOR(gn_RMAP_NODE_29_prev, 1, &gn_RMAP_NODE[28]);
MAKE_VECTOR(gn_RMAP_NODE_30_next, 1, &gn_RMAP_NODE[31]);
MAKE_VECTOR(gn_RMAP_NODE_30_prev, 2, &gn_RMAP_NODE[29], &gn_RMAP_NODE[35]);
MAKE_VECTOR(gn_RMAP_NODE_31_next, 1, &gn_RMAP_NODE[32]);
MAKE_VECTOR(gn_RMAP_NODE_31_prev, 1, &gn_RMAP_NODE[30]);
MAKE_VECTOR(gn_RMAP_NODE_32_next, 1, &gn_RMAP_NODE[33]);
MAKE_VECTOR(gn_RMAP_NODE_32_prev, 1, &gn_RMAP_NODE[31]);
MAKE_VECTOR(gn_RMAP_NODE_33_next, 1, &gn_RMAP_NODE[34]);
MAKE_VECTOR(gn_RMAP_NODE_33_prev, 1, &gn_RMAP_NODE[32]);
MAKE_VECTOR(gn_RMAP_NODE_34_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_34_prev, 1, &gn_RMAP_NODE[33]);
MAKE_VECTOR(gn_RMAP_NODE_35_next, 1, &gn_RMAP_NODE[30]);
MAKE_VECTOR(gn_RMAP_NODE_35_prev, 1, &gn_RMAP_NODE[28]);
MAKE_VECTOR(gn_RMAP_NODE_36_next, 2, &gn_RMAP_NODE[37], &gn_RMAP_NODE[45]);
MAKE_VECTOR(gn_RMAP_NODE_36_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_37_next, 2, &gn_RMAP_NODE[38], &gn_RMAP_NODE[43]);
MAKE_VECTOR(gn_RMAP_NODE_37_prev, 1, &gn_RMAP_NODE[36]);
MAKE_VECTOR(gn_RMAP_NODE_38_next, 1, &gn_RMAP_NODE[39]);
MAKE_VECTOR(gn_RMAP_NODE_38_prev, 1, &gn_RMAP_NODE[37]);
MAKE_VECTOR(gn_RMAP_NODE_39_next, 1, &gn_RMAP_NODE[40]);
MAKE_VECTOR(gn_RMAP_NODE_39_prev, 1, &gn_RMAP_NODE[38]);
MAKE_VECTOR(gn_RMAP_NODE_40_next, 1, &gn_RMAP_NODE[41]);
MAKE_VECTOR(gn_RMAP_NODE_40_prev, 2, &gn_RMAP_NODE[39], &gn_RMAP_NODE[44]);
MAKE_VECTOR(gn_RMAP_NODE_41_next, 1, &gn_RMAP_NODE[42]);
MAKE_VECTOR(gn_RMAP_NODE_41_prev, 1, &gn_RMAP_NODE[40]);
MAKE_VECTOR(gn_RMAP_NODE_42_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_42_prev, 1, &gn_RMAP_NODE[41]);
MAKE_VECTOR(gn_RMAP_NODE_43_next, 1, &gn_RMAP_NODE[44]);
MAKE_VECTOR(gn_RMAP_NODE_43_prev, 1, &gn_RMAP_NODE[37]);
MAKE_VECTOR(gn_RMAP_NODE_44_next, 1, &gn_RMAP_NODE[40]);
MAKE_VECTOR(gn_RMAP_NODE_44_prev, 1, &gn_RMAP_NODE[43]);
MAKE_VECTOR(gn_RMAP_NODE_45_next, 2, &gn_RMAP_NODE[46], &gn_RMAP_NODE[52]);
MAKE_VECTOR(gn_RMAP_NODE_45_prev, 1, &gn_RMAP_NODE[36]);
MAKE_VECTOR(gn_RMAP_NODE_46_next, 1, &gn_RMAP_NODE[47]);
MAKE_VECTOR(gn_RMAP_NODE_46_prev, 1, &gn_RMAP_NODE[45]);
MAKE_VECTOR(gn_RMAP_NODE_47_next, 1, &gn_RMAP_NODE[48]);
MAKE_VECTOR(gn_RMAP_NODE_47_prev, 2, &gn_RMAP_NODE[46], &gn_RMAP_NODE[52]);
MAKE_VECTOR(gn_RMAP_NODE_48_next, 1, &gn_RMAP_NODE[49]);
MAKE_VECTOR(gn_RMAP_NODE_48_prev, 1, &gn_RMAP_NODE[47]);
MAKE_VECTOR(gn_RMAP_NODE_49_next, 1, &gn_RMAP_NODE[50]);
MAKE_VECTOR(gn_RMAP_NODE_49_prev, 1, &gn_RMAP_NODE[48]);
MAKE_VECTOR(gn_RMAP_NODE_50_next, 1, &gn_RMAP_NODE[51]);
MAKE_VECTOR(gn_RMAP_NODE_50_prev, 1, &gn_RMAP_NODE[49]);
MAKE_VECTOR(gn_RMAP_NODE_51_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_51_prev, 1, &gn_RMAP_NODE[50]);
MAKE_VECTOR(gn_RMAP_NODE_52_next, 1, &gn_RMAP_NODE[47]);
MAKE_VECTOR(gn_RMAP_NODE_52_prev, 1, &gn_RMAP_NODE[45]);
MAKE_VECTOR(gn_RMAP_NODE_53_next, 1, &gn_RMAP_NODE[54]);
MAKE_VECTOR(gn_RMAP_NODE_53_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_54_next, 1, &gn_RMAP_NODE[55]);
MAKE_VECTOR(gn_RMAP_NODE_54_prev, 1, &gn_RMAP_NODE[53]);
MAKE_VECTOR(gn_RMAP_NODE_55_next, 1, &gn_RMAP_NODE[56]);
MAKE_VECTOR(gn_RMAP_NODE_55_prev, 1, &gn_RMAP_NODE[54]);
MAKE_VECTOR(gn_RMAP_NODE_56_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_56_prev, 1, &gn_RMAP_NODE[55]);
MAKE_VECTOR(gn_RMAP_NODE_57_next, 1, &gn_RMAP_NODE[58]);
MAKE_VECTOR(gn_RMAP_NODE_57_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_58_next, 3, &gn_RMAP_NODE[59], &gn_RMAP_NODE[63], &gn_RMAP_NODE[64]);
MAKE_VECTOR(gn_RMAP_NODE_58_prev, 1, &gn_RMAP_NODE[57]);
MAKE_VECTOR(gn_RMAP_NODE_59_next, 1, &gn_RMAP_NODE[60]);
MAKE_VECTOR(gn_RMAP_NODE_59_prev, 1, &gn_RMAP_NODE[58]);
MAKE_VECTOR(gn_RMAP_NODE_60_next, 1, &gn_RMAP_NODE[61]);
MAKE_VECTOR(gn_RMAP_NODE_60_prev, 3, &gn_RMAP_NODE[59], &gn_RMAP_NODE[63], &gn_RMAP_NODE[64]);
MAKE_VECTOR(gn_RMAP_NODE_61_next, 1, &gn_RMAP_NODE[62]);
MAKE_VECTOR(gn_RMAP_NODE_61_prev, 1, &gn_RMAP_NODE[60]);
MAKE_VECTOR(gn_RMAP_NODE_62_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_62_prev, 1, &gn_RMAP_NODE[61]);
MAKE_VECTOR(gn_RMAP_NODE_63_next, 1, &gn_RMAP_NODE[60]);
MAKE_VECTOR(gn_RMAP_NODE_63_prev, 1, &gn_RMAP_NODE[58]);
MAKE_VECTOR(gn_RMAP_NODE_64_next, 1, &gn_RMAP_NODE[60]);
MAKE_VECTOR(gn_RMAP_NODE_64_prev, 1, &gn_RMAP_NODE[58]);
MAKE_VECTOR(gn_RMAP_NODE_65_next, 1, &gn_RMAP_NODE[66]);
MAKE_VECTOR(gn_RMAP_NODE_65_prev, 1, &gn_RMAP_NODE[4]);
MAKE_VECTOR(gn_RMAP_NODE_66_next, 1, &gn_RMAP_NODE[67]);
MAKE_VECTOR(gn_RMAP_NODE_66_prev, 1, &gn_RMAP_NODE[65]);
MAKE_VECTOR(gn_RMAP_NODE_67_next, 1, &gn_RMAP_NODE[68]);
MAKE_VECTOR(gn_RMAP_NODE_67_prev, 1, &gn_RMAP_NODE[66]);
MAKE_VECTOR(gn_RMAP_NODE_68_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_68_prev, 1, &gn_RMAP_NODE[67]);
MAKE_VECTOR(gn_RMAP_NODE_69_next, 3, &gn_RMAP_NODE[70], &gn_RMAP_NODE[75], &gn_RMAP_NODE[83]);
MAKE_VECTOR(gn_RMAP_NODE_69_prev, 1, &gn_RMAP_NODE[3]);
MAKE_VECTOR(gn_RMAP_NODE_70_next, 1, &gn_RMAP_NODE[71]);
MAKE_VECTOR(gn_RMAP_NODE_70_prev, 1, &gn_RMAP_NODE[69]);
MAKE_VECTOR(gn_RMAP_NODE_71_next, 1, &gn_RMAP_NODE[72]);
MAKE_VECTOR(gn_RMAP_NODE_71_prev, 1, &gn_RMAP_NODE[70]);
MAKE_VECTOR(gn_RMAP_NODE_72_next, 1, &gn_RMAP_NODE[73]);
MAKE_VECTOR(gn_RMAP_NODE_72_prev, 1, &gn_RMAP_NODE[71]);
MAKE_VECTOR(gn_RMAP_NODE_73_next, 1, &gn_RMAP_NODE[74]);
MAKE_VECTOR(gn_RMAP_NODE_73_prev, 1, &gn_RMAP_NODE[72]);
MAKE_VECTOR(gn_RMAP_NODE_74_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_74_prev, 1, &gn_RMAP_NODE[73]);
MAKE_VECTOR(gn_RMAP_NODE_75_next, 1, &gn_RMAP_NODE[76]);
MAKE_VECTOR(gn_RMAP_NODE_75_prev, 1, &gn_RMAP_NODE[69]);
MAKE_VECTOR(gn_RMAP_NODE_76_next, 2, &gn_RMAP_NODE[77], &gn_RMAP_NODE[80]);
MAKE_VECTOR(gn_RMAP_NODE_76_prev, 1, &gn_RMAP_NODE[75]);
MAKE_VECTOR(gn_RMAP_NODE_77_next, 1, &gn_RMAP_NODE[78]);
MAKE_VECTOR(gn_RMAP_NODE_77_prev, 1, &gn_RMAP_NODE[76]);
MAKE_VECTOR(gn_RMAP_NODE_78_next, 1, &gn_RMAP_NODE[79]);
MAKE_VECTOR(gn_RMAP_NODE_78_prev, 1, &gn_RMAP_NODE[77]);
MAKE_VECTOR(gn_RMAP_NODE_79_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_79_prev, 1, &gn_RMAP_NODE[78]);
MAKE_VECTOR(gn_RMAP_NODE_80_next, 1, &gn_RMAP_NODE[81]);
MAKE_VECTOR(gn_RMAP_NODE_80_prev, 1, &gn_RMAP_NODE[76]);
MAKE_VECTOR(gn_RMAP_NODE_81_next, 1, &gn_RMAP_NODE[82]);
MAKE_VECTOR(gn_RMAP_NODE_81_prev, 1, &gn_RMAP_NODE[80]);
MAKE_VECTOR(gn_RMAP_NODE_82_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_82_prev, 1, &gn_RMAP_NODE[81]);
MAKE_VECTOR(gn_RMAP_NODE_83_next, 1, &gn_RMAP_NODE[84]);
MAKE_VECTOR(gn_RMAP_NODE_83_prev, 1, &gn_RMAP_NODE[69]);
MAKE_VECTOR(gn_RMAP_NODE_84_next, 1, &gn_RMAP_NODE[85]);
MAKE_VECTOR(gn_RMAP_NODE_84_prev, 1, &gn_RMAP_NODE[83]);
MAKE_VECTOR(gn_RMAP_NODE_85_next, 1, &gn_RMAP_NODE[86]);
MAKE_VECTOR(gn_RMAP_NODE_85_prev, 1, &gn_RMAP_NODE[84]);
MAKE_VECTOR(gn_RMAP_NODE_86_next, 1, &gn_RMAP_NODE[87]);
MAKE_VECTOR(gn_RMAP_NODE_86_prev, 1, &gn_RMAP_NODE[85]);
MAKE_VECTOR(gn_RMAP_NODE_87_next, 1, &gn_RMAP_NODE[88]);
MAKE_VECTOR(gn_RMAP_NODE_87_prev, 1, &gn_RMAP_NODE[86]);
MAKE_VECTOR(gn_RMAP_NODE_88_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_88_prev, 1, &gn_RMAP_NODE[87]);
MAKE_VECTOR(gn_RMAP_NODE_89_next, 1, &gn_RMAP_NODE[90]);
MAKE_VECTOR(gn_RMAP_NODE_89_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_90_next, 1, &gn_RMAP_NODE[91]);
MAKE_VECTOR(gn_RMAP_NODE_90_prev, 1, &gn_RMAP_NODE[89]);
MAKE_VECTOR(gn_RMAP_NODE_91_next, 1, &gn_RMAP_NODE[92]);
MAKE_VECTOR(gn_RMAP_NODE_91_prev, 1, &gn_RMAP_NODE[90]);
MAKE_VECTOR(gn_RMAP_NODE_92_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_92_prev, 1, &gn_RMAP_NODE[91]);
MAKE_VECTOR(gn_RMAP_NODE_93_next, 1, &gn_RMAP_NODE[94]);
MAKE_VECTOR(gn_RMAP_NODE_93_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_94_next, 1, &gn_RMAP_NODE[95]);
MAKE_VECTOR(gn_RMAP_NODE_94_prev, 1, &gn_RMAP_NODE[93]);
MAKE_VECTOR(gn_RMAP_NODE_95_next, 1, &gn_RMAP_NODE[96]);
MAKE_VECTOR(gn_RMAP_NODE_95_prev, 1, &gn_RMAP_NODE[94]);
MAKE_VECTOR(gn_RMAP_NODE_96_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_96_prev, 1, &gn_RMAP_NODE[95]);
MAKE_VECTOR(gn_RMAP_NODE_97_next, 1, &gn_RMAP_NODE[98]);
MAKE_VECTOR(gn_RMAP_NODE_97_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_98_next, 2, &gn_RMAP_NODE[98], &gn_RMAP_NODE[99]);
MAKE_VECTOR(gn_RMAP_NODE_98_prev, 2, &gn_RMAP_NODE[97], &gn_RMAP_NODE[98]);
MAKE_VECTOR(gn_RMAP_NODE_99_next, 1, &gn_RMAP_NODE[100]);
MAKE_VECTOR(gn_RMAP_NODE_99_prev, 1, &gn_RMAP_NODE[98]);
MAKE_VECTOR(gn_RMAP_NODE_100_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_100_prev, 1, &gn_RMAP_NODE[99]);
MAKE_VECTOR(gn_RMAP_NODE_101_next, 21, &gn_RMAP_NODE[102], &gn_RMAP_NODE[106], &gn_RMAP_NODE[110], &gn_RMAP_NODE[124], &gn_RMAP_NODE[151], &gn_RMAP_NODE[165], &gn_RMAP_NODE[169], &gn_RMAP_NODE[212], &gn_RMAP_NODE[246], &gn_RMAP_NODE[260], &gn_RMAP_NODE[264], &gn_RMAP_NODE[269], &gn_RMAP_NODE[273], &gn_RMAP_NODE[281], &gn_RMAP_NODE[292], &gn_RMAP_NODE[296], &gn_RMAP_NODE[304], &gn_RMAP_NODE[308], &gn_RMAP_NODE[328], &gn_RMAP_NODE[332], &gn_RMAP_NODE[340]);
MAKE_VECTOR(gn_RMAP_NODE_101_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_102_next, 1, &gn_RMAP_NODE[103]);
MAKE_VECTOR(gn_RMAP_NODE_102_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_103_next, 1, &gn_RMAP_NODE[104]);
MAKE_VECTOR(gn_RMAP_NODE_103_prev, 1, &gn_RMAP_NODE[102]);
MAKE_VECTOR(gn_RMAP_NODE_104_next, 1, &gn_RMAP_NODE[105]);
MAKE_VECTOR(gn_RMAP_NODE_104_prev, 1, &gn_RMAP_NODE[103]);
MAKE_VECTOR(gn_RMAP_NODE_105_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_105_prev, 1, &gn_RMAP_NODE[104]);
MAKE_VECTOR(gn_RMAP_NODE_106_next, 1, &gn_RMAP_NODE[107]);
MAKE_VECTOR(gn_RMAP_NODE_106_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_107_next, 1, &gn_RMAP_NODE[108]);
MAKE_VECTOR(gn_RMAP_NODE_107_prev, 1, &gn_RMAP_NODE[106]);
MAKE_VECTOR(gn_RMAP_NODE_108_next, 1, &gn_RMAP_NODE[109]);
MAKE_VECTOR(gn_RMAP_NODE_108_prev, 1, &gn_RMAP_NODE[107]);
MAKE_VECTOR(gn_RMAP_NODE_109_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_109_prev, 1, &gn_RMAP_NODE[108]);
MAKE_VECTOR(gn_RMAP_NODE_110_next, 1, &gn_RMAP_NODE[111]);
MAKE_VECTOR(gn_RMAP_NODE_110_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_111_next, 3, &gn_RMAP_NODE[112], &gn_RMAP_NODE[122], &gn_RMAP_NODE[123]);
MAKE_VECTOR(gn_RMAP_NODE_111_prev, 1, &gn_RMAP_NODE[110]);
MAKE_VECTOR(gn_RMAP_NODE_112_next, 1, &gn_RMAP_NODE[113]);
MAKE_VECTOR(gn_RMAP_NODE_112_prev, 1, &gn_RMAP_NODE[111]);
MAKE_VECTOR(gn_RMAP_NODE_113_next, 1, &gn_RMAP_NODE[114]);
MAKE_VECTOR(gn_RMAP_NODE_113_prev, 3, &gn_RMAP_NODE[112], &gn_RMAP_NODE[122], &gn_RMAP_NODE[123]);
MAKE_VECTOR(gn_RMAP_NODE_114_next, 2, &gn_RMAP_NODE[115], &gn_RMAP_NODE[118]);
MAKE_VECTOR(gn_RMAP_NODE_114_prev, 1, &gn_RMAP_NODE[113]);
MAKE_VECTOR(gn_RMAP_NODE_115_next, 2, &gn_RMAP_NODE[116], &gn_RMAP_NODE[121]);
MAKE_VECTOR(gn_RMAP_NODE_115_prev, 1, &gn_RMAP_NODE[114]);
MAKE_VECTOR(gn_RMAP_NODE_116_next, 1, &gn_RMAP_NODE[117]);
MAKE_VECTOR(gn_RMAP_NODE_116_prev, 1, &gn_RMAP_NODE[115]);
MAKE_VECTOR(gn_RMAP_NODE_117_next, 1, &gn_RMAP_NODE[118]);
MAKE_VECTOR(gn_RMAP_NODE_117_prev, 2, &gn_RMAP_NODE[116], &gn_RMAP_NODE[121]);
MAKE_VECTOR(gn_RMAP_NODE_118_next, 1, &gn_RMAP_NODE[119]);
MAKE_VECTOR(gn_RMAP_NODE_118_prev, 2, &gn_RMAP_NODE[117], &gn_RMAP_NODE[114]);
MAKE_VECTOR(gn_RMAP_NODE_119_next, 1, &gn_RMAP_NODE[120]);
MAKE_VECTOR(gn_RMAP_NODE_119_prev, 1, &gn_RMAP_NODE[118]);
MAKE_VECTOR(gn_RMAP_NODE_120_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_120_prev, 1, &gn_RMAP_NODE[119]);
MAKE_VECTOR(gn_RMAP_NODE_121_next, 1, &gn_RMAP_NODE[117]);
MAKE_VECTOR(gn_RMAP_NODE_121_prev, 1, &gn_RMAP_NODE[115]);
MAKE_VECTOR(gn_RMAP_NODE_122_next, 1, &gn_RMAP_NODE[113]);
MAKE_VECTOR(gn_RMAP_NODE_122_prev, 1, &gn_RMAP_NODE[111]);
MAKE_VECTOR(gn_RMAP_NODE_123_next, 1, &gn_RMAP_NODE[113]);
MAKE_VECTOR(gn_RMAP_NODE_123_prev, 1, &gn_RMAP_NODE[111]);
MAKE_VECTOR(gn_RMAP_NODE_124_next, 4, &gn_RMAP_NODE[125], &gn_RMAP_NODE[128], &gn_RMAP_NODE[132], &gn_RMAP_NODE[147]);
MAKE_VECTOR(gn_RMAP_NODE_124_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_125_next, 1, &gn_RMAP_NODE[126]);
MAKE_VECTOR(gn_RMAP_NODE_125_prev, 1, &gn_RMAP_NODE[124]);
MAKE_VECTOR(gn_RMAP_NODE_126_next, 1, &gn_RMAP_NODE[127]);
MAKE_VECTOR(gn_RMAP_NODE_126_prev, 1, &gn_RMAP_NODE[125]);
MAKE_VECTOR(gn_RMAP_NODE_127_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_127_prev, 1, &gn_RMAP_NODE[126]);
MAKE_VECTOR(gn_RMAP_NODE_128_next, 1, &gn_RMAP_NODE[129]);
MAKE_VECTOR(gn_RMAP_NODE_128_prev, 1, &gn_RMAP_NODE[124]);
MAKE_VECTOR(gn_RMAP_NODE_129_next, 1, &gn_RMAP_NODE[130]);
MAKE_VECTOR(gn_RMAP_NODE_129_prev, 1, &gn_RMAP_NODE[128]);
MAKE_VECTOR(gn_RMAP_NODE_130_next, 1, &gn_RMAP_NODE[131]);
MAKE_VECTOR(gn_RMAP_NODE_130_prev, 1, &gn_RMAP_NODE[129]);
MAKE_VECTOR(gn_RMAP_NODE_131_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_131_prev, 1, &gn_RMAP_NODE[130]);
MAKE_VECTOR(gn_RMAP_NODE_132_next, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_132_prev, 1, &gn_RMAP_NODE[124]);
MAKE_VECTOR(gn_RMAP_NODE_133_next, 10, &gn_RMAP_NODE[134], &gn_RMAP_NODE[138], &gn_RMAP_NODE[139], &gn_RMAP_NODE[140], &gn_RMAP_NODE[141], &gn_RMAP_NODE[142], &gn_RMAP_NODE[143], &gn_RMAP_NODE[144], &gn_RMAP_NODE[145], &gn_RMAP_NODE[146]);
MAKE_VECTOR(gn_RMAP_NODE_133_prev, 1, &gn_RMAP_NODE[132]);
MAKE_VECTOR(gn_RMAP_NODE_134_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_134_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_135_next, 1, &gn_RMAP_NODE[136]);
MAKE_VECTOR(gn_RMAP_NODE_135_prev, 10, &gn_RMAP_NODE[134], &gn_RMAP_NODE[138], &gn_RMAP_NODE[139], &gn_RMAP_NODE[140], &gn_RMAP_NODE[141], &gn_RMAP_NODE[142], &gn_RMAP_NODE[143], &gn_RMAP_NODE[144], &gn_RMAP_NODE[145], &gn_RMAP_NODE[146]);
MAKE_VECTOR(gn_RMAP_NODE_136_next, 1, &gn_RMAP_NODE[137]);
MAKE_VECTOR(gn_RMAP_NODE_136_prev, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_137_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_137_prev, 1, &gn_RMAP_NODE[136]);
MAKE_VECTOR(gn_RMAP_NODE_138_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_138_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_139_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_139_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_140_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_140_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_141_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_141_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_142_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_142_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_143_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_143_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_144_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_144_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_145_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_145_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_146_next, 1, &gn_RMAP_NODE[135]);
MAKE_VECTOR(gn_RMAP_NODE_146_prev, 1, &gn_RMAP_NODE[133]);
MAKE_VECTOR(gn_RMAP_NODE_147_next, 1, &gn_RMAP_NODE[148]);
MAKE_VECTOR(gn_RMAP_NODE_147_prev, 1, &gn_RMAP_NODE[124]);
MAKE_VECTOR(gn_RMAP_NODE_148_next, 1, &gn_RMAP_NODE[149]);
MAKE_VECTOR(gn_RMAP_NODE_148_prev, 1, &gn_RMAP_NODE[147]);
MAKE_VECTOR(gn_RMAP_NODE_149_next, 1, &gn_RMAP_NODE[150]);
MAKE_VECTOR(gn_RMAP_NODE_149_prev, 1, &gn_RMAP_NODE[148]);
MAKE_VECTOR(gn_RMAP_NODE_150_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_150_prev, 1, &gn_RMAP_NODE[149]);
MAKE_VECTOR(gn_RMAP_NODE_151_next, 1, &gn_RMAP_NODE[152]);
MAKE_VECTOR(gn_RMAP_NODE_151_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_152_next, 3, &gn_RMAP_NODE[153], &gn_RMAP_NODE[163], &gn_RMAP_NODE[164]);
MAKE_VECTOR(gn_RMAP_NODE_152_prev, 1, &gn_RMAP_NODE[151]);
MAKE_VECTOR(gn_RMAP_NODE_153_next, 1, &gn_RMAP_NODE[154]);
MAKE_VECTOR(gn_RMAP_NODE_153_prev, 1, &gn_RMAP_NODE[152]);
MAKE_VECTOR(gn_RMAP_NODE_154_next, 1, &gn_RMAP_NODE[155]);
MAKE_VECTOR(gn_RMAP_NODE_154_prev, 3, &gn_RMAP_NODE[153], &gn_RMAP_NODE[163], &gn_RMAP_NODE[164]);
MAKE_VECTOR(gn_RMAP_NODE_155_next, 2, &gn_RMAP_NODE[156], &gn_RMAP_NODE[159]);
MAKE_VECTOR(gn_RMAP_NODE_155_prev, 1, &gn_RMAP_NODE[154]);
MAKE_VECTOR(gn_RMAP_NODE_156_next, 2, &gn_RMAP_NODE[157], &gn_RMAP_NODE[162]);
MAKE_VECTOR(gn_RMAP_NODE_156_prev, 1, &gn_RMAP_NODE[155]);
MAKE_VECTOR(gn_RMAP_NODE_157_next, 1, &gn_RMAP_NODE[158]);
MAKE_VECTOR(gn_RMAP_NODE_157_prev, 1, &gn_RMAP_NODE[156]);
MAKE_VECTOR(gn_RMAP_NODE_158_next, 1, &gn_RMAP_NODE[159]);
MAKE_VECTOR(gn_RMAP_NODE_158_prev, 2, &gn_RMAP_NODE[157], &gn_RMAP_NODE[162]);
MAKE_VECTOR(gn_RMAP_NODE_159_next, 1, &gn_RMAP_NODE[160]);
MAKE_VECTOR(gn_RMAP_NODE_159_prev, 2, &gn_RMAP_NODE[158], &gn_RMAP_NODE[155]);
MAKE_VECTOR(gn_RMAP_NODE_160_next, 1, &gn_RMAP_NODE[161]);
MAKE_VECTOR(gn_RMAP_NODE_160_prev, 1, &gn_RMAP_NODE[159]);
MAKE_VECTOR(gn_RMAP_NODE_161_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_161_prev, 1, &gn_RMAP_NODE[160]);
MAKE_VECTOR(gn_RMAP_NODE_162_next, 1, &gn_RMAP_NODE[158]);
MAKE_VECTOR(gn_RMAP_NODE_162_prev, 1, &gn_RMAP_NODE[156]);
MAKE_VECTOR(gn_RMAP_NODE_163_next, 1, &gn_RMAP_NODE[154]);
MAKE_VECTOR(gn_RMAP_NODE_163_prev, 1, &gn_RMAP_NODE[152]);
MAKE_VECTOR(gn_RMAP_NODE_164_next, 1, &gn_RMAP_NODE[154]);
MAKE_VECTOR(gn_RMAP_NODE_164_prev, 1, &gn_RMAP_NODE[152]);
MAKE_VECTOR(gn_RMAP_NODE_165_next, 1, &gn_RMAP_NODE[166]);
MAKE_VECTOR(gn_RMAP_NODE_165_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_166_next, 1, &gn_RMAP_NODE[167]);
MAKE_VECTOR(gn_RMAP_NODE_166_prev, 1, &gn_RMAP_NODE[165]);
MAKE_VECTOR(gn_RMAP_NODE_167_next, 1, &gn_RMAP_NODE[168]);
MAKE_VECTOR(gn_RMAP_NODE_167_prev, 1, &gn_RMAP_NODE[166]);
MAKE_VECTOR(gn_RMAP_NODE_168_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_168_prev, 1, &gn_RMAP_NODE[167]);
MAKE_VECTOR(gn_RMAP_NODE_169_next, 3, &gn_RMAP_NODE[170], &gn_RMAP_NODE[182], &gn_RMAP_NODE[204]);
MAKE_VECTOR(gn_RMAP_NODE_169_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_170_next, 3, &gn_RMAP_NODE[171], &gn_RMAP_NODE[174], &gn_RMAP_NODE[178]);
MAKE_VECTOR(gn_RMAP_NODE_170_prev, 1, &gn_RMAP_NODE[169]);
MAKE_VECTOR(gn_RMAP_NODE_171_next, 1, &gn_RMAP_NODE[172]);
MAKE_VECTOR(gn_RMAP_NODE_171_prev, 1, &gn_RMAP_NODE[170]);
MAKE_VECTOR(gn_RMAP_NODE_172_next, 1, &gn_RMAP_NODE[173]);
MAKE_VECTOR(gn_RMAP_NODE_172_prev, 1, &gn_RMAP_NODE[171]);
MAKE_VECTOR(gn_RMAP_NODE_173_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_173_prev, 1, &gn_RMAP_NODE[172]);
MAKE_VECTOR(gn_RMAP_NODE_174_next, 1, &gn_RMAP_NODE[175]);
MAKE_VECTOR(gn_RMAP_NODE_174_prev, 1, &gn_RMAP_NODE[170]);
MAKE_VECTOR(gn_RMAP_NODE_175_next, 1, &gn_RMAP_NODE[176]);
MAKE_VECTOR(gn_RMAP_NODE_175_prev, 1, &gn_RMAP_NODE[174]);
MAKE_VECTOR(gn_RMAP_NODE_176_next, 1, &gn_RMAP_NODE[177]);
MAKE_VECTOR(gn_RMAP_NODE_176_prev, 1, &gn_RMAP_NODE[175]);
MAKE_VECTOR(gn_RMAP_NODE_177_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_177_prev, 1, &gn_RMAP_NODE[176]);
MAKE_VECTOR(gn_RMAP_NODE_178_next, 1, &gn_RMAP_NODE[179]);
MAKE_VECTOR(gn_RMAP_NODE_178_prev, 1, &gn_RMAP_NODE[170]);
MAKE_VECTOR(gn_RMAP_NODE_179_next, 1, &gn_RMAP_NODE[180]);
MAKE_VECTOR(gn_RMAP_NODE_179_prev, 1, &gn_RMAP_NODE[178]);
MAKE_VECTOR(gn_RMAP_NODE_180_next, 1, &gn_RMAP_NODE[181]);
MAKE_VECTOR(gn_RMAP_NODE_180_prev, 1, &gn_RMAP_NODE[179]);
MAKE_VECTOR(gn_RMAP_NODE_181_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_181_prev, 1, &gn_RMAP_NODE[180]);
MAKE_VECTOR(gn_RMAP_NODE_182_next, 5, &gn_RMAP_NODE[183], &gn_RMAP_NODE[186], &gn_RMAP_NODE[190], &gn_RMAP_NODE[194], &gn_RMAP_NODE[198]);
MAKE_VECTOR(gn_RMAP_NODE_182_prev, 1, &gn_RMAP_NODE[169]);
MAKE_VECTOR(gn_RMAP_NODE_183_next, 1, &gn_RMAP_NODE[184]);
MAKE_VECTOR(gn_RMAP_NODE_183_prev, 1, &gn_RMAP_NODE[182]);
MAKE_VECTOR(gn_RMAP_NODE_184_next, 1, &gn_RMAP_NODE[185]);
MAKE_VECTOR(gn_RMAP_NODE_184_prev, 1, &gn_RMAP_NODE[183]);
MAKE_VECTOR(gn_RMAP_NODE_185_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_185_prev, 1, &gn_RMAP_NODE[184]);
MAKE_VECTOR(gn_RMAP_NODE_186_next, 1, &gn_RMAP_NODE[187]);
MAKE_VECTOR(gn_RMAP_NODE_186_prev, 1, &gn_RMAP_NODE[182]);
MAKE_VECTOR(gn_RMAP_NODE_187_next, 1, &gn_RMAP_NODE[188]);
MAKE_VECTOR(gn_RMAP_NODE_187_prev, 1, &gn_RMAP_NODE[186]);
MAKE_VECTOR(gn_RMAP_NODE_188_next, 1, &gn_RMAP_NODE[189]);
MAKE_VECTOR(gn_RMAP_NODE_188_prev, 1, &gn_RMAP_NODE[187]);
MAKE_VECTOR(gn_RMAP_NODE_189_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_189_prev, 1, &gn_RMAP_NODE[188]);
MAKE_VECTOR(gn_RMAP_NODE_190_next, 1, &gn_RMAP_NODE[191]);
MAKE_VECTOR(gn_RMAP_NODE_190_prev, 1, &gn_RMAP_NODE[182]);
MAKE_VECTOR(gn_RMAP_NODE_191_next, 1, &gn_RMAP_NODE[192]);
MAKE_VECTOR(gn_RMAP_NODE_191_prev, 1, &gn_RMAP_NODE[190]);
MAKE_VECTOR(gn_RMAP_NODE_192_next, 1, &gn_RMAP_NODE[193]);
MAKE_VECTOR(gn_RMAP_NODE_192_prev, 1, &gn_RMAP_NODE[191]);
MAKE_VECTOR(gn_RMAP_NODE_193_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_193_prev, 1, &gn_RMAP_NODE[192]);
MAKE_VECTOR(gn_RMAP_NODE_194_next, 1, &gn_RMAP_NODE[195]);
MAKE_VECTOR(gn_RMAP_NODE_194_prev, 1, &gn_RMAP_NODE[182]);
MAKE_VECTOR(gn_RMAP_NODE_195_next, 1, &gn_RMAP_NODE[196]);
MAKE_VECTOR(gn_RMAP_NODE_195_prev, 1, &gn_RMAP_NODE[194]);
MAKE_VECTOR(gn_RMAP_NODE_196_next, 1, &gn_RMAP_NODE[197]);
MAKE_VECTOR(gn_RMAP_NODE_196_prev, 1, &gn_RMAP_NODE[195]);
MAKE_VECTOR(gn_RMAP_NODE_197_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_197_prev, 1, &gn_RMAP_NODE[196]);
MAKE_VECTOR(gn_RMAP_NODE_198_next, 1, &gn_RMAP_NODE[199]);
MAKE_VECTOR(gn_RMAP_NODE_198_prev, 1, &gn_RMAP_NODE[182]);
MAKE_VECTOR(gn_RMAP_NODE_199_next, 1, &gn_RMAP_NODE[200]);
MAKE_VECTOR(gn_RMAP_NODE_199_prev, 1, &gn_RMAP_NODE[198]);
MAKE_VECTOR(gn_RMAP_NODE_200_next, 1, &gn_RMAP_NODE[201]);
MAKE_VECTOR(gn_RMAP_NODE_200_prev, 1, &gn_RMAP_NODE[199]);
MAKE_VECTOR(gn_RMAP_NODE_201_next, 1, &gn_RMAP_NODE[202]);
MAKE_VECTOR(gn_RMAP_NODE_201_prev, 1, &gn_RMAP_NODE[200]);
MAKE_VECTOR(gn_RMAP_NODE_202_next, 1, &gn_RMAP_NODE[203]);
MAKE_VECTOR(gn_RMAP_NODE_202_prev, 1, &gn_RMAP_NODE[201]);
MAKE_VECTOR(gn_RMAP_NODE_203_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_203_prev, 1, &gn_RMAP_NODE[202]);
MAKE_VECTOR(gn_RMAP_NODE_204_next, 2, &gn_RMAP_NODE[205], &gn_RMAP_NODE[208]);
MAKE_VECTOR(gn_RMAP_NODE_204_prev, 1, &gn_RMAP_NODE[169]);
MAKE_VECTOR(gn_RMAP_NODE_205_next, 1, &gn_RMAP_NODE[206]);
MAKE_VECTOR(gn_RMAP_NODE_205_prev, 1, &gn_RMAP_NODE[204]);
MAKE_VECTOR(gn_RMAP_NODE_206_next, 1, &gn_RMAP_NODE[207]);
MAKE_VECTOR(gn_RMAP_NODE_206_prev, 1, &gn_RMAP_NODE[205]);
MAKE_VECTOR(gn_RMAP_NODE_207_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_207_prev, 1, &gn_RMAP_NODE[206]);
MAKE_VECTOR(gn_RMAP_NODE_208_next, 1, &gn_RMAP_NODE[209]);
MAKE_VECTOR(gn_RMAP_NODE_208_prev, 1, &gn_RMAP_NODE[204]);
MAKE_VECTOR(gn_RMAP_NODE_209_next, 1, &gn_RMAP_NODE[210]);
MAKE_VECTOR(gn_RMAP_NODE_209_prev, 1, &gn_RMAP_NODE[208]);
MAKE_VECTOR(gn_RMAP_NODE_210_next, 1, &gn_RMAP_NODE[211]);
MAKE_VECTOR(gn_RMAP_NODE_210_prev, 1, &gn_RMAP_NODE[209]);
MAKE_VECTOR(gn_RMAP_NODE_211_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_211_prev, 1, &gn_RMAP_NODE[210]);
MAKE_VECTOR(gn_RMAP_NODE_212_next, 2, &gn_RMAP_NODE[213], &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_212_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_213_next, 3, &gn_RMAP_NODE[214], &gn_RMAP_NODE[217], &gn_RMAP_NODE[221]);
MAKE_VECTOR(gn_RMAP_NODE_213_prev, 1, &gn_RMAP_NODE[212]);
MAKE_VECTOR(gn_RMAP_NODE_214_next, 1, &gn_RMAP_NODE[215]);
MAKE_VECTOR(gn_RMAP_NODE_214_prev, 1, &gn_RMAP_NODE[213]);
MAKE_VECTOR(gn_RMAP_NODE_215_next, 1, &gn_RMAP_NODE[216]);
MAKE_VECTOR(gn_RMAP_NODE_215_prev, 1, &gn_RMAP_NODE[214]);
MAKE_VECTOR(gn_RMAP_NODE_216_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_216_prev, 1, &gn_RMAP_NODE[215]);
MAKE_VECTOR(gn_RMAP_NODE_217_next, 1, &gn_RMAP_NODE[218]);
MAKE_VECTOR(gn_RMAP_NODE_217_prev, 1, &gn_RMAP_NODE[213]);
MAKE_VECTOR(gn_RMAP_NODE_218_next, 1, &gn_RMAP_NODE[219]);
MAKE_VECTOR(gn_RMAP_NODE_218_prev, 1, &gn_RMAP_NODE[217]);
MAKE_VECTOR(gn_RMAP_NODE_219_next, 1, &gn_RMAP_NODE[220]);
MAKE_VECTOR(gn_RMAP_NODE_219_prev, 1, &gn_RMAP_NODE[218]);
MAKE_VECTOR(gn_RMAP_NODE_220_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_220_prev, 1, &gn_RMAP_NODE[219]);
MAKE_VECTOR(gn_RMAP_NODE_221_next, 1, &gn_RMAP_NODE[222]);
MAKE_VECTOR(gn_RMAP_NODE_221_prev, 1, &gn_RMAP_NODE[213]);
MAKE_VECTOR(gn_RMAP_NODE_222_next, 1, &gn_RMAP_NODE[223]);
MAKE_VECTOR(gn_RMAP_NODE_222_prev, 1, &gn_RMAP_NODE[221]);
MAKE_VECTOR(gn_RMAP_NODE_223_next, 1, &gn_RMAP_NODE[224]);
MAKE_VECTOR(gn_RMAP_NODE_223_prev, 1, &gn_RMAP_NODE[222]);
MAKE_VECTOR(gn_RMAP_NODE_224_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_224_prev, 1, &gn_RMAP_NODE[223]);
MAKE_VECTOR(gn_RMAP_NODE_225_next, 5, &gn_RMAP_NODE[226], &gn_RMAP_NODE[229], &gn_RMAP_NODE[232], &gn_RMAP_NODE[236], &gn_RMAP_NODE[240]);
MAKE_VECTOR(gn_RMAP_NODE_225_prev, 1, &gn_RMAP_NODE[212]);
MAKE_VECTOR(gn_RMAP_NODE_226_next, 1, &gn_RMAP_NODE[227]);
MAKE_VECTOR(gn_RMAP_NODE_226_prev, 1, &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_227_next, 1, &gn_RMAP_NODE[228]);
MAKE_VECTOR(gn_RMAP_NODE_227_prev, 1, &gn_RMAP_NODE[226]);
MAKE_VECTOR(gn_RMAP_NODE_228_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_228_prev, 1, &gn_RMAP_NODE[227]);
MAKE_VECTOR(gn_RMAP_NODE_229_next, 1, &gn_RMAP_NODE[230]);
MAKE_VECTOR(gn_RMAP_NODE_229_prev, 1, &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_230_next, 1, &gn_RMAP_NODE[231]);
MAKE_VECTOR(gn_RMAP_NODE_230_prev, 1, &gn_RMAP_NODE[229]);
MAKE_VECTOR(gn_RMAP_NODE_231_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_231_prev, 1, &gn_RMAP_NODE[230]);
MAKE_VECTOR(gn_RMAP_NODE_232_next, 1, &gn_RMAP_NODE[233]);
MAKE_VECTOR(gn_RMAP_NODE_232_prev, 1, &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_233_next, 1, &gn_RMAP_NODE[234]);
MAKE_VECTOR(gn_RMAP_NODE_233_prev, 1, &gn_RMAP_NODE[232]);
MAKE_VECTOR(gn_RMAP_NODE_234_next, 1, &gn_RMAP_NODE[235]);
MAKE_VECTOR(gn_RMAP_NODE_234_prev, 1, &gn_RMAP_NODE[233]);
MAKE_VECTOR(gn_RMAP_NODE_235_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_235_prev, 1, &gn_RMAP_NODE[234]);
MAKE_VECTOR(gn_RMAP_NODE_236_next, 1, &gn_RMAP_NODE[237]);
MAKE_VECTOR(gn_RMAP_NODE_236_prev, 1, &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_237_next, 1, &gn_RMAP_NODE[238]);
MAKE_VECTOR(gn_RMAP_NODE_237_prev, 1, &gn_RMAP_NODE[236]);
MAKE_VECTOR(gn_RMAP_NODE_238_next, 1, &gn_RMAP_NODE[239]);
MAKE_VECTOR(gn_RMAP_NODE_238_prev, 1, &gn_RMAP_NODE[237]);
MAKE_VECTOR(gn_RMAP_NODE_239_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_239_prev, 1, &gn_RMAP_NODE[238]);
MAKE_VECTOR(gn_RMAP_NODE_240_next, 1, &gn_RMAP_NODE[241]);
MAKE_VECTOR(gn_RMAP_NODE_240_prev, 1, &gn_RMAP_NODE[225]);
MAKE_VECTOR(gn_RMAP_NODE_241_next, 1, &gn_RMAP_NODE[242]);
MAKE_VECTOR(gn_RMAP_NODE_241_prev, 1, &gn_RMAP_NODE[240]);
MAKE_VECTOR(gn_RMAP_NODE_242_next, 1, &gn_RMAP_NODE[243]);
MAKE_VECTOR(gn_RMAP_NODE_242_prev, 1, &gn_RMAP_NODE[241]);
MAKE_VECTOR(gn_RMAP_NODE_243_next, 1, &gn_RMAP_NODE[244]);
MAKE_VECTOR(gn_RMAP_NODE_243_prev, 1, &gn_RMAP_NODE[242]);
MAKE_VECTOR(gn_RMAP_NODE_244_next, 1, &gn_RMAP_NODE[245]);
MAKE_VECTOR(gn_RMAP_NODE_244_prev, 1, &gn_RMAP_NODE[243]);
MAKE_VECTOR(gn_RMAP_NODE_245_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_245_prev, 1, &gn_RMAP_NODE[244]);
MAKE_VECTOR(gn_RMAP_NODE_246_next, 1, &gn_RMAP_NODE[247]);
MAKE_VECTOR(gn_RMAP_NODE_246_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_247_next, 3, &gn_RMAP_NODE[248], &gn_RMAP_NODE[258], &gn_RMAP_NODE[259]);
MAKE_VECTOR(gn_RMAP_NODE_247_prev, 1, &gn_RMAP_NODE[246]);
MAKE_VECTOR(gn_RMAP_NODE_248_next, 1, &gn_RMAP_NODE[249]);
MAKE_VECTOR(gn_RMAP_NODE_248_prev, 1, &gn_RMAP_NODE[247]);
MAKE_VECTOR(gn_RMAP_NODE_249_next, 1, &gn_RMAP_NODE[250]);
MAKE_VECTOR(gn_RMAP_NODE_249_prev, 3, &gn_RMAP_NODE[248], &gn_RMAP_NODE[258], &gn_RMAP_NODE[259]);
MAKE_VECTOR(gn_RMAP_NODE_250_next, 2, &gn_RMAP_NODE[251], &gn_RMAP_NODE[254]);
MAKE_VECTOR(gn_RMAP_NODE_250_prev, 1, &gn_RMAP_NODE[249]);
MAKE_VECTOR(gn_RMAP_NODE_251_next, 2, &gn_RMAP_NODE[252], &gn_RMAP_NODE[257]);
MAKE_VECTOR(gn_RMAP_NODE_251_prev, 1, &gn_RMAP_NODE[250]);
MAKE_VECTOR(gn_RMAP_NODE_252_next, 1, &gn_RMAP_NODE[253]);
MAKE_VECTOR(gn_RMAP_NODE_252_prev, 1, &gn_RMAP_NODE[251]);
MAKE_VECTOR(gn_RMAP_NODE_253_next, 1, &gn_RMAP_NODE[254]);
MAKE_VECTOR(gn_RMAP_NODE_253_prev, 2, &gn_RMAP_NODE[252], &gn_RMAP_NODE[257]);
MAKE_VECTOR(gn_RMAP_NODE_254_next, 1, &gn_RMAP_NODE[255]);
MAKE_VECTOR(gn_RMAP_NODE_254_prev, 2, &gn_RMAP_NODE[253], &gn_RMAP_NODE[250]);
MAKE_VECTOR(gn_RMAP_NODE_255_next, 1, &gn_RMAP_NODE[256]);
MAKE_VECTOR(gn_RMAP_NODE_255_prev, 1, &gn_RMAP_NODE[254]);
MAKE_VECTOR(gn_RMAP_NODE_256_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_256_prev, 1, &gn_RMAP_NODE[255]);
MAKE_VECTOR(gn_RMAP_NODE_257_next, 1, &gn_RMAP_NODE[253]);
MAKE_VECTOR(gn_RMAP_NODE_257_prev, 1, &gn_RMAP_NODE[251]);
MAKE_VECTOR(gn_RMAP_NODE_258_next, 1, &gn_RMAP_NODE[249]);
MAKE_VECTOR(gn_RMAP_NODE_258_prev, 1, &gn_RMAP_NODE[247]);
MAKE_VECTOR(gn_RMAP_NODE_259_next, 1, &gn_RMAP_NODE[249]);
MAKE_VECTOR(gn_RMAP_NODE_259_prev, 1, &gn_RMAP_NODE[247]);
MAKE_VECTOR(gn_RMAP_NODE_260_next, 1, &gn_RMAP_NODE[261]);
MAKE_VECTOR(gn_RMAP_NODE_260_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_261_next, 1, &gn_RMAP_NODE[262]);
MAKE_VECTOR(gn_RMAP_NODE_261_prev, 1, &gn_RMAP_NODE[260]);
MAKE_VECTOR(gn_RMAP_NODE_262_next, 1, &gn_RMAP_NODE[263]);
MAKE_VECTOR(gn_RMAP_NODE_262_prev, 1, &gn_RMAP_NODE[261]);
MAKE_VECTOR(gn_RMAP_NODE_263_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_263_prev, 1, &gn_RMAP_NODE[262]);
MAKE_VECTOR(gn_RMAP_NODE_264_next, 1, &gn_RMAP_NODE[265]);
MAKE_VECTOR(gn_RMAP_NODE_264_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_265_next, 1, &gn_RMAP_NODE[266]);
MAKE_VECTOR(gn_RMAP_NODE_265_prev, 1, &gn_RMAP_NODE[264]);
MAKE_VECTOR(gn_RMAP_NODE_266_next, 1, &gn_RMAP_NODE[267]);
MAKE_VECTOR(gn_RMAP_NODE_266_prev, 1, &gn_RMAP_NODE[265]);
MAKE_VECTOR(gn_RMAP_NODE_267_next, 1, &gn_RMAP_NODE[268]);
MAKE_VECTOR(gn_RMAP_NODE_267_prev, 1, &gn_RMAP_NODE[266]);
MAKE_VECTOR(gn_RMAP_NODE_268_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_268_prev, 1, &gn_RMAP_NODE[267]);
MAKE_VECTOR(gn_RMAP_NODE_269_next, 1, &gn_RMAP_NODE[270]);
MAKE_VECTOR(gn_RMAP_NODE_269_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_270_next, 1, &gn_RMAP_NODE[271]);
MAKE_VECTOR(gn_RMAP_NODE_270_prev, 1, &gn_RMAP_NODE[269]);
MAKE_VECTOR(gn_RMAP_NODE_271_next, 1, &gn_RMAP_NODE[272]);
MAKE_VECTOR(gn_RMAP_NODE_271_prev, 1, &gn_RMAP_NODE[270]);
MAKE_VECTOR(gn_RMAP_NODE_272_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_272_prev, 1, &gn_RMAP_NODE[271]);
MAKE_VECTOR(gn_RMAP_NODE_273_next, 1, &gn_RMAP_NODE[274]);
MAKE_VECTOR(gn_RMAP_NODE_273_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_274_next, 3, &gn_RMAP_NODE[275], &gn_RMAP_NODE[279], &gn_RMAP_NODE[280]);
MAKE_VECTOR(gn_RMAP_NODE_274_prev, 1, &gn_RMAP_NODE[273]);
MAKE_VECTOR(gn_RMAP_NODE_275_next, 1, &gn_RMAP_NODE[276]);
MAKE_VECTOR(gn_RMAP_NODE_275_prev, 1, &gn_RMAP_NODE[274]);
MAKE_VECTOR(gn_RMAP_NODE_276_next, 1, &gn_RMAP_NODE[277]);
MAKE_VECTOR(gn_RMAP_NODE_276_prev, 3, &gn_RMAP_NODE[275], &gn_RMAP_NODE[279], &gn_RMAP_NODE[280]);
MAKE_VECTOR(gn_RMAP_NODE_277_next, 1, &gn_RMAP_NODE[278]);
MAKE_VECTOR(gn_RMAP_NODE_277_prev, 1, &gn_RMAP_NODE[276]);
MAKE_VECTOR(gn_RMAP_NODE_278_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_278_prev, 1, &gn_RMAP_NODE[277]);
MAKE_VECTOR(gn_RMAP_NODE_279_next, 1, &gn_RMAP_NODE[276]);
MAKE_VECTOR(gn_RMAP_NODE_279_prev, 1, &gn_RMAP_NODE[274]);
MAKE_VECTOR(gn_RMAP_NODE_280_next, 1, &gn_RMAP_NODE[276]);
MAKE_VECTOR(gn_RMAP_NODE_280_prev, 1, &gn_RMAP_NODE[274]);
MAKE_VECTOR(gn_RMAP_NODE_281_next, 2, &gn_RMAP_NODE[282], &gn_RMAP_NODE[289]);
MAKE_VECTOR(gn_RMAP_NODE_281_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_282_next, 3, &gn_RMAP_NODE[283], &gn_RMAP_NODE[287], &gn_RMAP_NODE[288]);
MAKE_VECTOR(gn_RMAP_NODE_282_prev, 1, &gn_RMAP_NODE[281]);
MAKE_VECTOR(gn_RMAP_NODE_283_next, 1, &gn_RMAP_NODE[284]);
MAKE_VECTOR(gn_RMAP_NODE_283_prev, 1, &gn_RMAP_NODE[282]);
MAKE_VECTOR(gn_RMAP_NODE_284_next, 1, &gn_RMAP_NODE[285]);
MAKE_VECTOR(gn_RMAP_NODE_284_prev, 3, &gn_RMAP_NODE[283], &gn_RMAP_NODE[287], &gn_RMAP_NODE[288]);
MAKE_VECTOR(gn_RMAP_NODE_285_next, 1, &gn_RMAP_NODE[286]);
MAKE_VECTOR(gn_RMAP_NODE_285_prev, 1, &gn_RMAP_NODE[284]);
MAKE_VECTOR(gn_RMAP_NODE_286_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_286_prev, 1, &gn_RMAP_NODE[285]);
MAKE_VECTOR(gn_RMAP_NODE_287_next, 1, &gn_RMAP_NODE[284]);
MAKE_VECTOR(gn_RMAP_NODE_287_prev, 1, &gn_RMAP_NODE[282]);
MAKE_VECTOR(gn_RMAP_NODE_288_next, 1, &gn_RMAP_NODE[284]);
MAKE_VECTOR(gn_RMAP_NODE_288_prev, 1, &gn_RMAP_NODE[282]);
MAKE_VECTOR(gn_RMAP_NODE_289_next, 1, &gn_RMAP_NODE[290]);
MAKE_VECTOR(gn_RMAP_NODE_289_prev, 1, &gn_RMAP_NODE[281]);
MAKE_VECTOR(gn_RMAP_NODE_290_next, 1, &gn_RMAP_NODE[291]);
MAKE_VECTOR(gn_RMAP_NODE_290_prev, 1, &gn_RMAP_NODE[289]);
MAKE_VECTOR(gn_RMAP_NODE_291_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_291_prev, 1, &gn_RMAP_NODE[290]);
MAKE_VECTOR(gn_RMAP_NODE_292_next, 1, &gn_RMAP_NODE[293]);
MAKE_VECTOR(gn_RMAP_NODE_292_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_293_next, 1, &gn_RMAP_NODE[294]);
MAKE_VECTOR(gn_RMAP_NODE_293_prev, 1, &gn_RMAP_NODE[292]);
MAKE_VECTOR(gn_RMAP_NODE_294_next, 1, &gn_RMAP_NODE[295]);
MAKE_VECTOR(gn_RMAP_NODE_294_prev, 1, &gn_RMAP_NODE[293]);
MAKE_VECTOR(gn_RMAP_NODE_295_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_295_prev, 1, &gn_RMAP_NODE[294]);
MAKE_VECTOR(gn_RMAP_NODE_296_next, 1, &gn_RMAP_NODE[297]);
MAKE_VECTOR(gn_RMAP_NODE_296_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_297_next, 3, &gn_RMAP_NODE[298], &gn_RMAP_NODE[302], &gn_RMAP_NODE[303]);
MAKE_VECTOR(gn_RMAP_NODE_297_prev, 1, &gn_RMAP_NODE[296]);
MAKE_VECTOR(gn_RMAP_NODE_298_next, 1, &gn_RMAP_NODE[299]);
MAKE_VECTOR(gn_RMAP_NODE_298_prev, 1, &gn_RMAP_NODE[297]);
MAKE_VECTOR(gn_RMAP_NODE_299_next, 1, &gn_RMAP_NODE[300]);
MAKE_VECTOR(gn_RMAP_NODE_299_prev, 3, &gn_RMAP_NODE[298], &gn_RMAP_NODE[302], &gn_RMAP_NODE[303]);
MAKE_VECTOR(gn_RMAP_NODE_300_next, 1, &gn_RMAP_NODE[301]);
MAKE_VECTOR(gn_RMAP_NODE_300_prev, 1, &gn_RMAP_NODE[299]);
MAKE_VECTOR(gn_RMAP_NODE_301_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_301_prev, 1, &gn_RMAP_NODE[300]);
MAKE_VECTOR(gn_RMAP_NODE_302_next, 1, &gn_RMAP_NODE[299]);
MAKE_VECTOR(gn_RMAP_NODE_302_prev, 1, &gn_RMAP_NODE[297]);
MAKE_VECTOR(gn_RMAP_NODE_303_next, 1, &gn_RMAP_NODE[299]);
MAKE_VECTOR(gn_RMAP_NODE_303_prev, 1, &gn_RMAP_NODE[297]);
MAKE_VECTOR(gn_RMAP_NODE_304_next, 1, &gn_RMAP_NODE[305]);
MAKE_VECTOR(gn_RMAP_NODE_304_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_305_next, 1, &gn_RMAP_NODE[306]);
MAKE_VECTOR(gn_RMAP_NODE_305_prev, 1, &gn_RMAP_NODE[304]);
MAKE_VECTOR(gn_RMAP_NODE_306_next, 1, &gn_RMAP_NODE[307]);
MAKE_VECTOR(gn_RMAP_NODE_306_prev, 1, &gn_RMAP_NODE[305]);
MAKE_VECTOR(gn_RMAP_NODE_307_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_307_prev, 1, &gn_RMAP_NODE[306]);
MAKE_VECTOR(gn_RMAP_NODE_308_next, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_308_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_309_next, 15, &gn_RMAP_NODE[310], &gn_RMAP_NODE[314], &gn_RMAP_NODE[315], &gn_RMAP_NODE[316], &gn_RMAP_NODE[317], &gn_RMAP_NODE[318], &gn_RMAP_NODE[319], &gn_RMAP_NODE[320], &gn_RMAP_NODE[321], &gn_RMAP_NODE[322], &gn_RMAP_NODE[323], &gn_RMAP_NODE[324], &gn_RMAP_NODE[325], &gn_RMAP_NODE[326], &gn_RMAP_NODE[327]);
MAKE_VECTOR(gn_RMAP_NODE_309_prev, 1, &gn_RMAP_NODE[308]);
MAKE_VECTOR(gn_RMAP_NODE_310_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_310_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_311_next, 1, &gn_RMAP_NODE[312]);
MAKE_VECTOR(gn_RMAP_NODE_311_prev, 15, &gn_RMAP_NODE[310], &gn_RMAP_NODE[314], &gn_RMAP_NODE[315], &gn_RMAP_NODE[316], &gn_RMAP_NODE[317], &gn_RMAP_NODE[318], &gn_RMAP_NODE[319], &gn_RMAP_NODE[320], &gn_RMAP_NODE[321], &gn_RMAP_NODE[322], &gn_RMAP_NODE[323], &gn_RMAP_NODE[324], &gn_RMAP_NODE[325], &gn_RMAP_NODE[326], &gn_RMAP_NODE[327]);
MAKE_VECTOR(gn_RMAP_NODE_312_next, 1, &gn_RMAP_NODE[313]);
MAKE_VECTOR(gn_RMAP_NODE_312_prev, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_313_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_313_prev, 1, &gn_RMAP_NODE[312]);
MAKE_VECTOR(gn_RMAP_NODE_314_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_314_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_315_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_315_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_316_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_316_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_317_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_317_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_318_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_318_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_319_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_319_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_320_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_320_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_321_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_321_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_322_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_322_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_323_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_323_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_324_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_324_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_325_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_325_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_326_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_326_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_327_next, 1, &gn_RMAP_NODE[311]);
MAKE_VECTOR(gn_RMAP_NODE_327_prev, 1, &gn_RMAP_NODE[309]);
MAKE_VECTOR(gn_RMAP_NODE_328_next, 1, &gn_RMAP_NODE[329]);
MAKE_VECTOR(gn_RMAP_NODE_328_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_329_next, 1, &gn_RMAP_NODE[330]);
MAKE_VECTOR(gn_RMAP_NODE_329_prev, 1, &gn_RMAP_NODE[328]);
MAKE_VECTOR(gn_RMAP_NODE_330_next, 1, &gn_RMAP_NODE[331]);
MAKE_VECTOR(gn_RMAP_NODE_330_prev, 1, &gn_RMAP_NODE[329]);
MAKE_VECTOR(gn_RMAP_NODE_331_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_331_prev, 1, &gn_RMAP_NODE[330]);
MAKE_VECTOR(gn_RMAP_NODE_332_next, 1, &gn_RMAP_NODE[333]);
MAKE_VECTOR(gn_RMAP_NODE_332_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_333_next, 3, &gn_RMAP_NODE[334], &gn_RMAP_NODE[338], &gn_RMAP_NODE[339]);
MAKE_VECTOR(gn_RMAP_NODE_333_prev, 1, &gn_RMAP_NODE[332]);
MAKE_VECTOR(gn_RMAP_NODE_334_next, 1, &gn_RMAP_NODE[335]);
MAKE_VECTOR(gn_RMAP_NODE_334_prev, 1, &gn_RMAP_NODE[333]);
MAKE_VECTOR(gn_RMAP_NODE_335_next, 1, &gn_RMAP_NODE[336]);
MAKE_VECTOR(gn_RMAP_NODE_335_prev, 3, &gn_RMAP_NODE[334], &gn_RMAP_NODE[338], &gn_RMAP_NODE[339]);
MAKE_VECTOR(gn_RMAP_NODE_336_next, 1, &gn_RMAP_NODE[337]);
MAKE_VECTOR(gn_RMAP_NODE_336_prev, 1, &gn_RMAP_NODE[335]);
MAKE_VECTOR(gn_RMAP_NODE_337_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_337_prev, 1, &gn_RMAP_NODE[336]);
MAKE_VECTOR(gn_RMAP_NODE_338_next, 1, &gn_RMAP_NODE[335]);
MAKE_VECTOR(gn_RMAP_NODE_338_prev, 1, &gn_RMAP_NODE[333]);
MAKE_VECTOR(gn_RMAP_NODE_339_next, 1, &gn_RMAP_NODE[335]);
MAKE_VECTOR(gn_RMAP_NODE_339_prev, 1, &gn_RMAP_NODE[333]);
MAKE_VECTOR(gn_RMAP_NODE_340_next, 1, &gn_RMAP_NODE[341]);
MAKE_VECTOR(gn_RMAP_NODE_340_prev, 1, &gn_RMAP_NODE[101]);
MAKE_VECTOR(gn_RMAP_NODE_341_next, 2, &gn_RMAP_NODE[342], &gn_RMAP_NODE[346]);
MAKE_VECTOR(gn_RMAP_NODE_341_prev, 1, &gn_RMAP_NODE[340]);
MAKE_VECTOR(gn_RMAP_NODE_342_next, 1, &gn_RMAP_NODE[343]);
MAKE_VECTOR(gn_RMAP_NODE_342_prev, 1, &gn_RMAP_NODE[341]);
MAKE_VECTOR(gn_RMAP_NODE_343_next, 1, &gn_RMAP_NODE[344]);
MAKE_VECTOR(gn_RMAP_NODE_343_prev, 2, &gn_RMAP_NODE[342], &gn_RMAP_NODE[346]);
MAKE_VECTOR(gn_RMAP_NODE_344_next, 1, &gn_RMAP_NODE[345]);
MAKE_VECTOR(gn_RMAP_NODE_344_prev, 1, &gn_RMAP_NODE[343]);
MAKE_VECTOR(gn_RMAP_NODE_345_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_345_prev, 1, &gn_RMAP_NODE[344]);
MAKE_VECTOR(gn_RMAP_NODE_346_next, 1, &gn_RMAP_NODE[343]);
MAKE_VECTOR(gn_RMAP_NODE_346_prev, 1, &gn_RMAP_NODE[341]);
MAKE_VECTOR(gn_RMAP_NODE_347_next, 6, &gn_RMAP_NODE[348], &gn_RMAP_NODE[354], &gn_RMAP_NODE[360], &gn_RMAP_NODE[363], &gn_RMAP_NODE[690], &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_347_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_348_next, 1, &gn_RMAP_NODE[349]);
MAKE_VECTOR(gn_RMAP_NODE_348_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_349_next, 2, &gn_RMAP_NODE[350], &gn_RMAP_NODE[351]);
MAKE_VECTOR(gn_RMAP_NODE_349_prev, 1, &gn_RMAP_NODE[348]);
MAKE_VECTOR(gn_RMAP_NODE_350_next, 1, &gn_RMAP_NODE[351]);
MAKE_VECTOR(gn_RMAP_NODE_350_prev, 1, &gn_RMAP_NODE[349]);
MAKE_VECTOR(gn_RMAP_NODE_351_next, 1, &gn_RMAP_NODE[352]);
MAKE_VECTOR(gn_RMAP_NODE_351_prev, 2, &gn_RMAP_NODE[350], &gn_RMAP_NODE[349]);
MAKE_VECTOR(gn_RMAP_NODE_352_next, 1, &gn_RMAP_NODE[353]);
MAKE_VECTOR(gn_RMAP_NODE_352_prev, 1, &gn_RMAP_NODE[351]);
MAKE_VECTOR(gn_RMAP_NODE_353_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_353_prev, 1, &gn_RMAP_NODE[352]);
MAKE_VECTOR(gn_RMAP_NODE_354_next, 1, &gn_RMAP_NODE[355]);
MAKE_VECTOR(gn_RMAP_NODE_354_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_355_next, 2, &gn_RMAP_NODE[356], &gn_RMAP_NODE[357]);
MAKE_VECTOR(gn_RMAP_NODE_355_prev, 1, &gn_RMAP_NODE[354]);
MAKE_VECTOR(gn_RMAP_NODE_356_next, 1, &gn_RMAP_NODE[357]);
MAKE_VECTOR(gn_RMAP_NODE_356_prev, 1, &gn_RMAP_NODE[355]);
MAKE_VECTOR(gn_RMAP_NODE_357_next, 1, &gn_RMAP_NODE[358]);
MAKE_VECTOR(gn_RMAP_NODE_357_prev, 2, &gn_RMAP_NODE[356], &gn_RMAP_NODE[355]);
MAKE_VECTOR(gn_RMAP_NODE_358_next, 1, &gn_RMAP_NODE[359]);
MAKE_VECTOR(gn_RMAP_NODE_358_prev, 1, &gn_RMAP_NODE[357]);
MAKE_VECTOR(gn_RMAP_NODE_359_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_359_prev, 1, &gn_RMAP_NODE[358]);
MAKE_VECTOR(gn_RMAP_NODE_360_next, 1, &gn_RMAP_NODE[361]);
MAKE_VECTOR(gn_RMAP_NODE_360_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_361_next, 1, &gn_RMAP_NODE[362]);
MAKE_VECTOR(gn_RMAP_NODE_361_prev, 1, &gn_RMAP_NODE[360]);
MAKE_VECTOR(gn_RMAP_NODE_362_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_362_prev, 1, &gn_RMAP_NODE[361]);
MAKE_VECTOR(gn_RMAP_NODE_363_next, 22, &gn_RMAP_NODE[364], &gn_RMAP_NODE[370], &gn_RMAP_NODE[376], &gn_RMAP_NODE[392], &gn_RMAP_NODE[419], &gn_RMAP_NODE[435], &gn_RMAP_NODE[441], &gn_RMAP_NODE[513], &gn_RMAP_NODE[568], &gn_RMAP_NODE[584], &gn_RMAP_NODE[590], &gn_RMAP_NODE[595], &gn_RMAP_NODE[601], &gn_RMAP_NODE[604], &gn_RMAP_NODE[614], &gn_RMAP_NODE[625], &gn_RMAP_NODE[631], &gn_RMAP_NODE[639], &gn_RMAP_NODE[645], &gn_RMAP_NODE[667], &gn_RMAP_NODE[671], &gn_RMAP_NODE[681]);
MAKE_VECTOR(gn_RMAP_NODE_363_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_364_next, 1, &gn_RMAP_NODE[365]);
MAKE_VECTOR(gn_RMAP_NODE_364_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_365_next, 2, &gn_RMAP_NODE[366], &gn_RMAP_NODE[367]);
MAKE_VECTOR(gn_RMAP_NODE_365_prev, 1, &gn_RMAP_NODE[364]);
MAKE_VECTOR(gn_RMAP_NODE_366_next, 1, &gn_RMAP_NODE[367]);
MAKE_VECTOR(gn_RMAP_NODE_366_prev, 1, &gn_RMAP_NODE[365]);
MAKE_VECTOR(gn_RMAP_NODE_367_next, 1, &gn_RMAP_NODE[368]);
MAKE_VECTOR(gn_RMAP_NODE_367_prev, 2, &gn_RMAP_NODE[366], &gn_RMAP_NODE[365]);
MAKE_VECTOR(gn_RMAP_NODE_368_next, 1, &gn_RMAP_NODE[369]);
MAKE_VECTOR(gn_RMAP_NODE_368_prev, 1, &gn_RMAP_NODE[367]);
MAKE_VECTOR(gn_RMAP_NODE_369_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_369_prev, 1, &gn_RMAP_NODE[368]);
MAKE_VECTOR(gn_RMAP_NODE_370_next, 1, &gn_RMAP_NODE[371]);
MAKE_VECTOR(gn_RMAP_NODE_370_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_371_next, 2, &gn_RMAP_NODE[372], &gn_RMAP_NODE[373]);
MAKE_VECTOR(gn_RMAP_NODE_371_prev, 1, &gn_RMAP_NODE[370]);
MAKE_VECTOR(gn_RMAP_NODE_372_next, 1, &gn_RMAP_NODE[373]);
MAKE_VECTOR(gn_RMAP_NODE_372_prev, 1, &gn_RMAP_NODE[371]);
MAKE_VECTOR(gn_RMAP_NODE_373_next, 1, &gn_RMAP_NODE[374]);
MAKE_VECTOR(gn_RMAP_NODE_373_prev, 2, &gn_RMAP_NODE[372], &gn_RMAP_NODE[371]);
MAKE_VECTOR(gn_RMAP_NODE_374_next, 1, &gn_RMAP_NODE[375]);
MAKE_VECTOR(gn_RMAP_NODE_374_prev, 1, &gn_RMAP_NODE[373]);
MAKE_VECTOR(gn_RMAP_NODE_375_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_375_prev, 1, &gn_RMAP_NODE[374]);
MAKE_VECTOR(gn_RMAP_NODE_376_next, 1, &gn_RMAP_NODE[377]);
MAKE_VECTOR(gn_RMAP_NODE_376_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_377_next, 2, &gn_RMAP_NODE[378], &gn_RMAP_NODE[386]);
MAKE_VECTOR(gn_RMAP_NODE_377_prev, 1, &gn_RMAP_NODE[376]);
MAKE_VECTOR(gn_RMAP_NODE_378_next, 3, &gn_RMAP_NODE[379], &gn_RMAP_NODE[390], &gn_RMAP_NODE[391]);
MAKE_VECTOR(gn_RMAP_NODE_378_prev, 1, &gn_RMAP_NODE[377]);
MAKE_VECTOR(gn_RMAP_NODE_379_next, 1, &gn_RMAP_NODE[380]);
MAKE_VECTOR(gn_RMAP_NODE_379_prev, 1, &gn_RMAP_NODE[378]);
MAKE_VECTOR(gn_RMAP_NODE_380_next, 1, &gn_RMAP_NODE[381]);
MAKE_VECTOR(gn_RMAP_NODE_380_prev, 3, &gn_RMAP_NODE[379], &gn_RMAP_NODE[390], &gn_RMAP_NODE[391]);
MAKE_VECTOR(gn_RMAP_NODE_381_next, 2, &gn_RMAP_NODE[382], &gn_RMAP_NODE[385]);
MAKE_VECTOR(gn_RMAP_NODE_381_prev, 1, &gn_RMAP_NODE[380]);
MAKE_VECTOR(gn_RMAP_NODE_382_next, 2, &gn_RMAP_NODE[383], &gn_RMAP_NODE[389]);
MAKE_VECTOR(gn_RMAP_NODE_382_prev, 1, &gn_RMAP_NODE[381]);
MAKE_VECTOR(gn_RMAP_NODE_383_next, 1, &gn_RMAP_NODE[384]);
MAKE_VECTOR(gn_RMAP_NODE_383_prev, 1, &gn_RMAP_NODE[382]);
MAKE_VECTOR(gn_RMAP_NODE_384_next, 1, &gn_RMAP_NODE[385]);
MAKE_VECTOR(gn_RMAP_NODE_384_prev, 2, &gn_RMAP_NODE[383], &gn_RMAP_NODE[389]);
MAKE_VECTOR(gn_RMAP_NODE_385_next, 1, &gn_RMAP_NODE[386]);
MAKE_VECTOR(gn_RMAP_NODE_385_prev, 2, &gn_RMAP_NODE[384], &gn_RMAP_NODE[381]);
MAKE_VECTOR(gn_RMAP_NODE_386_next, 1, &gn_RMAP_NODE[387]);
MAKE_VECTOR(gn_RMAP_NODE_386_prev, 2, &gn_RMAP_NODE[385], &gn_RMAP_NODE[377]);
MAKE_VECTOR(gn_RMAP_NODE_387_next, 1, &gn_RMAP_NODE[388]);
MAKE_VECTOR(gn_RMAP_NODE_387_prev, 1, &gn_RMAP_NODE[386]);
MAKE_VECTOR(gn_RMAP_NODE_388_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_388_prev, 1, &gn_RMAP_NODE[387]);
MAKE_VECTOR(gn_RMAP_NODE_389_next, 1, &gn_RMAP_NODE[384]);
MAKE_VECTOR(gn_RMAP_NODE_389_prev, 1, &gn_RMAP_NODE[382]);
MAKE_VECTOR(gn_RMAP_NODE_390_next, 1, &gn_RMAP_NODE[380]);
MAKE_VECTOR(gn_RMAP_NODE_390_prev, 1, &gn_RMAP_NODE[378]);
MAKE_VECTOR(gn_RMAP_NODE_391_next, 1, &gn_RMAP_NODE[380]);
MAKE_VECTOR(gn_RMAP_NODE_391_prev, 1, &gn_RMAP_NODE[378]);
MAKE_VECTOR(gn_RMAP_NODE_392_next, 4, &gn_RMAP_NODE[393], &gn_RMAP_NODE[396], &gn_RMAP_NODE[400], &gn_RMAP_NODE[415]);
MAKE_VECTOR(gn_RMAP_NODE_392_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_393_next, 1, &gn_RMAP_NODE[394]);
MAKE_VECTOR(gn_RMAP_NODE_393_prev, 1, &gn_RMAP_NODE[392]);
MAKE_VECTOR(gn_RMAP_NODE_394_next, 1, &gn_RMAP_NODE[395]);
MAKE_VECTOR(gn_RMAP_NODE_394_prev, 1, &gn_RMAP_NODE[393]);
MAKE_VECTOR(gn_RMAP_NODE_395_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_395_prev, 1, &gn_RMAP_NODE[394]);
MAKE_VECTOR(gn_RMAP_NODE_396_next, 1, &gn_RMAP_NODE[397]);
MAKE_VECTOR(gn_RMAP_NODE_396_prev, 1, &gn_RMAP_NODE[392]);
MAKE_VECTOR(gn_RMAP_NODE_397_next, 1, &gn_RMAP_NODE[398]);
MAKE_VECTOR(gn_RMAP_NODE_397_prev, 1, &gn_RMAP_NODE[396]);
MAKE_VECTOR(gn_RMAP_NODE_398_next, 1, &gn_RMAP_NODE[399]);
MAKE_VECTOR(gn_RMAP_NODE_398_prev, 1, &gn_RMAP_NODE[397]);
MAKE_VECTOR(gn_RMAP_NODE_399_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_399_prev, 1, &gn_RMAP_NODE[398]);
MAKE_VECTOR(gn_RMAP_NODE_400_next, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_400_prev, 1, &gn_RMAP_NODE[392]);
MAKE_VECTOR(gn_RMAP_NODE_401_next, 10, &gn_RMAP_NODE[402], &gn_RMAP_NODE[406], &gn_RMAP_NODE[407], &gn_RMAP_NODE[408], &gn_RMAP_NODE[409], &gn_RMAP_NODE[410], &gn_RMAP_NODE[411], &gn_RMAP_NODE[412], &gn_RMAP_NODE[413], &gn_RMAP_NODE[414]);
MAKE_VECTOR(gn_RMAP_NODE_401_prev, 1, &gn_RMAP_NODE[400]);
MAKE_VECTOR(gn_RMAP_NODE_402_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_402_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_403_next, 1, &gn_RMAP_NODE[404]);
MAKE_VECTOR(gn_RMAP_NODE_403_prev, 10, &gn_RMAP_NODE[402], &gn_RMAP_NODE[406], &gn_RMAP_NODE[407], &gn_RMAP_NODE[408], &gn_RMAP_NODE[409], &gn_RMAP_NODE[410], &gn_RMAP_NODE[411], &gn_RMAP_NODE[412], &gn_RMAP_NODE[413], &gn_RMAP_NODE[414]);
MAKE_VECTOR(gn_RMAP_NODE_404_next, 1, &gn_RMAP_NODE[405]);
MAKE_VECTOR(gn_RMAP_NODE_404_prev, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_405_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_405_prev, 1, &gn_RMAP_NODE[404]);
MAKE_VECTOR(gn_RMAP_NODE_406_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_406_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_407_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_407_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_408_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_408_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_409_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_409_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_410_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_410_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_411_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_411_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_412_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_412_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_413_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_413_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_414_next, 1, &gn_RMAP_NODE[403]);
MAKE_VECTOR(gn_RMAP_NODE_414_prev, 1, &gn_RMAP_NODE[401]);
MAKE_VECTOR(gn_RMAP_NODE_415_next, 1, &gn_RMAP_NODE[416]);
MAKE_VECTOR(gn_RMAP_NODE_415_prev, 1, &gn_RMAP_NODE[392]);
MAKE_VECTOR(gn_RMAP_NODE_416_next, 1, &gn_RMAP_NODE[417]);
MAKE_VECTOR(gn_RMAP_NODE_416_prev, 1, &gn_RMAP_NODE[415]);
MAKE_VECTOR(gn_RMAP_NODE_417_next, 1, &gn_RMAP_NODE[418]);
MAKE_VECTOR(gn_RMAP_NODE_417_prev, 1, &gn_RMAP_NODE[416]);
MAKE_VECTOR(gn_RMAP_NODE_418_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_418_prev, 1, &gn_RMAP_NODE[417]);
MAKE_VECTOR(gn_RMAP_NODE_419_next, 1, &gn_RMAP_NODE[420]);
MAKE_VECTOR(gn_RMAP_NODE_419_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_420_next, 2, &gn_RMAP_NODE[421], &gn_RMAP_NODE[429]);
MAKE_VECTOR(gn_RMAP_NODE_420_prev, 1, &gn_RMAP_NODE[419]);
MAKE_VECTOR(gn_RMAP_NODE_421_next, 3, &gn_RMAP_NODE[422], &gn_RMAP_NODE[433], &gn_RMAP_NODE[434]);
MAKE_VECTOR(gn_RMAP_NODE_421_prev, 1, &gn_RMAP_NODE[420]);
MAKE_VECTOR(gn_RMAP_NODE_422_next, 1, &gn_RMAP_NODE[423]);
MAKE_VECTOR(gn_RMAP_NODE_422_prev, 1, &gn_RMAP_NODE[421]);
MAKE_VECTOR(gn_RMAP_NODE_423_next, 1, &gn_RMAP_NODE[424]);
MAKE_VECTOR(gn_RMAP_NODE_423_prev, 3, &gn_RMAP_NODE[422], &gn_RMAP_NODE[433], &gn_RMAP_NODE[434]);
MAKE_VECTOR(gn_RMAP_NODE_424_next, 2, &gn_RMAP_NODE[425], &gn_RMAP_NODE[428]);
MAKE_VECTOR(gn_RMAP_NODE_424_prev, 1, &gn_RMAP_NODE[423]);
MAKE_VECTOR(gn_RMAP_NODE_425_next, 2, &gn_RMAP_NODE[426], &gn_RMAP_NODE[432]);
MAKE_VECTOR(gn_RMAP_NODE_425_prev, 1, &gn_RMAP_NODE[424]);
MAKE_VECTOR(gn_RMAP_NODE_426_next, 1, &gn_RMAP_NODE[427]);
MAKE_VECTOR(gn_RMAP_NODE_426_prev, 1, &gn_RMAP_NODE[425]);
MAKE_VECTOR(gn_RMAP_NODE_427_next, 1, &gn_RMAP_NODE[428]);
MAKE_VECTOR(gn_RMAP_NODE_427_prev, 2, &gn_RMAP_NODE[426], &gn_RMAP_NODE[432]);
MAKE_VECTOR(gn_RMAP_NODE_428_next, 1, &gn_RMAP_NODE[429]);
MAKE_VECTOR(gn_RMAP_NODE_428_prev, 2, &gn_RMAP_NODE[427], &gn_RMAP_NODE[424]);
MAKE_VECTOR(gn_RMAP_NODE_429_next, 1, &gn_RMAP_NODE[430]);
MAKE_VECTOR(gn_RMAP_NODE_429_prev, 2, &gn_RMAP_NODE[428], &gn_RMAP_NODE[420]);
MAKE_VECTOR(gn_RMAP_NODE_430_next, 1, &gn_RMAP_NODE[431]);
MAKE_VECTOR(gn_RMAP_NODE_430_prev, 1, &gn_RMAP_NODE[429]);
MAKE_VECTOR(gn_RMAP_NODE_431_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_431_prev, 1, &gn_RMAP_NODE[430]);
MAKE_VECTOR(gn_RMAP_NODE_432_next, 1, &gn_RMAP_NODE[427]);
MAKE_VECTOR(gn_RMAP_NODE_432_prev, 1, &gn_RMAP_NODE[425]);
MAKE_VECTOR(gn_RMAP_NODE_433_next, 1, &gn_RMAP_NODE[423]);
MAKE_VECTOR(gn_RMAP_NODE_433_prev, 1, &gn_RMAP_NODE[421]);
MAKE_VECTOR(gn_RMAP_NODE_434_next, 1, &gn_RMAP_NODE[423]);
MAKE_VECTOR(gn_RMAP_NODE_434_prev, 1, &gn_RMAP_NODE[421]);
MAKE_VECTOR(gn_RMAP_NODE_435_next, 1, &gn_RMAP_NODE[436]);
MAKE_VECTOR(gn_RMAP_NODE_435_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_436_next, 2, &gn_RMAP_NODE[437], &gn_RMAP_NODE[438]);
MAKE_VECTOR(gn_RMAP_NODE_436_prev, 1, &gn_RMAP_NODE[435]);
MAKE_VECTOR(gn_RMAP_NODE_437_next, 1, &gn_RMAP_NODE[438]);
MAKE_VECTOR(gn_RMAP_NODE_437_prev, 1, &gn_RMAP_NODE[436]);
MAKE_VECTOR(gn_RMAP_NODE_438_next, 1, &gn_RMAP_NODE[439]);
MAKE_VECTOR(gn_RMAP_NODE_438_prev, 2, &gn_RMAP_NODE[437], &gn_RMAP_NODE[436]);
MAKE_VECTOR(gn_RMAP_NODE_439_next, 1, &gn_RMAP_NODE[440]);
MAKE_VECTOR(gn_RMAP_NODE_439_prev, 1, &gn_RMAP_NODE[438]);
MAKE_VECTOR(gn_RMAP_NODE_440_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_440_prev, 1, &gn_RMAP_NODE[439]);
MAKE_VECTOR(gn_RMAP_NODE_441_next, 4, &gn_RMAP_NODE[442], &gn_RMAP_NODE[451], &gn_RMAP_NODE[469], &gn_RMAP_NODE[501]);
MAKE_VECTOR(gn_RMAP_NODE_441_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_442_next, 2, &gn_RMAP_NODE[443], &gn_RMAP_NODE[447]);
MAKE_VECTOR(gn_RMAP_NODE_442_prev, 1, &gn_RMAP_NODE[441]);
MAKE_VECTOR(gn_RMAP_NODE_443_next, 1, &gn_RMAP_NODE[444]);
MAKE_VECTOR(gn_RMAP_NODE_443_prev, 1, &gn_RMAP_NODE[442]);
MAKE_VECTOR(gn_RMAP_NODE_444_next, 2, &gn_RMAP_NODE[445], &gn_RMAP_NODE[448]);
MAKE_VECTOR(gn_RMAP_NODE_444_prev, 2, &gn_RMAP_NODE[443], &gn_RMAP_NODE[447]);
MAKE_VECTOR(gn_RMAP_NODE_445_next, 1, &gn_RMAP_NODE[446]);
MAKE_VECTOR(gn_RMAP_NODE_445_prev, 1, &gn_RMAP_NODE[444]);
MAKE_VECTOR(gn_RMAP_NODE_446_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_446_prev, 1, &gn_RMAP_NODE[445]);
MAKE_VECTOR(gn_RMAP_NODE_447_next, 1, &gn_RMAP_NODE[444]);
MAKE_VECTOR(gn_RMAP_NODE_447_prev, 1, &gn_RMAP_NODE[442]);
MAKE_VECTOR(gn_RMAP_NODE_448_next, 1, &gn_RMAP_NODE[449]);
MAKE_VECTOR(gn_RMAP_NODE_448_prev, 1, &gn_RMAP_NODE[444]);
MAKE_VECTOR(gn_RMAP_NODE_449_next, 1, &gn_RMAP_NODE[450]);
MAKE_VECTOR(gn_RMAP_NODE_449_prev, 1, &gn_RMAP_NODE[448]);
MAKE_VECTOR(gn_RMAP_NODE_450_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_450_prev, 1, &gn_RMAP_NODE[449]);
MAKE_VECTOR(gn_RMAP_NODE_451_next, 3, &gn_RMAP_NODE[452], &gn_RMAP_NODE[457], &gn_RMAP_NODE[463]);
MAKE_VECTOR(gn_RMAP_NODE_451_prev, 1, &gn_RMAP_NODE[441]);
MAKE_VECTOR(gn_RMAP_NODE_452_next, 2, &gn_RMAP_NODE[453], &gn_RMAP_NODE[454]);
MAKE_VECTOR(gn_RMAP_NODE_452_prev, 1, &gn_RMAP_NODE[451]);
MAKE_VECTOR(gn_RMAP_NODE_453_next, 1, &gn_RMAP_NODE[454]);
MAKE_VECTOR(gn_RMAP_NODE_453_prev, 1, &gn_RMAP_NODE[452]);
MAKE_VECTOR(gn_RMAP_NODE_454_next, 1, &gn_RMAP_NODE[455]);
MAKE_VECTOR(gn_RMAP_NODE_454_prev, 2, &gn_RMAP_NODE[453], &gn_RMAP_NODE[452]);
MAKE_VECTOR(gn_RMAP_NODE_455_next, 1, &gn_RMAP_NODE[456]);
MAKE_VECTOR(gn_RMAP_NODE_455_prev, 1, &gn_RMAP_NODE[454]);
MAKE_VECTOR(gn_RMAP_NODE_456_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_456_prev, 1, &gn_RMAP_NODE[455]);
MAKE_VECTOR(gn_RMAP_NODE_457_next, 1, &gn_RMAP_NODE[458]);
MAKE_VECTOR(gn_RMAP_NODE_457_prev, 1, &gn_RMAP_NODE[451]);
MAKE_VECTOR(gn_RMAP_NODE_458_next, 2, &gn_RMAP_NODE[459], &gn_RMAP_NODE[460]);
MAKE_VECTOR(gn_RMAP_NODE_458_prev, 1, &gn_RMAP_NODE[457]);
MAKE_VECTOR(gn_RMAP_NODE_459_next, 1, &gn_RMAP_NODE[460]);
MAKE_VECTOR(gn_RMAP_NODE_459_prev, 1, &gn_RMAP_NODE[458]);
MAKE_VECTOR(gn_RMAP_NODE_460_next, 1, &gn_RMAP_NODE[461]);
MAKE_VECTOR(gn_RMAP_NODE_460_prev, 2, &gn_RMAP_NODE[459], &gn_RMAP_NODE[458]);
MAKE_VECTOR(gn_RMAP_NODE_461_next, 1, &gn_RMAP_NODE[462]);
MAKE_VECTOR(gn_RMAP_NODE_461_prev, 1, &gn_RMAP_NODE[460]);
MAKE_VECTOR(gn_RMAP_NODE_462_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_462_prev, 1, &gn_RMAP_NODE[461]);
MAKE_VECTOR(gn_RMAP_NODE_463_next, 1, &gn_RMAP_NODE[464]);
MAKE_VECTOR(gn_RMAP_NODE_463_prev, 1, &gn_RMAP_NODE[451]);
MAKE_VECTOR(gn_RMAP_NODE_464_next, 2, &gn_RMAP_NODE[465], &gn_RMAP_NODE[466]);
MAKE_VECTOR(gn_RMAP_NODE_464_prev, 1, &gn_RMAP_NODE[463]);
MAKE_VECTOR(gn_RMAP_NODE_465_next, 1, &gn_RMAP_NODE[466]);
MAKE_VECTOR(gn_RMAP_NODE_465_prev, 1, &gn_RMAP_NODE[464]);
MAKE_VECTOR(gn_RMAP_NODE_466_next, 1, &gn_RMAP_NODE[467]);
MAKE_VECTOR(gn_RMAP_NODE_466_prev, 2, &gn_RMAP_NODE[465], &gn_RMAP_NODE[464]);
MAKE_VECTOR(gn_RMAP_NODE_467_next, 1, &gn_RMAP_NODE[468]);
MAKE_VECTOR(gn_RMAP_NODE_467_prev, 1, &gn_RMAP_NODE[466]);
MAKE_VECTOR(gn_RMAP_NODE_468_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_468_prev, 1, &gn_RMAP_NODE[467]);
MAKE_VECTOR(gn_RMAP_NODE_469_next, 5, &gn_RMAP_NODE[470], &gn_RMAP_NODE[475], &gn_RMAP_NODE[481], &gn_RMAP_NODE[487], &gn_RMAP_NODE[493]);
MAKE_VECTOR(gn_RMAP_NODE_469_prev, 1, &gn_RMAP_NODE[441]);
MAKE_VECTOR(gn_RMAP_NODE_470_next, 2, &gn_RMAP_NODE[471], &gn_RMAP_NODE[472]);
MAKE_VECTOR(gn_RMAP_NODE_470_prev, 1, &gn_RMAP_NODE[469]);
MAKE_VECTOR(gn_RMAP_NODE_471_next, 1, &gn_RMAP_NODE[472]);
MAKE_VECTOR(gn_RMAP_NODE_471_prev, 1, &gn_RMAP_NODE[470]);
MAKE_VECTOR(gn_RMAP_NODE_472_next, 1, &gn_RMAP_NODE[473]);
MAKE_VECTOR(gn_RMAP_NODE_472_prev, 2, &gn_RMAP_NODE[471], &gn_RMAP_NODE[470]);
MAKE_VECTOR(gn_RMAP_NODE_473_next, 1, &gn_RMAP_NODE[474]);
MAKE_VECTOR(gn_RMAP_NODE_473_prev, 1, &gn_RMAP_NODE[472]);
MAKE_VECTOR(gn_RMAP_NODE_474_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_474_prev, 1, &gn_RMAP_NODE[473]);
MAKE_VECTOR(gn_RMAP_NODE_475_next, 1, &gn_RMAP_NODE[476]);
MAKE_VECTOR(gn_RMAP_NODE_475_prev, 1, &gn_RMAP_NODE[469]);
MAKE_VECTOR(gn_RMAP_NODE_476_next, 2, &gn_RMAP_NODE[477], &gn_RMAP_NODE[478]);
MAKE_VECTOR(gn_RMAP_NODE_476_prev, 1, &gn_RMAP_NODE[475]);
MAKE_VECTOR(gn_RMAP_NODE_477_next, 1, &gn_RMAP_NODE[478]);
MAKE_VECTOR(gn_RMAP_NODE_477_prev, 1, &gn_RMAP_NODE[476]);
MAKE_VECTOR(gn_RMAP_NODE_478_next, 1, &gn_RMAP_NODE[479]);
MAKE_VECTOR(gn_RMAP_NODE_478_prev, 2, &gn_RMAP_NODE[477], &gn_RMAP_NODE[476]);
MAKE_VECTOR(gn_RMAP_NODE_479_next, 1, &gn_RMAP_NODE[480]);
MAKE_VECTOR(gn_RMAP_NODE_479_prev, 1, &gn_RMAP_NODE[478]);
MAKE_VECTOR(gn_RMAP_NODE_480_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_480_prev, 1, &gn_RMAP_NODE[479]);
MAKE_VECTOR(gn_RMAP_NODE_481_next, 1, &gn_RMAP_NODE[482]);
MAKE_VECTOR(gn_RMAP_NODE_481_prev, 1, &gn_RMAP_NODE[469]);
MAKE_VECTOR(gn_RMAP_NODE_482_next, 2, &gn_RMAP_NODE[483], &gn_RMAP_NODE[484]);
MAKE_VECTOR(gn_RMAP_NODE_482_prev, 1, &gn_RMAP_NODE[481]);
MAKE_VECTOR(gn_RMAP_NODE_483_next, 1, &gn_RMAP_NODE[484]);
MAKE_VECTOR(gn_RMAP_NODE_483_prev, 1, &gn_RMAP_NODE[482]);
MAKE_VECTOR(gn_RMAP_NODE_484_next, 1, &gn_RMAP_NODE[485]);
MAKE_VECTOR(gn_RMAP_NODE_484_prev, 2, &gn_RMAP_NODE[483], &gn_RMAP_NODE[482]);
MAKE_VECTOR(gn_RMAP_NODE_485_next, 1, &gn_RMAP_NODE[486]);
MAKE_VECTOR(gn_RMAP_NODE_485_prev, 1, &gn_RMAP_NODE[484]);
MAKE_VECTOR(gn_RMAP_NODE_486_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_486_prev, 1, &gn_RMAP_NODE[485]);
MAKE_VECTOR(gn_RMAP_NODE_487_next, 1, &gn_RMAP_NODE[488]);
MAKE_VECTOR(gn_RMAP_NODE_487_prev, 1, &gn_RMAP_NODE[469]);
MAKE_VECTOR(gn_RMAP_NODE_488_next, 2, &gn_RMAP_NODE[489], &gn_RMAP_NODE[490]);
MAKE_VECTOR(gn_RMAP_NODE_488_prev, 1, &gn_RMAP_NODE[487]);
MAKE_VECTOR(gn_RMAP_NODE_489_next, 1, &gn_RMAP_NODE[490]);
MAKE_VECTOR(gn_RMAP_NODE_489_prev, 1, &gn_RMAP_NODE[488]);
MAKE_VECTOR(gn_RMAP_NODE_490_next, 1, &gn_RMAP_NODE[491]);
MAKE_VECTOR(gn_RMAP_NODE_490_prev, 2, &gn_RMAP_NODE[489], &gn_RMAP_NODE[488]);
MAKE_VECTOR(gn_RMAP_NODE_491_next, 1, &gn_RMAP_NODE[492]);
MAKE_VECTOR(gn_RMAP_NODE_491_prev, 1, &gn_RMAP_NODE[490]);
MAKE_VECTOR(gn_RMAP_NODE_492_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_492_prev, 1, &gn_RMAP_NODE[491]);
MAKE_VECTOR(gn_RMAP_NODE_493_next, 1, &gn_RMAP_NODE[494]);
MAKE_VECTOR(gn_RMAP_NODE_493_prev, 1, &gn_RMAP_NODE[469]);
MAKE_VECTOR(gn_RMAP_NODE_494_next, 2, &gn_RMAP_NODE[495], &gn_RMAP_NODE[498]);
MAKE_VECTOR(gn_RMAP_NODE_494_prev, 1, &gn_RMAP_NODE[493]);
MAKE_VECTOR(gn_RMAP_NODE_495_next, 1, &gn_RMAP_NODE[496]);
MAKE_VECTOR(gn_RMAP_NODE_495_prev, 1, &gn_RMAP_NODE[494]);
MAKE_VECTOR(gn_RMAP_NODE_496_next, 1, &gn_RMAP_NODE[497]);
MAKE_VECTOR(gn_RMAP_NODE_496_prev, 1, &gn_RMAP_NODE[495]);
MAKE_VECTOR(gn_RMAP_NODE_497_next, 1, &gn_RMAP_NODE[498]);
MAKE_VECTOR(gn_RMAP_NODE_497_prev, 1, &gn_RMAP_NODE[496]);
MAKE_VECTOR(gn_RMAP_NODE_498_next, 1, &gn_RMAP_NODE[499]);
MAKE_VECTOR(gn_RMAP_NODE_498_prev, 2, &gn_RMAP_NODE[497], &gn_RMAP_NODE[494]);
MAKE_VECTOR(gn_RMAP_NODE_499_next, 1, &gn_RMAP_NODE[500]);
MAKE_VECTOR(gn_RMAP_NODE_499_prev, 1, &gn_RMAP_NODE[498]);
MAKE_VECTOR(gn_RMAP_NODE_500_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_500_prev, 1, &gn_RMAP_NODE[499]);
MAKE_VECTOR(gn_RMAP_NODE_501_next, 2, &gn_RMAP_NODE[502], &gn_RMAP_NODE[507]);
MAKE_VECTOR(gn_RMAP_NODE_501_prev, 1, &gn_RMAP_NODE[441]);
MAKE_VECTOR(gn_RMAP_NODE_502_next, 2, &gn_RMAP_NODE[503], &gn_RMAP_NODE[504]);
MAKE_VECTOR(gn_RMAP_NODE_502_prev, 1, &gn_RMAP_NODE[501]);
MAKE_VECTOR(gn_RMAP_NODE_503_next, 1, &gn_RMAP_NODE[504]);
MAKE_VECTOR(gn_RMAP_NODE_503_prev, 1, &gn_RMAP_NODE[502]);
MAKE_VECTOR(gn_RMAP_NODE_504_next, 1, &gn_RMAP_NODE[505]);
MAKE_VECTOR(gn_RMAP_NODE_504_prev, 2, &gn_RMAP_NODE[503], &gn_RMAP_NODE[502]);
MAKE_VECTOR(gn_RMAP_NODE_505_next, 1, &gn_RMAP_NODE[506]);
MAKE_VECTOR(gn_RMAP_NODE_505_prev, 1, &gn_RMAP_NODE[504]);
MAKE_VECTOR(gn_RMAP_NODE_506_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_506_prev, 1, &gn_RMAP_NODE[505]);
MAKE_VECTOR(gn_RMAP_NODE_507_next, 1, &gn_RMAP_NODE[508]);
MAKE_VECTOR(gn_RMAP_NODE_507_prev, 1, &gn_RMAP_NODE[501]);
MAKE_VECTOR(gn_RMAP_NODE_508_next, 2, &gn_RMAP_NODE[509], &gn_RMAP_NODE[510]);
MAKE_VECTOR(gn_RMAP_NODE_508_prev, 1, &gn_RMAP_NODE[507]);
MAKE_VECTOR(gn_RMAP_NODE_509_next, 1, &gn_RMAP_NODE[510]);
MAKE_VECTOR(gn_RMAP_NODE_509_prev, 1, &gn_RMAP_NODE[508]);
MAKE_VECTOR(gn_RMAP_NODE_510_next, 1, &gn_RMAP_NODE[511]);
MAKE_VECTOR(gn_RMAP_NODE_510_prev, 2, &gn_RMAP_NODE[509], &gn_RMAP_NODE[508]);
MAKE_VECTOR(gn_RMAP_NODE_511_next, 1, &gn_RMAP_NODE[512]);
MAKE_VECTOR(gn_RMAP_NODE_511_prev, 1, &gn_RMAP_NODE[510]);
MAKE_VECTOR(gn_RMAP_NODE_512_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_512_prev, 1, &gn_RMAP_NODE[511]);
MAKE_VECTOR(gn_RMAP_NODE_513_next, 3, &gn_RMAP_NODE[514], &gn_RMAP_NODE[523], &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_513_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_514_next, 2, &gn_RMAP_NODE[515], &gn_RMAP_NODE[519]);
MAKE_VECTOR(gn_RMAP_NODE_514_prev, 1, &gn_RMAP_NODE[513]);
MAKE_VECTOR(gn_RMAP_NODE_515_next, 1, &gn_RMAP_NODE[516]);
MAKE_VECTOR(gn_RMAP_NODE_515_prev, 1, &gn_RMAP_NODE[514]);
MAKE_VECTOR(gn_RMAP_NODE_516_next, 2, &gn_RMAP_NODE[517], &gn_RMAP_NODE[520]);
MAKE_VECTOR(gn_RMAP_NODE_516_prev, 2, &gn_RMAP_NODE[515], &gn_RMAP_NODE[519]);
MAKE_VECTOR(gn_RMAP_NODE_517_next, 1, &gn_RMAP_NODE[518]);
MAKE_VECTOR(gn_RMAP_NODE_517_prev, 1, &gn_RMAP_NODE[516]);
MAKE_VECTOR(gn_RMAP_NODE_518_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_518_prev, 1, &gn_RMAP_NODE[517]);
MAKE_VECTOR(gn_RMAP_NODE_519_next, 1, &gn_RMAP_NODE[516]);
MAKE_VECTOR(gn_RMAP_NODE_519_prev, 1, &gn_RMAP_NODE[514]);
MAKE_VECTOR(gn_RMAP_NODE_520_next, 1, &gn_RMAP_NODE[521]);
MAKE_VECTOR(gn_RMAP_NODE_520_prev, 1, &gn_RMAP_NODE[516]);
MAKE_VECTOR(gn_RMAP_NODE_521_next, 1, &gn_RMAP_NODE[522]);
MAKE_VECTOR(gn_RMAP_NODE_521_prev, 1, &gn_RMAP_NODE[520]);
MAKE_VECTOR(gn_RMAP_NODE_522_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_522_prev, 1, &gn_RMAP_NODE[521]);
MAKE_VECTOR(gn_RMAP_NODE_523_next, 3, &gn_RMAP_NODE[524], &gn_RMAP_NODE[529], &gn_RMAP_NODE[535]);
MAKE_VECTOR(gn_RMAP_NODE_523_prev, 1, &gn_RMAP_NODE[513]);
MAKE_VECTOR(gn_RMAP_NODE_524_next, 2, &gn_RMAP_NODE[525], &gn_RMAP_NODE[526]);
MAKE_VECTOR(gn_RMAP_NODE_524_prev, 1, &gn_RMAP_NODE[523]);
MAKE_VECTOR(gn_RMAP_NODE_525_next, 1, &gn_RMAP_NODE[526]);
MAKE_VECTOR(gn_RMAP_NODE_525_prev, 1, &gn_RMAP_NODE[524]);
MAKE_VECTOR(gn_RMAP_NODE_526_next, 1, &gn_RMAP_NODE[527]);
MAKE_VECTOR(gn_RMAP_NODE_526_prev, 2, &gn_RMAP_NODE[525], &gn_RMAP_NODE[524]);
MAKE_VECTOR(gn_RMAP_NODE_527_next, 1, &gn_RMAP_NODE[528]);
MAKE_VECTOR(gn_RMAP_NODE_527_prev, 1, &gn_RMAP_NODE[526]);
MAKE_VECTOR(gn_RMAP_NODE_528_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_528_prev, 1, &gn_RMAP_NODE[527]);
MAKE_VECTOR(gn_RMAP_NODE_529_next, 1, &gn_RMAP_NODE[530]);
MAKE_VECTOR(gn_RMAP_NODE_529_prev, 1, &gn_RMAP_NODE[523]);
MAKE_VECTOR(gn_RMAP_NODE_530_next, 2, &gn_RMAP_NODE[531], &gn_RMAP_NODE[532]);
MAKE_VECTOR(gn_RMAP_NODE_530_prev, 1, &gn_RMAP_NODE[529]);
MAKE_VECTOR(gn_RMAP_NODE_531_next, 1, &gn_RMAP_NODE[532]);
MAKE_VECTOR(gn_RMAP_NODE_531_prev, 1, &gn_RMAP_NODE[530]);
MAKE_VECTOR(gn_RMAP_NODE_532_next, 1, &gn_RMAP_NODE[533]);
MAKE_VECTOR(gn_RMAP_NODE_532_prev, 2, &gn_RMAP_NODE[531], &gn_RMAP_NODE[530]);
MAKE_VECTOR(gn_RMAP_NODE_533_next, 1, &gn_RMAP_NODE[534]);
MAKE_VECTOR(gn_RMAP_NODE_533_prev, 1, &gn_RMAP_NODE[532]);
MAKE_VECTOR(gn_RMAP_NODE_534_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_534_prev, 1, &gn_RMAP_NODE[533]);
MAKE_VECTOR(gn_RMAP_NODE_535_next, 1, &gn_RMAP_NODE[536]);
MAKE_VECTOR(gn_RMAP_NODE_535_prev, 1, &gn_RMAP_NODE[523]);
MAKE_VECTOR(gn_RMAP_NODE_536_next, 2, &gn_RMAP_NODE[537], &gn_RMAP_NODE[538]);
MAKE_VECTOR(gn_RMAP_NODE_536_prev, 1, &gn_RMAP_NODE[535]);
MAKE_VECTOR(gn_RMAP_NODE_537_next, 1, &gn_RMAP_NODE[538]);
MAKE_VECTOR(gn_RMAP_NODE_537_prev, 1, &gn_RMAP_NODE[536]);
MAKE_VECTOR(gn_RMAP_NODE_538_next, 1, &gn_RMAP_NODE[539]);
MAKE_VECTOR(gn_RMAP_NODE_538_prev, 2, &gn_RMAP_NODE[537], &gn_RMAP_NODE[536]);
MAKE_VECTOR(gn_RMAP_NODE_539_next, 1, &gn_RMAP_NODE[540]);
MAKE_VECTOR(gn_RMAP_NODE_539_prev, 1, &gn_RMAP_NODE[538]);
MAKE_VECTOR(gn_RMAP_NODE_540_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_540_prev, 1, &gn_RMAP_NODE[539]);
MAKE_VECTOR(gn_RMAP_NODE_541_next, 5, &gn_RMAP_NODE[542], &gn_RMAP_NODE[545], &gn_RMAP_NODE[550], &gn_RMAP_NODE[554], &gn_RMAP_NODE[560]);
MAKE_VECTOR(gn_RMAP_NODE_541_prev, 1, &gn_RMAP_NODE[513]);
MAKE_VECTOR(gn_RMAP_NODE_542_next, 1, &gn_RMAP_NODE[543]);
MAKE_VECTOR(gn_RMAP_NODE_542_prev, 1, &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_543_next, 1, &gn_RMAP_NODE[544]);
MAKE_VECTOR(gn_RMAP_NODE_543_prev, 1, &gn_RMAP_NODE[542]);
MAKE_VECTOR(gn_RMAP_NODE_544_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_544_prev, 1, &gn_RMAP_NODE[543]);
MAKE_VECTOR(gn_RMAP_NODE_545_next, 2, &gn_RMAP_NODE[546], &gn_RMAP_NODE[547]);
MAKE_VECTOR(gn_RMAP_NODE_545_prev, 1, &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_546_next, 1, &gn_RMAP_NODE[547]);
MAKE_VECTOR(gn_RMAP_NODE_546_prev, 1, &gn_RMAP_NODE[545]);
MAKE_VECTOR(gn_RMAP_NODE_547_next, 1, &gn_RMAP_NODE[548]);
MAKE_VECTOR(gn_RMAP_NODE_547_prev, 2, &gn_RMAP_NODE[546], &gn_RMAP_NODE[545]);
MAKE_VECTOR(gn_RMAP_NODE_548_next, 1, &gn_RMAP_NODE[549]);
MAKE_VECTOR(gn_RMAP_NODE_548_prev, 1, &gn_RMAP_NODE[547]);
MAKE_VECTOR(gn_RMAP_NODE_549_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_549_prev, 1, &gn_RMAP_NODE[548]);
MAKE_VECTOR(gn_RMAP_NODE_550_next, 1, &gn_RMAP_NODE[551]);
MAKE_VECTOR(gn_RMAP_NODE_550_prev, 1, &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_551_next, 1, &gn_RMAP_NODE[552]);
MAKE_VECTOR(gn_RMAP_NODE_551_prev, 1, &gn_RMAP_NODE[550]);
MAKE_VECTOR(gn_RMAP_NODE_552_next, 1, &gn_RMAP_NODE[553]);
MAKE_VECTOR(gn_RMAP_NODE_552_prev, 1, &gn_RMAP_NODE[551]);
MAKE_VECTOR(gn_RMAP_NODE_553_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_553_prev, 1, &gn_RMAP_NODE[552]);
MAKE_VECTOR(gn_RMAP_NODE_554_next, 1, &gn_RMAP_NODE[555]);
MAKE_VECTOR(gn_RMAP_NODE_554_prev, 1, &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_555_next, 2, &gn_RMAP_NODE[556], &gn_RMAP_NODE[557]);
MAKE_VECTOR(gn_RMAP_NODE_555_prev, 1, &gn_RMAP_NODE[554]);
MAKE_VECTOR(gn_RMAP_NODE_556_next, 1, &gn_RMAP_NODE[557]);
MAKE_VECTOR(gn_RMAP_NODE_556_prev, 1, &gn_RMAP_NODE[555]);
MAKE_VECTOR(gn_RMAP_NODE_557_next, 1, &gn_RMAP_NODE[558]);
MAKE_VECTOR(gn_RMAP_NODE_557_prev, 2, &gn_RMAP_NODE[556], &gn_RMAP_NODE[555]);
MAKE_VECTOR(gn_RMAP_NODE_558_next, 1, &gn_RMAP_NODE[559]);
MAKE_VECTOR(gn_RMAP_NODE_558_prev, 1, &gn_RMAP_NODE[557]);
MAKE_VECTOR(gn_RMAP_NODE_559_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_559_prev, 1, &gn_RMAP_NODE[558]);
MAKE_VECTOR(gn_RMAP_NODE_560_next, 1, &gn_RMAP_NODE[561]);
MAKE_VECTOR(gn_RMAP_NODE_560_prev, 1, &gn_RMAP_NODE[541]);
MAKE_VECTOR(gn_RMAP_NODE_561_next, 2, &gn_RMAP_NODE[562], &gn_RMAP_NODE[565]);
MAKE_VECTOR(gn_RMAP_NODE_561_prev, 1, &gn_RMAP_NODE[560]);
MAKE_VECTOR(gn_RMAP_NODE_562_next, 1, &gn_RMAP_NODE[563]);
MAKE_VECTOR(gn_RMAP_NODE_562_prev, 1, &gn_RMAP_NODE[561]);
MAKE_VECTOR(gn_RMAP_NODE_563_next, 1, &gn_RMAP_NODE[564]);
MAKE_VECTOR(gn_RMAP_NODE_563_prev, 1, &gn_RMAP_NODE[562]);
MAKE_VECTOR(gn_RMAP_NODE_564_next, 1, &gn_RMAP_NODE[565]);
MAKE_VECTOR(gn_RMAP_NODE_564_prev, 1, &gn_RMAP_NODE[563]);
MAKE_VECTOR(gn_RMAP_NODE_565_next, 1, &gn_RMAP_NODE[566]);
MAKE_VECTOR(gn_RMAP_NODE_565_prev, 2, &gn_RMAP_NODE[564], &gn_RMAP_NODE[561]);
MAKE_VECTOR(gn_RMAP_NODE_566_next, 1, &gn_RMAP_NODE[567]);
MAKE_VECTOR(gn_RMAP_NODE_566_prev, 1, &gn_RMAP_NODE[565]);
MAKE_VECTOR(gn_RMAP_NODE_567_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_567_prev, 1, &gn_RMAP_NODE[566]);
MAKE_VECTOR(gn_RMAP_NODE_568_next, 1, &gn_RMAP_NODE[569]);
MAKE_VECTOR(gn_RMAP_NODE_568_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_569_next, 2, &gn_RMAP_NODE[570], &gn_RMAP_NODE[578]);
MAKE_VECTOR(gn_RMAP_NODE_569_prev, 1, &gn_RMAP_NODE[568]);
MAKE_VECTOR(gn_RMAP_NODE_570_next, 3, &gn_RMAP_NODE[571], &gn_RMAP_NODE[582], &gn_RMAP_NODE[583]);
MAKE_VECTOR(gn_RMAP_NODE_570_prev, 1, &gn_RMAP_NODE[569]);
MAKE_VECTOR(gn_RMAP_NODE_571_next, 1, &gn_RMAP_NODE[572]);
MAKE_VECTOR(gn_RMAP_NODE_571_prev, 1, &gn_RMAP_NODE[570]);
MAKE_VECTOR(gn_RMAP_NODE_572_next, 1, &gn_RMAP_NODE[573]);
MAKE_VECTOR(gn_RMAP_NODE_572_prev, 3, &gn_RMAP_NODE[571], &gn_RMAP_NODE[582], &gn_RMAP_NODE[583]);
MAKE_VECTOR(gn_RMAP_NODE_573_next, 2, &gn_RMAP_NODE[574], &gn_RMAP_NODE[577]);
MAKE_VECTOR(gn_RMAP_NODE_573_prev, 1, &gn_RMAP_NODE[572]);
MAKE_VECTOR(gn_RMAP_NODE_574_next, 2, &gn_RMAP_NODE[575], &gn_RMAP_NODE[581]);
MAKE_VECTOR(gn_RMAP_NODE_574_prev, 1, &gn_RMAP_NODE[573]);
MAKE_VECTOR(gn_RMAP_NODE_575_next, 1, &gn_RMAP_NODE[576]);
MAKE_VECTOR(gn_RMAP_NODE_575_prev, 1, &gn_RMAP_NODE[574]);
MAKE_VECTOR(gn_RMAP_NODE_576_next, 1, &gn_RMAP_NODE[577]);
MAKE_VECTOR(gn_RMAP_NODE_576_prev, 2, &gn_RMAP_NODE[575], &gn_RMAP_NODE[581]);
MAKE_VECTOR(gn_RMAP_NODE_577_next, 1, &gn_RMAP_NODE[578]);
MAKE_VECTOR(gn_RMAP_NODE_577_prev, 2, &gn_RMAP_NODE[576], &gn_RMAP_NODE[573]);
MAKE_VECTOR(gn_RMAP_NODE_578_next, 1, &gn_RMAP_NODE[579]);
MAKE_VECTOR(gn_RMAP_NODE_578_prev, 2, &gn_RMAP_NODE[577], &gn_RMAP_NODE[569]);
MAKE_VECTOR(gn_RMAP_NODE_579_next, 1, &gn_RMAP_NODE[580]);
MAKE_VECTOR(gn_RMAP_NODE_579_prev, 1, &gn_RMAP_NODE[578]);
MAKE_VECTOR(gn_RMAP_NODE_580_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_580_prev, 1, &gn_RMAP_NODE[579]);
MAKE_VECTOR(gn_RMAP_NODE_581_next, 1, &gn_RMAP_NODE[576]);
MAKE_VECTOR(gn_RMAP_NODE_581_prev, 1, &gn_RMAP_NODE[574]);
MAKE_VECTOR(gn_RMAP_NODE_582_next, 1, &gn_RMAP_NODE[572]);
MAKE_VECTOR(gn_RMAP_NODE_582_prev, 1, &gn_RMAP_NODE[570]);
MAKE_VECTOR(gn_RMAP_NODE_583_next, 1, &gn_RMAP_NODE[572]);
MAKE_VECTOR(gn_RMAP_NODE_583_prev, 1, &gn_RMAP_NODE[570]);
MAKE_VECTOR(gn_RMAP_NODE_584_next, 1, &gn_RMAP_NODE[585]);
MAKE_VECTOR(gn_RMAP_NODE_584_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_585_next, 2, &gn_RMAP_NODE[586], &gn_RMAP_NODE[587]);
MAKE_VECTOR(gn_RMAP_NODE_585_prev, 1, &gn_RMAP_NODE[584]);
MAKE_VECTOR(gn_RMAP_NODE_586_next, 1, &gn_RMAP_NODE[587]);
MAKE_VECTOR(gn_RMAP_NODE_586_prev, 1, &gn_RMAP_NODE[585]);
MAKE_VECTOR(gn_RMAP_NODE_587_next, 1, &gn_RMAP_NODE[588]);
MAKE_VECTOR(gn_RMAP_NODE_587_prev, 2, &gn_RMAP_NODE[586], &gn_RMAP_NODE[585]);
MAKE_VECTOR(gn_RMAP_NODE_588_next, 1, &gn_RMAP_NODE[589]);
MAKE_VECTOR(gn_RMAP_NODE_588_prev, 1, &gn_RMAP_NODE[587]);
MAKE_VECTOR(gn_RMAP_NODE_589_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_589_prev, 1, &gn_RMAP_NODE[588]);
MAKE_VECTOR(gn_RMAP_NODE_590_next, 1, &gn_RMAP_NODE[591]);
MAKE_VECTOR(gn_RMAP_NODE_590_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_591_next, 1, &gn_RMAP_NODE[592]);
MAKE_VECTOR(gn_RMAP_NODE_591_prev, 1, &gn_RMAP_NODE[590]);
MAKE_VECTOR(gn_RMAP_NODE_592_next, 1, &gn_RMAP_NODE[593]);
MAKE_VECTOR(gn_RMAP_NODE_592_prev, 1, &gn_RMAP_NODE[591]);
MAKE_VECTOR(gn_RMAP_NODE_593_next, 1, &gn_RMAP_NODE[594]);
MAKE_VECTOR(gn_RMAP_NODE_593_prev, 1, &gn_RMAP_NODE[592]);
MAKE_VECTOR(gn_RMAP_NODE_594_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_594_prev, 1, &gn_RMAP_NODE[593]);
MAKE_VECTOR(gn_RMAP_NODE_595_next, 1, &gn_RMAP_NODE[596]);
MAKE_VECTOR(gn_RMAP_NODE_595_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_596_next, 2, &gn_RMAP_NODE[597], &gn_RMAP_NODE[598]);
MAKE_VECTOR(gn_RMAP_NODE_596_prev, 1, &gn_RMAP_NODE[595]);
MAKE_VECTOR(gn_RMAP_NODE_597_next, 1, &gn_RMAP_NODE[598]);
MAKE_VECTOR(gn_RMAP_NODE_597_prev, 1, &gn_RMAP_NODE[596]);
MAKE_VECTOR(gn_RMAP_NODE_598_next, 1, &gn_RMAP_NODE[599]);
MAKE_VECTOR(gn_RMAP_NODE_598_prev, 2, &gn_RMAP_NODE[597], &gn_RMAP_NODE[596]);
MAKE_VECTOR(gn_RMAP_NODE_599_next, 1, &gn_RMAP_NODE[600]);
MAKE_VECTOR(gn_RMAP_NODE_599_prev, 1, &gn_RMAP_NODE[598]);
MAKE_VECTOR(gn_RMAP_NODE_600_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_600_prev, 1, &gn_RMAP_NODE[599]);
MAKE_VECTOR(gn_RMAP_NODE_601_next, 1, &gn_RMAP_NODE[602]);
MAKE_VECTOR(gn_RMAP_NODE_601_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_602_next, 1, &gn_RMAP_NODE[603]);
MAKE_VECTOR(gn_RMAP_NODE_602_prev, 1, &gn_RMAP_NODE[601]);
MAKE_VECTOR(gn_RMAP_NODE_603_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_603_prev, 1, &gn_RMAP_NODE[602]);
MAKE_VECTOR(gn_RMAP_NODE_604_next, 1, &gn_RMAP_NODE[605]);
MAKE_VECTOR(gn_RMAP_NODE_604_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_605_next, 2, &gn_RMAP_NODE[606], &gn_RMAP_NODE[609]);
MAKE_VECTOR(gn_RMAP_NODE_605_prev, 1, &gn_RMAP_NODE[604]);
MAKE_VECTOR(gn_RMAP_NODE_606_next, 3, &gn_RMAP_NODE[607], &gn_RMAP_NODE[612], &gn_RMAP_NODE[613]);
MAKE_VECTOR(gn_RMAP_NODE_606_prev, 1, &gn_RMAP_NODE[605]);
MAKE_VECTOR(gn_RMAP_NODE_607_next, 1, &gn_RMAP_NODE[608]);
MAKE_VECTOR(gn_RMAP_NODE_607_prev, 1, &gn_RMAP_NODE[606]);
MAKE_VECTOR(gn_RMAP_NODE_608_next, 1, &gn_RMAP_NODE[609]);
MAKE_VECTOR(gn_RMAP_NODE_608_prev, 3, &gn_RMAP_NODE[607], &gn_RMAP_NODE[612], &gn_RMAP_NODE[613]);
MAKE_VECTOR(gn_RMAP_NODE_609_next, 1, &gn_RMAP_NODE[610]);
MAKE_VECTOR(gn_RMAP_NODE_609_prev, 2, &gn_RMAP_NODE[608], &gn_RMAP_NODE[605]);
MAKE_VECTOR(gn_RMAP_NODE_610_next, 1, &gn_RMAP_NODE[611]);
MAKE_VECTOR(gn_RMAP_NODE_610_prev, 1, &gn_RMAP_NODE[609]);
MAKE_VECTOR(gn_RMAP_NODE_611_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_611_prev, 1, &gn_RMAP_NODE[610]);
MAKE_VECTOR(gn_RMAP_NODE_612_next, 1, &gn_RMAP_NODE[608]);
MAKE_VECTOR(gn_RMAP_NODE_612_prev, 1, &gn_RMAP_NODE[606]);
MAKE_VECTOR(gn_RMAP_NODE_613_next, 1, &gn_RMAP_NODE[608]);
MAKE_VECTOR(gn_RMAP_NODE_613_prev, 1, &gn_RMAP_NODE[606]);
MAKE_VECTOR(gn_RMAP_NODE_614_next, 1, &gn_RMAP_NODE[615]);
MAKE_VECTOR(gn_RMAP_NODE_614_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_615_next, 2, &gn_RMAP_NODE[616], &gn_RMAP_NODE[619]);
MAKE_VECTOR(gn_RMAP_NODE_615_prev, 1, &gn_RMAP_NODE[614]);
MAKE_VECTOR(gn_RMAP_NODE_616_next, 4, &gn_RMAP_NODE[617], &gn_RMAP_NODE[622], &gn_RMAP_NODE[623], &gn_RMAP_NODE[624]);
MAKE_VECTOR(gn_RMAP_NODE_616_prev, 1, &gn_RMAP_NODE[615]);
MAKE_VECTOR(gn_RMAP_NODE_617_next, 1, &gn_RMAP_NODE[618]);
MAKE_VECTOR(gn_RMAP_NODE_617_prev, 1, &gn_RMAP_NODE[616]);
MAKE_VECTOR(gn_RMAP_NODE_618_next, 1, &gn_RMAP_NODE[619]);
MAKE_VECTOR(gn_RMAP_NODE_618_prev, 4, &gn_RMAP_NODE[617], &gn_RMAP_NODE[622], &gn_RMAP_NODE[623], &gn_RMAP_NODE[624]);
MAKE_VECTOR(gn_RMAP_NODE_619_next, 1, &gn_RMAP_NODE[620]);
MAKE_VECTOR(gn_RMAP_NODE_619_prev, 2, &gn_RMAP_NODE[618], &gn_RMAP_NODE[615]);
MAKE_VECTOR(gn_RMAP_NODE_620_next, 1, &gn_RMAP_NODE[621]);
MAKE_VECTOR(gn_RMAP_NODE_620_prev, 1, &gn_RMAP_NODE[619]);
MAKE_VECTOR(gn_RMAP_NODE_621_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_621_prev, 1, &gn_RMAP_NODE[620]);
MAKE_VECTOR(gn_RMAP_NODE_622_next, 1, &gn_RMAP_NODE[618]);
MAKE_VECTOR(gn_RMAP_NODE_622_prev, 1, &gn_RMAP_NODE[616]);
MAKE_VECTOR(gn_RMAP_NODE_623_next, 1, &gn_RMAP_NODE[618]);
MAKE_VECTOR(gn_RMAP_NODE_623_prev, 1, &gn_RMAP_NODE[616]);
MAKE_VECTOR(gn_RMAP_NODE_624_next, 1, &gn_RMAP_NODE[618]);
MAKE_VECTOR(gn_RMAP_NODE_624_prev, 1, &gn_RMAP_NODE[616]);
MAKE_VECTOR(gn_RMAP_NODE_625_next, 1, &gn_RMAP_NODE[626]);
MAKE_VECTOR(gn_RMAP_NODE_625_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_626_next, 2, &gn_RMAP_NODE[627], &gn_RMAP_NODE[628]);
MAKE_VECTOR(gn_RMAP_NODE_626_prev, 1, &gn_RMAP_NODE[625]);
MAKE_VECTOR(gn_RMAP_NODE_627_next, 1, &gn_RMAP_NODE[628]);
MAKE_VECTOR(gn_RMAP_NODE_627_prev, 1, &gn_RMAP_NODE[626]);
MAKE_VECTOR(gn_RMAP_NODE_628_next, 1, &gn_RMAP_NODE[629]);
MAKE_VECTOR(gn_RMAP_NODE_628_prev, 2, &gn_RMAP_NODE[627], &gn_RMAP_NODE[626]);
MAKE_VECTOR(gn_RMAP_NODE_629_next, 1, &gn_RMAP_NODE[630]);
MAKE_VECTOR(gn_RMAP_NODE_629_prev, 1, &gn_RMAP_NODE[628]);
MAKE_VECTOR(gn_RMAP_NODE_630_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_630_prev, 1, &gn_RMAP_NODE[629]);
MAKE_VECTOR(gn_RMAP_NODE_631_next, 1, &gn_RMAP_NODE[632]);
MAKE_VECTOR(gn_RMAP_NODE_631_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_632_next, 3, &gn_RMAP_NODE[633], &gn_RMAP_NODE[637], &gn_RMAP_NODE[638]);
MAKE_VECTOR(gn_RMAP_NODE_632_prev, 1, &gn_RMAP_NODE[631]);
MAKE_VECTOR(gn_RMAP_NODE_633_next, 1, &gn_RMAP_NODE[634]);
MAKE_VECTOR(gn_RMAP_NODE_633_prev, 1, &gn_RMAP_NODE[632]);
MAKE_VECTOR(gn_RMAP_NODE_634_next, 1, &gn_RMAP_NODE[635]);
MAKE_VECTOR(gn_RMAP_NODE_634_prev, 3, &gn_RMAP_NODE[633], &gn_RMAP_NODE[637], &gn_RMAP_NODE[638]);
MAKE_VECTOR(gn_RMAP_NODE_635_next, 1, &gn_RMAP_NODE[636]);
MAKE_VECTOR(gn_RMAP_NODE_635_prev, 1, &gn_RMAP_NODE[634]);
MAKE_VECTOR(gn_RMAP_NODE_636_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_636_prev, 1, &gn_RMAP_NODE[635]);
MAKE_VECTOR(gn_RMAP_NODE_637_next, 1, &gn_RMAP_NODE[634]);
MAKE_VECTOR(gn_RMAP_NODE_637_prev, 1, &gn_RMAP_NODE[632]);
MAKE_VECTOR(gn_RMAP_NODE_638_next, 1, &gn_RMAP_NODE[634]);
MAKE_VECTOR(gn_RMAP_NODE_638_prev, 1, &gn_RMAP_NODE[632]);
MAKE_VECTOR(gn_RMAP_NODE_639_next, 1, &gn_RMAP_NODE[640]);
MAKE_VECTOR(gn_RMAP_NODE_639_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_640_next, 2, &gn_RMAP_NODE[641], &gn_RMAP_NODE[642]);
MAKE_VECTOR(gn_RMAP_NODE_640_prev, 1, &gn_RMAP_NODE[639]);
MAKE_VECTOR(gn_RMAP_NODE_641_next, 1, &gn_RMAP_NODE[642]);
MAKE_VECTOR(gn_RMAP_NODE_641_prev, 1, &gn_RMAP_NODE[640]);
MAKE_VECTOR(gn_RMAP_NODE_642_next, 1, &gn_RMAP_NODE[643]);
MAKE_VECTOR(gn_RMAP_NODE_642_prev, 2, &gn_RMAP_NODE[641], &gn_RMAP_NODE[640]);
MAKE_VECTOR(gn_RMAP_NODE_643_next, 1, &gn_RMAP_NODE[644]);
MAKE_VECTOR(gn_RMAP_NODE_643_prev, 1, &gn_RMAP_NODE[642]);
MAKE_VECTOR(gn_RMAP_NODE_644_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_644_prev, 1, &gn_RMAP_NODE[643]);
MAKE_VECTOR(gn_RMAP_NODE_645_next, 1, &gn_RMAP_NODE[646]);
MAKE_VECTOR(gn_RMAP_NODE_645_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_646_next, 2, &gn_RMAP_NODE[647], &gn_RMAP_NODE[650]);
MAKE_VECTOR(gn_RMAP_NODE_646_prev, 1, &gn_RMAP_NODE[645]);
MAKE_VECTOR(gn_RMAP_NODE_647_next, 15, &gn_RMAP_NODE[648], &gn_RMAP_NODE[653], &gn_RMAP_NODE[654], &gn_RMAP_NODE[655], &gn_RMAP_NODE[656], &gn_RMAP_NODE[657], &gn_RMAP_NODE[658], &gn_RMAP_NODE[659], &gn_RMAP_NODE[660], &gn_RMAP_NODE[661], &gn_RMAP_NODE[662], &gn_RMAP_NODE[663], &gn_RMAP_NODE[664], &gn_RMAP_NODE[665], &gn_RMAP_NODE[666]);
MAKE_VECTOR(gn_RMAP_NODE_647_prev, 1, &gn_RMAP_NODE[646]);
MAKE_VECTOR(gn_RMAP_NODE_648_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_648_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_649_next, 1, &gn_RMAP_NODE[650]);
MAKE_VECTOR(gn_RMAP_NODE_649_prev, 15, &gn_RMAP_NODE[648], &gn_RMAP_NODE[653], &gn_RMAP_NODE[654], &gn_RMAP_NODE[655], &gn_RMAP_NODE[656], &gn_RMAP_NODE[657], &gn_RMAP_NODE[658], &gn_RMAP_NODE[659], &gn_RMAP_NODE[660], &gn_RMAP_NODE[661], &gn_RMAP_NODE[662], &gn_RMAP_NODE[663], &gn_RMAP_NODE[664], &gn_RMAP_NODE[665], &gn_RMAP_NODE[666]);
MAKE_VECTOR(gn_RMAP_NODE_650_next, 1, &gn_RMAP_NODE[651]);
MAKE_VECTOR(gn_RMAP_NODE_650_prev, 2, &gn_RMAP_NODE[649], &gn_RMAP_NODE[646]);
MAKE_VECTOR(gn_RMAP_NODE_651_next, 1, &gn_RMAP_NODE[652]);
MAKE_VECTOR(gn_RMAP_NODE_651_prev, 1, &gn_RMAP_NODE[650]);
MAKE_VECTOR(gn_RMAP_NODE_652_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_652_prev, 1, &gn_RMAP_NODE[651]);
MAKE_VECTOR(gn_RMAP_NODE_653_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_653_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_654_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_654_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_655_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_655_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_656_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_656_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_657_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_657_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_658_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_658_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_659_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_659_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_660_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_660_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_661_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_661_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_662_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_662_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_663_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_663_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_664_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_664_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_665_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_665_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_666_next, 1, &gn_RMAP_NODE[649]);
MAKE_VECTOR(gn_RMAP_NODE_666_prev, 1, &gn_RMAP_NODE[647]);
MAKE_VECTOR(gn_RMAP_NODE_667_next, 1, &gn_RMAP_NODE[668]);
MAKE_VECTOR(gn_RMAP_NODE_667_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_668_next, 1, &gn_RMAP_NODE[669]);
MAKE_VECTOR(gn_RMAP_NODE_668_prev, 1, &gn_RMAP_NODE[667]);
MAKE_VECTOR(gn_RMAP_NODE_669_next, 1, &gn_RMAP_NODE[670]);
MAKE_VECTOR(gn_RMAP_NODE_669_prev, 1, &gn_RMAP_NODE[668]);
MAKE_VECTOR(gn_RMAP_NODE_670_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_670_prev, 1, &gn_RMAP_NODE[669]);
MAKE_VECTOR(gn_RMAP_NODE_671_next, 1, &gn_RMAP_NODE[672]);
MAKE_VECTOR(gn_RMAP_NODE_671_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_672_next, 2, &gn_RMAP_NODE[673], &gn_RMAP_NODE[676]);
MAKE_VECTOR(gn_RMAP_NODE_672_prev, 1, &gn_RMAP_NODE[671]);
MAKE_VECTOR(gn_RMAP_NODE_673_next, 3, &gn_RMAP_NODE[674], &gn_RMAP_NODE[679], &gn_RMAP_NODE[680]);
MAKE_VECTOR(gn_RMAP_NODE_673_prev, 1, &gn_RMAP_NODE[672]);
MAKE_VECTOR(gn_RMAP_NODE_674_next, 1, &gn_RMAP_NODE[675]);
MAKE_VECTOR(gn_RMAP_NODE_674_prev, 1, &gn_RMAP_NODE[673]);
MAKE_VECTOR(gn_RMAP_NODE_675_next, 1, &gn_RMAP_NODE[676]);
MAKE_VECTOR(gn_RMAP_NODE_675_prev, 3, &gn_RMAP_NODE[674], &gn_RMAP_NODE[679], &gn_RMAP_NODE[680]);
MAKE_VECTOR(gn_RMAP_NODE_676_next, 1, &gn_RMAP_NODE[677]);
MAKE_VECTOR(gn_RMAP_NODE_676_prev, 2, &gn_RMAP_NODE[675], &gn_RMAP_NODE[672]);
MAKE_VECTOR(gn_RMAP_NODE_677_next, 1, &gn_RMAP_NODE[678]);
MAKE_VECTOR(gn_RMAP_NODE_677_prev, 1, &gn_RMAP_NODE[676]);
MAKE_VECTOR(gn_RMAP_NODE_678_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_678_prev, 1, &gn_RMAP_NODE[677]);
MAKE_VECTOR(gn_RMAP_NODE_679_next, 1, &gn_RMAP_NODE[675]);
MAKE_VECTOR(gn_RMAP_NODE_679_prev, 1, &gn_RMAP_NODE[673]);
MAKE_VECTOR(gn_RMAP_NODE_680_next, 1, &gn_RMAP_NODE[675]);
MAKE_VECTOR(gn_RMAP_NODE_680_prev, 1, &gn_RMAP_NODE[673]);
MAKE_VECTOR(gn_RMAP_NODE_681_next, 1, &gn_RMAP_NODE[682]);
MAKE_VECTOR(gn_RMAP_NODE_681_prev, 1, &gn_RMAP_NODE[363]);
MAKE_VECTOR(gn_RMAP_NODE_682_next, 2, &gn_RMAP_NODE[683], &gn_RMAP_NODE[686]);
MAKE_VECTOR(gn_RMAP_NODE_682_prev, 1, &gn_RMAP_NODE[681]);
MAKE_VECTOR(gn_RMAP_NODE_683_next, 2, &gn_RMAP_NODE[684], &gn_RMAP_NODE[689]);
MAKE_VECTOR(gn_RMAP_NODE_683_prev, 1, &gn_RMAP_NODE[682]);
MAKE_VECTOR(gn_RMAP_NODE_684_next, 1, &gn_RMAP_NODE[685]);
MAKE_VECTOR(gn_RMAP_NODE_684_prev, 1, &gn_RMAP_NODE[683]);
MAKE_VECTOR(gn_RMAP_NODE_685_next, 1, &gn_RMAP_NODE[686]);
MAKE_VECTOR(gn_RMAP_NODE_685_prev, 2, &gn_RMAP_NODE[684], &gn_RMAP_NODE[689]);
MAKE_VECTOR(gn_RMAP_NODE_686_next, 1, &gn_RMAP_NODE[687]);
MAKE_VECTOR(gn_RMAP_NODE_686_prev, 2, &gn_RMAP_NODE[685], &gn_RMAP_NODE[682]);
MAKE_VECTOR(gn_RMAP_NODE_687_next, 1, &gn_RMAP_NODE[688]);
MAKE_VECTOR(gn_RMAP_NODE_687_prev, 1, &gn_RMAP_NODE[686]);
MAKE_VECTOR(gn_RMAP_NODE_688_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_688_prev, 1, &gn_RMAP_NODE[687]);
MAKE_VECTOR(gn_RMAP_NODE_689_next, 1, &gn_RMAP_NODE[685]);
MAKE_VECTOR(gn_RMAP_NODE_689_prev, 1, &gn_RMAP_NODE[683]);
MAKE_VECTOR(gn_RMAP_NODE_690_next, 2, &gn_RMAP_NODE[691], &gn_RMAP_NODE[697]);
MAKE_VECTOR(gn_RMAP_NODE_690_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_691_next, 1, &gn_RMAP_NODE[692]);
MAKE_VECTOR(gn_RMAP_NODE_691_prev, 1, &gn_RMAP_NODE[690]);
MAKE_VECTOR(gn_RMAP_NODE_692_next, 2, &gn_RMAP_NODE[693], &gn_RMAP_NODE[694]);
MAKE_VECTOR(gn_RMAP_NODE_692_prev, 1, &gn_RMAP_NODE[691]);
MAKE_VECTOR(gn_RMAP_NODE_693_next, 1, &gn_RMAP_NODE[694]);
MAKE_VECTOR(gn_RMAP_NODE_693_prev, 1, &gn_RMAP_NODE[692]);
MAKE_VECTOR(gn_RMAP_NODE_694_next, 1, &gn_RMAP_NODE[695]);
MAKE_VECTOR(gn_RMAP_NODE_694_prev, 2, &gn_RMAP_NODE[693], &gn_RMAP_NODE[692]);
MAKE_VECTOR(gn_RMAP_NODE_695_next, 1, &gn_RMAP_NODE[696]);
MAKE_VECTOR(gn_RMAP_NODE_695_prev, 1, &gn_RMAP_NODE[694]);
MAKE_VECTOR(gn_RMAP_NODE_696_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_696_prev, 1, &gn_RMAP_NODE[695]);
MAKE_VECTOR(gn_RMAP_NODE_697_next, 1, &gn_RMAP_NODE[698]);
MAKE_VECTOR(gn_RMAP_NODE_697_prev, 1, &gn_RMAP_NODE[690]);
MAKE_VECTOR(gn_RMAP_NODE_698_next, 1, &gn_RMAP_NODE[699]);
MAKE_VECTOR(gn_RMAP_NODE_698_prev, 1, &gn_RMAP_NODE[697]);
MAKE_VECTOR(gn_RMAP_NODE_699_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_699_prev, 1, &gn_RMAP_NODE[698]);
MAKE_VECTOR(gn_RMAP_NODE_700_next, 29, &gn_RMAP_NODE[701], &gn_RMAP_NODE[715], &gn_RMAP_NODE[723], &gn_RMAP_NODE[732], &gn_RMAP_NODE[782], &gn_RMAP_NODE[785], &gn_RMAP_NODE[796], &gn_RMAP_NODE[802], &gn_RMAP_NODE[808], &gn_RMAP_NODE[818], &gn_RMAP_NODE[859], &gn_RMAP_NODE[870], &gn_RMAP_NODE[876], &gn_RMAP_NODE[883], &gn_RMAP_NODE[901], &gn_RMAP_NODE[907], &gn_RMAP_NODE[920], &gn_RMAP_NODE[929], &gn_RMAP_NODE[935], &gn_RMAP_NODE[941], &gn_RMAP_NODE[947], &gn_RMAP_NODE[956], &gn_RMAP_NODE[962], &gn_RMAP_NODE[972], &gn_RMAP_NODE[978], &gn_RMAP_NODE[985], &gn_RMAP_NODE[994], &gn_RMAP_NODE[1000], &gn_RMAP_NODE[1009]);
MAKE_VECTOR(gn_RMAP_NODE_700_prev, 1, &gn_RMAP_NODE[347]);
MAKE_VECTOR(gn_RMAP_NODE_701_next, 2, &gn_RMAP_NODE[702], &gn_RMAP_NODE[714]);
MAKE_VECTOR(gn_RMAP_NODE_701_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_702_next, 1, &gn_RMAP_NODE[703]);
MAKE_VECTOR(gn_RMAP_NODE_702_prev, 1, &gn_RMAP_NODE[701]);
MAKE_VECTOR(gn_RMAP_NODE_703_next, 1, &gn_RMAP_NODE[704]);
MAKE_VECTOR(gn_RMAP_NODE_703_prev, 2, &gn_RMAP_NODE[702], &gn_RMAP_NODE[714]);
MAKE_VECTOR(gn_RMAP_NODE_704_next, 1, &gn_RMAP_NODE[705]);
MAKE_VECTOR(gn_RMAP_NODE_704_prev, 1, &gn_RMAP_NODE[703]);
MAKE_VECTOR(gn_RMAP_NODE_705_next, 1, &gn_RMAP_NODE[706]);
MAKE_VECTOR(gn_RMAP_NODE_705_prev, 1, &gn_RMAP_NODE[704]);
MAKE_VECTOR(gn_RMAP_NODE_706_next, 2, &gn_RMAP_NODE[707], &gn_RMAP_NODE[710]);
MAKE_VECTOR(gn_RMAP_NODE_706_prev, 1, &gn_RMAP_NODE[705]);
MAKE_VECTOR(gn_RMAP_NODE_707_next, 2, &gn_RMAP_NODE[708], &gn_RMAP_NODE[713]);
MAKE_VECTOR(gn_RMAP_NODE_707_prev, 1, &gn_RMAP_NODE[706]);
MAKE_VECTOR(gn_RMAP_NODE_708_next, 1, &gn_RMAP_NODE[709]);
MAKE_VECTOR(gn_RMAP_NODE_708_prev, 1, &gn_RMAP_NODE[707]);
MAKE_VECTOR(gn_RMAP_NODE_709_next, 1, &gn_RMAP_NODE[710]);
MAKE_VECTOR(gn_RMAP_NODE_709_prev, 2, &gn_RMAP_NODE[708], &gn_RMAP_NODE[713]);
MAKE_VECTOR(gn_RMAP_NODE_710_next, 1, &gn_RMAP_NODE[711]);
MAKE_VECTOR(gn_RMAP_NODE_710_prev, 2, &gn_RMAP_NODE[709], &gn_RMAP_NODE[706]);
MAKE_VECTOR(gn_RMAP_NODE_711_next, 1, &gn_RMAP_NODE[712]);
MAKE_VECTOR(gn_RMAP_NODE_711_prev, 1, &gn_RMAP_NODE[710]);
MAKE_VECTOR(gn_RMAP_NODE_712_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_712_prev, 1, &gn_RMAP_NODE[711]);
MAKE_VECTOR(gn_RMAP_NODE_713_next, 1, &gn_RMAP_NODE[709]);
MAKE_VECTOR(gn_RMAP_NODE_713_prev, 1, &gn_RMAP_NODE[707]);
MAKE_VECTOR(gn_RMAP_NODE_714_next, 1, &gn_RMAP_NODE[703]);
MAKE_VECTOR(gn_RMAP_NODE_714_prev, 1, &gn_RMAP_NODE[701]);
MAKE_VECTOR(gn_RMAP_NODE_715_next, 1, &gn_RMAP_NODE[716]);
MAKE_VECTOR(gn_RMAP_NODE_715_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_716_next, 1, &gn_RMAP_NODE[717]);
MAKE_VECTOR(gn_RMAP_NODE_716_prev, 1, &gn_RMAP_NODE[715]);
MAKE_VECTOR(gn_RMAP_NODE_717_next, 2, &gn_RMAP_NODE[718], &gn_RMAP_NODE[720]);
MAKE_VECTOR(gn_RMAP_NODE_717_prev, 1, &gn_RMAP_NODE[716]);
MAKE_VECTOR(gn_RMAP_NODE_718_next, 1, &gn_RMAP_NODE[719]);
MAKE_VECTOR(gn_RMAP_NODE_718_prev, 1, &gn_RMAP_NODE[717]);
MAKE_VECTOR(gn_RMAP_NODE_719_next, 1, &gn_RMAP_NODE[720]);
MAKE_VECTOR(gn_RMAP_NODE_719_prev, 1, &gn_RMAP_NODE[718]);
MAKE_VECTOR(gn_RMAP_NODE_720_next, 1, &gn_RMAP_NODE[721]);
MAKE_VECTOR(gn_RMAP_NODE_720_prev, 2, &gn_RMAP_NODE[719], &gn_RMAP_NODE[717]);
MAKE_VECTOR(gn_RMAP_NODE_721_next, 1, &gn_RMAP_NODE[722]);
MAKE_VECTOR(gn_RMAP_NODE_721_prev, 1, &gn_RMAP_NODE[720]);
MAKE_VECTOR(gn_RMAP_NODE_722_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_722_prev, 1, &gn_RMAP_NODE[721]);
MAKE_VECTOR(gn_RMAP_NODE_723_next, 1, &gn_RMAP_NODE[724]);
MAKE_VECTOR(gn_RMAP_NODE_723_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_724_next, 2, &gn_RMAP_NODE[725], &gn_RMAP_NODE[728]);
MAKE_VECTOR(gn_RMAP_NODE_724_prev, 1, &gn_RMAP_NODE[723]);
MAKE_VECTOR(gn_RMAP_NODE_725_next, 2, &gn_RMAP_NODE[726], &gn_RMAP_NODE[731]);
MAKE_VECTOR(gn_RMAP_NODE_725_prev, 1, &gn_RMAP_NODE[724]);
MAKE_VECTOR(gn_RMAP_NODE_726_next, 1, &gn_RMAP_NODE[727]);
MAKE_VECTOR(gn_RMAP_NODE_726_prev, 1, &gn_RMAP_NODE[725]);
MAKE_VECTOR(gn_RMAP_NODE_727_next, 1, &gn_RMAP_NODE[728]);
MAKE_VECTOR(gn_RMAP_NODE_727_prev, 2, &gn_RMAP_NODE[726], &gn_RMAP_NODE[731]);
MAKE_VECTOR(gn_RMAP_NODE_728_next, 1, &gn_RMAP_NODE[729]);
MAKE_VECTOR(gn_RMAP_NODE_728_prev, 2, &gn_RMAP_NODE[727], &gn_RMAP_NODE[724]);
MAKE_VECTOR(gn_RMAP_NODE_729_next, 1, &gn_RMAP_NODE[730]);
MAKE_VECTOR(gn_RMAP_NODE_729_prev, 1, &gn_RMAP_NODE[728]);
MAKE_VECTOR(gn_RMAP_NODE_730_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_730_prev, 1, &gn_RMAP_NODE[729]);
MAKE_VECTOR(gn_RMAP_NODE_731_next, 1, &gn_RMAP_NODE[727]);
MAKE_VECTOR(gn_RMAP_NODE_731_prev, 1, &gn_RMAP_NODE[725]);
MAKE_VECTOR(gn_RMAP_NODE_732_next, 3, &gn_RMAP_NODE[733], &gn_RMAP_NODE[745], &gn_RMAP_NODE[757]);
MAKE_VECTOR(gn_RMAP_NODE_732_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_733_next, 3, &gn_RMAP_NODE[734], &gn_RMAP_NODE[736], &gn_RMAP_NODE[739]);
MAKE_VECTOR(gn_RMAP_NODE_733_prev, 1, &gn_RMAP_NODE[732]);
MAKE_VECTOR(gn_RMAP_NODE_734_next, 1, &gn_RMAP_NODE[735]);
MAKE_VECTOR(gn_RMAP_NODE_734_prev, 1, &gn_RMAP_NODE[733]);
MAKE_VECTOR(gn_RMAP_NODE_735_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_735_prev, 1, &gn_RMAP_NODE[734]);
MAKE_VECTOR(gn_RMAP_NODE_736_next, 2, &gn_RMAP_NODE[736], &gn_RMAP_NODE[737]);
MAKE_VECTOR(gn_RMAP_NODE_736_prev, 2, &gn_RMAP_NODE[736], &gn_RMAP_NODE[733]);
MAKE_VECTOR(gn_RMAP_NODE_737_next, 1, &gn_RMAP_NODE[738]);
MAKE_VECTOR(gn_RMAP_NODE_737_prev, 1, &gn_RMAP_NODE[736]);
MAKE_VECTOR(gn_RMAP_NODE_738_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_738_prev, 1, &gn_RMAP_NODE[737]);
MAKE_VECTOR(gn_RMAP_NODE_739_next, 1, &gn_RMAP_NODE[740]);
MAKE_VECTOR(gn_RMAP_NODE_739_prev, 1, &gn_RMAP_NODE[733]);
MAKE_VECTOR(gn_RMAP_NODE_740_next, 2, &gn_RMAP_NODE[741], &gn_RMAP_NODE[742]);
MAKE_VECTOR(gn_RMAP_NODE_740_prev, 1, &gn_RMAP_NODE[739]);
MAKE_VECTOR(gn_RMAP_NODE_741_next, 1, &gn_RMAP_NODE[742]);
MAKE_VECTOR(gn_RMAP_NODE_741_prev, 1, &gn_RMAP_NODE[740]);
MAKE_VECTOR(gn_RMAP_NODE_742_next, 1, &gn_RMAP_NODE[743]);
MAKE_VECTOR(gn_RMAP_NODE_742_prev, 2, &gn_RMAP_NODE[741], &gn_RMAP_NODE[740]);
MAKE_VECTOR(gn_RMAP_NODE_743_next, 1, &gn_RMAP_NODE[744]);
MAKE_VECTOR(gn_RMAP_NODE_743_prev, 1, &gn_RMAP_NODE[742]);
MAKE_VECTOR(gn_RMAP_NODE_744_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_744_prev, 1, &gn_RMAP_NODE[743]);
MAKE_VECTOR(gn_RMAP_NODE_745_next, 2, &gn_RMAP_NODE[746], &gn_RMAP_NODE[749]);
MAKE_VECTOR(gn_RMAP_NODE_745_prev, 1, &gn_RMAP_NODE[732]);
MAKE_VECTOR(gn_RMAP_NODE_746_next, 2, &gn_RMAP_NODE[746], &gn_RMAP_NODE[747]);
MAKE_VECTOR(gn_RMAP_NODE_746_prev, 2, &gn_RMAP_NODE[745], &gn_RMAP_NODE[746]);
MAKE_VECTOR(gn_RMAP_NODE_747_next, 1, &gn_RMAP_NODE[748]);
MAKE_VECTOR(gn_RMAP_NODE_747_prev, 1, &gn_RMAP_NODE[746]);
MAKE_VECTOR(gn_RMAP_NODE_748_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_748_prev, 1, &gn_RMAP_NODE[747]);
MAKE_VECTOR(gn_RMAP_NODE_749_next, 2, &gn_RMAP_NODE[750], &gn_RMAP_NODE[754]);
MAKE_VECTOR(gn_RMAP_NODE_749_prev, 1, &gn_RMAP_NODE[745]);
MAKE_VECTOR(gn_RMAP_NODE_750_next, 1, &gn_RMAP_NODE[751]);
MAKE_VECTOR(gn_RMAP_NODE_750_prev, 1, &gn_RMAP_NODE[749]);
MAKE_VECTOR(gn_RMAP_NODE_751_next, 2, &gn_RMAP_NODE[752], &gn_RMAP_NODE[753]);
MAKE_VECTOR(gn_RMAP_NODE_751_prev, 1, &gn_RMAP_NODE[750]);
MAKE_VECTOR(gn_RMAP_NODE_752_next, 1, &gn_RMAP_NODE[753]);
MAKE_VECTOR(gn_RMAP_NODE_752_prev, 1, &gn_RMAP_NODE[751]);
MAKE_VECTOR(gn_RMAP_NODE_753_next, 1, &gn_RMAP_NODE[754]);
MAKE_VECTOR(gn_RMAP_NODE_753_prev, 2, &gn_RMAP_NODE[752], &gn_RMAP_NODE[751]);
MAKE_VECTOR(gn_RMAP_NODE_754_next, 1, &gn_RMAP_NODE[755]);
MAKE_VECTOR(gn_RMAP_NODE_754_prev, 2, &gn_RMAP_NODE[753], &gn_RMAP_NODE[749]);
MAKE_VECTOR(gn_RMAP_NODE_755_next, 1, &gn_RMAP_NODE[756]);
MAKE_VECTOR(gn_RMAP_NODE_755_prev, 1, &gn_RMAP_NODE[754]);
MAKE_VECTOR(gn_RMAP_NODE_756_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_756_prev, 1, &gn_RMAP_NODE[755]);
MAKE_VECTOR(gn_RMAP_NODE_757_next, 2, &gn_RMAP_NODE[758], &gn_RMAP_NODE[771]);
MAKE_VECTOR(gn_RMAP_NODE_757_prev, 1, &gn_RMAP_NODE[732]);
MAKE_VECTOR(gn_RMAP_NODE_758_next, 2, &gn_RMAP_NODE[759], &gn_RMAP_NODE[762]);
MAKE_VECTOR(gn_RMAP_NODE_758_prev, 1, &gn_RMAP_NODE[757]);
MAKE_VECTOR(gn_RMAP_NODE_759_next, 2, &gn_RMAP_NODE[760], &gn_RMAP_NODE[770]);
MAKE_VECTOR(gn_RMAP_NODE_759_prev, 1, &gn_RMAP_NODE[758]);
MAKE_VECTOR(gn_RMAP_NODE_760_next, 1, &gn_RMAP_NODE[761]);
MAKE_VECTOR(gn_RMAP_NODE_760_prev, 1, &gn_RMAP_NODE[759]);
MAKE_VECTOR(gn_RMAP_NODE_761_next, 1, &gn_RMAP_NODE[762]);
MAKE_VECTOR(gn_RMAP_NODE_761_prev, 2, &gn_RMAP_NODE[760], &gn_RMAP_NODE[770]);
MAKE_VECTOR(gn_RMAP_NODE_762_next, 1, &gn_RMAP_NODE[763]);
MAKE_VECTOR(gn_RMAP_NODE_762_prev, 2, &gn_RMAP_NODE[761], &gn_RMAP_NODE[758]);
MAKE_VECTOR(gn_RMAP_NODE_763_next, 2, &gn_RMAP_NODE[764], &gn_RMAP_NODE[767]);
MAKE_VECTOR(gn_RMAP_NODE_763_prev, 1, &gn_RMAP_NODE[762]);
MAKE_VECTOR(gn_RMAP_NODE_764_next, 1, &gn_RMAP_NODE[765]);
MAKE_VECTOR(gn_RMAP_NODE_764_prev, 1, &gn_RMAP_NODE[763]);
MAKE_VECTOR(gn_RMAP_NODE_765_next, 1, &gn_RMAP_NODE[766]);
MAKE_VECTOR(gn_RMAP_NODE_765_prev, 1, &gn_RMAP_NODE[764]);
MAKE_VECTOR(gn_RMAP_NODE_766_next, 1, &gn_RMAP_NODE[767]);
MAKE_VECTOR(gn_RMAP_NODE_766_prev, 1, &gn_RMAP_NODE[765]);
MAKE_VECTOR(gn_RMAP_NODE_767_next, 1, &gn_RMAP_NODE[768]);
MAKE_VECTOR(gn_RMAP_NODE_767_prev, 2, &gn_RMAP_NODE[766], &gn_RMAP_NODE[763]);
MAKE_VECTOR(gn_RMAP_NODE_768_next, 1, &gn_RMAP_NODE[769]);
MAKE_VECTOR(gn_RMAP_NODE_768_prev, 1, &gn_RMAP_NODE[767]);
MAKE_VECTOR(gn_RMAP_NODE_769_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_769_prev, 1, &gn_RMAP_NODE[768]);
MAKE_VECTOR(gn_RMAP_NODE_770_next, 1, &gn_RMAP_NODE[761]);
MAKE_VECTOR(gn_RMAP_NODE_770_prev, 1, &gn_RMAP_NODE[759]);
MAKE_VECTOR(gn_RMAP_NODE_771_next, 1, &gn_RMAP_NODE[772]);
MAKE_VECTOR(gn_RMAP_NODE_771_prev, 1, &gn_RMAP_NODE[757]);
MAKE_VECTOR(gn_RMAP_NODE_772_next, 2, &gn_RMAP_NODE[773], &gn_RMAP_NODE[774]);
MAKE_VECTOR(gn_RMAP_NODE_772_prev, 1, &gn_RMAP_NODE[771]);
MAKE_VECTOR(gn_RMAP_NODE_773_next, 1, &gn_RMAP_NODE[774]);
MAKE_VECTOR(gn_RMAP_NODE_773_prev, 1, &gn_RMAP_NODE[772]);
MAKE_VECTOR(gn_RMAP_NODE_774_next, 1, &gn_RMAP_NODE[775]);
MAKE_VECTOR(gn_RMAP_NODE_774_prev, 2, &gn_RMAP_NODE[773], &gn_RMAP_NODE[772]);
MAKE_VECTOR(gn_RMAP_NODE_775_next, 2, &gn_RMAP_NODE[776], &gn_RMAP_NODE[779]);
MAKE_VECTOR(gn_RMAP_NODE_775_prev, 1, &gn_RMAP_NODE[774]);
MAKE_VECTOR(gn_RMAP_NODE_776_next, 1, &gn_RMAP_NODE[777]);
MAKE_VECTOR(gn_RMAP_NODE_776_prev, 1, &gn_RMAP_NODE[775]);
MAKE_VECTOR(gn_RMAP_NODE_777_next, 1, &gn_RMAP_NODE[778]);
MAKE_VECTOR(gn_RMAP_NODE_777_prev, 1, &gn_RMAP_NODE[776]);
MAKE_VECTOR(gn_RMAP_NODE_778_next, 1, &gn_RMAP_NODE[779]);
MAKE_VECTOR(gn_RMAP_NODE_778_prev, 1, &gn_RMAP_NODE[777]);
MAKE_VECTOR(gn_RMAP_NODE_779_next, 1, &gn_RMAP_NODE[780]);
MAKE_VECTOR(gn_RMAP_NODE_779_prev, 2, &gn_RMAP_NODE[778], &gn_RMAP_NODE[775]);
MAKE_VECTOR(gn_RMAP_NODE_780_next, 1, &gn_RMAP_NODE[781]);
MAKE_VECTOR(gn_RMAP_NODE_780_prev, 1, &gn_RMAP_NODE[779]);
MAKE_VECTOR(gn_RMAP_NODE_781_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_781_prev, 1, &gn_RMAP_NODE[780]);
MAKE_VECTOR(gn_RMAP_NODE_782_next, 1, &gn_RMAP_NODE[783]);
MAKE_VECTOR(gn_RMAP_NODE_782_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_783_next, 1, &gn_RMAP_NODE[784]);
MAKE_VECTOR(gn_RMAP_NODE_783_prev, 1, &gn_RMAP_NODE[782]);
MAKE_VECTOR(gn_RMAP_NODE_784_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_784_prev, 1, &gn_RMAP_NODE[783]);
MAKE_VECTOR(gn_RMAP_NODE_785_next, 1, &gn_RMAP_NODE[786]);
MAKE_VECTOR(gn_RMAP_NODE_785_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_786_next, 2, &gn_RMAP_NODE[787], &gn_RMAP_NODE[791]);
MAKE_VECTOR(gn_RMAP_NODE_786_prev, 1, &gn_RMAP_NODE[785]);
MAKE_VECTOR(gn_RMAP_NODE_787_next, 3, &gn_RMAP_NODE[788], &gn_RMAP_NODE[794], &gn_RMAP_NODE[795]);
MAKE_VECTOR(gn_RMAP_NODE_787_prev, 1, &gn_RMAP_NODE[786]);
MAKE_VECTOR(gn_RMAP_NODE_788_next, 1, &gn_RMAP_NODE[789]);
MAKE_VECTOR(gn_RMAP_NODE_788_prev, 1, &gn_RMAP_NODE[787]);
MAKE_VECTOR(gn_RMAP_NODE_789_next, 1, &gn_RMAP_NODE[790]);
MAKE_VECTOR(gn_RMAP_NODE_789_prev, 3, &gn_RMAP_NODE[788], &gn_RMAP_NODE[794], &gn_RMAP_NODE[795]);
MAKE_VECTOR(gn_RMAP_NODE_790_next, 1, &gn_RMAP_NODE[791]);
MAKE_VECTOR(gn_RMAP_NODE_790_prev, 1, &gn_RMAP_NODE[789]);
MAKE_VECTOR(gn_RMAP_NODE_791_next, 1, &gn_RMAP_NODE[792]);
MAKE_VECTOR(gn_RMAP_NODE_791_prev, 2, &gn_RMAP_NODE[790], &gn_RMAP_NODE[786]);
MAKE_VECTOR(gn_RMAP_NODE_792_next, 1, &gn_RMAP_NODE[793]);
MAKE_VECTOR(gn_RMAP_NODE_792_prev, 1, &gn_RMAP_NODE[791]);
MAKE_VECTOR(gn_RMAP_NODE_793_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_793_prev, 1, &gn_RMAP_NODE[792]);
MAKE_VECTOR(gn_RMAP_NODE_794_next, 1, &gn_RMAP_NODE[789]);
MAKE_VECTOR(gn_RMAP_NODE_794_prev, 1, &gn_RMAP_NODE[787]);
MAKE_VECTOR(gn_RMAP_NODE_795_next, 1, &gn_RMAP_NODE[789]);
MAKE_VECTOR(gn_RMAP_NODE_795_prev, 1, &gn_RMAP_NODE[787]);
MAKE_VECTOR(gn_RMAP_NODE_796_next, 2, &gn_RMAP_NODE[797], &gn_RMAP_NODE[799]);
MAKE_VECTOR(gn_RMAP_NODE_796_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_797_next, 1, &gn_RMAP_NODE[798]);
MAKE_VECTOR(gn_RMAP_NODE_797_prev, 1, &gn_RMAP_NODE[796]);
MAKE_VECTOR(gn_RMAP_NODE_798_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_798_prev, 1, &gn_RMAP_NODE[797]);
MAKE_VECTOR(gn_RMAP_NODE_799_next, 2, &gn_RMAP_NODE[799], &gn_RMAP_NODE[800]);
MAKE_VECTOR(gn_RMAP_NODE_799_prev, 2, &gn_RMAP_NODE[799], &gn_RMAP_NODE[796]);
MAKE_VECTOR(gn_RMAP_NODE_800_next, 1, &gn_RMAP_NODE[801]);
MAKE_VECTOR(gn_RMAP_NODE_800_prev, 1, &gn_RMAP_NODE[799]);
MAKE_VECTOR(gn_RMAP_NODE_801_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_801_prev, 1, &gn_RMAP_NODE[800]);
MAKE_VECTOR(gn_RMAP_NODE_802_next, 1, &gn_RMAP_NODE[803]);
MAKE_VECTOR(gn_RMAP_NODE_802_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_803_next, 2, &gn_RMAP_NODE[804], &gn_RMAP_NODE[805]);
MAKE_VECTOR(gn_RMAP_NODE_803_prev, 1, &gn_RMAP_NODE[802]);
MAKE_VECTOR(gn_RMAP_NODE_804_next, 1, &gn_RMAP_NODE[805]);
MAKE_VECTOR(gn_RMAP_NODE_804_prev, 1, &gn_RMAP_NODE[803]);
MAKE_VECTOR(gn_RMAP_NODE_805_next, 1, &gn_RMAP_NODE[806]);
MAKE_VECTOR(gn_RMAP_NODE_805_prev, 2, &gn_RMAP_NODE[804], &gn_RMAP_NODE[803]);
MAKE_VECTOR(gn_RMAP_NODE_806_next, 1, &gn_RMAP_NODE[807]);
MAKE_VECTOR(gn_RMAP_NODE_806_prev, 1, &gn_RMAP_NODE[805]);
MAKE_VECTOR(gn_RMAP_NODE_807_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_807_prev, 1, &gn_RMAP_NODE[806]);
MAKE_VECTOR(gn_RMAP_NODE_808_next, 1, &gn_RMAP_NODE[809]);
MAKE_VECTOR(gn_RMAP_NODE_808_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_809_next, 2, &gn_RMAP_NODE[810], &gn_RMAP_NODE[814]);
MAKE_VECTOR(gn_RMAP_NODE_809_prev, 1, &gn_RMAP_NODE[808]);
MAKE_VECTOR(gn_RMAP_NODE_810_next, 1, &gn_RMAP_NODE[811]);
MAKE_VECTOR(gn_RMAP_NODE_810_prev, 1, &gn_RMAP_NODE[809]);
MAKE_VECTOR(gn_RMAP_NODE_811_next, 1, &gn_RMAP_NODE[812]);
MAKE_VECTOR(gn_RMAP_NODE_811_prev, 1, &gn_RMAP_NODE[810]);
MAKE_VECTOR(gn_RMAP_NODE_812_next, 1, &gn_RMAP_NODE[813]);
MAKE_VECTOR(gn_RMAP_NODE_812_prev, 1, &gn_RMAP_NODE[811]);
MAKE_VECTOR(gn_RMAP_NODE_813_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_813_prev, 1, &gn_RMAP_NODE[812]);
MAKE_VECTOR(gn_RMAP_NODE_814_next, 1, &gn_RMAP_NODE[815]);
MAKE_VECTOR(gn_RMAP_NODE_814_prev, 1, &gn_RMAP_NODE[809]);
MAKE_VECTOR(gn_RMAP_NODE_815_next, 1, &gn_RMAP_NODE[816]);
MAKE_VECTOR(gn_RMAP_NODE_815_prev, 1, &gn_RMAP_NODE[814]);
MAKE_VECTOR(gn_RMAP_NODE_816_next, 1, &gn_RMAP_NODE[817]);
MAKE_VECTOR(gn_RMAP_NODE_816_prev, 1, &gn_RMAP_NODE[815]);
MAKE_VECTOR(gn_RMAP_NODE_817_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_817_prev, 1, &gn_RMAP_NODE[816]);
MAKE_VECTOR(gn_RMAP_NODE_818_next, 6, &gn_RMAP_NODE[819], &gn_RMAP_NODE[832], &gn_RMAP_NODE[838], &gn_RMAP_NODE[841], &gn_RMAP_NODE[847], &gn_RMAP_NODE[853]);
MAKE_VECTOR(gn_RMAP_NODE_818_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_819_next, 2, &gn_RMAP_NODE[820], &gn_RMAP_NODE[822]);
MAKE_VECTOR(gn_RMAP_NODE_819_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_820_next, 1, &gn_RMAP_NODE[821]);
MAKE_VECTOR(gn_RMAP_NODE_820_prev, 1, &gn_RMAP_NODE[819]);
MAKE_VECTOR(gn_RMAP_NODE_821_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_821_prev, 1, &gn_RMAP_NODE[820]);
MAKE_VECTOR(gn_RMAP_NODE_822_next, 3, &gn_RMAP_NODE[823], &gn_RMAP_NODE[830], &gn_RMAP_NODE[831]);
MAKE_VECTOR(gn_RMAP_NODE_822_prev, 1, &gn_RMAP_NODE[819]);
MAKE_VECTOR(gn_RMAP_NODE_823_next, 1, &gn_RMAP_NODE[824]);
MAKE_VECTOR(gn_RMAP_NODE_823_prev, 1, &gn_RMAP_NODE[822]);
MAKE_VECTOR(gn_RMAP_NODE_824_next, 1, &gn_RMAP_NODE[825]);
MAKE_VECTOR(gn_RMAP_NODE_824_prev, 3, &gn_RMAP_NODE[823], &gn_RMAP_NODE[830], &gn_RMAP_NODE[831]);
MAKE_VECTOR(gn_RMAP_NODE_825_next, 2, &gn_RMAP_NODE[826], &gn_RMAP_NODE[827]);
MAKE_VECTOR(gn_RMAP_NODE_825_prev, 1, &gn_RMAP_NODE[824]);
MAKE_VECTOR(gn_RMAP_NODE_826_next, 1, &gn_RMAP_NODE[827]);
MAKE_VECTOR(gn_RMAP_NODE_826_prev, 1, &gn_RMAP_NODE[825]);
MAKE_VECTOR(gn_RMAP_NODE_827_next, 1, &gn_RMAP_NODE[828]);
MAKE_VECTOR(gn_RMAP_NODE_827_prev, 2, &gn_RMAP_NODE[826], &gn_RMAP_NODE[825]);
MAKE_VECTOR(gn_RMAP_NODE_828_next, 1, &gn_RMAP_NODE[829]);
MAKE_VECTOR(gn_RMAP_NODE_828_prev, 1, &gn_RMAP_NODE[827]);
MAKE_VECTOR(gn_RMAP_NODE_829_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_829_prev, 1, &gn_RMAP_NODE[828]);
MAKE_VECTOR(gn_RMAP_NODE_830_next, 1, &gn_RMAP_NODE[824]);
MAKE_VECTOR(gn_RMAP_NODE_830_prev, 1, &gn_RMAP_NODE[822]);
MAKE_VECTOR(gn_RMAP_NODE_831_next, 1, &gn_RMAP_NODE[824]);
MAKE_VECTOR(gn_RMAP_NODE_831_prev, 1, &gn_RMAP_NODE[822]);
MAKE_VECTOR(gn_RMAP_NODE_832_next, 2, &gn_RMAP_NODE[833], &gn_RMAP_NODE[835]);
MAKE_VECTOR(gn_RMAP_NODE_832_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_833_next, 1, &gn_RMAP_NODE[834]);
MAKE_VECTOR(gn_RMAP_NODE_833_prev, 1, &gn_RMAP_NODE[832]);
MAKE_VECTOR(gn_RMAP_NODE_834_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_834_prev, 1, &gn_RMAP_NODE[833]);
MAKE_VECTOR(gn_RMAP_NODE_835_next, 2, &gn_RMAP_NODE[835], &gn_RMAP_NODE[836]);
MAKE_VECTOR(gn_RMAP_NODE_835_prev, 2, &gn_RMAP_NODE[835], &gn_RMAP_NODE[832]);
MAKE_VECTOR(gn_RMAP_NODE_836_next, 1, &gn_RMAP_NODE[837]);
MAKE_VECTOR(gn_RMAP_NODE_836_prev, 1, &gn_RMAP_NODE[835]);
MAKE_VECTOR(gn_RMAP_NODE_837_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_837_prev, 1, &gn_RMAP_NODE[836]);
MAKE_VECTOR(gn_RMAP_NODE_838_next, 1, &gn_RMAP_NODE[839]);
MAKE_VECTOR(gn_RMAP_NODE_838_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_839_next, 1, &gn_RMAP_NODE[840]);
MAKE_VECTOR(gn_RMAP_NODE_839_prev, 1, &gn_RMAP_NODE[838]);
MAKE_VECTOR(gn_RMAP_NODE_840_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_840_prev, 1, &gn_RMAP_NODE[839]);
MAKE_VECTOR(gn_RMAP_NODE_841_next, 2, &gn_RMAP_NODE[842], &gn_RMAP_NODE[844]);
MAKE_VECTOR(gn_RMAP_NODE_841_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_842_next, 1, &gn_RMAP_NODE[843]);
MAKE_VECTOR(gn_RMAP_NODE_842_prev, 1, &gn_RMAP_NODE[841]);
MAKE_VECTOR(gn_RMAP_NODE_843_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_843_prev, 1, &gn_RMAP_NODE[842]);
MAKE_VECTOR(gn_RMAP_NODE_844_next, 2, &gn_RMAP_NODE[844], &gn_RMAP_NODE[845]);
MAKE_VECTOR(gn_RMAP_NODE_844_prev, 2, &gn_RMAP_NODE[844], &gn_RMAP_NODE[841]);
MAKE_VECTOR(gn_RMAP_NODE_845_next, 1, &gn_RMAP_NODE[846]);
MAKE_VECTOR(gn_RMAP_NODE_845_prev, 1, &gn_RMAP_NODE[844]);
MAKE_VECTOR(gn_RMAP_NODE_846_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_846_prev, 1, &gn_RMAP_NODE[845]);
MAKE_VECTOR(gn_RMAP_NODE_847_next, 2, &gn_RMAP_NODE[848], &gn_RMAP_NODE[850]);
MAKE_VECTOR(gn_RMAP_NODE_847_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_848_next, 1, &gn_RMAP_NODE[849]);
MAKE_VECTOR(gn_RMAP_NODE_848_prev, 1, &gn_RMAP_NODE[847]);
MAKE_VECTOR(gn_RMAP_NODE_849_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_849_prev, 1, &gn_RMAP_NODE[848]);
MAKE_VECTOR(gn_RMAP_NODE_850_next, 2, &gn_RMAP_NODE[850], &gn_RMAP_NODE[851]);
MAKE_VECTOR(gn_RMAP_NODE_850_prev, 2, &gn_RMAP_NODE[850], &gn_RMAP_NODE[847]);
MAKE_VECTOR(gn_RMAP_NODE_851_next, 1, &gn_RMAP_NODE[852]);
MAKE_VECTOR(gn_RMAP_NODE_851_prev, 1, &gn_RMAP_NODE[850]);
MAKE_VECTOR(gn_RMAP_NODE_852_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_852_prev, 1, &gn_RMAP_NODE[851]);
MAKE_VECTOR(gn_RMAP_NODE_853_next, 2, &gn_RMAP_NODE[854], &gn_RMAP_NODE[856]);
MAKE_VECTOR(gn_RMAP_NODE_853_prev, 1, &gn_RMAP_NODE[818]);
MAKE_VECTOR(gn_RMAP_NODE_854_next, 1, &gn_RMAP_NODE[855]);
MAKE_VECTOR(gn_RMAP_NODE_854_prev, 1, &gn_RMAP_NODE[853]);
MAKE_VECTOR(gn_RMAP_NODE_855_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_855_prev, 1, &gn_RMAP_NODE[854]);
MAKE_VECTOR(gn_RMAP_NODE_856_next, 2, &gn_RMAP_NODE[856], &gn_RMAP_NODE[857]);
MAKE_VECTOR(gn_RMAP_NODE_856_prev, 2, &gn_RMAP_NODE[856], &gn_RMAP_NODE[853]);
MAKE_VECTOR(gn_RMAP_NODE_857_next, 1, &gn_RMAP_NODE[858]);
MAKE_VECTOR(gn_RMAP_NODE_857_prev, 1, &gn_RMAP_NODE[856]);
MAKE_VECTOR(gn_RMAP_NODE_858_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_858_prev, 1, &gn_RMAP_NODE[857]);
MAKE_VECTOR(gn_RMAP_NODE_859_next, 1, &gn_RMAP_NODE[860]);
MAKE_VECTOR(gn_RMAP_NODE_859_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_860_next, 2, &gn_RMAP_NODE[861], &gn_RMAP_NODE[864]);
MAKE_VECTOR(gn_RMAP_NODE_860_prev, 1, &gn_RMAP_NODE[859]);
MAKE_VECTOR(gn_RMAP_NODE_861_next, 3, &gn_RMAP_NODE[862], &gn_RMAP_NODE[868], &gn_RMAP_NODE[869]);
MAKE_VECTOR(gn_RMAP_NODE_861_prev, 1, &gn_RMAP_NODE[860]);
MAKE_VECTOR(gn_RMAP_NODE_862_next, 1, &gn_RMAP_NODE[863]);
MAKE_VECTOR(gn_RMAP_NODE_862_prev, 1, &gn_RMAP_NODE[861]);
MAKE_VECTOR(gn_RMAP_NODE_863_next, 1, &gn_RMAP_NODE[864]);
MAKE_VECTOR(gn_RMAP_NODE_863_prev, 3, &gn_RMAP_NODE[862], &gn_RMAP_NODE[868], &gn_RMAP_NODE[869]);
MAKE_VECTOR(gn_RMAP_NODE_864_next, 1, &gn_RMAP_NODE[865]);
MAKE_VECTOR(gn_RMAP_NODE_864_prev, 2, &gn_RMAP_NODE[863], &gn_RMAP_NODE[860]);
MAKE_VECTOR(gn_RMAP_NODE_865_next, 1, &gn_RMAP_NODE[866]);
MAKE_VECTOR(gn_RMAP_NODE_865_prev, 1, &gn_RMAP_NODE[864]);
MAKE_VECTOR(gn_RMAP_NODE_866_next, 1, &gn_RMAP_NODE[867]);
MAKE_VECTOR(gn_RMAP_NODE_866_prev, 1, &gn_RMAP_NODE[865]);
MAKE_VECTOR(gn_RMAP_NODE_867_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_867_prev, 1, &gn_RMAP_NODE[866]);
MAKE_VECTOR(gn_RMAP_NODE_868_next, 1, &gn_RMAP_NODE[863]);
MAKE_VECTOR(gn_RMAP_NODE_868_prev, 1, &gn_RMAP_NODE[861]);
MAKE_VECTOR(gn_RMAP_NODE_869_next, 1, &gn_RMAP_NODE[863]);
MAKE_VECTOR(gn_RMAP_NODE_869_prev, 1, &gn_RMAP_NODE[861]);
MAKE_VECTOR(gn_RMAP_NODE_870_next, 1, &gn_RMAP_NODE[871]);
MAKE_VECTOR(gn_RMAP_NODE_870_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_871_next, 2, &gn_RMAP_NODE[872], &gn_RMAP_NODE[873]);
MAKE_VECTOR(gn_RMAP_NODE_871_prev, 1, &gn_RMAP_NODE[870]);
MAKE_VECTOR(gn_RMAP_NODE_872_next, 1, &gn_RMAP_NODE[873]);
MAKE_VECTOR(gn_RMAP_NODE_872_prev, 1, &gn_RMAP_NODE[871]);
MAKE_VECTOR(gn_RMAP_NODE_873_next, 1, &gn_RMAP_NODE[874]);
MAKE_VECTOR(gn_RMAP_NODE_873_prev, 2, &gn_RMAP_NODE[872], &gn_RMAP_NODE[871]);
MAKE_VECTOR(gn_RMAP_NODE_874_next, 1, &gn_RMAP_NODE[875]);
MAKE_VECTOR(gn_RMAP_NODE_874_prev, 1, &gn_RMAP_NODE[873]);
MAKE_VECTOR(gn_RMAP_NODE_875_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_875_prev, 1, &gn_RMAP_NODE[874]);
MAKE_VECTOR(gn_RMAP_NODE_876_next, 1, &gn_RMAP_NODE[877]);
MAKE_VECTOR(gn_RMAP_NODE_876_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_877_next, 1, &gn_RMAP_NODE[878]);
MAKE_VECTOR(gn_RMAP_NODE_877_prev, 1, &gn_RMAP_NODE[876]);
MAKE_VECTOR(gn_RMAP_NODE_878_next, 2, &gn_RMAP_NODE[879], &gn_RMAP_NODE[880]);
MAKE_VECTOR(gn_RMAP_NODE_878_prev, 1, &gn_RMAP_NODE[877]);
MAKE_VECTOR(gn_RMAP_NODE_879_next, 1, &gn_RMAP_NODE[880]);
MAKE_VECTOR(gn_RMAP_NODE_879_prev, 1, &gn_RMAP_NODE[878]);
MAKE_VECTOR(gn_RMAP_NODE_880_next, 1, &gn_RMAP_NODE[881]);
MAKE_VECTOR(gn_RMAP_NODE_880_prev, 2, &gn_RMAP_NODE[879], &gn_RMAP_NODE[878]);
MAKE_VECTOR(gn_RMAP_NODE_881_next, 1, &gn_RMAP_NODE[882]);
MAKE_VECTOR(gn_RMAP_NODE_881_prev, 1, &gn_RMAP_NODE[880]);
MAKE_VECTOR(gn_RMAP_NODE_882_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_882_prev, 1, &gn_RMAP_NODE[881]);
MAKE_VECTOR(gn_RMAP_NODE_883_next, 1, &gn_RMAP_NODE[884]);
MAKE_VECTOR(gn_RMAP_NODE_883_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_884_next, 4, &gn_RMAP_NODE[885], &gn_RMAP_NODE[889], &gn_RMAP_NODE[895], &gn_RMAP_NODE[898]);
MAKE_VECTOR(gn_RMAP_NODE_884_prev, 1, &gn_RMAP_NODE[883]);
MAKE_VECTOR(gn_RMAP_NODE_885_next, 1, &gn_RMAP_NODE[886]);
MAKE_VECTOR(gn_RMAP_NODE_885_prev, 1, &gn_RMAP_NODE[884]);
MAKE_VECTOR(gn_RMAP_NODE_886_next, 1, &gn_RMAP_NODE[887]);
MAKE_VECTOR(gn_RMAP_NODE_886_prev, 1, &gn_RMAP_NODE[885]);
MAKE_VECTOR(gn_RMAP_NODE_887_next, 1, &gn_RMAP_NODE[888]);
MAKE_VECTOR(gn_RMAP_NODE_887_prev, 1, &gn_RMAP_NODE[886]);
MAKE_VECTOR(gn_RMAP_NODE_888_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_888_prev, 1, &gn_RMAP_NODE[887]);
MAKE_VECTOR(gn_RMAP_NODE_889_next, 1, &gn_RMAP_NODE[890]);
MAKE_VECTOR(gn_RMAP_NODE_889_prev, 1, &gn_RMAP_NODE[884]);
MAKE_VECTOR(gn_RMAP_NODE_890_next, 2, &gn_RMAP_NODE[891], &gn_RMAP_NODE[892]);
MAKE_VECTOR(gn_RMAP_NODE_890_prev, 1, &gn_RMAP_NODE[889]);
MAKE_VECTOR(gn_RMAP_NODE_891_next, 1, &gn_RMAP_NODE[892]);
MAKE_VECTOR(gn_RMAP_NODE_891_prev, 1, &gn_RMAP_NODE[890]);
MAKE_VECTOR(gn_RMAP_NODE_892_next, 1, &gn_RMAP_NODE[893]);
MAKE_VECTOR(gn_RMAP_NODE_892_prev, 2, &gn_RMAP_NODE[891], &gn_RMAP_NODE[890]);
MAKE_VECTOR(gn_RMAP_NODE_893_next, 1, &gn_RMAP_NODE[894]);
MAKE_VECTOR(gn_RMAP_NODE_893_prev, 1, &gn_RMAP_NODE[892]);
MAKE_VECTOR(gn_RMAP_NODE_894_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_894_prev, 1, &gn_RMAP_NODE[893]);
MAKE_VECTOR(gn_RMAP_NODE_895_next, 1, &gn_RMAP_NODE[896]);
MAKE_VECTOR(gn_RMAP_NODE_895_prev, 1, &gn_RMAP_NODE[884]);
MAKE_VECTOR(gn_RMAP_NODE_896_next, 1, &gn_RMAP_NODE[897]);
MAKE_VECTOR(gn_RMAP_NODE_896_prev, 1, &gn_RMAP_NODE[895]);
MAKE_VECTOR(gn_RMAP_NODE_897_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_897_prev, 1, &gn_RMAP_NODE[896]);
MAKE_VECTOR(gn_RMAP_NODE_898_next, 1, &gn_RMAP_NODE[899]);
MAKE_VECTOR(gn_RMAP_NODE_898_prev, 1, &gn_RMAP_NODE[884]);
MAKE_VECTOR(gn_RMAP_NODE_899_next, 1, &gn_RMAP_NODE[900]);
MAKE_VECTOR(gn_RMAP_NODE_899_prev, 1, &gn_RMAP_NODE[898]);
MAKE_VECTOR(gn_RMAP_NODE_900_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_900_prev, 1, &gn_RMAP_NODE[899]);
MAKE_VECTOR(gn_RMAP_NODE_901_next, 1, &gn_RMAP_NODE[902]);
MAKE_VECTOR(gn_RMAP_NODE_901_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_902_next, 2, &gn_RMAP_NODE[903], &gn_RMAP_NODE[904]);
MAKE_VECTOR(gn_RMAP_NODE_902_prev, 1, &gn_RMAP_NODE[901]);
MAKE_VECTOR(gn_RMAP_NODE_903_next, 1, &gn_RMAP_NODE[904]);
MAKE_VECTOR(gn_RMAP_NODE_903_prev, 1, &gn_RMAP_NODE[902]);
MAKE_VECTOR(gn_RMAP_NODE_904_next, 1, &gn_RMAP_NODE[905]);
MAKE_VECTOR(gn_RMAP_NODE_904_prev, 2, &gn_RMAP_NODE[903], &gn_RMAP_NODE[902]);
MAKE_VECTOR(gn_RMAP_NODE_905_next, 1, &gn_RMAP_NODE[906]);
MAKE_VECTOR(gn_RMAP_NODE_905_prev, 1, &gn_RMAP_NODE[904]);
MAKE_VECTOR(gn_RMAP_NODE_906_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_906_prev, 1, &gn_RMAP_NODE[905]);
MAKE_VECTOR(gn_RMAP_NODE_907_next, 2, &gn_RMAP_NODE[908], &gn_RMAP_NODE[910]);
MAKE_VECTOR(gn_RMAP_NODE_907_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_908_next, 1, &gn_RMAP_NODE[909]);
MAKE_VECTOR(gn_RMAP_NODE_908_prev, 1, &gn_RMAP_NODE[907]);
MAKE_VECTOR(gn_RMAP_NODE_909_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_909_prev, 1, &gn_RMAP_NODE[908]);
MAKE_VECTOR(gn_RMAP_NODE_910_next, 3, &gn_RMAP_NODE[911], &gn_RMAP_NODE[918], &gn_RMAP_NODE[919]);
MAKE_VECTOR(gn_RMAP_NODE_910_prev, 1, &gn_RMAP_NODE[907]);
MAKE_VECTOR(gn_RMAP_NODE_911_next, 1, &gn_RMAP_NODE[912]);
MAKE_VECTOR(gn_RMAP_NODE_911_prev, 1, &gn_RMAP_NODE[910]);
MAKE_VECTOR(gn_RMAP_NODE_912_next, 1, &gn_RMAP_NODE[913]);
MAKE_VECTOR(gn_RMAP_NODE_912_prev, 3, &gn_RMAP_NODE[911], &gn_RMAP_NODE[918], &gn_RMAP_NODE[919]);
MAKE_VECTOR(gn_RMAP_NODE_913_next, 2, &gn_RMAP_NODE[914], &gn_RMAP_NODE[915]);
MAKE_VECTOR(gn_RMAP_NODE_913_prev, 1, &gn_RMAP_NODE[912]);
MAKE_VECTOR(gn_RMAP_NODE_914_next, 1, &gn_RMAP_NODE[915]);
MAKE_VECTOR(gn_RMAP_NODE_914_prev, 1, &gn_RMAP_NODE[913]);
MAKE_VECTOR(gn_RMAP_NODE_915_next, 1, &gn_RMAP_NODE[916]);
MAKE_VECTOR(gn_RMAP_NODE_915_prev, 2, &gn_RMAP_NODE[914], &gn_RMAP_NODE[913]);
MAKE_VECTOR(gn_RMAP_NODE_916_next, 1, &gn_RMAP_NODE[917]);
MAKE_VECTOR(gn_RMAP_NODE_916_prev, 1, &gn_RMAP_NODE[915]);
MAKE_VECTOR(gn_RMAP_NODE_917_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_917_prev, 1, &gn_RMAP_NODE[916]);
MAKE_VECTOR(gn_RMAP_NODE_918_next, 1, &gn_RMAP_NODE[912]);
MAKE_VECTOR(gn_RMAP_NODE_918_prev, 1, &gn_RMAP_NODE[910]);
MAKE_VECTOR(gn_RMAP_NODE_919_next, 1, &gn_RMAP_NODE[912]);
MAKE_VECTOR(gn_RMAP_NODE_919_prev, 1, &gn_RMAP_NODE[910]);
MAKE_VECTOR(gn_RMAP_NODE_920_next, 3, &gn_RMAP_NODE[921], &gn_RMAP_NODE[923], &gn_RMAP_NODE[926]);
MAKE_VECTOR(gn_RMAP_NODE_920_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_921_next, 1, &gn_RMAP_NODE[922]);
MAKE_VECTOR(gn_RMAP_NODE_921_prev, 1, &gn_RMAP_NODE[920]);
MAKE_VECTOR(gn_RMAP_NODE_922_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_922_prev, 1, &gn_RMAP_NODE[921]);
MAKE_VECTOR(gn_RMAP_NODE_923_next, 2, &gn_RMAP_NODE[923], &gn_RMAP_NODE[924]);
MAKE_VECTOR(gn_RMAP_NODE_923_prev, 2, &gn_RMAP_NODE[923], &gn_RMAP_NODE[920]);
MAKE_VECTOR(gn_RMAP_NODE_924_next, 1, &gn_RMAP_NODE[925]);
MAKE_VECTOR(gn_RMAP_NODE_924_prev, 1, &gn_RMAP_NODE[923]);
MAKE_VECTOR(gn_RMAP_NODE_925_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_925_prev, 1, &gn_RMAP_NODE[924]);
MAKE_VECTOR(gn_RMAP_NODE_926_next, 1, &gn_RMAP_NODE[927]);
MAKE_VECTOR(gn_RMAP_NODE_926_prev, 1, &gn_RMAP_NODE[920]);
MAKE_VECTOR(gn_RMAP_NODE_927_next, 1, &gn_RMAP_NODE[928]);
MAKE_VECTOR(gn_RMAP_NODE_927_prev, 1, &gn_RMAP_NODE[926]);
MAKE_VECTOR(gn_RMAP_NODE_928_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_928_prev, 1, &gn_RMAP_NODE[927]);
MAKE_VECTOR(gn_RMAP_NODE_929_next, 1, &gn_RMAP_NODE[930]);
MAKE_VECTOR(gn_RMAP_NODE_929_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_930_next, 2, &gn_RMAP_NODE[931], &gn_RMAP_NODE[932]);
MAKE_VECTOR(gn_RMAP_NODE_930_prev, 1, &gn_RMAP_NODE[929]);
MAKE_VECTOR(gn_RMAP_NODE_931_next, 1, &gn_RMAP_NODE[932]);
MAKE_VECTOR(gn_RMAP_NODE_931_prev, 1, &gn_RMAP_NODE[930]);
MAKE_VECTOR(gn_RMAP_NODE_932_next, 1, &gn_RMAP_NODE[933]);
MAKE_VECTOR(gn_RMAP_NODE_932_prev, 2, &gn_RMAP_NODE[931], &gn_RMAP_NODE[930]);
MAKE_VECTOR(gn_RMAP_NODE_933_next, 1, &gn_RMAP_NODE[934]);
MAKE_VECTOR(gn_RMAP_NODE_933_prev, 1, &gn_RMAP_NODE[932]);
MAKE_VECTOR(gn_RMAP_NODE_934_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_934_prev, 1, &gn_RMAP_NODE[933]);
MAKE_VECTOR(gn_RMAP_NODE_935_next, 1, &gn_RMAP_NODE[936]);
MAKE_VECTOR(gn_RMAP_NODE_935_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_936_next, 2, &gn_RMAP_NODE[937], &gn_RMAP_NODE[938]);
MAKE_VECTOR(gn_RMAP_NODE_936_prev, 1, &gn_RMAP_NODE[935]);
MAKE_VECTOR(gn_RMAP_NODE_937_next, 1, &gn_RMAP_NODE[938]);
MAKE_VECTOR(gn_RMAP_NODE_937_prev, 1, &gn_RMAP_NODE[936]);
MAKE_VECTOR(gn_RMAP_NODE_938_next, 1, &gn_RMAP_NODE[939]);
MAKE_VECTOR(gn_RMAP_NODE_938_prev, 2, &gn_RMAP_NODE[937], &gn_RMAP_NODE[936]);
MAKE_VECTOR(gn_RMAP_NODE_939_next, 1, &gn_RMAP_NODE[940]);
MAKE_VECTOR(gn_RMAP_NODE_939_prev, 1, &gn_RMAP_NODE[938]);
MAKE_VECTOR(gn_RMAP_NODE_940_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_940_prev, 1, &gn_RMAP_NODE[939]);
MAKE_VECTOR(gn_RMAP_NODE_941_next, 1, &gn_RMAP_NODE[942]);
MAKE_VECTOR(gn_RMAP_NODE_941_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_942_next, 2, &gn_RMAP_NODE[943], &gn_RMAP_NODE[944]);
MAKE_VECTOR(gn_RMAP_NODE_942_prev, 1, &gn_RMAP_NODE[941]);
MAKE_VECTOR(gn_RMAP_NODE_943_next, 1, &gn_RMAP_NODE[944]);
MAKE_VECTOR(gn_RMAP_NODE_943_prev, 1, &gn_RMAP_NODE[942]);
MAKE_VECTOR(gn_RMAP_NODE_944_next, 1, &gn_RMAP_NODE[945]);
MAKE_VECTOR(gn_RMAP_NODE_944_prev, 2, &gn_RMAP_NODE[943], &gn_RMAP_NODE[942]);
MAKE_VECTOR(gn_RMAP_NODE_945_next, 1, &gn_RMAP_NODE[946]);
MAKE_VECTOR(gn_RMAP_NODE_945_prev, 1, &gn_RMAP_NODE[944]);
MAKE_VECTOR(gn_RMAP_NODE_946_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_946_prev, 1, &gn_RMAP_NODE[945]);
MAKE_VECTOR(gn_RMAP_NODE_947_next, 1, &gn_RMAP_NODE[948]);
MAKE_VECTOR(gn_RMAP_NODE_947_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_948_next, 2, &gn_RMAP_NODE[949], &gn_RMAP_NODE[952]);
MAKE_VECTOR(gn_RMAP_NODE_948_prev, 1, &gn_RMAP_NODE[947]);
MAKE_VECTOR(gn_RMAP_NODE_949_next, 2, &gn_RMAP_NODE[950], &gn_RMAP_NODE[955]);
MAKE_VECTOR(gn_RMAP_NODE_949_prev, 1, &gn_RMAP_NODE[948]);
MAKE_VECTOR(gn_RMAP_NODE_950_next, 1, &gn_RMAP_NODE[951]);
MAKE_VECTOR(gn_RMAP_NODE_950_prev, 1, &gn_RMAP_NODE[949]);
MAKE_VECTOR(gn_RMAP_NODE_951_next, 1, &gn_RMAP_NODE[952]);
MAKE_VECTOR(gn_RMAP_NODE_951_prev, 2, &gn_RMAP_NODE[950], &gn_RMAP_NODE[955]);
MAKE_VECTOR(gn_RMAP_NODE_952_next, 1, &gn_RMAP_NODE[953]);
MAKE_VECTOR(gn_RMAP_NODE_952_prev, 2, &gn_RMAP_NODE[951], &gn_RMAP_NODE[948]);
MAKE_VECTOR(gn_RMAP_NODE_953_next, 1, &gn_RMAP_NODE[954]);
MAKE_VECTOR(gn_RMAP_NODE_953_prev, 1, &gn_RMAP_NODE[952]);
MAKE_VECTOR(gn_RMAP_NODE_954_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_954_prev, 1, &gn_RMAP_NODE[953]);
MAKE_VECTOR(gn_RMAP_NODE_955_next, 1, &gn_RMAP_NODE[951]);
MAKE_VECTOR(gn_RMAP_NODE_955_prev, 1, &gn_RMAP_NODE[949]);
MAKE_VECTOR(gn_RMAP_NODE_956_next, 1, &gn_RMAP_NODE[957]);
MAKE_VECTOR(gn_RMAP_NODE_956_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_957_next, 2, &gn_RMAP_NODE[958], &gn_RMAP_NODE[959]);
MAKE_VECTOR(gn_RMAP_NODE_957_prev, 1, &gn_RMAP_NODE[956]);
MAKE_VECTOR(gn_RMAP_NODE_958_next, 1, &gn_RMAP_NODE[959]);
MAKE_VECTOR(gn_RMAP_NODE_958_prev, 1, &gn_RMAP_NODE[957]);
MAKE_VECTOR(gn_RMAP_NODE_959_next, 1, &gn_RMAP_NODE[960]);
MAKE_VECTOR(gn_RMAP_NODE_959_prev, 2, &gn_RMAP_NODE[958], &gn_RMAP_NODE[957]);
MAKE_VECTOR(gn_RMAP_NODE_960_next, 1, &gn_RMAP_NODE[961]);
MAKE_VECTOR(gn_RMAP_NODE_960_prev, 1, &gn_RMAP_NODE[959]);
MAKE_VECTOR(gn_RMAP_NODE_961_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_961_prev, 1, &gn_RMAP_NODE[960]);
MAKE_VECTOR(gn_RMAP_NODE_962_next, 1, &gn_RMAP_NODE[963]);
MAKE_VECTOR(gn_RMAP_NODE_962_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_963_next, 2, &gn_RMAP_NODE[964], &gn_RMAP_NODE[967]);
MAKE_VECTOR(gn_RMAP_NODE_963_prev, 1, &gn_RMAP_NODE[962]);
MAKE_VECTOR(gn_RMAP_NODE_964_next, 3, &gn_RMAP_NODE[965], &gn_RMAP_NODE[970], &gn_RMAP_NODE[971]);
MAKE_VECTOR(gn_RMAP_NODE_964_prev, 1, &gn_RMAP_NODE[963]);
MAKE_VECTOR(gn_RMAP_NODE_965_next, 1, &gn_RMAP_NODE[966]);
MAKE_VECTOR(gn_RMAP_NODE_965_prev, 1, &gn_RMAP_NODE[964]);
MAKE_VECTOR(gn_RMAP_NODE_966_next, 1, &gn_RMAP_NODE[967]);
MAKE_VECTOR(gn_RMAP_NODE_966_prev, 3, &gn_RMAP_NODE[965], &gn_RMAP_NODE[970], &gn_RMAP_NODE[971]);
MAKE_VECTOR(gn_RMAP_NODE_967_next, 1, &gn_RMAP_NODE[968]);
MAKE_VECTOR(gn_RMAP_NODE_967_prev, 2, &gn_RMAP_NODE[966], &gn_RMAP_NODE[963]);
MAKE_VECTOR(gn_RMAP_NODE_968_next, 1, &gn_RMAP_NODE[969]);
MAKE_VECTOR(gn_RMAP_NODE_968_prev, 1, &gn_RMAP_NODE[967]);
MAKE_VECTOR(gn_RMAP_NODE_969_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_969_prev, 1, &gn_RMAP_NODE[968]);
MAKE_VECTOR(gn_RMAP_NODE_970_next, 1, &gn_RMAP_NODE[966]);
MAKE_VECTOR(gn_RMAP_NODE_970_prev, 1, &gn_RMAP_NODE[964]);
MAKE_VECTOR(gn_RMAP_NODE_971_next, 1, &gn_RMAP_NODE[966]);
MAKE_VECTOR(gn_RMAP_NODE_971_prev, 1, &gn_RMAP_NODE[964]);
MAKE_VECTOR(gn_RMAP_NODE_972_next, 1, &gn_RMAP_NODE[973]);
MAKE_VECTOR(gn_RMAP_NODE_972_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_973_next, 2, &gn_RMAP_NODE[974], &gn_RMAP_NODE[975]);
MAKE_VECTOR(gn_RMAP_NODE_973_prev, 1, &gn_RMAP_NODE[972]);
MAKE_VECTOR(gn_RMAP_NODE_974_next, 1, &gn_RMAP_NODE[975]);
MAKE_VECTOR(gn_RMAP_NODE_974_prev, 1, &gn_RMAP_NODE[973]);
MAKE_VECTOR(gn_RMAP_NODE_975_next, 1, &gn_RMAP_NODE[976]);
MAKE_VECTOR(gn_RMAP_NODE_975_prev, 2, &gn_RMAP_NODE[974], &gn_RMAP_NODE[973]);
MAKE_VECTOR(gn_RMAP_NODE_976_next, 1, &gn_RMAP_NODE[977]);
MAKE_VECTOR(gn_RMAP_NODE_976_prev, 1, &gn_RMAP_NODE[975]);
MAKE_VECTOR(gn_RMAP_NODE_977_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_977_prev, 1, &gn_RMAP_NODE[976]);
MAKE_VECTOR(gn_RMAP_NODE_978_next, 1, &gn_RMAP_NODE[979]);
MAKE_VECTOR(gn_RMAP_NODE_978_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_979_next, 1, &gn_RMAP_NODE[980]);
MAKE_VECTOR(gn_RMAP_NODE_979_prev, 1, &gn_RMAP_NODE[978]);
MAKE_VECTOR(gn_RMAP_NODE_980_next, 2, &gn_RMAP_NODE[981], &gn_RMAP_NODE[982]);
MAKE_VECTOR(gn_RMAP_NODE_980_prev, 1, &gn_RMAP_NODE[979]);
MAKE_VECTOR(gn_RMAP_NODE_981_next, 1, &gn_RMAP_NODE[982]);
MAKE_VECTOR(gn_RMAP_NODE_981_prev, 1, &gn_RMAP_NODE[980]);
MAKE_VECTOR(gn_RMAP_NODE_982_next, 1, &gn_RMAP_NODE[983]);
MAKE_VECTOR(gn_RMAP_NODE_982_prev, 2, &gn_RMAP_NODE[981], &gn_RMAP_NODE[980]);
MAKE_VECTOR(gn_RMAP_NODE_983_next, 1, &gn_RMAP_NODE[984]);
MAKE_VECTOR(gn_RMAP_NODE_983_prev, 1, &gn_RMAP_NODE[982]);
MAKE_VECTOR(gn_RMAP_NODE_984_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_984_prev, 1, &gn_RMAP_NODE[983]);
MAKE_VECTOR(gn_RMAP_NODE_985_next, 1, &gn_RMAP_NODE[986]);
MAKE_VECTOR(gn_RMAP_NODE_985_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_986_next, 2, &gn_RMAP_NODE[987], &gn_RMAP_NODE[990]);
MAKE_VECTOR(gn_RMAP_NODE_986_prev, 1, &gn_RMAP_NODE[985]);
MAKE_VECTOR(gn_RMAP_NODE_987_next, 2, &gn_RMAP_NODE[988], &gn_RMAP_NODE[993]);
MAKE_VECTOR(gn_RMAP_NODE_987_prev, 1, &gn_RMAP_NODE[986]);
MAKE_VECTOR(gn_RMAP_NODE_988_next, 1, &gn_RMAP_NODE[989]);
MAKE_VECTOR(gn_RMAP_NODE_988_prev, 1, &gn_RMAP_NODE[987]);
MAKE_VECTOR(gn_RMAP_NODE_989_next, 1, &gn_RMAP_NODE[990]);
MAKE_VECTOR(gn_RMAP_NODE_989_prev, 2, &gn_RMAP_NODE[988], &gn_RMAP_NODE[993]);
MAKE_VECTOR(gn_RMAP_NODE_990_next, 1, &gn_RMAP_NODE[991]);
MAKE_VECTOR(gn_RMAP_NODE_990_prev, 2, &gn_RMAP_NODE[989], &gn_RMAP_NODE[986]);
MAKE_VECTOR(gn_RMAP_NODE_991_next, 1, &gn_RMAP_NODE[992]);
MAKE_VECTOR(gn_RMAP_NODE_991_prev, 1, &gn_RMAP_NODE[990]);
MAKE_VECTOR(gn_RMAP_NODE_992_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_992_prev, 1, &gn_RMAP_NODE[991]);
MAKE_VECTOR(gn_RMAP_NODE_993_next, 1, &gn_RMAP_NODE[989]);
MAKE_VECTOR(gn_RMAP_NODE_993_prev, 1, &gn_RMAP_NODE[987]);
MAKE_VECTOR(gn_RMAP_NODE_994_next, 1, &gn_RMAP_NODE[995]);
MAKE_VECTOR(gn_RMAP_NODE_994_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_995_next, 2, &gn_RMAP_NODE[996], &gn_RMAP_NODE[997]);
MAKE_VECTOR(gn_RMAP_NODE_995_prev, 1, &gn_RMAP_NODE[994]);
MAKE_VECTOR(gn_RMAP_NODE_996_next, 1, &gn_RMAP_NODE[997]);
MAKE_VECTOR(gn_RMAP_NODE_996_prev, 1, &gn_RMAP_NODE[995]);
MAKE_VECTOR(gn_RMAP_NODE_997_next, 1, &gn_RMAP_NODE[998]);
MAKE_VECTOR(gn_RMAP_NODE_997_prev, 2, &gn_RMAP_NODE[996], &gn_RMAP_NODE[995]);
MAKE_VECTOR(gn_RMAP_NODE_998_next, 1, &gn_RMAP_NODE[999]);
MAKE_VECTOR(gn_RMAP_NODE_998_prev, 1, &gn_RMAP_NODE[997]);
MAKE_VECTOR(gn_RMAP_NODE_999_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_999_prev, 1, &gn_RMAP_NODE[998]);
MAKE_VECTOR(gn_RMAP_NODE_1000_next, 1, &gn_RMAP_NODE[1001]);
MAKE_VECTOR(gn_RMAP_NODE_1000_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_1001_next, 2, &gn_RMAP_NODE[1002], &gn_RMAP_NODE[1005]);
MAKE_VECTOR(gn_RMAP_NODE_1001_prev, 1, &gn_RMAP_NODE[1000]);
MAKE_VECTOR(gn_RMAP_NODE_1002_next, 2, &gn_RMAP_NODE[1003], &gn_RMAP_NODE[1008]);
MAKE_VECTOR(gn_RMAP_NODE_1002_prev, 1, &gn_RMAP_NODE[1001]);
MAKE_VECTOR(gn_RMAP_NODE_1003_next, 1, &gn_RMAP_NODE[1004]);
MAKE_VECTOR(gn_RMAP_NODE_1003_prev, 1, &gn_RMAP_NODE[1002]);
MAKE_VECTOR(gn_RMAP_NODE_1004_next, 1, &gn_RMAP_NODE[1005]);
MAKE_VECTOR(gn_RMAP_NODE_1004_prev, 2, &gn_RMAP_NODE[1003], &gn_RMAP_NODE[1008]);
MAKE_VECTOR(gn_RMAP_NODE_1005_next, 1, &gn_RMAP_NODE[1006]);
MAKE_VECTOR(gn_RMAP_NODE_1005_prev, 2, &gn_RMAP_NODE[1004], &gn_RMAP_NODE[1001]);
MAKE_VECTOR(gn_RMAP_NODE_1006_next, 1, &gn_RMAP_NODE[1007]);
MAKE_VECTOR(gn_RMAP_NODE_1006_prev, 1, &gn_RMAP_NODE[1005]);
MAKE_VECTOR(gn_RMAP_NODE_1007_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1007_prev, 1, &gn_RMAP_NODE[1006]);
MAKE_VECTOR(gn_RMAP_NODE_1008_next, 1, &gn_RMAP_NODE[1004]);
MAKE_VECTOR(gn_RMAP_NODE_1008_prev, 1, &gn_RMAP_NODE[1002]);
MAKE_VECTOR(gn_RMAP_NODE_1009_next, 1, &gn_RMAP_NODE[1010]);
MAKE_VECTOR(gn_RMAP_NODE_1009_prev, 1, &gn_RMAP_NODE[700]);
MAKE_VECTOR(gn_RMAP_NODE_1010_next, 2, &gn_RMAP_NODE[1011], &gn_RMAP_NODE[1012]);
MAKE_VECTOR(gn_RMAP_NODE_1010_prev, 1, &gn_RMAP_NODE[1009]);
MAKE_VECTOR(gn_RMAP_NODE_1011_next, 1, &gn_RMAP_NODE[1012]);
MAKE_VECTOR(gn_RMAP_NODE_1011_prev, 1, &gn_RMAP_NODE[1010]);
MAKE_VECTOR(gn_RMAP_NODE_1012_next, 1, &gn_RMAP_NODE[1013]);
MAKE_VECTOR(gn_RMAP_NODE_1012_prev, 2, &gn_RMAP_NODE[1011], &gn_RMAP_NODE[1010]);
MAKE_VECTOR(gn_RMAP_NODE_1013_next, 1, &gn_RMAP_NODE[1014]);
MAKE_VECTOR(gn_RMAP_NODE_1013_prev, 1, &gn_RMAP_NODE[1012]);
MAKE_VECTOR(gn_RMAP_NODE_1014_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1014_prev, 1, &gn_RMAP_NODE[1013]);
MAKE_VECTOR(gn_RMAP_NODE_1015_next, 2, &gn_RMAP_NODE[1016], &gn_RMAP_NODE[1020]);
MAKE_VECTOR(gn_RMAP_NODE_1015_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_1016_next, 1, &gn_RMAP_NODE[1017]);
MAKE_VECTOR(gn_RMAP_NODE_1016_prev, 1, &gn_RMAP_NODE[1015]);
MAKE_VECTOR(gn_RMAP_NODE_1017_next, 1, &gn_RMAP_NODE[1018]);
MAKE_VECTOR(gn_RMAP_NODE_1017_prev, 1, &gn_RMAP_NODE[1016]);
MAKE_VECTOR(gn_RMAP_NODE_1018_next, 1, &gn_RMAP_NODE[1019]);
MAKE_VECTOR(gn_RMAP_NODE_1018_prev, 1, &gn_RMAP_NODE[1017]);
MAKE_VECTOR(gn_RMAP_NODE_1019_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1019_prev, 1, &gn_RMAP_NODE[1018]);
MAKE_VECTOR(gn_RMAP_NODE_1020_next, 1, &gn_RMAP_NODE[1021]);
MAKE_VECTOR(gn_RMAP_NODE_1020_prev, 1, &gn_RMAP_NODE[1015]);
MAKE_VECTOR(gn_RMAP_NODE_1021_next, 1, &gn_RMAP_NODE[1022]);
MAKE_VECTOR(gn_RMAP_NODE_1021_prev, 1, &gn_RMAP_NODE[1020]);
MAKE_VECTOR(gn_RMAP_NODE_1022_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1022_prev, 1, &gn_RMAP_NODE[1021]);
MAKE_VECTOR(gn_RMAP_NODE_1023_next, 29, &gn_RMAP_NODE[1024], &gn_RMAP_NODE[1036], &gn_RMAP_NODE[1042], &gn_RMAP_NODE[1049], &gn_RMAP_NODE[1087], &gn_RMAP_NODE[1090], &gn_RMAP_NODE[1099], &gn_RMAP_NODE[1106], &gn_RMAP_NODE[1110], &gn_RMAP_NODE[1120], &gn_RMAP_NODE[1151], &gn_RMAP_NODE[1160], &gn_RMAP_NODE[1164], &gn_RMAP_NODE[1169], &gn_RMAP_NODE[1185], &gn_RMAP_NODE[1189], &gn_RMAP_NODE[1198], &gn_RMAP_NODE[1205], &gn_RMAP_NODE[1209], &gn_RMAP_NODE[1215], &gn_RMAP_NODE[1226], &gn_RMAP_NODE[1233], &gn_RMAP_NODE[1239], &gn_RMAP_NODE[1247], &gn_RMAP_NODE[1251], &gn_RMAP_NODE[1256], &gn_RMAP_NODE[1263], &gn_RMAP_NODE[1267], &gn_RMAP_NODE[1274]);
MAKE_VECTOR(gn_RMAP_NODE_1023_prev, 1, &gn_RMAP_NODE[0]);
MAKE_VECTOR(gn_RMAP_NODE_1024_next, 2, &gn_RMAP_NODE[1025], &gn_RMAP_NODE[1035]);
MAKE_VECTOR(gn_RMAP_NODE_1024_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1025_next, 1, &gn_RMAP_NODE[1026]);
MAKE_VECTOR(gn_RMAP_NODE_1025_prev, 1, &gn_RMAP_NODE[1024]);
MAKE_VECTOR(gn_RMAP_NODE_1026_next, 1, &gn_RMAP_NODE[1027]);
MAKE_VECTOR(gn_RMAP_NODE_1026_prev, 2, &gn_RMAP_NODE[1025], &gn_RMAP_NODE[1035]);
MAKE_VECTOR(gn_RMAP_NODE_1027_next, 1, &gn_RMAP_NODE[1028]);
MAKE_VECTOR(gn_RMAP_NODE_1027_prev, 1, &gn_RMAP_NODE[1026]);
MAKE_VECTOR(gn_RMAP_NODE_1028_next, 1, &gn_RMAP_NODE[1029]);
MAKE_VECTOR(gn_RMAP_NODE_1028_prev, 1, &gn_RMAP_NODE[1027]);
MAKE_VECTOR(gn_RMAP_NODE_1029_next, 2, &gn_RMAP_NODE[1030], &gn_RMAP_NODE[1034]);
MAKE_VECTOR(gn_RMAP_NODE_1029_prev, 1, &gn_RMAP_NODE[1028]);
MAKE_VECTOR(gn_RMAP_NODE_1030_next, 1, &gn_RMAP_NODE[1031]);
MAKE_VECTOR(gn_RMAP_NODE_1030_prev, 1, &gn_RMAP_NODE[1029]);
MAKE_VECTOR(gn_RMAP_NODE_1031_next, 1, &gn_RMAP_NODE[1032]);
MAKE_VECTOR(gn_RMAP_NODE_1031_prev, 2, &gn_RMAP_NODE[1030], &gn_RMAP_NODE[1034]);
MAKE_VECTOR(gn_RMAP_NODE_1032_next, 1, &gn_RMAP_NODE[1033]);
MAKE_VECTOR(gn_RMAP_NODE_1032_prev, 1, &gn_RMAP_NODE[1031]);
MAKE_VECTOR(gn_RMAP_NODE_1033_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1033_prev, 1, &gn_RMAP_NODE[1032]);
MAKE_VECTOR(gn_RMAP_NODE_1034_next, 1, &gn_RMAP_NODE[1031]);
MAKE_VECTOR(gn_RMAP_NODE_1034_prev, 1, &gn_RMAP_NODE[1029]);
MAKE_VECTOR(gn_RMAP_NODE_1035_next, 1, &gn_RMAP_NODE[1026]);
MAKE_VECTOR(gn_RMAP_NODE_1035_prev, 1, &gn_RMAP_NODE[1024]);
MAKE_VECTOR(gn_RMAP_NODE_1036_next, 1, &gn_RMAP_NODE[1037]);
MAKE_VECTOR(gn_RMAP_NODE_1036_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1037_next, 1, &gn_RMAP_NODE[1038]);
MAKE_VECTOR(gn_RMAP_NODE_1037_prev, 1, &gn_RMAP_NODE[1036]);
MAKE_VECTOR(gn_RMAP_NODE_1038_next, 1, &gn_RMAP_NODE[1039]);
MAKE_VECTOR(gn_RMAP_NODE_1038_prev, 1, &gn_RMAP_NODE[1037]);
MAKE_VECTOR(gn_RMAP_NODE_1039_next, 1, &gn_RMAP_NODE[1040]);
MAKE_VECTOR(gn_RMAP_NODE_1039_prev, 1, &gn_RMAP_NODE[1038]);
MAKE_VECTOR(gn_RMAP_NODE_1040_next, 1, &gn_RMAP_NODE[1041]);
MAKE_VECTOR(gn_RMAP_NODE_1040_prev, 1, &gn_RMAP_NODE[1039]);
MAKE_VECTOR(gn_RMAP_NODE_1041_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1041_prev, 1, &gn_RMAP_NODE[1040]);
MAKE_VECTOR(gn_RMAP_NODE_1042_next, 1, &gn_RMAP_NODE[1043]);
MAKE_VECTOR(gn_RMAP_NODE_1042_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1043_next, 2, &gn_RMAP_NODE[1044], &gn_RMAP_NODE[1048]);
MAKE_VECTOR(gn_RMAP_NODE_1043_prev, 1, &gn_RMAP_NODE[1042]);
MAKE_VECTOR(gn_RMAP_NODE_1044_next, 1, &gn_RMAP_NODE[1045]);
MAKE_VECTOR(gn_RMAP_NODE_1044_prev, 1, &gn_RMAP_NODE[1043]);
MAKE_VECTOR(gn_RMAP_NODE_1045_next, 1, &gn_RMAP_NODE[1046]);
MAKE_VECTOR(gn_RMAP_NODE_1045_prev, 2, &gn_RMAP_NODE[1044], &gn_RMAP_NODE[1048]);
MAKE_VECTOR(gn_RMAP_NODE_1046_next, 1, &gn_RMAP_NODE[1047]);
MAKE_VECTOR(gn_RMAP_NODE_1046_prev, 1, &gn_RMAP_NODE[1045]);
MAKE_VECTOR(gn_RMAP_NODE_1047_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1047_prev, 1, &gn_RMAP_NODE[1046]);
MAKE_VECTOR(gn_RMAP_NODE_1048_next, 1, &gn_RMAP_NODE[1045]);
MAKE_VECTOR(gn_RMAP_NODE_1048_prev, 1, &gn_RMAP_NODE[1043]);
MAKE_VECTOR(gn_RMAP_NODE_1049_next, 3, &gn_RMAP_NODE[1050], &gn_RMAP_NODE[1058], &gn_RMAP_NODE[1066]);
MAKE_VECTOR(gn_RMAP_NODE_1049_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1050_next, 2, &gn_RMAP_NODE[1051], &gn_RMAP_NODE[1054]);
MAKE_VECTOR(gn_RMAP_NODE_1050_prev, 1, &gn_RMAP_NODE[1049]);
MAKE_VECTOR(gn_RMAP_NODE_1051_next, 2, &gn_RMAP_NODE[1051], &gn_RMAP_NODE[1052]);
MAKE_VECTOR(gn_RMAP_NODE_1051_prev, 2, &gn_RMAP_NODE[1050], &gn_RMAP_NODE[1051]);
MAKE_VECTOR(gn_RMAP_NODE_1052_next, 1, &gn_RMAP_NODE[1053]);
MAKE_VECTOR(gn_RMAP_NODE_1052_prev, 1, &gn_RMAP_NODE[1051]);
MAKE_VECTOR(gn_RMAP_NODE_1053_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1053_prev, 1, &gn_RMAP_NODE[1052]);
MAKE_VECTOR(gn_RMAP_NODE_1054_next, 1, &gn_RMAP_NODE[1055]);
MAKE_VECTOR(gn_RMAP_NODE_1054_prev, 1, &gn_RMAP_NODE[1050]);
MAKE_VECTOR(gn_RMAP_NODE_1055_next, 1, &gn_RMAP_NODE[1056]);
MAKE_VECTOR(gn_RMAP_NODE_1055_prev, 1, &gn_RMAP_NODE[1054]);
MAKE_VECTOR(gn_RMAP_NODE_1056_next, 1, &gn_RMAP_NODE[1057]);
MAKE_VECTOR(gn_RMAP_NODE_1056_prev, 1, &gn_RMAP_NODE[1055]);
MAKE_VECTOR(gn_RMAP_NODE_1057_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1057_prev, 1, &gn_RMAP_NODE[1056]);
MAKE_VECTOR(gn_RMAP_NODE_1058_next, 2, &gn_RMAP_NODE[1059], &gn_RMAP_NODE[1062]);
MAKE_VECTOR(gn_RMAP_NODE_1058_prev, 1, &gn_RMAP_NODE[1049]);
MAKE_VECTOR(gn_RMAP_NODE_1059_next, 2, &gn_RMAP_NODE[1059], &gn_RMAP_NODE[1060]);
MAKE_VECTOR(gn_RMAP_NODE_1059_prev, 2, &gn_RMAP_NODE[1058], &gn_RMAP_NODE[1059]);
MAKE_VECTOR(gn_RMAP_NODE_1060_next, 1, &gn_RMAP_NODE[1061]);
MAKE_VECTOR(gn_RMAP_NODE_1060_prev, 1, &gn_RMAP_NODE[1059]);
MAKE_VECTOR(gn_RMAP_NODE_1061_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1061_prev, 1, &gn_RMAP_NODE[1060]);
MAKE_VECTOR(gn_RMAP_NODE_1062_next, 1, &gn_RMAP_NODE[1063]);
MAKE_VECTOR(gn_RMAP_NODE_1062_prev, 1, &gn_RMAP_NODE[1058]);
MAKE_VECTOR(gn_RMAP_NODE_1063_next, 1, &gn_RMAP_NODE[1064]);
MAKE_VECTOR(gn_RMAP_NODE_1063_prev, 1, &gn_RMAP_NODE[1062]);
MAKE_VECTOR(gn_RMAP_NODE_1064_next, 1, &gn_RMAP_NODE[1065]);
MAKE_VECTOR(gn_RMAP_NODE_1064_prev, 1, &gn_RMAP_NODE[1063]);
MAKE_VECTOR(gn_RMAP_NODE_1065_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1065_prev, 1, &gn_RMAP_NODE[1064]);
MAKE_VECTOR(gn_RMAP_NODE_1066_next, 2, &gn_RMAP_NODE[1067], &gn_RMAP_NODE[1078]);
MAKE_VECTOR(gn_RMAP_NODE_1066_prev, 1, &gn_RMAP_NODE[1049]);
MAKE_VECTOR(gn_RMAP_NODE_1067_next, 2, &gn_RMAP_NODE[1068], &gn_RMAP_NODE[1077]);
MAKE_VECTOR(gn_RMAP_NODE_1067_prev, 1, &gn_RMAP_NODE[1066]);
MAKE_VECTOR(gn_RMAP_NODE_1068_next, 1, &gn_RMAP_NODE[1069]);
MAKE_VECTOR(gn_RMAP_NODE_1068_prev, 1, &gn_RMAP_NODE[1067]);
MAKE_VECTOR(gn_RMAP_NODE_1069_next, 1, &gn_RMAP_NODE[1070]);
MAKE_VECTOR(gn_RMAP_NODE_1069_prev, 2, &gn_RMAP_NODE[1068], &gn_RMAP_NODE[1077]);
MAKE_VECTOR(gn_RMAP_NODE_1070_next, 2, &gn_RMAP_NODE[1071], &gn_RMAP_NODE[1074]);
MAKE_VECTOR(gn_RMAP_NODE_1070_prev, 1, &gn_RMAP_NODE[1069]);
MAKE_VECTOR(gn_RMAP_NODE_1071_next, 1, &gn_RMAP_NODE[1072]);
MAKE_VECTOR(gn_RMAP_NODE_1071_prev, 1, &gn_RMAP_NODE[1070]);
MAKE_VECTOR(gn_RMAP_NODE_1072_next, 1, &gn_RMAP_NODE[1073]);
MAKE_VECTOR(gn_RMAP_NODE_1072_prev, 1, &gn_RMAP_NODE[1071]);
MAKE_VECTOR(gn_RMAP_NODE_1073_next, 1, &gn_RMAP_NODE[1074]);
MAKE_VECTOR(gn_RMAP_NODE_1073_prev, 1, &gn_RMAP_NODE[1072]);
MAKE_VECTOR(gn_RMAP_NODE_1074_next, 1, &gn_RMAP_NODE[1075]);
MAKE_VECTOR(gn_RMAP_NODE_1074_prev, 2, &gn_RMAP_NODE[1073], &gn_RMAP_NODE[1070]);
MAKE_VECTOR(gn_RMAP_NODE_1075_next, 1, &gn_RMAP_NODE[1076]);
MAKE_VECTOR(gn_RMAP_NODE_1075_prev, 1, &gn_RMAP_NODE[1074]);
MAKE_VECTOR(gn_RMAP_NODE_1076_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1076_prev, 1, &gn_RMAP_NODE[1075]);
MAKE_VECTOR(gn_RMAP_NODE_1077_next, 1, &gn_RMAP_NODE[1069]);
MAKE_VECTOR(gn_RMAP_NODE_1077_prev, 1, &gn_RMAP_NODE[1067]);
MAKE_VECTOR(gn_RMAP_NODE_1078_next, 1, &gn_RMAP_NODE[1079]);
MAKE_VECTOR(gn_RMAP_NODE_1078_prev, 1, &gn_RMAP_NODE[1066]);
MAKE_VECTOR(gn_RMAP_NODE_1079_next, 1, &gn_RMAP_NODE[1080]);
MAKE_VECTOR(gn_RMAP_NODE_1079_prev, 1, &gn_RMAP_NODE[1078]);
MAKE_VECTOR(gn_RMAP_NODE_1080_next, 2, &gn_RMAP_NODE[1081], &gn_RMAP_NODE[1084]);
MAKE_VECTOR(gn_RMAP_NODE_1080_prev, 1, &gn_RMAP_NODE[1079]);
MAKE_VECTOR(gn_RMAP_NODE_1081_next, 1, &gn_RMAP_NODE[1082]);
MAKE_VECTOR(gn_RMAP_NODE_1081_prev, 1, &gn_RMAP_NODE[1080]);
MAKE_VECTOR(gn_RMAP_NODE_1082_next, 1, &gn_RMAP_NODE[1083]);
MAKE_VECTOR(gn_RMAP_NODE_1082_prev, 1, &gn_RMAP_NODE[1081]);
MAKE_VECTOR(gn_RMAP_NODE_1083_next, 1, &gn_RMAP_NODE[1084]);
MAKE_VECTOR(gn_RMAP_NODE_1083_prev, 1, &gn_RMAP_NODE[1082]);
MAKE_VECTOR(gn_RMAP_NODE_1084_next, 1, &gn_RMAP_NODE[1085]);
MAKE_VECTOR(gn_RMAP_NODE_1084_prev, 2, &gn_RMAP_NODE[1083], &gn_RMAP_NODE[1080]);
MAKE_VECTOR(gn_RMAP_NODE_1085_next, 1, &gn_RMAP_NODE[1086]);
MAKE_VECTOR(gn_RMAP_NODE_1085_prev, 1, &gn_RMAP_NODE[1084]);
MAKE_VECTOR(gn_RMAP_NODE_1086_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1086_prev, 1, &gn_RMAP_NODE[1085]);
MAKE_VECTOR(gn_RMAP_NODE_1087_next, 1, &gn_RMAP_NODE[1088]);
MAKE_VECTOR(gn_RMAP_NODE_1087_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1088_next, 1, &gn_RMAP_NODE[1089]);
MAKE_VECTOR(gn_RMAP_NODE_1088_prev, 1, &gn_RMAP_NODE[1087]);
MAKE_VECTOR(gn_RMAP_NODE_1089_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1089_prev, 1, &gn_RMAP_NODE[1088]);
MAKE_VECTOR(gn_RMAP_NODE_1090_next, 1, &gn_RMAP_NODE[1091]);
MAKE_VECTOR(gn_RMAP_NODE_1090_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1091_next, 3, &gn_RMAP_NODE[1092], &gn_RMAP_NODE[1097], &gn_RMAP_NODE[1098]);
MAKE_VECTOR(gn_RMAP_NODE_1091_prev, 1, &gn_RMAP_NODE[1090]);
MAKE_VECTOR(gn_RMAP_NODE_1092_next, 1, &gn_RMAP_NODE[1093]);
MAKE_VECTOR(gn_RMAP_NODE_1092_prev, 1, &gn_RMAP_NODE[1091]);
MAKE_VECTOR(gn_RMAP_NODE_1093_next, 1, &gn_RMAP_NODE[1094]);
MAKE_VECTOR(gn_RMAP_NODE_1093_prev, 3, &gn_RMAP_NODE[1092], &gn_RMAP_NODE[1097], &gn_RMAP_NODE[1098]);
MAKE_VECTOR(gn_RMAP_NODE_1094_next, 1, &gn_RMAP_NODE[1095]);
MAKE_VECTOR(gn_RMAP_NODE_1094_prev, 1, &gn_RMAP_NODE[1093]);
MAKE_VECTOR(gn_RMAP_NODE_1095_next, 1, &gn_RMAP_NODE[1096]);
MAKE_VECTOR(gn_RMAP_NODE_1095_prev, 1, &gn_RMAP_NODE[1094]);
MAKE_VECTOR(gn_RMAP_NODE_1096_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1096_prev, 1, &gn_RMAP_NODE[1095]);
MAKE_VECTOR(gn_RMAP_NODE_1097_next, 1, &gn_RMAP_NODE[1093]);
MAKE_VECTOR(gn_RMAP_NODE_1097_prev, 1, &gn_RMAP_NODE[1091]);
MAKE_VECTOR(gn_RMAP_NODE_1098_next, 1, &gn_RMAP_NODE[1093]);
MAKE_VECTOR(gn_RMAP_NODE_1098_prev, 1, &gn_RMAP_NODE[1091]);
MAKE_VECTOR(gn_RMAP_NODE_1099_next, 2, &gn_RMAP_NODE[1100], &gn_RMAP_NODE[1103]);
MAKE_VECTOR(gn_RMAP_NODE_1099_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1100_next, 2, &gn_RMAP_NODE[1100], &gn_RMAP_NODE[1101]);
MAKE_VECTOR(gn_RMAP_NODE_1100_prev, 2, &gn_RMAP_NODE[1099], &gn_RMAP_NODE[1100]);
MAKE_VECTOR(gn_RMAP_NODE_1101_next, 1, &gn_RMAP_NODE[1102]);
MAKE_VECTOR(gn_RMAP_NODE_1101_prev, 1, &gn_RMAP_NODE[1100]);
MAKE_VECTOR(gn_RMAP_NODE_1102_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1102_prev, 1, &gn_RMAP_NODE[1101]);
MAKE_VECTOR(gn_RMAP_NODE_1103_next, 1, &gn_RMAP_NODE[1104]);
MAKE_VECTOR(gn_RMAP_NODE_1103_prev, 1, &gn_RMAP_NODE[1099]);
MAKE_VECTOR(gn_RMAP_NODE_1104_next, 1, &gn_RMAP_NODE[1105]);
MAKE_VECTOR(gn_RMAP_NODE_1104_prev, 1, &gn_RMAP_NODE[1103]);
MAKE_VECTOR(gn_RMAP_NODE_1105_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1105_prev, 1, &gn_RMAP_NODE[1104]);
MAKE_VECTOR(gn_RMAP_NODE_1106_next, 1, &gn_RMAP_NODE[1107]);
MAKE_VECTOR(gn_RMAP_NODE_1106_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1107_next, 1, &gn_RMAP_NODE[1108]);
MAKE_VECTOR(gn_RMAP_NODE_1107_prev, 1, &gn_RMAP_NODE[1106]);
MAKE_VECTOR(gn_RMAP_NODE_1108_next, 1, &gn_RMAP_NODE[1109]);
MAKE_VECTOR(gn_RMAP_NODE_1108_prev, 1, &gn_RMAP_NODE[1107]);
MAKE_VECTOR(gn_RMAP_NODE_1109_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1109_prev, 1, &gn_RMAP_NODE[1108]);
MAKE_VECTOR(gn_RMAP_NODE_1110_next, 1, &gn_RMAP_NODE[1111]);
MAKE_VECTOR(gn_RMAP_NODE_1110_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1111_next, 2, &gn_RMAP_NODE[1112], &gn_RMAP_NODE[1116]);
MAKE_VECTOR(gn_RMAP_NODE_1111_prev, 1, &gn_RMAP_NODE[1110]);
MAKE_VECTOR(gn_RMAP_NODE_1112_next, 1, &gn_RMAP_NODE[1113]);
MAKE_VECTOR(gn_RMAP_NODE_1112_prev, 1, &gn_RMAP_NODE[1111]);
MAKE_VECTOR(gn_RMAP_NODE_1113_next, 1, &gn_RMAP_NODE[1114]);
MAKE_VECTOR(gn_RMAP_NODE_1113_prev, 1, &gn_RMAP_NODE[1112]);
MAKE_VECTOR(gn_RMAP_NODE_1114_next, 1, &gn_RMAP_NODE[1115]);
MAKE_VECTOR(gn_RMAP_NODE_1114_prev, 1, &gn_RMAP_NODE[1113]);
MAKE_VECTOR(gn_RMAP_NODE_1115_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1115_prev, 1, &gn_RMAP_NODE[1114]);
MAKE_VECTOR(gn_RMAP_NODE_1116_next, 1, &gn_RMAP_NODE[1117]);
MAKE_VECTOR(gn_RMAP_NODE_1116_prev, 1, &gn_RMAP_NODE[1111]);
MAKE_VECTOR(gn_RMAP_NODE_1117_next, 1, &gn_RMAP_NODE[1118]);
MAKE_VECTOR(gn_RMAP_NODE_1117_prev, 1, &gn_RMAP_NODE[1116]);
MAKE_VECTOR(gn_RMAP_NODE_1118_next, 1, &gn_RMAP_NODE[1119]);
MAKE_VECTOR(gn_RMAP_NODE_1118_prev, 1, &gn_RMAP_NODE[1117]);
MAKE_VECTOR(gn_RMAP_NODE_1119_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1119_prev, 1, &gn_RMAP_NODE[1118]);
MAKE_VECTOR(gn_RMAP_NODE_1120_next, 6, &gn_RMAP_NODE[1121], &gn_RMAP_NODE[1132], &gn_RMAP_NODE[1136], &gn_RMAP_NODE[1139], &gn_RMAP_NODE[1143], &gn_RMAP_NODE[1147]);
MAKE_VECTOR(gn_RMAP_NODE_1120_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1121_next, 1, &gn_RMAP_NODE[1122]);
MAKE_VECTOR(gn_RMAP_NODE_1121_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1122_next, 3, &gn_RMAP_NODE[1123], &gn_RMAP_NODE[1130], &gn_RMAP_NODE[1131]);
MAKE_VECTOR(gn_RMAP_NODE_1122_prev, 1, &gn_RMAP_NODE[1121]);
MAKE_VECTOR(gn_RMAP_NODE_1123_next, 1, &gn_RMAP_NODE[1124]);
MAKE_VECTOR(gn_RMAP_NODE_1123_prev, 1, &gn_RMAP_NODE[1122]);
MAKE_VECTOR(gn_RMAP_NODE_1124_next, 1, &gn_RMAP_NODE[1125]);
MAKE_VECTOR(gn_RMAP_NODE_1124_prev, 3, &gn_RMAP_NODE[1123], &gn_RMAP_NODE[1130], &gn_RMAP_NODE[1131]);
MAKE_VECTOR(gn_RMAP_NODE_1125_next, 2, &gn_RMAP_NODE[1126], &gn_RMAP_NODE[1127]);
MAKE_VECTOR(gn_RMAP_NODE_1125_prev, 1, &gn_RMAP_NODE[1124]);
MAKE_VECTOR(gn_RMAP_NODE_1126_next, 1, &gn_RMAP_NODE[1127]);
MAKE_VECTOR(gn_RMAP_NODE_1126_prev, 1, &gn_RMAP_NODE[1125]);
MAKE_VECTOR(gn_RMAP_NODE_1127_next, 1, &gn_RMAP_NODE[1128]);
MAKE_VECTOR(gn_RMAP_NODE_1127_prev, 2, &gn_RMAP_NODE[1126], &gn_RMAP_NODE[1125]);
MAKE_VECTOR(gn_RMAP_NODE_1128_next, 1, &gn_RMAP_NODE[1129]);
MAKE_VECTOR(gn_RMAP_NODE_1128_prev, 1, &gn_RMAP_NODE[1127]);
MAKE_VECTOR(gn_RMAP_NODE_1129_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1129_prev, 1, &gn_RMAP_NODE[1128]);
MAKE_VECTOR(gn_RMAP_NODE_1130_next, 1, &gn_RMAP_NODE[1124]);
MAKE_VECTOR(gn_RMAP_NODE_1130_prev, 1, &gn_RMAP_NODE[1122]);
MAKE_VECTOR(gn_RMAP_NODE_1131_next, 1, &gn_RMAP_NODE[1124]);
MAKE_VECTOR(gn_RMAP_NODE_1131_prev, 1, &gn_RMAP_NODE[1122]);
MAKE_VECTOR(gn_RMAP_NODE_1132_next, 1, &gn_RMAP_NODE[1133]);
MAKE_VECTOR(gn_RMAP_NODE_1132_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1133_next, 2, &gn_RMAP_NODE[1133], &gn_RMAP_NODE[1134]);
MAKE_VECTOR(gn_RMAP_NODE_1133_prev, 2, &gn_RMAP_NODE[1132], &gn_RMAP_NODE[1133]);
MAKE_VECTOR(gn_RMAP_NODE_1134_next, 1, &gn_RMAP_NODE[1135]);
MAKE_VECTOR(gn_RMAP_NODE_1134_prev, 1, &gn_RMAP_NODE[1133]);
MAKE_VECTOR(gn_RMAP_NODE_1135_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1135_prev, 1, &gn_RMAP_NODE[1134]);
MAKE_VECTOR(gn_RMAP_NODE_1136_next, 1, &gn_RMAP_NODE[1137]);
MAKE_VECTOR(gn_RMAP_NODE_1136_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1137_next, 1, &gn_RMAP_NODE[1138]);
MAKE_VECTOR(gn_RMAP_NODE_1137_prev, 1, &gn_RMAP_NODE[1136]);
MAKE_VECTOR(gn_RMAP_NODE_1138_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1138_prev, 1, &gn_RMAP_NODE[1137]);
MAKE_VECTOR(gn_RMAP_NODE_1139_next, 1, &gn_RMAP_NODE[1140]);
MAKE_VECTOR(gn_RMAP_NODE_1139_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1140_next, 2, &gn_RMAP_NODE[1140], &gn_RMAP_NODE[1141]);
MAKE_VECTOR(gn_RMAP_NODE_1140_prev, 2, &gn_RMAP_NODE[1139], &gn_RMAP_NODE[1140]);
MAKE_VECTOR(gn_RMAP_NODE_1141_next, 1, &gn_RMAP_NODE[1142]);
MAKE_VECTOR(gn_RMAP_NODE_1141_prev, 1, &gn_RMAP_NODE[1140]);
MAKE_VECTOR(gn_RMAP_NODE_1142_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1142_prev, 1, &gn_RMAP_NODE[1141]);
MAKE_VECTOR(gn_RMAP_NODE_1143_next, 1, &gn_RMAP_NODE[1144]);
MAKE_VECTOR(gn_RMAP_NODE_1143_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1144_next, 2, &gn_RMAP_NODE[1144], &gn_RMAP_NODE[1145]);
MAKE_VECTOR(gn_RMAP_NODE_1144_prev, 2, &gn_RMAP_NODE[1143], &gn_RMAP_NODE[1144]);
MAKE_VECTOR(gn_RMAP_NODE_1145_next, 1, &gn_RMAP_NODE[1146]);
MAKE_VECTOR(gn_RMAP_NODE_1145_prev, 1, &gn_RMAP_NODE[1144]);
MAKE_VECTOR(gn_RMAP_NODE_1146_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1146_prev, 1, &gn_RMAP_NODE[1145]);
MAKE_VECTOR(gn_RMAP_NODE_1147_next, 1, &gn_RMAP_NODE[1148]);
MAKE_VECTOR(gn_RMAP_NODE_1147_prev, 1, &gn_RMAP_NODE[1120]);
MAKE_VECTOR(gn_RMAP_NODE_1148_next, 2, &gn_RMAP_NODE[1148], &gn_RMAP_NODE[1149]);
MAKE_VECTOR(gn_RMAP_NODE_1148_prev, 2, &gn_RMAP_NODE[1147], &gn_RMAP_NODE[1148]);
MAKE_VECTOR(gn_RMAP_NODE_1149_next, 1, &gn_RMAP_NODE[1150]);
MAKE_VECTOR(gn_RMAP_NODE_1149_prev, 1, &gn_RMAP_NODE[1148]);
MAKE_VECTOR(gn_RMAP_NODE_1150_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1150_prev, 1, &gn_RMAP_NODE[1149]);
MAKE_VECTOR(gn_RMAP_NODE_1151_next, 1, &gn_RMAP_NODE[1152]);
MAKE_VECTOR(gn_RMAP_NODE_1151_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1152_next, 3, &gn_RMAP_NODE[1153], &gn_RMAP_NODE[1158], &gn_RMAP_NODE[1159]);
MAKE_VECTOR(gn_RMAP_NODE_1152_prev, 1, &gn_RMAP_NODE[1151]);
MAKE_VECTOR(gn_RMAP_NODE_1153_next, 1, &gn_RMAP_NODE[1154]);
MAKE_VECTOR(gn_RMAP_NODE_1153_prev, 1, &gn_RMAP_NODE[1152]);
MAKE_VECTOR(gn_RMAP_NODE_1154_next, 1, &gn_RMAP_NODE[1155]);
MAKE_VECTOR(gn_RMAP_NODE_1154_prev, 3, &gn_RMAP_NODE[1153], &gn_RMAP_NODE[1158], &gn_RMAP_NODE[1159]);
MAKE_VECTOR(gn_RMAP_NODE_1155_next, 1, &gn_RMAP_NODE[1156]);
MAKE_VECTOR(gn_RMAP_NODE_1155_prev, 1, &gn_RMAP_NODE[1154]);
MAKE_VECTOR(gn_RMAP_NODE_1156_next, 1, &gn_RMAP_NODE[1157]);
MAKE_VECTOR(gn_RMAP_NODE_1156_prev, 1, &gn_RMAP_NODE[1155]);
MAKE_VECTOR(gn_RMAP_NODE_1157_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1157_prev, 1, &gn_RMAP_NODE[1156]);
MAKE_VECTOR(gn_RMAP_NODE_1158_next, 1, &gn_RMAP_NODE[1154]);
MAKE_VECTOR(gn_RMAP_NODE_1158_prev, 1, &gn_RMAP_NODE[1152]);
MAKE_VECTOR(gn_RMAP_NODE_1159_next, 1, &gn_RMAP_NODE[1154]);
MAKE_VECTOR(gn_RMAP_NODE_1159_prev, 1, &gn_RMAP_NODE[1152]);
MAKE_VECTOR(gn_RMAP_NODE_1160_next, 1, &gn_RMAP_NODE[1161]);
MAKE_VECTOR(gn_RMAP_NODE_1160_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1161_next, 1, &gn_RMAP_NODE[1162]);
MAKE_VECTOR(gn_RMAP_NODE_1161_prev, 1, &gn_RMAP_NODE[1160]);
MAKE_VECTOR(gn_RMAP_NODE_1162_next, 1, &gn_RMAP_NODE[1163]);
MAKE_VECTOR(gn_RMAP_NODE_1162_prev, 1, &gn_RMAP_NODE[1161]);
MAKE_VECTOR(gn_RMAP_NODE_1163_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1163_prev, 1, &gn_RMAP_NODE[1162]);
MAKE_VECTOR(gn_RMAP_NODE_1164_next, 1, &gn_RMAP_NODE[1165]);
MAKE_VECTOR(gn_RMAP_NODE_1164_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1165_next, 1, &gn_RMAP_NODE[1166]);
MAKE_VECTOR(gn_RMAP_NODE_1165_prev, 1, &gn_RMAP_NODE[1164]);
MAKE_VECTOR(gn_RMAP_NODE_1166_next, 1, &gn_RMAP_NODE[1167]);
MAKE_VECTOR(gn_RMAP_NODE_1166_prev, 1, &gn_RMAP_NODE[1165]);
MAKE_VECTOR(gn_RMAP_NODE_1167_next, 1, &gn_RMAP_NODE[1168]);
MAKE_VECTOR(gn_RMAP_NODE_1167_prev, 1, &gn_RMAP_NODE[1166]);
MAKE_VECTOR(gn_RMAP_NODE_1168_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1168_prev, 1, &gn_RMAP_NODE[1167]);
MAKE_VECTOR(gn_RMAP_NODE_1169_next, 1, &gn_RMAP_NODE[1170]);
MAKE_VECTOR(gn_RMAP_NODE_1169_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1170_next, 4, &gn_RMAP_NODE[1171], &gn_RMAP_NODE[1175], &gn_RMAP_NODE[1179], &gn_RMAP_NODE[1182]);
MAKE_VECTOR(gn_RMAP_NODE_1170_prev, 1, &gn_RMAP_NODE[1169]);
MAKE_VECTOR(gn_RMAP_NODE_1171_next, 1, &gn_RMAP_NODE[1172]);
MAKE_VECTOR(gn_RMAP_NODE_1171_prev, 1, &gn_RMAP_NODE[1170]);
MAKE_VECTOR(gn_RMAP_NODE_1172_next, 1, &gn_RMAP_NODE[1173]);
MAKE_VECTOR(gn_RMAP_NODE_1172_prev, 1, &gn_RMAP_NODE[1171]);
MAKE_VECTOR(gn_RMAP_NODE_1173_next, 1, &gn_RMAP_NODE[1174]);
MAKE_VECTOR(gn_RMAP_NODE_1173_prev, 1, &gn_RMAP_NODE[1172]);
MAKE_VECTOR(gn_RMAP_NODE_1174_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1174_prev, 1, &gn_RMAP_NODE[1173]);
MAKE_VECTOR(gn_RMAP_NODE_1175_next, 1, &gn_RMAP_NODE[1176]);
MAKE_VECTOR(gn_RMAP_NODE_1175_prev, 1, &gn_RMAP_NODE[1170]);
MAKE_VECTOR(gn_RMAP_NODE_1176_next, 1, &gn_RMAP_NODE[1177]);
MAKE_VECTOR(gn_RMAP_NODE_1176_prev, 1, &gn_RMAP_NODE[1175]);
MAKE_VECTOR(gn_RMAP_NODE_1177_next, 1, &gn_RMAP_NODE[1178]);
MAKE_VECTOR(gn_RMAP_NODE_1177_prev, 1, &gn_RMAP_NODE[1176]);
MAKE_VECTOR(gn_RMAP_NODE_1178_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1178_prev, 1, &gn_RMAP_NODE[1177]);
MAKE_VECTOR(gn_RMAP_NODE_1179_next, 1, &gn_RMAP_NODE[1180]);
MAKE_VECTOR(gn_RMAP_NODE_1179_prev, 1, &gn_RMAP_NODE[1170]);
MAKE_VECTOR(gn_RMAP_NODE_1180_next, 1, &gn_RMAP_NODE[1181]);
MAKE_VECTOR(gn_RMAP_NODE_1180_prev, 1, &gn_RMAP_NODE[1179]);
MAKE_VECTOR(gn_RMAP_NODE_1181_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1181_prev, 1, &gn_RMAP_NODE[1180]);
MAKE_VECTOR(gn_RMAP_NODE_1182_next, 1, &gn_RMAP_NODE[1183]);
MAKE_VECTOR(gn_RMAP_NODE_1182_prev, 1, &gn_RMAP_NODE[1170]);
MAKE_VECTOR(gn_RMAP_NODE_1183_next, 1, &gn_RMAP_NODE[1184]);
MAKE_VECTOR(gn_RMAP_NODE_1183_prev, 1, &gn_RMAP_NODE[1182]);
MAKE_VECTOR(gn_RMAP_NODE_1184_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1184_prev, 1, &gn_RMAP_NODE[1183]);
MAKE_VECTOR(gn_RMAP_NODE_1185_next, 1, &gn_RMAP_NODE[1186]);
MAKE_VECTOR(gn_RMAP_NODE_1185_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1186_next, 1, &gn_RMAP_NODE[1187]);
MAKE_VECTOR(gn_RMAP_NODE_1186_prev, 1, &gn_RMAP_NODE[1185]);
MAKE_VECTOR(gn_RMAP_NODE_1187_next, 1, &gn_RMAP_NODE[1188]);
MAKE_VECTOR(gn_RMAP_NODE_1187_prev, 1, &gn_RMAP_NODE[1186]);
MAKE_VECTOR(gn_RMAP_NODE_1188_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1188_prev, 1, &gn_RMAP_NODE[1187]);
MAKE_VECTOR(gn_RMAP_NODE_1189_next, 1, &gn_RMAP_NODE[1190]);
MAKE_VECTOR(gn_RMAP_NODE_1189_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1190_next, 3, &gn_RMAP_NODE[1191], &gn_RMAP_NODE[1196], &gn_RMAP_NODE[1197]);
MAKE_VECTOR(gn_RMAP_NODE_1190_prev, 1, &gn_RMAP_NODE[1189]);
MAKE_VECTOR(gn_RMAP_NODE_1191_next, 1, &gn_RMAP_NODE[1192]);
MAKE_VECTOR(gn_RMAP_NODE_1191_prev, 1, &gn_RMAP_NODE[1190]);
MAKE_VECTOR(gn_RMAP_NODE_1192_next, 1, &gn_RMAP_NODE[1193]);
MAKE_VECTOR(gn_RMAP_NODE_1192_prev, 3, &gn_RMAP_NODE[1191], &gn_RMAP_NODE[1196], &gn_RMAP_NODE[1197]);
MAKE_VECTOR(gn_RMAP_NODE_1193_next, 1, &gn_RMAP_NODE[1194]);
MAKE_VECTOR(gn_RMAP_NODE_1193_prev, 1, &gn_RMAP_NODE[1192]);
MAKE_VECTOR(gn_RMAP_NODE_1194_next, 1, &gn_RMAP_NODE[1195]);
MAKE_VECTOR(gn_RMAP_NODE_1194_prev, 1, &gn_RMAP_NODE[1193]);
MAKE_VECTOR(gn_RMAP_NODE_1195_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1195_prev, 1, &gn_RMAP_NODE[1194]);
MAKE_VECTOR(gn_RMAP_NODE_1196_next, 1, &gn_RMAP_NODE[1192]);
MAKE_VECTOR(gn_RMAP_NODE_1196_prev, 1, &gn_RMAP_NODE[1190]);
MAKE_VECTOR(gn_RMAP_NODE_1197_next, 1, &gn_RMAP_NODE[1192]);
MAKE_VECTOR(gn_RMAP_NODE_1197_prev, 1, &gn_RMAP_NODE[1190]);
MAKE_VECTOR(gn_RMAP_NODE_1198_next, 2, &gn_RMAP_NODE[1199], &gn_RMAP_NODE[1202]);
MAKE_VECTOR(gn_RMAP_NODE_1198_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1199_next, 2, &gn_RMAP_NODE[1199], &gn_RMAP_NODE[1200]);
MAKE_VECTOR(gn_RMAP_NODE_1199_prev, 2, &gn_RMAP_NODE[1198], &gn_RMAP_NODE[1199]);
MAKE_VECTOR(gn_RMAP_NODE_1200_next, 1, &gn_RMAP_NODE[1201]);
MAKE_VECTOR(gn_RMAP_NODE_1200_prev, 1, &gn_RMAP_NODE[1199]);
MAKE_VECTOR(gn_RMAP_NODE_1201_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1201_prev, 1, &gn_RMAP_NODE[1200]);
MAKE_VECTOR(gn_RMAP_NODE_1202_next, 1, &gn_RMAP_NODE[1203]);
MAKE_VECTOR(gn_RMAP_NODE_1202_prev, 1, &gn_RMAP_NODE[1198]);
MAKE_VECTOR(gn_RMAP_NODE_1203_next, 1, &gn_RMAP_NODE[1204]);
MAKE_VECTOR(gn_RMAP_NODE_1203_prev, 1, &gn_RMAP_NODE[1202]);
MAKE_VECTOR(gn_RMAP_NODE_1204_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1204_prev, 1, &gn_RMAP_NODE[1203]);
MAKE_VECTOR(gn_RMAP_NODE_1205_next, 1, &gn_RMAP_NODE[1206]);
MAKE_VECTOR(gn_RMAP_NODE_1205_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1206_next, 1, &gn_RMAP_NODE[1207]);
MAKE_VECTOR(gn_RMAP_NODE_1206_prev, 1, &gn_RMAP_NODE[1205]);
MAKE_VECTOR(gn_RMAP_NODE_1207_next, 1, &gn_RMAP_NODE[1208]);
MAKE_VECTOR(gn_RMAP_NODE_1207_prev, 1, &gn_RMAP_NODE[1206]);
MAKE_VECTOR(gn_RMAP_NODE_1208_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1208_prev, 1, &gn_RMAP_NODE[1207]);
MAKE_VECTOR(gn_RMAP_NODE_1209_next, 1, &gn_RMAP_NODE[1210]);
MAKE_VECTOR(gn_RMAP_NODE_1209_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1210_next, 1, &gn_RMAP_NODE[1211]);
MAKE_VECTOR(gn_RMAP_NODE_1210_prev, 1, &gn_RMAP_NODE[1209]);
MAKE_VECTOR(gn_RMAP_NODE_1211_next, 1, &gn_RMAP_NODE[1212]);
MAKE_VECTOR(gn_RMAP_NODE_1211_prev, 1, &gn_RMAP_NODE[1210]);
MAKE_VECTOR(gn_RMAP_NODE_1212_next, 1, &gn_RMAP_NODE[1213]);
MAKE_VECTOR(gn_RMAP_NODE_1212_prev, 1, &gn_RMAP_NODE[1211]);
MAKE_VECTOR(gn_RMAP_NODE_1213_next, 1, &gn_RMAP_NODE[1214]);
MAKE_VECTOR(gn_RMAP_NODE_1213_prev, 1, &gn_RMAP_NODE[1212]);
MAKE_VECTOR(gn_RMAP_NODE_1214_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1214_prev, 1, &gn_RMAP_NODE[1213]);
MAKE_VECTOR(gn_RMAP_NODE_1215_next, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1215_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1216_next, 6, &gn_RMAP_NODE[1217], &gn_RMAP_NODE[1221], &gn_RMAP_NODE[1222], &gn_RMAP_NODE[1223], &gn_RMAP_NODE[1224], &gn_RMAP_NODE[1225]);
MAKE_VECTOR(gn_RMAP_NODE_1216_prev, 1, &gn_RMAP_NODE[1215]);
MAKE_VECTOR(gn_RMAP_NODE_1217_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1217_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1218_next, 1, &gn_RMAP_NODE[1219]);
MAKE_VECTOR(gn_RMAP_NODE_1218_prev, 6, &gn_RMAP_NODE[1217], &gn_RMAP_NODE[1221], &gn_RMAP_NODE[1222], &gn_RMAP_NODE[1223], &gn_RMAP_NODE[1224], &gn_RMAP_NODE[1225]);
MAKE_VECTOR(gn_RMAP_NODE_1219_next, 1, &gn_RMAP_NODE[1220]);
MAKE_VECTOR(gn_RMAP_NODE_1219_prev, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1220_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1220_prev, 1, &gn_RMAP_NODE[1219]);
MAKE_VECTOR(gn_RMAP_NODE_1221_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1221_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1222_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1222_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1223_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1223_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1224_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1224_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1225_next, 1, &gn_RMAP_NODE[1218]);
MAKE_VECTOR(gn_RMAP_NODE_1225_prev, 1, &gn_RMAP_NODE[1216]);
MAKE_VECTOR(gn_RMAP_NODE_1226_next, 1, &gn_RMAP_NODE[1227]);
MAKE_VECTOR(gn_RMAP_NODE_1226_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1227_next, 2, &gn_RMAP_NODE[1228], &gn_RMAP_NODE[1232]);
MAKE_VECTOR(gn_RMAP_NODE_1227_prev, 1, &gn_RMAP_NODE[1226]);
MAKE_VECTOR(gn_RMAP_NODE_1228_next, 1, &gn_RMAP_NODE[1229]);
MAKE_VECTOR(gn_RMAP_NODE_1228_prev, 1, &gn_RMAP_NODE[1227]);
MAKE_VECTOR(gn_RMAP_NODE_1229_next, 1, &gn_RMAP_NODE[1230]);
MAKE_VECTOR(gn_RMAP_NODE_1229_prev, 2, &gn_RMAP_NODE[1228], &gn_RMAP_NODE[1232]);
MAKE_VECTOR(gn_RMAP_NODE_1230_next, 1, &gn_RMAP_NODE[1231]);
MAKE_VECTOR(gn_RMAP_NODE_1230_prev, 1, &gn_RMAP_NODE[1229]);
MAKE_VECTOR(gn_RMAP_NODE_1231_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1231_prev, 1, &gn_RMAP_NODE[1230]);
MAKE_VECTOR(gn_RMAP_NODE_1232_next, 1, &gn_RMAP_NODE[1229]);
MAKE_VECTOR(gn_RMAP_NODE_1232_prev, 1, &gn_RMAP_NODE[1227]);
MAKE_VECTOR(gn_RMAP_NODE_1233_next, 1, &gn_RMAP_NODE[1234]);
MAKE_VECTOR(gn_RMAP_NODE_1233_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1234_next, 1, &gn_RMAP_NODE[1235]);
MAKE_VECTOR(gn_RMAP_NODE_1234_prev, 1, &gn_RMAP_NODE[1233]);
MAKE_VECTOR(gn_RMAP_NODE_1235_next, 1, &gn_RMAP_NODE[1236]);
MAKE_VECTOR(gn_RMAP_NODE_1235_prev, 1, &gn_RMAP_NODE[1234]);
MAKE_VECTOR(gn_RMAP_NODE_1236_next, 1, &gn_RMAP_NODE[1237]);
MAKE_VECTOR(gn_RMAP_NODE_1236_prev, 1, &gn_RMAP_NODE[1235]);
MAKE_VECTOR(gn_RMAP_NODE_1237_next, 1, &gn_RMAP_NODE[1238]);
MAKE_VECTOR(gn_RMAP_NODE_1237_prev, 1, &gn_RMAP_NODE[1236]);
MAKE_VECTOR(gn_RMAP_NODE_1238_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1238_prev, 1, &gn_RMAP_NODE[1237]);
MAKE_VECTOR(gn_RMAP_NODE_1239_next, 1, &gn_RMAP_NODE[1240]);
MAKE_VECTOR(gn_RMAP_NODE_1239_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1240_next, 3, &gn_RMAP_NODE[1241], &gn_RMAP_NODE[1245], &gn_RMAP_NODE[1246]);
MAKE_VECTOR(gn_RMAP_NODE_1240_prev, 1, &gn_RMAP_NODE[1239]);
MAKE_VECTOR(gn_RMAP_NODE_1241_next, 1, &gn_RMAP_NODE[1242]);
MAKE_VECTOR(gn_RMAP_NODE_1241_prev, 1, &gn_RMAP_NODE[1240]);
MAKE_VECTOR(gn_RMAP_NODE_1242_next, 1, &gn_RMAP_NODE[1243]);
MAKE_VECTOR(gn_RMAP_NODE_1242_prev, 3, &gn_RMAP_NODE[1241], &gn_RMAP_NODE[1245], &gn_RMAP_NODE[1246]);
MAKE_VECTOR(gn_RMAP_NODE_1243_next, 1, &gn_RMAP_NODE[1244]);
MAKE_VECTOR(gn_RMAP_NODE_1243_prev, 1, &gn_RMAP_NODE[1242]);
MAKE_VECTOR(gn_RMAP_NODE_1244_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1244_prev, 1, &gn_RMAP_NODE[1243]);
MAKE_VECTOR(gn_RMAP_NODE_1245_next, 1, &gn_RMAP_NODE[1242]);
MAKE_VECTOR(gn_RMAP_NODE_1245_prev, 1, &gn_RMAP_NODE[1240]);
MAKE_VECTOR(gn_RMAP_NODE_1246_next, 1, &gn_RMAP_NODE[1242]);
MAKE_VECTOR(gn_RMAP_NODE_1246_prev, 1, &gn_RMAP_NODE[1240]);
MAKE_VECTOR(gn_RMAP_NODE_1247_next, 1, &gn_RMAP_NODE[1248]);
MAKE_VECTOR(gn_RMAP_NODE_1247_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1248_next, 1, &gn_RMAP_NODE[1249]);
MAKE_VECTOR(gn_RMAP_NODE_1248_prev, 1, &gn_RMAP_NODE[1247]);
MAKE_VECTOR(gn_RMAP_NODE_1249_next, 1, &gn_RMAP_NODE[1250]);
MAKE_VECTOR(gn_RMAP_NODE_1249_prev, 1, &gn_RMAP_NODE[1248]);
MAKE_VECTOR(gn_RMAP_NODE_1250_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1250_prev, 1, &gn_RMAP_NODE[1249]);
MAKE_VECTOR(gn_RMAP_NODE_1251_next, 1, &gn_RMAP_NODE[1252]);
MAKE_VECTOR(gn_RMAP_NODE_1251_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1252_next, 1, &gn_RMAP_NODE[1253]);
MAKE_VECTOR(gn_RMAP_NODE_1252_prev, 1, &gn_RMAP_NODE[1251]);
MAKE_VECTOR(gn_RMAP_NODE_1253_next, 1, &gn_RMAP_NODE[1254]);
MAKE_VECTOR(gn_RMAP_NODE_1253_prev, 1, &gn_RMAP_NODE[1252]);
MAKE_VECTOR(gn_RMAP_NODE_1254_next, 1, &gn_RMAP_NODE[1255]);
MAKE_VECTOR(gn_RMAP_NODE_1254_prev, 1, &gn_RMAP_NODE[1253]);
MAKE_VECTOR(gn_RMAP_NODE_1255_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1255_prev, 1, &gn_RMAP_NODE[1254]);
MAKE_VECTOR(gn_RMAP_NODE_1256_next, 1, &gn_RMAP_NODE[1257]);
MAKE_VECTOR(gn_RMAP_NODE_1256_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1257_next, 2, &gn_RMAP_NODE[1258], &gn_RMAP_NODE[1262]);
MAKE_VECTOR(gn_RMAP_NODE_1257_prev, 1, &gn_RMAP_NODE[1256]);
MAKE_VECTOR(gn_RMAP_NODE_1258_next, 1, &gn_RMAP_NODE[1259]);
MAKE_VECTOR(gn_RMAP_NODE_1258_prev, 1, &gn_RMAP_NODE[1257]);
MAKE_VECTOR(gn_RMAP_NODE_1259_next, 1, &gn_RMAP_NODE[1260]);
MAKE_VECTOR(gn_RMAP_NODE_1259_prev, 2, &gn_RMAP_NODE[1258], &gn_RMAP_NODE[1262]);
MAKE_VECTOR(gn_RMAP_NODE_1260_next, 1, &gn_RMAP_NODE[1261]);
MAKE_VECTOR(gn_RMAP_NODE_1260_prev, 1, &gn_RMAP_NODE[1259]);
MAKE_VECTOR(gn_RMAP_NODE_1261_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1261_prev, 1, &gn_RMAP_NODE[1260]);
MAKE_VECTOR(gn_RMAP_NODE_1262_next, 1, &gn_RMAP_NODE[1259]);
MAKE_VECTOR(gn_RMAP_NODE_1262_prev, 1, &gn_RMAP_NODE[1257]);
MAKE_VECTOR(gn_RMAP_NODE_1263_next, 1, &gn_RMAP_NODE[1264]);
MAKE_VECTOR(gn_RMAP_NODE_1263_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1264_next, 1, &gn_RMAP_NODE[1265]);
MAKE_VECTOR(gn_RMAP_NODE_1264_prev, 1, &gn_RMAP_NODE[1263]);
MAKE_VECTOR(gn_RMAP_NODE_1265_next, 1, &gn_RMAP_NODE[1266]);
MAKE_VECTOR(gn_RMAP_NODE_1265_prev, 1, &gn_RMAP_NODE[1264]);
MAKE_VECTOR(gn_RMAP_NODE_1266_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1266_prev, 1, &gn_RMAP_NODE[1265]);
MAKE_VECTOR(gn_RMAP_NODE_1267_next, 1, &gn_RMAP_NODE[1268]);
MAKE_VECTOR(gn_RMAP_NODE_1267_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1268_next, 2, &gn_RMAP_NODE[1269], &gn_RMAP_NODE[1273]);
MAKE_VECTOR(gn_RMAP_NODE_1268_prev, 1, &gn_RMAP_NODE[1267]);
MAKE_VECTOR(gn_RMAP_NODE_1269_next, 1, &gn_RMAP_NODE[1270]);
MAKE_VECTOR(gn_RMAP_NODE_1269_prev, 1, &gn_RMAP_NODE[1268]);
MAKE_VECTOR(gn_RMAP_NODE_1270_next, 1, &gn_RMAP_NODE[1271]);
MAKE_VECTOR(gn_RMAP_NODE_1270_prev, 2, &gn_RMAP_NODE[1269], &gn_RMAP_NODE[1273]);
MAKE_VECTOR(gn_RMAP_NODE_1271_next, 1, &gn_RMAP_NODE[1272]);
MAKE_VECTOR(gn_RMAP_NODE_1271_prev, 1, &gn_RMAP_NODE[1270]);
MAKE_VECTOR(gn_RMAP_NODE_1272_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1272_prev, 1, &gn_RMAP_NODE[1271]);
MAKE_VECTOR(gn_RMAP_NODE_1273_next, 1, &gn_RMAP_NODE[1270]);
MAKE_VECTOR(gn_RMAP_NODE_1273_prev, 1, &gn_RMAP_NODE[1268]);
MAKE_VECTOR(gn_RMAP_NODE_1274_next, 1, &gn_RMAP_NODE[1275]);
MAKE_VECTOR(gn_RMAP_NODE_1274_prev, 1, &gn_RMAP_NODE[1023]);
MAKE_VECTOR(gn_RMAP_NODE_1275_next, 1, &gn_RMAP_NODE[1276]);
MAKE_VECTOR(gn_RMAP_NODE_1275_prev, 1, &gn_RMAP_NODE[1274]);
MAKE_VECTOR(gn_RMAP_NODE_1276_next, 1, &gn_RMAP_NODE[1277]);
MAKE_VECTOR(gn_RMAP_NODE_1276_prev, 1, &gn_RMAP_NODE[1275]);
MAKE_VECTOR(gn_RMAP_NODE_1277_next, 0, );
MAKE_VECTOR(gn_RMAP_NODE_1277_prev, 1, &gn_RMAP_NODE[1276]);

static struct graph_node gn_RMAP_NODE[] = {
	{
		.from = &gn_RMAP_NODE_0_prev,
		.to = &gn_RMAP_NODE_0_next,
		.data = &ctkn_RMAP_NODE[0],
	},
	{
		.from = &gn_RMAP_NODE_1_prev,
		.to = &gn_RMAP_NODE_1_next,
		.data = &ctkn_RMAP_NODE[1],
	},
	{
		.from = &gn_RMAP_NODE_2_prev,
		.to = &gn_RMAP_NODE_2_next,
		.data = &ctkn_RMAP_NODE[2],
	},
	{
		.from = &gn_RMAP_NODE_3_prev,
		.to = &gn_RMAP_NODE_3_next,
		.data = &ctkn_RMAP_NODE[3],
	},
	{
		.from = &gn_RMAP_NODE_4_prev,
		.to = &gn_RMAP_NODE_4_next,
		.data = &ctkn_RMAP_NODE[4],
	},
	{
		.from = &gn_RMAP_NODE_5_prev,
		.to = &gn_RMAP_NODE_5_next,
		.data = &ctkn_RMAP_NODE[5],
	},
	{
		.from = &gn_RMAP_NODE_6_prev,
		.to = &gn_RMAP_NODE_6_next,
		.data = &ctkn_RMAP_NODE[6],
	},
	{
		.from = &gn_RMAP_NODE_7_prev,
		.to = &gn_RMAP_NODE_7_next,
		.data = &ctkn_RMAP_NODE[7],
	},
	{
		.from = &gn_RMAP_NODE_8_prev,
		.to = &gn_RMAP_NODE_8_next,
		.data = &ctkn_RMAP_NODE[8],
	},
	{
		.from = &gn_RMAP_NODE_9_prev,
		.to = &gn_RMAP_NODE_9_next,
		.data = &ctkn_RMAP_NODE[9],
	},
	{
		.from = &gn_RMAP_NODE_10_prev,
		.to = &gn_RMAP_NODE_10_next,
		.data = (void *)&match_community_limit_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_11_prev,
		.to = &gn_RMAP_NODE_11_next,
		.data = &ctkn_RMAP_NODE[11],
	},
	{
		.from = &gn_RMAP_NODE_12_prev,
		.to = &gn_RMAP_NODE_12_next,
		.data = &ctkn_RMAP_NODE[12],
	},
	{
		.from = &gn_RMAP_NODE_13_prev,
		.to = &gn_RMAP_NODE_13_next,
		.data = &ctkn_RMAP_NODE[13],
	},
	{
		.from = &gn_RMAP_NODE_14_prev,
		.to = &gn_RMAP_NODE_14_next,
		.data = &ctkn_RMAP_NODE[14],
	},
	{
		.from = &gn_RMAP_NODE_15_prev,
		.to = &gn_RMAP_NODE_15_next,
		.data = &ctkn_RMAP_NODE[15],
	},
	{
		.from = &gn_RMAP_NODE_16_prev,
		.to = &gn_RMAP_NODE_16_next,
		.data = &ctkn_RMAP_NODE[16],
	},
	{
		.from = &gn_RMAP_NODE_17_prev,
		.to = &gn_RMAP_NODE_17_next,
		.data = (void *)&match_extcommunity_limit_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_18_prev,
		.to = &gn_RMAP_NODE_18_next,
		.data = &ctkn_RMAP_NODE[18],
	},
	{
		.from = &gn_RMAP_NODE_19_prev,
		.to = &gn_RMAP_NODE_19_next,
		.data = &ctkn_RMAP_NODE[19],
	},
	{
		.from = &gn_RMAP_NODE_20_prev,
		.to = &gn_RMAP_NODE_20_next,
		.data = &ctkn_RMAP_NODE[20],
	},
	{
		.from = &gn_RMAP_NODE_21_prev,
		.to = &gn_RMAP_NODE_21_next,
		.data = &ctkn_RMAP_NODE[21],
	},
	{
		.from = &gn_RMAP_NODE_22_prev,
		.to = &gn_RMAP_NODE_22_next,
		.data = &ctkn_RMAP_NODE[22],
	},
	{
		.from = &gn_RMAP_NODE_23_prev,
		.to = &gn_RMAP_NODE_23_next,
		.data = &ctkn_RMAP_NODE[23],
	},
	{
		.from = &gn_RMAP_NODE_24_prev,
		.to = &gn_RMAP_NODE_24_next,
		.data = &ctkn_RMAP_NODE[24],
	},
	{
		.from = &gn_RMAP_NODE_25_prev,
		.to = &gn_RMAP_NODE_25_next,
		.data = (void *)&route_map_match_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_26_prev,
		.to = &gn_RMAP_NODE_26_next,
		.data = &ctkn_RMAP_NODE[26],
	},
	{
		.from = &gn_RMAP_NODE_27_prev,
		.to = &gn_RMAP_NODE_27_next,
		.data = &ctkn_RMAP_NODE[27],
	},
	{
		.from = &gn_RMAP_NODE_28_prev,
		.to = &gn_RMAP_NODE_28_next,
		.data = &ctkn_RMAP_NODE[28],
	},
	{
		.from = &gn_RMAP_NODE_29_prev,
		.to = &gn_RMAP_NODE_29_next,
		.data = &ctkn_RMAP_NODE[29],
	},
	{
		.from = &gn_RMAP_NODE_30_prev,
		.to = &gn_RMAP_NODE_30_next,
		.data = &ctkn_RMAP_NODE[30],
	},
	{
		.from = &gn_RMAP_NODE_31_prev,
		.to = &gn_RMAP_NODE_31_next,
		.data = &ctkn_RMAP_NODE[31],
	},
	{
		.from = &gn_RMAP_NODE_32_prev,
		.to = &gn_RMAP_NODE_32_next,
		.data = &ctkn_RMAP_NODE[32],
	},
	{
		.from = &gn_RMAP_NODE_33_prev,
		.to = &gn_RMAP_NODE_33_next,
		.data = &ctkn_RMAP_NODE[33],
	},
	{
		.from = &gn_RMAP_NODE_34_prev,
		.to = &gn_RMAP_NODE_34_next,
		.data = (void *)&route_map_match_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_35_prev,
		.to = &gn_RMAP_NODE_35_next,
		.data = &ctkn_RMAP_NODE[35],
	},
	{
		.from = &gn_RMAP_NODE_36_prev,
		.to = &gn_RMAP_NODE_36_next,
		.data = &ctkn_RMAP_NODE[36],
	},
	{
		.from = &gn_RMAP_NODE_37_prev,
		.to = &gn_RMAP_NODE_37_next,
		.data = &ctkn_RMAP_NODE[37],
	},
	{
		.from = &gn_RMAP_NODE_38_prev,
		.to = &gn_RMAP_NODE_38_next,
		.data = &ctkn_RMAP_NODE[38],
	},
	{
		.from = &gn_RMAP_NODE_39_prev,
		.to = &gn_RMAP_NODE_39_next,
		.data = &ctkn_RMAP_NODE[39],
	},
	{
		.from = &gn_RMAP_NODE_40_prev,
		.to = &gn_RMAP_NODE_40_next,
		.data = &ctkn_RMAP_NODE[40],
	},
	{
		.from = &gn_RMAP_NODE_41_prev,
		.to = &gn_RMAP_NODE_41_next,
		.data = &ctkn_RMAP_NODE[41],
	},
	{
		.from = &gn_RMAP_NODE_42_prev,
		.to = &gn_RMAP_NODE_42_next,
		.data = (void *)&route_map_match_address_v6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_43_prev,
		.to = &gn_RMAP_NODE_43_next,
		.data = &ctkn_RMAP_NODE[43],
	},
	{
		.from = &gn_RMAP_NODE_44_prev,
		.to = &gn_RMAP_NODE_44_next,
		.data = &ctkn_RMAP_NODE[44],
	},
	{
		.from = &gn_RMAP_NODE_45_prev,
		.to = &gn_RMAP_NODE_45_next,
		.data = &ctkn_RMAP_NODE[45],
	},
	{
		.from = &gn_RMAP_NODE_46_prev,
		.to = &gn_RMAP_NODE_46_next,
		.data = &ctkn_RMAP_NODE[46],
	},
	{
		.from = &gn_RMAP_NODE_47_prev,
		.to = &gn_RMAP_NODE_47_next,
		.data = &ctkn_RMAP_NODE[47],
	},
	{
		.from = &gn_RMAP_NODE_48_prev,
		.to = &gn_RMAP_NODE_48_next,
		.data = &ctkn_RMAP_NODE[48],
	},
	{
		.from = &gn_RMAP_NODE_49_prev,
		.to = &gn_RMAP_NODE_49_next,
		.data = &ctkn_RMAP_NODE[49],
	},
	{
		.from = &gn_RMAP_NODE_50_prev,
		.to = &gn_RMAP_NODE_50_next,
		.data = &ctkn_RMAP_NODE[50],
	},
	{
		.from = &gn_RMAP_NODE_51_prev,
		.to = &gn_RMAP_NODE_51_next,
		.data = (void *)&route_map_match_prefix_list_v6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_52_prev,
		.to = &gn_RMAP_NODE_52_next,
		.data = &ctkn_RMAP_NODE[52],
	},
	{
		.from = &gn_RMAP_NODE_53_prev,
		.to = &gn_RMAP_NODE_53_next,
		.data = &ctkn_RMAP_NODE[53],
	},
	{
		.from = &gn_RMAP_NODE_54_prev,
		.to = &gn_RMAP_NODE_54_next,
		.data = &ctkn_RMAP_NODE[54],
	},
	{
		.from = &gn_RMAP_NODE_55_prev,
		.to = &gn_RMAP_NODE_55_next,
		.data = &ctkn_RMAP_NODE[55],
	},
	{
		.from = &gn_RMAP_NODE_56_prev,
		.to = &gn_RMAP_NODE_56_next,
		.data = (void *)&route_map_match_interface_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_57_prev,
		.to = &gn_RMAP_NODE_57_next,
		.data = &ctkn_RMAP_NODE[57],
	},
	{
		.from = &gn_RMAP_NODE_58_prev,
		.to = &gn_RMAP_NODE_58_next,
		.data = &ctkn_RMAP_NODE[58],
	},
	{
		.from = &gn_RMAP_NODE_59_prev,
		.to = &gn_RMAP_NODE_59_next,
		.data = &ctkn_RMAP_NODE[59],
	},
	{
		.from = &gn_RMAP_NODE_60_prev,
		.to = &gn_RMAP_NODE_60_next,
		.data = &ctkn_RMAP_NODE[60],
	},
	{
		.from = &gn_RMAP_NODE_61_prev,
		.to = &gn_RMAP_NODE_61_next,
		.data = &ctkn_RMAP_NODE[61],
	},
	{
		.from = &gn_RMAP_NODE_62_prev,
		.to = &gn_RMAP_NODE_62_next,
		.data = (void *)&match_rpki_extcommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_63_prev,
		.to = &gn_RMAP_NODE_63_next,
		.data = &ctkn_RMAP_NODE[63],
	},
	{
		.from = &gn_RMAP_NODE_64_prev,
		.to = &gn_RMAP_NODE_64_next,
		.data = &ctkn_RMAP_NODE[64],
	},
	{
		.from = &gn_RMAP_NODE_65_prev,
		.to = &gn_RMAP_NODE_65_next,
		.data = &ctkn_RMAP_NODE[65],
	},
	{
		.from = &gn_RMAP_NODE_66_prev,
		.to = &gn_RMAP_NODE_66_next,
		.data = &ctkn_RMAP_NODE[66],
	},
	{
		.from = &gn_RMAP_NODE_67_prev,
		.to = &gn_RMAP_NODE_67_next,
		.data = &ctkn_RMAP_NODE[67],
	},
	{
		.from = &gn_RMAP_NODE_68_prev,
		.to = &gn_RMAP_NODE_68_next,
		.data = (void *)&match_script_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_69_prev,
		.to = &gn_RMAP_NODE_69_next,
		.data = &ctkn_RMAP_NODE[69],
	},
	{
		.from = &gn_RMAP_NODE_70_prev,
		.to = &gn_RMAP_NODE_70_next,
		.data = &ctkn_RMAP_NODE[70],
	},
	{
		.from = &gn_RMAP_NODE_71_prev,
		.to = &gn_RMAP_NODE_71_next,
		.data = &ctkn_RMAP_NODE[71],
	},
	{
		.from = &gn_RMAP_NODE_72_prev,
		.to = &gn_RMAP_NODE_72_next,
		.data = &ctkn_RMAP_NODE[72],
	},
	{
		.from = &gn_RMAP_NODE_73_prev,
		.to = &gn_RMAP_NODE_73_next,
		.data = &ctkn_RMAP_NODE[73],
	},
	{
		.from = &gn_RMAP_NODE_74_prev,
		.to = &gn_RMAP_NODE_74_next,
		.data = (void *)&set_aspath_exclude_all_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_75_prev,
		.to = &gn_RMAP_NODE_75_next,
		.data = &ctkn_RMAP_NODE[75],
	},
	{
		.from = &gn_RMAP_NODE_76_prev,
		.to = &gn_RMAP_NODE_76_next,
		.data = &ctkn_RMAP_NODE[76],
	},
	{
		.from = &gn_RMAP_NODE_77_prev,
		.to = &gn_RMAP_NODE_77_next,
		.data = &ctkn_RMAP_NODE[77],
	},
	{
		.from = &gn_RMAP_NODE_78_prev,
		.to = &gn_RMAP_NODE_78_next,
		.data = &ctkn_RMAP_NODE[78],
	},
	{
		.from = &gn_RMAP_NODE_79_prev,
		.to = &gn_RMAP_NODE_79_next,
		.data = (void *)&set_ip_nexthop_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_80_prev,
		.to = &gn_RMAP_NODE_80_next,
		.data = &ctkn_RMAP_NODE[80],
	},
	{
		.from = &gn_RMAP_NODE_81_prev,
		.to = &gn_RMAP_NODE_81_next,
		.data = &ctkn_RMAP_NODE[81],
	},
	{
		.from = &gn_RMAP_NODE_82_prev,
		.to = &gn_RMAP_NODE_82_next,
		.data = (void *)&set_ip_nexthop_unchanged_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_83_prev,
		.to = &gn_RMAP_NODE_83_next,
		.data = &ctkn_RMAP_NODE[83],
	},
	{
		.from = &gn_RMAP_NODE_84_prev,
		.to = &gn_RMAP_NODE_84_next,
		.data = &ctkn_RMAP_NODE[84],
	},
	{
		.from = &gn_RMAP_NODE_85_prev,
		.to = &gn_RMAP_NODE_85_next,
		.data = &ctkn_RMAP_NODE[85],
	},
	{
		.from = &gn_RMAP_NODE_86_prev,
		.to = &gn_RMAP_NODE_86_next,
		.data = &ctkn_RMAP_NODE[86],
	},
	{
		.from = &gn_RMAP_NODE_87_prev,
		.to = &gn_RMAP_NODE_87_next,
		.data = &ctkn_RMAP_NODE[87],
	},
	{
		.from = &gn_RMAP_NODE_88_prev,
		.to = &gn_RMAP_NODE_88_next,
		.data = (void *)&set_l3vpn_nexthop_encapsulation_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_89_prev,
		.to = &gn_RMAP_NODE_89_next,
		.data = &ctkn_RMAP_NODE[89],
	},
	{
		.from = &gn_RMAP_NODE_90_prev,
		.to = &gn_RMAP_NODE_90_next,
		.data = &ctkn_RMAP_NODE[90],
	},
	{
		.from = &gn_RMAP_NODE_91_prev,
		.to = &gn_RMAP_NODE_91_next,
		.data = &ctkn_RMAP_NODE[91],
	},
	{
		.from = &gn_RMAP_NODE_92_prev,
		.to = &gn_RMAP_NODE_92_next,
		.data = (void *)&rmap_call_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_93_prev,
		.to = &gn_RMAP_NODE_93_next,
		.data = &ctkn_RMAP_NODE[93],
	},
	{
		.from = &gn_RMAP_NODE_94_prev,
		.to = &gn_RMAP_NODE_94_next,
		.data = &ctkn_RMAP_NODE[94],
	},
	{
		.from = &gn_RMAP_NODE_95_prev,
		.to = &gn_RMAP_NODE_95_next,
		.data = &ctkn_RMAP_NODE[95],
	},
	{
		.from = &gn_RMAP_NODE_96_prev,
		.to = &gn_RMAP_NODE_96_next,
		.data = (void *)&rmap_continue_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_97_prev,
		.to = &gn_RMAP_NODE_97_next,
		.data = &ctkn_RMAP_NODE[97],
	},
	{
		.from = &gn_RMAP_NODE_98_prev,
		.to = &gn_RMAP_NODE_98_next,
		.data = &ctkn_RMAP_NODE[98],
	},
	{
		.from = &gn_RMAP_NODE_99_prev,
		.to = &gn_RMAP_NODE_99_next,
		.data = &ctkn_RMAP_NODE[99],
	},
	{
		.from = &gn_RMAP_NODE_100_prev,
		.to = &gn_RMAP_NODE_100_next,
		.data = (void *)&rmap_description_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_101_prev,
		.to = &gn_RMAP_NODE_101_next,
		.data = &ctkn_RMAP_NODE[101],
	},
	{
		.from = &gn_RMAP_NODE_102_prev,
		.to = &gn_RMAP_NODE_102_next,
		.data = &ctkn_RMAP_NODE[102],
	},
	{
		.from = &gn_RMAP_NODE_103_prev,
		.to = &gn_RMAP_NODE_103_next,
		.data = &ctkn_RMAP_NODE[103],
	},
	{
		.from = &gn_RMAP_NODE_104_prev,
		.to = &gn_RMAP_NODE_104_next,
		.data = &ctkn_RMAP_NODE[104],
	},
	{
		.from = &gn_RMAP_NODE_105_prev,
		.to = &gn_RMAP_NODE_105_next,
		.data = (void *)&match_alias_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_106_prev,
		.to = &gn_RMAP_NODE_106_next,
		.data = &ctkn_RMAP_NODE[106],
	},
	{
		.from = &gn_RMAP_NODE_107_prev,
		.to = &gn_RMAP_NODE_107_next,
		.data = &ctkn_RMAP_NODE[107],
	},
	{
		.from = &gn_RMAP_NODE_108_prev,
		.to = &gn_RMAP_NODE_108_next,
		.data = &ctkn_RMAP_NODE[108],
	},
	{
		.from = &gn_RMAP_NODE_109_prev,
		.to = &gn_RMAP_NODE_109_next,
		.data = (void *)&match_aspath_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_110_prev,
		.to = &gn_RMAP_NODE_110_next,
		.data = &ctkn_RMAP_NODE[110],
	},
	{
		.from = &gn_RMAP_NODE_111_prev,
		.to = &gn_RMAP_NODE_111_next,
		.data = &ctkn_RMAP_NODE[111],
	},
	{
		.from = &gn_RMAP_NODE_112_prev,
		.to = &gn_RMAP_NODE_112_next,
		.data = &ctkn_RMAP_NODE[112],
	},
	{
		.from = &gn_RMAP_NODE_113_prev,
		.to = &gn_RMAP_NODE_113_next,
		.data = &ctkn_RMAP_NODE[113],
	},
	{
		.from = &gn_RMAP_NODE_114_prev,
		.to = &gn_RMAP_NODE_114_next,
		.data = &ctkn_RMAP_NODE[114],
	},
	{
		.from = &gn_RMAP_NODE_115_prev,
		.to = &gn_RMAP_NODE_115_next,
		.data = &ctkn_RMAP_NODE[115],
	},
	{
		.from = &gn_RMAP_NODE_116_prev,
		.to = &gn_RMAP_NODE_116_next,
		.data = &ctkn_RMAP_NODE[116],
	},
	{
		.from = &gn_RMAP_NODE_117_prev,
		.to = &gn_RMAP_NODE_117_next,
		.data = &ctkn_RMAP_NODE[117],
	},
	{
		.from = &gn_RMAP_NODE_118_prev,
		.to = &gn_RMAP_NODE_118_next,
		.data = &ctkn_RMAP_NODE[118],
	},
	{
		.from = &gn_RMAP_NODE_119_prev,
		.to = &gn_RMAP_NODE_119_next,
		.data = &ctkn_RMAP_NODE[119],
	},
	{
		.from = &gn_RMAP_NODE_120_prev,
		.to = &gn_RMAP_NODE_120_next,
		.data = (void *)&match_community_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_121_prev,
		.to = &gn_RMAP_NODE_121_next,
		.data = &ctkn_RMAP_NODE[121],
	},
	{
		.from = &gn_RMAP_NODE_122_prev,
		.to = &gn_RMAP_NODE_122_next,
		.data = &ctkn_RMAP_NODE[122],
	},
	{
		.from = &gn_RMAP_NODE_123_prev,
		.to = &gn_RMAP_NODE_123_next,
		.data = &ctkn_RMAP_NODE[123],
	},
	{
		.from = &gn_RMAP_NODE_124_prev,
		.to = &gn_RMAP_NODE_124_next,
		.data = &ctkn_RMAP_NODE[124],
	},
	{
		.from = &gn_RMAP_NODE_125_prev,
		.to = &gn_RMAP_NODE_125_next,
		.data = &ctkn_RMAP_NODE[125],
	},
	{
		.from = &gn_RMAP_NODE_126_prev,
		.to = &gn_RMAP_NODE_126_next,
		.data = &ctkn_RMAP_NODE[126],
	},
	{
		.from = &gn_RMAP_NODE_127_prev,
		.to = &gn_RMAP_NODE_127_next,
		.data = (void *)&match_evpn_default_route_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_128_prev,
		.to = &gn_RMAP_NODE_128_next,
		.data = &ctkn_RMAP_NODE[128],
	},
	{
		.from = &gn_RMAP_NODE_129_prev,
		.to = &gn_RMAP_NODE_129_next,
		.data = &ctkn_RMAP_NODE[129],
	},
	{
		.from = &gn_RMAP_NODE_130_prev,
		.to = &gn_RMAP_NODE_130_next,
		.data = &ctkn_RMAP_NODE[130],
	},
	{
		.from = &gn_RMAP_NODE_131_prev,
		.to = &gn_RMAP_NODE_131_next,
		.data = (void *)&match_evpn_rd_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_132_prev,
		.to = &gn_RMAP_NODE_132_next,
		.data = &ctkn_RMAP_NODE[132],
	},
	{
		.from = &gn_RMAP_NODE_133_prev,
		.to = &gn_RMAP_NODE_133_next,
		.data = &ctkn_RMAP_NODE[133],
	},
	{
		.from = &gn_RMAP_NODE_134_prev,
		.to = &gn_RMAP_NODE_134_next,
		.data = &ctkn_RMAP_NODE[134],
	},
	{
		.from = &gn_RMAP_NODE_135_prev,
		.to = &gn_RMAP_NODE_135_next,
		.data = &ctkn_RMAP_NODE[135],
	},
	{
		.from = &gn_RMAP_NODE_136_prev,
		.to = &gn_RMAP_NODE_136_next,
		.data = &ctkn_RMAP_NODE[136],
	},
	{
		.from = &gn_RMAP_NODE_137_prev,
		.to = &gn_RMAP_NODE_137_next,
		.data = (void *)&match_evpn_route_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_138_prev,
		.to = &gn_RMAP_NODE_138_next,
		.data = &ctkn_RMAP_NODE[138],
	},
	{
		.from = &gn_RMAP_NODE_139_prev,
		.to = &gn_RMAP_NODE_139_next,
		.data = &ctkn_RMAP_NODE[139],
	},
	{
		.from = &gn_RMAP_NODE_140_prev,
		.to = &gn_RMAP_NODE_140_next,
		.data = &ctkn_RMAP_NODE[140],
	},
	{
		.from = &gn_RMAP_NODE_141_prev,
		.to = &gn_RMAP_NODE_141_next,
		.data = &ctkn_RMAP_NODE[141],
	},
	{
		.from = &gn_RMAP_NODE_142_prev,
		.to = &gn_RMAP_NODE_142_next,
		.data = &ctkn_RMAP_NODE[142],
	},
	{
		.from = &gn_RMAP_NODE_143_prev,
		.to = &gn_RMAP_NODE_143_next,
		.data = &ctkn_RMAP_NODE[143],
	},
	{
		.from = &gn_RMAP_NODE_144_prev,
		.to = &gn_RMAP_NODE_144_next,
		.data = &ctkn_RMAP_NODE[144],
	},
	{
		.from = &gn_RMAP_NODE_145_prev,
		.to = &gn_RMAP_NODE_145_next,
		.data = &ctkn_RMAP_NODE[145],
	},
	{
		.from = &gn_RMAP_NODE_146_prev,
		.to = &gn_RMAP_NODE_146_next,
		.data = &ctkn_RMAP_NODE[146],
	},
	{
		.from = &gn_RMAP_NODE_147_prev,
		.to = &gn_RMAP_NODE_147_next,
		.data = &ctkn_RMAP_NODE[147],
	},
	{
		.from = &gn_RMAP_NODE_148_prev,
		.to = &gn_RMAP_NODE_148_next,
		.data = &ctkn_RMAP_NODE[148],
	},
	{
		.from = &gn_RMAP_NODE_149_prev,
		.to = &gn_RMAP_NODE_149_next,
		.data = &ctkn_RMAP_NODE[149],
	},
	{
		.from = &gn_RMAP_NODE_150_prev,
		.to = &gn_RMAP_NODE_150_next,
		.data = (void *)&match_evpn_vni_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_151_prev,
		.to = &gn_RMAP_NODE_151_next,
		.data = &ctkn_RMAP_NODE[151],
	},
	{
		.from = &gn_RMAP_NODE_152_prev,
		.to = &gn_RMAP_NODE_152_next,
		.data = &ctkn_RMAP_NODE[152],
	},
	{
		.from = &gn_RMAP_NODE_153_prev,
		.to = &gn_RMAP_NODE_153_next,
		.data = &ctkn_RMAP_NODE[153],
	},
	{
		.from = &gn_RMAP_NODE_154_prev,
		.to = &gn_RMAP_NODE_154_next,
		.data = &ctkn_RMAP_NODE[154],
	},
	{
		.from = &gn_RMAP_NODE_155_prev,
		.to = &gn_RMAP_NODE_155_next,
		.data = &ctkn_RMAP_NODE[155],
	},
	{
		.from = &gn_RMAP_NODE_156_prev,
		.to = &gn_RMAP_NODE_156_next,
		.data = &ctkn_RMAP_NODE[156],
	},
	{
		.from = &gn_RMAP_NODE_157_prev,
		.to = &gn_RMAP_NODE_157_next,
		.data = &ctkn_RMAP_NODE[157],
	},
	{
		.from = &gn_RMAP_NODE_158_prev,
		.to = &gn_RMAP_NODE_158_next,
		.data = &ctkn_RMAP_NODE[158],
	},
	{
		.from = &gn_RMAP_NODE_159_prev,
		.to = &gn_RMAP_NODE_159_next,
		.data = &ctkn_RMAP_NODE[159],
	},
	{
		.from = &gn_RMAP_NODE_160_prev,
		.to = &gn_RMAP_NODE_160_next,
		.data = &ctkn_RMAP_NODE[160],
	},
	{
		.from = &gn_RMAP_NODE_161_prev,
		.to = &gn_RMAP_NODE_161_next,
		.data = (void *)&match_ecommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_162_prev,
		.to = &gn_RMAP_NODE_162_next,
		.data = &ctkn_RMAP_NODE[162],
	},
	{
		.from = &gn_RMAP_NODE_163_prev,
		.to = &gn_RMAP_NODE_163_next,
		.data = &ctkn_RMAP_NODE[163],
	},
	{
		.from = &gn_RMAP_NODE_164_prev,
		.to = &gn_RMAP_NODE_164_next,
		.data = &ctkn_RMAP_NODE[164],
	},
	{
		.from = &gn_RMAP_NODE_165_prev,
		.to = &gn_RMAP_NODE_165_next,
		.data = &ctkn_RMAP_NODE[165],
	},
	{
		.from = &gn_RMAP_NODE_166_prev,
		.to = &gn_RMAP_NODE_166_next,
		.data = &ctkn_RMAP_NODE[166],
	},
	{
		.from = &gn_RMAP_NODE_167_prev,
		.to = &gn_RMAP_NODE_167_next,
		.data = &ctkn_RMAP_NODE[167],
	},
	{
		.from = &gn_RMAP_NODE_168_prev,
		.to = &gn_RMAP_NODE_168_next,
		.data = (void *)&match_interface_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_169_prev,
		.to = &gn_RMAP_NODE_169_next,
		.data = &ctkn_RMAP_NODE[169],
	},
	{
		.from = &gn_RMAP_NODE_170_prev,
		.to = &gn_RMAP_NODE_170_next,
		.data = &ctkn_RMAP_NODE[170],
	},
	{
		.from = &gn_RMAP_NODE_171_prev,
		.to = &gn_RMAP_NODE_171_next,
		.data = &ctkn_RMAP_NODE[171],
	},
	{
		.from = &gn_RMAP_NODE_172_prev,
		.to = &gn_RMAP_NODE_172_next,
		.data = &ctkn_RMAP_NODE[172],
	},
	{
		.from = &gn_RMAP_NODE_173_prev,
		.to = &gn_RMAP_NODE_173_next,
		.data = (void *)&match_ip_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_174_prev,
		.to = &gn_RMAP_NODE_174_next,
		.data = &ctkn_RMAP_NODE[174],
	},
	{
		.from = &gn_RMAP_NODE_175_prev,
		.to = &gn_RMAP_NODE_175_next,
		.data = &ctkn_RMAP_NODE[175],
	},
	{
		.from = &gn_RMAP_NODE_176_prev,
		.to = &gn_RMAP_NODE_176_next,
		.data = &ctkn_RMAP_NODE[176],
	},
	{
		.from = &gn_RMAP_NODE_177_prev,
		.to = &gn_RMAP_NODE_177_next,
		.data = (void *)&match_ip_address_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_178_prev,
		.to = &gn_RMAP_NODE_178_next,
		.data = &ctkn_RMAP_NODE[178],
	},
	{
		.from = &gn_RMAP_NODE_179_prev,
		.to = &gn_RMAP_NODE_179_next,
		.data = &ctkn_RMAP_NODE[179],
	},
	{
		.from = &gn_RMAP_NODE_180_prev,
		.to = &gn_RMAP_NODE_180_next,
		.data = &ctkn_RMAP_NODE[180],
	},
	{
		.from = &gn_RMAP_NODE_181_prev,
		.to = &gn_RMAP_NODE_181_next,
		.data = (void *)&match_ip_address_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_182_prev,
		.to = &gn_RMAP_NODE_182_next,
		.data = &ctkn_RMAP_NODE[182],
	},
	{
		.from = &gn_RMAP_NODE_183_prev,
		.to = &gn_RMAP_NODE_183_next,
		.data = &ctkn_RMAP_NODE[183],
	},
	{
		.from = &gn_RMAP_NODE_184_prev,
		.to = &gn_RMAP_NODE_184_next,
		.data = &ctkn_RMAP_NODE[184],
	},
	{
		.from = &gn_RMAP_NODE_185_prev,
		.to = &gn_RMAP_NODE_185_next,
		.data = (void *)&match_ip_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_186_prev,
		.to = &gn_RMAP_NODE_186_next,
		.data = &ctkn_RMAP_NODE[186],
	},
	{
		.from = &gn_RMAP_NODE_187_prev,
		.to = &gn_RMAP_NODE_187_next,
		.data = &ctkn_RMAP_NODE[187],
	},
	{
		.from = &gn_RMAP_NODE_188_prev,
		.to = &gn_RMAP_NODE_188_next,
		.data = &ctkn_RMAP_NODE[188],
	},
	{
		.from = &gn_RMAP_NODE_189_prev,
		.to = &gn_RMAP_NODE_189_next,
		.data = (void *)&match_ipv4_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_190_prev,
		.to = &gn_RMAP_NODE_190_next,
		.data = &ctkn_RMAP_NODE[190],
	},
	{
		.from = &gn_RMAP_NODE_191_prev,
		.to = &gn_RMAP_NODE_191_next,
		.data = &ctkn_RMAP_NODE[191],
	},
	{
		.from = &gn_RMAP_NODE_192_prev,
		.to = &gn_RMAP_NODE_192_next,
		.data = &ctkn_RMAP_NODE[192],
	},
	{
		.from = &gn_RMAP_NODE_193_prev,
		.to = &gn_RMAP_NODE_193_next,
		.data = (void *)&match_ip_nexthop_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_194_prev,
		.to = &gn_RMAP_NODE_194_next,
		.data = &ctkn_RMAP_NODE[194],
	},
	{
		.from = &gn_RMAP_NODE_195_prev,
		.to = &gn_RMAP_NODE_195_next,
		.data = &ctkn_RMAP_NODE[195],
	},
	{
		.from = &gn_RMAP_NODE_196_prev,
		.to = &gn_RMAP_NODE_196_next,
		.data = &ctkn_RMAP_NODE[196],
	},
	{
		.from = &gn_RMAP_NODE_197_prev,
		.to = &gn_RMAP_NODE_197_next,
		.data = (void *)&match_ip_next_hop_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_198_prev,
		.to = &gn_RMAP_NODE_198_next,
		.data = &ctkn_RMAP_NODE[198],
	},
	{
		.from = &gn_RMAP_NODE_199_prev,
		.to = &gn_RMAP_NODE_199_next,
		.data = &ctkn_RMAP_NODE[199],
	},
	{
		.from = &gn_RMAP_NODE_200_prev,
		.to = &gn_RMAP_NODE_200_next,
		.data = &ctkn_RMAP_NODE[200],
	},
	{
		.from = &gn_RMAP_NODE_201_prev,
		.to = &gn_RMAP_NODE_201_next,
		.data = &ctkn_RMAP_NODE[201],
	},
	{
		.from = &gn_RMAP_NODE_202_prev,
		.to = &gn_RMAP_NODE_202_next,
		.data = &ctkn_RMAP_NODE[202],
	},
	{
		.from = &gn_RMAP_NODE_203_prev,
		.to = &gn_RMAP_NODE_203_next,
		.data = (void *)&match_ip_next_hop_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_204_prev,
		.to = &gn_RMAP_NODE_204_next,
		.data = &ctkn_RMAP_NODE[204],
	},
	{
		.from = &gn_RMAP_NODE_205_prev,
		.to = &gn_RMAP_NODE_205_next,
		.data = &ctkn_RMAP_NODE[205],
	},
	{
		.from = &gn_RMAP_NODE_206_prev,
		.to = &gn_RMAP_NODE_206_next,
		.data = &ctkn_RMAP_NODE[206],
	},
	{
		.from = &gn_RMAP_NODE_207_prev,
		.to = &gn_RMAP_NODE_207_next,
		.data = (void *)&match_ip_route_source_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_208_prev,
		.to = &gn_RMAP_NODE_208_next,
		.data = &ctkn_RMAP_NODE[208],
	},
	{
		.from = &gn_RMAP_NODE_209_prev,
		.to = &gn_RMAP_NODE_209_next,
		.data = &ctkn_RMAP_NODE[209],
	},
	{
		.from = &gn_RMAP_NODE_210_prev,
		.to = &gn_RMAP_NODE_210_next,
		.data = &ctkn_RMAP_NODE[210],
	},
	{
		.from = &gn_RMAP_NODE_211_prev,
		.to = &gn_RMAP_NODE_211_next,
		.data = (void *)&match_ip_route_source_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_212_prev,
		.to = &gn_RMAP_NODE_212_next,
		.data = &ctkn_RMAP_NODE[212],
	},
	{
		.from = &gn_RMAP_NODE_213_prev,
		.to = &gn_RMAP_NODE_213_next,
		.data = &ctkn_RMAP_NODE[213],
	},
	{
		.from = &gn_RMAP_NODE_214_prev,
		.to = &gn_RMAP_NODE_214_next,
		.data = &ctkn_RMAP_NODE[214],
	},
	{
		.from = &gn_RMAP_NODE_215_prev,
		.to = &gn_RMAP_NODE_215_next,
		.data = &ctkn_RMAP_NODE[215],
	},
	{
		.from = &gn_RMAP_NODE_216_prev,
		.to = &gn_RMAP_NODE_216_next,
		.data = (void *)&match_ipv6_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_217_prev,
		.to = &gn_RMAP_NODE_217_next,
		.data = &ctkn_RMAP_NODE[217],
	},
	{
		.from = &gn_RMAP_NODE_218_prev,
		.to = &gn_RMAP_NODE_218_next,
		.data = &ctkn_RMAP_NODE[218],
	},
	{
		.from = &gn_RMAP_NODE_219_prev,
		.to = &gn_RMAP_NODE_219_next,
		.data = &ctkn_RMAP_NODE[219],
	},
	{
		.from = &gn_RMAP_NODE_220_prev,
		.to = &gn_RMAP_NODE_220_next,
		.data = (void *)&match_ipv6_address_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_221_prev,
		.to = &gn_RMAP_NODE_221_next,
		.data = &ctkn_RMAP_NODE[221],
	},
	{
		.from = &gn_RMAP_NODE_222_prev,
		.to = &gn_RMAP_NODE_222_next,
		.data = &ctkn_RMAP_NODE[222],
	},
	{
		.from = &gn_RMAP_NODE_223_prev,
		.to = &gn_RMAP_NODE_223_next,
		.data = &ctkn_RMAP_NODE[223],
	},
	{
		.from = &gn_RMAP_NODE_224_prev,
		.to = &gn_RMAP_NODE_224_next,
		.data = (void *)&match_ipv6_address_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_225_prev,
		.to = &gn_RMAP_NODE_225_next,
		.data = &ctkn_RMAP_NODE[225],
	},
	{
		.from = &gn_RMAP_NODE_226_prev,
		.to = &gn_RMAP_NODE_226_next,
		.data = &ctkn_RMAP_NODE[226],
	},
	{
		.from = &gn_RMAP_NODE_227_prev,
		.to = &gn_RMAP_NODE_227_next,
		.data = &ctkn_RMAP_NODE[227],
	},
	{
		.from = &gn_RMAP_NODE_228_prev,
		.to = &gn_RMAP_NODE_228_next,
		.data = (void *)&match_ipv6_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_229_prev,
		.to = &gn_RMAP_NODE_229_next,
		.data = &ctkn_RMAP_NODE[229],
	},
	{
		.from = &gn_RMAP_NODE_230_prev,
		.to = &gn_RMAP_NODE_230_next,
		.data = &ctkn_RMAP_NODE[230],
	},
	{
		.from = &gn_RMAP_NODE_231_prev,
		.to = &gn_RMAP_NODE_231_next,
		.data = (void *)&match_ipv6_next_hop_old_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_232_prev,
		.to = &gn_RMAP_NODE_232_next,
		.data = &ctkn_RMAP_NODE[232],
	},
	{
		.from = &gn_RMAP_NODE_233_prev,
		.to = &gn_RMAP_NODE_233_next,
		.data = &ctkn_RMAP_NODE[233],
	},
	{
		.from = &gn_RMAP_NODE_234_prev,
		.to = &gn_RMAP_NODE_234_next,
		.data = &ctkn_RMAP_NODE[234],
	},
	{
		.from = &gn_RMAP_NODE_235_prev,
		.to = &gn_RMAP_NODE_235_next,
		.data = (void *)&match_ipv6_next_hop_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_236_prev,
		.to = &gn_RMAP_NODE_236_next,
		.data = &ctkn_RMAP_NODE[236],
	},
	{
		.from = &gn_RMAP_NODE_237_prev,
		.to = &gn_RMAP_NODE_237_next,
		.data = &ctkn_RMAP_NODE[237],
	},
	{
		.from = &gn_RMAP_NODE_238_prev,
		.to = &gn_RMAP_NODE_238_next,
		.data = &ctkn_RMAP_NODE[238],
	},
	{
		.from = &gn_RMAP_NODE_239_prev,
		.to = &gn_RMAP_NODE_239_next,
		.data = (void *)&match_ipv6_next_hop_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_240_prev,
		.to = &gn_RMAP_NODE_240_next,
		.data = &ctkn_RMAP_NODE[240],
	},
	{
		.from = &gn_RMAP_NODE_241_prev,
		.to = &gn_RMAP_NODE_241_next,
		.data = &ctkn_RMAP_NODE[241],
	},
	{
		.from = &gn_RMAP_NODE_242_prev,
		.to = &gn_RMAP_NODE_242_next,
		.data = &ctkn_RMAP_NODE[242],
	},
	{
		.from = &gn_RMAP_NODE_243_prev,
		.to = &gn_RMAP_NODE_243_next,
		.data = &ctkn_RMAP_NODE[243],
	},
	{
		.from = &gn_RMAP_NODE_244_prev,
		.to = &gn_RMAP_NODE_244_next,
		.data = &ctkn_RMAP_NODE[244],
	},
	{
		.from = &gn_RMAP_NODE_245_prev,
		.to = &gn_RMAP_NODE_245_next,
		.data = (void *)&match_ipv6_next_hop_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_246_prev,
		.to = &gn_RMAP_NODE_246_next,
		.data = &ctkn_RMAP_NODE[246],
	},
	{
		.from = &gn_RMAP_NODE_247_prev,
		.to = &gn_RMAP_NODE_247_next,
		.data = &ctkn_RMAP_NODE[247],
	},
	{
		.from = &gn_RMAP_NODE_248_prev,
		.to = &gn_RMAP_NODE_248_next,
		.data = &ctkn_RMAP_NODE[248],
	},
	{
		.from = &gn_RMAP_NODE_249_prev,
		.to = &gn_RMAP_NODE_249_next,
		.data = &ctkn_RMAP_NODE[249],
	},
	{
		.from = &gn_RMAP_NODE_250_prev,
		.to = &gn_RMAP_NODE_250_next,
		.data = &ctkn_RMAP_NODE[250],
	},
	{
		.from = &gn_RMAP_NODE_251_prev,
		.to = &gn_RMAP_NODE_251_next,
		.data = &ctkn_RMAP_NODE[251],
	},
	{
		.from = &gn_RMAP_NODE_252_prev,
		.to = &gn_RMAP_NODE_252_next,
		.data = &ctkn_RMAP_NODE[252],
	},
	{
		.from = &gn_RMAP_NODE_253_prev,
		.to = &gn_RMAP_NODE_253_next,
		.data = &ctkn_RMAP_NODE[253],
	},
	{
		.from = &gn_RMAP_NODE_254_prev,
		.to = &gn_RMAP_NODE_254_next,
		.data = &ctkn_RMAP_NODE[254],
	},
	{
		.from = &gn_RMAP_NODE_255_prev,
		.to = &gn_RMAP_NODE_255_next,
		.data = &ctkn_RMAP_NODE[255],
	},
	{
		.from = &gn_RMAP_NODE_256_prev,
		.to = &gn_RMAP_NODE_256_next,
		.data = (void *)&match_lcommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_257_prev,
		.to = &gn_RMAP_NODE_257_next,
		.data = &ctkn_RMAP_NODE[257],
	},
	{
		.from = &gn_RMAP_NODE_258_prev,
		.to = &gn_RMAP_NODE_258_next,
		.data = &ctkn_RMAP_NODE[258],
	},
	{
		.from = &gn_RMAP_NODE_259_prev,
		.to = &gn_RMAP_NODE_259_next,
		.data = &ctkn_RMAP_NODE[259],
	},
	{
		.from = &gn_RMAP_NODE_260_prev,
		.to = &gn_RMAP_NODE_260_next,
		.data = &ctkn_RMAP_NODE[260],
	},
	{
		.from = &gn_RMAP_NODE_261_prev,
		.to = &gn_RMAP_NODE_261_next,
		.data = &ctkn_RMAP_NODE[261],
	},
	{
		.from = &gn_RMAP_NODE_262_prev,
		.to = &gn_RMAP_NODE_262_next,
		.data = &ctkn_RMAP_NODE[262],
	},
	{
		.from = &gn_RMAP_NODE_263_prev,
		.to = &gn_RMAP_NODE_263_next,
		.data = (void *)&match_local_pref_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_264_prev,
		.to = &gn_RMAP_NODE_264_next,
		.data = &ctkn_RMAP_NODE[264],
	},
	{
		.from = &gn_RMAP_NODE_265_prev,
		.to = &gn_RMAP_NODE_265_next,
		.data = &ctkn_RMAP_NODE[265],
	},
	{
		.from = &gn_RMAP_NODE_266_prev,
		.to = &gn_RMAP_NODE_266_next,
		.data = &ctkn_RMAP_NODE[266],
	},
	{
		.from = &gn_RMAP_NODE_267_prev,
		.to = &gn_RMAP_NODE_267_next,
		.data = &ctkn_RMAP_NODE[267],
	},
	{
		.from = &gn_RMAP_NODE_268_prev,
		.to = &gn_RMAP_NODE_268_next,
		.data = (void *)&match_mac_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_269_prev,
		.to = &gn_RMAP_NODE_269_next,
		.data = &ctkn_RMAP_NODE[269],
	},
	{
		.from = &gn_RMAP_NODE_270_prev,
		.to = &gn_RMAP_NODE_270_next,
		.data = &ctkn_RMAP_NODE[270],
	},
	{
		.from = &gn_RMAP_NODE_271_prev,
		.to = &gn_RMAP_NODE_271_next,
		.data = &ctkn_RMAP_NODE[271],
	},
	{
		.from = &gn_RMAP_NODE_272_prev,
		.to = &gn_RMAP_NODE_272_next,
		.data = (void *)&match_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_273_prev,
		.to = &gn_RMAP_NODE_273_next,
		.data = &ctkn_RMAP_NODE[273],
	},
	{
		.from = &gn_RMAP_NODE_274_prev,
		.to = &gn_RMAP_NODE_274_next,
		.data = &ctkn_RMAP_NODE[274],
	},
	{
		.from = &gn_RMAP_NODE_275_prev,
		.to = &gn_RMAP_NODE_275_next,
		.data = &ctkn_RMAP_NODE[275],
	},
	{
		.from = &gn_RMAP_NODE_276_prev,
		.to = &gn_RMAP_NODE_276_next,
		.data = &ctkn_RMAP_NODE[276],
	},
	{
		.from = &gn_RMAP_NODE_277_prev,
		.to = &gn_RMAP_NODE_277_next,
		.data = &ctkn_RMAP_NODE[277],
	},
	{
		.from = &gn_RMAP_NODE_278_prev,
		.to = &gn_RMAP_NODE_278_next,
		.data = (void *)&match_origin_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_279_prev,
		.to = &gn_RMAP_NODE_279_next,
		.data = &ctkn_RMAP_NODE[279],
	},
	{
		.from = &gn_RMAP_NODE_280_prev,
		.to = &gn_RMAP_NODE_280_next,
		.data = &ctkn_RMAP_NODE[280],
	},
	{
		.from = &gn_RMAP_NODE_281_prev,
		.to = &gn_RMAP_NODE_281_next,
		.data = &ctkn_RMAP_NODE[281],
	},
	{
		.from = &gn_RMAP_NODE_282_prev,
		.to = &gn_RMAP_NODE_282_next,
		.data = &ctkn_RMAP_NODE[282],
	},
	{
		.from = &gn_RMAP_NODE_283_prev,
		.to = &gn_RMAP_NODE_283_next,
		.data = &ctkn_RMAP_NODE[283],
	},
	{
		.from = &gn_RMAP_NODE_284_prev,
		.to = &gn_RMAP_NODE_284_next,
		.data = &ctkn_RMAP_NODE[284],
	},
	{
		.from = &gn_RMAP_NODE_285_prev,
		.to = &gn_RMAP_NODE_285_next,
		.data = &ctkn_RMAP_NODE[285],
	},
	{
		.from = &gn_RMAP_NODE_286_prev,
		.to = &gn_RMAP_NODE_286_next,
		.data = (void *)&match_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_287_prev,
		.to = &gn_RMAP_NODE_287_next,
		.data = &ctkn_RMAP_NODE[287],
	},
	{
		.from = &gn_RMAP_NODE_288_prev,
		.to = &gn_RMAP_NODE_288_next,
		.data = &ctkn_RMAP_NODE[288],
	},
	{
		.from = &gn_RMAP_NODE_289_prev,
		.to = &gn_RMAP_NODE_289_next,
		.data = &ctkn_RMAP_NODE[289],
	},
	{
		.from = &gn_RMAP_NODE_290_prev,
		.to = &gn_RMAP_NODE_290_next,
		.data = &ctkn_RMAP_NODE[290],
	},
	{
		.from = &gn_RMAP_NODE_291_prev,
		.to = &gn_RMAP_NODE_291_next,
		.data = (void *)&match_peer_local_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_292_prev,
		.to = &gn_RMAP_NODE_292_next,
		.data = &ctkn_RMAP_NODE[292],
	},
	{
		.from = &gn_RMAP_NODE_293_prev,
		.to = &gn_RMAP_NODE_293_next,
		.data = &ctkn_RMAP_NODE[293],
	},
	{
		.from = &gn_RMAP_NODE_294_prev,
		.to = &gn_RMAP_NODE_294_next,
		.data = &ctkn_RMAP_NODE[294],
	},
	{
		.from = &gn_RMAP_NODE_295_prev,
		.to = &gn_RMAP_NODE_295_next,
		.data = (void *)&match_probability_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_296_prev,
		.to = &gn_RMAP_NODE_296_next,
		.data = &ctkn_RMAP_NODE[296],
	},
	{
		.from = &gn_RMAP_NODE_297_prev,
		.to = &gn_RMAP_NODE_297_next,
		.data = &ctkn_RMAP_NODE[297],
	},
	{
		.from = &gn_RMAP_NODE_298_prev,
		.to = &gn_RMAP_NODE_298_next,
		.data = &ctkn_RMAP_NODE[298],
	},
	{
		.from = &gn_RMAP_NODE_299_prev,
		.to = &gn_RMAP_NODE_299_next,
		.data = &ctkn_RMAP_NODE[299],
	},
	{
		.from = &gn_RMAP_NODE_300_prev,
		.to = &gn_RMAP_NODE_300_next,
		.data = &ctkn_RMAP_NODE[300],
	},
	{
		.from = &gn_RMAP_NODE_301_prev,
		.to = &gn_RMAP_NODE_301_next,
		.data = (void *)&match_rpki_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_302_prev,
		.to = &gn_RMAP_NODE_302_next,
		.data = &ctkn_RMAP_NODE[302],
	},
	{
		.from = &gn_RMAP_NODE_303_prev,
		.to = &gn_RMAP_NODE_303_next,
		.data = &ctkn_RMAP_NODE[303],
	},
	{
		.from = &gn_RMAP_NODE_304_prev,
		.to = &gn_RMAP_NODE_304_next,
		.data = &ctkn_RMAP_NODE[304],
	},
	{
		.from = &gn_RMAP_NODE_305_prev,
		.to = &gn_RMAP_NODE_305_next,
		.data = &ctkn_RMAP_NODE[305],
	},
	{
		.from = &gn_RMAP_NODE_306_prev,
		.to = &gn_RMAP_NODE_306_next,
		.data = &ctkn_RMAP_NODE[306],
	},
	{
		.from = &gn_RMAP_NODE_307_prev,
		.to = &gn_RMAP_NODE_307_next,
		.data = (void *)&match_source_instance_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_308_prev,
		.to = &gn_RMAP_NODE_308_next,
		.data = &ctkn_RMAP_NODE[308],
	},
	{
		.from = &gn_RMAP_NODE_309_prev,
		.to = &gn_RMAP_NODE_309_next,
		.data = &ctkn_RMAP_NODE[309],
	},
	{
		.from = &gn_RMAP_NODE_310_prev,
		.to = &gn_RMAP_NODE_310_next,
		.data = &ctkn_RMAP_NODE[310],
	},
	{
		.from = &gn_RMAP_NODE_311_prev,
		.to = &gn_RMAP_NODE_311_next,
		.data = &ctkn_RMAP_NODE[311],
	},
	{
		.from = &gn_RMAP_NODE_312_prev,
		.to = &gn_RMAP_NODE_312_next,
		.data = &ctkn_RMAP_NODE[312],
	},
	{
		.from = &gn_RMAP_NODE_313_prev,
		.to = &gn_RMAP_NODE_313_next,
		.data = (void *)&match_source_protocol_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_314_prev,
		.to = &gn_RMAP_NODE_314_next,
		.data = &ctkn_RMAP_NODE[314],
	},
	{
		.from = &gn_RMAP_NODE_315_prev,
		.to = &gn_RMAP_NODE_315_next,
		.data = &ctkn_RMAP_NODE[315],
	},
	{
		.from = &gn_RMAP_NODE_316_prev,
		.to = &gn_RMAP_NODE_316_next,
		.data = &ctkn_RMAP_NODE[316],
	},
	{
		.from = &gn_RMAP_NODE_317_prev,
		.to = &gn_RMAP_NODE_317_next,
		.data = &ctkn_RMAP_NODE[317],
	},
	{
		.from = &gn_RMAP_NODE_318_prev,
		.to = &gn_RMAP_NODE_318_next,
		.data = &ctkn_RMAP_NODE[318],
	},
	{
		.from = &gn_RMAP_NODE_319_prev,
		.to = &gn_RMAP_NODE_319_next,
		.data = &ctkn_RMAP_NODE[319],
	},
	{
		.from = &gn_RMAP_NODE_320_prev,
		.to = &gn_RMAP_NODE_320_next,
		.data = &ctkn_RMAP_NODE[320],
	},
	{
		.from = &gn_RMAP_NODE_321_prev,
		.to = &gn_RMAP_NODE_321_next,
		.data = &ctkn_RMAP_NODE[321],
	},
	{
		.from = &gn_RMAP_NODE_322_prev,
		.to = &gn_RMAP_NODE_322_next,
		.data = &ctkn_RMAP_NODE[322],
	},
	{
		.from = &gn_RMAP_NODE_323_prev,
		.to = &gn_RMAP_NODE_323_next,
		.data = &ctkn_RMAP_NODE[323],
	},
	{
		.from = &gn_RMAP_NODE_324_prev,
		.to = &gn_RMAP_NODE_324_next,
		.data = &ctkn_RMAP_NODE[324],
	},
	{
		.from = &gn_RMAP_NODE_325_prev,
		.to = &gn_RMAP_NODE_325_next,
		.data = &ctkn_RMAP_NODE[325],
	},
	{
		.from = &gn_RMAP_NODE_326_prev,
		.to = &gn_RMAP_NODE_326_next,
		.data = &ctkn_RMAP_NODE[326],
	},
	{
		.from = &gn_RMAP_NODE_327_prev,
		.to = &gn_RMAP_NODE_327_next,
		.data = &ctkn_RMAP_NODE[327],
	},
	{
		.from = &gn_RMAP_NODE_328_prev,
		.to = &gn_RMAP_NODE_328_next,
		.data = &ctkn_RMAP_NODE[328],
	},
	{
		.from = &gn_RMAP_NODE_329_prev,
		.to = &gn_RMAP_NODE_329_next,
		.data = &ctkn_RMAP_NODE[329],
	},
	{
		.from = &gn_RMAP_NODE_330_prev,
		.to = &gn_RMAP_NODE_330_next,
		.data = &ctkn_RMAP_NODE[330],
	},
	{
		.from = &gn_RMAP_NODE_331_prev,
		.to = &gn_RMAP_NODE_331_next,
		.data = (void *)&match_vrl_source_vrf_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_332_prev,
		.to = &gn_RMAP_NODE_332_next,
		.data = &ctkn_RMAP_NODE[332],
	},
	{
		.from = &gn_RMAP_NODE_333_prev,
		.to = &gn_RMAP_NODE_333_next,
		.data = &ctkn_RMAP_NODE[333],
	},
	{
		.from = &gn_RMAP_NODE_334_prev,
		.to = &gn_RMAP_NODE_334_next,
		.data = &ctkn_RMAP_NODE[334],
	},
	{
		.from = &gn_RMAP_NODE_335_prev,
		.to = &gn_RMAP_NODE_335_next,
		.data = &ctkn_RMAP_NODE[335],
	},
	{
		.from = &gn_RMAP_NODE_336_prev,
		.to = &gn_RMAP_NODE_336_next,
		.data = &ctkn_RMAP_NODE[336],
	},
	{
		.from = &gn_RMAP_NODE_337_prev,
		.to = &gn_RMAP_NODE_337_next,
		.data = (void *)&match_src_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_338_prev,
		.to = &gn_RMAP_NODE_338_next,
		.data = &ctkn_RMAP_NODE[338],
	},
	{
		.from = &gn_RMAP_NODE_339_prev,
		.to = &gn_RMAP_NODE_339_next,
		.data = &ctkn_RMAP_NODE[339],
	},
	{
		.from = &gn_RMAP_NODE_340_prev,
		.to = &gn_RMAP_NODE_340_next,
		.data = &ctkn_RMAP_NODE[340],
	},
	{
		.from = &gn_RMAP_NODE_341_prev,
		.to = &gn_RMAP_NODE_341_next,
		.data = &ctkn_RMAP_NODE[341],
	},
	{
		.from = &gn_RMAP_NODE_342_prev,
		.to = &gn_RMAP_NODE_342_next,
		.data = &ctkn_RMAP_NODE[342],
	},
	{
		.from = &gn_RMAP_NODE_343_prev,
		.to = &gn_RMAP_NODE_343_next,
		.data = &ctkn_RMAP_NODE[343],
	},
	{
		.from = &gn_RMAP_NODE_344_prev,
		.to = &gn_RMAP_NODE_344_next,
		.data = &ctkn_RMAP_NODE[344],
	},
	{
		.from = &gn_RMAP_NODE_345_prev,
		.to = &gn_RMAP_NODE_345_next,
		.data = (void *)&match_tag_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_346_prev,
		.to = &gn_RMAP_NODE_346_next,
		.data = &ctkn_RMAP_NODE[346],
	},
	{
		.from = &gn_RMAP_NODE_347_prev,
		.to = &gn_RMAP_NODE_347_next,
		.data = &ctkn_RMAP_NODE[347],
	},
	{
		.from = &gn_RMAP_NODE_348_prev,
		.to = &gn_RMAP_NODE_348_next,
		.data = &ctkn_RMAP_NODE[348],
	},
	{
		.from = &gn_RMAP_NODE_349_prev,
		.to = &gn_RMAP_NODE_349_next,
		.data = &ctkn_RMAP_NODE[349],
	},
	{
		.from = &gn_RMAP_NODE_350_prev,
		.to = &gn_RMAP_NODE_350_next,
		.data = &ctkn_RMAP_NODE[350],
	},
	{
		.from = &gn_RMAP_NODE_351_prev,
		.to = &gn_RMAP_NODE_351_next,
		.data = &ctkn_RMAP_NODE[351],
	},
	{
		.from = &gn_RMAP_NODE_352_prev,
		.to = &gn_RMAP_NODE_352_next,
		.data = &ctkn_RMAP_NODE[352],
	},
	{
		.from = &gn_RMAP_NODE_353_prev,
		.to = &gn_RMAP_NODE_353_next,
		.data = (void *)&no_rmap_call_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_354_prev,
		.to = &gn_RMAP_NODE_354_next,
		.data = &ctkn_RMAP_NODE[354],
	},
	{
		.from = &gn_RMAP_NODE_355_prev,
		.to = &gn_RMAP_NODE_355_next,
		.data = &ctkn_RMAP_NODE[355],
	},
	{
		.from = &gn_RMAP_NODE_356_prev,
		.to = &gn_RMAP_NODE_356_next,
		.data = &ctkn_RMAP_NODE[356],
	},
	{
		.from = &gn_RMAP_NODE_357_prev,
		.to = &gn_RMAP_NODE_357_next,
		.data = &ctkn_RMAP_NODE[357],
	},
	{
		.from = &gn_RMAP_NODE_358_prev,
		.to = &gn_RMAP_NODE_358_next,
		.data = &ctkn_RMAP_NODE[358],
	},
	{
		.from = &gn_RMAP_NODE_359_prev,
		.to = &gn_RMAP_NODE_359_next,
		.data = (void *)&no_rmap_continue_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_360_prev,
		.to = &gn_RMAP_NODE_360_next,
		.data = &ctkn_RMAP_NODE[360],
	},
	{
		.from = &gn_RMAP_NODE_361_prev,
		.to = &gn_RMAP_NODE_361_next,
		.data = &ctkn_RMAP_NODE[361],
	},
	{
		.from = &gn_RMAP_NODE_362_prev,
		.to = &gn_RMAP_NODE_362_next,
		.data = (void *)&no_rmap_description_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_363_prev,
		.to = &gn_RMAP_NODE_363_next,
		.data = &ctkn_RMAP_NODE[363],
	},
	{
		.from = &gn_RMAP_NODE_364_prev,
		.to = &gn_RMAP_NODE_364_next,
		.data = &ctkn_RMAP_NODE[364],
	},
	{
		.from = &gn_RMAP_NODE_365_prev,
		.to = &gn_RMAP_NODE_365_next,
		.data = &ctkn_RMAP_NODE[365],
	},
	{
		.from = &gn_RMAP_NODE_366_prev,
		.to = &gn_RMAP_NODE_366_next,
		.data = &ctkn_RMAP_NODE[366],
	},
	{
		.from = &gn_RMAP_NODE_367_prev,
		.to = &gn_RMAP_NODE_367_next,
		.data = &ctkn_RMAP_NODE[367],
	},
	{
		.from = &gn_RMAP_NODE_368_prev,
		.to = &gn_RMAP_NODE_368_next,
		.data = &ctkn_RMAP_NODE[368],
	},
	{
		.from = &gn_RMAP_NODE_369_prev,
		.to = &gn_RMAP_NODE_369_next,
		.data = (void *)&no_match_alias_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_370_prev,
		.to = &gn_RMAP_NODE_370_next,
		.data = &ctkn_RMAP_NODE[370],
	},
	{
		.from = &gn_RMAP_NODE_371_prev,
		.to = &gn_RMAP_NODE_371_next,
		.data = &ctkn_RMAP_NODE[371],
	},
	{
		.from = &gn_RMAP_NODE_372_prev,
		.to = &gn_RMAP_NODE_372_next,
		.data = &ctkn_RMAP_NODE[372],
	},
	{
		.from = &gn_RMAP_NODE_373_prev,
		.to = &gn_RMAP_NODE_373_next,
		.data = &ctkn_RMAP_NODE[373],
	},
	{
		.from = &gn_RMAP_NODE_374_prev,
		.to = &gn_RMAP_NODE_374_next,
		.data = &ctkn_RMAP_NODE[374],
	},
	{
		.from = &gn_RMAP_NODE_375_prev,
		.to = &gn_RMAP_NODE_375_next,
		.data = (void *)&no_match_aspath_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_376_prev,
		.to = &gn_RMAP_NODE_376_next,
		.data = &ctkn_RMAP_NODE[376],
	},
	{
		.from = &gn_RMAP_NODE_377_prev,
		.to = &gn_RMAP_NODE_377_next,
		.data = &ctkn_RMAP_NODE[377],
	},
	{
		.from = &gn_RMAP_NODE_378_prev,
		.to = &gn_RMAP_NODE_378_next,
		.data = &ctkn_RMAP_NODE[378],
	},
	{
		.from = &gn_RMAP_NODE_379_prev,
		.to = &gn_RMAP_NODE_379_next,
		.data = &ctkn_RMAP_NODE[379],
	},
	{
		.from = &gn_RMAP_NODE_380_prev,
		.to = &gn_RMAP_NODE_380_next,
		.data = &ctkn_RMAP_NODE[380],
	},
	{
		.from = &gn_RMAP_NODE_381_prev,
		.to = &gn_RMAP_NODE_381_next,
		.data = &ctkn_RMAP_NODE[381],
	},
	{
		.from = &gn_RMAP_NODE_382_prev,
		.to = &gn_RMAP_NODE_382_next,
		.data = &ctkn_RMAP_NODE[382],
	},
	{
		.from = &gn_RMAP_NODE_383_prev,
		.to = &gn_RMAP_NODE_383_next,
		.data = &ctkn_RMAP_NODE[383],
	},
	{
		.from = &gn_RMAP_NODE_384_prev,
		.to = &gn_RMAP_NODE_384_next,
		.data = &ctkn_RMAP_NODE[384],
	},
	{
		.from = &gn_RMAP_NODE_385_prev,
		.to = &gn_RMAP_NODE_385_next,
		.data = &ctkn_RMAP_NODE[385],
	},
	{
		.from = &gn_RMAP_NODE_386_prev,
		.to = &gn_RMAP_NODE_386_next,
		.data = &ctkn_RMAP_NODE[386],
	},
	{
		.from = &gn_RMAP_NODE_387_prev,
		.to = &gn_RMAP_NODE_387_next,
		.data = &ctkn_RMAP_NODE[387],
	},
	{
		.from = &gn_RMAP_NODE_388_prev,
		.to = &gn_RMAP_NODE_388_next,
		.data = (void *)&no_match_community_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_389_prev,
		.to = &gn_RMAP_NODE_389_next,
		.data = &ctkn_RMAP_NODE[389],
	},
	{
		.from = &gn_RMAP_NODE_390_prev,
		.to = &gn_RMAP_NODE_390_next,
		.data = &ctkn_RMAP_NODE[390],
	},
	{
		.from = &gn_RMAP_NODE_391_prev,
		.to = &gn_RMAP_NODE_391_next,
		.data = &ctkn_RMAP_NODE[391],
	},
	{
		.from = &gn_RMAP_NODE_392_prev,
		.to = &gn_RMAP_NODE_392_next,
		.data = &ctkn_RMAP_NODE[392],
	},
	{
		.from = &gn_RMAP_NODE_393_prev,
		.to = &gn_RMAP_NODE_393_next,
		.data = &ctkn_RMAP_NODE[393],
	},
	{
		.from = &gn_RMAP_NODE_394_prev,
		.to = &gn_RMAP_NODE_394_next,
		.data = &ctkn_RMAP_NODE[394],
	},
	{
		.from = &gn_RMAP_NODE_395_prev,
		.to = &gn_RMAP_NODE_395_next,
		.data = (void *)&no_match_evpn_default_route_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_396_prev,
		.to = &gn_RMAP_NODE_396_next,
		.data = &ctkn_RMAP_NODE[396],
	},
	{
		.from = &gn_RMAP_NODE_397_prev,
		.to = &gn_RMAP_NODE_397_next,
		.data = &ctkn_RMAP_NODE[397],
	},
	{
		.from = &gn_RMAP_NODE_398_prev,
		.to = &gn_RMAP_NODE_398_next,
		.data = &ctkn_RMAP_NODE[398],
	},
	{
		.from = &gn_RMAP_NODE_399_prev,
		.to = &gn_RMAP_NODE_399_next,
		.data = (void *)&no_match_evpn_rd_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_400_prev,
		.to = &gn_RMAP_NODE_400_next,
		.data = &ctkn_RMAP_NODE[400],
	},
	{
		.from = &gn_RMAP_NODE_401_prev,
		.to = &gn_RMAP_NODE_401_next,
		.data = &ctkn_RMAP_NODE[401],
	},
	{
		.from = &gn_RMAP_NODE_402_prev,
		.to = &gn_RMAP_NODE_402_next,
		.data = &ctkn_RMAP_NODE[402],
	},
	{
		.from = &gn_RMAP_NODE_403_prev,
		.to = &gn_RMAP_NODE_403_next,
		.data = &ctkn_RMAP_NODE[403],
	},
	{
		.from = &gn_RMAP_NODE_404_prev,
		.to = &gn_RMAP_NODE_404_next,
		.data = &ctkn_RMAP_NODE[404],
	},
	{
		.from = &gn_RMAP_NODE_405_prev,
		.to = &gn_RMAP_NODE_405_next,
		.data = (void *)&no_match_evpn_route_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_406_prev,
		.to = &gn_RMAP_NODE_406_next,
		.data = &ctkn_RMAP_NODE[406],
	},
	{
		.from = &gn_RMAP_NODE_407_prev,
		.to = &gn_RMAP_NODE_407_next,
		.data = &ctkn_RMAP_NODE[407],
	},
	{
		.from = &gn_RMAP_NODE_408_prev,
		.to = &gn_RMAP_NODE_408_next,
		.data = &ctkn_RMAP_NODE[408],
	},
	{
		.from = &gn_RMAP_NODE_409_prev,
		.to = &gn_RMAP_NODE_409_next,
		.data = &ctkn_RMAP_NODE[409],
	},
	{
		.from = &gn_RMAP_NODE_410_prev,
		.to = &gn_RMAP_NODE_410_next,
		.data = &ctkn_RMAP_NODE[410],
	},
	{
		.from = &gn_RMAP_NODE_411_prev,
		.to = &gn_RMAP_NODE_411_next,
		.data = &ctkn_RMAP_NODE[411],
	},
	{
		.from = &gn_RMAP_NODE_412_prev,
		.to = &gn_RMAP_NODE_412_next,
		.data = &ctkn_RMAP_NODE[412],
	},
	{
		.from = &gn_RMAP_NODE_413_prev,
		.to = &gn_RMAP_NODE_413_next,
		.data = &ctkn_RMAP_NODE[413],
	},
	{
		.from = &gn_RMAP_NODE_414_prev,
		.to = &gn_RMAP_NODE_414_next,
		.data = &ctkn_RMAP_NODE[414],
	},
	{
		.from = &gn_RMAP_NODE_415_prev,
		.to = &gn_RMAP_NODE_415_next,
		.data = &ctkn_RMAP_NODE[415],
	},
	{
		.from = &gn_RMAP_NODE_416_prev,
		.to = &gn_RMAP_NODE_416_next,
		.data = &ctkn_RMAP_NODE[416],
	},
	{
		.from = &gn_RMAP_NODE_417_prev,
		.to = &gn_RMAP_NODE_417_next,
		.data = &ctkn_RMAP_NODE[417],
	},
	{
		.from = &gn_RMAP_NODE_418_prev,
		.to = &gn_RMAP_NODE_418_next,
		.data = (void *)&no_match_evpn_vni_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_419_prev,
		.to = &gn_RMAP_NODE_419_next,
		.data = &ctkn_RMAP_NODE[419],
	},
	{
		.from = &gn_RMAP_NODE_420_prev,
		.to = &gn_RMAP_NODE_420_next,
		.data = &ctkn_RMAP_NODE[420],
	},
	{
		.from = &gn_RMAP_NODE_421_prev,
		.to = &gn_RMAP_NODE_421_next,
		.data = &ctkn_RMAP_NODE[421],
	},
	{
		.from = &gn_RMAP_NODE_422_prev,
		.to = &gn_RMAP_NODE_422_next,
		.data = &ctkn_RMAP_NODE[422],
	},
	{
		.from = &gn_RMAP_NODE_423_prev,
		.to = &gn_RMAP_NODE_423_next,
		.data = &ctkn_RMAP_NODE[423],
	},
	{
		.from = &gn_RMAP_NODE_424_prev,
		.to = &gn_RMAP_NODE_424_next,
		.data = &ctkn_RMAP_NODE[424],
	},
	{
		.from = &gn_RMAP_NODE_425_prev,
		.to = &gn_RMAP_NODE_425_next,
		.data = &ctkn_RMAP_NODE[425],
	},
	{
		.from = &gn_RMAP_NODE_426_prev,
		.to = &gn_RMAP_NODE_426_next,
		.data = &ctkn_RMAP_NODE[426],
	},
	{
		.from = &gn_RMAP_NODE_427_prev,
		.to = &gn_RMAP_NODE_427_next,
		.data = &ctkn_RMAP_NODE[427],
	},
	{
		.from = &gn_RMAP_NODE_428_prev,
		.to = &gn_RMAP_NODE_428_next,
		.data = &ctkn_RMAP_NODE[428],
	},
	{
		.from = &gn_RMAP_NODE_429_prev,
		.to = &gn_RMAP_NODE_429_next,
		.data = &ctkn_RMAP_NODE[429],
	},
	{
		.from = &gn_RMAP_NODE_430_prev,
		.to = &gn_RMAP_NODE_430_next,
		.data = &ctkn_RMAP_NODE[430],
	},
	{
		.from = &gn_RMAP_NODE_431_prev,
		.to = &gn_RMAP_NODE_431_next,
		.data = (void *)&no_match_ecommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_432_prev,
		.to = &gn_RMAP_NODE_432_next,
		.data = &ctkn_RMAP_NODE[432],
	},
	{
		.from = &gn_RMAP_NODE_433_prev,
		.to = &gn_RMAP_NODE_433_next,
		.data = &ctkn_RMAP_NODE[433],
	},
	{
		.from = &gn_RMAP_NODE_434_prev,
		.to = &gn_RMAP_NODE_434_next,
		.data = &ctkn_RMAP_NODE[434],
	},
	{
		.from = &gn_RMAP_NODE_435_prev,
		.to = &gn_RMAP_NODE_435_next,
		.data = &ctkn_RMAP_NODE[435],
	},
	{
		.from = &gn_RMAP_NODE_436_prev,
		.to = &gn_RMAP_NODE_436_next,
		.data = &ctkn_RMAP_NODE[436],
	},
	{
		.from = &gn_RMAP_NODE_437_prev,
		.to = &gn_RMAP_NODE_437_next,
		.data = &ctkn_RMAP_NODE[437],
	},
	{
		.from = &gn_RMAP_NODE_438_prev,
		.to = &gn_RMAP_NODE_438_next,
		.data = &ctkn_RMAP_NODE[438],
	},
	{
		.from = &gn_RMAP_NODE_439_prev,
		.to = &gn_RMAP_NODE_439_next,
		.data = &ctkn_RMAP_NODE[439],
	},
	{
		.from = &gn_RMAP_NODE_440_prev,
		.to = &gn_RMAP_NODE_440_next,
		.data = (void *)&no_match_interface_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_441_prev,
		.to = &gn_RMAP_NODE_441_next,
		.data = &ctkn_RMAP_NODE[441],
	},
	{
		.from = &gn_RMAP_NODE_442_prev,
		.to = &gn_RMAP_NODE_442_next,
		.data = &ctkn_RMAP_NODE[442],
	},
	{
		.from = &gn_RMAP_NODE_443_prev,
		.to = &gn_RMAP_NODE_443_next,
		.data = &ctkn_RMAP_NODE[443],
	},
	{
		.from = &gn_RMAP_NODE_444_prev,
		.to = &gn_RMAP_NODE_444_next,
		.data = &ctkn_RMAP_NODE[444],
	},
	{
		.from = &gn_RMAP_NODE_445_prev,
		.to = &gn_RMAP_NODE_445_next,
		.data = &ctkn_RMAP_NODE[445],
	},
	{
		.from = &gn_RMAP_NODE_446_prev,
		.to = &gn_RMAP_NODE_446_next,
		.data = (void *)&no_route_map_match_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_447_prev,
		.to = &gn_RMAP_NODE_447_next,
		.data = &ctkn_RMAP_NODE[447],
	},
	{
		.from = &gn_RMAP_NODE_448_prev,
		.to = &gn_RMAP_NODE_448_next,
		.data = &ctkn_RMAP_NODE[448],
	},
	{
		.from = &gn_RMAP_NODE_449_prev,
		.to = &gn_RMAP_NODE_449_next,
		.data = &ctkn_RMAP_NODE[449],
	},
	{
		.from = &gn_RMAP_NODE_450_prev,
		.to = &gn_RMAP_NODE_450_next,
		.data = (void *)&no_route_map_match_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_451_prev,
		.to = &gn_RMAP_NODE_451_next,
		.data = &ctkn_RMAP_NODE[451],
	},
	{
		.from = &gn_RMAP_NODE_452_prev,
		.to = &gn_RMAP_NODE_452_next,
		.data = &ctkn_RMAP_NODE[452],
	},
	{
		.from = &gn_RMAP_NODE_453_prev,
		.to = &gn_RMAP_NODE_453_next,
		.data = &ctkn_RMAP_NODE[453],
	},
	{
		.from = &gn_RMAP_NODE_454_prev,
		.to = &gn_RMAP_NODE_454_next,
		.data = &ctkn_RMAP_NODE[454],
	},
	{
		.from = &gn_RMAP_NODE_455_prev,
		.to = &gn_RMAP_NODE_455_next,
		.data = &ctkn_RMAP_NODE[455],
	},
	{
		.from = &gn_RMAP_NODE_456_prev,
		.to = &gn_RMAP_NODE_456_next,
		.data = (void *)&no_match_ip_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_457_prev,
		.to = &gn_RMAP_NODE_457_next,
		.data = &ctkn_RMAP_NODE[457],
	},
	{
		.from = &gn_RMAP_NODE_458_prev,
		.to = &gn_RMAP_NODE_458_next,
		.data = &ctkn_RMAP_NODE[458],
	},
	{
		.from = &gn_RMAP_NODE_459_prev,
		.to = &gn_RMAP_NODE_459_next,
		.data = &ctkn_RMAP_NODE[459],
	},
	{
		.from = &gn_RMAP_NODE_460_prev,
		.to = &gn_RMAP_NODE_460_next,
		.data = &ctkn_RMAP_NODE[460],
	},
	{
		.from = &gn_RMAP_NODE_461_prev,
		.to = &gn_RMAP_NODE_461_next,
		.data = &ctkn_RMAP_NODE[461],
	},
	{
		.from = &gn_RMAP_NODE_462_prev,
		.to = &gn_RMAP_NODE_462_next,
		.data = (void *)&no_match_ip_address_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_463_prev,
		.to = &gn_RMAP_NODE_463_next,
		.data = &ctkn_RMAP_NODE[463],
	},
	{
		.from = &gn_RMAP_NODE_464_prev,
		.to = &gn_RMAP_NODE_464_next,
		.data = &ctkn_RMAP_NODE[464],
	},
	{
		.from = &gn_RMAP_NODE_465_prev,
		.to = &gn_RMAP_NODE_465_next,
		.data = &ctkn_RMAP_NODE[465],
	},
	{
		.from = &gn_RMAP_NODE_466_prev,
		.to = &gn_RMAP_NODE_466_next,
		.data = &ctkn_RMAP_NODE[466],
	},
	{
		.from = &gn_RMAP_NODE_467_prev,
		.to = &gn_RMAP_NODE_467_next,
		.data = &ctkn_RMAP_NODE[467],
	},
	{
		.from = &gn_RMAP_NODE_468_prev,
		.to = &gn_RMAP_NODE_468_next,
		.data = (void *)&no_match_ip_address_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_469_prev,
		.to = &gn_RMAP_NODE_469_next,
		.data = &ctkn_RMAP_NODE[469],
	},
	{
		.from = &gn_RMAP_NODE_470_prev,
		.to = &gn_RMAP_NODE_470_next,
		.data = &ctkn_RMAP_NODE[470],
	},
	{
		.from = &gn_RMAP_NODE_471_prev,
		.to = &gn_RMAP_NODE_471_next,
		.data = &ctkn_RMAP_NODE[471],
	},
	{
		.from = &gn_RMAP_NODE_472_prev,
		.to = &gn_RMAP_NODE_472_next,
		.data = &ctkn_RMAP_NODE[472],
	},
	{
		.from = &gn_RMAP_NODE_473_prev,
		.to = &gn_RMAP_NODE_473_next,
		.data = &ctkn_RMAP_NODE[473],
	},
	{
		.from = &gn_RMAP_NODE_474_prev,
		.to = &gn_RMAP_NODE_474_next,
		.data = (void *)&no_match_ip_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_475_prev,
		.to = &gn_RMAP_NODE_475_next,
		.data = &ctkn_RMAP_NODE[475],
	},
	{
		.from = &gn_RMAP_NODE_476_prev,
		.to = &gn_RMAP_NODE_476_next,
		.data = &ctkn_RMAP_NODE[476],
	},
	{
		.from = &gn_RMAP_NODE_477_prev,
		.to = &gn_RMAP_NODE_477_next,
		.data = &ctkn_RMAP_NODE[477],
	},
	{
		.from = &gn_RMAP_NODE_478_prev,
		.to = &gn_RMAP_NODE_478_next,
		.data = &ctkn_RMAP_NODE[478],
	},
	{
		.from = &gn_RMAP_NODE_479_prev,
		.to = &gn_RMAP_NODE_479_next,
		.data = &ctkn_RMAP_NODE[479],
	},
	{
		.from = &gn_RMAP_NODE_480_prev,
		.to = &gn_RMAP_NODE_480_next,
		.data = (void *)&no_match_ipv4_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_481_prev,
		.to = &gn_RMAP_NODE_481_next,
		.data = &ctkn_RMAP_NODE[481],
	},
	{
		.from = &gn_RMAP_NODE_482_prev,
		.to = &gn_RMAP_NODE_482_next,
		.data = &ctkn_RMAP_NODE[482],
	},
	{
		.from = &gn_RMAP_NODE_483_prev,
		.to = &gn_RMAP_NODE_483_next,
		.data = &ctkn_RMAP_NODE[483],
	},
	{
		.from = &gn_RMAP_NODE_484_prev,
		.to = &gn_RMAP_NODE_484_next,
		.data = &ctkn_RMAP_NODE[484],
	},
	{
		.from = &gn_RMAP_NODE_485_prev,
		.to = &gn_RMAP_NODE_485_next,
		.data = &ctkn_RMAP_NODE[485],
	},
	{
		.from = &gn_RMAP_NODE_486_prev,
		.to = &gn_RMAP_NODE_486_next,
		.data = (void *)&no_match_ip_nexthop_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_487_prev,
		.to = &gn_RMAP_NODE_487_next,
		.data = &ctkn_RMAP_NODE[487],
	},
	{
		.from = &gn_RMAP_NODE_488_prev,
		.to = &gn_RMAP_NODE_488_next,
		.data = &ctkn_RMAP_NODE[488],
	},
	{
		.from = &gn_RMAP_NODE_489_prev,
		.to = &gn_RMAP_NODE_489_next,
		.data = &ctkn_RMAP_NODE[489],
	},
	{
		.from = &gn_RMAP_NODE_490_prev,
		.to = &gn_RMAP_NODE_490_next,
		.data = &ctkn_RMAP_NODE[490],
	},
	{
		.from = &gn_RMAP_NODE_491_prev,
		.to = &gn_RMAP_NODE_491_next,
		.data = &ctkn_RMAP_NODE[491],
	},
	{
		.from = &gn_RMAP_NODE_492_prev,
		.to = &gn_RMAP_NODE_492_next,
		.data = (void *)&no_match_ip_next_hop_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_493_prev,
		.to = &gn_RMAP_NODE_493_next,
		.data = &ctkn_RMAP_NODE[493],
	},
	{
		.from = &gn_RMAP_NODE_494_prev,
		.to = &gn_RMAP_NODE_494_next,
		.data = &ctkn_RMAP_NODE[494],
	},
	{
		.from = &gn_RMAP_NODE_495_prev,
		.to = &gn_RMAP_NODE_495_next,
		.data = &ctkn_RMAP_NODE[495],
	},
	{
		.from = &gn_RMAP_NODE_496_prev,
		.to = &gn_RMAP_NODE_496_next,
		.data = &ctkn_RMAP_NODE[496],
	},
	{
		.from = &gn_RMAP_NODE_497_prev,
		.to = &gn_RMAP_NODE_497_next,
		.data = &ctkn_RMAP_NODE[497],
	},
	{
		.from = &gn_RMAP_NODE_498_prev,
		.to = &gn_RMAP_NODE_498_next,
		.data = &ctkn_RMAP_NODE[498],
	},
	{
		.from = &gn_RMAP_NODE_499_prev,
		.to = &gn_RMAP_NODE_499_next,
		.data = &ctkn_RMAP_NODE[499],
	},
	{
		.from = &gn_RMAP_NODE_500_prev,
		.to = &gn_RMAP_NODE_500_next,
		.data = (void *)&no_match_ip_next_hop_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_501_prev,
		.to = &gn_RMAP_NODE_501_next,
		.data = &ctkn_RMAP_NODE[501],
	},
	{
		.from = &gn_RMAP_NODE_502_prev,
		.to = &gn_RMAP_NODE_502_next,
		.data = &ctkn_RMAP_NODE[502],
	},
	{
		.from = &gn_RMAP_NODE_503_prev,
		.to = &gn_RMAP_NODE_503_next,
		.data = &ctkn_RMAP_NODE[503],
	},
	{
		.from = &gn_RMAP_NODE_504_prev,
		.to = &gn_RMAP_NODE_504_next,
		.data = &ctkn_RMAP_NODE[504],
	},
	{
		.from = &gn_RMAP_NODE_505_prev,
		.to = &gn_RMAP_NODE_505_next,
		.data = &ctkn_RMAP_NODE[505],
	},
	{
		.from = &gn_RMAP_NODE_506_prev,
		.to = &gn_RMAP_NODE_506_next,
		.data = (void *)&no_match_ip_route_source_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_507_prev,
		.to = &gn_RMAP_NODE_507_next,
		.data = &ctkn_RMAP_NODE[507],
	},
	{
		.from = &gn_RMAP_NODE_508_prev,
		.to = &gn_RMAP_NODE_508_next,
		.data = &ctkn_RMAP_NODE[508],
	},
	{
		.from = &gn_RMAP_NODE_509_prev,
		.to = &gn_RMAP_NODE_509_next,
		.data = &ctkn_RMAP_NODE[509],
	},
	{
		.from = &gn_RMAP_NODE_510_prev,
		.to = &gn_RMAP_NODE_510_next,
		.data = &ctkn_RMAP_NODE[510],
	},
	{
		.from = &gn_RMAP_NODE_511_prev,
		.to = &gn_RMAP_NODE_511_next,
		.data = &ctkn_RMAP_NODE[511],
	},
	{
		.from = &gn_RMAP_NODE_512_prev,
		.to = &gn_RMAP_NODE_512_next,
		.data = (void *)&no_match_ip_route_source_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_513_prev,
		.to = &gn_RMAP_NODE_513_next,
		.data = &ctkn_RMAP_NODE[513],
	},
	{
		.from = &gn_RMAP_NODE_514_prev,
		.to = &gn_RMAP_NODE_514_next,
		.data = &ctkn_RMAP_NODE[514],
	},
	{
		.from = &gn_RMAP_NODE_515_prev,
		.to = &gn_RMAP_NODE_515_next,
		.data = &ctkn_RMAP_NODE[515],
	},
	{
		.from = &gn_RMAP_NODE_516_prev,
		.to = &gn_RMAP_NODE_516_next,
		.data = &ctkn_RMAP_NODE[516],
	},
	{
		.from = &gn_RMAP_NODE_517_prev,
		.to = &gn_RMAP_NODE_517_next,
		.data = &ctkn_RMAP_NODE[517],
	},
	{
		.from = &gn_RMAP_NODE_518_prev,
		.to = &gn_RMAP_NODE_518_next,
		.data = (void *)&no_route_map_match_address_v6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_519_prev,
		.to = &gn_RMAP_NODE_519_next,
		.data = &ctkn_RMAP_NODE[519],
	},
	{
		.from = &gn_RMAP_NODE_520_prev,
		.to = &gn_RMAP_NODE_520_next,
		.data = &ctkn_RMAP_NODE[520],
	},
	{
		.from = &gn_RMAP_NODE_521_prev,
		.to = &gn_RMAP_NODE_521_next,
		.data = &ctkn_RMAP_NODE[521],
	},
	{
		.from = &gn_RMAP_NODE_522_prev,
		.to = &gn_RMAP_NODE_522_next,
		.data = (void *)&no_route_map_match_prefix_list_v6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_523_prev,
		.to = &gn_RMAP_NODE_523_next,
		.data = &ctkn_RMAP_NODE[523],
	},
	{
		.from = &gn_RMAP_NODE_524_prev,
		.to = &gn_RMAP_NODE_524_next,
		.data = &ctkn_RMAP_NODE[524],
	},
	{
		.from = &gn_RMAP_NODE_525_prev,
		.to = &gn_RMAP_NODE_525_next,
		.data = &ctkn_RMAP_NODE[525],
	},
	{
		.from = &gn_RMAP_NODE_526_prev,
		.to = &gn_RMAP_NODE_526_next,
		.data = &ctkn_RMAP_NODE[526],
	},
	{
		.from = &gn_RMAP_NODE_527_prev,
		.to = &gn_RMAP_NODE_527_next,
		.data = &ctkn_RMAP_NODE[527],
	},
	{
		.from = &gn_RMAP_NODE_528_prev,
		.to = &gn_RMAP_NODE_528_next,
		.data = (void *)&no_match_ipv6_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_529_prev,
		.to = &gn_RMAP_NODE_529_next,
		.data = &ctkn_RMAP_NODE[529],
	},
	{
		.from = &gn_RMAP_NODE_530_prev,
		.to = &gn_RMAP_NODE_530_next,
		.data = &ctkn_RMAP_NODE[530],
	},
	{
		.from = &gn_RMAP_NODE_531_prev,
		.to = &gn_RMAP_NODE_531_next,
		.data = &ctkn_RMAP_NODE[531],
	},
	{
		.from = &gn_RMAP_NODE_532_prev,
		.to = &gn_RMAP_NODE_532_next,
		.data = &ctkn_RMAP_NODE[532],
	},
	{
		.from = &gn_RMAP_NODE_533_prev,
		.to = &gn_RMAP_NODE_533_next,
		.data = &ctkn_RMAP_NODE[533],
	},
	{
		.from = &gn_RMAP_NODE_534_prev,
		.to = &gn_RMAP_NODE_534_next,
		.data = (void *)&no_match_ipv6_address_prefix_len_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_535_prev,
		.to = &gn_RMAP_NODE_535_next,
		.data = &ctkn_RMAP_NODE[535],
	},
	{
		.from = &gn_RMAP_NODE_536_prev,
		.to = &gn_RMAP_NODE_536_next,
		.data = &ctkn_RMAP_NODE[536],
	},
	{
		.from = &gn_RMAP_NODE_537_prev,
		.to = &gn_RMAP_NODE_537_next,
		.data = &ctkn_RMAP_NODE[537],
	},
	{
		.from = &gn_RMAP_NODE_538_prev,
		.to = &gn_RMAP_NODE_538_next,
		.data = &ctkn_RMAP_NODE[538],
	},
	{
		.from = &gn_RMAP_NODE_539_prev,
		.to = &gn_RMAP_NODE_539_next,
		.data = &ctkn_RMAP_NODE[539],
	},
	{
		.from = &gn_RMAP_NODE_540_prev,
		.to = &gn_RMAP_NODE_540_next,
		.data = (void *)&no_match_ipv6_address_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_541_prev,
		.to = &gn_RMAP_NODE_541_next,
		.data = &ctkn_RMAP_NODE[541],
	},
	{
		.from = &gn_RMAP_NODE_542_prev,
		.to = &gn_RMAP_NODE_542_next,
		.data = &ctkn_RMAP_NODE[542],
	},
	{
		.from = &gn_RMAP_NODE_543_prev,
		.to = &gn_RMAP_NODE_543_next,
		.data = &ctkn_RMAP_NODE[543],
	},
	{
		.from = &gn_RMAP_NODE_544_prev,
		.to = &gn_RMAP_NODE_544_next,
		.data = (void *)&no_match_ipv6_next_hop_old_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_545_prev,
		.to = &gn_RMAP_NODE_545_next,
		.data = &ctkn_RMAP_NODE[545],
	},
	{
		.from = &gn_RMAP_NODE_546_prev,
		.to = &gn_RMAP_NODE_546_next,
		.data = &ctkn_RMAP_NODE[546],
	},
	{
		.from = &gn_RMAP_NODE_547_prev,
		.to = &gn_RMAP_NODE_547_next,
		.data = &ctkn_RMAP_NODE[547],
	},
	{
		.from = &gn_RMAP_NODE_548_prev,
		.to = &gn_RMAP_NODE_548_next,
		.data = &ctkn_RMAP_NODE[548],
	},
	{
		.from = &gn_RMAP_NODE_549_prev,
		.to = &gn_RMAP_NODE_549_next,
		.data = (void *)&no_match_ipv6_next_hop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_550_prev,
		.to = &gn_RMAP_NODE_550_next,
		.data = &ctkn_RMAP_NODE[550],
	},
	{
		.from = &gn_RMAP_NODE_551_prev,
		.to = &gn_RMAP_NODE_551_next,
		.data = &ctkn_RMAP_NODE[551],
	},
	{
		.from = &gn_RMAP_NODE_552_prev,
		.to = &gn_RMAP_NODE_552_next,
		.data = &ctkn_RMAP_NODE[552],
	},
	{
		.from = &gn_RMAP_NODE_553_prev,
		.to = &gn_RMAP_NODE_553_next,
		.data = (void *)&no_match_ipv6_next_hop_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_554_prev,
		.to = &gn_RMAP_NODE_554_next,
		.data = &ctkn_RMAP_NODE[554],
	},
	{
		.from = &gn_RMAP_NODE_555_prev,
		.to = &gn_RMAP_NODE_555_next,
		.data = &ctkn_RMAP_NODE[555],
	},
	{
		.from = &gn_RMAP_NODE_556_prev,
		.to = &gn_RMAP_NODE_556_next,
		.data = &ctkn_RMAP_NODE[556],
	},
	{
		.from = &gn_RMAP_NODE_557_prev,
		.to = &gn_RMAP_NODE_557_next,
		.data = &ctkn_RMAP_NODE[557],
	},
	{
		.from = &gn_RMAP_NODE_558_prev,
		.to = &gn_RMAP_NODE_558_next,
		.data = &ctkn_RMAP_NODE[558],
	},
	{
		.from = &gn_RMAP_NODE_559_prev,
		.to = &gn_RMAP_NODE_559_next,
		.data = (void *)&no_match_ipv6_next_hop_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_560_prev,
		.to = &gn_RMAP_NODE_560_next,
		.data = &ctkn_RMAP_NODE[560],
	},
	{
		.from = &gn_RMAP_NODE_561_prev,
		.to = &gn_RMAP_NODE_561_next,
		.data = &ctkn_RMAP_NODE[561],
	},
	{
		.from = &gn_RMAP_NODE_562_prev,
		.to = &gn_RMAP_NODE_562_next,
		.data = &ctkn_RMAP_NODE[562],
	},
	{
		.from = &gn_RMAP_NODE_563_prev,
		.to = &gn_RMAP_NODE_563_next,
		.data = &ctkn_RMAP_NODE[563],
	},
	{
		.from = &gn_RMAP_NODE_564_prev,
		.to = &gn_RMAP_NODE_564_next,
		.data = &ctkn_RMAP_NODE[564],
	},
	{
		.from = &gn_RMAP_NODE_565_prev,
		.to = &gn_RMAP_NODE_565_next,
		.data = &ctkn_RMAP_NODE[565],
	},
	{
		.from = &gn_RMAP_NODE_566_prev,
		.to = &gn_RMAP_NODE_566_next,
		.data = &ctkn_RMAP_NODE[566],
	},
	{
		.from = &gn_RMAP_NODE_567_prev,
		.to = &gn_RMAP_NODE_567_next,
		.data = (void *)&no_match_ipv6_next_hop_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_568_prev,
		.to = &gn_RMAP_NODE_568_next,
		.data = &ctkn_RMAP_NODE[568],
	},
	{
		.from = &gn_RMAP_NODE_569_prev,
		.to = &gn_RMAP_NODE_569_next,
		.data = &ctkn_RMAP_NODE[569],
	},
	{
		.from = &gn_RMAP_NODE_570_prev,
		.to = &gn_RMAP_NODE_570_next,
		.data = &ctkn_RMAP_NODE[570],
	},
	{
		.from = &gn_RMAP_NODE_571_prev,
		.to = &gn_RMAP_NODE_571_next,
		.data = &ctkn_RMAP_NODE[571],
	},
	{
		.from = &gn_RMAP_NODE_572_prev,
		.to = &gn_RMAP_NODE_572_next,
		.data = &ctkn_RMAP_NODE[572],
	},
	{
		.from = &gn_RMAP_NODE_573_prev,
		.to = &gn_RMAP_NODE_573_next,
		.data = &ctkn_RMAP_NODE[573],
	},
	{
		.from = &gn_RMAP_NODE_574_prev,
		.to = &gn_RMAP_NODE_574_next,
		.data = &ctkn_RMAP_NODE[574],
	},
	{
		.from = &gn_RMAP_NODE_575_prev,
		.to = &gn_RMAP_NODE_575_next,
		.data = &ctkn_RMAP_NODE[575],
	},
	{
		.from = &gn_RMAP_NODE_576_prev,
		.to = &gn_RMAP_NODE_576_next,
		.data = &ctkn_RMAP_NODE[576],
	},
	{
		.from = &gn_RMAP_NODE_577_prev,
		.to = &gn_RMAP_NODE_577_next,
		.data = &ctkn_RMAP_NODE[577],
	},
	{
		.from = &gn_RMAP_NODE_578_prev,
		.to = &gn_RMAP_NODE_578_next,
		.data = &ctkn_RMAP_NODE[578],
	},
	{
		.from = &gn_RMAP_NODE_579_prev,
		.to = &gn_RMAP_NODE_579_next,
		.data = &ctkn_RMAP_NODE[579],
	},
	{
		.from = &gn_RMAP_NODE_580_prev,
		.to = &gn_RMAP_NODE_580_next,
		.data = (void *)&no_match_lcommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_581_prev,
		.to = &gn_RMAP_NODE_581_next,
		.data = &ctkn_RMAP_NODE[581],
	},
	{
		.from = &gn_RMAP_NODE_582_prev,
		.to = &gn_RMAP_NODE_582_next,
		.data = &ctkn_RMAP_NODE[582],
	},
	{
		.from = &gn_RMAP_NODE_583_prev,
		.to = &gn_RMAP_NODE_583_next,
		.data = &ctkn_RMAP_NODE[583],
	},
	{
		.from = &gn_RMAP_NODE_584_prev,
		.to = &gn_RMAP_NODE_584_next,
		.data = &ctkn_RMAP_NODE[584],
	},
	{
		.from = &gn_RMAP_NODE_585_prev,
		.to = &gn_RMAP_NODE_585_next,
		.data = &ctkn_RMAP_NODE[585],
	},
	{
		.from = &gn_RMAP_NODE_586_prev,
		.to = &gn_RMAP_NODE_586_next,
		.data = &ctkn_RMAP_NODE[586],
	},
	{
		.from = &gn_RMAP_NODE_587_prev,
		.to = &gn_RMAP_NODE_587_next,
		.data = &ctkn_RMAP_NODE[587],
	},
	{
		.from = &gn_RMAP_NODE_588_prev,
		.to = &gn_RMAP_NODE_588_next,
		.data = &ctkn_RMAP_NODE[588],
	},
	{
		.from = &gn_RMAP_NODE_589_prev,
		.to = &gn_RMAP_NODE_589_next,
		.data = (void *)&no_match_local_pref_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_590_prev,
		.to = &gn_RMAP_NODE_590_next,
		.data = &ctkn_RMAP_NODE[590],
	},
	{
		.from = &gn_RMAP_NODE_591_prev,
		.to = &gn_RMAP_NODE_591_next,
		.data = &ctkn_RMAP_NODE[591],
	},
	{
		.from = &gn_RMAP_NODE_592_prev,
		.to = &gn_RMAP_NODE_592_next,
		.data = &ctkn_RMAP_NODE[592],
	},
	{
		.from = &gn_RMAP_NODE_593_prev,
		.to = &gn_RMAP_NODE_593_next,
		.data = &ctkn_RMAP_NODE[593],
	},
	{
		.from = &gn_RMAP_NODE_594_prev,
		.to = &gn_RMAP_NODE_594_next,
		.data = (void *)&no_match_mac_address_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_595_prev,
		.to = &gn_RMAP_NODE_595_next,
		.data = &ctkn_RMAP_NODE[595],
	},
	{
		.from = &gn_RMAP_NODE_596_prev,
		.to = &gn_RMAP_NODE_596_next,
		.data = &ctkn_RMAP_NODE[596],
	},
	{
		.from = &gn_RMAP_NODE_597_prev,
		.to = &gn_RMAP_NODE_597_next,
		.data = &ctkn_RMAP_NODE[597],
	},
	{
		.from = &gn_RMAP_NODE_598_prev,
		.to = &gn_RMAP_NODE_598_next,
		.data = &ctkn_RMAP_NODE[598],
	},
	{
		.from = &gn_RMAP_NODE_599_prev,
		.to = &gn_RMAP_NODE_599_next,
		.data = &ctkn_RMAP_NODE[599],
	},
	{
		.from = &gn_RMAP_NODE_600_prev,
		.to = &gn_RMAP_NODE_600_next,
		.data = (void *)&no_match_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_601_prev,
		.to = &gn_RMAP_NODE_601_next,
		.data = &ctkn_RMAP_NODE[601],
	},
	{
		.from = &gn_RMAP_NODE_602_prev,
		.to = &gn_RMAP_NODE_602_next,
		.data = &ctkn_RMAP_NODE[602],
	},
	{
		.from = &gn_RMAP_NODE_603_prev,
		.to = &gn_RMAP_NODE_603_next,
		.data = (void *)&no_route_map_match_interface_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_604_prev,
		.to = &gn_RMAP_NODE_604_next,
		.data = &ctkn_RMAP_NODE[604],
	},
	{
		.from = &gn_RMAP_NODE_605_prev,
		.to = &gn_RMAP_NODE_605_next,
		.data = &ctkn_RMAP_NODE[605],
	},
	{
		.from = &gn_RMAP_NODE_606_prev,
		.to = &gn_RMAP_NODE_606_next,
		.data = &ctkn_RMAP_NODE[606],
	},
	{
		.from = &gn_RMAP_NODE_607_prev,
		.to = &gn_RMAP_NODE_607_next,
		.data = &ctkn_RMAP_NODE[607],
	},
	{
		.from = &gn_RMAP_NODE_608_prev,
		.to = &gn_RMAP_NODE_608_next,
		.data = &ctkn_RMAP_NODE[608],
	},
	{
		.from = &gn_RMAP_NODE_609_prev,
		.to = &gn_RMAP_NODE_609_next,
		.data = &ctkn_RMAP_NODE[609],
	},
	{
		.from = &gn_RMAP_NODE_610_prev,
		.to = &gn_RMAP_NODE_610_next,
		.data = &ctkn_RMAP_NODE[610],
	},
	{
		.from = &gn_RMAP_NODE_611_prev,
		.to = &gn_RMAP_NODE_611_next,
		.data = (void *)&no_match_origin_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_612_prev,
		.to = &gn_RMAP_NODE_612_next,
		.data = &ctkn_RMAP_NODE[612],
	},
	{
		.from = &gn_RMAP_NODE_613_prev,
		.to = &gn_RMAP_NODE_613_next,
		.data = &ctkn_RMAP_NODE[613],
	},
	{
		.from = &gn_RMAP_NODE_614_prev,
		.to = &gn_RMAP_NODE_614_next,
		.data = &ctkn_RMAP_NODE[614],
	},
	{
		.from = &gn_RMAP_NODE_615_prev,
		.to = &gn_RMAP_NODE_615_next,
		.data = &ctkn_RMAP_NODE[615],
	},
	{
		.from = &gn_RMAP_NODE_616_prev,
		.to = &gn_RMAP_NODE_616_next,
		.data = &ctkn_RMAP_NODE[616],
	},
	{
		.from = &gn_RMAP_NODE_617_prev,
		.to = &gn_RMAP_NODE_617_next,
		.data = &ctkn_RMAP_NODE[617],
	},
	{
		.from = &gn_RMAP_NODE_618_prev,
		.to = &gn_RMAP_NODE_618_next,
		.data = &ctkn_RMAP_NODE[618],
	},
	{
		.from = &gn_RMAP_NODE_619_prev,
		.to = &gn_RMAP_NODE_619_next,
		.data = &ctkn_RMAP_NODE[619],
	},
	{
		.from = &gn_RMAP_NODE_620_prev,
		.to = &gn_RMAP_NODE_620_next,
		.data = &ctkn_RMAP_NODE[620],
	},
	{
		.from = &gn_RMAP_NODE_621_prev,
		.to = &gn_RMAP_NODE_621_next,
		.data = (void *)&no_match_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_622_prev,
		.to = &gn_RMAP_NODE_622_next,
		.data = &ctkn_RMAP_NODE[622],
	},
	{
		.from = &gn_RMAP_NODE_623_prev,
		.to = &gn_RMAP_NODE_623_next,
		.data = &ctkn_RMAP_NODE[623],
	},
	{
		.from = &gn_RMAP_NODE_624_prev,
		.to = &gn_RMAP_NODE_624_next,
		.data = &ctkn_RMAP_NODE[624],
	},
	{
		.from = &gn_RMAP_NODE_625_prev,
		.to = &gn_RMAP_NODE_625_next,
		.data = &ctkn_RMAP_NODE[625],
	},
	{
		.from = &gn_RMAP_NODE_626_prev,
		.to = &gn_RMAP_NODE_626_next,
		.data = &ctkn_RMAP_NODE[626],
	},
	{
		.from = &gn_RMAP_NODE_627_prev,
		.to = &gn_RMAP_NODE_627_next,
		.data = &ctkn_RMAP_NODE[627],
	},
	{
		.from = &gn_RMAP_NODE_628_prev,
		.to = &gn_RMAP_NODE_628_next,
		.data = &ctkn_RMAP_NODE[628],
	},
	{
		.from = &gn_RMAP_NODE_629_prev,
		.to = &gn_RMAP_NODE_629_next,
		.data = &ctkn_RMAP_NODE[629],
	},
	{
		.from = &gn_RMAP_NODE_630_prev,
		.to = &gn_RMAP_NODE_630_next,
		.data = (void *)&no_match_probability_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_631_prev,
		.to = &gn_RMAP_NODE_631_next,
		.data = &ctkn_RMAP_NODE[631],
	},
	{
		.from = &gn_RMAP_NODE_632_prev,
		.to = &gn_RMAP_NODE_632_next,
		.data = &ctkn_RMAP_NODE[632],
	},
	{
		.from = &gn_RMAP_NODE_633_prev,
		.to = &gn_RMAP_NODE_633_next,
		.data = &ctkn_RMAP_NODE[633],
	},
	{
		.from = &gn_RMAP_NODE_634_prev,
		.to = &gn_RMAP_NODE_634_next,
		.data = &ctkn_RMAP_NODE[634],
	},
	{
		.from = &gn_RMAP_NODE_635_prev,
		.to = &gn_RMAP_NODE_635_next,
		.data = &ctkn_RMAP_NODE[635],
	},
	{
		.from = &gn_RMAP_NODE_636_prev,
		.to = &gn_RMAP_NODE_636_next,
		.data = (void *)&no_match_rpki_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_637_prev,
		.to = &gn_RMAP_NODE_637_next,
		.data = &ctkn_RMAP_NODE[637],
	},
	{
		.from = &gn_RMAP_NODE_638_prev,
		.to = &gn_RMAP_NODE_638_next,
		.data = &ctkn_RMAP_NODE[638],
	},
	{
		.from = &gn_RMAP_NODE_639_prev,
		.to = &gn_RMAP_NODE_639_next,
		.data = &ctkn_RMAP_NODE[639],
	},
	{
		.from = &gn_RMAP_NODE_640_prev,
		.to = &gn_RMAP_NODE_640_next,
		.data = &ctkn_RMAP_NODE[640],
	},
	{
		.from = &gn_RMAP_NODE_641_prev,
		.to = &gn_RMAP_NODE_641_next,
		.data = &ctkn_RMAP_NODE[641],
	},
	{
		.from = &gn_RMAP_NODE_642_prev,
		.to = &gn_RMAP_NODE_642_next,
		.data = &ctkn_RMAP_NODE[642],
	},
	{
		.from = &gn_RMAP_NODE_643_prev,
		.to = &gn_RMAP_NODE_643_next,
		.data = &ctkn_RMAP_NODE[643],
	},
	{
		.from = &gn_RMAP_NODE_644_prev,
		.to = &gn_RMAP_NODE_644_next,
		.data = (void *)&no_match_source_instance_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_645_prev,
		.to = &gn_RMAP_NODE_645_next,
		.data = &ctkn_RMAP_NODE[645],
	},
	{
		.from = &gn_RMAP_NODE_646_prev,
		.to = &gn_RMAP_NODE_646_next,
		.data = &ctkn_RMAP_NODE[646],
	},
	{
		.from = &gn_RMAP_NODE_647_prev,
		.to = &gn_RMAP_NODE_647_next,
		.data = &ctkn_RMAP_NODE[647],
	},
	{
		.from = &gn_RMAP_NODE_648_prev,
		.to = &gn_RMAP_NODE_648_next,
		.data = &ctkn_RMAP_NODE[648],
	},
	{
		.from = &gn_RMAP_NODE_649_prev,
		.to = &gn_RMAP_NODE_649_next,
		.data = &ctkn_RMAP_NODE[649],
	},
	{
		.from = &gn_RMAP_NODE_650_prev,
		.to = &gn_RMAP_NODE_650_next,
		.data = &ctkn_RMAP_NODE[650],
	},
	{
		.from = &gn_RMAP_NODE_651_prev,
		.to = &gn_RMAP_NODE_651_next,
		.data = &ctkn_RMAP_NODE[651],
	},
	{
		.from = &gn_RMAP_NODE_652_prev,
		.to = &gn_RMAP_NODE_652_next,
		.data = (void *)&no_match_source_protocol_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_653_prev,
		.to = &gn_RMAP_NODE_653_next,
		.data = &ctkn_RMAP_NODE[653],
	},
	{
		.from = &gn_RMAP_NODE_654_prev,
		.to = &gn_RMAP_NODE_654_next,
		.data = &ctkn_RMAP_NODE[654],
	},
	{
		.from = &gn_RMAP_NODE_655_prev,
		.to = &gn_RMAP_NODE_655_next,
		.data = &ctkn_RMAP_NODE[655],
	},
	{
		.from = &gn_RMAP_NODE_656_prev,
		.to = &gn_RMAP_NODE_656_next,
		.data = &ctkn_RMAP_NODE[656],
	},
	{
		.from = &gn_RMAP_NODE_657_prev,
		.to = &gn_RMAP_NODE_657_next,
		.data = &ctkn_RMAP_NODE[657],
	},
	{
		.from = &gn_RMAP_NODE_658_prev,
		.to = &gn_RMAP_NODE_658_next,
		.data = &ctkn_RMAP_NODE[658],
	},
	{
		.from = &gn_RMAP_NODE_659_prev,
		.to = &gn_RMAP_NODE_659_next,
		.data = &ctkn_RMAP_NODE[659],
	},
	{
		.from = &gn_RMAP_NODE_660_prev,
		.to = &gn_RMAP_NODE_660_next,
		.data = &ctkn_RMAP_NODE[660],
	},
	{
		.from = &gn_RMAP_NODE_661_prev,
		.to = &gn_RMAP_NODE_661_next,
		.data = &ctkn_RMAP_NODE[661],
	},
	{
		.from = &gn_RMAP_NODE_662_prev,
		.to = &gn_RMAP_NODE_662_next,
		.data = &ctkn_RMAP_NODE[662],
	},
	{
		.from = &gn_RMAP_NODE_663_prev,
		.to = &gn_RMAP_NODE_663_next,
		.data = &ctkn_RMAP_NODE[663],
	},
	{
		.from = &gn_RMAP_NODE_664_prev,
		.to = &gn_RMAP_NODE_664_next,
		.data = &ctkn_RMAP_NODE[664],
	},
	{
		.from = &gn_RMAP_NODE_665_prev,
		.to = &gn_RMAP_NODE_665_next,
		.data = &ctkn_RMAP_NODE[665],
	},
	{
		.from = &gn_RMAP_NODE_666_prev,
		.to = &gn_RMAP_NODE_666_next,
		.data = &ctkn_RMAP_NODE[666],
	},
	{
		.from = &gn_RMAP_NODE_667_prev,
		.to = &gn_RMAP_NODE_667_next,
		.data = &ctkn_RMAP_NODE[667],
	},
	{
		.from = &gn_RMAP_NODE_668_prev,
		.to = &gn_RMAP_NODE_668_next,
		.data = &ctkn_RMAP_NODE[668],
	},
	{
		.from = &gn_RMAP_NODE_669_prev,
		.to = &gn_RMAP_NODE_669_next,
		.data = &ctkn_RMAP_NODE[669],
	},
	{
		.from = &gn_RMAP_NODE_670_prev,
		.to = &gn_RMAP_NODE_670_next,
		.data = (void *)&no_match_vrl_source_vrf_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_671_prev,
		.to = &gn_RMAP_NODE_671_next,
		.data = &ctkn_RMAP_NODE[671],
	},
	{
		.from = &gn_RMAP_NODE_672_prev,
		.to = &gn_RMAP_NODE_672_next,
		.data = &ctkn_RMAP_NODE[672],
	},
	{
		.from = &gn_RMAP_NODE_673_prev,
		.to = &gn_RMAP_NODE_673_next,
		.data = &ctkn_RMAP_NODE[673],
	},
	{
		.from = &gn_RMAP_NODE_674_prev,
		.to = &gn_RMAP_NODE_674_next,
		.data = &ctkn_RMAP_NODE[674],
	},
	{
		.from = &gn_RMAP_NODE_675_prev,
		.to = &gn_RMAP_NODE_675_next,
		.data = &ctkn_RMAP_NODE[675],
	},
	{
		.from = &gn_RMAP_NODE_676_prev,
		.to = &gn_RMAP_NODE_676_next,
		.data = &ctkn_RMAP_NODE[676],
	},
	{
		.from = &gn_RMAP_NODE_677_prev,
		.to = &gn_RMAP_NODE_677_next,
		.data = &ctkn_RMAP_NODE[677],
	},
	{
		.from = &gn_RMAP_NODE_678_prev,
		.to = &gn_RMAP_NODE_678_next,
		.data = (void *)&no_match_src_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_679_prev,
		.to = &gn_RMAP_NODE_679_next,
		.data = &ctkn_RMAP_NODE[679],
	},
	{
		.from = &gn_RMAP_NODE_680_prev,
		.to = &gn_RMAP_NODE_680_next,
		.data = &ctkn_RMAP_NODE[680],
	},
	{
		.from = &gn_RMAP_NODE_681_prev,
		.to = &gn_RMAP_NODE_681_next,
		.data = &ctkn_RMAP_NODE[681],
	},
	{
		.from = &gn_RMAP_NODE_682_prev,
		.to = &gn_RMAP_NODE_682_next,
		.data = &ctkn_RMAP_NODE[682],
	},
	{
		.from = &gn_RMAP_NODE_683_prev,
		.to = &gn_RMAP_NODE_683_next,
		.data = &ctkn_RMAP_NODE[683],
	},
	{
		.from = &gn_RMAP_NODE_684_prev,
		.to = &gn_RMAP_NODE_684_next,
		.data = &ctkn_RMAP_NODE[684],
	},
	{
		.from = &gn_RMAP_NODE_685_prev,
		.to = &gn_RMAP_NODE_685_next,
		.data = &ctkn_RMAP_NODE[685],
	},
	{
		.from = &gn_RMAP_NODE_686_prev,
		.to = &gn_RMAP_NODE_686_next,
		.data = &ctkn_RMAP_NODE[686],
	},
	{
		.from = &gn_RMAP_NODE_687_prev,
		.to = &gn_RMAP_NODE_687_next,
		.data = &ctkn_RMAP_NODE[687],
	},
	{
		.from = &gn_RMAP_NODE_688_prev,
		.to = &gn_RMAP_NODE_688_next,
		.data = (void *)&no_match_tag_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_689_prev,
		.to = &gn_RMAP_NODE_689_next,
		.data = &ctkn_RMAP_NODE[689],
	},
	{
		.from = &gn_RMAP_NODE_690_prev,
		.to = &gn_RMAP_NODE_690_next,
		.data = &ctkn_RMAP_NODE[690],
	},
	{
		.from = &gn_RMAP_NODE_691_prev,
		.to = &gn_RMAP_NODE_691_next,
		.data = &ctkn_RMAP_NODE[691],
	},
	{
		.from = &gn_RMAP_NODE_692_prev,
		.to = &gn_RMAP_NODE_692_next,
		.data = &ctkn_RMAP_NODE[692],
	},
	{
		.from = &gn_RMAP_NODE_693_prev,
		.to = &gn_RMAP_NODE_693_next,
		.data = &ctkn_RMAP_NODE[693],
	},
	{
		.from = &gn_RMAP_NODE_694_prev,
		.to = &gn_RMAP_NODE_694_next,
		.data = &ctkn_RMAP_NODE[694],
	},
	{
		.from = &gn_RMAP_NODE_695_prev,
		.to = &gn_RMAP_NODE_695_next,
		.data = &ctkn_RMAP_NODE[695],
	},
	{
		.from = &gn_RMAP_NODE_696_prev,
		.to = &gn_RMAP_NODE_696_next,
		.data = (void *)&no_rmap_onmatch_goto_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_697_prev,
		.to = &gn_RMAP_NODE_697_next,
		.data = &ctkn_RMAP_NODE[697],
	},
	{
		.from = &gn_RMAP_NODE_698_prev,
		.to = &gn_RMAP_NODE_698_next,
		.data = &ctkn_RMAP_NODE[698],
	},
	{
		.from = &gn_RMAP_NODE_699_prev,
		.to = &gn_RMAP_NODE_699_next,
		.data = (void *)&no_rmap_onmatch_next_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_700_prev,
		.to = &gn_RMAP_NODE_700_next,
		.data = &ctkn_RMAP_NODE[700],
	},
	{
		.from = &gn_RMAP_NODE_701_prev,
		.to = &gn_RMAP_NODE_701_next,
		.data = &ctkn_RMAP_NODE[701],
	},
	{
		.from = &gn_RMAP_NODE_702_prev,
		.to = &gn_RMAP_NODE_702_next,
		.data = &ctkn_RMAP_NODE[702],
	},
	{
		.from = &gn_RMAP_NODE_703_prev,
		.to = &gn_RMAP_NODE_703_next,
		.data = &ctkn_RMAP_NODE[703],
	},
	{
		.from = &gn_RMAP_NODE_704_prev,
		.to = &gn_RMAP_NODE_704_next,
		.data = &ctkn_RMAP_NODE[704],
	},
	{
		.from = &gn_RMAP_NODE_705_prev,
		.to = &gn_RMAP_NODE_705_next,
		.data = &ctkn_RMAP_NODE[705],
	},
	{
		.from = &gn_RMAP_NODE_706_prev,
		.to = &gn_RMAP_NODE_706_next,
		.data = &ctkn_RMAP_NODE[706],
	},
	{
		.from = &gn_RMAP_NODE_707_prev,
		.to = &gn_RMAP_NODE_707_next,
		.data = &ctkn_RMAP_NODE[707],
	},
	{
		.from = &gn_RMAP_NODE_708_prev,
		.to = &gn_RMAP_NODE_708_next,
		.data = &ctkn_RMAP_NODE[708],
	},
	{
		.from = &gn_RMAP_NODE_709_prev,
		.to = &gn_RMAP_NODE_709_next,
		.data = &ctkn_RMAP_NODE[709],
	},
	{
		.from = &gn_RMAP_NODE_710_prev,
		.to = &gn_RMAP_NODE_710_next,
		.data = &ctkn_RMAP_NODE[710],
	},
	{
		.from = &gn_RMAP_NODE_711_prev,
		.to = &gn_RMAP_NODE_711_next,
		.data = &ctkn_RMAP_NODE[711],
	},
	{
		.from = &gn_RMAP_NODE_712_prev,
		.to = &gn_RMAP_NODE_712_next,
		.data = (void *)&no_set_ipx_vpn_nexthop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_713_prev,
		.to = &gn_RMAP_NODE_713_next,
		.data = &ctkn_RMAP_NODE[713],
	},
	{
		.from = &gn_RMAP_NODE_714_prev,
		.to = &gn_RMAP_NODE_714_next,
		.data = &ctkn_RMAP_NODE[714],
	},
	{
		.from = &gn_RMAP_NODE_715_prev,
		.to = &gn_RMAP_NODE_715_next,
		.data = &ctkn_RMAP_NODE[715],
	},
	{
		.from = &gn_RMAP_NODE_716_prev,
		.to = &gn_RMAP_NODE_716_next,
		.data = &ctkn_RMAP_NODE[716],
	},
	{
		.from = &gn_RMAP_NODE_717_prev,
		.to = &gn_RMAP_NODE_717_next,
		.data = &ctkn_RMAP_NODE[717],
	},
	{
		.from = &gn_RMAP_NODE_718_prev,
		.to = &gn_RMAP_NODE_718_next,
		.data = &ctkn_RMAP_NODE[718],
	},
	{
		.from = &gn_RMAP_NODE_719_prev,
		.to = &gn_RMAP_NODE_719_next,
		.data = &ctkn_RMAP_NODE[719],
	},
	{
		.from = &gn_RMAP_NODE_720_prev,
		.to = &gn_RMAP_NODE_720_next,
		.data = &ctkn_RMAP_NODE[720],
	},
	{
		.from = &gn_RMAP_NODE_721_prev,
		.to = &gn_RMAP_NODE_721_next,
		.data = &ctkn_RMAP_NODE[721],
	},
	{
		.from = &gn_RMAP_NODE_722_prev,
		.to = &gn_RMAP_NODE_722_next,
		.data = (void *)&no_set_aggregator_as_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_723_prev,
		.to = &gn_RMAP_NODE_723_next,
		.data = &ctkn_RMAP_NODE[723],
	},
	{
		.from = &gn_RMAP_NODE_724_prev,
		.to = &gn_RMAP_NODE_724_next,
		.data = &ctkn_RMAP_NODE[724],
	},
	{
		.from = &gn_RMAP_NODE_725_prev,
		.to = &gn_RMAP_NODE_725_next,
		.data = &ctkn_RMAP_NODE[725],
	},
	{
		.from = &gn_RMAP_NODE_726_prev,
		.to = &gn_RMAP_NODE_726_next,
		.data = &ctkn_RMAP_NODE[726],
	},
	{
		.from = &gn_RMAP_NODE_727_prev,
		.to = &gn_RMAP_NODE_727_next,
		.data = &ctkn_RMAP_NODE[727],
	},
	{
		.from = &gn_RMAP_NODE_728_prev,
		.to = &gn_RMAP_NODE_728_next,
		.data = &ctkn_RMAP_NODE[728],
	},
	{
		.from = &gn_RMAP_NODE_729_prev,
		.to = &gn_RMAP_NODE_729_next,
		.data = &ctkn_RMAP_NODE[729],
	},
	{
		.from = &gn_RMAP_NODE_730_prev,
		.to = &gn_RMAP_NODE_730_next,
		.data = (void *)&no_set_aigp_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_731_prev,
		.to = &gn_RMAP_NODE_731_next,
		.data = &ctkn_RMAP_NODE[731],
	},
	{
		.from = &gn_RMAP_NODE_732_prev,
		.to = &gn_RMAP_NODE_732_next,
		.data = &ctkn_RMAP_NODE[732],
	},
	{
		.from = &gn_RMAP_NODE_733_prev,
		.to = &gn_RMAP_NODE_733_next,
		.data = &ctkn_RMAP_NODE[733],
	},
	{
		.from = &gn_RMAP_NODE_734_prev,
		.to = &gn_RMAP_NODE_734_next,
		.data = &ctkn_RMAP_NODE[734],
	},
	{
		.from = &gn_RMAP_NODE_735_prev,
		.to = &gn_RMAP_NODE_735_next,
		.data = (void *)&no_set_aspath_exclude_all_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_736_prev,
		.to = &gn_RMAP_NODE_736_next,
		.data = &ctkn_RMAP_NODE[736],
	},
	{
		.from = &gn_RMAP_NODE_737_prev,
		.to = &gn_RMAP_NODE_737_next,
		.data = &ctkn_RMAP_NODE[737],
	},
	{
		.from = &gn_RMAP_NODE_738_prev,
		.to = &gn_RMAP_NODE_738_next,
		.data = (void *)&no_set_aspath_exclude_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_739_prev,
		.to = &gn_RMAP_NODE_739_next,
		.data = &ctkn_RMAP_NODE[739],
	},
	{
		.from = &gn_RMAP_NODE_740_prev,
		.to = &gn_RMAP_NODE_740_next,
		.data = &ctkn_RMAP_NODE[740],
	},
	{
		.from = &gn_RMAP_NODE_741_prev,
		.to = &gn_RMAP_NODE_741_next,
		.data = &ctkn_RMAP_NODE[741],
	},
	{
		.from = &gn_RMAP_NODE_742_prev,
		.to = &gn_RMAP_NODE_742_next,
		.data = &ctkn_RMAP_NODE[742],
	},
	{
		.from = &gn_RMAP_NODE_743_prev,
		.to = &gn_RMAP_NODE_743_next,
		.data = &ctkn_RMAP_NODE[743],
	},
	{
		.from = &gn_RMAP_NODE_744_prev,
		.to = &gn_RMAP_NODE_744_next,
		.data = (void *)&no_set_aspath_exclude_access_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_745_prev,
		.to = &gn_RMAP_NODE_745_next,
		.data = &ctkn_RMAP_NODE[745],
	},
	{
		.from = &gn_RMAP_NODE_746_prev,
		.to = &gn_RMAP_NODE_746_next,
		.data = &ctkn_RMAP_NODE[746],
	},
	{
		.from = &gn_RMAP_NODE_747_prev,
		.to = &gn_RMAP_NODE_747_next,
		.data = &ctkn_RMAP_NODE[747],
	},
	{
		.from = &gn_RMAP_NODE_748_prev,
		.to = &gn_RMAP_NODE_748_next,
		.data = (void *)&no_set_aspath_prepend_as_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_749_prev,
		.to = &gn_RMAP_NODE_749_next,
		.data = &ctkn_RMAP_NODE[749],
	},
	{
		.from = &gn_RMAP_NODE_750_prev,
		.to = &gn_RMAP_NODE_750_next,
		.data = &ctkn_RMAP_NODE[750],
	},
	{
		.from = &gn_RMAP_NODE_751_prev,
		.to = &gn_RMAP_NODE_751_next,
		.data = &ctkn_RMAP_NODE[751],
	},
	{
		.from = &gn_RMAP_NODE_752_prev,
		.to = &gn_RMAP_NODE_752_next,
		.data = &ctkn_RMAP_NODE[752],
	},
	{
		.from = &gn_RMAP_NODE_753_prev,
		.to = &gn_RMAP_NODE_753_next,
		.data = &ctkn_RMAP_NODE[753],
	},
	{
		.from = &gn_RMAP_NODE_754_prev,
		.to = &gn_RMAP_NODE_754_next,
		.data = &ctkn_RMAP_NODE[754],
	},
	{
		.from = &gn_RMAP_NODE_755_prev,
		.to = &gn_RMAP_NODE_755_next,
		.data = &ctkn_RMAP_NODE[755],
	},
	{
		.from = &gn_RMAP_NODE_756_prev,
		.to = &gn_RMAP_NODE_756_next,
		.data = (void *)&no_set_aspath_prepend_last_as_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_757_prev,
		.to = &gn_RMAP_NODE_757_next,
		.data = &ctkn_RMAP_NODE[757],
	},
	{
		.from = &gn_RMAP_NODE_758_prev,
		.to = &gn_RMAP_NODE_758_next,
		.data = &ctkn_RMAP_NODE[758],
	},
	{
		.from = &gn_RMAP_NODE_759_prev,
		.to = &gn_RMAP_NODE_759_next,
		.data = &ctkn_RMAP_NODE[759],
	},
	{
		.from = &gn_RMAP_NODE_760_prev,
		.to = &gn_RMAP_NODE_760_next,
		.data = &ctkn_RMAP_NODE[760],
	},
	{
		.from = &gn_RMAP_NODE_761_prev,
		.to = &gn_RMAP_NODE_761_next,
		.data = &ctkn_RMAP_NODE[761],
	},
	{
		.from = &gn_RMAP_NODE_762_prev,
		.to = &gn_RMAP_NODE_762_next,
		.data = &ctkn_RMAP_NODE[762],
	},
	{
		.from = &gn_RMAP_NODE_763_prev,
		.to = &gn_RMAP_NODE_763_next,
		.data = &ctkn_RMAP_NODE[763],
	},
	{
		.from = &gn_RMAP_NODE_764_prev,
		.to = &gn_RMAP_NODE_764_next,
		.data = &ctkn_RMAP_NODE[764],
	},
	{
		.from = &gn_RMAP_NODE_765_prev,
		.to = &gn_RMAP_NODE_765_next,
		.data = &ctkn_RMAP_NODE[765],
	},
	{
		.from = &gn_RMAP_NODE_766_prev,
		.to = &gn_RMAP_NODE_766_next,
		.data = &ctkn_RMAP_NODE[766],
	},
	{
		.from = &gn_RMAP_NODE_767_prev,
		.to = &gn_RMAP_NODE_767_next,
		.data = &ctkn_RMAP_NODE[767],
	},
	{
		.from = &gn_RMAP_NODE_768_prev,
		.to = &gn_RMAP_NODE_768_next,
		.data = &ctkn_RMAP_NODE[768],
	},
	{
		.from = &gn_RMAP_NODE_769_prev,
		.to = &gn_RMAP_NODE_769_next,
		.data = (void *)&no_set_aspath_replace_asn_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_770_prev,
		.to = &gn_RMAP_NODE_770_next,
		.data = &ctkn_RMAP_NODE[770],
	},
	{
		.from = &gn_RMAP_NODE_771_prev,
		.to = &gn_RMAP_NODE_771_next,
		.data = &ctkn_RMAP_NODE[771],
	},
	{
		.from = &gn_RMAP_NODE_772_prev,
		.to = &gn_RMAP_NODE_772_next,
		.data = &ctkn_RMAP_NODE[772],
	},
	{
		.from = &gn_RMAP_NODE_773_prev,
		.to = &gn_RMAP_NODE_773_next,
		.data = &ctkn_RMAP_NODE[773],
	},
	{
		.from = &gn_RMAP_NODE_774_prev,
		.to = &gn_RMAP_NODE_774_next,
		.data = &ctkn_RMAP_NODE[774],
	},
	{
		.from = &gn_RMAP_NODE_775_prev,
		.to = &gn_RMAP_NODE_775_next,
		.data = &ctkn_RMAP_NODE[775],
	},
	{
		.from = &gn_RMAP_NODE_776_prev,
		.to = &gn_RMAP_NODE_776_next,
		.data = &ctkn_RMAP_NODE[776],
	},
	{
		.from = &gn_RMAP_NODE_777_prev,
		.to = &gn_RMAP_NODE_777_next,
		.data = &ctkn_RMAP_NODE[777],
	},
	{
		.from = &gn_RMAP_NODE_778_prev,
		.to = &gn_RMAP_NODE_778_next,
		.data = &ctkn_RMAP_NODE[778],
	},
	{
		.from = &gn_RMAP_NODE_779_prev,
		.to = &gn_RMAP_NODE_779_next,
		.data = &ctkn_RMAP_NODE[779],
	},
	{
		.from = &gn_RMAP_NODE_780_prev,
		.to = &gn_RMAP_NODE_780_next,
		.data = &ctkn_RMAP_NODE[780],
	},
	{
		.from = &gn_RMAP_NODE_781_prev,
		.to = &gn_RMAP_NODE_781_next,
		.data = (void *)&no_set_aspath_replace_access_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_782_prev,
		.to = &gn_RMAP_NODE_782_next,
		.data = &ctkn_RMAP_NODE[782],
	},
	{
		.from = &gn_RMAP_NODE_783_prev,
		.to = &gn_RMAP_NODE_783_next,
		.data = &ctkn_RMAP_NODE[783],
	},
	{
		.from = &gn_RMAP_NODE_784_prev,
		.to = &gn_RMAP_NODE_784_next,
		.data = (void *)&no_set_atomic_aggregate_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_785_prev,
		.to = &gn_RMAP_NODE_785_next,
		.data = &ctkn_RMAP_NODE[785],
	},
	{
		.from = &gn_RMAP_NODE_786_prev,
		.to = &gn_RMAP_NODE_786_next,
		.data = &ctkn_RMAP_NODE[786],
	},
	{
		.from = &gn_RMAP_NODE_787_prev,
		.to = &gn_RMAP_NODE_787_next,
		.data = &ctkn_RMAP_NODE[787],
	},
	{
		.from = &gn_RMAP_NODE_788_prev,
		.to = &gn_RMAP_NODE_788_next,
		.data = &ctkn_RMAP_NODE[788],
	},
	{
		.from = &gn_RMAP_NODE_789_prev,
		.to = &gn_RMAP_NODE_789_next,
		.data = &ctkn_RMAP_NODE[789],
	},
	{
		.from = &gn_RMAP_NODE_790_prev,
		.to = &gn_RMAP_NODE_790_next,
		.data = &ctkn_RMAP_NODE[790],
	},
	{
		.from = &gn_RMAP_NODE_791_prev,
		.to = &gn_RMAP_NODE_791_next,
		.data = &ctkn_RMAP_NODE[791],
	},
	{
		.from = &gn_RMAP_NODE_792_prev,
		.to = &gn_RMAP_NODE_792_next,
		.data = &ctkn_RMAP_NODE[792],
	},
	{
		.from = &gn_RMAP_NODE_793_prev,
		.to = &gn_RMAP_NODE_793_next,
		.data = (void *)&no_set_community_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_794_prev,
		.to = &gn_RMAP_NODE_794_next,
		.data = &ctkn_RMAP_NODE[794],
	},
	{
		.from = &gn_RMAP_NODE_795_prev,
		.to = &gn_RMAP_NODE_795_next,
		.data = &ctkn_RMAP_NODE[795],
	},
	{
		.from = &gn_RMAP_NODE_796_prev,
		.to = &gn_RMAP_NODE_796_next,
		.data = &ctkn_RMAP_NODE[796],
	},
	{
		.from = &gn_RMAP_NODE_797_prev,
		.to = &gn_RMAP_NODE_797_next,
		.data = &ctkn_RMAP_NODE[797],
	},
	{
		.from = &gn_RMAP_NODE_798_prev,
		.to = &gn_RMAP_NODE_798_next,
		.data = (void *)&no_set_community_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_799_prev,
		.to = &gn_RMAP_NODE_799_next,
		.data = &ctkn_RMAP_NODE[799],
	},
	{
		.from = &gn_RMAP_NODE_800_prev,
		.to = &gn_RMAP_NODE_800_next,
		.data = &ctkn_RMAP_NODE[800],
	},
	{
		.from = &gn_RMAP_NODE_801_prev,
		.to = &gn_RMAP_NODE_801_next,
		.data = (void *)&no_set_community_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_802_prev,
		.to = &gn_RMAP_NODE_802_next,
		.data = &ctkn_RMAP_NODE[802],
	},
	{
		.from = &gn_RMAP_NODE_803_prev,
		.to = &gn_RMAP_NODE_803_next,
		.data = &ctkn_RMAP_NODE[803],
	},
	{
		.from = &gn_RMAP_NODE_804_prev,
		.to = &gn_RMAP_NODE_804_next,
		.data = &ctkn_RMAP_NODE[804],
	},
	{
		.from = &gn_RMAP_NODE_805_prev,
		.to = &gn_RMAP_NODE_805_next,
		.data = &ctkn_RMAP_NODE[805],
	},
	{
		.from = &gn_RMAP_NODE_806_prev,
		.to = &gn_RMAP_NODE_806_next,
		.data = &ctkn_RMAP_NODE[806],
	},
	{
		.from = &gn_RMAP_NODE_807_prev,
		.to = &gn_RMAP_NODE_807_next,
		.data = (void *)&no_set_distance_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_808_prev,
		.to = &gn_RMAP_NODE_808_next,
		.data = &ctkn_RMAP_NODE[808],
	},
	{
		.from = &gn_RMAP_NODE_809_prev,
		.to = &gn_RMAP_NODE_809_next,
		.data = &ctkn_RMAP_NODE[809],
	},
	{
		.from = &gn_RMAP_NODE_810_prev,
		.to = &gn_RMAP_NODE_810_next,
		.data = &ctkn_RMAP_NODE[810],
	},
	{
		.from = &gn_RMAP_NODE_811_prev,
		.to = &gn_RMAP_NODE_811_next,
		.data = &ctkn_RMAP_NODE[811],
	},
	{
		.from = &gn_RMAP_NODE_812_prev,
		.to = &gn_RMAP_NODE_812_next,
		.data = &ctkn_RMAP_NODE[812],
	},
	{
		.from = &gn_RMAP_NODE_813_prev,
		.to = &gn_RMAP_NODE_813_next,
		.data = (void *)&no_set_evpn_gw_ip_ipv4_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_814_prev,
		.to = &gn_RMAP_NODE_814_next,
		.data = &ctkn_RMAP_NODE[814],
	},
	{
		.from = &gn_RMAP_NODE_815_prev,
		.to = &gn_RMAP_NODE_815_next,
		.data = &ctkn_RMAP_NODE[815],
	},
	{
		.from = &gn_RMAP_NODE_816_prev,
		.to = &gn_RMAP_NODE_816_next,
		.data = &ctkn_RMAP_NODE[816],
	},
	{
		.from = &gn_RMAP_NODE_817_prev,
		.to = &gn_RMAP_NODE_817_next,
		.data = (void *)&no_set_evpn_gw_ip_ipv6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_818_prev,
		.to = &gn_RMAP_NODE_818_next,
		.data = &ctkn_RMAP_NODE[818],
	},
	{
		.from = &gn_RMAP_NODE_819_prev,
		.to = &gn_RMAP_NODE_819_next,
		.data = &ctkn_RMAP_NODE[819],
	},
	{
		.from = &gn_RMAP_NODE_820_prev,
		.to = &gn_RMAP_NODE_820_next,
		.data = &ctkn_RMAP_NODE[820],
	},
	{
		.from = &gn_RMAP_NODE_821_prev,
		.to = &gn_RMAP_NODE_821_next,
		.data = (void *)&no_set_ecommunity_lb_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_822_prev,
		.to = &gn_RMAP_NODE_822_next,
		.data = &ctkn_RMAP_NODE[822],
	},
	{
		.from = &gn_RMAP_NODE_823_prev,
		.to = &gn_RMAP_NODE_823_next,
		.data = &ctkn_RMAP_NODE[823],
	},
	{
		.from = &gn_RMAP_NODE_824_prev,
		.to = &gn_RMAP_NODE_824_next,
		.data = &ctkn_RMAP_NODE[824],
	},
	{
		.from = &gn_RMAP_NODE_825_prev,
		.to = &gn_RMAP_NODE_825_next,
		.data = &ctkn_RMAP_NODE[825],
	},
	{
		.from = &gn_RMAP_NODE_826_prev,
		.to = &gn_RMAP_NODE_826_next,
		.data = &ctkn_RMAP_NODE[826],
	},
	{
		.from = &gn_RMAP_NODE_827_prev,
		.to = &gn_RMAP_NODE_827_next,
		.data = &ctkn_RMAP_NODE[827],
	},
	{
		.from = &gn_RMAP_NODE_828_prev,
		.to = &gn_RMAP_NODE_828_next,
		.data = &ctkn_RMAP_NODE[828],
	},
	{
		.from = &gn_RMAP_NODE_829_prev,
		.to = &gn_RMAP_NODE_829_next,
		.data = (void *)&no_set_ecommunity_lb_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_830_prev,
		.to = &gn_RMAP_NODE_830_next,
		.data = &ctkn_RMAP_NODE[830],
	},
	{
		.from = &gn_RMAP_NODE_831_prev,
		.to = &gn_RMAP_NODE_831_next,
		.data = &ctkn_RMAP_NODE[831],
	},
	{
		.from = &gn_RMAP_NODE_832_prev,
		.to = &gn_RMAP_NODE_832_next,
		.data = &ctkn_RMAP_NODE[832],
	},
	{
		.from = &gn_RMAP_NODE_833_prev,
		.to = &gn_RMAP_NODE_833_next,
		.data = &ctkn_RMAP_NODE[833],
	},
	{
		.from = &gn_RMAP_NODE_834_prev,
		.to = &gn_RMAP_NODE_834_next,
		.data = (void *)&no_set_ecommunity_color_all_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_835_prev,
		.to = &gn_RMAP_NODE_835_next,
		.data = &ctkn_RMAP_NODE[835],
	},
	{
		.from = &gn_RMAP_NODE_836_prev,
		.to = &gn_RMAP_NODE_836_next,
		.data = &ctkn_RMAP_NODE[836],
	},
	{
		.from = &gn_RMAP_NODE_837_prev,
		.to = &gn_RMAP_NODE_837_next,
		.data = (void *)&no_set_ecommunity_color_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_838_prev,
		.to = &gn_RMAP_NODE_838_next,
		.data = &ctkn_RMAP_NODE[838],
	},
	{
		.from = &gn_RMAP_NODE_839_prev,
		.to = &gn_RMAP_NODE_839_next,
		.data = &ctkn_RMAP_NODE[839],
	},
	{
		.from = &gn_RMAP_NODE_840_prev,
		.to = &gn_RMAP_NODE_840_next,
		.data = (void *)&no_set_ecommunity_none_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_841_prev,
		.to = &gn_RMAP_NODE_841_next,
		.data = &ctkn_RMAP_NODE[841],
	},
	{
		.from = &gn_RMAP_NODE_842_prev,
		.to = &gn_RMAP_NODE_842_next,
		.data = &ctkn_RMAP_NODE[842],
	},
	{
		.from = &gn_RMAP_NODE_843_prev,
		.to = &gn_RMAP_NODE_843_next,
		.data = (void *)&no_set_ecommunity_nt_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_844_prev,
		.to = &gn_RMAP_NODE_844_next,
		.data = &ctkn_RMAP_NODE[844],
	},
	{
		.from = &gn_RMAP_NODE_845_prev,
		.to = &gn_RMAP_NODE_845_next,
		.data = &ctkn_RMAP_NODE[845],
	},
	{
		.from = &gn_RMAP_NODE_846_prev,
		.to = &gn_RMAP_NODE_846_next,
		.data = (void *)&no_set_ecommunity_nt_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_847_prev,
		.to = &gn_RMAP_NODE_847_next,
		.data = &ctkn_RMAP_NODE[847],
	},
	{
		.from = &gn_RMAP_NODE_848_prev,
		.to = &gn_RMAP_NODE_848_next,
		.data = &ctkn_RMAP_NODE[848],
	},
	{
		.from = &gn_RMAP_NODE_849_prev,
		.to = &gn_RMAP_NODE_849_next,
		.data = (void *)&no_set_ecommunity_rt_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_850_prev,
		.to = &gn_RMAP_NODE_850_next,
		.data = &ctkn_RMAP_NODE[850],
	},
	{
		.from = &gn_RMAP_NODE_851_prev,
		.to = &gn_RMAP_NODE_851_next,
		.data = &ctkn_RMAP_NODE[851],
	},
	{
		.from = &gn_RMAP_NODE_852_prev,
		.to = &gn_RMAP_NODE_852_next,
		.data = (void *)&no_set_ecommunity_rt_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_853_prev,
		.to = &gn_RMAP_NODE_853_next,
		.data = &ctkn_RMAP_NODE[853],
	},
	{
		.from = &gn_RMAP_NODE_854_prev,
		.to = &gn_RMAP_NODE_854_next,
		.data = &ctkn_RMAP_NODE[854],
	},
	{
		.from = &gn_RMAP_NODE_855_prev,
		.to = &gn_RMAP_NODE_855_next,
		.data = (void *)&no_set_ecommunity_soo_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_856_prev,
		.to = &gn_RMAP_NODE_856_next,
		.data = &ctkn_RMAP_NODE[856],
	},
	{
		.from = &gn_RMAP_NODE_857_prev,
		.to = &gn_RMAP_NODE_857_next,
		.data = &ctkn_RMAP_NODE[857],
	},
	{
		.from = &gn_RMAP_NODE_858_prev,
		.to = &gn_RMAP_NODE_858_next,
		.data = (void *)&no_set_ecommunity_soo_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_859_prev,
		.to = &gn_RMAP_NODE_859_next,
		.data = &ctkn_RMAP_NODE[859],
	},
	{
		.from = &gn_RMAP_NODE_860_prev,
		.to = &gn_RMAP_NODE_860_next,
		.data = &ctkn_RMAP_NODE[860],
	},
	{
		.from = &gn_RMAP_NODE_861_prev,
		.to = &gn_RMAP_NODE_861_next,
		.data = &ctkn_RMAP_NODE[861],
	},
	{
		.from = &gn_RMAP_NODE_862_prev,
		.to = &gn_RMAP_NODE_862_next,
		.data = &ctkn_RMAP_NODE[862],
	},
	{
		.from = &gn_RMAP_NODE_863_prev,
		.to = &gn_RMAP_NODE_863_next,
		.data = &ctkn_RMAP_NODE[863],
	},
	{
		.from = &gn_RMAP_NODE_864_prev,
		.to = &gn_RMAP_NODE_864_next,
		.data = &ctkn_RMAP_NODE[864],
	},
	{
		.from = &gn_RMAP_NODE_865_prev,
		.to = &gn_RMAP_NODE_865_next,
		.data = &ctkn_RMAP_NODE[865],
	},
	{
		.from = &gn_RMAP_NODE_866_prev,
		.to = &gn_RMAP_NODE_866_next,
		.data = &ctkn_RMAP_NODE[866],
	},
	{
		.from = &gn_RMAP_NODE_867_prev,
		.to = &gn_RMAP_NODE_867_next,
		.data = (void *)&no_set_ecommunity_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_868_prev,
		.to = &gn_RMAP_NODE_868_next,
		.data = &ctkn_RMAP_NODE[868],
	},
	{
		.from = &gn_RMAP_NODE_869_prev,
		.to = &gn_RMAP_NODE_869_next,
		.data = &ctkn_RMAP_NODE[869],
	},
	{
		.from = &gn_RMAP_NODE_870_prev,
		.to = &gn_RMAP_NODE_870_next,
		.data = &ctkn_RMAP_NODE[870],
	},
	{
		.from = &gn_RMAP_NODE_871_prev,
		.to = &gn_RMAP_NODE_871_next,
		.data = &ctkn_RMAP_NODE[871],
	},
	{
		.from = &gn_RMAP_NODE_872_prev,
		.to = &gn_RMAP_NODE_872_next,
		.data = &ctkn_RMAP_NODE[872],
	},
	{
		.from = &gn_RMAP_NODE_873_prev,
		.to = &gn_RMAP_NODE_873_next,
		.data = &ctkn_RMAP_NODE[873],
	},
	{
		.from = &gn_RMAP_NODE_874_prev,
		.to = &gn_RMAP_NODE_874_next,
		.data = &ctkn_RMAP_NODE[874],
	},
	{
		.from = &gn_RMAP_NODE_875_prev,
		.to = &gn_RMAP_NODE_875_next,
		.data = (void *)&ospf6_routemap_no_set_forwarding_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_876_prev,
		.to = &gn_RMAP_NODE_876_next,
		.data = &ctkn_RMAP_NODE[876],
	},
	{
		.from = &gn_RMAP_NODE_877_prev,
		.to = &gn_RMAP_NODE_877_next,
		.data = &ctkn_RMAP_NODE[877],
	},
	{
		.from = &gn_RMAP_NODE_878_prev,
		.to = &gn_RMAP_NODE_878_next,
		.data = &ctkn_RMAP_NODE[878],
	},
	{
		.from = &gn_RMAP_NODE_879_prev,
		.to = &gn_RMAP_NODE_879_next,
		.data = &ctkn_RMAP_NODE[879],
	},
	{
		.from = &gn_RMAP_NODE_880_prev,
		.to = &gn_RMAP_NODE_880_next,
		.data = &ctkn_RMAP_NODE[880],
	},
	{
		.from = &gn_RMAP_NODE_881_prev,
		.to = &gn_RMAP_NODE_881_next,
		.data = &ctkn_RMAP_NODE[881],
	},
	{
		.from = &gn_RMAP_NODE_882_prev,
		.to = &gn_RMAP_NODE_882_next,
		.data = (void *)&no_set_ip_nexthop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_883_prev,
		.to = &gn_RMAP_NODE_883_next,
		.data = &ctkn_RMAP_NODE[883],
	},
	{
		.from = &gn_RMAP_NODE_884_prev,
		.to = &gn_RMAP_NODE_884_next,
		.data = &ctkn_RMAP_NODE[884],
	},
	{
		.from = &gn_RMAP_NODE_885_prev,
		.to = &gn_RMAP_NODE_885_next,
		.data = &ctkn_RMAP_NODE[885],
	},
	{
		.from = &gn_RMAP_NODE_886_prev,
		.to = &gn_RMAP_NODE_886_next,
		.data = &ctkn_RMAP_NODE[886],
	},
	{
		.from = &gn_RMAP_NODE_887_prev,
		.to = &gn_RMAP_NODE_887_next,
		.data = &ctkn_RMAP_NODE[887],
	},
	{
		.from = &gn_RMAP_NODE_888_prev,
		.to = &gn_RMAP_NODE_888_next,
		.data = (void *)&no_set_ipv6_nexthop_global_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_889_prev,
		.to = &gn_RMAP_NODE_889_next,
		.data = &ctkn_RMAP_NODE[889],
	},
	{
		.from = &gn_RMAP_NODE_890_prev,
		.to = &gn_RMAP_NODE_890_next,
		.data = &ctkn_RMAP_NODE[890],
	},
	{
		.from = &gn_RMAP_NODE_891_prev,
		.to = &gn_RMAP_NODE_891_next,
		.data = &ctkn_RMAP_NODE[891],
	},
	{
		.from = &gn_RMAP_NODE_892_prev,
		.to = &gn_RMAP_NODE_892_next,
		.data = &ctkn_RMAP_NODE[892],
	},
	{
		.from = &gn_RMAP_NODE_893_prev,
		.to = &gn_RMAP_NODE_893_next,
		.data = &ctkn_RMAP_NODE[893],
	},
	{
		.from = &gn_RMAP_NODE_894_prev,
		.to = &gn_RMAP_NODE_894_next,
		.data = (void *)&no_set_ipv6_nexthop_local_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_895_prev,
		.to = &gn_RMAP_NODE_895_next,
		.data = &ctkn_RMAP_NODE[895],
	},
	{
		.from = &gn_RMAP_NODE_896_prev,
		.to = &gn_RMAP_NODE_896_next,
		.data = &ctkn_RMAP_NODE[896],
	},
	{
		.from = &gn_RMAP_NODE_897_prev,
		.to = &gn_RMAP_NODE_897_next,
		.data = (void *)&no_set_ipv6_nexthop_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_898_prev,
		.to = &gn_RMAP_NODE_898_next,
		.data = &ctkn_RMAP_NODE[898],
	},
	{
		.from = &gn_RMAP_NODE_899_prev,
		.to = &gn_RMAP_NODE_899_next,
		.data = &ctkn_RMAP_NODE[899],
	},
	{
		.from = &gn_RMAP_NODE_900_prev,
		.to = &gn_RMAP_NODE_900_next,
		.data = (void *)&no_set_ipv6_nexthop_prefer_global_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_901_prev,
		.to = &gn_RMAP_NODE_901_next,
		.data = &ctkn_RMAP_NODE[901],
	},
	{
		.from = &gn_RMAP_NODE_902_prev,
		.to = &gn_RMAP_NODE_902_next,
		.data = &ctkn_RMAP_NODE[902],
	},
	{
		.from = &gn_RMAP_NODE_903_prev,
		.to = &gn_RMAP_NODE_903_next,
		.data = &ctkn_RMAP_NODE[903],
	},
	{
		.from = &gn_RMAP_NODE_904_prev,
		.to = &gn_RMAP_NODE_904_next,
		.data = &ctkn_RMAP_NODE[904],
	},
	{
		.from = &gn_RMAP_NODE_905_prev,
		.to = &gn_RMAP_NODE_905_next,
		.data = &ctkn_RMAP_NODE[905],
	},
	{
		.from = &gn_RMAP_NODE_906_prev,
		.to = &gn_RMAP_NODE_906_next,
		.data = (void *)&no_set_label_index_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_907_prev,
		.to = &gn_RMAP_NODE_907_next,
		.data = &ctkn_RMAP_NODE[907],
	},
	{
		.from = &gn_RMAP_NODE_908_prev,
		.to = &gn_RMAP_NODE_908_next,
		.data = &ctkn_RMAP_NODE[908],
	},
	{
		.from = &gn_RMAP_NODE_909_prev,
		.to = &gn_RMAP_NODE_909_next,
		.data = (void *)&no_set_lcommunity_delete_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_910_prev,
		.to = &gn_RMAP_NODE_910_next,
		.data = &ctkn_RMAP_NODE[910],
	},
	{
		.from = &gn_RMAP_NODE_911_prev,
		.to = &gn_RMAP_NODE_911_next,
		.data = &ctkn_RMAP_NODE[911],
	},
	{
		.from = &gn_RMAP_NODE_912_prev,
		.to = &gn_RMAP_NODE_912_next,
		.data = &ctkn_RMAP_NODE[912],
	},
	{
		.from = &gn_RMAP_NODE_913_prev,
		.to = &gn_RMAP_NODE_913_next,
		.data = &ctkn_RMAP_NODE[913],
	},
	{
		.from = &gn_RMAP_NODE_914_prev,
		.to = &gn_RMAP_NODE_914_next,
		.data = &ctkn_RMAP_NODE[914],
	},
	{
		.from = &gn_RMAP_NODE_915_prev,
		.to = &gn_RMAP_NODE_915_next,
		.data = &ctkn_RMAP_NODE[915],
	},
	{
		.from = &gn_RMAP_NODE_916_prev,
		.to = &gn_RMAP_NODE_916_next,
		.data = &ctkn_RMAP_NODE[916],
	},
	{
		.from = &gn_RMAP_NODE_917_prev,
		.to = &gn_RMAP_NODE_917_next,
		.data = (void *)&no_set_lcommunity_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_918_prev,
		.to = &gn_RMAP_NODE_918_next,
		.data = &ctkn_RMAP_NODE[918],
	},
	{
		.from = &gn_RMAP_NODE_919_prev,
		.to = &gn_RMAP_NODE_919_next,
		.data = &ctkn_RMAP_NODE[919],
	},
	{
		.from = &gn_RMAP_NODE_920_prev,
		.to = &gn_RMAP_NODE_920_next,
		.data = &ctkn_RMAP_NODE[920],
	},
	{
		.from = &gn_RMAP_NODE_921_prev,
		.to = &gn_RMAP_NODE_921_next,
		.data = &ctkn_RMAP_NODE[921],
	},
	{
		.from = &gn_RMAP_NODE_922_prev,
		.to = &gn_RMAP_NODE_922_next,
		.data = (void *)&no_set_lcommunity1_short_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_923_prev,
		.to = &gn_RMAP_NODE_923_next,
		.data = &ctkn_RMAP_NODE[923],
	},
	{
		.from = &gn_RMAP_NODE_924_prev,
		.to = &gn_RMAP_NODE_924_next,
		.data = &ctkn_RMAP_NODE[924],
	},
	{
		.from = &gn_RMAP_NODE_925_prev,
		.to = &gn_RMAP_NODE_925_next,
		.data = (void *)&no_set_lcommunity1_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_926_prev,
		.to = &gn_RMAP_NODE_926_next,
		.data = &ctkn_RMAP_NODE[926],
	},
	{
		.from = &gn_RMAP_NODE_927_prev,
		.to = &gn_RMAP_NODE_927_next,
		.data = &ctkn_RMAP_NODE[927],
	},
	{
		.from = &gn_RMAP_NODE_928_prev,
		.to = &gn_RMAP_NODE_928_next,
		.data = (void *)&no_set_lcommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_929_prev,
		.to = &gn_RMAP_NODE_929_next,
		.data = &ctkn_RMAP_NODE[929],
	},
	{
		.from = &gn_RMAP_NODE_930_prev,
		.to = &gn_RMAP_NODE_930_next,
		.data = &ctkn_RMAP_NODE[930],
	},
	{
		.from = &gn_RMAP_NODE_931_prev,
		.to = &gn_RMAP_NODE_931_next,
		.data = &ctkn_RMAP_NODE[931],
	},
	{
		.from = &gn_RMAP_NODE_932_prev,
		.to = &gn_RMAP_NODE_932_next,
		.data = &ctkn_RMAP_NODE[932],
	},
	{
		.from = &gn_RMAP_NODE_933_prev,
		.to = &gn_RMAP_NODE_933_next,
		.data = &ctkn_RMAP_NODE[933],
	},
	{
		.from = &gn_RMAP_NODE_934_prev,
		.to = &gn_RMAP_NODE_934_next,
		.data = (void *)&no_set_local_pref_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_935_prev,
		.to = &gn_RMAP_NODE_935_next,
		.data = &ctkn_RMAP_NODE[935],
	},
	{
		.from = &gn_RMAP_NODE_936_prev,
		.to = &gn_RMAP_NODE_936_next,
		.data = &ctkn_RMAP_NODE[936],
	},
	{
		.from = &gn_RMAP_NODE_937_prev,
		.to = &gn_RMAP_NODE_937_next,
		.data = &ctkn_RMAP_NODE[937],
	},
	{
		.from = &gn_RMAP_NODE_938_prev,
		.to = &gn_RMAP_NODE_938_next,
		.data = &ctkn_RMAP_NODE[938],
	},
	{
		.from = &gn_RMAP_NODE_939_prev,
		.to = &gn_RMAP_NODE_939_next,
		.data = &ctkn_RMAP_NODE[939],
	},
	{
		.from = &gn_RMAP_NODE_940_prev,
		.to = &gn_RMAP_NODE_940_next,
		.data = (void *)&no_set_max_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_941_prev,
		.to = &gn_RMAP_NODE_941_next,
		.data = &ctkn_RMAP_NODE[941],
	},
	{
		.from = &gn_RMAP_NODE_942_prev,
		.to = &gn_RMAP_NODE_942_next,
		.data = &ctkn_RMAP_NODE[942],
	},
	{
		.from = &gn_RMAP_NODE_943_prev,
		.to = &gn_RMAP_NODE_943_next,
		.data = &ctkn_RMAP_NODE[943],
	},
	{
		.from = &gn_RMAP_NODE_944_prev,
		.to = &gn_RMAP_NODE_944_next,
		.data = &ctkn_RMAP_NODE[944],
	},
	{
		.from = &gn_RMAP_NODE_945_prev,
		.to = &gn_RMAP_NODE_945_next,
		.data = &ctkn_RMAP_NODE[945],
	},
	{
		.from = &gn_RMAP_NODE_946_prev,
		.to = &gn_RMAP_NODE_946_next,
		.data = (void *)&no_set_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_947_prev,
		.to = &gn_RMAP_NODE_947_next,
		.data = &ctkn_RMAP_NODE[947],
	},
	{
		.from = &gn_RMAP_NODE_948_prev,
		.to = &gn_RMAP_NODE_948_next,
		.data = &ctkn_RMAP_NODE[948],
	},
	{
		.from = &gn_RMAP_NODE_949_prev,
		.to = &gn_RMAP_NODE_949_next,
		.data = &ctkn_RMAP_NODE[949],
	},
	{
		.from = &gn_RMAP_NODE_950_prev,
		.to = &gn_RMAP_NODE_950_next,
		.data = &ctkn_RMAP_NODE[950],
	},
	{
		.from = &gn_RMAP_NODE_951_prev,
		.to = &gn_RMAP_NODE_951_next,
		.data = &ctkn_RMAP_NODE[951],
	},
	{
		.from = &gn_RMAP_NODE_952_prev,
		.to = &gn_RMAP_NODE_952_next,
		.data = &ctkn_RMAP_NODE[952],
	},
	{
		.from = &gn_RMAP_NODE_953_prev,
		.to = &gn_RMAP_NODE_953_next,
		.data = &ctkn_RMAP_NODE[953],
	},
	{
		.from = &gn_RMAP_NODE_954_prev,
		.to = &gn_RMAP_NODE_954_next,
		.data = (void *)&no_set_metric_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_955_prev,
		.to = &gn_RMAP_NODE_955_next,
		.data = &ctkn_RMAP_NODE[955],
	},
	{
		.from = &gn_RMAP_NODE_956_prev,
		.to = &gn_RMAP_NODE_956_next,
		.data = &ctkn_RMAP_NODE[956],
	},
	{
		.from = &gn_RMAP_NODE_957_prev,
		.to = &gn_RMAP_NODE_957_next,
		.data = &ctkn_RMAP_NODE[957],
	},
	{
		.from = &gn_RMAP_NODE_958_prev,
		.to = &gn_RMAP_NODE_958_next,
		.data = &ctkn_RMAP_NODE[958],
	},
	{
		.from = &gn_RMAP_NODE_959_prev,
		.to = &gn_RMAP_NODE_959_next,
		.data = &ctkn_RMAP_NODE[959],
	},
	{
		.from = &gn_RMAP_NODE_960_prev,
		.to = &gn_RMAP_NODE_960_next,
		.data = &ctkn_RMAP_NODE[960],
	},
	{
		.from = &gn_RMAP_NODE_961_prev,
		.to = &gn_RMAP_NODE_961_next,
		.data = (void *)&no_set_min_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_962_prev,
		.to = &gn_RMAP_NODE_962_next,
		.data = &ctkn_RMAP_NODE[962],
	},
	{
		.from = &gn_RMAP_NODE_963_prev,
		.to = &gn_RMAP_NODE_963_next,
		.data = &ctkn_RMAP_NODE[963],
	},
	{
		.from = &gn_RMAP_NODE_964_prev,
		.to = &gn_RMAP_NODE_964_next,
		.data = &ctkn_RMAP_NODE[964],
	},
	{
		.from = &gn_RMAP_NODE_965_prev,
		.to = &gn_RMAP_NODE_965_next,
		.data = &ctkn_RMAP_NODE[965],
	},
	{
		.from = &gn_RMAP_NODE_966_prev,
		.to = &gn_RMAP_NODE_966_next,
		.data = &ctkn_RMAP_NODE[966],
	},
	{
		.from = &gn_RMAP_NODE_967_prev,
		.to = &gn_RMAP_NODE_967_next,
		.data = &ctkn_RMAP_NODE[967],
	},
	{
		.from = &gn_RMAP_NODE_968_prev,
		.to = &gn_RMAP_NODE_968_next,
		.data = &ctkn_RMAP_NODE[968],
	},
	{
		.from = &gn_RMAP_NODE_969_prev,
		.to = &gn_RMAP_NODE_969_next,
		.data = (void *)&no_set_origin_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_970_prev,
		.to = &gn_RMAP_NODE_970_next,
		.data = &ctkn_RMAP_NODE[970],
	},
	{
		.from = &gn_RMAP_NODE_971_prev,
		.to = &gn_RMAP_NODE_971_next,
		.data = &ctkn_RMAP_NODE[971],
	},
	{
		.from = &gn_RMAP_NODE_972_prev,
		.to = &gn_RMAP_NODE_972_next,
		.data = &ctkn_RMAP_NODE[972],
	},
	{
		.from = &gn_RMAP_NODE_973_prev,
		.to = &gn_RMAP_NODE_973_next,
		.data = &ctkn_RMAP_NODE[973],
	},
	{
		.from = &gn_RMAP_NODE_974_prev,
		.to = &gn_RMAP_NODE_974_next,
		.data = &ctkn_RMAP_NODE[974],
	},
	{
		.from = &gn_RMAP_NODE_975_prev,
		.to = &gn_RMAP_NODE_975_next,
		.data = &ctkn_RMAP_NODE[975],
	},
	{
		.from = &gn_RMAP_NODE_976_prev,
		.to = &gn_RMAP_NODE_976_next,
		.data = &ctkn_RMAP_NODE[976],
	},
	{
		.from = &gn_RMAP_NODE_977_prev,
		.to = &gn_RMAP_NODE_977_next,
		.data = (void *)&no_set_originator_id_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_978_prev,
		.to = &gn_RMAP_NODE_978_next,
		.data = &ctkn_RMAP_NODE[978],
	},
	{
		.from = &gn_RMAP_NODE_979_prev,
		.to = &gn_RMAP_NODE_979_next,
		.data = &ctkn_RMAP_NODE[979],
	},
	{
		.from = &gn_RMAP_NODE_980_prev,
		.to = &gn_RMAP_NODE_980_next,
		.data = &ctkn_RMAP_NODE[980],
	},
	{
		.from = &gn_RMAP_NODE_981_prev,
		.to = &gn_RMAP_NODE_981_next,
		.data = &ctkn_RMAP_NODE[981],
	},
	{
		.from = &gn_RMAP_NODE_982_prev,
		.to = &gn_RMAP_NODE_982_next,
		.data = &ctkn_RMAP_NODE[982],
	},
	{
		.from = &gn_RMAP_NODE_983_prev,
		.to = &gn_RMAP_NODE_983_next,
		.data = &ctkn_RMAP_NODE[983],
	},
	{
		.from = &gn_RMAP_NODE_984_prev,
		.to = &gn_RMAP_NODE_984_next,
		.data = (void *)&no_set_srte_color_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_985_prev,
		.to = &gn_RMAP_NODE_985_next,
		.data = &ctkn_RMAP_NODE[985],
	},
	{
		.from = &gn_RMAP_NODE_986_prev,
		.to = &gn_RMAP_NODE_986_next,
		.data = &ctkn_RMAP_NODE[986],
	},
	{
		.from = &gn_RMAP_NODE_987_prev,
		.to = &gn_RMAP_NODE_987_next,
		.data = &ctkn_RMAP_NODE[987],
	},
	{
		.from = &gn_RMAP_NODE_988_prev,
		.to = &gn_RMAP_NODE_988_next,
		.data = &ctkn_RMAP_NODE[988],
	},
	{
		.from = &gn_RMAP_NODE_989_prev,
		.to = &gn_RMAP_NODE_989_next,
		.data = &ctkn_RMAP_NODE[989],
	},
	{
		.from = &gn_RMAP_NODE_990_prev,
		.to = &gn_RMAP_NODE_990_next,
		.data = &ctkn_RMAP_NODE[990],
	},
	{
		.from = &gn_RMAP_NODE_991_prev,
		.to = &gn_RMAP_NODE_991_next,
		.data = &ctkn_RMAP_NODE[991],
	},
	{
		.from = &gn_RMAP_NODE_992_prev,
		.to = &gn_RMAP_NODE_992_next,
		.data = (void *)&no_set_src_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_993_prev,
		.to = &gn_RMAP_NODE_993_next,
		.data = &ctkn_RMAP_NODE[993],
	},
	{
		.from = &gn_RMAP_NODE_994_prev,
		.to = &gn_RMAP_NODE_994_next,
		.data = &ctkn_RMAP_NODE[994],
	},
	{
		.from = &gn_RMAP_NODE_995_prev,
		.to = &gn_RMAP_NODE_995_next,
		.data = &ctkn_RMAP_NODE[995],
	},
	{
		.from = &gn_RMAP_NODE_996_prev,
		.to = &gn_RMAP_NODE_996_next,
		.data = &ctkn_RMAP_NODE[996],
	},
	{
		.from = &gn_RMAP_NODE_997_prev,
		.to = &gn_RMAP_NODE_997_next,
		.data = &ctkn_RMAP_NODE[997],
	},
	{
		.from = &gn_RMAP_NODE_998_prev,
		.to = &gn_RMAP_NODE_998_next,
		.data = &ctkn_RMAP_NODE[998],
	},
	{
		.from = &gn_RMAP_NODE_999_prev,
		.to = &gn_RMAP_NODE_999_next,
		.data = (void *)&no_set_table_id_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1000_prev,
		.to = &gn_RMAP_NODE_1000_next,
		.data = &ctkn_RMAP_NODE[1000],
	},
	{
		.from = &gn_RMAP_NODE_1001_prev,
		.to = &gn_RMAP_NODE_1001_next,
		.data = &ctkn_RMAP_NODE[1001],
	},
	{
		.from = &gn_RMAP_NODE_1002_prev,
		.to = &gn_RMAP_NODE_1002_next,
		.data = &ctkn_RMAP_NODE[1002],
	},
	{
		.from = &gn_RMAP_NODE_1003_prev,
		.to = &gn_RMAP_NODE_1003_next,
		.data = &ctkn_RMAP_NODE[1003],
	},
	{
		.from = &gn_RMAP_NODE_1004_prev,
		.to = &gn_RMAP_NODE_1004_next,
		.data = &ctkn_RMAP_NODE[1004],
	},
	{
		.from = &gn_RMAP_NODE_1005_prev,
		.to = &gn_RMAP_NODE_1005_next,
		.data = &ctkn_RMAP_NODE[1005],
	},
	{
		.from = &gn_RMAP_NODE_1006_prev,
		.to = &gn_RMAP_NODE_1006_next,
		.data = &ctkn_RMAP_NODE[1006],
	},
	{
		.from = &gn_RMAP_NODE_1007_prev,
		.to = &gn_RMAP_NODE_1007_next,
		.data = (void *)&no_set_tag_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1008_prev,
		.to = &gn_RMAP_NODE_1008_next,
		.data = &ctkn_RMAP_NODE[1008],
	},
	{
		.from = &gn_RMAP_NODE_1009_prev,
		.to = &gn_RMAP_NODE_1009_next,
		.data = &ctkn_RMAP_NODE[1009],
	},
	{
		.from = &gn_RMAP_NODE_1010_prev,
		.to = &gn_RMAP_NODE_1010_next,
		.data = &ctkn_RMAP_NODE[1010],
	},
	{
		.from = &gn_RMAP_NODE_1011_prev,
		.to = &gn_RMAP_NODE_1011_next,
		.data = &ctkn_RMAP_NODE[1011],
	},
	{
		.from = &gn_RMAP_NODE_1012_prev,
		.to = &gn_RMAP_NODE_1012_next,
		.data = &ctkn_RMAP_NODE[1012],
	},
	{
		.from = &gn_RMAP_NODE_1013_prev,
		.to = &gn_RMAP_NODE_1013_next,
		.data = &ctkn_RMAP_NODE[1013],
	},
	{
		.from = &gn_RMAP_NODE_1014_prev,
		.to = &gn_RMAP_NODE_1014_next,
		.data = (void *)&no_set_weight_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1015_prev,
		.to = &gn_RMAP_NODE_1015_next,
		.data = &ctkn_RMAP_NODE[1015],
	},
	{
		.from = &gn_RMAP_NODE_1016_prev,
		.to = &gn_RMAP_NODE_1016_next,
		.data = &ctkn_RMAP_NODE[1016],
	},
	{
		.from = &gn_RMAP_NODE_1017_prev,
		.to = &gn_RMAP_NODE_1017_next,
		.data = &ctkn_RMAP_NODE[1017],
	},
	{
		.from = &gn_RMAP_NODE_1018_prev,
		.to = &gn_RMAP_NODE_1018_next,
		.data = &ctkn_RMAP_NODE[1018],
	},
	{
		.from = &gn_RMAP_NODE_1019_prev,
		.to = &gn_RMAP_NODE_1019_next,
		.data = (void *)&rmap_onmatch_goto_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1020_prev,
		.to = &gn_RMAP_NODE_1020_next,
		.data = &ctkn_RMAP_NODE[1020],
	},
	{
		.from = &gn_RMAP_NODE_1021_prev,
		.to = &gn_RMAP_NODE_1021_next,
		.data = &ctkn_RMAP_NODE[1021],
	},
	{
		.from = &gn_RMAP_NODE_1022_prev,
		.to = &gn_RMAP_NODE_1022_next,
		.data = (void *)&rmap_onmatch_next_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1023_prev,
		.to = &gn_RMAP_NODE_1023_next,
		.data = &ctkn_RMAP_NODE[1023],
	},
	{
		.from = &gn_RMAP_NODE_1024_prev,
		.to = &gn_RMAP_NODE_1024_next,
		.data = &ctkn_RMAP_NODE[1024],
	},
	{
		.from = &gn_RMAP_NODE_1025_prev,
		.to = &gn_RMAP_NODE_1025_next,
		.data = &ctkn_RMAP_NODE[1025],
	},
	{
		.from = &gn_RMAP_NODE_1026_prev,
		.to = &gn_RMAP_NODE_1026_next,
		.data = &ctkn_RMAP_NODE[1026],
	},
	{
		.from = &gn_RMAP_NODE_1027_prev,
		.to = &gn_RMAP_NODE_1027_next,
		.data = &ctkn_RMAP_NODE[1027],
	},
	{
		.from = &gn_RMAP_NODE_1028_prev,
		.to = &gn_RMAP_NODE_1028_next,
		.data = &ctkn_RMAP_NODE[1028],
	},
	{
		.from = &gn_RMAP_NODE_1029_prev,
		.to = &gn_RMAP_NODE_1029_next,
		.data = &ctkn_RMAP_NODE[1029],
	},
	{
		.from = &gn_RMAP_NODE_1030_prev,
		.to = &gn_RMAP_NODE_1030_next,
		.data = &ctkn_RMAP_NODE[1030],
	},
	{
		.from = &gn_RMAP_NODE_1031_prev,
		.to = &gn_RMAP_NODE_1031_next,
		.data = &ctkn_RMAP_NODE[1031],
	},
	{
		.from = &gn_RMAP_NODE_1032_prev,
		.to = &gn_RMAP_NODE_1032_next,
		.data = &ctkn_RMAP_NODE[1032],
	},
	{
		.from = &gn_RMAP_NODE_1033_prev,
		.to = &gn_RMAP_NODE_1033_next,
		.data = (void *)&set_ipx_vpn_nexthop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1034_prev,
		.to = &gn_RMAP_NODE_1034_next,
		.data = &ctkn_RMAP_NODE[1034],
	},
	{
		.from = &gn_RMAP_NODE_1035_prev,
		.to = &gn_RMAP_NODE_1035_next,
		.data = &ctkn_RMAP_NODE[1035],
	},
	{
		.from = &gn_RMAP_NODE_1036_prev,
		.to = &gn_RMAP_NODE_1036_next,
		.data = &ctkn_RMAP_NODE[1036],
	},
	{
		.from = &gn_RMAP_NODE_1037_prev,
		.to = &gn_RMAP_NODE_1037_next,
		.data = &ctkn_RMAP_NODE[1037],
	},
	{
		.from = &gn_RMAP_NODE_1038_prev,
		.to = &gn_RMAP_NODE_1038_next,
		.data = &ctkn_RMAP_NODE[1038],
	},
	{
		.from = &gn_RMAP_NODE_1039_prev,
		.to = &gn_RMAP_NODE_1039_next,
		.data = &ctkn_RMAP_NODE[1039],
	},
	{
		.from = &gn_RMAP_NODE_1040_prev,
		.to = &gn_RMAP_NODE_1040_next,
		.data = &ctkn_RMAP_NODE[1040],
	},
	{
		.from = &gn_RMAP_NODE_1041_prev,
		.to = &gn_RMAP_NODE_1041_next,
		.data = (void *)&set_aggregator_as_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1042_prev,
		.to = &gn_RMAP_NODE_1042_next,
		.data = &ctkn_RMAP_NODE[1042],
	},
	{
		.from = &gn_RMAP_NODE_1043_prev,
		.to = &gn_RMAP_NODE_1043_next,
		.data = &ctkn_RMAP_NODE[1043],
	},
	{
		.from = &gn_RMAP_NODE_1044_prev,
		.to = &gn_RMAP_NODE_1044_next,
		.data = &ctkn_RMAP_NODE[1044],
	},
	{
		.from = &gn_RMAP_NODE_1045_prev,
		.to = &gn_RMAP_NODE_1045_next,
		.data = &ctkn_RMAP_NODE[1045],
	},
	{
		.from = &gn_RMAP_NODE_1046_prev,
		.to = &gn_RMAP_NODE_1046_next,
		.data = &ctkn_RMAP_NODE[1046],
	},
	{
		.from = &gn_RMAP_NODE_1047_prev,
		.to = &gn_RMAP_NODE_1047_next,
		.data = (void *)&set_aigp_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1048_prev,
		.to = &gn_RMAP_NODE_1048_next,
		.data = &ctkn_RMAP_NODE[1048],
	},
	{
		.from = &gn_RMAP_NODE_1049_prev,
		.to = &gn_RMAP_NODE_1049_next,
		.data = &ctkn_RMAP_NODE[1049],
	},
	{
		.from = &gn_RMAP_NODE_1050_prev,
		.to = &gn_RMAP_NODE_1050_next,
		.data = &ctkn_RMAP_NODE[1050],
	},
	{
		.from = &gn_RMAP_NODE_1051_prev,
		.to = &gn_RMAP_NODE_1051_next,
		.data = &ctkn_RMAP_NODE[1051],
	},
	{
		.from = &gn_RMAP_NODE_1052_prev,
		.to = &gn_RMAP_NODE_1052_next,
		.data = &ctkn_RMAP_NODE[1052],
	},
	{
		.from = &gn_RMAP_NODE_1053_prev,
		.to = &gn_RMAP_NODE_1053_next,
		.data = (void *)&set_aspath_exclude_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1054_prev,
		.to = &gn_RMAP_NODE_1054_next,
		.data = &ctkn_RMAP_NODE[1054],
	},
	{
		.from = &gn_RMAP_NODE_1055_prev,
		.to = &gn_RMAP_NODE_1055_next,
		.data = &ctkn_RMAP_NODE[1055],
	},
	{
		.from = &gn_RMAP_NODE_1056_prev,
		.to = &gn_RMAP_NODE_1056_next,
		.data = &ctkn_RMAP_NODE[1056],
	},
	{
		.from = &gn_RMAP_NODE_1057_prev,
		.to = &gn_RMAP_NODE_1057_next,
		.data = (void *)&set_aspath_exclude_access_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1058_prev,
		.to = &gn_RMAP_NODE_1058_next,
		.data = &ctkn_RMAP_NODE[1058],
	},
	{
		.from = &gn_RMAP_NODE_1059_prev,
		.to = &gn_RMAP_NODE_1059_next,
		.data = &ctkn_RMAP_NODE[1059],
	},
	{
		.from = &gn_RMAP_NODE_1060_prev,
		.to = &gn_RMAP_NODE_1060_next,
		.data = &ctkn_RMAP_NODE[1060],
	},
	{
		.from = &gn_RMAP_NODE_1061_prev,
		.to = &gn_RMAP_NODE_1061_next,
		.data = (void *)&set_aspath_prepend_asn_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1062_prev,
		.to = &gn_RMAP_NODE_1062_next,
		.data = &ctkn_RMAP_NODE[1062],
	},
	{
		.from = &gn_RMAP_NODE_1063_prev,
		.to = &gn_RMAP_NODE_1063_next,
		.data = &ctkn_RMAP_NODE[1063],
	},
	{
		.from = &gn_RMAP_NODE_1064_prev,
		.to = &gn_RMAP_NODE_1064_next,
		.data = &ctkn_RMAP_NODE[1064],
	},
	{
		.from = &gn_RMAP_NODE_1065_prev,
		.to = &gn_RMAP_NODE_1065_next,
		.data = (void *)&set_aspath_prepend_lastas_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1066_prev,
		.to = &gn_RMAP_NODE_1066_next,
		.data = &ctkn_RMAP_NODE[1066],
	},
	{
		.from = &gn_RMAP_NODE_1067_prev,
		.to = &gn_RMAP_NODE_1067_next,
		.data = &ctkn_RMAP_NODE[1067],
	},
	{
		.from = &gn_RMAP_NODE_1068_prev,
		.to = &gn_RMAP_NODE_1068_next,
		.data = &ctkn_RMAP_NODE[1068],
	},
	{
		.from = &gn_RMAP_NODE_1069_prev,
		.to = &gn_RMAP_NODE_1069_next,
		.data = &ctkn_RMAP_NODE[1069],
	},
	{
		.from = &gn_RMAP_NODE_1070_prev,
		.to = &gn_RMAP_NODE_1070_next,
		.data = &ctkn_RMAP_NODE[1070],
	},
	{
		.from = &gn_RMAP_NODE_1071_prev,
		.to = &gn_RMAP_NODE_1071_next,
		.data = &ctkn_RMAP_NODE[1071],
	},
	{
		.from = &gn_RMAP_NODE_1072_prev,
		.to = &gn_RMAP_NODE_1072_next,
		.data = &ctkn_RMAP_NODE[1072],
	},
	{
		.from = &gn_RMAP_NODE_1073_prev,
		.to = &gn_RMAP_NODE_1073_next,
		.data = &ctkn_RMAP_NODE[1073],
	},
	{
		.from = &gn_RMAP_NODE_1074_prev,
		.to = &gn_RMAP_NODE_1074_next,
		.data = &ctkn_RMAP_NODE[1074],
	},
	{
		.from = &gn_RMAP_NODE_1075_prev,
		.to = &gn_RMAP_NODE_1075_next,
		.data = &ctkn_RMAP_NODE[1075],
	},
	{
		.from = &gn_RMAP_NODE_1076_prev,
		.to = &gn_RMAP_NODE_1076_next,
		.data = (void *)&set_aspath_replace_asn_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1077_prev,
		.to = &gn_RMAP_NODE_1077_next,
		.data = &ctkn_RMAP_NODE[1077],
	},
	{
		.from = &gn_RMAP_NODE_1078_prev,
		.to = &gn_RMAP_NODE_1078_next,
		.data = &ctkn_RMAP_NODE[1078],
	},
	{
		.from = &gn_RMAP_NODE_1079_prev,
		.to = &gn_RMAP_NODE_1079_next,
		.data = &ctkn_RMAP_NODE[1079],
	},
	{
		.from = &gn_RMAP_NODE_1080_prev,
		.to = &gn_RMAP_NODE_1080_next,
		.data = &ctkn_RMAP_NODE[1080],
	},
	{
		.from = &gn_RMAP_NODE_1081_prev,
		.to = &gn_RMAP_NODE_1081_next,
		.data = &ctkn_RMAP_NODE[1081],
	},
	{
		.from = &gn_RMAP_NODE_1082_prev,
		.to = &gn_RMAP_NODE_1082_next,
		.data = &ctkn_RMAP_NODE[1082],
	},
	{
		.from = &gn_RMAP_NODE_1083_prev,
		.to = &gn_RMAP_NODE_1083_next,
		.data = &ctkn_RMAP_NODE[1083],
	},
	{
		.from = &gn_RMAP_NODE_1084_prev,
		.to = &gn_RMAP_NODE_1084_next,
		.data = &ctkn_RMAP_NODE[1084],
	},
	{
		.from = &gn_RMAP_NODE_1085_prev,
		.to = &gn_RMAP_NODE_1085_next,
		.data = &ctkn_RMAP_NODE[1085],
	},
	{
		.from = &gn_RMAP_NODE_1086_prev,
		.to = &gn_RMAP_NODE_1086_next,
		.data = (void *)&set_aspath_replace_access_list_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1087_prev,
		.to = &gn_RMAP_NODE_1087_next,
		.data = &ctkn_RMAP_NODE[1087],
	},
	{
		.from = &gn_RMAP_NODE_1088_prev,
		.to = &gn_RMAP_NODE_1088_next,
		.data = &ctkn_RMAP_NODE[1088],
	},
	{
		.from = &gn_RMAP_NODE_1089_prev,
		.to = &gn_RMAP_NODE_1089_next,
		.data = (void *)&set_atomic_aggregate_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1090_prev,
		.to = &gn_RMAP_NODE_1090_next,
		.data = &ctkn_RMAP_NODE[1090],
	},
	{
		.from = &gn_RMAP_NODE_1091_prev,
		.to = &gn_RMAP_NODE_1091_next,
		.data = &ctkn_RMAP_NODE[1091],
	},
	{
		.from = &gn_RMAP_NODE_1092_prev,
		.to = &gn_RMAP_NODE_1092_next,
		.data = &ctkn_RMAP_NODE[1092],
	},
	{
		.from = &gn_RMAP_NODE_1093_prev,
		.to = &gn_RMAP_NODE_1093_next,
		.data = &ctkn_RMAP_NODE[1093],
	},
	{
		.from = &gn_RMAP_NODE_1094_prev,
		.to = &gn_RMAP_NODE_1094_next,
		.data = &ctkn_RMAP_NODE[1094],
	},
	{
		.from = &gn_RMAP_NODE_1095_prev,
		.to = &gn_RMAP_NODE_1095_next,
		.data = &ctkn_RMAP_NODE[1095],
	},
	{
		.from = &gn_RMAP_NODE_1096_prev,
		.to = &gn_RMAP_NODE_1096_next,
		.data = (void *)&set_community_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1097_prev,
		.to = &gn_RMAP_NODE_1097_next,
		.data = &ctkn_RMAP_NODE[1097],
	},
	{
		.from = &gn_RMAP_NODE_1098_prev,
		.to = &gn_RMAP_NODE_1098_next,
		.data = &ctkn_RMAP_NODE[1098],
	},
	{
		.from = &gn_RMAP_NODE_1099_prev,
		.to = &gn_RMAP_NODE_1099_next,
		.data = &ctkn_RMAP_NODE[1099],
	},
	{
		.from = &gn_RMAP_NODE_1100_prev,
		.to = &gn_RMAP_NODE_1100_next,
		.data = &ctkn_RMAP_NODE[1100],
	},
	{
		.from = &gn_RMAP_NODE_1101_prev,
		.to = &gn_RMAP_NODE_1101_next,
		.data = &ctkn_RMAP_NODE[1101],
	},
	{
		.from = &gn_RMAP_NODE_1102_prev,
		.to = &gn_RMAP_NODE_1102_next,
		.data = (void *)&set_community_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1103_prev,
		.to = &gn_RMAP_NODE_1103_next,
		.data = &ctkn_RMAP_NODE[1103],
	},
	{
		.from = &gn_RMAP_NODE_1104_prev,
		.to = &gn_RMAP_NODE_1104_next,
		.data = &ctkn_RMAP_NODE[1104],
	},
	{
		.from = &gn_RMAP_NODE_1105_prev,
		.to = &gn_RMAP_NODE_1105_next,
		.data = (void *)&set_community_none_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1106_prev,
		.to = &gn_RMAP_NODE_1106_next,
		.data = &ctkn_RMAP_NODE[1106],
	},
	{
		.from = &gn_RMAP_NODE_1107_prev,
		.to = &gn_RMAP_NODE_1107_next,
		.data = &ctkn_RMAP_NODE[1107],
	},
	{
		.from = &gn_RMAP_NODE_1108_prev,
		.to = &gn_RMAP_NODE_1108_next,
		.data = &ctkn_RMAP_NODE[1108],
	},
	{
		.from = &gn_RMAP_NODE_1109_prev,
		.to = &gn_RMAP_NODE_1109_next,
		.data = (void *)&set_distance_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1110_prev,
		.to = &gn_RMAP_NODE_1110_next,
		.data = &ctkn_RMAP_NODE[1110],
	},
	{
		.from = &gn_RMAP_NODE_1111_prev,
		.to = &gn_RMAP_NODE_1111_next,
		.data = &ctkn_RMAP_NODE[1111],
	},
	{
		.from = &gn_RMAP_NODE_1112_prev,
		.to = &gn_RMAP_NODE_1112_next,
		.data = &ctkn_RMAP_NODE[1112],
	},
	{
		.from = &gn_RMAP_NODE_1113_prev,
		.to = &gn_RMAP_NODE_1113_next,
		.data = &ctkn_RMAP_NODE[1113],
	},
	{
		.from = &gn_RMAP_NODE_1114_prev,
		.to = &gn_RMAP_NODE_1114_next,
		.data = &ctkn_RMAP_NODE[1114],
	},
	{
		.from = &gn_RMAP_NODE_1115_prev,
		.to = &gn_RMAP_NODE_1115_next,
		.data = (void *)&set_evpn_gw_ip_ipv4_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1116_prev,
		.to = &gn_RMAP_NODE_1116_next,
		.data = &ctkn_RMAP_NODE[1116],
	},
	{
		.from = &gn_RMAP_NODE_1117_prev,
		.to = &gn_RMAP_NODE_1117_next,
		.data = &ctkn_RMAP_NODE[1117],
	},
	{
		.from = &gn_RMAP_NODE_1118_prev,
		.to = &gn_RMAP_NODE_1118_next,
		.data = &ctkn_RMAP_NODE[1118],
	},
	{
		.from = &gn_RMAP_NODE_1119_prev,
		.to = &gn_RMAP_NODE_1119_next,
		.data = (void *)&set_evpn_gw_ip_ipv6_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1120_prev,
		.to = &gn_RMAP_NODE_1120_next,
		.data = &ctkn_RMAP_NODE[1120],
	},
	{
		.from = &gn_RMAP_NODE_1121_prev,
		.to = &gn_RMAP_NODE_1121_next,
		.data = &ctkn_RMAP_NODE[1121],
	},
	{
		.from = &gn_RMAP_NODE_1122_prev,
		.to = &gn_RMAP_NODE_1122_next,
		.data = &ctkn_RMAP_NODE[1122],
	},
	{
		.from = &gn_RMAP_NODE_1123_prev,
		.to = &gn_RMAP_NODE_1123_next,
		.data = &ctkn_RMAP_NODE[1123],
	},
	{
		.from = &gn_RMAP_NODE_1124_prev,
		.to = &gn_RMAP_NODE_1124_next,
		.data = &ctkn_RMAP_NODE[1124],
	},
	{
		.from = &gn_RMAP_NODE_1125_prev,
		.to = &gn_RMAP_NODE_1125_next,
		.data = &ctkn_RMAP_NODE[1125],
	},
	{
		.from = &gn_RMAP_NODE_1126_prev,
		.to = &gn_RMAP_NODE_1126_next,
		.data = &ctkn_RMAP_NODE[1126],
	},
	{
		.from = &gn_RMAP_NODE_1127_prev,
		.to = &gn_RMAP_NODE_1127_next,
		.data = &ctkn_RMAP_NODE[1127],
	},
	{
		.from = &gn_RMAP_NODE_1128_prev,
		.to = &gn_RMAP_NODE_1128_next,
		.data = &ctkn_RMAP_NODE[1128],
	},
	{
		.from = &gn_RMAP_NODE_1129_prev,
		.to = &gn_RMAP_NODE_1129_next,
		.data = (void *)&set_ecommunity_lb_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1130_prev,
		.to = &gn_RMAP_NODE_1130_next,
		.data = &ctkn_RMAP_NODE[1130],
	},
	{
		.from = &gn_RMAP_NODE_1131_prev,
		.to = &gn_RMAP_NODE_1131_next,
		.data = &ctkn_RMAP_NODE[1131],
	},
	{
		.from = &gn_RMAP_NODE_1132_prev,
		.to = &gn_RMAP_NODE_1132_next,
		.data = &ctkn_RMAP_NODE[1132],
	},
	{
		.from = &gn_RMAP_NODE_1133_prev,
		.to = &gn_RMAP_NODE_1133_next,
		.data = &ctkn_RMAP_NODE[1133],
	},
	{
		.from = &gn_RMAP_NODE_1134_prev,
		.to = &gn_RMAP_NODE_1134_next,
		.data = &ctkn_RMAP_NODE[1134],
	},
	{
		.from = &gn_RMAP_NODE_1135_prev,
		.to = &gn_RMAP_NODE_1135_next,
		.data = (void *)&set_ecommunity_color_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1136_prev,
		.to = &gn_RMAP_NODE_1136_next,
		.data = &ctkn_RMAP_NODE[1136],
	},
	{
		.from = &gn_RMAP_NODE_1137_prev,
		.to = &gn_RMAP_NODE_1137_next,
		.data = &ctkn_RMAP_NODE[1137],
	},
	{
		.from = &gn_RMAP_NODE_1138_prev,
		.to = &gn_RMAP_NODE_1138_next,
		.data = (void *)&set_ecommunity_none_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1139_prev,
		.to = &gn_RMAP_NODE_1139_next,
		.data = &ctkn_RMAP_NODE[1139],
	},
	{
		.from = &gn_RMAP_NODE_1140_prev,
		.to = &gn_RMAP_NODE_1140_next,
		.data = &ctkn_RMAP_NODE[1140],
	},
	{
		.from = &gn_RMAP_NODE_1141_prev,
		.to = &gn_RMAP_NODE_1141_next,
		.data = &ctkn_RMAP_NODE[1141],
	},
	{
		.from = &gn_RMAP_NODE_1142_prev,
		.to = &gn_RMAP_NODE_1142_next,
		.data = (void *)&set_ecommunity_nt_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1143_prev,
		.to = &gn_RMAP_NODE_1143_next,
		.data = &ctkn_RMAP_NODE[1143],
	},
	{
		.from = &gn_RMAP_NODE_1144_prev,
		.to = &gn_RMAP_NODE_1144_next,
		.data = &ctkn_RMAP_NODE[1144],
	},
	{
		.from = &gn_RMAP_NODE_1145_prev,
		.to = &gn_RMAP_NODE_1145_next,
		.data = &ctkn_RMAP_NODE[1145],
	},
	{
		.from = &gn_RMAP_NODE_1146_prev,
		.to = &gn_RMAP_NODE_1146_next,
		.data = (void *)&set_ecommunity_rt_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1147_prev,
		.to = &gn_RMAP_NODE_1147_next,
		.data = &ctkn_RMAP_NODE[1147],
	},
	{
		.from = &gn_RMAP_NODE_1148_prev,
		.to = &gn_RMAP_NODE_1148_next,
		.data = &ctkn_RMAP_NODE[1148],
	},
	{
		.from = &gn_RMAP_NODE_1149_prev,
		.to = &gn_RMAP_NODE_1149_next,
		.data = &ctkn_RMAP_NODE[1149],
	},
	{
		.from = &gn_RMAP_NODE_1150_prev,
		.to = &gn_RMAP_NODE_1150_next,
		.data = (void *)&set_ecommunity_soo_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1151_prev,
		.to = &gn_RMAP_NODE_1151_next,
		.data = &ctkn_RMAP_NODE[1151],
	},
	{
		.from = &gn_RMAP_NODE_1152_prev,
		.to = &gn_RMAP_NODE_1152_next,
		.data = &ctkn_RMAP_NODE[1152],
	},
	{
		.from = &gn_RMAP_NODE_1153_prev,
		.to = &gn_RMAP_NODE_1153_next,
		.data = &ctkn_RMAP_NODE[1153],
	},
	{
		.from = &gn_RMAP_NODE_1154_prev,
		.to = &gn_RMAP_NODE_1154_next,
		.data = &ctkn_RMAP_NODE[1154],
	},
	{
		.from = &gn_RMAP_NODE_1155_prev,
		.to = &gn_RMAP_NODE_1155_next,
		.data = &ctkn_RMAP_NODE[1155],
	},
	{
		.from = &gn_RMAP_NODE_1156_prev,
		.to = &gn_RMAP_NODE_1156_next,
		.data = &ctkn_RMAP_NODE[1156],
	},
	{
		.from = &gn_RMAP_NODE_1157_prev,
		.to = &gn_RMAP_NODE_1157_next,
		.data = (void *)&set_ecommunity_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1158_prev,
		.to = &gn_RMAP_NODE_1158_next,
		.data = &ctkn_RMAP_NODE[1158],
	},
	{
		.from = &gn_RMAP_NODE_1159_prev,
		.to = &gn_RMAP_NODE_1159_next,
		.data = &ctkn_RMAP_NODE[1159],
	},
	{
		.from = &gn_RMAP_NODE_1160_prev,
		.to = &gn_RMAP_NODE_1160_next,
		.data = &ctkn_RMAP_NODE[1160],
	},
	{
		.from = &gn_RMAP_NODE_1161_prev,
		.to = &gn_RMAP_NODE_1161_next,
		.data = &ctkn_RMAP_NODE[1161],
	},
	{
		.from = &gn_RMAP_NODE_1162_prev,
		.to = &gn_RMAP_NODE_1162_next,
		.data = &ctkn_RMAP_NODE[1162],
	},
	{
		.from = &gn_RMAP_NODE_1163_prev,
		.to = &gn_RMAP_NODE_1163_next,
		.data = (void *)&ospf6_routemap_set_forwarding_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1164_prev,
		.to = &gn_RMAP_NODE_1164_next,
		.data = &ctkn_RMAP_NODE[1164],
	},
	{
		.from = &gn_RMAP_NODE_1165_prev,
		.to = &gn_RMAP_NODE_1165_next,
		.data = &ctkn_RMAP_NODE[1165],
	},
	{
		.from = &gn_RMAP_NODE_1166_prev,
		.to = &gn_RMAP_NODE_1166_next,
		.data = &ctkn_RMAP_NODE[1166],
	},
	{
		.from = &gn_RMAP_NODE_1167_prev,
		.to = &gn_RMAP_NODE_1167_next,
		.data = &ctkn_RMAP_NODE[1167],
	},
	{
		.from = &gn_RMAP_NODE_1168_prev,
		.to = &gn_RMAP_NODE_1168_next,
		.data = (void *)&set_ip_nexthop_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1169_prev,
		.to = &gn_RMAP_NODE_1169_next,
		.data = &ctkn_RMAP_NODE[1169],
	},
	{
		.from = &gn_RMAP_NODE_1170_prev,
		.to = &gn_RMAP_NODE_1170_next,
		.data = &ctkn_RMAP_NODE[1170],
	},
	{
		.from = &gn_RMAP_NODE_1171_prev,
		.to = &gn_RMAP_NODE_1171_next,
		.data = &ctkn_RMAP_NODE[1171],
	},
	{
		.from = &gn_RMAP_NODE_1172_prev,
		.to = &gn_RMAP_NODE_1172_next,
		.data = &ctkn_RMAP_NODE[1172],
	},
	{
		.from = &gn_RMAP_NODE_1173_prev,
		.to = &gn_RMAP_NODE_1173_next,
		.data = &ctkn_RMAP_NODE[1173],
	},
	{
		.from = &gn_RMAP_NODE_1174_prev,
		.to = &gn_RMAP_NODE_1174_next,
		.data = (void *)&set_ipv6_nexthop_global_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1175_prev,
		.to = &gn_RMAP_NODE_1175_next,
		.data = &ctkn_RMAP_NODE[1175],
	},
	{
		.from = &gn_RMAP_NODE_1176_prev,
		.to = &gn_RMAP_NODE_1176_next,
		.data = &ctkn_RMAP_NODE[1176],
	},
	{
		.from = &gn_RMAP_NODE_1177_prev,
		.to = &gn_RMAP_NODE_1177_next,
		.data = &ctkn_RMAP_NODE[1177],
	},
	{
		.from = &gn_RMAP_NODE_1178_prev,
		.to = &gn_RMAP_NODE_1178_next,
		.data = (void *)&set_ipv6_nexthop_local_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1179_prev,
		.to = &gn_RMAP_NODE_1179_next,
		.data = &ctkn_RMAP_NODE[1179],
	},
	{
		.from = &gn_RMAP_NODE_1180_prev,
		.to = &gn_RMAP_NODE_1180_next,
		.data = &ctkn_RMAP_NODE[1180],
	},
	{
		.from = &gn_RMAP_NODE_1181_prev,
		.to = &gn_RMAP_NODE_1181_next,
		.data = (void *)&set_ipv6_nexthop_peer_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1182_prev,
		.to = &gn_RMAP_NODE_1182_next,
		.data = &ctkn_RMAP_NODE[1182],
	},
	{
		.from = &gn_RMAP_NODE_1183_prev,
		.to = &gn_RMAP_NODE_1183_next,
		.data = &ctkn_RMAP_NODE[1183],
	},
	{
		.from = &gn_RMAP_NODE_1184_prev,
		.to = &gn_RMAP_NODE_1184_next,
		.data = (void *)&set_ipv6_nexthop_prefer_global_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1185_prev,
		.to = &gn_RMAP_NODE_1185_next,
		.data = &ctkn_RMAP_NODE[1185],
	},
	{
		.from = &gn_RMAP_NODE_1186_prev,
		.to = &gn_RMAP_NODE_1186_next,
		.data = &ctkn_RMAP_NODE[1186],
	},
	{
		.from = &gn_RMAP_NODE_1187_prev,
		.to = &gn_RMAP_NODE_1187_next,
		.data = &ctkn_RMAP_NODE[1187],
	},
	{
		.from = &gn_RMAP_NODE_1188_prev,
		.to = &gn_RMAP_NODE_1188_next,
		.data = (void *)&set_label_index_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1189_prev,
		.to = &gn_RMAP_NODE_1189_next,
		.data = &ctkn_RMAP_NODE[1189],
	},
	{
		.from = &gn_RMAP_NODE_1190_prev,
		.to = &gn_RMAP_NODE_1190_next,
		.data = &ctkn_RMAP_NODE[1190],
	},
	{
		.from = &gn_RMAP_NODE_1191_prev,
		.to = &gn_RMAP_NODE_1191_next,
		.data = &ctkn_RMAP_NODE[1191],
	},
	{
		.from = &gn_RMAP_NODE_1192_prev,
		.to = &gn_RMAP_NODE_1192_next,
		.data = &ctkn_RMAP_NODE[1192],
	},
	{
		.from = &gn_RMAP_NODE_1193_prev,
		.to = &gn_RMAP_NODE_1193_next,
		.data = &ctkn_RMAP_NODE[1193],
	},
	{
		.from = &gn_RMAP_NODE_1194_prev,
		.to = &gn_RMAP_NODE_1194_next,
		.data = &ctkn_RMAP_NODE[1194],
	},
	{
		.from = &gn_RMAP_NODE_1195_prev,
		.to = &gn_RMAP_NODE_1195_next,
		.data = (void *)&set_lcommunity_delete_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1196_prev,
		.to = &gn_RMAP_NODE_1196_next,
		.data = &ctkn_RMAP_NODE[1196],
	},
	{
		.from = &gn_RMAP_NODE_1197_prev,
		.to = &gn_RMAP_NODE_1197_next,
		.data = &ctkn_RMAP_NODE[1197],
	},
	{
		.from = &gn_RMAP_NODE_1198_prev,
		.to = &gn_RMAP_NODE_1198_next,
		.data = &ctkn_RMAP_NODE[1198],
	},
	{
		.from = &gn_RMAP_NODE_1199_prev,
		.to = &gn_RMAP_NODE_1199_next,
		.data = &ctkn_RMAP_NODE[1199],
	},
	{
		.from = &gn_RMAP_NODE_1200_prev,
		.to = &gn_RMAP_NODE_1200_next,
		.data = &ctkn_RMAP_NODE[1200],
	},
	{
		.from = &gn_RMAP_NODE_1201_prev,
		.to = &gn_RMAP_NODE_1201_next,
		.data = (void *)&set_lcommunity_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1202_prev,
		.to = &gn_RMAP_NODE_1202_next,
		.data = &ctkn_RMAP_NODE[1202],
	},
	{
		.from = &gn_RMAP_NODE_1203_prev,
		.to = &gn_RMAP_NODE_1203_next,
		.data = &ctkn_RMAP_NODE[1203],
	},
	{
		.from = &gn_RMAP_NODE_1204_prev,
		.to = &gn_RMAP_NODE_1204_next,
		.data = (void *)&set_lcommunity_none_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1205_prev,
		.to = &gn_RMAP_NODE_1205_next,
		.data = &ctkn_RMAP_NODE[1205],
	},
	{
		.from = &gn_RMAP_NODE_1206_prev,
		.to = &gn_RMAP_NODE_1206_next,
		.data = &ctkn_RMAP_NODE[1206],
	},
	{
		.from = &gn_RMAP_NODE_1207_prev,
		.to = &gn_RMAP_NODE_1207_next,
		.data = &ctkn_RMAP_NODE[1207],
	},
	{
		.from = &gn_RMAP_NODE_1208_prev,
		.to = &gn_RMAP_NODE_1208_next,
		.data = (void *)&set_local_pref_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1209_prev,
		.to = &gn_RMAP_NODE_1209_next,
		.data = &ctkn_RMAP_NODE[1209],
	},
	{
		.from = &gn_RMAP_NODE_1210_prev,
		.to = &gn_RMAP_NODE_1210_next,
		.data = &ctkn_RMAP_NODE[1210],
	},
	{
		.from = &gn_RMAP_NODE_1211_prev,
		.to = &gn_RMAP_NODE_1211_next,
		.data = &ctkn_RMAP_NODE[1211],
	},
	{
		.from = &gn_RMAP_NODE_1212_prev,
		.to = &gn_RMAP_NODE_1212_next,
		.data = &ctkn_RMAP_NODE[1212],
	},
	{
		.from = &gn_RMAP_NODE_1213_prev,
		.to = &gn_RMAP_NODE_1213_next,
		.data = &ctkn_RMAP_NODE[1213],
	},
	{
		.from = &gn_RMAP_NODE_1214_prev,
		.to = &gn_RMAP_NODE_1214_next,
		.data = (void *)&set_max_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1215_prev,
		.to = &gn_RMAP_NODE_1215_next,
		.data = &ctkn_RMAP_NODE[1215],
	},
	{
		.from = &gn_RMAP_NODE_1216_prev,
		.to = &gn_RMAP_NODE_1216_next,
		.data = &ctkn_RMAP_NODE[1216],
	},
	{
		.from = &gn_RMAP_NODE_1217_prev,
		.to = &gn_RMAP_NODE_1217_next,
		.data = &ctkn_RMAP_NODE[1217],
	},
	{
		.from = &gn_RMAP_NODE_1218_prev,
		.to = &gn_RMAP_NODE_1218_next,
		.data = &ctkn_RMAP_NODE[1218],
	},
	{
		.from = &gn_RMAP_NODE_1219_prev,
		.to = &gn_RMAP_NODE_1219_next,
		.data = &ctkn_RMAP_NODE[1219],
	},
	{
		.from = &gn_RMAP_NODE_1220_prev,
		.to = &gn_RMAP_NODE_1220_next,
		.data = (void *)&set_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1221_prev,
		.to = &gn_RMAP_NODE_1221_next,
		.data = &ctkn_RMAP_NODE[1221],
	},
	{
		.from = &gn_RMAP_NODE_1222_prev,
		.to = &gn_RMAP_NODE_1222_next,
		.data = &ctkn_RMAP_NODE[1222],
	},
	{
		.from = &gn_RMAP_NODE_1223_prev,
		.to = &gn_RMAP_NODE_1223_next,
		.data = &ctkn_RMAP_NODE[1223],
	},
	{
		.from = &gn_RMAP_NODE_1224_prev,
		.to = &gn_RMAP_NODE_1224_next,
		.data = &ctkn_RMAP_NODE[1224],
	},
	{
		.from = &gn_RMAP_NODE_1225_prev,
		.to = &gn_RMAP_NODE_1225_next,
		.data = &ctkn_RMAP_NODE[1225],
	},
	{
		.from = &gn_RMAP_NODE_1226_prev,
		.to = &gn_RMAP_NODE_1226_next,
		.data = &ctkn_RMAP_NODE[1226],
	},
	{
		.from = &gn_RMAP_NODE_1227_prev,
		.to = &gn_RMAP_NODE_1227_next,
		.data = &ctkn_RMAP_NODE[1227],
	},
	{
		.from = &gn_RMAP_NODE_1228_prev,
		.to = &gn_RMAP_NODE_1228_next,
		.data = &ctkn_RMAP_NODE[1228],
	},
	{
		.from = &gn_RMAP_NODE_1229_prev,
		.to = &gn_RMAP_NODE_1229_next,
		.data = &ctkn_RMAP_NODE[1229],
	},
	{
		.from = &gn_RMAP_NODE_1230_prev,
		.to = &gn_RMAP_NODE_1230_next,
		.data = &ctkn_RMAP_NODE[1230],
	},
	{
		.from = &gn_RMAP_NODE_1231_prev,
		.to = &gn_RMAP_NODE_1231_next,
		.data = (void *)&set_metric_type_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1232_prev,
		.to = &gn_RMAP_NODE_1232_next,
		.data = &ctkn_RMAP_NODE[1232],
	},
	{
		.from = &gn_RMAP_NODE_1233_prev,
		.to = &gn_RMAP_NODE_1233_next,
		.data = &ctkn_RMAP_NODE[1233],
	},
	{
		.from = &gn_RMAP_NODE_1234_prev,
		.to = &gn_RMAP_NODE_1234_next,
		.data = &ctkn_RMAP_NODE[1234],
	},
	{
		.from = &gn_RMAP_NODE_1235_prev,
		.to = &gn_RMAP_NODE_1235_next,
		.data = &ctkn_RMAP_NODE[1235],
	},
	{
		.from = &gn_RMAP_NODE_1236_prev,
		.to = &gn_RMAP_NODE_1236_next,
		.data = &ctkn_RMAP_NODE[1236],
	},
	{
		.from = &gn_RMAP_NODE_1237_prev,
		.to = &gn_RMAP_NODE_1237_next,
		.data = &ctkn_RMAP_NODE[1237],
	},
	{
		.from = &gn_RMAP_NODE_1238_prev,
		.to = &gn_RMAP_NODE_1238_next,
		.data = (void *)&set_min_metric_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1239_prev,
		.to = &gn_RMAP_NODE_1239_next,
		.data = &ctkn_RMAP_NODE[1239],
	},
	{
		.from = &gn_RMAP_NODE_1240_prev,
		.to = &gn_RMAP_NODE_1240_next,
		.data = &ctkn_RMAP_NODE[1240],
	},
	{
		.from = &gn_RMAP_NODE_1241_prev,
		.to = &gn_RMAP_NODE_1241_next,
		.data = &ctkn_RMAP_NODE[1241],
	},
	{
		.from = &gn_RMAP_NODE_1242_prev,
		.to = &gn_RMAP_NODE_1242_next,
		.data = &ctkn_RMAP_NODE[1242],
	},
	{
		.from = &gn_RMAP_NODE_1243_prev,
		.to = &gn_RMAP_NODE_1243_next,
		.data = &ctkn_RMAP_NODE[1243],
	},
	{
		.from = &gn_RMAP_NODE_1244_prev,
		.to = &gn_RMAP_NODE_1244_next,
		.data = (void *)&set_origin_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1245_prev,
		.to = &gn_RMAP_NODE_1245_next,
		.data = &ctkn_RMAP_NODE[1245],
	},
	{
		.from = &gn_RMAP_NODE_1246_prev,
		.to = &gn_RMAP_NODE_1246_next,
		.data = &ctkn_RMAP_NODE[1246],
	},
	{
		.from = &gn_RMAP_NODE_1247_prev,
		.to = &gn_RMAP_NODE_1247_next,
		.data = &ctkn_RMAP_NODE[1247],
	},
	{
		.from = &gn_RMAP_NODE_1248_prev,
		.to = &gn_RMAP_NODE_1248_next,
		.data = &ctkn_RMAP_NODE[1248],
	},
	{
		.from = &gn_RMAP_NODE_1249_prev,
		.to = &gn_RMAP_NODE_1249_next,
		.data = &ctkn_RMAP_NODE[1249],
	},
	{
		.from = &gn_RMAP_NODE_1250_prev,
		.to = &gn_RMAP_NODE_1250_next,
		.data = (void *)&set_originator_id_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1251_prev,
		.to = &gn_RMAP_NODE_1251_next,
		.data = &ctkn_RMAP_NODE[1251],
	},
	{
		.from = &gn_RMAP_NODE_1252_prev,
		.to = &gn_RMAP_NODE_1252_next,
		.data = &ctkn_RMAP_NODE[1252],
	},
	{
		.from = &gn_RMAP_NODE_1253_prev,
		.to = &gn_RMAP_NODE_1253_next,
		.data = &ctkn_RMAP_NODE[1253],
	},
	{
		.from = &gn_RMAP_NODE_1254_prev,
		.to = &gn_RMAP_NODE_1254_next,
		.data = &ctkn_RMAP_NODE[1254],
	},
	{
		.from = &gn_RMAP_NODE_1255_prev,
		.to = &gn_RMAP_NODE_1255_next,
		.data = (void *)&set_srte_color_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1256_prev,
		.to = &gn_RMAP_NODE_1256_next,
		.data = &ctkn_RMAP_NODE[1256],
	},
	{
		.from = &gn_RMAP_NODE_1257_prev,
		.to = &gn_RMAP_NODE_1257_next,
		.data = &ctkn_RMAP_NODE[1257],
	},
	{
		.from = &gn_RMAP_NODE_1258_prev,
		.to = &gn_RMAP_NODE_1258_next,
		.data = &ctkn_RMAP_NODE[1258],
	},
	{
		.from = &gn_RMAP_NODE_1259_prev,
		.to = &gn_RMAP_NODE_1259_next,
		.data = &ctkn_RMAP_NODE[1259],
	},
	{
		.from = &gn_RMAP_NODE_1260_prev,
		.to = &gn_RMAP_NODE_1260_next,
		.data = &ctkn_RMAP_NODE[1260],
	},
	{
		.from = &gn_RMAP_NODE_1261_prev,
		.to = &gn_RMAP_NODE_1261_next,
		.data = (void *)&set_src_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1262_prev,
		.to = &gn_RMAP_NODE_1262_next,
		.data = &ctkn_RMAP_NODE[1262],
	},
	{
		.from = &gn_RMAP_NODE_1263_prev,
		.to = &gn_RMAP_NODE_1263_next,
		.data = &ctkn_RMAP_NODE[1263],
	},
	{
		.from = &gn_RMAP_NODE_1264_prev,
		.to = &gn_RMAP_NODE_1264_next,
		.data = &ctkn_RMAP_NODE[1264],
	},
	{
		.from = &gn_RMAP_NODE_1265_prev,
		.to = &gn_RMAP_NODE_1265_next,
		.data = &ctkn_RMAP_NODE[1265],
	},
	{
		.from = &gn_RMAP_NODE_1266_prev,
		.to = &gn_RMAP_NODE_1266_next,
		.data = (void *)&set_table_id_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1267_prev,
		.to = &gn_RMAP_NODE_1267_next,
		.data = &ctkn_RMAP_NODE[1267],
	},
	{
		.from = &gn_RMAP_NODE_1268_prev,
		.to = &gn_RMAP_NODE_1268_next,
		.data = &ctkn_RMAP_NODE[1268],
	},
	{
		.from = &gn_RMAP_NODE_1269_prev,
		.to = &gn_RMAP_NODE_1269_next,
		.data = &ctkn_RMAP_NODE[1269],
	},
	{
		.from = &gn_RMAP_NODE_1270_prev,
		.to = &gn_RMAP_NODE_1270_next,
		.data = &ctkn_RMAP_NODE[1270],
	},
	{
		.from = &gn_RMAP_NODE_1271_prev,
		.to = &gn_RMAP_NODE_1271_next,
		.data = &ctkn_RMAP_NODE[1271],
	},
	{
		.from = &gn_RMAP_NODE_1272_prev,
		.to = &gn_RMAP_NODE_1272_next,
		.data = (void *)&set_tag_cmd_vtysh,
	},
	{
		.from = &gn_RMAP_NODE_1273_prev,
		.to = &gn_RMAP_NODE_1273_next,
		.data = &ctkn_RMAP_NODE[1273],
	},
	{
		.from = &gn_RMAP_NODE_1274_prev,
		.to = &gn_RMAP_NODE_1274_next,
		.data = &ctkn_RMAP_NODE[1274],
	},
	{
		.from = &gn_RMAP_NODE_1275_prev,
		.to = &gn_RMAP_NODE_1275_next,
		.data = &ctkn_RMAP_NODE[1275],
	},
	{
		.from = &gn_RMAP_NODE_1276_prev,
		.to = &gn_RMAP_NODE_1276_next,
		.data = &ctkn_RMAP_NODE[1276],
	},
	{
		.from = &gn_RMAP_NODE_1277_prev,
		.to = &gn_RMAP_NODE_1277_next,
		.data = (void *)&set_weight_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_RMAP_NODE, 1278, &gn_RMAP_NODE[0], &gn_RMAP_NODE[1], &gn_RMAP_NODE[2], &gn_RMAP_NODE[3], &gn_RMAP_NODE[4], &gn_RMAP_NODE[5], &gn_RMAP_NODE[6], &gn_RMAP_NODE[7], &gn_RMAP_NODE[8], &gn_RMAP_NODE[9], &gn_RMAP_NODE[10], &gn_RMAP_NODE[11], &gn_RMAP_NODE[12], &gn_RMAP_NODE[13], &gn_RMAP_NODE[14], &gn_RMAP_NODE[15], &gn_RMAP_NODE[16], &gn_RMAP_NODE[17], &gn_RMAP_NODE[18], &gn_RMAP_NODE[19], &gn_RMAP_NODE[20], &gn_RMAP_NODE[21], &gn_RMAP_NODE[22], &gn_RMAP_NODE[23], &gn_RMAP_NODE[24], &gn_RMAP_NODE[25], &gn_RMAP_NODE[26], &gn_RMAP_NODE[27], &gn_RMAP_NODE[28], &gn_RMAP_NODE[29], &gn_RMAP_NODE[30], &gn_RMAP_NODE[31], &gn_RMAP_NODE[32], &gn_RMAP_NODE[33], &gn_RMAP_NODE[34], &gn_RMAP_NODE[35], &gn_RMAP_NODE[36], &gn_RMAP_NODE[37], &gn_RMAP_NODE[38], &gn_RMAP_NODE[39], &gn_RMAP_NODE[40], &gn_RMAP_NODE[41], &gn_RMAP_NODE[42], &gn_RMAP_NODE[43], &gn_RMAP_NODE[44], &gn_RMAP_NODE[45], &gn_RMAP_NODE[46], &gn_RMAP_NODE[47], &gn_RMAP_NODE[48], &gn_RMAP_NODE[49], &gn_RMAP_NODE[50], &gn_RMAP_NODE[51], &gn_RMAP_NODE[52], &gn_RMAP_NODE[53], &gn_RMAP_NODE[54], &gn_RMAP_NODE[55], &gn_RMAP_NODE[56], &gn_RMAP_NODE[57], &gn_RMAP_NODE[58], &gn_RMAP_NODE[59], &gn_RMAP_NODE[60], &gn_RMAP_NODE[61], &gn_RMAP_NODE[62], &gn_RMAP_NODE[63], &gn_RMAP_NODE[64], &gn_RMAP_NODE[65], &gn_RMAP_NODE[66], &gn_RMAP_NODE[67], &gn_RMAP_NODE[68], &gn_RMAP_NODE[69], &gn_RMAP_NODE[70], &gn_RMAP_NODE[71], &gn_RMAP_NODE[72], &gn_RMAP_NODE[73], &gn_RMAP_NODE[74], &gn_RMAP_NODE[75], &gn_RMAP_NODE[76], &gn_RMAP_NODE[77], &gn_RMAP_NODE[78], &gn_RMAP_NODE[79], &gn_RMAP_NODE[80], &gn_RMAP_NODE[81], &gn_RMAP_NODE[82], &gn_RMAP_NODE[83], &gn_RMAP_NODE[84], &gn_RMAP_NODE[85], &gn_RMAP_NODE[86], &gn_RMAP_NODE[87], &gn_RMAP_NODE[88], &gn_RMAP_NODE[89], &gn_RMAP_NODE[90], &gn_RMAP_NODE[91], &gn_RMAP_NODE[92], &gn_RMAP_NODE[93], &gn_RMAP_NODE[94], &gn_RMAP_NODE[95], &gn_RMAP_NODE[96], &gn_RMAP_NODE[97], &gn_RMAP_NODE[98], &gn_RMAP_NODE[99], &gn_RMAP_NODE[100], &gn_RMAP_NODE[101], &gn_RMAP_NODE[102], &gn_RMAP_NODE[103], &gn_RMAP_NODE[104], &gn_RMAP_NODE[105], &gn_RMAP_NODE[106], &gn_RMAP_NODE[107], &gn_RMAP_NODE[108], &gn_RMAP_NODE[109], &gn_RMAP_NODE[110], &gn_RMAP_NODE[111], &gn_RMAP_NODE[112], &gn_RMAP_NODE[113], &gn_RMAP_NODE[114], &gn_RMAP_NODE[115], &gn_RMAP_NODE[116], &gn_RMAP_NODE[117], &gn_RMAP_NODE[118], &gn_RMAP_NODE[119], &gn_RMAP_NODE[120], &gn_RMAP_NODE[121], &gn_RMAP_NODE[122], &gn_RMAP_NODE[123], &gn_RMAP_NODE[124], &gn_RMAP_NODE[125], &gn_RMAP_NODE[126], &gn_RMAP_NODE[127], &gn_RMAP_NODE[128], &gn_RMAP_NODE[129], &gn_RMAP_NODE[130], &gn_RMAP_NODE[131], &gn_RMAP_NODE[132], &gn_RMAP_NODE[133], &gn_RMAP_NODE[134], &gn_RMAP_NODE[135], &gn_RMAP_NODE[136], &gn_RMAP_NODE[137], &gn_RMAP_NODE[138], &gn_RMAP_NODE[139], &gn_RMAP_NODE[140], &gn_RMAP_NODE[141], &gn_RMAP_NODE[142], &gn_RMAP_NODE[143], &gn_RMAP_NODE[144], &gn_RMAP_NODE[145], &gn_RMAP_NODE[146], &gn_RMAP_NODE[147], &gn_RMAP_NODE[148], &gn_RMAP_NODE[149], &gn_RMAP_NODE[150], &gn_RMAP_NODE[151], &gn_RMAP_NODE[152], &gn_RMAP_NODE[153], &gn_RMAP_NODE[154], &gn_RMAP_NODE[155], &gn_RMAP_NODE[156], &gn_RMAP_NODE[157], &gn_RMAP_NODE[158], &gn_RMAP_NODE[159], &gn_RMAP_NODE[160], &gn_RMAP_NODE[161], &gn_RMAP_NODE[162], &gn_RMAP_NODE[163], &gn_RMAP_NODE[164], &gn_RMAP_NODE[165], &gn_RMAP_NODE[166], &gn_RMAP_NODE[167], &gn_RMAP_NODE[168], &gn_RMAP_NODE[169], &gn_RMAP_NODE[170], &gn_RMAP_NODE[171], &gn_RMAP_NODE[172], &gn_RMAP_NODE[173], &gn_RMAP_NODE[174], &gn_RMAP_NODE[175], &gn_RMAP_NODE[176], &gn_RMAP_NODE[177], &gn_RMAP_NODE[178], &gn_RMAP_NODE[179], &gn_RMAP_NODE[180], &gn_RMAP_NODE[181], &gn_RMAP_NODE[182], &gn_RMAP_NODE[183], &gn_RMAP_NODE[184], &gn_RMAP_NODE[185], &gn_RMAP_NODE[186], &gn_RMAP_NODE[187], &gn_RMAP_NODE[188], &gn_RMAP_NODE[189], &gn_RMAP_NODE[190], &gn_RMAP_NODE[191], &gn_RMAP_NODE[192], &gn_RMAP_NODE[193], &gn_RMAP_NODE[194], &gn_RMAP_NODE[195], &gn_RMAP_NODE[196], &gn_RMAP_NODE[197], &gn_RMAP_NODE[198], &gn_RMAP_NODE[199], &gn_RMAP_NODE[200], &gn_RMAP_NODE[201], &gn_RMAP_NODE[202], &gn_RMAP_NODE[203], &gn_RMAP_NODE[204], &gn_RMAP_NODE[205], &gn_RMAP_NODE[206], &gn_RMAP_NODE[207], &gn_RMAP_NODE[208], &gn_RMAP_NODE[209], &gn_RMAP_NODE[210], &gn_RMAP_NODE[211], &gn_RMAP_NODE[212], &gn_RMAP_NODE[213], &gn_RMAP_NODE[214], &gn_RMAP_NODE[215], &gn_RMAP_NODE[216], &gn_RMAP_NODE[217], &gn_RMAP_NODE[218], &gn_RMAP_NODE[219], &gn_RMAP_NODE[220], &gn_RMAP_NODE[221], &gn_RMAP_NODE[222], &gn_RMAP_NODE[223], &gn_RMAP_NODE[224], &gn_RMAP_NODE[225], &gn_RMAP_NODE[226], &gn_RMAP_NODE[227], &gn_RMAP_NODE[228], &gn_RMAP_NODE[229], &gn_RMAP_NODE[230], &gn_RMAP_NODE[231], &gn_RMAP_NODE[232], &gn_RMAP_NODE[233], &gn_RMAP_NODE[234], &gn_RMAP_NODE[235], &gn_RMAP_NODE[236], &gn_RMAP_NODE[237], &gn_RMAP_NODE[238], &gn_RMAP_NODE[239], &gn_RMAP_NODE[240], &gn_RMAP_NODE[241], &gn_RMAP_NODE[242], &gn_RMAP_NODE[243], &gn_RMAP_NODE[244], &gn_RMAP_NODE[245], &gn_RMAP_NODE[246], &gn_RMAP_NODE[247], &gn_RMAP_NODE[248], &gn_RMAP_NODE[249], &gn_RMAP_NODE[250], &gn_RMAP_NODE[251], &gn_RMAP_NODE[252], &gn_RMAP_NODE[253], &gn_RMAP_NODE[254], &gn_RMAP_NODE[255], &gn_RMAP_NODE[256], &gn_RMAP_NODE[257], &gn_RMAP_NODE[258], &gn_RMAP_NODE[259], &gn_RMAP_NODE[260], &gn_RMAP_NODE[261], &gn_RMAP_NODE[262], &gn_RMAP_NODE[263], &gn_RMAP_NODE[264], &gn_RMAP_NODE[265], &gn_RMAP_NODE[266], &gn_RMAP_NODE[267], &gn_RMAP_NODE[268], &gn_RMAP_NODE[269], &gn_RMAP_NODE[270], &gn_RMAP_NODE[271], &gn_RMAP_NODE[272], &gn_RMAP_NODE[273], &gn_RMAP_NODE[274], &gn_RMAP_NODE[275], &gn_RMAP_NODE[276], &gn_RMAP_NODE[277], &gn_RMAP_NODE[278], &gn_RMAP_NODE[279], &gn_RMAP_NODE[280], &gn_RMAP_NODE[281], &gn_RMAP_NODE[282], &gn_RMAP_NODE[283], &gn_RMAP_NODE[284], &gn_RMAP_NODE[285], &gn_RMAP_NODE[286], &gn_RMAP_NODE[287], &gn_RMAP_NODE[288], &gn_RMAP_NODE[289], &gn_RMAP_NODE[290], &gn_RMAP_NODE[291], &gn_RMAP_NODE[292], &gn_RMAP_NODE[293], &gn_RMAP_NODE[294], &gn_RMAP_NODE[295], &gn_RMAP_NODE[296], &gn_RMAP_NODE[297], &gn_RMAP_NODE[298], &gn_RMAP_NODE[299], &gn_RMAP_NODE[300], &gn_RMAP_NODE[301], &gn_RMAP_NODE[302], &gn_RMAP_NODE[303], &gn_RMAP_NODE[304], &gn_RMAP_NODE[305], &gn_RMAP_NODE[306], &gn_RMAP_NODE[307], &gn_RMAP_NODE[308], &gn_RMAP_NODE[309], &gn_RMAP_NODE[310], &gn_RMAP_NODE[311], &gn_RMAP_NODE[312], &gn_RMAP_NODE[313], &gn_RMAP_NODE[314], &gn_RMAP_NODE[315], &gn_RMAP_NODE[316], &gn_RMAP_NODE[317], &gn_RMAP_NODE[318], &gn_RMAP_NODE[319], &gn_RMAP_NODE[320], &gn_RMAP_NODE[321], &gn_RMAP_NODE[322], &gn_RMAP_NODE[323], &gn_RMAP_NODE[324], &gn_RMAP_NODE[325], &gn_RMAP_NODE[326], &gn_RMAP_NODE[327], &gn_RMAP_NODE[328], &gn_RMAP_NODE[329], &gn_RMAP_NODE[330], &gn_RMAP_NODE[331], &gn_RMAP_NODE[332], &gn_RMAP_NODE[333], &gn_RMAP_NODE[334], &gn_RMAP_NODE[335], &gn_RMAP_NODE[336], &gn_RMAP_NODE[337], &gn_RMAP_NODE[338], &gn_RMAP_NODE[339], &gn_RMAP_NODE[340], &gn_RMAP_NODE[341], &gn_RMAP_NODE[342], &gn_RMAP_NODE[343], &gn_RMAP_NODE[344], &gn_RMAP_NODE[345], &gn_RMAP_NODE[346], &gn_RMAP_NODE[347], &gn_RMAP_NODE[348], &gn_RMAP_NODE[349], &gn_RMAP_NODE[350], &gn_RMAP_NODE[351], &gn_RMAP_NODE[352], &gn_RMAP_NODE[353], &gn_RMAP_NODE[354], &gn_RMAP_NODE[355], &gn_RMAP_NODE[356], &gn_RMAP_NODE[357], &gn_RMAP_NODE[358], &gn_RMAP_NODE[359], &gn_RMAP_NODE[360], &gn_RMAP_NODE[361], &gn_RMAP_NODE[362], &gn_RMAP_NODE[363], &gn_RMAP_NODE[364], &gn_RMAP_NODE[365], &gn_RMAP_NODE[366], &gn_RMAP_NODE[367], &gn_RMAP_NODE[368], &gn_RMAP_NODE[369], &gn_RMAP_NODE[370], &gn_RMAP_NODE[371], &gn_RMAP_NODE[372], &gn_RMAP_NODE[373], &gn_RMAP_NODE[374], &gn_RMAP_NODE[375], &gn_RMAP_NODE[376], &gn_RMAP_NODE[377], &gn_RMAP_NODE[378], &gn_RMAP_NODE[379], &gn_RMAP_NODE[380], &gn_RMAP_NODE[381], &gn_RMAP_NODE[382], &gn_RMAP_NODE[383], &gn_RMAP_NODE[384], &gn_RMAP_NODE[385], &gn_RMAP_NODE[386], &gn_RMAP_NODE[387], &gn_RMAP_NODE[388], &gn_RMAP_NODE[389], &gn_RMAP_NODE[390], &gn_RMAP_NODE[391], &gn_RMAP_NODE[392], &gn_RMAP_NODE[393], &gn_RMAP_NODE[394], &gn_RMAP_NODE[395], &gn_RMAP_NODE[396], &gn_RMAP_NODE[397], &gn_RMAP_NODE[398], &gn_RMAP_NODE[399], &gn_RMAP_NODE[400], &gn_RMAP_NODE[401], &gn_RMAP_NODE[402], &gn_RMAP_NODE[403], &gn_RMAP_NODE[404], &gn_RMAP_NODE[405], &gn_RMAP_NODE[406], &gn_RMAP_NODE[407], &gn_RMAP_NODE[408], &gn_RMAP_NODE[409], &gn_RMAP_NODE[410], &gn_RMAP_NODE[411], &gn_RMAP_NODE[412], &gn_RMAP_NODE[413], &gn_RMAP_NODE[414], &gn_RMAP_NODE[415], &gn_RMAP_NODE[416], &gn_RMAP_NODE[417], &gn_RMAP_NODE[418], &gn_RMAP_NODE[419], &gn_RMAP_NODE[420], &gn_RMAP_NODE[421], &gn_RMAP_NODE[422], &gn_RMAP_NODE[423], &gn_RMAP_NODE[424], &gn_RMAP_NODE[425], &gn_RMAP_NODE[426], &gn_RMAP_NODE[427], &gn_RMAP_NODE[428], &gn_RMAP_NODE[429], &gn_RMAP_NODE[430], &gn_RMAP_NODE[431], &gn_RMAP_NODE[432], &gn_RMAP_NODE[433], &gn_RMAP_NODE[434], &gn_RMAP_NODE[435], &gn_RMAP_NODE[436], &gn_RMAP_NODE[437], &gn_RMAP_NODE[438], &gn_RMAP_NODE[439], &gn_RMAP_NODE[440], &gn_RMAP_NODE[441], &gn_RMAP_NODE[442], &gn_RMAP_NODE[443], &gn_RMAP_NODE[444], &gn_RMAP_NODE[445], &gn_RMAP_NODE[446], &gn_RMAP_NODE[447], &gn_RMAP_NODE[448], &gn_RMAP_NODE[449], &gn_RMAP_NODE[450], &gn_RMAP_NODE[451], &gn_RMAP_NODE[452], &gn_RMAP_NODE[453], &gn_RMAP_NODE[454], &gn_RMAP_NODE[455], &gn_RMAP_NODE[456], &gn_RMAP_NODE[457], &gn_RMAP_NODE[458], &gn_RMAP_NODE[459], &gn_RMAP_NODE[460], &gn_RMAP_NODE[461], &gn_RMAP_NODE[462], &gn_RMAP_NODE[463], &gn_RMAP_NODE[464], &gn_RMAP_NODE[465], &gn_RMAP_NODE[466], &gn_RMAP_NODE[467], &gn_RMAP_NODE[468], &gn_RMAP_NODE[469], &gn_RMAP_NODE[470], &gn_RMAP_NODE[471], &gn_RMAP_NODE[472], &gn_RMAP_NODE[473], &gn_RMAP_NODE[474], &gn_RMAP_NODE[475], &gn_RMAP_NODE[476], &gn_RMAP_NODE[477], &gn_RMAP_NODE[478], &gn_RMAP_NODE[479], &gn_RMAP_NODE[480], &gn_RMAP_NODE[481], &gn_RMAP_NODE[482], &gn_RMAP_NODE[483], &gn_RMAP_NODE[484], &gn_RMAP_NODE[485], &gn_RMAP_NODE[486], &gn_RMAP_NODE[487], &gn_RMAP_NODE[488], &gn_RMAP_NODE[489], &gn_RMAP_NODE[490], &gn_RMAP_NODE[491], &gn_RMAP_NODE[492], &gn_RMAP_NODE[493], &gn_RMAP_NODE[494], &gn_RMAP_NODE[495], &gn_RMAP_NODE[496], &gn_RMAP_NODE[497], &gn_RMAP_NODE[498], &gn_RMAP_NODE[499], &gn_RMAP_NODE[500], &gn_RMAP_NODE[501], &gn_RMAP_NODE[502], &gn_RMAP_NODE[503], &gn_RMAP_NODE[504], &gn_RMAP_NODE[505], &gn_RMAP_NODE[506], &gn_RMAP_NODE[507], &gn_RMAP_NODE[508], &gn_RMAP_NODE[509], &gn_RMAP_NODE[510], &gn_RMAP_NODE[511], &gn_RMAP_NODE[512], &gn_RMAP_NODE[513], &gn_RMAP_NODE[514], &gn_RMAP_NODE[515], &gn_RMAP_NODE[516], &gn_RMAP_NODE[517], &gn_RMAP_NODE[518], &gn_RMAP_NODE[519], &gn_RMAP_NODE[520], &gn_RMAP_NODE[521], &gn_RMAP_NODE[522], &gn_RMAP_NODE[523], &gn_RMAP_NODE[524], &gn_RMAP_NODE[525], &gn_RMAP_NODE[526], &gn_RMAP_NODE[527], &gn_RMAP_NODE[528], &gn_RMAP_NODE[529], &gn_RMAP_NODE[530], &gn_RMAP_NODE[531], &gn_RMAP_NODE[532], &gn_RMAP_NODE[533], &gn_RMAP_NODE[534], &gn_RMAP_NODE[535], &gn_RMAP_NODE[536], &gn_RMAP_NODE[537], &gn_RMAP_NODE[538], &gn_RMAP_NODE[539], &gn_RMAP_NODE[540], &gn_RMAP_NODE[541], &gn_RMAP_NODE[542], &gn_RMAP_NODE[543], &gn_RMAP_NODE[544], &gn_RMAP_NODE[545], &gn_RMAP_NODE[546], &gn_RMAP_NODE[547], &gn_RMAP_NODE[548], &gn_RMAP_NODE[549], &gn_RMAP_NODE[550], &gn_RMAP_NODE[551], &gn_RMAP_NODE[552], &gn_RMAP_NODE[553], &gn_RMAP_NODE[554], &gn_RMAP_NODE[555], &gn_RMAP_NODE[556], &gn_RMAP_NODE[557], &gn_RMAP_NODE[558], &gn_RMAP_NODE[559], &gn_RMAP_NODE[560], &gn_RMAP_NODE[561], &gn_RMAP_NODE[562], &gn_RMAP_NODE[563], &gn_RMAP_NODE[564], &gn_RMAP_NODE[565], &gn_RMAP_NODE[566], &gn_RMAP_NODE[567], &gn_RMAP_NODE[568], &gn_RMAP_NODE[569], &gn_RMAP_NODE[570], &gn_RMAP_NODE[571], &gn_RMAP_NODE[572], &gn_RMAP_NODE[573], &gn_RMAP_NODE[574], &gn_RMAP_NODE[575], &gn_RMAP_NODE[576], &gn_RMAP_NODE[577], &gn_RMAP_NODE[578], &gn_RMAP_NODE[579], &gn_RMAP_NODE[580], &gn_RMAP_NODE[581], &gn_RMAP_NODE[582], &gn_RMAP_NODE[583], &gn_RMAP_NODE[584], &gn_RMAP_NODE[585], &gn_RMAP_NODE[586], &gn_RMAP_NODE[587], &gn_RMAP_NODE[588], &gn_RMAP_NODE[589], &gn_RMAP_NODE[590], &gn_RMAP_NODE[591], &gn_RMAP_NODE[592], &gn_RMAP_NODE[593], &gn_RMAP_NODE[594], &gn_RMAP_NODE[595], &gn_RMAP_NODE[596], &gn_RMAP_NODE[597], &gn_RMAP_NODE[598], &gn_RMAP_NODE[599], &gn_RMAP_NODE[600], &gn_RMAP_NODE[601], &gn_RMAP_NODE[602], &gn_RMAP_NODE[603], &gn_RMAP_NODE[604], &gn_RMAP_NODE[605], &gn_RMAP_NODE[606], &gn_RMAP_NODE[607], &gn_RMAP_NODE[608], &gn_RMAP_NODE[609], &gn_RMAP_NODE[610], &gn_RMAP_NODE[611], &gn_RMAP_NODE[612], &gn_RMAP_NODE[613], &gn_RMAP_NODE[614], &gn_RMAP_NODE[615], &gn_RMAP_NODE[616], &gn_RMAP_NODE[617], &gn_RMAP_NODE[618], &gn_RMAP_NODE[619], &gn_RMAP_NODE[620], &gn_RMAP_NODE[621], &gn_RMAP_NODE[622], &gn_RMAP_NODE[623], &gn_RMAP_NODE[624], &gn_RMAP_NODE[625], &gn_RMAP_NODE[626], &gn_RMAP_NODE[627], &gn_RMAP_NODE[628], &gn_RMAP_NODE[629], &gn_RMAP_NODE[630], &gn_RMAP_NODE[631], &gn_RMAP_NODE[632], &gn_RMAP_NODE[633], &gn_RMAP_NODE[634], &gn_RMAP_NODE[635], &gn_RMAP_NODE[636], &gn_RMAP_NODE[637], &gn_RMAP_NODE[638], &gn_RMAP_NODE[639], &gn_RMAP_NODE[640], &gn_RMAP_NODE[641], &gn_RMAP_NODE[642], &gn_RMAP_NODE[643], &gn_RMAP_NODE[644], &gn_RMAP_NODE[645], &gn_RMAP_NODE[646], &gn_RMAP_NODE[647], &gn_RMAP_NODE[648], &gn_RMAP_NODE[649], &gn_RMAP_NODE[650], &gn_RMAP_NODE[651], &gn_RMAP_NODE[652], &gn_RMAP_NODE[653], &gn_RMAP_NODE[654], &gn_RMAP_NODE[655], &gn_RMAP_NODE[656], &gn_RMAP_NODE[657], &gn_RMAP_NODE[658], &gn_RMAP_NODE[659], &gn_RMAP_NODE[660], &gn_RMAP_NODE[661], &gn_RMAP_NODE[662], &gn_RMAP_NODE[663], &gn_RMAP_NODE[664], &gn_RMAP_NODE[665], &gn_RMAP_NODE[666], &gn_RMAP_NODE[667], &gn_RMAP_NODE[668], &gn_RMAP_NODE[669], &gn_RMAP_NODE[670], &gn_RMAP_NODE[671], &gn_RMAP_NODE[672], &gn_RMAP_NODE[673], &gn_RMAP_NODE[674], &gn_RMAP_NODE[675], &gn_RMAP_NODE[676], &gn_RMAP_NODE[677], &gn_RMAP_NODE[678], &gn_RMAP_NODE[679], &gn_RMAP_NODE[680], &gn_RMAP_NODE[681], &gn_RMAP_NODE[682], &gn_RMAP_NODE[683], &gn_RMAP_NODE[684], &gn_RMAP_NODE[685], &gn_RMAP_NODE[686], &gn_RMAP_NODE[687], &gn_RMAP_NODE[688], &gn_RMAP_NODE[689], &gn_RMAP_NODE[690], &gn_RMAP_NODE[691], &gn_RMAP_NODE[692], &gn_RMAP_NODE[693], &gn_RMAP_NODE[694], &gn_RMAP_NODE[695], &gn_RMAP_NODE[696], &gn_RMAP_NODE[697], &gn_RMAP_NODE[698], &gn_RMAP_NODE[699], &gn_RMAP_NODE[700], &gn_RMAP_NODE[701], &gn_RMAP_NODE[702], &gn_RMAP_NODE[703], &gn_RMAP_NODE[704], &gn_RMAP_NODE[705], &gn_RMAP_NODE[706], &gn_RMAP_NODE[707], &gn_RMAP_NODE[708], &gn_RMAP_NODE[709], &gn_RMAP_NODE[710], &gn_RMAP_NODE[711], &gn_RMAP_NODE[712], &gn_RMAP_NODE[713], &gn_RMAP_NODE[714], &gn_RMAP_NODE[715], &gn_RMAP_NODE[716], &gn_RMAP_NODE[717], &gn_RMAP_NODE[718], &gn_RMAP_NODE[719], &gn_RMAP_NODE[720], &gn_RMAP_NODE[721], &gn_RMAP_NODE[722], &gn_RMAP_NODE[723], &gn_RMAP_NODE[724], &gn_RMAP_NODE[725], &gn_RMAP_NODE[726], &gn_RMAP_NODE[727], &gn_RMAP_NODE[728], &gn_RMAP_NODE[729], &gn_RMAP_NODE[730], &gn_RMAP_NODE[731], &gn_RMAP_NODE[732], &gn_RMAP_NODE[733], &gn_RMAP_NODE[734], &gn_RMAP_NODE[735], &gn_RMAP_NODE[736], &gn_RMAP_NODE[737], &gn_RMAP_NODE[738], &gn_RMAP_NODE[739], &gn_RMAP_NODE[740], &gn_RMAP_NODE[741], &gn_RMAP_NODE[742], &gn_RMAP_NODE[743], &gn_RMAP_NODE[744], &gn_RMAP_NODE[745], &gn_RMAP_NODE[746], &gn_RMAP_NODE[747], &gn_RMAP_NODE[748], &gn_RMAP_NODE[749], &gn_RMAP_NODE[750], &gn_RMAP_NODE[751], &gn_RMAP_NODE[752], &gn_RMAP_NODE[753], &gn_RMAP_NODE[754], &gn_RMAP_NODE[755], &gn_RMAP_NODE[756], &gn_RMAP_NODE[757], &gn_RMAP_NODE[758], &gn_RMAP_NODE[759], &gn_RMAP_NODE[760], &gn_RMAP_NODE[761], &gn_RMAP_NODE[762], &gn_RMAP_NODE[763], &gn_RMAP_NODE[764], &gn_RMAP_NODE[765], &gn_RMAP_NODE[766], &gn_RMAP_NODE[767], &gn_RMAP_NODE[768], &gn_RMAP_NODE[769], &gn_RMAP_NODE[770], &gn_RMAP_NODE[771], &gn_RMAP_NODE[772], &gn_RMAP_NODE[773], &gn_RMAP_NODE[774], &gn_RMAP_NODE[775], &gn_RMAP_NODE[776], &gn_RMAP_NODE[777], &gn_RMAP_NODE[778], &gn_RMAP_NODE[779], &gn_RMAP_NODE[780], &gn_RMAP_NODE[781], &gn_RMAP_NODE[782], &gn_RMAP_NODE[783], &gn_RMAP_NODE[784], &gn_RMAP_NODE[785], &gn_RMAP_NODE[786], &gn_RMAP_NODE[787], &gn_RMAP_NODE[788], &gn_RMAP_NODE[789], &gn_RMAP_NODE[790], &gn_RMAP_NODE[791], &gn_RMAP_NODE[792], &gn_RMAP_NODE[793], &gn_RMAP_NODE[794], &gn_RMAP_NODE[795], &gn_RMAP_NODE[796], &gn_RMAP_NODE[797], &gn_RMAP_NODE[798], &gn_RMAP_NODE[799], &gn_RMAP_NODE[800], &gn_RMAP_NODE[801], &gn_RMAP_NODE[802], &gn_RMAP_NODE[803], &gn_RMAP_NODE[804], &gn_RMAP_NODE[805], &gn_RMAP_NODE[806], &gn_RMAP_NODE[807], &gn_RMAP_NODE[808], &gn_RMAP_NODE[809], &gn_RMAP_NODE[810], &gn_RMAP_NODE[811], &gn_RMAP_NODE[812], &gn_RMAP_NODE[813], &gn_RMAP_NODE[814], &gn_RMAP_NODE[815], &gn_RMAP_NODE[816], &gn_RMAP_NODE[817], &gn_RMAP_NODE[818], &gn_RMAP_NODE[819], &gn_RMAP_NODE[820], &gn_RMAP_NODE[821], &gn_RMAP_NODE[822], &gn_RMAP_NODE[823], &gn_RMAP_NODE[824], &gn_RMAP_NODE[825], &gn_RMAP_NODE[826], &gn_RMAP_NODE[827], &gn_RMAP_NODE[828], &gn_RMAP_NODE[829], &gn_RMAP_NODE[830], &gn_RMAP_NODE[831], &gn_RMAP_NODE[832], &gn_RMAP_NODE[833], &gn_RMAP_NODE[834], &gn_RMAP_NODE[835], &gn_RMAP_NODE[836], &gn_RMAP_NODE[837], &gn_RMAP_NODE[838], &gn_RMAP_NODE[839], &gn_RMAP_NODE[840], &gn_RMAP_NODE[841], &gn_RMAP_NODE[842], &gn_RMAP_NODE[843], &gn_RMAP_NODE[844], &gn_RMAP_NODE[845], &gn_RMAP_NODE[846], &gn_RMAP_NODE[847], &gn_RMAP_NODE[848], &gn_RMAP_NODE[849], &gn_RMAP_NODE[850], &gn_RMAP_NODE[851], &gn_RMAP_NODE[852], &gn_RMAP_NODE[853], &gn_RMAP_NODE[854], &gn_RMAP_NODE[855], &gn_RMAP_NODE[856], &gn_RMAP_NODE[857], &gn_RMAP_NODE[858], &gn_RMAP_NODE[859], &gn_RMAP_NODE[860], &gn_RMAP_NODE[861], &gn_RMAP_NODE[862], &gn_RMAP_NODE[863], &gn_RMAP_NODE[864], &gn_RMAP_NODE[865], &gn_RMAP_NODE[866], &gn_RMAP_NODE[867], &gn_RMAP_NODE[868], &gn_RMAP_NODE[869], &gn_RMAP_NODE[870], &gn_RMAP_NODE[871], &gn_RMAP_NODE[872], &gn_RMAP_NODE[873], &gn_RMAP_NODE[874], &gn_RMAP_NODE[875], &gn_RMAP_NODE[876], &gn_RMAP_NODE[877], &gn_RMAP_NODE[878], &gn_RMAP_NODE[879], &gn_RMAP_NODE[880], &gn_RMAP_NODE[881], &gn_RMAP_NODE[882], &gn_RMAP_NODE[883], &gn_RMAP_NODE[884], &gn_RMAP_NODE[885], &gn_RMAP_NODE[886], &gn_RMAP_NODE[887], &gn_RMAP_NODE[888], &gn_RMAP_NODE[889], &gn_RMAP_NODE[890], &gn_RMAP_NODE[891], &gn_RMAP_NODE[892], &gn_RMAP_NODE[893], &gn_RMAP_NODE[894], &gn_RMAP_NODE[895], &gn_RMAP_NODE[896], &gn_RMAP_NODE[897], &gn_RMAP_NODE[898], &gn_RMAP_NODE[899], &gn_RMAP_NODE[900], &gn_RMAP_NODE[901], &gn_RMAP_NODE[902], &gn_RMAP_NODE[903], &gn_RMAP_NODE[904], &gn_RMAP_NODE[905], &gn_RMAP_NODE[906], &gn_RMAP_NODE[907], &gn_RMAP_NODE[908], &gn_RMAP_NODE[909], &gn_RMAP_NODE[910], &gn_RMAP_NODE[911], &gn_RMAP_NODE[912], &gn_RMAP_NODE[913], &gn_RMAP_NODE[914], &gn_RMAP_NODE[915], &gn_RMAP_NODE[916], &gn_RMAP_NODE[917], &gn_RMAP_NODE[918], &gn_RMAP_NODE[919], &gn_RMAP_NODE[920], &gn_RMAP_NODE[921], &gn_RMAP_NODE[922], &gn_RMAP_NODE[923], &gn_RMAP_NODE[924], &gn_RMAP_NODE[925], &gn_RMAP_NODE[926], &gn_RMAP_NODE[927], &gn_RMAP_NODE[928], &gn_RMAP_NODE[929], &gn_RMAP_NODE[930], &gn_RMAP_NODE[931], &gn_RMAP_NODE[932], &gn_RMAP_NODE[933], &gn_RMAP_NODE[934], &gn_RMAP_NODE[935], &gn_RMAP_NODE[936], &gn_RMAP_NODE[937], &gn_RMAP_NODE[938], &gn_RMAP_NODE[939], &gn_RMAP_NODE[940], &gn_RMAP_NODE[941], &gn_RMAP_NODE[942], &gn_RMAP_NODE[943], &gn_RMAP_NODE[944], &gn_RMAP_NODE[945], &gn_RMAP_NODE[946], &gn_RMAP_NODE[947], &gn_RMAP_NODE[948], &gn_RMAP_NODE[949], &gn_RMAP_NODE[950], &gn_RMAP_NODE[951], &gn_RMAP_NODE[952], &gn_RMAP_NODE[953], &gn_RMAP_NODE[954], &gn_RMAP_NODE[955], &gn_RMAP_NODE[956], &gn_RMAP_NODE[957], &gn_RMAP_NODE[958], &gn_RMAP_NODE[959], &gn_RMAP_NODE[960], &gn_RMAP_NODE[961], &gn_RMAP_NODE[962], &gn_RMAP_NODE[963], &gn_RMAP_NODE[964], &gn_RMAP_NODE[965], &gn_RMAP_NODE[966], &gn_RMAP_NODE[967], &gn_RMAP_NODE[968], &gn_RMAP_NODE[969], &gn_RMAP_NODE[970], &gn_RMAP_NODE[971], &gn_RMAP_NODE[972], &gn_RMAP_NODE[973], &gn_RMAP_NODE[974], &gn_RMAP_NODE[975], &gn_RMAP_NODE[976], &gn_RMAP_NODE[977], &gn_RMAP_NODE[978], &gn_RMAP_NODE[979], &gn_RMAP_NODE[980], &gn_RMAP_NODE[981], &gn_RMAP_NODE[982], &gn_RMAP_NODE[983], &gn_RMAP_NODE[984], &gn_RMAP_NODE[985], &gn_RMAP_NODE[986], &gn_RMAP_NODE[987], &gn_RMAP_NODE[988], &gn_RMAP_NODE[989], &gn_RMAP_NODE[990], &gn_RMAP_NODE[991], &gn_RMAP_NODE[992], &gn_RMAP_NODE[993], &gn_RMAP_NODE[994], &gn_RMAP_NODE[995], &gn_RMAP_NODE[996], &gn_RMAP_NODE[997], &gn_RMAP_NODE[998], &gn_RMAP_NODE[999], &gn_RMAP_NODE[1000], &gn_RMAP_NODE[1001], &gn_RMAP_NODE[1002], &gn_RMAP_NODE[1003], &gn_RMAP_NODE[1004], &gn_RMAP_NODE[1005], &gn_RMAP_NODE[1006], &gn_RMAP_NODE[1007], &gn_RMAP_NODE[1008], &gn_RMAP_NODE[1009], &gn_RMAP_NODE[1010], &gn_RMAP_NODE[1011], &gn_RMAP_NODE[1012], &gn_RMAP_NODE[1013], &gn_RMAP_NODE[1014], &gn_RMAP_NODE[1015], &gn_RMAP_NODE[1016], &gn_RMAP_NODE[1017], &gn_RMAP_NODE[1018], &gn_RMAP_NODE[1019], &gn_RMAP_NODE[1020], &gn_RMAP_NODE[1021], &gn_RMAP_NODE[1022], &gn_RMAP_NODE[1023], &gn_RMAP_NODE[1024], &gn_RMAP_NODE[1025], &gn_RMAP_NODE[1026], &gn_RMAP_NODE[1027], &gn_RMAP_NODE[1028], &gn_RMAP_NODE[1029], &gn_RMAP_NODE[1030], &gn_RMAP_NODE[1031], &gn_RMAP_NODE[1032], &gn_RMAP_NODE[1033], &gn_RMAP_NODE[1034], &gn_RMAP_NODE[1035], &gn_RMAP_NODE[1036], &gn_RMAP_NODE[1037], &gn_RMAP_NODE[1038], &gn_RMAP_NODE[1039], &gn_RMAP_NODE[1040], &gn_RMAP_NODE[1041], &gn_RMAP_NODE[1042], &gn_RMAP_NODE[1043], &gn_RMAP_NODE[1044], &gn_RMAP_NODE[1045], &gn_RMAP_NODE[1046], &gn_RMAP_NODE[1047], &gn_RMAP_NODE[1048], &gn_RMAP_NODE[1049], &gn_RMAP_NODE[1050], &gn_RMAP_NODE[1051], &gn_RMAP_NODE[1052], &gn_RMAP_NODE[1053], &gn_RMAP_NODE[1054], &gn_RMAP_NODE[1055], &gn_RMAP_NODE[1056], &gn_RMAP_NODE[1057], &gn_RMAP_NODE[1058], &gn_RMAP_NODE[1059], &gn_RMAP_NODE[1060], &gn_RMAP_NODE[1061], &gn_RMAP_NODE[1062], &gn_RMAP_NODE[1063], &gn_RMAP_NODE[1064], &gn_RMAP_NODE[1065], &gn_RMAP_NODE[1066], &gn_RMAP_NODE[1067], &gn_RMAP_NODE[1068], &gn_RMAP_NODE[1069], &gn_RMAP_NODE[1070], &gn_RMAP_NODE[1071], &gn_RMAP_NODE[1072], &gn_RMAP_NODE[1073], &gn_RMAP_NODE[1074], &gn_RMAP_NODE[1075], &gn_RMAP_NODE[1076], &gn_RMAP_NODE[1077], &gn_RMAP_NODE[1078], &gn_RMAP_NODE[1079], &gn_RMAP_NODE[1080], &gn_RMAP_NODE[1081], &gn_RMAP_NODE[1082], &gn_RMAP_NODE[1083], &gn_RMAP_NODE[1084], &gn_RMAP_NODE[1085], &gn_RMAP_NODE[1086], &gn_RMAP_NODE[1087], &gn_RMAP_NODE[1088], &gn_RMAP_NODE[1089], &gn_RMAP_NODE[1090], &gn_RMAP_NODE[1091], &gn_RMAP_NODE[1092], &gn_RMAP_NODE[1093], &gn_RMAP_NODE[1094], &gn_RMAP_NODE[1095], &gn_RMAP_NODE[1096], &gn_RMAP_NODE[1097], &gn_RMAP_NODE[1098], &gn_RMAP_NODE[1099], &gn_RMAP_NODE[1100], &gn_RMAP_NODE[1101], &gn_RMAP_NODE[1102], &gn_RMAP_NODE[1103], &gn_RMAP_NODE[1104], &gn_RMAP_NODE[1105], &gn_RMAP_NODE[1106], &gn_RMAP_NODE[1107], &gn_RMAP_NODE[1108], &gn_RMAP_NODE[1109], &gn_RMAP_NODE[1110], &gn_RMAP_NODE[1111], &gn_RMAP_NODE[1112], &gn_RMAP_NODE[1113], &gn_RMAP_NODE[1114], &gn_RMAP_NODE[1115], &gn_RMAP_NODE[1116], &gn_RMAP_NODE[1117], &gn_RMAP_NODE[1118], &gn_RMAP_NODE[1119], &gn_RMAP_NODE[1120], &gn_RMAP_NODE[1121], &gn_RMAP_NODE[1122], &gn_RMAP_NODE[1123], &gn_RMAP_NODE[1124], &gn_RMAP_NODE[1125], &gn_RMAP_NODE[1126], &gn_RMAP_NODE[1127], &gn_RMAP_NODE[1128], &gn_RMAP_NODE[1129], &gn_RMAP_NODE[1130], &gn_RMAP_NODE[1131], &gn_RMAP_NODE[1132], &gn_RMAP_NODE[1133], &gn_RMAP_NODE[1134], &gn_RMAP_NODE[1135], &gn_RMAP_NODE[1136], &gn_RMAP_NODE[1137], &gn_RMAP_NODE[1138], &gn_RMAP_NODE[1139], &gn_RMAP_NODE[1140], &gn_RMAP_NODE[1141], &gn_RMAP_NODE[1142], &gn_RMAP_NODE[1143], &gn_RMAP_NODE[1144], &gn_RMAP_NODE[1145], &gn_RMAP_NODE[1146], &gn_RMAP_NODE[1147], &gn_RMAP_NODE[1148], &gn_RMAP_NODE[1149], &gn_RMAP_NODE[1150], &gn_RMAP_NODE[1151], &gn_RMAP_NODE[1152], &gn_RMAP_NODE[1153], &gn_RMAP_NODE[1154], &gn_RMAP_NODE[1155], &gn_RMAP_NODE[1156], &gn_RMAP_NODE[1157], &gn_RMAP_NODE[1158], &gn_RMAP_NODE[1159], &gn_RMAP_NODE[1160], &gn_RMAP_NODE[1161], &gn_RMAP_NODE[1162], &gn_RMAP_NODE[1163], &gn_RMAP_NODE[1164], &gn_RMAP_NODE[1165], &gn_RMAP_NODE[1166], &gn_RMAP_NODE[1167], &gn_RMAP_NODE[1168], &gn_RMAP_NODE[1169], &gn_RMAP_NODE[1170], &gn_RMAP_NODE[1171], &gn_RMAP_NODE[1172], &gn_RMAP_NODE[1173], &gn_RMAP_NODE[1174], &gn_RMAP_NODE[1175], &gn_RMAP_NODE[1176], &gn_RMAP_NODE[1177], &gn_RMAP_NODE[1178], &gn_RMAP_NODE[1179], &gn_RMAP_NODE[1180], &gn_RMAP_NODE[1181], &gn_RMAP_NODE[1182], &gn_RMAP_NODE[1183], &gn_RMAP_NODE[1184], &gn_RMAP_NODE[1185], &gn_RMAP_NODE[1186], &gn_RMAP_NODE[1187], &gn_RMAP_NODE[1188], &gn_RMAP_NODE[1189], &gn_RMAP_NODE[1190], &gn_RMAP_NODE[1191], &gn_RMAP_NODE[1192], &gn_RMAP_NODE[1193], &gn_RMAP_NODE[1194], &gn_RMAP_NODE[1195], &gn_RMAP_NODE[1196], &gn_RMAP_NODE[1197], &gn_RMAP_NODE[1198], &gn_RMAP_NODE[1199], &gn_RMAP_NODE[1200], &gn_RMAP_NODE[1201], &gn_RMAP_NODE[1202], &gn_RMAP_NODE[1203], &gn_RMAP_NODE[1204], &gn_RMAP_NODE[1205], &gn_RMAP_NODE[1206], &gn_RMAP_NODE[1207], &gn_RMAP_NODE[1208], &gn_RMAP_NODE[1209], &gn_RMAP_NODE[1210], &gn_RMAP_NODE[1211], &gn_RMAP_NODE[1212], &gn_RMAP_NODE[1213], &gn_RMAP_NODE[1214], &gn_RMAP_NODE[1215], &gn_RMAP_NODE[1216], &gn_RMAP_NODE[1217], &gn_RMAP_NODE[1218], &gn_RMAP_NODE[1219], &gn_RMAP_NODE[1220], &gn_RMAP_NODE[1221], &gn_RMAP_NODE[1222], &gn_RMAP_NODE[1223], &gn_RMAP_NODE[1224], &gn_RMAP_NODE[1225], &gn_RMAP_NODE[1226], &gn_RMAP_NODE[1227], &gn_RMAP_NODE[1228], &gn_RMAP_NODE[1229], &gn_RMAP_NODE[1230], &gn_RMAP_NODE[1231], &gn_RMAP_NODE[1232], &gn_RMAP_NODE[1233], &gn_RMAP_NODE[1234], &gn_RMAP_NODE[1235], &gn_RMAP_NODE[1236], &gn_RMAP_NODE[1237], &gn_RMAP_NODE[1238], &gn_RMAP_NODE[1239], &gn_RMAP_NODE[1240], &gn_RMAP_NODE[1241], &gn_RMAP_NODE[1242], &gn_RMAP_NODE[1243], &gn_RMAP_NODE[1244], &gn_RMAP_NODE[1245], &gn_RMAP_NODE[1246], &gn_RMAP_NODE[1247], &gn_RMAP_NODE[1248], &gn_RMAP_NODE[1249], &gn_RMAP_NODE[1250], &gn_RMAP_NODE[1251], &gn_RMAP_NODE[1252], &gn_RMAP_NODE[1253], &gn_RMAP_NODE[1254], &gn_RMAP_NODE[1255], &gn_RMAP_NODE[1256], &gn_RMAP_NODE[1257], &gn_RMAP_NODE[1258], &gn_RMAP_NODE[1259], &gn_RMAP_NODE[1260], &gn_RMAP_NODE[1261], &gn_RMAP_NODE[1262], &gn_RMAP_NODE[1263], &gn_RMAP_NODE[1264], &gn_RMAP_NODE[1265], &gn_RMAP_NODE[1266], &gn_RMAP_NODE[1267], &gn_RMAP_NODE[1268], &gn_RMAP_NODE[1269], &gn_RMAP_NODE[1270], &gn_RMAP_NODE[1271], &gn_RMAP_NODE[1272], &gn_RMAP_NODE[1273], &gn_RMAP_NODE[1274], &gn_RMAP_NODE[1275], &gn_RMAP_NODE[1276], &gn_RMAP_NODE[1277]);

extern void install_RMAP_NODE(void);

void install_RMAP_NODE(void)

{
	unsigned node_id = RMAP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_RMAP_NODE;
	vector_set(node->cmd_vector, &match_alias_cmd_vtysh);
	vector_set(node->cmd_vector, &match_aspath_cmd_vtysh);
	vector_set(node->cmd_vector, &match_community_cmd_vtysh);
	vector_set(node->cmd_vector, &match_community_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ecommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &match_evpn_default_route_cmd_vtysh);
	vector_set(node->cmd_vector, &match_evpn_rd_cmd_vtysh);
	vector_set(node->cmd_vector, &match_evpn_route_type_cmd_vtysh);
	vector_set(node->cmd_vector, &match_evpn_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &match_extcommunity_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &match_interface_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_address_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_address_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_address_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_next_hop_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_next_hop_type_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_nexthop_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_route_source_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ip_route_source_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv4_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_address_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_address_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_address_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_next_hop_address_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_next_hop_old_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_next_hop_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &match_ipv6_next_hop_type_cmd_vtysh);
	vector_set(node->cmd_vector, &match_lcommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &match_local_pref_cmd_vtysh);
	vector_set(node->cmd_vector, &match_mac_address_cmd_vtysh);
	vector_set(node->cmd_vector, &match_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &match_origin_cmd_vtysh);
	vector_set(node->cmd_vector, &match_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &match_peer_local_cmd_vtysh);
	vector_set(node->cmd_vector, &match_probability_cmd_vtysh);
	vector_set(node->cmd_vector, &match_rpki_cmd_vtysh);
	vector_set(node->cmd_vector, &match_rpki_extcommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &match_script_cmd_vtysh);
	vector_set(node->cmd_vector, &match_source_instance_cmd_vtysh);
	vector_set(node->cmd_vector, &match_source_protocol_cmd_vtysh);
	vector_set(node->cmd_vector, &match_src_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &match_tag_cmd_vtysh);
	vector_set(node->cmd_vector, &match_vrl_source_vrf_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_alias_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_aspath_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_community_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ecommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_evpn_default_route_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_evpn_rd_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_evpn_route_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_evpn_vni_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_interface_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_address_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_address_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_address_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_next_hop_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_next_hop_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_nexthop_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_route_source_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ip_route_source_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv4_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_address_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_address_prefix_len_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_address_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_next_hop_address_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_next_hop_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_next_hop_old_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_next_hop_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_ipv6_next_hop_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_lcommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_local_pref_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_mac_address_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_origin_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_probability_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_rpki_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_source_instance_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_source_protocol_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_src_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_tag_cmd_vtysh);
	vector_set(node->cmd_vector, &no_match_vrl_source_vrf_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rmap_call_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rmap_continue_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rmap_description_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rmap_onmatch_goto_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rmap_onmatch_next_cmd_vtysh);
	vector_set(node->cmd_vector, &no_route_map_match_address_cmd_vtysh);
	vector_set(node->cmd_vector, &no_route_map_match_address_v6_cmd_vtysh);
	vector_set(node->cmd_vector, &no_route_map_match_interface_cmd_vtysh);
	vector_set(node->cmd_vector, &no_route_map_match_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_route_map_match_prefix_list_v6_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aggregator_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aigp_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_exclude_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_exclude_all_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_exclude_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_prepend_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_prepend_last_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_replace_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_aspath_replace_asn_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_atomic_aggregate_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_community_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_community_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_community_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_color_all_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_color_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_lb_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_lb_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_none_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_nt_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_nt_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_rt_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_rt_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ecommunity_soo_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_evpn_gw_ip_ipv4_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_evpn_gw_ip_ipv6_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ip_nexthop_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ipv6_nexthop_global_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ipv6_nexthop_local_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ipv6_nexthop_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ipv6_nexthop_prefer_global_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_ipx_vpn_nexthop_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_label_index_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_lcommunity1_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_lcommunity1_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_lcommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_lcommunity_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_lcommunity_delete_short_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_local_pref_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_max_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_metric_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_min_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_origin_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_originator_id_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_src_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_srte_color_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_table_id_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_tag_cmd_vtysh);
	vector_set(node->cmd_vector, &no_set_weight_cmd_vtysh);
	vector_set(node->cmd_vector, &ospf6_routemap_no_set_forwarding_cmd_vtysh);
	vector_set(node->cmd_vector, &ospf6_routemap_set_forwarding_cmd_vtysh);
	vector_set(node->cmd_vector, &rmap_call_cmd_vtysh);
	vector_set(node->cmd_vector, &rmap_continue_cmd_vtysh);
	vector_set(node->cmd_vector, &rmap_description_cmd_vtysh);
	vector_set(node->cmd_vector, &rmap_onmatch_goto_cmd_vtysh);
	vector_set(node->cmd_vector, &rmap_onmatch_next_cmd_vtysh);
	vector_set(node->cmd_vector, &route_map_match_address_cmd_vtysh);
	vector_set(node->cmd_vector, &route_map_match_address_v6_cmd_vtysh);
	vector_set(node->cmd_vector, &route_map_match_interface_cmd_vtysh);
	vector_set(node->cmd_vector, &route_map_match_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &route_map_match_prefix_list_v6_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aggregator_as_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aigp_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_exclude_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_exclude_all_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_exclude_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_prepend_asn_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_prepend_lastas_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_replace_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &set_aspath_replace_asn_cmd_vtysh);
	vector_set(node->cmd_vector, &set_atomic_aggregate_cmd_vtysh);
	vector_set(node->cmd_vector, &set_community_cmd_vtysh);
	vector_set(node->cmd_vector, &set_community_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &set_community_none_cmd_vtysh);
	vector_set(node->cmd_vector, &set_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_color_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_lb_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_none_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_nt_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_rt_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ecommunity_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &set_evpn_gw_ip_ipv4_cmd_vtysh);
	vector_set(node->cmd_vector, &set_evpn_gw_ip_ipv6_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ip_nexthop_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ip_nexthop_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ip_nexthop_unchanged_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ipv6_nexthop_global_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ipv6_nexthop_local_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ipv6_nexthop_peer_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ipv6_nexthop_prefer_global_cmd_vtysh);
	vector_set(node->cmd_vector, &set_ipx_vpn_nexthop_cmd_vtysh);
	vector_set(node->cmd_vector, &set_l3vpn_nexthop_encapsulation_cmd_vtysh);
	vector_set(node->cmd_vector, &set_label_index_cmd_vtysh);
	vector_set(node->cmd_vector, &set_lcommunity_cmd_vtysh);
	vector_set(node->cmd_vector, &set_lcommunity_delete_cmd_vtysh);
	vector_set(node->cmd_vector, &set_lcommunity_none_cmd_vtysh);
	vector_set(node->cmd_vector, &set_local_pref_cmd_vtysh);
	vector_set(node->cmd_vector, &set_max_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &set_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &set_metric_type_cmd_vtysh);
	vector_set(node->cmd_vector, &set_min_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &set_origin_cmd_vtysh);
	vector_set(node->cmd_vector, &set_originator_id_cmd_vtysh);
	vector_set(node->cmd_vector, &set_src_cmd_vtysh);
	vector_set(node->cmd_vector, &set_srte_color_cmd_vtysh);
	vector_set(node->cmd_vector, &set_table_id_cmd_vtysh);
	vector_set(node->cmd_vector, &set_tag_cmd_vtysh);
	vector_set(node->cmd_vector, &set_weight_cmd_vtysh);
}

static struct cmd_token ctkn_BGP_VNC_NVE_GROUP_NODE[];
static struct graph_node gn_BGP_VNC_NVE_GROUP_NODE[];

static struct cmd_token ctkn_BGP_VNC_NVE_GROUP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"Export to other protocols",
	},
	{ /* [2] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[4],
	},
	{ /* [3] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"Export to BGP",
	},
	{ /* [4] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[2],
	},
	{ /* [5] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[7],
	},
	{ /* [6] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 routes",
	},
	{ /* [7] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[5],
	},
	{ /* [8] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Prefix-list for filtering exported routes",
	},
	{ /* [9] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"prefix list name",
		.varname = (char *)"prefix_list",
	},
	{ /* [10] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [11] = vnc_nve_group_export_prefixlist_cmd */ },
	{ /* [12] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 routes",
	},
	{ /* [13] */
		.type = WORD_TKN,
		.text = (char *)"zebra",
		.desc = (char *)"Export to Zebra (experimental)",
	},
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map for filtering exported routes",
	},
	{ /* [15] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"route map name",
		.varname = (char *)"route_map",
	},
	{ /* [16] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [17] = vnc_nve_group_export_routemap_cmd */ },
	{ /* [18] */
		.type = WORD_TKN,
		.text = (char *)"l2rd",
		.desc = (char *)"Specify default Local Nve ID value to use in RD for L2 routes",
	},
	{ /* [19] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[21],
	},
	{ /* [20] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Fixed value 1-255",
		.min = 1,
		.max = 255,
		.varname = (char *)"l2rd",
	},
	{ /* [21] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[19],
	},
	{ /* [22] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [23] = vnc_nve_group_l2rd_cmd */ },
	{ /* [24] */
		.type = WORD_TKN,
		.text = (char *)"auto-vn",
		.desc = (char *)"use the low-order octet of the NVE's VN address",
	},
	{ /* [25] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [26] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"Export to other protocols",
	},
	{ /* [27] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[29],
	},
	{ /* [28] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"Export to BGP",
	},
	{ /* [29] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[27],
	},
	{ /* [30] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[32],
	},
	{ /* [31] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 routes",
	},
	{ /* [32] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[30],
	},
	{ /* [33] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Prefix-list for filtering exported routes",
	},
	{ /* [34] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[36],
	},
	{ /* [35] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"prefix list name",
		.varname = (char *)"prefix_list",
	},
	{ /* [36] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[34],
	},
	{ /* [37] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [38] = vnc_nve_group_export_no_prefixlist_cmd */ },
	{ /* [39] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 routes",
	},
	{ /* [40] */
		.type = WORD_TKN,
		.text = (char *)"zebra",
		.desc = (char *)"Export to Zebra (experimental)",
	},
	{ /* [41] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map for filtering exported routes",
	},
	{ /* [42] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[44],
	},
	{ /* [43] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"route map name",
		.varname = (char *)"route_map",
	},
	{ /* [44] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[42],
	},
	{ /* [45] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [46] = vnc_nve_group_export_no_routemap_cmd */ },
	{ /* [47] */
		.type = WORD_TKN,
		.text = (char *)"l2rd",
		.desc = (char *)"Specify default Local Nve ID value to use in RD for L2 routes",
	},
	{ /* [48] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [49] = vnc_nve_group_no_l2rd_cmd */ },
	{ /* [50] */
		.type = WORD_TKN,
		.text = (char *)"redistribute",
		.desc = (char *)"Redistribute from other protocol",
	},
	{ /* [51] */
		.type = WORD_TKN,
		.text = (char *)"bgp-direct",
		.desc = (char *)"Redistribute from BGP directly",
	},
	{ /* [52] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[54],
	},
	{ /* [53] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 routes",
	},
	{ /* [54] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[52],
	},
	{ /* [55] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Prefix-list for filtering redistributed routes",
	},
	{ /* [56] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [57] = vnc_nve_group_redist_bgpdirect_no_prefixlist_cmd */ },
	{ /* [58] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 routes",
	},
	{ /* [59] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map for filtering redistributed routes",
	},
	{ /* [60] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [61] = vnc_nve_group_redist_bgpdirect_no_routemap_cmd */ },
	{ /* [62] */
		.type = WORD_TKN,
		.text = (char *)"prefix",
		.desc = (char *)"Specify prefixes matching NVE VN or UN interfaces",
	},
	{ /* [63] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[65],
	},
	{ /* [64] */
		.type = WORD_TKN,
		.text = (char *)"vn",
		.desc = (char *)"VN prefix",
	},
	{ /* [65] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[63],
	},
	{ /* [66] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[68],
	},
	{ /* [67] */
		.type = IPV4_PREFIX_TKN,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IPv4 prefix",
	},
	{ /* [68] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[66],
	},
	{ /* [69] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [70] = vnc_nve_group_prefix_cmd */ },
	{ /* [71] */
		.type = IPV6_PREFIX_TKN,
		.text = (char *)"X:X::X:X/M",
		.desc = (char *)"IPv6 prefix",
	},
	{ /* [72] */
		.type = WORD_TKN,
		.text = (char *)"un",
		.desc = (char *)"UN prefix",
	},
	{ /* [73] */
		.type = WORD_TKN,
		.text = (char *)"rd",
		.desc = (char *)"Specify route distinguisher",
	},
	{ /* [74] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"Route Distinguisher (<as-number>:<number> | <ip-address>:<number> | auto:vn:<number> )",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [75] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [76] = vnc_nve_group_rd_cmd */ },
	{ /* [77] */
		.type = WORD_TKN,
		.text = (char *)"redistribute",
		.desc = (char *)"Redistribute from other protocol",
	},
	{ /* [78] */
		.type = WORD_TKN,
		.text = (char *)"bgp-direct",
		.desc = (char *)"Redistribute from BGP directly",
	},
	{ /* [79] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[81],
	},
	{ /* [80] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"IPv4 routes",
	},
	{ /* [81] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[79],
	},
	{ /* [82] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Prefix-list for filtering redistributed routes",
	},
	{ /* [83] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"prefix list name",
		.varname = (char *)"prefix_list",
	},
	{ /* [84] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [85] = vnc_nve_group_redist_bgpdirect_prefixlist_cmd */ },
	{ /* [86] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 routes",
	},
	{ /* [87] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map for filtering exported routes",
	},
	{ /* [88] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"NAME",
		.desc = (char *)"route map name",
		.varname = (char *)"route_map",
	},
	{ /* [89] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [90] = vnc_nve_group_redist_bgpdirect_routemap_cmd */ },
	{ /* [91] */
		.type = WORD_TKN,
		.text = (char *)"response-lifetime",
		.desc = (char *)"Specify response lifetime",
	},
	{ /* [92] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[94],
	},
	{ /* [93] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"LIFETIME",
		.desc = (char *)"Response lifetime in seconds",
		.varname = (char *)"lifetime",
	},
	{ /* [94] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_NVE_GROUP_NODE[92],
	},
	{ /* [95] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [96] = vnc_nve_group_responselifetime_cmd */ },
	{ /* [97] */
		.type = WORD_TKN,
		.text = (char *)"infinite",
		.desc = (char *)"Infinite response lifetime",
	},
	{ /* [98] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Specify route targets",
	},
	{ /* [99] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Export+import filters",
	},
	{ /* [100] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)",
		.varname = (char *)"rtlist",
	},
	{ /* [101] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [102] = vnc_nve_group_rt_both_cmd */ },
	{ /* [103] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"Export filter",
	},
	{ /* [104] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)",
		.varname = (char *)"rtlist",
	},
	{ /* [105] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [106] = vnc_nve_group_rt_export_cmd */ },
	{ /* [107] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import filter",
	},
	{ /* [108] */
		.type = VARIABLE_TKN,
		.allowrepeat = true,
		.varname_src = 3,
		.text = (char *)"RTLIST",
		.desc = (char *)"Space separated route target list (A.B.C.D:MN|EF:OPQR|GHJK:MN)",
		.varname = (char *)"rtlist",
	},
	{ /* [109] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [110] = vnc_nve_group_rt_import_cmd */ },
};

extern struct cmd_element vnc_nve_group_export_no_prefixlist_cmd_vtysh;
extern struct cmd_element vnc_nve_group_export_no_routemap_cmd_vtysh;
extern struct cmd_element vnc_nve_group_export_prefixlist_cmd_vtysh;
extern struct cmd_element vnc_nve_group_export_routemap_cmd_vtysh;
extern struct cmd_element vnc_nve_group_l2rd_cmd_vtysh;
extern struct cmd_element vnc_nve_group_no_l2rd_cmd_vtysh;
extern struct cmd_element vnc_nve_group_prefix_cmd_vtysh;
extern struct cmd_element vnc_nve_group_rd_cmd_vtysh;
extern struct cmd_element vnc_nve_group_redist_bgpdirect_no_prefixlist_cmd_vtysh;
extern struct cmd_element vnc_nve_group_redist_bgpdirect_no_routemap_cmd_vtysh;
extern struct cmd_element vnc_nve_group_redist_bgpdirect_prefixlist_cmd_vtysh;
extern struct cmd_element vnc_nve_group_redist_bgpdirect_routemap_cmd_vtysh;
extern struct cmd_element vnc_nve_group_responselifetime_cmd_vtysh;
extern struct cmd_element vnc_nve_group_rt_both_cmd_vtysh;
extern struct cmd_element vnc_nve_group_rt_export_cmd_vtysh;
extern struct cmd_element vnc_nve_group_rt_import_cmd_vtysh;

MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_0_next, 8, &gn_BGP_VNC_NVE_GROUP_NODE[1], &gn_BGP_VNC_NVE_GROUP_NODE[18], &gn_BGP_VNC_NVE_GROUP_NODE[25], &gn_BGP_VNC_NVE_GROUP_NODE[62], &gn_BGP_VNC_NVE_GROUP_NODE[73], &gn_BGP_VNC_NVE_GROUP_NODE[77], &gn_BGP_VNC_NVE_GROUP_NODE[91], &gn_BGP_VNC_NVE_GROUP_NODE[98]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_1_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_1_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_2_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[3], &gn_BGP_VNC_NVE_GROUP_NODE[13]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_2_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[1]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_3_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[4]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_3_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_4_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[5], &gn_BGP_VNC_NVE_GROUP_NODE[14]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_4_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[3], &gn_BGP_VNC_NVE_GROUP_NODE[13]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_5_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[6], &gn_BGP_VNC_NVE_GROUP_NODE[12]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_5_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[4]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_6_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[7]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_6_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[5]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_7_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[8]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_7_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[6], &gn_BGP_VNC_NVE_GROUP_NODE[12]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_8_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[9]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_8_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[7]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_9_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[10]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_9_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[8]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_10_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[11]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_10_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[9]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_11_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_11_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[10]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_12_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[7]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_12_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[5]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_13_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[4]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_13_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_14_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[15]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_14_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[4]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_15_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[16]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_15_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[14]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_16_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[17]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_16_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[15]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_17_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_17_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[16]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_18_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[19]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_18_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_19_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[20], &gn_BGP_VNC_NVE_GROUP_NODE[24]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_19_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[18]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_20_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[21]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_20_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[19]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_21_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[22]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_21_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[20], &gn_BGP_VNC_NVE_GROUP_NODE[24]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_22_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[23]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_22_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[21]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_23_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_23_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[22]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_24_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[21]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_24_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[19]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_25_next, 3, &gn_BGP_VNC_NVE_GROUP_NODE[26], &gn_BGP_VNC_NVE_GROUP_NODE[47], &gn_BGP_VNC_NVE_GROUP_NODE[50]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_25_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_26_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[27]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_26_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[25]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_27_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[28], &gn_BGP_VNC_NVE_GROUP_NODE[40]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_27_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[26]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_28_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[29]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_28_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[27]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_29_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[30], &gn_BGP_VNC_NVE_GROUP_NODE[41]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_29_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[28], &gn_BGP_VNC_NVE_GROUP_NODE[40]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_30_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[31], &gn_BGP_VNC_NVE_GROUP_NODE[39]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_30_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[29]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_31_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[32]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_31_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[30]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_32_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[33]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_32_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[31], &gn_BGP_VNC_NVE_GROUP_NODE[39]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_33_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[34]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_33_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[32]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_34_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[35], &gn_BGP_VNC_NVE_GROUP_NODE[36]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_34_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[33]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_35_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[36]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_35_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[34]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_36_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[37]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_36_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[35], &gn_BGP_VNC_NVE_GROUP_NODE[34]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_37_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[38]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_37_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[36]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_38_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_38_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[37]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_39_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[32]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_39_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[30]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_40_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[29]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_40_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[27]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_41_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[42]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_41_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[29]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_42_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[43], &gn_BGP_VNC_NVE_GROUP_NODE[44]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_42_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[41]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_43_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[44]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_43_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[42]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_44_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[45]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_44_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[43], &gn_BGP_VNC_NVE_GROUP_NODE[42]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_45_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[46]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_45_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[44]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_46_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_46_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[45]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_47_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[48]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_47_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[25]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_48_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[49]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_48_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[47]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_49_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_49_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[48]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_50_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[51]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_50_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[25]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_51_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[52], &gn_BGP_VNC_NVE_GROUP_NODE[59]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_51_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[50]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_52_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[53], &gn_BGP_VNC_NVE_GROUP_NODE[58]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_52_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[51]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_53_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[54]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_53_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[52]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_54_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[55]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_54_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[53], &gn_BGP_VNC_NVE_GROUP_NODE[58]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_55_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[56]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_55_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[54]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_56_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[57]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_56_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[55]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_57_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_57_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[56]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_58_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[54]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_58_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[52]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_59_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[60]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_59_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[51]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_60_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[61]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_60_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[59]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_61_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_61_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[60]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_62_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[63]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_62_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_63_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[64], &gn_BGP_VNC_NVE_GROUP_NODE[72]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_63_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[62]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_64_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[65]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_64_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[63]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_65_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[66]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_65_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[64], &gn_BGP_VNC_NVE_GROUP_NODE[72]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_66_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[67], &gn_BGP_VNC_NVE_GROUP_NODE[71]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_66_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[65]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_67_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[68]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_67_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[66]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_68_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[69]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_68_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[67], &gn_BGP_VNC_NVE_GROUP_NODE[71]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_69_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[70]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_69_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[68]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_70_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_70_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[69]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_71_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[68]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_71_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[66]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_72_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[65]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_72_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[63]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_73_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[74]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_73_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_74_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[75]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_74_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[73]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_75_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[76]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_75_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[74]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_76_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_76_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[75]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_77_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[78]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_77_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_78_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[79], &gn_BGP_VNC_NVE_GROUP_NODE[87]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_78_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[77]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_79_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[80], &gn_BGP_VNC_NVE_GROUP_NODE[86]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_79_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[78]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_80_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[81]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_80_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[79]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_81_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[82]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_81_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[80], &gn_BGP_VNC_NVE_GROUP_NODE[86]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_82_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[83]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_82_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[81]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_83_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[84]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_83_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[82]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_84_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[85]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_84_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[83]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_85_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_85_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[84]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_86_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[81]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_86_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[79]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_87_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[88]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_87_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[78]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_88_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[89]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_88_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[87]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_89_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[90]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_89_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[88]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_90_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_90_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[89]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_91_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[92]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_91_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_92_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[93], &gn_BGP_VNC_NVE_GROUP_NODE[97]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_92_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[91]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_93_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[94]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_93_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[92]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_94_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[95]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_94_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[93], &gn_BGP_VNC_NVE_GROUP_NODE[97]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_95_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[96]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_95_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[94]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_96_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_96_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[95]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_97_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[94]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_97_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[92]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_98_next, 3, &gn_BGP_VNC_NVE_GROUP_NODE[99], &gn_BGP_VNC_NVE_GROUP_NODE[103], &gn_BGP_VNC_NVE_GROUP_NODE[107]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_98_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_99_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[100]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_99_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[98]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_100_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[100], &gn_BGP_VNC_NVE_GROUP_NODE[101]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_100_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[99], &gn_BGP_VNC_NVE_GROUP_NODE[100]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_101_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[102]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_101_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[100]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_102_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_102_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[101]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_103_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[104]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_103_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[98]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_104_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[104], &gn_BGP_VNC_NVE_GROUP_NODE[105]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_104_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[103], &gn_BGP_VNC_NVE_GROUP_NODE[104]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_105_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[106]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_105_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[104]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_106_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_106_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[105]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_107_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[108]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_107_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[98]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_108_next, 2, &gn_BGP_VNC_NVE_GROUP_NODE[108], &gn_BGP_VNC_NVE_GROUP_NODE[109]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_108_prev, 2, &gn_BGP_VNC_NVE_GROUP_NODE[107], &gn_BGP_VNC_NVE_GROUP_NODE[108]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_109_next, 1, &gn_BGP_VNC_NVE_GROUP_NODE[110]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_109_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[108]);
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_110_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_NVE_GROUP_NODE_110_prev, 1, &gn_BGP_VNC_NVE_GROUP_NODE[109]);

static struct graph_node gn_BGP_VNC_NVE_GROUP_NODE[] = {
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_0_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_0_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[0],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_1_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_1_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[1],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_2_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_2_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[2],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_3_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_3_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[3],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_4_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_4_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[4],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_5_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_5_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[5],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_6_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_6_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[6],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_7_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_7_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[7],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_8_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_8_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[8],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_9_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_9_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[9],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_10_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_10_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[10],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_11_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_11_next,
		.data = (void *)&vnc_nve_group_export_prefixlist_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_12_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_12_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[12],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_13_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_13_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[13],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_14_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_14_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[14],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_15_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_15_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[15],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_16_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_16_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[16],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_17_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_17_next,
		.data = (void *)&vnc_nve_group_export_routemap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_18_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_18_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[18],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_19_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_19_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[19],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_20_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_20_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[20],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_21_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_21_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[21],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_22_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_22_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[22],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_23_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_23_next,
		.data = (void *)&vnc_nve_group_l2rd_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_24_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_24_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[24],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_25_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_25_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[25],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_26_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_26_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[26],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_27_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_27_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[27],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_28_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_28_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[28],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_29_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_29_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[29],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_30_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_30_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[30],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_31_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_31_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[31],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_32_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_32_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[32],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_33_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_33_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[33],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_34_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_34_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[34],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_35_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_35_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[35],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_36_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_36_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[36],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_37_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_37_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[37],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_38_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_38_next,
		.data = (void *)&vnc_nve_group_export_no_prefixlist_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_39_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_39_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[39],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_40_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_40_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[40],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_41_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_41_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[41],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_42_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_42_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[42],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_43_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_43_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[43],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_44_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_44_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[44],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_45_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_45_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[45],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_46_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_46_next,
		.data = (void *)&vnc_nve_group_export_no_routemap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_47_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_47_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[47],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_48_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_48_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[48],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_49_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_49_next,
		.data = (void *)&vnc_nve_group_no_l2rd_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_50_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_50_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[50],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_51_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_51_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[51],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_52_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_52_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[52],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_53_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_53_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[53],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_54_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_54_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[54],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_55_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_55_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[55],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_56_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_56_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[56],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_57_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_57_next,
		.data = (void *)&vnc_nve_group_redist_bgpdirect_no_prefixlist_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_58_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_58_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[58],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_59_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_59_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[59],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_60_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_60_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[60],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_61_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_61_next,
		.data = (void *)&vnc_nve_group_redist_bgpdirect_no_routemap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_62_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_62_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[62],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_63_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_63_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[63],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_64_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_64_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[64],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_65_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_65_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[65],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_66_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_66_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[66],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_67_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_67_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[67],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_68_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_68_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[68],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_69_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_69_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[69],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_70_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_70_next,
		.data = (void *)&vnc_nve_group_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_71_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_71_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[71],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_72_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_72_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[72],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_73_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_73_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[73],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_74_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_74_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[74],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_75_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_75_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[75],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_76_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_76_next,
		.data = (void *)&vnc_nve_group_rd_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_77_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_77_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[77],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_78_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_78_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[78],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_79_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_79_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[79],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_80_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_80_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[80],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_81_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_81_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[81],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_82_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_82_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[82],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_83_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_83_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[83],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_84_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_84_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[84],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_85_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_85_next,
		.data = (void *)&vnc_nve_group_redist_bgpdirect_prefixlist_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_86_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_86_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[86],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_87_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_87_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[87],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_88_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_88_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[88],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_89_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_89_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[89],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_90_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_90_next,
		.data = (void *)&vnc_nve_group_redist_bgpdirect_routemap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_91_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_91_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[91],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_92_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_92_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[92],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_93_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_93_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[93],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_94_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_94_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[94],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_95_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_95_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[95],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_96_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_96_next,
		.data = (void *)&vnc_nve_group_responselifetime_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_97_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_97_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[97],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_98_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_98_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[98],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_99_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_99_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[99],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_100_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_100_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[100],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_101_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_101_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[101],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_102_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_102_next,
		.data = (void *)&vnc_nve_group_rt_both_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_103_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_103_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[103],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_104_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_104_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[104],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_105_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_105_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[105],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_106_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_106_next,
		.data = (void *)&vnc_nve_group_rt_export_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_107_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_107_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[107],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_108_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_108_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[108],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_109_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_109_next,
		.data = &ctkn_BGP_VNC_NVE_GROUP_NODE[109],
	},
	{
		.from = &gn_BGP_VNC_NVE_GROUP_NODE_110_prev,
		.to = &gn_BGP_VNC_NVE_GROUP_NODE_110_next,
		.data = (void *)&vnc_nve_group_rt_import_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_BGP_VNC_NVE_GROUP_NODE, 111, &gn_BGP_VNC_NVE_GROUP_NODE[0], &gn_BGP_VNC_NVE_GROUP_NODE[1], &gn_BGP_VNC_NVE_GROUP_NODE[2], &gn_BGP_VNC_NVE_GROUP_NODE[3], &gn_BGP_VNC_NVE_GROUP_NODE[4], &gn_BGP_VNC_NVE_GROUP_NODE[5], &gn_BGP_VNC_NVE_GROUP_NODE[6], &gn_BGP_VNC_NVE_GROUP_NODE[7], &gn_BGP_VNC_NVE_GROUP_NODE[8], &gn_BGP_VNC_NVE_GROUP_NODE[9], &gn_BGP_VNC_NVE_GROUP_NODE[10], &gn_BGP_VNC_NVE_GROUP_NODE[11], &gn_BGP_VNC_NVE_GROUP_NODE[12], &gn_BGP_VNC_NVE_GROUP_NODE[13], &gn_BGP_VNC_NVE_GROUP_NODE[14], &gn_BGP_VNC_NVE_GROUP_NODE[15], &gn_BGP_VNC_NVE_GROUP_NODE[16], &gn_BGP_VNC_NVE_GROUP_NODE[17], &gn_BGP_VNC_NVE_GROUP_NODE[18], &gn_BGP_VNC_NVE_GROUP_NODE[19], &gn_BGP_VNC_NVE_GROUP_NODE[20], &gn_BGP_VNC_NVE_GROUP_NODE[21], &gn_BGP_VNC_NVE_GROUP_NODE[22], &gn_BGP_VNC_NVE_GROUP_NODE[23], &gn_BGP_VNC_NVE_GROUP_NODE[24], &gn_BGP_VNC_NVE_GROUP_NODE[25], &gn_BGP_VNC_NVE_GROUP_NODE[26], &gn_BGP_VNC_NVE_GROUP_NODE[27], &gn_BGP_VNC_NVE_GROUP_NODE[28], &gn_BGP_VNC_NVE_GROUP_NODE[29], &gn_BGP_VNC_NVE_GROUP_NODE[30], &gn_BGP_VNC_NVE_GROUP_NODE[31], &gn_BGP_VNC_NVE_GROUP_NODE[32], &gn_BGP_VNC_NVE_GROUP_NODE[33], &gn_BGP_VNC_NVE_GROUP_NODE[34], &gn_BGP_VNC_NVE_GROUP_NODE[35], &gn_BGP_VNC_NVE_GROUP_NODE[36], &gn_BGP_VNC_NVE_GROUP_NODE[37], &gn_BGP_VNC_NVE_GROUP_NODE[38], &gn_BGP_VNC_NVE_GROUP_NODE[39], &gn_BGP_VNC_NVE_GROUP_NODE[40], &gn_BGP_VNC_NVE_GROUP_NODE[41], &gn_BGP_VNC_NVE_GROUP_NODE[42], &gn_BGP_VNC_NVE_GROUP_NODE[43], &gn_BGP_VNC_NVE_GROUP_NODE[44], &gn_BGP_VNC_NVE_GROUP_NODE[45], &gn_BGP_VNC_NVE_GROUP_NODE[46], &gn_BGP_VNC_NVE_GROUP_NODE[47], &gn_BGP_VNC_NVE_GROUP_NODE[48], &gn_BGP_VNC_NVE_GROUP_NODE[49], &gn_BGP_VNC_NVE_GROUP_NODE[50], &gn_BGP_VNC_NVE_GROUP_NODE[51], &gn_BGP_VNC_NVE_GROUP_NODE[52], &gn_BGP_VNC_NVE_GROUP_NODE[53], &gn_BGP_VNC_NVE_GROUP_NODE[54], &gn_BGP_VNC_NVE_GROUP_NODE[55], &gn_BGP_VNC_NVE_GROUP_NODE[56], &gn_BGP_VNC_NVE_GROUP_NODE[57], &gn_BGP_VNC_NVE_GROUP_NODE[58], &gn_BGP_VNC_NVE_GROUP_NODE[59], &gn_BGP_VNC_NVE_GROUP_NODE[60], &gn_BGP_VNC_NVE_GROUP_NODE[61], &gn_BGP_VNC_NVE_GROUP_NODE[62], &gn_BGP_VNC_NVE_GROUP_NODE[63], &gn_BGP_VNC_NVE_GROUP_NODE[64], &gn_BGP_VNC_NVE_GROUP_NODE[65], &gn_BGP_VNC_NVE_GROUP_NODE[66], &gn_BGP_VNC_NVE_GROUP_NODE[67], &gn_BGP_VNC_NVE_GROUP_NODE[68], &gn_BGP_VNC_NVE_GROUP_NODE[69], &gn_BGP_VNC_NVE_GROUP_NODE[70], &gn_BGP_VNC_NVE_GROUP_NODE[71], &gn_BGP_VNC_NVE_GROUP_NODE[72], &gn_BGP_VNC_NVE_GROUP_NODE[73], &gn_BGP_VNC_NVE_GROUP_NODE[74], &gn_BGP_VNC_NVE_GROUP_NODE[75], &gn_BGP_VNC_NVE_GROUP_NODE[76], &gn_BGP_VNC_NVE_GROUP_NODE[77], &gn_BGP_VNC_NVE_GROUP_NODE[78], &gn_BGP_VNC_NVE_GROUP_NODE[79], &gn_BGP_VNC_NVE_GROUP_NODE[80], &gn_BGP_VNC_NVE_GROUP_NODE[81], &gn_BGP_VNC_NVE_GROUP_NODE[82], &gn_BGP_VNC_NVE_GROUP_NODE[83], &gn_BGP_VNC_NVE_GROUP_NODE[84], &gn_BGP_VNC_NVE_GROUP_NODE[85], &gn_BGP_VNC_NVE_GROUP_NODE[86], &gn_BGP_VNC_NVE_GROUP_NODE[87], &gn_BGP_VNC_NVE_GROUP_NODE[88], &gn_BGP_VNC_NVE_GROUP_NODE[89], &gn_BGP_VNC_NVE_GROUP_NODE[90], &gn_BGP_VNC_NVE_GROUP_NODE[91], &gn_BGP_VNC_NVE_GROUP_NODE[92], &gn_BGP_VNC_NVE_GROUP_NODE[93], &gn_BGP_VNC_NVE_GROUP_NODE[94], &gn_BGP_VNC_NVE_GROUP_NODE[95], &gn_BGP_VNC_NVE_GROUP_NODE[96], &gn_BGP_VNC_NVE_GROUP_NODE[97], &gn_BGP_VNC_NVE_GROUP_NODE[98], &gn_BGP_VNC_NVE_GROUP_NODE[99], &gn_BGP_VNC_NVE_GROUP_NODE[100], &gn_BGP_VNC_NVE_GROUP_NODE[101], &gn_BGP_VNC_NVE_GROUP_NODE[102], &gn_BGP_VNC_NVE_GROUP_NODE[103], &gn_BGP_VNC_NVE_GROUP_NODE[104], &gn_BGP_VNC_NVE_GROUP_NODE[105], &gn_BGP_VNC_NVE_GROUP_NODE[106], &gn_BGP_VNC_NVE_GROUP_NODE[107], &gn_BGP_VNC_NVE_GROUP_NODE[108], &gn_BGP_VNC_NVE_GROUP_NODE[109], &gn_BGP_VNC_NVE_GROUP_NODE[110]);

extern void install_BGP_VNC_NVE_GROUP_NODE(void);

void install_BGP_VNC_NVE_GROUP_NODE(void)

{
	unsigned node_id = BGP_VNC_NVE_GROUP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BGP_VNC_NVE_GROUP_NODE;
	vector_set(node->cmd_vector, &vnc_nve_group_export_no_prefixlist_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_export_no_routemap_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_export_prefixlist_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_export_routemap_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_l2rd_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_no_l2rd_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_rd_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_redist_bgpdirect_no_prefixlist_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_redist_bgpdirect_no_routemap_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_redist_bgpdirect_prefixlist_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_redist_bgpdirect_routemap_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_responselifetime_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_rt_both_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_rt_export_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_nve_group_rt_import_cmd_vtysh);
}

static struct cmd_token ctkn_LDP_IPV6_NODE[];
static struct graph_node gn_LDP_IPV6_NODE[];

static struct cmd_token ctkn_LDP_IPV6_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"discovery",
		.desc = (char *)"Configure discovery parameters",
	},
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"hello",
		.desc = (char *)"LDP Link Hellos",
	},
	{ /* [6] */
		.type = WORD_TKN,
		.text = (char *)"holdtime",
		.desc = (char *)"Hello holdtime",
	},
	{ /* [7] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds) - 65535 implies infinite",
		.min = 1,
		.max = 65535,
		.varname = (char *)"holdtime",
	},
	{ /* [8] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [9] = ldp_discovery_link_holdtime_cmd */ },
	{ /* [10] */
		.type = WORD_TKN,
		.text = (char *)"interval",
		.desc = (char *)"Hello interval",
	},
	{ /* [11] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds)",
		.min = 1,
		.max = 65535,
		.varname = (char *)"interval",
	},
	{ /* [12] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [13] = ldp_discovery_link_interval_cmd */ },
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"targeted-hello",
		.desc = (char *)"LDP Targeted Hellos",
	},
	{ /* [15] */
		.type = WORD_TKN,
		.text = (char *)"accept",
		.desc = (char *)"Accept and respond to targeted hellos",
	},
	{ /* [16] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[19],
	},
	{ /* [17] */
		.type = WORD_TKN,
		.text = (char *)"from",
		.desc = (char *)"Access list to specify acceptable targeted hello source",
	},
	{ /* [18] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"from_acl",
	},
	{ /* [19] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[16],
	},
	{ /* [20] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [21] = ldp_discovery_targeted_hello_accept_cmd */ },
	{ /* [22] */
		.type = WORD_TKN,
		.text = (char *)"holdtime",
		.desc = (char *)"Hello holdtime",
	},
	{ /* [23] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds) - 65535 implies infinite",
		.min = 1,
		.max = 65535,
		.varname = (char *)"holdtime",
	},
	{ /* [24] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [25] = ldp_discovery_targeted_holdtime_cmd */ },
	{ /* [26] */
		.type = WORD_TKN,
		.text = (char *)"interval",
		.desc = (char *)"Hello interval",
	},
	{ /* [27] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds)",
		.min = 1,
		.max = 65535,
		.varname = (char *)"interval",
	},
	{ /* [28] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [29] = ldp_discovery_targeted_interval_cmd */ },
	{ /* [30] */
		.type = WORD_TKN,
		.text = (char *)"transport-address",
		.desc = (char *)"Specify transport address for TCP connection",
	},
	{ /* [31] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address to be used as transport address",
		.varname = (char *)"address",
	},
	{ /* [32] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [33] = ldp_discovery_transport_address_ipv6_cmd */ },
	{ /* [34] */
		.type = WORD_TKN,
		.text = (char *)"label",
		.desc = (char *)"Configure label control and policies",
	},
	{ /* [35] */
		.type = WORD_TKN,
		.text = (char *)"local",
		.desc = (char *)"Configure local label control and policies",
	},
	{ /* [36] */
		.type = WORD_TKN,
		.text = (char *)"advertise",
		.desc = (char *)"Configure outbound label advertisement control",
	},
	{ /* [37] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[42],
	},
	{ /* [38] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[41],
	},
	{ /* [39] */
		.type = WORD_TKN,
		.text = (char *)"to",
		.desc = (char *)"IP Access-list specifying controls on LDP Peers",
	},
	{ /* [40] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"to_acl",
	},
	{ /* [41] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[38],
	},
	{ /* [42] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[37],
	},
	{ /* [43] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [44] = ldp_label_local_advertise_cmd */ },
	{ /* [45] */
		.type = WORD_TKN,
		.text = (char *)"for",
		.desc = (char *)"IP access-list for destination prefixes",
	},
	{ /* [46] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"for_acl",
	},
	{ /* [47] */
		.type = WORD_TKN,
		.text = (char *)"explicit-null",
		.desc = (char *)"Configure explicit-null advertisement",
	},
	{ /* [48] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[51],
	},
	{ /* [49] */
		.type = WORD_TKN,
		.text = (char *)"for",
		.desc = (char *)"IP access-list for destination prefixes",
	},
	{ /* [50] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"for_acl",
	},
	{ /* [51] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[48],
	},
	{ /* [52] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [53] = ldp_label_local_advertise_explicit_null_cmd */ },
	{ /* [54] */
		.type = WORD_TKN,
		.text = (char *)"allocate",
		.desc = (char *)"Configure label allocation control",
	},
	{ /* [55] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[57],
	},
	{ /* [56] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"host-routes",
		.desc = (char *)"allocate local label for host routes only",
		.varname = (char *)"host_routes",
	},
	{ /* [57] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[55],
	},
	{ /* [58] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [59] = ldp_label_local_allocate_cmd */ },
	{ /* [60] */
		.type = WORD_TKN,
		.text = (char *)"for",
		.desc = (char *)"IP access-list",
	},
	{ /* [61] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"for_acl",
	},
	{ /* [62] */
		.type = WORD_TKN,
		.text = (char *)"remote",
		.desc = (char *)"Configure remote/peer label control and policies",
	},
	{ /* [63] */
		.type = WORD_TKN,
		.text = (char *)"accept",
		.desc = (char *)"Configure inbound label acceptance control",
	},
	{ /* [64] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[67],
	},
	{ /* [65] */
		.type = WORD_TKN,
		.text = (char *)"from",
		.desc = (char *)"Neighbor from whom to accept label advertisement",
	},
	{ /* [66] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"from_acl",
	},
	{ /* [67] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV6_NODE[64],
	},
	{ /* [68] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [69] = ldp_label_remote_accept_cmd */ },
	{ /* [70] */
		.type = WORD_TKN,
		.text = (char *)"for",
		.desc = (char *)"IP access-list for destination prefixes",
	},
	{ /* [71] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP access-list name",
		.varname = (char *)"for_acl",
	},
	{ /* [72] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Configure neighbor parameters",
	},
	{ /* [73] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address of neighbor",
		.varname = (char *)"address",
	},
	{ /* [74] */
		.type = WORD_TKN,
		.text = (char *)"targeted",
		.desc = (char *)"Establish targeted session",
	},
	{ /* [75] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [76] = ldp_neighbor_ipv6_targeted_cmd */ },
	{ /* [77] */
		.type = WORD_TKN,
		.text = (char *)"session",
		.desc = (char *)"Configure session parameters",
	},
	{ /* [78] */
		.type = WORD_TKN,
		.text = (char *)"holdtime",
		.desc = (char *)"Configure session holdtime",
	},
	{ /* [79] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(15-65535)",
		.desc = (char *)"Time (seconds)",
		.min = 15,
		.max = 65535,
		.varname = (char *)"holdtime",
	},
	{ /* [80] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [81] = ldp_session_holdtime_cmd */ },
	{ /* [82] */
		.type = WORD_TKN,
		.text = (char *)"ttl-security",
		.desc = (char *)"LDP ttl security check",
	},
	{ /* [83] */
		.type = WORD_TKN,
		.text = (char *)"disable",
		.desc = (char *)"Disable ttl security",
	},
	{ /* [84] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [85] = ldp_ttl_security_disable_cmd */ },
	{ /* [86] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [87] */
		.type = WORD_TKN,
		.text = (char *)"interface",
		.desc = (char *)"Enable LDP on an interface and enter interface submode",
	},
	{ /* [88] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface's name",
		.varname = (char *)"ifname",
	},
	{ /* [89] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [90] = no_ldp_interface_cmd */ },
};

extern struct cmd_element ldp_discovery_link_holdtime_cmd_vtysh;
extern struct cmd_element ldp_discovery_link_interval_cmd_vtysh;
extern struct cmd_element ldp_discovery_targeted_hello_accept_cmd_vtysh;
extern struct cmd_element ldp_discovery_targeted_holdtime_cmd_vtysh;
extern struct cmd_element ldp_discovery_targeted_interval_cmd_vtysh;
extern struct cmd_element ldp_discovery_transport_address_ipv6_cmd_vtysh;
extern struct cmd_element ldp_label_local_advertise_cmd_vtysh;
extern struct cmd_element ldp_label_local_advertise_explicit_null_cmd_vtysh;
extern struct cmd_element ldp_label_local_allocate_cmd_vtysh;
extern struct cmd_element ldp_label_remote_accept_cmd_vtysh;
extern struct cmd_element ldp_neighbor_ipv6_targeted_cmd_vtysh;
extern struct cmd_element ldp_session_holdtime_cmd_vtysh;
extern struct cmd_element ldp_ttl_security_disable_cmd_vtysh;
extern struct cmd_element no_ldp_interface_cmd_vtysh;

MAKE_VECTOR(gn_LDP_IPV6_NODE_0_next, 2, &gn_LDP_IPV6_NODE[1], &gn_LDP_IPV6_NODE[86]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_0_prev, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_1_next, 2, &gn_LDP_IPV6_NODE[2], &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_1_prev, 1, &gn_LDP_IPV6_NODE[0]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_2_next, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_2_prev, 1, &gn_LDP_IPV6_NODE[1]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_3_next, 5, &gn_LDP_IPV6_NODE[4], &gn_LDP_IPV6_NODE[34], &gn_LDP_IPV6_NODE[72], &gn_LDP_IPV6_NODE[77], &gn_LDP_IPV6_NODE[82]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_3_prev, 2, &gn_LDP_IPV6_NODE[2], &gn_LDP_IPV6_NODE[1]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_4_next, 3, &gn_LDP_IPV6_NODE[5], &gn_LDP_IPV6_NODE[14], &gn_LDP_IPV6_NODE[30]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_4_prev, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_5_next, 2, &gn_LDP_IPV6_NODE[6], &gn_LDP_IPV6_NODE[10]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_5_prev, 1, &gn_LDP_IPV6_NODE[4]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_6_next, 1, &gn_LDP_IPV6_NODE[7]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_6_prev, 1, &gn_LDP_IPV6_NODE[5]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_7_next, 1, &gn_LDP_IPV6_NODE[8]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_7_prev, 1, &gn_LDP_IPV6_NODE[6]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_8_next, 1, &gn_LDP_IPV6_NODE[9]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_8_prev, 1, &gn_LDP_IPV6_NODE[7]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_9_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_9_prev, 1, &gn_LDP_IPV6_NODE[8]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_10_next, 1, &gn_LDP_IPV6_NODE[11]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_10_prev, 1, &gn_LDP_IPV6_NODE[5]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_11_next, 1, &gn_LDP_IPV6_NODE[12]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_11_prev, 1, &gn_LDP_IPV6_NODE[10]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_12_next, 1, &gn_LDP_IPV6_NODE[13]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_12_prev, 1, &gn_LDP_IPV6_NODE[11]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_13_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_13_prev, 1, &gn_LDP_IPV6_NODE[12]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_14_next, 3, &gn_LDP_IPV6_NODE[15], &gn_LDP_IPV6_NODE[22], &gn_LDP_IPV6_NODE[26]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_14_prev, 1, &gn_LDP_IPV6_NODE[4]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_15_next, 1, &gn_LDP_IPV6_NODE[16]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_15_prev, 1, &gn_LDP_IPV6_NODE[14]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_16_next, 2, &gn_LDP_IPV6_NODE[17], &gn_LDP_IPV6_NODE[19]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_16_prev, 1, &gn_LDP_IPV6_NODE[15]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_17_next, 1, &gn_LDP_IPV6_NODE[18]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_17_prev, 1, &gn_LDP_IPV6_NODE[16]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_18_next, 1, &gn_LDP_IPV6_NODE[19]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_18_prev, 1, &gn_LDP_IPV6_NODE[17]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_19_next, 1, &gn_LDP_IPV6_NODE[20]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_19_prev, 2, &gn_LDP_IPV6_NODE[18], &gn_LDP_IPV6_NODE[16]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_20_next, 1, &gn_LDP_IPV6_NODE[21]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_20_prev, 1, &gn_LDP_IPV6_NODE[19]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_21_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_21_prev, 1, &gn_LDP_IPV6_NODE[20]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_22_next, 1, &gn_LDP_IPV6_NODE[23]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_22_prev, 1, &gn_LDP_IPV6_NODE[14]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_23_next, 1, &gn_LDP_IPV6_NODE[24]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_23_prev, 1, &gn_LDP_IPV6_NODE[22]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_24_next, 1, &gn_LDP_IPV6_NODE[25]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_24_prev, 1, &gn_LDP_IPV6_NODE[23]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_25_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_25_prev, 1, &gn_LDP_IPV6_NODE[24]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_26_next, 1, &gn_LDP_IPV6_NODE[27]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_26_prev, 1, &gn_LDP_IPV6_NODE[14]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_27_next, 1, &gn_LDP_IPV6_NODE[28]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_27_prev, 1, &gn_LDP_IPV6_NODE[26]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_28_next, 1, &gn_LDP_IPV6_NODE[29]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_28_prev, 1, &gn_LDP_IPV6_NODE[27]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_29_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_29_prev, 1, &gn_LDP_IPV6_NODE[28]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_30_next, 1, &gn_LDP_IPV6_NODE[31]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_30_prev, 1, &gn_LDP_IPV6_NODE[4]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_31_next, 1, &gn_LDP_IPV6_NODE[32]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_31_prev, 1, &gn_LDP_IPV6_NODE[30]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_32_next, 1, &gn_LDP_IPV6_NODE[33]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_32_prev, 1, &gn_LDP_IPV6_NODE[31]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_33_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_33_prev, 1, &gn_LDP_IPV6_NODE[32]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_34_next, 2, &gn_LDP_IPV6_NODE[35], &gn_LDP_IPV6_NODE[62]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_34_prev, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_35_next, 2, &gn_LDP_IPV6_NODE[36], &gn_LDP_IPV6_NODE[54]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_35_prev, 1, &gn_LDP_IPV6_NODE[34]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_36_next, 2, &gn_LDP_IPV6_NODE[37], &gn_LDP_IPV6_NODE[47]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_36_prev, 1, &gn_LDP_IPV6_NODE[35]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_37_next, 2, &gn_LDP_IPV6_NODE[38], &gn_LDP_IPV6_NODE[42]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_37_prev, 1, &gn_LDP_IPV6_NODE[36]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_38_next, 2, &gn_LDP_IPV6_NODE[39], &gn_LDP_IPV6_NODE[45]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_38_prev, 2, &gn_LDP_IPV6_NODE[41], &gn_LDP_IPV6_NODE[37]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_39_next, 1, &gn_LDP_IPV6_NODE[40]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_39_prev, 1, &gn_LDP_IPV6_NODE[38]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_40_next, 1, &gn_LDP_IPV6_NODE[41]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_40_prev, 1, &gn_LDP_IPV6_NODE[39]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_41_next, 2, &gn_LDP_IPV6_NODE[38], &gn_LDP_IPV6_NODE[42]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_41_prev, 2, &gn_LDP_IPV6_NODE[40], &gn_LDP_IPV6_NODE[46]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_42_next, 1, &gn_LDP_IPV6_NODE[43]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_42_prev, 2, &gn_LDP_IPV6_NODE[41], &gn_LDP_IPV6_NODE[37]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_43_next, 1, &gn_LDP_IPV6_NODE[44]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_43_prev, 1, &gn_LDP_IPV6_NODE[42]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_44_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_44_prev, 1, &gn_LDP_IPV6_NODE[43]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_45_next, 1, &gn_LDP_IPV6_NODE[46]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_45_prev, 1, &gn_LDP_IPV6_NODE[38]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_46_next, 1, &gn_LDP_IPV6_NODE[41]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_46_prev, 1, &gn_LDP_IPV6_NODE[45]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_47_next, 1, &gn_LDP_IPV6_NODE[48]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_47_prev, 1, &gn_LDP_IPV6_NODE[36]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_48_next, 2, &gn_LDP_IPV6_NODE[49], &gn_LDP_IPV6_NODE[51]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_48_prev, 1, &gn_LDP_IPV6_NODE[47]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_49_next, 1, &gn_LDP_IPV6_NODE[50]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_49_prev, 1, &gn_LDP_IPV6_NODE[48]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_50_next, 1, &gn_LDP_IPV6_NODE[51]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_50_prev, 1, &gn_LDP_IPV6_NODE[49]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_51_next, 1, &gn_LDP_IPV6_NODE[52]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_51_prev, 2, &gn_LDP_IPV6_NODE[50], &gn_LDP_IPV6_NODE[48]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_52_next, 1, &gn_LDP_IPV6_NODE[53]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_52_prev, 1, &gn_LDP_IPV6_NODE[51]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_53_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_53_prev, 1, &gn_LDP_IPV6_NODE[52]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_54_next, 1, &gn_LDP_IPV6_NODE[55]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_54_prev, 1, &gn_LDP_IPV6_NODE[35]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_55_next, 2, &gn_LDP_IPV6_NODE[56], &gn_LDP_IPV6_NODE[60]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_55_prev, 1, &gn_LDP_IPV6_NODE[54]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_56_next, 1, &gn_LDP_IPV6_NODE[57]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_56_prev, 1, &gn_LDP_IPV6_NODE[55]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_57_next, 1, &gn_LDP_IPV6_NODE[58]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_57_prev, 2, &gn_LDP_IPV6_NODE[56], &gn_LDP_IPV6_NODE[61]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_58_next, 1, &gn_LDP_IPV6_NODE[59]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_58_prev, 1, &gn_LDP_IPV6_NODE[57]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_59_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_59_prev, 1, &gn_LDP_IPV6_NODE[58]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_60_next, 1, &gn_LDP_IPV6_NODE[61]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_60_prev, 1, &gn_LDP_IPV6_NODE[55]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_61_next, 1, &gn_LDP_IPV6_NODE[57]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_61_prev, 1, &gn_LDP_IPV6_NODE[60]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_62_next, 1, &gn_LDP_IPV6_NODE[63]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_62_prev, 1, &gn_LDP_IPV6_NODE[34]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_63_next, 1, &gn_LDP_IPV6_NODE[64]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_63_prev, 1, &gn_LDP_IPV6_NODE[62]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_64_next, 2, &gn_LDP_IPV6_NODE[65], &gn_LDP_IPV6_NODE[70]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_64_prev, 2, &gn_LDP_IPV6_NODE[67], &gn_LDP_IPV6_NODE[63]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_65_next, 1, &gn_LDP_IPV6_NODE[66]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_65_prev, 1, &gn_LDP_IPV6_NODE[64]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_66_next, 1, &gn_LDP_IPV6_NODE[67]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_66_prev, 1, &gn_LDP_IPV6_NODE[65]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_67_next, 2, &gn_LDP_IPV6_NODE[64], &gn_LDP_IPV6_NODE[68]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_67_prev, 2, &gn_LDP_IPV6_NODE[66], &gn_LDP_IPV6_NODE[71]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_68_next, 1, &gn_LDP_IPV6_NODE[69]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_68_prev, 1, &gn_LDP_IPV6_NODE[67]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_69_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_69_prev, 1, &gn_LDP_IPV6_NODE[68]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_70_next, 1, &gn_LDP_IPV6_NODE[71]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_70_prev, 1, &gn_LDP_IPV6_NODE[64]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_71_next, 1, &gn_LDP_IPV6_NODE[67]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_71_prev, 1, &gn_LDP_IPV6_NODE[70]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_72_next, 1, &gn_LDP_IPV6_NODE[73]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_72_prev, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_73_next, 1, &gn_LDP_IPV6_NODE[74]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_73_prev, 1, &gn_LDP_IPV6_NODE[72]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_74_next, 1, &gn_LDP_IPV6_NODE[75]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_74_prev, 1, &gn_LDP_IPV6_NODE[73]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_75_next, 1, &gn_LDP_IPV6_NODE[76]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_75_prev, 1, &gn_LDP_IPV6_NODE[74]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_76_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_76_prev, 1, &gn_LDP_IPV6_NODE[75]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_77_next, 1, &gn_LDP_IPV6_NODE[78]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_77_prev, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_78_next, 1, &gn_LDP_IPV6_NODE[79]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_78_prev, 1, &gn_LDP_IPV6_NODE[77]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_79_next, 1, &gn_LDP_IPV6_NODE[80]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_79_prev, 1, &gn_LDP_IPV6_NODE[78]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_80_next, 1, &gn_LDP_IPV6_NODE[81]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_80_prev, 1, &gn_LDP_IPV6_NODE[79]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_81_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_81_prev, 1, &gn_LDP_IPV6_NODE[80]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_82_next, 1, &gn_LDP_IPV6_NODE[83]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_82_prev, 1, &gn_LDP_IPV6_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_83_next, 1, &gn_LDP_IPV6_NODE[84]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_83_prev, 1, &gn_LDP_IPV6_NODE[82]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_84_next, 1, &gn_LDP_IPV6_NODE[85]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_84_prev, 1, &gn_LDP_IPV6_NODE[83]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_85_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_85_prev, 1, &gn_LDP_IPV6_NODE[84]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_86_next, 1, &gn_LDP_IPV6_NODE[87]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_86_prev, 1, &gn_LDP_IPV6_NODE[0]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_87_next, 1, &gn_LDP_IPV6_NODE[88]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_87_prev, 1, &gn_LDP_IPV6_NODE[86]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_88_next, 1, &gn_LDP_IPV6_NODE[89]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_88_prev, 1, &gn_LDP_IPV6_NODE[87]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_89_next, 1, &gn_LDP_IPV6_NODE[90]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_89_prev, 1, &gn_LDP_IPV6_NODE[88]);
MAKE_VECTOR(gn_LDP_IPV6_NODE_90_next, 0, );
MAKE_VECTOR(gn_LDP_IPV6_NODE_90_prev, 1, &gn_LDP_IPV6_NODE[89]);

static struct graph_node gn_LDP_IPV6_NODE[] = {
	{
		.from = &gn_LDP_IPV6_NODE_0_prev,
		.to = &gn_LDP_IPV6_NODE_0_next,
		.data = &ctkn_LDP_IPV6_NODE[0],
	},
	{
		.from = &gn_LDP_IPV6_NODE_1_prev,
		.to = &gn_LDP_IPV6_NODE_1_next,
		.data = &ctkn_LDP_IPV6_NODE[1],
	},
	{
		.from = &gn_LDP_IPV6_NODE_2_prev,
		.to = &gn_LDP_IPV6_NODE_2_next,
		.data = &ctkn_LDP_IPV6_NODE[2],
	},
	{
		.from = &gn_LDP_IPV6_NODE_3_prev,
		.to = &gn_LDP_IPV6_NODE_3_next,
		.data = &ctkn_LDP_IPV6_NODE[3],
	},
	{
		.from = &gn_LDP_IPV6_NODE_4_prev,
		.to = &gn_LDP_IPV6_NODE_4_next,
		.data = &ctkn_LDP_IPV6_NODE[4],
	},
	{
		.from = &gn_LDP_IPV6_NODE_5_prev,
		.to = &gn_LDP_IPV6_NODE_5_next,
		.data = &ctkn_LDP_IPV6_NODE[5],
	},
	{
		.from = &gn_LDP_IPV6_NODE_6_prev,
		.to = &gn_LDP_IPV6_NODE_6_next,
		.data = &ctkn_LDP_IPV6_NODE[6],
	},
	{
		.from = &gn_LDP_IPV6_NODE_7_prev,
		.to = &gn_LDP_IPV6_NODE_7_next,
		.data = &ctkn_LDP_IPV6_NODE[7],
	},
	{
		.from = &gn_LDP_IPV6_NODE_8_prev,
		.to = &gn_LDP_IPV6_NODE_8_next,
		.data = &ctkn_LDP_IPV6_NODE[8],
	},
	{
		.from = &gn_LDP_IPV6_NODE_9_prev,
		.to = &gn_LDP_IPV6_NODE_9_next,
		.data = (void *)&ldp_discovery_link_holdtime_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_10_prev,
		.to = &gn_LDP_IPV6_NODE_10_next,
		.data = &ctkn_LDP_IPV6_NODE[10],
	},
	{
		.from = &gn_LDP_IPV6_NODE_11_prev,
		.to = &gn_LDP_IPV6_NODE_11_next,
		.data = &ctkn_LDP_IPV6_NODE[11],
	},
	{
		.from = &gn_LDP_IPV6_NODE_12_prev,
		.to = &gn_LDP_IPV6_NODE_12_next,
		.data = &ctkn_LDP_IPV6_NODE[12],
	},
	{
		.from = &gn_LDP_IPV6_NODE_13_prev,
		.to = &gn_LDP_IPV6_NODE_13_next,
		.data = (void *)&ldp_discovery_link_interval_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_14_prev,
		.to = &gn_LDP_IPV6_NODE_14_next,
		.data = &ctkn_LDP_IPV6_NODE[14],
	},
	{
		.from = &gn_LDP_IPV6_NODE_15_prev,
		.to = &gn_LDP_IPV6_NODE_15_next,
		.data = &ctkn_LDP_IPV6_NODE[15],
	},
	{
		.from = &gn_LDP_IPV6_NODE_16_prev,
		.to = &gn_LDP_IPV6_NODE_16_next,
		.data = &ctkn_LDP_IPV6_NODE[16],
	},
	{
		.from = &gn_LDP_IPV6_NODE_17_prev,
		.to = &gn_LDP_IPV6_NODE_17_next,
		.data = &ctkn_LDP_IPV6_NODE[17],
	},
	{
		.from = &gn_LDP_IPV6_NODE_18_prev,
		.to = &gn_LDP_IPV6_NODE_18_next,
		.data = &ctkn_LDP_IPV6_NODE[18],
	},
	{
		.from = &gn_LDP_IPV6_NODE_19_prev,
		.to = &gn_LDP_IPV6_NODE_19_next,
		.data = &ctkn_LDP_IPV6_NODE[19],
	},
	{
		.from = &gn_LDP_IPV6_NODE_20_prev,
		.to = &gn_LDP_IPV6_NODE_20_next,
		.data = &ctkn_LDP_IPV6_NODE[20],
	},
	{
		.from = &gn_LDP_IPV6_NODE_21_prev,
		.to = &gn_LDP_IPV6_NODE_21_next,
		.data = (void *)&ldp_discovery_targeted_hello_accept_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_22_prev,
		.to = &gn_LDP_IPV6_NODE_22_next,
		.data = &ctkn_LDP_IPV6_NODE[22],
	},
	{
		.from = &gn_LDP_IPV6_NODE_23_prev,
		.to = &gn_LDP_IPV6_NODE_23_next,
		.data = &ctkn_LDP_IPV6_NODE[23],
	},
	{
		.from = &gn_LDP_IPV6_NODE_24_prev,
		.to = &gn_LDP_IPV6_NODE_24_next,
		.data = &ctkn_LDP_IPV6_NODE[24],
	},
	{
		.from = &gn_LDP_IPV6_NODE_25_prev,
		.to = &gn_LDP_IPV6_NODE_25_next,
		.data = (void *)&ldp_discovery_targeted_holdtime_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_26_prev,
		.to = &gn_LDP_IPV6_NODE_26_next,
		.data = &ctkn_LDP_IPV6_NODE[26],
	},
	{
		.from = &gn_LDP_IPV6_NODE_27_prev,
		.to = &gn_LDP_IPV6_NODE_27_next,
		.data = &ctkn_LDP_IPV6_NODE[27],
	},
	{
		.from = &gn_LDP_IPV6_NODE_28_prev,
		.to = &gn_LDP_IPV6_NODE_28_next,
		.data = &ctkn_LDP_IPV6_NODE[28],
	},
	{
		.from = &gn_LDP_IPV6_NODE_29_prev,
		.to = &gn_LDP_IPV6_NODE_29_next,
		.data = (void *)&ldp_discovery_targeted_interval_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_30_prev,
		.to = &gn_LDP_IPV6_NODE_30_next,
		.data = &ctkn_LDP_IPV6_NODE[30],
	},
	{
		.from = &gn_LDP_IPV6_NODE_31_prev,
		.to = &gn_LDP_IPV6_NODE_31_next,
		.data = &ctkn_LDP_IPV6_NODE[31],
	},
	{
		.from = &gn_LDP_IPV6_NODE_32_prev,
		.to = &gn_LDP_IPV6_NODE_32_next,
		.data = &ctkn_LDP_IPV6_NODE[32],
	},
	{
		.from = &gn_LDP_IPV6_NODE_33_prev,
		.to = &gn_LDP_IPV6_NODE_33_next,
		.data = (void *)&ldp_discovery_transport_address_ipv6_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_34_prev,
		.to = &gn_LDP_IPV6_NODE_34_next,
		.data = &ctkn_LDP_IPV6_NODE[34],
	},
	{
		.from = &gn_LDP_IPV6_NODE_35_prev,
		.to = &gn_LDP_IPV6_NODE_35_next,
		.data = &ctkn_LDP_IPV6_NODE[35],
	},
	{
		.from = &gn_LDP_IPV6_NODE_36_prev,
		.to = &gn_LDP_IPV6_NODE_36_next,
		.data = &ctkn_LDP_IPV6_NODE[36],
	},
	{
		.from = &gn_LDP_IPV6_NODE_37_prev,
		.to = &gn_LDP_IPV6_NODE_37_next,
		.data = &ctkn_LDP_IPV6_NODE[37],
	},
	{
		.from = &gn_LDP_IPV6_NODE_38_prev,
		.to = &gn_LDP_IPV6_NODE_38_next,
		.data = &ctkn_LDP_IPV6_NODE[38],
	},
	{
		.from = &gn_LDP_IPV6_NODE_39_prev,
		.to = &gn_LDP_IPV6_NODE_39_next,
		.data = &ctkn_LDP_IPV6_NODE[39],
	},
	{
		.from = &gn_LDP_IPV6_NODE_40_prev,
		.to = &gn_LDP_IPV6_NODE_40_next,
		.data = &ctkn_LDP_IPV6_NODE[40],
	},
	{
		.from = &gn_LDP_IPV6_NODE_41_prev,
		.to = &gn_LDP_IPV6_NODE_41_next,
		.data = &ctkn_LDP_IPV6_NODE[41],
	},
	{
		.from = &gn_LDP_IPV6_NODE_42_prev,
		.to = &gn_LDP_IPV6_NODE_42_next,
		.data = &ctkn_LDP_IPV6_NODE[42],
	},
	{
		.from = &gn_LDP_IPV6_NODE_43_prev,
		.to = &gn_LDP_IPV6_NODE_43_next,
		.data = &ctkn_LDP_IPV6_NODE[43],
	},
	{
		.from = &gn_LDP_IPV6_NODE_44_prev,
		.to = &gn_LDP_IPV6_NODE_44_next,
		.data = (void *)&ldp_label_local_advertise_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_45_prev,
		.to = &gn_LDP_IPV6_NODE_45_next,
		.data = &ctkn_LDP_IPV6_NODE[45],
	},
	{
		.from = &gn_LDP_IPV6_NODE_46_prev,
		.to = &gn_LDP_IPV6_NODE_46_next,
		.data = &ctkn_LDP_IPV6_NODE[46],
	},
	{
		.from = &gn_LDP_IPV6_NODE_47_prev,
		.to = &gn_LDP_IPV6_NODE_47_next,
		.data = &ctkn_LDP_IPV6_NODE[47],
	},
	{
		.from = &gn_LDP_IPV6_NODE_48_prev,
		.to = &gn_LDP_IPV6_NODE_48_next,
		.data = &ctkn_LDP_IPV6_NODE[48],
	},
	{
		.from = &gn_LDP_IPV6_NODE_49_prev,
		.to = &gn_LDP_IPV6_NODE_49_next,
		.data = &ctkn_LDP_IPV6_NODE[49],
	},
	{
		.from = &gn_LDP_IPV6_NODE_50_prev,
		.to = &gn_LDP_IPV6_NODE_50_next,
		.data = &ctkn_LDP_IPV6_NODE[50],
	},
	{
		.from = &gn_LDP_IPV6_NODE_51_prev,
		.to = &gn_LDP_IPV6_NODE_51_next,
		.data = &ctkn_LDP_IPV6_NODE[51],
	},
	{
		.from = &gn_LDP_IPV6_NODE_52_prev,
		.to = &gn_LDP_IPV6_NODE_52_next,
		.data = &ctkn_LDP_IPV6_NODE[52],
	},
	{
		.from = &gn_LDP_IPV6_NODE_53_prev,
		.to = &gn_LDP_IPV6_NODE_53_next,
		.data = (void *)&ldp_label_local_advertise_explicit_null_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_54_prev,
		.to = &gn_LDP_IPV6_NODE_54_next,
		.data = &ctkn_LDP_IPV6_NODE[54],
	},
	{
		.from = &gn_LDP_IPV6_NODE_55_prev,
		.to = &gn_LDP_IPV6_NODE_55_next,
		.data = &ctkn_LDP_IPV6_NODE[55],
	},
	{
		.from = &gn_LDP_IPV6_NODE_56_prev,
		.to = &gn_LDP_IPV6_NODE_56_next,
		.data = &ctkn_LDP_IPV6_NODE[56],
	},
	{
		.from = &gn_LDP_IPV6_NODE_57_prev,
		.to = &gn_LDP_IPV6_NODE_57_next,
		.data = &ctkn_LDP_IPV6_NODE[57],
	},
	{
		.from = &gn_LDP_IPV6_NODE_58_prev,
		.to = &gn_LDP_IPV6_NODE_58_next,
		.data = &ctkn_LDP_IPV6_NODE[58],
	},
	{
		.from = &gn_LDP_IPV6_NODE_59_prev,
		.to = &gn_LDP_IPV6_NODE_59_next,
		.data = (void *)&ldp_label_local_allocate_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_60_prev,
		.to = &gn_LDP_IPV6_NODE_60_next,
		.data = &ctkn_LDP_IPV6_NODE[60],
	},
	{
		.from = &gn_LDP_IPV6_NODE_61_prev,
		.to = &gn_LDP_IPV6_NODE_61_next,
		.data = &ctkn_LDP_IPV6_NODE[61],
	},
	{
		.from = &gn_LDP_IPV6_NODE_62_prev,
		.to = &gn_LDP_IPV6_NODE_62_next,
		.data = &ctkn_LDP_IPV6_NODE[62],
	},
	{
		.from = &gn_LDP_IPV6_NODE_63_prev,
		.to = &gn_LDP_IPV6_NODE_63_next,
		.data = &ctkn_LDP_IPV6_NODE[63],
	},
	{
		.from = &gn_LDP_IPV6_NODE_64_prev,
		.to = &gn_LDP_IPV6_NODE_64_next,
		.data = &ctkn_LDP_IPV6_NODE[64],
	},
	{
		.from = &gn_LDP_IPV6_NODE_65_prev,
		.to = &gn_LDP_IPV6_NODE_65_next,
		.data = &ctkn_LDP_IPV6_NODE[65],
	},
	{
		.from = &gn_LDP_IPV6_NODE_66_prev,
		.to = &gn_LDP_IPV6_NODE_66_next,
		.data = &ctkn_LDP_IPV6_NODE[66],
	},
	{
		.from = &gn_LDP_IPV6_NODE_67_prev,
		.to = &gn_LDP_IPV6_NODE_67_next,
		.data = &ctkn_LDP_IPV6_NODE[67],
	},
	{
		.from = &gn_LDP_IPV6_NODE_68_prev,
		.to = &gn_LDP_IPV6_NODE_68_next,
		.data = &ctkn_LDP_IPV6_NODE[68],
	},
	{
		.from = &gn_LDP_IPV6_NODE_69_prev,
		.to = &gn_LDP_IPV6_NODE_69_next,
		.data = (void *)&ldp_label_remote_accept_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_70_prev,
		.to = &gn_LDP_IPV6_NODE_70_next,
		.data = &ctkn_LDP_IPV6_NODE[70],
	},
	{
		.from = &gn_LDP_IPV6_NODE_71_prev,
		.to = &gn_LDP_IPV6_NODE_71_next,
		.data = &ctkn_LDP_IPV6_NODE[71],
	},
	{
		.from = &gn_LDP_IPV6_NODE_72_prev,
		.to = &gn_LDP_IPV6_NODE_72_next,
		.data = &ctkn_LDP_IPV6_NODE[72],
	},
	{
		.from = &gn_LDP_IPV6_NODE_73_prev,
		.to = &gn_LDP_IPV6_NODE_73_next,
		.data = &ctkn_LDP_IPV6_NODE[73],
	},
	{
		.from = &gn_LDP_IPV6_NODE_74_prev,
		.to = &gn_LDP_IPV6_NODE_74_next,
		.data = &ctkn_LDP_IPV6_NODE[74],
	},
	{
		.from = &gn_LDP_IPV6_NODE_75_prev,
		.to = &gn_LDP_IPV6_NODE_75_next,
		.data = &ctkn_LDP_IPV6_NODE[75],
	},
	{
		.from = &gn_LDP_IPV6_NODE_76_prev,
		.to = &gn_LDP_IPV6_NODE_76_next,
		.data = (void *)&ldp_neighbor_ipv6_targeted_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_77_prev,
		.to = &gn_LDP_IPV6_NODE_77_next,
		.data = &ctkn_LDP_IPV6_NODE[77],
	},
	{
		.from = &gn_LDP_IPV6_NODE_78_prev,
		.to = &gn_LDP_IPV6_NODE_78_next,
		.data = &ctkn_LDP_IPV6_NODE[78],
	},
	{
		.from = &gn_LDP_IPV6_NODE_79_prev,
		.to = &gn_LDP_IPV6_NODE_79_next,
		.data = &ctkn_LDP_IPV6_NODE[79],
	},
	{
		.from = &gn_LDP_IPV6_NODE_80_prev,
		.to = &gn_LDP_IPV6_NODE_80_next,
		.data = &ctkn_LDP_IPV6_NODE[80],
	},
	{
		.from = &gn_LDP_IPV6_NODE_81_prev,
		.to = &gn_LDP_IPV6_NODE_81_next,
		.data = (void *)&ldp_session_holdtime_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_82_prev,
		.to = &gn_LDP_IPV6_NODE_82_next,
		.data = &ctkn_LDP_IPV6_NODE[82],
	},
	{
		.from = &gn_LDP_IPV6_NODE_83_prev,
		.to = &gn_LDP_IPV6_NODE_83_next,
		.data = &ctkn_LDP_IPV6_NODE[83],
	},
	{
		.from = &gn_LDP_IPV6_NODE_84_prev,
		.to = &gn_LDP_IPV6_NODE_84_next,
		.data = &ctkn_LDP_IPV6_NODE[84],
	},
	{
		.from = &gn_LDP_IPV6_NODE_85_prev,
		.to = &gn_LDP_IPV6_NODE_85_next,
		.data = (void *)&ldp_ttl_security_disable_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV6_NODE_86_prev,
		.to = &gn_LDP_IPV6_NODE_86_next,
		.data = &ctkn_LDP_IPV6_NODE[86],
	},
	{
		.from = &gn_LDP_IPV6_NODE_87_prev,
		.to = &gn_LDP_IPV6_NODE_87_next,
		.data = &ctkn_LDP_IPV6_NODE[87],
	},
	{
		.from = &gn_LDP_IPV6_NODE_88_prev,
		.to = &gn_LDP_IPV6_NODE_88_next,
		.data = &ctkn_LDP_IPV6_NODE[88],
	},
	{
		.from = &gn_LDP_IPV6_NODE_89_prev,
		.to = &gn_LDP_IPV6_NODE_89_next,
		.data = &ctkn_LDP_IPV6_NODE[89],
	},
	{
		.from = &gn_LDP_IPV6_NODE_90_prev,
		.to = &gn_LDP_IPV6_NODE_90_next,
		.data = (void *)&no_ldp_interface_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_LDP_IPV6_NODE, 91, &gn_LDP_IPV6_NODE[0], &gn_LDP_IPV6_NODE[1], &gn_LDP_IPV6_NODE[2], &gn_LDP_IPV6_NODE[3], &gn_LDP_IPV6_NODE[4], &gn_LDP_IPV6_NODE[5], &gn_LDP_IPV6_NODE[6], &gn_LDP_IPV6_NODE[7], &gn_LDP_IPV6_NODE[8], &gn_LDP_IPV6_NODE[9], &gn_LDP_IPV6_NODE[10], &gn_LDP_IPV6_NODE[11], &gn_LDP_IPV6_NODE[12], &gn_LDP_IPV6_NODE[13], &gn_LDP_IPV6_NODE[14], &gn_LDP_IPV6_NODE[15], &gn_LDP_IPV6_NODE[16], &gn_LDP_IPV6_NODE[17], &gn_LDP_IPV6_NODE[18], &gn_LDP_IPV6_NODE[19], &gn_LDP_IPV6_NODE[20], &gn_LDP_IPV6_NODE[21], &gn_LDP_IPV6_NODE[22], &gn_LDP_IPV6_NODE[23], &gn_LDP_IPV6_NODE[24], &gn_LDP_IPV6_NODE[25], &gn_LDP_IPV6_NODE[26], &gn_LDP_IPV6_NODE[27], &gn_LDP_IPV6_NODE[28], &gn_LDP_IPV6_NODE[29], &gn_LDP_IPV6_NODE[30], &gn_LDP_IPV6_NODE[31], &gn_LDP_IPV6_NODE[32], &gn_LDP_IPV6_NODE[33], &gn_LDP_IPV6_NODE[34], &gn_LDP_IPV6_NODE[35], &gn_LDP_IPV6_NODE[36], &gn_LDP_IPV6_NODE[37], &gn_LDP_IPV6_NODE[38], &gn_LDP_IPV6_NODE[39], &gn_LDP_IPV6_NODE[40], &gn_LDP_IPV6_NODE[41], &gn_LDP_IPV6_NODE[42], &gn_LDP_IPV6_NODE[43], &gn_LDP_IPV6_NODE[44], &gn_LDP_IPV6_NODE[45], &gn_LDP_IPV6_NODE[46], &gn_LDP_IPV6_NODE[47], &gn_LDP_IPV6_NODE[48], &gn_LDP_IPV6_NODE[49], &gn_LDP_IPV6_NODE[50], &gn_LDP_IPV6_NODE[51], &gn_LDP_IPV6_NODE[52], &gn_LDP_IPV6_NODE[53], &gn_LDP_IPV6_NODE[54], &gn_LDP_IPV6_NODE[55], &gn_LDP_IPV6_NODE[56], &gn_LDP_IPV6_NODE[57], &gn_LDP_IPV6_NODE[58], &gn_LDP_IPV6_NODE[59], &gn_LDP_IPV6_NODE[60], &gn_LDP_IPV6_NODE[61], &gn_LDP_IPV6_NODE[62], &gn_LDP_IPV6_NODE[63], &gn_LDP_IPV6_NODE[64], &gn_LDP_IPV6_NODE[65], &gn_LDP_IPV6_NODE[66], &gn_LDP_IPV6_NODE[67], &gn_LDP_IPV6_NODE[68], &gn_LDP_IPV6_NODE[69], &gn_LDP_IPV6_NODE[70], &gn_LDP_IPV6_NODE[71], &gn_LDP_IPV6_NODE[72], &gn_LDP_IPV6_NODE[73], &gn_LDP_IPV6_NODE[74], &gn_LDP_IPV6_NODE[75], &gn_LDP_IPV6_NODE[76], &gn_LDP_IPV6_NODE[77], &gn_LDP_IPV6_NODE[78], &gn_LDP_IPV6_NODE[79], &gn_LDP_IPV6_NODE[80], &gn_LDP_IPV6_NODE[81], &gn_LDP_IPV6_NODE[82], &gn_LDP_IPV6_NODE[83], &gn_LDP_IPV6_NODE[84], &gn_LDP_IPV6_NODE[85], &gn_LDP_IPV6_NODE[86], &gn_LDP_IPV6_NODE[87], &gn_LDP_IPV6_NODE[88], &gn_LDP_IPV6_NODE[89], &gn_LDP_IPV6_NODE[90]);

extern void install_LDP_IPV6_NODE(void);

void install_LDP_IPV6_NODE(void)

{
	unsigned node_id = LDP_IPV6_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_LDP_IPV6_NODE;
	vector_set(node->cmd_vector, &ldp_discovery_link_holdtime_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_link_interval_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_targeted_hello_accept_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_targeted_holdtime_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_targeted_interval_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_transport_address_ipv6_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_label_local_advertise_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_label_local_advertise_explicit_null_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_label_local_allocate_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_label_remote_accept_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_neighbor_ipv6_targeted_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_session_holdtime_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_ttl_security_disable_cmd_vtysh);
	vector_set(node->cmd_vector, &no_ldp_interface_cmd_vtysh);
}

static struct cmd_token ctkn_PCEP_NODE[];
static struct graph_node gn_PCEP_NODE[];

static struct cmd_token ctkn_PCEP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [2] */
		.type = WORD_TKN,
		.text = (char *)"pcc",
		.desc = (char *)"PCC configuration",
	},
	{ /* [3] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [4] = pcep_cli_no_pcc_cmd */ },
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"pce",
		.desc = (char *)"PCE configuration, address sub-config is mandatory",
	},
	{ /* [6] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"PCE name",
		.varname = (char *)"name",
	},
	{ /* [7] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [8] = pcep_cli_no_pce_cmd */ },
	{ /* [9] */
		.type = WORD_TKN,
		.text = (char *)"pce-config",
		.desc = (char *)"Shared configuration",
	},
	{ /* [10] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Shared configuration name",
		.varname = (char *)"name",
	},
	{ /* [11] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [12] = pcep_cli_pcep_no_pce_config_cmd */ },
};

extern struct cmd_element pcep_cli_no_pcc_cmd_vtysh;
extern struct cmd_element pcep_cli_no_pce_cmd_vtysh;
extern struct cmd_element pcep_cli_pcep_no_pce_config_cmd_vtysh;

MAKE_VECTOR(gn_PCEP_NODE_0_next, 1, &gn_PCEP_NODE[1]);
MAKE_VECTOR(gn_PCEP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_PCEP_NODE_1_next, 3, &gn_PCEP_NODE[2], &gn_PCEP_NODE[5], &gn_PCEP_NODE[9]);
MAKE_VECTOR(gn_PCEP_NODE_1_prev, 1, &gn_PCEP_NODE[0]);
MAKE_VECTOR(gn_PCEP_NODE_2_next, 1, &gn_PCEP_NODE[3]);
MAKE_VECTOR(gn_PCEP_NODE_2_prev, 1, &gn_PCEP_NODE[1]);
MAKE_VECTOR(gn_PCEP_NODE_3_next, 1, &gn_PCEP_NODE[4]);
MAKE_VECTOR(gn_PCEP_NODE_3_prev, 1, &gn_PCEP_NODE[2]);
MAKE_VECTOR(gn_PCEP_NODE_4_next, 0, );
MAKE_VECTOR(gn_PCEP_NODE_4_prev, 1, &gn_PCEP_NODE[3]);
MAKE_VECTOR(gn_PCEP_NODE_5_next, 1, &gn_PCEP_NODE[6]);
MAKE_VECTOR(gn_PCEP_NODE_5_prev, 1, &gn_PCEP_NODE[1]);
MAKE_VECTOR(gn_PCEP_NODE_6_next, 1, &gn_PCEP_NODE[7]);
MAKE_VECTOR(gn_PCEP_NODE_6_prev, 1, &gn_PCEP_NODE[5]);
MAKE_VECTOR(gn_PCEP_NODE_7_next, 1, &gn_PCEP_NODE[8]);
MAKE_VECTOR(gn_PCEP_NODE_7_prev, 1, &gn_PCEP_NODE[6]);
MAKE_VECTOR(gn_PCEP_NODE_8_next, 0, );
MAKE_VECTOR(gn_PCEP_NODE_8_prev, 1, &gn_PCEP_NODE[7]);
MAKE_VECTOR(gn_PCEP_NODE_9_next, 1, &gn_PCEP_NODE[10]);
MAKE_VECTOR(gn_PCEP_NODE_9_prev, 1, &gn_PCEP_NODE[1]);
MAKE_VECTOR(gn_PCEP_NODE_10_next, 1, &gn_PCEP_NODE[11]);
MAKE_VECTOR(gn_PCEP_NODE_10_prev, 1, &gn_PCEP_NODE[9]);
MAKE_VECTOR(gn_PCEP_NODE_11_next, 1, &gn_PCEP_NODE[12]);
MAKE_VECTOR(gn_PCEP_NODE_11_prev, 1, &gn_PCEP_NODE[10]);
MAKE_VECTOR(gn_PCEP_NODE_12_next, 0, );
MAKE_VECTOR(gn_PCEP_NODE_12_prev, 1, &gn_PCEP_NODE[11]);

static struct graph_node gn_PCEP_NODE[] = {
	{
		.from = &gn_PCEP_NODE_0_prev,
		.to = &gn_PCEP_NODE_0_next,
		.data = &ctkn_PCEP_NODE[0],
	},
	{
		.from = &gn_PCEP_NODE_1_prev,
		.to = &gn_PCEP_NODE_1_next,
		.data = &ctkn_PCEP_NODE[1],
	},
	{
		.from = &gn_PCEP_NODE_2_prev,
		.to = &gn_PCEP_NODE_2_next,
		.data = &ctkn_PCEP_NODE[2],
	},
	{
		.from = &gn_PCEP_NODE_3_prev,
		.to = &gn_PCEP_NODE_3_next,
		.data = &ctkn_PCEP_NODE[3],
	},
	{
		.from = &gn_PCEP_NODE_4_prev,
		.to = &gn_PCEP_NODE_4_next,
		.data = (void *)&pcep_cli_no_pcc_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_NODE_5_prev,
		.to = &gn_PCEP_NODE_5_next,
		.data = &ctkn_PCEP_NODE[5],
	},
	{
		.from = &gn_PCEP_NODE_6_prev,
		.to = &gn_PCEP_NODE_6_next,
		.data = &ctkn_PCEP_NODE[6],
	},
	{
		.from = &gn_PCEP_NODE_7_prev,
		.to = &gn_PCEP_NODE_7_next,
		.data = &ctkn_PCEP_NODE[7],
	},
	{
		.from = &gn_PCEP_NODE_8_prev,
		.to = &gn_PCEP_NODE_8_next,
		.data = (void *)&pcep_cli_no_pce_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_NODE_9_prev,
		.to = &gn_PCEP_NODE_9_next,
		.data = &ctkn_PCEP_NODE[9],
	},
	{
		.from = &gn_PCEP_NODE_10_prev,
		.to = &gn_PCEP_NODE_10_next,
		.data = &ctkn_PCEP_NODE[10],
	},
	{
		.from = &gn_PCEP_NODE_11_prev,
		.to = &gn_PCEP_NODE_11_next,
		.data = &ctkn_PCEP_NODE[11],
	},
	{
		.from = &gn_PCEP_NODE_12_prev,
		.to = &gn_PCEP_NODE_12_next,
		.data = (void *)&pcep_cli_pcep_no_pce_config_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_PCEP_NODE, 13, &gn_PCEP_NODE[0], &gn_PCEP_NODE[1], &gn_PCEP_NODE[2], &gn_PCEP_NODE[3], &gn_PCEP_NODE[4], &gn_PCEP_NODE[5], &gn_PCEP_NODE[6], &gn_PCEP_NODE[7], &gn_PCEP_NODE[8], &gn_PCEP_NODE[9], &gn_PCEP_NODE[10], &gn_PCEP_NODE[11], &gn_PCEP_NODE[12]);

extern void install_PCEP_NODE(void);

void install_PCEP_NODE(void)

{
	unsigned node_id = PCEP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_PCEP_NODE;
	vector_set(node->cmd_vector, &pcep_cli_no_pcc_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_no_pce_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_pcep_no_pce_config_cmd_vtysh);
}
