/* autogenerated file, DO NOT EDIT! */
#include <zebra.h>

#include "command.h"
#include "linklist.h"

#include "vtysh/vtysh.h"

#pragma GCC visibility push(internal)

#define MAKE_VECTOR(name, len, ...)                        \
        static void * name ## _vitems[] = { __VA_ARGS__ }; \
        static struct _vector name = {                     \
                .active = len,                             \
                .count = len,                              \
                .index = name ## _vitems,                  \
        }

static struct cmd_token ctkn_SRV6_SID_FORMATS_NODE[];
static struct graph_node gn_SRV6_SID_FORMATS_NODE[];

static struct cmd_token ctkn_SRV6_SID_FORMATS_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [2] */
		.type = WORD_TKN,
		.text = (char *)"format",
		.desc = (char *)"Configure SRv6 SID format",
	},
	{ /* [3] */
		.type = WORD_TKN,
		.text = (char *)"uncompressed-f4024",
		.desc = (char *)"Configure the uncompressed f4024 format",
	},
	{ /* [4] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [5] = no_srv6_sid_format_f4024_uncompressed_cmd */ },
	{ /* [6] */
		.type = WORD_TKN,
		.text = (char *)"usid-f3216",
		.desc = (char *)"Configure the uSID f3216 format",
	},
	{ /* [7] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [8] = no_srv6_sid_format_f3216_usid_cmd */ },
	{ /* [9] */
		.type = WORD_TKN,
		.text = (char *)"usid-f4816",
		.desc = (char *)"Configure the uSID f4816 format",
	},
	{ /* [10] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [11] = no_srv6_sid_format_f4816_usid_cmd */ },
};

extern struct cmd_element no_srv6_sid_format_f3216_usid_cmd_vtysh;
extern struct cmd_element no_srv6_sid_format_f4024_uncompressed_cmd_vtysh;
extern struct cmd_element no_srv6_sid_format_f4816_usid_cmd_vtysh;

MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_0_next, 1, &gn_SRV6_SID_FORMATS_NODE[1]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_0_prev, 0, );
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_1_next, 1, &gn_SRV6_SID_FORMATS_NODE[2]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_1_prev, 1, &gn_SRV6_SID_FORMATS_NODE[0]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_2_next, 3, &gn_SRV6_SID_FORMATS_NODE[3], &gn_SRV6_SID_FORMATS_NODE[6], &gn_SRV6_SID_FORMATS_NODE[9]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_2_prev, 1, &gn_SRV6_SID_FORMATS_NODE[1]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_3_next, 1, &gn_SRV6_SID_FORMATS_NODE[4]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_3_prev, 1, &gn_SRV6_SID_FORMATS_NODE[2]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_4_next, 1, &gn_SRV6_SID_FORMATS_NODE[5]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_4_prev, 1, &gn_SRV6_SID_FORMATS_NODE[3]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_5_next, 0, );
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_5_prev, 1, &gn_SRV6_SID_FORMATS_NODE[4]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_6_next, 1, &gn_SRV6_SID_FORMATS_NODE[7]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_6_prev, 1, &gn_SRV6_SID_FORMATS_NODE[2]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_7_next, 1, &gn_SRV6_SID_FORMATS_NODE[8]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_7_prev, 1, &gn_SRV6_SID_FORMATS_NODE[6]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_8_next, 0, );
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_8_prev, 1, &gn_SRV6_SID_FORMATS_NODE[7]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_9_next, 1, &gn_SRV6_SID_FORMATS_NODE[10]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_9_prev, 1, &gn_SRV6_SID_FORMATS_NODE[2]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_10_next, 1, &gn_SRV6_SID_FORMATS_NODE[11]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_10_prev, 1, &gn_SRV6_SID_FORMATS_NODE[9]);
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_11_next, 0, );
MAKE_VECTOR(gn_SRV6_SID_FORMATS_NODE_11_prev, 1, &gn_SRV6_SID_FORMATS_NODE[10]);

static struct graph_node gn_SRV6_SID_FORMATS_NODE[] = {
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_0_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_0_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[0],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_1_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_1_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[1],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_2_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_2_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[2],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_3_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_3_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[3],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_4_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_4_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[4],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_5_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_5_next,
		.data = (void *)&no_srv6_sid_format_f4024_uncompressed_cmd_vtysh,
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_6_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_6_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[6],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_7_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_7_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[7],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_8_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_8_next,
		.data = (void *)&no_srv6_sid_format_f3216_usid_cmd_vtysh,
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_9_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_9_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[9],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_10_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_10_next,
		.data = &ctkn_SRV6_SID_FORMATS_NODE[10],
	},
	{
		.from = &gn_SRV6_SID_FORMATS_NODE_11_prev,
		.to = &gn_SRV6_SID_FORMATS_NODE_11_next,
		.data = (void *)&no_srv6_sid_format_f4816_usid_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_SRV6_SID_FORMATS_NODE, 12, &gn_SRV6_SID_FORMATS_NODE[0], &gn_SRV6_SID_FORMATS_NODE[1], &gn_SRV6_SID_FORMATS_NODE[2], &gn_SRV6_SID_FORMATS_NODE[3], &gn_SRV6_SID_FORMATS_NODE[4], &gn_SRV6_SID_FORMATS_NODE[5], &gn_SRV6_SID_FORMATS_NODE[6], &gn_SRV6_SID_FORMATS_NODE[7], &gn_SRV6_SID_FORMATS_NODE[8], &gn_SRV6_SID_FORMATS_NODE[9], &gn_SRV6_SID_FORMATS_NODE[10], &gn_SRV6_SID_FORMATS_NODE[11]);

extern void install_SRV6_SID_FORMATS_NODE(void);

void install_SRV6_SID_FORMATS_NODE(void)

{
	unsigned node_id = SRV6_SID_FORMATS_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_SRV6_SID_FORMATS_NODE;
	vector_set(node->cmd_vector, &no_srv6_sid_format_f3216_usid_cmd_vtysh);
	vector_set(node->cmd_vector, &no_srv6_sid_format_f4024_uncompressed_cmd_vtysh);
	vector_set(node->cmd_vector, &no_srv6_sid_format_f4816_usid_cmd_vtysh);
}

static struct cmd_token ctkn_BGP_IPV4M_NODE[];
static struct graph_node gn_BGP_IPV4M_NODE[];

static struct cmd_token ctkn_BGP_IPV4M_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"aggregate-address",
		.desc = (char *)"Configure BGP aggregate entries",
	},
	{ /* [5] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[7],
	},
	{ /* [6] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"Aggregate prefix",
		.varname = (char *)"prefix",
	},
	{ /* [7] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[5],
	},
	{ /* [8] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[12],
	},
	{ /* [9] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[11],
	},
	{ /* [10] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"as-set",
		.desc = (char *)"Generate AS set path information",
		.varname = (char *)"as_set_s",
	},
	{ /* [11] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[9],
	},
	{ /* [12] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[8],
	},
	{ /* [13] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [14] = aggregate_addressv4_cmd */ },
	{ /* [15] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"summary-only",
		.desc = (char *)"Filter more specific routes from updates",
		.varname = (char *)"summary_only",
	},
	{ /* [16] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to aggregate network",
	},
	{ /* [17] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Route map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [18] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"BGP origin code",
	},
	{ /* [19] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[21],
	},
	{ /* [20] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"egp",
		.desc = (char *)"Remote EGP",
		.varname = (char *)"origin_s",
	},
	{ /* [21] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[19],
	},
	{ /* [22] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"igp",
		.desc = (char *)"Local IGP",
		.varname = (char *)"origin_s",
	},
	{ /* [23] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"incomplete",
		.desc = (char *)"Unknown heritage",
		.varname = (char *)"origin_s",
	},
	{ /* [24] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"matching-MED-only",
		.desc = (char *)"Only aggregate routes with matching MED",
		.varname = (char *)"match_med",
	},
	{ /* [25] */
		.type = WORD_TKN,
		.text = (char *)"suppress-map",
		.desc = (char *)"Suppress the selected more specific routes",
	},
	{ /* [26] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Route map with the route selectors",
		.varname = (char *)"suppress_map",
	},
	{ /* [27] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Aggregate address",
		.varname = (char *)"addr",
	},
	{ /* [28] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Aggregate mask",
		.varname = (char *)"mask",
	},
	{ /* [29] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [30] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[32],
	},
	{ /* [31] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [32] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[30],
	},
	{ /* [33] */
		.type = WORD_TKN,
		.text = (char *)"advertise-map",
		.desc = (char *)"Route-map to conditionally advertise routes",
	},
	{ /* [34] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of advertise map",
		.varname = (char *)"advertise_str",
	},
	{ /* [35] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[37],
	},
	{ /* [36] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"exist-map",
		.desc = (char *)"Advertise routes only if prefixes in exist-map are installed in BGP table",
		.varname = (char *)"exist",
	},
	{ /* [37] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[35],
	},
	{ /* [38] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of the exist or non exist map",
		.varname = (char *)"condition_str",
	},
	{ /* [39] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [40] = neighbor_advertise_map_cmd */ },
	{ /* [41] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"non-exist-map",
		.desc = (char *)"Advertise routes only if prefixes in non-exist-map are not installed in BGP table",
		.varname = (char *)"exist",
	},
	{ /* [42] */
		.type = IPV6_TKN,
		.varname_src = 4,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [43] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [44] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [45] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [46] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Send RPKI Extended Community attributes",
	},
	{ /* [47] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [48] = neighbor_ecommunity_rpki_cmd */ },
	{ /* [49] */
		.type = WORD_TKN,
		.text = (char *)"network",
		.desc = (char *)"Specify a network to announce via BGP",
	},
	{ /* [50] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[52],
	},
	{ /* [51] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IPv4 prefix",
		.varname = (char *)"prefix",
	},
	{ /* [52] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[50],
	},
	{ /* [53] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[58],
	},
	{ /* [54] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[57],
	},
	{ /* [55] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to modify the attributes",
	},
	{ /* [56] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"map_name",
	},
	{ /* [57] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[54],
	},
	{ /* [58] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[53],
	},
	{ /* [59] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [60] = bgp_network_cmd */ },
	{ /* [61] */
		.type = WORD_TKN,
		.text = (char *)"label-index",
		.desc = (char *)"Label index to associate with the prefix",
	},
	{ /* [62] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-1048560)",
		.desc = (char *)"Label index value",
		.max = 1048560,
		.varname = (char *)"label_index",
	},
	{ /* [63] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"backdoor",
		.desc = (char *)"Specify a BGP backdoor route",
		.varname = (char *)"backdoor",
	},
	{ /* [64] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Network number",
		.varname = (char *)"address",
	},
	{ /* [65] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[68],
	},
	{ /* [66] */
		.type = WORD_TKN,
		.text = (char *)"mask",
		.desc = (char *)"Network mask",
	},
	{ /* [67] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Network mask",
		.varname = (char *)"netmask",
	},
	{ /* [68] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[65],
	},
	{ /* [69] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP Specific commands",
	},
	{ /* [70] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable route-flap dampening",
	},
	{ /* [71] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[78],
	},
	{ /* [72] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"dampening",
	},
	{ /* [73] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[77],
	},
	{ /* [74] */
		.type = RANGE_TKN,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
	},
	{ /* [75] */
		.type = RANGE_TKN,
		.text = (char *)"(1-50000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 50000,
	},
	{ /* [76] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
	},
	{ /* [77] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[73],
	},
	{ /* [78] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[71],
	},
	{ /* [79] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [80] = bgp_damp_set_cmd */ },
	{ /* [81] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Define an administrative distance",
	},
	{ /* [82] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Administrative distance",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [83] */
		.type = IPV4_PREFIX_TKN,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP source prefix",
	},
	{ /* [84] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [85] = bgp_distance_source_cmd */ },
	{ /* [86] */
		.type = VARIABLE_TKN,
		.text = (char *)"WORD",
		.desc = (char *)"Access list name",
	},
	{ /* [87] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [88] = bgp_distance_source_access_list_cmd */ },
	{ /* [89] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP distance",
	},
	{ /* [90] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes external to the AS",
		.min = 1,
		.max = 255,
		.varname = (char *)"bgp",
	},
	{ /* [91] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes internal to the AS",
		.min = 1,
		.max = 255,
	},
	{ /* [92] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for local routes",
		.min = 1,
		.max = 255,
	},
	{ /* [93] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [94] = bgp_distance_cmd */ },
	{ /* [95] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [96] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[98],
	},
	{ /* [97] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [98] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[96],
	},
	{ /* [99] */
		.type = WORD_TKN,
		.text = (char *)"activate",
		.desc = (char *)"Enable the Address Family for this Neighbor",
	},
	{ /* [100] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [101] = neighbor_activate_cmd */ },
	{ /* [102] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [103] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [104] */
		.type = WORD_TKN,
		.text = (char *)"addpath-rx-paths-limit",
		.desc = (char *)"Paths Limit for Addpath to receive from the peer",
	},
	{ /* [105] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Maximum number of paths",
		.min = 1,
		.max = 65535,
		.varname = (char *)"paths_limit",
	},
	{ /* [106] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [107] = neighbor_addpath_paths_limit_cmd */ },
	{ /* [108] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-all-paths",
		.desc = (char *)"Use addpath to advertise all paths to a neighbor",
	},
	{ /* [109] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [110] = neighbor_addpath_tx_all_paths_cmd */ },
	{ /* [111] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-best-selected",
		.desc = (char *)"Use addpath to advertise best selected paths to a neighbor",
	},
	{ /* [112] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-6)",
		.desc = (char *)"The number of best paths",
		.min = 1,
		.max = 6,
		.varname = (char *)"paths",
	},
	{ /* [113] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [114] = neighbor_addpath_tx_best_selected_paths_cmd */ },
	{ /* [115] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-bestpath-per-AS",
		.desc = (char *)"Use addpath to advertise the bestpath per each neighboring AS",
	},
	{ /* [116] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [117] = neighbor_addpath_tx_bestpath_per_as_cmd */ },
	{ /* [118] */
		.type = WORD_TKN,
		.text = (char *)"allowas-in",
		.desc = (char *)"Accept as-path with my AS present in it",
	},
	{ /* [119] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[123],
	},
	{ /* [120] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[122],
	},
	{ /* [121] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of occurrences of AS number",
		.min = 1,
		.max = 10,
		.varname = (char *)"allowas_in",
	},
	{ /* [122] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[120],
	},
	{ /* [123] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[119],
	},
	{ /* [124] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [125] = neighbor_allowas_in_cmd */ },
	{ /* [126] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"Only accept my AS in the as-path if the route was originated in my AS",
	},
	{ /* [127] */
		.type = WORD_TKN,
		.text = (char *)"as-override",
		.desc = (char *)"Override ASNs in outbound updates if aspath equals remote-as",
	},
	{ /* [128] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [129] = neighbor_as_override_cmd */ },
	{ /* [130] */
		.type = WORD_TKN,
		.text = (char *)"attribute-unchanged",
		.desc = (char *)"BGP attribute is propagated unchanged to this neighbor",
	},
	{ /* [131] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[135],
	},
	{ /* [132] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[134],
	},
	{ /* [133] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"As-path attribute",
	},
	{ /* [134] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[132],
	},
	{ /* [135] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[131],
	},
	{ /* [136] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [137] = neighbor_attr_unchanged_cmd */ },
	{ /* [138] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Nexthop attribute",
	},
	{ /* [139] */
		.type = WORD_TKN,
		.text = (char *)"med",
		.desc = (char *)"Med attribute",
	},
	{ /* [140] */
		.type = WORD_TKN,
		.text = (char *)"capability",
		.desc = (char *)"Advertise capability to the peer",
	},
	{ /* [141] */
		.type = WORD_TKN,
		.text = (char *)"orf",
		.desc = (char *)"Advertise ORF capability to the peer",
	},
	{ /* [142] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Advertise prefixlist ORF capability to this neighbor",
	},
	{ /* [143] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[145],
	},
	{ /* [144] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Capability to SEND and RECEIVE the ORF to/from this neighbor",
	},
	{ /* [145] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[143],
	},
	{ /* [146] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [147] = neighbor_capability_orf_prefix_cmd */ },
	{ /* [148] */
		.type = WORD_TKN,
		.text = (char *)"send",
		.desc = (char *)"Capability to RECEIVE the ORF from this neighbor",
	},
	{ /* [149] */
		.type = WORD_TKN,
		.text = (char *)"receive",
		.desc = (char *)"Capability to SEND the ORF to this neighbor",
	},
	{ /* [150] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable neighbor route-flap dampening",
	},
	{ /* [151] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[158],
	},
	{ /* [152] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"half",
	},
	{ /* [153] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[157],
	},
	{ /* [154] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
		.varname = (char *)"reuse",
	},
	{ /* [155] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 20000,
		.varname = (char *)"suppress",
	},
	{ /* [156] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
		.varname = (char *)"max",
	},
	{ /* [157] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[153],
	},
	{ /* [158] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[151],
	},
	{ /* [159] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [160] = neighbor_damp_cmd */ },
	{ /* [161] */
		.type = WORD_TKN,
		.text = (char *)"default-originate",
		.desc = (char *)"Originate default route to this neighbor",
	},
	{ /* [162] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [163] = neighbor_default_originate_cmd */ },
	{ /* [164] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to specify criteria to originate default",
	},
	{ /* [165] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"route-map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [166] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [167] = neighbor_default_originate_rmap_cmd */ },
	{ /* [168] */
		.type = WORD_TKN,
		.text = (char *)"disable-addpath-rx",
		.desc = (char *)"Do not accept additional paths",
	},
	{ /* [169] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [170] = neighbor_disable_addpath_rx_cmd */ },
	{ /* [171] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [172] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist_name",
	},
	{ /* [173] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[175],
	},
	{ /* [174] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [175] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[173],
	},
	{ /* [176] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [177] = neighbor_distribute_list_cmd */ },
	{ /* [178] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [179] */
		.type = WORD_TKN,
		.text = (char *)"filter-list",
		.desc = (char *)"Establish BGP filters",
	},
	{ /* [180] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [181] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[183],
	},
	{ /* [182] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routes",
	},
	{ /* [183] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[181],
	},
	{ /* [184] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [185] = neighbor_filter_list_cmd */ },
	{ /* [186] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routes",
	},
	{ /* [187] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix",
		.desc = (char *)"Maximum number of prefix accept from this peer",
	},
	{ /* [188] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix",
	},
	{ /* [189] */
		.type = RANGE_TKN,
		.text = (char *)"(1-100)",
		.desc = (char *)"Threshold value (%) at which to generate a warning msg",
		.min = 1,
		.max = 100,
	},
	{ /* [190] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[192],
	},
	{ /* [191] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [192] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[190],
	},
	{ /* [193] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [194] = neighbor_maximum_prefix_threshold_cmd */ },
	{ /* [195] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [196] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [197] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[199],
	},
	{ /* [198] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [199] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[197],
	},
	{ /* [200] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [201] = neighbor_maximum_prefix_threshold_restart_cmd */ },
	{ /* [202] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [203] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[205],
	},
	{ /* [204] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [205] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[203],
	},
	{ /* [206] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [207] = neighbor_maximum_prefix_threshold_warning_cmd */ },
	{ /* [208] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[210],
	},
	{ /* [209] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [210] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[208],
	},
	{ /* [211] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [212] = neighbor_maximum_prefix_cmd */ },
	{ /* [213] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [214] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [215] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[217],
	},
	{ /* [216] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [217] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[215],
	},
	{ /* [218] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [219] = neighbor_maximum_prefix_restart_cmd */ },
	{ /* [220] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [221] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[223],
	},
	{ /* [222] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [223] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[221],
	},
	{ /* [224] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [225] = neighbor_maximum_prefix_warning_cmd */ },
	{ /* [226] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix-out",
		.desc = (char *)"Maximum number of prefixes to be sent to this peer",
	},
	{ /* [227] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix_out",
	},
	{ /* [228] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [229] = neighbor_maximum_prefix_out_cmd */ },
	{ /* [230] */
		.type = WORD_TKN,
		.text = (char *)"next-hop-self",
		.desc = (char *)"Disable the next hop calculation for this neighbor",
	},
	{ /* [231] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [232] = neighbor_nexthop_self_cmd */ },
	{ /* [233] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [234] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [235] = neighbor_nexthop_self_all_hidden_cmd */ },
	{ /* [236] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [237] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [238] = neighbor_nexthop_self_force_cmd */ },
	{ /* [239] */
		.type = WORD_TKN,
		.text = (char *)"peer-group",
		.desc = (char *)"Member of the peer-group",
	},
	{ /* [240] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PGNAME",
		.desc = (char *)"Peer-group name",
		.varname = (char *)"pgname",
	},
	{ /* [241] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [242] = neighbor_set_peer_group_hidden_cmd */ },
	{ /* [243] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [244] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of a prefix list",
		.varname = (char *)"prefix_list",
	},
	{ /* [245] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[247],
	},
	{ /* [246] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [247] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[245],
	},
	{ /* [248] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [249] = neighbor_prefix_list_cmd */ },
	{ /* [250] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [251] */
		.type = WORD_TKN,
		.text = (char *)"remove-private-AS",
		.desc = (char *)"Remove private ASNs in outbound updates",
	},
	{ /* [252] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [253] = neighbor_remove_private_as_cmd */ },
	{ /* [254] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Apply to all AS numbers",
	},
	{ /* [255] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [256] = neighbor_remove_private_as_all_cmd */ },
	{ /* [257] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [258] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [259] = neighbor_remove_private_as_all_replace_as_cmd */ },
	{ /* [260] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [261] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [262] = neighbor_remove_private_as_replace_as_cmd */ },
	{ /* [263] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to neighbor",
	},
	{ /* [264] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of route map",
		.varname = (char *)"rmap_name",
	},
	{ /* [265] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[267],
	},
	{ /* [266] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Apply map to incoming routes",
	},
	{ /* [267] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[265],
	},
	{ /* [268] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [269] = neighbor_route_map_cmd */ },
	{ /* [270] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Apply map to outbound routes",
	},
	{ /* [271] */
		.type = WORD_TKN,
		.text = (char *)"route-reflector-client",
		.desc = (char *)"Configure a neighbor as Route Reflector client",
	},
	{ /* [272] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [273] = neighbor_route_reflector_client_cmd */ },
	{ /* [274] */
		.type = WORD_TKN,
		.text = (char *)"route-server-client",
		.desc = (char *)"Configure a neighbor as Route Server client",
	},
	{ /* [275] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [276] = neighbor_route_server_client_cmd */ },
	{ /* [277] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [278] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [279] = neighbor_send_community_cmd */ },
	{ /* [280] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[282],
	},
	{ /* [281] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Send Standard and Extended Community attributes",
	},
	{ /* [282] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[280],
	},
	{ /* [283] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [284] = neighbor_send_community_type_cmd */ },
	{ /* [285] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Send Standard, Large and Extended Community attributes",
	},
	{ /* [286] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [287] */
		.type = WORD_TKN,
		.text = (char *)"standard",
		.desc = (char *)"Send Standard Community attributes",
	},
	{ /* [288] */
		.type = WORD_TKN,
		.text = (char *)"large",
		.desc = (char *)"Send Large Community attributes",
	},
	{ /* [289] */
		.type = WORD_TKN,
		.text = (char *)"soft-reconfiguration",
		.desc = (char *)"Per neighbor soft reconfiguration",
	},
	{ /* [290] */
		.type = WORD_TKN,
		.text = (char *)"inbound",
		.desc = (char *)"Allow inbound soft reconfiguration for this neighbor",
	},
	{ /* [291] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [292] = neighbor_soft_reconfiguration_cmd */ },
	{ /* [293] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Set the Site-of-Origin (SoO) extended community",
	},
	{ /* [294] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"soo",
	},
	{ /* [295] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [296] = neighbor_soo_cmd */ },
	{ /* [297] */
		.type = WORD_TKN,
		.text = (char *)"unsuppress-map",
		.desc = (char *)"Route-map to selectively unsuppress suppressed routes",
	},
	{ /* [298] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of route map",
		.varname = (char *)"unsuppress_map",
	},
	{ /* [299] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [300] = neighbor_unsuppress_map_cmd */ },
	{ /* [301] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"Set default weight for routes from this neighbor",
	},
	{ /* [302] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-65535)",
		.desc = (char *)"default weight",
		.max = 65535,
		.varname = (char *)"weight",
	},
	{ /* [303] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [304] = neighbor_weight_cmd */ },
	{ /* [305] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [306] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP Specific commands",
	},
	{ /* [307] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable route-flap dampening",
	},
	{ /* [308] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[315],
	},
	{ /* [309] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-45)",
		.desc = (char *)"Half-life time for the penalty",
		.min = 1,
		.max = 45,
		.varname = (char *)"dampening",
	},
	{ /* [310] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[314],
	},
	{ /* [311] */
		.type = RANGE_TKN,
		.text = (char *)"(1-20000)",
		.desc = (char *)"Value to start reusing a route",
		.min = 1,
		.max = 20000,
	},
	{ /* [312] */
		.type = RANGE_TKN,
		.text = (char *)"(1-50000)",
		.desc = (char *)"Value to start suppressing a route",
		.min = 1,
		.max = 50000,
	},
	{ /* [313] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.min = 1,
		.max = 255,
	},
	{ /* [314] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[310],
	},
	{ /* [315] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[308],
	},
	{ /* [316] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [317] = bgp_damp_unset_cmd */ },
	{ /* [318] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Define an administrative distance",
	},
	{ /* [319] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Administrative distance",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [320] */
		.type = IPV4_PREFIX_TKN,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP source prefix",
	},
	{ /* [321] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [322] = no_bgp_distance_source_cmd */ },
	{ /* [323] */
		.type = VARIABLE_TKN,
		.text = (char *)"WORD",
		.desc = (char *)"Access list name",
	},
	{ /* [324] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [325] = no_bgp_distance_source_access_list_cmd */ },
	{ /* [326] */
		.type = WORD_TKN,
		.text = (char *)"bgp",
		.desc = (char *)"BGP distance",
	},
	{ /* [327] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[331],
	},
	{ /* [328] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes external to the AS",
		.min = 1,
		.max = 255,
		.varname = (char *)"bgp",
	},
	{ /* [329] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for routes internal to the AS",
		.min = 1,
		.max = 255,
	},
	{ /* [330] */
		.type = RANGE_TKN,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance for local routes",
		.min = 1,
		.max = 255,
	},
	{ /* [331] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[327],
	},
	{ /* [332] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [333] = no_bgp_distance_cmd */ },
	{ /* [334] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify neighbor router",
	},
	{ /* [335] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[337],
	},
	{ /* [336] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [337] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[335],
	},
	{ /* [338] */
		.type = WORD_TKN,
		.text = (char *)"activate",
		.desc = (char *)"Enable the Address Family for this Neighbor",
	},
	{ /* [339] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [340] = no_neighbor_activate_cmd */ },
	{ /* [341] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"Neighbor IPv6 address",
		.varname = (char *)"neighbor",
	},
	{ /* [342] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name or neighbor tag",
		.varname = (char *)"neighbor",
	},
	{ /* [343] */
		.type = WORD_TKN,
		.text = (char *)"addpath-rx-paths-limit",
		.desc = (char *)"Paths Limit for Addpath to receive from the peer",
	},
	{ /* [344] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[346],
	},
	{ /* [345] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Maximum number of paths",
		.min = 1,
		.max = 65535,
		.varname = (char *)"addpath_rx_paths_limit",
	},
	{ /* [346] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[344],
	},
	{ /* [347] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [348] = no_neighbor_addpath_paths_limit_cmd */ },
	{ /* [349] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-all-paths",
		.desc = (char *)"Use addpath to advertise all paths to a neighbor",
	},
	{ /* [350] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [351] = no_neighbor_addpath_tx_all_paths_cmd */ },
	{ /* [352] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-best-selected",
		.desc = (char *)"Use addpath to advertise best selected paths to a neighbor",
	},
	{ /* [353] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[355],
	},
	{ /* [354] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-6)",
		.desc = (char *)"The number of best paths",
		.min = 1,
		.max = 6,
		.varname = (char *)"addpath_tx_best_selected",
	},
	{ /* [355] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[353],
	},
	{ /* [356] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [357] = no_neighbor_addpath_tx_best_selected_paths_cmd */ },
	{ /* [358] */
		.type = WORD_TKN,
		.text = (char *)"addpath-tx-bestpath-per-AS",
		.desc = (char *)"Use addpath to advertise the bestpath per each neighboring AS",
	},
	{ /* [359] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [360] = no_neighbor_addpath_tx_bestpath_per_as_cmd */ },
	{ /* [361] */
		.type = WORD_TKN,
		.text = (char *)"allowas-in",
		.desc = (char *)"allow local ASN appears in aspath attribute",
	},
	{ /* [362] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[366],
	},
	{ /* [363] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[365],
	},
	{ /* [364] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-10)",
		.desc = (char *)"Number of occurrences of AS number",
		.min = 1,
		.max = 10,
		.varname = (char *)"allowas_in",
	},
	{ /* [365] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[363],
	},
	{ /* [366] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[362],
	},
	{ /* [367] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [368] = no_neighbor_allowas_in_cmd */ },
	{ /* [369] */
		.type = WORD_TKN,
		.text = (char *)"origin",
		.desc = (char *)"Only accept my AS in the as-path if the route was originated in my AS",
	},
	{ /* [370] */
		.type = WORD_TKN,
		.text = (char *)"as-override",
		.desc = (char *)"Override ASNs in outbound updates if aspath equals remote-as",
	},
	{ /* [371] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [372] = no_neighbor_as_override_cmd */ },
	{ /* [373] */
		.type = WORD_TKN,
		.text = (char *)"attribute-unchanged",
		.desc = (char *)"BGP attribute is propagated unchanged to this neighbor",
	},
	{ /* [374] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[378],
	},
	{ /* [375] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[377],
	},
	{ /* [376] */
		.type = WORD_TKN,
		.text = (char *)"as-path",
		.desc = (char *)"As-path attribute",
	},
	{ /* [377] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[375],
	},
	{ /* [378] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[374],
	},
	{ /* [379] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [380] = no_neighbor_attr_unchanged_cmd */ },
	{ /* [381] */
		.type = WORD_TKN,
		.text = (char *)"next-hop",
		.desc = (char *)"Nexthop attribute",
	},
	{ /* [382] */
		.type = WORD_TKN,
		.text = (char *)"med",
		.desc = (char *)"Med attribute",
	},
	{ /* [383] */
		.type = WORD_TKN,
		.text = (char *)"capability",
		.desc = (char *)"Advertise capability to the peer",
	},
	{ /* [384] */
		.type = WORD_TKN,
		.text = (char *)"orf",
		.desc = (char *)"Advertise ORF capability to the peer",
	},
	{ /* [385] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Advertise prefixlist ORF capability to this neighbor",
	},
	{ /* [386] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[388],
	},
	{ /* [387] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Capability to SEND and RECEIVE the ORF to/from this neighbor",
	},
	{ /* [388] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[386],
	},
	{ /* [389] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [390] = no_neighbor_capability_orf_prefix_cmd */ },
	{ /* [391] */
		.type = WORD_TKN,
		.text = (char *)"send",
		.desc = (char *)"Capability to RECEIVE the ORF from this neighbor",
	},
	{ /* [392] */
		.type = WORD_TKN,
		.text = (char *)"receive",
		.desc = (char *)"Capability to SEND the ORF to this neighbor",
	},
	{ /* [393] */
		.type = WORD_TKN,
		.text = (char *)"dampening",
		.desc = (char *)"Enable neighbor route-flap dampening",
	},
	{ /* [394] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[401],
	},
	{ /* [395] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"HALF",
		.desc = (char *)"Half-life time for the penalty",
		.varname = (char *)"half",
	},
	{ /* [396] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[400],
	},
	{ /* [397] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"REUSE",
		.desc = (char *)"Value to start reusing a route",
		.varname = (char *)"reuse",
	},
	{ /* [398] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SUPPRESS",
		.desc = (char *)"Value to start suppressing a route",
		.varname = (char *)"suppress",
	},
	{ /* [399] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"MAX",
		.desc = (char *)"Maximum duration to suppress a stable route",
		.varname = (char *)"max",
	},
	{ /* [400] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[396],
	},
	{ /* [401] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[394],
	},
	{ /* [402] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [403] = no_neighbor_damp_cmd */ },
	{ /* [404] */
		.type = WORD_TKN,
		.text = (char *)"default-originate",
		.desc = (char *)"Originate default route to this neighbor",
	},
	{ /* [405] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[408],
	},
	{ /* [406] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route-map to specify criteria to originate default",
	},
	{ /* [407] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"route-map name",
		.varname = (char *)"rmap_name",
	},
	{ /* [408] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[405],
	},
	{ /* [409] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [410] = no_neighbor_default_originate_cmd */ },
	{ /* [411] */
		.type = WORD_TKN,
		.text = (char *)"disable-addpath-rx",
		.desc = (char *)"Do not accept additional paths",
	},
	{ /* [412] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [413] = no_neighbor_disable_addpath_rx_cmd */ },
	{ /* [414] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [415] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"IP Access-list name",
		.varname = (char *)"accesslist_name",
	},
	{ /* [416] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[418],
	},
	{ /* [417] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [418] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[416],
	},
	{ /* [419] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [420] = no_neighbor_distribute_list_cmd */ },
	{ /* [421] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [422] */
		.type = WORD_TKN,
		.text = (char *)"filter-list",
		.desc = (char *)"Establish BGP filters",
	},
	{ /* [423] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"AS_PATH_FILTER_NAME",
		.desc = (char *)"AS path access-list name",
		.varname = (char *)"as_path_filter_name",
	},
	{ /* [424] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[426],
	},
	{ /* [425] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routes",
	},
	{ /* [426] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[424],
	},
	{ /* [427] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [428] = no_neighbor_filter_list_cmd */ },
	{ /* [429] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routes",
	},
	{ /* [430] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix",
		.desc = (char *)"Maximum number of prefixes to accept from this peer",
	},
	{ /* [431] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[446],
	},
	{ /* [432] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix",
	},
	{ /* [433] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[435],
	},
	{ /* [434] */
		.type = RANGE_TKN,
		.text = (char *)"(1-100)",
		.desc = (char *)"Threshold value (%) at which to generate a warning msg",
		.min = 1,
		.max = 100,
	},
	{ /* [435] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[433],
	},
	{ /* [436] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[439],
	},
	{ /* [437] */
		.type = WORD_TKN,
		.text = (char *)"restart",
		.desc = (char *)"Restart bgp connection after limit is exceeded",
	},
	{ /* [438] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Restart interval in minutes",
		.min = 1,
		.max = 65535,
		.varname = (char *)"restart",
	},
	{ /* [439] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[436],
	},
	{ /* [440] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[442],
	},
	{ /* [441] */
		.type = WORD_TKN,
		.text = (char *)"warning-only",
		.desc = (char *)"Only give warning message when limit is exceeded",
	},
	{ /* [442] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[440],
	},
	{ /* [443] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[445],
	},
	{ /* [444] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Force checking all received routes not only accepted",
	},
	{ /* [445] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[443],
	},
	{ /* [446] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[431],
	},
	{ /* [447] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [448] = no_neighbor_maximum_prefix_cmd */ },
	{ /* [449] */
		.type = WORD_TKN,
		.text = (char *)"maximum-prefix-out",
		.desc = (char *)"Maximum number of prefixes to be sent to this peer",
	},
	{ /* [450] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[452],
	},
	{ /* [451] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-4294967295)",
		.desc = (char *)"Maximum no. of prefix limit",
		.min = 1,
		.max = 4294967295,
		.varname = (char *)"maximum_prefix_out",
	},
	{ /* [452] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[450],
	},
	{ /* [453] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [454] = no_neighbor_maximum_prefix_out_cmd */ },
	{ /* [455] */
		.type = WORD_TKN,
		.text = (char *)"next-hop-self",
		.desc = (char *)"Disable the next hop calculation for this neighbor",
	},
	{ /* [456] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [457] = no_neighbor_nexthop_self_cmd */ },
	{ /* [458] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [459] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [460] = no_neighbor_nexthop_self_all_hidden_cmd */ },
	{ /* [461] */
		.type = WORD_TKN,
		.text = (char *)"force",
		.desc = (char *)"Set the next hop to self for reflected routes",
	},
	{ /* [462] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [463] = no_neighbor_nexthop_self_force_cmd */ },
	{ /* [464] */
		.type = WORD_TKN,
		.text = (char *)"peer-group",
		.desc = (char *)"Member of the peer-group",
	},
	{ /* [465] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"PGNAME",
		.desc = (char *)"Peer-group name",
		.varname = (char *)"pgname",
	},
	{ /* [466] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [467] = no_neighbor_set_peer_group_hidden_cmd */ },
	{ /* [468] */
		.type = WORD_TKN,
		.text = (char *)"prefix-list",
		.desc = (char *)"Filter updates to/from this neighbor",
	},
	{ /* [469] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of a prefix list",
		.varname = (char *)"prefix_list",
	},
	{ /* [470] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[472],
	},
	{ /* [471] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming updates",
	},
	{ /* [472] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[470],
	},
	{ /* [473] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [474] = no_neighbor_prefix_list_cmd */ },
	{ /* [475] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing updates",
	},
	{ /* [476] */
		.type = WORD_TKN,
		.text = (char *)"remove-private-AS",
		.desc = (char *)"Remove private ASNs in outbound updates",
	},
	{ /* [477] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [478] = no_neighbor_remove_private_as_cmd */ },
	{ /* [479] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Apply to all AS numbers",
	},
	{ /* [480] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [481] = no_neighbor_remove_private_as_all_cmd */ },
	{ /* [482] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [483] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [484] = no_neighbor_remove_private_as_all_replace_as_cmd */ },
	{ /* [485] */
		.type = WORD_TKN,
		.text = (char *)"replace-AS",
		.desc = (char *)"Replace private ASNs with our ASN in outbound updates",
	},
	{ /* [486] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [487] = no_neighbor_remove_private_as_replace_as_cmd */ },
	{ /* [488] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Apply route map to neighbor",
	},
	{ /* [489] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Name of route map",
		.varname = (char *)"rmap_name",
	},
	{ /* [490] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[492],
	},
	{ /* [491] */
		.type = WORD_TKN,
		.text = (char *)"in",
		.desc = (char *)"Apply map to incoming routes",
	},
	{ /* [492] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[490],
	},
	{ /* [493] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [494] = no_neighbor_route_map_cmd */ },
	{ /* [495] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Apply map to outbound routes",
	},
	{ /* [496] */
		.type = WORD_TKN,
		.text = (char *)"route-reflector-client",
		.desc = (char *)"Configure a neighbor as Route Reflector client",
	},
	{ /* [497] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [498] = no_neighbor_route_reflector_client_cmd */ },
	{ /* [499] */
		.type = WORD_TKN,
		.text = (char *)"route-server-client",
		.desc = (char *)"Configure a neighbor as Route Server client",
	},
	{ /* [500] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [501] = no_neighbor_route_server_client_cmd */ },
	{ /* [502] */
		.type = WORD_TKN,
		.text = (char *)"send-community",
		.desc = (char *)"Send Community attribute to this neighbor",
	},
	{ /* [503] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [504] = no_neighbor_send_community_cmd */ },
	{ /* [505] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[507],
	},
	{ /* [506] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Send Standard and Extended Community attributes",
	},
	{ /* [507] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[505],
	},
	{ /* [508] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [509] = no_neighbor_send_community_type_cmd */ },
	{ /* [510] */
		.type = WORD_TKN,
		.text = (char *)"all",
		.desc = (char *)"Send Standard, Large and Extended Community attributes",
	},
	{ /* [511] */
		.type = WORD_TKN,
		.text = (char *)"extended",
		.desc = (char *)"Send Extended Community attributes",
	},
	{ /* [512] */
		.type = WORD_TKN,
		.text = (char *)"standard",
		.desc = (char *)"Send Standard Community attributes",
	},
	{ /* [513] */
		.type = WORD_TKN,
		.text = (char *)"large",
		.desc = (char *)"Send Large Community attributes",
	},
	{ /* [514] */
		.type = WORD_TKN,
		.text = (char *)"soft-reconfiguration",
		.desc = (char *)"Per neighbor soft reconfiguration",
	},
	{ /* [515] */
		.type = WORD_TKN,
		.text = (char *)"inbound",
		.desc = (char *)"Allow inbound soft reconfiguration for this neighbor",
	},
	{ /* [516] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [517] = no_neighbor_soft_reconfiguration_cmd */ },
	{ /* [518] */
		.type = WORD_TKN,
		.text = (char *)"soo",
		.desc = (char *)"Set the Site-of-Origin (SoO) extended community",
	},
	{ /* [519] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[521],
	},
	{ /* [520] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"VPN extended community",
		.varname = (char *)"soo",
	},
	{ /* [521] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[519],
	},
	{ /* [522] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [523] = no_neighbor_soo_cmd */ },
	{ /* [524] */
		.type = WORD_TKN,
		.text = (char *)"unsuppress-map",
		.desc = (char *)"Route-map to selectively unsuppress suppressed routes",
	},
	{ /* [525] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of route map",
		.varname = (char *)"unsuppress_map",
	},
	{ /* [526] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [527] = no_neighbor_unsuppress_map_cmd */ },
	{ /* [528] */
		.type = WORD_TKN,
		.text = (char *)"weight",
		.desc = (char *)"Set default weight for routes from this neighbor",
	},
	{ /* [529] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[531],
	},
	{ /* [530] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-65535)",
		.desc = (char *)"default weight",
		.max = 65535,
		.varname = (char *)"weight",
	},
	{ /* [531] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_IPV4M_NODE[529],
	},
	{ /* [532] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [533] = no_neighbor_weight_cmd */ },
	{ /* [534] */
		.type = WORD_TKN,
		.text = (char *)"table-map",
		.desc = (char *)"BGP table to RIB route download filter",
	},
	{ /* [535] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"table_map",
	},
	{ /* [536] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [537] = no_bgp_table_map_cmd */ },
	{ /* [538] */
		.type = WORD_TKN,
		.text = (char *)"table-map",
		.desc = (char *)"BGP table to RIB route download filter",
	},
	{ /* [539] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Name of the route map",
		.varname = (char *)"table_map",
	},
	{ /* [540] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [541] = bgp_table_map_cmd */ },
};

extern struct cmd_element aggregate_addressv4_cmd_vtysh;
extern struct cmd_element bgp_damp_set_cmd_vtysh;
extern struct cmd_element bgp_damp_unset_cmd_vtysh;
extern struct cmd_element bgp_distance_cmd_vtysh;
extern struct cmd_element bgp_distance_source_access_list_cmd_vtysh;
extern struct cmd_element bgp_distance_source_cmd_vtysh;
extern struct cmd_element bgp_network_cmd_vtysh;
extern struct cmd_element bgp_table_map_cmd_vtysh;
extern struct cmd_element neighbor_activate_cmd_vtysh;
extern struct cmd_element neighbor_addpath_paths_limit_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_all_paths_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_best_selected_paths_cmd_vtysh;
extern struct cmd_element neighbor_addpath_tx_bestpath_per_as_cmd_vtysh;
extern struct cmd_element neighbor_advertise_map_cmd_vtysh;
extern struct cmd_element neighbor_allowas_in_cmd_vtysh;
extern struct cmd_element neighbor_as_override_cmd_vtysh;
extern struct cmd_element neighbor_attr_unchanged_cmd_vtysh;
extern struct cmd_element neighbor_capability_orf_prefix_cmd_vtysh;
extern struct cmd_element neighbor_damp_cmd_vtysh;
extern struct cmd_element neighbor_default_originate_cmd_vtysh;
extern struct cmd_element neighbor_default_originate_rmap_cmd_vtysh;
extern struct cmd_element neighbor_disable_addpath_rx_cmd_vtysh;
extern struct cmd_element neighbor_distribute_list_cmd_vtysh;
extern struct cmd_element neighbor_ecommunity_rpki_cmd_vtysh;
extern struct cmd_element neighbor_filter_list_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_out_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_restart_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_restart_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_threshold_warning_cmd_vtysh;
extern struct cmd_element neighbor_maximum_prefix_warning_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_all_hidden_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_cmd_vtysh;
extern struct cmd_element neighbor_nexthop_self_force_cmd_vtysh;
extern struct cmd_element neighbor_prefix_list_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_all_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_all_replace_as_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_cmd_vtysh;
extern struct cmd_element neighbor_remove_private_as_replace_as_cmd_vtysh;
extern struct cmd_element neighbor_route_map_cmd_vtysh;
extern struct cmd_element neighbor_route_reflector_client_cmd_vtysh;
extern struct cmd_element neighbor_route_server_client_cmd_vtysh;
extern struct cmd_element neighbor_send_community_cmd_vtysh;
extern struct cmd_element neighbor_send_community_type_cmd_vtysh;
extern struct cmd_element neighbor_set_peer_group_hidden_cmd_vtysh;
extern struct cmd_element neighbor_soft_reconfiguration_cmd_vtysh;
extern struct cmd_element neighbor_soo_cmd_vtysh;
extern struct cmd_element neighbor_unsuppress_map_cmd_vtysh;
extern struct cmd_element neighbor_weight_cmd_vtysh;
extern struct cmd_element no_bgp_distance_cmd_vtysh;
extern struct cmd_element no_bgp_distance_source_access_list_cmd_vtysh;
extern struct cmd_element no_bgp_distance_source_cmd_vtysh;
extern struct cmd_element no_bgp_table_map_cmd_vtysh;
extern struct cmd_element no_neighbor_activate_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_paths_limit_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_all_paths_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh;
extern struct cmd_element no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh;
extern struct cmd_element no_neighbor_allowas_in_cmd_vtysh;
extern struct cmd_element no_neighbor_as_override_cmd_vtysh;
extern struct cmd_element no_neighbor_attr_unchanged_cmd_vtysh;
extern struct cmd_element no_neighbor_capability_orf_prefix_cmd_vtysh;
extern struct cmd_element no_neighbor_damp_cmd_vtysh;
extern struct cmd_element no_neighbor_default_originate_cmd_vtysh;
extern struct cmd_element no_neighbor_disable_addpath_rx_cmd_vtysh;
extern struct cmd_element no_neighbor_distribute_list_cmd_vtysh;
extern struct cmd_element no_neighbor_filter_list_cmd_vtysh;
extern struct cmd_element no_neighbor_maximum_prefix_cmd_vtysh;
extern struct cmd_element no_neighbor_maximum_prefix_out_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_all_hidden_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_cmd_vtysh;
extern struct cmd_element no_neighbor_nexthop_self_force_cmd_vtysh;
extern struct cmd_element no_neighbor_prefix_list_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_all_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_all_replace_as_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_cmd_vtysh;
extern struct cmd_element no_neighbor_remove_private_as_replace_as_cmd_vtysh;
extern struct cmd_element no_neighbor_route_map_cmd_vtysh;
extern struct cmd_element no_neighbor_route_reflector_client_cmd_vtysh;
extern struct cmd_element no_neighbor_route_server_client_cmd_vtysh;
extern struct cmd_element no_neighbor_send_community_cmd_vtysh;
extern struct cmd_element no_neighbor_send_community_type_cmd_vtysh;
extern struct cmd_element no_neighbor_set_peer_group_hidden_cmd_vtysh;
extern struct cmd_element no_neighbor_soft_reconfiguration_cmd_vtysh;
extern struct cmd_element no_neighbor_soo_cmd_vtysh;
extern struct cmd_element no_neighbor_unsuppress_map_cmd_vtysh;
extern struct cmd_element no_neighbor_weight_cmd_vtysh;

MAKE_VECTOR(gn_BGP_IPV4M_NODE_0_next, 6, &gn_BGP_IPV4M_NODE[1], &gn_BGP_IPV4M_NODE[69], &gn_BGP_IPV4M_NODE[81], &gn_BGP_IPV4M_NODE[95], &gn_BGP_IPV4M_NODE[305], &gn_BGP_IPV4M_NODE[538]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_1_next, 2, &gn_BGP_IPV4M_NODE[2], &gn_BGP_IPV4M_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_1_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_2_next, 1, &gn_BGP_IPV4M_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_2_prev, 1, &gn_BGP_IPV4M_NODE[1]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_3_next, 3, &gn_BGP_IPV4M_NODE[4], &gn_BGP_IPV4M_NODE[29], &gn_BGP_IPV4M_NODE[49]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_3_prev, 2, &gn_BGP_IPV4M_NODE[2], &gn_BGP_IPV4M_NODE[1]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_4_next, 1, &gn_BGP_IPV4M_NODE[5]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_4_prev, 1, &gn_BGP_IPV4M_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_5_next, 2, &gn_BGP_IPV4M_NODE[6], &gn_BGP_IPV4M_NODE[27]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_5_prev, 1, &gn_BGP_IPV4M_NODE[4]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_6_next, 1, &gn_BGP_IPV4M_NODE[7]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_6_prev, 1, &gn_BGP_IPV4M_NODE[5]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_7_next, 1, &gn_BGP_IPV4M_NODE[8]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_7_prev, 2, &gn_BGP_IPV4M_NODE[6], &gn_BGP_IPV4M_NODE[28]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_8_next, 2, &gn_BGP_IPV4M_NODE[9], &gn_BGP_IPV4M_NODE[12]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_8_prev, 1, &gn_BGP_IPV4M_NODE[7]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_9_next, 6, &gn_BGP_IPV4M_NODE[10], &gn_BGP_IPV4M_NODE[15], &gn_BGP_IPV4M_NODE[16], &gn_BGP_IPV4M_NODE[18], &gn_BGP_IPV4M_NODE[24], &gn_BGP_IPV4M_NODE[25]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_9_prev, 2, &gn_BGP_IPV4M_NODE[11], &gn_BGP_IPV4M_NODE[8]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_10_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_10_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_11_next, 2, &gn_BGP_IPV4M_NODE[9], &gn_BGP_IPV4M_NODE[12]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_11_prev, 6, &gn_BGP_IPV4M_NODE[10], &gn_BGP_IPV4M_NODE[15], &gn_BGP_IPV4M_NODE[17], &gn_BGP_IPV4M_NODE[21], &gn_BGP_IPV4M_NODE[24], &gn_BGP_IPV4M_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_12_next, 1, &gn_BGP_IPV4M_NODE[13]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_12_prev, 2, &gn_BGP_IPV4M_NODE[11], &gn_BGP_IPV4M_NODE[8]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_13_next, 1, &gn_BGP_IPV4M_NODE[14]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_13_prev, 1, &gn_BGP_IPV4M_NODE[12]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_14_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_14_prev, 1, &gn_BGP_IPV4M_NODE[13]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_15_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_15_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_16_next, 1, &gn_BGP_IPV4M_NODE[17]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_16_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_17_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_17_prev, 1, &gn_BGP_IPV4M_NODE[16]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_18_next, 1, &gn_BGP_IPV4M_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_18_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_19_next, 3, &gn_BGP_IPV4M_NODE[20], &gn_BGP_IPV4M_NODE[22], &gn_BGP_IPV4M_NODE[23]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_19_prev, 1, &gn_BGP_IPV4M_NODE[18]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_20_next, 1, &gn_BGP_IPV4M_NODE[21]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_20_prev, 1, &gn_BGP_IPV4M_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_21_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_21_prev, 3, &gn_BGP_IPV4M_NODE[20], &gn_BGP_IPV4M_NODE[22], &gn_BGP_IPV4M_NODE[23]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_22_next, 1, &gn_BGP_IPV4M_NODE[21]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_22_prev, 1, &gn_BGP_IPV4M_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_23_next, 1, &gn_BGP_IPV4M_NODE[21]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_23_prev, 1, &gn_BGP_IPV4M_NODE[19]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_24_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_24_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_25_next, 1, &gn_BGP_IPV4M_NODE[26]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_25_prev, 1, &gn_BGP_IPV4M_NODE[9]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_26_next, 1, &gn_BGP_IPV4M_NODE[11]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_26_prev, 1, &gn_BGP_IPV4M_NODE[25]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_27_next, 1, &gn_BGP_IPV4M_NODE[28]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_27_prev, 1, &gn_BGP_IPV4M_NODE[5]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_28_next, 1, &gn_BGP_IPV4M_NODE[7]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_28_prev, 1, &gn_BGP_IPV4M_NODE[27]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_29_next, 1, &gn_BGP_IPV4M_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_29_prev, 1, &gn_BGP_IPV4M_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_30_next, 3, &gn_BGP_IPV4M_NODE[31], &gn_BGP_IPV4M_NODE[42], &gn_BGP_IPV4M_NODE[43]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_30_prev, 1, &gn_BGP_IPV4M_NODE[29]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_31_next, 1, &gn_BGP_IPV4M_NODE[32]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_31_prev, 1, &gn_BGP_IPV4M_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_32_next, 2, &gn_BGP_IPV4M_NODE[33], &gn_BGP_IPV4M_NODE[44]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_32_prev, 3, &gn_BGP_IPV4M_NODE[31], &gn_BGP_IPV4M_NODE[42], &gn_BGP_IPV4M_NODE[43]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_33_next, 1, &gn_BGP_IPV4M_NODE[34]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_33_prev, 1, &gn_BGP_IPV4M_NODE[32]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_34_next, 1, &gn_BGP_IPV4M_NODE[35]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_34_prev, 1, &gn_BGP_IPV4M_NODE[33]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_35_next, 2, &gn_BGP_IPV4M_NODE[36], &gn_BGP_IPV4M_NODE[41]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_35_prev, 1, &gn_BGP_IPV4M_NODE[34]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_36_next, 1, &gn_BGP_IPV4M_NODE[37]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_36_prev, 1, &gn_BGP_IPV4M_NODE[35]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_37_next, 1, &gn_BGP_IPV4M_NODE[38]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_37_prev, 2, &gn_BGP_IPV4M_NODE[36], &gn_BGP_IPV4M_NODE[41]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_38_next, 1, &gn_BGP_IPV4M_NODE[39]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_38_prev, 1, &gn_BGP_IPV4M_NODE[37]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_39_next, 1, &gn_BGP_IPV4M_NODE[40]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_39_prev, 1, &gn_BGP_IPV4M_NODE[38]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_40_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_40_prev, 1, &gn_BGP_IPV4M_NODE[39]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_41_next, 1, &gn_BGP_IPV4M_NODE[37]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_41_prev, 1, &gn_BGP_IPV4M_NODE[35]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_42_next, 1, &gn_BGP_IPV4M_NODE[32]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_42_prev, 1, &gn_BGP_IPV4M_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_43_next, 1, &gn_BGP_IPV4M_NODE[32]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_43_prev, 1, &gn_BGP_IPV4M_NODE[30]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_44_next, 1, &gn_BGP_IPV4M_NODE[45]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_44_prev, 1, &gn_BGP_IPV4M_NODE[32]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_45_next, 1, &gn_BGP_IPV4M_NODE[46]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_45_prev, 1, &gn_BGP_IPV4M_NODE[44]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_46_next, 1, &gn_BGP_IPV4M_NODE[47]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_46_prev, 1, &gn_BGP_IPV4M_NODE[45]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_47_next, 1, &gn_BGP_IPV4M_NODE[48]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_47_prev, 1, &gn_BGP_IPV4M_NODE[46]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_48_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_48_prev, 1, &gn_BGP_IPV4M_NODE[47]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_49_next, 1, &gn_BGP_IPV4M_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_49_prev, 1, &gn_BGP_IPV4M_NODE[3]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_50_next, 2, &gn_BGP_IPV4M_NODE[51], &gn_BGP_IPV4M_NODE[64]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_50_prev, 1, &gn_BGP_IPV4M_NODE[49]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_51_next, 1, &gn_BGP_IPV4M_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_51_prev, 1, &gn_BGP_IPV4M_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_52_next, 1, &gn_BGP_IPV4M_NODE[53]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_52_prev, 2, &gn_BGP_IPV4M_NODE[51], &gn_BGP_IPV4M_NODE[68]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_53_next, 2, &gn_BGP_IPV4M_NODE[54], &gn_BGP_IPV4M_NODE[58]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_53_prev, 1, &gn_BGP_IPV4M_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_54_next, 3, &gn_BGP_IPV4M_NODE[55], &gn_BGP_IPV4M_NODE[61], &gn_BGP_IPV4M_NODE[63]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_54_prev, 2, &gn_BGP_IPV4M_NODE[57], &gn_BGP_IPV4M_NODE[53]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_55_next, 1, &gn_BGP_IPV4M_NODE[56]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_55_prev, 1, &gn_BGP_IPV4M_NODE[54]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_56_next, 1, &gn_BGP_IPV4M_NODE[57]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_56_prev, 1, &gn_BGP_IPV4M_NODE[55]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_57_next, 2, &gn_BGP_IPV4M_NODE[54], &gn_BGP_IPV4M_NODE[58]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_57_prev, 3, &gn_BGP_IPV4M_NODE[56], &gn_BGP_IPV4M_NODE[62], &gn_BGP_IPV4M_NODE[63]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_58_next, 1, &gn_BGP_IPV4M_NODE[59]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_58_prev, 2, &gn_BGP_IPV4M_NODE[57], &gn_BGP_IPV4M_NODE[53]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_59_next, 1, &gn_BGP_IPV4M_NODE[60]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_59_prev, 1, &gn_BGP_IPV4M_NODE[58]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_60_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_60_prev, 1, &gn_BGP_IPV4M_NODE[59]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_61_next, 1, &gn_BGP_IPV4M_NODE[62]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_61_prev, 1, &gn_BGP_IPV4M_NODE[54]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_62_next, 1, &gn_BGP_IPV4M_NODE[57]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_62_prev, 1, &gn_BGP_IPV4M_NODE[61]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_63_next, 1, &gn_BGP_IPV4M_NODE[57]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_63_prev, 1, &gn_BGP_IPV4M_NODE[54]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_64_next, 1, &gn_BGP_IPV4M_NODE[65]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_64_prev, 1, &gn_BGP_IPV4M_NODE[50]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_65_next, 2, &gn_BGP_IPV4M_NODE[66], &gn_BGP_IPV4M_NODE[68]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_65_prev, 1, &gn_BGP_IPV4M_NODE[64]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_66_next, 1, &gn_BGP_IPV4M_NODE[67]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_66_prev, 1, &gn_BGP_IPV4M_NODE[65]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_67_next, 1, &gn_BGP_IPV4M_NODE[68]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_67_prev, 1, &gn_BGP_IPV4M_NODE[66]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_68_next, 1, &gn_BGP_IPV4M_NODE[52]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_68_prev, 2, &gn_BGP_IPV4M_NODE[67], &gn_BGP_IPV4M_NODE[65]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_69_next, 1, &gn_BGP_IPV4M_NODE[70]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_69_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_70_next, 1, &gn_BGP_IPV4M_NODE[71]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_70_prev, 1, &gn_BGP_IPV4M_NODE[69]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_71_next, 2, &gn_BGP_IPV4M_NODE[72], &gn_BGP_IPV4M_NODE[78]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_71_prev, 1, &gn_BGP_IPV4M_NODE[70]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_72_next, 1, &gn_BGP_IPV4M_NODE[73]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_72_prev, 1, &gn_BGP_IPV4M_NODE[71]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_73_next, 2, &gn_BGP_IPV4M_NODE[74], &gn_BGP_IPV4M_NODE[77]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_73_prev, 1, &gn_BGP_IPV4M_NODE[72]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_74_next, 1, &gn_BGP_IPV4M_NODE[75]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_74_prev, 1, &gn_BGP_IPV4M_NODE[73]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_75_next, 1, &gn_BGP_IPV4M_NODE[76]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_75_prev, 1, &gn_BGP_IPV4M_NODE[74]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_76_next, 1, &gn_BGP_IPV4M_NODE[77]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_76_prev, 1, &gn_BGP_IPV4M_NODE[75]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_77_next, 1, &gn_BGP_IPV4M_NODE[78]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_77_prev, 2, &gn_BGP_IPV4M_NODE[76], &gn_BGP_IPV4M_NODE[73]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_78_next, 1, &gn_BGP_IPV4M_NODE[79]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_78_prev, 2, &gn_BGP_IPV4M_NODE[77], &gn_BGP_IPV4M_NODE[71]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_79_next, 1, &gn_BGP_IPV4M_NODE[80]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_79_prev, 1, &gn_BGP_IPV4M_NODE[78]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_80_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_80_prev, 1, &gn_BGP_IPV4M_NODE[79]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_81_next, 2, &gn_BGP_IPV4M_NODE[82], &gn_BGP_IPV4M_NODE[89]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_81_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_82_next, 1, &gn_BGP_IPV4M_NODE[83]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_82_prev, 1, &gn_BGP_IPV4M_NODE[81]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_83_next, 2, &gn_BGP_IPV4M_NODE[84], &gn_BGP_IPV4M_NODE[86]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_83_prev, 1, &gn_BGP_IPV4M_NODE[82]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_84_next, 1, &gn_BGP_IPV4M_NODE[85]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_84_prev, 1, &gn_BGP_IPV4M_NODE[83]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_85_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_85_prev, 1, &gn_BGP_IPV4M_NODE[84]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_86_next, 1, &gn_BGP_IPV4M_NODE[87]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_86_prev, 1, &gn_BGP_IPV4M_NODE[83]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_87_next, 1, &gn_BGP_IPV4M_NODE[88]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_87_prev, 1, &gn_BGP_IPV4M_NODE[86]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_88_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_88_prev, 1, &gn_BGP_IPV4M_NODE[87]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_89_next, 1, &gn_BGP_IPV4M_NODE[90]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_89_prev, 1, &gn_BGP_IPV4M_NODE[81]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_90_next, 1, &gn_BGP_IPV4M_NODE[91]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_90_prev, 1, &gn_BGP_IPV4M_NODE[89]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_91_next, 1, &gn_BGP_IPV4M_NODE[92]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_91_prev, 1, &gn_BGP_IPV4M_NODE[90]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_92_next, 1, &gn_BGP_IPV4M_NODE[93]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_92_prev, 1, &gn_BGP_IPV4M_NODE[91]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_93_next, 1, &gn_BGP_IPV4M_NODE[94]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_93_prev, 1, &gn_BGP_IPV4M_NODE[92]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_94_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_94_prev, 1, &gn_BGP_IPV4M_NODE[93]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_95_next, 1, &gn_BGP_IPV4M_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_95_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_96_next, 3, &gn_BGP_IPV4M_NODE[97], &gn_BGP_IPV4M_NODE[102], &gn_BGP_IPV4M_NODE[103]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_96_prev, 1, &gn_BGP_IPV4M_NODE[95]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_97_next, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_97_prev, 1, &gn_BGP_IPV4M_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_98_next, 28, &gn_BGP_IPV4M_NODE[99], &gn_BGP_IPV4M_NODE[104], &gn_BGP_IPV4M_NODE[108], &gn_BGP_IPV4M_NODE[111], &gn_BGP_IPV4M_NODE[115], &gn_BGP_IPV4M_NODE[118], &gn_BGP_IPV4M_NODE[127], &gn_BGP_IPV4M_NODE[130], &gn_BGP_IPV4M_NODE[140], &gn_BGP_IPV4M_NODE[150], &gn_BGP_IPV4M_NODE[161], &gn_BGP_IPV4M_NODE[168], &gn_BGP_IPV4M_NODE[171], &gn_BGP_IPV4M_NODE[179], &gn_BGP_IPV4M_NODE[187], &gn_BGP_IPV4M_NODE[226], &gn_BGP_IPV4M_NODE[230], &gn_BGP_IPV4M_NODE[239], &gn_BGP_IPV4M_NODE[243], &gn_BGP_IPV4M_NODE[251], &gn_BGP_IPV4M_NODE[263], &gn_BGP_IPV4M_NODE[271], &gn_BGP_IPV4M_NODE[274], &gn_BGP_IPV4M_NODE[277], &gn_BGP_IPV4M_NODE[289], &gn_BGP_IPV4M_NODE[293], &gn_BGP_IPV4M_NODE[297], &gn_BGP_IPV4M_NODE[301]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_98_prev, 3, &gn_BGP_IPV4M_NODE[97], &gn_BGP_IPV4M_NODE[102], &gn_BGP_IPV4M_NODE[103]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_99_next, 1, &gn_BGP_IPV4M_NODE[100]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_99_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_100_next, 1, &gn_BGP_IPV4M_NODE[101]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_100_prev, 1, &gn_BGP_IPV4M_NODE[99]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_101_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_101_prev, 1, &gn_BGP_IPV4M_NODE[100]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_102_next, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_102_prev, 1, &gn_BGP_IPV4M_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_103_next, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_103_prev, 1, &gn_BGP_IPV4M_NODE[96]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_104_next, 1, &gn_BGP_IPV4M_NODE[105]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_104_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_105_next, 1, &gn_BGP_IPV4M_NODE[106]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_105_prev, 1, &gn_BGP_IPV4M_NODE[104]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_106_next, 1, &gn_BGP_IPV4M_NODE[107]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_106_prev, 1, &gn_BGP_IPV4M_NODE[105]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_107_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_107_prev, 1, &gn_BGP_IPV4M_NODE[106]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_108_next, 1, &gn_BGP_IPV4M_NODE[109]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_108_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_109_next, 1, &gn_BGP_IPV4M_NODE[110]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_109_prev, 1, &gn_BGP_IPV4M_NODE[108]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_110_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_110_prev, 1, &gn_BGP_IPV4M_NODE[109]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_111_next, 1, &gn_BGP_IPV4M_NODE[112]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_111_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_112_next, 1, &gn_BGP_IPV4M_NODE[113]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_112_prev, 1, &gn_BGP_IPV4M_NODE[111]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_113_next, 1, &gn_BGP_IPV4M_NODE[114]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_113_prev, 1, &gn_BGP_IPV4M_NODE[112]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_114_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_114_prev, 1, &gn_BGP_IPV4M_NODE[113]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_115_next, 1, &gn_BGP_IPV4M_NODE[116]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_115_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_116_next, 1, &gn_BGP_IPV4M_NODE[117]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_116_prev, 1, &gn_BGP_IPV4M_NODE[115]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_117_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_117_prev, 1, &gn_BGP_IPV4M_NODE[116]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_118_next, 1, &gn_BGP_IPV4M_NODE[119]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_118_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_119_next, 2, &gn_BGP_IPV4M_NODE[120], &gn_BGP_IPV4M_NODE[123]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_119_prev, 1, &gn_BGP_IPV4M_NODE[118]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_120_next, 2, &gn_BGP_IPV4M_NODE[121], &gn_BGP_IPV4M_NODE[126]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_120_prev, 1, &gn_BGP_IPV4M_NODE[119]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_121_next, 1, &gn_BGP_IPV4M_NODE[122]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_121_prev, 1, &gn_BGP_IPV4M_NODE[120]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_122_next, 1, &gn_BGP_IPV4M_NODE[123]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_122_prev, 2, &gn_BGP_IPV4M_NODE[121], &gn_BGP_IPV4M_NODE[126]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_123_next, 1, &gn_BGP_IPV4M_NODE[124]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_123_prev, 2, &gn_BGP_IPV4M_NODE[122], &gn_BGP_IPV4M_NODE[119]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_124_next, 1, &gn_BGP_IPV4M_NODE[125]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_124_prev, 1, &gn_BGP_IPV4M_NODE[123]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_125_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_125_prev, 1, &gn_BGP_IPV4M_NODE[124]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_126_next, 1, &gn_BGP_IPV4M_NODE[122]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_126_prev, 1, &gn_BGP_IPV4M_NODE[120]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_127_next, 1, &gn_BGP_IPV4M_NODE[128]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_127_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_128_next, 1, &gn_BGP_IPV4M_NODE[129]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_128_prev, 1, &gn_BGP_IPV4M_NODE[127]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_129_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_129_prev, 1, &gn_BGP_IPV4M_NODE[128]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_130_next, 1, &gn_BGP_IPV4M_NODE[131]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_130_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_131_next, 2, &gn_BGP_IPV4M_NODE[132], &gn_BGP_IPV4M_NODE[135]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_131_prev, 1, &gn_BGP_IPV4M_NODE[130]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_132_next, 3, &gn_BGP_IPV4M_NODE[133], &gn_BGP_IPV4M_NODE[138], &gn_BGP_IPV4M_NODE[139]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_132_prev, 2, &gn_BGP_IPV4M_NODE[134], &gn_BGP_IPV4M_NODE[131]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_133_next, 1, &gn_BGP_IPV4M_NODE[134]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_133_prev, 1, &gn_BGP_IPV4M_NODE[132]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_134_next, 2, &gn_BGP_IPV4M_NODE[132], &gn_BGP_IPV4M_NODE[135]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_134_prev, 3, &gn_BGP_IPV4M_NODE[133], &gn_BGP_IPV4M_NODE[138], &gn_BGP_IPV4M_NODE[139]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_135_next, 1, &gn_BGP_IPV4M_NODE[136]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_135_prev, 2, &gn_BGP_IPV4M_NODE[134], &gn_BGP_IPV4M_NODE[131]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_136_next, 1, &gn_BGP_IPV4M_NODE[137]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_136_prev, 1, &gn_BGP_IPV4M_NODE[135]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_137_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_137_prev, 1, &gn_BGP_IPV4M_NODE[136]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_138_next, 1, &gn_BGP_IPV4M_NODE[134]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_138_prev, 1, &gn_BGP_IPV4M_NODE[132]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_139_next, 1, &gn_BGP_IPV4M_NODE[134]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_139_prev, 1, &gn_BGP_IPV4M_NODE[132]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_140_next, 1, &gn_BGP_IPV4M_NODE[141]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_140_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_141_next, 1, &gn_BGP_IPV4M_NODE[142]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_141_prev, 1, &gn_BGP_IPV4M_NODE[140]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_142_next, 1, &gn_BGP_IPV4M_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_142_prev, 1, &gn_BGP_IPV4M_NODE[141]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_143_next, 3, &gn_BGP_IPV4M_NODE[144], &gn_BGP_IPV4M_NODE[148], &gn_BGP_IPV4M_NODE[149]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_143_prev, 1, &gn_BGP_IPV4M_NODE[142]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_144_next, 1, &gn_BGP_IPV4M_NODE[145]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_144_prev, 1, &gn_BGP_IPV4M_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_145_next, 1, &gn_BGP_IPV4M_NODE[146]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_145_prev, 3, &gn_BGP_IPV4M_NODE[144], &gn_BGP_IPV4M_NODE[148], &gn_BGP_IPV4M_NODE[149]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_146_next, 1, &gn_BGP_IPV4M_NODE[147]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_146_prev, 1, &gn_BGP_IPV4M_NODE[145]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_147_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_147_prev, 1, &gn_BGP_IPV4M_NODE[146]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_148_next, 1, &gn_BGP_IPV4M_NODE[145]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_148_prev, 1, &gn_BGP_IPV4M_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_149_next, 1, &gn_BGP_IPV4M_NODE[145]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_149_prev, 1, &gn_BGP_IPV4M_NODE[143]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_150_next, 1, &gn_BGP_IPV4M_NODE[151]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_150_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_151_next, 2, &gn_BGP_IPV4M_NODE[152], &gn_BGP_IPV4M_NODE[158]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_151_prev, 1, &gn_BGP_IPV4M_NODE[150]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_152_next, 1, &gn_BGP_IPV4M_NODE[153]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_152_prev, 1, &gn_BGP_IPV4M_NODE[151]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_153_next, 2, &gn_BGP_IPV4M_NODE[154], &gn_BGP_IPV4M_NODE[157]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_153_prev, 1, &gn_BGP_IPV4M_NODE[152]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_154_next, 1, &gn_BGP_IPV4M_NODE[155]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_154_prev, 1, &gn_BGP_IPV4M_NODE[153]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_155_next, 1, &gn_BGP_IPV4M_NODE[156]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_155_prev, 1, &gn_BGP_IPV4M_NODE[154]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_156_next, 1, &gn_BGP_IPV4M_NODE[157]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_156_prev, 1, &gn_BGP_IPV4M_NODE[155]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_157_next, 1, &gn_BGP_IPV4M_NODE[158]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_157_prev, 2, &gn_BGP_IPV4M_NODE[156], &gn_BGP_IPV4M_NODE[153]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_158_next, 1, &gn_BGP_IPV4M_NODE[159]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_158_prev, 2, &gn_BGP_IPV4M_NODE[157], &gn_BGP_IPV4M_NODE[151]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_159_next, 1, &gn_BGP_IPV4M_NODE[160]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_159_prev, 1, &gn_BGP_IPV4M_NODE[158]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_160_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_160_prev, 1, &gn_BGP_IPV4M_NODE[159]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_161_next, 2, &gn_BGP_IPV4M_NODE[162], &gn_BGP_IPV4M_NODE[164]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_161_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_162_next, 1, &gn_BGP_IPV4M_NODE[163]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_162_prev, 1, &gn_BGP_IPV4M_NODE[161]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_163_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_163_prev, 1, &gn_BGP_IPV4M_NODE[162]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_164_next, 1, &gn_BGP_IPV4M_NODE[165]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_164_prev, 1, &gn_BGP_IPV4M_NODE[161]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_165_next, 1, &gn_BGP_IPV4M_NODE[166]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_165_prev, 1, &gn_BGP_IPV4M_NODE[164]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_166_next, 1, &gn_BGP_IPV4M_NODE[167]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_166_prev, 1, &gn_BGP_IPV4M_NODE[165]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_167_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_167_prev, 1, &gn_BGP_IPV4M_NODE[166]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_168_next, 1, &gn_BGP_IPV4M_NODE[169]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_168_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_169_next, 1, &gn_BGP_IPV4M_NODE[170]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_169_prev, 1, &gn_BGP_IPV4M_NODE[168]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_170_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_170_prev, 1, &gn_BGP_IPV4M_NODE[169]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_171_next, 1, &gn_BGP_IPV4M_NODE[172]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_171_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_172_next, 1, &gn_BGP_IPV4M_NODE[173]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_172_prev, 1, &gn_BGP_IPV4M_NODE[171]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_173_next, 2, &gn_BGP_IPV4M_NODE[174], &gn_BGP_IPV4M_NODE[178]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_173_prev, 1, &gn_BGP_IPV4M_NODE[172]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_174_next, 1, &gn_BGP_IPV4M_NODE[175]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_174_prev, 1, &gn_BGP_IPV4M_NODE[173]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_175_next, 1, &gn_BGP_IPV4M_NODE[176]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_175_prev, 2, &gn_BGP_IPV4M_NODE[174], &gn_BGP_IPV4M_NODE[178]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_176_next, 1, &gn_BGP_IPV4M_NODE[177]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_176_prev, 1, &gn_BGP_IPV4M_NODE[175]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_177_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_177_prev, 1, &gn_BGP_IPV4M_NODE[176]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_178_next, 1, &gn_BGP_IPV4M_NODE[175]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_178_prev, 1, &gn_BGP_IPV4M_NODE[173]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_179_next, 1, &gn_BGP_IPV4M_NODE[180]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_179_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_180_next, 1, &gn_BGP_IPV4M_NODE[181]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_180_prev, 1, &gn_BGP_IPV4M_NODE[179]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_181_next, 2, &gn_BGP_IPV4M_NODE[182], &gn_BGP_IPV4M_NODE[186]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_181_prev, 1, &gn_BGP_IPV4M_NODE[180]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_182_next, 1, &gn_BGP_IPV4M_NODE[183]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_182_prev, 1, &gn_BGP_IPV4M_NODE[181]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_183_next, 1, &gn_BGP_IPV4M_NODE[184]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_183_prev, 2, &gn_BGP_IPV4M_NODE[182], &gn_BGP_IPV4M_NODE[186]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_184_next, 1, &gn_BGP_IPV4M_NODE[185]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_184_prev, 1, &gn_BGP_IPV4M_NODE[183]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_185_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_185_prev, 1, &gn_BGP_IPV4M_NODE[184]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_186_next, 1, &gn_BGP_IPV4M_NODE[183]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_186_prev, 1, &gn_BGP_IPV4M_NODE[181]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_187_next, 1, &gn_BGP_IPV4M_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_187_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_188_next, 4, &gn_BGP_IPV4M_NODE[189], &gn_BGP_IPV4M_NODE[208], &gn_BGP_IPV4M_NODE[213], &gn_BGP_IPV4M_NODE[220]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_188_prev, 1, &gn_BGP_IPV4M_NODE[187]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_189_next, 3, &gn_BGP_IPV4M_NODE[190], &gn_BGP_IPV4M_NODE[195], &gn_BGP_IPV4M_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_189_prev, 1, &gn_BGP_IPV4M_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_190_next, 2, &gn_BGP_IPV4M_NODE[191], &gn_BGP_IPV4M_NODE[192]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_190_prev, 1, &gn_BGP_IPV4M_NODE[189]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_191_next, 1, &gn_BGP_IPV4M_NODE[192]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_191_prev, 1, &gn_BGP_IPV4M_NODE[190]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_192_next, 1, &gn_BGP_IPV4M_NODE[193]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_192_prev, 2, &gn_BGP_IPV4M_NODE[191], &gn_BGP_IPV4M_NODE[190]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_193_next, 1, &gn_BGP_IPV4M_NODE[194]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_193_prev, 1, &gn_BGP_IPV4M_NODE[192]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_194_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_194_prev, 1, &gn_BGP_IPV4M_NODE[193]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_195_next, 1, &gn_BGP_IPV4M_NODE[196]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_195_prev, 1, &gn_BGP_IPV4M_NODE[189]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_196_next, 1, &gn_BGP_IPV4M_NODE[197]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_196_prev, 1, &gn_BGP_IPV4M_NODE[195]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_197_next, 2, &gn_BGP_IPV4M_NODE[198], &gn_BGP_IPV4M_NODE[199]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_197_prev, 1, &gn_BGP_IPV4M_NODE[196]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_198_next, 1, &gn_BGP_IPV4M_NODE[199]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_198_prev, 1, &gn_BGP_IPV4M_NODE[197]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_199_next, 1, &gn_BGP_IPV4M_NODE[200]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_199_prev, 2, &gn_BGP_IPV4M_NODE[198], &gn_BGP_IPV4M_NODE[197]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_200_next, 1, &gn_BGP_IPV4M_NODE[201]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_200_prev, 1, &gn_BGP_IPV4M_NODE[199]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_201_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_201_prev, 1, &gn_BGP_IPV4M_NODE[200]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_202_next, 1, &gn_BGP_IPV4M_NODE[203]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_202_prev, 1, &gn_BGP_IPV4M_NODE[189]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_203_next, 2, &gn_BGP_IPV4M_NODE[204], &gn_BGP_IPV4M_NODE[205]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_203_prev, 1, &gn_BGP_IPV4M_NODE[202]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_204_next, 1, &gn_BGP_IPV4M_NODE[205]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_204_prev, 1, &gn_BGP_IPV4M_NODE[203]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_205_next, 1, &gn_BGP_IPV4M_NODE[206]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_205_prev, 2, &gn_BGP_IPV4M_NODE[204], &gn_BGP_IPV4M_NODE[203]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_206_next, 1, &gn_BGP_IPV4M_NODE[207]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_206_prev, 1, &gn_BGP_IPV4M_NODE[205]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_207_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_207_prev, 1, &gn_BGP_IPV4M_NODE[206]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_208_next, 2, &gn_BGP_IPV4M_NODE[209], &gn_BGP_IPV4M_NODE[210]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_208_prev, 1, &gn_BGP_IPV4M_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_209_next, 1, &gn_BGP_IPV4M_NODE[210]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_209_prev, 1, &gn_BGP_IPV4M_NODE[208]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_210_next, 1, &gn_BGP_IPV4M_NODE[211]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_210_prev, 2, &gn_BGP_IPV4M_NODE[209], &gn_BGP_IPV4M_NODE[208]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_211_next, 1, &gn_BGP_IPV4M_NODE[212]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_211_prev, 1, &gn_BGP_IPV4M_NODE[210]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_212_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_212_prev, 1, &gn_BGP_IPV4M_NODE[211]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_213_next, 1, &gn_BGP_IPV4M_NODE[214]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_213_prev, 1, &gn_BGP_IPV4M_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_214_next, 1, &gn_BGP_IPV4M_NODE[215]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_214_prev, 1, &gn_BGP_IPV4M_NODE[213]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_215_next, 2, &gn_BGP_IPV4M_NODE[216], &gn_BGP_IPV4M_NODE[217]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_215_prev, 1, &gn_BGP_IPV4M_NODE[214]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_216_next, 1, &gn_BGP_IPV4M_NODE[217]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_216_prev, 1, &gn_BGP_IPV4M_NODE[215]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_217_next, 1, &gn_BGP_IPV4M_NODE[218]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_217_prev, 2, &gn_BGP_IPV4M_NODE[216], &gn_BGP_IPV4M_NODE[215]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_218_next, 1, &gn_BGP_IPV4M_NODE[219]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_218_prev, 1, &gn_BGP_IPV4M_NODE[217]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_219_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_219_prev, 1, &gn_BGP_IPV4M_NODE[218]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_220_next, 1, &gn_BGP_IPV4M_NODE[221]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_220_prev, 1, &gn_BGP_IPV4M_NODE[188]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_221_next, 2, &gn_BGP_IPV4M_NODE[222], &gn_BGP_IPV4M_NODE[223]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_221_prev, 1, &gn_BGP_IPV4M_NODE[220]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_222_next, 1, &gn_BGP_IPV4M_NODE[223]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_222_prev, 1, &gn_BGP_IPV4M_NODE[221]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_223_next, 1, &gn_BGP_IPV4M_NODE[224]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_223_prev, 2, &gn_BGP_IPV4M_NODE[222], &gn_BGP_IPV4M_NODE[221]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_224_next, 1, &gn_BGP_IPV4M_NODE[225]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_224_prev, 1, &gn_BGP_IPV4M_NODE[223]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_225_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_225_prev, 1, &gn_BGP_IPV4M_NODE[224]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_226_next, 1, &gn_BGP_IPV4M_NODE[227]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_226_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_227_next, 1, &gn_BGP_IPV4M_NODE[228]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_227_prev, 1, &gn_BGP_IPV4M_NODE[226]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_228_next, 1, &gn_BGP_IPV4M_NODE[229]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_228_prev, 1, &gn_BGP_IPV4M_NODE[227]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_229_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_229_prev, 1, &gn_BGP_IPV4M_NODE[228]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_230_next, 3, &gn_BGP_IPV4M_NODE[231], &gn_BGP_IPV4M_NODE[233], &gn_BGP_IPV4M_NODE[236]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_230_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_231_next, 1, &gn_BGP_IPV4M_NODE[232]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_231_prev, 1, &gn_BGP_IPV4M_NODE[230]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_232_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_232_prev, 1, &gn_BGP_IPV4M_NODE[231]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_233_next, 1, &gn_BGP_IPV4M_NODE[234]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_233_prev, 1, &gn_BGP_IPV4M_NODE[230]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_234_next, 1, &gn_BGP_IPV4M_NODE[235]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_234_prev, 1, &gn_BGP_IPV4M_NODE[233]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_235_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_235_prev, 1, &gn_BGP_IPV4M_NODE[234]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_236_next, 1, &gn_BGP_IPV4M_NODE[237]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_236_prev, 1, &gn_BGP_IPV4M_NODE[230]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_237_next, 1, &gn_BGP_IPV4M_NODE[238]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_237_prev, 1, &gn_BGP_IPV4M_NODE[236]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_238_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_238_prev, 1, &gn_BGP_IPV4M_NODE[237]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_239_next, 1, &gn_BGP_IPV4M_NODE[240]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_239_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_240_next, 1, &gn_BGP_IPV4M_NODE[241]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_240_prev, 1, &gn_BGP_IPV4M_NODE[239]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_241_next, 1, &gn_BGP_IPV4M_NODE[242]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_241_prev, 1, &gn_BGP_IPV4M_NODE[240]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_242_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_242_prev, 1, &gn_BGP_IPV4M_NODE[241]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_243_next, 1, &gn_BGP_IPV4M_NODE[244]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_243_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_244_next, 1, &gn_BGP_IPV4M_NODE[245]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_244_prev, 1, &gn_BGP_IPV4M_NODE[243]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_245_next, 2, &gn_BGP_IPV4M_NODE[246], &gn_BGP_IPV4M_NODE[250]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_245_prev, 1, &gn_BGP_IPV4M_NODE[244]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_246_next, 1, &gn_BGP_IPV4M_NODE[247]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_246_prev, 1, &gn_BGP_IPV4M_NODE[245]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_247_next, 1, &gn_BGP_IPV4M_NODE[248]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_247_prev, 2, &gn_BGP_IPV4M_NODE[246], &gn_BGP_IPV4M_NODE[250]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_248_next, 1, &gn_BGP_IPV4M_NODE[249]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_248_prev, 1, &gn_BGP_IPV4M_NODE[247]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_249_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_249_prev, 1, &gn_BGP_IPV4M_NODE[248]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_250_next, 1, &gn_BGP_IPV4M_NODE[247]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_250_prev, 1, &gn_BGP_IPV4M_NODE[245]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_251_next, 3, &gn_BGP_IPV4M_NODE[252], &gn_BGP_IPV4M_NODE[254], &gn_BGP_IPV4M_NODE[260]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_251_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_252_next, 1, &gn_BGP_IPV4M_NODE[253]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_252_prev, 1, &gn_BGP_IPV4M_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_253_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_253_prev, 1, &gn_BGP_IPV4M_NODE[252]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_254_next, 2, &gn_BGP_IPV4M_NODE[255], &gn_BGP_IPV4M_NODE[257]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_254_prev, 1, &gn_BGP_IPV4M_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_255_next, 1, &gn_BGP_IPV4M_NODE[256]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_255_prev, 1, &gn_BGP_IPV4M_NODE[254]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_256_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_256_prev, 1, &gn_BGP_IPV4M_NODE[255]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_257_next, 1, &gn_BGP_IPV4M_NODE[258]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_257_prev, 1, &gn_BGP_IPV4M_NODE[254]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_258_next, 1, &gn_BGP_IPV4M_NODE[259]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_258_prev, 1, &gn_BGP_IPV4M_NODE[257]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_259_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_259_prev, 1, &gn_BGP_IPV4M_NODE[258]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_260_next, 1, &gn_BGP_IPV4M_NODE[261]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_260_prev, 1, &gn_BGP_IPV4M_NODE[251]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_261_next, 1, &gn_BGP_IPV4M_NODE[262]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_261_prev, 1, &gn_BGP_IPV4M_NODE[260]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_262_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_262_prev, 1, &gn_BGP_IPV4M_NODE[261]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_263_next, 1, &gn_BGP_IPV4M_NODE[264]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_263_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_264_next, 1, &gn_BGP_IPV4M_NODE[265]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_264_prev, 1, &gn_BGP_IPV4M_NODE[263]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_265_next, 2, &gn_BGP_IPV4M_NODE[266], &gn_BGP_IPV4M_NODE[270]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_265_prev, 1, &gn_BGP_IPV4M_NODE[264]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_266_next, 1, &gn_BGP_IPV4M_NODE[267]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_266_prev, 1, &gn_BGP_IPV4M_NODE[265]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_267_next, 1, &gn_BGP_IPV4M_NODE[268]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_267_prev, 2, &gn_BGP_IPV4M_NODE[266], &gn_BGP_IPV4M_NODE[270]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_268_next, 1, &gn_BGP_IPV4M_NODE[269]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_268_prev, 1, &gn_BGP_IPV4M_NODE[267]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_269_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_269_prev, 1, &gn_BGP_IPV4M_NODE[268]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_270_next, 1, &gn_BGP_IPV4M_NODE[267]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_270_prev, 1, &gn_BGP_IPV4M_NODE[265]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_271_next, 1, &gn_BGP_IPV4M_NODE[272]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_271_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_272_next, 1, &gn_BGP_IPV4M_NODE[273]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_272_prev, 1, &gn_BGP_IPV4M_NODE[271]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_273_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_273_prev, 1, &gn_BGP_IPV4M_NODE[272]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_274_next, 1, &gn_BGP_IPV4M_NODE[275]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_274_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_275_next, 1, &gn_BGP_IPV4M_NODE[276]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_275_prev, 1, &gn_BGP_IPV4M_NODE[274]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_276_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_276_prev, 1, &gn_BGP_IPV4M_NODE[275]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_277_next, 2, &gn_BGP_IPV4M_NODE[278], &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_277_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_278_next, 1, &gn_BGP_IPV4M_NODE[279]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_278_prev, 1, &gn_BGP_IPV4M_NODE[277]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_279_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_279_prev, 1, &gn_BGP_IPV4M_NODE[278]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_280_next, 5, &gn_BGP_IPV4M_NODE[281], &gn_BGP_IPV4M_NODE[285], &gn_BGP_IPV4M_NODE[286], &gn_BGP_IPV4M_NODE[287], &gn_BGP_IPV4M_NODE[288]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_280_prev, 1, &gn_BGP_IPV4M_NODE[277]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_281_next, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_281_prev, 1, &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_282_next, 1, &gn_BGP_IPV4M_NODE[283]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_282_prev, 5, &gn_BGP_IPV4M_NODE[281], &gn_BGP_IPV4M_NODE[285], &gn_BGP_IPV4M_NODE[286], &gn_BGP_IPV4M_NODE[287], &gn_BGP_IPV4M_NODE[288]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_283_next, 1, &gn_BGP_IPV4M_NODE[284]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_283_prev, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_284_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_284_prev, 1, &gn_BGP_IPV4M_NODE[283]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_285_next, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_285_prev, 1, &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_286_next, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_286_prev, 1, &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_287_next, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_287_prev, 1, &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_288_next, 1, &gn_BGP_IPV4M_NODE[282]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_288_prev, 1, &gn_BGP_IPV4M_NODE[280]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_289_next, 1, &gn_BGP_IPV4M_NODE[290]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_289_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_290_next, 1, &gn_BGP_IPV4M_NODE[291]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_290_prev, 1, &gn_BGP_IPV4M_NODE[289]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_291_next, 1, &gn_BGP_IPV4M_NODE[292]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_291_prev, 1, &gn_BGP_IPV4M_NODE[290]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_292_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_292_prev, 1, &gn_BGP_IPV4M_NODE[291]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_293_next, 1, &gn_BGP_IPV4M_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_293_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_294_next, 1, &gn_BGP_IPV4M_NODE[295]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_294_prev, 1, &gn_BGP_IPV4M_NODE[293]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_295_next, 1, &gn_BGP_IPV4M_NODE[296]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_295_prev, 1, &gn_BGP_IPV4M_NODE[294]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_296_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_296_prev, 1, &gn_BGP_IPV4M_NODE[295]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_297_next, 1, &gn_BGP_IPV4M_NODE[298]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_297_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_298_next, 1, &gn_BGP_IPV4M_NODE[299]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_298_prev, 1, &gn_BGP_IPV4M_NODE[297]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_299_next, 1, &gn_BGP_IPV4M_NODE[300]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_299_prev, 1, &gn_BGP_IPV4M_NODE[298]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_300_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_300_prev, 1, &gn_BGP_IPV4M_NODE[299]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_301_next, 1, &gn_BGP_IPV4M_NODE[302]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_301_prev, 1, &gn_BGP_IPV4M_NODE[98]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_302_next, 1, &gn_BGP_IPV4M_NODE[303]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_302_prev, 1, &gn_BGP_IPV4M_NODE[301]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_303_next, 1, &gn_BGP_IPV4M_NODE[304]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_303_prev, 1, &gn_BGP_IPV4M_NODE[302]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_304_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_304_prev, 1, &gn_BGP_IPV4M_NODE[303]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_305_next, 4, &gn_BGP_IPV4M_NODE[306], &gn_BGP_IPV4M_NODE[318], &gn_BGP_IPV4M_NODE[334], &gn_BGP_IPV4M_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_305_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_306_next, 1, &gn_BGP_IPV4M_NODE[307]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_306_prev, 1, &gn_BGP_IPV4M_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_307_next, 1, &gn_BGP_IPV4M_NODE[308]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_307_prev, 1, &gn_BGP_IPV4M_NODE[306]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_308_next, 2, &gn_BGP_IPV4M_NODE[309], &gn_BGP_IPV4M_NODE[315]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_308_prev, 1, &gn_BGP_IPV4M_NODE[307]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_309_next, 1, &gn_BGP_IPV4M_NODE[310]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_309_prev, 1, &gn_BGP_IPV4M_NODE[308]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_310_next, 2, &gn_BGP_IPV4M_NODE[311], &gn_BGP_IPV4M_NODE[314]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_310_prev, 1, &gn_BGP_IPV4M_NODE[309]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_311_next, 1, &gn_BGP_IPV4M_NODE[312]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_311_prev, 1, &gn_BGP_IPV4M_NODE[310]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_312_next, 1, &gn_BGP_IPV4M_NODE[313]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_312_prev, 1, &gn_BGP_IPV4M_NODE[311]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_313_next, 1, &gn_BGP_IPV4M_NODE[314]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_313_prev, 1, &gn_BGP_IPV4M_NODE[312]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_314_next, 1, &gn_BGP_IPV4M_NODE[315]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_314_prev, 2, &gn_BGP_IPV4M_NODE[313], &gn_BGP_IPV4M_NODE[310]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_315_next, 1, &gn_BGP_IPV4M_NODE[316]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_315_prev, 2, &gn_BGP_IPV4M_NODE[314], &gn_BGP_IPV4M_NODE[308]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_316_next, 1, &gn_BGP_IPV4M_NODE[317]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_316_prev, 1, &gn_BGP_IPV4M_NODE[315]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_317_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_317_prev, 1, &gn_BGP_IPV4M_NODE[316]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_318_next, 2, &gn_BGP_IPV4M_NODE[319], &gn_BGP_IPV4M_NODE[326]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_318_prev, 1, &gn_BGP_IPV4M_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_319_next, 1, &gn_BGP_IPV4M_NODE[320]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_319_prev, 1, &gn_BGP_IPV4M_NODE[318]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_320_next, 2, &gn_BGP_IPV4M_NODE[321], &gn_BGP_IPV4M_NODE[323]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_320_prev, 1, &gn_BGP_IPV4M_NODE[319]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_321_next, 1, &gn_BGP_IPV4M_NODE[322]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_321_prev, 1, &gn_BGP_IPV4M_NODE[320]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_322_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_322_prev, 1, &gn_BGP_IPV4M_NODE[321]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_323_next, 1, &gn_BGP_IPV4M_NODE[324]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_323_prev, 1, &gn_BGP_IPV4M_NODE[320]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_324_next, 1, &gn_BGP_IPV4M_NODE[325]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_324_prev, 1, &gn_BGP_IPV4M_NODE[323]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_325_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_325_prev, 1, &gn_BGP_IPV4M_NODE[324]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_326_next, 1, &gn_BGP_IPV4M_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_326_prev, 1, &gn_BGP_IPV4M_NODE[318]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_327_next, 2, &gn_BGP_IPV4M_NODE[328], &gn_BGP_IPV4M_NODE[331]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_327_prev, 1, &gn_BGP_IPV4M_NODE[326]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_328_next, 1, &gn_BGP_IPV4M_NODE[329]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_328_prev, 1, &gn_BGP_IPV4M_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_329_next, 1, &gn_BGP_IPV4M_NODE[330]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_329_prev, 1, &gn_BGP_IPV4M_NODE[328]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_330_next, 1, &gn_BGP_IPV4M_NODE[331]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_330_prev, 1, &gn_BGP_IPV4M_NODE[329]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_331_next, 1, &gn_BGP_IPV4M_NODE[332]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_331_prev, 2, &gn_BGP_IPV4M_NODE[330], &gn_BGP_IPV4M_NODE[327]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_332_next, 1, &gn_BGP_IPV4M_NODE[333]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_332_prev, 1, &gn_BGP_IPV4M_NODE[331]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_333_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_333_prev, 1, &gn_BGP_IPV4M_NODE[332]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_334_next, 1, &gn_BGP_IPV4M_NODE[335]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_334_prev, 1, &gn_BGP_IPV4M_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_335_next, 3, &gn_BGP_IPV4M_NODE[336], &gn_BGP_IPV4M_NODE[341], &gn_BGP_IPV4M_NODE[342]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_335_prev, 1, &gn_BGP_IPV4M_NODE[334]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_336_next, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_336_prev, 1, &gn_BGP_IPV4M_NODE[335]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_337_next, 28, &gn_BGP_IPV4M_NODE[338], &gn_BGP_IPV4M_NODE[343], &gn_BGP_IPV4M_NODE[349], &gn_BGP_IPV4M_NODE[352], &gn_BGP_IPV4M_NODE[358], &gn_BGP_IPV4M_NODE[361], &gn_BGP_IPV4M_NODE[370], &gn_BGP_IPV4M_NODE[373], &gn_BGP_IPV4M_NODE[383], &gn_BGP_IPV4M_NODE[393], &gn_BGP_IPV4M_NODE[404], &gn_BGP_IPV4M_NODE[411], &gn_BGP_IPV4M_NODE[414], &gn_BGP_IPV4M_NODE[422], &gn_BGP_IPV4M_NODE[430], &gn_BGP_IPV4M_NODE[449], &gn_BGP_IPV4M_NODE[455], &gn_BGP_IPV4M_NODE[464], &gn_BGP_IPV4M_NODE[468], &gn_BGP_IPV4M_NODE[476], &gn_BGP_IPV4M_NODE[488], &gn_BGP_IPV4M_NODE[496], &gn_BGP_IPV4M_NODE[499], &gn_BGP_IPV4M_NODE[502], &gn_BGP_IPV4M_NODE[514], &gn_BGP_IPV4M_NODE[518], &gn_BGP_IPV4M_NODE[524], &gn_BGP_IPV4M_NODE[528]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_337_prev, 3, &gn_BGP_IPV4M_NODE[336], &gn_BGP_IPV4M_NODE[341], &gn_BGP_IPV4M_NODE[342]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_338_next, 1, &gn_BGP_IPV4M_NODE[339]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_338_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_339_next, 1, &gn_BGP_IPV4M_NODE[340]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_339_prev, 1, &gn_BGP_IPV4M_NODE[338]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_340_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_340_prev, 1, &gn_BGP_IPV4M_NODE[339]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_341_next, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_341_prev, 1, &gn_BGP_IPV4M_NODE[335]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_342_next, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_342_prev, 1, &gn_BGP_IPV4M_NODE[335]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_343_next, 1, &gn_BGP_IPV4M_NODE[344]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_343_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_344_next, 2, &gn_BGP_IPV4M_NODE[345], &gn_BGP_IPV4M_NODE[346]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_344_prev, 1, &gn_BGP_IPV4M_NODE[343]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_345_next, 1, &gn_BGP_IPV4M_NODE[346]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_345_prev, 1, &gn_BGP_IPV4M_NODE[344]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_346_next, 1, &gn_BGP_IPV4M_NODE[347]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_346_prev, 2, &gn_BGP_IPV4M_NODE[345], &gn_BGP_IPV4M_NODE[344]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_347_next, 1, &gn_BGP_IPV4M_NODE[348]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_347_prev, 1, &gn_BGP_IPV4M_NODE[346]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_348_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_348_prev, 1, &gn_BGP_IPV4M_NODE[347]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_349_next, 1, &gn_BGP_IPV4M_NODE[350]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_349_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_350_next, 1, &gn_BGP_IPV4M_NODE[351]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_350_prev, 1, &gn_BGP_IPV4M_NODE[349]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_351_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_351_prev, 1, &gn_BGP_IPV4M_NODE[350]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_352_next, 1, &gn_BGP_IPV4M_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_352_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_353_next, 2, &gn_BGP_IPV4M_NODE[354], &gn_BGP_IPV4M_NODE[355]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_353_prev, 1, &gn_BGP_IPV4M_NODE[352]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_354_next, 1, &gn_BGP_IPV4M_NODE[355]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_354_prev, 1, &gn_BGP_IPV4M_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_355_next, 1, &gn_BGP_IPV4M_NODE[356]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_355_prev, 2, &gn_BGP_IPV4M_NODE[354], &gn_BGP_IPV4M_NODE[353]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_356_next, 1, &gn_BGP_IPV4M_NODE[357]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_356_prev, 1, &gn_BGP_IPV4M_NODE[355]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_357_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_357_prev, 1, &gn_BGP_IPV4M_NODE[356]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_358_next, 1, &gn_BGP_IPV4M_NODE[359]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_358_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_359_next, 1, &gn_BGP_IPV4M_NODE[360]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_359_prev, 1, &gn_BGP_IPV4M_NODE[358]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_360_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_360_prev, 1, &gn_BGP_IPV4M_NODE[359]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_361_next, 1, &gn_BGP_IPV4M_NODE[362]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_361_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_362_next, 2, &gn_BGP_IPV4M_NODE[363], &gn_BGP_IPV4M_NODE[366]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_362_prev, 1, &gn_BGP_IPV4M_NODE[361]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_363_next, 2, &gn_BGP_IPV4M_NODE[364], &gn_BGP_IPV4M_NODE[369]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_363_prev, 1, &gn_BGP_IPV4M_NODE[362]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_364_next, 1, &gn_BGP_IPV4M_NODE[365]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_364_prev, 1, &gn_BGP_IPV4M_NODE[363]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_365_next, 1, &gn_BGP_IPV4M_NODE[366]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_365_prev, 2, &gn_BGP_IPV4M_NODE[364], &gn_BGP_IPV4M_NODE[369]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_366_next, 1, &gn_BGP_IPV4M_NODE[367]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_366_prev, 2, &gn_BGP_IPV4M_NODE[365], &gn_BGP_IPV4M_NODE[362]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_367_next, 1, &gn_BGP_IPV4M_NODE[368]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_367_prev, 1, &gn_BGP_IPV4M_NODE[366]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_368_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_368_prev, 1, &gn_BGP_IPV4M_NODE[367]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_369_next, 1, &gn_BGP_IPV4M_NODE[365]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_369_prev, 1, &gn_BGP_IPV4M_NODE[363]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_370_next, 1, &gn_BGP_IPV4M_NODE[371]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_370_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_371_next, 1, &gn_BGP_IPV4M_NODE[372]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_371_prev, 1, &gn_BGP_IPV4M_NODE[370]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_372_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_372_prev, 1, &gn_BGP_IPV4M_NODE[371]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_373_next, 1, &gn_BGP_IPV4M_NODE[374]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_373_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_374_next, 2, &gn_BGP_IPV4M_NODE[375], &gn_BGP_IPV4M_NODE[378]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_374_prev, 1, &gn_BGP_IPV4M_NODE[373]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_375_next, 3, &gn_BGP_IPV4M_NODE[376], &gn_BGP_IPV4M_NODE[381], &gn_BGP_IPV4M_NODE[382]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_375_prev, 2, &gn_BGP_IPV4M_NODE[377], &gn_BGP_IPV4M_NODE[374]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_376_next, 1, &gn_BGP_IPV4M_NODE[377]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_376_prev, 1, &gn_BGP_IPV4M_NODE[375]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_377_next, 2, &gn_BGP_IPV4M_NODE[375], &gn_BGP_IPV4M_NODE[378]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_377_prev, 3, &gn_BGP_IPV4M_NODE[376], &gn_BGP_IPV4M_NODE[381], &gn_BGP_IPV4M_NODE[382]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_378_next, 1, &gn_BGP_IPV4M_NODE[379]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_378_prev, 2, &gn_BGP_IPV4M_NODE[377], &gn_BGP_IPV4M_NODE[374]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_379_next, 1, &gn_BGP_IPV4M_NODE[380]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_379_prev, 1, &gn_BGP_IPV4M_NODE[378]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_380_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_380_prev, 1, &gn_BGP_IPV4M_NODE[379]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_381_next, 1, &gn_BGP_IPV4M_NODE[377]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_381_prev, 1, &gn_BGP_IPV4M_NODE[375]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_382_next, 1, &gn_BGP_IPV4M_NODE[377]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_382_prev, 1, &gn_BGP_IPV4M_NODE[375]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_383_next, 1, &gn_BGP_IPV4M_NODE[384]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_383_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_384_next, 1, &gn_BGP_IPV4M_NODE[385]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_384_prev, 1, &gn_BGP_IPV4M_NODE[383]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_385_next, 1, &gn_BGP_IPV4M_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_385_prev, 1, &gn_BGP_IPV4M_NODE[384]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_386_next, 3, &gn_BGP_IPV4M_NODE[387], &gn_BGP_IPV4M_NODE[391], &gn_BGP_IPV4M_NODE[392]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_386_prev, 1, &gn_BGP_IPV4M_NODE[385]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_387_next, 1, &gn_BGP_IPV4M_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_387_prev, 1, &gn_BGP_IPV4M_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_388_next, 1, &gn_BGP_IPV4M_NODE[389]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_388_prev, 3, &gn_BGP_IPV4M_NODE[387], &gn_BGP_IPV4M_NODE[391], &gn_BGP_IPV4M_NODE[392]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_389_next, 1, &gn_BGP_IPV4M_NODE[390]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_389_prev, 1, &gn_BGP_IPV4M_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_390_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_390_prev, 1, &gn_BGP_IPV4M_NODE[389]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_391_next, 1, &gn_BGP_IPV4M_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_391_prev, 1, &gn_BGP_IPV4M_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_392_next, 1, &gn_BGP_IPV4M_NODE[388]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_392_prev, 1, &gn_BGP_IPV4M_NODE[386]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_393_next, 1, &gn_BGP_IPV4M_NODE[394]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_393_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_394_next, 2, &gn_BGP_IPV4M_NODE[395], &gn_BGP_IPV4M_NODE[401]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_394_prev, 1, &gn_BGP_IPV4M_NODE[393]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_395_next, 1, &gn_BGP_IPV4M_NODE[396]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_395_prev, 1, &gn_BGP_IPV4M_NODE[394]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_396_next, 2, &gn_BGP_IPV4M_NODE[397], &gn_BGP_IPV4M_NODE[400]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_396_prev, 1, &gn_BGP_IPV4M_NODE[395]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_397_next, 1, &gn_BGP_IPV4M_NODE[398]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_397_prev, 1, &gn_BGP_IPV4M_NODE[396]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_398_next, 1, &gn_BGP_IPV4M_NODE[399]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_398_prev, 1, &gn_BGP_IPV4M_NODE[397]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_399_next, 1, &gn_BGP_IPV4M_NODE[400]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_399_prev, 1, &gn_BGP_IPV4M_NODE[398]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_400_next, 1, &gn_BGP_IPV4M_NODE[401]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_400_prev, 2, &gn_BGP_IPV4M_NODE[399], &gn_BGP_IPV4M_NODE[396]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_401_next, 1, &gn_BGP_IPV4M_NODE[402]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_401_prev, 2, &gn_BGP_IPV4M_NODE[400], &gn_BGP_IPV4M_NODE[394]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_402_next, 1, &gn_BGP_IPV4M_NODE[403]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_402_prev, 1, &gn_BGP_IPV4M_NODE[401]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_403_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_403_prev, 1, &gn_BGP_IPV4M_NODE[402]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_404_next, 1, &gn_BGP_IPV4M_NODE[405]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_404_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_405_next, 2, &gn_BGP_IPV4M_NODE[406], &gn_BGP_IPV4M_NODE[408]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_405_prev, 1, &gn_BGP_IPV4M_NODE[404]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_406_next, 1, &gn_BGP_IPV4M_NODE[407]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_406_prev, 1, &gn_BGP_IPV4M_NODE[405]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_407_next, 1, &gn_BGP_IPV4M_NODE[408]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_407_prev, 1, &gn_BGP_IPV4M_NODE[406]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_408_next, 1, &gn_BGP_IPV4M_NODE[409]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_408_prev, 2, &gn_BGP_IPV4M_NODE[407], &gn_BGP_IPV4M_NODE[405]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_409_next, 1, &gn_BGP_IPV4M_NODE[410]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_409_prev, 1, &gn_BGP_IPV4M_NODE[408]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_410_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_410_prev, 1, &gn_BGP_IPV4M_NODE[409]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_411_next, 1, &gn_BGP_IPV4M_NODE[412]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_411_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_412_next, 1, &gn_BGP_IPV4M_NODE[413]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_412_prev, 1, &gn_BGP_IPV4M_NODE[411]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_413_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_413_prev, 1, &gn_BGP_IPV4M_NODE[412]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_414_next, 1, &gn_BGP_IPV4M_NODE[415]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_414_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_415_next, 1, &gn_BGP_IPV4M_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_415_prev, 1, &gn_BGP_IPV4M_NODE[414]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_416_next, 2, &gn_BGP_IPV4M_NODE[417], &gn_BGP_IPV4M_NODE[421]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_416_prev, 1, &gn_BGP_IPV4M_NODE[415]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_417_next, 1, &gn_BGP_IPV4M_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_417_prev, 1, &gn_BGP_IPV4M_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_418_next, 1, &gn_BGP_IPV4M_NODE[419]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_418_prev, 2, &gn_BGP_IPV4M_NODE[417], &gn_BGP_IPV4M_NODE[421]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_419_next, 1, &gn_BGP_IPV4M_NODE[420]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_419_prev, 1, &gn_BGP_IPV4M_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_420_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_420_prev, 1, &gn_BGP_IPV4M_NODE[419]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_421_next, 1, &gn_BGP_IPV4M_NODE[418]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_421_prev, 1, &gn_BGP_IPV4M_NODE[416]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_422_next, 1, &gn_BGP_IPV4M_NODE[423]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_422_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_423_next, 1, &gn_BGP_IPV4M_NODE[424]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_423_prev, 1, &gn_BGP_IPV4M_NODE[422]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_424_next, 2, &gn_BGP_IPV4M_NODE[425], &gn_BGP_IPV4M_NODE[429]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_424_prev, 1, &gn_BGP_IPV4M_NODE[423]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_425_next, 1, &gn_BGP_IPV4M_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_425_prev, 1, &gn_BGP_IPV4M_NODE[424]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_426_next, 1, &gn_BGP_IPV4M_NODE[427]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_426_prev, 2, &gn_BGP_IPV4M_NODE[425], &gn_BGP_IPV4M_NODE[429]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_427_next, 1, &gn_BGP_IPV4M_NODE[428]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_427_prev, 1, &gn_BGP_IPV4M_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_428_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_428_prev, 1, &gn_BGP_IPV4M_NODE[427]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_429_next, 1, &gn_BGP_IPV4M_NODE[426]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_429_prev, 1, &gn_BGP_IPV4M_NODE[424]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_430_next, 1, &gn_BGP_IPV4M_NODE[431]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_430_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_431_next, 2, &gn_BGP_IPV4M_NODE[432], &gn_BGP_IPV4M_NODE[446]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_431_prev, 1, &gn_BGP_IPV4M_NODE[430]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_432_next, 1, &gn_BGP_IPV4M_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_432_prev, 1, &gn_BGP_IPV4M_NODE[431]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_433_next, 2, &gn_BGP_IPV4M_NODE[434], &gn_BGP_IPV4M_NODE[435]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_433_prev, 1, &gn_BGP_IPV4M_NODE[432]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_434_next, 1, &gn_BGP_IPV4M_NODE[435]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_434_prev, 1, &gn_BGP_IPV4M_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_435_next, 1, &gn_BGP_IPV4M_NODE[436]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_435_prev, 2, &gn_BGP_IPV4M_NODE[434], &gn_BGP_IPV4M_NODE[433]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_436_next, 2, &gn_BGP_IPV4M_NODE[437], &gn_BGP_IPV4M_NODE[439]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_436_prev, 1, &gn_BGP_IPV4M_NODE[435]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_437_next, 1, &gn_BGP_IPV4M_NODE[438]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_437_prev, 1, &gn_BGP_IPV4M_NODE[436]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_438_next, 1, &gn_BGP_IPV4M_NODE[439]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_438_prev, 1, &gn_BGP_IPV4M_NODE[437]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_439_next, 1, &gn_BGP_IPV4M_NODE[440]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_439_prev, 2, &gn_BGP_IPV4M_NODE[438], &gn_BGP_IPV4M_NODE[436]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_440_next, 2, &gn_BGP_IPV4M_NODE[441], &gn_BGP_IPV4M_NODE[442]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_440_prev, 1, &gn_BGP_IPV4M_NODE[439]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_441_next, 1, &gn_BGP_IPV4M_NODE[442]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_441_prev, 1, &gn_BGP_IPV4M_NODE[440]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_442_next, 1, &gn_BGP_IPV4M_NODE[443]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_442_prev, 2, &gn_BGP_IPV4M_NODE[441], &gn_BGP_IPV4M_NODE[440]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_443_next, 2, &gn_BGP_IPV4M_NODE[444], &gn_BGP_IPV4M_NODE[445]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_443_prev, 1, &gn_BGP_IPV4M_NODE[442]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_444_next, 1, &gn_BGP_IPV4M_NODE[445]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_444_prev, 1, &gn_BGP_IPV4M_NODE[443]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_445_next, 1, &gn_BGP_IPV4M_NODE[446]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_445_prev, 2, &gn_BGP_IPV4M_NODE[444], &gn_BGP_IPV4M_NODE[443]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_446_next, 1, &gn_BGP_IPV4M_NODE[447]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_446_prev, 2, &gn_BGP_IPV4M_NODE[445], &gn_BGP_IPV4M_NODE[431]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_447_next, 1, &gn_BGP_IPV4M_NODE[448]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_447_prev, 1, &gn_BGP_IPV4M_NODE[446]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_448_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_448_prev, 1, &gn_BGP_IPV4M_NODE[447]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_449_next, 1, &gn_BGP_IPV4M_NODE[450]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_449_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_450_next, 2, &gn_BGP_IPV4M_NODE[451], &gn_BGP_IPV4M_NODE[452]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_450_prev, 1, &gn_BGP_IPV4M_NODE[449]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_451_next, 1, &gn_BGP_IPV4M_NODE[452]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_451_prev, 1, &gn_BGP_IPV4M_NODE[450]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_452_next, 1, &gn_BGP_IPV4M_NODE[453]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_452_prev, 2, &gn_BGP_IPV4M_NODE[451], &gn_BGP_IPV4M_NODE[450]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_453_next, 1, &gn_BGP_IPV4M_NODE[454]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_453_prev, 1, &gn_BGP_IPV4M_NODE[452]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_454_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_454_prev, 1, &gn_BGP_IPV4M_NODE[453]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_455_next, 3, &gn_BGP_IPV4M_NODE[456], &gn_BGP_IPV4M_NODE[458], &gn_BGP_IPV4M_NODE[461]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_455_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_456_next, 1, &gn_BGP_IPV4M_NODE[457]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_456_prev, 1, &gn_BGP_IPV4M_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_457_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_457_prev, 1, &gn_BGP_IPV4M_NODE[456]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_458_next, 1, &gn_BGP_IPV4M_NODE[459]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_458_prev, 1, &gn_BGP_IPV4M_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_459_next, 1, &gn_BGP_IPV4M_NODE[460]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_459_prev, 1, &gn_BGP_IPV4M_NODE[458]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_460_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_460_prev, 1, &gn_BGP_IPV4M_NODE[459]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_461_next, 1, &gn_BGP_IPV4M_NODE[462]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_461_prev, 1, &gn_BGP_IPV4M_NODE[455]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_462_next, 1, &gn_BGP_IPV4M_NODE[463]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_462_prev, 1, &gn_BGP_IPV4M_NODE[461]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_463_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_463_prev, 1, &gn_BGP_IPV4M_NODE[462]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_464_next, 1, &gn_BGP_IPV4M_NODE[465]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_464_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_465_next, 1, &gn_BGP_IPV4M_NODE[466]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_465_prev, 1, &gn_BGP_IPV4M_NODE[464]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_466_next, 1, &gn_BGP_IPV4M_NODE[467]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_466_prev, 1, &gn_BGP_IPV4M_NODE[465]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_467_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_467_prev, 1, &gn_BGP_IPV4M_NODE[466]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_468_next, 1, &gn_BGP_IPV4M_NODE[469]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_468_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_469_next, 1, &gn_BGP_IPV4M_NODE[470]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_469_prev, 1, &gn_BGP_IPV4M_NODE[468]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_470_next, 2, &gn_BGP_IPV4M_NODE[471], &gn_BGP_IPV4M_NODE[475]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_470_prev, 1, &gn_BGP_IPV4M_NODE[469]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_471_next, 1, &gn_BGP_IPV4M_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_471_prev, 1, &gn_BGP_IPV4M_NODE[470]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_472_next, 1, &gn_BGP_IPV4M_NODE[473]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_472_prev, 2, &gn_BGP_IPV4M_NODE[471], &gn_BGP_IPV4M_NODE[475]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_473_next, 1, &gn_BGP_IPV4M_NODE[474]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_473_prev, 1, &gn_BGP_IPV4M_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_474_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_474_prev, 1, &gn_BGP_IPV4M_NODE[473]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_475_next, 1, &gn_BGP_IPV4M_NODE[472]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_475_prev, 1, &gn_BGP_IPV4M_NODE[470]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_476_next, 3, &gn_BGP_IPV4M_NODE[477], &gn_BGP_IPV4M_NODE[479], &gn_BGP_IPV4M_NODE[485]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_476_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_477_next, 1, &gn_BGP_IPV4M_NODE[478]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_477_prev, 1, &gn_BGP_IPV4M_NODE[476]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_478_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_478_prev, 1, &gn_BGP_IPV4M_NODE[477]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_479_next, 2, &gn_BGP_IPV4M_NODE[480], &gn_BGP_IPV4M_NODE[482]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_479_prev, 1, &gn_BGP_IPV4M_NODE[476]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_480_next, 1, &gn_BGP_IPV4M_NODE[481]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_480_prev, 1, &gn_BGP_IPV4M_NODE[479]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_481_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_481_prev, 1, &gn_BGP_IPV4M_NODE[480]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_482_next, 1, &gn_BGP_IPV4M_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_482_prev, 1, &gn_BGP_IPV4M_NODE[479]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_483_next, 1, &gn_BGP_IPV4M_NODE[484]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_483_prev, 1, &gn_BGP_IPV4M_NODE[482]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_484_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_484_prev, 1, &gn_BGP_IPV4M_NODE[483]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_485_next, 1, &gn_BGP_IPV4M_NODE[486]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_485_prev, 1, &gn_BGP_IPV4M_NODE[476]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_486_next, 1, &gn_BGP_IPV4M_NODE[487]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_486_prev, 1, &gn_BGP_IPV4M_NODE[485]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_487_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_487_prev, 1, &gn_BGP_IPV4M_NODE[486]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_488_next, 1, &gn_BGP_IPV4M_NODE[489]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_488_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_489_next, 1, &gn_BGP_IPV4M_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_489_prev, 1, &gn_BGP_IPV4M_NODE[488]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_490_next, 2, &gn_BGP_IPV4M_NODE[491], &gn_BGP_IPV4M_NODE[495]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_490_prev, 1, &gn_BGP_IPV4M_NODE[489]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_491_next, 1, &gn_BGP_IPV4M_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_491_prev, 1, &gn_BGP_IPV4M_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_492_next, 1, &gn_BGP_IPV4M_NODE[493]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_492_prev, 2, &gn_BGP_IPV4M_NODE[491], &gn_BGP_IPV4M_NODE[495]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_493_next, 1, &gn_BGP_IPV4M_NODE[494]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_493_prev, 1, &gn_BGP_IPV4M_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_494_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_494_prev, 1, &gn_BGP_IPV4M_NODE[493]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_495_next, 1, &gn_BGP_IPV4M_NODE[492]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_495_prev, 1, &gn_BGP_IPV4M_NODE[490]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_496_next, 1, &gn_BGP_IPV4M_NODE[497]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_496_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_497_next, 1, &gn_BGP_IPV4M_NODE[498]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_497_prev, 1, &gn_BGP_IPV4M_NODE[496]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_498_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_498_prev, 1, &gn_BGP_IPV4M_NODE[497]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_499_next, 1, &gn_BGP_IPV4M_NODE[500]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_499_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_500_next, 1, &gn_BGP_IPV4M_NODE[501]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_500_prev, 1, &gn_BGP_IPV4M_NODE[499]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_501_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_501_prev, 1, &gn_BGP_IPV4M_NODE[500]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_502_next, 2, &gn_BGP_IPV4M_NODE[503], &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_502_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_503_next, 1, &gn_BGP_IPV4M_NODE[504]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_503_prev, 1, &gn_BGP_IPV4M_NODE[502]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_504_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_504_prev, 1, &gn_BGP_IPV4M_NODE[503]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_505_next, 5, &gn_BGP_IPV4M_NODE[506], &gn_BGP_IPV4M_NODE[510], &gn_BGP_IPV4M_NODE[511], &gn_BGP_IPV4M_NODE[512], &gn_BGP_IPV4M_NODE[513]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_505_prev, 1, &gn_BGP_IPV4M_NODE[502]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_506_next, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_506_prev, 1, &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_507_next, 1, &gn_BGP_IPV4M_NODE[508]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_507_prev, 5, &gn_BGP_IPV4M_NODE[506], &gn_BGP_IPV4M_NODE[510], &gn_BGP_IPV4M_NODE[511], &gn_BGP_IPV4M_NODE[512], &gn_BGP_IPV4M_NODE[513]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_508_next, 1, &gn_BGP_IPV4M_NODE[509]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_508_prev, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_509_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_509_prev, 1, &gn_BGP_IPV4M_NODE[508]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_510_next, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_510_prev, 1, &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_511_next, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_511_prev, 1, &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_512_next, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_512_prev, 1, &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_513_next, 1, &gn_BGP_IPV4M_NODE[507]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_513_prev, 1, &gn_BGP_IPV4M_NODE[505]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_514_next, 1, &gn_BGP_IPV4M_NODE[515]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_514_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_515_next, 1, &gn_BGP_IPV4M_NODE[516]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_515_prev, 1, &gn_BGP_IPV4M_NODE[514]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_516_next, 1, &gn_BGP_IPV4M_NODE[517]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_516_prev, 1, &gn_BGP_IPV4M_NODE[515]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_517_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_517_prev, 1, &gn_BGP_IPV4M_NODE[516]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_518_next, 1, &gn_BGP_IPV4M_NODE[519]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_518_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_519_next, 2, &gn_BGP_IPV4M_NODE[520], &gn_BGP_IPV4M_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_519_prev, 1, &gn_BGP_IPV4M_NODE[518]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_520_next, 1, &gn_BGP_IPV4M_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_520_prev, 1, &gn_BGP_IPV4M_NODE[519]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_521_next, 1, &gn_BGP_IPV4M_NODE[522]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_521_prev, 2, &gn_BGP_IPV4M_NODE[520], &gn_BGP_IPV4M_NODE[519]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_522_next, 1, &gn_BGP_IPV4M_NODE[523]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_522_prev, 1, &gn_BGP_IPV4M_NODE[521]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_523_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_523_prev, 1, &gn_BGP_IPV4M_NODE[522]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_524_next, 1, &gn_BGP_IPV4M_NODE[525]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_524_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_525_next, 1, &gn_BGP_IPV4M_NODE[526]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_525_prev, 1, &gn_BGP_IPV4M_NODE[524]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_526_next, 1, &gn_BGP_IPV4M_NODE[527]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_526_prev, 1, &gn_BGP_IPV4M_NODE[525]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_527_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_527_prev, 1, &gn_BGP_IPV4M_NODE[526]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_528_next, 1, &gn_BGP_IPV4M_NODE[529]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_528_prev, 1, &gn_BGP_IPV4M_NODE[337]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_529_next, 2, &gn_BGP_IPV4M_NODE[530], &gn_BGP_IPV4M_NODE[531]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_529_prev, 1, &gn_BGP_IPV4M_NODE[528]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_530_next, 1, &gn_BGP_IPV4M_NODE[531]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_530_prev, 1, &gn_BGP_IPV4M_NODE[529]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_531_next, 1, &gn_BGP_IPV4M_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_531_prev, 2, &gn_BGP_IPV4M_NODE[530], &gn_BGP_IPV4M_NODE[529]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_532_next, 1, &gn_BGP_IPV4M_NODE[533]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_532_prev, 1, &gn_BGP_IPV4M_NODE[531]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_533_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_533_prev, 1, &gn_BGP_IPV4M_NODE[532]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_534_next, 1, &gn_BGP_IPV4M_NODE[535]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_534_prev, 1, &gn_BGP_IPV4M_NODE[305]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_535_next, 1, &gn_BGP_IPV4M_NODE[536]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_535_prev, 1, &gn_BGP_IPV4M_NODE[534]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_536_next, 1, &gn_BGP_IPV4M_NODE[537]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_536_prev, 1, &gn_BGP_IPV4M_NODE[535]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_537_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_537_prev, 1, &gn_BGP_IPV4M_NODE[536]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_538_next, 1, &gn_BGP_IPV4M_NODE[539]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_538_prev, 1, &gn_BGP_IPV4M_NODE[0]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_539_next, 1, &gn_BGP_IPV4M_NODE[540]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_539_prev, 1, &gn_BGP_IPV4M_NODE[538]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_540_next, 1, &gn_BGP_IPV4M_NODE[541]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_540_prev, 1, &gn_BGP_IPV4M_NODE[539]);
MAKE_VECTOR(gn_BGP_IPV4M_NODE_541_next, 0, );
MAKE_VECTOR(gn_BGP_IPV4M_NODE_541_prev, 1, &gn_BGP_IPV4M_NODE[540]);

static struct graph_node gn_BGP_IPV4M_NODE[] = {
	{
		.from = &gn_BGP_IPV4M_NODE_0_prev,
		.to = &gn_BGP_IPV4M_NODE_0_next,
		.data = &ctkn_BGP_IPV4M_NODE[0],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_1_prev,
		.to = &gn_BGP_IPV4M_NODE_1_next,
		.data = &ctkn_BGP_IPV4M_NODE[1],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_2_prev,
		.to = &gn_BGP_IPV4M_NODE_2_next,
		.data = &ctkn_BGP_IPV4M_NODE[2],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_3_prev,
		.to = &gn_BGP_IPV4M_NODE_3_next,
		.data = &ctkn_BGP_IPV4M_NODE[3],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_4_prev,
		.to = &gn_BGP_IPV4M_NODE_4_next,
		.data = &ctkn_BGP_IPV4M_NODE[4],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_5_prev,
		.to = &gn_BGP_IPV4M_NODE_5_next,
		.data = &ctkn_BGP_IPV4M_NODE[5],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_6_prev,
		.to = &gn_BGP_IPV4M_NODE_6_next,
		.data = &ctkn_BGP_IPV4M_NODE[6],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_7_prev,
		.to = &gn_BGP_IPV4M_NODE_7_next,
		.data = &ctkn_BGP_IPV4M_NODE[7],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_8_prev,
		.to = &gn_BGP_IPV4M_NODE_8_next,
		.data = &ctkn_BGP_IPV4M_NODE[8],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_9_prev,
		.to = &gn_BGP_IPV4M_NODE_9_next,
		.data = &ctkn_BGP_IPV4M_NODE[9],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_10_prev,
		.to = &gn_BGP_IPV4M_NODE_10_next,
		.data = &ctkn_BGP_IPV4M_NODE[10],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_11_prev,
		.to = &gn_BGP_IPV4M_NODE_11_next,
		.data = &ctkn_BGP_IPV4M_NODE[11],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_12_prev,
		.to = &gn_BGP_IPV4M_NODE_12_next,
		.data = &ctkn_BGP_IPV4M_NODE[12],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_13_prev,
		.to = &gn_BGP_IPV4M_NODE_13_next,
		.data = &ctkn_BGP_IPV4M_NODE[13],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_14_prev,
		.to = &gn_BGP_IPV4M_NODE_14_next,
		.data = (void *)&aggregate_addressv4_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_15_prev,
		.to = &gn_BGP_IPV4M_NODE_15_next,
		.data = &ctkn_BGP_IPV4M_NODE[15],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_16_prev,
		.to = &gn_BGP_IPV4M_NODE_16_next,
		.data = &ctkn_BGP_IPV4M_NODE[16],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_17_prev,
		.to = &gn_BGP_IPV4M_NODE_17_next,
		.data = &ctkn_BGP_IPV4M_NODE[17],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_18_prev,
		.to = &gn_BGP_IPV4M_NODE_18_next,
		.data = &ctkn_BGP_IPV4M_NODE[18],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_19_prev,
		.to = &gn_BGP_IPV4M_NODE_19_next,
		.data = &ctkn_BGP_IPV4M_NODE[19],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_20_prev,
		.to = &gn_BGP_IPV4M_NODE_20_next,
		.data = &ctkn_BGP_IPV4M_NODE[20],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_21_prev,
		.to = &gn_BGP_IPV4M_NODE_21_next,
		.data = &ctkn_BGP_IPV4M_NODE[21],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_22_prev,
		.to = &gn_BGP_IPV4M_NODE_22_next,
		.data = &ctkn_BGP_IPV4M_NODE[22],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_23_prev,
		.to = &gn_BGP_IPV4M_NODE_23_next,
		.data = &ctkn_BGP_IPV4M_NODE[23],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_24_prev,
		.to = &gn_BGP_IPV4M_NODE_24_next,
		.data = &ctkn_BGP_IPV4M_NODE[24],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_25_prev,
		.to = &gn_BGP_IPV4M_NODE_25_next,
		.data = &ctkn_BGP_IPV4M_NODE[25],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_26_prev,
		.to = &gn_BGP_IPV4M_NODE_26_next,
		.data = &ctkn_BGP_IPV4M_NODE[26],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_27_prev,
		.to = &gn_BGP_IPV4M_NODE_27_next,
		.data = &ctkn_BGP_IPV4M_NODE[27],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_28_prev,
		.to = &gn_BGP_IPV4M_NODE_28_next,
		.data = &ctkn_BGP_IPV4M_NODE[28],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_29_prev,
		.to = &gn_BGP_IPV4M_NODE_29_next,
		.data = &ctkn_BGP_IPV4M_NODE[29],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_30_prev,
		.to = &gn_BGP_IPV4M_NODE_30_next,
		.data = &ctkn_BGP_IPV4M_NODE[30],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_31_prev,
		.to = &gn_BGP_IPV4M_NODE_31_next,
		.data = &ctkn_BGP_IPV4M_NODE[31],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_32_prev,
		.to = &gn_BGP_IPV4M_NODE_32_next,
		.data = &ctkn_BGP_IPV4M_NODE[32],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_33_prev,
		.to = &gn_BGP_IPV4M_NODE_33_next,
		.data = &ctkn_BGP_IPV4M_NODE[33],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_34_prev,
		.to = &gn_BGP_IPV4M_NODE_34_next,
		.data = &ctkn_BGP_IPV4M_NODE[34],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_35_prev,
		.to = &gn_BGP_IPV4M_NODE_35_next,
		.data = &ctkn_BGP_IPV4M_NODE[35],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_36_prev,
		.to = &gn_BGP_IPV4M_NODE_36_next,
		.data = &ctkn_BGP_IPV4M_NODE[36],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_37_prev,
		.to = &gn_BGP_IPV4M_NODE_37_next,
		.data = &ctkn_BGP_IPV4M_NODE[37],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_38_prev,
		.to = &gn_BGP_IPV4M_NODE_38_next,
		.data = &ctkn_BGP_IPV4M_NODE[38],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_39_prev,
		.to = &gn_BGP_IPV4M_NODE_39_next,
		.data = &ctkn_BGP_IPV4M_NODE[39],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_40_prev,
		.to = &gn_BGP_IPV4M_NODE_40_next,
		.data = (void *)&neighbor_advertise_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_41_prev,
		.to = &gn_BGP_IPV4M_NODE_41_next,
		.data = &ctkn_BGP_IPV4M_NODE[41],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_42_prev,
		.to = &gn_BGP_IPV4M_NODE_42_next,
		.data = &ctkn_BGP_IPV4M_NODE[42],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_43_prev,
		.to = &gn_BGP_IPV4M_NODE_43_next,
		.data = &ctkn_BGP_IPV4M_NODE[43],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_44_prev,
		.to = &gn_BGP_IPV4M_NODE_44_next,
		.data = &ctkn_BGP_IPV4M_NODE[44],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_45_prev,
		.to = &gn_BGP_IPV4M_NODE_45_next,
		.data = &ctkn_BGP_IPV4M_NODE[45],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_46_prev,
		.to = &gn_BGP_IPV4M_NODE_46_next,
		.data = &ctkn_BGP_IPV4M_NODE[46],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_47_prev,
		.to = &gn_BGP_IPV4M_NODE_47_next,
		.data = &ctkn_BGP_IPV4M_NODE[47],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_48_prev,
		.to = &gn_BGP_IPV4M_NODE_48_next,
		.data = (void *)&neighbor_ecommunity_rpki_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_49_prev,
		.to = &gn_BGP_IPV4M_NODE_49_next,
		.data = &ctkn_BGP_IPV4M_NODE[49],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_50_prev,
		.to = &gn_BGP_IPV4M_NODE_50_next,
		.data = &ctkn_BGP_IPV4M_NODE[50],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_51_prev,
		.to = &gn_BGP_IPV4M_NODE_51_next,
		.data = &ctkn_BGP_IPV4M_NODE[51],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_52_prev,
		.to = &gn_BGP_IPV4M_NODE_52_next,
		.data = &ctkn_BGP_IPV4M_NODE[52],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_53_prev,
		.to = &gn_BGP_IPV4M_NODE_53_next,
		.data = &ctkn_BGP_IPV4M_NODE[53],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_54_prev,
		.to = &gn_BGP_IPV4M_NODE_54_next,
		.data = &ctkn_BGP_IPV4M_NODE[54],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_55_prev,
		.to = &gn_BGP_IPV4M_NODE_55_next,
		.data = &ctkn_BGP_IPV4M_NODE[55],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_56_prev,
		.to = &gn_BGP_IPV4M_NODE_56_next,
		.data = &ctkn_BGP_IPV4M_NODE[56],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_57_prev,
		.to = &gn_BGP_IPV4M_NODE_57_next,
		.data = &ctkn_BGP_IPV4M_NODE[57],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_58_prev,
		.to = &gn_BGP_IPV4M_NODE_58_next,
		.data = &ctkn_BGP_IPV4M_NODE[58],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_59_prev,
		.to = &gn_BGP_IPV4M_NODE_59_next,
		.data = &ctkn_BGP_IPV4M_NODE[59],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_60_prev,
		.to = &gn_BGP_IPV4M_NODE_60_next,
		.data = (void *)&bgp_network_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_61_prev,
		.to = &gn_BGP_IPV4M_NODE_61_next,
		.data = &ctkn_BGP_IPV4M_NODE[61],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_62_prev,
		.to = &gn_BGP_IPV4M_NODE_62_next,
		.data = &ctkn_BGP_IPV4M_NODE[62],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_63_prev,
		.to = &gn_BGP_IPV4M_NODE_63_next,
		.data = &ctkn_BGP_IPV4M_NODE[63],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_64_prev,
		.to = &gn_BGP_IPV4M_NODE_64_next,
		.data = &ctkn_BGP_IPV4M_NODE[64],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_65_prev,
		.to = &gn_BGP_IPV4M_NODE_65_next,
		.data = &ctkn_BGP_IPV4M_NODE[65],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_66_prev,
		.to = &gn_BGP_IPV4M_NODE_66_next,
		.data = &ctkn_BGP_IPV4M_NODE[66],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_67_prev,
		.to = &gn_BGP_IPV4M_NODE_67_next,
		.data = &ctkn_BGP_IPV4M_NODE[67],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_68_prev,
		.to = &gn_BGP_IPV4M_NODE_68_next,
		.data = &ctkn_BGP_IPV4M_NODE[68],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_69_prev,
		.to = &gn_BGP_IPV4M_NODE_69_next,
		.data = &ctkn_BGP_IPV4M_NODE[69],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_70_prev,
		.to = &gn_BGP_IPV4M_NODE_70_next,
		.data = &ctkn_BGP_IPV4M_NODE[70],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_71_prev,
		.to = &gn_BGP_IPV4M_NODE_71_next,
		.data = &ctkn_BGP_IPV4M_NODE[71],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_72_prev,
		.to = &gn_BGP_IPV4M_NODE_72_next,
		.data = &ctkn_BGP_IPV4M_NODE[72],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_73_prev,
		.to = &gn_BGP_IPV4M_NODE_73_next,
		.data = &ctkn_BGP_IPV4M_NODE[73],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_74_prev,
		.to = &gn_BGP_IPV4M_NODE_74_next,
		.data = &ctkn_BGP_IPV4M_NODE[74],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_75_prev,
		.to = &gn_BGP_IPV4M_NODE_75_next,
		.data = &ctkn_BGP_IPV4M_NODE[75],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_76_prev,
		.to = &gn_BGP_IPV4M_NODE_76_next,
		.data = &ctkn_BGP_IPV4M_NODE[76],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_77_prev,
		.to = &gn_BGP_IPV4M_NODE_77_next,
		.data = &ctkn_BGP_IPV4M_NODE[77],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_78_prev,
		.to = &gn_BGP_IPV4M_NODE_78_next,
		.data = &ctkn_BGP_IPV4M_NODE[78],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_79_prev,
		.to = &gn_BGP_IPV4M_NODE_79_next,
		.data = &ctkn_BGP_IPV4M_NODE[79],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_80_prev,
		.to = &gn_BGP_IPV4M_NODE_80_next,
		.data = (void *)&bgp_damp_set_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_81_prev,
		.to = &gn_BGP_IPV4M_NODE_81_next,
		.data = &ctkn_BGP_IPV4M_NODE[81],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_82_prev,
		.to = &gn_BGP_IPV4M_NODE_82_next,
		.data = &ctkn_BGP_IPV4M_NODE[82],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_83_prev,
		.to = &gn_BGP_IPV4M_NODE_83_next,
		.data = &ctkn_BGP_IPV4M_NODE[83],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_84_prev,
		.to = &gn_BGP_IPV4M_NODE_84_next,
		.data = &ctkn_BGP_IPV4M_NODE[84],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_85_prev,
		.to = &gn_BGP_IPV4M_NODE_85_next,
		.data = (void *)&bgp_distance_source_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_86_prev,
		.to = &gn_BGP_IPV4M_NODE_86_next,
		.data = &ctkn_BGP_IPV4M_NODE[86],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_87_prev,
		.to = &gn_BGP_IPV4M_NODE_87_next,
		.data = &ctkn_BGP_IPV4M_NODE[87],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_88_prev,
		.to = &gn_BGP_IPV4M_NODE_88_next,
		.data = (void *)&bgp_distance_source_access_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_89_prev,
		.to = &gn_BGP_IPV4M_NODE_89_next,
		.data = &ctkn_BGP_IPV4M_NODE[89],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_90_prev,
		.to = &gn_BGP_IPV4M_NODE_90_next,
		.data = &ctkn_BGP_IPV4M_NODE[90],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_91_prev,
		.to = &gn_BGP_IPV4M_NODE_91_next,
		.data = &ctkn_BGP_IPV4M_NODE[91],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_92_prev,
		.to = &gn_BGP_IPV4M_NODE_92_next,
		.data = &ctkn_BGP_IPV4M_NODE[92],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_93_prev,
		.to = &gn_BGP_IPV4M_NODE_93_next,
		.data = &ctkn_BGP_IPV4M_NODE[93],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_94_prev,
		.to = &gn_BGP_IPV4M_NODE_94_next,
		.data = (void *)&bgp_distance_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_95_prev,
		.to = &gn_BGP_IPV4M_NODE_95_next,
		.data = &ctkn_BGP_IPV4M_NODE[95],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_96_prev,
		.to = &gn_BGP_IPV4M_NODE_96_next,
		.data = &ctkn_BGP_IPV4M_NODE[96],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_97_prev,
		.to = &gn_BGP_IPV4M_NODE_97_next,
		.data = &ctkn_BGP_IPV4M_NODE[97],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_98_prev,
		.to = &gn_BGP_IPV4M_NODE_98_next,
		.data = &ctkn_BGP_IPV4M_NODE[98],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_99_prev,
		.to = &gn_BGP_IPV4M_NODE_99_next,
		.data = &ctkn_BGP_IPV4M_NODE[99],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_100_prev,
		.to = &gn_BGP_IPV4M_NODE_100_next,
		.data = &ctkn_BGP_IPV4M_NODE[100],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_101_prev,
		.to = &gn_BGP_IPV4M_NODE_101_next,
		.data = (void *)&neighbor_activate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_102_prev,
		.to = &gn_BGP_IPV4M_NODE_102_next,
		.data = &ctkn_BGP_IPV4M_NODE[102],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_103_prev,
		.to = &gn_BGP_IPV4M_NODE_103_next,
		.data = &ctkn_BGP_IPV4M_NODE[103],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_104_prev,
		.to = &gn_BGP_IPV4M_NODE_104_next,
		.data = &ctkn_BGP_IPV4M_NODE[104],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_105_prev,
		.to = &gn_BGP_IPV4M_NODE_105_next,
		.data = &ctkn_BGP_IPV4M_NODE[105],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_106_prev,
		.to = &gn_BGP_IPV4M_NODE_106_next,
		.data = &ctkn_BGP_IPV4M_NODE[106],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_107_prev,
		.to = &gn_BGP_IPV4M_NODE_107_next,
		.data = (void *)&neighbor_addpath_paths_limit_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_108_prev,
		.to = &gn_BGP_IPV4M_NODE_108_next,
		.data = &ctkn_BGP_IPV4M_NODE[108],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_109_prev,
		.to = &gn_BGP_IPV4M_NODE_109_next,
		.data = &ctkn_BGP_IPV4M_NODE[109],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_110_prev,
		.to = &gn_BGP_IPV4M_NODE_110_next,
		.data = (void *)&neighbor_addpath_tx_all_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_111_prev,
		.to = &gn_BGP_IPV4M_NODE_111_next,
		.data = &ctkn_BGP_IPV4M_NODE[111],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_112_prev,
		.to = &gn_BGP_IPV4M_NODE_112_next,
		.data = &ctkn_BGP_IPV4M_NODE[112],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_113_prev,
		.to = &gn_BGP_IPV4M_NODE_113_next,
		.data = &ctkn_BGP_IPV4M_NODE[113],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_114_prev,
		.to = &gn_BGP_IPV4M_NODE_114_next,
		.data = (void *)&neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_115_prev,
		.to = &gn_BGP_IPV4M_NODE_115_next,
		.data = &ctkn_BGP_IPV4M_NODE[115],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_116_prev,
		.to = &gn_BGP_IPV4M_NODE_116_next,
		.data = &ctkn_BGP_IPV4M_NODE[116],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_117_prev,
		.to = &gn_BGP_IPV4M_NODE_117_next,
		.data = (void *)&neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_118_prev,
		.to = &gn_BGP_IPV4M_NODE_118_next,
		.data = &ctkn_BGP_IPV4M_NODE[118],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_119_prev,
		.to = &gn_BGP_IPV4M_NODE_119_next,
		.data = &ctkn_BGP_IPV4M_NODE[119],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_120_prev,
		.to = &gn_BGP_IPV4M_NODE_120_next,
		.data = &ctkn_BGP_IPV4M_NODE[120],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_121_prev,
		.to = &gn_BGP_IPV4M_NODE_121_next,
		.data = &ctkn_BGP_IPV4M_NODE[121],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_122_prev,
		.to = &gn_BGP_IPV4M_NODE_122_next,
		.data = &ctkn_BGP_IPV4M_NODE[122],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_123_prev,
		.to = &gn_BGP_IPV4M_NODE_123_next,
		.data = &ctkn_BGP_IPV4M_NODE[123],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_124_prev,
		.to = &gn_BGP_IPV4M_NODE_124_next,
		.data = &ctkn_BGP_IPV4M_NODE[124],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_125_prev,
		.to = &gn_BGP_IPV4M_NODE_125_next,
		.data = (void *)&neighbor_allowas_in_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_126_prev,
		.to = &gn_BGP_IPV4M_NODE_126_next,
		.data = &ctkn_BGP_IPV4M_NODE[126],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_127_prev,
		.to = &gn_BGP_IPV4M_NODE_127_next,
		.data = &ctkn_BGP_IPV4M_NODE[127],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_128_prev,
		.to = &gn_BGP_IPV4M_NODE_128_next,
		.data = &ctkn_BGP_IPV4M_NODE[128],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_129_prev,
		.to = &gn_BGP_IPV4M_NODE_129_next,
		.data = (void *)&neighbor_as_override_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_130_prev,
		.to = &gn_BGP_IPV4M_NODE_130_next,
		.data = &ctkn_BGP_IPV4M_NODE[130],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_131_prev,
		.to = &gn_BGP_IPV4M_NODE_131_next,
		.data = &ctkn_BGP_IPV4M_NODE[131],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_132_prev,
		.to = &gn_BGP_IPV4M_NODE_132_next,
		.data = &ctkn_BGP_IPV4M_NODE[132],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_133_prev,
		.to = &gn_BGP_IPV4M_NODE_133_next,
		.data = &ctkn_BGP_IPV4M_NODE[133],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_134_prev,
		.to = &gn_BGP_IPV4M_NODE_134_next,
		.data = &ctkn_BGP_IPV4M_NODE[134],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_135_prev,
		.to = &gn_BGP_IPV4M_NODE_135_next,
		.data = &ctkn_BGP_IPV4M_NODE[135],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_136_prev,
		.to = &gn_BGP_IPV4M_NODE_136_next,
		.data = &ctkn_BGP_IPV4M_NODE[136],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_137_prev,
		.to = &gn_BGP_IPV4M_NODE_137_next,
		.data = (void *)&neighbor_attr_unchanged_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_138_prev,
		.to = &gn_BGP_IPV4M_NODE_138_next,
		.data = &ctkn_BGP_IPV4M_NODE[138],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_139_prev,
		.to = &gn_BGP_IPV4M_NODE_139_next,
		.data = &ctkn_BGP_IPV4M_NODE[139],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_140_prev,
		.to = &gn_BGP_IPV4M_NODE_140_next,
		.data = &ctkn_BGP_IPV4M_NODE[140],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_141_prev,
		.to = &gn_BGP_IPV4M_NODE_141_next,
		.data = &ctkn_BGP_IPV4M_NODE[141],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_142_prev,
		.to = &gn_BGP_IPV4M_NODE_142_next,
		.data = &ctkn_BGP_IPV4M_NODE[142],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_143_prev,
		.to = &gn_BGP_IPV4M_NODE_143_next,
		.data = &ctkn_BGP_IPV4M_NODE[143],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_144_prev,
		.to = &gn_BGP_IPV4M_NODE_144_next,
		.data = &ctkn_BGP_IPV4M_NODE[144],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_145_prev,
		.to = &gn_BGP_IPV4M_NODE_145_next,
		.data = &ctkn_BGP_IPV4M_NODE[145],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_146_prev,
		.to = &gn_BGP_IPV4M_NODE_146_next,
		.data = &ctkn_BGP_IPV4M_NODE[146],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_147_prev,
		.to = &gn_BGP_IPV4M_NODE_147_next,
		.data = (void *)&neighbor_capability_orf_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_148_prev,
		.to = &gn_BGP_IPV4M_NODE_148_next,
		.data = &ctkn_BGP_IPV4M_NODE[148],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_149_prev,
		.to = &gn_BGP_IPV4M_NODE_149_next,
		.data = &ctkn_BGP_IPV4M_NODE[149],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_150_prev,
		.to = &gn_BGP_IPV4M_NODE_150_next,
		.data = &ctkn_BGP_IPV4M_NODE[150],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_151_prev,
		.to = &gn_BGP_IPV4M_NODE_151_next,
		.data = &ctkn_BGP_IPV4M_NODE[151],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_152_prev,
		.to = &gn_BGP_IPV4M_NODE_152_next,
		.data = &ctkn_BGP_IPV4M_NODE[152],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_153_prev,
		.to = &gn_BGP_IPV4M_NODE_153_next,
		.data = &ctkn_BGP_IPV4M_NODE[153],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_154_prev,
		.to = &gn_BGP_IPV4M_NODE_154_next,
		.data = &ctkn_BGP_IPV4M_NODE[154],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_155_prev,
		.to = &gn_BGP_IPV4M_NODE_155_next,
		.data = &ctkn_BGP_IPV4M_NODE[155],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_156_prev,
		.to = &gn_BGP_IPV4M_NODE_156_next,
		.data = &ctkn_BGP_IPV4M_NODE[156],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_157_prev,
		.to = &gn_BGP_IPV4M_NODE_157_next,
		.data = &ctkn_BGP_IPV4M_NODE[157],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_158_prev,
		.to = &gn_BGP_IPV4M_NODE_158_next,
		.data = &ctkn_BGP_IPV4M_NODE[158],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_159_prev,
		.to = &gn_BGP_IPV4M_NODE_159_next,
		.data = &ctkn_BGP_IPV4M_NODE[159],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_160_prev,
		.to = &gn_BGP_IPV4M_NODE_160_next,
		.data = (void *)&neighbor_damp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_161_prev,
		.to = &gn_BGP_IPV4M_NODE_161_next,
		.data = &ctkn_BGP_IPV4M_NODE[161],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_162_prev,
		.to = &gn_BGP_IPV4M_NODE_162_next,
		.data = &ctkn_BGP_IPV4M_NODE[162],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_163_prev,
		.to = &gn_BGP_IPV4M_NODE_163_next,
		.data = (void *)&neighbor_default_originate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_164_prev,
		.to = &gn_BGP_IPV4M_NODE_164_next,
		.data = &ctkn_BGP_IPV4M_NODE[164],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_165_prev,
		.to = &gn_BGP_IPV4M_NODE_165_next,
		.data = &ctkn_BGP_IPV4M_NODE[165],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_166_prev,
		.to = &gn_BGP_IPV4M_NODE_166_next,
		.data = &ctkn_BGP_IPV4M_NODE[166],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_167_prev,
		.to = &gn_BGP_IPV4M_NODE_167_next,
		.data = (void *)&neighbor_default_originate_rmap_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_168_prev,
		.to = &gn_BGP_IPV4M_NODE_168_next,
		.data = &ctkn_BGP_IPV4M_NODE[168],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_169_prev,
		.to = &gn_BGP_IPV4M_NODE_169_next,
		.data = &ctkn_BGP_IPV4M_NODE[169],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_170_prev,
		.to = &gn_BGP_IPV4M_NODE_170_next,
		.data = (void *)&neighbor_disable_addpath_rx_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_171_prev,
		.to = &gn_BGP_IPV4M_NODE_171_next,
		.data = &ctkn_BGP_IPV4M_NODE[171],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_172_prev,
		.to = &gn_BGP_IPV4M_NODE_172_next,
		.data = &ctkn_BGP_IPV4M_NODE[172],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_173_prev,
		.to = &gn_BGP_IPV4M_NODE_173_next,
		.data = &ctkn_BGP_IPV4M_NODE[173],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_174_prev,
		.to = &gn_BGP_IPV4M_NODE_174_next,
		.data = &ctkn_BGP_IPV4M_NODE[174],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_175_prev,
		.to = &gn_BGP_IPV4M_NODE_175_next,
		.data = &ctkn_BGP_IPV4M_NODE[175],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_176_prev,
		.to = &gn_BGP_IPV4M_NODE_176_next,
		.data = &ctkn_BGP_IPV4M_NODE[176],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_177_prev,
		.to = &gn_BGP_IPV4M_NODE_177_next,
		.data = (void *)&neighbor_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_178_prev,
		.to = &gn_BGP_IPV4M_NODE_178_next,
		.data = &ctkn_BGP_IPV4M_NODE[178],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_179_prev,
		.to = &gn_BGP_IPV4M_NODE_179_next,
		.data = &ctkn_BGP_IPV4M_NODE[179],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_180_prev,
		.to = &gn_BGP_IPV4M_NODE_180_next,
		.data = &ctkn_BGP_IPV4M_NODE[180],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_181_prev,
		.to = &gn_BGP_IPV4M_NODE_181_next,
		.data = &ctkn_BGP_IPV4M_NODE[181],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_182_prev,
		.to = &gn_BGP_IPV4M_NODE_182_next,
		.data = &ctkn_BGP_IPV4M_NODE[182],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_183_prev,
		.to = &gn_BGP_IPV4M_NODE_183_next,
		.data = &ctkn_BGP_IPV4M_NODE[183],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_184_prev,
		.to = &gn_BGP_IPV4M_NODE_184_next,
		.data = &ctkn_BGP_IPV4M_NODE[184],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_185_prev,
		.to = &gn_BGP_IPV4M_NODE_185_next,
		.data = (void *)&neighbor_filter_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_186_prev,
		.to = &gn_BGP_IPV4M_NODE_186_next,
		.data = &ctkn_BGP_IPV4M_NODE[186],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_187_prev,
		.to = &gn_BGP_IPV4M_NODE_187_next,
		.data = &ctkn_BGP_IPV4M_NODE[187],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_188_prev,
		.to = &gn_BGP_IPV4M_NODE_188_next,
		.data = &ctkn_BGP_IPV4M_NODE[188],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_189_prev,
		.to = &gn_BGP_IPV4M_NODE_189_next,
		.data = &ctkn_BGP_IPV4M_NODE[189],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_190_prev,
		.to = &gn_BGP_IPV4M_NODE_190_next,
		.data = &ctkn_BGP_IPV4M_NODE[190],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_191_prev,
		.to = &gn_BGP_IPV4M_NODE_191_next,
		.data = &ctkn_BGP_IPV4M_NODE[191],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_192_prev,
		.to = &gn_BGP_IPV4M_NODE_192_next,
		.data = &ctkn_BGP_IPV4M_NODE[192],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_193_prev,
		.to = &gn_BGP_IPV4M_NODE_193_next,
		.data = &ctkn_BGP_IPV4M_NODE[193],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_194_prev,
		.to = &gn_BGP_IPV4M_NODE_194_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_195_prev,
		.to = &gn_BGP_IPV4M_NODE_195_next,
		.data = &ctkn_BGP_IPV4M_NODE[195],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_196_prev,
		.to = &gn_BGP_IPV4M_NODE_196_next,
		.data = &ctkn_BGP_IPV4M_NODE[196],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_197_prev,
		.to = &gn_BGP_IPV4M_NODE_197_next,
		.data = &ctkn_BGP_IPV4M_NODE[197],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_198_prev,
		.to = &gn_BGP_IPV4M_NODE_198_next,
		.data = &ctkn_BGP_IPV4M_NODE[198],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_199_prev,
		.to = &gn_BGP_IPV4M_NODE_199_next,
		.data = &ctkn_BGP_IPV4M_NODE[199],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_200_prev,
		.to = &gn_BGP_IPV4M_NODE_200_next,
		.data = &ctkn_BGP_IPV4M_NODE[200],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_201_prev,
		.to = &gn_BGP_IPV4M_NODE_201_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_restart_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_202_prev,
		.to = &gn_BGP_IPV4M_NODE_202_next,
		.data = &ctkn_BGP_IPV4M_NODE[202],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_203_prev,
		.to = &gn_BGP_IPV4M_NODE_203_next,
		.data = &ctkn_BGP_IPV4M_NODE[203],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_204_prev,
		.to = &gn_BGP_IPV4M_NODE_204_next,
		.data = &ctkn_BGP_IPV4M_NODE[204],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_205_prev,
		.to = &gn_BGP_IPV4M_NODE_205_next,
		.data = &ctkn_BGP_IPV4M_NODE[205],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_206_prev,
		.to = &gn_BGP_IPV4M_NODE_206_next,
		.data = &ctkn_BGP_IPV4M_NODE[206],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_207_prev,
		.to = &gn_BGP_IPV4M_NODE_207_next,
		.data = (void *)&neighbor_maximum_prefix_threshold_warning_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_208_prev,
		.to = &gn_BGP_IPV4M_NODE_208_next,
		.data = &ctkn_BGP_IPV4M_NODE[208],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_209_prev,
		.to = &gn_BGP_IPV4M_NODE_209_next,
		.data = &ctkn_BGP_IPV4M_NODE[209],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_210_prev,
		.to = &gn_BGP_IPV4M_NODE_210_next,
		.data = &ctkn_BGP_IPV4M_NODE[210],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_211_prev,
		.to = &gn_BGP_IPV4M_NODE_211_next,
		.data = &ctkn_BGP_IPV4M_NODE[211],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_212_prev,
		.to = &gn_BGP_IPV4M_NODE_212_next,
		.data = (void *)&neighbor_maximum_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_213_prev,
		.to = &gn_BGP_IPV4M_NODE_213_next,
		.data = &ctkn_BGP_IPV4M_NODE[213],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_214_prev,
		.to = &gn_BGP_IPV4M_NODE_214_next,
		.data = &ctkn_BGP_IPV4M_NODE[214],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_215_prev,
		.to = &gn_BGP_IPV4M_NODE_215_next,
		.data = &ctkn_BGP_IPV4M_NODE[215],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_216_prev,
		.to = &gn_BGP_IPV4M_NODE_216_next,
		.data = &ctkn_BGP_IPV4M_NODE[216],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_217_prev,
		.to = &gn_BGP_IPV4M_NODE_217_next,
		.data = &ctkn_BGP_IPV4M_NODE[217],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_218_prev,
		.to = &gn_BGP_IPV4M_NODE_218_next,
		.data = &ctkn_BGP_IPV4M_NODE[218],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_219_prev,
		.to = &gn_BGP_IPV4M_NODE_219_next,
		.data = (void *)&neighbor_maximum_prefix_restart_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_220_prev,
		.to = &gn_BGP_IPV4M_NODE_220_next,
		.data = &ctkn_BGP_IPV4M_NODE[220],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_221_prev,
		.to = &gn_BGP_IPV4M_NODE_221_next,
		.data = &ctkn_BGP_IPV4M_NODE[221],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_222_prev,
		.to = &gn_BGP_IPV4M_NODE_222_next,
		.data = &ctkn_BGP_IPV4M_NODE[222],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_223_prev,
		.to = &gn_BGP_IPV4M_NODE_223_next,
		.data = &ctkn_BGP_IPV4M_NODE[223],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_224_prev,
		.to = &gn_BGP_IPV4M_NODE_224_next,
		.data = &ctkn_BGP_IPV4M_NODE[224],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_225_prev,
		.to = &gn_BGP_IPV4M_NODE_225_next,
		.data = (void *)&neighbor_maximum_prefix_warning_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_226_prev,
		.to = &gn_BGP_IPV4M_NODE_226_next,
		.data = &ctkn_BGP_IPV4M_NODE[226],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_227_prev,
		.to = &gn_BGP_IPV4M_NODE_227_next,
		.data = &ctkn_BGP_IPV4M_NODE[227],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_228_prev,
		.to = &gn_BGP_IPV4M_NODE_228_next,
		.data = &ctkn_BGP_IPV4M_NODE[228],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_229_prev,
		.to = &gn_BGP_IPV4M_NODE_229_next,
		.data = (void *)&neighbor_maximum_prefix_out_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_230_prev,
		.to = &gn_BGP_IPV4M_NODE_230_next,
		.data = &ctkn_BGP_IPV4M_NODE[230],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_231_prev,
		.to = &gn_BGP_IPV4M_NODE_231_next,
		.data = &ctkn_BGP_IPV4M_NODE[231],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_232_prev,
		.to = &gn_BGP_IPV4M_NODE_232_next,
		.data = (void *)&neighbor_nexthop_self_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_233_prev,
		.to = &gn_BGP_IPV4M_NODE_233_next,
		.data = &ctkn_BGP_IPV4M_NODE[233],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_234_prev,
		.to = &gn_BGP_IPV4M_NODE_234_next,
		.data = &ctkn_BGP_IPV4M_NODE[234],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_235_prev,
		.to = &gn_BGP_IPV4M_NODE_235_next,
		.data = (void *)&neighbor_nexthop_self_all_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_236_prev,
		.to = &gn_BGP_IPV4M_NODE_236_next,
		.data = &ctkn_BGP_IPV4M_NODE[236],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_237_prev,
		.to = &gn_BGP_IPV4M_NODE_237_next,
		.data = &ctkn_BGP_IPV4M_NODE[237],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_238_prev,
		.to = &gn_BGP_IPV4M_NODE_238_next,
		.data = (void *)&neighbor_nexthop_self_force_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_239_prev,
		.to = &gn_BGP_IPV4M_NODE_239_next,
		.data = &ctkn_BGP_IPV4M_NODE[239],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_240_prev,
		.to = &gn_BGP_IPV4M_NODE_240_next,
		.data = &ctkn_BGP_IPV4M_NODE[240],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_241_prev,
		.to = &gn_BGP_IPV4M_NODE_241_next,
		.data = &ctkn_BGP_IPV4M_NODE[241],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_242_prev,
		.to = &gn_BGP_IPV4M_NODE_242_next,
		.data = (void *)&neighbor_set_peer_group_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_243_prev,
		.to = &gn_BGP_IPV4M_NODE_243_next,
		.data = &ctkn_BGP_IPV4M_NODE[243],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_244_prev,
		.to = &gn_BGP_IPV4M_NODE_244_next,
		.data = &ctkn_BGP_IPV4M_NODE[244],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_245_prev,
		.to = &gn_BGP_IPV4M_NODE_245_next,
		.data = &ctkn_BGP_IPV4M_NODE[245],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_246_prev,
		.to = &gn_BGP_IPV4M_NODE_246_next,
		.data = &ctkn_BGP_IPV4M_NODE[246],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_247_prev,
		.to = &gn_BGP_IPV4M_NODE_247_next,
		.data = &ctkn_BGP_IPV4M_NODE[247],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_248_prev,
		.to = &gn_BGP_IPV4M_NODE_248_next,
		.data = &ctkn_BGP_IPV4M_NODE[248],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_249_prev,
		.to = &gn_BGP_IPV4M_NODE_249_next,
		.data = (void *)&neighbor_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_250_prev,
		.to = &gn_BGP_IPV4M_NODE_250_next,
		.data = &ctkn_BGP_IPV4M_NODE[250],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_251_prev,
		.to = &gn_BGP_IPV4M_NODE_251_next,
		.data = &ctkn_BGP_IPV4M_NODE[251],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_252_prev,
		.to = &gn_BGP_IPV4M_NODE_252_next,
		.data = &ctkn_BGP_IPV4M_NODE[252],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_253_prev,
		.to = &gn_BGP_IPV4M_NODE_253_next,
		.data = (void *)&neighbor_remove_private_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_254_prev,
		.to = &gn_BGP_IPV4M_NODE_254_next,
		.data = &ctkn_BGP_IPV4M_NODE[254],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_255_prev,
		.to = &gn_BGP_IPV4M_NODE_255_next,
		.data = &ctkn_BGP_IPV4M_NODE[255],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_256_prev,
		.to = &gn_BGP_IPV4M_NODE_256_next,
		.data = (void *)&neighbor_remove_private_as_all_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_257_prev,
		.to = &gn_BGP_IPV4M_NODE_257_next,
		.data = &ctkn_BGP_IPV4M_NODE[257],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_258_prev,
		.to = &gn_BGP_IPV4M_NODE_258_next,
		.data = &ctkn_BGP_IPV4M_NODE[258],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_259_prev,
		.to = &gn_BGP_IPV4M_NODE_259_next,
		.data = (void *)&neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_260_prev,
		.to = &gn_BGP_IPV4M_NODE_260_next,
		.data = &ctkn_BGP_IPV4M_NODE[260],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_261_prev,
		.to = &gn_BGP_IPV4M_NODE_261_next,
		.data = &ctkn_BGP_IPV4M_NODE[261],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_262_prev,
		.to = &gn_BGP_IPV4M_NODE_262_next,
		.data = (void *)&neighbor_remove_private_as_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_263_prev,
		.to = &gn_BGP_IPV4M_NODE_263_next,
		.data = &ctkn_BGP_IPV4M_NODE[263],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_264_prev,
		.to = &gn_BGP_IPV4M_NODE_264_next,
		.data = &ctkn_BGP_IPV4M_NODE[264],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_265_prev,
		.to = &gn_BGP_IPV4M_NODE_265_next,
		.data = &ctkn_BGP_IPV4M_NODE[265],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_266_prev,
		.to = &gn_BGP_IPV4M_NODE_266_next,
		.data = &ctkn_BGP_IPV4M_NODE[266],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_267_prev,
		.to = &gn_BGP_IPV4M_NODE_267_next,
		.data = &ctkn_BGP_IPV4M_NODE[267],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_268_prev,
		.to = &gn_BGP_IPV4M_NODE_268_next,
		.data = &ctkn_BGP_IPV4M_NODE[268],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_269_prev,
		.to = &gn_BGP_IPV4M_NODE_269_next,
		.data = (void *)&neighbor_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_270_prev,
		.to = &gn_BGP_IPV4M_NODE_270_next,
		.data = &ctkn_BGP_IPV4M_NODE[270],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_271_prev,
		.to = &gn_BGP_IPV4M_NODE_271_next,
		.data = &ctkn_BGP_IPV4M_NODE[271],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_272_prev,
		.to = &gn_BGP_IPV4M_NODE_272_next,
		.data = &ctkn_BGP_IPV4M_NODE[272],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_273_prev,
		.to = &gn_BGP_IPV4M_NODE_273_next,
		.data = (void *)&neighbor_route_reflector_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_274_prev,
		.to = &gn_BGP_IPV4M_NODE_274_next,
		.data = &ctkn_BGP_IPV4M_NODE[274],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_275_prev,
		.to = &gn_BGP_IPV4M_NODE_275_next,
		.data = &ctkn_BGP_IPV4M_NODE[275],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_276_prev,
		.to = &gn_BGP_IPV4M_NODE_276_next,
		.data = (void *)&neighbor_route_server_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_277_prev,
		.to = &gn_BGP_IPV4M_NODE_277_next,
		.data = &ctkn_BGP_IPV4M_NODE[277],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_278_prev,
		.to = &gn_BGP_IPV4M_NODE_278_next,
		.data = &ctkn_BGP_IPV4M_NODE[278],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_279_prev,
		.to = &gn_BGP_IPV4M_NODE_279_next,
		.data = (void *)&neighbor_send_community_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_280_prev,
		.to = &gn_BGP_IPV4M_NODE_280_next,
		.data = &ctkn_BGP_IPV4M_NODE[280],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_281_prev,
		.to = &gn_BGP_IPV4M_NODE_281_next,
		.data = &ctkn_BGP_IPV4M_NODE[281],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_282_prev,
		.to = &gn_BGP_IPV4M_NODE_282_next,
		.data = &ctkn_BGP_IPV4M_NODE[282],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_283_prev,
		.to = &gn_BGP_IPV4M_NODE_283_next,
		.data = &ctkn_BGP_IPV4M_NODE[283],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_284_prev,
		.to = &gn_BGP_IPV4M_NODE_284_next,
		.data = (void *)&neighbor_send_community_type_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_285_prev,
		.to = &gn_BGP_IPV4M_NODE_285_next,
		.data = &ctkn_BGP_IPV4M_NODE[285],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_286_prev,
		.to = &gn_BGP_IPV4M_NODE_286_next,
		.data = &ctkn_BGP_IPV4M_NODE[286],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_287_prev,
		.to = &gn_BGP_IPV4M_NODE_287_next,
		.data = &ctkn_BGP_IPV4M_NODE[287],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_288_prev,
		.to = &gn_BGP_IPV4M_NODE_288_next,
		.data = &ctkn_BGP_IPV4M_NODE[288],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_289_prev,
		.to = &gn_BGP_IPV4M_NODE_289_next,
		.data = &ctkn_BGP_IPV4M_NODE[289],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_290_prev,
		.to = &gn_BGP_IPV4M_NODE_290_next,
		.data = &ctkn_BGP_IPV4M_NODE[290],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_291_prev,
		.to = &gn_BGP_IPV4M_NODE_291_next,
		.data = &ctkn_BGP_IPV4M_NODE[291],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_292_prev,
		.to = &gn_BGP_IPV4M_NODE_292_next,
		.data = (void *)&neighbor_soft_reconfiguration_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_293_prev,
		.to = &gn_BGP_IPV4M_NODE_293_next,
		.data = &ctkn_BGP_IPV4M_NODE[293],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_294_prev,
		.to = &gn_BGP_IPV4M_NODE_294_next,
		.data = &ctkn_BGP_IPV4M_NODE[294],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_295_prev,
		.to = &gn_BGP_IPV4M_NODE_295_next,
		.data = &ctkn_BGP_IPV4M_NODE[295],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_296_prev,
		.to = &gn_BGP_IPV4M_NODE_296_next,
		.data = (void *)&neighbor_soo_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_297_prev,
		.to = &gn_BGP_IPV4M_NODE_297_next,
		.data = &ctkn_BGP_IPV4M_NODE[297],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_298_prev,
		.to = &gn_BGP_IPV4M_NODE_298_next,
		.data = &ctkn_BGP_IPV4M_NODE[298],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_299_prev,
		.to = &gn_BGP_IPV4M_NODE_299_next,
		.data = &ctkn_BGP_IPV4M_NODE[299],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_300_prev,
		.to = &gn_BGP_IPV4M_NODE_300_next,
		.data = (void *)&neighbor_unsuppress_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_301_prev,
		.to = &gn_BGP_IPV4M_NODE_301_next,
		.data = &ctkn_BGP_IPV4M_NODE[301],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_302_prev,
		.to = &gn_BGP_IPV4M_NODE_302_next,
		.data = &ctkn_BGP_IPV4M_NODE[302],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_303_prev,
		.to = &gn_BGP_IPV4M_NODE_303_next,
		.data = &ctkn_BGP_IPV4M_NODE[303],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_304_prev,
		.to = &gn_BGP_IPV4M_NODE_304_next,
		.data = (void *)&neighbor_weight_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_305_prev,
		.to = &gn_BGP_IPV4M_NODE_305_next,
		.data = &ctkn_BGP_IPV4M_NODE[305],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_306_prev,
		.to = &gn_BGP_IPV4M_NODE_306_next,
		.data = &ctkn_BGP_IPV4M_NODE[306],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_307_prev,
		.to = &gn_BGP_IPV4M_NODE_307_next,
		.data = &ctkn_BGP_IPV4M_NODE[307],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_308_prev,
		.to = &gn_BGP_IPV4M_NODE_308_next,
		.data = &ctkn_BGP_IPV4M_NODE[308],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_309_prev,
		.to = &gn_BGP_IPV4M_NODE_309_next,
		.data = &ctkn_BGP_IPV4M_NODE[309],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_310_prev,
		.to = &gn_BGP_IPV4M_NODE_310_next,
		.data = &ctkn_BGP_IPV4M_NODE[310],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_311_prev,
		.to = &gn_BGP_IPV4M_NODE_311_next,
		.data = &ctkn_BGP_IPV4M_NODE[311],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_312_prev,
		.to = &gn_BGP_IPV4M_NODE_312_next,
		.data = &ctkn_BGP_IPV4M_NODE[312],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_313_prev,
		.to = &gn_BGP_IPV4M_NODE_313_next,
		.data = &ctkn_BGP_IPV4M_NODE[313],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_314_prev,
		.to = &gn_BGP_IPV4M_NODE_314_next,
		.data = &ctkn_BGP_IPV4M_NODE[314],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_315_prev,
		.to = &gn_BGP_IPV4M_NODE_315_next,
		.data = &ctkn_BGP_IPV4M_NODE[315],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_316_prev,
		.to = &gn_BGP_IPV4M_NODE_316_next,
		.data = &ctkn_BGP_IPV4M_NODE[316],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_317_prev,
		.to = &gn_BGP_IPV4M_NODE_317_next,
		.data = (void *)&bgp_damp_unset_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_318_prev,
		.to = &gn_BGP_IPV4M_NODE_318_next,
		.data = &ctkn_BGP_IPV4M_NODE[318],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_319_prev,
		.to = &gn_BGP_IPV4M_NODE_319_next,
		.data = &ctkn_BGP_IPV4M_NODE[319],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_320_prev,
		.to = &gn_BGP_IPV4M_NODE_320_next,
		.data = &ctkn_BGP_IPV4M_NODE[320],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_321_prev,
		.to = &gn_BGP_IPV4M_NODE_321_next,
		.data = &ctkn_BGP_IPV4M_NODE[321],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_322_prev,
		.to = &gn_BGP_IPV4M_NODE_322_next,
		.data = (void *)&no_bgp_distance_source_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_323_prev,
		.to = &gn_BGP_IPV4M_NODE_323_next,
		.data = &ctkn_BGP_IPV4M_NODE[323],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_324_prev,
		.to = &gn_BGP_IPV4M_NODE_324_next,
		.data = &ctkn_BGP_IPV4M_NODE[324],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_325_prev,
		.to = &gn_BGP_IPV4M_NODE_325_next,
		.data = (void *)&no_bgp_distance_source_access_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_326_prev,
		.to = &gn_BGP_IPV4M_NODE_326_next,
		.data = &ctkn_BGP_IPV4M_NODE[326],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_327_prev,
		.to = &gn_BGP_IPV4M_NODE_327_next,
		.data = &ctkn_BGP_IPV4M_NODE[327],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_328_prev,
		.to = &gn_BGP_IPV4M_NODE_328_next,
		.data = &ctkn_BGP_IPV4M_NODE[328],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_329_prev,
		.to = &gn_BGP_IPV4M_NODE_329_next,
		.data = &ctkn_BGP_IPV4M_NODE[329],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_330_prev,
		.to = &gn_BGP_IPV4M_NODE_330_next,
		.data = &ctkn_BGP_IPV4M_NODE[330],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_331_prev,
		.to = &gn_BGP_IPV4M_NODE_331_next,
		.data = &ctkn_BGP_IPV4M_NODE[331],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_332_prev,
		.to = &gn_BGP_IPV4M_NODE_332_next,
		.data = &ctkn_BGP_IPV4M_NODE[332],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_333_prev,
		.to = &gn_BGP_IPV4M_NODE_333_next,
		.data = (void *)&no_bgp_distance_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_334_prev,
		.to = &gn_BGP_IPV4M_NODE_334_next,
		.data = &ctkn_BGP_IPV4M_NODE[334],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_335_prev,
		.to = &gn_BGP_IPV4M_NODE_335_next,
		.data = &ctkn_BGP_IPV4M_NODE[335],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_336_prev,
		.to = &gn_BGP_IPV4M_NODE_336_next,
		.data = &ctkn_BGP_IPV4M_NODE[336],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_337_prev,
		.to = &gn_BGP_IPV4M_NODE_337_next,
		.data = &ctkn_BGP_IPV4M_NODE[337],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_338_prev,
		.to = &gn_BGP_IPV4M_NODE_338_next,
		.data = &ctkn_BGP_IPV4M_NODE[338],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_339_prev,
		.to = &gn_BGP_IPV4M_NODE_339_next,
		.data = &ctkn_BGP_IPV4M_NODE[339],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_340_prev,
		.to = &gn_BGP_IPV4M_NODE_340_next,
		.data = (void *)&no_neighbor_activate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_341_prev,
		.to = &gn_BGP_IPV4M_NODE_341_next,
		.data = &ctkn_BGP_IPV4M_NODE[341],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_342_prev,
		.to = &gn_BGP_IPV4M_NODE_342_next,
		.data = &ctkn_BGP_IPV4M_NODE[342],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_343_prev,
		.to = &gn_BGP_IPV4M_NODE_343_next,
		.data = &ctkn_BGP_IPV4M_NODE[343],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_344_prev,
		.to = &gn_BGP_IPV4M_NODE_344_next,
		.data = &ctkn_BGP_IPV4M_NODE[344],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_345_prev,
		.to = &gn_BGP_IPV4M_NODE_345_next,
		.data = &ctkn_BGP_IPV4M_NODE[345],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_346_prev,
		.to = &gn_BGP_IPV4M_NODE_346_next,
		.data = &ctkn_BGP_IPV4M_NODE[346],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_347_prev,
		.to = &gn_BGP_IPV4M_NODE_347_next,
		.data = &ctkn_BGP_IPV4M_NODE[347],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_348_prev,
		.to = &gn_BGP_IPV4M_NODE_348_next,
		.data = (void *)&no_neighbor_addpath_paths_limit_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_349_prev,
		.to = &gn_BGP_IPV4M_NODE_349_next,
		.data = &ctkn_BGP_IPV4M_NODE[349],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_350_prev,
		.to = &gn_BGP_IPV4M_NODE_350_next,
		.data = &ctkn_BGP_IPV4M_NODE[350],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_351_prev,
		.to = &gn_BGP_IPV4M_NODE_351_next,
		.data = (void *)&no_neighbor_addpath_tx_all_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_352_prev,
		.to = &gn_BGP_IPV4M_NODE_352_next,
		.data = &ctkn_BGP_IPV4M_NODE[352],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_353_prev,
		.to = &gn_BGP_IPV4M_NODE_353_next,
		.data = &ctkn_BGP_IPV4M_NODE[353],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_354_prev,
		.to = &gn_BGP_IPV4M_NODE_354_next,
		.data = &ctkn_BGP_IPV4M_NODE[354],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_355_prev,
		.to = &gn_BGP_IPV4M_NODE_355_next,
		.data = &ctkn_BGP_IPV4M_NODE[355],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_356_prev,
		.to = &gn_BGP_IPV4M_NODE_356_next,
		.data = &ctkn_BGP_IPV4M_NODE[356],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_357_prev,
		.to = &gn_BGP_IPV4M_NODE_357_next,
		.data = (void *)&no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_358_prev,
		.to = &gn_BGP_IPV4M_NODE_358_next,
		.data = &ctkn_BGP_IPV4M_NODE[358],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_359_prev,
		.to = &gn_BGP_IPV4M_NODE_359_next,
		.data = &ctkn_BGP_IPV4M_NODE[359],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_360_prev,
		.to = &gn_BGP_IPV4M_NODE_360_next,
		.data = (void *)&no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_361_prev,
		.to = &gn_BGP_IPV4M_NODE_361_next,
		.data = &ctkn_BGP_IPV4M_NODE[361],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_362_prev,
		.to = &gn_BGP_IPV4M_NODE_362_next,
		.data = &ctkn_BGP_IPV4M_NODE[362],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_363_prev,
		.to = &gn_BGP_IPV4M_NODE_363_next,
		.data = &ctkn_BGP_IPV4M_NODE[363],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_364_prev,
		.to = &gn_BGP_IPV4M_NODE_364_next,
		.data = &ctkn_BGP_IPV4M_NODE[364],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_365_prev,
		.to = &gn_BGP_IPV4M_NODE_365_next,
		.data = &ctkn_BGP_IPV4M_NODE[365],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_366_prev,
		.to = &gn_BGP_IPV4M_NODE_366_next,
		.data = &ctkn_BGP_IPV4M_NODE[366],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_367_prev,
		.to = &gn_BGP_IPV4M_NODE_367_next,
		.data = &ctkn_BGP_IPV4M_NODE[367],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_368_prev,
		.to = &gn_BGP_IPV4M_NODE_368_next,
		.data = (void *)&no_neighbor_allowas_in_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_369_prev,
		.to = &gn_BGP_IPV4M_NODE_369_next,
		.data = &ctkn_BGP_IPV4M_NODE[369],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_370_prev,
		.to = &gn_BGP_IPV4M_NODE_370_next,
		.data = &ctkn_BGP_IPV4M_NODE[370],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_371_prev,
		.to = &gn_BGP_IPV4M_NODE_371_next,
		.data = &ctkn_BGP_IPV4M_NODE[371],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_372_prev,
		.to = &gn_BGP_IPV4M_NODE_372_next,
		.data = (void *)&no_neighbor_as_override_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_373_prev,
		.to = &gn_BGP_IPV4M_NODE_373_next,
		.data = &ctkn_BGP_IPV4M_NODE[373],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_374_prev,
		.to = &gn_BGP_IPV4M_NODE_374_next,
		.data = &ctkn_BGP_IPV4M_NODE[374],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_375_prev,
		.to = &gn_BGP_IPV4M_NODE_375_next,
		.data = &ctkn_BGP_IPV4M_NODE[375],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_376_prev,
		.to = &gn_BGP_IPV4M_NODE_376_next,
		.data = &ctkn_BGP_IPV4M_NODE[376],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_377_prev,
		.to = &gn_BGP_IPV4M_NODE_377_next,
		.data = &ctkn_BGP_IPV4M_NODE[377],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_378_prev,
		.to = &gn_BGP_IPV4M_NODE_378_next,
		.data = &ctkn_BGP_IPV4M_NODE[378],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_379_prev,
		.to = &gn_BGP_IPV4M_NODE_379_next,
		.data = &ctkn_BGP_IPV4M_NODE[379],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_380_prev,
		.to = &gn_BGP_IPV4M_NODE_380_next,
		.data = (void *)&no_neighbor_attr_unchanged_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_381_prev,
		.to = &gn_BGP_IPV4M_NODE_381_next,
		.data = &ctkn_BGP_IPV4M_NODE[381],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_382_prev,
		.to = &gn_BGP_IPV4M_NODE_382_next,
		.data = &ctkn_BGP_IPV4M_NODE[382],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_383_prev,
		.to = &gn_BGP_IPV4M_NODE_383_next,
		.data = &ctkn_BGP_IPV4M_NODE[383],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_384_prev,
		.to = &gn_BGP_IPV4M_NODE_384_next,
		.data = &ctkn_BGP_IPV4M_NODE[384],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_385_prev,
		.to = &gn_BGP_IPV4M_NODE_385_next,
		.data = &ctkn_BGP_IPV4M_NODE[385],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_386_prev,
		.to = &gn_BGP_IPV4M_NODE_386_next,
		.data = &ctkn_BGP_IPV4M_NODE[386],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_387_prev,
		.to = &gn_BGP_IPV4M_NODE_387_next,
		.data = &ctkn_BGP_IPV4M_NODE[387],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_388_prev,
		.to = &gn_BGP_IPV4M_NODE_388_next,
		.data = &ctkn_BGP_IPV4M_NODE[388],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_389_prev,
		.to = &gn_BGP_IPV4M_NODE_389_next,
		.data = &ctkn_BGP_IPV4M_NODE[389],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_390_prev,
		.to = &gn_BGP_IPV4M_NODE_390_next,
		.data = (void *)&no_neighbor_capability_orf_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_391_prev,
		.to = &gn_BGP_IPV4M_NODE_391_next,
		.data = &ctkn_BGP_IPV4M_NODE[391],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_392_prev,
		.to = &gn_BGP_IPV4M_NODE_392_next,
		.data = &ctkn_BGP_IPV4M_NODE[392],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_393_prev,
		.to = &gn_BGP_IPV4M_NODE_393_next,
		.data = &ctkn_BGP_IPV4M_NODE[393],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_394_prev,
		.to = &gn_BGP_IPV4M_NODE_394_next,
		.data = &ctkn_BGP_IPV4M_NODE[394],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_395_prev,
		.to = &gn_BGP_IPV4M_NODE_395_next,
		.data = &ctkn_BGP_IPV4M_NODE[395],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_396_prev,
		.to = &gn_BGP_IPV4M_NODE_396_next,
		.data = &ctkn_BGP_IPV4M_NODE[396],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_397_prev,
		.to = &gn_BGP_IPV4M_NODE_397_next,
		.data = &ctkn_BGP_IPV4M_NODE[397],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_398_prev,
		.to = &gn_BGP_IPV4M_NODE_398_next,
		.data = &ctkn_BGP_IPV4M_NODE[398],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_399_prev,
		.to = &gn_BGP_IPV4M_NODE_399_next,
		.data = &ctkn_BGP_IPV4M_NODE[399],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_400_prev,
		.to = &gn_BGP_IPV4M_NODE_400_next,
		.data = &ctkn_BGP_IPV4M_NODE[400],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_401_prev,
		.to = &gn_BGP_IPV4M_NODE_401_next,
		.data = &ctkn_BGP_IPV4M_NODE[401],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_402_prev,
		.to = &gn_BGP_IPV4M_NODE_402_next,
		.data = &ctkn_BGP_IPV4M_NODE[402],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_403_prev,
		.to = &gn_BGP_IPV4M_NODE_403_next,
		.data = (void *)&no_neighbor_damp_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_404_prev,
		.to = &gn_BGP_IPV4M_NODE_404_next,
		.data = &ctkn_BGP_IPV4M_NODE[404],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_405_prev,
		.to = &gn_BGP_IPV4M_NODE_405_next,
		.data = &ctkn_BGP_IPV4M_NODE[405],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_406_prev,
		.to = &gn_BGP_IPV4M_NODE_406_next,
		.data = &ctkn_BGP_IPV4M_NODE[406],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_407_prev,
		.to = &gn_BGP_IPV4M_NODE_407_next,
		.data = &ctkn_BGP_IPV4M_NODE[407],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_408_prev,
		.to = &gn_BGP_IPV4M_NODE_408_next,
		.data = &ctkn_BGP_IPV4M_NODE[408],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_409_prev,
		.to = &gn_BGP_IPV4M_NODE_409_next,
		.data = &ctkn_BGP_IPV4M_NODE[409],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_410_prev,
		.to = &gn_BGP_IPV4M_NODE_410_next,
		.data = (void *)&no_neighbor_default_originate_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_411_prev,
		.to = &gn_BGP_IPV4M_NODE_411_next,
		.data = &ctkn_BGP_IPV4M_NODE[411],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_412_prev,
		.to = &gn_BGP_IPV4M_NODE_412_next,
		.data = &ctkn_BGP_IPV4M_NODE[412],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_413_prev,
		.to = &gn_BGP_IPV4M_NODE_413_next,
		.data = (void *)&no_neighbor_disable_addpath_rx_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_414_prev,
		.to = &gn_BGP_IPV4M_NODE_414_next,
		.data = &ctkn_BGP_IPV4M_NODE[414],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_415_prev,
		.to = &gn_BGP_IPV4M_NODE_415_next,
		.data = &ctkn_BGP_IPV4M_NODE[415],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_416_prev,
		.to = &gn_BGP_IPV4M_NODE_416_next,
		.data = &ctkn_BGP_IPV4M_NODE[416],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_417_prev,
		.to = &gn_BGP_IPV4M_NODE_417_next,
		.data = &ctkn_BGP_IPV4M_NODE[417],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_418_prev,
		.to = &gn_BGP_IPV4M_NODE_418_next,
		.data = &ctkn_BGP_IPV4M_NODE[418],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_419_prev,
		.to = &gn_BGP_IPV4M_NODE_419_next,
		.data = &ctkn_BGP_IPV4M_NODE[419],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_420_prev,
		.to = &gn_BGP_IPV4M_NODE_420_next,
		.data = (void *)&no_neighbor_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_421_prev,
		.to = &gn_BGP_IPV4M_NODE_421_next,
		.data = &ctkn_BGP_IPV4M_NODE[421],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_422_prev,
		.to = &gn_BGP_IPV4M_NODE_422_next,
		.data = &ctkn_BGP_IPV4M_NODE[422],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_423_prev,
		.to = &gn_BGP_IPV4M_NODE_423_next,
		.data = &ctkn_BGP_IPV4M_NODE[423],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_424_prev,
		.to = &gn_BGP_IPV4M_NODE_424_next,
		.data = &ctkn_BGP_IPV4M_NODE[424],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_425_prev,
		.to = &gn_BGP_IPV4M_NODE_425_next,
		.data = &ctkn_BGP_IPV4M_NODE[425],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_426_prev,
		.to = &gn_BGP_IPV4M_NODE_426_next,
		.data = &ctkn_BGP_IPV4M_NODE[426],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_427_prev,
		.to = &gn_BGP_IPV4M_NODE_427_next,
		.data = &ctkn_BGP_IPV4M_NODE[427],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_428_prev,
		.to = &gn_BGP_IPV4M_NODE_428_next,
		.data = (void *)&no_neighbor_filter_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_429_prev,
		.to = &gn_BGP_IPV4M_NODE_429_next,
		.data = &ctkn_BGP_IPV4M_NODE[429],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_430_prev,
		.to = &gn_BGP_IPV4M_NODE_430_next,
		.data = &ctkn_BGP_IPV4M_NODE[430],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_431_prev,
		.to = &gn_BGP_IPV4M_NODE_431_next,
		.data = &ctkn_BGP_IPV4M_NODE[431],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_432_prev,
		.to = &gn_BGP_IPV4M_NODE_432_next,
		.data = &ctkn_BGP_IPV4M_NODE[432],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_433_prev,
		.to = &gn_BGP_IPV4M_NODE_433_next,
		.data = &ctkn_BGP_IPV4M_NODE[433],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_434_prev,
		.to = &gn_BGP_IPV4M_NODE_434_next,
		.data = &ctkn_BGP_IPV4M_NODE[434],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_435_prev,
		.to = &gn_BGP_IPV4M_NODE_435_next,
		.data = &ctkn_BGP_IPV4M_NODE[435],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_436_prev,
		.to = &gn_BGP_IPV4M_NODE_436_next,
		.data = &ctkn_BGP_IPV4M_NODE[436],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_437_prev,
		.to = &gn_BGP_IPV4M_NODE_437_next,
		.data = &ctkn_BGP_IPV4M_NODE[437],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_438_prev,
		.to = &gn_BGP_IPV4M_NODE_438_next,
		.data = &ctkn_BGP_IPV4M_NODE[438],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_439_prev,
		.to = &gn_BGP_IPV4M_NODE_439_next,
		.data = &ctkn_BGP_IPV4M_NODE[439],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_440_prev,
		.to = &gn_BGP_IPV4M_NODE_440_next,
		.data = &ctkn_BGP_IPV4M_NODE[440],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_441_prev,
		.to = &gn_BGP_IPV4M_NODE_441_next,
		.data = &ctkn_BGP_IPV4M_NODE[441],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_442_prev,
		.to = &gn_BGP_IPV4M_NODE_442_next,
		.data = &ctkn_BGP_IPV4M_NODE[442],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_443_prev,
		.to = &gn_BGP_IPV4M_NODE_443_next,
		.data = &ctkn_BGP_IPV4M_NODE[443],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_444_prev,
		.to = &gn_BGP_IPV4M_NODE_444_next,
		.data = &ctkn_BGP_IPV4M_NODE[444],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_445_prev,
		.to = &gn_BGP_IPV4M_NODE_445_next,
		.data = &ctkn_BGP_IPV4M_NODE[445],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_446_prev,
		.to = &gn_BGP_IPV4M_NODE_446_next,
		.data = &ctkn_BGP_IPV4M_NODE[446],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_447_prev,
		.to = &gn_BGP_IPV4M_NODE_447_next,
		.data = &ctkn_BGP_IPV4M_NODE[447],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_448_prev,
		.to = &gn_BGP_IPV4M_NODE_448_next,
		.data = (void *)&no_neighbor_maximum_prefix_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_449_prev,
		.to = &gn_BGP_IPV4M_NODE_449_next,
		.data = &ctkn_BGP_IPV4M_NODE[449],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_450_prev,
		.to = &gn_BGP_IPV4M_NODE_450_next,
		.data = &ctkn_BGP_IPV4M_NODE[450],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_451_prev,
		.to = &gn_BGP_IPV4M_NODE_451_next,
		.data = &ctkn_BGP_IPV4M_NODE[451],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_452_prev,
		.to = &gn_BGP_IPV4M_NODE_452_next,
		.data = &ctkn_BGP_IPV4M_NODE[452],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_453_prev,
		.to = &gn_BGP_IPV4M_NODE_453_next,
		.data = &ctkn_BGP_IPV4M_NODE[453],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_454_prev,
		.to = &gn_BGP_IPV4M_NODE_454_next,
		.data = (void *)&no_neighbor_maximum_prefix_out_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_455_prev,
		.to = &gn_BGP_IPV4M_NODE_455_next,
		.data = &ctkn_BGP_IPV4M_NODE[455],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_456_prev,
		.to = &gn_BGP_IPV4M_NODE_456_next,
		.data = &ctkn_BGP_IPV4M_NODE[456],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_457_prev,
		.to = &gn_BGP_IPV4M_NODE_457_next,
		.data = (void *)&no_neighbor_nexthop_self_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_458_prev,
		.to = &gn_BGP_IPV4M_NODE_458_next,
		.data = &ctkn_BGP_IPV4M_NODE[458],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_459_prev,
		.to = &gn_BGP_IPV4M_NODE_459_next,
		.data = &ctkn_BGP_IPV4M_NODE[459],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_460_prev,
		.to = &gn_BGP_IPV4M_NODE_460_next,
		.data = (void *)&no_neighbor_nexthop_self_all_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_461_prev,
		.to = &gn_BGP_IPV4M_NODE_461_next,
		.data = &ctkn_BGP_IPV4M_NODE[461],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_462_prev,
		.to = &gn_BGP_IPV4M_NODE_462_next,
		.data = &ctkn_BGP_IPV4M_NODE[462],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_463_prev,
		.to = &gn_BGP_IPV4M_NODE_463_next,
		.data = (void *)&no_neighbor_nexthop_self_force_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_464_prev,
		.to = &gn_BGP_IPV4M_NODE_464_next,
		.data = &ctkn_BGP_IPV4M_NODE[464],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_465_prev,
		.to = &gn_BGP_IPV4M_NODE_465_next,
		.data = &ctkn_BGP_IPV4M_NODE[465],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_466_prev,
		.to = &gn_BGP_IPV4M_NODE_466_next,
		.data = &ctkn_BGP_IPV4M_NODE[466],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_467_prev,
		.to = &gn_BGP_IPV4M_NODE_467_next,
		.data = (void *)&no_neighbor_set_peer_group_hidden_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_468_prev,
		.to = &gn_BGP_IPV4M_NODE_468_next,
		.data = &ctkn_BGP_IPV4M_NODE[468],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_469_prev,
		.to = &gn_BGP_IPV4M_NODE_469_next,
		.data = &ctkn_BGP_IPV4M_NODE[469],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_470_prev,
		.to = &gn_BGP_IPV4M_NODE_470_next,
		.data = &ctkn_BGP_IPV4M_NODE[470],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_471_prev,
		.to = &gn_BGP_IPV4M_NODE_471_next,
		.data = &ctkn_BGP_IPV4M_NODE[471],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_472_prev,
		.to = &gn_BGP_IPV4M_NODE_472_next,
		.data = &ctkn_BGP_IPV4M_NODE[472],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_473_prev,
		.to = &gn_BGP_IPV4M_NODE_473_next,
		.data = &ctkn_BGP_IPV4M_NODE[473],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_474_prev,
		.to = &gn_BGP_IPV4M_NODE_474_next,
		.data = (void *)&no_neighbor_prefix_list_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_475_prev,
		.to = &gn_BGP_IPV4M_NODE_475_next,
		.data = &ctkn_BGP_IPV4M_NODE[475],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_476_prev,
		.to = &gn_BGP_IPV4M_NODE_476_next,
		.data = &ctkn_BGP_IPV4M_NODE[476],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_477_prev,
		.to = &gn_BGP_IPV4M_NODE_477_next,
		.data = &ctkn_BGP_IPV4M_NODE[477],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_478_prev,
		.to = &gn_BGP_IPV4M_NODE_478_next,
		.data = (void *)&no_neighbor_remove_private_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_479_prev,
		.to = &gn_BGP_IPV4M_NODE_479_next,
		.data = &ctkn_BGP_IPV4M_NODE[479],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_480_prev,
		.to = &gn_BGP_IPV4M_NODE_480_next,
		.data = &ctkn_BGP_IPV4M_NODE[480],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_481_prev,
		.to = &gn_BGP_IPV4M_NODE_481_next,
		.data = (void *)&no_neighbor_remove_private_as_all_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_482_prev,
		.to = &gn_BGP_IPV4M_NODE_482_next,
		.data = &ctkn_BGP_IPV4M_NODE[482],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_483_prev,
		.to = &gn_BGP_IPV4M_NODE_483_next,
		.data = &ctkn_BGP_IPV4M_NODE[483],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_484_prev,
		.to = &gn_BGP_IPV4M_NODE_484_next,
		.data = (void *)&no_neighbor_remove_private_as_all_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_485_prev,
		.to = &gn_BGP_IPV4M_NODE_485_next,
		.data = &ctkn_BGP_IPV4M_NODE[485],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_486_prev,
		.to = &gn_BGP_IPV4M_NODE_486_next,
		.data = &ctkn_BGP_IPV4M_NODE[486],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_487_prev,
		.to = &gn_BGP_IPV4M_NODE_487_next,
		.data = (void *)&no_neighbor_remove_private_as_replace_as_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_488_prev,
		.to = &gn_BGP_IPV4M_NODE_488_next,
		.data = &ctkn_BGP_IPV4M_NODE[488],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_489_prev,
		.to = &gn_BGP_IPV4M_NODE_489_next,
		.data = &ctkn_BGP_IPV4M_NODE[489],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_490_prev,
		.to = &gn_BGP_IPV4M_NODE_490_next,
		.data = &ctkn_BGP_IPV4M_NODE[490],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_491_prev,
		.to = &gn_BGP_IPV4M_NODE_491_next,
		.data = &ctkn_BGP_IPV4M_NODE[491],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_492_prev,
		.to = &gn_BGP_IPV4M_NODE_492_next,
		.data = &ctkn_BGP_IPV4M_NODE[492],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_493_prev,
		.to = &gn_BGP_IPV4M_NODE_493_next,
		.data = &ctkn_BGP_IPV4M_NODE[493],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_494_prev,
		.to = &gn_BGP_IPV4M_NODE_494_next,
		.data = (void *)&no_neighbor_route_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_495_prev,
		.to = &gn_BGP_IPV4M_NODE_495_next,
		.data = &ctkn_BGP_IPV4M_NODE[495],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_496_prev,
		.to = &gn_BGP_IPV4M_NODE_496_next,
		.data = &ctkn_BGP_IPV4M_NODE[496],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_497_prev,
		.to = &gn_BGP_IPV4M_NODE_497_next,
		.data = &ctkn_BGP_IPV4M_NODE[497],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_498_prev,
		.to = &gn_BGP_IPV4M_NODE_498_next,
		.data = (void *)&no_neighbor_route_reflector_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_499_prev,
		.to = &gn_BGP_IPV4M_NODE_499_next,
		.data = &ctkn_BGP_IPV4M_NODE[499],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_500_prev,
		.to = &gn_BGP_IPV4M_NODE_500_next,
		.data = &ctkn_BGP_IPV4M_NODE[500],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_501_prev,
		.to = &gn_BGP_IPV4M_NODE_501_next,
		.data = (void *)&no_neighbor_route_server_client_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_502_prev,
		.to = &gn_BGP_IPV4M_NODE_502_next,
		.data = &ctkn_BGP_IPV4M_NODE[502],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_503_prev,
		.to = &gn_BGP_IPV4M_NODE_503_next,
		.data = &ctkn_BGP_IPV4M_NODE[503],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_504_prev,
		.to = &gn_BGP_IPV4M_NODE_504_next,
		.data = (void *)&no_neighbor_send_community_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_505_prev,
		.to = &gn_BGP_IPV4M_NODE_505_next,
		.data = &ctkn_BGP_IPV4M_NODE[505],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_506_prev,
		.to = &gn_BGP_IPV4M_NODE_506_next,
		.data = &ctkn_BGP_IPV4M_NODE[506],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_507_prev,
		.to = &gn_BGP_IPV4M_NODE_507_next,
		.data = &ctkn_BGP_IPV4M_NODE[507],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_508_prev,
		.to = &gn_BGP_IPV4M_NODE_508_next,
		.data = &ctkn_BGP_IPV4M_NODE[508],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_509_prev,
		.to = &gn_BGP_IPV4M_NODE_509_next,
		.data = (void *)&no_neighbor_send_community_type_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_510_prev,
		.to = &gn_BGP_IPV4M_NODE_510_next,
		.data = &ctkn_BGP_IPV4M_NODE[510],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_511_prev,
		.to = &gn_BGP_IPV4M_NODE_511_next,
		.data = &ctkn_BGP_IPV4M_NODE[511],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_512_prev,
		.to = &gn_BGP_IPV4M_NODE_512_next,
		.data = &ctkn_BGP_IPV4M_NODE[512],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_513_prev,
		.to = &gn_BGP_IPV4M_NODE_513_next,
		.data = &ctkn_BGP_IPV4M_NODE[513],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_514_prev,
		.to = &gn_BGP_IPV4M_NODE_514_next,
		.data = &ctkn_BGP_IPV4M_NODE[514],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_515_prev,
		.to = &gn_BGP_IPV4M_NODE_515_next,
		.data = &ctkn_BGP_IPV4M_NODE[515],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_516_prev,
		.to = &gn_BGP_IPV4M_NODE_516_next,
		.data = &ctkn_BGP_IPV4M_NODE[516],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_517_prev,
		.to = &gn_BGP_IPV4M_NODE_517_next,
		.data = (void *)&no_neighbor_soft_reconfiguration_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_518_prev,
		.to = &gn_BGP_IPV4M_NODE_518_next,
		.data = &ctkn_BGP_IPV4M_NODE[518],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_519_prev,
		.to = &gn_BGP_IPV4M_NODE_519_next,
		.data = &ctkn_BGP_IPV4M_NODE[519],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_520_prev,
		.to = &gn_BGP_IPV4M_NODE_520_next,
		.data = &ctkn_BGP_IPV4M_NODE[520],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_521_prev,
		.to = &gn_BGP_IPV4M_NODE_521_next,
		.data = &ctkn_BGP_IPV4M_NODE[521],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_522_prev,
		.to = &gn_BGP_IPV4M_NODE_522_next,
		.data = &ctkn_BGP_IPV4M_NODE[522],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_523_prev,
		.to = &gn_BGP_IPV4M_NODE_523_next,
		.data = (void *)&no_neighbor_soo_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_524_prev,
		.to = &gn_BGP_IPV4M_NODE_524_next,
		.data = &ctkn_BGP_IPV4M_NODE[524],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_525_prev,
		.to = &gn_BGP_IPV4M_NODE_525_next,
		.data = &ctkn_BGP_IPV4M_NODE[525],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_526_prev,
		.to = &gn_BGP_IPV4M_NODE_526_next,
		.data = &ctkn_BGP_IPV4M_NODE[526],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_527_prev,
		.to = &gn_BGP_IPV4M_NODE_527_next,
		.data = (void *)&no_neighbor_unsuppress_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_528_prev,
		.to = &gn_BGP_IPV4M_NODE_528_next,
		.data = &ctkn_BGP_IPV4M_NODE[528],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_529_prev,
		.to = &gn_BGP_IPV4M_NODE_529_next,
		.data = &ctkn_BGP_IPV4M_NODE[529],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_530_prev,
		.to = &gn_BGP_IPV4M_NODE_530_next,
		.data = &ctkn_BGP_IPV4M_NODE[530],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_531_prev,
		.to = &gn_BGP_IPV4M_NODE_531_next,
		.data = &ctkn_BGP_IPV4M_NODE[531],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_532_prev,
		.to = &gn_BGP_IPV4M_NODE_532_next,
		.data = &ctkn_BGP_IPV4M_NODE[532],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_533_prev,
		.to = &gn_BGP_IPV4M_NODE_533_next,
		.data = (void *)&no_neighbor_weight_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_534_prev,
		.to = &gn_BGP_IPV4M_NODE_534_next,
		.data = &ctkn_BGP_IPV4M_NODE[534],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_535_prev,
		.to = &gn_BGP_IPV4M_NODE_535_next,
		.data = &ctkn_BGP_IPV4M_NODE[535],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_536_prev,
		.to = &gn_BGP_IPV4M_NODE_536_next,
		.data = &ctkn_BGP_IPV4M_NODE[536],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_537_prev,
		.to = &gn_BGP_IPV4M_NODE_537_next,
		.data = (void *)&no_bgp_table_map_cmd_vtysh,
	},
	{
		.from = &gn_BGP_IPV4M_NODE_538_prev,
		.to = &gn_BGP_IPV4M_NODE_538_next,
		.data = &ctkn_BGP_IPV4M_NODE[538],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_539_prev,
		.to = &gn_BGP_IPV4M_NODE_539_next,
		.data = &ctkn_BGP_IPV4M_NODE[539],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_540_prev,
		.to = &gn_BGP_IPV4M_NODE_540_next,
		.data = &ctkn_BGP_IPV4M_NODE[540],
	},
	{
		.from = &gn_BGP_IPV4M_NODE_541_prev,
		.to = &gn_BGP_IPV4M_NODE_541_next,
		.data = (void *)&bgp_table_map_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_BGP_IPV4M_NODE, 542, &gn_BGP_IPV4M_NODE[0], &gn_BGP_IPV4M_NODE[1], &gn_BGP_IPV4M_NODE[2], &gn_BGP_IPV4M_NODE[3], &gn_BGP_IPV4M_NODE[4], &gn_BGP_IPV4M_NODE[5], &gn_BGP_IPV4M_NODE[6], &gn_BGP_IPV4M_NODE[7], &gn_BGP_IPV4M_NODE[8], &gn_BGP_IPV4M_NODE[9], &gn_BGP_IPV4M_NODE[10], &gn_BGP_IPV4M_NODE[11], &gn_BGP_IPV4M_NODE[12], &gn_BGP_IPV4M_NODE[13], &gn_BGP_IPV4M_NODE[14], &gn_BGP_IPV4M_NODE[15], &gn_BGP_IPV4M_NODE[16], &gn_BGP_IPV4M_NODE[17], &gn_BGP_IPV4M_NODE[18], &gn_BGP_IPV4M_NODE[19], &gn_BGP_IPV4M_NODE[20], &gn_BGP_IPV4M_NODE[21], &gn_BGP_IPV4M_NODE[22], &gn_BGP_IPV4M_NODE[23], &gn_BGP_IPV4M_NODE[24], &gn_BGP_IPV4M_NODE[25], &gn_BGP_IPV4M_NODE[26], &gn_BGP_IPV4M_NODE[27], &gn_BGP_IPV4M_NODE[28], &gn_BGP_IPV4M_NODE[29], &gn_BGP_IPV4M_NODE[30], &gn_BGP_IPV4M_NODE[31], &gn_BGP_IPV4M_NODE[32], &gn_BGP_IPV4M_NODE[33], &gn_BGP_IPV4M_NODE[34], &gn_BGP_IPV4M_NODE[35], &gn_BGP_IPV4M_NODE[36], &gn_BGP_IPV4M_NODE[37], &gn_BGP_IPV4M_NODE[38], &gn_BGP_IPV4M_NODE[39], &gn_BGP_IPV4M_NODE[40], &gn_BGP_IPV4M_NODE[41], &gn_BGP_IPV4M_NODE[42], &gn_BGP_IPV4M_NODE[43], &gn_BGP_IPV4M_NODE[44], &gn_BGP_IPV4M_NODE[45], &gn_BGP_IPV4M_NODE[46], &gn_BGP_IPV4M_NODE[47], &gn_BGP_IPV4M_NODE[48], &gn_BGP_IPV4M_NODE[49], &gn_BGP_IPV4M_NODE[50], &gn_BGP_IPV4M_NODE[51], &gn_BGP_IPV4M_NODE[52], &gn_BGP_IPV4M_NODE[53], &gn_BGP_IPV4M_NODE[54], &gn_BGP_IPV4M_NODE[55], &gn_BGP_IPV4M_NODE[56], &gn_BGP_IPV4M_NODE[57], &gn_BGP_IPV4M_NODE[58], &gn_BGP_IPV4M_NODE[59], &gn_BGP_IPV4M_NODE[60], &gn_BGP_IPV4M_NODE[61], &gn_BGP_IPV4M_NODE[62], &gn_BGP_IPV4M_NODE[63], &gn_BGP_IPV4M_NODE[64], &gn_BGP_IPV4M_NODE[65], &gn_BGP_IPV4M_NODE[66], &gn_BGP_IPV4M_NODE[67], &gn_BGP_IPV4M_NODE[68], &gn_BGP_IPV4M_NODE[69], &gn_BGP_IPV4M_NODE[70], &gn_BGP_IPV4M_NODE[71], &gn_BGP_IPV4M_NODE[72], &gn_BGP_IPV4M_NODE[73], &gn_BGP_IPV4M_NODE[74], &gn_BGP_IPV4M_NODE[75], &gn_BGP_IPV4M_NODE[76], &gn_BGP_IPV4M_NODE[77], &gn_BGP_IPV4M_NODE[78], &gn_BGP_IPV4M_NODE[79], &gn_BGP_IPV4M_NODE[80], &gn_BGP_IPV4M_NODE[81], &gn_BGP_IPV4M_NODE[82], &gn_BGP_IPV4M_NODE[83], &gn_BGP_IPV4M_NODE[84], &gn_BGP_IPV4M_NODE[85], &gn_BGP_IPV4M_NODE[86], &gn_BGP_IPV4M_NODE[87], &gn_BGP_IPV4M_NODE[88], &gn_BGP_IPV4M_NODE[89], &gn_BGP_IPV4M_NODE[90], &gn_BGP_IPV4M_NODE[91], &gn_BGP_IPV4M_NODE[92], &gn_BGP_IPV4M_NODE[93], &gn_BGP_IPV4M_NODE[94], &gn_BGP_IPV4M_NODE[95], &gn_BGP_IPV4M_NODE[96], &gn_BGP_IPV4M_NODE[97], &gn_BGP_IPV4M_NODE[98], &gn_BGP_IPV4M_NODE[99], &gn_BGP_IPV4M_NODE[100], &gn_BGP_IPV4M_NODE[101], &gn_BGP_IPV4M_NODE[102], &gn_BGP_IPV4M_NODE[103], &gn_BGP_IPV4M_NODE[104], &gn_BGP_IPV4M_NODE[105], &gn_BGP_IPV4M_NODE[106], &gn_BGP_IPV4M_NODE[107], &gn_BGP_IPV4M_NODE[108], &gn_BGP_IPV4M_NODE[109], &gn_BGP_IPV4M_NODE[110], &gn_BGP_IPV4M_NODE[111], &gn_BGP_IPV4M_NODE[112], &gn_BGP_IPV4M_NODE[113], &gn_BGP_IPV4M_NODE[114], &gn_BGP_IPV4M_NODE[115], &gn_BGP_IPV4M_NODE[116], &gn_BGP_IPV4M_NODE[117], &gn_BGP_IPV4M_NODE[118], &gn_BGP_IPV4M_NODE[119], &gn_BGP_IPV4M_NODE[120], &gn_BGP_IPV4M_NODE[121], &gn_BGP_IPV4M_NODE[122], &gn_BGP_IPV4M_NODE[123], &gn_BGP_IPV4M_NODE[124], &gn_BGP_IPV4M_NODE[125], &gn_BGP_IPV4M_NODE[126], &gn_BGP_IPV4M_NODE[127], &gn_BGP_IPV4M_NODE[128], &gn_BGP_IPV4M_NODE[129], &gn_BGP_IPV4M_NODE[130], &gn_BGP_IPV4M_NODE[131], &gn_BGP_IPV4M_NODE[132], &gn_BGP_IPV4M_NODE[133], &gn_BGP_IPV4M_NODE[134], &gn_BGP_IPV4M_NODE[135], &gn_BGP_IPV4M_NODE[136], &gn_BGP_IPV4M_NODE[137], &gn_BGP_IPV4M_NODE[138], &gn_BGP_IPV4M_NODE[139], &gn_BGP_IPV4M_NODE[140], &gn_BGP_IPV4M_NODE[141], &gn_BGP_IPV4M_NODE[142], &gn_BGP_IPV4M_NODE[143], &gn_BGP_IPV4M_NODE[144], &gn_BGP_IPV4M_NODE[145], &gn_BGP_IPV4M_NODE[146], &gn_BGP_IPV4M_NODE[147], &gn_BGP_IPV4M_NODE[148], &gn_BGP_IPV4M_NODE[149], &gn_BGP_IPV4M_NODE[150], &gn_BGP_IPV4M_NODE[151], &gn_BGP_IPV4M_NODE[152], &gn_BGP_IPV4M_NODE[153], &gn_BGP_IPV4M_NODE[154], &gn_BGP_IPV4M_NODE[155], &gn_BGP_IPV4M_NODE[156], &gn_BGP_IPV4M_NODE[157], &gn_BGP_IPV4M_NODE[158], &gn_BGP_IPV4M_NODE[159], &gn_BGP_IPV4M_NODE[160], &gn_BGP_IPV4M_NODE[161], &gn_BGP_IPV4M_NODE[162], &gn_BGP_IPV4M_NODE[163], &gn_BGP_IPV4M_NODE[164], &gn_BGP_IPV4M_NODE[165], &gn_BGP_IPV4M_NODE[166], &gn_BGP_IPV4M_NODE[167], &gn_BGP_IPV4M_NODE[168], &gn_BGP_IPV4M_NODE[169], &gn_BGP_IPV4M_NODE[170], &gn_BGP_IPV4M_NODE[171], &gn_BGP_IPV4M_NODE[172], &gn_BGP_IPV4M_NODE[173], &gn_BGP_IPV4M_NODE[174], &gn_BGP_IPV4M_NODE[175], &gn_BGP_IPV4M_NODE[176], &gn_BGP_IPV4M_NODE[177], &gn_BGP_IPV4M_NODE[178], &gn_BGP_IPV4M_NODE[179], &gn_BGP_IPV4M_NODE[180], &gn_BGP_IPV4M_NODE[181], &gn_BGP_IPV4M_NODE[182], &gn_BGP_IPV4M_NODE[183], &gn_BGP_IPV4M_NODE[184], &gn_BGP_IPV4M_NODE[185], &gn_BGP_IPV4M_NODE[186], &gn_BGP_IPV4M_NODE[187], &gn_BGP_IPV4M_NODE[188], &gn_BGP_IPV4M_NODE[189], &gn_BGP_IPV4M_NODE[190], &gn_BGP_IPV4M_NODE[191], &gn_BGP_IPV4M_NODE[192], &gn_BGP_IPV4M_NODE[193], &gn_BGP_IPV4M_NODE[194], &gn_BGP_IPV4M_NODE[195], &gn_BGP_IPV4M_NODE[196], &gn_BGP_IPV4M_NODE[197], &gn_BGP_IPV4M_NODE[198], &gn_BGP_IPV4M_NODE[199], &gn_BGP_IPV4M_NODE[200], &gn_BGP_IPV4M_NODE[201], &gn_BGP_IPV4M_NODE[202], &gn_BGP_IPV4M_NODE[203], &gn_BGP_IPV4M_NODE[204], &gn_BGP_IPV4M_NODE[205], &gn_BGP_IPV4M_NODE[206], &gn_BGP_IPV4M_NODE[207], &gn_BGP_IPV4M_NODE[208], &gn_BGP_IPV4M_NODE[209], &gn_BGP_IPV4M_NODE[210], &gn_BGP_IPV4M_NODE[211], &gn_BGP_IPV4M_NODE[212], &gn_BGP_IPV4M_NODE[213], &gn_BGP_IPV4M_NODE[214], &gn_BGP_IPV4M_NODE[215], &gn_BGP_IPV4M_NODE[216], &gn_BGP_IPV4M_NODE[217], &gn_BGP_IPV4M_NODE[218], &gn_BGP_IPV4M_NODE[219], &gn_BGP_IPV4M_NODE[220], &gn_BGP_IPV4M_NODE[221], &gn_BGP_IPV4M_NODE[222], &gn_BGP_IPV4M_NODE[223], &gn_BGP_IPV4M_NODE[224], &gn_BGP_IPV4M_NODE[225], &gn_BGP_IPV4M_NODE[226], &gn_BGP_IPV4M_NODE[227], &gn_BGP_IPV4M_NODE[228], &gn_BGP_IPV4M_NODE[229], &gn_BGP_IPV4M_NODE[230], &gn_BGP_IPV4M_NODE[231], &gn_BGP_IPV4M_NODE[232], &gn_BGP_IPV4M_NODE[233], &gn_BGP_IPV4M_NODE[234], &gn_BGP_IPV4M_NODE[235], &gn_BGP_IPV4M_NODE[236], &gn_BGP_IPV4M_NODE[237], &gn_BGP_IPV4M_NODE[238], &gn_BGP_IPV4M_NODE[239], &gn_BGP_IPV4M_NODE[240], &gn_BGP_IPV4M_NODE[241], &gn_BGP_IPV4M_NODE[242], &gn_BGP_IPV4M_NODE[243], &gn_BGP_IPV4M_NODE[244], &gn_BGP_IPV4M_NODE[245], &gn_BGP_IPV4M_NODE[246], &gn_BGP_IPV4M_NODE[247], &gn_BGP_IPV4M_NODE[248], &gn_BGP_IPV4M_NODE[249], &gn_BGP_IPV4M_NODE[250], &gn_BGP_IPV4M_NODE[251], &gn_BGP_IPV4M_NODE[252], &gn_BGP_IPV4M_NODE[253], &gn_BGP_IPV4M_NODE[254], &gn_BGP_IPV4M_NODE[255], &gn_BGP_IPV4M_NODE[256], &gn_BGP_IPV4M_NODE[257], &gn_BGP_IPV4M_NODE[258], &gn_BGP_IPV4M_NODE[259], &gn_BGP_IPV4M_NODE[260], &gn_BGP_IPV4M_NODE[261], &gn_BGP_IPV4M_NODE[262], &gn_BGP_IPV4M_NODE[263], &gn_BGP_IPV4M_NODE[264], &gn_BGP_IPV4M_NODE[265], &gn_BGP_IPV4M_NODE[266], &gn_BGP_IPV4M_NODE[267], &gn_BGP_IPV4M_NODE[268], &gn_BGP_IPV4M_NODE[269], &gn_BGP_IPV4M_NODE[270], &gn_BGP_IPV4M_NODE[271], &gn_BGP_IPV4M_NODE[272], &gn_BGP_IPV4M_NODE[273], &gn_BGP_IPV4M_NODE[274], &gn_BGP_IPV4M_NODE[275], &gn_BGP_IPV4M_NODE[276], &gn_BGP_IPV4M_NODE[277], &gn_BGP_IPV4M_NODE[278], &gn_BGP_IPV4M_NODE[279], &gn_BGP_IPV4M_NODE[280], &gn_BGP_IPV4M_NODE[281], &gn_BGP_IPV4M_NODE[282], &gn_BGP_IPV4M_NODE[283], &gn_BGP_IPV4M_NODE[284], &gn_BGP_IPV4M_NODE[285], &gn_BGP_IPV4M_NODE[286], &gn_BGP_IPV4M_NODE[287], &gn_BGP_IPV4M_NODE[288], &gn_BGP_IPV4M_NODE[289], &gn_BGP_IPV4M_NODE[290], &gn_BGP_IPV4M_NODE[291], &gn_BGP_IPV4M_NODE[292], &gn_BGP_IPV4M_NODE[293], &gn_BGP_IPV4M_NODE[294], &gn_BGP_IPV4M_NODE[295], &gn_BGP_IPV4M_NODE[296], &gn_BGP_IPV4M_NODE[297], &gn_BGP_IPV4M_NODE[298], &gn_BGP_IPV4M_NODE[299], &gn_BGP_IPV4M_NODE[300], &gn_BGP_IPV4M_NODE[301], &gn_BGP_IPV4M_NODE[302], &gn_BGP_IPV4M_NODE[303], &gn_BGP_IPV4M_NODE[304], &gn_BGP_IPV4M_NODE[305], &gn_BGP_IPV4M_NODE[306], &gn_BGP_IPV4M_NODE[307], &gn_BGP_IPV4M_NODE[308], &gn_BGP_IPV4M_NODE[309], &gn_BGP_IPV4M_NODE[310], &gn_BGP_IPV4M_NODE[311], &gn_BGP_IPV4M_NODE[312], &gn_BGP_IPV4M_NODE[313], &gn_BGP_IPV4M_NODE[314], &gn_BGP_IPV4M_NODE[315], &gn_BGP_IPV4M_NODE[316], &gn_BGP_IPV4M_NODE[317], &gn_BGP_IPV4M_NODE[318], &gn_BGP_IPV4M_NODE[319], &gn_BGP_IPV4M_NODE[320], &gn_BGP_IPV4M_NODE[321], &gn_BGP_IPV4M_NODE[322], &gn_BGP_IPV4M_NODE[323], &gn_BGP_IPV4M_NODE[324], &gn_BGP_IPV4M_NODE[325], &gn_BGP_IPV4M_NODE[326], &gn_BGP_IPV4M_NODE[327], &gn_BGP_IPV4M_NODE[328], &gn_BGP_IPV4M_NODE[329], &gn_BGP_IPV4M_NODE[330], &gn_BGP_IPV4M_NODE[331], &gn_BGP_IPV4M_NODE[332], &gn_BGP_IPV4M_NODE[333], &gn_BGP_IPV4M_NODE[334], &gn_BGP_IPV4M_NODE[335], &gn_BGP_IPV4M_NODE[336], &gn_BGP_IPV4M_NODE[337], &gn_BGP_IPV4M_NODE[338], &gn_BGP_IPV4M_NODE[339], &gn_BGP_IPV4M_NODE[340], &gn_BGP_IPV4M_NODE[341], &gn_BGP_IPV4M_NODE[342], &gn_BGP_IPV4M_NODE[343], &gn_BGP_IPV4M_NODE[344], &gn_BGP_IPV4M_NODE[345], &gn_BGP_IPV4M_NODE[346], &gn_BGP_IPV4M_NODE[347], &gn_BGP_IPV4M_NODE[348], &gn_BGP_IPV4M_NODE[349], &gn_BGP_IPV4M_NODE[350], &gn_BGP_IPV4M_NODE[351], &gn_BGP_IPV4M_NODE[352], &gn_BGP_IPV4M_NODE[353], &gn_BGP_IPV4M_NODE[354], &gn_BGP_IPV4M_NODE[355], &gn_BGP_IPV4M_NODE[356], &gn_BGP_IPV4M_NODE[357], &gn_BGP_IPV4M_NODE[358], &gn_BGP_IPV4M_NODE[359], &gn_BGP_IPV4M_NODE[360], &gn_BGP_IPV4M_NODE[361], &gn_BGP_IPV4M_NODE[362], &gn_BGP_IPV4M_NODE[363], &gn_BGP_IPV4M_NODE[364], &gn_BGP_IPV4M_NODE[365], &gn_BGP_IPV4M_NODE[366], &gn_BGP_IPV4M_NODE[367], &gn_BGP_IPV4M_NODE[368], &gn_BGP_IPV4M_NODE[369], &gn_BGP_IPV4M_NODE[370], &gn_BGP_IPV4M_NODE[371], &gn_BGP_IPV4M_NODE[372], &gn_BGP_IPV4M_NODE[373], &gn_BGP_IPV4M_NODE[374], &gn_BGP_IPV4M_NODE[375], &gn_BGP_IPV4M_NODE[376], &gn_BGP_IPV4M_NODE[377], &gn_BGP_IPV4M_NODE[378], &gn_BGP_IPV4M_NODE[379], &gn_BGP_IPV4M_NODE[380], &gn_BGP_IPV4M_NODE[381], &gn_BGP_IPV4M_NODE[382], &gn_BGP_IPV4M_NODE[383], &gn_BGP_IPV4M_NODE[384], &gn_BGP_IPV4M_NODE[385], &gn_BGP_IPV4M_NODE[386], &gn_BGP_IPV4M_NODE[387], &gn_BGP_IPV4M_NODE[388], &gn_BGP_IPV4M_NODE[389], &gn_BGP_IPV4M_NODE[390], &gn_BGP_IPV4M_NODE[391], &gn_BGP_IPV4M_NODE[392], &gn_BGP_IPV4M_NODE[393], &gn_BGP_IPV4M_NODE[394], &gn_BGP_IPV4M_NODE[395], &gn_BGP_IPV4M_NODE[396], &gn_BGP_IPV4M_NODE[397], &gn_BGP_IPV4M_NODE[398], &gn_BGP_IPV4M_NODE[399], &gn_BGP_IPV4M_NODE[400], &gn_BGP_IPV4M_NODE[401], &gn_BGP_IPV4M_NODE[402], &gn_BGP_IPV4M_NODE[403], &gn_BGP_IPV4M_NODE[404], &gn_BGP_IPV4M_NODE[405], &gn_BGP_IPV4M_NODE[406], &gn_BGP_IPV4M_NODE[407], &gn_BGP_IPV4M_NODE[408], &gn_BGP_IPV4M_NODE[409], &gn_BGP_IPV4M_NODE[410], &gn_BGP_IPV4M_NODE[411], &gn_BGP_IPV4M_NODE[412], &gn_BGP_IPV4M_NODE[413], &gn_BGP_IPV4M_NODE[414], &gn_BGP_IPV4M_NODE[415], &gn_BGP_IPV4M_NODE[416], &gn_BGP_IPV4M_NODE[417], &gn_BGP_IPV4M_NODE[418], &gn_BGP_IPV4M_NODE[419], &gn_BGP_IPV4M_NODE[420], &gn_BGP_IPV4M_NODE[421], &gn_BGP_IPV4M_NODE[422], &gn_BGP_IPV4M_NODE[423], &gn_BGP_IPV4M_NODE[424], &gn_BGP_IPV4M_NODE[425], &gn_BGP_IPV4M_NODE[426], &gn_BGP_IPV4M_NODE[427], &gn_BGP_IPV4M_NODE[428], &gn_BGP_IPV4M_NODE[429], &gn_BGP_IPV4M_NODE[430], &gn_BGP_IPV4M_NODE[431], &gn_BGP_IPV4M_NODE[432], &gn_BGP_IPV4M_NODE[433], &gn_BGP_IPV4M_NODE[434], &gn_BGP_IPV4M_NODE[435], &gn_BGP_IPV4M_NODE[436], &gn_BGP_IPV4M_NODE[437], &gn_BGP_IPV4M_NODE[438], &gn_BGP_IPV4M_NODE[439], &gn_BGP_IPV4M_NODE[440], &gn_BGP_IPV4M_NODE[441], &gn_BGP_IPV4M_NODE[442], &gn_BGP_IPV4M_NODE[443], &gn_BGP_IPV4M_NODE[444], &gn_BGP_IPV4M_NODE[445], &gn_BGP_IPV4M_NODE[446], &gn_BGP_IPV4M_NODE[447], &gn_BGP_IPV4M_NODE[448], &gn_BGP_IPV4M_NODE[449], &gn_BGP_IPV4M_NODE[450], &gn_BGP_IPV4M_NODE[451], &gn_BGP_IPV4M_NODE[452], &gn_BGP_IPV4M_NODE[453], &gn_BGP_IPV4M_NODE[454], &gn_BGP_IPV4M_NODE[455], &gn_BGP_IPV4M_NODE[456], &gn_BGP_IPV4M_NODE[457], &gn_BGP_IPV4M_NODE[458], &gn_BGP_IPV4M_NODE[459], &gn_BGP_IPV4M_NODE[460], &gn_BGP_IPV4M_NODE[461], &gn_BGP_IPV4M_NODE[462], &gn_BGP_IPV4M_NODE[463], &gn_BGP_IPV4M_NODE[464], &gn_BGP_IPV4M_NODE[465], &gn_BGP_IPV4M_NODE[466], &gn_BGP_IPV4M_NODE[467], &gn_BGP_IPV4M_NODE[468], &gn_BGP_IPV4M_NODE[469], &gn_BGP_IPV4M_NODE[470], &gn_BGP_IPV4M_NODE[471], &gn_BGP_IPV4M_NODE[472], &gn_BGP_IPV4M_NODE[473], &gn_BGP_IPV4M_NODE[474], &gn_BGP_IPV4M_NODE[475], &gn_BGP_IPV4M_NODE[476], &gn_BGP_IPV4M_NODE[477], &gn_BGP_IPV4M_NODE[478], &gn_BGP_IPV4M_NODE[479], &gn_BGP_IPV4M_NODE[480], &gn_BGP_IPV4M_NODE[481], &gn_BGP_IPV4M_NODE[482], &gn_BGP_IPV4M_NODE[483], &gn_BGP_IPV4M_NODE[484], &gn_BGP_IPV4M_NODE[485], &gn_BGP_IPV4M_NODE[486], &gn_BGP_IPV4M_NODE[487], &gn_BGP_IPV4M_NODE[488], &gn_BGP_IPV4M_NODE[489], &gn_BGP_IPV4M_NODE[490], &gn_BGP_IPV4M_NODE[491], &gn_BGP_IPV4M_NODE[492], &gn_BGP_IPV4M_NODE[493], &gn_BGP_IPV4M_NODE[494], &gn_BGP_IPV4M_NODE[495], &gn_BGP_IPV4M_NODE[496], &gn_BGP_IPV4M_NODE[497], &gn_BGP_IPV4M_NODE[498], &gn_BGP_IPV4M_NODE[499], &gn_BGP_IPV4M_NODE[500], &gn_BGP_IPV4M_NODE[501], &gn_BGP_IPV4M_NODE[502], &gn_BGP_IPV4M_NODE[503], &gn_BGP_IPV4M_NODE[504], &gn_BGP_IPV4M_NODE[505], &gn_BGP_IPV4M_NODE[506], &gn_BGP_IPV4M_NODE[507], &gn_BGP_IPV4M_NODE[508], &gn_BGP_IPV4M_NODE[509], &gn_BGP_IPV4M_NODE[510], &gn_BGP_IPV4M_NODE[511], &gn_BGP_IPV4M_NODE[512], &gn_BGP_IPV4M_NODE[513], &gn_BGP_IPV4M_NODE[514], &gn_BGP_IPV4M_NODE[515], &gn_BGP_IPV4M_NODE[516], &gn_BGP_IPV4M_NODE[517], &gn_BGP_IPV4M_NODE[518], &gn_BGP_IPV4M_NODE[519], &gn_BGP_IPV4M_NODE[520], &gn_BGP_IPV4M_NODE[521], &gn_BGP_IPV4M_NODE[522], &gn_BGP_IPV4M_NODE[523], &gn_BGP_IPV4M_NODE[524], &gn_BGP_IPV4M_NODE[525], &gn_BGP_IPV4M_NODE[526], &gn_BGP_IPV4M_NODE[527], &gn_BGP_IPV4M_NODE[528], &gn_BGP_IPV4M_NODE[529], &gn_BGP_IPV4M_NODE[530], &gn_BGP_IPV4M_NODE[531], &gn_BGP_IPV4M_NODE[532], &gn_BGP_IPV4M_NODE[533], &gn_BGP_IPV4M_NODE[534], &gn_BGP_IPV4M_NODE[535], &gn_BGP_IPV4M_NODE[536], &gn_BGP_IPV4M_NODE[537], &gn_BGP_IPV4M_NODE[538], &gn_BGP_IPV4M_NODE[539], &gn_BGP_IPV4M_NODE[540], &gn_BGP_IPV4M_NODE[541]);

extern void install_BGP_IPV4M_NODE(void);

void install_BGP_IPV4M_NODE(void)

{
	unsigned node_id = BGP_IPV4M_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BGP_IPV4M_NODE;
	vector_set(node->cmd_vector, &aggregate_addressv4_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_damp_set_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_damp_unset_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_source_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_distance_source_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_network_cmd_vtysh);
	vector_set(node->cmd_vector, &bgp_table_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_activate_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_paths_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_all_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_best_selected_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_addpath_tx_bestpath_per_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_advertise_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_allowas_in_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_as_override_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_attr_unchanged_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_capability_orf_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_damp_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_default_originate_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_default_originate_rmap_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_disable_addpath_rx_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_ecommunity_rpki_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_filter_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_out_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_restart_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_restart_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_threshold_warning_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_maximum_prefix_warning_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_all_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_nexthop_self_force_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_all_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_all_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_remove_private_as_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_reflector_client_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_route_server_client_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_send_community_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_send_community_type_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_set_peer_group_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_soft_reconfiguration_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_unsuppress_map_cmd_vtysh);
	vector_set(node->cmd_vector, &neighbor_weight_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_source_access_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_distance_source_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bgp_table_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_activate_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_paths_limit_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_all_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_best_selected_paths_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_addpath_tx_bestpath_per_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_allowas_in_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_as_override_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_attr_unchanged_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_capability_orf_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_damp_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_default_originate_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_disable_addpath_rx_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_filter_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_maximum_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_maximum_prefix_out_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_all_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_nexthop_self_force_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_prefix_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_all_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_all_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_remove_private_as_replace_as_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_reflector_client_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_route_server_client_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_send_community_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_send_community_type_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_set_peer_group_hidden_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_soft_reconfiguration_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_soo_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_unsuppress_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_neighbor_weight_cmd_vtysh);
}

static struct cmd_token ctkn_BGP_VNC_L2_GROUP_NODE[];
static struct graph_node gn_BGP_VNC_L2_GROUP_NODE[];

static struct cmd_token ctkn_BGP_VNC_L2_GROUP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"labels",
		.desc = (char *)"Specify label values associated with group",
	},
	{ /* [2] */
		.type = RANGE_TKN,
		.allowrepeat = true,
		.text = (char *)"(0-1048575)",
		.desc = (char *)"Space separated list of label values <0-1048575>",
		.max = 1048575,
	},
	{ /* [3] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [4] = vnc_l2_group_labels_cmd */ },
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"logical-network-id",
		.desc = (char *)"Specify Logical Network ID associated with group",
	},
	{ /* [6] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-4294967295)",
		.desc = (char *)"value",
		.max = 4294967295,
		.varname = (char *)"logical_network_id",
	},
	{ /* [7] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [8] = vnc_l2_group_lni_cmd */ },
	{ /* [9] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [10] */
		.type = WORD_TKN,
		.text = (char *)"labels",
		.desc = (char *)"Specify label values associated with L2 group",
	},
	{ /* [11] */
		.type = RANGE_TKN,
		.allowrepeat = true,
		.text = (char *)"(0-1048575)",
		.desc = (char *)"Space separated list of label values <0-1048575>",
		.max = 1048575,
	},
	{ /* [12] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [13] = vnc_l2_group_no_labels_cmd */ },
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"rt",
		.desc = (char *)"Specify route targets",
	},
	{ /* [15] */
		.type = FORK_TKN,
		.forkjoin = &gn_BGP_VNC_L2_GROUP_NODE[17],
	},
	{ /* [16] */
		.type = WORD_TKN,
		.text = (char *)"both",
		.desc = (char *)"Export+import filters",
	},
	{ /* [17] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BGP_VNC_L2_GROUP_NODE[15],
	},
	{ /* [18] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ASN:NN_OR_IP-ADDRESS:NN",
		.desc = (char *)"A route target",
		.varname = (char *)"asn_nn_or_ip_address_nn",
	},
	{ /* [19] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [20] = vnc_l2_group_rt_cmd */ },
	{ /* [21] */
		.type = WORD_TKN,
		.text = (char *)"export",
		.desc = (char *)"Export filters",
	},
	{ /* [22] */
		.type = WORD_TKN,
		.text = (char *)"import",
		.desc = (char *)"Import filters",
	},
};

extern struct cmd_element vnc_l2_group_labels_cmd_vtysh;
extern struct cmd_element vnc_l2_group_lni_cmd_vtysh;
extern struct cmd_element vnc_l2_group_no_labels_cmd_vtysh;
extern struct cmd_element vnc_l2_group_rt_cmd_vtysh;

MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_0_next, 4, &gn_BGP_VNC_L2_GROUP_NODE[1], &gn_BGP_VNC_L2_GROUP_NODE[5], &gn_BGP_VNC_L2_GROUP_NODE[9], &gn_BGP_VNC_L2_GROUP_NODE[14]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_1_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_1_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_2_next, 2, &gn_BGP_VNC_L2_GROUP_NODE[2], &gn_BGP_VNC_L2_GROUP_NODE[3]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_2_prev, 2, &gn_BGP_VNC_L2_GROUP_NODE[1], &gn_BGP_VNC_L2_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_3_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[4]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_3_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[2]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_4_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_4_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[3]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_5_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[6]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_5_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_6_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[7]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_6_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[5]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_7_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[8]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_7_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[6]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_8_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_8_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[7]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_9_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[10]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_9_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_10_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[11]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_10_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[9]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_11_next, 2, &gn_BGP_VNC_L2_GROUP_NODE[11], &gn_BGP_VNC_L2_GROUP_NODE[12]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_11_prev, 2, &gn_BGP_VNC_L2_GROUP_NODE[10], &gn_BGP_VNC_L2_GROUP_NODE[11]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_12_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[13]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_12_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[11]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_13_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_13_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[12]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_14_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[15]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_14_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[0]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_15_next, 3, &gn_BGP_VNC_L2_GROUP_NODE[16], &gn_BGP_VNC_L2_GROUP_NODE[21], &gn_BGP_VNC_L2_GROUP_NODE[22]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_15_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[14]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_16_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[17]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_16_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[15]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_17_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[18]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_17_prev, 3, &gn_BGP_VNC_L2_GROUP_NODE[16], &gn_BGP_VNC_L2_GROUP_NODE[21], &gn_BGP_VNC_L2_GROUP_NODE[22]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_18_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[19]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_18_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[17]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_19_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[20]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_19_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[18]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_20_next, 0, );
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_20_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[19]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_21_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[17]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_21_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[15]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_22_next, 1, &gn_BGP_VNC_L2_GROUP_NODE[17]);
MAKE_VECTOR(gn_BGP_VNC_L2_GROUP_NODE_22_prev, 1, &gn_BGP_VNC_L2_GROUP_NODE[15]);

static struct graph_node gn_BGP_VNC_L2_GROUP_NODE[] = {
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_0_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_0_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[0],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_1_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_1_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[1],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_2_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_2_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[2],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_3_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_3_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[3],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_4_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_4_next,
		.data = (void *)&vnc_l2_group_labels_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_5_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_5_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[5],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_6_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_6_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[6],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_7_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_7_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[7],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_8_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_8_next,
		.data = (void *)&vnc_l2_group_lni_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_9_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_9_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[9],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_10_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_10_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[10],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_11_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_11_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[11],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_12_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_12_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[12],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_13_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_13_next,
		.data = (void *)&vnc_l2_group_no_labels_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_14_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_14_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[14],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_15_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_15_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[15],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_16_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_16_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[16],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_17_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_17_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[17],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_18_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_18_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[18],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_19_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_19_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[19],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_20_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_20_next,
		.data = (void *)&vnc_l2_group_rt_cmd_vtysh,
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_21_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_21_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[21],
	},
	{
		.from = &gn_BGP_VNC_L2_GROUP_NODE_22_prev,
		.to = &gn_BGP_VNC_L2_GROUP_NODE_22_next,
		.data = &ctkn_BGP_VNC_L2_GROUP_NODE[22],
	},
};
MAKE_VECTOR(gvec_BGP_VNC_L2_GROUP_NODE, 23, &gn_BGP_VNC_L2_GROUP_NODE[0], &gn_BGP_VNC_L2_GROUP_NODE[1], &gn_BGP_VNC_L2_GROUP_NODE[2], &gn_BGP_VNC_L2_GROUP_NODE[3], &gn_BGP_VNC_L2_GROUP_NODE[4], &gn_BGP_VNC_L2_GROUP_NODE[5], &gn_BGP_VNC_L2_GROUP_NODE[6], &gn_BGP_VNC_L2_GROUP_NODE[7], &gn_BGP_VNC_L2_GROUP_NODE[8], &gn_BGP_VNC_L2_GROUP_NODE[9], &gn_BGP_VNC_L2_GROUP_NODE[10], &gn_BGP_VNC_L2_GROUP_NODE[11], &gn_BGP_VNC_L2_GROUP_NODE[12], &gn_BGP_VNC_L2_GROUP_NODE[13], &gn_BGP_VNC_L2_GROUP_NODE[14], &gn_BGP_VNC_L2_GROUP_NODE[15], &gn_BGP_VNC_L2_GROUP_NODE[16], &gn_BGP_VNC_L2_GROUP_NODE[17], &gn_BGP_VNC_L2_GROUP_NODE[18], &gn_BGP_VNC_L2_GROUP_NODE[19], &gn_BGP_VNC_L2_GROUP_NODE[20], &gn_BGP_VNC_L2_GROUP_NODE[21], &gn_BGP_VNC_L2_GROUP_NODE[22]);

extern void install_BGP_VNC_L2_GROUP_NODE(void);

void install_BGP_VNC_L2_GROUP_NODE(void)

{
	unsigned node_id = BGP_VNC_L2_GROUP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BGP_VNC_L2_GROUP_NODE;
	vector_set(node->cmd_vector, &vnc_l2_group_labels_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_l2_group_lni_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_l2_group_no_labels_cmd_vtysh);
	vector_set(node->cmd_vector, &vnc_l2_group_rt_cmd_vtysh);
}

static struct cmd_token ctkn_LDP_IPV4_IFACE_NODE[];
static struct graph_node gn_LDP_IPV4_IFACE_NODE[];

static struct cmd_token ctkn_LDP_IPV4_IFACE_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_LDP_IPV4_IFACE_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_LDP_IPV4_IFACE_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"disable-establish-hello",
		.desc = (char *)"Disable sending additional LDP hello message on establishing LDP tcp connection",
	},
	{ /* [5] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [6] = ldp_disable_establish_hello_cmd */ },
	{ /* [7] */
		.type = WORD_TKN,
		.text = (char *)"discovery",
		.desc = (char *)"Configure discovery parameters",
	},
	{ /* [8] */
		.type = WORD_TKN,
		.text = (char *)"hello",
		.desc = (char *)"LDP Link Hellos",
	},
	{ /* [9] */
		.type = WORD_TKN,
		.text = (char *)"holdtime",
		.desc = (char *)"Hello holdtime",
	},
	{ /* [10] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds) - 65535 implies infinite",
		.min = 1,
		.max = 65535,
		.varname = (char *)"holdtime",
	},
	{ /* [11] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [12] = ldp_discovery_link_holdtime_cmd */ },
	{ /* [13] */
		.type = WORD_TKN,
		.text = (char *)"interval",
		.desc = (char *)"Hello interval",
	},
	{ /* [14] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"Time (seconds)",
		.min = 1,
		.max = 65535,
		.varname = (char *)"interval",
	},
	{ /* [15] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [16] = ldp_discovery_link_interval_cmd */ },
};

extern struct cmd_element ldp_disable_establish_hello_cmd_vtysh;
extern struct cmd_element ldp_discovery_link_holdtime_cmd_vtysh;
extern struct cmd_element ldp_discovery_link_interval_cmd_vtysh;

MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_0_next, 1, &gn_LDP_IPV4_IFACE_NODE[1]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_0_prev, 0, );
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_1_next, 2, &gn_LDP_IPV4_IFACE_NODE[2], &gn_LDP_IPV4_IFACE_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_1_prev, 1, &gn_LDP_IPV4_IFACE_NODE[0]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_2_next, 1, &gn_LDP_IPV4_IFACE_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_2_prev, 1, &gn_LDP_IPV4_IFACE_NODE[1]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_3_next, 2, &gn_LDP_IPV4_IFACE_NODE[4], &gn_LDP_IPV4_IFACE_NODE[7]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_3_prev, 2, &gn_LDP_IPV4_IFACE_NODE[2], &gn_LDP_IPV4_IFACE_NODE[1]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_4_next, 1, &gn_LDP_IPV4_IFACE_NODE[5]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_4_prev, 1, &gn_LDP_IPV4_IFACE_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_5_next, 1, &gn_LDP_IPV4_IFACE_NODE[6]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_5_prev, 1, &gn_LDP_IPV4_IFACE_NODE[4]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_6_next, 0, );
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_6_prev, 1, &gn_LDP_IPV4_IFACE_NODE[5]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_7_next, 1, &gn_LDP_IPV4_IFACE_NODE[8]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_7_prev, 1, &gn_LDP_IPV4_IFACE_NODE[3]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_8_next, 2, &gn_LDP_IPV4_IFACE_NODE[9], &gn_LDP_IPV4_IFACE_NODE[13]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_8_prev, 1, &gn_LDP_IPV4_IFACE_NODE[7]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_9_next, 1, &gn_LDP_IPV4_IFACE_NODE[10]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_9_prev, 1, &gn_LDP_IPV4_IFACE_NODE[8]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_10_next, 1, &gn_LDP_IPV4_IFACE_NODE[11]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_10_prev, 1, &gn_LDP_IPV4_IFACE_NODE[9]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_11_next, 1, &gn_LDP_IPV4_IFACE_NODE[12]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_11_prev, 1, &gn_LDP_IPV4_IFACE_NODE[10]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_12_next, 0, );
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_12_prev, 1, &gn_LDP_IPV4_IFACE_NODE[11]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_13_next, 1, &gn_LDP_IPV4_IFACE_NODE[14]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_13_prev, 1, &gn_LDP_IPV4_IFACE_NODE[8]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_14_next, 1, &gn_LDP_IPV4_IFACE_NODE[15]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_14_prev, 1, &gn_LDP_IPV4_IFACE_NODE[13]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_15_next, 1, &gn_LDP_IPV4_IFACE_NODE[16]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_15_prev, 1, &gn_LDP_IPV4_IFACE_NODE[14]);
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_16_next, 0, );
MAKE_VECTOR(gn_LDP_IPV4_IFACE_NODE_16_prev, 1, &gn_LDP_IPV4_IFACE_NODE[15]);

static struct graph_node gn_LDP_IPV4_IFACE_NODE[] = {
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_0_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_0_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[0],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_1_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_1_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[1],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_2_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_2_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[2],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_3_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_3_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[3],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_4_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_4_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[4],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_5_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_5_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[5],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_6_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_6_next,
		.data = (void *)&ldp_disable_establish_hello_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_7_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_7_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[7],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_8_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_8_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[8],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_9_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_9_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[9],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_10_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_10_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[10],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_11_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_11_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[11],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_12_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_12_next,
		.data = (void *)&ldp_discovery_link_holdtime_cmd_vtysh,
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_13_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_13_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[13],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_14_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_14_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[14],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_15_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_15_next,
		.data = &ctkn_LDP_IPV4_IFACE_NODE[15],
	},
	{
		.from = &gn_LDP_IPV4_IFACE_NODE_16_prev,
		.to = &gn_LDP_IPV4_IFACE_NODE_16_next,
		.data = (void *)&ldp_discovery_link_interval_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_LDP_IPV4_IFACE_NODE, 17, &gn_LDP_IPV4_IFACE_NODE[0], &gn_LDP_IPV4_IFACE_NODE[1], &gn_LDP_IPV4_IFACE_NODE[2], &gn_LDP_IPV4_IFACE_NODE[3], &gn_LDP_IPV4_IFACE_NODE[4], &gn_LDP_IPV4_IFACE_NODE[5], &gn_LDP_IPV4_IFACE_NODE[6], &gn_LDP_IPV4_IFACE_NODE[7], &gn_LDP_IPV4_IFACE_NODE[8], &gn_LDP_IPV4_IFACE_NODE[9], &gn_LDP_IPV4_IFACE_NODE[10], &gn_LDP_IPV4_IFACE_NODE[11], &gn_LDP_IPV4_IFACE_NODE[12], &gn_LDP_IPV4_IFACE_NODE[13], &gn_LDP_IPV4_IFACE_NODE[14], &gn_LDP_IPV4_IFACE_NODE[15], &gn_LDP_IPV4_IFACE_NODE[16]);

extern void install_LDP_IPV4_IFACE_NODE(void);

void install_LDP_IPV4_IFACE_NODE(void)

{
	unsigned node_id = LDP_IPV4_IFACE_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_LDP_IPV4_IFACE_NODE;
	vector_set(node->cmd_vector, &ldp_disable_establish_hello_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_link_holdtime_cmd_vtysh);
	vector_set(node->cmd_vector, &ldp_discovery_link_interval_cmd_vtysh);
}

static struct cmd_token ctkn_RIP_NODE[];
static struct graph_node gn_RIP_NODE[];

static struct cmd_token ctkn_RIP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"default-information",
		.desc = (char *)"Control distribution of default route",
	},
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"originate",
		.desc = (char *)"Distribute a default route",
	},
	{ /* [6] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [7] = rip_default_information_originate_cmd */ },
	{ /* [8] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Administrative distance",
	},
	{ /* [9] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance value",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [10] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP source prefix",
		.varname = (char *)"prefix",
	},
	{ /* [11] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[13],
	},
	{ /* [12] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Access list name",
		.varname = (char *)"acl",
	},
	{ /* [13] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[11],
	},
	{ /* [14] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [15] = rip_distance_source_cmd */ },
	{ /* [16] */
		.type = WORD_TKN,
		.text = (char *)"neighbor",
		.desc = (char *)"Specify a neighbor router",
	},
	{ /* [17] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Neighbor address",
		.varname = (char *)"neighbor",
	},
	{ /* [18] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [19] = rip_neighbor_cmd */ },
	{ /* [20] */
		.type = WORD_TKN,
		.text = (char *)"network",
		.desc = (char *)"Enable routing on an IP network",
	},
	{ /* [21] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP prefix <network>/<length>, e.g., 35.0.0.0/8",
		.varname = (char *)"network",
	},
	{ /* [22] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [23] = rip_network_prefix_cmd */ },
	{ /* [24] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name",
		.varname = (char *)"network",
	},
	{ /* [25] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [26] = rip_network_if_cmd */ },
	{ /* [27] */
		.type = WORD_TKN,
		.text = (char *)"offset-list",
		.desc = (char *)"Modify RIP metric",
	},
	{ /* [28] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"Access-list name",
		.varname = (char *)"acl",
	},
	{ /* [29] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[31],
	},
	{ /* [30] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"For incoming updates",
		.varname = (char *)"direction",
	},
	{ /* [31] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[29],
	},
	{ /* [32] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(0-16)",
		.desc = (char *)"Metric value",
		.max = 16,
		.varname = (char *)"metric",
	},
	{ /* [33] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[35],
	},
	{ /* [34] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface to match",
		.varname = (char *)"ifname",
	},
	{ /* [35] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[33],
	},
	{ /* [36] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [37] = rip_offset_list_cmd */ },
	{ /* [38] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"out",
		.desc = (char *)"For outgoing updates",
		.varname = (char *)"direction",
	},
	{ /* [39] */
		.type = WORD_TKN,
		.text = (char *)"passive-interface",
		.desc = (char *)"Suppress routing updates on an interface",
	},
	{ /* [40] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [41] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [42] = rip_passive_interface_cmd */ },
	{ /* [43] */
		.type = WORD_TKN,
		.text = (char *)"default",
		.desc = (char *)"default for all interfaces",
	},
	{ /* [44] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [45] = rip_passive_default_cmd */ },
	{ /* [46] */
		.type = WORD_TKN,
		.text = (char *)"redistribute",
		.desc = (char *)"Redistribute information from another routing protocol",
	},
	{ /* [47] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[49],
	},
	{ /* [48] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"kernel",
		.desc = (char *)"Kernel routes (not installed via the zebra RIB)",
		.varname = (char *)"protocol",
	},
	{ /* [49] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[47],
	},
	{ /* [50] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[55],
	},
	{ /* [51] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[54],
	},
	{ /* [52] */
		.type = WORD_TKN,
		.text = (char *)"metric",
		.desc = (char *)"Metric",
	},
	{ /* [53] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-16)",
		.desc = (char *)"Metric value",
		.max = 16,
		.varname = (char *)"metric",
	},
	{ /* [54] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[51],
	},
	{ /* [55] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[50],
	},
	{ /* [56] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [57] = rip_redistribute_cmd */ },
	{ /* [58] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map reference",
	},
	{ /* [59] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"RMAP_NAME",
		.desc = (char *)"Pointer to route-map entries",
		.varname = (char *)"route_map",
	},
	{ /* [60] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"connected",
		.desc = (char *)"Connected routes (directly attached subnet or host)",
		.varname = (char *)"protocol",
	},
	{ /* [61] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"local",
		.desc = (char *)"Local routes (directly attached host route)",
		.varname = (char *)"protocol",
	},
	{ /* [62] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"static",
		.desc = (char *)"Statically configured routes",
		.varname = (char *)"protocol",
	},
	{ /* [63] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ospf",
		.desc = (char *)"Open Shortest Path First (OSPFv2)",
		.varname = (char *)"protocol",
	},
	{ /* [64] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"isis",
		.desc = (char *)"Intermediate System to Intermediate System (IS-IS)",
		.varname = (char *)"protocol",
	},
	{ /* [65] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"bgp",
		.desc = (char *)"Border Gateway Protocol (BGP)",
		.varname = (char *)"protocol",
	},
	{ /* [66] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"eigrp",
		.desc = (char *)"Enhanced Interior Gateway Routing Protocol (EIGRP)",
		.varname = (char *)"protocol",
	},
	{ /* [67] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"nhrp",
		.desc = (char *)"Next Hop Resolution Protocol (NHRP)",
		.varname = (char *)"protocol",
	},
	{ /* [68] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"vnc",
		.desc = (char *)"Virtual Network Control (VNC)",
		.varname = (char *)"protocol",
	},
	{ /* [69] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"babel",
		.desc = (char *)"Babel routing protocol (Babel)",
		.varname = (char *)"protocol",
	},
	{ /* [70] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"openfabric",
		.desc = (char *)"OpenFabric Routing Protocol",
		.varname = (char *)"protocol",
	},
	{ /* [71] */
		.type = WORD_TKN,
		.text = (char *)"route",
		.desc = (char *)"RIP static route configuration",
	},
	{ /* [72] */
		.type = IPV4_PREFIX_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D/M",
		.desc = (char *)"IP prefix <network>/<length>",
		.varname = (char *)"route",
	},
	{ /* [73] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [74] = rip_route_cmd */ },
	{ /* [75] */
		.type = WORD_TKN,
		.text = (char *)"allow-ecmp",
		.desc = (char *)"Allow Equal Cost MultiPath",
	},
	{ /* [76] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[78],
	},
	{ /* [77] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"allow_ecmp",
	},
	{ /* [78] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[76],
	},
	{ /* [79] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [80] = rip_allow_ecmp_cmd */ },
	{ /* [81] */
		.type = WORD_TKN,
		.text = (char *)"bfd",
		.desc = (char *)"Bidirectional Forwarding Detection",
	},
	{ /* [82] */
		.type = WORD_TKN,
		.text = (char *)"default-profile",
		.desc = (char *)"BFD default profile",
	},
	{ /* [83] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"BFDPROF",
		.desc = (char *)"Profile name",
		.varname = (char *)"profile",
	},
	{ /* [84] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [85] = rip_bfd_default_profile_cmd */ },
	{ /* [86] */
		.type = WORD_TKN,
		.text = (char *)"default-metric",
		.desc = (char *)"Set a metric of redistribute routes",
	},
	{ /* [87] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-16)",
		.desc = (char *)"Default metric",
		.min = 1,
		.max = 16,
		.varname = (char *)"default_metric",
	},
	{ /* [88] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [89] = rip_default_metric_cmd */ },
	{ /* [90] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Administrative distance",
	},
	{ /* [91] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance value",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [92] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [93] = rip_distance_cmd */ },
	{ /* [94] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter networks in routing updates",
	},
	{ /* [95] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"Access-list name",
		.varname = (char *)"name",
	},
	{ /* [96] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[98],
	},
	{ /* [97] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routing updates",
		.varname = (char *)"dir",
	},
	{ /* [98] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[96],
	},
	{ /* [99] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[101],
	},
	{ /* [100] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [101] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[99],
	},
	{ /* [102] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [103] = rip_distribute_list_cmd */ },
	{ /* [104] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routing updates",
		.varname = (char *)"dir",
	},
	{ /* [105] */
		.type = WORD_TKN,
		.text = (char *)"prefix",
		.desc = (char *)"Specify a prefix list",
	},
	{ /* [106] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"Prefix-list name",
		.varname = (char *)"name",
	},
	{ /* [107] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[109],
	},
	{ /* [108] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routing updates",
		.varname = (char *)"dir",
	},
	{ /* [109] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[107],
	},
	{ /* [110] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[112],
	},
	{ /* [111] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [112] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[110],
	},
	{ /* [113] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [114] = rip_distribute_list_prefix_cmd */ },
	{ /* [115] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routing updates",
		.varname = (char *)"dir",
	},
	{ /* [116] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [117] */
		.type = WORD_TKN,
		.text = (char *)"allow-ecmp",
		.desc = (char *)"Allow Equal Cost MultiPath",
	},
	{ /* [118] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[120],
	},
	{ /* [119] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-256)",
		.desc = (char *)"Number of paths",
		.min = 1,
		.max = 256,
		.varname = (char *)"allow_ecmp",
	},
	{ /* [120] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[118],
	},
	{ /* [121] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [122] = no_rip_allow_ecmp_cmd */ },
	{ /* [123] */
		.type = WORD_TKN,
		.text = (char *)"bfd",
		.desc = (char *)"Bidirectional Forwarding Detection",
	},
	{ /* [124] */
		.type = WORD_TKN,
		.text = (char *)"default-profile",
		.desc = (char *)"BFD default profile",
	},
	{ /* [125] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[127],
	},
	{ /* [126] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"BFDPROF",
		.desc = (char *)"Profile name",
		.varname = (char *)"bfdprof",
	},
	{ /* [127] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[125],
	},
	{ /* [128] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [129] = no_rip_bfd_default_profile_cmd */ },
	{ /* [130] */
		.type = WORD_TKN,
		.text = (char *)"default-metric",
		.desc = (char *)"Set a metric of redistribute routes",
	},
	{ /* [131] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[133],
	},
	{ /* [132] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-16)",
		.desc = (char *)"Default metric",
		.min = 1,
		.max = 16,
		.varname = (char *)"default_metric",
	},
	{ /* [133] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[131],
	},
	{ /* [134] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [135] = no_rip_default_metric_cmd */ },
	{ /* [136] */
		.type = WORD_TKN,
		.text = (char *)"distance",
		.desc = (char *)"Administrative distance",
	},
	{ /* [137] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[139],
	},
	{ /* [138] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Distance value",
		.min = 1,
		.max = 255,
		.varname = (char *)"distance",
	},
	{ /* [139] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[137],
	},
	{ /* [140] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [141] = no_rip_distance_cmd */ },
	{ /* [142] */
		.type = WORD_TKN,
		.text = (char *)"distribute-list",
		.desc = (char *)"Filter networks in routing updates",
	},
	{ /* [143] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[145],
	},
	{ /* [144] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST4_NAME",
		.desc = (char *)"Access-list name",
		.varname = (char *)"name",
	},
	{ /* [145] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[143],
	},
	{ /* [146] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[148],
	},
	{ /* [147] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routing updates",
		.varname = (char *)"dir",
	},
	{ /* [148] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[146],
	},
	{ /* [149] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[151],
	},
	{ /* [150] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [151] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[149],
	},
	{ /* [152] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [153] = no_rip_distribute_list_cmd */ },
	{ /* [154] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routing updates",
		.varname = (char *)"dir",
	},
	{ /* [155] */
		.type = WORD_TKN,
		.text = (char *)"prefix",
		.desc = (char *)"Specify a prefix list",
	},
	{ /* [156] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[158],
	},
	{ /* [157] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"PREFIXLIST4_NAME",
		.desc = (char *)"Prefix-list name",
		.varname = (char *)"name",
	},
	{ /* [158] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[156],
	},
	{ /* [159] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[161],
	},
	{ /* [160] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Filter incoming routing updates",
		.varname = (char *)"dir",
	},
	{ /* [161] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[159],
	},
	{ /* [162] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[164],
	},
	{ /* [163] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Interface name",
		.varname = (char *)"ifname",
	},
	{ /* [164] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[162],
	},
	{ /* [165] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [166] = no_rip_distribute_list_prefix_cmd */ },
	{ /* [167] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"out",
		.desc = (char *)"Filter outgoing routing updates",
		.varname = (char *)"dir",
	},
	{ /* [168] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map set",
	},
	{ /* [169] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[171],
	},
	{ /* [170] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ROUTE-MAP",
		.desc = (char *)"Route map name",
		.varname = (char *)"route_map",
	},
	{ /* [171] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[169],
	},
	{ /* [172] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[174],
	},
	{ /* [173] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Route map set for input filtering",
		.varname = (char *)"in",
	},
	{ /* [174] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[172],
	},
	{ /* [175] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface information",
		.varname = (char *)"ifname",
	},
	{ /* [176] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [177] = no_if_ipv4_route_map_cmd */ },
	{ /* [178] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Route map set for output filtering",
	},
	{ /* [179] */
		.type = WORD_TKN,
		.text = (char *)"timers",
		.desc = (char *)"Adjust routing timers",
	},
	{ /* [180] */
		.type = WORD_TKN,
		.text = (char *)"basic",
		.desc = (char *)"Basic routing protocol update timers",
	},
	{ /* [181] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[185],
	},
	{ /* [182] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Routing table update timer value in second. Default is 30.",
		.min = 1,
		.max = 32767,
		.varname = (char *)"basic",
	},
	{ /* [183] */
		.type = RANGE_TKN,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Routing information timeout timer. Default is 180.",
		.min = 1,
		.max = 32767,
	},
	{ /* [184] */
		.type = RANGE_TKN,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Garbage collection timer. Default is 240.",
		.min = 1,
		.max = 32767,
	},
	{ /* [185] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[181],
	},
	{ /* [186] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [187] = no_rip_timers_cmd */ },
	{ /* [188] */
		.type = WORD_TKN,
		.text = (char *)"version",
		.desc = (char *)"Set routing protocol version",
	},
	{ /* [189] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[191],
	},
	{ /* [190] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-2)",
		.desc = (char *)"version",
		.min = 1,
		.max = 2,
		.varname = (char *)"version",
	},
	{ /* [191] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[189],
	},
	{ /* [192] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [193] = no_rip_version_cmd */ },
	{ /* [194] */
		.type = WORD_TKN,
		.text = (char *)"route-map",
		.desc = (char *)"Route map set",
	},
	{ /* [195] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"ROUTE-MAP",
		.desc = (char *)"Route map name",
		.varname = (char *)"route_map",
	},
	{ /* [196] */
		.type = FORK_TKN,
		.forkjoin = &gn_RIP_NODE[198],
	},
	{ /* [197] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"in",
		.desc = (char *)"Route map set for input filtering",
		.varname = (char *)"in",
	},
	{ /* [198] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RIP_NODE[196],
	},
	{ /* [199] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"IFNAME",
		.desc = (char *)"Interface information",
		.varname = (char *)"ifname",
	},
	{ /* [200] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [201] = if_ipv4_route_map_cmd */ },
	{ /* [202] */
		.type = WORD_TKN,
		.text = (char *)"out",
		.desc = (char *)"Route map set for output filtering",
	},
	{ /* [203] */
		.type = WORD_TKN,
		.text = (char *)"timers",
		.desc = (char *)"Adjust routing timers",
	},
	{ /* [204] */
		.type = WORD_TKN,
		.text = (char *)"basic",
		.desc = (char *)"Basic routing protocol update timers",
	},
	{ /* [205] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Routing table update timer value in second. Default is 30.",
		.min = 1,
		.max = 32767,
		.varname = (char *)"update",
	},
	{ /* [206] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Routing information timeout timer. Default is 180.",
		.min = 1,
		.max = 32767,
		.varname = (char *)"timeout",
	},
	{ /* [207] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-32767)",
		.desc = (char *)"Garbage collection timer. Default is 240.",
		.min = 1,
		.max = 32767,
		.varname = (char *)"garbage",
	},
	{ /* [208] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [209] = rip_timers_cmd */ },
	{ /* [210] */
		.type = WORD_TKN,
		.text = (char *)"version",
		.desc = (char *)"Set routing protocol version",
	},
	{ /* [211] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-2)",
		.desc = (char *)"version",
		.min = 1,
		.max = 2,
		.varname = (char *)"version",
	},
	{ /* [212] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [213] = rip_version_cmd */ },
};

extern struct cmd_element if_ipv4_route_map_cmd_vtysh;
extern struct cmd_element no_if_ipv4_route_map_cmd_vtysh;
extern struct cmd_element no_rip_allow_ecmp_cmd_vtysh;
extern struct cmd_element no_rip_bfd_default_profile_cmd_vtysh;
extern struct cmd_element no_rip_default_metric_cmd_vtysh;
extern struct cmd_element no_rip_distance_cmd_vtysh;
extern struct cmd_element no_rip_distribute_list_cmd_vtysh;
extern struct cmd_element no_rip_distribute_list_prefix_cmd_vtysh;
extern struct cmd_element no_rip_timers_cmd_vtysh;
extern struct cmd_element no_rip_version_cmd_vtysh;
extern struct cmd_element rip_allow_ecmp_cmd_vtysh;
extern struct cmd_element rip_bfd_default_profile_cmd_vtysh;
extern struct cmd_element rip_default_information_originate_cmd_vtysh;
extern struct cmd_element rip_default_metric_cmd_vtysh;
extern struct cmd_element rip_distance_cmd_vtysh;
extern struct cmd_element rip_distance_source_cmd_vtysh;
extern struct cmd_element rip_distribute_list_cmd_vtysh;
extern struct cmd_element rip_distribute_list_prefix_cmd_vtysh;
extern struct cmd_element rip_neighbor_cmd_vtysh;
extern struct cmd_element rip_network_if_cmd_vtysh;
extern struct cmd_element rip_network_prefix_cmd_vtysh;
extern struct cmd_element rip_offset_list_cmd_vtysh;
extern struct cmd_element rip_passive_default_cmd_vtysh;
extern struct cmd_element rip_passive_interface_cmd_vtysh;
extern struct cmd_element rip_redistribute_cmd_vtysh;
extern struct cmd_element rip_route_cmd_vtysh;
extern struct cmd_element rip_timers_cmd_vtysh;
extern struct cmd_element rip_version_cmd_vtysh;

MAKE_VECTOR(gn_RIP_NODE_0_next, 10, &gn_RIP_NODE[1], &gn_RIP_NODE[75], &gn_RIP_NODE[81], &gn_RIP_NODE[86], &gn_RIP_NODE[90], &gn_RIP_NODE[94], &gn_RIP_NODE[116], &gn_RIP_NODE[194], &gn_RIP_NODE[203], &gn_RIP_NODE[210]);
MAKE_VECTOR(gn_RIP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_RIP_NODE_1_next, 2, &gn_RIP_NODE[2], &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_1_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_2_next, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_2_prev, 1, &gn_RIP_NODE[1]);
MAKE_VECTOR(gn_RIP_NODE_3_next, 8, &gn_RIP_NODE[4], &gn_RIP_NODE[8], &gn_RIP_NODE[16], &gn_RIP_NODE[20], &gn_RIP_NODE[27], &gn_RIP_NODE[39], &gn_RIP_NODE[46], &gn_RIP_NODE[71]);
MAKE_VECTOR(gn_RIP_NODE_3_prev, 2, &gn_RIP_NODE[2], &gn_RIP_NODE[1]);
MAKE_VECTOR(gn_RIP_NODE_4_next, 1, &gn_RIP_NODE[5]);
MAKE_VECTOR(gn_RIP_NODE_4_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_5_next, 1, &gn_RIP_NODE[6]);
MAKE_VECTOR(gn_RIP_NODE_5_prev, 1, &gn_RIP_NODE[4]);
MAKE_VECTOR(gn_RIP_NODE_6_next, 1, &gn_RIP_NODE[7]);
MAKE_VECTOR(gn_RIP_NODE_6_prev, 1, &gn_RIP_NODE[5]);
MAKE_VECTOR(gn_RIP_NODE_7_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_7_prev, 1, &gn_RIP_NODE[6]);
MAKE_VECTOR(gn_RIP_NODE_8_next, 1, &gn_RIP_NODE[9]);
MAKE_VECTOR(gn_RIP_NODE_8_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_9_next, 1, &gn_RIP_NODE[10]);
MAKE_VECTOR(gn_RIP_NODE_9_prev, 1, &gn_RIP_NODE[8]);
MAKE_VECTOR(gn_RIP_NODE_10_next, 1, &gn_RIP_NODE[11]);
MAKE_VECTOR(gn_RIP_NODE_10_prev, 1, &gn_RIP_NODE[9]);
MAKE_VECTOR(gn_RIP_NODE_11_next, 2, &gn_RIP_NODE[12], &gn_RIP_NODE[13]);
MAKE_VECTOR(gn_RIP_NODE_11_prev, 1, &gn_RIP_NODE[10]);
MAKE_VECTOR(gn_RIP_NODE_12_next, 1, &gn_RIP_NODE[13]);
MAKE_VECTOR(gn_RIP_NODE_12_prev, 1, &gn_RIP_NODE[11]);
MAKE_VECTOR(gn_RIP_NODE_13_next, 1, &gn_RIP_NODE[14]);
MAKE_VECTOR(gn_RIP_NODE_13_prev, 2, &gn_RIP_NODE[12], &gn_RIP_NODE[11]);
MAKE_VECTOR(gn_RIP_NODE_14_next, 1, &gn_RIP_NODE[15]);
MAKE_VECTOR(gn_RIP_NODE_14_prev, 1, &gn_RIP_NODE[13]);
MAKE_VECTOR(gn_RIP_NODE_15_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_15_prev, 1, &gn_RIP_NODE[14]);
MAKE_VECTOR(gn_RIP_NODE_16_next, 1, &gn_RIP_NODE[17]);
MAKE_VECTOR(gn_RIP_NODE_16_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_17_next, 1, &gn_RIP_NODE[18]);
MAKE_VECTOR(gn_RIP_NODE_17_prev, 1, &gn_RIP_NODE[16]);
MAKE_VECTOR(gn_RIP_NODE_18_next, 1, &gn_RIP_NODE[19]);
MAKE_VECTOR(gn_RIP_NODE_18_prev, 1, &gn_RIP_NODE[17]);
MAKE_VECTOR(gn_RIP_NODE_19_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_19_prev, 1, &gn_RIP_NODE[18]);
MAKE_VECTOR(gn_RIP_NODE_20_next, 2, &gn_RIP_NODE[21], &gn_RIP_NODE[24]);
MAKE_VECTOR(gn_RIP_NODE_20_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_21_next, 1, &gn_RIP_NODE[22]);
MAKE_VECTOR(gn_RIP_NODE_21_prev, 1, &gn_RIP_NODE[20]);
MAKE_VECTOR(gn_RIP_NODE_22_next, 1, &gn_RIP_NODE[23]);
MAKE_VECTOR(gn_RIP_NODE_22_prev, 1, &gn_RIP_NODE[21]);
MAKE_VECTOR(gn_RIP_NODE_23_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_23_prev, 1, &gn_RIP_NODE[22]);
MAKE_VECTOR(gn_RIP_NODE_24_next, 1, &gn_RIP_NODE[25]);
MAKE_VECTOR(gn_RIP_NODE_24_prev, 1, &gn_RIP_NODE[20]);
MAKE_VECTOR(gn_RIP_NODE_25_next, 1, &gn_RIP_NODE[26]);
MAKE_VECTOR(gn_RIP_NODE_25_prev, 1, &gn_RIP_NODE[24]);
MAKE_VECTOR(gn_RIP_NODE_26_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_26_prev, 1, &gn_RIP_NODE[25]);
MAKE_VECTOR(gn_RIP_NODE_27_next, 1, &gn_RIP_NODE[28]);
MAKE_VECTOR(gn_RIP_NODE_27_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_28_next, 1, &gn_RIP_NODE[29]);
MAKE_VECTOR(gn_RIP_NODE_28_prev, 1, &gn_RIP_NODE[27]);
MAKE_VECTOR(gn_RIP_NODE_29_next, 2, &gn_RIP_NODE[30], &gn_RIP_NODE[38]);
MAKE_VECTOR(gn_RIP_NODE_29_prev, 1, &gn_RIP_NODE[28]);
MAKE_VECTOR(gn_RIP_NODE_30_next, 1, &gn_RIP_NODE[31]);
MAKE_VECTOR(gn_RIP_NODE_30_prev, 1, &gn_RIP_NODE[29]);
MAKE_VECTOR(gn_RIP_NODE_31_next, 1, &gn_RIP_NODE[32]);
MAKE_VECTOR(gn_RIP_NODE_31_prev, 2, &gn_RIP_NODE[30], &gn_RIP_NODE[38]);
MAKE_VECTOR(gn_RIP_NODE_32_next, 1, &gn_RIP_NODE[33]);
MAKE_VECTOR(gn_RIP_NODE_32_prev, 1, &gn_RIP_NODE[31]);
MAKE_VECTOR(gn_RIP_NODE_33_next, 2, &gn_RIP_NODE[34], &gn_RIP_NODE[35]);
MAKE_VECTOR(gn_RIP_NODE_33_prev, 1, &gn_RIP_NODE[32]);
MAKE_VECTOR(gn_RIP_NODE_34_next, 1, &gn_RIP_NODE[35]);
MAKE_VECTOR(gn_RIP_NODE_34_prev, 1, &gn_RIP_NODE[33]);
MAKE_VECTOR(gn_RIP_NODE_35_next, 1, &gn_RIP_NODE[36]);
MAKE_VECTOR(gn_RIP_NODE_35_prev, 2, &gn_RIP_NODE[34], &gn_RIP_NODE[33]);
MAKE_VECTOR(gn_RIP_NODE_36_next, 1, &gn_RIP_NODE[37]);
MAKE_VECTOR(gn_RIP_NODE_36_prev, 1, &gn_RIP_NODE[35]);
MAKE_VECTOR(gn_RIP_NODE_37_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_37_prev, 1, &gn_RIP_NODE[36]);
MAKE_VECTOR(gn_RIP_NODE_38_next, 1, &gn_RIP_NODE[31]);
MAKE_VECTOR(gn_RIP_NODE_38_prev, 1, &gn_RIP_NODE[29]);
MAKE_VECTOR(gn_RIP_NODE_39_next, 2, &gn_RIP_NODE[40], &gn_RIP_NODE[43]);
MAKE_VECTOR(gn_RIP_NODE_39_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_40_next, 1, &gn_RIP_NODE[41]);
MAKE_VECTOR(gn_RIP_NODE_40_prev, 1, &gn_RIP_NODE[39]);
MAKE_VECTOR(gn_RIP_NODE_41_next, 1, &gn_RIP_NODE[42]);
MAKE_VECTOR(gn_RIP_NODE_41_prev, 1, &gn_RIP_NODE[40]);
MAKE_VECTOR(gn_RIP_NODE_42_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_42_prev, 1, &gn_RIP_NODE[41]);
MAKE_VECTOR(gn_RIP_NODE_43_next, 1, &gn_RIP_NODE[44]);
MAKE_VECTOR(gn_RIP_NODE_43_prev, 1, &gn_RIP_NODE[39]);
MAKE_VECTOR(gn_RIP_NODE_44_next, 1, &gn_RIP_NODE[45]);
MAKE_VECTOR(gn_RIP_NODE_44_prev, 1, &gn_RIP_NODE[43]);
MAKE_VECTOR(gn_RIP_NODE_45_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_45_prev, 1, &gn_RIP_NODE[44]);
MAKE_VECTOR(gn_RIP_NODE_46_next, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_46_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_47_next, 12, &gn_RIP_NODE[48], &gn_RIP_NODE[60], &gn_RIP_NODE[61], &gn_RIP_NODE[62], &gn_RIP_NODE[63], &gn_RIP_NODE[64], &gn_RIP_NODE[65], &gn_RIP_NODE[66], &gn_RIP_NODE[67], &gn_RIP_NODE[68], &gn_RIP_NODE[69], &gn_RIP_NODE[70]);
MAKE_VECTOR(gn_RIP_NODE_47_prev, 1, &gn_RIP_NODE[46]);
MAKE_VECTOR(gn_RIP_NODE_48_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_48_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_49_next, 1, &gn_RIP_NODE[50]);
MAKE_VECTOR(gn_RIP_NODE_49_prev, 12, &gn_RIP_NODE[48], &gn_RIP_NODE[60], &gn_RIP_NODE[61], &gn_RIP_NODE[62], &gn_RIP_NODE[63], &gn_RIP_NODE[64], &gn_RIP_NODE[65], &gn_RIP_NODE[66], &gn_RIP_NODE[67], &gn_RIP_NODE[68], &gn_RIP_NODE[69], &gn_RIP_NODE[70]);
MAKE_VECTOR(gn_RIP_NODE_50_next, 2, &gn_RIP_NODE[51], &gn_RIP_NODE[55]);
MAKE_VECTOR(gn_RIP_NODE_50_prev, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_51_next, 2, &gn_RIP_NODE[52], &gn_RIP_NODE[58]);
MAKE_VECTOR(gn_RIP_NODE_51_prev, 2, &gn_RIP_NODE[54], &gn_RIP_NODE[50]);
MAKE_VECTOR(gn_RIP_NODE_52_next, 1, &gn_RIP_NODE[53]);
MAKE_VECTOR(gn_RIP_NODE_52_prev, 1, &gn_RIP_NODE[51]);
MAKE_VECTOR(gn_RIP_NODE_53_next, 1, &gn_RIP_NODE[54]);
MAKE_VECTOR(gn_RIP_NODE_53_prev, 1, &gn_RIP_NODE[52]);
MAKE_VECTOR(gn_RIP_NODE_54_next, 2, &gn_RIP_NODE[51], &gn_RIP_NODE[55]);
MAKE_VECTOR(gn_RIP_NODE_54_prev, 2, &gn_RIP_NODE[53], &gn_RIP_NODE[59]);
MAKE_VECTOR(gn_RIP_NODE_55_next, 1, &gn_RIP_NODE[56]);
MAKE_VECTOR(gn_RIP_NODE_55_prev, 2, &gn_RIP_NODE[54], &gn_RIP_NODE[50]);
MAKE_VECTOR(gn_RIP_NODE_56_next, 1, &gn_RIP_NODE[57]);
MAKE_VECTOR(gn_RIP_NODE_56_prev, 1, &gn_RIP_NODE[55]);
MAKE_VECTOR(gn_RIP_NODE_57_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_57_prev, 1, &gn_RIP_NODE[56]);
MAKE_VECTOR(gn_RIP_NODE_58_next, 1, &gn_RIP_NODE[59]);
MAKE_VECTOR(gn_RIP_NODE_58_prev, 1, &gn_RIP_NODE[51]);
MAKE_VECTOR(gn_RIP_NODE_59_next, 1, &gn_RIP_NODE[54]);
MAKE_VECTOR(gn_RIP_NODE_59_prev, 1, &gn_RIP_NODE[58]);
MAKE_VECTOR(gn_RIP_NODE_60_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_60_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_61_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_61_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_62_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_62_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_63_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_63_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_64_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_64_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_65_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_65_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_66_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_66_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_67_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_67_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_68_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_68_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_69_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_69_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_70_next, 1, &gn_RIP_NODE[49]);
MAKE_VECTOR(gn_RIP_NODE_70_prev, 1, &gn_RIP_NODE[47]);
MAKE_VECTOR(gn_RIP_NODE_71_next, 1, &gn_RIP_NODE[72]);
MAKE_VECTOR(gn_RIP_NODE_71_prev, 1, &gn_RIP_NODE[3]);
MAKE_VECTOR(gn_RIP_NODE_72_next, 1, &gn_RIP_NODE[73]);
MAKE_VECTOR(gn_RIP_NODE_72_prev, 1, &gn_RIP_NODE[71]);
MAKE_VECTOR(gn_RIP_NODE_73_next, 1, &gn_RIP_NODE[74]);
MAKE_VECTOR(gn_RIP_NODE_73_prev, 1, &gn_RIP_NODE[72]);
MAKE_VECTOR(gn_RIP_NODE_74_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_74_prev, 1, &gn_RIP_NODE[73]);
MAKE_VECTOR(gn_RIP_NODE_75_next, 1, &gn_RIP_NODE[76]);
MAKE_VECTOR(gn_RIP_NODE_75_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_76_next, 2, &gn_RIP_NODE[77], &gn_RIP_NODE[78]);
MAKE_VECTOR(gn_RIP_NODE_76_prev, 1, &gn_RIP_NODE[75]);
MAKE_VECTOR(gn_RIP_NODE_77_next, 1, &gn_RIP_NODE[78]);
MAKE_VECTOR(gn_RIP_NODE_77_prev, 1, &gn_RIP_NODE[76]);
MAKE_VECTOR(gn_RIP_NODE_78_next, 1, &gn_RIP_NODE[79]);
MAKE_VECTOR(gn_RIP_NODE_78_prev, 2, &gn_RIP_NODE[77], &gn_RIP_NODE[76]);
MAKE_VECTOR(gn_RIP_NODE_79_next, 1, &gn_RIP_NODE[80]);
MAKE_VECTOR(gn_RIP_NODE_79_prev, 1, &gn_RIP_NODE[78]);
MAKE_VECTOR(gn_RIP_NODE_80_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_80_prev, 1, &gn_RIP_NODE[79]);
MAKE_VECTOR(gn_RIP_NODE_81_next, 1, &gn_RIP_NODE[82]);
MAKE_VECTOR(gn_RIP_NODE_81_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_82_next, 1, &gn_RIP_NODE[83]);
MAKE_VECTOR(gn_RIP_NODE_82_prev, 1, &gn_RIP_NODE[81]);
MAKE_VECTOR(gn_RIP_NODE_83_next, 1, &gn_RIP_NODE[84]);
MAKE_VECTOR(gn_RIP_NODE_83_prev, 1, &gn_RIP_NODE[82]);
MAKE_VECTOR(gn_RIP_NODE_84_next, 1, &gn_RIP_NODE[85]);
MAKE_VECTOR(gn_RIP_NODE_84_prev, 1, &gn_RIP_NODE[83]);
MAKE_VECTOR(gn_RIP_NODE_85_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_85_prev, 1, &gn_RIP_NODE[84]);
MAKE_VECTOR(gn_RIP_NODE_86_next, 1, &gn_RIP_NODE[87]);
MAKE_VECTOR(gn_RIP_NODE_86_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_87_next, 1, &gn_RIP_NODE[88]);
MAKE_VECTOR(gn_RIP_NODE_87_prev, 1, &gn_RIP_NODE[86]);
MAKE_VECTOR(gn_RIP_NODE_88_next, 1, &gn_RIP_NODE[89]);
MAKE_VECTOR(gn_RIP_NODE_88_prev, 1, &gn_RIP_NODE[87]);
MAKE_VECTOR(gn_RIP_NODE_89_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_89_prev, 1, &gn_RIP_NODE[88]);
MAKE_VECTOR(gn_RIP_NODE_90_next, 1, &gn_RIP_NODE[91]);
MAKE_VECTOR(gn_RIP_NODE_90_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_91_next, 1, &gn_RIP_NODE[92]);
MAKE_VECTOR(gn_RIP_NODE_91_prev, 1, &gn_RIP_NODE[90]);
MAKE_VECTOR(gn_RIP_NODE_92_next, 1, &gn_RIP_NODE[93]);
MAKE_VECTOR(gn_RIP_NODE_92_prev, 1, &gn_RIP_NODE[91]);
MAKE_VECTOR(gn_RIP_NODE_93_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_93_prev, 1, &gn_RIP_NODE[92]);
MAKE_VECTOR(gn_RIP_NODE_94_next, 2, &gn_RIP_NODE[95], &gn_RIP_NODE[105]);
MAKE_VECTOR(gn_RIP_NODE_94_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_95_next, 1, &gn_RIP_NODE[96]);
MAKE_VECTOR(gn_RIP_NODE_95_prev, 1, &gn_RIP_NODE[94]);
MAKE_VECTOR(gn_RIP_NODE_96_next, 2, &gn_RIP_NODE[97], &gn_RIP_NODE[104]);
MAKE_VECTOR(gn_RIP_NODE_96_prev, 1, &gn_RIP_NODE[95]);
MAKE_VECTOR(gn_RIP_NODE_97_next, 1, &gn_RIP_NODE[98]);
MAKE_VECTOR(gn_RIP_NODE_97_prev, 1, &gn_RIP_NODE[96]);
MAKE_VECTOR(gn_RIP_NODE_98_next, 1, &gn_RIP_NODE[99]);
MAKE_VECTOR(gn_RIP_NODE_98_prev, 2, &gn_RIP_NODE[97], &gn_RIP_NODE[104]);
MAKE_VECTOR(gn_RIP_NODE_99_next, 2, &gn_RIP_NODE[100], &gn_RIP_NODE[101]);
MAKE_VECTOR(gn_RIP_NODE_99_prev, 1, &gn_RIP_NODE[98]);
MAKE_VECTOR(gn_RIP_NODE_100_next, 1, &gn_RIP_NODE[101]);
MAKE_VECTOR(gn_RIP_NODE_100_prev, 1, &gn_RIP_NODE[99]);
MAKE_VECTOR(gn_RIP_NODE_101_next, 1, &gn_RIP_NODE[102]);
MAKE_VECTOR(gn_RIP_NODE_101_prev, 2, &gn_RIP_NODE[100], &gn_RIP_NODE[99]);
MAKE_VECTOR(gn_RIP_NODE_102_next, 1, &gn_RIP_NODE[103]);
MAKE_VECTOR(gn_RIP_NODE_102_prev, 1, &gn_RIP_NODE[101]);
MAKE_VECTOR(gn_RIP_NODE_103_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_103_prev, 1, &gn_RIP_NODE[102]);
MAKE_VECTOR(gn_RIP_NODE_104_next, 1, &gn_RIP_NODE[98]);
MAKE_VECTOR(gn_RIP_NODE_104_prev, 1, &gn_RIP_NODE[96]);
MAKE_VECTOR(gn_RIP_NODE_105_next, 1, &gn_RIP_NODE[106]);
MAKE_VECTOR(gn_RIP_NODE_105_prev, 1, &gn_RIP_NODE[94]);
MAKE_VECTOR(gn_RIP_NODE_106_next, 1, &gn_RIP_NODE[107]);
MAKE_VECTOR(gn_RIP_NODE_106_prev, 1, &gn_RIP_NODE[105]);
MAKE_VECTOR(gn_RIP_NODE_107_next, 2, &gn_RIP_NODE[108], &gn_RIP_NODE[115]);
MAKE_VECTOR(gn_RIP_NODE_107_prev, 1, &gn_RIP_NODE[106]);
MAKE_VECTOR(gn_RIP_NODE_108_next, 1, &gn_RIP_NODE[109]);
MAKE_VECTOR(gn_RIP_NODE_108_prev, 1, &gn_RIP_NODE[107]);
MAKE_VECTOR(gn_RIP_NODE_109_next, 1, &gn_RIP_NODE[110]);
MAKE_VECTOR(gn_RIP_NODE_109_prev, 2, &gn_RIP_NODE[108], &gn_RIP_NODE[115]);
MAKE_VECTOR(gn_RIP_NODE_110_next, 2, &gn_RIP_NODE[111], &gn_RIP_NODE[112]);
MAKE_VECTOR(gn_RIP_NODE_110_prev, 1, &gn_RIP_NODE[109]);
MAKE_VECTOR(gn_RIP_NODE_111_next, 1, &gn_RIP_NODE[112]);
MAKE_VECTOR(gn_RIP_NODE_111_prev, 1, &gn_RIP_NODE[110]);
MAKE_VECTOR(gn_RIP_NODE_112_next, 1, &gn_RIP_NODE[113]);
MAKE_VECTOR(gn_RIP_NODE_112_prev, 2, &gn_RIP_NODE[111], &gn_RIP_NODE[110]);
MAKE_VECTOR(gn_RIP_NODE_113_next, 1, &gn_RIP_NODE[114]);
MAKE_VECTOR(gn_RIP_NODE_113_prev, 1, &gn_RIP_NODE[112]);
MAKE_VECTOR(gn_RIP_NODE_114_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_114_prev, 1, &gn_RIP_NODE[113]);
MAKE_VECTOR(gn_RIP_NODE_115_next, 1, &gn_RIP_NODE[109]);
MAKE_VECTOR(gn_RIP_NODE_115_prev, 1, &gn_RIP_NODE[107]);
MAKE_VECTOR(gn_RIP_NODE_116_next, 8, &gn_RIP_NODE[117], &gn_RIP_NODE[123], &gn_RIP_NODE[130], &gn_RIP_NODE[136], &gn_RIP_NODE[142], &gn_RIP_NODE[168], &gn_RIP_NODE[179], &gn_RIP_NODE[188]);
MAKE_VECTOR(gn_RIP_NODE_116_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_117_next, 1, &gn_RIP_NODE[118]);
MAKE_VECTOR(gn_RIP_NODE_117_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_118_next, 2, &gn_RIP_NODE[119], &gn_RIP_NODE[120]);
MAKE_VECTOR(gn_RIP_NODE_118_prev, 1, &gn_RIP_NODE[117]);
MAKE_VECTOR(gn_RIP_NODE_119_next, 1, &gn_RIP_NODE[120]);
MAKE_VECTOR(gn_RIP_NODE_119_prev, 1, &gn_RIP_NODE[118]);
MAKE_VECTOR(gn_RIP_NODE_120_next, 1, &gn_RIP_NODE[121]);
MAKE_VECTOR(gn_RIP_NODE_120_prev, 2, &gn_RIP_NODE[119], &gn_RIP_NODE[118]);
MAKE_VECTOR(gn_RIP_NODE_121_next, 1, &gn_RIP_NODE[122]);
MAKE_VECTOR(gn_RIP_NODE_121_prev, 1, &gn_RIP_NODE[120]);
MAKE_VECTOR(gn_RIP_NODE_122_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_122_prev, 1, &gn_RIP_NODE[121]);
MAKE_VECTOR(gn_RIP_NODE_123_next, 1, &gn_RIP_NODE[124]);
MAKE_VECTOR(gn_RIP_NODE_123_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_124_next, 1, &gn_RIP_NODE[125]);
MAKE_VECTOR(gn_RIP_NODE_124_prev, 1, &gn_RIP_NODE[123]);
MAKE_VECTOR(gn_RIP_NODE_125_next, 2, &gn_RIP_NODE[126], &gn_RIP_NODE[127]);
MAKE_VECTOR(gn_RIP_NODE_125_prev, 1, &gn_RIP_NODE[124]);
MAKE_VECTOR(gn_RIP_NODE_126_next, 1, &gn_RIP_NODE[127]);
MAKE_VECTOR(gn_RIP_NODE_126_prev, 1, &gn_RIP_NODE[125]);
MAKE_VECTOR(gn_RIP_NODE_127_next, 1, &gn_RIP_NODE[128]);
MAKE_VECTOR(gn_RIP_NODE_127_prev, 2, &gn_RIP_NODE[126], &gn_RIP_NODE[125]);
MAKE_VECTOR(gn_RIP_NODE_128_next, 1, &gn_RIP_NODE[129]);
MAKE_VECTOR(gn_RIP_NODE_128_prev, 1, &gn_RIP_NODE[127]);
MAKE_VECTOR(gn_RIP_NODE_129_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_129_prev, 1, &gn_RIP_NODE[128]);
MAKE_VECTOR(gn_RIP_NODE_130_next, 1, &gn_RIP_NODE[131]);
MAKE_VECTOR(gn_RIP_NODE_130_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_131_next, 2, &gn_RIP_NODE[132], &gn_RIP_NODE[133]);
MAKE_VECTOR(gn_RIP_NODE_131_prev, 1, &gn_RIP_NODE[130]);
MAKE_VECTOR(gn_RIP_NODE_132_next, 1, &gn_RIP_NODE[133]);
MAKE_VECTOR(gn_RIP_NODE_132_prev, 1, &gn_RIP_NODE[131]);
MAKE_VECTOR(gn_RIP_NODE_133_next, 1, &gn_RIP_NODE[134]);
MAKE_VECTOR(gn_RIP_NODE_133_prev, 2, &gn_RIP_NODE[132], &gn_RIP_NODE[131]);
MAKE_VECTOR(gn_RIP_NODE_134_next, 1, &gn_RIP_NODE[135]);
MAKE_VECTOR(gn_RIP_NODE_134_prev, 1, &gn_RIP_NODE[133]);
MAKE_VECTOR(gn_RIP_NODE_135_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_135_prev, 1, &gn_RIP_NODE[134]);
MAKE_VECTOR(gn_RIP_NODE_136_next, 1, &gn_RIP_NODE[137]);
MAKE_VECTOR(gn_RIP_NODE_136_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_137_next, 2, &gn_RIP_NODE[138], &gn_RIP_NODE[139]);
MAKE_VECTOR(gn_RIP_NODE_137_prev, 1, &gn_RIP_NODE[136]);
MAKE_VECTOR(gn_RIP_NODE_138_next, 1, &gn_RIP_NODE[139]);
MAKE_VECTOR(gn_RIP_NODE_138_prev, 1, &gn_RIP_NODE[137]);
MAKE_VECTOR(gn_RIP_NODE_139_next, 1, &gn_RIP_NODE[140]);
MAKE_VECTOR(gn_RIP_NODE_139_prev, 2, &gn_RIP_NODE[138], &gn_RIP_NODE[137]);
MAKE_VECTOR(gn_RIP_NODE_140_next, 1, &gn_RIP_NODE[141]);
MAKE_VECTOR(gn_RIP_NODE_140_prev, 1, &gn_RIP_NODE[139]);
MAKE_VECTOR(gn_RIP_NODE_141_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_141_prev, 1, &gn_RIP_NODE[140]);
MAKE_VECTOR(gn_RIP_NODE_142_next, 2, &gn_RIP_NODE[143], &gn_RIP_NODE[155]);
MAKE_VECTOR(gn_RIP_NODE_142_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_143_next, 2, &gn_RIP_NODE[144], &gn_RIP_NODE[145]);
MAKE_VECTOR(gn_RIP_NODE_143_prev, 1, &gn_RIP_NODE[142]);
MAKE_VECTOR(gn_RIP_NODE_144_next, 1, &gn_RIP_NODE[145]);
MAKE_VECTOR(gn_RIP_NODE_144_prev, 1, &gn_RIP_NODE[143]);
MAKE_VECTOR(gn_RIP_NODE_145_next, 1, &gn_RIP_NODE[146]);
MAKE_VECTOR(gn_RIP_NODE_145_prev, 2, &gn_RIP_NODE[144], &gn_RIP_NODE[143]);
MAKE_VECTOR(gn_RIP_NODE_146_next, 2, &gn_RIP_NODE[147], &gn_RIP_NODE[154]);
MAKE_VECTOR(gn_RIP_NODE_146_prev, 1, &gn_RIP_NODE[145]);
MAKE_VECTOR(gn_RIP_NODE_147_next, 1, &gn_RIP_NODE[148]);
MAKE_VECTOR(gn_RIP_NODE_147_prev, 1, &gn_RIP_NODE[146]);
MAKE_VECTOR(gn_RIP_NODE_148_next, 1, &gn_RIP_NODE[149]);
MAKE_VECTOR(gn_RIP_NODE_148_prev, 2, &gn_RIP_NODE[147], &gn_RIP_NODE[154]);
MAKE_VECTOR(gn_RIP_NODE_149_next, 2, &gn_RIP_NODE[150], &gn_RIP_NODE[151]);
MAKE_VECTOR(gn_RIP_NODE_149_prev, 1, &gn_RIP_NODE[148]);
MAKE_VECTOR(gn_RIP_NODE_150_next, 1, &gn_RIP_NODE[151]);
MAKE_VECTOR(gn_RIP_NODE_150_prev, 1, &gn_RIP_NODE[149]);
MAKE_VECTOR(gn_RIP_NODE_151_next, 1, &gn_RIP_NODE[152]);
MAKE_VECTOR(gn_RIP_NODE_151_prev, 2, &gn_RIP_NODE[150], &gn_RIP_NODE[149]);
MAKE_VECTOR(gn_RIP_NODE_152_next, 1, &gn_RIP_NODE[153]);
MAKE_VECTOR(gn_RIP_NODE_152_prev, 1, &gn_RIP_NODE[151]);
MAKE_VECTOR(gn_RIP_NODE_153_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_153_prev, 1, &gn_RIP_NODE[152]);
MAKE_VECTOR(gn_RIP_NODE_154_next, 1, &gn_RIP_NODE[148]);
MAKE_VECTOR(gn_RIP_NODE_154_prev, 1, &gn_RIP_NODE[146]);
MAKE_VECTOR(gn_RIP_NODE_155_next, 1, &gn_RIP_NODE[156]);
MAKE_VECTOR(gn_RIP_NODE_155_prev, 1, &gn_RIP_NODE[142]);
MAKE_VECTOR(gn_RIP_NODE_156_next, 2, &gn_RIP_NODE[157], &gn_RIP_NODE[158]);
MAKE_VECTOR(gn_RIP_NODE_156_prev, 1, &gn_RIP_NODE[155]);
MAKE_VECTOR(gn_RIP_NODE_157_next, 1, &gn_RIP_NODE[158]);
MAKE_VECTOR(gn_RIP_NODE_157_prev, 1, &gn_RIP_NODE[156]);
MAKE_VECTOR(gn_RIP_NODE_158_next, 1, &gn_RIP_NODE[159]);
MAKE_VECTOR(gn_RIP_NODE_158_prev, 2, &gn_RIP_NODE[157], &gn_RIP_NODE[156]);
MAKE_VECTOR(gn_RIP_NODE_159_next, 2, &gn_RIP_NODE[160], &gn_RIP_NODE[167]);
MAKE_VECTOR(gn_RIP_NODE_159_prev, 1, &gn_RIP_NODE[158]);
MAKE_VECTOR(gn_RIP_NODE_160_next, 1, &gn_RIP_NODE[161]);
MAKE_VECTOR(gn_RIP_NODE_160_prev, 1, &gn_RIP_NODE[159]);
MAKE_VECTOR(gn_RIP_NODE_161_next, 1, &gn_RIP_NODE[162]);
MAKE_VECTOR(gn_RIP_NODE_161_prev, 2, &gn_RIP_NODE[160], &gn_RIP_NODE[167]);
MAKE_VECTOR(gn_RIP_NODE_162_next, 2, &gn_RIP_NODE[163], &gn_RIP_NODE[164]);
MAKE_VECTOR(gn_RIP_NODE_162_prev, 1, &gn_RIP_NODE[161]);
MAKE_VECTOR(gn_RIP_NODE_163_next, 1, &gn_RIP_NODE[164]);
MAKE_VECTOR(gn_RIP_NODE_163_prev, 1, &gn_RIP_NODE[162]);
MAKE_VECTOR(gn_RIP_NODE_164_next, 1, &gn_RIP_NODE[165]);
MAKE_VECTOR(gn_RIP_NODE_164_prev, 2, &gn_RIP_NODE[163], &gn_RIP_NODE[162]);
MAKE_VECTOR(gn_RIP_NODE_165_next, 1, &gn_RIP_NODE[166]);
MAKE_VECTOR(gn_RIP_NODE_165_prev, 1, &gn_RIP_NODE[164]);
MAKE_VECTOR(gn_RIP_NODE_166_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_166_prev, 1, &gn_RIP_NODE[165]);
MAKE_VECTOR(gn_RIP_NODE_167_next, 1, &gn_RIP_NODE[161]);
MAKE_VECTOR(gn_RIP_NODE_167_prev, 1, &gn_RIP_NODE[159]);
MAKE_VECTOR(gn_RIP_NODE_168_next, 1, &gn_RIP_NODE[169]);
MAKE_VECTOR(gn_RIP_NODE_168_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_169_next, 2, &gn_RIP_NODE[170], &gn_RIP_NODE[171]);
MAKE_VECTOR(gn_RIP_NODE_169_prev, 1, &gn_RIP_NODE[168]);
MAKE_VECTOR(gn_RIP_NODE_170_next, 1, &gn_RIP_NODE[171]);
MAKE_VECTOR(gn_RIP_NODE_170_prev, 1, &gn_RIP_NODE[169]);
MAKE_VECTOR(gn_RIP_NODE_171_next, 1, &gn_RIP_NODE[172]);
MAKE_VECTOR(gn_RIP_NODE_171_prev, 2, &gn_RIP_NODE[170], &gn_RIP_NODE[169]);
MAKE_VECTOR(gn_RIP_NODE_172_next, 2, &gn_RIP_NODE[173], &gn_RIP_NODE[178]);
MAKE_VECTOR(gn_RIP_NODE_172_prev, 1, &gn_RIP_NODE[171]);
MAKE_VECTOR(gn_RIP_NODE_173_next, 1, &gn_RIP_NODE[174]);
MAKE_VECTOR(gn_RIP_NODE_173_prev, 1, &gn_RIP_NODE[172]);
MAKE_VECTOR(gn_RIP_NODE_174_next, 1, &gn_RIP_NODE[175]);
MAKE_VECTOR(gn_RIP_NODE_174_prev, 2, &gn_RIP_NODE[173], &gn_RIP_NODE[178]);
MAKE_VECTOR(gn_RIP_NODE_175_next, 1, &gn_RIP_NODE[176]);
MAKE_VECTOR(gn_RIP_NODE_175_prev, 1, &gn_RIP_NODE[174]);
MAKE_VECTOR(gn_RIP_NODE_176_next, 1, &gn_RIP_NODE[177]);
MAKE_VECTOR(gn_RIP_NODE_176_prev, 1, &gn_RIP_NODE[175]);
MAKE_VECTOR(gn_RIP_NODE_177_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_177_prev, 1, &gn_RIP_NODE[176]);
MAKE_VECTOR(gn_RIP_NODE_178_next, 1, &gn_RIP_NODE[174]);
MAKE_VECTOR(gn_RIP_NODE_178_prev, 1, &gn_RIP_NODE[172]);
MAKE_VECTOR(gn_RIP_NODE_179_next, 1, &gn_RIP_NODE[180]);
MAKE_VECTOR(gn_RIP_NODE_179_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_180_next, 1, &gn_RIP_NODE[181]);
MAKE_VECTOR(gn_RIP_NODE_180_prev, 1, &gn_RIP_NODE[179]);
MAKE_VECTOR(gn_RIP_NODE_181_next, 2, &gn_RIP_NODE[182], &gn_RIP_NODE[185]);
MAKE_VECTOR(gn_RIP_NODE_181_prev, 1, &gn_RIP_NODE[180]);
MAKE_VECTOR(gn_RIP_NODE_182_next, 1, &gn_RIP_NODE[183]);
MAKE_VECTOR(gn_RIP_NODE_182_prev, 1, &gn_RIP_NODE[181]);
MAKE_VECTOR(gn_RIP_NODE_183_next, 1, &gn_RIP_NODE[184]);
MAKE_VECTOR(gn_RIP_NODE_183_prev, 1, &gn_RIP_NODE[182]);
MAKE_VECTOR(gn_RIP_NODE_184_next, 1, &gn_RIP_NODE[185]);
MAKE_VECTOR(gn_RIP_NODE_184_prev, 1, &gn_RIP_NODE[183]);
MAKE_VECTOR(gn_RIP_NODE_185_next, 1, &gn_RIP_NODE[186]);
MAKE_VECTOR(gn_RIP_NODE_185_prev, 2, &gn_RIP_NODE[184], &gn_RIP_NODE[181]);
MAKE_VECTOR(gn_RIP_NODE_186_next, 1, &gn_RIP_NODE[187]);
MAKE_VECTOR(gn_RIP_NODE_186_prev, 1, &gn_RIP_NODE[185]);
MAKE_VECTOR(gn_RIP_NODE_187_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_187_prev, 1, &gn_RIP_NODE[186]);
MAKE_VECTOR(gn_RIP_NODE_188_next, 1, &gn_RIP_NODE[189]);
MAKE_VECTOR(gn_RIP_NODE_188_prev, 1, &gn_RIP_NODE[116]);
MAKE_VECTOR(gn_RIP_NODE_189_next, 2, &gn_RIP_NODE[190], &gn_RIP_NODE[191]);
MAKE_VECTOR(gn_RIP_NODE_189_prev, 1, &gn_RIP_NODE[188]);
MAKE_VECTOR(gn_RIP_NODE_190_next, 1, &gn_RIP_NODE[191]);
MAKE_VECTOR(gn_RIP_NODE_190_prev, 1, &gn_RIP_NODE[189]);
MAKE_VECTOR(gn_RIP_NODE_191_next, 1, &gn_RIP_NODE[192]);
MAKE_VECTOR(gn_RIP_NODE_191_prev, 2, &gn_RIP_NODE[190], &gn_RIP_NODE[189]);
MAKE_VECTOR(gn_RIP_NODE_192_next, 1, &gn_RIP_NODE[193]);
MAKE_VECTOR(gn_RIP_NODE_192_prev, 1, &gn_RIP_NODE[191]);
MAKE_VECTOR(gn_RIP_NODE_193_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_193_prev, 1, &gn_RIP_NODE[192]);
MAKE_VECTOR(gn_RIP_NODE_194_next, 1, &gn_RIP_NODE[195]);
MAKE_VECTOR(gn_RIP_NODE_194_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_195_next, 1, &gn_RIP_NODE[196]);
MAKE_VECTOR(gn_RIP_NODE_195_prev, 1, &gn_RIP_NODE[194]);
MAKE_VECTOR(gn_RIP_NODE_196_next, 2, &gn_RIP_NODE[197], &gn_RIP_NODE[202]);
MAKE_VECTOR(gn_RIP_NODE_196_prev, 1, &gn_RIP_NODE[195]);
MAKE_VECTOR(gn_RIP_NODE_197_next, 1, &gn_RIP_NODE[198]);
MAKE_VECTOR(gn_RIP_NODE_197_prev, 1, &gn_RIP_NODE[196]);
MAKE_VECTOR(gn_RIP_NODE_198_next, 1, &gn_RIP_NODE[199]);
MAKE_VECTOR(gn_RIP_NODE_198_prev, 2, &gn_RIP_NODE[197], &gn_RIP_NODE[202]);
MAKE_VECTOR(gn_RIP_NODE_199_next, 1, &gn_RIP_NODE[200]);
MAKE_VECTOR(gn_RIP_NODE_199_prev, 1, &gn_RIP_NODE[198]);
MAKE_VECTOR(gn_RIP_NODE_200_next, 1, &gn_RIP_NODE[201]);
MAKE_VECTOR(gn_RIP_NODE_200_prev, 1, &gn_RIP_NODE[199]);
MAKE_VECTOR(gn_RIP_NODE_201_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_201_prev, 1, &gn_RIP_NODE[200]);
MAKE_VECTOR(gn_RIP_NODE_202_next, 1, &gn_RIP_NODE[198]);
MAKE_VECTOR(gn_RIP_NODE_202_prev, 1, &gn_RIP_NODE[196]);
MAKE_VECTOR(gn_RIP_NODE_203_next, 1, &gn_RIP_NODE[204]);
MAKE_VECTOR(gn_RIP_NODE_203_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_204_next, 1, &gn_RIP_NODE[205]);
MAKE_VECTOR(gn_RIP_NODE_204_prev, 1, &gn_RIP_NODE[203]);
MAKE_VECTOR(gn_RIP_NODE_205_next, 1, &gn_RIP_NODE[206]);
MAKE_VECTOR(gn_RIP_NODE_205_prev, 1, &gn_RIP_NODE[204]);
MAKE_VECTOR(gn_RIP_NODE_206_next, 1, &gn_RIP_NODE[207]);
MAKE_VECTOR(gn_RIP_NODE_206_prev, 1, &gn_RIP_NODE[205]);
MAKE_VECTOR(gn_RIP_NODE_207_next, 1, &gn_RIP_NODE[208]);
MAKE_VECTOR(gn_RIP_NODE_207_prev, 1, &gn_RIP_NODE[206]);
MAKE_VECTOR(gn_RIP_NODE_208_next, 1, &gn_RIP_NODE[209]);
MAKE_VECTOR(gn_RIP_NODE_208_prev, 1, &gn_RIP_NODE[207]);
MAKE_VECTOR(gn_RIP_NODE_209_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_209_prev, 1, &gn_RIP_NODE[208]);
MAKE_VECTOR(gn_RIP_NODE_210_next, 1, &gn_RIP_NODE[211]);
MAKE_VECTOR(gn_RIP_NODE_210_prev, 1, &gn_RIP_NODE[0]);
MAKE_VECTOR(gn_RIP_NODE_211_next, 1, &gn_RIP_NODE[212]);
MAKE_VECTOR(gn_RIP_NODE_211_prev, 1, &gn_RIP_NODE[210]);
MAKE_VECTOR(gn_RIP_NODE_212_next, 1, &gn_RIP_NODE[213]);
MAKE_VECTOR(gn_RIP_NODE_212_prev, 1, &gn_RIP_NODE[211]);
MAKE_VECTOR(gn_RIP_NODE_213_next, 0, );
MAKE_VECTOR(gn_RIP_NODE_213_prev, 1, &gn_RIP_NODE[212]);

static struct graph_node gn_RIP_NODE[] = {
	{
		.from = &gn_RIP_NODE_0_prev,
		.to = &gn_RIP_NODE_0_next,
		.data = &ctkn_RIP_NODE[0],
	},
	{
		.from = &gn_RIP_NODE_1_prev,
		.to = &gn_RIP_NODE_1_next,
		.data = &ctkn_RIP_NODE[1],
	},
	{
		.from = &gn_RIP_NODE_2_prev,
		.to = &gn_RIP_NODE_2_next,
		.data = &ctkn_RIP_NODE[2],
	},
	{
		.from = &gn_RIP_NODE_3_prev,
		.to = &gn_RIP_NODE_3_next,
		.data = &ctkn_RIP_NODE[3],
	},
	{
		.from = &gn_RIP_NODE_4_prev,
		.to = &gn_RIP_NODE_4_next,
		.data = &ctkn_RIP_NODE[4],
	},
	{
		.from = &gn_RIP_NODE_5_prev,
		.to = &gn_RIP_NODE_5_next,
		.data = &ctkn_RIP_NODE[5],
	},
	{
		.from = &gn_RIP_NODE_6_prev,
		.to = &gn_RIP_NODE_6_next,
		.data = &ctkn_RIP_NODE[6],
	},
	{
		.from = &gn_RIP_NODE_7_prev,
		.to = &gn_RIP_NODE_7_next,
		.data = (void *)&rip_default_information_originate_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_8_prev,
		.to = &gn_RIP_NODE_8_next,
		.data = &ctkn_RIP_NODE[8],
	},
	{
		.from = &gn_RIP_NODE_9_prev,
		.to = &gn_RIP_NODE_9_next,
		.data = &ctkn_RIP_NODE[9],
	},
	{
		.from = &gn_RIP_NODE_10_prev,
		.to = &gn_RIP_NODE_10_next,
		.data = &ctkn_RIP_NODE[10],
	},
	{
		.from = &gn_RIP_NODE_11_prev,
		.to = &gn_RIP_NODE_11_next,
		.data = &ctkn_RIP_NODE[11],
	},
	{
		.from = &gn_RIP_NODE_12_prev,
		.to = &gn_RIP_NODE_12_next,
		.data = &ctkn_RIP_NODE[12],
	},
	{
		.from = &gn_RIP_NODE_13_prev,
		.to = &gn_RIP_NODE_13_next,
		.data = &ctkn_RIP_NODE[13],
	},
	{
		.from = &gn_RIP_NODE_14_prev,
		.to = &gn_RIP_NODE_14_next,
		.data = &ctkn_RIP_NODE[14],
	},
	{
		.from = &gn_RIP_NODE_15_prev,
		.to = &gn_RIP_NODE_15_next,
		.data = (void *)&rip_distance_source_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_16_prev,
		.to = &gn_RIP_NODE_16_next,
		.data = &ctkn_RIP_NODE[16],
	},
	{
		.from = &gn_RIP_NODE_17_prev,
		.to = &gn_RIP_NODE_17_next,
		.data = &ctkn_RIP_NODE[17],
	},
	{
		.from = &gn_RIP_NODE_18_prev,
		.to = &gn_RIP_NODE_18_next,
		.data = &ctkn_RIP_NODE[18],
	},
	{
		.from = &gn_RIP_NODE_19_prev,
		.to = &gn_RIP_NODE_19_next,
		.data = (void *)&rip_neighbor_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_20_prev,
		.to = &gn_RIP_NODE_20_next,
		.data = &ctkn_RIP_NODE[20],
	},
	{
		.from = &gn_RIP_NODE_21_prev,
		.to = &gn_RIP_NODE_21_next,
		.data = &ctkn_RIP_NODE[21],
	},
	{
		.from = &gn_RIP_NODE_22_prev,
		.to = &gn_RIP_NODE_22_next,
		.data = &ctkn_RIP_NODE[22],
	},
	{
		.from = &gn_RIP_NODE_23_prev,
		.to = &gn_RIP_NODE_23_next,
		.data = (void *)&rip_network_prefix_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_24_prev,
		.to = &gn_RIP_NODE_24_next,
		.data = &ctkn_RIP_NODE[24],
	},
	{
		.from = &gn_RIP_NODE_25_prev,
		.to = &gn_RIP_NODE_25_next,
		.data = &ctkn_RIP_NODE[25],
	},
	{
		.from = &gn_RIP_NODE_26_prev,
		.to = &gn_RIP_NODE_26_next,
		.data = (void *)&rip_network_if_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_27_prev,
		.to = &gn_RIP_NODE_27_next,
		.data = &ctkn_RIP_NODE[27],
	},
	{
		.from = &gn_RIP_NODE_28_prev,
		.to = &gn_RIP_NODE_28_next,
		.data = &ctkn_RIP_NODE[28],
	},
	{
		.from = &gn_RIP_NODE_29_prev,
		.to = &gn_RIP_NODE_29_next,
		.data = &ctkn_RIP_NODE[29],
	},
	{
		.from = &gn_RIP_NODE_30_prev,
		.to = &gn_RIP_NODE_30_next,
		.data = &ctkn_RIP_NODE[30],
	},
	{
		.from = &gn_RIP_NODE_31_prev,
		.to = &gn_RIP_NODE_31_next,
		.data = &ctkn_RIP_NODE[31],
	},
	{
		.from = &gn_RIP_NODE_32_prev,
		.to = &gn_RIP_NODE_32_next,
		.data = &ctkn_RIP_NODE[32],
	},
	{
		.from = &gn_RIP_NODE_33_prev,
		.to = &gn_RIP_NODE_33_next,
		.data = &ctkn_RIP_NODE[33],
	},
	{
		.from = &gn_RIP_NODE_34_prev,
		.to = &gn_RIP_NODE_34_next,
		.data = &ctkn_RIP_NODE[34],
	},
	{
		.from = &gn_RIP_NODE_35_prev,
		.to = &gn_RIP_NODE_35_next,
		.data = &ctkn_RIP_NODE[35],
	},
	{
		.from = &gn_RIP_NODE_36_prev,
		.to = &gn_RIP_NODE_36_next,
		.data = &ctkn_RIP_NODE[36],
	},
	{
		.from = &gn_RIP_NODE_37_prev,
		.to = &gn_RIP_NODE_37_next,
		.data = (void *)&rip_offset_list_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_38_prev,
		.to = &gn_RIP_NODE_38_next,
		.data = &ctkn_RIP_NODE[38],
	},
	{
		.from = &gn_RIP_NODE_39_prev,
		.to = &gn_RIP_NODE_39_next,
		.data = &ctkn_RIP_NODE[39],
	},
	{
		.from = &gn_RIP_NODE_40_prev,
		.to = &gn_RIP_NODE_40_next,
		.data = &ctkn_RIP_NODE[40],
	},
	{
		.from = &gn_RIP_NODE_41_prev,
		.to = &gn_RIP_NODE_41_next,
		.data = &ctkn_RIP_NODE[41],
	},
	{
		.from = &gn_RIP_NODE_42_prev,
		.to = &gn_RIP_NODE_42_next,
		.data = (void *)&rip_passive_interface_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_43_prev,
		.to = &gn_RIP_NODE_43_next,
		.data = &ctkn_RIP_NODE[43],
	},
	{
		.from = &gn_RIP_NODE_44_prev,
		.to = &gn_RIP_NODE_44_next,
		.data = &ctkn_RIP_NODE[44],
	},
	{
		.from = &gn_RIP_NODE_45_prev,
		.to = &gn_RIP_NODE_45_next,
		.data = (void *)&rip_passive_default_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_46_prev,
		.to = &gn_RIP_NODE_46_next,
		.data = &ctkn_RIP_NODE[46],
	},
	{
		.from = &gn_RIP_NODE_47_prev,
		.to = &gn_RIP_NODE_47_next,
		.data = &ctkn_RIP_NODE[47],
	},
	{
		.from = &gn_RIP_NODE_48_prev,
		.to = &gn_RIP_NODE_48_next,
		.data = &ctkn_RIP_NODE[48],
	},
	{
		.from = &gn_RIP_NODE_49_prev,
		.to = &gn_RIP_NODE_49_next,
		.data = &ctkn_RIP_NODE[49],
	},
	{
		.from = &gn_RIP_NODE_50_prev,
		.to = &gn_RIP_NODE_50_next,
		.data = &ctkn_RIP_NODE[50],
	},
	{
		.from = &gn_RIP_NODE_51_prev,
		.to = &gn_RIP_NODE_51_next,
		.data = &ctkn_RIP_NODE[51],
	},
	{
		.from = &gn_RIP_NODE_52_prev,
		.to = &gn_RIP_NODE_52_next,
		.data = &ctkn_RIP_NODE[52],
	},
	{
		.from = &gn_RIP_NODE_53_prev,
		.to = &gn_RIP_NODE_53_next,
		.data = &ctkn_RIP_NODE[53],
	},
	{
		.from = &gn_RIP_NODE_54_prev,
		.to = &gn_RIP_NODE_54_next,
		.data = &ctkn_RIP_NODE[54],
	},
	{
		.from = &gn_RIP_NODE_55_prev,
		.to = &gn_RIP_NODE_55_next,
		.data = &ctkn_RIP_NODE[55],
	},
	{
		.from = &gn_RIP_NODE_56_prev,
		.to = &gn_RIP_NODE_56_next,
		.data = &ctkn_RIP_NODE[56],
	},
	{
		.from = &gn_RIP_NODE_57_prev,
		.to = &gn_RIP_NODE_57_next,
		.data = (void *)&rip_redistribute_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_58_prev,
		.to = &gn_RIP_NODE_58_next,
		.data = &ctkn_RIP_NODE[58],
	},
	{
		.from = &gn_RIP_NODE_59_prev,
		.to = &gn_RIP_NODE_59_next,
		.data = &ctkn_RIP_NODE[59],
	},
	{
		.from = &gn_RIP_NODE_60_prev,
		.to = &gn_RIP_NODE_60_next,
		.data = &ctkn_RIP_NODE[60],
	},
	{
		.from = &gn_RIP_NODE_61_prev,
		.to = &gn_RIP_NODE_61_next,
		.data = &ctkn_RIP_NODE[61],
	},
	{
		.from = &gn_RIP_NODE_62_prev,
		.to = &gn_RIP_NODE_62_next,
		.data = &ctkn_RIP_NODE[62],
	},
	{
		.from = &gn_RIP_NODE_63_prev,
		.to = &gn_RIP_NODE_63_next,
		.data = &ctkn_RIP_NODE[63],
	},
	{
		.from = &gn_RIP_NODE_64_prev,
		.to = &gn_RIP_NODE_64_next,
		.data = &ctkn_RIP_NODE[64],
	},
	{
		.from = &gn_RIP_NODE_65_prev,
		.to = &gn_RIP_NODE_65_next,
		.data = &ctkn_RIP_NODE[65],
	},
	{
		.from = &gn_RIP_NODE_66_prev,
		.to = &gn_RIP_NODE_66_next,
		.data = &ctkn_RIP_NODE[66],
	},
	{
		.from = &gn_RIP_NODE_67_prev,
		.to = &gn_RIP_NODE_67_next,
		.data = &ctkn_RIP_NODE[67],
	},
	{
		.from = &gn_RIP_NODE_68_prev,
		.to = &gn_RIP_NODE_68_next,
		.data = &ctkn_RIP_NODE[68],
	},
	{
		.from = &gn_RIP_NODE_69_prev,
		.to = &gn_RIP_NODE_69_next,
		.data = &ctkn_RIP_NODE[69],
	},
	{
		.from = &gn_RIP_NODE_70_prev,
		.to = &gn_RIP_NODE_70_next,
		.data = &ctkn_RIP_NODE[70],
	},
	{
		.from = &gn_RIP_NODE_71_prev,
		.to = &gn_RIP_NODE_71_next,
		.data = &ctkn_RIP_NODE[71],
	},
	{
		.from = &gn_RIP_NODE_72_prev,
		.to = &gn_RIP_NODE_72_next,
		.data = &ctkn_RIP_NODE[72],
	},
	{
		.from = &gn_RIP_NODE_73_prev,
		.to = &gn_RIP_NODE_73_next,
		.data = &ctkn_RIP_NODE[73],
	},
	{
		.from = &gn_RIP_NODE_74_prev,
		.to = &gn_RIP_NODE_74_next,
		.data = (void *)&rip_route_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_75_prev,
		.to = &gn_RIP_NODE_75_next,
		.data = &ctkn_RIP_NODE[75],
	},
	{
		.from = &gn_RIP_NODE_76_prev,
		.to = &gn_RIP_NODE_76_next,
		.data = &ctkn_RIP_NODE[76],
	},
	{
		.from = &gn_RIP_NODE_77_prev,
		.to = &gn_RIP_NODE_77_next,
		.data = &ctkn_RIP_NODE[77],
	},
	{
		.from = &gn_RIP_NODE_78_prev,
		.to = &gn_RIP_NODE_78_next,
		.data = &ctkn_RIP_NODE[78],
	},
	{
		.from = &gn_RIP_NODE_79_prev,
		.to = &gn_RIP_NODE_79_next,
		.data = &ctkn_RIP_NODE[79],
	},
	{
		.from = &gn_RIP_NODE_80_prev,
		.to = &gn_RIP_NODE_80_next,
		.data = (void *)&rip_allow_ecmp_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_81_prev,
		.to = &gn_RIP_NODE_81_next,
		.data = &ctkn_RIP_NODE[81],
	},
	{
		.from = &gn_RIP_NODE_82_prev,
		.to = &gn_RIP_NODE_82_next,
		.data = &ctkn_RIP_NODE[82],
	},
	{
		.from = &gn_RIP_NODE_83_prev,
		.to = &gn_RIP_NODE_83_next,
		.data = &ctkn_RIP_NODE[83],
	},
	{
		.from = &gn_RIP_NODE_84_prev,
		.to = &gn_RIP_NODE_84_next,
		.data = &ctkn_RIP_NODE[84],
	},
	{
		.from = &gn_RIP_NODE_85_prev,
		.to = &gn_RIP_NODE_85_next,
		.data = (void *)&rip_bfd_default_profile_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_86_prev,
		.to = &gn_RIP_NODE_86_next,
		.data = &ctkn_RIP_NODE[86],
	},
	{
		.from = &gn_RIP_NODE_87_prev,
		.to = &gn_RIP_NODE_87_next,
		.data = &ctkn_RIP_NODE[87],
	},
	{
		.from = &gn_RIP_NODE_88_prev,
		.to = &gn_RIP_NODE_88_next,
		.data = &ctkn_RIP_NODE[88],
	},
	{
		.from = &gn_RIP_NODE_89_prev,
		.to = &gn_RIP_NODE_89_next,
		.data = (void *)&rip_default_metric_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_90_prev,
		.to = &gn_RIP_NODE_90_next,
		.data = &ctkn_RIP_NODE[90],
	},
	{
		.from = &gn_RIP_NODE_91_prev,
		.to = &gn_RIP_NODE_91_next,
		.data = &ctkn_RIP_NODE[91],
	},
	{
		.from = &gn_RIP_NODE_92_prev,
		.to = &gn_RIP_NODE_92_next,
		.data = &ctkn_RIP_NODE[92],
	},
	{
		.from = &gn_RIP_NODE_93_prev,
		.to = &gn_RIP_NODE_93_next,
		.data = (void *)&rip_distance_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_94_prev,
		.to = &gn_RIP_NODE_94_next,
		.data = &ctkn_RIP_NODE[94],
	},
	{
		.from = &gn_RIP_NODE_95_prev,
		.to = &gn_RIP_NODE_95_next,
		.data = &ctkn_RIP_NODE[95],
	},
	{
		.from = &gn_RIP_NODE_96_prev,
		.to = &gn_RIP_NODE_96_next,
		.data = &ctkn_RIP_NODE[96],
	},
	{
		.from = &gn_RIP_NODE_97_prev,
		.to = &gn_RIP_NODE_97_next,
		.data = &ctkn_RIP_NODE[97],
	},
	{
		.from = &gn_RIP_NODE_98_prev,
		.to = &gn_RIP_NODE_98_next,
		.data = &ctkn_RIP_NODE[98],
	},
	{
		.from = &gn_RIP_NODE_99_prev,
		.to = &gn_RIP_NODE_99_next,
		.data = &ctkn_RIP_NODE[99],
	},
	{
		.from = &gn_RIP_NODE_100_prev,
		.to = &gn_RIP_NODE_100_next,
		.data = &ctkn_RIP_NODE[100],
	},
	{
		.from = &gn_RIP_NODE_101_prev,
		.to = &gn_RIP_NODE_101_next,
		.data = &ctkn_RIP_NODE[101],
	},
	{
		.from = &gn_RIP_NODE_102_prev,
		.to = &gn_RIP_NODE_102_next,
		.data = &ctkn_RIP_NODE[102],
	},
	{
		.from = &gn_RIP_NODE_103_prev,
		.to = &gn_RIP_NODE_103_next,
		.data = (void *)&rip_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_104_prev,
		.to = &gn_RIP_NODE_104_next,
		.data = &ctkn_RIP_NODE[104],
	},
	{
		.from = &gn_RIP_NODE_105_prev,
		.to = &gn_RIP_NODE_105_next,
		.data = &ctkn_RIP_NODE[105],
	},
	{
		.from = &gn_RIP_NODE_106_prev,
		.to = &gn_RIP_NODE_106_next,
		.data = &ctkn_RIP_NODE[106],
	},
	{
		.from = &gn_RIP_NODE_107_prev,
		.to = &gn_RIP_NODE_107_next,
		.data = &ctkn_RIP_NODE[107],
	},
	{
		.from = &gn_RIP_NODE_108_prev,
		.to = &gn_RIP_NODE_108_next,
		.data = &ctkn_RIP_NODE[108],
	},
	{
		.from = &gn_RIP_NODE_109_prev,
		.to = &gn_RIP_NODE_109_next,
		.data = &ctkn_RIP_NODE[109],
	},
	{
		.from = &gn_RIP_NODE_110_prev,
		.to = &gn_RIP_NODE_110_next,
		.data = &ctkn_RIP_NODE[110],
	},
	{
		.from = &gn_RIP_NODE_111_prev,
		.to = &gn_RIP_NODE_111_next,
		.data = &ctkn_RIP_NODE[111],
	},
	{
		.from = &gn_RIP_NODE_112_prev,
		.to = &gn_RIP_NODE_112_next,
		.data = &ctkn_RIP_NODE[112],
	},
	{
		.from = &gn_RIP_NODE_113_prev,
		.to = &gn_RIP_NODE_113_next,
		.data = &ctkn_RIP_NODE[113],
	},
	{
		.from = &gn_RIP_NODE_114_prev,
		.to = &gn_RIP_NODE_114_next,
		.data = (void *)&rip_distribute_list_prefix_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_115_prev,
		.to = &gn_RIP_NODE_115_next,
		.data = &ctkn_RIP_NODE[115],
	},
	{
		.from = &gn_RIP_NODE_116_prev,
		.to = &gn_RIP_NODE_116_next,
		.data = &ctkn_RIP_NODE[116],
	},
	{
		.from = &gn_RIP_NODE_117_prev,
		.to = &gn_RIP_NODE_117_next,
		.data = &ctkn_RIP_NODE[117],
	},
	{
		.from = &gn_RIP_NODE_118_prev,
		.to = &gn_RIP_NODE_118_next,
		.data = &ctkn_RIP_NODE[118],
	},
	{
		.from = &gn_RIP_NODE_119_prev,
		.to = &gn_RIP_NODE_119_next,
		.data = &ctkn_RIP_NODE[119],
	},
	{
		.from = &gn_RIP_NODE_120_prev,
		.to = &gn_RIP_NODE_120_next,
		.data = &ctkn_RIP_NODE[120],
	},
	{
		.from = &gn_RIP_NODE_121_prev,
		.to = &gn_RIP_NODE_121_next,
		.data = &ctkn_RIP_NODE[121],
	},
	{
		.from = &gn_RIP_NODE_122_prev,
		.to = &gn_RIP_NODE_122_next,
		.data = (void *)&no_rip_allow_ecmp_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_123_prev,
		.to = &gn_RIP_NODE_123_next,
		.data = &ctkn_RIP_NODE[123],
	},
	{
		.from = &gn_RIP_NODE_124_prev,
		.to = &gn_RIP_NODE_124_next,
		.data = &ctkn_RIP_NODE[124],
	},
	{
		.from = &gn_RIP_NODE_125_prev,
		.to = &gn_RIP_NODE_125_next,
		.data = &ctkn_RIP_NODE[125],
	},
	{
		.from = &gn_RIP_NODE_126_prev,
		.to = &gn_RIP_NODE_126_next,
		.data = &ctkn_RIP_NODE[126],
	},
	{
		.from = &gn_RIP_NODE_127_prev,
		.to = &gn_RIP_NODE_127_next,
		.data = &ctkn_RIP_NODE[127],
	},
	{
		.from = &gn_RIP_NODE_128_prev,
		.to = &gn_RIP_NODE_128_next,
		.data = &ctkn_RIP_NODE[128],
	},
	{
		.from = &gn_RIP_NODE_129_prev,
		.to = &gn_RIP_NODE_129_next,
		.data = (void *)&no_rip_bfd_default_profile_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_130_prev,
		.to = &gn_RIP_NODE_130_next,
		.data = &ctkn_RIP_NODE[130],
	},
	{
		.from = &gn_RIP_NODE_131_prev,
		.to = &gn_RIP_NODE_131_next,
		.data = &ctkn_RIP_NODE[131],
	},
	{
		.from = &gn_RIP_NODE_132_prev,
		.to = &gn_RIP_NODE_132_next,
		.data = &ctkn_RIP_NODE[132],
	},
	{
		.from = &gn_RIP_NODE_133_prev,
		.to = &gn_RIP_NODE_133_next,
		.data = &ctkn_RIP_NODE[133],
	},
	{
		.from = &gn_RIP_NODE_134_prev,
		.to = &gn_RIP_NODE_134_next,
		.data = &ctkn_RIP_NODE[134],
	},
	{
		.from = &gn_RIP_NODE_135_prev,
		.to = &gn_RIP_NODE_135_next,
		.data = (void *)&no_rip_default_metric_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_136_prev,
		.to = &gn_RIP_NODE_136_next,
		.data = &ctkn_RIP_NODE[136],
	},
	{
		.from = &gn_RIP_NODE_137_prev,
		.to = &gn_RIP_NODE_137_next,
		.data = &ctkn_RIP_NODE[137],
	},
	{
		.from = &gn_RIP_NODE_138_prev,
		.to = &gn_RIP_NODE_138_next,
		.data = &ctkn_RIP_NODE[138],
	},
	{
		.from = &gn_RIP_NODE_139_prev,
		.to = &gn_RIP_NODE_139_next,
		.data = &ctkn_RIP_NODE[139],
	},
	{
		.from = &gn_RIP_NODE_140_prev,
		.to = &gn_RIP_NODE_140_next,
		.data = &ctkn_RIP_NODE[140],
	},
	{
		.from = &gn_RIP_NODE_141_prev,
		.to = &gn_RIP_NODE_141_next,
		.data = (void *)&no_rip_distance_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_142_prev,
		.to = &gn_RIP_NODE_142_next,
		.data = &ctkn_RIP_NODE[142],
	},
	{
		.from = &gn_RIP_NODE_143_prev,
		.to = &gn_RIP_NODE_143_next,
		.data = &ctkn_RIP_NODE[143],
	},
	{
		.from = &gn_RIP_NODE_144_prev,
		.to = &gn_RIP_NODE_144_next,
		.data = &ctkn_RIP_NODE[144],
	},
	{
		.from = &gn_RIP_NODE_145_prev,
		.to = &gn_RIP_NODE_145_next,
		.data = &ctkn_RIP_NODE[145],
	},
	{
		.from = &gn_RIP_NODE_146_prev,
		.to = &gn_RIP_NODE_146_next,
		.data = &ctkn_RIP_NODE[146],
	},
	{
		.from = &gn_RIP_NODE_147_prev,
		.to = &gn_RIP_NODE_147_next,
		.data = &ctkn_RIP_NODE[147],
	},
	{
		.from = &gn_RIP_NODE_148_prev,
		.to = &gn_RIP_NODE_148_next,
		.data = &ctkn_RIP_NODE[148],
	},
	{
		.from = &gn_RIP_NODE_149_prev,
		.to = &gn_RIP_NODE_149_next,
		.data = &ctkn_RIP_NODE[149],
	},
	{
		.from = &gn_RIP_NODE_150_prev,
		.to = &gn_RIP_NODE_150_next,
		.data = &ctkn_RIP_NODE[150],
	},
	{
		.from = &gn_RIP_NODE_151_prev,
		.to = &gn_RIP_NODE_151_next,
		.data = &ctkn_RIP_NODE[151],
	},
	{
		.from = &gn_RIP_NODE_152_prev,
		.to = &gn_RIP_NODE_152_next,
		.data = &ctkn_RIP_NODE[152],
	},
	{
		.from = &gn_RIP_NODE_153_prev,
		.to = &gn_RIP_NODE_153_next,
		.data = (void *)&no_rip_distribute_list_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_154_prev,
		.to = &gn_RIP_NODE_154_next,
		.data = &ctkn_RIP_NODE[154],
	},
	{
		.from = &gn_RIP_NODE_155_prev,
		.to = &gn_RIP_NODE_155_next,
		.data = &ctkn_RIP_NODE[155],
	},
	{
		.from = &gn_RIP_NODE_156_prev,
		.to = &gn_RIP_NODE_156_next,
		.data = &ctkn_RIP_NODE[156],
	},
	{
		.from = &gn_RIP_NODE_157_prev,
		.to = &gn_RIP_NODE_157_next,
		.data = &ctkn_RIP_NODE[157],
	},
	{
		.from = &gn_RIP_NODE_158_prev,
		.to = &gn_RIP_NODE_158_next,
		.data = &ctkn_RIP_NODE[158],
	},
	{
		.from = &gn_RIP_NODE_159_prev,
		.to = &gn_RIP_NODE_159_next,
		.data = &ctkn_RIP_NODE[159],
	},
	{
		.from = &gn_RIP_NODE_160_prev,
		.to = &gn_RIP_NODE_160_next,
		.data = &ctkn_RIP_NODE[160],
	},
	{
		.from = &gn_RIP_NODE_161_prev,
		.to = &gn_RIP_NODE_161_next,
		.data = &ctkn_RIP_NODE[161],
	},
	{
		.from = &gn_RIP_NODE_162_prev,
		.to = &gn_RIP_NODE_162_next,
		.data = &ctkn_RIP_NODE[162],
	},
	{
		.from = &gn_RIP_NODE_163_prev,
		.to = &gn_RIP_NODE_163_next,
		.data = &ctkn_RIP_NODE[163],
	},
	{
		.from = &gn_RIP_NODE_164_prev,
		.to = &gn_RIP_NODE_164_next,
		.data = &ctkn_RIP_NODE[164],
	},
	{
		.from = &gn_RIP_NODE_165_prev,
		.to = &gn_RIP_NODE_165_next,
		.data = &ctkn_RIP_NODE[165],
	},
	{
		.from = &gn_RIP_NODE_166_prev,
		.to = &gn_RIP_NODE_166_next,
		.data = (void *)&no_rip_distribute_list_prefix_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_167_prev,
		.to = &gn_RIP_NODE_167_next,
		.data = &ctkn_RIP_NODE[167],
	},
	{
		.from = &gn_RIP_NODE_168_prev,
		.to = &gn_RIP_NODE_168_next,
		.data = &ctkn_RIP_NODE[168],
	},
	{
		.from = &gn_RIP_NODE_169_prev,
		.to = &gn_RIP_NODE_169_next,
		.data = &ctkn_RIP_NODE[169],
	},
	{
		.from = &gn_RIP_NODE_170_prev,
		.to = &gn_RIP_NODE_170_next,
		.data = &ctkn_RIP_NODE[170],
	},
	{
		.from = &gn_RIP_NODE_171_prev,
		.to = &gn_RIP_NODE_171_next,
		.data = &ctkn_RIP_NODE[171],
	},
	{
		.from = &gn_RIP_NODE_172_prev,
		.to = &gn_RIP_NODE_172_next,
		.data = &ctkn_RIP_NODE[172],
	},
	{
		.from = &gn_RIP_NODE_173_prev,
		.to = &gn_RIP_NODE_173_next,
		.data = &ctkn_RIP_NODE[173],
	},
	{
		.from = &gn_RIP_NODE_174_prev,
		.to = &gn_RIP_NODE_174_next,
		.data = &ctkn_RIP_NODE[174],
	},
	{
		.from = &gn_RIP_NODE_175_prev,
		.to = &gn_RIP_NODE_175_next,
		.data = &ctkn_RIP_NODE[175],
	},
	{
		.from = &gn_RIP_NODE_176_prev,
		.to = &gn_RIP_NODE_176_next,
		.data = &ctkn_RIP_NODE[176],
	},
	{
		.from = &gn_RIP_NODE_177_prev,
		.to = &gn_RIP_NODE_177_next,
		.data = (void *)&no_if_ipv4_route_map_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_178_prev,
		.to = &gn_RIP_NODE_178_next,
		.data = &ctkn_RIP_NODE[178],
	},
	{
		.from = &gn_RIP_NODE_179_prev,
		.to = &gn_RIP_NODE_179_next,
		.data = &ctkn_RIP_NODE[179],
	},
	{
		.from = &gn_RIP_NODE_180_prev,
		.to = &gn_RIP_NODE_180_next,
		.data = &ctkn_RIP_NODE[180],
	},
	{
		.from = &gn_RIP_NODE_181_prev,
		.to = &gn_RIP_NODE_181_next,
		.data = &ctkn_RIP_NODE[181],
	},
	{
		.from = &gn_RIP_NODE_182_prev,
		.to = &gn_RIP_NODE_182_next,
		.data = &ctkn_RIP_NODE[182],
	},
	{
		.from = &gn_RIP_NODE_183_prev,
		.to = &gn_RIP_NODE_183_next,
		.data = &ctkn_RIP_NODE[183],
	},
	{
		.from = &gn_RIP_NODE_184_prev,
		.to = &gn_RIP_NODE_184_next,
		.data = &ctkn_RIP_NODE[184],
	},
	{
		.from = &gn_RIP_NODE_185_prev,
		.to = &gn_RIP_NODE_185_next,
		.data = &ctkn_RIP_NODE[185],
	},
	{
		.from = &gn_RIP_NODE_186_prev,
		.to = &gn_RIP_NODE_186_next,
		.data = &ctkn_RIP_NODE[186],
	},
	{
		.from = &gn_RIP_NODE_187_prev,
		.to = &gn_RIP_NODE_187_next,
		.data = (void *)&no_rip_timers_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_188_prev,
		.to = &gn_RIP_NODE_188_next,
		.data = &ctkn_RIP_NODE[188],
	},
	{
		.from = &gn_RIP_NODE_189_prev,
		.to = &gn_RIP_NODE_189_next,
		.data = &ctkn_RIP_NODE[189],
	},
	{
		.from = &gn_RIP_NODE_190_prev,
		.to = &gn_RIP_NODE_190_next,
		.data = &ctkn_RIP_NODE[190],
	},
	{
		.from = &gn_RIP_NODE_191_prev,
		.to = &gn_RIP_NODE_191_next,
		.data = &ctkn_RIP_NODE[191],
	},
	{
		.from = &gn_RIP_NODE_192_prev,
		.to = &gn_RIP_NODE_192_next,
		.data = &ctkn_RIP_NODE[192],
	},
	{
		.from = &gn_RIP_NODE_193_prev,
		.to = &gn_RIP_NODE_193_next,
		.data = (void *)&no_rip_version_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_194_prev,
		.to = &gn_RIP_NODE_194_next,
		.data = &ctkn_RIP_NODE[194],
	},
	{
		.from = &gn_RIP_NODE_195_prev,
		.to = &gn_RIP_NODE_195_next,
		.data = &ctkn_RIP_NODE[195],
	},
	{
		.from = &gn_RIP_NODE_196_prev,
		.to = &gn_RIP_NODE_196_next,
		.data = &ctkn_RIP_NODE[196],
	},
	{
		.from = &gn_RIP_NODE_197_prev,
		.to = &gn_RIP_NODE_197_next,
		.data = &ctkn_RIP_NODE[197],
	},
	{
		.from = &gn_RIP_NODE_198_prev,
		.to = &gn_RIP_NODE_198_next,
		.data = &ctkn_RIP_NODE[198],
	},
	{
		.from = &gn_RIP_NODE_199_prev,
		.to = &gn_RIP_NODE_199_next,
		.data = &ctkn_RIP_NODE[199],
	},
	{
		.from = &gn_RIP_NODE_200_prev,
		.to = &gn_RIP_NODE_200_next,
		.data = &ctkn_RIP_NODE[200],
	},
	{
		.from = &gn_RIP_NODE_201_prev,
		.to = &gn_RIP_NODE_201_next,
		.data = (void *)&if_ipv4_route_map_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_202_prev,
		.to = &gn_RIP_NODE_202_next,
		.data = &ctkn_RIP_NODE[202],
	},
	{
		.from = &gn_RIP_NODE_203_prev,
		.to = &gn_RIP_NODE_203_next,
		.data = &ctkn_RIP_NODE[203],
	},
	{
		.from = &gn_RIP_NODE_204_prev,
		.to = &gn_RIP_NODE_204_next,
		.data = &ctkn_RIP_NODE[204],
	},
	{
		.from = &gn_RIP_NODE_205_prev,
		.to = &gn_RIP_NODE_205_next,
		.data = &ctkn_RIP_NODE[205],
	},
	{
		.from = &gn_RIP_NODE_206_prev,
		.to = &gn_RIP_NODE_206_next,
		.data = &ctkn_RIP_NODE[206],
	},
	{
		.from = &gn_RIP_NODE_207_prev,
		.to = &gn_RIP_NODE_207_next,
		.data = &ctkn_RIP_NODE[207],
	},
	{
		.from = &gn_RIP_NODE_208_prev,
		.to = &gn_RIP_NODE_208_next,
		.data = &ctkn_RIP_NODE[208],
	},
	{
		.from = &gn_RIP_NODE_209_prev,
		.to = &gn_RIP_NODE_209_next,
		.data = (void *)&rip_timers_cmd_vtysh,
	},
	{
		.from = &gn_RIP_NODE_210_prev,
		.to = &gn_RIP_NODE_210_next,
		.data = &ctkn_RIP_NODE[210],
	},
	{
		.from = &gn_RIP_NODE_211_prev,
		.to = &gn_RIP_NODE_211_next,
		.data = &ctkn_RIP_NODE[211],
	},
	{
		.from = &gn_RIP_NODE_212_prev,
		.to = &gn_RIP_NODE_212_next,
		.data = &ctkn_RIP_NODE[212],
	},
	{
		.from = &gn_RIP_NODE_213_prev,
		.to = &gn_RIP_NODE_213_next,
		.data = (void *)&rip_version_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_RIP_NODE, 214, &gn_RIP_NODE[0], &gn_RIP_NODE[1], &gn_RIP_NODE[2], &gn_RIP_NODE[3], &gn_RIP_NODE[4], &gn_RIP_NODE[5], &gn_RIP_NODE[6], &gn_RIP_NODE[7], &gn_RIP_NODE[8], &gn_RIP_NODE[9], &gn_RIP_NODE[10], &gn_RIP_NODE[11], &gn_RIP_NODE[12], &gn_RIP_NODE[13], &gn_RIP_NODE[14], &gn_RIP_NODE[15], &gn_RIP_NODE[16], &gn_RIP_NODE[17], &gn_RIP_NODE[18], &gn_RIP_NODE[19], &gn_RIP_NODE[20], &gn_RIP_NODE[21], &gn_RIP_NODE[22], &gn_RIP_NODE[23], &gn_RIP_NODE[24], &gn_RIP_NODE[25], &gn_RIP_NODE[26], &gn_RIP_NODE[27], &gn_RIP_NODE[28], &gn_RIP_NODE[29], &gn_RIP_NODE[30], &gn_RIP_NODE[31], &gn_RIP_NODE[32], &gn_RIP_NODE[33], &gn_RIP_NODE[34], &gn_RIP_NODE[35], &gn_RIP_NODE[36], &gn_RIP_NODE[37], &gn_RIP_NODE[38], &gn_RIP_NODE[39], &gn_RIP_NODE[40], &gn_RIP_NODE[41], &gn_RIP_NODE[42], &gn_RIP_NODE[43], &gn_RIP_NODE[44], &gn_RIP_NODE[45], &gn_RIP_NODE[46], &gn_RIP_NODE[47], &gn_RIP_NODE[48], &gn_RIP_NODE[49], &gn_RIP_NODE[50], &gn_RIP_NODE[51], &gn_RIP_NODE[52], &gn_RIP_NODE[53], &gn_RIP_NODE[54], &gn_RIP_NODE[55], &gn_RIP_NODE[56], &gn_RIP_NODE[57], &gn_RIP_NODE[58], &gn_RIP_NODE[59], &gn_RIP_NODE[60], &gn_RIP_NODE[61], &gn_RIP_NODE[62], &gn_RIP_NODE[63], &gn_RIP_NODE[64], &gn_RIP_NODE[65], &gn_RIP_NODE[66], &gn_RIP_NODE[67], &gn_RIP_NODE[68], &gn_RIP_NODE[69], &gn_RIP_NODE[70], &gn_RIP_NODE[71], &gn_RIP_NODE[72], &gn_RIP_NODE[73], &gn_RIP_NODE[74], &gn_RIP_NODE[75], &gn_RIP_NODE[76], &gn_RIP_NODE[77], &gn_RIP_NODE[78], &gn_RIP_NODE[79], &gn_RIP_NODE[80], &gn_RIP_NODE[81], &gn_RIP_NODE[82], &gn_RIP_NODE[83], &gn_RIP_NODE[84], &gn_RIP_NODE[85], &gn_RIP_NODE[86], &gn_RIP_NODE[87], &gn_RIP_NODE[88], &gn_RIP_NODE[89], &gn_RIP_NODE[90], &gn_RIP_NODE[91], &gn_RIP_NODE[92], &gn_RIP_NODE[93], &gn_RIP_NODE[94], &gn_RIP_NODE[95], &gn_RIP_NODE[96], &gn_RIP_NODE[97], &gn_RIP_NODE[98], &gn_RIP_NODE[99], &gn_RIP_NODE[100], &gn_RIP_NODE[101], &gn_RIP_NODE[102], &gn_RIP_NODE[103], &gn_RIP_NODE[104], &gn_RIP_NODE[105], &gn_RIP_NODE[106], &gn_RIP_NODE[107], &gn_RIP_NODE[108], &gn_RIP_NODE[109], &gn_RIP_NODE[110], &gn_RIP_NODE[111], &gn_RIP_NODE[112], &gn_RIP_NODE[113], &gn_RIP_NODE[114], &gn_RIP_NODE[115], &gn_RIP_NODE[116], &gn_RIP_NODE[117], &gn_RIP_NODE[118], &gn_RIP_NODE[119], &gn_RIP_NODE[120], &gn_RIP_NODE[121], &gn_RIP_NODE[122], &gn_RIP_NODE[123], &gn_RIP_NODE[124], &gn_RIP_NODE[125], &gn_RIP_NODE[126], &gn_RIP_NODE[127], &gn_RIP_NODE[128], &gn_RIP_NODE[129], &gn_RIP_NODE[130], &gn_RIP_NODE[131], &gn_RIP_NODE[132], &gn_RIP_NODE[133], &gn_RIP_NODE[134], &gn_RIP_NODE[135], &gn_RIP_NODE[136], &gn_RIP_NODE[137], &gn_RIP_NODE[138], &gn_RIP_NODE[139], &gn_RIP_NODE[140], &gn_RIP_NODE[141], &gn_RIP_NODE[142], &gn_RIP_NODE[143], &gn_RIP_NODE[144], &gn_RIP_NODE[145], &gn_RIP_NODE[146], &gn_RIP_NODE[147], &gn_RIP_NODE[148], &gn_RIP_NODE[149], &gn_RIP_NODE[150], &gn_RIP_NODE[151], &gn_RIP_NODE[152], &gn_RIP_NODE[153], &gn_RIP_NODE[154], &gn_RIP_NODE[155], &gn_RIP_NODE[156], &gn_RIP_NODE[157], &gn_RIP_NODE[158], &gn_RIP_NODE[159], &gn_RIP_NODE[160], &gn_RIP_NODE[161], &gn_RIP_NODE[162], &gn_RIP_NODE[163], &gn_RIP_NODE[164], &gn_RIP_NODE[165], &gn_RIP_NODE[166], &gn_RIP_NODE[167], &gn_RIP_NODE[168], &gn_RIP_NODE[169], &gn_RIP_NODE[170], &gn_RIP_NODE[171], &gn_RIP_NODE[172], &gn_RIP_NODE[173], &gn_RIP_NODE[174], &gn_RIP_NODE[175], &gn_RIP_NODE[176], &gn_RIP_NODE[177], &gn_RIP_NODE[178], &gn_RIP_NODE[179], &gn_RIP_NODE[180], &gn_RIP_NODE[181], &gn_RIP_NODE[182], &gn_RIP_NODE[183], &gn_RIP_NODE[184], &gn_RIP_NODE[185], &gn_RIP_NODE[186], &gn_RIP_NODE[187], &gn_RIP_NODE[188], &gn_RIP_NODE[189], &gn_RIP_NODE[190], &gn_RIP_NODE[191], &gn_RIP_NODE[192], &gn_RIP_NODE[193], &gn_RIP_NODE[194], &gn_RIP_NODE[195], &gn_RIP_NODE[196], &gn_RIP_NODE[197], &gn_RIP_NODE[198], &gn_RIP_NODE[199], &gn_RIP_NODE[200], &gn_RIP_NODE[201], &gn_RIP_NODE[202], &gn_RIP_NODE[203], &gn_RIP_NODE[204], &gn_RIP_NODE[205], &gn_RIP_NODE[206], &gn_RIP_NODE[207], &gn_RIP_NODE[208], &gn_RIP_NODE[209], &gn_RIP_NODE[210], &gn_RIP_NODE[211], &gn_RIP_NODE[212], &gn_RIP_NODE[213]);

extern void install_RIP_NODE(void);

void install_RIP_NODE(void)

{
	unsigned node_id = RIP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_RIP_NODE;
	vector_set(node->cmd_vector, &if_ipv4_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_if_ipv4_route_map_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_allow_ecmp_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_bfd_default_profile_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_default_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_distribute_list_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_timers_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rip_version_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_allow_ecmp_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_bfd_default_profile_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_default_information_originate_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_default_metric_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_distance_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_distance_source_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_distribute_list_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_distribute_list_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_neighbor_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_network_if_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_network_prefix_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_offset_list_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_passive_default_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_passive_interface_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_redistribute_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_route_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_timers_cmd_vtysh);
	vector_set(node->cmd_vector, &rip_version_cmd_vtysh);
}

static struct cmd_token ctkn_KEYCHAIN_NODE[];
static struct graph_node gn_KEYCHAIN_NODE[];

static struct cmd_token ctkn_KEYCHAIN_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [2] */
		.type = WORD_TKN,
		.text = (char *)"key",
		.desc = (char *)"Delete a key",
	},
	{ /* [3] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(0-2147483647)",
		.desc = (char *)"Key identifier number",
		.max = 2147483647,
		.varname = (char *)"key",
	},
	{ /* [4] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [5] = no_key_cmd */ },
	{ /* [6] */
		.type = WORD_TKN,
		.text = (char *)"chain",
		.desc = (char *)"Key-chain management",
	},
	{ /* [7] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"Key-chain name",
		.varname = (char *)"chain",
	},
	{ /* [8] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [9] = no_key_chain_cmd */ },
};

extern struct cmd_element no_key_chain_cmd_vtysh;
extern struct cmd_element no_key_cmd_vtysh;

MAKE_VECTOR(gn_KEYCHAIN_NODE_0_next, 1, &gn_KEYCHAIN_NODE[1]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_0_prev, 0, );
MAKE_VECTOR(gn_KEYCHAIN_NODE_1_next, 1, &gn_KEYCHAIN_NODE[2]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_1_prev, 1, &gn_KEYCHAIN_NODE[0]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_2_next, 2, &gn_KEYCHAIN_NODE[3], &gn_KEYCHAIN_NODE[6]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_2_prev, 1, &gn_KEYCHAIN_NODE[1]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_3_next, 1, &gn_KEYCHAIN_NODE[4]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_3_prev, 1, &gn_KEYCHAIN_NODE[2]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_4_next, 1, &gn_KEYCHAIN_NODE[5]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_4_prev, 1, &gn_KEYCHAIN_NODE[3]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_5_next, 0, );
MAKE_VECTOR(gn_KEYCHAIN_NODE_5_prev, 1, &gn_KEYCHAIN_NODE[4]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_6_next, 1, &gn_KEYCHAIN_NODE[7]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_6_prev, 1, &gn_KEYCHAIN_NODE[2]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_7_next, 1, &gn_KEYCHAIN_NODE[8]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_7_prev, 1, &gn_KEYCHAIN_NODE[6]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_8_next, 1, &gn_KEYCHAIN_NODE[9]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_8_prev, 1, &gn_KEYCHAIN_NODE[7]);
MAKE_VECTOR(gn_KEYCHAIN_NODE_9_next, 0, );
MAKE_VECTOR(gn_KEYCHAIN_NODE_9_prev, 1, &gn_KEYCHAIN_NODE[8]);

static struct graph_node gn_KEYCHAIN_NODE[] = {
	{
		.from = &gn_KEYCHAIN_NODE_0_prev,
		.to = &gn_KEYCHAIN_NODE_0_next,
		.data = &ctkn_KEYCHAIN_NODE[0],
	},
	{
		.from = &gn_KEYCHAIN_NODE_1_prev,
		.to = &gn_KEYCHAIN_NODE_1_next,
		.data = &ctkn_KEYCHAIN_NODE[1],
	},
	{
		.from = &gn_KEYCHAIN_NODE_2_prev,
		.to = &gn_KEYCHAIN_NODE_2_next,
		.data = &ctkn_KEYCHAIN_NODE[2],
	},
	{
		.from = &gn_KEYCHAIN_NODE_3_prev,
		.to = &gn_KEYCHAIN_NODE_3_next,
		.data = &ctkn_KEYCHAIN_NODE[3],
	},
	{
		.from = &gn_KEYCHAIN_NODE_4_prev,
		.to = &gn_KEYCHAIN_NODE_4_next,
		.data = &ctkn_KEYCHAIN_NODE[4],
	},
	{
		.from = &gn_KEYCHAIN_NODE_5_prev,
		.to = &gn_KEYCHAIN_NODE_5_next,
		.data = (void *)&no_key_cmd_vtysh,
	},
	{
		.from = &gn_KEYCHAIN_NODE_6_prev,
		.to = &gn_KEYCHAIN_NODE_6_next,
		.data = &ctkn_KEYCHAIN_NODE[6],
	},
	{
		.from = &gn_KEYCHAIN_NODE_7_prev,
		.to = &gn_KEYCHAIN_NODE_7_next,
		.data = &ctkn_KEYCHAIN_NODE[7],
	},
	{
		.from = &gn_KEYCHAIN_NODE_8_prev,
		.to = &gn_KEYCHAIN_NODE_8_next,
		.data = &ctkn_KEYCHAIN_NODE[8],
	},
	{
		.from = &gn_KEYCHAIN_NODE_9_prev,
		.to = &gn_KEYCHAIN_NODE_9_next,
		.data = (void *)&no_key_chain_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_KEYCHAIN_NODE, 10, &gn_KEYCHAIN_NODE[0], &gn_KEYCHAIN_NODE[1], &gn_KEYCHAIN_NODE[2], &gn_KEYCHAIN_NODE[3], &gn_KEYCHAIN_NODE[4], &gn_KEYCHAIN_NODE[5], &gn_KEYCHAIN_NODE[6], &gn_KEYCHAIN_NODE[7], &gn_KEYCHAIN_NODE[8], &gn_KEYCHAIN_NODE[9]);

extern void install_KEYCHAIN_NODE(void);

void install_KEYCHAIN_NODE(void)

{
	unsigned node_id = KEYCHAIN_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_KEYCHAIN_NODE;
	vector_set(node->cmd_vector, &no_key_chain_cmd_vtysh);
	vector_set(node->cmd_vector, &no_key_cmd_vtysh);
}

static struct cmd_token ctkn_RPKI_NODE[];
static struct graph_node gn_RPKI_NODE[];

static struct cmd_token ctkn_RPKI_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [2] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Control rpki specific settings",
	},
	{ /* [3] */
		.type = WORD_TKN,
		.text = (char *)"cache",
		.desc = (char *)"Install a cache server to current group",
	},
	{ /* [4] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[6],
	},
	{ /* [5] */
		.type = WORD_TKN,
		.text = (char *)"tcp",
		.desc = (char *)"Use TCP",
	},
	{ /* [6] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[4],
	},
	{ /* [7] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[9],
	},
	{ /* [8] */
		.type = IPV4_TKN,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of cache server",
	},
	{ /* [9] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[7],
	},
	{ /* [10] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[12],
	},
	{ /* [11] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"TCPPORT",
		.desc = (char *)"TCP port number",
		.varname = (char *)"tcpport",
	},
	{ /* [12] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[10],
	},
	{ /* [13] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[18],
	},
	{ /* [14] */
		.type = WORD_TKN,
		.text = (char *)"source",
		.desc = (char *)"Configure source IP address of RPKI connection",
	},
	{ /* [15] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[17],
	},
	{ /* [16] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Define a Source IP Address",
		.varname = (char *)"bindaddr",
	},
	{ /* [17] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[15],
	},
	{ /* [18] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[13],
	},
	{ /* [19] */
		.type = WORD_TKN,
		.text = (char *)"preference",
		.desc = (char *)"Preference of the cache server",
	},
	{ /* [20] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Preference value",
		.min = 1,
		.max = 255,
		.varname = (char *)"preference",
	},
	{ /* [21] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [22] = no_rpki_cache_cmd */ },
	{ /* [23] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"SSH port number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"sshport",
	},
	{ /* [24] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SSH_UNAME",
		.desc = (char *)"SSH user name",
		.varname = (char *)"ssh_uname",
	},
	{ /* [25] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SSH_PRIVKEY",
		.desc = (char *)"Path to own SSH private key",
		.varname = (char *)"ssh_privkey",
	},
	{ /* [26] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[28],
	},
	{ /* [27] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"KNOWN_HOSTS_PATH",
		.desc = (char *)"Path to the known hosts file",
		.varname = (char *)"known_hosts_path",
	},
	{ /* [28] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[26],
	},
	{ /* [29] */
		.type = VARIABLE_TKN,
		.text = (char *)"WORD",
		.desc = (char *)"Hostname of cache server",
	},
	{ /* [30] */
		.type = WORD_TKN,
		.text = (char *)"ssh",
		.desc = (char *)"Use SSH",
	},
	{ /* [31] */
		.type = WORD_TKN,
		.text = (char *)"expire_interval",
		.desc = (char *)"Set expire interval back to default",
	},
	{ /* [32] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[34],
	},
	{ /* [33] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(600-172800)",
		.desc = (char *)"Expire interval value",
		.min = 600,
		.max = 172800,
		.varname = (char *)"expire_interval",
	},
	{ /* [34] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[32],
	},
	{ /* [35] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [36] = no_rpki_expire_interval_cmd */ },
	{ /* [37] */
		.type = WORD_TKN,
		.text = (char *)"polling_period",
		.desc = (char *)"Set polling period back to default",
	},
	{ /* [38] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[40],
	},
	{ /* [39] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-86400)",
		.desc = (char *)"Polling period value",
		.min = 1,
		.max = 86400,
		.varname = (char *)"polling_period",
	},
	{ /* [40] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[38],
	},
	{ /* [41] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [42] = no_rpki_polling_period_cmd */ },
	{ /* [43] */
		.type = WORD_TKN,
		.text = (char *)"retry_interval",
		.desc = (char *)"Set retry interval back to default",
	},
	{ /* [44] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[46],
	},
	{ /* [45] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-7200)",
		.desc = (char *)"retry interval value",
		.min = 1,
		.max = 7200,
		.varname = (char *)"retry_interval",
	},
	{ /* [46] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[44],
	},
	{ /* [47] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [48] = no_rpki_retry_interval_cmd */ },
	{ /* [49] */
		.type = WORD_TKN,
		.text = (char *)"rpki",
		.desc = (char *)"Control rpki specific settings",
	},
	{ /* [50] */
		.type = WORD_TKN,
		.text = (char *)"cache",
		.desc = (char *)"Install a cache server to current group",
	},
	{ /* [51] */
		.type = WORD_TKN,
		.text = (char *)"ssh",
		.desc = (char *)"Use SSH",
	},
	{ /* [52] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[54],
	},
	{ /* [53] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of cache server",
		.varname = (char *)"cache",
	},
	{ /* [54] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[52],
	},
	{ /* [55] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-65535)",
		.desc = (char *)"SSH port number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"sshport",
	},
	{ /* [56] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SSH_UNAME",
		.desc = (char *)"SSH user name",
		.varname = (char *)"ssh_uname",
	},
	{ /* [57] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"SSH_PRIVKEY",
		.desc = (char *)"Path to own SSH private key",
		.varname = (char *)"ssh_privkey",
	},
	{ /* [58] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[60],
	},
	{ /* [59] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"KNOWN_HOSTS_PATH",
		.desc = (char *)"Path to the known hosts file",
		.varname = (char *)"known_hosts_path",
	},
	{ /* [60] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[58],
	},
	{ /* [61] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[66],
	},
	{ /* [62] */
		.type = WORD_TKN,
		.text = (char *)"source",
		.desc = (char *)"Configure source IP address of RPKI connection",
	},
	{ /* [63] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[65],
	},
	{ /* [64] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Define a Source IP Address",
		.varname = (char *)"bindaddr",
	},
	{ /* [65] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[63],
	},
	{ /* [66] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[61],
	},
	{ /* [67] */
		.type = WORD_TKN,
		.text = (char *)"preference",
		.desc = (char *)"Preference of the cache server",
	},
	{ /* [68] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Preference value",
		.min = 1,
		.max = 255,
		.varname = (char *)"preference",
	},
	{ /* [69] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [70] = rpki_cache_ssh_cmd */ },
	{ /* [71] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Hostname of cache server",
		.varname = (char *)"cache",
	},
	{ /* [72] */
		.type = WORD_TKN,
		.text = (char *)"tcp",
		.desc = (char *)"Use TCP",
	},
	{ /* [73] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[75],
	},
	{ /* [74] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IP address of cache server",
		.varname = (char *)"cache",
	},
	{ /* [75] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[73],
	},
	{ /* [76] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"TCPPORT",
		.desc = (char *)"TCP port number",
		.varname = (char *)"tcpport",
	},
	{ /* [77] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[82],
	},
	{ /* [78] */
		.type = WORD_TKN,
		.text = (char *)"source",
		.desc = (char *)"Configure source IP address of RPKI connection",
	},
	{ /* [79] */
		.type = FORK_TKN,
		.forkjoin = &gn_RPKI_NODE[81],
	},
	{ /* [80] */
		.type = IPV4_TKN,
		.varname_src = 4,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"Define a Source IP Address",
		.varname = (char *)"bindaddr",
	},
	{ /* [81] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[79],
	},
	{ /* [82] */
		.type = JOIN_TKN,
		.forkjoin = &gn_RPKI_NODE[77],
	},
	{ /* [83] */
		.type = WORD_TKN,
		.text = (char *)"preference",
		.desc = (char *)"Preference of the cache server",
	},
	{ /* [84] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Preference value",
		.min = 1,
		.max = 255,
		.varname = (char *)"preference",
	},
	{ /* [85] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [86] = rpki_cache_tcp_cmd */ },
	{ /* [87] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Hostname of cache server",
		.varname = (char *)"cache",
	},
	{ /* [88] */
		.type = WORD_TKN,
		.text = (char *)"expire_interval",
		.desc = (char *)"Set expire interval",
	},
	{ /* [89] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(600-172800)",
		.desc = (char *)"Expire interval value",
		.min = 600,
		.max = 172800,
		.varname = (char *)"tmp",
	},
	{ /* [90] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [91] = rpki_expire_interval_cmd */ },
	{ /* [92] */
		.type = WORD_TKN,
		.text = (char *)"polling_period",
		.desc = (char *)"Set polling period",
	},
	{ /* [93] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-86400)",
		.desc = (char *)"Polling period value",
		.min = 1,
		.max = 86400,
		.varname = (char *)"pp",
	},
	{ /* [94] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [95] = rpki_polling_period_cmd */ },
	{ /* [96] */
		.type = WORD_TKN,
		.text = (char *)"reset",
		.desc = (char *)"reset rpki",
	},
	{ /* [97] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [98] = rpki_reset_config_mode_cmd */ },
	{ /* [99] */
		.type = WORD_TKN,
		.text = (char *)"retry_interval",
		.desc = (char *)"Set retry interval",
	},
	{ /* [100] */
		.type = RANGE_TKN,
		.varname_src = 4,
		.text = (char *)"(1-7200)",
		.desc = (char *)"retry interval value",
		.min = 1,
		.max = 7200,
		.varname = (char *)"tmp",
	},
	{ /* [101] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [102] = rpki_retry_interval_cmd */ },
};

extern struct cmd_element no_rpki_cache_cmd_vtysh;
extern struct cmd_element no_rpki_expire_interval_cmd_vtysh;
extern struct cmd_element no_rpki_polling_period_cmd_vtysh;
extern struct cmd_element no_rpki_retry_interval_cmd_vtysh;
extern struct cmd_element rpki_cache_ssh_cmd_vtysh;
extern struct cmd_element rpki_cache_tcp_cmd_vtysh;
extern struct cmd_element rpki_expire_interval_cmd_vtysh;
extern struct cmd_element rpki_polling_period_cmd_vtysh;
extern struct cmd_element rpki_reset_config_mode_cmd_vtysh;
extern struct cmd_element rpki_retry_interval_cmd_vtysh;

MAKE_VECTOR(gn_RPKI_NODE_0_next, 2, &gn_RPKI_NODE[1], &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_0_prev, 0, );
MAKE_VECTOR(gn_RPKI_NODE_1_next, 1, &gn_RPKI_NODE[2]);
MAKE_VECTOR(gn_RPKI_NODE_1_prev, 1, &gn_RPKI_NODE[0]);
MAKE_VECTOR(gn_RPKI_NODE_2_next, 4, &gn_RPKI_NODE[3], &gn_RPKI_NODE[31], &gn_RPKI_NODE[37], &gn_RPKI_NODE[43]);
MAKE_VECTOR(gn_RPKI_NODE_2_prev, 1, &gn_RPKI_NODE[1]);
MAKE_VECTOR(gn_RPKI_NODE_3_next, 1, &gn_RPKI_NODE[4]);
MAKE_VECTOR(gn_RPKI_NODE_3_prev, 1, &gn_RPKI_NODE[2]);
MAKE_VECTOR(gn_RPKI_NODE_4_next, 2, &gn_RPKI_NODE[5], &gn_RPKI_NODE[30]);
MAKE_VECTOR(gn_RPKI_NODE_4_prev, 1, &gn_RPKI_NODE[3]);
MAKE_VECTOR(gn_RPKI_NODE_5_next, 1, &gn_RPKI_NODE[6]);
MAKE_VECTOR(gn_RPKI_NODE_5_prev, 1, &gn_RPKI_NODE[4]);
MAKE_VECTOR(gn_RPKI_NODE_6_next, 1, &gn_RPKI_NODE[7]);
MAKE_VECTOR(gn_RPKI_NODE_6_prev, 2, &gn_RPKI_NODE[5], &gn_RPKI_NODE[30]);
MAKE_VECTOR(gn_RPKI_NODE_7_next, 2, &gn_RPKI_NODE[8], &gn_RPKI_NODE[29]);
MAKE_VECTOR(gn_RPKI_NODE_7_prev, 1, &gn_RPKI_NODE[6]);
MAKE_VECTOR(gn_RPKI_NODE_8_next, 1, &gn_RPKI_NODE[9]);
MAKE_VECTOR(gn_RPKI_NODE_8_prev, 1, &gn_RPKI_NODE[7]);
MAKE_VECTOR(gn_RPKI_NODE_9_next, 1, &gn_RPKI_NODE[10]);
MAKE_VECTOR(gn_RPKI_NODE_9_prev, 2, &gn_RPKI_NODE[8], &gn_RPKI_NODE[29]);
MAKE_VECTOR(gn_RPKI_NODE_10_next, 2, &gn_RPKI_NODE[11], &gn_RPKI_NODE[23]);
MAKE_VECTOR(gn_RPKI_NODE_10_prev, 1, &gn_RPKI_NODE[9]);
MAKE_VECTOR(gn_RPKI_NODE_11_next, 1, &gn_RPKI_NODE[12]);
MAKE_VECTOR(gn_RPKI_NODE_11_prev, 1, &gn_RPKI_NODE[10]);
MAKE_VECTOR(gn_RPKI_NODE_12_next, 1, &gn_RPKI_NODE[13]);
MAKE_VECTOR(gn_RPKI_NODE_12_prev, 2, &gn_RPKI_NODE[11], &gn_RPKI_NODE[28]);
MAKE_VECTOR(gn_RPKI_NODE_13_next, 2, &gn_RPKI_NODE[14], &gn_RPKI_NODE[18]);
MAKE_VECTOR(gn_RPKI_NODE_13_prev, 1, &gn_RPKI_NODE[12]);
MAKE_VECTOR(gn_RPKI_NODE_14_next, 1, &gn_RPKI_NODE[15]);
MAKE_VECTOR(gn_RPKI_NODE_14_prev, 1, &gn_RPKI_NODE[13]);
MAKE_VECTOR(gn_RPKI_NODE_15_next, 1, &gn_RPKI_NODE[16]);
MAKE_VECTOR(gn_RPKI_NODE_15_prev, 1, &gn_RPKI_NODE[14]);
MAKE_VECTOR(gn_RPKI_NODE_16_next, 1, &gn_RPKI_NODE[17]);
MAKE_VECTOR(gn_RPKI_NODE_16_prev, 1, &gn_RPKI_NODE[15]);
MAKE_VECTOR(gn_RPKI_NODE_17_next, 1, &gn_RPKI_NODE[18]);
MAKE_VECTOR(gn_RPKI_NODE_17_prev, 1, &gn_RPKI_NODE[16]);
MAKE_VECTOR(gn_RPKI_NODE_18_next, 1, &gn_RPKI_NODE[19]);
MAKE_VECTOR(gn_RPKI_NODE_18_prev, 2, &gn_RPKI_NODE[17], &gn_RPKI_NODE[13]);
MAKE_VECTOR(gn_RPKI_NODE_19_next, 1, &gn_RPKI_NODE[20]);
MAKE_VECTOR(gn_RPKI_NODE_19_prev, 1, &gn_RPKI_NODE[18]);
MAKE_VECTOR(gn_RPKI_NODE_20_next, 1, &gn_RPKI_NODE[21]);
MAKE_VECTOR(gn_RPKI_NODE_20_prev, 1, &gn_RPKI_NODE[19]);
MAKE_VECTOR(gn_RPKI_NODE_21_next, 1, &gn_RPKI_NODE[22]);
MAKE_VECTOR(gn_RPKI_NODE_21_prev, 1, &gn_RPKI_NODE[20]);
MAKE_VECTOR(gn_RPKI_NODE_22_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_22_prev, 1, &gn_RPKI_NODE[21]);
MAKE_VECTOR(gn_RPKI_NODE_23_next, 1, &gn_RPKI_NODE[24]);
MAKE_VECTOR(gn_RPKI_NODE_23_prev, 1, &gn_RPKI_NODE[10]);
MAKE_VECTOR(gn_RPKI_NODE_24_next, 1, &gn_RPKI_NODE[25]);
MAKE_VECTOR(gn_RPKI_NODE_24_prev, 1, &gn_RPKI_NODE[23]);
MAKE_VECTOR(gn_RPKI_NODE_25_next, 1, &gn_RPKI_NODE[26]);
MAKE_VECTOR(gn_RPKI_NODE_25_prev, 1, &gn_RPKI_NODE[24]);
MAKE_VECTOR(gn_RPKI_NODE_26_next, 2, &gn_RPKI_NODE[27], &gn_RPKI_NODE[28]);
MAKE_VECTOR(gn_RPKI_NODE_26_prev, 1, &gn_RPKI_NODE[25]);
MAKE_VECTOR(gn_RPKI_NODE_27_next, 1, &gn_RPKI_NODE[28]);
MAKE_VECTOR(gn_RPKI_NODE_27_prev, 1, &gn_RPKI_NODE[26]);
MAKE_VECTOR(gn_RPKI_NODE_28_next, 1, &gn_RPKI_NODE[12]);
MAKE_VECTOR(gn_RPKI_NODE_28_prev, 2, &gn_RPKI_NODE[27], &gn_RPKI_NODE[26]);
MAKE_VECTOR(gn_RPKI_NODE_29_next, 1, &gn_RPKI_NODE[9]);
MAKE_VECTOR(gn_RPKI_NODE_29_prev, 1, &gn_RPKI_NODE[7]);
MAKE_VECTOR(gn_RPKI_NODE_30_next, 1, &gn_RPKI_NODE[6]);
MAKE_VECTOR(gn_RPKI_NODE_30_prev, 1, &gn_RPKI_NODE[4]);
MAKE_VECTOR(gn_RPKI_NODE_31_next, 1, &gn_RPKI_NODE[32]);
MAKE_VECTOR(gn_RPKI_NODE_31_prev, 1, &gn_RPKI_NODE[2]);
MAKE_VECTOR(gn_RPKI_NODE_32_next, 2, &gn_RPKI_NODE[33], &gn_RPKI_NODE[34]);
MAKE_VECTOR(gn_RPKI_NODE_32_prev, 1, &gn_RPKI_NODE[31]);
MAKE_VECTOR(gn_RPKI_NODE_33_next, 1, &gn_RPKI_NODE[34]);
MAKE_VECTOR(gn_RPKI_NODE_33_prev, 1, &gn_RPKI_NODE[32]);
MAKE_VECTOR(gn_RPKI_NODE_34_next, 1, &gn_RPKI_NODE[35]);
MAKE_VECTOR(gn_RPKI_NODE_34_prev, 2, &gn_RPKI_NODE[33], &gn_RPKI_NODE[32]);
MAKE_VECTOR(gn_RPKI_NODE_35_next, 1, &gn_RPKI_NODE[36]);
MAKE_VECTOR(gn_RPKI_NODE_35_prev, 1, &gn_RPKI_NODE[34]);
MAKE_VECTOR(gn_RPKI_NODE_36_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_36_prev, 1, &gn_RPKI_NODE[35]);
MAKE_VECTOR(gn_RPKI_NODE_37_next, 1, &gn_RPKI_NODE[38]);
MAKE_VECTOR(gn_RPKI_NODE_37_prev, 1, &gn_RPKI_NODE[2]);
MAKE_VECTOR(gn_RPKI_NODE_38_next, 2, &gn_RPKI_NODE[39], &gn_RPKI_NODE[40]);
MAKE_VECTOR(gn_RPKI_NODE_38_prev, 1, &gn_RPKI_NODE[37]);
MAKE_VECTOR(gn_RPKI_NODE_39_next, 1, &gn_RPKI_NODE[40]);
MAKE_VECTOR(gn_RPKI_NODE_39_prev, 1, &gn_RPKI_NODE[38]);
MAKE_VECTOR(gn_RPKI_NODE_40_next, 1, &gn_RPKI_NODE[41]);
MAKE_VECTOR(gn_RPKI_NODE_40_prev, 2, &gn_RPKI_NODE[39], &gn_RPKI_NODE[38]);
MAKE_VECTOR(gn_RPKI_NODE_41_next, 1, &gn_RPKI_NODE[42]);
MAKE_VECTOR(gn_RPKI_NODE_41_prev, 1, &gn_RPKI_NODE[40]);
MAKE_VECTOR(gn_RPKI_NODE_42_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_42_prev, 1, &gn_RPKI_NODE[41]);
MAKE_VECTOR(gn_RPKI_NODE_43_next, 1, &gn_RPKI_NODE[44]);
MAKE_VECTOR(gn_RPKI_NODE_43_prev, 1, &gn_RPKI_NODE[2]);
MAKE_VECTOR(gn_RPKI_NODE_44_next, 2, &gn_RPKI_NODE[45], &gn_RPKI_NODE[46]);
MAKE_VECTOR(gn_RPKI_NODE_44_prev, 1, &gn_RPKI_NODE[43]);
MAKE_VECTOR(gn_RPKI_NODE_45_next, 1, &gn_RPKI_NODE[46]);
MAKE_VECTOR(gn_RPKI_NODE_45_prev, 1, &gn_RPKI_NODE[44]);
MAKE_VECTOR(gn_RPKI_NODE_46_next, 1, &gn_RPKI_NODE[47]);
MAKE_VECTOR(gn_RPKI_NODE_46_prev, 2, &gn_RPKI_NODE[45], &gn_RPKI_NODE[44]);
MAKE_VECTOR(gn_RPKI_NODE_47_next, 1, &gn_RPKI_NODE[48]);
MAKE_VECTOR(gn_RPKI_NODE_47_prev, 1, &gn_RPKI_NODE[46]);
MAKE_VECTOR(gn_RPKI_NODE_48_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_48_prev, 1, &gn_RPKI_NODE[47]);
MAKE_VECTOR(gn_RPKI_NODE_49_next, 5, &gn_RPKI_NODE[50], &gn_RPKI_NODE[88], &gn_RPKI_NODE[92], &gn_RPKI_NODE[96], &gn_RPKI_NODE[99]);
MAKE_VECTOR(gn_RPKI_NODE_49_prev, 1, &gn_RPKI_NODE[0]);
MAKE_VECTOR(gn_RPKI_NODE_50_next, 2, &gn_RPKI_NODE[51], &gn_RPKI_NODE[72]);
MAKE_VECTOR(gn_RPKI_NODE_50_prev, 1, &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_51_next, 1, &gn_RPKI_NODE[52]);
MAKE_VECTOR(gn_RPKI_NODE_51_prev, 1, &gn_RPKI_NODE[50]);
MAKE_VECTOR(gn_RPKI_NODE_52_next, 2, &gn_RPKI_NODE[53], &gn_RPKI_NODE[71]);
MAKE_VECTOR(gn_RPKI_NODE_52_prev, 1, &gn_RPKI_NODE[51]);
MAKE_VECTOR(gn_RPKI_NODE_53_next, 1, &gn_RPKI_NODE[54]);
MAKE_VECTOR(gn_RPKI_NODE_53_prev, 1, &gn_RPKI_NODE[52]);
MAKE_VECTOR(gn_RPKI_NODE_54_next, 1, &gn_RPKI_NODE[55]);
MAKE_VECTOR(gn_RPKI_NODE_54_prev, 2, &gn_RPKI_NODE[53], &gn_RPKI_NODE[71]);
MAKE_VECTOR(gn_RPKI_NODE_55_next, 1, &gn_RPKI_NODE[56]);
MAKE_VECTOR(gn_RPKI_NODE_55_prev, 1, &gn_RPKI_NODE[54]);
MAKE_VECTOR(gn_RPKI_NODE_56_next, 1, &gn_RPKI_NODE[57]);
MAKE_VECTOR(gn_RPKI_NODE_56_prev, 1, &gn_RPKI_NODE[55]);
MAKE_VECTOR(gn_RPKI_NODE_57_next, 1, &gn_RPKI_NODE[58]);
MAKE_VECTOR(gn_RPKI_NODE_57_prev, 1, &gn_RPKI_NODE[56]);
MAKE_VECTOR(gn_RPKI_NODE_58_next, 2, &gn_RPKI_NODE[59], &gn_RPKI_NODE[60]);
MAKE_VECTOR(gn_RPKI_NODE_58_prev, 1, &gn_RPKI_NODE[57]);
MAKE_VECTOR(gn_RPKI_NODE_59_next, 1, &gn_RPKI_NODE[60]);
MAKE_VECTOR(gn_RPKI_NODE_59_prev, 1, &gn_RPKI_NODE[58]);
MAKE_VECTOR(gn_RPKI_NODE_60_next, 1, &gn_RPKI_NODE[61]);
MAKE_VECTOR(gn_RPKI_NODE_60_prev, 2, &gn_RPKI_NODE[59], &gn_RPKI_NODE[58]);
MAKE_VECTOR(gn_RPKI_NODE_61_next, 2, &gn_RPKI_NODE[62], &gn_RPKI_NODE[66]);
MAKE_VECTOR(gn_RPKI_NODE_61_prev, 1, &gn_RPKI_NODE[60]);
MAKE_VECTOR(gn_RPKI_NODE_62_next, 1, &gn_RPKI_NODE[63]);
MAKE_VECTOR(gn_RPKI_NODE_62_prev, 1, &gn_RPKI_NODE[61]);
MAKE_VECTOR(gn_RPKI_NODE_63_next, 1, &gn_RPKI_NODE[64]);
MAKE_VECTOR(gn_RPKI_NODE_63_prev, 1, &gn_RPKI_NODE[62]);
MAKE_VECTOR(gn_RPKI_NODE_64_next, 1, &gn_RPKI_NODE[65]);
MAKE_VECTOR(gn_RPKI_NODE_64_prev, 1, &gn_RPKI_NODE[63]);
MAKE_VECTOR(gn_RPKI_NODE_65_next, 1, &gn_RPKI_NODE[66]);
MAKE_VECTOR(gn_RPKI_NODE_65_prev, 1, &gn_RPKI_NODE[64]);
MAKE_VECTOR(gn_RPKI_NODE_66_next, 1, &gn_RPKI_NODE[67]);
MAKE_VECTOR(gn_RPKI_NODE_66_prev, 2, &gn_RPKI_NODE[65], &gn_RPKI_NODE[61]);
MAKE_VECTOR(gn_RPKI_NODE_67_next, 1, &gn_RPKI_NODE[68]);
MAKE_VECTOR(gn_RPKI_NODE_67_prev, 1, &gn_RPKI_NODE[66]);
MAKE_VECTOR(gn_RPKI_NODE_68_next, 1, &gn_RPKI_NODE[69]);
MAKE_VECTOR(gn_RPKI_NODE_68_prev, 1, &gn_RPKI_NODE[67]);
MAKE_VECTOR(gn_RPKI_NODE_69_next, 1, &gn_RPKI_NODE[70]);
MAKE_VECTOR(gn_RPKI_NODE_69_prev, 1, &gn_RPKI_NODE[68]);
MAKE_VECTOR(gn_RPKI_NODE_70_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_70_prev, 1, &gn_RPKI_NODE[69]);
MAKE_VECTOR(gn_RPKI_NODE_71_next, 1, &gn_RPKI_NODE[54]);
MAKE_VECTOR(gn_RPKI_NODE_71_prev, 1, &gn_RPKI_NODE[52]);
MAKE_VECTOR(gn_RPKI_NODE_72_next, 1, &gn_RPKI_NODE[73]);
MAKE_VECTOR(gn_RPKI_NODE_72_prev, 1, &gn_RPKI_NODE[50]);
MAKE_VECTOR(gn_RPKI_NODE_73_next, 2, &gn_RPKI_NODE[74], &gn_RPKI_NODE[87]);
MAKE_VECTOR(gn_RPKI_NODE_73_prev, 1, &gn_RPKI_NODE[72]);
MAKE_VECTOR(gn_RPKI_NODE_74_next, 1, &gn_RPKI_NODE[75]);
MAKE_VECTOR(gn_RPKI_NODE_74_prev, 1, &gn_RPKI_NODE[73]);
MAKE_VECTOR(gn_RPKI_NODE_75_next, 1, &gn_RPKI_NODE[76]);
MAKE_VECTOR(gn_RPKI_NODE_75_prev, 2, &gn_RPKI_NODE[74], &gn_RPKI_NODE[87]);
MAKE_VECTOR(gn_RPKI_NODE_76_next, 1, &gn_RPKI_NODE[77]);
MAKE_VECTOR(gn_RPKI_NODE_76_prev, 1, &gn_RPKI_NODE[75]);
MAKE_VECTOR(gn_RPKI_NODE_77_next, 2, &gn_RPKI_NODE[78], &gn_RPKI_NODE[82]);
MAKE_VECTOR(gn_RPKI_NODE_77_prev, 1, &gn_RPKI_NODE[76]);
MAKE_VECTOR(gn_RPKI_NODE_78_next, 1, &gn_RPKI_NODE[79]);
MAKE_VECTOR(gn_RPKI_NODE_78_prev, 1, &gn_RPKI_NODE[77]);
MAKE_VECTOR(gn_RPKI_NODE_79_next, 1, &gn_RPKI_NODE[80]);
MAKE_VECTOR(gn_RPKI_NODE_79_prev, 1, &gn_RPKI_NODE[78]);
MAKE_VECTOR(gn_RPKI_NODE_80_next, 1, &gn_RPKI_NODE[81]);
MAKE_VECTOR(gn_RPKI_NODE_80_prev, 1, &gn_RPKI_NODE[79]);
MAKE_VECTOR(gn_RPKI_NODE_81_next, 1, &gn_RPKI_NODE[82]);
MAKE_VECTOR(gn_RPKI_NODE_81_prev, 1, &gn_RPKI_NODE[80]);
MAKE_VECTOR(gn_RPKI_NODE_82_next, 1, &gn_RPKI_NODE[83]);
MAKE_VECTOR(gn_RPKI_NODE_82_prev, 2, &gn_RPKI_NODE[81], &gn_RPKI_NODE[77]);
MAKE_VECTOR(gn_RPKI_NODE_83_next, 1, &gn_RPKI_NODE[84]);
MAKE_VECTOR(gn_RPKI_NODE_83_prev, 1, &gn_RPKI_NODE[82]);
MAKE_VECTOR(gn_RPKI_NODE_84_next, 1, &gn_RPKI_NODE[85]);
MAKE_VECTOR(gn_RPKI_NODE_84_prev, 1, &gn_RPKI_NODE[83]);
MAKE_VECTOR(gn_RPKI_NODE_85_next, 1, &gn_RPKI_NODE[86]);
MAKE_VECTOR(gn_RPKI_NODE_85_prev, 1, &gn_RPKI_NODE[84]);
MAKE_VECTOR(gn_RPKI_NODE_86_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_86_prev, 1, &gn_RPKI_NODE[85]);
MAKE_VECTOR(gn_RPKI_NODE_87_next, 1, &gn_RPKI_NODE[75]);
MAKE_VECTOR(gn_RPKI_NODE_87_prev, 1, &gn_RPKI_NODE[73]);
MAKE_VECTOR(gn_RPKI_NODE_88_next, 1, &gn_RPKI_NODE[89]);
MAKE_VECTOR(gn_RPKI_NODE_88_prev, 1, &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_89_next, 1, &gn_RPKI_NODE[90]);
MAKE_VECTOR(gn_RPKI_NODE_89_prev, 1, &gn_RPKI_NODE[88]);
MAKE_VECTOR(gn_RPKI_NODE_90_next, 1, &gn_RPKI_NODE[91]);
MAKE_VECTOR(gn_RPKI_NODE_90_prev, 1, &gn_RPKI_NODE[89]);
MAKE_VECTOR(gn_RPKI_NODE_91_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_91_prev, 1, &gn_RPKI_NODE[90]);
MAKE_VECTOR(gn_RPKI_NODE_92_next, 1, &gn_RPKI_NODE[93]);
MAKE_VECTOR(gn_RPKI_NODE_92_prev, 1, &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_93_next, 1, &gn_RPKI_NODE[94]);
MAKE_VECTOR(gn_RPKI_NODE_93_prev, 1, &gn_RPKI_NODE[92]);
MAKE_VECTOR(gn_RPKI_NODE_94_next, 1, &gn_RPKI_NODE[95]);
MAKE_VECTOR(gn_RPKI_NODE_94_prev, 1, &gn_RPKI_NODE[93]);
MAKE_VECTOR(gn_RPKI_NODE_95_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_95_prev, 1, &gn_RPKI_NODE[94]);
MAKE_VECTOR(gn_RPKI_NODE_96_next, 1, &gn_RPKI_NODE[97]);
MAKE_VECTOR(gn_RPKI_NODE_96_prev, 1, &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_97_next, 1, &gn_RPKI_NODE[98]);
MAKE_VECTOR(gn_RPKI_NODE_97_prev, 1, &gn_RPKI_NODE[96]);
MAKE_VECTOR(gn_RPKI_NODE_98_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_98_prev, 1, &gn_RPKI_NODE[97]);
MAKE_VECTOR(gn_RPKI_NODE_99_next, 1, &gn_RPKI_NODE[100]);
MAKE_VECTOR(gn_RPKI_NODE_99_prev, 1, &gn_RPKI_NODE[49]);
MAKE_VECTOR(gn_RPKI_NODE_100_next, 1, &gn_RPKI_NODE[101]);
MAKE_VECTOR(gn_RPKI_NODE_100_prev, 1, &gn_RPKI_NODE[99]);
MAKE_VECTOR(gn_RPKI_NODE_101_next, 1, &gn_RPKI_NODE[102]);
MAKE_VECTOR(gn_RPKI_NODE_101_prev, 1, &gn_RPKI_NODE[100]);
MAKE_VECTOR(gn_RPKI_NODE_102_next, 0, );
MAKE_VECTOR(gn_RPKI_NODE_102_prev, 1, &gn_RPKI_NODE[101]);

static struct graph_node gn_RPKI_NODE[] = {
	{
		.from = &gn_RPKI_NODE_0_prev,
		.to = &gn_RPKI_NODE_0_next,
		.data = &ctkn_RPKI_NODE[0],
	},
	{
		.from = &gn_RPKI_NODE_1_prev,
		.to = &gn_RPKI_NODE_1_next,
		.data = &ctkn_RPKI_NODE[1],
	},
	{
		.from = &gn_RPKI_NODE_2_prev,
		.to = &gn_RPKI_NODE_2_next,
		.data = &ctkn_RPKI_NODE[2],
	},
	{
		.from = &gn_RPKI_NODE_3_prev,
		.to = &gn_RPKI_NODE_3_next,
		.data = &ctkn_RPKI_NODE[3],
	},
	{
		.from = &gn_RPKI_NODE_4_prev,
		.to = &gn_RPKI_NODE_4_next,
		.data = &ctkn_RPKI_NODE[4],
	},
	{
		.from = &gn_RPKI_NODE_5_prev,
		.to = &gn_RPKI_NODE_5_next,
		.data = &ctkn_RPKI_NODE[5],
	},
	{
		.from = &gn_RPKI_NODE_6_prev,
		.to = &gn_RPKI_NODE_6_next,
		.data = &ctkn_RPKI_NODE[6],
	},
	{
		.from = &gn_RPKI_NODE_7_prev,
		.to = &gn_RPKI_NODE_7_next,
		.data = &ctkn_RPKI_NODE[7],
	},
	{
		.from = &gn_RPKI_NODE_8_prev,
		.to = &gn_RPKI_NODE_8_next,
		.data = &ctkn_RPKI_NODE[8],
	},
	{
		.from = &gn_RPKI_NODE_9_prev,
		.to = &gn_RPKI_NODE_9_next,
		.data = &ctkn_RPKI_NODE[9],
	},
	{
		.from = &gn_RPKI_NODE_10_prev,
		.to = &gn_RPKI_NODE_10_next,
		.data = &ctkn_RPKI_NODE[10],
	},
	{
		.from = &gn_RPKI_NODE_11_prev,
		.to = &gn_RPKI_NODE_11_next,
		.data = &ctkn_RPKI_NODE[11],
	},
	{
		.from = &gn_RPKI_NODE_12_prev,
		.to = &gn_RPKI_NODE_12_next,
		.data = &ctkn_RPKI_NODE[12],
	},
	{
		.from = &gn_RPKI_NODE_13_prev,
		.to = &gn_RPKI_NODE_13_next,
		.data = &ctkn_RPKI_NODE[13],
	},
	{
		.from = &gn_RPKI_NODE_14_prev,
		.to = &gn_RPKI_NODE_14_next,
		.data = &ctkn_RPKI_NODE[14],
	},
	{
		.from = &gn_RPKI_NODE_15_prev,
		.to = &gn_RPKI_NODE_15_next,
		.data = &ctkn_RPKI_NODE[15],
	},
	{
		.from = &gn_RPKI_NODE_16_prev,
		.to = &gn_RPKI_NODE_16_next,
		.data = &ctkn_RPKI_NODE[16],
	},
	{
		.from = &gn_RPKI_NODE_17_prev,
		.to = &gn_RPKI_NODE_17_next,
		.data = &ctkn_RPKI_NODE[17],
	},
	{
		.from = &gn_RPKI_NODE_18_prev,
		.to = &gn_RPKI_NODE_18_next,
		.data = &ctkn_RPKI_NODE[18],
	},
	{
		.from = &gn_RPKI_NODE_19_prev,
		.to = &gn_RPKI_NODE_19_next,
		.data = &ctkn_RPKI_NODE[19],
	},
	{
		.from = &gn_RPKI_NODE_20_prev,
		.to = &gn_RPKI_NODE_20_next,
		.data = &ctkn_RPKI_NODE[20],
	},
	{
		.from = &gn_RPKI_NODE_21_prev,
		.to = &gn_RPKI_NODE_21_next,
		.data = &ctkn_RPKI_NODE[21],
	},
	{
		.from = &gn_RPKI_NODE_22_prev,
		.to = &gn_RPKI_NODE_22_next,
		.data = (void *)&no_rpki_cache_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_23_prev,
		.to = &gn_RPKI_NODE_23_next,
		.data = &ctkn_RPKI_NODE[23],
	},
	{
		.from = &gn_RPKI_NODE_24_prev,
		.to = &gn_RPKI_NODE_24_next,
		.data = &ctkn_RPKI_NODE[24],
	},
	{
		.from = &gn_RPKI_NODE_25_prev,
		.to = &gn_RPKI_NODE_25_next,
		.data = &ctkn_RPKI_NODE[25],
	},
	{
		.from = &gn_RPKI_NODE_26_prev,
		.to = &gn_RPKI_NODE_26_next,
		.data = &ctkn_RPKI_NODE[26],
	},
	{
		.from = &gn_RPKI_NODE_27_prev,
		.to = &gn_RPKI_NODE_27_next,
		.data = &ctkn_RPKI_NODE[27],
	},
	{
		.from = &gn_RPKI_NODE_28_prev,
		.to = &gn_RPKI_NODE_28_next,
		.data = &ctkn_RPKI_NODE[28],
	},
	{
		.from = &gn_RPKI_NODE_29_prev,
		.to = &gn_RPKI_NODE_29_next,
		.data = &ctkn_RPKI_NODE[29],
	},
	{
		.from = &gn_RPKI_NODE_30_prev,
		.to = &gn_RPKI_NODE_30_next,
		.data = &ctkn_RPKI_NODE[30],
	},
	{
		.from = &gn_RPKI_NODE_31_prev,
		.to = &gn_RPKI_NODE_31_next,
		.data = &ctkn_RPKI_NODE[31],
	},
	{
		.from = &gn_RPKI_NODE_32_prev,
		.to = &gn_RPKI_NODE_32_next,
		.data = &ctkn_RPKI_NODE[32],
	},
	{
		.from = &gn_RPKI_NODE_33_prev,
		.to = &gn_RPKI_NODE_33_next,
		.data = &ctkn_RPKI_NODE[33],
	},
	{
		.from = &gn_RPKI_NODE_34_prev,
		.to = &gn_RPKI_NODE_34_next,
		.data = &ctkn_RPKI_NODE[34],
	},
	{
		.from = &gn_RPKI_NODE_35_prev,
		.to = &gn_RPKI_NODE_35_next,
		.data = &ctkn_RPKI_NODE[35],
	},
	{
		.from = &gn_RPKI_NODE_36_prev,
		.to = &gn_RPKI_NODE_36_next,
		.data = (void *)&no_rpki_expire_interval_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_37_prev,
		.to = &gn_RPKI_NODE_37_next,
		.data = &ctkn_RPKI_NODE[37],
	},
	{
		.from = &gn_RPKI_NODE_38_prev,
		.to = &gn_RPKI_NODE_38_next,
		.data = &ctkn_RPKI_NODE[38],
	},
	{
		.from = &gn_RPKI_NODE_39_prev,
		.to = &gn_RPKI_NODE_39_next,
		.data = &ctkn_RPKI_NODE[39],
	},
	{
		.from = &gn_RPKI_NODE_40_prev,
		.to = &gn_RPKI_NODE_40_next,
		.data = &ctkn_RPKI_NODE[40],
	},
	{
		.from = &gn_RPKI_NODE_41_prev,
		.to = &gn_RPKI_NODE_41_next,
		.data = &ctkn_RPKI_NODE[41],
	},
	{
		.from = &gn_RPKI_NODE_42_prev,
		.to = &gn_RPKI_NODE_42_next,
		.data = (void *)&no_rpki_polling_period_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_43_prev,
		.to = &gn_RPKI_NODE_43_next,
		.data = &ctkn_RPKI_NODE[43],
	},
	{
		.from = &gn_RPKI_NODE_44_prev,
		.to = &gn_RPKI_NODE_44_next,
		.data = &ctkn_RPKI_NODE[44],
	},
	{
		.from = &gn_RPKI_NODE_45_prev,
		.to = &gn_RPKI_NODE_45_next,
		.data = &ctkn_RPKI_NODE[45],
	},
	{
		.from = &gn_RPKI_NODE_46_prev,
		.to = &gn_RPKI_NODE_46_next,
		.data = &ctkn_RPKI_NODE[46],
	},
	{
		.from = &gn_RPKI_NODE_47_prev,
		.to = &gn_RPKI_NODE_47_next,
		.data = &ctkn_RPKI_NODE[47],
	},
	{
		.from = &gn_RPKI_NODE_48_prev,
		.to = &gn_RPKI_NODE_48_next,
		.data = (void *)&no_rpki_retry_interval_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_49_prev,
		.to = &gn_RPKI_NODE_49_next,
		.data = &ctkn_RPKI_NODE[49],
	},
	{
		.from = &gn_RPKI_NODE_50_prev,
		.to = &gn_RPKI_NODE_50_next,
		.data = &ctkn_RPKI_NODE[50],
	},
	{
		.from = &gn_RPKI_NODE_51_prev,
		.to = &gn_RPKI_NODE_51_next,
		.data = &ctkn_RPKI_NODE[51],
	},
	{
		.from = &gn_RPKI_NODE_52_prev,
		.to = &gn_RPKI_NODE_52_next,
		.data = &ctkn_RPKI_NODE[52],
	},
	{
		.from = &gn_RPKI_NODE_53_prev,
		.to = &gn_RPKI_NODE_53_next,
		.data = &ctkn_RPKI_NODE[53],
	},
	{
		.from = &gn_RPKI_NODE_54_prev,
		.to = &gn_RPKI_NODE_54_next,
		.data = &ctkn_RPKI_NODE[54],
	},
	{
		.from = &gn_RPKI_NODE_55_prev,
		.to = &gn_RPKI_NODE_55_next,
		.data = &ctkn_RPKI_NODE[55],
	},
	{
		.from = &gn_RPKI_NODE_56_prev,
		.to = &gn_RPKI_NODE_56_next,
		.data = &ctkn_RPKI_NODE[56],
	},
	{
		.from = &gn_RPKI_NODE_57_prev,
		.to = &gn_RPKI_NODE_57_next,
		.data = &ctkn_RPKI_NODE[57],
	},
	{
		.from = &gn_RPKI_NODE_58_prev,
		.to = &gn_RPKI_NODE_58_next,
		.data = &ctkn_RPKI_NODE[58],
	},
	{
		.from = &gn_RPKI_NODE_59_prev,
		.to = &gn_RPKI_NODE_59_next,
		.data = &ctkn_RPKI_NODE[59],
	},
	{
		.from = &gn_RPKI_NODE_60_prev,
		.to = &gn_RPKI_NODE_60_next,
		.data = &ctkn_RPKI_NODE[60],
	},
	{
		.from = &gn_RPKI_NODE_61_prev,
		.to = &gn_RPKI_NODE_61_next,
		.data = &ctkn_RPKI_NODE[61],
	},
	{
		.from = &gn_RPKI_NODE_62_prev,
		.to = &gn_RPKI_NODE_62_next,
		.data = &ctkn_RPKI_NODE[62],
	},
	{
		.from = &gn_RPKI_NODE_63_prev,
		.to = &gn_RPKI_NODE_63_next,
		.data = &ctkn_RPKI_NODE[63],
	},
	{
		.from = &gn_RPKI_NODE_64_prev,
		.to = &gn_RPKI_NODE_64_next,
		.data = &ctkn_RPKI_NODE[64],
	},
	{
		.from = &gn_RPKI_NODE_65_prev,
		.to = &gn_RPKI_NODE_65_next,
		.data = &ctkn_RPKI_NODE[65],
	},
	{
		.from = &gn_RPKI_NODE_66_prev,
		.to = &gn_RPKI_NODE_66_next,
		.data = &ctkn_RPKI_NODE[66],
	},
	{
		.from = &gn_RPKI_NODE_67_prev,
		.to = &gn_RPKI_NODE_67_next,
		.data = &ctkn_RPKI_NODE[67],
	},
	{
		.from = &gn_RPKI_NODE_68_prev,
		.to = &gn_RPKI_NODE_68_next,
		.data = &ctkn_RPKI_NODE[68],
	},
	{
		.from = &gn_RPKI_NODE_69_prev,
		.to = &gn_RPKI_NODE_69_next,
		.data = &ctkn_RPKI_NODE[69],
	},
	{
		.from = &gn_RPKI_NODE_70_prev,
		.to = &gn_RPKI_NODE_70_next,
		.data = (void *)&rpki_cache_ssh_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_71_prev,
		.to = &gn_RPKI_NODE_71_next,
		.data = &ctkn_RPKI_NODE[71],
	},
	{
		.from = &gn_RPKI_NODE_72_prev,
		.to = &gn_RPKI_NODE_72_next,
		.data = &ctkn_RPKI_NODE[72],
	},
	{
		.from = &gn_RPKI_NODE_73_prev,
		.to = &gn_RPKI_NODE_73_next,
		.data = &ctkn_RPKI_NODE[73],
	},
	{
		.from = &gn_RPKI_NODE_74_prev,
		.to = &gn_RPKI_NODE_74_next,
		.data = &ctkn_RPKI_NODE[74],
	},
	{
		.from = &gn_RPKI_NODE_75_prev,
		.to = &gn_RPKI_NODE_75_next,
		.data = &ctkn_RPKI_NODE[75],
	},
	{
		.from = &gn_RPKI_NODE_76_prev,
		.to = &gn_RPKI_NODE_76_next,
		.data = &ctkn_RPKI_NODE[76],
	},
	{
		.from = &gn_RPKI_NODE_77_prev,
		.to = &gn_RPKI_NODE_77_next,
		.data = &ctkn_RPKI_NODE[77],
	},
	{
		.from = &gn_RPKI_NODE_78_prev,
		.to = &gn_RPKI_NODE_78_next,
		.data = &ctkn_RPKI_NODE[78],
	},
	{
		.from = &gn_RPKI_NODE_79_prev,
		.to = &gn_RPKI_NODE_79_next,
		.data = &ctkn_RPKI_NODE[79],
	},
	{
		.from = &gn_RPKI_NODE_80_prev,
		.to = &gn_RPKI_NODE_80_next,
		.data = &ctkn_RPKI_NODE[80],
	},
	{
		.from = &gn_RPKI_NODE_81_prev,
		.to = &gn_RPKI_NODE_81_next,
		.data = &ctkn_RPKI_NODE[81],
	},
	{
		.from = &gn_RPKI_NODE_82_prev,
		.to = &gn_RPKI_NODE_82_next,
		.data = &ctkn_RPKI_NODE[82],
	},
	{
		.from = &gn_RPKI_NODE_83_prev,
		.to = &gn_RPKI_NODE_83_next,
		.data = &ctkn_RPKI_NODE[83],
	},
	{
		.from = &gn_RPKI_NODE_84_prev,
		.to = &gn_RPKI_NODE_84_next,
		.data = &ctkn_RPKI_NODE[84],
	},
	{
		.from = &gn_RPKI_NODE_85_prev,
		.to = &gn_RPKI_NODE_85_next,
		.data = &ctkn_RPKI_NODE[85],
	},
	{
		.from = &gn_RPKI_NODE_86_prev,
		.to = &gn_RPKI_NODE_86_next,
		.data = (void *)&rpki_cache_tcp_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_87_prev,
		.to = &gn_RPKI_NODE_87_next,
		.data = &ctkn_RPKI_NODE[87],
	},
	{
		.from = &gn_RPKI_NODE_88_prev,
		.to = &gn_RPKI_NODE_88_next,
		.data = &ctkn_RPKI_NODE[88],
	},
	{
		.from = &gn_RPKI_NODE_89_prev,
		.to = &gn_RPKI_NODE_89_next,
		.data = &ctkn_RPKI_NODE[89],
	},
	{
		.from = &gn_RPKI_NODE_90_prev,
		.to = &gn_RPKI_NODE_90_next,
		.data = &ctkn_RPKI_NODE[90],
	},
	{
		.from = &gn_RPKI_NODE_91_prev,
		.to = &gn_RPKI_NODE_91_next,
		.data = (void *)&rpki_expire_interval_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_92_prev,
		.to = &gn_RPKI_NODE_92_next,
		.data = &ctkn_RPKI_NODE[92],
	},
	{
		.from = &gn_RPKI_NODE_93_prev,
		.to = &gn_RPKI_NODE_93_next,
		.data = &ctkn_RPKI_NODE[93],
	},
	{
		.from = &gn_RPKI_NODE_94_prev,
		.to = &gn_RPKI_NODE_94_next,
		.data = &ctkn_RPKI_NODE[94],
	},
	{
		.from = &gn_RPKI_NODE_95_prev,
		.to = &gn_RPKI_NODE_95_next,
		.data = (void *)&rpki_polling_period_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_96_prev,
		.to = &gn_RPKI_NODE_96_next,
		.data = &ctkn_RPKI_NODE[96],
	},
	{
		.from = &gn_RPKI_NODE_97_prev,
		.to = &gn_RPKI_NODE_97_next,
		.data = &ctkn_RPKI_NODE[97],
	},
	{
		.from = &gn_RPKI_NODE_98_prev,
		.to = &gn_RPKI_NODE_98_next,
		.data = (void *)&rpki_reset_config_mode_cmd_vtysh,
	},
	{
		.from = &gn_RPKI_NODE_99_prev,
		.to = &gn_RPKI_NODE_99_next,
		.data = &ctkn_RPKI_NODE[99],
	},
	{
		.from = &gn_RPKI_NODE_100_prev,
		.to = &gn_RPKI_NODE_100_next,
		.data = &ctkn_RPKI_NODE[100],
	},
	{
		.from = &gn_RPKI_NODE_101_prev,
		.to = &gn_RPKI_NODE_101_next,
		.data = &ctkn_RPKI_NODE[101],
	},
	{
		.from = &gn_RPKI_NODE_102_prev,
		.to = &gn_RPKI_NODE_102_next,
		.data = (void *)&rpki_retry_interval_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_RPKI_NODE, 103, &gn_RPKI_NODE[0], &gn_RPKI_NODE[1], &gn_RPKI_NODE[2], &gn_RPKI_NODE[3], &gn_RPKI_NODE[4], &gn_RPKI_NODE[5], &gn_RPKI_NODE[6], &gn_RPKI_NODE[7], &gn_RPKI_NODE[8], &gn_RPKI_NODE[9], &gn_RPKI_NODE[10], &gn_RPKI_NODE[11], &gn_RPKI_NODE[12], &gn_RPKI_NODE[13], &gn_RPKI_NODE[14], &gn_RPKI_NODE[15], &gn_RPKI_NODE[16], &gn_RPKI_NODE[17], &gn_RPKI_NODE[18], &gn_RPKI_NODE[19], &gn_RPKI_NODE[20], &gn_RPKI_NODE[21], &gn_RPKI_NODE[22], &gn_RPKI_NODE[23], &gn_RPKI_NODE[24], &gn_RPKI_NODE[25], &gn_RPKI_NODE[26], &gn_RPKI_NODE[27], &gn_RPKI_NODE[28], &gn_RPKI_NODE[29], &gn_RPKI_NODE[30], &gn_RPKI_NODE[31], &gn_RPKI_NODE[32], &gn_RPKI_NODE[33], &gn_RPKI_NODE[34], &gn_RPKI_NODE[35], &gn_RPKI_NODE[36], &gn_RPKI_NODE[37], &gn_RPKI_NODE[38], &gn_RPKI_NODE[39], &gn_RPKI_NODE[40], &gn_RPKI_NODE[41], &gn_RPKI_NODE[42], &gn_RPKI_NODE[43], &gn_RPKI_NODE[44], &gn_RPKI_NODE[45], &gn_RPKI_NODE[46], &gn_RPKI_NODE[47], &gn_RPKI_NODE[48], &gn_RPKI_NODE[49], &gn_RPKI_NODE[50], &gn_RPKI_NODE[51], &gn_RPKI_NODE[52], &gn_RPKI_NODE[53], &gn_RPKI_NODE[54], &gn_RPKI_NODE[55], &gn_RPKI_NODE[56], &gn_RPKI_NODE[57], &gn_RPKI_NODE[58], &gn_RPKI_NODE[59], &gn_RPKI_NODE[60], &gn_RPKI_NODE[61], &gn_RPKI_NODE[62], &gn_RPKI_NODE[63], &gn_RPKI_NODE[64], &gn_RPKI_NODE[65], &gn_RPKI_NODE[66], &gn_RPKI_NODE[67], &gn_RPKI_NODE[68], &gn_RPKI_NODE[69], &gn_RPKI_NODE[70], &gn_RPKI_NODE[71], &gn_RPKI_NODE[72], &gn_RPKI_NODE[73], &gn_RPKI_NODE[74], &gn_RPKI_NODE[75], &gn_RPKI_NODE[76], &gn_RPKI_NODE[77], &gn_RPKI_NODE[78], &gn_RPKI_NODE[79], &gn_RPKI_NODE[80], &gn_RPKI_NODE[81], &gn_RPKI_NODE[82], &gn_RPKI_NODE[83], &gn_RPKI_NODE[84], &gn_RPKI_NODE[85], &gn_RPKI_NODE[86], &gn_RPKI_NODE[87], &gn_RPKI_NODE[88], &gn_RPKI_NODE[89], &gn_RPKI_NODE[90], &gn_RPKI_NODE[91], &gn_RPKI_NODE[92], &gn_RPKI_NODE[93], &gn_RPKI_NODE[94], &gn_RPKI_NODE[95], &gn_RPKI_NODE[96], &gn_RPKI_NODE[97], &gn_RPKI_NODE[98], &gn_RPKI_NODE[99], &gn_RPKI_NODE[100], &gn_RPKI_NODE[101], &gn_RPKI_NODE[102]);

extern void install_RPKI_NODE(void);

void install_RPKI_NODE(void)

{
	unsigned node_id = RPKI_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_RPKI_NODE;
	vector_set(node->cmd_vector, &no_rpki_cache_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rpki_expire_interval_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rpki_polling_period_cmd_vtysh);
	vector_set(node->cmd_vector, &no_rpki_retry_interval_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_cache_ssh_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_cache_tcp_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_expire_interval_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_polling_period_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_reset_config_mode_cmd_vtysh);
	vector_set(node->cmd_vector, &rpki_retry_interval_cmd_vtysh);
}

static struct cmd_token ctkn_BMP_NODE[];
static struct graph_node gn_BMP_NODE[];

static struct cmd_token ctkn_BMP_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[1],
	},
	{ /* [4] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[6],
	},
	{ /* [5] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ip",
		.desc = (char *)"IP information",
		.varname = (char *)"af",
	},
	{ /* [6] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[4],
	},
	{ /* [7] */
		.type = WORD_TKN,
		.text = (char *)"access-list",
		.desc = (char *)"Access list to restrict BMP sessions",
	},
	{ /* [8] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"ACCESSLIST_NAME",
		.desc = (char *)"Access list name",
		.varname = (char *)"access_list",
	},
	{ /* [9] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [10] = bmp_acl_cmd */ },
	{ /* [11] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"ipv6",
		.desc = (char *)"IPv6 information",
		.varname = (char *)"af",
	},
	{ /* [12] */
		.type = WORD_TKN,
		.text = (char *)"bmp",
		.desc = (char *)"BGP Monitoring Protocol",
	},
	{ /* [13] */
		.type = WORD_TKN,
		.text = (char *)"connect",
		.desc = (char *)"Actively establish connection to monitoring station",
	},
	{ /* [14] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"HOSTNAME",
		.desc = (char *)"Monitoring station hostname or address",
		.varname = (char *)"hostname",
	},
	{ /* [15] */
		.type = WORD_TKN,
		.text = (char *)"port",
		.desc = (char *)"TCP port",
	},
	{ /* [16] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"TCP port",
		.min = 1,
		.max = 65535,
		.varname = (char *)"port",
	},
	{ /* [17] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[20],
	},
	{ /* [18] */
		.type = WORD_TKN,
		.text = (char *)"min-retry",
		.desc = (char *)"Minimum connection retry interval",
	},
	{ /* [19] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-86400000)",
		.desc = (char *)"Minimum connection retry interval (milliseconds)",
		.min = 100,
		.max = 86400000,
		.varname = (char *)"min_retry",
	},
	{ /* [20] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[17],
	},
	{ /* [21] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[26],
	},
	{ /* [22] */
		.type = WORD_TKN,
		.text = (char *)"source-interface",
		.desc = (char *)"Source interface to use",
	},
	{ /* [23] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[25],
	},
	{ /* [24] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"WORD",
		.desc = (char *)"Define an interface",
		.varname = (char *)"srcif",
	},
	{ /* [25] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[23],
	},
	{ /* [26] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[21],
	},
	{ /* [27] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [28] = bmp_connect_cmd */ },
	{ /* [29] */
		.type = WORD_TKN,
		.text = (char *)"max-retry",
		.desc = (char *)"Maximum connection retry interval",
	},
	{ /* [30] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-86400000)",
		.desc = (char *)"Maximum connection retry interval (milliseconds)",
		.min = 100,
		.max = 86400000,
		.varname = (char *)"max_retry",
	},
	{ /* [31] */
		.type = WORD_TKN,
		.text = (char *)"import-vrf-view",
		.desc = (char *)"Import BMP information from another VRF",
	},
	{ /* [32] */
		.type = VARIABLE_TKN,
		.varname_src = 4,
		.text = (char *)"VRFNAME",
		.desc = (char *)"Specify the VRF or view instance name",
		.varname = (char *)"vrfname",
	},
	{ /* [33] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [34] = bmp_import_vrf_cmd */ },
	{ /* [35] */
		.type = WORD_TKN,
		.text = (char *)"mirror",
		.desc = (char *)"Send BMP route mirroring messages",
	},
	{ /* [36] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [37] = bmp_mirror_cmd */ },
	{ /* [38] */
		.type = WORD_TKN,
		.text = (char *)"monitor",
		.desc = (char *)"Send BMP route monitoring messages",
	},
	{ /* [39] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[41],
	},
	{ /* [40] */
		.type = WORD_TKN,
		.text = (char *)"ipv4",
		.desc = (char *)"Address Family",
	},
	{ /* [41] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[39],
	},
	{ /* [42] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[44],
	},
	{ /* [43] */
		.type = WORD_TKN,
		.text = (char *)"unicast",
		.desc = (char *)"Address Family",
	},
	{ /* [44] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[42],
	},
	{ /* [45] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[47],
	},
	{ /* [46] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"pre-policy",
		.desc = (char *)"Send state before policy and filter processing",
		.varname = (char *)"policy",
	},
	{ /* [47] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[45],
	},
	{ /* [48] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [49] = bmp_monitor_cmd */ },
	{ /* [50] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"post-policy",
		.desc = (char *)"Send state with policy and filters applied",
		.varname = (char *)"policy",
	},
	{ /* [51] */
		.type = WORD_TKN,
		.varname_src = 4,
		.text = (char *)"loc-rib",
		.desc = (char *)"Send state after decision process is applied",
		.varname = (char *)"policy",
	},
	{ /* [52] */
		.type = WORD_TKN,
		.text = (char *)"multicast",
		.desc = (char *)"Address Family",
	},
	{ /* [53] */
		.type = WORD_TKN,
		.text = (char *)"evpn",
		.desc = (char *)"Address Family",
	},
	{ /* [54] */
		.type = WORD_TKN,
		.text = (char *)"vpn",
		.desc = (char *)"Address Family",
	},
	{ /* [55] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"Address Family",
	},
	{ /* [56] */
		.type = WORD_TKN,
		.text = (char *)"l2vpn",
		.desc = (char *)"Address Family",
	},
	{ /* [57] */
		.type = WORD_TKN,
		.text = (char *)"stats",
		.desc = (char *)"Send BMP statistics messages",
	},
	{ /* [58] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[61],
	},
	{ /* [59] */
		.type = WORD_TKN,
		.text = (char *)"interval",
		.desc = (char *)"Specify BMP stats interval",
	},
	{ /* [60] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(100-86400000)",
		.desc = (char *)"Interval (milliseconds) to send BMP Stats in",
		.min = 100,
		.max = 86400000,
		.varname = (char *)"interval",
	},
	{ /* [61] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[58],
	},
	{ /* [62] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [63] = bmp_stats_cmd */ },
	{ /* [64] */
		.type = WORD_TKN,
		.text = (char *)"send-experimental",
		.desc = (char *)"Send experimental BMP stats [65531-65534]",
	},
	{ /* [65] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [66] = bmp_stats_send_experimental_cmd */ },
	{ /* [67] */
		.type = WORD_TKN,
		.text = (char *)"bmp",
		.desc = (char *)"BGP Monitoring Protocol",
	},
	{ /* [68] */
		.type = WORD_TKN,
		.text = (char *)"listener",
		.desc = (char *)"Listen for inbound BMP connections",
	},
	{ /* [69] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[71],
	},
	{ /* [70] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address to listen on",
		.varname = (char *)"listener",
	},
	{ /* [71] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[69],
	},
	{ /* [72] */
		.type = WORD_TKN,
		.text = (char *)"port",
		.desc = (char *)"TCP Port number",
	},
	{ /* [73] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"TCP Port number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"port",
	},
	{ /* [74] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [75] = bmp_listener_cmd */ },
	{ /* [76] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IPv4 address to listen on",
		.varname = (char *)"listener",
	},
	{ /* [77] */
		.type = WORD_TKN,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
	},
	{ /* [78] */
		.type = WORD_TKN,
		.text = (char *)"bmp",
		.desc = (char *)"BGP Monitoring Protocol",
	},
	{ /* [79] */
		.type = WORD_TKN,
		.text = (char *)"listener",
		.desc = (char *)"Create BMP listener",
	},
	{ /* [80] */
		.type = FORK_TKN,
		.forkjoin = &gn_BMP_NODE[82],
	},
	{ /* [81] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"IPv6 address to listen on",
		.varname = (char *)"listener",
	},
	{ /* [82] */
		.type = JOIN_TKN,
		.forkjoin = &gn_BMP_NODE[80],
	},
	{ /* [83] */
		.type = WORD_TKN,
		.text = (char *)"port",
		.desc = (char *)"TCP Port number",
	},
	{ /* [84] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-65535)",
		.desc = (char *)"TCP Port number",
		.min = 1,
		.max = 65535,
		.varname = (char *)"port",
	},
	{ /* [85] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [86] = no_bmp_listener_cmd */ },
	{ /* [87] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"IPv4 address to listen on",
		.varname = (char *)"listener",
	},
};

extern struct cmd_element bmp_acl_cmd_vtysh;
extern struct cmd_element bmp_connect_cmd_vtysh;
extern struct cmd_element bmp_import_vrf_cmd_vtysh;
extern struct cmd_element bmp_listener_cmd_vtysh;
extern struct cmd_element bmp_mirror_cmd_vtysh;
extern struct cmd_element bmp_monitor_cmd_vtysh;
extern struct cmd_element bmp_stats_cmd_vtysh;
extern struct cmd_element bmp_stats_send_experimental_cmd_vtysh;
extern struct cmd_element no_bmp_listener_cmd_vtysh;

MAKE_VECTOR(gn_BMP_NODE_0_next, 3, &gn_BMP_NODE[1], &gn_BMP_NODE[67], &gn_BMP_NODE[77]);
MAKE_VECTOR(gn_BMP_NODE_0_prev, 0, );
MAKE_VECTOR(gn_BMP_NODE_1_next, 2, &gn_BMP_NODE[2], &gn_BMP_NODE[3]);
MAKE_VECTOR(gn_BMP_NODE_1_prev, 1, &gn_BMP_NODE[0]);
MAKE_VECTOR(gn_BMP_NODE_2_next, 1, &gn_BMP_NODE[3]);
MAKE_VECTOR(gn_BMP_NODE_2_prev, 1, &gn_BMP_NODE[1]);
MAKE_VECTOR(gn_BMP_NODE_3_next, 2, &gn_BMP_NODE[4], &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_3_prev, 2, &gn_BMP_NODE[2], &gn_BMP_NODE[1]);
MAKE_VECTOR(gn_BMP_NODE_4_next, 2, &gn_BMP_NODE[5], &gn_BMP_NODE[11]);
MAKE_VECTOR(gn_BMP_NODE_4_prev, 1, &gn_BMP_NODE[3]);
MAKE_VECTOR(gn_BMP_NODE_5_next, 1, &gn_BMP_NODE[6]);
MAKE_VECTOR(gn_BMP_NODE_5_prev, 1, &gn_BMP_NODE[4]);
MAKE_VECTOR(gn_BMP_NODE_6_next, 1, &gn_BMP_NODE[7]);
MAKE_VECTOR(gn_BMP_NODE_6_prev, 2, &gn_BMP_NODE[5], &gn_BMP_NODE[11]);
MAKE_VECTOR(gn_BMP_NODE_7_next, 1, &gn_BMP_NODE[8]);
MAKE_VECTOR(gn_BMP_NODE_7_prev, 1, &gn_BMP_NODE[6]);
MAKE_VECTOR(gn_BMP_NODE_8_next, 1, &gn_BMP_NODE[9]);
MAKE_VECTOR(gn_BMP_NODE_8_prev, 1, &gn_BMP_NODE[7]);
MAKE_VECTOR(gn_BMP_NODE_9_next, 1, &gn_BMP_NODE[10]);
MAKE_VECTOR(gn_BMP_NODE_9_prev, 1, &gn_BMP_NODE[8]);
MAKE_VECTOR(gn_BMP_NODE_10_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_10_prev, 1, &gn_BMP_NODE[9]);
MAKE_VECTOR(gn_BMP_NODE_11_next, 1, &gn_BMP_NODE[6]);
MAKE_VECTOR(gn_BMP_NODE_11_prev, 1, &gn_BMP_NODE[4]);
MAKE_VECTOR(gn_BMP_NODE_12_next, 5, &gn_BMP_NODE[13], &gn_BMP_NODE[31], &gn_BMP_NODE[35], &gn_BMP_NODE[38], &gn_BMP_NODE[57]);
MAKE_VECTOR(gn_BMP_NODE_12_prev, 1, &gn_BMP_NODE[3]);
MAKE_VECTOR(gn_BMP_NODE_13_next, 1, &gn_BMP_NODE[14]);
MAKE_VECTOR(gn_BMP_NODE_13_prev, 1, &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_14_next, 1, &gn_BMP_NODE[15]);
MAKE_VECTOR(gn_BMP_NODE_14_prev, 1, &gn_BMP_NODE[13]);
MAKE_VECTOR(gn_BMP_NODE_15_next, 1, &gn_BMP_NODE[16]);
MAKE_VECTOR(gn_BMP_NODE_15_prev, 1, &gn_BMP_NODE[14]);
MAKE_VECTOR(gn_BMP_NODE_16_next, 1, &gn_BMP_NODE[17]);
MAKE_VECTOR(gn_BMP_NODE_16_prev, 1, &gn_BMP_NODE[15]);
MAKE_VECTOR(gn_BMP_NODE_17_next, 2, &gn_BMP_NODE[18], &gn_BMP_NODE[29]);
MAKE_VECTOR(gn_BMP_NODE_17_prev, 2, &gn_BMP_NODE[20], &gn_BMP_NODE[16]);
MAKE_VECTOR(gn_BMP_NODE_18_next, 1, &gn_BMP_NODE[19]);
MAKE_VECTOR(gn_BMP_NODE_18_prev, 1, &gn_BMP_NODE[17]);
MAKE_VECTOR(gn_BMP_NODE_19_next, 1, &gn_BMP_NODE[20]);
MAKE_VECTOR(gn_BMP_NODE_19_prev, 1, &gn_BMP_NODE[18]);
MAKE_VECTOR(gn_BMP_NODE_20_next, 2, &gn_BMP_NODE[17], &gn_BMP_NODE[21]);
MAKE_VECTOR(gn_BMP_NODE_20_prev, 2, &gn_BMP_NODE[19], &gn_BMP_NODE[30]);
MAKE_VECTOR(gn_BMP_NODE_21_next, 2, &gn_BMP_NODE[22], &gn_BMP_NODE[26]);
MAKE_VECTOR(gn_BMP_NODE_21_prev, 1, &gn_BMP_NODE[20]);
MAKE_VECTOR(gn_BMP_NODE_22_next, 1, &gn_BMP_NODE[23]);
MAKE_VECTOR(gn_BMP_NODE_22_prev, 1, &gn_BMP_NODE[21]);
MAKE_VECTOR(gn_BMP_NODE_23_next, 1, &gn_BMP_NODE[24]);
MAKE_VECTOR(gn_BMP_NODE_23_prev, 1, &gn_BMP_NODE[22]);
MAKE_VECTOR(gn_BMP_NODE_24_next, 1, &gn_BMP_NODE[25]);
MAKE_VECTOR(gn_BMP_NODE_24_prev, 1, &gn_BMP_NODE[23]);
MAKE_VECTOR(gn_BMP_NODE_25_next, 1, &gn_BMP_NODE[26]);
MAKE_VECTOR(gn_BMP_NODE_25_prev, 1, &gn_BMP_NODE[24]);
MAKE_VECTOR(gn_BMP_NODE_26_next, 1, &gn_BMP_NODE[27]);
MAKE_VECTOR(gn_BMP_NODE_26_prev, 2, &gn_BMP_NODE[25], &gn_BMP_NODE[21]);
MAKE_VECTOR(gn_BMP_NODE_27_next, 1, &gn_BMP_NODE[28]);
MAKE_VECTOR(gn_BMP_NODE_27_prev, 1, &gn_BMP_NODE[26]);
MAKE_VECTOR(gn_BMP_NODE_28_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_28_prev, 1, &gn_BMP_NODE[27]);
MAKE_VECTOR(gn_BMP_NODE_29_next, 1, &gn_BMP_NODE[30]);
MAKE_VECTOR(gn_BMP_NODE_29_prev, 1, &gn_BMP_NODE[17]);
MAKE_VECTOR(gn_BMP_NODE_30_next, 1, &gn_BMP_NODE[20]);
MAKE_VECTOR(gn_BMP_NODE_30_prev, 1, &gn_BMP_NODE[29]);
MAKE_VECTOR(gn_BMP_NODE_31_next, 1, &gn_BMP_NODE[32]);
MAKE_VECTOR(gn_BMP_NODE_31_prev, 1, &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_32_next, 1, &gn_BMP_NODE[33]);
MAKE_VECTOR(gn_BMP_NODE_32_prev, 1, &gn_BMP_NODE[31]);
MAKE_VECTOR(gn_BMP_NODE_33_next, 1, &gn_BMP_NODE[34]);
MAKE_VECTOR(gn_BMP_NODE_33_prev, 1, &gn_BMP_NODE[32]);
MAKE_VECTOR(gn_BMP_NODE_34_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_34_prev, 1, &gn_BMP_NODE[33]);
MAKE_VECTOR(gn_BMP_NODE_35_next, 1, &gn_BMP_NODE[36]);
MAKE_VECTOR(gn_BMP_NODE_35_prev, 1, &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_36_next, 1, &gn_BMP_NODE[37]);
MAKE_VECTOR(gn_BMP_NODE_36_prev, 1, &gn_BMP_NODE[35]);
MAKE_VECTOR(gn_BMP_NODE_37_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_37_prev, 1, &gn_BMP_NODE[36]);
MAKE_VECTOR(gn_BMP_NODE_38_next, 1, &gn_BMP_NODE[39]);
MAKE_VECTOR(gn_BMP_NODE_38_prev, 1, &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_39_next, 3, &gn_BMP_NODE[40], &gn_BMP_NODE[55], &gn_BMP_NODE[56]);
MAKE_VECTOR(gn_BMP_NODE_39_prev, 1, &gn_BMP_NODE[38]);
MAKE_VECTOR(gn_BMP_NODE_40_next, 1, &gn_BMP_NODE[41]);
MAKE_VECTOR(gn_BMP_NODE_40_prev, 1, &gn_BMP_NODE[39]);
MAKE_VECTOR(gn_BMP_NODE_41_next, 1, &gn_BMP_NODE[42]);
MAKE_VECTOR(gn_BMP_NODE_41_prev, 3, &gn_BMP_NODE[40], &gn_BMP_NODE[55], &gn_BMP_NODE[56]);
MAKE_VECTOR(gn_BMP_NODE_42_next, 4, &gn_BMP_NODE[43], &gn_BMP_NODE[52], &gn_BMP_NODE[53], &gn_BMP_NODE[54]);
MAKE_VECTOR(gn_BMP_NODE_42_prev, 1, &gn_BMP_NODE[41]);
MAKE_VECTOR(gn_BMP_NODE_43_next, 1, &gn_BMP_NODE[44]);
MAKE_VECTOR(gn_BMP_NODE_43_prev, 1, &gn_BMP_NODE[42]);
MAKE_VECTOR(gn_BMP_NODE_44_next, 1, &gn_BMP_NODE[45]);
MAKE_VECTOR(gn_BMP_NODE_44_prev, 4, &gn_BMP_NODE[43], &gn_BMP_NODE[52], &gn_BMP_NODE[53], &gn_BMP_NODE[54]);
MAKE_VECTOR(gn_BMP_NODE_45_next, 3, &gn_BMP_NODE[46], &gn_BMP_NODE[50], &gn_BMP_NODE[51]);
MAKE_VECTOR(gn_BMP_NODE_45_prev, 1, &gn_BMP_NODE[44]);
MAKE_VECTOR(gn_BMP_NODE_46_next, 1, &gn_BMP_NODE[47]);
MAKE_VECTOR(gn_BMP_NODE_46_prev, 1, &gn_BMP_NODE[45]);
MAKE_VECTOR(gn_BMP_NODE_47_next, 1, &gn_BMP_NODE[48]);
MAKE_VECTOR(gn_BMP_NODE_47_prev, 3, &gn_BMP_NODE[46], &gn_BMP_NODE[50], &gn_BMP_NODE[51]);
MAKE_VECTOR(gn_BMP_NODE_48_next, 1, &gn_BMP_NODE[49]);
MAKE_VECTOR(gn_BMP_NODE_48_prev, 1, &gn_BMP_NODE[47]);
MAKE_VECTOR(gn_BMP_NODE_49_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_49_prev, 1, &gn_BMP_NODE[48]);
MAKE_VECTOR(gn_BMP_NODE_50_next, 1, &gn_BMP_NODE[47]);
MAKE_VECTOR(gn_BMP_NODE_50_prev, 1, &gn_BMP_NODE[45]);
MAKE_VECTOR(gn_BMP_NODE_51_next, 1, &gn_BMP_NODE[47]);
MAKE_VECTOR(gn_BMP_NODE_51_prev, 1, &gn_BMP_NODE[45]);
MAKE_VECTOR(gn_BMP_NODE_52_next, 1, &gn_BMP_NODE[44]);
MAKE_VECTOR(gn_BMP_NODE_52_prev, 1, &gn_BMP_NODE[42]);
MAKE_VECTOR(gn_BMP_NODE_53_next, 1, &gn_BMP_NODE[44]);
MAKE_VECTOR(gn_BMP_NODE_53_prev, 1, &gn_BMP_NODE[42]);
MAKE_VECTOR(gn_BMP_NODE_54_next, 1, &gn_BMP_NODE[44]);
MAKE_VECTOR(gn_BMP_NODE_54_prev, 1, &gn_BMP_NODE[42]);
MAKE_VECTOR(gn_BMP_NODE_55_next, 1, &gn_BMP_NODE[41]);
MAKE_VECTOR(gn_BMP_NODE_55_prev, 1, &gn_BMP_NODE[39]);
MAKE_VECTOR(gn_BMP_NODE_56_next, 1, &gn_BMP_NODE[41]);
MAKE_VECTOR(gn_BMP_NODE_56_prev, 1, &gn_BMP_NODE[39]);
MAKE_VECTOR(gn_BMP_NODE_57_next, 2, &gn_BMP_NODE[58], &gn_BMP_NODE[64]);
MAKE_VECTOR(gn_BMP_NODE_57_prev, 1, &gn_BMP_NODE[12]);
MAKE_VECTOR(gn_BMP_NODE_58_next, 2, &gn_BMP_NODE[59], &gn_BMP_NODE[61]);
MAKE_VECTOR(gn_BMP_NODE_58_prev, 1, &gn_BMP_NODE[57]);
MAKE_VECTOR(gn_BMP_NODE_59_next, 1, &gn_BMP_NODE[60]);
MAKE_VECTOR(gn_BMP_NODE_59_prev, 1, &gn_BMP_NODE[58]);
MAKE_VECTOR(gn_BMP_NODE_60_next, 1, &gn_BMP_NODE[61]);
MAKE_VECTOR(gn_BMP_NODE_60_prev, 1, &gn_BMP_NODE[59]);
MAKE_VECTOR(gn_BMP_NODE_61_next, 1, &gn_BMP_NODE[62]);
MAKE_VECTOR(gn_BMP_NODE_61_prev, 2, &gn_BMP_NODE[60], &gn_BMP_NODE[58]);
MAKE_VECTOR(gn_BMP_NODE_62_next, 1, &gn_BMP_NODE[63]);
MAKE_VECTOR(gn_BMP_NODE_62_prev, 1, &gn_BMP_NODE[61]);
MAKE_VECTOR(gn_BMP_NODE_63_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_63_prev, 1, &gn_BMP_NODE[62]);
MAKE_VECTOR(gn_BMP_NODE_64_next, 1, &gn_BMP_NODE[65]);
MAKE_VECTOR(gn_BMP_NODE_64_prev, 1, &gn_BMP_NODE[57]);
MAKE_VECTOR(gn_BMP_NODE_65_next, 1, &gn_BMP_NODE[66]);
MAKE_VECTOR(gn_BMP_NODE_65_prev, 1, &gn_BMP_NODE[64]);
MAKE_VECTOR(gn_BMP_NODE_66_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_66_prev, 1, &gn_BMP_NODE[65]);
MAKE_VECTOR(gn_BMP_NODE_67_next, 1, &gn_BMP_NODE[68]);
MAKE_VECTOR(gn_BMP_NODE_67_prev, 1, &gn_BMP_NODE[0]);
MAKE_VECTOR(gn_BMP_NODE_68_next, 1, &gn_BMP_NODE[69]);
MAKE_VECTOR(gn_BMP_NODE_68_prev, 1, &gn_BMP_NODE[67]);
MAKE_VECTOR(gn_BMP_NODE_69_next, 2, &gn_BMP_NODE[70], &gn_BMP_NODE[76]);
MAKE_VECTOR(gn_BMP_NODE_69_prev, 1, &gn_BMP_NODE[68]);
MAKE_VECTOR(gn_BMP_NODE_70_next, 1, &gn_BMP_NODE[71]);
MAKE_VECTOR(gn_BMP_NODE_70_prev, 1, &gn_BMP_NODE[69]);
MAKE_VECTOR(gn_BMP_NODE_71_next, 1, &gn_BMP_NODE[72]);
MAKE_VECTOR(gn_BMP_NODE_71_prev, 2, &gn_BMP_NODE[70], &gn_BMP_NODE[76]);
MAKE_VECTOR(gn_BMP_NODE_72_next, 1, &gn_BMP_NODE[73]);
MAKE_VECTOR(gn_BMP_NODE_72_prev, 1, &gn_BMP_NODE[71]);
MAKE_VECTOR(gn_BMP_NODE_73_next, 1, &gn_BMP_NODE[74]);
MAKE_VECTOR(gn_BMP_NODE_73_prev, 1, &gn_BMP_NODE[72]);
MAKE_VECTOR(gn_BMP_NODE_74_next, 1, &gn_BMP_NODE[75]);
MAKE_VECTOR(gn_BMP_NODE_74_prev, 1, &gn_BMP_NODE[73]);
MAKE_VECTOR(gn_BMP_NODE_75_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_75_prev, 1, &gn_BMP_NODE[74]);
MAKE_VECTOR(gn_BMP_NODE_76_next, 1, &gn_BMP_NODE[71]);
MAKE_VECTOR(gn_BMP_NODE_76_prev, 1, &gn_BMP_NODE[69]);
MAKE_VECTOR(gn_BMP_NODE_77_next, 1, &gn_BMP_NODE[78]);
MAKE_VECTOR(gn_BMP_NODE_77_prev, 1, &gn_BMP_NODE[0]);
MAKE_VECTOR(gn_BMP_NODE_78_next, 1, &gn_BMP_NODE[79]);
MAKE_VECTOR(gn_BMP_NODE_78_prev, 1, &gn_BMP_NODE[77]);
MAKE_VECTOR(gn_BMP_NODE_79_next, 1, &gn_BMP_NODE[80]);
MAKE_VECTOR(gn_BMP_NODE_79_prev, 1, &gn_BMP_NODE[78]);
MAKE_VECTOR(gn_BMP_NODE_80_next, 2, &gn_BMP_NODE[81], &gn_BMP_NODE[87]);
MAKE_VECTOR(gn_BMP_NODE_80_prev, 1, &gn_BMP_NODE[79]);
MAKE_VECTOR(gn_BMP_NODE_81_next, 1, &gn_BMP_NODE[82]);
MAKE_VECTOR(gn_BMP_NODE_81_prev, 1, &gn_BMP_NODE[80]);
MAKE_VECTOR(gn_BMP_NODE_82_next, 1, &gn_BMP_NODE[83]);
MAKE_VECTOR(gn_BMP_NODE_82_prev, 2, &gn_BMP_NODE[81], &gn_BMP_NODE[87]);
MAKE_VECTOR(gn_BMP_NODE_83_next, 1, &gn_BMP_NODE[84]);
MAKE_VECTOR(gn_BMP_NODE_83_prev, 1, &gn_BMP_NODE[82]);
MAKE_VECTOR(gn_BMP_NODE_84_next, 1, &gn_BMP_NODE[85]);
MAKE_VECTOR(gn_BMP_NODE_84_prev, 1, &gn_BMP_NODE[83]);
MAKE_VECTOR(gn_BMP_NODE_85_next, 1, &gn_BMP_NODE[86]);
MAKE_VECTOR(gn_BMP_NODE_85_prev, 1, &gn_BMP_NODE[84]);
MAKE_VECTOR(gn_BMP_NODE_86_next, 0, );
MAKE_VECTOR(gn_BMP_NODE_86_prev, 1, &gn_BMP_NODE[85]);
MAKE_VECTOR(gn_BMP_NODE_87_next, 1, &gn_BMP_NODE[82]);
MAKE_VECTOR(gn_BMP_NODE_87_prev, 1, &gn_BMP_NODE[80]);

static struct graph_node gn_BMP_NODE[] = {
	{
		.from = &gn_BMP_NODE_0_prev,
		.to = &gn_BMP_NODE_0_next,
		.data = &ctkn_BMP_NODE[0],
	},
	{
		.from = &gn_BMP_NODE_1_prev,
		.to = &gn_BMP_NODE_1_next,
		.data = &ctkn_BMP_NODE[1],
	},
	{
		.from = &gn_BMP_NODE_2_prev,
		.to = &gn_BMP_NODE_2_next,
		.data = &ctkn_BMP_NODE[2],
	},
	{
		.from = &gn_BMP_NODE_3_prev,
		.to = &gn_BMP_NODE_3_next,
		.data = &ctkn_BMP_NODE[3],
	},
	{
		.from = &gn_BMP_NODE_4_prev,
		.to = &gn_BMP_NODE_4_next,
		.data = &ctkn_BMP_NODE[4],
	},
	{
		.from = &gn_BMP_NODE_5_prev,
		.to = &gn_BMP_NODE_5_next,
		.data = &ctkn_BMP_NODE[5],
	},
	{
		.from = &gn_BMP_NODE_6_prev,
		.to = &gn_BMP_NODE_6_next,
		.data = &ctkn_BMP_NODE[6],
	},
	{
		.from = &gn_BMP_NODE_7_prev,
		.to = &gn_BMP_NODE_7_next,
		.data = &ctkn_BMP_NODE[7],
	},
	{
		.from = &gn_BMP_NODE_8_prev,
		.to = &gn_BMP_NODE_8_next,
		.data = &ctkn_BMP_NODE[8],
	},
	{
		.from = &gn_BMP_NODE_9_prev,
		.to = &gn_BMP_NODE_9_next,
		.data = &ctkn_BMP_NODE[9],
	},
	{
		.from = &gn_BMP_NODE_10_prev,
		.to = &gn_BMP_NODE_10_next,
		.data = (void *)&bmp_acl_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_11_prev,
		.to = &gn_BMP_NODE_11_next,
		.data = &ctkn_BMP_NODE[11],
	},
	{
		.from = &gn_BMP_NODE_12_prev,
		.to = &gn_BMP_NODE_12_next,
		.data = &ctkn_BMP_NODE[12],
	},
	{
		.from = &gn_BMP_NODE_13_prev,
		.to = &gn_BMP_NODE_13_next,
		.data = &ctkn_BMP_NODE[13],
	},
	{
		.from = &gn_BMP_NODE_14_prev,
		.to = &gn_BMP_NODE_14_next,
		.data = &ctkn_BMP_NODE[14],
	},
	{
		.from = &gn_BMP_NODE_15_prev,
		.to = &gn_BMP_NODE_15_next,
		.data = &ctkn_BMP_NODE[15],
	},
	{
		.from = &gn_BMP_NODE_16_prev,
		.to = &gn_BMP_NODE_16_next,
		.data = &ctkn_BMP_NODE[16],
	},
	{
		.from = &gn_BMP_NODE_17_prev,
		.to = &gn_BMP_NODE_17_next,
		.data = &ctkn_BMP_NODE[17],
	},
	{
		.from = &gn_BMP_NODE_18_prev,
		.to = &gn_BMP_NODE_18_next,
		.data = &ctkn_BMP_NODE[18],
	},
	{
		.from = &gn_BMP_NODE_19_prev,
		.to = &gn_BMP_NODE_19_next,
		.data = &ctkn_BMP_NODE[19],
	},
	{
		.from = &gn_BMP_NODE_20_prev,
		.to = &gn_BMP_NODE_20_next,
		.data = &ctkn_BMP_NODE[20],
	},
	{
		.from = &gn_BMP_NODE_21_prev,
		.to = &gn_BMP_NODE_21_next,
		.data = &ctkn_BMP_NODE[21],
	},
	{
		.from = &gn_BMP_NODE_22_prev,
		.to = &gn_BMP_NODE_22_next,
		.data = &ctkn_BMP_NODE[22],
	},
	{
		.from = &gn_BMP_NODE_23_prev,
		.to = &gn_BMP_NODE_23_next,
		.data = &ctkn_BMP_NODE[23],
	},
	{
		.from = &gn_BMP_NODE_24_prev,
		.to = &gn_BMP_NODE_24_next,
		.data = &ctkn_BMP_NODE[24],
	},
	{
		.from = &gn_BMP_NODE_25_prev,
		.to = &gn_BMP_NODE_25_next,
		.data = &ctkn_BMP_NODE[25],
	},
	{
		.from = &gn_BMP_NODE_26_prev,
		.to = &gn_BMP_NODE_26_next,
		.data = &ctkn_BMP_NODE[26],
	},
	{
		.from = &gn_BMP_NODE_27_prev,
		.to = &gn_BMP_NODE_27_next,
		.data = &ctkn_BMP_NODE[27],
	},
	{
		.from = &gn_BMP_NODE_28_prev,
		.to = &gn_BMP_NODE_28_next,
		.data = (void *)&bmp_connect_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_29_prev,
		.to = &gn_BMP_NODE_29_next,
		.data = &ctkn_BMP_NODE[29],
	},
	{
		.from = &gn_BMP_NODE_30_prev,
		.to = &gn_BMP_NODE_30_next,
		.data = &ctkn_BMP_NODE[30],
	},
	{
		.from = &gn_BMP_NODE_31_prev,
		.to = &gn_BMP_NODE_31_next,
		.data = &ctkn_BMP_NODE[31],
	},
	{
		.from = &gn_BMP_NODE_32_prev,
		.to = &gn_BMP_NODE_32_next,
		.data = &ctkn_BMP_NODE[32],
	},
	{
		.from = &gn_BMP_NODE_33_prev,
		.to = &gn_BMP_NODE_33_next,
		.data = &ctkn_BMP_NODE[33],
	},
	{
		.from = &gn_BMP_NODE_34_prev,
		.to = &gn_BMP_NODE_34_next,
		.data = (void *)&bmp_import_vrf_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_35_prev,
		.to = &gn_BMP_NODE_35_next,
		.data = &ctkn_BMP_NODE[35],
	},
	{
		.from = &gn_BMP_NODE_36_prev,
		.to = &gn_BMP_NODE_36_next,
		.data = &ctkn_BMP_NODE[36],
	},
	{
		.from = &gn_BMP_NODE_37_prev,
		.to = &gn_BMP_NODE_37_next,
		.data = (void *)&bmp_mirror_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_38_prev,
		.to = &gn_BMP_NODE_38_next,
		.data = &ctkn_BMP_NODE[38],
	},
	{
		.from = &gn_BMP_NODE_39_prev,
		.to = &gn_BMP_NODE_39_next,
		.data = &ctkn_BMP_NODE[39],
	},
	{
		.from = &gn_BMP_NODE_40_prev,
		.to = &gn_BMP_NODE_40_next,
		.data = &ctkn_BMP_NODE[40],
	},
	{
		.from = &gn_BMP_NODE_41_prev,
		.to = &gn_BMP_NODE_41_next,
		.data = &ctkn_BMP_NODE[41],
	},
	{
		.from = &gn_BMP_NODE_42_prev,
		.to = &gn_BMP_NODE_42_next,
		.data = &ctkn_BMP_NODE[42],
	},
	{
		.from = &gn_BMP_NODE_43_prev,
		.to = &gn_BMP_NODE_43_next,
		.data = &ctkn_BMP_NODE[43],
	},
	{
		.from = &gn_BMP_NODE_44_prev,
		.to = &gn_BMP_NODE_44_next,
		.data = &ctkn_BMP_NODE[44],
	},
	{
		.from = &gn_BMP_NODE_45_prev,
		.to = &gn_BMP_NODE_45_next,
		.data = &ctkn_BMP_NODE[45],
	},
	{
		.from = &gn_BMP_NODE_46_prev,
		.to = &gn_BMP_NODE_46_next,
		.data = &ctkn_BMP_NODE[46],
	},
	{
		.from = &gn_BMP_NODE_47_prev,
		.to = &gn_BMP_NODE_47_next,
		.data = &ctkn_BMP_NODE[47],
	},
	{
		.from = &gn_BMP_NODE_48_prev,
		.to = &gn_BMP_NODE_48_next,
		.data = &ctkn_BMP_NODE[48],
	},
	{
		.from = &gn_BMP_NODE_49_prev,
		.to = &gn_BMP_NODE_49_next,
		.data = (void *)&bmp_monitor_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_50_prev,
		.to = &gn_BMP_NODE_50_next,
		.data = &ctkn_BMP_NODE[50],
	},
	{
		.from = &gn_BMP_NODE_51_prev,
		.to = &gn_BMP_NODE_51_next,
		.data = &ctkn_BMP_NODE[51],
	},
	{
		.from = &gn_BMP_NODE_52_prev,
		.to = &gn_BMP_NODE_52_next,
		.data = &ctkn_BMP_NODE[52],
	},
	{
		.from = &gn_BMP_NODE_53_prev,
		.to = &gn_BMP_NODE_53_next,
		.data = &ctkn_BMP_NODE[53],
	},
	{
		.from = &gn_BMP_NODE_54_prev,
		.to = &gn_BMP_NODE_54_next,
		.data = &ctkn_BMP_NODE[54],
	},
	{
		.from = &gn_BMP_NODE_55_prev,
		.to = &gn_BMP_NODE_55_next,
		.data = &ctkn_BMP_NODE[55],
	},
	{
		.from = &gn_BMP_NODE_56_prev,
		.to = &gn_BMP_NODE_56_next,
		.data = &ctkn_BMP_NODE[56],
	},
	{
		.from = &gn_BMP_NODE_57_prev,
		.to = &gn_BMP_NODE_57_next,
		.data = &ctkn_BMP_NODE[57],
	},
	{
		.from = &gn_BMP_NODE_58_prev,
		.to = &gn_BMP_NODE_58_next,
		.data = &ctkn_BMP_NODE[58],
	},
	{
		.from = &gn_BMP_NODE_59_prev,
		.to = &gn_BMP_NODE_59_next,
		.data = &ctkn_BMP_NODE[59],
	},
	{
		.from = &gn_BMP_NODE_60_prev,
		.to = &gn_BMP_NODE_60_next,
		.data = &ctkn_BMP_NODE[60],
	},
	{
		.from = &gn_BMP_NODE_61_prev,
		.to = &gn_BMP_NODE_61_next,
		.data = &ctkn_BMP_NODE[61],
	},
	{
		.from = &gn_BMP_NODE_62_prev,
		.to = &gn_BMP_NODE_62_next,
		.data = &ctkn_BMP_NODE[62],
	},
	{
		.from = &gn_BMP_NODE_63_prev,
		.to = &gn_BMP_NODE_63_next,
		.data = (void *)&bmp_stats_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_64_prev,
		.to = &gn_BMP_NODE_64_next,
		.data = &ctkn_BMP_NODE[64],
	},
	{
		.from = &gn_BMP_NODE_65_prev,
		.to = &gn_BMP_NODE_65_next,
		.data = &ctkn_BMP_NODE[65],
	},
	{
		.from = &gn_BMP_NODE_66_prev,
		.to = &gn_BMP_NODE_66_next,
		.data = (void *)&bmp_stats_send_experimental_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_67_prev,
		.to = &gn_BMP_NODE_67_next,
		.data = &ctkn_BMP_NODE[67],
	},
	{
		.from = &gn_BMP_NODE_68_prev,
		.to = &gn_BMP_NODE_68_next,
		.data = &ctkn_BMP_NODE[68],
	},
	{
		.from = &gn_BMP_NODE_69_prev,
		.to = &gn_BMP_NODE_69_next,
		.data = &ctkn_BMP_NODE[69],
	},
	{
		.from = &gn_BMP_NODE_70_prev,
		.to = &gn_BMP_NODE_70_next,
		.data = &ctkn_BMP_NODE[70],
	},
	{
		.from = &gn_BMP_NODE_71_prev,
		.to = &gn_BMP_NODE_71_next,
		.data = &ctkn_BMP_NODE[71],
	},
	{
		.from = &gn_BMP_NODE_72_prev,
		.to = &gn_BMP_NODE_72_next,
		.data = &ctkn_BMP_NODE[72],
	},
	{
		.from = &gn_BMP_NODE_73_prev,
		.to = &gn_BMP_NODE_73_next,
		.data = &ctkn_BMP_NODE[73],
	},
	{
		.from = &gn_BMP_NODE_74_prev,
		.to = &gn_BMP_NODE_74_next,
		.data = &ctkn_BMP_NODE[74],
	},
	{
		.from = &gn_BMP_NODE_75_prev,
		.to = &gn_BMP_NODE_75_next,
		.data = (void *)&bmp_listener_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_76_prev,
		.to = &gn_BMP_NODE_76_next,
		.data = &ctkn_BMP_NODE[76],
	},
	{
		.from = &gn_BMP_NODE_77_prev,
		.to = &gn_BMP_NODE_77_next,
		.data = &ctkn_BMP_NODE[77],
	},
	{
		.from = &gn_BMP_NODE_78_prev,
		.to = &gn_BMP_NODE_78_next,
		.data = &ctkn_BMP_NODE[78],
	},
	{
		.from = &gn_BMP_NODE_79_prev,
		.to = &gn_BMP_NODE_79_next,
		.data = &ctkn_BMP_NODE[79],
	},
	{
		.from = &gn_BMP_NODE_80_prev,
		.to = &gn_BMP_NODE_80_next,
		.data = &ctkn_BMP_NODE[80],
	},
	{
		.from = &gn_BMP_NODE_81_prev,
		.to = &gn_BMP_NODE_81_next,
		.data = &ctkn_BMP_NODE[81],
	},
	{
		.from = &gn_BMP_NODE_82_prev,
		.to = &gn_BMP_NODE_82_next,
		.data = &ctkn_BMP_NODE[82],
	},
	{
		.from = &gn_BMP_NODE_83_prev,
		.to = &gn_BMP_NODE_83_next,
		.data = &ctkn_BMP_NODE[83],
	},
	{
		.from = &gn_BMP_NODE_84_prev,
		.to = &gn_BMP_NODE_84_next,
		.data = &ctkn_BMP_NODE[84],
	},
	{
		.from = &gn_BMP_NODE_85_prev,
		.to = &gn_BMP_NODE_85_next,
		.data = &ctkn_BMP_NODE[85],
	},
	{
		.from = &gn_BMP_NODE_86_prev,
		.to = &gn_BMP_NODE_86_next,
		.data = (void *)&no_bmp_listener_cmd_vtysh,
	},
	{
		.from = &gn_BMP_NODE_87_prev,
		.to = &gn_BMP_NODE_87_next,
		.data = &ctkn_BMP_NODE[87],
	},
};
MAKE_VECTOR(gvec_BMP_NODE, 88, &gn_BMP_NODE[0], &gn_BMP_NODE[1], &gn_BMP_NODE[2], &gn_BMP_NODE[3], &gn_BMP_NODE[4], &gn_BMP_NODE[5], &gn_BMP_NODE[6], &gn_BMP_NODE[7], &gn_BMP_NODE[8], &gn_BMP_NODE[9], &gn_BMP_NODE[10], &gn_BMP_NODE[11], &gn_BMP_NODE[12], &gn_BMP_NODE[13], &gn_BMP_NODE[14], &gn_BMP_NODE[15], &gn_BMP_NODE[16], &gn_BMP_NODE[17], &gn_BMP_NODE[18], &gn_BMP_NODE[19], &gn_BMP_NODE[20], &gn_BMP_NODE[21], &gn_BMP_NODE[22], &gn_BMP_NODE[23], &gn_BMP_NODE[24], &gn_BMP_NODE[25], &gn_BMP_NODE[26], &gn_BMP_NODE[27], &gn_BMP_NODE[28], &gn_BMP_NODE[29], &gn_BMP_NODE[30], &gn_BMP_NODE[31], &gn_BMP_NODE[32], &gn_BMP_NODE[33], &gn_BMP_NODE[34], &gn_BMP_NODE[35], &gn_BMP_NODE[36], &gn_BMP_NODE[37], &gn_BMP_NODE[38], &gn_BMP_NODE[39], &gn_BMP_NODE[40], &gn_BMP_NODE[41], &gn_BMP_NODE[42], &gn_BMP_NODE[43], &gn_BMP_NODE[44], &gn_BMP_NODE[45], &gn_BMP_NODE[46], &gn_BMP_NODE[47], &gn_BMP_NODE[48], &gn_BMP_NODE[49], &gn_BMP_NODE[50], &gn_BMP_NODE[51], &gn_BMP_NODE[52], &gn_BMP_NODE[53], &gn_BMP_NODE[54], &gn_BMP_NODE[55], &gn_BMP_NODE[56], &gn_BMP_NODE[57], &gn_BMP_NODE[58], &gn_BMP_NODE[59], &gn_BMP_NODE[60], &gn_BMP_NODE[61], &gn_BMP_NODE[62], &gn_BMP_NODE[63], &gn_BMP_NODE[64], &gn_BMP_NODE[65], &gn_BMP_NODE[66], &gn_BMP_NODE[67], &gn_BMP_NODE[68], &gn_BMP_NODE[69], &gn_BMP_NODE[70], &gn_BMP_NODE[71], &gn_BMP_NODE[72], &gn_BMP_NODE[73], &gn_BMP_NODE[74], &gn_BMP_NODE[75], &gn_BMP_NODE[76], &gn_BMP_NODE[77], &gn_BMP_NODE[78], &gn_BMP_NODE[79], &gn_BMP_NODE[80], &gn_BMP_NODE[81], &gn_BMP_NODE[82], &gn_BMP_NODE[83], &gn_BMP_NODE[84], &gn_BMP_NODE[85], &gn_BMP_NODE[86], &gn_BMP_NODE[87]);

extern void install_BMP_NODE(void);

void install_BMP_NODE(void)

{
	unsigned node_id = BMP_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_BMP_NODE;
	vector_set(node->cmd_vector, &bmp_acl_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_connect_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_import_vrf_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_listener_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_mirror_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_monitor_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_stats_cmd_vtysh);
	vector_set(node->cmd_vector, &bmp_stats_send_experimental_cmd_vtysh);
	vector_set(node->cmd_vector, &no_bmp_listener_cmd_vtysh);
}

static struct cmd_token ctkn_PCEP_PCE_CONFIG_NODE[];
static struct graph_node gn_PCEP_PCE_CONFIG_NODE[];

static struct cmd_token ctkn_PCEP_PCE_CONFIG_NODE[] = {
	{ /* [0] */
		.type = START_TKN,
	},
	{ /* [1] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[3],
	},
	{ /* [2] */
		.type = WORD_TKN,
		.varname_src = 1,
		.text = (char *)"no",
		.desc = (char *)"Negate a command or set its defaults",
		.varname = (char *)"no",
	},
	{ /* [3] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[1],
	},
	{ /* [4] */
		.type = WORD_TKN,
		.text = (char *)"pce-initiated",
		.desc = (char *)"Configure PCC to accept PCE initiated LSPs",
	},
	{ /* [5] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [6] = pcep_cli_peer_pce_initiated_cmd */ },
	{ /* [7] */
		.type = WORD_TKN,
		.text = (char *)"source-address",
		.desc = (char *)"PCE source IP Address configuration",
	},
	{ /* [8] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[11],
	},
	{ /* [9] */
		.type = WORD_TKN,
		.text = (char *)"ip",
		.desc = (char *)"PCE source IPv4 address",
	},
	{ /* [10] */
		.type = IPV4_TKN,
		.varname_src = 3,
		.text = (char *)"A.B.C.D",
		.desc = (char *)"PCE source IPv4 address value",
		.varname = (char *)"ip",
	},
	{ /* [11] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[8],
	},
	{ /* [12] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[15],
	},
	{ /* [13] */
		.type = WORD_TKN,
		.text = (char *)"port",
		.desc = (char *)"Source PCE server port",
	},
	{ /* [14] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1024-65535)",
		.desc = (char *)"Source PCE server port value",
		.min = 1024,
		.max = 65535,
		.varname = (char *)"port",
	},
	{ /* [15] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[12],
	},
	{ /* [16] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [17] = pcep_cli_peer_source_address_cmd */ },
	{ /* [18] */
		.type = WORD_TKN,
		.text = (char *)"ipv6",
		.desc = (char *)"PCE source IPv6 address",
	},
	{ /* [19] */
		.type = IPV6_TKN,
		.varname_src = 3,
		.text = (char *)"X:X::X:X",
		.desc = (char *)"PCE source IPv6 address value",
		.varname = (char *)"ipv6",
	},
	{ /* [20] */
		.type = WORD_TKN,
		.text = (char *)"sr-draft07",
		.desc = (char *)"Configure PCC to send PCEP Open with SR draft07",
	},
	{ /* [21] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [22] = pcep_cli_peer_sr_draft07_cmd */ },
	{ /* [23] */
		.type = WORD_TKN,
		.text = (char *)"tcp-md5-auth",
		.desc = (char *)"Configure PCC TCP-MD5 RFC2385 Authentication",
	},
	{ /* [24] */
		.type = VARIABLE_TKN,
		.varname_src = 3,
		.text = (char *)"WORD",
		.desc = (char *)"TCP-MD5 Authentication string",
		.varname = (char *)"tcp_md5_auth",
	},
	{ /* [25] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [26] = pcep_cli_peer_tcp_md5_auth_cmd */ },
	{ /* [27] */
		.type = WORD_TKN,
		.text = (char *)"timer",
		.desc = (char *)"PCE PCEP Session Timers configuration",
	},
	{ /* [28] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[31],
	},
	{ /* [29] */
		.type = WORD_TKN,
		.text = (char *)"keep-alive",
		.desc = (char *)"PCC Keep Alive Timer",
	},
	{ /* [30] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-63)",
		.desc = (char *)"PCC Keep Alive Timer value in seconds",
		.min = 1,
		.max = 63,
		.varname = (char *)"keep_alive",
	},
	{ /* [31] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[28],
	},
	{ /* [32] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[35],
	},
	{ /* [33] */
		.type = WORD_TKN,
		.text = (char *)"min-peer-keep-alive",
		.desc = (char *)"Min Acceptable PCE Keep Alive Timer",
	},
	{ /* [34] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Min Acceptable PCE Keep Alive Timer value in seconds",
		.min = 1,
		.max = 255,
		.varname = (char *)"min_peer_keep_alive",
	},
	{ /* [35] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[32],
	},
	{ /* [36] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[39],
	},
	{ /* [37] */
		.type = WORD_TKN,
		.text = (char *)"max-peer-keep-alive",
		.desc = (char *)"Max Acceptable PCE Keep Alive Timer",
	},
	{ /* [38] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-255)",
		.desc = (char *)"Max Acceptable PCE Keep Alive Timer value in seconds",
		.min = 1,
		.max = 255,
		.varname = (char *)"max_peer_keep_alive",
	},
	{ /* [39] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[36],
	},
	{ /* [40] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[43],
	},
	{ /* [41] */
		.type = WORD_TKN,
		.text = (char *)"dead-timer",
		.desc = (char *)"PCC Dead Timer",
	},
	{ /* [42] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(4-255)",
		.desc = (char *)"PCC Dead Timer value in seconds",
		.min = 4,
		.max = 255,
		.varname = (char *)"dead_timer",
	},
	{ /* [43] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[40],
	},
	{ /* [44] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[47],
	},
	{ /* [45] */
		.type = WORD_TKN,
		.text = (char *)"min-peer-dead-timer",
		.desc = (char *)"Min Acceptable PCE Dead Timer",
	},
	{ /* [46] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(4-255)",
		.desc = (char *)"Min Acceptable PCE Dead Timer value in seconds",
		.min = 4,
		.max = 255,
		.varname = (char *)"min_peer_dead_timer",
	},
	{ /* [47] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[44],
	},
	{ /* [48] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[51],
	},
	{ /* [49] */
		.type = WORD_TKN,
		.text = (char *)"max-peer-dead-timer",
		.desc = (char *)"Max Acceptable PCE Dead Timer",
	},
	{ /* [50] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(4-255)",
		.desc = (char *)"Max Acceptable PCE Dead Timer value in seconds",
		.min = 4,
		.max = 255,
		.varname = (char *)"max_peer_dead_timer",
	},
	{ /* [51] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[48],
	},
	{ /* [52] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[55],
	},
	{ /* [53] */
		.type = WORD_TKN,
		.text = (char *)"pcep-request",
		.desc = (char *)"PCC PCEP Request Timer",
	},
	{ /* [54] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-120)",
		.desc = (char *)"PCC PCEP Request Timer value in seconds",
		.min = 1,
		.max = 120,
		.varname = (char *)"pcep_request",
	},
	{ /* [55] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[52],
	},
	{ /* [56] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[59],
	},
	{ /* [57] */
		.type = WORD_TKN,
		.text = (char *)"session-timeout-interval",
		.desc = (char *)"PCC Session Timeout Interval",
	},
	{ /* [58] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-120)",
		.desc = (char *)"PCC Session Timeout Interval value in seconds",
		.min = 1,
		.max = 120,
		.varname = (char *)"session_timeout_interval",
	},
	{ /* [59] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[56],
	},
	{ /* [60] */
		.type = FORK_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[63],
	},
	{ /* [61] */
		.type = WORD_TKN,
		.text = (char *)"delegation-timeout",
		.desc = (char *)"Multi-PCE delegation timeout",
	},
	{ /* [62] */
		.type = RANGE_TKN,
		.varname_src = 3,
		.text = (char *)"(1-60)",
		.desc = (char *)"Multi-PCE delegation timeout value in seconds",
		.min = 1,
		.max = 60,
		.varname = (char *)"delegation_timeout",
	},
	{ /* [63] */
		.type = JOIN_TKN,
		.forkjoin = &gn_PCEP_PCE_CONFIG_NODE[60],
	},
	{ /* [64] */
		.type = END_TKN,
		.text = (char *)"<cr>",
	},
	{ /* [65] = pcep_cli_peer_timers_cmd */ },
};

extern struct cmd_element pcep_cli_peer_pce_initiated_cmd_vtysh;
extern struct cmd_element pcep_cli_peer_source_address_cmd_vtysh;
extern struct cmd_element pcep_cli_peer_sr_draft07_cmd_vtysh;
extern struct cmd_element pcep_cli_peer_tcp_md5_auth_cmd_vtysh;
extern struct cmd_element pcep_cli_peer_timers_cmd_vtysh;

MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_0_next, 2, &gn_PCEP_PCE_CONFIG_NODE[1], &gn_PCEP_PCE_CONFIG_NODE[27]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_0_prev, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_1_next, 2, &gn_PCEP_PCE_CONFIG_NODE[2], &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_1_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[0]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_2_next, 1, &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_2_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[1]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_3_next, 4, &gn_PCEP_PCE_CONFIG_NODE[4], &gn_PCEP_PCE_CONFIG_NODE[7], &gn_PCEP_PCE_CONFIG_NODE[20], &gn_PCEP_PCE_CONFIG_NODE[23]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_3_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[2], &gn_PCEP_PCE_CONFIG_NODE[1]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_4_next, 1, &gn_PCEP_PCE_CONFIG_NODE[5]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_4_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_5_next, 1, &gn_PCEP_PCE_CONFIG_NODE[6]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_5_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[4]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_6_next, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_6_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[5]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_7_next, 1, &gn_PCEP_PCE_CONFIG_NODE[8]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_7_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_8_next, 3, &gn_PCEP_PCE_CONFIG_NODE[9], &gn_PCEP_PCE_CONFIG_NODE[18], &gn_PCEP_PCE_CONFIG_NODE[11]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_8_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[7]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_9_next, 1, &gn_PCEP_PCE_CONFIG_NODE[10]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_9_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[8]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_10_next, 1, &gn_PCEP_PCE_CONFIG_NODE[11]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_10_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[9]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_11_next, 1, &gn_PCEP_PCE_CONFIG_NODE[12]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_11_prev, 3, &gn_PCEP_PCE_CONFIG_NODE[10], &gn_PCEP_PCE_CONFIG_NODE[19], &gn_PCEP_PCE_CONFIG_NODE[8]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_12_next, 2, &gn_PCEP_PCE_CONFIG_NODE[13], &gn_PCEP_PCE_CONFIG_NODE[15]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_12_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[11]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_13_next, 1, &gn_PCEP_PCE_CONFIG_NODE[14]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_13_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[12]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_14_next, 1, &gn_PCEP_PCE_CONFIG_NODE[15]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_14_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[13]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_15_next, 1, &gn_PCEP_PCE_CONFIG_NODE[16]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_15_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[14], &gn_PCEP_PCE_CONFIG_NODE[12]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_16_next, 1, &gn_PCEP_PCE_CONFIG_NODE[17]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_16_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[15]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_17_next, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_17_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[16]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_18_next, 1, &gn_PCEP_PCE_CONFIG_NODE[19]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_18_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[8]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_19_next, 1, &gn_PCEP_PCE_CONFIG_NODE[11]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_19_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[18]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_20_next, 1, &gn_PCEP_PCE_CONFIG_NODE[21]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_20_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_21_next, 1, &gn_PCEP_PCE_CONFIG_NODE[22]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_21_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[20]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_22_next, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_22_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[21]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_23_next, 1, &gn_PCEP_PCE_CONFIG_NODE[24]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_23_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[3]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_24_next, 1, &gn_PCEP_PCE_CONFIG_NODE[25]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_24_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[23]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_25_next, 1, &gn_PCEP_PCE_CONFIG_NODE[26]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_25_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[24]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_26_next, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_26_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[25]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_27_next, 1, &gn_PCEP_PCE_CONFIG_NODE[28]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_27_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[0]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_28_next, 2, &gn_PCEP_PCE_CONFIG_NODE[29], &gn_PCEP_PCE_CONFIG_NODE[31]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_28_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[27]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_29_next, 1, &gn_PCEP_PCE_CONFIG_NODE[30]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_29_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[28]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_30_next, 1, &gn_PCEP_PCE_CONFIG_NODE[31]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_30_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[29]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_31_next, 1, &gn_PCEP_PCE_CONFIG_NODE[32]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_31_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[30], &gn_PCEP_PCE_CONFIG_NODE[28]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_32_next, 2, &gn_PCEP_PCE_CONFIG_NODE[33], &gn_PCEP_PCE_CONFIG_NODE[35]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_32_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[31]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_33_next, 1, &gn_PCEP_PCE_CONFIG_NODE[34]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_33_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[32]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_34_next, 1, &gn_PCEP_PCE_CONFIG_NODE[35]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_34_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[33]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_35_next, 1, &gn_PCEP_PCE_CONFIG_NODE[36]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_35_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[34], &gn_PCEP_PCE_CONFIG_NODE[32]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_36_next, 2, &gn_PCEP_PCE_CONFIG_NODE[37], &gn_PCEP_PCE_CONFIG_NODE[39]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_36_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[35]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_37_next, 1, &gn_PCEP_PCE_CONFIG_NODE[38]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_37_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[36]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_38_next, 1, &gn_PCEP_PCE_CONFIG_NODE[39]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_38_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[37]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_39_next, 1, &gn_PCEP_PCE_CONFIG_NODE[40]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_39_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[38], &gn_PCEP_PCE_CONFIG_NODE[36]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_40_next, 2, &gn_PCEP_PCE_CONFIG_NODE[41], &gn_PCEP_PCE_CONFIG_NODE[43]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_40_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[39]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_41_next, 1, &gn_PCEP_PCE_CONFIG_NODE[42]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_41_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[40]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_42_next, 1, &gn_PCEP_PCE_CONFIG_NODE[43]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_42_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[41]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_43_next, 1, &gn_PCEP_PCE_CONFIG_NODE[44]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_43_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[42], &gn_PCEP_PCE_CONFIG_NODE[40]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_44_next, 2, &gn_PCEP_PCE_CONFIG_NODE[45], &gn_PCEP_PCE_CONFIG_NODE[47]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_44_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[43]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_45_next, 1, &gn_PCEP_PCE_CONFIG_NODE[46]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_45_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[44]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_46_next, 1, &gn_PCEP_PCE_CONFIG_NODE[47]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_46_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[45]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_47_next, 1, &gn_PCEP_PCE_CONFIG_NODE[48]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_47_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[46], &gn_PCEP_PCE_CONFIG_NODE[44]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_48_next, 2, &gn_PCEP_PCE_CONFIG_NODE[49], &gn_PCEP_PCE_CONFIG_NODE[51]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_48_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[47]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_49_next, 1, &gn_PCEP_PCE_CONFIG_NODE[50]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_49_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[48]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_50_next, 1, &gn_PCEP_PCE_CONFIG_NODE[51]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_50_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[49]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_51_next, 1, &gn_PCEP_PCE_CONFIG_NODE[52]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_51_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[50], &gn_PCEP_PCE_CONFIG_NODE[48]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_52_next, 2, &gn_PCEP_PCE_CONFIG_NODE[53], &gn_PCEP_PCE_CONFIG_NODE[55]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_52_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[51]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_53_next, 1, &gn_PCEP_PCE_CONFIG_NODE[54]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_53_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[52]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_54_next, 1, &gn_PCEP_PCE_CONFIG_NODE[55]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_54_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[53]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_55_next, 1, &gn_PCEP_PCE_CONFIG_NODE[56]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_55_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[54], &gn_PCEP_PCE_CONFIG_NODE[52]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_56_next, 2, &gn_PCEP_PCE_CONFIG_NODE[57], &gn_PCEP_PCE_CONFIG_NODE[59]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_56_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[55]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_57_next, 1, &gn_PCEP_PCE_CONFIG_NODE[58]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_57_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[56]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_58_next, 1, &gn_PCEP_PCE_CONFIG_NODE[59]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_58_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[57]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_59_next, 1, &gn_PCEP_PCE_CONFIG_NODE[60]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_59_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[58], &gn_PCEP_PCE_CONFIG_NODE[56]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_60_next, 2, &gn_PCEP_PCE_CONFIG_NODE[61], &gn_PCEP_PCE_CONFIG_NODE[63]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_60_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[59]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_61_next, 1, &gn_PCEP_PCE_CONFIG_NODE[62]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_61_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[60]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_62_next, 1, &gn_PCEP_PCE_CONFIG_NODE[63]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_62_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[61]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_63_next, 1, &gn_PCEP_PCE_CONFIG_NODE[64]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_63_prev, 2, &gn_PCEP_PCE_CONFIG_NODE[62], &gn_PCEP_PCE_CONFIG_NODE[60]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_64_next, 1, &gn_PCEP_PCE_CONFIG_NODE[65]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_64_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[63]);
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_65_next, 0, );
MAKE_VECTOR(gn_PCEP_PCE_CONFIG_NODE_65_prev, 1, &gn_PCEP_PCE_CONFIG_NODE[64]);

static struct graph_node gn_PCEP_PCE_CONFIG_NODE[] = {
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_0_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_0_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[0],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_1_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_1_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[1],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_2_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_2_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[2],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_3_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_3_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[3],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_4_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_4_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[4],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_5_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_5_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[5],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_6_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_6_next,
		.data = (void *)&pcep_cli_peer_pce_initiated_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_7_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_7_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[7],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_8_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_8_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[8],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_9_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_9_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[9],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_10_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_10_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[10],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_11_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_11_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[11],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_12_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_12_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[12],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_13_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_13_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[13],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_14_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_14_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[14],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_15_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_15_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[15],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_16_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_16_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[16],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_17_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_17_next,
		.data = (void *)&pcep_cli_peer_source_address_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_18_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_18_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[18],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_19_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_19_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[19],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_20_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_20_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[20],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_21_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_21_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[21],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_22_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_22_next,
		.data = (void *)&pcep_cli_peer_sr_draft07_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_23_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_23_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[23],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_24_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_24_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[24],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_25_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_25_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[25],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_26_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_26_next,
		.data = (void *)&pcep_cli_peer_tcp_md5_auth_cmd_vtysh,
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_27_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_27_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[27],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_28_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_28_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[28],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_29_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_29_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[29],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_30_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_30_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[30],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_31_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_31_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[31],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_32_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_32_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[32],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_33_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_33_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[33],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_34_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_34_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[34],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_35_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_35_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[35],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_36_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_36_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[36],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_37_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_37_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[37],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_38_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_38_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[38],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_39_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_39_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[39],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_40_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_40_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[40],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_41_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_41_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[41],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_42_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_42_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[42],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_43_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_43_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[43],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_44_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_44_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[44],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_45_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_45_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[45],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_46_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_46_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[46],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_47_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_47_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[47],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_48_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_48_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[48],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_49_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_49_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[49],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_50_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_50_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[50],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_51_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_51_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[51],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_52_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_52_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[52],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_53_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_53_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[53],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_54_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_54_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[54],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_55_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_55_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[55],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_56_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_56_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[56],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_57_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_57_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[57],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_58_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_58_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[58],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_59_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_59_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[59],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_60_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_60_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[60],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_61_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_61_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[61],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_62_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_62_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[62],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_63_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_63_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[63],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_64_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_64_next,
		.data = &ctkn_PCEP_PCE_CONFIG_NODE[64],
	},
	{
		.from = &gn_PCEP_PCE_CONFIG_NODE_65_prev,
		.to = &gn_PCEP_PCE_CONFIG_NODE_65_next,
		.data = (void *)&pcep_cli_peer_timers_cmd_vtysh,
	},
};
MAKE_VECTOR(gvec_PCEP_PCE_CONFIG_NODE, 66, &gn_PCEP_PCE_CONFIG_NODE[0], &gn_PCEP_PCE_CONFIG_NODE[1], &gn_PCEP_PCE_CONFIG_NODE[2], &gn_PCEP_PCE_CONFIG_NODE[3], &gn_PCEP_PCE_CONFIG_NODE[4], &gn_PCEP_PCE_CONFIG_NODE[5], &gn_PCEP_PCE_CONFIG_NODE[6], &gn_PCEP_PCE_CONFIG_NODE[7], &gn_PCEP_PCE_CONFIG_NODE[8], &gn_PCEP_PCE_CONFIG_NODE[9], &gn_PCEP_PCE_CONFIG_NODE[10], &gn_PCEP_PCE_CONFIG_NODE[11], &gn_PCEP_PCE_CONFIG_NODE[12], &gn_PCEP_PCE_CONFIG_NODE[13], &gn_PCEP_PCE_CONFIG_NODE[14], &gn_PCEP_PCE_CONFIG_NODE[15], &gn_PCEP_PCE_CONFIG_NODE[16], &gn_PCEP_PCE_CONFIG_NODE[17], &gn_PCEP_PCE_CONFIG_NODE[18], &gn_PCEP_PCE_CONFIG_NODE[19], &gn_PCEP_PCE_CONFIG_NODE[20], &gn_PCEP_PCE_CONFIG_NODE[21], &gn_PCEP_PCE_CONFIG_NODE[22], &gn_PCEP_PCE_CONFIG_NODE[23], &gn_PCEP_PCE_CONFIG_NODE[24], &gn_PCEP_PCE_CONFIG_NODE[25], &gn_PCEP_PCE_CONFIG_NODE[26], &gn_PCEP_PCE_CONFIG_NODE[27], &gn_PCEP_PCE_CONFIG_NODE[28], &gn_PCEP_PCE_CONFIG_NODE[29], &gn_PCEP_PCE_CONFIG_NODE[30], &gn_PCEP_PCE_CONFIG_NODE[31], &gn_PCEP_PCE_CONFIG_NODE[32], &gn_PCEP_PCE_CONFIG_NODE[33], &gn_PCEP_PCE_CONFIG_NODE[34], &gn_PCEP_PCE_CONFIG_NODE[35], &gn_PCEP_PCE_CONFIG_NODE[36], &gn_PCEP_PCE_CONFIG_NODE[37], &gn_PCEP_PCE_CONFIG_NODE[38], &gn_PCEP_PCE_CONFIG_NODE[39], &gn_PCEP_PCE_CONFIG_NODE[40], &gn_PCEP_PCE_CONFIG_NODE[41], &gn_PCEP_PCE_CONFIG_NODE[42], &gn_PCEP_PCE_CONFIG_NODE[43], &gn_PCEP_PCE_CONFIG_NODE[44], &gn_PCEP_PCE_CONFIG_NODE[45], &gn_PCEP_PCE_CONFIG_NODE[46], &gn_PCEP_PCE_CONFIG_NODE[47], &gn_PCEP_PCE_CONFIG_NODE[48], &gn_PCEP_PCE_CONFIG_NODE[49], &gn_PCEP_PCE_CONFIG_NODE[50], &gn_PCEP_PCE_CONFIG_NODE[51], &gn_PCEP_PCE_CONFIG_NODE[52], &gn_PCEP_PCE_CONFIG_NODE[53], &gn_PCEP_PCE_CONFIG_NODE[54], &gn_PCEP_PCE_CONFIG_NODE[55], &gn_PCEP_PCE_CONFIG_NODE[56], &gn_PCEP_PCE_CONFIG_NODE[57], &gn_PCEP_PCE_CONFIG_NODE[58], &gn_PCEP_PCE_CONFIG_NODE[59], &gn_PCEP_PCE_CONFIG_NODE[60], &gn_PCEP_PCE_CONFIG_NODE[61], &gn_PCEP_PCE_CONFIG_NODE[62], &gn_PCEP_PCE_CONFIG_NODE[63], &gn_PCEP_PCE_CONFIG_NODE[64], &gn_PCEP_PCE_CONFIG_NODE[65]);

extern void install_PCEP_PCE_CONFIG_NODE(void);

void install_PCEP_PCE_CONFIG_NODE(void)

{
	unsigned node_id = PCEP_PCE_CONFIG_NODE;
	struct cmd_node *node;

	assert(node_id < vector_active(cmdvec));
	node = vector_slot(cmdvec, node_id);
	assert(node);
	assert(vector_active(node->cmdgraph->nodes) == 1);
	graph_delete_node(node->cmdgraph, vector_slot(node->cmdgraph->nodes, 0));
	vector_free(node->cmdgraph->nodes);
	node->cmdgraph->nodes = &gvec_PCEP_PCE_CONFIG_NODE;
	vector_set(node->cmd_vector, &pcep_cli_peer_pce_initiated_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_peer_source_address_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_peer_sr_draft07_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_peer_tcp_md5_auth_cmd_vtysh);
	vector_set(node->cmd_vector, &pcep_cli_peer_timers_cmd_vtysh);
}
