/* no_rpki => "no rpki" */
DEFUN_CMD_FUNC_DECL(no_rpki)
#define funcdecl_no_rpki static int no_rpki_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)))
funcdecl_no_rpki;
DEFUN_CMD_FUNC_TEXT(no_rpki)
{
#if 0 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return no_rpki_magic(self, vty, argc, argv);
}

/* bgp_rpki_start => "rpki start [vrf NAME$vrfname]" */
DEFUN_CMD_FUNC_DECL(bgp_rpki_start)
#define funcdecl_bgp_rpki_start static int bgp_rpki_start_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname)
funcdecl_bgp_rpki_start;
DEFUN_CMD_FUNC_TEXT(bgp_rpki_start)
{
#if 1 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return bgp_rpki_start_magic(self, vty, argc, argv, vrfname);
}

/* bgp_rpki_stop => "rpki stop [vrf NAME$vrfname]" */
DEFUN_CMD_FUNC_DECL(bgp_rpki_stop)
#define funcdecl_bgp_rpki_stop static int bgp_rpki_stop_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname)
funcdecl_bgp_rpki_stop;
DEFUN_CMD_FUNC_TEXT(bgp_rpki_stop)
{
#if 1 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return bgp_rpki_stop_magic(self, vty, argc, argv, vrfname);
}

/* rpki_polling_period => "rpki polling_period (1-86400)$pp" */
DEFUN_CMD_FUNC_DECL(rpki_polling_period)
#define funcdecl_rpki_polling_period static int rpki_polling_period_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	long pp,\
	const char * pp_str __attribute__ ((unused)))
funcdecl_rpki_polling_period;
DEFUN_CMD_FUNC_TEXT(rpki_polling_period)
{
#if 1 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	long pp = 0;
	const char *pp_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "pp")) {
			pp_str = argv[_i]->arg;
			char *_end;
			pp = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!pp_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "pp_str");
		return CMD_WARNING;
	}

	return rpki_polling_period_magic(self, vty, argc, argv, pp, pp_str);
}

/* rpki_expire_interval => "rpki expire_interval (600-172800)$tmp" */
DEFUN_CMD_FUNC_DECL(rpki_expire_interval)
#define funcdecl_rpki_expire_interval static int rpki_expire_interval_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	long tmp,\
	const char * tmp_str __attribute__ ((unused)))
funcdecl_rpki_expire_interval;
DEFUN_CMD_FUNC_TEXT(rpki_expire_interval)
{
#if 1 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	long tmp = 0;
	const char *tmp_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "tmp")) {
			tmp_str = argv[_i]->arg;
			char *_end;
			tmp = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!tmp_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "tmp_str");
		return CMD_WARNING;
	}

	return rpki_expire_interval_magic(self, vty, argc, argv, tmp, tmp_str);
}

/* rpki_retry_interval => "rpki retry_interval (1-7200)$tmp" */
DEFUN_CMD_FUNC_DECL(rpki_retry_interval)
#define funcdecl_rpki_retry_interval static int rpki_retry_interval_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	long tmp,\
	const char * tmp_str __attribute__ ((unused)))
funcdecl_rpki_retry_interval;
DEFUN_CMD_FUNC_TEXT(rpki_retry_interval)
{
#if 1 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	long tmp = 0;
	const char *tmp_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "tmp")) {
			tmp_str = argv[_i]->arg;
			char *_end;
			tmp = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!tmp_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "tmp_str");
		return CMD_WARNING;
	}

	return rpki_retry_interval_magic(self, vty, argc, argv, tmp, tmp_str);
}

/* rpki_cache_tcp => "rpki cache tcp <A.B.C.D|WORD>$cache TCPPORT [source <A.B.C.D>$bindaddr] preference (1-255)" */
DEFUN_CMD_FUNC_DECL(rpki_cache_tcp)
#define funcdecl_rpki_cache_tcp static int rpki_cache_tcp_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * cache,\
	const char * tcpport,\
	struct in_addr bindaddr,\
	const char * bindaddr_str __attribute__ ((unused)),\
	long preference,\
	const char * preference_str __attribute__ ((unused)))
funcdecl_rpki_cache_tcp;
DEFUN_CMD_FUNC_TEXT(rpki_cache_tcp)
{
#if 4 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *cache = NULL;
	const char *tcpport = NULL;
	struct in_addr bindaddr = { INADDR_ANY };
	const char *bindaddr_str = NULL;
	long preference = 0;
	const char *preference_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "cache")) {
			cache = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "tcpport")) {
			tcpport = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "bindaddr")) {
			bindaddr_str = argv[_i]->arg;
			_fail = !inet_aton(argv[_i]->arg, &bindaddr);
		}
		if (!strcmp(argv[_i]->varname, "preference")) {
			preference_str = argv[_i]->arg;
			char *_end;
			preference = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!cache) {
		vty_out(vty, "Internal CLI error [%s]\n", "cache");
		return CMD_WARNING;
	}
	if (!tcpport) {
		vty_out(vty, "Internal CLI error [%s]\n", "tcpport");
		return CMD_WARNING;
	}
	if (!preference_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "preference_str");
		return CMD_WARNING;
	}

	return rpki_cache_tcp_magic(self, vty, argc, argv, cache, tcpport, bindaddr, bindaddr_str, preference, preference_str);
}

/* rpki_cache_ssh => "rpki cache ssh <A.B.C.D|WORD>$cache (1-65535)$sshport SSH_UNAME SSH_PRIVKEY [KNOWN_HOSTS_PATH] [source <A.B.C.D>$bindaddr] preference (1-255)" */
DEFUN_CMD_FUNC_DECL(rpki_cache_ssh)
#define funcdecl_rpki_cache_ssh static int rpki_cache_ssh_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * cache,\
	long sshport,\
	const char * sshport_str __attribute__ ((unused)),\
	const char * ssh_uname,\
	const char * ssh_privkey,\
	const char * known_hosts_path,\
	struct in_addr bindaddr,\
	const char * bindaddr_str __attribute__ ((unused)),\
	long preference,\
	const char * preference_str __attribute__ ((unused)))
funcdecl_rpki_cache_ssh;
DEFUN_CMD_FUNC_TEXT(rpki_cache_ssh)
{
#if 7 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *cache = NULL;
	long sshport = 0;
	const char *sshport_str = NULL;
	const char *ssh_uname = NULL;
	const char *ssh_privkey = NULL;
	const char *known_hosts_path = NULL;
	struct in_addr bindaddr = { INADDR_ANY };
	const char *bindaddr_str = NULL;
	long preference = 0;
	const char *preference_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "cache")) {
			cache = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "sshport")) {
			sshport_str = argv[_i]->arg;
			char *_end;
			sshport = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
		if (!strcmp(argv[_i]->varname, "ssh_uname")) {
			ssh_uname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "ssh_privkey")) {
			ssh_privkey = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "known_hosts_path")) {
			known_hosts_path = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "bindaddr")) {
			bindaddr_str = argv[_i]->arg;
			_fail = !inet_aton(argv[_i]->arg, &bindaddr);
		}
		if (!strcmp(argv[_i]->varname, "preference")) {
			preference_str = argv[_i]->arg;
			char *_end;
			preference = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!cache) {
		vty_out(vty, "Internal CLI error [%s]\n", "cache");
		return CMD_WARNING;
	}
	if (!sshport_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "sshport_str");
		return CMD_WARNING;
	}
	if (!ssh_uname) {
		vty_out(vty, "Internal CLI error [%s]\n", "ssh_uname");
		return CMD_WARNING;
	}
	if (!ssh_privkey) {
		vty_out(vty, "Internal CLI error [%s]\n", "ssh_privkey");
		return CMD_WARNING;
	}
	if (!preference_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "preference_str");
		return CMD_WARNING;
	}

	return rpki_cache_ssh_magic(self, vty, argc, argv, cache, sshport, sshport_str, ssh_uname, ssh_privkey, known_hosts_path, bindaddr, bindaddr_str, preference, preference_str);
}

/* no_rpki_cache => "no rpki cache <tcp|ssh> <A.B.C.D|WORD> <TCPPORT|(1-65535)$sshport SSH_UNAME SSH_PRIVKEY [KNOWN_HOSTS_PATH]> [source <A.B.C.D>$bindaddr] preference (1-255)" */
DEFUN_CMD_FUNC_DECL(no_rpki_cache)
#define funcdecl_no_rpki_cache static int no_rpki_cache_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * tcpport,\
	long sshport,\
	const char * sshport_str __attribute__ ((unused)),\
	const char * ssh_uname,\
	const char * ssh_privkey,\
	const char * known_hosts_path,\
	struct in_addr bindaddr,\
	const char * bindaddr_str __attribute__ ((unused)),\
	long preference,\
	const char * preference_str __attribute__ ((unused)))
funcdecl_no_rpki_cache;
DEFUN_CMD_FUNC_TEXT(no_rpki_cache)
{
#if 7 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *tcpport = NULL;
	long sshport = 0;
	const char *sshport_str = NULL;
	const char *ssh_uname = NULL;
	const char *ssh_privkey = NULL;
	const char *known_hosts_path = NULL;
	struct in_addr bindaddr = { INADDR_ANY };
	const char *bindaddr_str = NULL;
	long preference = 0;
	const char *preference_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "tcpport")) {
			tcpport = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "sshport")) {
			sshport_str = argv[_i]->arg;
			char *_end;
			sshport = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
		if (!strcmp(argv[_i]->varname, "ssh_uname")) {
			ssh_uname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "ssh_privkey")) {
			ssh_privkey = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "known_hosts_path")) {
			known_hosts_path = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "bindaddr")) {
			bindaddr_str = argv[_i]->arg;
			_fail = !inet_aton(argv[_i]->arg, &bindaddr);
		}
		if (!strcmp(argv[_i]->varname, "preference")) {
			preference_str = argv[_i]->arg;
			char *_end;
			preference = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!preference_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "preference_str");
		return CMD_WARNING;
	}

	return no_rpki_cache_magic(self, vty, argc, argv, tcpport, sshport, sshport_str, ssh_uname, ssh_privkey, known_hosts_path, bindaddr, bindaddr_str, preference, preference_str);
}

/* show_rpki_prefix_table => "show rpki <prefix-table|prefix-count>$prefixkind [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_prefix_table)
#define funcdecl_show_rpki_prefix_table static int show_rpki_prefix_table_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * prefixkind,\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_prefix_table;
DEFUN_CMD_FUNC_TEXT(show_rpki_prefix_table)
{
#if 3 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *prefixkind = NULL;
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "prefixkind")) {
			prefixkind = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!prefixkind) {
		vty_out(vty, "Internal CLI error [%s]\n", "prefixkind");
		return CMD_WARNING;
	}

	return show_rpki_prefix_table_magic(self, vty, argc, argv, prefixkind, vrfname, uj);
}

/* show_rpki_as_number => "show rpki as-number <0$zero|ASNUM$by_asn> [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_as_number)
#define funcdecl_show_rpki_as_number static int show_rpki_as_number_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * zero,\
	as_t by_asn,\
	const char * by_asn_str __attribute__ ((unused)),\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_as_number;
DEFUN_CMD_FUNC_TEXT(show_rpki_as_number)
{
#if 4 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *zero = NULL;
	as_t by_asn = 0;
	const char *by_asn_str = NULL;
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "zero")) {
			zero = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "by_asn")) {
			by_asn_str = argv[_i]->arg;
			_fail = !asn_str2asn(argv[_i]->arg, &by_asn);
		}
		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return show_rpki_as_number_magic(self, vty, argc, argv, zero, by_asn, by_asn_str, vrfname, uj);
}

/* show_rpki_prefix => "show rpki prefix <A.B.C.D/M|X:X::X:X/M> [0$zero|ASNUM$asn] [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_prefix)
#define funcdecl_show_rpki_prefix static int show_rpki_prefix_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const struct prefix * prefix,\
	const char * prefix_str __attribute__ ((unused)),\
	const char * zero,\
	as_t asn,\
	const char * asn_str __attribute__ ((unused)),\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_prefix;
DEFUN_CMD_FUNC_TEXT(show_rpki_prefix)
{
#if 5 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	struct prefix prefix = { };
	const char *prefix_str = NULL;
	const char *zero = NULL;
	as_t asn = 0;
	const char *asn_str = NULL;
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "prefix")) {
			prefix_str = argv[_i]->arg;
			_fail = !str2prefix(argv[_i]->arg, &prefix);
		}
		if (!strcmp(argv[_i]->varname, "zero")) {
			zero = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "asn")) {
			asn_str = argv[_i]->arg;
			_fail = !asn_str2asn(argv[_i]->arg, &asn);
		}
		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!prefix_str) {
		vty_out(vty, "Internal CLI error [%s]\n", "prefix_str");
		return CMD_WARNING;
	}

	return show_rpki_prefix_magic(self, vty, argc, argv, &prefix, prefix_str, zero, asn, asn_str, vrfname, uj);
}

/* show_rpki_cache_server => "show rpki cache-server [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_cache_server)
#define funcdecl_show_rpki_cache_server static int show_rpki_cache_server_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_cache_server;
DEFUN_CMD_FUNC_TEXT(show_rpki_cache_server)
{
#if 2 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return show_rpki_cache_server_magic(self, vty, argc, argv, vrfname, uj);
}

/* show_rpki_cache_connection => "show rpki cache-connection [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_cache_connection)
#define funcdecl_show_rpki_cache_connection static int show_rpki_cache_connection_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_cache_connection;
DEFUN_CMD_FUNC_TEXT(show_rpki_cache_connection)
{
#if 2 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return show_rpki_cache_connection_magic(self, vty, argc, argv, vrfname, uj);
}

/* show_rpki_configuration => "show rpki configuration [vrf NAME$vrfname] [json$uj]" */
DEFUN_CMD_FUNC_DECL(show_rpki_configuration)
#define funcdecl_show_rpki_configuration static int show_rpki_configuration_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname,\
	const char * uj)
funcdecl_show_rpki_configuration;
DEFUN_CMD_FUNC_TEXT(show_rpki_configuration)
{
#if 2 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;
	const char *uj = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "uj")) {
			uj = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return show_rpki_configuration_magic(self, vty, argc, argv, vrfname, uj);
}

/* rpki_reset => "rpki reset [vrf NAME$vrfname]" */
DEFUN_CMD_FUNC_DECL(rpki_reset)
#define funcdecl_rpki_reset static int rpki_reset_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * vrfname)
funcdecl_rpki_reset;
DEFUN_CMD_FUNC_TEXT(rpki_reset)
{
#if 1 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *vrfname = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "vrfname")) {
			vrfname = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return rpki_reset_magic(self, vty, argc, argv, vrfname);
}

/* rpki_reset_config_mode => "rpki reset" */
DEFUN_CMD_FUNC_DECL(rpki_reset_config_mode)
#define funcdecl_rpki_reset_config_mode static int rpki_reset_config_mode_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)))
funcdecl_rpki_reset_config_mode;
DEFUN_CMD_FUNC_TEXT(rpki_reset_config_mode)
{
#if 0 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif

	return rpki_reset_config_mode_magic(self, vty, argc, argv);
}

