/* neighbor_bfd_strict => "[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor bfd strict" */
DEFUN_CMD_FUNC_DECL(neighbor_bfd_strict)
#define funcdecl_neighbor_bfd_strict static int neighbor_bfd_strict_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * no,\
	const char * neighbor)
funcdecl_neighbor_bfd_strict;
DEFUN_CMD_FUNC_TEXT(neighbor_bfd_strict)
{
#if 2 /* anything to parse? */
	int _i;
#if 0 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *no = NULL;
	const char *neighbor = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 0 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "no")) {
			no = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "neighbor")) {
			neighbor = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
#if 0 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 0 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!neighbor) {
		vty_out(vty, "Internal CLI error [%s]\n", "neighbor");
		return CMD_WARNING;
	}

	return neighbor_bfd_strict_magic(self, vty, argc, argv, no, neighbor);
}

/* neighbor_bfd_strict_hold_time => "[no$no] neighbor <A.B.C.D|X:X::X:X|WORD>$neighbor bfd strict hold-time ![(1-4294967295)$hold_time]" */
DEFUN_CMD_FUNC_DECL(neighbor_bfd_strict_hold_time)
#define funcdecl_neighbor_bfd_strict_hold_time static int neighbor_bfd_strict_hold_time_magic(\
	const struct cmd_element *self __attribute__ ((unused)),\
	struct vty *vty __attribute__ ((unused)),\
	int argc __attribute__ ((unused)),\
	struct cmd_token *argv[] __attribute__ ((unused)),\
	const char * no,\
	const char * neighbor,\
	long hold_time,\
	const char * hold_time_str __attribute__ ((unused)))
funcdecl_neighbor_bfd_strict_hold_time;
DEFUN_CMD_FUNC_TEXT(neighbor_bfd_strict_hold_time)
{
#if 3 /* anything to parse? */
	int _i;
#if 1 /* anything that can fail? */
	unsigned _fail = 0, _failcnt = 0;
#endif
	const char *no = NULL;
	const char *neighbor = NULL;
	long hold_time = 0;
	const char *hold_time_str = NULL;

	for (_i = 0; _i < argc; _i++) {
		if (!argv[_i]->varname)
			continue;
#if 1 /* anything that can fail? */
		_fail = 0;
#endif

		if (!strcmp(argv[_i]->varname, "no")) {
			no = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "neighbor")) {
			neighbor = (argv[_i]->type == WORD_TKN) ? argv[_i]->text : argv[_i]->arg;
		}
		if (!strcmp(argv[_i]->varname, "hold_time")) {
			hold_time_str = argv[_i]->arg;
			char *_end;
			hold_time = strtol(argv[_i]->arg, &_end, 10);
			_fail = (_end == argv[_i]->arg) || (*_end != '\0');
		}
#if 1 /* anything that can fail? */
		if (_fail)
			vty_out (vty, "%% invalid input for %s: %s\n",
				   argv[_i]->varname, argv[_i]->arg);
		_failcnt += _fail;
#endif
	}
#if 1 /* anything that can fail? */
	if (_failcnt)
		return CMD_WARNING;
#endif
#endif
	if (!neighbor) {
		vty_out(vty, "Internal CLI error [%s]\n", "neighbor");
		return CMD_WARNING;
	}

	return neighbor_bfd_strict_hold_time_magic(self, vty, argc, argv, no, neighbor, hold_time, hold_time_str);
}

